
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `egroupware231260113`
--

-- --------------------------------------------------------

--
-- Table structure for table `egw_access_log`
--

CREATE TABLE `egw_access_log` (
  `sessionid` int(11) NOT NULL AUTO_INCREMENT,
  `loginid` varchar(64) NOT NULL,
  `ip` varchar(48) CHARACTER SET ascii NOT NULL,
  `li` bigint(20) NOT NULL,
  `lo` bigint(20) DEFAULT NULL,
  `account_id` int(11) NOT NULL DEFAULT '0',
  `session_dla` bigint(20) DEFAULT NULL,
  `session_action` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `session_php` varchar(64) CHARACTER SET ascii NOT NULL,
  `notification_heartbeat` bigint(20) DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`sessionid`),
  KEY `egw_access_log_li` (`li`),
  KEY `egw_access_log_lo` (`lo`),
  KEY `egw_access_log_session_dla` (`session_dla`),
  KEY `egw_access_log_session_php` (`session_php`),
  KEY `egw_access_log_notification_heartbeat` (`notification_heartbeat`),
  KEY `egw_access_log_account_id_ip_li` (`account_id`,`ip`,`li`),
  KEY `egw_access_log_account_id_loginid_li` (`account_id`,`loginid`,`li`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_accounts`
--

CREATE TABLE `egw_accounts` (
  `account_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_lid` varchar(64) NOT NULL,
  `account_pwd` varchar(128) NOT NULL,
  `account_lastlogin` int(11) DEFAULT NULL,
  `account_lastloginfrom` varchar(48) CHARACTER SET ascii DEFAULT NULL,
  `account_lastpwd_change` int(11) DEFAULT NULL,
  `account_status` varchar(1) NOT NULL DEFAULT 'A',
  `account_expires` int(11) DEFAULT NULL,
  `account_type` varchar(1) DEFAULT NULL,
  `account_primary_group` int(11) NOT NULL DEFAULT '0',
  `account_description` varchar(255) DEFAULT NULL,
  `account_uuid` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `account_dn` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`account_id`),
  UNIQUE KEY `egw_accounts_account_lid` (`account_lid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `egw_accounts`
--

INSERT INTO `egw_accounts` VALUES
(1, 'Default', '', NULL, NULL, NULL, 'A', -1, 'g', 0, 'EGroupware all users group, do NOT delete', NULL, NULL),
(2, 'Admins', '', NULL, NULL, NULL, 'A', -1, 'g', 0, 'EGroupware administrators group, do NOT delete', NULL, NULL),
(3, 'NoGroup', '', NULL, NULL, NULL, 'A', -1, 'g', 0, 'EGroupware anonymous users group, do NOT delete', NULL, NULL),
(4, 'anonymous', '{crypt}$2a$12$1KUPn9uPRfJUQ13csZ9iBeWFEJOxAxLPOv5VWMGE2pqilAux9lWGu', NULL, NULL, [[timestamp]], 'A', -1, 'u', -3, NULL, NULL, NULL),
(5, 'Teachers', '', NULL, NULL, NULL, 'A', -1, 'g', 0, NULL, NULL, NULL),
(6, '[[admin_username]]', '[[admin_pass]]', NULL, NULL, [[timestamp]], 'A', -1, 'u', -2, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_acl`
--

CREATE TABLE `egw_acl` (
  `acl_appname` varchar(16) CHARACTER SET ascii NOT NULL,
  `acl_location` varchar(16) CHARACTER SET ascii NOT NULL,
  `acl_account` int(11) NOT NULL,
  `acl_rights` int(11) DEFAULT NULL,
  `acl_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`acl_id`),
  UNIQUE KEY `egw_acl_appname_location_account` (`acl_appname`,`acl_location`,`acl_account`),
  KEY `egw_acl_account` (`acl_account`),
  KEY `egw_acl_location_account` (`acl_location`,`acl_account`),
  KEY `egw_acl_appname_account` (`acl_appname`,`acl_account`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=70 ;

--
-- Dumping data for table `egw_acl`
--

INSERT INTO `egw_acl` VALUES
('addressbook', '-1', -1, 15, 1),
('phpgw_group', '-3', 4, 1, 2),
('news_admin', 'run', -1, 1, 11),
('news_admin', 'run', 4, 1, 13),
('news_admin', 'L3', -2, 3, 15),
('news_admin', 'L3', -1, 1, 16),
('news_admin', 'L4', -2, 1, 17),
('news_admin', 'L4', -1, 1, 18),
('news_admin', 'L4', 4, 1, 19),
('openid', 'run', -1, 1, 20),
('resources', 'run', -1, 1, 22),
('resources', 'L5', -1, 399, 23),
('resources', 'L6', -1, 399, 24),
('rocketchat', 'run', -1, 1, 25),
('rocketchat', 'run', -2, 1, 26),
('smallpart', 'run', -1, 1, 27),
('smallpart', 'run', -2, 1, 28),
('smallpart', 'run', -5, 1, 29),
('smallpart', 'admin', -5, 1, 30),
('status', 'run', -1, 1, 31),
('status', 'run', -2, 1, 32),
('tracker', 'run', -1, 1, 34),
('preferences', 'nopasswordchange', 4, 1, 35),
('phpgwapi', 'anonymous', 4, 1, 36),
('collabora', 'run', -1, 1, 37),
('addressbook', 'run', -1, 1, 38),
('calendar', 'run', -1, 1, 39),
('infolog', 'run', -1, 1, 40),
('mail', 'run', -1, 1, 41),
('filemanager', 'run', -1, 1, 42),
('preferences', 'run', -1, 1, 43),
('manual', 'run', -1, 1, 44),
('groupdav', 'run', -1, 1, 45),
('notifications', 'run', -1, 1, 46),
('timesheet', 'run', -1, 1, 47),
('importexport', 'run', -1, 1, 48),
('activesync', 'run', -1, 1, 49),
('addressbook', 'run', -2, 1, 50),
('calendar', 'run', -2, 1, 51),
('infolog', 'run', -2, 1, 52),
('mail', 'run', -2, 1, 53),
('filemanager', 'run', -2, 1, 54),
('preferences', 'run', -2, 1, 55),
('groupdav', 'run', -2, 1, 56),
('notifications', 'run', -2, 1, 57),
('timesheet', 'run', -2, 1, 58),
('importexport', 'run', -2, 1, 59),
('activesync', 'run', -2, 1, 60),
('admin', 'run', -2, 1, 61),
('bookmarks', 'run', -2, 1, 62),
('news_admin', 'run', -2, 1, 63),
('projectmanager', 'run', -2, 1, 64),
('resources', 'run', -2, 1, 65),
('tracker', 'run', -2, 1, 66),
('phpgw_group', '-2', 6, 1, 68),
('phpgw_group', '-1', 6, 1, 69);

-- --------------------------------------------------------

--
-- Table structure for table `egw_addressbook`
--

CREATE TABLE `egw_addressbook` (
  `contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_tid` varchar(1) DEFAULT 'n',
  `contact_owner` bigint(20) NOT NULL,
  `contact_private` tinyint(4) DEFAULT '0',
  `cat_id` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `n_family` varchar(64) DEFAULT NULL,
  `n_given` varchar(64) DEFAULT NULL,
  `n_middle` varchar(64) DEFAULT NULL,
  `n_prefix` varchar(64) DEFAULT NULL,
  `n_suffix` varchar(64) DEFAULT NULL,
  `n_fn` varchar(128) DEFAULT NULL,
  `n_fileas` varchar(255) DEFAULT NULL,
  `contact_bday` varchar(12) DEFAULT NULL,
  `org_name` varchar(128) DEFAULT NULL,
  `org_unit` varchar(128) DEFAULT NULL,
  `contact_title` varchar(128) DEFAULT NULL,
  `contact_role` varchar(128) DEFAULT NULL,
  `contact_assistent` varchar(64) DEFAULT NULL,
  `contact_room` varchar(64) DEFAULT NULL,
  `adr_one_street` varchar(64) DEFAULT NULL,
  `adr_one_street2` varchar(64) DEFAULT NULL,
  `adr_one_locality` varchar(64) DEFAULT NULL,
  `adr_one_region` varchar(64) DEFAULT NULL,
  `adr_one_postalcode` varchar(64) DEFAULT NULL,
  `adr_one_countryname` varchar(64) DEFAULT NULL,
  `contact_label` text,
  `adr_two_street` varchar(64) DEFAULT NULL,
  `adr_two_street2` varchar(64) DEFAULT NULL,
  `adr_two_locality` varchar(64) DEFAULT NULL,
  `adr_two_region` varchar(64) DEFAULT NULL,
  `adr_two_postalcode` varchar(64) DEFAULT NULL,
  `adr_two_countryname` varchar(64) DEFAULT NULL,
  `tel_work` varchar(40) DEFAULT NULL,
  `tel_cell` varchar(40) DEFAULT NULL,
  `tel_fax` varchar(40) DEFAULT NULL,
  `tel_assistent` varchar(40) DEFAULT NULL,
  `tel_car` varchar(40) DEFAULT NULL,
  `tel_pager` varchar(40) DEFAULT NULL,
  `tel_home` varchar(40) DEFAULT NULL,
  `tel_fax_home` varchar(40) DEFAULT NULL,
  `tel_cell_private` varchar(40) DEFAULT NULL,
  `tel_other` varchar(40) DEFAULT NULL,
  `tel_prefer` varchar(32) DEFAULT NULL,
  `contact_email` varchar(128) DEFAULT NULL,
  `contact_email_home` varchar(128) DEFAULT NULL,
  `contact_url` varchar(128) DEFAULT NULL,
  `contact_url_home` varchar(128) DEFAULT NULL,
  `contact_freebusy_uri` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `contact_calendar_uri` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `contact_note` varchar(8192) DEFAULT NULL,
  `contact_tz` varchar(8) DEFAULT NULL,
  `contact_geo` varchar(32) CHARACTER SET ascii DEFAULT NULL,
  `contact_pubkey` varchar(16384) CHARACTER SET ascii DEFAULT NULL,
  `contact_created` bigint(20) DEFAULT NULL,
  `contact_creator` int(11) NOT NULL,
  `contact_modified` bigint(20) NOT NULL,
  `contact_modifier` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `contact_etag` int(11) DEFAULT '0',
  `contact_uid` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `adr_one_countrycode` varchar(2) CHARACTER SET ascii DEFAULT NULL,
  `adr_two_countrycode` varchar(2) CHARACTER SET ascii DEFAULT NULL,
  `carddav_name` varchar(260) CHARACTER SET ascii DEFAULT NULL,
  `contact_files` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`contact_id`),
  UNIQUE KEY `egw_addressbook_account_id` (`account_id`),
  KEY `egw_addressbook_contact_owner` (`contact_owner`),
  KEY `egw_addressbook_cat_id` (`cat_id`),
  KEY `egw_addressbook_n_fileas` (`n_fileas`),
  KEY `egw_addressbook_contact_modified` (`contact_modified`),
  KEY `egw_addressbook_contact_uid` (`contact_uid`),
  KEY `egw_addressbook_carddav_name` (`carddav_name`),
  KEY `egw_addressbook_n_family_n_given` (`n_family`,`n_given`),
  KEY `egw_addressbook_n_given_n_family` (`n_given`,`n_family`),
  KEY `egw_addressbook_org_name_n_family_n_given` (`org_name`,`n_family`,`n_given`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `egw_addressbook`
--

INSERT INTO `egw_addressbook` VALUES
(1, 'n', 0, 0, NULL, 'User', 'SiteMgr', NULL, NULL, NULL, 'SiteMgr User', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, [[timestamp]], 0, [[timestamp]], NULL, 4, 0, 'addressbook-1-[[install_id]]', NULL, NULL, '1.vcf', 0),
(2, 'n', 0, 0, NULL, '[[admin_lname]]', '[[admin_fname]]', NULL, NULL, NULL, '[[admin_fname]] [[admin_lname]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[admin_email]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, [[timestamp]], 0, [[timestamp]], NULL, 6, 0, 'addressbook-2-[[install_id]]', NULL, NULL, '2.vcf', 0);

-- --------------------------------------------------------

--
-- Table structure for table `egw_addressbook2list`
--

CREATE TABLE `egw_addressbook2list` (
  `contact_id` int(11) NOT NULL,
  `list_id` int(11) NOT NULL,
  `list_added` bigint(20) DEFAULT NULL,
  `list_added_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`contact_id`,`list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_addressbook_extra`
--

CREATE TABLE `egw_addressbook_extra` (
  `contact_id` int(11) NOT NULL,
  `contact_owner` bigint(20) DEFAULT NULL,
  `contact_name` varchar(64) NOT NULL,
  `contact_value` varchar(16384) DEFAULT NULL,
  `contact_extra_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`contact_extra_id`),
  KEY `egw_addressbook_extra_contact_name` (`contact_name`),
  KEY `egw_addressbook_extra_contact_id_contact_name` (`contact_id`,`contact_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_addressbook_lists`
--

CREATE TABLE `egw_addressbook_lists` (
  `list_id` int(11) NOT NULL AUTO_INCREMENT,
  `list_name` varchar(80) NOT NULL,
  `list_owner` int(11) NOT NULL,
  `list_created` bigint(20) DEFAULT NULL,
  `list_creator` int(11) DEFAULT NULL,
  `list_uid` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `list_carddav_name` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `list_etag` int(11) NOT NULL DEFAULT '0',
  `list_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `list_modifier` int(11) DEFAULT NULL,
  PRIMARY KEY (`list_id`),
  UNIQUE KEY `egw_addressbook_lists_list_owner_list_name` (`list_owner`,`list_name`),
  UNIQUE KEY `egw_addressbook_lists_list_uid` (`list_uid`),
  UNIQUE KEY `egw_addressbook_lists_list_carddav_name` (`list_carddav_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_addressbook_shared`
--

CREATE TABLE `egw_addressbook_shared` (
  `shared_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `shared_with` int(11) NOT NULL,
  `shared_by` int(11) NOT NULL,
  `shared_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `shared_writable` tinyint(4) NOT NULL DEFAULT '0',
  `shared_deleted` datetime DEFAULT NULL,
  PRIMARY KEY (`shared_id`),
  UNIQUE KEY `egw_addressbook_shared_by_with_contact_id` (`shared_by`,`shared_with`,`contact_id`),
  KEY `egw_addressbook_shared_contact_id` (`contact_id`),
  KEY `egw_addressbook_shared_with` (`shared_with`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_admin_queue`
--

CREATE TABLE `egw_admin_queue` (
  `cmd_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmd_uid` varchar(64) CHARACTER SET ascii NOT NULL,
  `cmd_creator` int(11) NOT NULL,
  `cmd_creator_email` varchar(128) NOT NULL,
  `cmd_created` bigint(20) NOT NULL,
  `cmd_type` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT 'admin_cmd',
  `cmd_status` tinyint(4) DEFAULT NULL,
  `cmd_scheduled` bigint(20) DEFAULT NULL,
  `cmd_modified` bigint(20) DEFAULT NULL,
  `cmd_modifier` int(11) DEFAULT NULL,
  `cmd_modifier_email` varchar(128) DEFAULT NULL,
  `cmd_error` varchar(255) DEFAULT NULL,
  `cmd_errno` int(11) DEFAULT NULL,
  `cmd_requested` int(11) DEFAULT NULL,
  `cmd_requested_email` varchar(128) DEFAULT NULL,
  `cmd_comment` varchar(255) DEFAULT NULL,
  `cmd_data` varchar(16384) CHARACTER SET ascii DEFAULT NULL,
  `remote_id` int(11) DEFAULT NULL,
  `cmd_app` varchar(16) CHARACTER SET ascii DEFAULT NULL,
  `cmd_account` int(11) DEFAULT NULL,
  `cmd_rrule` varchar(128) DEFAULT NULL,
  `cmd_parent` int(11) DEFAULT NULL,
  `cmd_run` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`cmd_id`),
  UNIQUE KEY `egw_admin_queue_cmd_uid` (`cmd_uid`),
  KEY `egw_admin_queue_cmd_status` (`cmd_status`),
  KEY `egw_admin_queue_cmd_scheduled` (`cmd_scheduled`),
  KEY `egw_admin_queue_cmd_app` (`cmd_app`),
  KEY `egw_admin_queue_cmd_account` (`cmd_account`),
  KEY `egw_admin_queue_cmd_parent` (`cmd_parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_admin_remote`
--

CREATE TABLE `egw_admin_remote` (
  `remote_id` int(11) NOT NULL AUTO_INCREMENT,
  `remote_name` varchar(64) NOT NULL,
  `remote_hash` varchar(32) CHARACTER SET ascii NOT NULL,
  `remote_url` varchar(128) CHARACTER SET ascii NOT NULL,
  `remote_domain` varchar(64) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`remote_id`),
  UNIQUE KEY `egw_admin_remote_name` (`remote_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_applications`
--

CREATE TABLE `egw_applications` (
  `app_id` int(11) NOT NULL AUTO_INCREMENT,
  `app_name` varchar(16) CHARACTER SET ascii NOT NULL,
  `app_enabled` int(11) NOT NULL,
  `app_order` int(11) NOT NULL,
  `app_tables` varchar(8192) CHARACTER SET ascii NOT NULL,
  `app_version` varchar(20) CHARACTER SET ascii NOT NULL DEFAULT '0.0',
  `app_icon` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `app_icon_app` varchar(16) CHARACTER SET ascii DEFAULT NULL,
  `app_index` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `egw_applications_name` (`app_name`),
  KEY `egw_applications_enabled_order` (`app_enabled`,`app_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `egw_applications`
--

INSERT INTO `egw_applications` VALUES
(1, 'api', 3, 1, 'egw_config,egw_applications,egw_acl,egw_accounts,egw_preferences,egw_access_log,egw_languages,egw_lang,egw_categories,egw_history_log,egw_async,egw_links,egw_addressbook,egw_addressbook_extra,egw_addressbook_lists,egw_addressbook2list,egw_sqlfs,egw_locks,egw_sqlfs_props,egw_customfields,egw_sharing,egw_mailaccounts,egw_ea_accounts,egw_ea_credentials,egw_ea_identities,egw_ea_valid,egw_ea_notifications,egw_addressbook_shared,egw_tokens', '23.1.011', NULL, NULL, NULL),
(2, 'admin', 1, 1, 'egw_admin_queue,egw_admin_remote', '23.1', NULL, NULL, 'admin.admin_ui.index&ajax=true'),
(3, 'preferences', 2, 1, '', '23.1', NULL, NULL, 'preferences.preferences_settings.index&ajax=true'),
(4, 'groupdav', 2, 1, '', '23.1', 'groupdav', 'api', NULL),
(5, 'activesync', 2, 99, 'egw_zpush_states,egw_zpush_users,egw_zpush_settings', '23.1', NULL, NULL, NULL),
(6, 'addressbook', 1, 4, '', '23.1', NULL, NULL, 'addressbook.addressbook_ui.index&ajax=true'),
(7, 'bookmarks', 1, 12, 'egw_bookmarks,egw_bookmarks_extra', '23.1', NULL, NULL, 'bookmarks.bookmarks_ui.init&ajax=true'),
(8, 'calendar', 1, 3, 'egw_cal,egw_cal_repeats,egw_cal_user,egw_cal_extra,egw_cal_dates,egw_cal_timezones', '23.1.001', NULL, NULL, 'calendar.calendar_uiviews.index&ajax=true'),
(9, 'filemanager', 1, 6, '', '23.1', NULL, NULL, 'filemanager.filemanager_ui.index&ajax=true'),
(10, 'home', 1, 1, '', '23.1', NULL, NULL, 'home.home_ui.index&ajax=true'),
(11, 'importexport', 2, 2, 'egw_importexport_definitions', '23.1', NULL, NULL, NULL),
(12, 'infolog', 1, 5, 'egw_infolog,egw_infolog_extra,egw_infolog_users', '23.1', NULL, NULL, 'infolog.infolog_ui.index&ajax=true'),
(13, 'mail', 1, 2, '', '23.1', NULL, NULL, 'mail.mail_ui.index&ajax=true'),
(14, 'news_admin', 1, 16, 'egw_news,egw_news_export', '23.1', NULL, NULL, 'news_admin.news_admin_gui.index&ajax=true'),
(15, 'notifications', 2, 1, 'egw_notificationpopup', '23.1.002', NULL, NULL, NULL),
(16, 'openid', 2, 1, 'egw_openid_scopes,egw_openid_clients,egw_openid_client_scopes,egw_openid_client_grants,egw_openid_user_grants,egw_openid_user_scopes,egw_openid_user_clients,egw_openid_access_tokens,egw_openid_access_token_scopes,egw_openid_refresh_tokens,egw_openid_auth_codes,egw_openid_auth_code_scopes', '23.1.001', NULL, NULL, NULL),
(17, 'projectmanager', 1, 5, 'egw_pm_projects,egw_pm_extra,egw_pm_elements,egw_pm_constraints,egw_pm_milestones,egw_pm_roles,egw_pm_members,egw_pm_pricelist,egw_pm_prices,egw_pm_eroles', '23.1.001', NULL, NULL, 'projectmanager.projectmanager_ui.index&ajax=true'),
(18, 'registration', 2, 40, 'egw_registration', '23.1', NULL, NULL, NULL),
(19, 'resources', 1, 5, 'egw_resources,egw_resources_extra', '23.1.001', NULL, NULL, 'resources.resources_ui.index&ajax=true'),
(20, 'rocketchat', 1, 7, '', '23.1', NULL, NULL, 'rocketchat.EGroupware\\Rocketchat\\Ui.index&ajax=true'),
(21, 'smallpart', 1, 5, 'egw_smallpart_courses,egw_smallpart_participants,egw_smallpart_videos,egw_smallpart_lastvideo,egw_smallpart_comments,egw_smallpart_watched,egw_smallpart_overlay,egw_smallpart_answers,egw_smallpart_clmeasurements,egw_smallpart_clmeasurements_config,egw_smallpart_livefeedback,egw_smallpart_categories,egw_smallpart_extra', '23.1.016', NULL, NULL, 'smallpart.EGroupware\\SmallParT\\Student\\Ui.index&ajax=true'),
(22, 'status', 5, 0, '', '23.1', NULL, NULL, 'status.EGroupware\\Status\\Ui.index&ajax=true'),
(23, 'swoolepush', 2, 7, '', '23.1', NULL, NULL, NULL),
(24, 'timesheet', 1, 5, 'egw_timesheet,egw_timesheet_extra,egw_timesheet_events', '23.1.002', NULL, NULL, 'timesheet.timesheet_ui.index&ajax=true'),
(25, 'tracker', 1, 5, 'egw_tracker,egw_tracker_replies,egw_tracker_votes,egw_tracker_bounties,egw_tracker_assignee,egw_tracker_escalations,egw_tracker_escalated,egw_tracker_extra', '23.1.003', NULL, NULL, 'tracker.tracker_ui.index&ajax=true'),
(26, 'collabora', 2, 1, '', '23.1', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_async`
--

CREATE TABLE `egw_async` (
  `async_id` varchar(64) CHARACTER SET ascii NOT NULL,
  `async_next` int(11) NOT NULL,
  `async_times` varchar(255) CHARACTER SET ascii NOT NULL,
  `async_method` varchar(80) CHARACTER SET ascii NOT NULL,
  `async_data` varchar(8192) NOT NULL,
  `async_account_id` int(11) NOT NULL DEFAULT '0',
  `async_auto_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`async_auto_id`),
  UNIQUE KEY `egw_async_id` (`async_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `egw_async`
--

INSERT INTO `egw_async` VALUES
('news_admin-import', [[timestamp]], '{"hour":"*","min":27}', 'news_admin.news_admin_import.async_import', '', 0, 1),
('registration-purge', [[timestamp]], '{"hour":"*"}', 'registration.registration_bo.purge_expired', '', 4, 2);

-- --------------------------------------------------------

--
-- Table structure for table `egw_bookmarks`
--

CREATE TABLE `egw_bookmarks` (
  `bm_id` int(11) NOT NULL AUTO_INCREMENT,
  `bm_owner` int(11) DEFAULT NULL,
  `bm_access` varchar(255) DEFAULT NULL,
  `bm_url` varchar(255) DEFAULT NULL,
  `bm_name` varchar(255) DEFAULT NULL,
  `bm_desc` text,
  `bm_keywords` varchar(255) DEFAULT NULL,
  `bm_category` int(11) DEFAULT NULL,
  `bm_rating` int(11) DEFAULT NULL,
  `bm_info` varchar(255) DEFAULT NULL,
  `bm_visits` int(11) DEFAULT NULL,
  `bm_favicon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_bookmarks_extra`
--

CREATE TABLE `egw_bookmarks_extra` (
  `bm_id` int(11) NOT NULL,
  `bm_name` varchar(64) NOT NULL,
  `bm_value` text,
  PRIMARY KEY (`bm_id`,`bm_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal`
--

CREATE TABLE `egw_cal` (
  `cal_id` int(11) NOT NULL AUTO_INCREMENT,
  `cal_uid` varchar(255) CHARACTER SET ascii NOT NULL,
  `cal_owner` int(11) NOT NULL,
  `cal_category` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `cal_modified` bigint(20) DEFAULT NULL,
  `cal_priority` smallint(6) NOT NULL DEFAULT '2',
  `cal_public` smallint(6) NOT NULL DEFAULT '1',
  `cal_title` varchar(255) NOT NULL,
  `cal_description` varchar(16384) DEFAULT NULL,
  `cal_location` varchar(255) DEFAULT NULL,
  `cal_reference` int(11) NOT NULL DEFAULT '0',
  `cal_modifier` int(11) DEFAULT NULL,
  `cal_non_blocking` smallint(6) DEFAULT '0',
  `cal_special` smallint(6) DEFAULT '0',
  `cal_etag` int(11) DEFAULT '0',
  `cal_creator` int(11) NOT NULL,
  `cal_created` bigint(20) NOT NULL,
  `cal_recurrence` bigint(20) NOT NULL DEFAULT '0',
  `tz_id` int(11) DEFAULT NULL,
  `cal_deleted` bigint(20) DEFAULT NULL,
  `caldav_name` varchar(260) CHARACTER SET ascii DEFAULT NULL,
  `range_start` bigint(20) NOT NULL,
  `range_end` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`cal_id`),
  KEY `egw_cal_uid` (`cal_uid`),
  KEY `egw_cal_owner` (`cal_owner`),
  KEY `egw_cal_modified` (`cal_modified`),
  KEY `egw_cal_reference` (`cal_reference`),
  KEY `egw_cal_deleted` (`cal_deleted`),
  KEY `egw_cal_caldav_name` (`caldav_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal_dates`
--

CREATE TABLE `egw_cal_dates` (
  `cal_id` int(11) NOT NULL,
  `cal_start` bigint(20) NOT NULL,
  `cal_end` bigint(20) NOT NULL,
  `recur_exception` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cal_id`,`cal_start`),
  KEY `egw_cal_dates_recur_exception_id` (`recur_exception`,`cal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal_extra`
--

CREATE TABLE `egw_cal_extra` (
  `cal_id` int(11) NOT NULL,
  `cal_extra_name` varchar(64) NOT NULL,
  `cal_extra_value` varchar(16384) NOT NULL DEFAULT '',
  PRIMARY KEY (`cal_id`,`cal_extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal_repeats`
--

CREATE TABLE `egw_cal_repeats` (
  `cal_id` int(11) NOT NULL,
  `recur_type` smallint(6) NOT NULL,
  `recur_interval` smallint(6) DEFAULT '1',
  `recur_data` smallint(6) DEFAULT '1',
  PRIMARY KEY (`cal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal_timezones`
--

CREATE TABLE `egw_cal_timezones` (
  `tz_id` int(11) NOT NULL AUTO_INCREMENT,
  `tz_tzid` varchar(128) CHARACTER SET ascii NOT NULL,
  `tz_alias` int(11) DEFAULT NULL,
  `tz_latitude` int(11) DEFAULT NULL,
  `tz_longitude` int(11) DEFAULT NULL,
  `tz_component` varchar(8192) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`tz_id`),
  UNIQUE KEY `egw_cal_timezones_tz_tzid` (`tz_tzid`),
  KEY `egw_cal_timezones_tz_alias` (`tz_alias`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=657 ;

--
-- Dumping data for table `egw_cal_timezones`
--

INSERT INTO `egw_cal_timezones` VALUES
(1, 'Africa/Abidjan', NULL, 51900, -40200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(2, 'Africa/Accra', NULL, 53300, 1300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(3, 'Africa/Addis_Ababa', NULL, 90200, 384200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(4, 'Africa/Algiers', NULL, 364700, 30300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(5, 'Africa/Asmara', NULL, 152000, 385300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(6, 'Africa/Bamako', NULL, 123900, -80000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(7, 'Africa/Bangui', NULL, 42200, 183500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(8, 'Africa/Banjul', NULL, 132800, -163900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(9, 'Africa/Bissau', NULL, 115100, -153500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(10, 'Africa/Blantyre', NULL, -154700, 350000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(11, 'Africa/Brazzaville', NULL, -41600, 151700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(12, 'Africa/Bujumbura', NULL, -32300, 292200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(13, 'Africa/Cairo', NULL, 300300, 311500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(14, 'Africa/Casablanca', NULL, 333900, -73500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20180325T020000\r\nRDATE:20180325T020000\r\nRDATE:20180617T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180513T030000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20190609T020000\r\nRDATE:20190609T020000\r\nRDATE:20200531T020000\r\nRDATE:20210516T020000\r\nRDATE:20220508T020000\r\nRDATE:20230430T020000\r\nRDATE:20240414T020000\r\nRDATE:20250406T020000\r\nRDATE:20260322T020000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20181028T030000\r\nRDATE:20181028T030000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:20190505T030000\r\nRDATE:20190505T030000\r\nRDATE:20200419T030000\r\nRDATE:20210411T030000\r\nRDATE:20220327T030000\r\nRDATE:20230319T030000\r\nRDATE:20240310T030000\r\nRDATE:20250223T030000\r\nRDATE:20260215T030000\r\nEND:DAYLIGHT'),
(15, 'Africa/Ceuta', NULL, 355300, -51900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(16, 'Africa/Conakry', NULL, 93100, -134300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(17, 'Africa/Dakar', NULL, 144000, -172600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(18, 'Africa/Dar_es_Salaam', NULL, -64800, 391700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(19, 'Africa/Djibouti', NULL, 113600, 430900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(20, 'Africa/Douala', NULL, 40300, 94200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(21, 'Africa/El_Aaiun', NULL, 270900, -131200, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20180325T020000\r\nRDATE:20180325T020000\r\nRDATE:20180617T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180513T030000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20181028T030000\r\nRDATE:20181028T030000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:20190505T030000\r\nRDATE:20190505T030000\r\nRDATE:20200419T030000\r\nRDATE:20210411T030000\r\nRDATE:20220327T030000\r\nRDATE:20230319T030000\r\nRDATE:20240310T030000\r\nRDATE:20250223T030000\r\nRDATE:20260215T030000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:+01\r\nDTSTART:20190609T020000\r\nRDATE:20190609T020000\r\nRDATE:20200531T020000\r\nRDATE:20210516T020000\r\nRDATE:20220508T020000\r\nRDATE:20230430T020000\r\nRDATE:20240414T020000\r\nRDATE:20250406T020000\r\nRDATE:20260322T020000\r\nEND:STANDARD'),
(22, 'Africa/Freetown', NULL, 83000, -131500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(23, 'Africa/Gaborone', NULL, -243900, 255500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(24, 'Africa/Harare', NULL, -175000, 310300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(25, 'Africa/Johannesburg', NULL, -261500, 280000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:SAST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(26, 'Africa/Juba', NULL, 45100, 313700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:20210201T000000\r\nRDATE:20210201T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(27, 'Africa/Kampala', NULL, 1900, 322500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(28, 'Africa/Khartoum', NULL, 153600, 323200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(29, 'Africa/Kigali', NULL, -15700, 300400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(30, 'Africa/Kinshasa', NULL, -41800, 151800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(31, 'Africa/Lagos', NULL, 62700, 32400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(32, 'Africa/Libreville', NULL, 2300, 92700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(33, 'Africa/Lome', NULL, 60800, 11300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(34, 'Africa/Luanda', NULL, -84800, 131400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(35, 'Africa/Lubumbashi', NULL, -114000, 272800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(36, 'Africa/Lusaka', NULL, -152500, 281700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(37, 'Africa/Malabo', NULL, 34500, 84700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(38, 'Africa/Maputo', NULL, -255800, 323500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(39, 'Africa/Maseru', NULL, -292800, 273000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:SAST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(40, 'Africa/Mbabane', NULL, -261800, 310600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:SAST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(41, 'Africa/Mogadishu', NULL, 20400, 452200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(42, 'Africa/Monrovia', NULL, 61800, -104700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(43, 'Africa/Nairobi', NULL, -11700, 364900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(44, 'Africa/Ndjamena', NULL, 120700, 150300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(45, 'Africa/Niamey', NULL, 133100, 20700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(46, 'Africa/Nouakchott', NULL, 180600, -155700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(47, 'Africa/Ouagadougou', NULL, 122200, -13100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(48, 'Africa/Porto-Novo', NULL, 62900, 23700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(49, 'Africa/Sao_Tome', NULL, 2000, 64400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WAT\r\nDTSTART:20180101T010000\r\nRDATE:20180101T010000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:20190101T020000\r\nRDATE:20190101T020000\r\nEND:STANDARD'),
(50, 'Africa/Tripoli', NULL, 325400, 131100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(51, 'Africa/Tunis', NULL, 364800, 101100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(52, 'Africa/Windhoek', NULL, -223400, 170600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:CAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(53, 'America/Adak', NULL, 515248, -1763929, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-0900\r\nTZNAME:HDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-1000\r\nTZNAME:HST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(54, 'America/Anchorage', NULL, 611305, -1495401, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(55, 'America/Anguilla', NULL, 181200, -630400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(56, 'America/Antigua', NULL, 170300, -614800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(57, 'America/Araguaina', NULL, -71200, -481200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(58, 'America/Argentina/Buenos_Aires', NULL, -343600, -582700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(59, 'America/Argentina/Catamarca', NULL, -282800, -654700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(60, 'America/Argentina/Cordoba', NULL, -312400, -641100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(61, 'America/Argentina/Jujuy', NULL, -241100, -651800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(62, 'America/Argentina/La_Rioja', NULL, -292600, -665100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(63, 'America/Argentina/Mendoza', NULL, -325300, -684900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(64, 'America/Argentina/Rio_Gallegos', NULL, -513800, -691300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(65, 'America/Argentina/Salta', NULL, -244700, -652500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(66, 'America/Argentina/San_Juan', NULL, -313200, -683100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(67, 'America/Argentina/San_Luis', NULL, -331900, -662100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(68, 'America/Argentina/Tucuman', NULL, -264900, -651300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(69, 'America/Argentina/Ushuaia', NULL, -544800, -681800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(70, 'America/Aruba', NULL, 123000, -695800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(71, 'America/Asuncion', NULL, -251600, -574000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19701004T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700322T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=4SU\r\nEND:STANDARD'),
(72, 'America/Atikokan', NULL, 484531, -913718, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(73, 'America/Bahia', NULL, -125900, -383100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(74, 'America/Bahia_Banderas', NULL, 204800, -1051500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT'),
(75, 'America/Barbados', NULL, 130600, -593700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(76, 'America/Belem', NULL, -12700, -482900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(77, 'America/Belize', NULL, 173000, -881200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(78, 'America/Blanc-Sablon', NULL, 512500, -570700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(79, 'America/Boa_Vista', NULL, 24900, -604000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(80, 'America/Bogota', NULL, 43600, -740500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(81, 'America/Boise', NULL, 433649, -1161209, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(82, 'America/Cambridge_Bay', NULL, 690650, -1050310, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(83, 'America/Campo_Grande', NULL, -202700, -543700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:20180218T000000\r\nRDATE:20180218T000000\r\nRDATE:20190217T000000\r\nEND:STANDARD'),
(84, 'America/Cancun', NULL, 210500, -864600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(85, 'America/Caracas', NULL, 103000, -665600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(86, 'America/Cayenne', NULL, 45600, -522000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(87, 'America/Cayman', NULL, 191800, -812300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(88, 'America/Chicago', NULL, 415100, -873900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(89, 'America/Chihuahua', NULL, 283800, -1060500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(90, 'America/Costa_Rica', NULL, 95600, -840500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(91, 'America/Creston', 96, 490600, -1163100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(92, 'America/Cuiaba', NULL, -153500, -560500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:20180218T000000\r\nRDATE:20180218T000000\r\nRDATE:20190217T000000\r\nEND:STANDARD'),
(93, 'America/Curacao', NULL, 121100, -690000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(94, 'America/Danmarkshavn', NULL, 764600, -184000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(95, 'America/Dawson', NULL, 640400, -1392500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:PDT\r\nDTSTART:20180311T020000\r\nRDATE:20180311T020000\r\nRDATE:20190310T020000\r\nRDATE:20200308T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T020000\r\nRDATE:20191103T020000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:20201101T000000\r\nRDATE:20201101T000000\r\nEND:STANDARD'),
(96, 'America/Dawson_Creek', NULL, 554600, -1201400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(97, 'America/Denver', NULL, 394421, -1045903, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(98, 'America/Detroit', NULL, 421953, -830245, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(99, 'America/Dominica', NULL, 151800, -612400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(100, 'America/Edmonton', NULL, 533300, -1132800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(101, 'America/Eirunepe', NULL, -64000, -695200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(102, 'America/El_Salvador', NULL, 134200, -891200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(103, 'America/Fort_Nelson', NULL, 584800, -1224200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(104, 'America/Fortaleza', NULL, -34300, -383000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(105, 'America/Glace_Bay', NULL, 461200, -595700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(106, 'America/Goose_Bay', NULL, 532000, -602500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT'),
(107, 'America/Grand_Turk', NULL, 212800, -710800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:20181104T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:20190310T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:20180311T020000\r\nRDATE:20180311T020000\r\nEND:DAYLIGHT'),
(108, 'America/Grenada', NULL, 120300, -614500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(109, 'America/Guadeloupe', NULL, 161400, -613200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(110, 'America/Guatemala', NULL, 143800, -903100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(111, 'America/Guayaquil', NULL, -21000, -795000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(112, 'America/Guyana', NULL, 64800, -581000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(113, 'America/Halifax', NULL, 443900, -633600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(114, 'America/Havana', NULL, 230800, -822200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:CST\r\nDTSTART:19701101T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:CDT\r\nDTSTART:19700308T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT'),
(115, 'America/Hermosillo', NULL, 290400, -1105800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(116, 'America/Indiana/Indianapolis', NULL, 394606, -860929, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(117, 'America/Indiana/Knox', NULL, 411745, -863730, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(118, 'America/Indiana/Marengo', NULL, 382232, -862041, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(119, 'America/Indiana/Petersburg', NULL, 382931, -871643, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(120, 'America/Indiana/Tell_City', NULL, 375711, -864541, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(121, 'America/Indiana/Vevay', NULL, 384452, -850402, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(122, 'America/Indiana/Vincennes', NULL, 384038, -873143, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(123, 'America/Indiana/Winamac', NULL, 410305, -863611, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT'),
(124, 'America/Inuvik', NULL, 682059, -1334300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(125, 'America/Iqaluit', NULL, 634400, -682800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(126, 'America/Jamaica', NULL, 175805, -764736, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(127, 'America/Juneau', NULL, 581807, -1342511, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(128, 'America/Kentucky/Louisville', NULL, 381515, -854534, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(129, 'America/Kentucky/Monticello', NULL, 364947, -845057, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(130, 'America/Kralendijk', NULL, 120903, -681636, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(131, 'America/La_Paz', NULL, -163000, -680900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(132, 'America/Lima', NULL, -120300, -770300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(133, 'America/Los_Angeles', NULL, 340308, -1181434, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:PDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(134, 'America/Lower_Princes', NULL, 180305, -630250, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(135, 'America/Maceio', NULL, -94000, -354300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(136, 'America/Managua', NULL, 120900, -861700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(137, 'America/Manaus', NULL, -30800, -600100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(138, 'America/Marigot', NULL, 180400, -630500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(139, 'America/Martinique', NULL, 143600, -610500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(140, 'America/Matamoros', NULL, 255000, -973000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(141, 'America/Mazatlan', NULL, 231300, -1062500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(142, 'America/Menominee', NULL, 450628, -873651, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(143, 'America/Merida', NULL, 205800, -893700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(144, 'America/Metlakatla', NULL, 550737, -1313435, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:20191103T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:20181104T020000\r\nRDATE:20181104T020000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:20190120T020000\r\nRDATE:20190120T020000\r\nEND:STANDARD'),
(145, 'America/Mexico_City', NULL, 192400, -990900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(146, 'America/Miquelon', NULL, 470300, -562000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:-02\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(147, 'America/Moncton', NULL, 460600, -644700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(148, 'America/Monterrey', NULL, 254000, -1001900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(149, 'America/Montevideo', NULL, -345433, -561245, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(150, 'America/Montserrat', NULL, 164300, -621300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(151, 'America/Nassau', NULL, 250500, -772100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(152, 'America/New_York', NULL, 404251, -740023, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(153, 'America/Nipigon', NULL, 490100, -881600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(154, 'America/Nome', NULL, 643004, -1652423, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(155, 'America/Noronha', NULL, -35100, -322500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0200\r\nTZNAME:-02\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(156, 'America/North_Dakota/Beulah', NULL, 471551, -1014640, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(157, 'America/North_Dakota/Center', NULL, 470659, -1011757, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(158, 'America/North_Dakota/New_Salem', NULL, 465042, -1012439, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(159, 'America/Nuuk', NULL, 641100, -514400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:-02\r\nDTSTART:19700328T220000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19701024T230000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:STANDARD'),
(160, 'America/Ojinaga', NULL, 293400, -1042500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(161, 'America/Panama', NULL, 85800, -793200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(162, 'America/Pangnirtung', NULL, 660800, -654400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(163, 'America/Paramaribo', NULL, 55000, -551000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(164, 'America/Phoenix', NULL, 332654, -1120424, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(165, 'America/Port-au-Prince', NULL, 183200, -722000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(166, 'America/Port_of_Spain', NULL, 103900, -613100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(167, 'America/Porto_Velho', NULL, -84600, -635400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(168, 'America/Puerto_Rico', NULL, 182806, -660622, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(169, 'America/Punta_Arenas', NULL, -530900, -705500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(170, 'America/Rainy_River', NULL, 484300, -943400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(171, 'America/Rankin_Inlet', NULL, 624900, -920459, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(172, 'America/Recife', NULL, -80300, -345400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(173, 'America/Regina', NULL, 502400, -1043900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(174, 'America/Resolute', NULL, 744144, -944945, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT'),
(175, 'America/Rio_Branco', NULL, -95800, -674800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(176, 'America/Santarem', NULL, -22600, -545200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(177, 'America/Santiago', NULL, -332700, -704000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:20190407T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYMONTHDAY=2,3,4,5,6,7,8;BYDAY=SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:20230903T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=9;BYMONTHDAY=2,3,4,5,6,7,8;BYDAY=SU\r\nEND:DAYLIGHT\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180812T000000\r\nRDATE:20190908T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:-04\r\nDTSTART:20180513T000000\r\nRDATE:20180513T000000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:20200906T010000\r\nRDATE:20200906T010000\r\nRDATE:20210905T010000\r\nRDATE:20220911T010000\r\nEND:DAYLIGHT'),
(178, 'America/Santo_Domingo', NULL, 182800, -695400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(179, 'America/Sao_Paulo', NULL, -233200, -463700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0200\r\nTZNAME:-02\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:20180218T000000\r\nRDATE:20180218T000000\r\nRDATE:20190217T000000\r\nEND:STANDARD'),
(180, 'America/Scoresbysund', NULL, 702900, -215800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:19700329T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:-0100\r\nTZNAME:-01\r\nDTSTART:19701025T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(181, 'America/Sitka', NULL, 571035, -1351807, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(182, 'America/St_Barthelemy', NULL, 175300, -625100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(183, 'America/St_Johns', NULL, 473400, -524300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0230\r\nTZOFFSETTO:-0330\r\nTZNAME:NST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0330\r\nTZOFFSETTO:-0230\r\nTZNAME:NDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT'),
(184, 'America/St_Kitts', NULL, 171800, -624300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(185, 'America/St_Lucia', NULL, 140100, -610000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(186, 'America/St_Thomas', NULL, 182100, -645600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(187, 'America/St_Vincent', NULL, 130900, -611400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(188, 'America/Swift_Current', NULL, 501700, -1075000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(189, 'America/Tegucigalpa', NULL, 140600, -871300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(190, 'America/Thule', NULL, 763400, -684700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(191, 'America/Thunder_Bay', NULL, 482300, -891500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(192, 'America/Tijuana', NULL, 323200, -1170100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:PDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(193, 'America/Toronto', NULL, 433900, -792300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nTZNAME:EDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nTZNAME:EST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(194, 'America/Tortola', NULL, 182700, -643700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(195, 'America/Vancouver', NULL, 491600, -1230700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:PDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD');
INSERT INTO `egw_cal_timezones` VALUES
(196, 'America/Whitehorse', NULL, 604300, -1350300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0700\r\nTZNAME:PDT\r\nDTSTART:20180311T020000\r\nRDATE:20180311T020000\r\nRDATE:20190310T020000\r\nRDATE:20200308T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0800\r\nTZNAME:PST\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T020000\r\nRDATE:20191103T020000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:20201101T000000\r\nRDATE:20201101T000000\r\nEND:STANDARD'),
(197, 'America/Winnipeg', NULL, 495300, -970900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:CDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:CST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(198, 'America/Yakutat', NULL, 593249, -1394338, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0800\r\nTZNAME:AKDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0900\r\nTZNAME:AKST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(199, 'America/Yellowknife', NULL, 622700, -1142100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0700\r\nTZOFFSETTO:-0600\r\nTZNAME:MDT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0700\r\nTZNAME:MST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(200, 'Antarctica/Casey', NULL, -661700, 1103100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181007T040000\r\nRDATE:20191004T030000\r\nRDATE:20201004T000100\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:20180311T040000\r\nRDATE:20180311T040000\r\nRDATE:20190317T030000\r\nRDATE:20200308T030000\r\nEND:STANDARD'),
(201, 'Antarctica/Davis', NULL, -683500, 775800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(202, 'Antarctica/DumontDUrville', NULL, -664000, 1400100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:+10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(203, 'Antarctica/Macquarie', NULL, -543000, 1585700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:AEDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(204, 'Antarctica/Mawson', NULL, -673600, 625300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(205, 'Antarctica/McMurdo', NULL, -775000, 1663600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:NZDT\r\nDTSTART:19700927T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:NZST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD'),
(206, 'Antarctica/Palmer', NULL, -644800, -640600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(207, 'Antarctica/Rothera', NULL, -673400, -680800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(208, 'Antarctica/Syowa', NULL, -690022, 393524, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(209, 'Antarctica/Troll', NULL, -720041, 23206, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0200\r\nTZNAME:+02\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(210, 'Antarctica/Vostok', NULL, -782400, 1065400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(211, 'Arctic/Longyearbyen', NULL, 780000, 160000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(212, 'Asia/Aden', NULL, 124500, 451200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(213, 'Asia/Almaty', NULL, 431500, 765700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(214, 'Asia/Amman', NULL, 315700, 355600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20180329T235959\r\nRDATE:20180329T235959\r\nRDATE:20190328T235959\r\nRDATE:20200326T235959\r\nRDATE:20210325T235959\r\nRDATE:20220224T235959\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181026T010000\r\nRDATE:20191025T010000\r\nRDATE:20201030T010000\r\nRDATE:20211029T010000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:20221028T010000\r\nRDATE:20221028T010000\r\nEND:STANDARD'),
(215, 'Asia/Anadyr', NULL, 644500, 1772900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(216, 'Asia/Aqtau', NULL, 443100, 501600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(217, 'Asia/Aqtobe', NULL, 501700, 571000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(218, 'Asia/Ashgabat', NULL, 375700, 582300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(219, 'Asia/Atyrau', NULL, 470700, 515600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(220, 'Asia/Baghdad', NULL, 332100, 442500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(221, 'Asia/Bahrain', NULL, 262300, 503500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(222, 'Asia/Baku', NULL, 402300, 495100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(223, 'Asia/Bangkok', NULL, 134500, 1003100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(224, 'Asia/Barnaul', NULL, 532200, 834500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(225, 'Asia/Beirut', NULL, 335300, 353000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(226, 'Asia/Bishkek', NULL, 425400, 743600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(227, 'Asia/Brunei', NULL, 45600, 1145500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(228, 'Asia/Chita', NULL, 520300, 1132800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:+09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(229, 'Asia/Choibalsan', NULL, 480400, 1143000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(230, 'Asia/Colombo', NULL, 65600, 795100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0530\r\nTZOFFSETTO:+0530\r\nTZNAME:+0530\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(231, 'Asia/Damascus', NULL, 333000, 361800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20180330T000000\r\nRDATE:20180330T000000\r\nRDATE:20190329T000000\r\nRDATE:20200327T000000\r\nRDATE:20210326T000000\r\nRDATE:20220325T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181026T000000\r\nRDATE:20191025T000000\r\nRDATE:20201030T000000\r\nRDATE:20211029T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:20221028T000000\r\nRDATE:20221028T000000\r\nEND:STANDARD'),
(232, 'Asia/Dhaka', NULL, 234300, 902500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(233, 'Asia/Dili', NULL, -83300, 1253500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:+09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(234, 'Asia/Dubai', NULL, 251800, 551800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(235, 'Asia/Dushanbe', NULL, 383500, 684800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(236, 'Asia/Famagusta', NULL, 350700, 335700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20180325T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(237, 'Asia/Gaza', NULL, 313000, 342800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:20221029T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20230325T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:DAYLIGHT\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20180324T010000\r\nRDATE:20180324T010000\r\nRDATE:20190329T000000\r\nRDATE:20200328T000000\r\nRDATE:20210327T000000\r\nRDATE:20220327T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181027T010000\r\nRDATE:20191026T000000\r\nRDATE:20201024T010000\r\nRDATE:20211029T010000\r\nEND:STANDARD'),
(238, 'Asia/Hebron', NULL, 313200, 350542, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:20221029T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20230325T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYMONTHDAY=24,25,26,27,28,29,30;BYDAY=SA\r\nEND:DAYLIGHT\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:20180324T010000\r\nRDATE:20180324T010000\r\nRDATE:20190329T000000\r\nRDATE:20200328T000000\r\nRDATE:20210327T000000\r\nRDATE:20220327T000000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181027T010000\r\nRDATE:20191026T000000\r\nRDATE:20201024T010000\r\nRDATE:20211029T010000\r\nEND:STANDARD'),
(239, 'Asia/Ho_Chi_Minh', NULL, 104500, 1064000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(240, 'Asia/Hong_Kong', NULL, 221700, 1140900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:HKT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(241, 'Asia/Hovd', NULL, 480100, 913900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(242, 'Asia/Irkutsk', NULL, 521600, 1042000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(243, 'Asia/Istanbul', NULL, 410100, 285800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(244, 'Asia/Jakarta', NULL, -61000, 1064800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:WIB\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(245, 'Asia/Jayapura', NULL, -23200, 1404200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:WIT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(246, 'Asia/Jerusalem', NULL, 314650, 351326, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:IDT\r\nDTSTART:19700327T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYMONTHDAY=23,24,25,26,27,28,29;BYDAY=FR\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:IST\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(247, 'Asia/Kabul', NULL, 343100, 691200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0430\r\nTZNAME:+0430\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(248, 'Asia/Kamchatka', NULL, 530100, 1583900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(249, 'Asia/Karachi', NULL, 245200, 670300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:PKT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(250, 'Asia/Kathmandu', NULL, 274300, 851900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0545\r\nTZOFFSETTO:+0545\r\nTZNAME:+0545\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(251, 'Asia/Khandyga', NULL, 623923, 1353314, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:+09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(252, 'Asia/Kolkata', NULL, 223200, 882200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0530\r\nTZOFFSETTO:+0530\r\nTZNAME:IST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(253, 'Asia/Krasnoyarsk', NULL, 560100, 925000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(254, 'Asia/Kuala_Lumpur', NULL, 31000, 1014200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(255, 'Asia/Kuching', NULL, 13300, 1102000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(256, 'Asia/Kuwait', NULL, 292000, 475900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(257, 'Asia/Macau', NULL, 221150, 1133230, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(258, 'Asia/Magadan', NULL, 593400, 1504800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(259, 'Asia/Makassar', NULL, -50700, 1192400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:WITA\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(260, 'Asia/Manila', NULL, 143500, 1210000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:PST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(261, 'Asia/Muscat', NULL, 233600, 583500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(262, 'Asia/Nicosia', NULL, 351000, 332200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(263, 'Asia/Novokuznetsk', NULL, 534500, 870700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(264, 'Asia/Novosibirsk', NULL, 550200, 825500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(265, 'Asia/Omsk', NULL, 550000, 732400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(266, 'Asia/Oral', NULL, 511300, 512100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(267, 'Asia/Phnom_Penh', NULL, 113300, 1045500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(268, 'Asia/Pontianak', NULL, 200, 1092000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:WIB\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(269, 'Asia/Pyongyang', NULL, 390100, 1254500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0830\r\nTZNAME:KST\r\nDTSTART:19700101T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0830\r\nTZOFFSETTO:+0900\r\nTZNAME:KST\r\nDTSTART:20180504T233000\r\nRDATE:20180504T233000\r\nEND:STANDARD'),
(270, 'Asia/Qatar', NULL, 251700, 513200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(271, 'Asia/Qostanay', NULL, 531200, 633700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(272, 'Asia/Qyzylorda', NULL, 444800, 652800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:20181221T000000\r\nRDATE:20181221T000000\r\nEND:STANDARD'),
(273, 'Asia/Riyadh', NULL, 243800, 464300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(274, 'Asia/Sakhalin', NULL, 465800, 1424200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(275, 'Asia/Samarkand', NULL, 394000, 664800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(276, 'Asia/Seoul', NULL, 373300, 1265800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:KST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(277, 'Asia/Shanghai', NULL, 311400, 1212800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(278, 'Asia/Singapore', NULL, 11700, 1035100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(279, 'Asia/Srednekolymsk', NULL, 672800, 1534300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(280, 'Asia/Taipei', NULL, 250300, 1213000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:CST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(281, 'Asia/Tashkent', NULL, 412000, 691800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(282, 'Asia/Tbilisi', NULL, 414300, 444900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(283, 'Asia/Tehran', NULL, 354000, 512600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0330\r\nTZOFFSETTO:+0430\r\nTZNAME:+0430\r\nDTSTART:20180321T235959\r\nRDATE:20180321T235959\r\nRDATE:20190321T235959\r\nRDATE:20200320T235959\r\nRDATE:20210321T235959\r\nRDATE:20220321T235959\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0430\r\nTZOFFSETTO:+0330\r\nTZNAME:+0330\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180921T235959\r\nRDATE:20190921T235959\r\nRDATE:20200920T235959\r\nRDATE:20210921T235959\r\nRDATE:20220921T235959\r\nEND:STANDARD'),
(284, 'Asia/Thimphu', NULL, 272800, 893900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(285, 'Asia/Tokyo', NULL, 353916, 1394441, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:JST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(286, 'Asia/Tomsk', NULL, 563000, 845800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(287, 'Asia/Ulaanbaatar', NULL, 475500, 1065300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:+08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(288, 'Asia/Urumqi', NULL, 434800, 873500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(289, 'Asia/Ust-Nera', NULL, 643337, 1431336, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:+10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(290, 'Asia/Vientiane', NULL, 175800, 1023600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(291, 'Asia/Vladivostok', NULL, 431000, 1315600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:+10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(292, 'Asia/Yakutsk', NULL, 620000, 1294000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:+09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(293, 'Asia/Yangon', NULL, 164700, 961000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0630\r\nTZOFFSETTO:+0630\r\nTZNAME:+0630\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(294, 'Asia/Yekaterinburg', NULL, 565100, 603600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(295, 'Asia/Yerevan', NULL, 401100, 443000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(296, 'Atlantic/Azores', NULL, 374400, -254000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:+0000\r\nTZNAME:+00\r\nDTSTART:19700329T000000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:-0100\r\nTZNAME:-01\r\nDTSTART:19701025T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(297, 'Atlantic/Bermuda', NULL, 321700, -644600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0300\r\nTZNAME:ADT\r\nDTSTART:19700308T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0400\r\nTZNAME:AST\r\nDTSTART:19701101T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\r\nEND:STANDARD'),
(298, 'Atlantic/Canary', NULL, 280600, -152400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WEST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(299, 'Atlantic/Cape_Verde', NULL, 145500, -233100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0100\r\nTZOFFSETTO:-0100\r\nTZNAME:-01\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(300, 'Atlantic/Faroe', NULL, 620100, -64600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WEST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(301, 'Atlantic/Madeira', NULL, 323800, -165400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WEST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(302, 'Atlantic/Reykjavik', NULL, 640900, -215100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(303, 'Atlantic/South_Georgia', NULL, -541600, -363200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0200\r\nTZOFFSETTO:-0200\r\nTZNAME:-02\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(304, 'Atlantic/St_Helena', NULL, -155500, -54200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(305, 'Atlantic/Stanley', NULL, -514200, -575100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0300\r\nTZOFFSETTO:-0300\r\nTZNAME:-03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(306, 'Australia/Adelaide', NULL, -345500, 1383500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1030\r\nTZOFFSETTO:+0930\r\nTZNAME:ACST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+1030\r\nTZNAME:ACDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(307, 'Australia/Brisbane', NULL, -272800, 1530200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(308, 'Australia/Broken_Hill', NULL, -315700, 1412700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1030\r\nTZOFFSETTO:+0930\r\nTZNAME:ACST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+1030\r\nTZNAME:ACDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(309, 'Australia/Darwin', NULL, -122800, 1305000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0930\r\nTZOFFSETTO:+0930\r\nTZNAME:ACST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(310, 'Australia/Eucla', NULL, -314300, 1285200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0845\r\nTZOFFSETTO:+0845\r\nTZNAME:+0845\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(311, 'Australia/Hobart', NULL, -425300, 1471900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:AEDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD'),
(312, 'Australia/Lindeman', NULL, -201600, 1490000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(313, 'Australia/Lord_Howe', NULL, -313300, 1590500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1030\r\nTZNAME:+1030\r\nDTSTART:19700405T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1030\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(314, 'Australia/Melbourne', NULL, -374900, 1445800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:AEDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(315, 'Australia/Perth', NULL, -315700, 1155100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0800\r\nTZOFFSETTO:+0800\r\nTZNAME:AWST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(316, 'Australia/Sydney', NULL, -335200, 1511300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1000\r\nTZNAME:AEST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1100\r\nTZNAME:AEDT\r\nDTSTART:19701004T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT'),
(317, 'Europe/Amsterdam', NULL, 522200, 45400, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(318, 'Europe/Andorra', NULL, 423000, 13100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(319, 'Europe/Astrakhan', NULL, 462100, 480300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(320, 'Europe/Athens', NULL, 375800, 234300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(321, 'Europe/Belgrade', NULL, 445000, 203000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(322, 'Europe/Berlin', NULL, 523000, 132200, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(323, 'Europe/Bratislava', NULL, 480900, 170700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(324, 'Europe/Brussels', NULL, 505000, 42000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(325, 'Europe/Bucharest', NULL, 442600, 260600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(326, 'Europe/Budapest', NULL, 473000, 190500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(327, 'Europe/Busingen', NULL, 474200, 84100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(328, 'Europe/Chisinau', NULL, 470000, 285000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(329, 'Europe/Copenhagen', NULL, 554000, 123500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(330, 'Europe/Dublin', NULL, 532000, -61500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:IST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(331, 'Europe/Gibraltar', NULL, 360800, -52100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(332, 'Europe/Guernsey', NULL, 492717, -23210, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:BST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(333, 'Europe/Helsinki', NULL, 601000, 245800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(334, 'Europe/Isle_of_Man', NULL, 540900, -42800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:BST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(335, 'Europe/Istanbul', NULL, 410100, 285800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(336, 'Europe/Jersey', NULL, 491101, -20624, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:BST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(337, 'Europe/Kaliningrad', NULL, 544300, 203000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(338, 'Europe/Kirov', NULL, 583600, 493900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(339, 'Europe/Kyiv', NULL, 502600, 303100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(340, 'Europe/Lisbon', NULL, 384300, -90800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:WET\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:WEST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(341, 'Europe/Ljubljana', NULL, 460300, 143100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(342, 'Europe/London', NULL, 513030, 731, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0000\r\nTZOFFSETTO:+0100\r\nTZNAME:BST\r\nDTSTART:19700329T010000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0000\r\nTZNAME:GMT\r\nDTSTART:19701025T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(343, 'Europe/Luxembourg', NULL, 493600, 60900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(344, 'Europe/Madrid', NULL, 402400, -34100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(345, 'Europe/Malta', NULL, 355400, 143100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(346, 'Europe/Mariehamn', NULL, 600600, 195700, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(347, 'Europe/Minsk', NULL, 535400, 273400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(348, 'Europe/Monaco', NULL, 434200, 72300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(349, 'Europe/Moscow', NULL, 554521, 373704, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:MSK\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(350, 'Europe/Nicosia', NULL, 351000, 332200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT'),
(351, 'Europe/Oslo', NULL, 595500, 104500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(352, 'Europe/Paris', NULL, 485200, 22000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(353, 'Europe/Podgorica', NULL, 422600, 191600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(354, 'Europe/Prague', NULL, 500500, 142600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(355, 'Europe/Riga', NULL, 565700, 240600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(356, 'Europe/Rome', NULL, 415400, 122900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(357, 'Europe/Samara', NULL, 531200, 500900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(358, 'Europe/San_Marino', NULL, 435500, 122800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(359, 'Europe/Sarajevo', NULL, 435200, 182500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(360, 'Europe/Saratov', NULL, 513400, 460200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(361, 'Europe/Simferopol', NULL, 445700, 340600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:MSK\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(362, 'Europe/Skopje', NULL, 415900, 212600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(363, 'Europe/Sofia', NULL, 424100, 231900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(364, 'Europe/Stockholm', NULL, 592000, 180300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(365, 'Europe/Tallinn', NULL, 592500, 244500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(366, 'Europe/Tirane', NULL, 412000, 195000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(367, 'Europe/Ulyanovsk', NULL, 542000, 482400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(368, 'Europe/Vaduz', NULL, 470900, 93100, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(369, 'Europe/Vatican', NULL, 415408, 122711, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(370, 'Europe/Vienna', NULL, 481300, 162000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(371, 'Europe/Vilnius', NULL, 544100, 251900, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0300\r\nTZNAME:EEST\r\nDTSTART:19700329T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0200\r\nTZNAME:EET\r\nDTSTART:19701025T040000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(372, 'Europe/Volgograd', NULL, 484400, 442500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:20181028T020000\r\nRDATE:20181028T020000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0300\r\nTZNAME:+03\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20201227T020000\r\nEND:STANDARD'),
(373, 'Europe/Warsaw', NULL, 521500, 210000, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(374, 'Europe/Zagreb', NULL, 454800, 155800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(375, 'Europe/Zurich', NULL, 472300, 83200, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD'),
(376, 'Indian/Antananarivo', NULL, -185500, 473100, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(377, 'Indian/Chagos', NULL, -72000, 722500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0600\r\nTZOFFSETTO:+0600\r\nTZNAME:+06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(378, 'Indian/Christmas', NULL, -102500, 1054300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0700\r\nTZOFFSETTO:+0700\r\nTZNAME:+07\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(379, 'Indian/Cocos', NULL, -121000, 965500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0630\r\nTZOFFSETTO:+0630\r\nTZNAME:+0630\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(380, 'Indian/Comoro', NULL, -114100, 431600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(381, 'Indian/Kerguelen', NULL, -492110, 701303, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(382, 'Indian/Mahe', NULL, -44000, 552800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(383, 'Indian/Maldives', NULL, 41000, 733000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0500\r\nTZOFFSETTO:+0500\r\nTZNAME:+05\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(384, 'Indian/Mauritius', NULL, -201000, 573000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(385, 'Indian/Mayotte', NULL, -124700, 451400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0300\r\nTZOFFSETTO:+0300\r\nTZNAME:EAT\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(386, 'Indian/Reunion', NULL, -205200, 552800, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0400\r\nTZOFFSETTO:+0400\r\nTZNAME:+04\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(387, 'Pacific/Apia', NULL, -135000, -1714400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1400\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:20180401T040000\r\nRDATE:20180401T040000\r\nRDATE:20190407T040000\r\nRDATE:20200405T040000\r\nRDATE:20210404T040000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1400\r\nTZNAME:+14\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180930T030000\r\nRDATE:20190929T030000\r\nRDATE:20200927T030000\r\nEND:DAYLIGHT');
INSERT INTO `egw_cal_timezones` VALUES
(388, 'Pacific/Auckland', NULL, -365200, 1744600, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:NZDT\r\nDTSTART:19700927T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:NZST\r\nDTSTART:19700405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD'),
(389, 'Pacific/Bougainville', NULL, -61300, 1553400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(390, 'Pacific/Chatham', NULL, -435700, -1763300, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1245\r\nTZOFFSETTO:+1345\r\nTZNAME:+1345\r\nDTSTART:19700927T024500\r\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1345\r\nTZOFFSETTO:+1245\r\nTZNAME:+1245\r\nDTSTART:19700405T034500\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD'),
(391, 'Pacific/Chuuk', NULL, 72500, 1514700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:+10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(392, 'Pacific/Easter', NULL, -270900, -1092600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:-06\r\nDTSTART:20190406T220000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SA\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:20230902T230000\r\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=1SA\r\nEND:DAYLIGHT\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20180811T220000\r\nRDATE:20190907T220000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0600\r\nTZNAME:-06\r\nDTSTART:20180512T220000\r\nRDATE:20180512T220000\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0500\r\nTZNAME:-05\r\nDTSTART:20200905T230000\r\nRDATE:20200905T230000\r\nRDATE:20210904T230000\r\nRDATE:20220910T230000\r\nEND:DAYLIGHT'),
(393, 'Pacific/Efate', NULL, -174000, 1682500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(394, 'Pacific/Fakaofo', NULL, -92200, -1711400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(395, 'Pacific/Fiji', NULL, -180800, 1782500, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:20221113T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=2SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:20230115T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=1;BYMONTHDAY=12,13,14,15,16,17,18;BYDAY=SU\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:19700101T000000\r\nRDATE:19700101T000000\r\nRDATE:20181104T020000\r\nRDATE:20191110T020000\r\nRDATE:20201220T020000\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:20180114T030000\r\nRDATE:20180114T030000\r\nRDATE:20190113T030000\r\nRDATE:20200112T030000\r\nRDATE:20210117T030000\r\nEND:STANDARD'),
(396, 'Pacific/Funafuti', NULL, -83100, 1791300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(397, 'Pacific/Galapagos', NULL, 5400, -893600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0600\r\nTZOFFSETTO:-0600\r\nTZNAME:-06\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(398, 'Pacific/Gambier', NULL, -230800, -1345700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0900\r\nTZOFFSETTO:-0900\r\nTZNAME:-09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(399, 'Pacific/Guadalcanal', NULL, -93200, 1601200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(400, 'Pacific/Guam', NULL, 132800, 1444500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:ChST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(401, 'Pacific/Honolulu', NULL, 211825, -1575130, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-1000\r\nTZNAME:HST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(402, 'Pacific/Kanton', NULL, -24700, -1714300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(403, 'Pacific/Kiritimati', NULL, 15200, -1572000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1400\r\nTZOFFSETTO:+1400\r\nTZNAME:+14\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(404, 'Pacific/Kosrae', NULL, 51900, 1625900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(405, 'Pacific/Kwajalein', NULL, 90500, 1672000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(406, 'Pacific/Majuro', NULL, 70900, 1711200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(407, 'Pacific/Marquesas', NULL, -90000, -1393000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0930\r\nTZOFFSETTO:-0930\r\nTZNAME:-0930\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(408, 'Pacific/Midway', NULL, 281300, -1772200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1100\r\nTZOFFSETTO:-1100\r\nTZNAME:SST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(409, 'Pacific/Nauru', NULL, 3100, 1665500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(410, 'Pacific/Niue', NULL, -190100, -1695500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1100\r\nTZOFFSETTO:-1100\r\nTZNAME:-11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(411, 'Pacific/Norfolk', NULL, -290300, 1675800, 'BEGIN:DAYLIGHT\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:20191006T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:20200405T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1130\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:20190701T000000\r\nRDATE:20190701T000000\r\nEND:STANDARD'),
(412, 'Pacific/Noumea', NULL, -221600, 1662700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(413, 'Pacific/Pago_Pago', NULL, -141600, -1704200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1100\r\nTZOFFSETTO:-1100\r\nTZNAME:SST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(414, 'Pacific/Palau', NULL, 72000, 1342900, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+0900\r\nTZOFFSETTO:+0900\r\nTZNAME:+09\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(415, 'Pacific/Pitcairn', NULL, -250400, -1300500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-0800\r\nTZOFFSETTO:-0800\r\nTZNAME:-08\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(416, 'Pacific/Pohnpei', NULL, 65800, 1581300, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1100\r\nTZOFFSETTO:+1100\r\nTZNAME:+11\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(417, 'Pacific/Port_Moresby', NULL, -93000, 1471000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:+10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(418, 'Pacific/Rarotonga', NULL, -211400, -1594600, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-1000\r\nTZNAME:-10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(419, 'Pacific/Saipan', NULL, 151200, 1454500, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1000\r\nTZOFFSETTO:+1000\r\nTZNAME:ChST\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(420, 'Pacific/Tahiti', NULL, -173200, -1493400, 'BEGIN:STANDARD\r\nTZOFFSETFROM:-1000\r\nTZOFFSETTO:-1000\r\nTZNAME:-10\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(421, 'Pacific/Tarawa', NULL, 12500, 1730000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(422, 'Pacific/Tongatapu', NULL, -210800, -1751200, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1300\r\nTZOFFSETTO:+1300\r\nTZNAME:+13\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(423, 'Pacific/Wake', NULL, 191700, 1663700, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(424, 'Pacific/Wallis', NULL, -131800, -1761000, 'BEGIN:STANDARD\r\nTZOFFSETFROM:+1200\r\nTZOFFSETTO:+1200\r\nTZNAME:+12\r\nDTSTART:19700101T000000\r\nEND:STANDARD'),
(425, 'AUS Central Standard Time', 309, NULL, NULL, ''),
(426, 'AUS Eastern Standard Time', 316, NULL, NULL, ''),
(427, 'Afghanistan Standard Time', 247, NULL, NULL, ''),
(428, 'Africa/Asmera', 5, NULL, NULL, ''),
(429, 'Africa/Timbuktu', 6, NULL, NULL, ''),
(430, 'Alaskan Standard Time', 54, NULL, NULL, ''),
(431, 'Aleutian Standard Time', 53, NULL, NULL, ''),
(432, 'Altai Standard Time', 224, NULL, NULL, ''),
(433, 'America/Argentina/ComodRivadavia', 59, NULL, NULL, ''),
(434, 'America/Buenos_Aires', 58, NULL, NULL, ''),
(435, 'America/Godthab', 159, NULL, NULL, ''),
(436, 'America/Louisville', 128, NULL, NULL, ''),
(437, 'America/Montreal', 193, NULL, NULL, ''),
(438, 'America/Santa_Isabel', 192, NULL, NULL, ''),
(439, 'Arab Standard Time', 273, NULL, NULL, ''),
(440, 'Arabian Standard Time', 234, NULL, NULL, ''),
(441, 'Arabic Standard Time', 220, NULL, NULL, ''),
(442, 'Argentina Standard Time', 58, NULL, NULL, ''),
(443, 'Armenian Standard Time', 295, NULL, NULL, ''),
(444, 'Asia/Calcutta', 252, NULL, NULL, ''),
(445, 'Asia/Katmandu', 250, NULL, NULL, ''),
(446, 'Asia/Rangoon', 293, NULL, NULL, ''),
(447, 'Asia/Saigon', 239, NULL, NULL, ''),
(448, 'Astrakhan Standard Time', 319, NULL, NULL, ''),
(449, 'Atlantic Standard Time', 113, NULL, NULL, ''),
(450, 'Atlantic/Faeroe', 300, NULL, NULL, ''),
(451, 'Atlantic/Jan_Mayen', 351, NULL, NULL, ''),
(452, 'Aus Central W. Standard Time', 310, NULL, NULL, ''),
(453, 'Australia/Currie', 311, NULL, NULL, ''),
(454, 'Azerbaijan Standard Time', 222, NULL, NULL, ''),
(455, 'Azores Standard Time', 296, NULL, NULL, ''),
(456, 'Bahia Standard Time', 73, NULL, NULL, ''),
(457, 'Bangkok Standard Time', 223, NULL, NULL, ''),
(458, 'Bangladesh Standard Time', 232, NULL, NULL, ''),
(459, 'Belarus Standard Time', 347, NULL, NULL, ''),
(460, 'Bougainville Standard Time', 389, NULL, NULL, ''),
(461, 'Canada Central Standard Time', 173, NULL, NULL, ''),
(462, 'Cape Verde Standard Time', 299, NULL, NULL, ''),
(463, 'Caucasus Standard Time', 295, NULL, NULL, ''),
(464, 'Cen. Australia Standard Time', 306, NULL, NULL, ''),
(465, 'Central America Standard Time', 110, NULL, NULL, ''),
(466, 'Central Asia Standard Time', 213, NULL, NULL, ''),
(467, 'Central Brazilian Standard Time', 92, NULL, NULL, ''),
(468, 'Central Europe Standard Time', 326, NULL, NULL, ''),
(469, 'Central European Standard Time', 373, NULL, NULL, ''),
(470, 'Central Pacific Standard Time', 399, NULL, NULL, ''),
(471, 'Central Standard Time', 88, NULL, NULL, ''),
(472, 'Central Standard Time (Mexico)', 145, NULL, NULL, ''),
(473, 'Chatham Islands Standard Time', 390, NULL, NULL, ''),
(474, 'China Standard Time', 277, NULL, NULL, ''),
(475, 'Cuba Standard Time', 114, NULL, NULL, ''),
(476, 'E. Africa Standard Time', 43, NULL, NULL, ''),
(477, 'E. Australia Standard Time', 307, NULL, NULL, ''),
(478, 'E. Europe Standard Time', 262, NULL, NULL, ''),
(479, 'E. South America Standard Time', 179, NULL, NULL, ''),
(480, 'Easter Island Standard Time', 392, NULL, NULL, ''),
(481, 'Eastern Standard Time', 152, NULL, NULL, ''),
(482, 'Eastern Standard Time (Mexico)', 84, NULL, NULL, ''),
(483, 'Egypt Standard Time', 13, NULL, NULL, ''),
(484, 'Ekaterinburg Standard Time', 294, NULL, NULL, ''),
(485, 'Europe/Belfast', 342, NULL, NULL, ''),
(486, 'Europe/Kiev', 339, NULL, NULL, ''),
(487, 'Europe/Uzhgorod', 339, NULL, NULL, ''),
(488, 'Europe/Zaporozhye', 339, NULL, NULL, ''),
(489, 'FLE Standard Time', 486, NULL, NULL, ''),
(490, 'Fiji Standard Time', 395, NULL, NULL, ''),
(491, 'GFT Standard Time', 320, NULL, NULL, ''),
(492, 'GMT Standard Time', 342, NULL, NULL, ''),
(493, 'GTB Standard Time', 325, NULL, NULL, ''),
(494, 'Georgian Standard Time', 282, NULL, NULL, ''),
(495, 'Greenland Standard Time', 435, NULL, NULL, ''),
(496, 'Greenwich Standard Time', 302, NULL, NULL, ''),
(497, 'Haiti Standard Time', 165, NULL, NULL, ''),
(498, 'Hawaiian Standard Time', 401, NULL, NULL, ''),
(499, 'India Standard Time', 252, NULL, NULL, ''),
(500, 'Iran Standard Time', 283, NULL, NULL, ''),
(501, 'Israel Standard Time', 246, NULL, NULL, ''),
(502, 'Jordan Standard Time', 214, NULL, NULL, ''),
(503, 'Kaliningrad Standard Time', 337, NULL, NULL, ''),
(504, 'Korea Standard Time', 276, NULL, NULL, ''),
(505, 'Libya Standard Time', 50, NULL, NULL, ''),
(506, 'Line Islands Standard Time', 403, NULL, NULL, ''),
(507, 'Lord Howe Standard Time', 313, NULL, NULL, ''),
(508, 'Magadan Standard Time', 258, NULL, NULL, ''),
(509, 'Magallanes Standard Time', 169, NULL, NULL, ''),
(510, 'Marquesas Standard Time', 407, NULL, NULL, ''),
(511, 'Mauritius Standard Time', 384, NULL, NULL, ''),
(512, 'Mexico Standard Time', 145, NULL, NULL, ''),
(513, 'Mid-Atlantic Standard Time', 303, NULL, NULL, ''),
(514, 'Middle East Standard Time', 225, NULL, NULL, ''),
(515, 'Montevideo Standard Time', 149, NULL, NULL, ''),
(516, 'Morocco Standard Time', 14, NULL, NULL, ''),
(517, 'Mountain Standard Time', 97, NULL, NULL, ''),
(518, 'Mountain Standard Time (Mexico)', 89, NULL, NULL, ''),
(519, 'Myanmar Standard Time', 446, NULL, NULL, ''),
(520, 'N. Central Asia Standard Time', 264, NULL, NULL, ''),
(521, 'Namibia Standard Time', 52, NULL, NULL, ''),
(522, 'Nepal Standard Time', 250, NULL, NULL, ''),
(523, 'New Zealand Standard Time', 388, NULL, NULL, ''),
(524, 'Newfoundland Standard Time', 183, NULL, NULL, ''),
(525, 'Norfolk Standard Time', 411, NULL, NULL, ''),
(526, 'North Asia East Standard Time', 242, NULL, NULL, ''),
(527, 'North Asia Standard Time', 253, NULL, NULL, ''),
(528, 'North Korea Standard Time', 269, NULL, NULL, ''),
(529, 'Omsk Standard Time', 265, NULL, NULL, ''),
(530, 'Pacific SA Standard Time', 177, NULL, NULL, ''),
(531, 'Pacific Standard Time', 133, NULL, NULL, ''),
(532, 'Pacific Standard Time (Mexico)', 438, NULL, NULL, ''),
(533, 'Pacific/Enderbury', 402, NULL, NULL, ''),
(534, 'Pacific/Johnston', 401, NULL, NULL, ''),
(535, 'Pakistan Standard Time', 249, NULL, NULL, ''),
(536, 'Paraguay Standard Time', 71, NULL, NULL, ''),
(537, 'Romance Standard Time', 352, NULL, NULL, ''),
(538, 'Russia Time Zone 10', 279, NULL, NULL, ''),
(539, 'Russia Time Zone 11', 248, NULL, NULL, ''),
(540, 'Russia Time Zone 3', 357, NULL, NULL, ''),
(541, 'Russian Standard Time', 349, NULL, NULL, ''),
(542, 'SA Eastern Standard Time', 86, NULL, NULL, ''),
(543, 'SA Pacific Standard Time', 80, NULL, NULL, ''),
(544, 'SA Western Standard Time', 131, NULL, NULL, ''),
(545, 'SE Asia Standard Time', 223, NULL, NULL, ''),
(546, 'Saint Pierre Standard Time', 146, NULL, NULL, ''),
(547, 'Sakhalin Standard Time', 274, NULL, NULL, ''),
(548, 'Samoa Standard Time', 387, NULL, NULL, ''),
(549, 'Sao Tome Standard Time', 49, NULL, NULL, ''),
(550, 'Saratov Standard Time', 360, NULL, NULL, ''),
(551, 'Saudi Arabia Standard Time', 273, NULL, NULL, ''),
(552, 'Singapore Standard Time', 278, NULL, NULL, ''),
(553, 'South Africa Standard Time', 25, NULL, NULL, ''),
(554, 'Sri Lanka Standard Time', 230, NULL, NULL, ''),
(555, 'Sudan Standard Time', 28, NULL, NULL, ''),
(556, 'Sydney Standard Time', 316, NULL, NULL, ''),
(557, 'Syria Standard Time', 231, NULL, NULL, ''),
(558, 'Taipei Standard Time', 280, NULL, NULL, ''),
(559, 'Tasmania Standard Time', 311, NULL, NULL, ''),
(560, 'Tocantins Standard Time', 57, NULL, NULL, ''),
(561, 'Tokyo Standard Time', 285, NULL, NULL, ''),
(562, 'Tomsk Standard Time', 286, NULL, NULL, ''),
(563, 'Tonga Standard Time', 422, NULL, NULL, ''),
(564, 'Transbaikal Standard Time', 228, NULL, NULL, ''),
(565, 'Turkey Standard Time', 335, NULL, NULL, ''),
(566, 'Turks And Caicos Standard Time', 107, NULL, NULL, ''),
(567, 'US Eastern Standard Time', 116, NULL, NULL, ''),
(568, 'US Mountain Standard Time', 164, NULL, NULL, ''),
(569, 'US/Central', 88, NULL, NULL, ''),
(570, 'US/Eastern', 152, NULL, NULL, ''),
(571, 'US/Mountain', 97, NULL, NULL, ''),
(572, 'US/Pacific', 133, NULL, NULL, ''),
(573, 'US/Pacific-New', 133, NULL, NULL, ''),
(574, 'Ulaanbaatar Standard Time', 287, NULL, NULL, ''),
(575, 'Venezuela Standard Time', 85, NULL, NULL, ''),
(576, 'Vladivostok Standard Time', 291, NULL, NULL, ''),
(577, 'W. Australia Standard Time', 315, NULL, NULL, ''),
(578, 'W. Central Africa Standard Time', 31, NULL, NULL, ''),
(579, 'W. Europe Standard Time', 322, NULL, NULL, ''),
(580, 'W. Mongolia Standard Time', 241, NULL, NULL, ''),
(581, 'West Asia Standard Time', 281, NULL, NULL, ''),
(582, 'West Bank Standard Time', 238, NULL, NULL, ''),
(583, 'West Pacific Standard Time', 417, NULL, NULL, ''),
(584, 'Western Brazilian Standard Time', 175, NULL, NULL, ''),
(585, 'Yakutsk Standard Time', 292, NULL, NULL, ''),
(586, 'Universal Coordinated Time', -1, NULL, NULL, NULL),
(587, 'Casablanca, Monrovia', 14, NULL, NULL, NULL),
(588, 'Greenwich Mean Time: Dublin, Edinburgh, Lisbon, London', 340, NULL, NULL, NULL),
(589, 'Greenwich Mean Time; Dublin, Edinburgh, London', 342, NULL, NULL, NULL),
(590, 'Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna', 322, NULL, NULL, NULL),
(591, 'Belgrade, Pozsony, Budapest, Ljubljana, Prague', 354, NULL, NULL, NULL),
(592, 'Brussels, Copenhagen, Madrid, Paris', 352, NULL, NULL, NULL),
(593, 'Paris, Madrid, Brussels, Copenhagen', 352, NULL, NULL, NULL),
(594, 'Prague, Central Europe', 354, NULL, NULL, NULL),
(595, 'Sarajevo, Skopje, Sofija, Vilnius, Warsaw, Zagreb', 359, NULL, NULL, NULL),
(596, 'West Central Africa', 34, NULL, NULL, NULL),
(597, 'Athens, Istanbul, Minsk', 320, NULL, NULL, NULL),
(598, 'Bucharest', 325, NULL, NULL, NULL),
(599, 'Cairo', 13, NULL, NULL, NULL),
(600, 'Harare, Pretoria', 24, NULL, NULL, NULL),
(601, 'Helsinki, Riga, Tallinn', 333, NULL, NULL, NULL),
(602, 'Israel, Jerusalem Standard Time', 246, NULL, NULL, NULL),
(603, 'Baghdad', 220, NULL, NULL, NULL),
(604, 'Arab, Kuwait, Riyadh', 256, NULL, NULL, NULL),
(605, 'Moscow, St. Petersburg, Volgograd', 349, NULL, NULL, NULL),
(606, 'East Africa, Nairobi', 43, NULL, NULL, NULL),
(607, 'Tehran', 283, NULL, NULL, NULL),
(608, 'Abu Dhabi, Muscat', 261, NULL, NULL, NULL),
(609, 'Baku, Tbilisi, Yerevan', 222, NULL, NULL, NULL),
(610, 'Kabul', 247, NULL, NULL, NULL),
(611, 'Islamabad, Karachi, Tashkent', 249, NULL, NULL, NULL),
(612, 'Kolkata, Chennai, Mumbai, New Delhi, India Standard Time', 444, NULL, NULL, NULL),
(613, 'Kathmandu, Nepal', 250, NULL, NULL, NULL),
(614, 'Almaty, Novosibirsk, North Central Asia', 213, NULL, NULL, NULL),
(615, 'Astana, Dhaka', 232, NULL, NULL, NULL),
(616, 'Sri Jayawardenepura, Sri Lanka', 230, NULL, NULL, NULL),
(617, 'Rangoon', 446, NULL, NULL, NULL),
(618, 'Bangkok, Hanoi, Jakarta', 223, NULL, NULL, NULL),
(619, 'Krasnoyarsk', 253, NULL, NULL, NULL),
(620, 'Beijing, Chongqing, Hong Kong SAR, Urumqi', 277, NULL, NULL, NULL),
(621, 'Irkutsk, Ulaan Bataar', 242, NULL, NULL, NULL),
(622, 'Kuala Lumpur, Singapore', 278, NULL, NULL, NULL),
(623, 'Perth, Western Australia', 315, NULL, NULL, NULL),
(624, 'Osaka, Sapporo, Tokyo', 285, NULL, NULL, NULL),
(625, 'Seoul, Korea Standard time', 276, NULL, NULL, NULL),
(626, 'Adelaide, Central Australia', 306, NULL, NULL, NULL),
(627, 'Darwin', 309, NULL, NULL, NULL),
(628, 'Brisbane, East Australia', 307, NULL, NULL, NULL),
(629, 'Canberra, Melbourne, Sydney, Hobart (year 2000 only)', 316, NULL, NULL, NULL),
(630, 'Guam, Port Moresby', 400, NULL, NULL, NULL),
(631, 'Hobart, Tasmania', 311, NULL, NULL, NULL),
(632, 'Magadan, Solomon Is., New Caledonia', 258, NULL, NULL, NULL),
(633, 'Auckland, Wellington', 388, NULL, NULL, NULL),
(634, 'Fiji Islands, Kamchatka, Marshall Is.', 395, NULL, NULL, NULL),
(635, 'Nuku''alofa, Tonga', 422, NULL, NULL, NULL),
(636, 'Cape Verde Is.', 299, NULL, NULL, NULL),
(637, 'Mid-Atlantic', 155, NULL, NULL, NULL),
(638, 'Brasilia', 179, NULL, NULL, NULL),
(639, 'Buenos Aires', 58, NULL, NULL, NULL),
(640, 'Atlantic Time (Canada)', 113, NULL, NULL, NULL),
(641, 'Caracas, La Paz', 85, NULL, NULL, NULL),
(642, 'Santiago', 177, NULL, NULL, NULL),
(643, 'Bogota, Lima, Quito', 80, NULL, NULL, NULL),
(644, 'Eastern Time (US & Canada)', 152, NULL, NULL, NULL),
(645, 'Indiana (East)', 116, NULL, NULL, NULL),
(646, 'Central Time (US & Canada)', 88, NULL, NULL, NULL),
(647, 'Mexico City, Tegucigalpa', 145, NULL, NULL, NULL),
(648, 'Saskatchewan', 100, NULL, NULL, NULL),
(649, 'Arizona', 164, NULL, NULL, NULL),
(650, 'Mountain Time (US & Canada)', 97, NULL, NULL, NULL),
(651, 'Pacific Time (US & Canada); Tijuana', 133, NULL, NULL, NULL),
(652, 'Alaska', 54, NULL, NULL, NULL),
(653, 'Hawaii', 401, NULL, NULL, NULL),
(654, 'Midway Island, Samoa', 408, NULL, NULL, NULL),
(655, 'Eniwetok, Kwajalein, Dateline Time', 405, NULL, NULL, NULL),
(656, 'Mexico Standard Time 2', 89, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_cal_user`
--

CREATE TABLE `egw_cal_user` (
  `cal_id` int(11) NOT NULL,
  `cal_recur_date` bigint(20) NOT NULL DEFAULT '0',
  `cal_user_type` varchar(1) CHARACTER SET ascii NOT NULL DEFAULT 'u',
  `cal_user_id` varchar(32) CHARACTER SET ascii NOT NULL,
  `cal_status` varchar(1) CHARACTER SET ascii DEFAULT 'A',
  `cal_quantity` int(11) DEFAULT '1',
  `cal_role` varchar(64) CHARACTER SET ascii DEFAULT 'REQ-PARTICIPANT',
  `cal_user_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cal_user_auto` int(11) NOT NULL AUTO_INCREMENT,
  `cal_user_attendee` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cal_user_auto`),
  UNIQUE KEY `egw_cal_user_id_recur_date_type_id` (`cal_id`,`cal_recur_date`,`cal_user_type`,`cal_user_id`),
  KEY `egw_cal_user_modified` (`cal_user_modified`),
  KEY `egw_cal_user_type_id` (`cal_user_type`,`cal_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_categories`
--

CREATE TABLE `egw_categories` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_main` int(11) NOT NULL DEFAULT '0',
  `cat_parent` int(11) NOT NULL DEFAULT '0',
  `cat_level` smallint(6) NOT NULL DEFAULT '0',
  `cat_owner` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '0',
  `cat_access` varchar(7) CHARACTER SET ascii DEFAULT NULL,
  `cat_appname` varchar(16) CHARACTER SET ascii NOT NULL,
  `cat_name` varchar(150) NOT NULL,
  `cat_description` varchar(255) NOT NULL,
  `cat_data` varchar(8192) DEFAULT NULL,
  `last_mod` bigint(20) NOT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `egw_categories_appname_owner_parent_level` (`cat_appname`,`cat_owner`,`cat_parent`,`cat_level`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `egw_categories`
--

INSERT INTO `egw_categories` VALUES
(1, 0, 0, 0, '0', NULL, '*update*', 'global=0', 'global=0', NULL, [[timestamp]]),
(2, 0, 0, 0, '0', 'public', 'bookmarks', 'Bookmarks', 'Added by setup.', '', [[timestamp]]),
(3, 0, 0, 0, '0', 'public', 'news_admin', 'News', 'Category for news', NULL, [[timestamp]]),
(4, 0, 0, 0, '0', 'public', 'news_admin', 'egroupware.org', 'News from egroupware.org', 'a:3:{s:10:"import_url";s:40:"https://www.egroupware.org/start/rss.xml";s:16:"import_frequency";i:4;s:13:"keep_imported";i:0;}', [[timestamp]]),
(5, 0, 0, 0, '0', 'public', 'resources', 'General resources', 'This category has been added by setup', NULL, [[timestamp]]),
(6, 0, 0, 0, '0', 'public', 'resources', 'Locations', 'This category has been added by setup', NULL, [[timestamp]]),
(7, 7, 0, 0, '0', 'public', 'tracker', 'Feature Requests', 'Tracker added by setup.', 'a:1:{s:4:"type";s:7:"tracker";}', [[timestamp]]),
(8, 8, 0, 0, '0', 'public', 'tracker', 'Bugs', 'Tracker added by setup.', 'a:1:{s:4:"type";s:7:"tracker";}', [[timestamp]]),
(9, 9, 0, 0, '0', 'public', 'tracker', 'Patches', 'Tracker added by setup.', 'a:1:{s:4:"type";s:7:"tracker";}', [[timestamp]]),
(10, 10, 0, 0, '0', 'public', 'tracker', 'Stable Release', 'Version added by setup.', 'a:1:{s:4:"type";s:7:"version";}', [[timestamp]]),
(11, 11, 0, 0, '0', 'public', 'tracker', 'Development Version', 'Version added by setup.', 'a:1:{s:4:"type";s:7:"version";}', [[timestamp]]),
(12, 12, 0, 0, '0', 'public', 'tracker', 'Tracker', 'Cat added by setup.', 'a:1:{s:4:"type";s:3:"cat";}', [[timestamp]]),
(13, 13, 0, 0, '0', 'public', 'tracker', 'API', 'Cat added by setup.', 'a:1:{s:4:"type";s:3:"cat";}', [[timestamp]]),
(14, 14, 0, 0, '0', 'public', 'tracker', 'None', 'Resolution added by setup.', 'a:2:{s:4:"type";s:10:"resolution";s:9:"isdefault";b:1;}', [[timestamp]]),
(15, 15, 0, 0, '0', 'public', 'tracker', 'Accepted', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(16, 16, 0, 0, '0', 'public', 'tracker', 'Duplicate', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(17, 17, 0, 0, '0', 'public', 'tracker', 'Fixed', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(18, 18, 0, 0, '0', 'public', 'tracker', 'Invalid', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(19, 19, 0, 0, '0', 'public', 'tracker', 'Info only', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(20, 20, 0, 0, '0', 'public', 'tracker', 'Later', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(21, 21, 0, 0, '0', 'public', 'tracker', 'Out of date', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(22, 22, 0, 0, '0', 'public', 'tracker', 'Postponed', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(23, 23, 0, 0, '0', 'public', 'tracker', 'Outsourced', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(24, 24, 0, 0, '0', 'public', 'tracker', 'Rejected', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(25, 25, 0, 0, '0', 'public', 'tracker', 'Remind', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(26, 26, 0, 0, '0', 'public', 'tracker', 'Wont fix', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(27, 27, 0, 0, '0', 'public', 'tracker', 'Works for me', 'Resolution added by setup.', 'a:1:{s:4:"type";s:10:"resolution";}', [[timestamp]]),
(28, 9, 9, 1, '-1', 'public', 'tracker', 'Translations', 'Added by setup.', 'cat', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `egw_config`
--

CREATE TABLE `egw_config` (
  `config_app` varchar(16) CHARACTER SET ascii NOT NULL,
  `config_name` varchar(32) CHARACTER SET ascii NOT NULL,
  `config_value` text,
  PRIMARY KEY (`config_app`,`config_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `egw_config`
--

INSERT INTO `egw_config` VALUES
('admin', 'postpone_statistics_submit', '[[postpone_statistics_submit]]'),
('bookmarks', 'mail_footer', '\\n\\n--\\nThis was sent from eGroupWare\\nhttp://www.egroupware.org\\n'),
('calendar', 'horizont', '[[calendarhorizont]]'),
('collabora', 'server', 'https://collabora.egroupware.org'),
('infolog', 'history', 'history_admin_delete'),
('phpgwapi', 'account_import_delete', 'yes'),
('phpgwapi', 'account_import_loglevel', 'info'),
('phpgwapi', 'account_import_source', 'ads'),
('phpgwapi', 'account_import_type', 'users'),
('phpgwapi', 'account_repository', 'sql'),
('phpgwapi', 'acl_default', 'deny'),
('phpgwapi', 'asyncservice', 'fallback'),
('phpgwapi', 'auth_type', 'sql'),
('phpgwapi', 'auto_create_expire', '604800'),
('phpgwapi', 'auto_load_holidays', 'True'),
('phpgwapi', 'backup_dir', '[[softdatadir]]/egrpbackup'),
('phpgwapi', 'block_time', '1'),
('phpgwapi', 'calendar_delete_history', 'history'),
('phpgwapi', 'cas_authentication_mode', 'Client'),
('phpgwapi', 'cas_ssl_validation', 'No'),
('phpgwapi', 'enabled_spellcheck', 'YesBrowserBased'),
('phpgwapi', 'files_dir', '[[softdatadir]]/egrpfiles'),
('phpgwapi', 'history', 'history'),
('phpgwapi', 'holidays_url_path', 'localhost'),
('phpgwapi', 'hostname', '[[domhost]]'),
('phpgwapi', 'install_id', '[[install_id]]'),
('phpgwapi', 'ldap_encryption_type', 'blowfish_crypt'),
('phpgwapi', 'mail_login_type', 'standard'),
('phpgwapi', 'mail_server', '[[imap]]'),
('phpgwapi', 'mail_server_type', 'imap'),
('phpgwapi', 'max_access_log_age', '90'),
('phpgwapi', 'max_history', '20'),
('phpgwapi', 'num_unsuccessful_id', '3'),
('phpgwapi', 'num_unsuccessful_ip', '15'),
('phpgwapi', 'oic_username_attribute', 'sub'),
('phpgwapi', 'saml_affiliation', 'eduPersonAffiliation'),
('phpgwapi', 'saml_metadata_refresh', 'daily'),
('phpgwapi', 'saml_username', 'eduPersonPrincipalName'),
('phpgwapi', 'server_timezone', 'America/New_York'),
('phpgwapi', 'sessions_checkip', 'True'),
('phpgwapi', 'site_title', 'EGroupware'),
('phpgwapi', 'sql_encryption_type', 'ssha'),
('phpgwapi', 'system_charset', 'utf-8'),
('phpgwapi', 'temp_dir', '/tmp'),
('phpgwapi', 'tz_aliases_mtime', '2026-01-13 02:29:04'),
('phpgwapi', 'tz_offset', '-5'),
('phpgwapi', 'tz_version', '2.2022e'),
('phpgwapi', 'usecookies', 'True'),
('phpgwapi', 'vfs_storage_mode', 'fs'),
('phpgwapi', 'webserver_url', '[[relativeurl]]'),
('registration', 'accounts_expire', '-1'),
('registration', 'anonymous_pass', 'anonymous'),
('registration', 'anonymous_user', 'anonymous'),
('registration', 'enable_registration', ''),
('registration', 'expiry', '2'),
('registration', 'register_link', ''),
('resources', 'history', 'history'),
('resources', 'location_cats', '6'),
('smallpart', 'coursepassword', 'cleartext'),
('smallpart', 'youtube_videos', 'yes'),
('timesheet', 'history', 'history'),
('tracker', 'admins', 'a:1:{i:0;a:1:{i:0;i:-2;}}'),
('tracker', 'allow_assign_groups', '1'),
('tracker', 'allow_voting', '1'),
('tracker', 'field_acl', 'a:19:{s:10:"tr_summary";i:49;s:10:"tr_tracker";i:97;s:6:"cat_id";i:49;s:10:"tr_version";i:49;s:9:"tr_status";i:49;s:14:"tr_description";i:64;s:11:"tr_assigned";i:17;s:10:"tr_private";i:49;s:9:"tr_budget";i:33;s:13:"tr_resolution";i:33;s:13:"tr_completion";i:33;s:11:"tr_priority";i:49;s:12:"tr_startdate";i:49;s:10:"tr_duedate";i:17;s:7:"link_to";i:49;s:15:"canned_response";i:33;s:13:"reply_message";i:4;s:3:"add";i:4;s:4:"vote";i:8;}'),
('tracker', 'overdue_days', '14'),
('tracker', 'pending_close_days', '0'),
('tracker', 'technicians', 'a:1:{i:0;a:1:{i:0;i:-1;}}');

-- --------------------------------------------------------

--
-- Table structure for table `egw_customfields`
--

CREATE TABLE `egw_customfields` (
  `cf_id` int(11) NOT NULL AUTO_INCREMENT,
  `cf_app` varchar(16) CHARACTER SET ascii NOT NULL,
  `cf_name` varchar(128) NOT NULL,
  `cf_label` varchar(128) DEFAULT NULL,
  `cf_type` varchar(64) NOT NULL DEFAULT 'text',
  `cf_type2` varchar(2048) DEFAULT NULL,
  `cf_help` varchar(256) DEFAULT NULL,
  `cf_values` varchar(8096) DEFAULT NULL,
  `cf_len` smallint(6) DEFAULT NULL,
  `cf_rows` smallint(6) DEFAULT NULL,
  `cf_order` smallint(6) DEFAULT NULL,
  `cf_needed` tinyint(4) DEFAULT '0',
  `cf_private` varchar(2048) CHARACTER SET ascii DEFAULT NULL,
  `cf_modifier` int(11) DEFAULT NULL,
  `cf_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cf_tab` varchar(64) DEFAULT NULL,
  `cf_readonly` varchar(2048) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`cf_id`),
  UNIQUE KEY `egw_customfields_cf_app_cf_name` (`cf_app`,`cf_name`),
  KEY `egw_customfields_cf_app_cf_order` (`cf_app`,`cf_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_ea_accounts`
--

CREATE TABLE `egw_ea_accounts` (
  `acc_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_name` varchar(80) DEFAULT NULL,
  `ident_id` int(11) NOT NULL,
  `acc_imap_host` varchar(128) CHARACTER SET ascii NOT NULL,
  `acc_imap_ssl` tinyint(4) NOT NULL DEFAULT '0',
  `acc_imap_port` int(11) NOT NULL DEFAULT '143',
  `acc_sieve_enabled` tinyint(4) DEFAULT '0',
  `acc_sieve_host` varchar(128) CHARACTER SET ascii DEFAULT NULL,
  `acc_sieve_port` int(11) DEFAULT '4190',
  `acc_folder_sent` varchar(128) DEFAULT NULL,
  `acc_folder_trash` varchar(128) DEFAULT NULL,
  `acc_folder_draft` varchar(128) DEFAULT NULL,
  `acc_folder_template` varchar(128) DEFAULT NULL,
  `acc_folder_archive` varchar(128) DEFAULT NULL,
  `acc_smtp_host` varchar(128) DEFAULT NULL,
  `acc_smtp_ssl` tinyint(4) NOT NULL DEFAULT '0',
  `acc_smtp_port` int(11) NOT NULL DEFAULT '25',
  `acc_smtp_type` varchar(32) CHARACTER SET ascii DEFAULT 'emailadmin_smtp',
  `acc_imap_type` varchar(32) CHARACTER SET ascii DEFAULT 'emailadmin_imap',
  `acc_imap_logintype` varchar(20) CHARACTER SET ascii DEFAULT NULL,
  `acc_domain` varchar(100) DEFAULT NULL,
  `acc_user_editable` tinyint(4) NOT NULL DEFAULT '1',
  `acc_sieve_ssl` tinyint(4) DEFAULT '1',
  `acc_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `acc_modifier` int(11) DEFAULT NULL,
  `acc_smtp_auth_session` tinyint(4) DEFAULT NULL,
  `acc_folder_junk` varchar(128) DEFAULT NULL,
  `acc_imap_default_quota` int(11) DEFAULT NULL,
  `acc_imap_timeout` smallint(6) DEFAULT NULL,
  `acc_user_forward` tinyint(4) DEFAULT '0',
  `acc_further_identities` tinyint(4) NOT NULL DEFAULT '1',
  `acc_folder_ham` varchar(128) DEFAULT NULL,
  `acc_spam_api` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`acc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_ea_credentials`
--

CREATE TABLE `egw_ea_credentials` (
  `cred_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_id` int(11) NOT NULL,
  `cred_type` smallint(6) NOT NULL,
  `account_id` int(11) NOT NULL,
  `cred_username` varchar(80) NOT NULL,
  `cred_password` varchar(16384) DEFAULT NULL,
  `cred_pw_enc` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`cred_id`),
  UNIQUE KEY `egw_ea_credentials_acc_id_account_id_cred_type` (`acc_id`,`account_id`,`cred_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_ea_identities`
--

CREATE TABLE `egw_ea_identities` (
  `ident_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_id` int(11) NOT NULL,
  `ident_realname` varchar(128) NOT NULL,
  `ident_email` varchar(128) DEFAULT NULL,
  `ident_org` varchar(128) DEFAULT NULL,
  `ident_signature` text,
  `account_id` int(11) NOT NULL DEFAULT '0',
  `ident_name` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`ident_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_ea_notifications`
--

CREATE TABLE `egw_ea_notifications` (
  `notif_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `notif_folder` varchar(255) NOT NULL,
  PRIMARY KEY (`notif_id`),
  KEY `egw_ea_notifications_account_id_acc_id` (`account_id`,`acc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_ea_valid`
--

CREATE TABLE `egw_ea_valid` (
  `acc_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  UNIQUE KEY `egw_ea_valid_acc_id_account_id` (`acc_id`,`account_id`),
  KEY `egw_ea_valid_account_id_acc_id` (`account_id`,`acc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_history_log`
--

CREATE TABLE `egw_history_log` (
  `history_id` int(11) NOT NULL AUTO_INCREMENT,
  `history_record_id` int(11) NOT NULL,
  `history_appname` varchar(16) CHARACTER SET ascii NOT NULL,
  `history_owner` int(11) NOT NULL,
  `history_status` varchar(32) NOT NULL,
  `history_new_value` longtext NOT NULL,
  `history_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `history_old_value` longtext NOT NULL,
  `sessionid` int(11) DEFAULT NULL,
  `share_email` varchar(4096) DEFAULT NULL,
  PRIMARY KEY (`history_id`),
  KEY `egw_history_log_appname_record_id_id` (`history_appname`,`history_record_id`,`history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_importexport_definitions`
--

CREATE TABLE `egw_importexport_definitions` (
  `definition_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `application` varchar(50) DEFAULT NULL,
  `plugin` varchar(100) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `allowed_users` varchar(255) DEFAULT NULL,
  `plugin_options` longtext,
  `owner` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `filter` longtext,
  PRIMARY KEY (`definition_id`),
  UNIQUE KEY `egw_importexport_definitions_name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `egw_importexport_definitions`
--

INSERT INTO `egw_importexport_definitions` VALUES
(1, 'export-infolog', 'infolog', 'infolog_export_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="info_id">Infolog ID</entry>\n    <entry type="string" name="info_type">Type</entry>\n    <entry type="string" name="info_from">Contact</entry>\n    <entry type="string" name="info_subject">Subject</entry>\n    <entry type="string" name="info_des">Description</entry>\n    <entry type="string" name="info_link_id">primary link</entry>\n    <entry type="string" name="info_cat">Category</entry>\n    <entry type="string" name="info_priority">Priority</entry>\n    <entry type="string" name="info_owner">Owner</entry>\n    <entry type="string" name="info_access">Access</entry>\n    <entry type="string" name="info_status">Status</entry>\n    <entry type="string" name="info_percent">Completed</entry>\n    <entry type="string" name="info_datecompleted">Date completed</entry>\n    <entry type="string" name="info_datemodified">Last changed</entry>\n    <entry type="string" name="info_location">Location</entry>\n    <entry type="string" name="info_startdate">Start date</entry>\n    <entry type="string" name="info_enddate">Due date</entry>\n    <entry type="string" name="info_responsible">Responsible</entry>\n    <entry type="string" name="info_cc">Cc</entry>\n    <entry type="string" name="info_planned_time">planned time</entry>\n    <entry type="string" name="info_replanned_time">re-planned time</entry>\n    <entry type="string" name="info_used_time">used time</entry>\n    <entry type="string" name="pl_id">pricelist</entry>\n    <entry type="string" name="info_price">price</entry>\n    <entry type="string" name="all_custom_fields">infolog</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(2, 'import-infolog', 'infolog', 'infolog_import_infologs_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Infolog ID</entry>\n    <entry type="string" name="1">Type</entry>\n    <entry type="string" name="2">Contact</entry>\n    <entry type="string" name="3">Subject</entry>\n    <entry type="string" name="4">Description</entry>\n    <entry type="string" name="5">Phone/Email</entry>\n    <entry type="string" name="6">primary link</entry>\n    <entry type="string" name="7">Category</entry>\n    <entry type="string" name="8">Priority</entry>\n    <entry type="string" name="9">Owner</entry>\n    <entry type="string" name="10">Access</entry>\n    <entry type="string" name="11">Status</entry>\n    <entry type="string" name="12">Completed</entry>\n    <entry type="string" name="13">Date completed</entry>\n    <entry type="string" name="14">Last changed</entry>\n    <entry type="string" name="15">Location</entry>\n    <entry type="string" name="16">Start date</entry>\n    <entry type="string" name="17">Due date</entry>\n    <entry type="string" name="18">Responsible</entry>\n    <entry type="string" name="19">Cc</entry>\n    <entry type="string" name="20">planned time</entry>\n    <entry type="string" name="21">re-planned time</entry>\n    <entry type="string" name="22">used time</entry>\n    <entry type="string" name="23">pricelist</entry>\n    <entry type="string" name="24">price</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">info_id</entry>\n    <entry type="string" name="1">info_type</entry>\n    <entry type="string" name="2">info_from</entry>\n    <entry type="string" name="3">info_subject</entry>\n    <entry type="string" name="4">info_des</entry>\n    <entry type="string" name="6">info_link_id</entry>\n    <entry type="string" name="7">info_cat</entry>\n    <entry type="string" name="8">info_priority</entry>\n    <entry type="string" name="9">info_owner</entry>\n    <entry type="string" name="10">info_access</entry>\n    <entry type="string" name="11">info_status</entry>\n    <entry type="string" name="12">info_percent</entry>\n    <entry type="string" name="13">info_datecompleted</entry>\n    <entry type="string" name="14">info_datemodified</entry>\n    <entry type="string" name="15">info_location</entry>\n    <entry type="string" name="16">info_startdate</entry>\n    <entry type="string" name="17">info_enddate</entry>\n    <entry type="string" name="18">info_responsible</entry>\n    <entry type="string" name="19">info_cc</entry>\n    <entry type="string" name="20">info_planned_time</entry>\n    <entry type="string" name="21">info_replanned_time</entry>\n    <entry type="string" name="22">info_used_time</entry>\n    <entry type="string" name="23">pl_id</entry>\n    <entry type="string" name="24">info_price</entry>\n  </entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">info_id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(3, 'export-calendar-csv', 'calendar', 'calendar_export_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="owner">owner</entry>\n    <entry type="string" name="category">category</entry>\n    <entry type="string" name="priority">priority</entry>\n    <entry type="string" name="public">public</entry>\n    <entry type="string" name="title">title</entry>\n    <entry type="string" name="description">description</entry>\n    <entry type="string" name="location">location</entry>\n    <entry type="string" name="reference">reference</entry>\n    <entry type="string" name="modifier">modifier</entry>\n    <entry type="string" name="non_blocking">non blocking</entry>\n    <entry type="string" name="special">special</entry>\n    <entry type="string" name="creator">creator</entry>\n    <entry type="string" name="recurrence">recurrence</entry>\n    <entry type="string" name="tz_id">tz_id</entry>\n    <entry type="string" name="start">start</entry>\n    <entry type="string" name="end">end</entry>\n    <entry type="string" name="participants">Participants: User, Status, Role</entry>\n    <entry type="string" name="all_custom_fields">calendar</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(4, 'import-calendar-ical', 'calendar', 'calendar_import_ical', 'import', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(5, 'export-calendar-ical', 'calendar', 'calendar_export_ical', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(6, 'export-ACL', 'admin', 'admin_export_acl_csv', 'export', ',,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="acl_account">acl_account</entry>\n    <entry type="string" name="acl_appname">acl_appname</entry>\n    <entry type="string" name="acl_location">acl_location</entry>\n    <entry type="string" name="acl1">acl1</entry>\n    <entry type="string" name="acl2">acl2</entry>\n    <entry type="string" name="acl4">acl4</entry>\n    <entry type="string" name="acl8">acl8</entry>\n    <entry type="string" name="acl16">acl16</entry>\n    <entry type="string" name="acl64">acl64</entry>\n    <entry type="string" name="acl128">acl128</entry>\n    <entry type="string" name="acl256">acl256</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">utf-8</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(7, 'export-projectmanager', 'projectmanager', 'projectmanager_export_projects_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="pm_id">Projectid</entry>\n    <entry type="string" name="pm_title">Title</entry>\n    <entry type="string" name="pm_number">Projectnumber</entry>\n    <entry type="string" name="pm_description">Description</entry>\n    <entry type="string" name="pm_creator">Owner</entry>\n    <entry type="string" name="pm_created">Created</entry>\n    <entry type="string" name="pm_modifier">Modifier</entry>\n    <entry type="string" name="pm_modified">Modified</entry>\n    <entry type="string" name="pm_planned_start">Planned start</entry>\n    <entry type="string" name="pm_planned_end">Planned end</entry>\n    <entry type="string" name="pm_real_start">Real start</entry>\n    <entry type="string" name="pm_real_end">Real end</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="pm_access">Access</entry>\n    <entry type="string" name="pm_priority">Priority</entry>\n    <entry type="string" name="pm_status">Status</entry>\n    <entry type="string" name="pm_completion">Completion</entry>\n    <entry type="string" name="pm_used_time">Used time</entry>\n    <entry type="string" name="pm_planned_time">Planned time</entry>\n    <entry type="string" name="pm_replanned_time">Replanned time</entry>\n    <entry type="string" name="pm_used_budget">Used budget</entry>\n    <entry type="string" name="pm_planned_budget">Planned budget</entry>\n    <entry type="string" name="pm_accounting_type">Accounting type</entry>\n    <entry type="string" name="roles">Roles</entry>\n    <entry type="string" name="pe_sum_completion_shares">Element list Total completion shares</entry>\n    <entry type="string" name="pe_total_shares">Element list Total shares</entry>\n    <entry type="string" name="pe_used_time">Element list Used time</entry>\n    <entry type="string" name="pe_planned_time">Element list Planned time</entry>\n    <entry type="string" name="pe_replanned_time">Element list Replanned time</entry>\n    <entry type="string" name="pe_used_budget">Element list Used budget</entry>\n    <entry type="string" name="pe_planned_budget">Element list Planned budget</entry>\n    <entry type="string" name="pe_real_start">Element list Real start</entry>\n    <entry type="string" name="pe_planned_start">Element list Planned start</entry>\n    <entry type="string" name="pe_real_end">Element list Real end</entry>\n    <entry type="string" name="pe_planned_end">Element list Planned end</entry>\n    <entry type="string" name="pe_completion">Element list Completion</entry>\n    <entry type="string" name="all_custom_fields">projectmanager</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n  <entry type="string" name="pm_used_time">h</entry>\n  <entry type="string" name="pm_planned_time">h</entry>\n  <entry type="string" name="pm_replanned_time">h</entry>\n  <entry type="string" name="include_duration_unit">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(8, 'export-projectmanager-elements', 'projectmanager', 'projectmanager_export_elements_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="pm_title">Project title</entry>\n    <entry type="string" name="pm_id">Project ID</entry>\n    <entry type="string" name="pe_id">Element ID</entry>\n    <entry type="string" name="pe_app">Application</entry>\n    <entry type="string" name="pe_title">Element title</entry>\n    <entry type="string" name="pe_completion">Completion</entry>\n    <entry type="string" name="pe_planned_time">Planned time</entry>\n    <entry type="string" name="pe_replanned_time">Re-planned time</entry>\n    <entry type="string" name="pe_used_time">Time</entry>\n    <entry type="string" name="pe_planned_budget">Planned budget</entry>\n    <entry type="string" name="pe_used_budget">Used budget</entry>\n    <entry type="string" name="pe_planned_start">Planned start</entry>\n    <entry type="string" name="pe_real_start">Start date</entry>\n    <entry type="string" name="pe_planned_end">Planned end</entry>\n    <entry type="string" name="pe_real_end">End date</entry>\n    <entry type="string" name="pe_synced">Synced</entry>\n    <entry type="string" name="pe_modified">Last modified</entry>\n    <entry type="string" name="pe_modifier">Modified by</entry>\n    <entry type="string" name="pe_status">Status</entry>\n    <entry type="string" name="pe_unitprice">Unit price</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="pe_share">Share</entry>\n    <entry type="string" name="pe_resources">Resources</entry>\n    <entry type="string" name="pe_details">Details</entry>\n    <entry type="string" name="pe_planned_quantity">Planned quantity</entry>\n    <entry type="string" name="pe_used_quantity">Used quantity</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n  <entry type="string" name="pe_used_time">h</entry>\n  <entry type="string" name="pe_planned_time">h</entry>\n  <entry type="string" name="pe_replanned_time">h</entry>\n  <entry type="string" name="include_duration_unit">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(9, 'import-projectmanager', 'projectmanager', 'projectmanager_import_projects_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="string" name="update_cats">add</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Projectid</entry>\n    <entry type="string" name="1">Title</entry>\n    <entry type="string" name="2">Projectnumber</entry>\n    <entry type="string" name="3">Description</entry>\n    <entry type="string" name="4">Owner</entry>\n    <entry type="string" name="5">Created</entry>\n    <entry type="string" name="6">Modifier</entry>\n    <entry type="string" name="7">Modified</entry>\n    <entry type="string" name="8">Planned start</entry>\n    <entry type="string" name="9">Planned end</entry>\n    <entry type="string" name="10">Real start</entry>\n    <entry type="string" name="11">Real end</entry>\n    <entry type="string" name="12">Category</entry>\n    <entry type="string" name="13">Access</entry>\n    <entry type="string" name="14">Priority</entry>\n    <entry type="string" name="15">Status</entry>\n    <entry type="string" name="16">Completion</entry>\n    <entry type="string" name="17">Used time</entry>\n    <entry type="string" name="18">Planned time</entry>\n    <entry type="string" name="19">Replanned time</entry>\n    <entry type="string" name="20">Used budget</entry>\n    <entry type="string" name="21">Planned budget</entry>\n    <entry type="string" name="22">Accounting type</entry>\n    <entry type="string" name="23">Roles</entry>\n    <entry type="string" name="24">Element list Total completion shares</entry>\n    <entry type="string" name="25">Element list Total shares</entry>\n    <entry type="string" name="26">Element list Used time</entry>\n    <entry type="string" name="27">Element list Planned time</entry>\n    <entry type="string" name="28">Element list Replanned time</entry>\n    <entry type="string" name="29">Element list Used budget</entry>\n    <entry type="string" name="30">Element list Planned budget</entry>\n    <entry type="string" name="31">Element list Real start</entry>\n    <entry type="string" name="32">Element list Planned start</entry>\n    <entry type="string" name="33">Element list Real end</entry>\n    <entry type="string" name="34">Element list Planned end</entry>\n    <entry type="string" name="35">Element list Completion</entry>\n    <entry type="string" name="36">Custom</entry>\n    <entry type="string" name="37">Coordinator</entry>\n    <entry type="string" name="38">Accounting</entry>\n    <entry type="string" name="39">Assistant</entry>\n    <entry type="string" name="40">Projectmember</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">pm_id</entry>\n    <entry type="string" name="1">pm_title</entry>\n    <entry type="string" name="2">pm_number</entry>\n    <entry type="string" name="3">pm_description</entry>\n    <entry type="string" name="4">pm_creator</entry>\n    <entry type="string" name="5">pm_created</entry>\n    <entry type="string" name="6">pm_modifier</entry>\n    <entry type="string" name="7">pm_modified</entry>\n    <entry type="string" name="8">pm_planned_start</entry>\n    <entry type="string" name="9">pm_planned_end</entry>\n    <entry type="string" name="10">pm_real_start</entry>\n    <entry type="string" name="11">pm_real_end</entry>\n    <entry type="string" name="12">cat_id</entry>\n    <entry type="string" name="13">pm_access</entry>\n    <entry type="string" name="14">pm_priority</entry>\n    <entry type="string" name="15">pm_status</entry>\n    <entry type="string" name="16">pm_completion</entry>\n    <entry type="string" name="17">pm_used_time</entry>\n    <entry type="string" name="18">pm_planned_time</entry>\n    <entry type="string" name="19">pm_replanned_time</entry>\n    <entry type="string" name="20">pm_used_budget</entry>\n    <entry type="string" name="21">pm_planned_budget</entry>\n    <entry type="string" name="22">pm_accounting_type</entry>\n  </entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">pm_id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">none</entry>\n        <entry type="string" name="stop"/>\n      </entry>\n    </entry>\n    <entry type="array" name="1">\n      <entry type="string" name="string">pm_title</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(10, 'export-resources', 'resources', 'resources_export_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="res_id">Resource ID</entry>\n    <entry type="string" name="name">Name</entry>\n    <entry type="string" name="short_description">Short description</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="quantity">Quantity</entry>\n    <entry type="string" name="useable">Useable</entry>\n    <entry type="string" name="location">Location</entry>\n    <entry type="string" name="storage_info">Storage</entry>\n    <entry type="string" name="bookable">Bookable</entry>\n    <entry type="string" name="long_description">Long description</entry>\n    <entry type="string" name="inventory_number">Inventory number</entry>\n    <entry type="string" name="accessory_of">Accessory of</entry>\n    <entry type="string" name="all_custom_fields">resources</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(11, 'import-resources', 'resources', 'resources_import_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="string" name="update_cats">add</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Resource ID</entry>\n    <entry type="string" name="1">Name</entry>\n    <entry type="string" name="2">Short description</entry>\n    <entry type="string" name="3">Category</entry>\n    <entry type="string" name="4">Quantity</entry>\n    <entry type="string" name="5">Useable</entry>\n    <entry type="string" name="6">Location</entry>\n    <entry type="string" name="7">Storage</entry>\n    <entry type="string" name="8">Bookable</entry>\n    <entry type="string" name="9">Long description</entry>\n    <entry type="string" name="10">Inventory number</entry>\n    <entry type="string" name="11">Accessory of</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">res_id</entry>\n    <entry type="string" name="1">name</entry>\n    <entry type="string" name="2">short_description</entry>\n    <entry type="string" name="3">cat_id</entry>\n    <entry type="string" name="4">quantity</entry>\n    <entry type="string" name="5">useable</entry>\n    <entry type="string" name="6">location</entry>\n    <entry type="string" name="7">storage_info</entry>\n    <entry type="string" name="8">bookable</entry>\n    <entry type="string" name="9">long_description</entry>\n    <entry type="string" name="10">inventory_number</entry>\n    <entry type="string" name="11">accessory_of</entry>\n  </entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">res_id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(12, 'export-tracker', 'tracker', 'tracker_export_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="tr_id">Tracker ID</entry>\n    <entry type="string" name="tr_summary">Summary</entry>\n    <entry type="string" name="tr_tracker">Queue</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="tr_version">Version</entry>\n    <entry type="string" name="tr_status">Status</entry>\n    <entry type="string" name="tr_description">Description</entry>\n    <entry type="string" name="replies">Comments</entry>\n    <entry type="string" name="tr_assigned">Assigned to</entry>\n    <entry type="string" name="tr_private">Private</entry>\n    <entry type="string" name="tr_resolution">Resolution</entry>\n    <entry type="string" name="tr_completion">Completed</entry>\n    <entry type="string" name="tr_priority">Priority</entry>\n    <entry type="string" name="tr_closed">Closed</entry>\n    <entry type="string" name="tr_creator">Created by</entry>\n    <entry type="string" name="tr_modifier">Modified by</entry>\n    <entry type="string" name="tr_modified">Last Modified</entry>\n    <entry type="string" name="tr_created">Created</entry>\n    <entry type="string" name="tr_votes">Votes</entry>\n    <entry type="string" name="bounties">Bounty</entry>\n    <entry type="string" name="tr_group">Group</entry>\n    <entry type="string" name="tr_cc">CC</entry>\n    <entry type="string" name="num_replies">Number of replies</entry>\n    <entry type="string" name="all_custom_fields">tracker</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(13, 'import-tracker', 'tracker', 'tracker_import_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="string" name="update_cats">replace</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Tracker ID</entry>\n    <entry type="string" name="1">Summary</entry>\n    <entry type="string" name="2">Queue</entry>\n    <entry type="string" name="3">Category</entry>\n    <entry type="string" name="4">Version</entry>\n    <entry type="string" name="5">Status</entry>\n    <entry type="string" name="6">Description</entry>\n    <entry type="string" name="7">Comments</entry>\n    <entry type="string" name="8">Assigned to</entry>\n    <entry type="string" name="9">Private</entry>\n    <entry type="string" name="10">Resolution</entry>\n    <entry type="string" name="11">Completed</entry>\n    <entry type="string" name="12">Priority</entry>\n    <entry type="string" name="13">Closed</entry>\n    <entry type="string" name="14">Created by</entry>\n    <entry type="string" name="15">Modified by</entry>\n    <entry type="string" name="16">Last Modified</entry>\n    <entry type="string" name="17">Created</entry>\n    <entry type="string" name="18">Votes</entry>\n    <entry type="string" name="19">Bounty</entry>\n    <entry type="string" name="20">Group</entry>\n    <entry type="string" name="21">CC</entry>\n    <entry type="string" name="22">Number of replies</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">tr_id</entry>\n    <entry type="string" name="1">tr_summary</entry>\n    <entry type="string" name="2">tr_tracker</entry>\n    <entry type="string" name="3">cat_id</entry>\n    <entry type="string" name="4">tr_version</entry>\n    <entry type="string" name="5">tr_status</entry>\n    <entry type="string" name="6">tr_description</entry>\n    <entry type="string" name="7">replies</entry>\n    <entry type="string" name="8">tr_assigned</entry>\n    <entry type="string" name="9">tr_private</entry>\n    <entry type="string" name="10">tr_resolution</entry>\n    <entry type="string" name="11">tr_completion</entry>\n    <entry type="string" name="12">tr_priority</entry>\n    <entry type="string" name="13">tr_closed</entry>\n    <entry type="string" name="14">tr_creator</entry>\n    <entry type="string" name="17">tr_created</entry>\n    <entry type="string" name="20">tr_group</entry>\n    <entry type="string" name="21">tr_cc</entry>\n    <entry type="string" name="22">num_replies</entry>\n  </entry>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">tr_id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="owner_from_csv">1</entry>\n  <entry type="string" name="change_owner">0</entry>\n  <entry type="string" name="message">Import options</entry>\n  <entry type="string" name="translate_tracker">add</entry>\n  <entry type="string" name="translate_version">add~</entry>\n  <entry type="string" name="translate_status">add~</entry>\n  <entry type="string" name="translate_resolution">add~</entry>\n  <entry type="string" name="translate_cat_id">add~</entry>\n  <entry type="string" name="creator"/>\n  <entry type="string" name="creator_from_csv">1</entry>\n  <entry type="string" name="group_from_csv">1</entry>\n  <entry type="string" name="assigned_from_csv">1</entry>\n  <entry type="string" name="change_creator"/>\n  <entry type="string" name="convert">1</entry>\n  <entry type="boolean" name="no_cats">TRUE</entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="string" name="record_owner"/>\n  <entry type="string" name="record_group">-1</entry>\n  <entry type="string" name="change_group">0</entry>\n  <entry type="string" name="change_assigned">0</entry>\n  <entry type="string" name="record_assigned"/>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(14, 'export-timesheet', 'timesheet', 'timesheet_export_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="ts_id">Timesheet ID</entry>\n    <entry type="string" name="ts_project">Project</entry>\n    <entry type="string" name="ts_title">Title</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="ts_description">Description</entry>\n    <entry type="string" name="ts_start">Start</entry>\n    <entry type="string" name="ts_duration">Duration</entry>\n    <entry type="string" name="ts_quantity">Quantity</entry>\n    <entry type="string" name="ts_unitprice">Unitprice</entry>\n    <entry type="string" name="ts_owner">Owner</entry>\n    <entry type="string" name="ts_modifier">Modifier</entry>\n    <entry type="string" name="ts_status">Status</entry>\n    <entry type="string" name="pm_id">Projectid</entry>\n    <entry type="string" name="all_custom_fields">timesheet</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(15, 'import-timesheet', 'timesheet', 'timesheet_import_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="string" name="update_cats">add</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Timesheet ID</entry>\n    <entry type="string" name="1">Project</entry>\n    <entry type="string" name="2">Title</entry>\n    <entry type="string" name="3">Category</entry>\n    <entry type="string" name="4">Description</entry>\n    <entry type="string" name="5">Start</entry>\n    <entry type="string" name="6">Duration</entry>\n    <entry type="string" name="7">Quantity</entry>\n    <entry type="string" name="8">Unitprice</entry>\n    <entry type="string" name="9">Owner</entry>\n    <entry type="string" name="10">Modifier</entry>\n    <entry type="string" name="11">Status</entry>\n    <entry type="string" name="12">Projectid</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">ts_id</entry>\n    <entry type="string" name="1">ts_project</entry>\n    <entry type="string" name="2">ts_title</entry>\n    <entry type="string" name="3">cat_id</entry>\n    <entry type="string" name="4">ts_description</entry>\n    <entry type="string" name="5">ts_start</entry>\n    <entry type="string" name="6">ts_duration</entry>\n    <entry type="string" name="7">ts_quantity</entry>\n    <entry type="string" name="8">ts_unitprice</entry>\n    <entry type="string" name="9">ts_owner</entry>\n    <entry type="string" name="10">ts_modifier</entry>\n    <entry type="string" name="11">ts_status</entry>\n    <entry type="string" name="12">pm_id</entry>\n  </entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">ts_id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="change_owner">0</entry>\n  <entry type="string" name="owner_from_csv">1</entry>\n  <entry type="string" name="creator"/>\n  <entry type="string" name="creator_from_csv"/>\n  <entry type="string" name="change_creator"/>\n  <entry type="string" name="convert">1</entry>\n  <entry type="boolean" name="no_cats">TRUE</entry>\n  <entry type="string" name="message">Import options</entry>\n  <entry type="string" name="translate_status">0</entry>\n  <entry type="string" name="translate_cat_id">0</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(16, 'import-addressbook-vcard', 'addressbook', 'addressbook_import_vcard', 'import', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="contact_owner">personal</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(17, 'export-addressbook-vcard', 'addressbook', 'addressbook_export_vcard', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="charset">user</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(18, 'import-addressbook-csv', 'addressbook', 'addressbook_import_contacts_csv', 'import', ',-2,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="string" name="fieldsep">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="num_header_lines">1</entry>\n  <entry type="string" name="update_cats">add</entry>\n  <entry type="array" name="csv_fields">\n    <entry type="string" name="0">Contact ID</entry>\n    <entry type="string" name="1">Type</entry>\n    <entry type="string" name="2">Address Book</entry>\n    <entry type="string" name="3">Private</entry>\n    <entry type="string" name="4">Category</entry>\n    <entry type="string" name="5">Prefix</entry>\n    <entry type="string" name="6">First name</entry>\n    <entry type="string" name="7">Middle name</entry>\n    <entry type="string" name="8">Last name</entry>\n    <entry type="string" name="9">Suffix</entry>\n    <entry type="string" name="10">Full name</entry>\n    <entry type="string" name="11">Own sorting</entry>\n    <entry type="string" name="12">Birthday</entry>\n    <entry type="string" name="13">Organisation</entry>\n    <entry type="string" name="14">Department</entry>\n    <entry type="string" name="15">Job title</entry>\n    <entry type="string" name="16">Occupation</entry>\n    <entry type="string" name="17">Assistent</entry>\n    <entry type="string" name="18">Room</entry>\n    <entry type="string" name="19">Business street</entry>\n    <entry type="string" name="20">Business address line 2</entry>\n    <entry type="string" name="21">Business city</entry>\n    <entry type="string" name="22">Business state</entry>\n    <entry type="string" name="23">Business postal code</entry>\n    <entry type="string" name="24">Business country</entry>\n    <entry type="string" name="25">Business country code</entry>\n    <entry type="string" name="26">Label</entry>\n    <entry type="string" name="27">Street (private)</entry>\n    <entry type="string" name="28">Address line 2 (private)</entry>\n    <entry type="string" name="29">City (private)</entry>\n    <entry type="string" name="30">State (private)</entry>\n    <entry type="string" name="31">ZIP code (private)</entry>\n    <entry type="string" name="32">Country (private)</entry>\n    <entry type="string" name="33">Country code (private)</entry>\n    <entry type="string" name="34">Work phone</entry>\n    <entry type="string" name="35">Mobile phone</entry>\n    <entry type="string" name="36">Business fax</entry>\n    <entry type="string" name="37">Assistent phone</entry>\n    <entry type="string" name="38">Car phone</entry>\n    <entry type="string" name="39">Pager</entry>\n    <entry type="string" name="40">Home phone</entry>\n    <entry type="string" name="41">fax (private)</entry>\n    <entry type="string" name="42">mobile phone (private)</entry>\n    <entry type="string" name="43">Other phone</entry>\n    <entry type="string" name="44">Preferred phone</entry>\n    <entry type="string" name="45">Business email</entry>\n    <entry type="string" name="46">email (private)</entry>\n    <entry type="string" name="47">url (business)</entry>\n    <entry type="string" name="48">url (private)</entry>\n    <entry type="string" name="49">FreeBusy URI</entry>\n    <entry type="string" name="50">Calendar URI</entry>\n    <entry type="string" name="51">Note</entry>\n    <entry type="string" name="52">Time zone</entry>\n    <entry type="string" name="53">GEO</entry>\n    <entry type="string" name="54">Public key</entry>\n    <entry type="string" name="55">Created</entry>\n    <entry type="string" name="56">Created by</entry>\n    <entry type="string" name="57">Last modified</entry>\n    <entry type="string" name="58">Last modified by</entry>\n    <entry type="string" name="59">Account ID</entry>\n  </entry>\n  <entry type="array" name="field_mapping">\n    <entry type="string" name="0">id</entry>\n    <entry type="string" name="1">tid</entry>\n    <entry type="string" name="2">owner</entry>\n    <entry type="string" name="3">private</entry>\n    <entry type="string" name="4">cat_id</entry>\n    <entry type="string" name="5">n_prefix</entry>\n    <entry type="string" name="6">n_given</entry>\n    <entry type="string" name="7">n_middle</entry>\n    <entry type="string" name="8">n_family</entry>\n    <entry type="string" name="9">n_suffix</entry>\n    <entry type="string" name="10">n_fn</entry>\n    <entry type="string" name="11">n_fileas</entry>\n    <entry type="string" name="12">bday</entry>\n    <entry type="string" name="13">org_name</entry>\n    <entry type="string" name="14">org_unit</entry>\n    <entry type="string" name="15">title</entry>\n    <entry type="string" name="16">role</entry>\n    <entry type="string" name="17">assistent</entry>\n    <entry type="string" name="18">room</entry>\n    <entry type="string" name="19">adr_one_street</entry>\n    <entry type="string" name="20">adr_one_street2</entry>\n    <entry type="string" name="21">adr_one_locality</entry>\n    <entry type="string" name="22">adr_one_region</entry>\n    <entry type="string" name="23">adr_one_postalcode</entry>\n    <entry type="string" name="24">adr_one_countryname</entry>\n    <entry type="string" name="25">adr_one_countrycode</entry>\n    <entry type="string" name="26">label</entry>\n    <entry type="string" name="27">adr_two_street</entry>\n    <entry type="string" name="28">adr_two_street2</entry>\n    <entry type="string" name="29">adr_two_locality</entry>\n    <entry type="string" name="30">adr_two_region</entry>\n    <entry type="string" name="31">adr_two_postalcode</entry>\n    <entry type="string" name="32">adr_two_countryname</entry>\n    <entry type="string" name="33">adr_two_countrycode</entry>\n    <entry type="string" name="34">tel_work</entry>\n    <entry type="string" name="35">tel_cell</entry>\n    <entry type="string" name="36">tel_fax</entry>\n    <entry type="string" name="37">tel_assistent</entry>\n    <entry type="string" name="38">tel_car</entry>\n    <entry type="string" name="39">tel_pager</entry>\n    <entry type="string" name="40">tel_home</entry>\n    <entry type="string" name="41">tel_fax_home</entry>\n    <entry type="string" name="42">tel_cell_private</entry>\n    <entry type="string" name="43">tel_other</entry>\n    <entry type="string" name="44">tel_prefer</entry>\n    <entry type="string" name="45">email</entry>\n    <entry type="string" name="46">email_home</entry>\n    <entry type="string" name="47">url</entry>\n    <entry type="string" name="48">url_home</entry>\n    <entry type="string" name="49">freebusy_uri</entry>\n    <entry type="string" name="50">calendar_uri</entry>\n    <entry type="string" name="51">note</entry>\n    <entry type="string" name="52">tz</entry>\n    <entry type="string" name="53">geo</entry>\n    <entry type="string" name="54">pubkey</entry>\n    <entry type="string" name="55">created</entry>\n    <entry type="string" name="56">creator</entry>\n    <entry type="string" name="57">modified</entry>\n    <entry type="string" name="58">modifier</entry>\n    <entry type="string" name="59">account_id</entry>\n  </entry>\n  <entry type="string" name="field_conversion"/>\n  <entry type="array" name="conditions">\n    <entry type="array" name="0">\n      <entry type="string" name="string">id</entry>\n      <entry type="string" name="type">exists</entry>\n      <entry type="array" name="true">\n        <entry type="string" name="action">update</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n      <entry type="array" name="false">\n        <entry type="string" name="action">insert</entry>\n        <entry type="string" name="stop">1</entry>\n      </entry>\n    </entry>\n  </entry>\n  <entry type="string" name="owner_from_csv">1</entry>\n  <entry type="string" name="contact_owner">personal</entry>\n  <entry type="string" name="change_owner">0</entry>\n  <entry type="string" name="convert">1</entry>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n'),
(19, 'export-addressbook-csv', 'addressbook', 'addressbook_export_contacts_csv', 'export', ',-1,', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root">\n  <entry type="array" name="mapping">\n    <entry type="string" name="id">Contact ID</entry>\n    <entry type="string" name="tid">Type</entry>\n    <entry type="string" name="owner">Address Book</entry>\n    <entry type="string" name="private">Private</entry>\n    <entry type="string" name="cat_id">Category</entry>\n    <entry type="string" name="n_prefix">Prefix</entry>\n    <entry type="string" name="n_given">First name</entry>\n    <entry type="string" name="n_middle">Middle name</entry>\n    <entry type="string" name="n_family">Last name</entry>\n    <entry type="string" name="n_suffix">Suffix</entry>\n    <entry type="string" name="n_fn">Full name</entry>\n    <entry type="string" name="n_fileas">Own sorting</entry>\n    <entry type="string" name="bday">Birthday</entry>\n    <entry type="string" name="org_name">Organisation</entry>\n    <entry type="string" name="org_unit">Department</entry>\n    <entry type="string" name="title">Job title</entry>\n    <entry type="string" name="role">Occupation</entry>\n    <entry type="string" name="assistent">Assistent</entry>\n    <entry type="string" name="room">Room</entry>\n    <entry type="string" name="adr_one_street">Business street</entry>\n    <entry type="string" name="adr_one_street2">Business address line 2</entry>\n    <entry type="string" name="adr_one_locality">Business city</entry>\n    <entry type="string" name="adr_one_region">Business state</entry>\n    <entry type="string" name="adr_one_postalcode">Business postal code</entry>\n    <entry type="string" name="adr_one_countryname">Business country</entry>\n    <entry type="string" name="adr_one_countrycode">Business country code</entry>\n    <entry type="string" name="label">Label</entry>\n    <entry type="string" name="adr_two_street">Street (private)</entry>\n    <entry type="string" name="adr_two_street2">Address line 2 (private)</entry>\n    <entry type="string" name="adr_two_locality">City (private)</entry>\n    <entry type="string" name="adr_two_region">State (private)</entry>\n    <entry type="string" name="adr_two_postalcode">ZIP code (private)</entry>\n    <entry type="string" name="adr_two_countryname">Country (private)</entry>\n    <entry type="string" name="adr_two_countrycode">Country code (private)</entry>\n    <entry type="string" name="tel_work">Work phone</entry>\n    <entry type="string" name="tel_cell">Mobile phone</entry>\n    <entry type="string" name="tel_fax">Business fax</entry>\n    <entry type="string" name="tel_assistent">Assistent phone</entry>\n    <entry type="string" name="tel_car">Car phone</entry>\n    <entry type="string" name="tel_pager">Pager</entry>\n    <entry type="string" name="tel_home">Home phone</entry>\n    <entry type="string" name="tel_fax_home">fax (private)*</entry>\n    <entry type="string" name="tel_cell_private">mobile phone (private)*</entry>\n    <entry type="string" name="tel_other">Other phone</entry>\n    <entry type="string" name="tel_prefer">Preferred phone</entry>\n    <entry type="string" name="email">Business email</entry>\n    <entry type="string" name="email_home">email (private)*</entry>\n    <entry type="string" name="url">url (business)*</entry>\n    <entry type="string" name="url_home">url (private)*</entry>\n    <entry type="string" name="freebusy_uri">FreeBusy URI</entry>\n    <entry type="string" name="calendar_uri">Calendar URI</entry>\n    <entry type="string" name="note">Note</entry>\n    <entry type="string" name="tz">Time zone</entry>\n    <entry type="string" name="geo">GEO</entry>\n    <entry type="string" name="pubkey">Public key</entry>\n    <entry type="string" name="created">Created</entry>\n    <entry type="string" name="creator">Created by</entry>\n    <entry type="string" name="modified">Last modified</entry>\n    <entry type="string" name="modifier">Last modified by</entry>\n    <entry type="string" name="account_id">Account ID</entry>\n    <entry type="string" name="all_custom_fields">addressbook</entry>\n  </entry>\n  <entry type="string" name="delimiter">;</entry>\n  <entry type="string" name="charset">user</entry>\n  <entry type="string" name="begin_with_fieldnames">label</entry>\n  <entry type="string" name="convert">1</entry>\n  <entry type="string" name="explode_multiselects"/>\n</entry>\n', NULL, NULL, '[[regtime]]', '<?xml version="1.0" encoding="utf-8"?>\n<entry type="array" name="root"/>\n');

-- --------------------------------------------------------

--
-- Table structure for table `egw_infolog`
--

CREATE TABLE `egw_infolog` (
  `info_id` int(11) NOT NULL AUTO_INCREMENT,
  `info_type` varchar(40) NOT NULL DEFAULT 'task',
  `info_from` varchar(255) DEFAULT NULL,
  `info_subject` varchar(255) DEFAULT NULL,
  `info_des` longtext,
  `info_owner` int(11) NOT NULL,
  `info_access` varchar(10) CHARACTER SET ascii DEFAULT 'public',
  `info_cat` int(11) NOT NULL DEFAULT '0',
  `info_datemodified` bigint(20) NOT NULL,
  `info_startdate` bigint(20) NOT NULL DEFAULT '0',
  `info_enddate` bigint(20) NOT NULL DEFAULT '0',
  `info_id_parent` int(11) NOT NULL DEFAULT '0',
  `info_planned_time` int(11) NOT NULL DEFAULT '0',
  `info_replanned_time` int(11) NOT NULL DEFAULT '0',
  `info_used_time` int(11) NOT NULL DEFAULT '0',
  `info_status` varchar(40) DEFAULT 'done',
  `info_confirm` varchar(10) CHARACTER SET ascii DEFAULT 'not',
  `info_modifier` int(11) NOT NULL DEFAULT '0',
  `info_link_id` int(11) NOT NULL DEFAULT '0',
  `info_priority` smallint(6) DEFAULT '1',
  `pl_id` int(11) DEFAULT NULL,
  `info_price` double DEFAULT NULL,
  `info_percent` smallint(6) DEFAULT '0',
  `info_datecompleted` bigint(20) DEFAULT NULL,
  `info_location` varchar(255) DEFAULT NULL,
  `info_custom_from` tinyint(4) DEFAULT NULL,
  `info_uid` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `caldav_name` varchar(260) CHARACTER SET ascii DEFAULT NULL,
  `info_etag` int(11) DEFAULT '0',
  `info_created` bigint(20) DEFAULT NULL,
  `info_creator` int(11) DEFAULT NULL,
  PRIMARY KEY (`info_id`),
  KEY `egw_infolog_owner` (`info_owner`),
  KEY `egw_infolog_datemodified` (`info_datemodified`),
  KEY `egw_infolog_id_parent` (`info_id_parent`),
  KEY `egw_infolog_caldav_name` (`caldav_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_infolog_extra`
--

CREATE TABLE `egw_infolog_extra` (
  `info_id` int(11) NOT NULL,
  `info_extra_name` varchar(64) NOT NULL,
  `info_extra_value` varchar(16384) NOT NULL,
  PRIMARY KEY (`info_id`,`info_extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_infolog_users`
--

CREATE TABLE `egw_infolog_users` (
  `info_res_id` int(11) NOT NULL AUTO_INCREMENT,
  `info_id` int(11) NOT NULL,
  `account_id` varchar(32) CHARACTER SET ascii NOT NULL,
  `info_res_deleted` tinyint(4) DEFAULT NULL,
  `info_res_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `info_res_modifier` int(11) DEFAULT NULL,
  `info_res_status` varchar(16) DEFAULT 'NEEDS-ACTION',
  `info_res_attendee` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`info_res_id`),
  UNIQUE KEY `egw_infolog_users_id_account_id` (`info_id`,`account_id`),
  KEY `egw_infolog_users_account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_lang`
--

CREATE TABLE `egw_lang` (
  `lang` varchar(5) NOT NULL DEFAULT '',
  `app_name` varchar(16) CHARACTER SET ascii NOT NULL DEFAULT 'common',
  `message_id` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '',
  `content` varchar(8192) DEFAULT NULL,
  `lang_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `egw_lang_lang_app_name_message_id` (`lang`,`app_name`,`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_languages`
--

CREATE TABLE `egw_languages` (
  `lang_id` varchar(5) CHARACTER SET ascii NOT NULL,
  `lang_name` varchar(50) NOT NULL,
  PRIMARY KEY (`lang_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `egw_languages`
--

INSERT INTO `egw_languages` VALUES
('aa', 'Afar'),
('ab', 'Abkhazian'),
('af', 'Afrikaans'),
('am', 'Amharic'),
('ar', 'Arabic'),
('as', 'Assamese'),
('ay', 'Aymara'),
('az', 'Azerbaijani'),
('ba', 'Bashkir'),
('be', 'Byelorussian'),
('bg', 'Bulgarian'),
('bh', 'Bihari'),
('bi', 'Bislama'),
('bn', 'Bengali / Bangla'),
('bo', 'Tibetan'),
('br', 'Breton'),
('ca', 'Catalan'),
('co', 'Corsican'),
('cs', 'Czech'),
('cy', 'Welsh'),
('da', 'Danish'),
('de', 'German'),
('dz', 'Bhutani'),
('el', 'Greek'),
('en', 'English'),
('eo', 'Esperanto'),
('es-es', 'Español'),
('et', 'Estonian'),
('eu', 'Basque'),
('fa', 'Persian'),
('fi', 'Finnish'),
('fj', 'Fiji'),
('fo', 'Faeroese'),
('fr', 'Français'),
('fy', 'Frisian'),
('ga', 'Irish'),
('gd', 'Gaelic / Scots Gaelic'),
('gl', 'Galician'),
('gn', 'Guarani'),
('gu', 'Gujarati'),
('ha', 'Hausa'),
('hi', 'Hindi'),
('hr', 'Croatian'),
('hu', 'Hungarian'),
('hy', 'Armenian'),
('ia', 'Interlingua'),
('id', 'Indonesian'),
('ie', 'Interlingue'),
('ik', 'Inupiak'),
('is', 'Icelandic'),
('it', 'Italian'),
('iw', 'Hebrew'),
('ja', 'Japanese'),
('ji', 'Yiddish'),
('jw', 'Javanese'),
('ka', 'Georgian'),
('kk', 'Kazakh'),
('kl', 'Greenlandic'),
('km', 'Cambodian'),
('kn', 'Kannada'),
('ko', 'Korean'),
('ks', 'Kashmiri'),
('ku', 'Kurdish'),
('ky', 'Kirghiz'),
('la', 'Latin'),
('ln', 'Lingala'),
('lo', 'Laothian'),
('lt', 'Lithuanian'),
('lv', 'Latvian / Lettish'),
('mg', 'Malagasy'),
('mi', 'Maori'),
('mk', 'Macedonian'),
('ml', 'Malayalam'),
('mn', 'Mongolian'),
('mo', 'Moldavian'),
('mr', 'Marathi'),
('ms', 'Malay'),
('mt', 'Maltese'),
('my', 'Burmese'),
('na', 'Nauru'),
('ne', 'Nepali'),
('nl', 'Dutch'),
('no', 'Norwegian'),
('oc', 'Occitan'),
('om', 'Oromo / Afan'),
('or', 'Oriya'),
('pa', 'Punjabi'),
('pl', 'Polish'),
('ps', 'Pashto / Pushto'),
('pt', 'Portuguese'),
('pt-br', 'Brazil'),
('qu', 'Quechua'),
('rm', 'Rhaeto-Romance'),
('rn', 'Kirundi'),
('ro', 'Romanian'),
('ru', 'Russian'),
('rw', 'Kinyarwanda'),
('sa', 'Sanskrit'),
('sd', 'Sindhi'),
('sg', 'Sangro'),
('sh', 'Serbo-Croatian'),
('si', 'Singhalese'),
('sk', 'Slovak'),
('sl', 'Slovenian'),
('sm', 'Samoan'),
('sn', 'Shona'),
('so', 'Somali'),
('sq', 'Albanian'),
('sr', 'Serbian'),
('ss', 'Siswati'),
('st', 'Sesotho'),
('su', 'Sudanese'),
('sv', 'Swedish'),
('sw', 'Swahili'),
('ta', 'Tamil'),
('te', 'Tegulu'),
('tg', 'Tajik'),
('th', 'Thai'),
('ti', 'Tigrinya'),
('tk', 'Turkmen'),
('tl', 'Tagalog'),
('tn', 'Setswana'),
('to', 'Tonga'),
('tr', 'Turkish'),
('ts', 'Tsonga'),
('tt', 'Tatar'),
('tw', 'Twi'),
('uk', 'Ukrainian'),
('ur', 'Urdu'),
('uz', 'Uzbek'),
('vi', 'Vietnamese'),
('vo', 'Volapuk'),
('wo', 'Wolof'),
('xh', 'Xhosa'),
('yo', 'Yoruba'),
('zh', 'Chinese(simplified)'),
('zh-tw', 'Chinese(Taiwan)'),
('zu', 'Zulu');

-- --------------------------------------------------------

--
-- Table structure for table `egw_links`
--

CREATE TABLE `egw_links` (
  `link_id` int(11) NOT NULL AUTO_INCREMENT,
  `link_app1` varchar(16) CHARACTER SET ascii NOT NULL,
  `link_id1` varchar(64) CHARACTER SET ascii NOT NULL,
  `link_app2` varchar(16) CHARACTER SET ascii NOT NULL,
  `link_id2` varchar(64) CHARACTER SET ascii NOT NULL,
  `link_remark` varchar(100) DEFAULT NULL,
  `link_lastmod` bigint(20) NOT NULL,
  `link_owner` int(11) NOT NULL,
  `deleted` datetime DEFAULT NULL,
  PRIMARY KEY (`link_id`),
  KEY `egw_links_deleted` (`deleted`),
  KEY `egw_links_app1_id1_lastmod` (`link_app1`,`link_id1`,`link_lastmod`),
  KEY `egw_links_app2_id2_lastmod` (`link_app2`,`link_id2`,`link_lastmod`),
  KEY `egw_links_app1_app2_id1_id2` (`link_app1`,`link_app2`,`link_id1`,`link_id2`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_locks`
--

CREATE TABLE `egw_locks` (
  `lock_token` varchar(64) CHARACTER SET ascii NOT NULL,
  `lock_path` varchar(255) NOT NULL,
  `lock_expires` bigint(20) NOT NULL,
  `lock_owner` varchar(255) DEFAULT NULL,
  `lock_recursive` tinyint(4) NOT NULL DEFAULT '0',
  `lock_write` tinyint(4) NOT NULL DEFAULT '0',
  `lock_exclusive` tinyint(4) NOT NULL DEFAULT '0',
  `lock_created` bigint(20) DEFAULT '0',
  `lock_modified` bigint(20) DEFAULT '0',
  `lock_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`lock_id`),
  UNIQUE KEY `egw_locks_token` (`lock_token`),
  KEY `egw_locks_path` (`lock_path`),
  KEY `egw_locks_expires` (`lock_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_mailaccounts`
--

CREATE TABLE `egw_mailaccounts` (
  `mail_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `mail_type` tinyint(4) NOT NULL,
  `mail_value` varchar(128) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`mail_id`),
  KEY `egw_mailaccounts_value` (`mail_value`),
  KEY `egw_mailaccounts_account_id_type` (`account_id`,`mail_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_news`
--

CREATE TABLE `egw_news` (
  `news_id` int(11) NOT NULL AUTO_INCREMENT,
  `news_date` bigint(20) DEFAULT NULL,
  `news_headline` varchar(128) DEFAULT NULL,
  `news_submittedby` int(11) DEFAULT NULL,
  `news_content` text,
  `news_begin` bigint(20) NOT NULL DEFAULT '0',
  `news_end` bigint(20) DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `news_teaser` text,
  `news_is_html` smallint(6) NOT NULL DEFAULT '1',
  `news_source_id` int(11) DEFAULT NULL,
  `news_lang` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`news_id`),
  KEY `egw_news_date` (`news_date`),
  KEY `egw_news_headline` (`news_headline`),
  KEY `egw_news_cat_id` (`cat_id`),
  KEY `egw_news_lang` (`news_lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_news_export`
--

CREATE TABLE `egw_news_export` (
  `cat_id` int(11) NOT NULL,
  `export_type` smallint(6) DEFAULT NULL,
  `export_itemsyntax` smallint(6) DEFAULT NULL,
  `export_title` varchar(255) DEFAULT NULL,
  `export_link` varchar(255) DEFAULT NULL,
  `export_description` text,
  `export_img_title` varchar(255) DEFAULT NULL,
  `export_img_url` varchar(255) DEFAULT NULL,
  `export_img_link` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`cat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_notificationpopup`
--

CREATE TABLE `egw_notificationpopup` (
  `notify_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `notify_message` longtext,
  `notify_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `notify_type` varchar(32) CHARACTER SET ascii DEFAULT NULL,
  `notify_status` varchar(32) DEFAULT NULL,
  `notify_data` varchar(4096) DEFAULT NULL,
  `notify_app` varchar(16) CHARACTER SET ascii DEFAULT NULL,
  `notify_app_id` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`notify_id`),
  KEY `egw_notificationpopup_notify_created` (`notify_created`),
  KEY `egw_notificationpopup_notify_type` (`notify_type`),
  KEY `egw_notificationpopup_account_id_notify_type` (`account_id`,`notify_type`),
  KEY `egw_notificationpopup_notify_app_notify_app_id` (`notify_app`,`notify_app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_access_tokens`
--

CREATE TABLE `egw_openid_access_tokens` (
  `access_token_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token_identifier` varchar(128) CHARACTER SET ascii NOT NULL,
  `client_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `access_token_expiration` datetime DEFAULT NULL,
  `access_token_revoked` tinyint(4) NOT NULL DEFAULT '0',
  `access_token_type` tinyint(4) NOT NULL DEFAULT '1',
  `access_token_created` datetime NOT NULL,
  `access_token_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `access_token_ip` varchar(48) CHARACTER SET ascii DEFAULT NULL,
  `access_token_user_agent` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`access_token_id`),
  KEY `egw_openid_access_tokens_client_id` (`client_id`),
  KEY `egw_openid_access_tokens_account_id` (`account_id`),
  KEY `egw_openid_access_tokens_token_revoked` (`access_token_revoked`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_access_token_scopes`
--

CREATE TABLE `egw_openid_access_token_scopes` (
  `access_token_scope_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_token_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`access_token_scope_id`),
  KEY `egw_openid_access_token_scopes_id_scid` (`access_token_id`,`scope_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_auth_codes`
--

CREATE TABLE `egw_openid_auth_codes` (
  `auth_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `auth_code_identifier` varchar(128) CHARACTER SET ascii NOT NULL,
  `account_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `auth_code_expiration` datetime DEFAULT NULL,
  `auth_code_redirect_uri` varchar(255) CHARACTER SET ascii NOT NULL,
  `auth_code_revoked` tinyint(4) NOT NULL DEFAULT '0',
  `auth_code_created` datetime NOT NULL,
  `auth_code_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `auth_code_ip` varchar(48) CHARACTER SET ascii DEFAULT NULL,
  `auth_code_user_agent` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `auth_code_nonce` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`auth_code_id`),
  KEY `egw_openid_auth_codes_account_id` (`account_id`),
  KEY `egw_openid_auth_codes_client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_auth_code_scopes`
--

CREATE TABLE `egw_openid_auth_code_scopes` (
  `auth_code_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`auth_code_id`,`scope_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_clients`
--

CREATE TABLE `egw_openid_clients` (
  `client_id` int(11) NOT NULL AUTO_INCREMENT,
  `client_name` varchar(128) NOT NULL,
  `client_identifier` varchar(128) CHARACTER SET ascii NOT NULL,
  `client_secret` varchar(128) CHARACTER SET ascii NOT NULL,
  `client_redirect_uri` varchar(255) CHARACTER SET ascii NOT NULL,
  `client_status` tinyint(4) NOT NULL DEFAULT '1',
  `client_created` datetime NOT NULL,
  `client_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `client_creator` int(11) DEFAULT NULL,
  `client_modifier` int(11) DEFAULT NULL,
  `client_access_token_ttl` varchar(16) DEFAULT NULL,
  `client_refresh_token_ttl` varchar(16) DEFAULT NULL,
  `app_name` varchar(16) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`client_id`),
  KEY `egw_openid_clients_client_identifier` (`client_identifier`),
  KEY `egw_openid_clients_client_status` (`client_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_client_grants`
--

CREATE TABLE `egw_openid_client_grants` (
  `client_id` int(11) NOT NULL,
  `grant_id` tinyint(4) NOT NULL,
  PRIMARY KEY (`client_id`,`grant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_client_scopes`
--

CREATE TABLE `egw_openid_client_scopes` (
  `client_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`client_id`,`scope_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_refresh_tokens`
--

CREATE TABLE `egw_openid_refresh_tokens` (
  `refresh_token_id` int(11) NOT NULL AUTO_INCREMENT,
  `refresh_token_identifier` varchar(128) CHARACTER SET ascii NOT NULL,
  `access_token_id` int(11) NOT NULL,
  `refresh_token_expiration` datetime DEFAULT NULL,
  `refresh_token_revoked` tinyint(4) NOT NULL DEFAULT '0',
  `refresh_token_created` datetime NOT NULL,
  `refresh_token_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`refresh_token_id`),
  KEY `egw_openid_refresh_tokens_access_token_id` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_scopes`
--

CREATE TABLE `egw_openid_scopes` (
  `scope_id` int(11) NOT NULL AUTO_INCREMENT,
  `scope_identifier` varchar(128) CHARACTER SET ascii NOT NULL,
  `scope_description` varchar(255) DEFAULT NULL,
  `scope_created` datetime NOT NULL,
  `scope_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`scope_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `egw_openid_scopes`
--

INSERT INTO `egw_openid_scopes` VALUES
(1, 'openid', 'Enable OpenID Connect support', '[[regtime]]', '[[regtime]]'),
(2, 'basic', 'Basic details about you', '[[regtime]]', '[[regtime]]'),
(3, 'email', 'Your email address', '[[regtime]]', '[[regtime]]'),
(4, 'phone', 'Your phone number', '[[regtime]]', '[[regtime]]'),
(5, 'address', 'Your address', '[[regtime]]', '[[regtime]]'),
(6, 'profile', 'Your full profile', '[[regtime]]', '[[regtime]]'),
(7, 'roles', 'Administration rights or regular user', '[[regtime]]', '[[regtime]]'),
(8, 'videoconference', 'Videoconference', '[[regtime]]', '[[regtime]]'),
(9, 'groups', 'Groups', '[[regtime]]', '[[regtime]]'),
(10, 'email_aliases', 'EMail aliases', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_user_clients`
--

CREATE TABLE `egw_openid_user_clients` (
  `account_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  PRIMARY KEY (`account_id`,`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_user_grants`
--

CREATE TABLE `egw_openid_user_grants` (
  `account_id` int(11) NOT NULL,
  `grant_id` tinyint(4) NOT NULL,
  PRIMARY KEY (`account_id`,`grant_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_openid_user_scopes`
--

CREATE TABLE `egw_openid_user_scopes` (
  `account_id` int(11) NOT NULL,
  `scope_id` int(11) NOT NULL,
  PRIMARY KEY (`account_id`,`scope_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_constraints`
--

CREATE TABLE `egw_pm_constraints` (
  `pm_id` int(11) NOT NULL,
  `pe_id_end` int(11) NOT NULL,
  `pe_id_start` int(11) NOT NULL,
  `ms_id` int(11) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pm_id`,`pe_id_end`,`pe_id_start`,`ms_id`),
  KEY `egw_pm_constraints_id_pe_id_start` (`pm_id`,`pe_id_start`),
  KEY `egw_pm_constraints_id_ms_id` (`pm_id`,`ms_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_elements`
--

CREATE TABLE `egw_pm_elements` (
  `pm_id` int(11) NOT NULL,
  `pe_id` int(11) NOT NULL,
  `pe_title` varchar(255) NOT NULL,
  `pe_completion` smallint(6) DEFAULT NULL,
  `pe_planned_time` int(11) DEFAULT NULL,
  `pe_replanned_time` int(11) DEFAULT NULL,
  `pe_used_time` int(11) DEFAULT NULL,
  `pe_planned_budget` decimal(20,2) DEFAULT NULL,
  `pe_used_budget` decimal(20,2) DEFAULT NULL,
  `pe_planned_start` bigint(20) DEFAULT NULL,
  `pe_real_start` bigint(20) DEFAULT NULL,
  `pe_planned_end` bigint(20) DEFAULT NULL,
  `pe_real_end` bigint(20) DEFAULT NULL,
  `pe_overwrite` int(11) NOT NULL DEFAULT '0',
  `pl_id` int(11) NOT NULL DEFAULT '0',
  `pe_synced` bigint(20) DEFAULT NULL,
  `pe_modified` bigint(20) NOT NULL,
  `pe_modifier` int(11) NOT NULL,
  `pe_status` varchar(8) NOT NULL DEFAULT 'new',
  `pe_unitprice` decimal(20,2) DEFAULT NULL,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `pe_share` int(11) DEFAULT NULL,
  `pe_health` smallint(6) DEFAULT NULL,
  `pe_resources` varchar(255) DEFAULT NULL,
  `pe_details` text,
  `pe_planned_quantity` double DEFAULT NULL,
  `pe_used_quantity` double DEFAULT NULL,
  `pe_eroles` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`pm_id`,`pe_id`),
  KEY `egw_pm_elements_id_pe_status` (`pm_id`,`pe_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_eroles`
--

CREATE TABLE `egw_pm_eroles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT '0',
  `role_title` varchar(80) NOT NULL,
  `role_description` varchar(255) DEFAULT NULL,
  `role_multi` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_extra`
--

CREATE TABLE `egw_pm_extra` (
  `pm_id` int(11) NOT NULL,
  `pm_extra_name` varchar(64) NOT NULL,
  `pm_extra_value` text,
  PRIMARY KEY (`pm_id`,`pm_extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_members`
--

CREATE TABLE `egw_pm_members` (
  `pm_id` int(11) NOT NULL,
  `member_uid` int(11) NOT NULL,
  `role_id` int(11) DEFAULT '0',
  `member_availibility` double DEFAULT '100',
  PRIMARY KEY (`pm_id`,`member_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_milestones`
--

CREATE TABLE `egw_pm_milestones` (
  `ms_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) NOT NULL,
  `ms_date` bigint(20) NOT NULL,
  `ms_title` varchar(255) DEFAULT NULL,
  `ms_description` text,
  PRIMARY KEY (`ms_id`),
  KEY `egw_pm_milestones_id` (`pm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_pricelist`
--

CREATE TABLE `egw_pm_pricelist` (
  `pl_id` int(11) NOT NULL AUTO_INCREMENT,
  `pl_title` varchar(255) NOT NULL,
  `pl_description` text,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `pl_unit` varchar(20) NOT NULL,
  PRIMARY KEY (`pl_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_prices`
--

CREATE TABLE `egw_pm_prices` (
  `pm_id` int(11) NOT NULL DEFAULT '0',
  `pl_id` int(11) NOT NULL,
  `pl_validsince` bigint(20) NOT NULL DEFAULT '0',
  `pl_price` double DEFAULT NULL,
  `pl_modifier` int(11) NOT NULL,
  `pl_modified` bigint(20) NOT NULL,
  `pl_customertitle` varchar(255) DEFAULT NULL,
  `pl_billable` smallint(6) DEFAULT '1',
  PRIMARY KEY (`pm_id`,`pl_id`,`pl_validsince`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_projects`
--

CREATE TABLE `egw_pm_projects` (
  `pm_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_number` varchar(64) NOT NULL,
  `pm_title` varchar(255) NOT NULL,
  `pm_description` text,
  `pm_creator` int(11) NOT NULL,
  `pm_created` bigint(20) NOT NULL,
  `pm_modifier` int(11) DEFAULT NULL,
  `pm_modified` bigint(20) DEFAULT NULL,
  `pm_planned_start` bigint(20) DEFAULT NULL,
  `pm_planned_end` bigint(20) DEFAULT NULL,
  `pm_real_start` bigint(20) DEFAULT NULL,
  `pm_real_end` bigint(20) DEFAULT NULL,
  `cat_id` int(11) DEFAULT '0',
  `pm_access` varchar(7) DEFAULT 'public',
  `pm_priority` smallint(6) DEFAULT '1',
  `pm_status` varchar(9) DEFAULT 'active',
  `pm_completion` smallint(6) DEFAULT '0',
  `pm_used_time` int(11) DEFAULT NULL,
  `pm_planned_time` int(11) DEFAULT NULL,
  `pm_replanned_time` int(11) DEFAULT NULL,
  `pm_used_budget` decimal(20,2) DEFAULT NULL,
  `pm_planned_budget` decimal(20,2) DEFAULT NULL,
  `pm_overwrite` int(11) DEFAULT '0',
  `pm_accounting_type` varchar(10) DEFAULT 'times',
  PRIMARY KEY (`pm_id`),
  UNIQUE KEY `egw_pm_projects_number` (`pm_number`),
  KEY `egw_pm_projects_title` (`pm_title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_pm_roles`
--

CREATE TABLE `egw_pm_roles` (
  `role_id` int(11) NOT NULL AUTO_INCREMENT,
  `pm_id` int(11) DEFAULT '0',
  `role_title` varchar(80) NOT NULL,
  `role_description` varchar(255) DEFAULT NULL,
  `role_acl` int(11) NOT NULL,
  PRIMARY KEY (`role_id`),
  KEY `egw_pm_roles_id` (`pm_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `egw_pm_roles`
--

INSERT INTO `egw_pm_roles` VALUES
(1, 0, 'Coordinator', 'full access', 65535),
(2, 0, 'Accounting', 'edit access, incl. editing budget and elements', 455),
(3, 0, 'Assistant', 'read access, incl. budget and adding elements', 323),
(4, 0, 'Projectmember', 'read access, no budget', 257),
(5, 0, 'External', 'Add timesheet only', 256);

-- --------------------------------------------------------

--
-- Table structure for table `egw_preferences`
--

CREATE TABLE `egw_preferences` (
  `preference_owner` int(11) NOT NULL,
  `preference_app` varchar(16) CHARACTER SET ascii NOT NULL,
  `preference_value` text NOT NULL,
  `preference_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`preference_id`),
  UNIQUE KEY `egw_preferences_preference_owner_preference_app` (`preference_owner`,`preference_app`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `egw_preferences`
--

INSERT INTO `egw_preferences` VALUES
(0, 'common', '{"rte_toolbar":"fontselect,fontsizeselect,bold,italic,forecolor,backcolor,alignleft,aligncenter,alignright,alignjustify,numlist,bullist,outdent,indent,link,image"}', 1),
(-2, 'common', '{"textsize":"14","lazy-update":"lazy","darkmode":"0","audio_effect":"0","select_multiple_close":"close_email","select_mode":"EGW_SELECTMODE_DEFAULT","account_selection":"selectbox","account_display":"lastname","scroll_area":"0","lang":"[[language]]","country":"US","tz":"America\\/New_York","dateformat":"Y\\/m\\/d","timeformat":"24","number_format":".","currency":"$","csv_charset":"iso-8859-1","rte_font":"arial, helvetica, sans-serif","rte_font_unit":"pt","rte_font_size":"10","rte_formatblock":"p","rte_menubar":"1","open_tabs":"addressbook,calendar,mail,filemanager,infolog,rocketchat","active_tab":"calendar"}', 2),
(-1, 'common', '{"maxmatchs":"20","template_set":"pixelegg","theme":"pixelegg","link_list_format":"icons","show_currentusers":"1","tz_selection":"America\\/New_York","show_generation_time":"0"}', 3),
(-2, 'groupdav', '{"infolog-types":"task","infolog-cat-action":"none","debug_level":"0"}', 4),
(-2, 'addressbook', '{"document_dir":"\\/templates\\/addressbook","hide_accounts":"0","hide_groups_as_lists":"0","link_title":"org_name: n_family, n_given","addr_format":"postcode_city","fileas_default":"org_name: n_family, n_given","duplicate_fields":"n_family,org_name,contact_email","duplicate_threshold":"3","crm_list":"infolog","geolocation_src":"browser"}', 5),
(-2, 'calendar', '{"document_dir":"\\/templates\\/calendar","multiple_weeks":"2","workdaystarts":"9","workdayends":"18","interval":"30","day_consolidate":"6","week_consolidate":"4","use_time_grid":"Array","defaultlength":"60","default_participant":"selected","default_category":"","default-alarm":"","default-alarm-wholeday":"","default-alarm-for":"","defaultresource_sel":"resources","reset_stati":"all","reset_resource_status":"all","new_event_dialog":"add","limit_all_day_lines":"3","birthdays_as_events":"none","link_title":"","receive_updates":"time_change","receive_own_updates":"false","receive_not_participating":"1","notify_externals":"no","notifyAdded":"","notifyCanceled":"","notifyModified":"","export_timezone":"0"}', 6),
(-2, 'infolog', '{"document_dir":"\\/templates\\/infolog","defaultFilter":"","set_start":"date","show_id":"1","listNoSubs":"0","show_links":"all","show_percent":"1","limit_des_lines":"5","notify_creator":"1","notify_assigned":"1","notify_due_delegated":"0","notify_due_responsible":"0d","notify_start_delegated":"0","notify_start_responsible":"0d","notify_owner_group_member":"0","no_notification_types":"Array"}', 7),
(-2, 'tracker', '{"document_dir":"\\/templates\\/tracker","default_version":"","limit_des_lines":"5","notify_creator":"1","notify_assigned":"1","notify_own_modification":"0","notify_start":"0d","notify_due":"0d"}', 8),
(-2, 'timesheet', '{"document_dir":"\\/templates\\/timesheet"}', 9),
(-2, 'projectmanager', '{"document_dir":"\\/templates\\/projectmanager","show_custom_app_icons":"1","link_sort_order":"pm_created DESC","show_links":"0","pm_list":"list","show_projectselection":"tree_with_title","duration_1":"480","start_1":"540","duration_2":"480","start_2":"540","duration_3":"480","start_3":"540","duration_4":"480","start_4":"540","duration_5":"360","start_5":"540","duration_6":"0","start_6":"0","duration_0":"0","start_0":"0","notify_creator":"1","notify_assigned":"0","notify_due_planned":"0","notify_due_real":"0d","notify_start_planned":"0","notify_start_real":"0d","id-generation-format":"P-%Y-%04ix","id-generation-format-sub":"%px\\/%04ix"}', 10),
(-2, 'filemanager', '{"document_dir":"\\/templates\\/","showbase":"no","document_download_name":"$$document$$","collab_excluded_mimes":"application\\/pdf","merge_open_handler":"collabora","document_doubleclick_action":"collabora"}', 11),
(-2, 'activesync', '{"addressbook-all-in-user":"0","addressbook-force-fileas":"0","mail-ActiveSyncProfileID":"G","mail-allowSendingInvitations":"sendifnocalnotif","infolog-types":"task"}', 12),
(-1, 'addressbook', '{"private_addressbook":"0"}', 13),
(-1, 'calendar', '{"weekdaystarts":"Monday","default_private":"0","planner_show_empty_rows":"user","update_format":"ical","freebusy":"0","freebusy_pw":""}', 14),
(-1, 'filemanager', '{"showhome":"yes","showusers":"yes"}', 15),
(-2, 'mail', '{"message_forwarding":"asmail","composeOptions":"html","replyOptions":"none","disableRulerForSignatureSeparation":"0","insertSignatureAtTopOfMessage":"0","allowExternalIMGs":"2","emailTag":"onlyname","deleteOptions":"move_to_trash","sendOptions":"move_to_sent","trustServersUnseenInfo":"2","showAllFoldersInFolderPane":"0","prefaskformove":"2","saveAsOptions":"text","previewPane":"vertical","identLabel":"7","contactLabel":"Array","nextmatch-mail.index.rows-autorefresh":"300"}', 16),
(-1, 'mail', '{"htmlOptions":"always_display","allowExternalIMGs":"1","prefaskformove":"1"}', 17),
(-2, 'news_admin', '{"limit_des_lines":"5"}', 18),
(-2, 'notifications', '{"notification_chain":"popup_and_email","egwpopup_verbosity":"medium"}', 19),
(-1, 'projectmanager', '{"show_infolog_type_icon":"0","gantt_element_title_length":"0","gantt_pm_elementbars_order":"pe_start,pe_end","duration_6":"0","start_6":"0","duration_0":"0","start_0":"0"}', 20),
(-2, 'resources', '{"1":"short_description"}', 21),
(-2, 'rocketchat', '{"notification":"1"}', 22),
(-2, 'smallpart', '{"theme":""}', 23),
(-2, 'status', '{"opencallin":"0","ringtone":"1","ringingtimeout":"15","groups":"_A"}', 24),
(-1, 'tracker', '{"allow_defaultproject":"1"}', 25);

-- --------------------------------------------------------

--
-- Table structure for table `egw_registration`
--

CREATE TABLE `egw_registration` (
  `reg_id` int(11) NOT NULL AUTO_INCREMENT,
  `contact_id` int(11) NOT NULL,
  `status` varchar(1) NOT NULL DEFAULT '0',
  `ip` varchar(20) DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `register_code` varchar(40) DEFAULT NULL,
  `post_confirm_hook` varchar(255) DEFAULT NULL,
  `sitemgr_version` int(11) DEFAULT NULL,
  `account_lid` varchar(64) DEFAULT NULL,
  `password` varchar(100) DEFAULT NULL,
  `primary_group` int(11) DEFAULT NULL,
  PRIMARY KEY (`reg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_resources`
--

CREATE TABLE `egw_resources` (
  `res_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_description` varchar(100) DEFAULT NULL,
  `cat_id` int(11) NOT NULL,
  `quantity` int(11) DEFAULT '1',
  `useable` int(11) DEFAULT '1',
  `location` varchar(100) DEFAULT NULL,
  `bookable` varchar(1) DEFAULT NULL,
  `buyable` varchar(1) DEFAULT NULL,
  `prize` varchar(200) DEFAULT NULL,
  `long_description` longtext,
  `picture_src` varchar(20) DEFAULT NULL,
  `accessory_of` int(11) DEFAULT '-1',
  `storage_info` varchar(200) DEFAULT NULL,
  `inventory_number` varchar(20) DEFAULT NULL,
  `deleted` bigint(20) DEFAULT NULL,
  `res_creator` int(11) DEFAULT NULL,
  `res_created` bigint(20) DEFAULT NULL,
  `res_modifier` int(11) DEFAULT NULL,
  `res_modified` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`res_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `egw_resources`
--

INSERT INTO `egw_resources` VALUES
(1, 'Meeting room 1', NULL, 6, 1, 1, NULL, '1', NULL, NULL, NULL, 'cat_src', -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'Meeting room 2', NULL, 6, 1, 1, NULL, '1', NULL, NULL, NULL, 'cat_src', -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'Fixed Beamer', NULL, 5, 1, 1, NULL, '0', NULL, NULL, NULL, 'cat_src', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_resources_extra`
--

CREATE TABLE `egw_resources_extra` (
  `extra_id` int(11) NOT NULL,
  `extra_name` varchar(64) NOT NULL,
  `extra_owner` int(11) NOT NULL DEFAULT '-1',
  `extra_value` varchar(16384) NOT NULL DEFAULT '',
  PRIMARY KEY (`extra_id`,`extra_name`,`extra_owner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_sharing`
--

CREATE TABLE `egw_sharing` (
  `share_id` int(11) NOT NULL AUTO_INCREMENT,
  `share_token` varchar(64) CHARACTER SET ascii NOT NULL,
  `share_path` varchar(1024) NOT NULL,
  `share_owner` int(11) NOT NULL,
  `share_expires` date DEFAULT NULL,
  `share_writable` tinyint(4) NOT NULL DEFAULT '0',
  `share_with` varchar(4096) DEFAULT NULL,
  `share_passwd` varchar(128) DEFAULT NULL,
  `share_pw_reversable` varchar(128) DEFAULT NULL,
  `share_encryption` int(11) DEFAULT NULL,
  `share_modified` datetime NOT NULL,
  `share_modifier` int(11) DEFAULT NULL,
  `share_created` datetime NOT NULL,
  `share_last_accessed` datetime DEFAULT NULL,
  PRIMARY KEY (`share_id`),
  UNIQUE KEY `egw_sharing_share_token` (`share_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_answers`
--

CREATE TABLE `egw_smallpart_answers` (
  `answer_id` int(11) NOT NULL AUTO_INCREMENT,
  `overlay_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `answer_data` varchar(8192) NOT NULL,
  `answer_score` double DEFAULT NULL,
  `answer_created` datetime NOT NULL,
  `answer_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `answer_modifier` int(11) DEFAULT NULL,
  PRIMARY KEY (`answer_id`),
  KEY `egw_smallpart_answers_overlay_id` (`overlay_id`),
  KEY `egw_smallpart_answers_video_id` (`video_id`),
  KEY `egw_smallpart_answers_account_id` (`account_id`),
  KEY `egw_smallpart_answers_course_id_video_id_account_id` (`course_id`,`video_id`,`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_categories`
--

CREATE TABLE `egw_smallpart_categories` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `cat_name` varchar(256) DEFAULT NULL,
  `cat_description` varchar(256) DEFAULT NULL,
  `cat_color` varchar(7) DEFAULT NULL,
  `cat_data` varchar(16384) DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  KEY `egw_smallpart_categories_course_id` (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_clmeasurements`
--

CREATE TABLE `egw_smallpart_clmeasurements` (
  `cl_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `cl_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `cl_type` varchar(16) CHARACTER SET ascii DEFAULT NULL,
  `cl_data` varchar(16384) DEFAULT NULL,
  PRIMARY KEY (`cl_id`),
  KEY `egw_smallpart_clmeasurements_course_id` (`course_id`),
  KEY `egw_smallpart_clmeasurements_video_id_account_id_cl_timestamp` (`video_id`,`account_id`,`cl_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_clmeasurements_config`
--

CREATE TABLE `egw_smallpart_clmeasurements_config` (
  `course_id` int(11) NOT NULL,
  `config_data` varchar(16384) DEFAULT NULL,
  PRIMARY KEY (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_comments`
--

CREATE TABLE `egw_smallpart_comments` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `comment_starttime` int(11) DEFAULT '0',
  `comment_stoptime` int(11) DEFAULT '0',
  `comment_color` varchar(6) CHARACTER SET ascii DEFAULT NULL,
  `comment_deleted` tinyint(4) NOT NULL DEFAULT '0',
  `comment_added` varchar(16384) NOT NULL,
  `comment_history` text,
  `comment_related_to` int(11) DEFAULT NULL,
  `comment_info_alert` varchar(2048) DEFAULT NULL,
  `comment_marked` text,
  `comment_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comment_created` datetime DEFAULT NULL,
  `comment_cat` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `egw_smallpart_comments_course_id` (`course_id`),
  KEY `egw_smallpart_comments_video_id` (`video_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `egw_smallpart_comments`
--

INSERT INTO `egw_smallpart_comments` VALUES
(1, 1, 24, 1, 13, 13, 'ffffff', 0, '["Transparenz des Overlays kann gesteuert werden und muss je nach Zielsetzung höher oder niedriger sein."]', NULL, NULL, '', '[{"x":11.25,"y":68.89,"c":"ffffff"},{"x":13.75,"y":68.89,"c":"ffffff"},{"x":16.25,"y":68.89,"c":"ffffff"},{"x":10,"y":71.11,"c":"ffffff"},{"x":16.25,"y":71.11,"c":"ffffff"},{"x":16.25,"y":75.56,"c":"ffffff"},{"x":15,"y":80,"c":"ffffff"},{"x":13.75,"y":82.22,"c":"ffffff"}]', '[[regtime]]', NULL, NULL),
(2, 1, 24, 1, 20, 20, 'ff0000', 0, '["Verlust des Triggers bei zu schnellen Bewegungen. Du solltest hier langsamer in der Demonstration sein. Man sieht aber auch wie schnell sich das System wieder \\"einklinkt\\"","Christoph[24]","Verlust des Triggers lässt sich unabhängig von der Bewegungsgeschwindigkeit bei zu starkem Kippen nicht vermeiden, da das Bild nicht mehr erkannt werden kann, wenn es optisch nur noch ein Strich ist."]', '["","Christoph[24]","Verlust des Triggers bei zu schnellen Bewegungen. Du solltest hier langsamer in der Demonstartion sein. Man sieht aber auch wie schnell sich das System wieder \\"einklinkt\\""]', NULL, '', NULL, '[[regtime]]', NULL, NULL),
(3, 1, 24, 1, 32, 32, 'ffffff', 0, '["Hier sucht die Kamera, man kann es am pulsierenden Symbol erkennen.","Test[71]","Ein \\"n\\" zu viel."]', '["Christoph[24]","Hier sucht die Kammera, mann kann es am pulsierenden Symbol erkennen.","Christoph[24]","Hier sucht die Kammera, man kann es am pulsierenden Symbol erkennen."]', NULL, '', '[{"x":45,"y":33.33,"c":"ff0000"},{"x":52.5,"y":33.33,"c":"ff0000"},{"x":58.75,"y":42.22,"c":"ff0000"},{"x":40,"y":48.89,"c":"ff0000"},{"x":58.75,"y":57.78,"c":"ff0000"},{"x":43.75,"y":62.22,"c":"ff0000"},{"x":50,"y":66.67,"c":"ff0000"}]', '[[regtime]]', NULL, NULL),
(4, 1, 24, 1, 50, 50, '00ff00', 0, '["Transparenz kann geregelt werden in der App."]', NULL, NULL, '', NULL, '[[regtime]]', NULL, NULL),
(5, 1, 24, 1, 61, 61, '00ff00', 0, '["Die Triggererkennung kann Seiten unterscheiden."]', NULL, NULL, '', NULL, '[[regtime]]', NULL, NULL),
(6, 1, 24, 1, 73, 73, '00ff00', 0, '["Durch den Wechsel werden kleine Veränderungen gut sichtbar,"]', NULL, NULL, '', '[{"x":41.25,"y":66.67,"c":"ff0000"},{"x":42.5,"y":66.67,"c":"ff0000"},{"x":43.75,"y":66.67,"c":"ff0000"},{"x":40,"y":68.89,"c":"ff0000"},{"x":41.25,"y":68.89,"c":"ff0000"},{"x":45,"y":68.89,"c":"ff0000"},{"x":40,"y":71.11,"c":"ff0000"},{"x":45,"y":71.11,"c":"ff0000"},{"x":40,"y":73.33,"c":"ff0000"},{"x":45,"y":73.33,"c":"ff0000"},{"x":41.25,"y":75.56,"c":"ff0000"},{"x":43.75,"y":75.56,"c":"ff0000"},{"x":42.5,"y":77.78,"c":"ff0000"}]', '[[regtime]]', NULL, NULL),
(7, 1, 24, 1, 84, 84, 'ffffff', 0, '["Verlust von grauer Substanz."]', NULL, NULL, '', '[{"x":53.75,"y":35.56,"c":"ff0000"},{"x":63.75,"y":42.22,"c":"ff0000"},{"x":31.25,"y":46.67,"c":"ff0000"},{"x":67.5,"y":51.11,"c":"ff0000"},{"x":31.25,"y":77.78,"c":"ff0000"},{"x":36.25,"y":82.22,"c":"ff0000"}]', '[[regtime]]', NULL, NULL),
(8, 1, 24, 1, 94, 94, 'ff0000', 0, '["Ab hierf könnte man kürzen!",null,"Da ist ein \\"f\\" zu viel ..."]', NULL, NULL, '', NULL, '[[regtime]]', NULL, NULL),
(9, 1, 24, 1, 8, 8, 'ffffff', 0, '["Warum nimmst Du das in die Hand?","Christoph[24]","Nun ja, ich möcht die dynamichen Fähigkeiten zeigen.","Christoph[24]","ein \\"s\\" zu wenig"]', '["Warum nimmstg Du das indie HAnd?","Warum nimmst Du das in die HAnd?"]', NULL, '', NULL, '[[regtime]]', NULL, NULL),
(10, 1, 24, 1, 10, 10, 'ffffff', 0, '[""]', NULL, NULL, '', '[{"x":40,"y":48.89,"c":"ff0000"},{"x":42.5,"y":48.89,"c":"ff0000"},{"x":38.75,"y":51.11,"c":"ff0000"},{"x":38.75,"y":55.56,"c":"ff0000"},{"x":45,"y":55.56,"c":"ff0000"},{"x":41.25,"y":57.78,"c":"ff0000"},{"x":45,"y":57.78,"c":"ff0000"}]', '[[regtime]]', NULL, NULL),
(11, 1, 71, 1, 42, 42, 'ff0000', 0, '["Testuser neuer Kommentar\\nDein Kommentar enthält keine Frage, somit ist er beantwortet, ich setze ihn auf grün\\nMir fehlt aber, desahlb setze ich noch mal auf Rot!","Christoph[24]","Beim Retweet ist die Farbe nicht änderbar, ggf. geht das für Dozierende ... ist aber eine größere Änderung."]', '["Test[71]","Testuser neuer kommentar","Christoph[24]","Testuser neuer Kommentar","Christoph[24]","Testuser neuer Kommentar\\nDein Kommentar enthält keine Frage, somit ist er beantwortet, ich setze ihn auf grün"]', NULL, '', NULL, '[[regtime]]', NULL, NULL),
(12, 1, 5, 1, 14, 14, 'ffffff', 0, '["Ralf''s Kommentar mit Markierung ;)"]', '["Ralf''s Kommentar mit Markierung","Ralf''s Kommentar mit Markierung ;)","Ralf''s Kommentar mit Markierung"]', NULL, '', '[{"x":63.75,"y":75.56,"c":"ffffff"},{"x":65,"y":75.56,"c":"ffffff"},{"x":66.25,"y":75.56,"c":"ffffff"},{"x":70,"y":75.56,"c":"ffffff"},{"x":73.75,"y":75.56,"c":"ffffff"},{"x":78.75,"y":75.56,"c":"ffffff"},{"x":80,"y":75.56,"c":"ffffff"},{"x":81.25,"y":75.56,"c":"ffffff"},{"x":63.75,"y":77.78,"c":"ffffff"},{"x":66.25,"y":77.78,"c":"ffffff"},{"x":68.75,"y":77.78,"c":"ffffff"},{"x":71.25,"y":77.78,"c":"ffffff"},{"x":73.75,"y":77.78,"c":"ffffff"},{"x":78.75,"y":77.78,"c":"ffffff"},{"x":63.75,"y":80,"c":"ffffff"},{"x":65,"y":80,"c":"ffffff"},{"x":66.25,"y":80,"c":"ffffff"},{"x":68.75,"y":80,"c":"ffffff"},{"x":71.25,"y":80,"c":"ffffff"},{"x":73.75,"y":80,"c":"ffffff"},{"x":78.75,"y":80,"c":"ffffff"},{"x":63.75,"y":82.22,"c":"ffffff"},{"x":65,"y":82.22,"c":"ffffff"},{"x":68.75,"y":82.22,"c":"ffffff"},{"x":70,"y":82.22,"c":"ffffff"},{"x":71.25,"y":82.22,"c":"ffffff"},{"x":73.75,"y":82.22,"c":"ffffff"},{"x":78.75,"y":82.22,"c":"ffffff"},{"x":80,"y":82.22,"c":"ffffff"},{"x":63.75,"y":84.44,"c":"ffffff"},{"x":66.25,"y":84.44,"c":"ffffff"},{"x":68.75,"y":84.44,"c":"ffffff"},{"x":71.25,"y":84.44,"c":"ffffff"},{"x":73.75,"y":84.44,"c":"ffffff"},{"x":78.75,"y":84.44,"c":"ffffff"},{"x":63.75,"y":86.67,"c":"ffffff"},{"x":66.25,"y":86.67,"c":"ffffff"},{"x":68.75,"y":86.67,"c":"ffffff"},{"x":71.25,"y":86.67,"c":"ffffff"},{"x":73.75,"y":86.67,"c":"ffffff"},{"x":75,"y":86.67,"c":"ffffff"},{"x":76.25,"y":86.67,"c":"ffffff"},{"x":78.75,"y":86.67,"c":"ffffff"}]', '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_courses`
--

CREATE TABLE `egw_smallpart_courses` (
  `course_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(255) NOT NULL,
  `course_password` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `course_owner` int(11) NOT NULL,
  `course_org` int(11) DEFAULT NULL,
  `course_closed` tinyint(4) DEFAULT '0',
  `course_secret` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `course_options` tinyint(4) DEFAULT '0',
  `course_groups` tinyint(4) DEFAULT NULL,
  `course_info` varchar(8192) DEFAULT NULL,
  `course_disclaimer` varchar(4096) DEFAULT NULL,
  `allow_neutral_lf_categories` tinyint(4) DEFAULT '0',
  `export_columns` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `student_uploads` tinyint(4) DEFAULT '0',
  `course_parent` int(11) DEFAULT NULL,
  `notify_participants` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`course_id`),
  KEY `egw_smallpart_courses_course_org` (`course_org`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `egw_smallpart_courses`
--

INSERT INTO `egw_smallpart_courses` VALUES
(1, 'Christophs Testkurs', NULL, 5, -1, 0, NULL, 0, NULL, NULL, NULL, 0, NULL, 0, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_extra`
--

CREATE TABLE `egw_smallpart_extra` (
  `course_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL DEFAULT '0',
  `extra_name` varchar(64) NOT NULL,
  `extra_value` varchar(16384) NOT NULL,
  `extra_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`extra_id`),
  UNIQUE KEY `egw_smallpart_extra_course_id_video_id_name` (`course_id`,`video_id`,`extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_lastvideo`
--

CREATE TABLE `egw_smallpart_lastvideo` (
  `account_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL DEFAULT '0',
  `video_id` int(11) NOT NULL DEFAULT '0',
  `position` int(11) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`account_id`,`course_id`,`video_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_livefeedback`
--

CREATE TABLE `egw_smallpart_livefeedback` (
  `lf_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `session_created` datetime DEFAULT NULL,
  `session_starttime` datetime DEFAULT NULL,
  `session_endtime` datetime DEFAULT NULL,
  `session_interval` int(11) DEFAULT NULL,
  `host` int(11) DEFAULT NULL,
  PRIMARY KEY (`lf_id`),
  KEY `egw_smallpart_livefeedback_course_id` (`course_id`),
  KEY `egw_smallpart_livefeedback_video_id` (`video_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_overlay`
--

CREATE TABLE `egw_smallpart_overlay` (
  `overlay_id` int(11) NOT NULL AUTO_INCREMENT,
  `video_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `overlay_type` varchar(64) CHARACTER SET ascii NOT NULL,
  `overlay_start` int(11) NOT NULL,
  `overlay_question_mode` tinyint(4) NOT NULL DEFAULT '0',
  `overlay_duration` int(11) DEFAULT NULL,
  `overlay_data` text,
  PRIMARY KEY (`overlay_id`),
  KEY `egw_smallpart_overlay_video_id` (`video_id`),
  KEY `egw_smallpart_overlay_course_id_video_id_start` (`course_id`,`video_id`,`overlay_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_participants`
--

CREATE TABLE `egw_smallpart_participants` (
  `course_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `participant_role` tinyint(4) NOT NULL DEFAULT '0',
  `participant_group` tinyint(4) DEFAULT NULL,
  `participant_alias` varchar(20) DEFAULT NULL,
  `participant_subscribed` datetime DEFAULT NULL,
  `participant_unsubscribed` datetime DEFAULT NULL,
  `participant_agreed` datetime DEFAULT NULL,
  `notify` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`course_id`,`account_id`),
  KEY `egw_smallpart_participants_account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_videos`
--

CREATE TABLE `egw_smallpart_videos` (
  `video_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) NOT NULL,
  `video_name` varchar(255) NOT NULL,
  `video_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `video_question` varchar(4096) DEFAULT NULL,
  `video_hash` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `video_url` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  `video_type` varchar(8) CHARACTER SET ascii NOT NULL DEFAULT 'mp4',
  `video_options` tinyint(4) DEFAULT '0',
  `video_published` tinyint(4) NOT NULL DEFAULT '1',
  `video_published_start` datetime DEFAULT NULL,
  `video_published_end` datetime DEFAULT NULL,
  `video_published_prerequisite` varchar(1024) CHARACTER SET ascii DEFAULT '',
  `video_test_duration` smallint(6) DEFAULT NULL,
  `video_test_options` tinyint(4) NOT NULL DEFAULT '0',
  `video_test_display` tinyint(4) NOT NULL DEFAULT '0',
  `video_limit_access` varchar(1024) CHARACTER SET ascii DEFAULT NULL,
  `owner` int(11) DEFAULT NULL,
  PRIMARY KEY (`video_id`),
  KEY `egw_smallpart_videos_course_id` (`course_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `egw_smallpart_videos`
--

INSERT INTO `egw_smallpart_videos` VALUES
(1, 1, 'Brain Slices.mp4', '[[regtime]]', 'Hier kann eine Aufgabe für die User angelegt werden. Z.B. Rückfragen zum Stoff ...', NULL, '[[relativeurl]]/smallpart/setup/brain-slices.mp4', 'mp4', 0, 1, NULL, NULL, '', NULL, 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_smallpart_watched`
--

CREATE TABLE `egw_smallpart_watched` (
  `watch_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `video_id` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `watch_starttime` datetime NOT NULL,
  `watch_endtime` datetime NOT NULL,
  `watch_position` int(11) DEFAULT '0',
  `watch_duration` int(11) DEFAULT NULL,
  `watch_paused` smallint(6) DEFAULT '0',
  PRIMARY KEY (`watch_id`),
  KEY `egw_smallpart_watched_video_id_account_id` (`video_id`,`account_id`),
  KEY `egw_smallpart_watched_watch_starttime` (`watch_starttime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_sqlfs`
--

CREATE TABLE `egw_sqlfs` (
  `fs_id` int(11) NOT NULL AUTO_INCREMENT,
  `fs_dir` int(11) NOT NULL,
  `fs_name` varchar(200) NOT NULL,
  `fs_mode` smallint(6) NOT NULL,
  `fs_uid` int(11) NOT NULL DEFAULT '0',
  `fs_gid` int(11) NOT NULL DEFAULT '0',
  `fs_created` datetime NOT NULL,
  `fs_modified` datetime NOT NULL,
  `fs_mime` varchar(96) CHARACTER SET ascii NOT NULL,
  `fs_size` bigint(20) DEFAULT '0',
  `fs_creator` int(11) NOT NULL,
  `fs_modifier` int(11) DEFAULT NULL,
  `fs_active` tinyint(4) NOT NULL DEFAULT '1',
  `fs_content` longblob,
  `fs_link` varchar(1024) DEFAULT NULL,
  `fs_s3_flags` tinyint(4) DEFAULT '0',
  `fs_aes_key` varbinary(32) DEFAULT NULL,
  PRIMARY KEY (`fs_id`),
  KEY `egw_sqlfs_fs_s3_flags` (`fs_s3_flags`),
  KEY `egw_sqlfs_fs_dir_fs_active` (`fs_dir`,`fs_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `egw_sqlfs`
--

INSERT INTO `egw_sqlfs` VALUES
(1, 0, '', 5, 0, 0, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, 0, 1, NULL, NULL, 0, NULL),
(2, 1, 'home', 5, 0, 0, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, 0, 1, NULL, NULL, 0, NULL),
(3, 1, 'apps', 5, 0, 0, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, 0, 1, NULL, NULL, 0, NULL),
(4, 2, 'Default', 56, 0, 1, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(5, 2, 'Admins', 56, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(6, 1, 'templates', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(7, 6, 'addressbook', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(8, 6, 'calendar', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(9, 6, 'infolog', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(10, 6, 'tracker', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(11, 6, 'timesheet', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(12, 6, 'projectmanager', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(13, 6, 'filemanager', 61, 0, 2, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(14, 2, 'NoGroup', 56, 0, 3, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(15, 2, 'anonymous', 448, 4, 0, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(16, 2, 'Teachers', 56, 0, 5, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL),
(17, 2, '[[admin_username]]', 448, 6, 0, '[[regtime]]', '[[regtime]]', 'httpd/unix-directory', 0, 0, NULL, 1, NULL, NULL, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `egw_sqlfs_props`
--

CREATE TABLE `egw_sqlfs_props` (
  `fs_id` int(11) NOT NULL,
  `prop_namespace` varchar(64) CHARACTER SET ascii NOT NULL,
  `prop_name` varchar(64) CHARACTER SET ascii NOT NULL,
  `prop_value` varchar(16384) DEFAULT NULL,
  `prop_id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`prop_id`),
  UNIQUE KEY `egw_sqlfs_props_fs_id_prop_namespace_prop_name` (`fs_id`,`prop_namespace`,`prop_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_timesheet`
--

CREATE TABLE `egw_timesheet` (
  `ts_id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_project` varchar(255) DEFAULT NULL,
  `ts_title` varchar(255) NOT NULL,
  `ts_description` varchar(16384) DEFAULT NULL,
  `ts_start` bigint(20) NOT NULL,
  `ts_duration` int(11) NOT NULL DEFAULT '0',
  `ts_quantity` double NOT NULL,
  `ts_unitprice` double DEFAULT NULL,
  `cat_id` int(11) DEFAULT '0',
  `ts_owner` int(11) NOT NULL,
  `ts_modified` bigint(20) NOT NULL,
  `ts_modifier` int(11) NOT NULL,
  `pl_id` int(11) DEFAULT '0',
  `ts_status` int(11) DEFAULT NULL,
  `ts_created` bigint(20) NOT NULL,
  `ts_paused` int(11) DEFAULT '0',
  `ts_readable` varchar(255) CHARACTER SET ascii DEFAULT NULL,
  PRIMARY KEY (`ts_id`),
  KEY `egw_timesheet_ts_project` (`ts_project`),
  KEY `egw_timesheet_ts_owner` (`ts_owner`),
  KEY `egw_timesheet_ts_status` (`ts_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_timesheet_events`
--

CREATE TABLE `egw_timesheet_events` (
  `tse_id` int(11) NOT NULL AUTO_INCREMENT,
  `ts_id` int(11) DEFAULT NULL,
  `tse_timestamp` datetime NOT NULL,
  `tse_time` datetime DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `tse_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `tse_modifier` int(11) DEFAULT NULL,
  `tse_app` varchar(24) CHARACTER SET ascii DEFAULT NULL,
  `tse_app_id` varchar(64) CHARACTER SET ascii DEFAULT NULL,
  `tse_type` int(11) NOT NULL,
  PRIMARY KEY (`tse_id`),
  KEY `egw_timesheet_events_ts_id` (`ts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_timesheet_extra`
--

CREATE TABLE `egw_timesheet_extra` (
  `ts_id` int(11) NOT NULL,
  `ts_extra_name` varchar(64) NOT NULL,
  `ts_extra_value` varchar(16384) NOT NULL DEFAULT '',
  PRIMARY KEY (`ts_id`,`ts_extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tokens`
--

CREATE TABLE `egw_tokens` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `token_hash` varchar(128) CHARACTER SET ascii NOT NULL,
  `token_limits` varchar(4096) CHARACTER SET ascii DEFAULT NULL,
  `token_created` datetime NOT NULL,
  `token_created_by` int(11) NOT NULL,
  `token_valid_until` datetime DEFAULT NULL,
  `token_revoked` datetime DEFAULT NULL,
  `token_revoked_by` int(11) DEFAULT NULL,
  `token_remark` varchar(1024) DEFAULT NULL,
  `token_updated` datetime DEFAULT NULL,
  `token_updated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`token_id`),
  KEY `egw_tokens_account_id` (`account_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker`
--

CREATE TABLE `egw_tracker` (
  `tr_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_summary` varchar(80) NOT NULL,
  `tr_tracker` int(11) NOT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `tr_version` int(11) DEFAULT NULL,
  `tr_status` int(11) DEFAULT '-100',
  `tr_description` longtext,
  `tr_private` smallint(6) NOT NULL DEFAULT '0',
  `tr_budget` decimal(20,2) DEFAULT NULL,
  `tr_completion` smallint(6) DEFAULT '0',
  `tr_creator` int(11) NOT NULL,
  `tr_created` bigint(20) NOT NULL,
  `tr_modifier` int(11) DEFAULT NULL,
  `tr_modified` bigint(20) DEFAULT NULL,
  `tr_closed` bigint(20) DEFAULT NULL,
  `tr_priority` smallint(6) DEFAULT '5',
  `tr_resolution` int(11) DEFAULT NULL,
  `tr_cc` text,
  `tr_group` int(11) DEFAULT NULL,
  `tr_edit_mode` varchar(5) DEFAULT 'ascii',
  `tr_seen` text,
  `tr_startdate` bigint(20) DEFAULT NULL,
  `tr_duedate` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`tr_id`),
  KEY `egw_tracker_tr_summary` (`tr_summary`),
  KEY `egw_tracker_tr_tracker` (`tr_tracker`),
  KEY `egw_tracker_tr_version` (`tr_version`),
  KEY `egw_tracker_tr_status` (`tr_status`),
  KEY `egw_tracker_tr_resolution` (`tr_resolution`),
  KEY `egw_tracker_tr_group` (`tr_group`),
  KEY `egw_tracker_cat_id_tr_status` (`cat_id`,`tr_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_assignee`
--

CREATE TABLE `egw_tracker_assignee` (
  `tr_id` int(11) NOT NULL,
  `tr_assigned` int(11) NOT NULL,
  PRIMARY KEY (`tr_id`,`tr_assigned`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_bounties`
--

CREATE TABLE `egw_tracker_bounties` (
  `bounty_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_id` int(11) NOT NULL,
  `bounty_creator` int(11) NOT NULL,
  `bounty_created` bigint(20) NOT NULL,
  `bounty_amount` decimal(20,2) NOT NULL,
  `bounty_name` varchar(64) DEFAULT NULL,
  `bounty_email` varchar(128) DEFAULT NULL,
  `bounty_confirmer` int(11) DEFAULT NULL,
  `bounty_confirmed` bigint(20) DEFAULT NULL,
  `bounty_payedto` varchar(128) DEFAULT NULL,
  `bounty_payed` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`bounty_id`),
  KEY `egw_tracker_bounties_tr_id` (`tr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_escalated`
--

CREATE TABLE `egw_tracker_escalated` (
  `tr_id` int(11) NOT NULL,
  `esc_id` int(11) NOT NULL,
  `esc_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `match_count` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`tr_id`,`esc_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_escalations`
--

CREATE TABLE `egw_tracker_escalations` (
  `esc_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_tracker` varchar(55) NOT NULL DEFAULT '0',
  `cat_id` varchar(55) NOT NULL DEFAULT '0',
  `tr_version` varchar(55) NOT NULL DEFAULT '0',
  `tr_status` varchar(255) NOT NULL DEFAULT '0',
  `tr_priority` varchar(55) NOT NULL DEFAULT '0',
  `esc_title` varchar(128) NOT NULL,
  `esc_time` int(11) NOT NULL,
  `esc_type` tinyint(4) NOT NULL DEFAULT '0',
  `esc_tr_assigned` varchar(255) DEFAULT NULL,
  `esc_add_assigned` tinyint(4) DEFAULT NULL,
  `esc_tr_tracker` int(11) DEFAULT NULL,
  `esc_cat_id` int(11) DEFAULT NULL,
  `esc_tr_version` int(11) DEFAULT NULL,
  `esc_tr_status` int(11) DEFAULT NULL,
  `esc_tr_priority` int(11) DEFAULT NULL,
  `esc_reply_message` text,
  `esc_reply_visible` tinyint(4) DEFAULT NULL,
  `esc_match_repeat` int(11) DEFAULT '0',
  `esc_notify` varchar(15) DEFAULT NULL,
  `esc_limit` tinyint(4) DEFAULT NULL,
  `tr_resolution` varchar(55) NOT NULL,
  `esc_run_on_existing` tinyint(4) NOT NULL DEFAULT '1',
  `esc_tr_resolution` tinyint(4) NOT NULL DEFAULT '1',
  `esc_tr_duedate` text,
  PRIMARY KEY (`esc_id`),
  UNIQUE KEY `egw_tracker_escalations_esc_time_esc_type` (`esc_time`,`esc_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_extra`
--

CREATE TABLE `egw_tracker_extra` (
  `tr_id` int(11) NOT NULL,
  `tr_extra_name` varchar(64) NOT NULL,
  `tr_extra_value` text,
  PRIMARY KEY (`tr_id`,`tr_extra_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_replies`
--

CREATE TABLE `egw_tracker_replies` (
  `reply_id` int(11) NOT NULL AUTO_INCREMENT,
  `tr_id` int(11) NOT NULL,
  `reply_creator` int(11) NOT NULL,
  `reply_created` bigint(20) NOT NULL,
  `reply_message` longtext,
  `reply_visible` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`reply_id`),
  KEY `egw_tracker_replies_reply_visible` (`reply_visible`),
  KEY `egw_tracker_replies_tr_id_reply_created` (`tr_id`,`reply_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_tracker_votes`
--

CREATE TABLE `egw_tracker_votes` (
  `tr_id` int(11) NOT NULL,
  `vote_uid` int(11) NOT NULL,
  `vote_ip` varchar(128) NOT NULL,
  `vote_time` bigint(20) NOT NULL,
  PRIMARY KEY (`tr_id`,`vote_uid`,`vote_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_zpush_settings`
--

CREATE TABLE `egw_zpush_settings` (
  `key_name` varchar(50) CHARACTER SET ascii NOT NULL,
  `key_value` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`key_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `egw_zpush_states`
--

CREATE TABLE `egw_zpush_states` (
  `id_state` int(11) NOT NULL AUTO_INCREMENT,
  `device_id` varchar(50) CHARACTER SET ascii NOT NULL,
  `uuid` varchar(50) CHARACTER SET ascii DEFAULT NULL,
  `state_type` varchar(50) CHARACTER SET ascii DEFAULT NULL,
  `counter` int(11) DEFAULT NULL,
  `state_data` longblob,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id_state`),
  UNIQUE KEY `egw_zpush_states_device_id_uuid_state_type_counter` (`device_id`,`uuid`,`state_type`,`counter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `egw_zpush_users`
--

CREATE TABLE `egw_zpush_users` (
  `username` varchar(50) NOT NULL,
  `device_id` varchar(50) CHARACTER SET ascii NOT NULL,
  UNIQUE KEY `egw_zpush_users_username_device_id` (`username`,`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
