import { a6 as Et2Widget, a7 as card_default, a8 as shoelace, M as i, a9 as HasSlotController, a as egw$1, i as interact, b as etemplate2, Q as x, c as Et2Dialog, H as et2_IResizeable, U as o, aa as Et2Favorites, h as et2_createWidget, ab as o$1, V as A, ac as c, E as EgwApp, a0 as loadWebComponent } from '../../chunks/etemplate2-0373054a.js';
import '../../chunks/egw_json-39123901.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

var _templateObject$6, _templateObject2$4, _templateObject3$1, _templateObject4$1, _templateObject5$1;
function _taggedTemplateLiteral$6(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function ownKeys$1(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1(Object(t), !0).forEach(function (r) { _defineProperty$2(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$2(e, r, t) { return (r = _toPropertyKey$2(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2(t) { var i = _toPrimitive$2(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Participate in Home
 */

class Et2Portlet extends Et2Widget(card_default) {
  static get properties() {
    return _objectSpread$1(_objectSpread$1({}, super.properties), {}, {
      /**
       * Give a title
       * Goes in the header at the top with the icons
       */
      title: {
        type: String
      },
      /**
       * Custom etemplate used to customize / set up the portlet
       */
      editTemplate: {
        type: String
      },
      /**
       * Set the portlet color
       */
      color: {
        type: String
      },
      /**
       * Array of customization settings, similar in structure to preference settings
       */
      settings: {
        type: Object
      },
      actions: {
        type: Object
      }
    });
  }
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$6 || (_templateObject$6 = _taggedTemplateLiteral$6(["\n\t\t\t  :host {\n\t\t\t\t--header-spacing: var(--sl-spacing-medium);\n\t\t\t  }\n\n\t\t\t  .portlet__header {\n\t\t\t\tflex: 0 0 auto;\n\t\t\t\tdisplay: flex;\n\t\t\t\tfont-style: inherit;\n\t\t\t\tfont-variant: inherit;\n\t\t\t\tfont-weight: inherit;\n\t\t\t\tfont-stretch: inherit;\n\t\t\t\tfont-family: inherit;\n\t\t\t\tfont-size: var(--sl-font-size-medium);\n\t\t\t\tline-height: var(--sl-line-height-dense);\n\t\t\t\tpadding: 0px;\n\t\t\t\tpadding-left: 0px;\n\t\t\t\tmargin: 0px;\n\t\t\t\tposition: relative;\n\t\t\t  }\n\n\t\t\t  .portlet__title {\n\t\t\t\tflex: 1 1 auto;\n\t\t\t\tfont-size: var(--sl-font-size-medium);\n\t\t\t\tuser-select: none;\n\t\t\t  }\n\n\t\t\t  .portlet__header .portlet__settings-icon {\n\t\t\t\tdisplay: none;\n\t\t\t  }\n\n\t\t\t  .portlet__header:hover .portlet__settings-icon {\n\t\t\t\tdisplay: initial;\n\t\t\t  }\n\n\t\t\t  .portlet__header #settings {\n\t\t\t\tposition: absolute;\n\t\t\t\tright: 0px;\n\t\t\t  }\n\n\t\t\t  .card {\n\t\t\t\twidth: 100%;\n\t\t\t\theight: 100%\n\t\t\t  }\n\n\t\t\t  .card__header {\n\t\t\t\tdisplay: flex;\n\t\t\t\twidth: 100%;\n\t\t\t\tpadding: 0px;\n\t\t\t\tpadding-left: var(--sl-spacing-medium);\n\t\t\t\tpadding-right: calc(2em + var(--header-spacing));\n\t\t\t  }\n\n\t\t\t  .card__body {\n\t\t\t\t/* display block to prevent overflow from our size */\n\t\t\t\tdisplay: block;\n\t\t\t\toverflow: hidden;\n\n\t\t\t\tflex: 1 1 auto;\n\t\t\t\tpadding: 0px;\n\t\t\t  }\n\n\n\t\t\t  ::slotted(div) {\n\t\t\t  }\n\t\t\t"])))];
  }
  constructor() {
    super();
    _defineProperty$2(this, "hasSlotController", new HasSlotController(this, 'footer', 'header', 'image'));
    this.editTemplate = egw$1.webserverUrl + "/home/templates/default/edit.xet";
    this.actions = {};
    this._onMoveResize = this._onMoveResize.bind(this);
    this._onMoveResizeEnd = this._onMoveResizeEnd.bind(this);
  }
  connectedCallback() {
    super.connectedCallback();
    Promise.all([/* any others here...*/this.updateComplete]).then(() => this._setupMoveResize());
  }

  /**
   * Load further details from content
   *
   * Normal load & attribute assign will cast our settings object to a string
   * @param _template_node
   */
  transformAttributes(attrs) {
    // Pull out width - super will handle it wrong then remove it
    var width;
    if (typeof attrs.width != "undefined") {
      width = attrs.width;
      delete attrs.width;
    }
    super.transformAttributes(attrs);

    // If width was provided, put it back
    if (typeof width != "undefined") {
      attrs.width = width;
    }
    var data = this.getArrayMgr("content").data.find(e => e.id && e.id == this.id) || {};
    this.settings = typeof attrs.settings == "string" ? data.value || data.settings || {} : attrs.settings;

    // Set size & position, if available
    // NB: initial load can't find them by entry in array mgr, we check the data directly
    if (attrs.row || attrs.height || data.row || data.height) {
      this.style.gridRow = (attrs.row || data.row || "auto") + " / span " + (attrs.height || data.height || this.constructor.DEFAULT_HEIGHT);
    }
    if (attrs.col || attrs.width || data.col || data.width) {
      this.style.gridColumn = (attrs.col || data.col || "auto") + " / span " + (attrs.width || data.width || this.constructor.DEFAULT_WIDTH);
    }
  }

  /**
   * Overriden from parent to add in default actions
   */
  set_actions(actions) {
    // Set targets for actions
    var defaults = {};
    for (var action_name in Et2Portlet.default_actions) {
      defaults[action_name] = Et2Portlet.default_actions[action_name];
      // Translate caption here, as translations aren't available earlier
      defaults[action_name].caption = this.egw().lang(Et2Portlet.default_actions[action_name].caption);
      if (typeof this[action_name] == "function") {
        defaults[action_name].onExecute = this[action_name].bind(this);
      }
    }

    // Add in defaults, but let provided actions override them
    this.actions = jQuery.extend(true, {}, defaults, actions);
  }

  /**
   * Set up moving & resizing
   */
  _setupMoveResize() {
    // Quick calculation of min size - dialog is made up of header, content & buttons
    var minHeight = 0;
    for (var e of this.children) {
      minHeight += e.getBoundingClientRect().height + parseFloat(getComputedStyle(e).marginTop) + parseFloat(getComputedStyle(e).marginBottom);
    }

    // Get parent's dimensions
    var style = getComputedStyle(this.parentElement);
    var parentDimensions = {
      width: parseInt(style.gridAutoColumns) + parseInt(style.gap) || HomeApp.GRID,
      height: parseInt(style.gridAutoRows) + parseInt(style.gap) || HomeApp.GRID
    };
    var gridTarget = interact.snappers.grid({
      x: parentDimensions.width,
      y: parentDimensions.height
    });
    interact(this).resizable({
      edges: {
        bottom: true,
        right: true
      },
      listeners: {
        move: this._onMoveResize,
        end: this._onMoveResizeEnd
      },
      modifiers: [
      // Snap to grid
      interact.modifiers.snap({
        targets: [gridTarget],
        offset: "startCoords",
        limits: {
          top: 0,
          left: 0
        }
      }),
      // keep the edges inside the parent
      interact.modifiers.restrictEdges({
        outer: 'parent'
      })]
    }).draggable({
      allowFrom: ".portlet__header",
      autoScroll: true,
      listeners: {
        move: this._onMoveResize,
        end: this._onMoveResizeEnd
      },
      modifiers: [
      // Restrict interferes with grid making it act strangely
      //interact.modifiers.restrict({
      //	restriction: 'parent'
      //}),
      // Snap to grid
      interact.modifiers.snap({
        targets: [gridTarget],
        offset: "startCoords",
        limits: {
          top: 0,
          left: 0
        }
      })]
    });
  }

  /**
   * Handle moving and resizing
   *
   * @param event
   */
  _onMoveResize(event) {
    var target = event.target;
    var x = (parseFloat(target.getAttribute('data-x')) || 0) + (event.deltaRect ? 0 : event.dx);
    var y = (parseFloat(target.getAttribute('data-y')) || 0) + (event.deltaRect ? 0 : event.dy);

    // update the element's style
    // Size
    target.style.width = event.rect.width + 'px';
    target.style.height = event.rect.height + 'px';

    // Position
    target.style.transform = 'translate(' + x + 'px,' + y + 'px)';
    target.setAttribute('data-x', x);
    target.setAttribute('data-y', y);
  }

  /**
   * Move or resize has completed.  Now into parent grid and update settings.
   *
   * @param {InteractEvent} event
   */
  _onMoveResizeEnd(event) {
    var _event$deltaRect, _event$deltaRect2, _etemplate2$getById;
    // Get parent's dimensions
    var style = getComputedStyle(this.parentElement);
    var parentDimensions = {
      x: parseInt(style.gridAutoColumns) || 1,
      y: parseInt(style.gridAutoRows) || 1
    };
    var target = event.target;
    var dx = Math.round((parseInt(target.getAttribute('data-x')) || 0) / parentDimensions.x);
    var dy = Math.round((parseInt(target.getAttribute('data-y')) || 0) / parentDimensions.y);
    var dwidth = Math.round((((_event$deltaRect = event.deltaRect) === null || _event$deltaRect === void 0 ? void 0 : _event$deltaRect.width) || 1) / parentDimensions.x);
    var dheight = Math.round((((_event$deltaRect2 = event.deltaRect) === null || _event$deltaRect2 === void 0 ? void 0 : _event$deltaRect2.height) || 1) / parentDimensions.y);
    var [o_x, o_width] = this.style.gridColumn.split(" / span");
    var [o_y, o_height] = this.style.gridRow.split(" / span");

    // Clear temp stuff from moving
    target.style.transform = "";
    target.style.width = "";
    target.style.height = "";
    target.removeAttribute('data-x');
    target.removeAttribute('data-y');
    if (o_x == "auto") {
      o_x = "" + (1 + Math.round((this.getBoundingClientRect().left - this.parentElement.getBoundingClientRect().left) / parentDimensions.x));
    }
    var col = Math.max(1, dx + (parseInt(o_x) || 0));
    var row = Math.max(1, dy + (parseInt(o_y) || 0));
    var width = dwidth + parseInt(o_width) || 1;
    var height = dheight + parseInt(o_height) || 1;

    // Set grid position
    target.style.gridArea = row + " / " + col + "/ span " + height + " / span " + width;

    // Update position settings
    this.update_settings({
      row: row,
      col: col,
      width: width,
      height: height
    });

    // If there's a full etemplate living inside, make it resize
    (_etemplate2$getById = etemplate2.getById(this.id)) === null || _etemplate2$getById === void 0 || _etemplate2$getById.resize();
  }
  imageTemplate() {
    return '';
  }
  headerTemplate() {
    return x(_templateObject2$4 || (_templateObject2$4 = _taggedTemplateLiteral$6(["\n            <h2 class=\"portlet__title\">", "</h2>"])), this.title);
  }
  bodyTemplate() {
    return x(_templateObject3$1 || (_templateObject3$1 = _taggedTemplateLiteral$6([""])));
  }
  footerTemplate() {
    return x(_templateObject4$1 || (_templateObject4$1 = _taggedTemplateLiteral$6([""])));
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [{
      name: 'color',
      label: "Color",
      type: 'et2-colorpicker'
    }];
  }

  /**
   * Create & show a dialog for customizing this portlet
   *
   * Properties for customization are sent in the 'settings' attribute
   */
  edit_settings() {
    var content = this.portletProperties;

    // Add values, but skip any duplicate properties
    Object.keys(this.settings || {}).forEach(k => {
      if (typeof k == "string" && isNaN(parseInt(k)) || content.filter(v => v.name == this.settings[k].name).length == 0) {
        content[k] = this.settings[k];
      }
    });
    var dialog = new Et2Dialog(this.egw());
    dialog.transformAttributes({
      callback: this._process_edit.bind(this),
      template: this.editTemplate,
      value: {
        content: content
      },
      buttons: [{
        "button_id": Et2Dialog.OK_BUTTON,
        label: this.egw().lang('ok'),
        id: 'dialog[ok]',
        image: 'check',
        "default": true
      }, {
        label: this.egw().lang('delete'),
        id: 'delete',
        image: 'delete',
        align: "right"
      }, {
        "button_id": Et2Dialog.CANCEL_BUTTON,
        label: this.egw().lang('cancel'),
        id: 'cancel',
        image: 'cancel'
      }]
    });
    // Set separately to avoid translation
    dialog.title = this.egw().lang("Edit") + " " + (this.title || '');
    this.appendChild(dialog);
  }
  _process_edit(button_id, value) {
    if (button_id != Et2Dialog.OK_BUTTON) {
      if (button_id == "delete") {
        this.update_settings('~remove~').then(() => {
          this.remove();
        });
      }
      return;
    }

    // Keep settings, but remove any properties, no need to pass those on
    var settings = {};
    Object.keys(this.settings || {}).forEach(k => {
      if (typeof k == "string" && isNaN(parseInt(k)) || typeof this.settings[k].name == "undefined" && typeof this.settings[k].type == "undefined") {
        settings[k] = this.settings[k];
      }
    });
    // Pass updated settings, unless we're removing
    this.update_settings(_objectSpread$1(_objectSpread$1({}, settings), value));

    // Extend, not replace, because settings has types while value has just value
    if (typeof value == 'object') {
      this.settings = _objectSpread$1(_objectSpread$1({}, settings), value);
    }
    this.requestUpdate();
  }
  update_settings(settings) {
    // Skip any updates during loading
    if (this.getInstanceManager() && !this.getInstanceManager().isReady) {
      return Promise.resolve();
    }

    // We can set some things immediately, server will overwrite if it doesn't like them
    this.portletProperties.forEach(p => {
      if (typeof settings[p.name] != "undefined") {
        this[p.name] = settings[p.name];
      }
    });

    // Save settings - server might reply with new content if the portlet needs an update,
    // but ideally it doesn't
    this.classList.add("loading");
    return this.egw().request("home.home_ui.ajax_set_properties", [this.id, [], settings, this.settings ? this.settings.group : false]).then(data => {
      // This section not for us
      if (!data || typeof data.attributes == 'undefined') {
        return false;
      }
      this.classList.remove("loading");
      this.transformAttributes(data.attributes);

      // Flagged as needing to edit settings?  Open dialog
      if (typeof data.edit_settings != 'undefined' && data.edit_settings) {
        this.edit_settings();
      }

      // Only resize once, and only if needed
      if (data.attributes.width || data.attributes.height) {
        // Tell children
        try {
          this.iterateOver(function (widget) {
            if (typeof widget.resize === 'function') {
              widget.resize();
            }
          }, null, et2_IResizeable);
        } catch (e) {
          // Something went wrong, but do not stop
          this.egw().debug('warn', e, this);
        }
      }
    });
  }
  render() {
    return x(_templateObject5$1 || (_templateObject5$1 = _taggedTemplateLiteral$6(["\n            <style>\n                ", "\n            </style>\n            <div\n                    part=\"base\"\n                    class=", "\n            >\n                <slot name=\"image\" part=\"image\" class=\"card__image\">", "</slot>\n\n                <header class=\"portlet__header\">\n                    <slot name=\"header\" part=\"header\" class=\"card__header\">", "</slot>\n                    <sl-icon-button id=\"settings\" name=\"gear\" label=\"Settings\" class=\"portlet__settings-icon\"\n                                    @click=\"", "\">\n                    </sl-icon-button>\n                </header>\n                <slot part=\"body\" class=\"card__body\">", "</slot>\n                <slot name=\"footer\" part=\"footer\" class=\"card__footer\">", "</slot>\n            </div>\n\t\t"])), this.color ? ".card  {--border-color: " + this.color + "}" : "", o({
      card: true,
      'card--has-footer': this.hasSlotController.test('footer'),
      'card--has-image': this.hasSlotController.test('image'),
      'card--has-header': true,
      'et2-portlet': true
    }), this.imageTemplate(), this.headerTemplate(), () => this.edit_settings(), this.bodyTemplate(), this.footerTemplate());
  }
}
/**
 * These are the "normal" actions that every portlet is expected to have.
 * The widget provides default actions for all of these, but they can
 * be added to or overridden if needed by setting the action attribute.
 */
_defineProperty$2(Et2Portlet, "default_actions", {
  edit_settings: {
    icon: "edit",
    caption: "Configure",
    "default": true,
    hideOnDisabled: true,
    group: "portlet"
  },
  remove_portlet: {
    icon: "delete",
    caption: "Remove",
    group: "portlet"
  }
});
_defineProperty$2(Et2Portlet, "DEFAULT_WIDTH", 2);
_defineProperty$2(Et2Portlet, "DEFAULT_HEIGHT", 2);
if (!customElements.get("et2-portlet")) {
  customElements.define("et2-portlet", Et2Portlet);
}

var _templateObject$5, _templateObject2$3;
function _taggedTemplateLiteral$5(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
class Et2PortletFavorite extends Et2Portlet {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$5 || (_templateObject$5 = _taggedTemplateLiteral$5(["\n\t\t\t  .portlet__header et2-button {\n\t\t\t\tvisibility: hidden;\n\t\t\t  }\n\n\t\t\t  .portlet__header:hover et2-button {\n\t\t\t\tvisibility: visible;\n\t\t\t  }\n\t\t\t"])))];
  }
  constructor() {
    super();
    this.toggleHeader = this.toggleHeader.bind(this);
  }
  connectedCallback() {
    super.connectedCallback();
    this.classList.add("header_hidden");
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [...super.portletProperties, {
      name: "favorite",
      type: "et2-select",
      label: "Favorite",
      select_options: this.favorites
    }];
  }
  get favorites() {
    var _this$settings;
    // Default blank filter
    var favorites = [{
      value: 'blank',
      label: this.egw().lang("No filters"),
      favorite: {}
    }];

    // Load favorites
    if ((_this$settings = this.settings) !== null && _this$settings !== void 0 && _this$settings.appname) {
      var preferences = this.egw().preference("*", this.settings.appname);
      for (var pref_name in preferences) {
        if (pref_name.indexOf(Et2Favorites.PREFIX) == 0 && typeof preferences[pref_name] == 'object') {
          var name = pref_name.substr(Et2Favorites.PREFIX.length);
          favorites.push({
            value: name,
            label: preferences[pref_name]['name'],
            favorite: preferences[pref_name]
          });
        }
      }
    }
    return favorites;
  }

  /**
   * Overridden so we can just apply the favorite to the nm
   *
   * @param button_id
   * @param value
   */
  _process_edit(button_id, value) {
    if (button_id == Et2Dialog.OK_BUTTON && value.favorite != this.settings.favorite) {
      var _this$favorites$find;
      var state = ((_this$favorites$find = this.favorites.find(f => f.value == value.favorite)) === null || _this$favorites$find === void 0 ? void 0 : _this$favorites$find.favorite) || {};
      if (this.nm && typeof state == "object") {
        // Firefox has trouble with spaces in search
        if (state.state && state.state.search) {
          state.state.search = unescape(state.state.search);
        }

        // Apply
        if (state.state && state.state.sort && state.state.sort.id) {
          this.nm.sortBy(state.state.sort.id, state.state.sort.asc, false);
        } else {
          // Not using resetSort() to avoid the extra applyFilters() call
          this.nm.sortBy(undefined, undefined, false);
        }
        if (state.state && state.state.selectcols) {
          // Make sure it's a real array, not an object, then set cols
          this.nm.set_columns(jQuery.extend([], state.state.selectcols));
        }
        this.nm.applyFilters(state.state || state.filter || {});
      }
    }
    super._process_edit(button_id, value);
  }

  /**
   * Override parent to force resize on initial load
   * @param settings
   * @returns {Promise<void> | Promise<boolean>}
   */
  update_settings(settings) {
    return super.update_settings(settings).then(result => {
      if (!this.nm) {
        // If child was added recently (not loaded in normal reload), resize them all
        etemplate2.getByTemplate("home.favorite").forEach(et => et.resize(undefined));
      }
      return result;
    });
  }
  headerTemplate() {
    var hidden = this.classList.contains("header_hidden");
    return x(_templateObject2$3 || (_templateObject2$3 = _taggedTemplateLiteral$5(["", "\n        <et2-button-icon id=\"header_toggle\" slot=\"header\"\n                         name=\"", "\"\n                         class=", "\n                         noSubmit=true\n                         @click=", "\n        ></et2-button-icon>\n\t\t"])), super.headerTemplate(), hidden ? "chevron-down" : "chevron-up", o({
      hidden: hidden
    }), this.toggleHeader);
  }
  get nm() {
    return this.getWidgetById('nm') || etemplate2.getById(this.id) && etemplate2.getById(this.id).widgetContainer.getWidgetById('nm') || false;
  }
  toggleHeader() {
    //widget.set_class(widget.class == 'opened' ? 'closed' : 'opened');
    // We operate on the DOM here, nm should be unaware of our fiddling
    var nm = this.nm;
    if (!nm) {
      return;
    }

    // Hide header
    nm.div.toggleClass('header_hidden');
    nm.set_hide_header(nm.div.hasClass('header_hidden'));
    nm.resize();

    // Toggle class that changes everything
    this.classList.toggle("header_hidden");
    this.requestUpdate();
  }
}
if (!customElements.get("et2-portlet-favorite")) {
  customElements.define("et2-portlet-favorite", Et2PortletFavorite);
}

var _templateObject$4;
function _taggedTemplateLiteral$4(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Home portlet to show a list of entries
 */
class Et2PortletLink extends Et2Portlet {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$4 || (_templateObject$4 = _taggedTemplateLiteral$4(["\n\t\t\t"])))];
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [...super.portletProperties, {
      name: "entry",
      type: "et2-link-entry",
      label: "Entry"
    }];
  }
  _process_edit(button_id, value) {
    if (button_id == Et2Dialog.OK_BUTTON && value.entry && value.entry != this.settings.entry) {
      // Update title with new app immediately
      this.title = this.egw().lang(value.entry.app);
    }
    super._process_edit(button_id, value);
  }
}
if (!customElements.get("et2-portlet-link")) {
  customElements.define("et2-portlet-link", Et2PortletLink);
}

var _templateObject$3, _templateObject2$2;
function _taggedTemplateLiteral$3(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Home portlet to show a list of entries
 */
class Et2PortletList extends Et2Portlet {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$3 || (_templateObject$3 = _taggedTemplateLiteral$3(["\n\t\t\t  .delete_button {\n\t\t\t\tpadding-right: 10px;\n\t\t\t  }\n\t\t\t"])))];
  }
  constructor() {
    super();
    this.link_change = this.link_change.bind(this);
  }

  /**
   * For list_portlet - opens a dialog to add a new entry to the list
   *
   * @param {egwAction} action Drop or add action
   * @param {egwActionObject[]} Selected entries
   * @param {egwActionObject} target_action Drop target
   */
  add_link(action, source, target_action) {
    // TODO
    debugger;

    // Actions got confused drop vs popup
    if (source[0].id == 'portlets') {
      return this.add_link(action);
    }

    // Get widget
    var widget = null;
    while (action.parent != null) {
      if (action.data && action.data.widget) {
        widget = action.data.widget;
        break;
      }
      action = action.parent;
    }
    if (target_action == null) {
      // use template base url from initial template, to continue using webdav, if that was loaded via webdav
      var splitted = 'home.edit'.split('.');
      var path = app.home.portlet_container.getRoot()._inst.template_base_url + splitted.shift() + "/templates/default/" + splitted.join('.') + ".xet";
      var dialog = et2_createWidget("dialog", {
        callback: function callback(button_id, value) {
          if (button_id == Et2Dialog.CANCEL_BUTTON) {
            return;
          }
          var new_list = widget.options.settings.list || [];
          for (var i = 0; i < new_list.length; i++) {
            if (new_list[i].app == value.add.app && new_list[i].id == value.add.id) {
              // Duplicate - skip it
              return;
            }
          }
          value.add.link_id = value.add.app + ':' + value.add.id;
          // Update server side
          new_list.push(value.add);
          widget._process_edit(button_id, {
            list: new_list
          });
          // Update client side
          var list = widget.getWidgetById('list');
          if (list) {
            list.set_value(new_list);
          }
        },
        buttons: Et2Dialog.BUTTONS_OK_CANCEL,
        title: app.home.egw.lang('add'),
        template: path,
        value: {
          content: [{
            label: app.home.egw.lang('add'),
            type: 'link-entry',
            name: 'add',
            size: ''
          }]
        }
      });
    } else {
      // Drag'n'dropped something on the list - just send action IDs
      var new_list = widget.options.settings.list || [];
      var changed = false;
      for (var i = 0; i < new_list.length; i++) {
        // Avoid duplicates
        for (var j = 0; j < source.length; j++) {
          if (!source[j].id || new_list[i].app + "::" + new_list[i].id == source[j].id) {
            // Duplicate - skip it
            source.splice(j, 1);
          }
        }
      }
      for (var _i = 0; _i < source.length; _i++) {
        var explode = source[_i].id.split('::');
        new_list.push({
          app: explode[0],
          id: explode[1],
          link_id: explode.join(':')
        });
        changed = true;
      }
      if (changed) {
        widget._process_edit(Et2Dialog.OK_BUTTON, {
          list: new_list || {}
        });
      }
      // Filemanager support - links need app = 'file' and type set
      for (var _i2 = 0; _i2 < new_list.length; _i2++) {
        if (new_list[_i2]['app'] == 'filemanager') {
          new_list[_i2]['app'] = 'file';
          new_list[_i2]['path'] = new_list[_i2]['title'] = new_list[_i2]['icon'] = new_list[_i2]['id'];
        }
      }
      widget.getWidgetById('list').set_value(new_list);
    }
  }

  /**
   * Remove a link from the list
   */
  link_change(event) {
    var _this$getInstanceMana;
    if (!((_this$getInstanceMana = this.getInstanceManager()) !== null && _this$getInstanceMana !== void 0 && _this$getInstanceMana.isReady)) {
      return;
    }

    // Not used, but delete puts link in event.data
    var link_data = event.data || false;

    // Update settings on link delete
    if (link_data) {
      this.update_settings({
        list: this.settings.list
      });
    }
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [...super.portletProperties, {
      name: "title",
      type: "et2-textbox",
      label: "Title"
    }, {
      name: "add",
      type: "et2-link-entry",
      label: "Add"
    }];
  }
  _process_edit(button_id, value) {
    if (button_id == Et2Dialog.OK_BUTTON && value.add) {
      // Add in to list, remove from value or it will be saved
      value.list = [...this.settings.list, value.add];
      delete value.add;
    }
    super._process_edit(button_id, value);
  }
  bodyTemplate() {
    var _this$settings;
    return x(_templateObject2$2 || (_templateObject2$2 = _taggedTemplateLiteral$3(["\n            <et2-link-list .value=", "\n                           @change=", "\n            >\n            </et2-link-list>"])), ((_this$settings = this.settings) === null || _this$settings === void 0 ? void 0 : _this$settings.list) || [], this.link_change);
  }
}
if (!customElements.get("et2-portlet-list")) {
  customElements.define("et2-portlet-list", Et2PortletList);
}

var _templateObject$2, _templateObject2$1;
function _taggedTemplateLiteral$2(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Home portlet to show a note
 */
class Et2PortletNote extends Et2Portlet {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$2 || (_templateObject$2 = _taggedTemplateLiteral$2(["\n\t\t\t  .delete_button {\n\t\t\t\tpadding-right: 10px;\n\t\t\t  }\n\t\t\t"])))];
  }
  constructor() {
    super();
    this.edit = this.edit.bind(this);
  }
  edit() {
    // CKEditor is impossible to use below a certain size
    // Add 35px for the toolbar, 35px for the buttons
    var window_width = Math.max(580, parseInt(getComputedStyle(this).width) + 20);
    var window_height = Math.max(350, parseInt(getComputedStyle(this).height) + 70);

    // Open popup, but add 70 to the height for the toolbar
    this.egw().open_link(this.egw().link('/index.php', {
      menuaction: 'home.home_note_portlet.edit',
      id: this.id,
      height: window_height - 70
    }), 'home_' + this.id, window_width + 'x' + window_height, 'home');
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [...super.portletProperties, {
      name: "title",
      type: "et2-textbox",
      label: "Title"
    }, {
      name: "note",
      type: "htmlarea",
      label: ""
    }];
  }
  bodyTemplate() {
    var _this$settings;
    return x(_templateObject2$1 || (_templateObject2$1 = _taggedTemplateLiteral$2(["\n            <div @dblclick=", ">\n                ", "\n            </div>\n\t\t"])), this.edit, o$1(((_this$settings = this.settings) === null || _this$settings === void 0 ? void 0 : _this$settings.note) || ""));
  }
}
if (!customElements.get("et2-portlet-note")) {
  customElements.define("et2-portlet-note", Et2PortletNote);
}

var _templateObject$1, _templateObject2, _templateObject3, _templateObject4, _templateObject5;
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty$1(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$1(e, r, t) { return (r = _toPropertyKey$1(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$1(t) { var i = _toPrimitive$1(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$1(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral$1(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Show current and forecast weather
 */
class Et2PortletWeather extends Et2Portlet {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject$1 || (_templateObject$1 = _taggedTemplateLiteral$1(["\n\t\t\t  .portlet--weather {\n\t\t\t\tdisplay: flex;\n\t\t\t  }\n\n\t\t\t  .day__forecast {\n\t\t\t\twidth: fit-content;\n\t\t\t\tmin-width: 12ex;\n\t\t\t\tmax-width: 20ex;\n\t\t\t  }\n\n\t\t\t  .temperature__day-label {\n\t\t\t\ttext-align: center;\n\t\t\t\tfont-size: 120%;\n\t\t\t\tpadding-bottom: var(--sl-spacing-medium);\n\t\t\t  }\n\n\t\t\t  .temperature {\n\t\t\t\tfont-size: 160%;\n\t\t\t  }\n\n\t\t\t  .temperature__high_low {\n\t\t\t  }\n\n\t\t\t  sl-icon {\n\t\t\t\tfont-size: 32px;\n\t\t\t  }\n\n\t\t\t  .portlet--weather .temperature__current {\n\t\t\t\t/* Make current day a little bigger */\n\t\t\t\tfont-size: 180%;\n\t\t\t\tpadding: var(--sl-spacing-large);\n\t\t\t  }\n\n\t\t\t  .temperature__current .day__forecast {\n\t\t\t\tpadding: var(--sl-spacing-medium) 0px;\n\t\t\t  }\n\n\t\t\t  :host([style*=\"span 1\"]) .temperature__current {\n\t\t\t\t/* No padding if portlet is small */\n\t\t\t\tpadding: 0px;\n\t\t\t  }\n\n\t\t\t  .portlet--weather .temperature__current sl-icon {\n\t\t\t\tfont-size: 250%;\n\t\t\t  }\n\n\t\t\t  .temperature__day-list {\n\t\t\t\tflex: 1 1 auto;\n\t\t\t\tdisplay: grid;\n\t\t\t\tgap: var(--sl-spacing-x-large) var(--sl-spacing-medium);\n\t\t\t\tgrid-template-columns: repeat(auto-fill, minmax(12ex, 1fr));\n\t\t\t\tpadding-top: var(--sl-spacing-large);\n\t\t\t  }\n\n\t\t\t  .temperature__day-list .weather__day-forecast {\n\t\t\t\tmin-height: 12ex;\n\t\t\t  }\n\t\t\t"])))];
  }

  /**
   * Get a list of user-configurable properties
   * @returns {[{name : string, type : string, select_options? : [SelectOption]}]}
   */
  get portletProperties() {
    return [...super.portletProperties, {
      'name': 'city',
      'type': 'et2-textbox',
      'label': this.egw().lang('Location')
    }
    /* Use size to control what we show
    {
    	name: "display", label: "Display", type: "et2-select", select_options: [
    		{'value': 'today', 'label': this.egw().lang('today')},
    		{'value': '3', 'label': this.egw().lang('%1 day', 3)},
    		{'value': '10', 'label': this.egw().lang('%1 day', 10)},
    	]
    }
    */];
  }

  /**
   * Template for one day of the forecast
   * @param day
   * @protected
   */
  forecastDayTemplate(day) {
    var _day$temp;
    return x(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral$1(["\n            <div class=\"weather__day-forecast\">\n                <et2-description class=\"temperature__day-label\" value=\"", "\"></et2-description>\n                <et2-hbox part=\"day\" class=\"day__forecast\">\n                    <sl-icon class=\"weather_icon\" name=\"", "\"></sl-icon>\n                    ", "\n                    <et2-vbox class=\"temperature__high_low\">\n                        <span class=\"temperature__max\">", "</span>\n                        <span class=\"temperature__min\">", "</span>\n                    </et2-vbox>\n                </et2-hbox>\n            </div>"])), day.day, day.weather[0].icon, typeof ((_day$temp = day.temp) === null || _day$temp === void 0 ? void 0 : _day$temp.temp) != "undefined" ? x(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral$1(["\n                        <et2-hbox class=\"temperature\">\n                            <span>", "</span>\n                        </et2-hbox>"])), day.temp.temp) : A, day.temp.max, day.temp.min);
  }
  bodyTemplate() {
    var _this$settings, _this$settings2;
    var doList = parseInt(getComputedStyle(this).width) > 300;
    var current = ((_this$settings = this.settings) === null || _this$settings === void 0 || (_this$settings = _this$settings.weather) === null || _this$settings === void 0 ? void 0 : _this$settings.current) || {
      weather: [{
        icon: "question-lg"
      }],
      temp: {
        temp: "?"
      }
    };

    // Get the forecast, excluding today
    var list = this.settings.weather && (Object.values(((_this$settings2 = this.settings) === null || _this$settings2 === void 0 || (_this$settings2 = _this$settings2.weather) === null || _this$settings2 === void 0 ? void 0 : _this$settings2.list) || {}).slice(1) || []) || [];
    return x(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral$1(["\n            <div\n                    part=\"base\"\n                    class=", "\n            >\n                <div part=\"current\" class=\"temperature__current\">\n                    ", "\n                </div>\n                ", "\n            </div>\n\t\t"])), o({
      portlet: true,
      "portlet--weather": true
    }), this.forecastDayTemplate(_objectSpread({}, _objectSpread({
      day: 'Today',
      // Current has a different data format
      temp: {
        min: current.temp.temp_min,
        max: current.temp.temp_max
      }
    }, current))), doList ? x(_templateObject5 || (_templateObject5 = _taggedTemplateLiteral$1(["\n                    <div part=\"list\" class=\"temperature__day-list\">\n                        ", "\n                    </div>"])), c(list, (item, index) => {
      return this.forecastDayTemplate(item);
    })) : A);
  }
}
if (!customElements.get("et2-portlet-weather")) {
  customElements.define("et2-portlet-weather", Et2PortletWeather);
}

var _templateObject;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 * Home portlet to show a note
 */
class Et2PortletCalendar extends Et2PortletFavorite {
  static get styles() {
    return [...shoelace, ...(super.styles || []), i(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n\n\t\t\t"])))];
  }
}
if (!customElements.get("et2-portlet-calendar")) {
  customElements.define("et2-portlet-calendar", Et2PortletCalendar);
}

function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * JS for home application
 *
 * Home is a collection of little bits of content (portlets) from the other applications.
 *
 * Uses Gridster for the grid layout
 * @see http://gridster.net
 * @augments AppJS
 */
class HomeApp extends EgwApp {
  /**
   * Constructor
   *
   */
  constructor() {
    // call parent
    super("home");
    // List of portlets
    _defineProperty(this, "portlets", {});
    _defineProperty(this, "portlet_container", void 0);
    _defineProperty(this, "sortable", void 0);
  }

  /**
   * Destructor
   */
  destroy() {
    delete this.et2;
    delete this.portlet_container;
    this.portlets = {};

    // call parent
    super.destroy(this.appname);

    // Make sure all other sub-etemplates in portlets are done
    if (this == window.app.home) {
      var others = etemplate2.getByApplication(this.appname);
      for (var i = 0; i < others.length; i++) {
        others[i].clear();
      }
    }
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} et2 Newly ready object
   * @param {string} Template name
   */
  et2_ready(et2, name) {
    // Top level
    if (name == 'home.index') {
      var _this$et2$getArrayMgr;
      // call parent
      super.et2_ready(et2, name);
      this.et2.actions = (_this$et2$getArrayMgr = this.et2.getArrayMgr('modifications').getEntry('home.index')['actions']) !== null && _this$et2$getArrayMgr !== void 0 ? _this$et2$getArrayMgr : [];
      this.portlet_container = this.et2.getWidgetById("portlets");
      var portlet_container = this.portlet_container.getDOMNode();
      et2.DOMContainer.parentElement.querySelectorAll("form[id*='portlet_'").forEach(et => {
        portlet_container.querySelector("[id$='" + et.id + "']").append(et);
      });
      this._do_ordering();
    } else if (et2.uniqueId) {
      var _window$app$home;
      var _portlet_container = this.portlet_container || ((_window$app$home = window.app.home) === null || _window$app$home === void 0 ? void 0 : _window$app$home.portlet_container);
      // Handle bad timing - a sub-template was finished first
      if (!_portlet_container) {
        window.setTimeout(() => {
          this.et2_ready(et2, name);
        }, 200);
        return;
      }
      var portlet = _portlet_container.getWidgetById(et2.uniqueId) || et2.DOMContainer;
      // Check for existing etemplate, this one loaded over it
      // NOTE: Moving them around like this can cause problems with event handlers
      var existing = etemplate2.getById(et2.uniqueId);
      if (portlet && existing) {
        for (var i = 0; i < portlet._children.length; i++) {
          if (typeof portlet._children[i]._init == 'undefined') {
            portlet.removeChild(portlet._children[i]);
          }
        }
      }
      // Set size & position, if somehow not set yet (Et2Portlet does it)
      if (portlet.style.gridArea == "") {
        var et2_data = et2.widgetContainer.getArrayMgr("content").data;
        var settings = et2_data && et2_data.id == portlet.id && et2_data || _portlet_container.getArrayMgr("content").data.find(e => et2.uniqueId.endsWith(e.id)) || {
          settings: {}
        };
        portlet.settings = settings.settings || {};
        portlet.style.gridArea = settings.row + "/" + settings.col + "/ span " + (settings.height || 1) + "/ span " + (settings.width || 1);
      }

      // Ordering of portlets
      // Only needs to be done once, but its hard to tell when everything is loaded
      this._do_ordering();
    }
  }

  /**
   * Observer method receives update notifications from all applications
   *
   * Home passes the notification off to specific code for each portlet, which
   * decide if they should be updated or not.
   *
   * @param {string} _msg message (already translated) to show, eg. 'Entry deleted'
   * @param {string} _app application name
   * @param {(string|number)} _id id of entry to refresh or null
   * @param {string} _type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {string} _msg_type 'error', 'warning' or 'success' (default)
   * @param {string} _targetapp which app's window should be refreshed, default current
   * @return {false|*} false to stop regular refresh, thought all observers are run
   */
  observer(_msg, _app, _id, _type, _msg_type, _targetapp) {
    for (var id in this.portlets) {
      // App is home, refresh all portlets
      if (_app == 'home') {
        this.refresh(id);
        continue;
      }

      // Ask the portlets if they're interested
      try {
        var code = this.portlets[id];
        if (code) {
          code.observer(_msg, _app, _id, _type, _msg_type, _targetapp);
        }
      } catch (e) {
        this.egw.debug("error", "Error trying to update portlet " + id, e);
      }
    }
    return false;
  }

  /**
   * Add a new portlet from the context menu
   */
  add(action, source) {
    // Basic portlet attributes
    var attrs = {
      id: this._create_id(),
      class: action.data.class,
      settings: {}
    };
    // Add extra data from action
    Object.keys(action.data).forEach(k => {
      if (["id", "type", "acceptedTypes", "class"].indexOf(k) == -1) {
        attrs["settings"][k] = action.data[k];
      }
    });

    // Try to put it about where the menu was opened
    if (action.menu_context) {
      var $portlet_container = jQuery(this.portlet_container.getDOMNode());
      attrs.row = Math.max(1, Math.round((action.menu_context.posy - $portlet_container.offset().top) / HomeApp.GRID) + 1);
      // Use "auto" col to avoid any overlap or overflow
      attrs.col = "auto";
    }
    var portlet = loadWebComponent(this.get_portlet_tag(action), attrs, this.portlet_container);
    portlet.loadingFinished();

    // Get actual attributes & settings, since they're not available client side yet
    portlet.update_settings(attrs).then(result => {
      // Initial add needs to wait for the update to come back, then ask about settings
      // Etemplate can conflict with portlet asking for settings
      if (result === false) {
        portlet.edit_settings();
      }
    });
  }

  /**
   * User dropped something on home.  Add a new portlet
   */
  add_from_drop(action, source) {
    // Actions got confused drop vs popup
    if (source[0].id == 'portlets') {
      return this.add(action);
    }
    var $portlet_container = jQuery(this.portlet_container.getDOMNode());

    // Basic portlet attributes
    var attrs = {
      id: this._create_id(),
      class: action.data.class || action.id.substr(5),
      dropped_data: []
    };

    // Try to find where the drop was
    if (action != null && action.ui && action.ui.position) {
      attrs.row = Math.max(1, Math.round((action.ui.position.top - $portlet_container.offset().top) / HomeApp.GRID));
      // Use "auto" col to avoid any overlap or overflow
      attrs.col = "auto";
    }

    // Get actual attributes & settings, since they're not available client side yet
    for (var i = 0; i < source.length; i++) {
      if (source[i].id) {
        attrs.dropped_data.push(source[i].id);
      } else {
        attrs.dropped_data.push(source[i].data);
      }
    }
    var portlet = loadWebComponent(this.get_portlet_tag(action), attrs, this.portlet_container);
    portlet.loadingFinished();

    // Get actual attributes & settings, since they're not available client side yet
    portlet.update_settings(attrs);
  }

  /**
   * Set the current selection as default for other users
   *
   * Only works (and available) for admins, this shows a dialog to select
   * the group, and then sets the default for that group.
   *
   * @param {egwAction} action
   * @param {egwActionObject[]} selected
   */
  set_default(action, selected) {
    // Gather just IDs, server will handle the details
    var portlet_ids = [];
    var group = action.data.portlet_group || false;
    if (selected[0].id == 'home.index') {
      // Set all
      this.portlet_container.iterateOver(function (portlet) {
        portlet_ids.push(portlet.id);
      }, this, et2_portlet);
    } else {
      for (var i = 0; i < selected.length; i++) {
        portlet_ids.push(selected[i].id);

        // Read the associated group so we can properly remove it
        var portlet = egw.preference(selected[i].id, 'home');
        if (!group && portlet && portlet.group) {
          group = portlet.group;
        }
      }
    }
    if (action.id.indexOf("remove_default") == 0) {
      // Disable action for feedback
      action.set_enabled(false);

      // Pass them to server
      egw.json('home_ui::ajax_set_default', ['delete', portlet_ids, group]).sendRequest(true);
      return;
    }
    var dialog = et2_createWidget("dialog", {
      // If you use a template, the second parameter will be the value of the template, as if it were submitted.
      callback: function callback(button_id, value) {
        if (button_id != Et2Dialog.OK_BUTTON) {
          return;
        }

        // Pass them to server
        egw.json('home_ui::ajax_set_default', ['add', portlet_ids, value.group || false]).sendRequest(true);
      },
      buttons: Et2Dialog.BUTTONS_OK_CANCEL,
      title: action.caption,
      template: "home.set_default",
      value: {
        content: {},
        sel_options: {
          group: {
            default: egw.lang('All'),
            forced: egw.lang('Forced')
          }
        }
      }
    });
  }

  /**
   * Allow a refresh from anywhere by triggering an update with no changes
   *
   * @param {string} id
   */
  refresh(id) {
    var p = this.portlet_container.getWidgetById(id);
    if (p) {
      p.update_settings('~reload~');
    }
  }

  /**
   * Determine the correct portlet type to use for the given action
   *
   * @param {egwAction} action
   */
  get_portlet_tag(action) {
    // Try to turn action ID into tag (eg: home_list_portlet -> et2-portlet-list)
    var tag = "et2-" + action.id.replace("add_", "").split("_").reverse().slice(0, -1).map(i => i.toLowerCase()).join("-");
    if (typeof customElements.get(tag) != "undefined") {
      return tag;
    }
    return "et2-portlet";
  }

  /**
   * Determine the best fitting code to use for the given portlet, instanciate
   * it and add it to the list.
   *
   * @param {et2_portlet} portlet
   * @returns {home_portlet}
   */
  _get_portlet_code(portlet) {
    var classname = portlet.class;
    // Freshly added portlets can have 'add_' prefix
    if (classname.indexOf('add_') == 0) {
      classname = classname.replace('add_', '');
    }
    // Prefer a specific match
    var _class = app.classes.home[classname] || (typeof customElements.get(classname) != "undefined" ? customElements.get(classname).class : false) || (
    // If it has a nextmatch, use favorite base class
    portlet.getWidgetById('nm') ? Et2PortletFavorite : false) ||
    // Fall back to base class
    Et2Portlet;
    this.portlets[portlet.id] = new _class(portlet);
    return this.portlets[portlet.id];
  }

  /**
   * For link_portlet - opens the configured record when the user
   * double-clicks or chooses view from the context menu
   */
  open_link(action) {
    // Get widget
    var widget = null;
    while (action.parent != null) {
      if (action.data && action.data.widget) {
        widget = action.data.widget;
        break;
      }
      action = action.parent;
    }
    if (widget == null) {
      this.egw.log("warning", "Could not find widget");
      return;
    }
    this.egw.open(widget.options.settings.entry, "", 'view', null, widget.options.settings.entry.app);
  }

  /**
   * Set up the positioning of portlets
   *
   * This handles portlets that may be offscreen because of wrong settings or changed screen size
   *
   */
  _do_ordering() {
    if (!this.portlet_container) {
      return;
    }

    // Check for column overflow
    var gridStyle = getComputedStyle(this.portlet_container.getDOMNode());
    var col_list = gridStyle.getPropertyValue("grid-template-columns").split(" ") || [];
    var gridWidth = parseInt(gridStyle.width);
    var maxColumn = Math.floor(gridWidth / (parseInt(col_list[0]) || 1));

    // Check for column overlap
    var col_map = {};
    var last_row = 0;
    this.portlet_container.getDOMNode().querySelectorAll("[style*='grid-area']").forEach(n => {
      var [row] = (getComputedStyle(n).gridRow || "").split(" / ");
      var colData = (getComputedStyle(n).gridColumn || "").split(" / span ");
      var col = parseInt(colData[0]);
      var span = parseInt(colData[1] || "1");
      if (parseInt(row) != last_row && typeof col_map[row] == "undefined") {
        last_row = parseInt(row);
        col_map[row] = {};
      }
      // If column is already occupied, or start off screen, or width pushes right side off screen
      if (typeof col_map[row][col] !== "undefined" || col > maxColumn || col + span > maxColumn) {
        if (col + span > maxColumn) {
          span = Math.max(1, Math.min(span, maxColumn - (parseInt(Object.keys(col_map[row]).at(-1)) || col)));
        }
        // Set column to auto to avoid overlap
        n.style.gridColumn = "auto / span " + span;
      }
      for (var i = col; i <= span; i++) {
        col_map[row][i] = true;
      }
    });
  }

  /**
   * Create an ID that should be unique, at least amoung a single user's portlets
   */
  _create_id() {
    var id = '';
    do {
      id = Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
    } while (this.portlet_container.getWidgetById('portlet_' + id));
    return 'portlet_' + id;
  }

  /**
   * Functions for the list portlet
   */
  /**
   * Remove a link from the list
   */
  link_change(list, link_id, row) {
    list.link_change(link_id, row);
  }
}
/**
 * Grid resolution.  Must match et2_portlet GRID
 */
_defineProperty(HomeApp, "GRID", 150);
app.classes.home = HomeApp;

/*

app.classes.home.home_weather_portlet = app.classes.home.home_portlet.extend({
	init: function(portlet) {
		// call parent
		this._super.apply(this, arguments);

		// Use location API
		if(!this.portlet.options.settings && 'geolocation' in navigator)
		{
			navigator.geolocation.getCurrentPosition(function(position) {
				if(portlet && portlet.options && portlet.options.settings &&
					portlet.options.settings.position && portlet.options.settings.position == position.coords.latitude + ',' + position.coords.longitude)
				{
					return;
				}
				portlet._process_edit(et2_dialog.OK_BUTTON, {position: position.coords.latitude + ',' + position.coords.longitude});
			});
		}
	}
});
*/

export { HomeApp };
//# sourceMappingURL=app.min.js.map
