/// <reference types="node" />
import { TestRunnerCoreConfig } from '../config/TestRunnerCoreConfig.js';
import { TestSessionManager } from '../test-session/TestSessionManager.js';
import { TestSession } from '../test-session/TestSession.js';
import { TestScheduler } from './TestScheduler.js';
export declare class TestSessionTimeoutHandler {
    private timeoutIdsPerSession;
    private config;
    private sessions;
    private scheduler;
    constructor(config: TestRunnerCoreConfig, sessions: TestSessionManager, scheduler: TestScheduler);
    waitForTestsStarted(testRun: number, sessionId: string): void;
    waitForTestsFinished(testRun: number, sessionId: string): void;
    /**
     * Returns whether the session has gone stale. Sessions are immutable, this takes in a
     * snapshot of a session and returns whether the session has since changed test run or status.
     * This can be used to decide whether perform side effects like logging or changing status.
     */
    isStale(session: TestSession): boolean;
    addTimeoutId(sessionId: string, id: any): void;
    private setSessionFailed;
    clearTimeoutsForSession(session: TestSession): void;
    clearAllTimeouts(): void;
    clearTimeouts(timeoutIds: NodeJS.Timeout[]): void;
}
//# sourceMappingURL=TestSessionTimeoutHandler.d.ts.map