"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBrowserLogs = void 0;
const browser_logs_1 = require("@web/browser-logs");
const async_js_1 = require("../../../utils/async.js");
async function parseBrowserLog(browserLog, mapBrowserUrl, mapStackLocation, config) {
    const browserRootDir = config.rootDir;
    const args = await (0, async_js_1.mapAsync)(browserLog.args, arg => (0, browser_logs_1.deserialize)(arg, { browserRootDir, mapBrowserUrl, mapStackLocation }));
    return { type: browserLog.type, args };
}
async function parseBrowserLogs(config, mapBrowserUrl, mapStackLocation, result) {
    if (!result.logs) {
        return;
    }
    const browserLogs = result.logs;
    const logsWithType = await (0, async_js_1.mapAsync)(browserLogs, b => parseBrowserLog(b, mapBrowserUrl, mapStackLocation, config));
    const logs = [];
    for (const log of logsWithType) {
        if (!config.filterBrowserLogs || config.filterBrowserLogs(log, result)) {
            logs.push(log.args);
        }
    }
    result.logs = logs;
}
exports.parseBrowserLogs = parseBrowserLogs;
//# sourceMappingURL=parseBrowserLogs.js.map