"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaywrightLauncherPage = void 0;
const test_runner_coverage_v8_1 = require("@web/test-runner-coverage-v8");
class PlaywrightLauncherPage {
    constructor(config, product, testFiles, playwrightContext, playwrightPage) {
        this.nativeInstrumentationEnabledOnPage = false;
        this.config = config;
        this.product = product;
        this.testFiles = testFiles;
        this.playwrightContext = playwrightContext;
        this.playwrightPage = playwrightPage;
    }
    async runSession(url, coverage) {
        var _a;
        if (coverage &&
            this.product === 'chromium' &&
            ((_a = this.config.coverageConfig) === null || _a === void 0 ? void 0 : _a.nativeInstrumentation) !== false) {
            if (this.nativeInstrumentationEnabledOnPage) {
                await this.playwrightPage.coverage.stopJSCoverage();
            }
            this.nativeInstrumentationEnabledOnPage = true;
            await this.playwrightPage.coverage.startJSCoverage();
        }
        await this.playwrightPage.setViewportSize({ height: 600, width: 800 });
        await this.playwrightPage.goto(url);
    }
    async stopSession() {
        const testCoverage = this.nativeInstrumentationEnabledOnPage
            ? await this.collectTestCoverage(this.config, this.testFiles)
            : undefined;
        // navigate to an empty page to kill any running code on the page, stopping timers and
        // breaking a potential endless reload loop
        await this.playwrightPage.goto('about:blank');
        await this.playwrightContext.close();
        return { testCoverage };
    }
    async collectTestCoverage(config, testFiles) {
        var _a, _b, _c;
        const userAgentPromise = this.playwrightPage
            .evaluate(() => window.navigator.userAgent)
            .catch(() => undefined);
        try {
            const coverageFromBrowser = await this.playwrightPage.evaluate(() => window.__coverage__);
            if (coverageFromBrowser) {
                // coverage was generated by JS, return that
                return coverageFromBrowser;
            }
        }
        catch (error) {
            // evaluate throws when the a test navigates in the browser
        }
        if (((_a = config.coverageConfig) === null || _a === void 0 ? void 0 : _a.nativeInstrumentation) === false) {
            throw new Error('Coverage is enabled with nativeInstrumentation disabled. ' +
                'Expected coverage provided in the browser as a global __coverage__ variable.' +
                'Use a plugin like babel-plugin-istanbul to generate the coverage, or enable native instrumentation.');
        }
        // get native coverage from playwright
        let coverage;
        if (this.product === 'chromium') {
            coverage = await ((_c = (_b = this.playwrightPage) === null || _b === void 0 ? void 0 : _b.coverage) === null || _c === void 0 ? void 0 : _c.stopJSCoverage());
        }
        else {
            coverage = [];
        }
        this.nativeInstrumentationEnabledOnPage = false;
        const userAgent = await userAgentPromise;
        return (0, test_runner_coverage_v8_1.v8ToIstanbul)(config, testFiles, coverage, userAgent);
    }
}
exports.PlaywrightLauncherPage = PlaywrightLauncherPage;
//# sourceMappingURL=PlaywrightLauncherPage.js.map