import webpack from 'webpack';

const build = function(options,cb){
    return new Promise(function(resolve) {
        console.log("Start building...");
        const compiler = webpack(options);
        compiler.run((err, stats) => {
            if (err) {
                console.error(err.message || err.stack || err);    
                resolve(false)      
                return false;
            }
            const info = stats.toJson();
            if (stats.hasErrors()) {
                for (let item of info.errors){
                    console.error(item.message || item);
                }   
                resolve(false)      
                return false;       
            }      
            if (stats.hasWarnings()) {
                for (let item of info.warnings){
                    console.warn(item.message || item);
                }  
            }
            resolve(compiler)
            return compiler;
        });      
        
    })
}

export {build}