export declare type NumberOrString = number | string;
export interface HEXObject {
    r: string;
    g: string;
    b: string;
    a?: string;
}
export interface RGBObject {
    r: number;
    g: number;
    b: number;
    a?: number;
}
export interface RGBObjectGeneric {
    r: NumberOrString;
    g: NumberOrString;
    b: NumberOrString;
    a?: NumberOrString;
}
export interface HSLObject {
    h: number;
    s: number;
    l: number;
    a?: number;
}
export interface HSLObjectGeneric {
    h: number;
    s: NumberOrString;
    l: NumberOrString;
    a?: number;
}
export interface CMYKObject {
    c: number;
    m: number;
    y: number;
    k: number;
}
export interface CMYKObjectGeneric {
    c: NumberOrString;
    m: NumberOrString;
    y: NumberOrString;
    k: NumberOrString;
}
export interface RYBObject {
    r: number;
    y: number;
    b: number;
    a?: number;
}
export declare type RGYBObject = RGBObject | RYBObject;
export declare type Color = RGBObjectGeneric | HSLObjectGeneric | CMYKObjectGeneric;
export declare type ColorWithoutCMYK = RGBObjectGeneric | HSLObjectGeneric;
export declare type ColorInput = string | Color;
export declare type ColorInputWithoutCMYK = string | ColorWithoutCMYK;
export declare type HEXOutput = string | HEXObject;
export declare type RGBOutput = string | RGBObject;
export declare type HSLOutput = string | HSLObject;
export declare type CMYKOutput = string | CMYKObject;
export declare type ColorOutput = HEXOutput | RGBOutput | HSLOutput;
export interface ObjectProps<T> {
    [key: string]: T;
}
