/**
 * EGroupware - Notifications Java Desktop App
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package notifications
 * @subpackage jdesk
 * @link http://www.egroupware.org
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 * @author Maik Hüttner <maik.huettner@hw-softwareentwicklung.de>
 */
package egroupwaretray.settings;

import egroupwaretray.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/**
 * egwSettingUsername
 * 
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 */
public class egwSettingUsername extends javax.swing.JDialog {

	private jegwconfig _config		= null;
	private Boolean _isClickedBack	= false;
	
	/**
	 * Creates new form egwSettingUsername
	 */
	public egwSettingUsername(java.awt.Frame parent, boolean modal, jegwconfig configmanager) {
		super(parent, modal);
		initComponents();
		
		this._config = configmanager;
		
		this.jButtonCancel.setText(jegwConst.getConstTag("egw_txt_cancel"));
		this.jButtonBack.setText(jegwConst.getConstTag("egw_txt_back"));
		this.jLabelStep.setText(jegwConst.getConstTag("egw_txt_step") + " 3.");
		this.jButtonSave.setText(jegwConst.getConstTag("egw_txt_save"));
		this.jLabelTitle.setText(jegwConst.getConstTag("egw_txt_user"));
		this.jLabelInfo.setText(jegwConst.getConstTag("egw_msg_info_username"));
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelStep = new javax.swing.JLabel();
        jLabelInfo = new javax.swing.JLabel();
        jLabelTitle = new javax.swing.JLabel();
        jTextFieldUsername = new javax.swing.JTextField();
        jButtonBack = new javax.swing.JButton();
        jButtonSave = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        jLabelStep.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        jLabelStep.setText("Schritt 3.");

        jLabelInfo.setText("Bitte geben Sie den Egroupware Benutzernamen an.");

        jLabelTitle.setText("Benutzer:");

        jButtonBack.setText("Zurück");
        jButtonBack.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mouseClickedBack(evt);
            }
        });

        jButtonSave.setText("Speichern");
        jButtonSave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mouseClickedSave(evt);
            }
        });

        jButtonCancel.setText("Abbrechen");
        jButtonCancel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mouseClickedCancel(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabelInfo, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonBack)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jButtonCancel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonSave))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabelStep)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabelTitle)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jTextFieldUsername)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabelStep)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelInfo)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabelTitle)
                    .addComponent(jTextFieldUsername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonBack)
                    .addComponent(jButtonSave)
                    .addComponent(jButtonCancel))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void mouseClickedBack(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mouseClickedBack
		// TODO add your handling code here:
		this._isClickedBack = true;
		this.setVisible(false);
	}//GEN-LAST:event_mouseClickedBack

	private void mouseClickedCancel(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mouseClickedCancel
		// TODO add your handling code here:
		
		if( jegwMain.confirmDialog(
			jegwConst.getConstTag("egw_msg_cancal_setting"),
			jegwConst.getConstTag("egw_txt_cancal2") ) == 0 )
		{
			this.setVisible(false);
		}
	}//GEN-LAST:event_mouseClickedCancel

	private void mouseClickedSave(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mouseClickedSave
		// TODO add your handling code here:
		
		String username = this.jTextFieldUsername.getText();
		
		if( username.trim().isEmpty() )
		{
			JOptionPane.showMessageDialog(
				EgroupwareTrayApp.getApplication().getMainFrame(),
				jegwConst.getConstTag("egw_msg_info_username"), 
				jegwConst.getConstTag("egw_txt_setting"), 
				JOptionPane.INFORMATION_MESSAGE
				); 
		}
		else
		{
			KeyArray config = null;
			
			if( this._config.getCXMLM().countConf() > 0 )
			{	
				KeyArray aktivconf = this._config.getCXMLM().getActivConf();

				if( aktivconf != null )
				{
					config = aktivconf;
				}
			}

			if( config== null )
			{
				// Config erzeugen
				config = new KeyArray(jegwxmlconfig.CONF_STRUCT);

			}
			
			config.add("user", username);
			
			this._config.getCXMLM().deleteConf(0);
			this._config.getCXMLM().addConf(config);
			
			try {
				this._config.saveConfig();
				this.setVisible(false);
			} catch (Exception ex) {
				Logger.getLogger(egwSettingUsername.class.getName()).log(Level.SEVERE, null, ex);
			}
		}
	}//GEN-LAST:event_mouseClickedSave

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		/*
		 * Set the Nimbus look and feel
		 */
		//<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
		 * If Nimbus (introduced in Java SE 6) is not available, stay with the
		 * default look and feel. For details see
		 * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
		 */
		try {
			for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
				if ("Nimbus".equals(info.getName())) {
					javax.swing.UIManager.setLookAndFeel(info.getClassName());
					break;
				}
			}
		} catch (ClassNotFoundException ex) {
			java.util.logging.Logger.getLogger(egwSettingUsername.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (InstantiationException ex) {
			java.util.logging.Logger.getLogger(egwSettingUsername.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (IllegalAccessException ex) {
			java.util.logging.Logger.getLogger(egwSettingUsername.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		} catch (javax.swing.UnsupportedLookAndFeelException ex) {
			java.util.logging.Logger.getLogger(egwSettingUsername.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
		}
		//</editor-fold>

		/*
		 * Create and display the dialog
		 */
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				egwSettingUsername dialog = new egwSettingUsername(new javax.swing.JFrame(), true, null);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {

					@Override
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBack;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonSave;
    private javax.swing.JLabel jLabelInfo;
    private javax.swing.JLabel jLabelStep;
    private javax.swing.JLabel jLabelTitle;
    private javax.swing.JTextField jTextFieldUsername;
    // End of variables declaration//GEN-END:variables

	public Boolean isClickedBack()
	{
		return this._isClickedBack;
	}
}
