import '../../chunks/egw_json-39123901.js';
import { aA as e, aN as Et2SelectAccount, V as A, E as EgwApp, av as et2_button, aM as et2_selectbox, b as etemplate2, j as et2_nextmatch, a as egw, ad as nm_open_popup, c as Et2Dialog } from '../../chunks/etemplate2-0373054a.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

var _dec, _class, _descriptor;
function asyncGeneratorStep$1(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$1(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _initializerDefineProperty(e, i, r, l) { r && Object.defineProperty(e, i, { enumerable: r.enumerable, configurable: r.configurable, writable: r.writable, value: r.initializer ? r.initializer.call(l) : void 0 }); }
function _defineProperty$1(e, r, t) { return (r = _toPropertyKey$1(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$1(t) { var i = _toPrimitive$1(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$1(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
function _initializerWarningHelper(r, e) { throw Error("Decorating class property failed. Please ensure that transform-class-properties is enabled and runs after the decorators transform."); }

/**
 * Select widget customised for tracker to limit users
 *
 */
var Et2TrackerAssigned = (_dec = e(), _class = class Et2TrackerAssigned extends Et2SelectAccount {
  constructor() {
    super();
    /**
     * Limit users to those of a specific queue
     *
     * @type {number}
     */
    _initializerDefineProperty(this, "tracker", _descriptor, this);
    this.searchUrl = "tracker_assigned_etemplate_widget::ajax_search";
    this.searchOptions = {};
  }

  /**
   * Do not pre-fill the list, we only want certain users, which are passed from client
   *
   * @protected
   * @internal
   */
  _getAccounts() {
    return Promise.resolve();
  }

  /**
   * Start searching
   *
   * Overridden from parent to easily set the tracker
   */
  startSearch() {
    var _superprop_getStartSearch = () => super.startSearch,
      _this = this;
    return _asyncToGenerator$1(function* () {
      _this.searchOptions['tracker'] = _this.tracker;
      return _superprop_getStartSearch().call(_this);
    })();
  }

  /**
   * Override icon - none
   *
   * @param option
   * @protected
   */
  _iconTemplate(option) {
    return A;
  }
}, _descriptor = _applyDecoratedDescriptor(_class.prototype, "tracker", [_dec], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return '0';
  }
}), _class);
if (!customElements.get("et2-tracker-assigned")) {
  customElements.define("et2-tracker-assigned", Et2TrackerAssigned);
}

function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * UI for tracker
 */
class trackerAPP extends EgwApp {
  /**
   * Constructor
   */
  constructor() {
    super('tracker');
    // Filter push messages to see if we can ignore it
    _defineProperty(this, "push_filter_fields", ["tr_tracker", "tr_version", "tr_creator", "tr_assigned"]);
  }

  /**
   * Destructor
   */
  destroy(_app) {
    super.destroy(_app);
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} _et2
   * @param {string} _name name of template loaded
   */
  et2_ready(_et2, _name) {
    // call parent
    super.et2_ready(_et2, _name);
    switch (_name) {
      case 'tracker.admin':
        this.acl_queue_access();
        break;
      case 'tracker.edit':
        this.edit_popup();
        break;
      case 'tracker.index':
        this.filter_change();
        if (this.et2.getArrayMgr('content').getEntry('nm[only_tracker]'))
          // there's no this.et2.getWidgetById('colfilter[tr_tracker]').hide() and
          // jQuery(this.et2.getWidgetById('colfilter[tr_tracker]').getDOMNode()).hide()
          // hides already hiden selectbox and not the choosen container :(
          jQuery('#tracker_index_col_filter_tr_tracker__chzn').hide();
        break;
      case 'tracker.escalations':
        // Set any filters with multiple values to multiple
        _et2.widgetContainer.getWidgetById('escalation').iterateOver(function (widget) {
          if (typeof widget.options.value === 'object' && widget.options.value.length > 1) {
            var button = null;
            // Find associated expand button
            widget.getParent().getParent().iterateOver(function (widget) {
              button = widget;
            }, this, et2_button);
            this.multiple_assigned(false, button);
            widget.set_value(widget.options.value);
          }
        }, this, et2_selectbox);
        break;
    }
  }

  /**
   * Observer method receives update notifications from all applications
   *
   * @param {string} _msg message (already translated) to show, eg. 'Entry deleted'
   * @param {string} _app application name
   * @param {(string|number)} _id id of entry to refresh or null
   * @param {string} _type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {string} _msg_type 'error', 'warning' or 'success' (default)
   * @param {object|null} _links app => array of ids of linked entries
   * or null, if not triggered on server-side, which adds that info
   */
  observer(_msg, _app, _id, _type, _msg_type, _links) {
    if (typeof (_links === null || _links === void 0 ? void 0 : _links.tracker) != 'undefined') {
      if (_app === 'timesheet') {
        var nm = this.et2 ? this.et2.getWidgetById('nm') : null;
        if (nm) nm.applyFilters();
      }
    }
  }

  /**
   * Retrieve the current state of the application for future restoration
   *
   * The state can be anything, as long as it's an object.  The contents are
   * application specific.  Overriding the default implementation to always use
   * the tracker list, not escalations.
   * The return value of this function cannot be passed directly to setState(),
   * since setState is expecting an additional wrapper, eg:
   * {name: 'something', state: getState()}
   *
   * @return {object} Application specific map representing the current state
   */
  getState() {
    var state = {};

    // Try and find a nextmatch widget, and set its filters
    var et2 = etemplate2.getById('tracker-index');
    if (!et2) return {};
    et2.widgetContainer.iterateOver(function (_widget) {
      state = _widget.getValue();
    }, this, et2_nextmatch);
    return state;
  }

  /**
   * Tracker list filter change, used to toggle date fields
   */
  filter_change() {
    var filter = this.et2.getWidgetById('filter');
    var dates = this.et2.getWidgetById('tracker.index.dates');
    if (filter && dates) {
      dates.set_disabled(filter.getValue() !== "custom");
      if (filter.value == "custom") {
        window.setTimeout(function () {
          jQuery(this.et2.getWidgetById('startdate').getDOMNode()).find('input').focus();
        }.bind(this), 100);
      }
    }
    return true;
  }

  /**
   * User wants to share
   *
   * @param {egwAction} _action
   * @param {egwActionObject} _selected
   * @param _target
   */
  share_link(_action, _selected, _target) {
    if (_action.id == 'shareWritableFilemanager') {
      // No checkbox for parent to find, explicitly set writable
      super.share_link(_action.parent.getActionById('shareFilemanager'), _selected, _target, true);
    } else {
      // Leave writable parameter undefined so parent can check
      super.share_link(_action, _selected, _target);
    }
  }

  /**
   * Used in escalations on buttons to change filters from a single select to a multi-select
   *
   * @param {object} _event
   * @param {et2_baseWidget} _widget
   *
   * Note: It's important to consider the menupop widget needs to be always first child of
   * buttononly's parent, since we are getting the right selectbox by orders
   */
  multiple_assigned(_event, _widget) {
    _widget.set_disabled(true);
    var selectbox = _widget.getParent()._children[0];
    selectbox.set_multiple(true);
    selectbox.set_tags(true, '98%');
    return false;
  }

  /**
   * tprint
   * @param _action
   * @param _senders
   */
  tprint(_action, _senders) {
    var id = _senders[0].id.split('::');
    if (_action.id === 'print') {
      var popup = egw().open_link('/index.php?menuaction=tracker.tracker_ui.tprint&tr_id=' + id[1], '', egw().link_get_registry('tracker', 'add_popup'), 'tracker');
      popup.onload = function () {
        this.print();
      };
    }
  }

  /**
   * Check if the edit window is a popup, then set window focus
   */
  edit_popup() {
    if (typeof this.et2.node != 'undefined' && typeof this.et2.node.baseURI != 'undefined') {
      if (!this.et2.node.baseURI.match(/no_?popup/)) {
        window.focus();
        if (this.et2.node.baseURI.match('composeid'))
          //tracker created by mail application
          {
            window.resizeTo(750, 550);
          }
      }
    }
  }

  /**
   * canned_comment_request
   *
   */
  canned_comment_requst() {
    var editor = this.et2.getWidgetById('reply_message');
    var id = this.et2.getValueById('canned_response');
    if (id && editor) {
      // Need to specify the popup's egw
      this.et2.egw().json('tracker.tracker_ui.ajax_canned_comment', [id, document.getElementById('tracker-edit_reply_message').style.display == 'none']).sendRequest(true);
    }
  }
  /**
   * canned_comment_response
   * @param _replyMsg
   */
  canned_comment_response(_replyMsg) {
    this.et2.getWidgetById('canned_response').set_value('');
    var editor = this.et2.getWidgetById('add_comment[reply_message]');
    if (editor) {
      editor.set_value(_replyMsg);
    }
  }

  /**
   * Update the UI to show the file after user adds a file to a comment
   *
   * @param {HTMLElement} dom_node
   * @param {et2_widget} widget
   * @returns {undefined}
   */
  comment_add_vfs(dom_node, widget) {
    var wait = [];
    // Add the file into the existing list of files
    widget.getInstanceManager().widgetContainer.querySelectorAll('et2-link-list').forEach(link => {
      link.get_links();
      wait.push(link.updateComplete);
    });

    // Update link list widgets (including on links tab)
    this.et2.querySelectorAll('et2-link-list').forEach(link => {
      link.get_links();
      wait.push(link.updateComplete);
    });
    // Files have been put where they need to be, clear widget value
    Promise.all([wait, wait]).then(() => {
      widget.value = null;
    });
  }

  /**
   * acl_queue_access
   *
   * Enables or disables the Site configuration 'Staff'tab 'Users' widget
   * based on the 'enabled_queue_acl_access' config setting
   */
  acl_queue_access() {
    var queue_acl = this.et2.getWidgetById('enabled_queue_acl_access');

    // Check content too, in case we're viewing a specific queue and that widget
    // isn't there
    var content = this.et2.getArrayMgr('content').getEntry('enabled_queue_acl_access');
    if (queue_acl && queue_acl.get_value() === 'false' || content !== null && !content) {
      this.et2.getWidgetById('users').set_disabled(true);
    } else {
      this.et2.getWidgetById('users').set_disabled(false);
    }
  }

  /**
   * Get title in order to set it as document title
   * @returns {string}
   */
  getWindowTitle() {
    return this.et2.getValueById('tr_summary');
  }

  /**
   * Action handler for context menu change assigned action
   *
   * We populate the dialog with the current value.
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _selected
   */
  change_assigned(_action, _selected) {
    var et2 = _selected[0].manager.data.nextmatch.getInstanceManager();
    var assigned = et2.widgetContainer.getWidgetById('assigned');
    if (assigned) {
      assigned.set_value([]);
      et2.widgetContainer.getWidgetById('assigned_action[title]').set_value('');
      et2.widgetContainer.getWidgetById('assigned_action[title]').set_class('');
      et2.widgetContainer.getWidgetById('assigned_action[ok]').set_disabled(_selected.length !== 1);
      et2.widgetContainer.getWidgetById('assigned_action[add]').set_disabled(_selected.length === 1);
      et2.widgetContainer.getWidgetById('assigned_action[delete]').set_disabled(_selected.length === 1);
    }
    if (_selected.length === 1) {
      var data = egw.dataGetUIDdata(_selected[0].id);
      if (assigned && data && data.data) {
        et2.widgetContainer.getWidgetById('assigned_action[title]').set_value(data.data.tr_summary);
        et2.widgetContainer.getWidgetById('assigned_action[title]').set_class(data.data.class);
        assigned.set_value(data.data.tr_assigned);
      }
    }
    nm_open_popup(_action, _selected);
  }

  /**
   * Override the viewEntry to remove unseen class
   * right after view the entry.
   *
   * @param {type} _action
   * @param {type} _senders
   */
  viewEntry(_action, _senders) {
    super.viewEntry(_action, _senders);
    var nm = this.et2.getWidgetById('nm');
    var nm_indexes = nm.getController()._indexMap;
    var node = null;
    for (var i in nm_indexes) {
      if (nm_indexes[i]['uid'] == _senders[0]['id']) {
        node = nm_indexes[i].row._nodes[0].find('.tracker_unseen');
      }
    }
    if (node) {
      node.removeClass('tracker_unseen');
    }
  }

  /**
   * Handle context menu action on the comments to edit the comment
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _entries
   */
  reply_edit(_action, _entries) {
    var _this$egw$dataGetUIDd,
      _this$egw$dataGetUIDd2,
      _entries$0$manager$da,
      _entries$0$manager,
      _this = this;
    var data = (_this$egw$dataGetUIDd = (_this$egw$dataGetUIDd2 = this.egw.dataGetUIDdata(_entries[0].id)) === null || _this$egw$dataGetUIDd2 === void 0 ? void 0 : _this$egw$dataGetUIDd2.data) !== null && _this$egw$dataGetUIDd !== void 0 ? _this$egw$dataGetUIDd : {};

    // If you have more than one edit dialog open, we need the right data
    var instance = (_entries$0$manager$da = (_entries$0$manager = _entries[0].manager) === null || _entries$0$manager === void 0 || (_entries$0$manager = _entries$0$manager.data) === null || _entries$0$manager === void 0 || (_entries$0$manager = _entries$0$manager.context) === null || _entries$0$manager === void 0 || (_entries$0$manager = _entries$0$manager.tracker) === null || _entries$0$manager === void 0 ? void 0 : _entries$0$manager.et2.getInstanceManager()) !== null && _entries$0$manager$da !== void 0 ? _entries$0$manager$da : this.et2.getInstanceManager();

    // Create dialog
    var dialog = this.editCommentDialog(instance.etemplate_exec_id, _entries[0].id, _objectSpread(_objectSpread({}, data), {}, {
      tr_edit_mode: instance.widgetContainer.getArrayMgr("content").getEntry("tr_edit_mode")
    }));
    dialog.updateComplete.then(() => {
      var _dialog$querySelector;
      (_dialog$querySelector = dialog.querySelector('textarea')) === null || _dialog$querySelector === void 0 || _dialog$querySelector.focus();
    });

    // Update reply
    dialog.getComplete().then(/*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(function* (_ref) {
        var [button, value] = _ref;
        if (!button) {
          return;
        }
        var result = yield _this.egw.request("tracker_ui::ajax_update_reply", [value.reply_message, data.tr_id, data.reply_id]);

        // Update the row
        _this.egw.dataRefreshUID(_entries[0].id);
      });
      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  editCommentDialog(etemplate_exec_id, comment_id, data) {
    var dialog = document.createElement('et2-dialog');
    dialog._setApiInstance(this.egw);
    dialog.transformAttributes({
      title: this.egw.lang('Edit comment'),
      id: "tracker-edit-comment-dialog",
      buttons: Et2Dialog.BUTTONS_OK_CANCEL,
      isModal: true,
      destroyOnClose: false,
      value: {
        etemplate_exec_id: etemplate_exec_id,
        content: data
      },
      template: "tracker.edit.comment_edit"
    });
    // Stop [Enter] key from closing the dialog
    dialog.updateComplete.then(() => {
      dialog.querySelector("#tracker-edit-comment_edit").addEventListener("keyup", e => {
        e.stopImmediatePropagation();
      });
    });
    document.body.appendChild(dialog);
    dialog.getComplete().then(_ref3 => {
      var [button, value] = _ref3;
      // Carefully clear template preserving session
      dialog.eTemplate.clear(true, true);
      dialog.remove();
    });
    return dialog;
  }

  /**
   * View a list of timesheets for the linked tracker entry
   *
   * Only one tracker entry at a time is allowed, we just pick the first one
   *
   * @param {egwAction} _action
   * @param {egwActionObject[]} _selected
   */
  timesheet_list(_action, _selected) {
    var extras = {
      link_app: 'tracker',
      link_id: false
    };
    for (var i = 0; i < _selected.length; i++) {
      // Remove UID prefix for just contact_id
      var ids = _selected[i].id.split('::');
      ids.shift();
      ids = ids.join('::');
      extras.link_id = ids;
      break;
    }
    egw.open("", "timesheet", "list", extras, 'timesheet');
  }
}
app.classes.tracker = trackerAPP;
//# sourceMappingURL=app.min.js.map
