import { Color, ColorInput, ColorInputWithoutCMYK, RGBObjectGeneric, HSLObjectGeneric, CMYKObjectGeneric, CMYKObject, HSLObject, RGBObject, HEXObject, RGBOutput, HSLOutput, HEXOutput, ColorOutput } from '../@types';
import { ColorModel, Mix } from '../constants';
declare type HarmonyFunction = (color: HSLObject, mode: Mix) => HSLObject[];
export declare const normalizeHue: (hue: number) => number;
export declare const normalizeAlpha: (alpha: number | undefined | null) => number;
export declare const analogous: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const complementary: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const splitComplementary: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const triadic: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const tetradic: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const square: (color: HSLObject, mode: Mix) => HSLObject[];
export declare const getColorModel: (color: string | Color) => ColorModel;
export declare const getRGBObjectFromString: {
    HEX(color: string): RGBObject;
    RGB(color: string): RGBObject;
    RGBA(color: string): RGBObject;
    HSL(color: string): RGBObject;
    HSLA(color: string): RGBObject;
    CMYK(color: string): RGBObject;
};
export declare const getRGBObjectFromObject: {
    HEX(color: RGBObjectGeneric): RGBObject;
    RGB(color: RGBObjectGeneric): RGBObject;
    RGBA(color: RGBObjectGeneric): RGBObject;
    HSL(color: HSLObjectGeneric): RGBObject;
    HSLA(color: HSLObjectGeneric): RGBObject;
    CMYK(color: CMYKObjectGeneric): RGBObject;
};
export declare const getRGBObject: (color: ColorInput, model?: ColorModel) => RGBObject;
export declare const translateColor: {
    HEX(color: RGBObject): HEXObject;
    HEXA(color: RGBObject): HEXObject;
    RGB(color: RGBObject): RGBObject;
    RGBA(color: RGBObject): RGBObject;
    HSL(color: RGBObject): HSLObject;
    HSLA(color: RGBObject): HSLObject;
    CMYK(color: RGBObject): CMYKObject;
};
export declare const blend: (from: RGBObject, to: RGBObject, steps: number) => RGBObject[];
export declare const getColorMixture: (color: ColorInputWithoutCMYK, steps: number, shades: boolean) => ColorOutput[];
export declare const colorHarmony: {
    buildHarmony(color: ColorInputWithoutCMYK, harmonyFunction: HarmonyFunction, mode: Mix): ColorOutput[];
    HEX(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): HEXOutput[];
    HEXA(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): HEXOutput[];
    RGB(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): RGBOutput[];
    RGBA(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): RGBOutput[];
    HSL(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): HSLOutput[];
    HSLA(color: HSLObject, harmonyFunction: HarmonyFunction, mode: Mix, css: boolean): HSLOutput[];
};
export declare const colorMixer: {
    mix(colors: ColorInput[], mode: Mix): RGBObject;
    HEX(colors: ColorInput[], mode: Mix, css: boolean): HEXOutput;
    HEXA(colors: ColorInput[], mode: Mix, css: boolean): HEXOutput;
    RGB(colors: ColorInput[], mode: Mix, css: boolean): RGBOutput;
    RGBA(colors: ColorInput[], mode: Mix, css: boolean): RGBOutput;
    HSL(colors: ColorInput[], mode: Mix, css: boolean): HSLOutput;
    HSLA(colors: ColorInput[], mode: Mix, css: boolean): HSLOutput;
};
export {};
