# ADOdb Security Policy

## Supported Versions

The following releases of the library are currently being supported with
security updates. Please refer to the [project's home page](https://adodb.org)
for actual version numbers.

- Stable
- Legacy
- Development (Git *master* branch)

Older releases are no longer supported. 


## Reporting a Vulnerability

If you discover a vulnerability in ADOdb, please contact 
the [project's maintainer](https://github.com/dregad)

- by e-mail (look for it in the Git history)
- via private chat on [Matrix](https://matrix.to/#/@dregad:matrix.org)

Kindly provide the following information in your report:

- Affected ADOdb version(s) or Git revision
- A clear and detailed description of the issue, including if possible a code 
  snippet to demonstrate or reproduce the vulnerability
- A patch for the issue if you have one, preferably in *Git diff* format

### CVE handling

To ensure a comprehensive and detailed declaration of the issue, we generally 
prefer requesting CVE IDs ourselves, which usually happens after our analysis
confirms the vulnerability.

In case you have already obtained a CVE ID, do not forget to reference it in 
your report.

### Credits

Let us know if and how you wish to be credited for the finding. 

Your name, e-mail, company, etc. will be included as specified in the CVE 
report, as well as in the Git commit message patching the issue.
