<?php

namespace Elgg\Icons;

/**
 * Adds FontAwesome icon classes
 *
 * @since 4.3
 */
class AddFontAwesomeClassesHandler {
	
	/**
	 * Common alternative spelling for icons in Elgg
	 *
	 * @var array
	 */
	protected $common_icons = [
		'delete-alt' => 'times-circle',
		'delete' => 'times',
		'grid' => 'th',
		'info' => 'info-circle',
		'mail' => 'envelope-regular',
		'refresh' => 'redo',
		'remove' => 'times',
		'settings' => 'wrench',
		'settings-alt' => 'cog',
		'warning' => 'exclamation-triangle',
	];
	
	/**
	 * FontAwesome brand icons
	 *
	 * @var array
	 */
	protected $brands = [
		'500px',
		'accessible-icon',
		'accusoft',
		'acquisitions-incorporated',
		'adn',
		'adobe',
		'adversal',
		'affiliatetheme',
		'airbnb',
		'algolia',
		'alipay',
		'amazon-pay',
		'amazon',
		'amilia',
		'android',
		'angellist',
		'angrycreative',
		'angular',
		'app-store-ios',
		'app-store',
		'apper',
		'apple-pay',
		'apple',
		'artstation',
		'asymmetrik',
		'atlassian',
		'audible',
		'autoprefixer',
		'avianex',
		'aviato',
		'aws',
		'bandcamp',
		'battle-net',
		'behance-square',
		'behance',
		'bimobject',
		'bitbucket',
		'bitcoin',
		'bity',
		'black-tie',
		'blackberry',
		'blogger-b',
		'blogger',
		'bluetooth-b',
		'bluetooth',
		'bootstrap',
		'btc',
		'buffer',
		'buromobelexperte',
		'buy-n-large',
		'buysellads',
		'canadian-maple-leaf',
		'cc-amazon-pay',
		'cc-amex',
		'cc-apple-pay',
		'cc-diners-club',
		'cc-discover',
		'cc-jcb',
		'cc-mastercard',
		'cc-paypal',
		'cc-stripe',
		'cc-visa',
		'centercode',
		'centos',
		'chrome',
		'chromecast',
		'cloudscale',
		'cloudsmith',
		'cloudversify',
		'codepen',
		'codiepie',
		'confluence',
		'connectdevelop',
		'contao',
		'cotton-bureau',
		'cpanel',
		'creative-commons-by',
		'creative-commons-nc-eu',
		'creative-commons-nc-jp',
		'creative-commons-nc',
		'creative-commons-nd',
		'creative-commons-pd-alt',
		'creative-commons-pd',
		'creative-commons-remix',
		'creative-commons-sa',
		'creative-commons-sampling-plus',
		'creative-commons-sampling',
		'creative-commons-share',
		'creative-commons-zero',
		'creative-commons',
		'critical-role',
		'css3-alt',
		'css3',
		'cuttlefish',
		'd-and-d-beyond',
		'd-and-d',
		'dashcube',
		'delicious',
		'deploydog',
		'deskpro',
		'dev',
		'deviantart',
		'dhl',
		'diaspora',
		'digg',
		'digital-ocean',
		'discord',
		'discourse',
		'dochub',
		'docker',
		'draft2digital',
		'dribbble-square',
		'dribbble',
		'dropbox',
		'drupal',
		'dyalog',
		'earlybirds',
		'ebay',
		'edge',
		'elementor',
		'ello',
		'ember',
		'empire',
		'envira',
		'erlang',
		'ethereum',
		'etsy',
		'evernote',
		'expeditedssl',
		'facebook-f',
		'facebook-messenger',
		'facebook-square',
		'facebook',
		'fantasy-flight-games',
		'fedex',
		'fedora',
		'figma',
		'firefox-browser',
		'firefox',
		'first-order-alt',
		'first-order',
		'firstdraft',
		'flickr',
		'flipboard',
		'fly',
		'font-awesome-alt',
		'font-awesome-flag',
		'font-awesome-logo-full',
		'font-awesome',
		'fonticons-fi',
		'fonticons',
		'fort-awesome-alt',
		'fort-awesome',
		'forumbee',
		'foursquare',
		'free-code-camp',
		'freebsd',
		'fulcrum',
		'galactic-republic',
		'galactic-senate',
		'get-pocket',
		'gg-circle',
		'gg',
		'git-alt',
		'git-square',
		'git',
		'github-alt',
		'github-square',
		'github',
		'gitkraken',
		'gitlab',
		'gitter',
		'glide-g',
		'glide',
		'gofore',
		'goodreads-g',
		'goodreads',
		'google-drive',
		'google-play',
		'google-plus-g',
		'google-plus-square',
		'google-plus',
		'google-wallet',
		'google',
		'gratipay',
		'grav',
		'gripfire',
		'grunt',
		'gulp',
		'hacker-news-square',
		'hacker-news',
		'hackerrank',
		'hips',
		'hire-a-helper',
		'hooli',
		'hornbill',
		'hotjar',
		'houzz',
		'html5',
		'hubspot',
		'ideal',
		'imdb',
		'instagram',
		'intercom',
		'internet-explorer',
		'invision',
		'ioxhost',
		'itch-io',
		'itunes-note',
		'itunes',
		'java',
		'jedi-order',
		'jenkins',
		'jira',
		'joget',
		'joomla',
		'js-square',
		'js',
		'jsfiddle',
		'kaggle',
		'keybase',
		'keycdn',
		'kickstarter-k',
		'kickstarter',
		'korvue',
		'laravel',
		'lastfm-square',
		'lastfm',
		'leanpub',
		'less',
		'line',
		'linkedin-in',
		'linkedin',
		'linode',
		'linux',
		'lyft',
		'magento',
		'mailchimp',
		'mandalorian',
		'markdown',
		'mastodon',
		'maxcdn',
		'mdb',
		'medapps',
		'medium-m',
		'medium',
		'medrt',
		'meetup',
		'megaport',
		'mendeley',
		'microblog',
		'microsoft',
		'mix',
		'mixcloud',
		'mizuni',
		'modx',
		'monero',
		'napster',
		'neos',
		'nimblr',
		'node-js',
		'node',
		'npm',
		'ns8',
		'nutritionix',
		'odnoklassniki-square',
		'odnoklassniki',
		'old-republic',
		'opencart',
		'openid',
		'opera',
		'optin-monster',
		'orcid',
		'osi',
		'page4',
		'pagelines',
		'palfed',
		'patreon',
		'paypal',
		'penny-arcade',
		'periscope',
		'phabricator',
		'phoenix-framework',
		'phoenix-squadron',
		'php',
		'pied-piper-alt',
		'pied-piper-hat',
		'pied-piper-pp',
		'pied-piper-square',
		'pied-piper',
		'pinterest-p',
		'pinterest-square',
		'pinterest',
		'playstation',
		'product-hunt',
		'pushed',
		'python',
		'qq',
		'quinscape',
		'quora',
		'r-project',
		'raspberry-pi',
		'ravelry',
		'react',
		'reacteurope',
		'readme',
		'rebel',
		'red-river',
		'reddit-alien',
		'reddit-square',
		'reddit',
		'redhat',
		'renren',
		'replyd',
		'researchgate',
		'resolving',
		'rev',
		'rocketchat',
		'rockrms',
		'safari',
		'salesforce',
		'sass',
		'schlix',
		'scribd',
		'searchengin',
		'sellcast',
		'sellsy',
		'servicestack',
		'shirtsinbulk',
		'shopware',
		'simplybuilt',
		'sistrix',
		'sith',
		'sketch',
		'skyatlas',
		'skype',
		'slack-hash',
		'slack',
		'slideshare',
		'snapchat-ghost',
		'snapchat-square',
		'snapchat',
		'soundcloud',
		'sourcetree',
		'speakap',
		'speaker-deck',
		'spotify',
		'squarespace',
		'stack-exchange',
		'stack-overflow',
		'stackpath',
		'staylinked',
		'steam-square',
		'steam-symbol',
		'steam',
		'sticker-mule',
		'strava',
		'stripe-s',
		'stripe',
		'studiovinari',
		'stumbleupon-circle',
		'stumbleupon',
		'superpowers',
		'supple',
		'suse',
		'swift',
		'symfony',
		'teamspeak',
		'telegram-plane',
		'telegram',
		'tencent-weibo',
		'the-red-yeti',
		'themeco',
		'themeisle',
		'think-peaks',
		'trade-federation',
		'trello',
		'tripadvisor',
		'tumblr-square',
		'tumblr',
		'twitch',
		'twitter-square',
		'twitter',
		'typo3',
		'uber',
		'ubuntu',
		'uikit',
		'umbraco',
		'uniregistry',
		'unity',
		'untappd',
		'ups',
		'usb',
		'usps',
		'ussunnah',
		'vaadin',
		'viacoin',
		'viadeo-square',
		'viadeo',
		'viber',
		'vimeo-square',
		'vimeo-v',
		'vimeo',
		'vine',
		'vk',
		'vnv',
		'vuejs',
		'waze',
		'weebly',
		'weibo',
		'weixin',
		'whatsapp-square',
		'whatsapp',
		'whmcs',
		'wikipedia-w',
		'windows',
		'wix',
		'wizards-of-the-coast',
		'wolf-pack-battalion',
		'wordpress-simple',
		'wordpress',
		'wpbeginner',
		'wpexplorer',
		'wpforms',
		'wpressr',
		'xbox',
		'xing-square',
		'xing',
		'y-combinator',
		'yahoo',
		'yammer',
		'yandex-international',
		'yandex',
		'yarn',
		'yelp',
		'yoast',
		'youtube-square',
		'youtube',
		'zhihu',
	];
	
	/**
	 * Converts icon classes to correct FontAwesome classes
	 *
	 * @param \Elgg\Event $event 'view_vars', 'output/icon'
	 *
	 * @return array
	 */
	public function __invoke(\Elgg\Event $event) {
		$vars = $event->getValue();
		
		$classes = elgg_extract_class($vars);
		
		foreach ($classes as $icon_class) {
			if (!preg_match_all('/^elgg-icon-(.+)/i', $icon_class)) {
				continue;
			}
			
			// strip elgg-icon-
			$base_icon = preg_replace('/^elgg-icon-(.+)/i', '$1', $icon_class);
			
			// convert common icons
			$base_icon = elgg_extract($base_icon, $this->common_icons, $base_icon);
			
			// map solid/regular/light iconnames to correct classes
			if (preg_match('/.*-solid$/', $base_icon)) {
				$base_icon = preg_replace('/(.*)-solid$/', '$1', $base_icon);
				$classes[] = 'fas';
			} elseif (preg_match('/.*-regular$/', $base_icon)) {
				$base_icon = preg_replace('/(.*)-regular$/', '$1', $base_icon);
				$classes[] = 'far';
			} elseif (preg_match('/.*-light$/', $base_icon)) {
				// currently light is only available in FontAwesome 5 Pro
				$base_icon = preg_replace('/(.*)-light$/', '$1', $base_icon);
				$classes[] = 'fal';
			} elseif (in_array($base_icon, $this->brands)) {
				$classes[] = 'fab';
			} else {
				$classes[] = 'fas';
			}
	
			$classes[] = "fa-{$base_icon}";
		}

		$vars['class'] = array_unique($classes);
	
		return $vars;
	}
}
