[![ElkArte](https://raw.github.com/elkarte/Elkarte/master/themes/default/images/logo.png "ElkArte")](https://www.elkarte.net "ElkArte")

This is the **ElkArte** repository.

ElkArte is a modern, free, powerful community building forum software. It is completely free and licensed with an open source [BSD 3-clause license](http://www.opensource.org/licenses/BSD-3-Clause).

Initially based on Simple Machines Forum (SMF), it began as an overhaul of the code; to modernise, implement new features and make a forum software more relevant in a time of unprecedented social interaction. It has grown to become a modern and feature rich forum package to meet the demands of today's message board user.

Enjoy the benefits of enthusiasts from around the world who spend time making ElkArte what it is today.

Test ElkArte yourself by [visiting ElkArte.net](https://www.elkarte.net).

Contributions to documentation are licensed under [CC-by-SA 3](http://creativecommons.org/licenses/by-sa/3.0). Third party libraries or sets of images, are under their own licenses.

![Build Status](https://github.com/elkarte/Elkarte/workflows/UnitTests/badge.svg)
[![Open Issues](https://img.shields.io/github/issues/elkarte/Elkarte.svg?style=flat)](https://github.com/elkarte/Elkarte/issues)
[![Downloads](https://img.shields.io/github/downloads/elkArte/Elkarte/total)](https://github.com/elkarte/Elkarte/releases)
[![Current Release](https://img.shields.io/github/release/elkarte/ElkArte.svg?style=flat)](https://github.com/elkarte/ElkArte/releases)
[![License](https://img.shields.io/badge/License-BSD-green.svg?style=flat)](http://opensource.org/licenses/BSD-3-Clause)

## A small sample of ElkArte's features
* @Mentioning users including site and/or email notifications
* Likes for posts and topics
* Drafts, including auto save
* OpenID 2.0 (BC Math must be available)
* Two built in modern, responsive themes
* Integrated video embedding for youtube, tiktok, vimeo and dailymotion
* Drag and drop post attachments
* Improved password hashing using industry standards
* Drag and drop ordering (boards, categories, custom profile fields) in the admin panel
* Improved Anti Spam measures
* Bad Behaviour built in
* Automatic combining and minifying of JavaScript and CSS
* Posting and Replying by Email (PM's and Posts)
* Ajax previews and responses throughout the user interface
* Utilizes jQuery and Font Awesome
* Quick Quote allows quoting selected text in your post
* webP image support (GD or Imagick must have support)

## Requirements

* PHP version 5.3 or newer, (works on 8.1)
* MySQL 5 and newer OR PostgreSQL 8.3 and newer

On the client side, ElkArte will run & look good with its responsive theme in just about any modern browser, smartphone or tablet.



## Setting up an ElkArte Forum:

If you're not here to play with the open source code, but instead would like to set up an ElkArte forum, follow these steps.  Since ElkArte is built to be simple to use, its installation is no exception.

* Create a database for your forum using a tool like PHPMyAdmin
* Get the latest [Install Package](https://github.com/elkarte/Elkarte/releases) for ElkArte.
* Upload and extract the entire file structure up to your web server.
* Confirm the folders are writable by PHP.
* Navigate to that folder in your web browser
* Follow the instructions on screen.
* Enjoy !

## Migrating to ElkArte

Switching to ElkArte is fast and easy!

Simply install ElkArte using our Quick Installer (as outlined above), then utilizing the [Open Importer Engine](https://github.com/OpenImporter/openimporter) you can migrate to ElkArte from many other popular forums including SMF, phpBB, MyBB, vBulletin, XenForo and more.

## Extend ElkArte

ElkArte was built to be extensible, so you can add new features or give it your own custom look, with ease. With 100's of plugin hooks, adding new features can be done without any involved source edits.

Browse the collections of Themes and Addons created by our [awesome community](https://www.elkarte.net/community)

## Contributing:

* Troubleshoot issues you run into on the [ElkArte community forum](https://www.elkarte.net) so others can help & the developers can reference it later.
* Have a new feature idea or improvement suggestion? Use the forum to discuss it.
* File detailed issues on GitHub (what you did, and what the actual vs expected outcomes are).
* Read the [Developer's Certificate of Origin](https://github.com/elkarte/Elkarte/blob/master/DCO.txt) if you want to send us code. It means you acknowledge that you can and do license your submissions under the license of the project.
* Feel free to fork this repository and make your desired changes.

Please see our [How to contribute](https://github.com/elkarte/Elkarte/blob/master/CONTRIBUTING.md) section for more information on how to contribute to the ElkArte Project.

## Class / Method / Function documentation
ElkArte utilizes inline docblocks to provide descriptions for all of its classes, methods and functions.  This [API Documentation](https://elkarte.github.io/Doc/) is available online for viewing and searching.

## Site and IRC

Join us on IRC, on #elkarte channel on freenode.

Project site: [www.elkarte.net](https://www.elkarte.net)
