<?php

namespace SVG\Utilities\Colors;

final class ColorLookup
{
    /**
     * Obtains the RGBA component array for the given color keyword. If a string
     * that is NOT a valid keyword is given, or if the color is unknown, null is
     * returned.
     *
     * @param string $keyword The color keyword to look up.
     * @return int[]|null The RGBA components, or null.
     */
    public static function get($keyword)
    {
        $keywordLower = strtolower($keyword);

        if (!isset(self::$values[$keywordLower])) {
            return null;
        }

        return self::$values[$keywordLower];
    }

    /**
     * @var array[] $values A map of color names to their RGBA arrays.
     * @see https://www.w3.org/TR/SVG11/types.html#ColorKeywords For the source.
     */
    private static $values = array(
        'transparent'           => array(  0,   0,   0,   0),
        'aliceblue'             => array(240, 248, 255, 255),
        'antiquewhite'          => array(250, 235, 215, 255),
        'aqua'                  => array(  0, 255, 255, 255),
        'aquamarine'            => array(127, 255, 212, 255),
        'azure'                 => array(240, 255, 255, 255),
        'beige'                 => array(245, 245, 220, 255),
        'bisque'                => array(255, 228, 196, 255),
        'black'                 => array(  0,   0,   0, 255),
        'blanchedalmond'        => array(255, 235, 205, 255),
        'blue'                  => array(  0,   0, 255, 255),
        'blueviolet'            => array(138,  43, 226, 255),
        'brown'                 => array(165,  42,  42, 255),
        'burlywood'             => array(222, 184, 135, 255),
        'cadetblue'             => array( 95, 158, 160, 255),
        'chartreuse'            => array(127, 255,   0, 255),
        'chocolate'             => array(210, 105,  30, 255),
        'coral'                 => array(255, 127,  80, 255),
        'cornflowerblue'        => array(100, 149, 237, 255),
        'cornsilk'              => array(255, 248, 220, 255),
        'crimson'               => array(220,  20,  60, 255),
        'cyan'                  => array(  0, 255, 255, 255),
        'darkblue'              => array(  0,   0, 139, 255),
        'darkcyan'              => array(  0, 139, 139, 255),
        'darkgoldenrod'         => array(184, 134,  11, 255),
        'darkgray'              => array(169, 169, 169, 255),
        'darkgreen'             => array(  0, 100,   0, 255),
        'darkgrey'              => array(169, 169, 169, 255),
        'darkkhaki'             => array(189, 183, 107, 255),
        'darkmagenta'           => array(139,   0, 139, 255),
        'darkolivegreen'        => array( 85, 107,  47, 255),
        'darkorange'            => array(255, 140,   0, 255),
        'darkorchid'            => array(153,  50, 204, 255),
        'darkred'               => array(139,   0,   0, 255),
        'darksalmon'            => array(233, 150, 122, 255),
        'darkseagreen'          => array(143, 188, 143, 255),
        'darkslateblue'         => array( 72,  61, 139, 255),
        'darkslategray'         => array( 47,  79,  79, 255),
        'darkslategrey'         => array( 47,  79,  79, 255),
        'darkturquoise'         => array(  0, 206, 209, 255),
        'darkviolet'            => array(148,   0, 211, 255),
        'deeppink'              => array(255,  20, 147, 255),
        'deepskyblue'           => array(  0, 191, 255, 255),
        'dimgray'               => array(105, 105, 105, 255),
        'dimgrey'               => array(105, 105, 105, 255),
        'dodgerblue'            => array( 30, 144, 255, 255),
        'firebrick'             => array(178,  34,  34, 255),
        'floralwhite'           => array(255, 250, 240, 255),
        'forestgreen'           => array( 34, 139,  34, 255),
        'fuchsia'               => array(255,   0, 255, 255),
        'gainsboro'             => array(220, 220, 220, 255),
        'ghostwhite'            => array(248, 248, 255, 255),
        'gold'                  => array(255, 215,   0, 255),
        'goldenrod'             => array(218, 165,  32, 255),
        'gray'                  => array(128, 128, 128, 255),
        'grey'                  => array(128, 128, 128, 255),
        'green'                 => array(  0, 128,   0, 255),
        'greenyellow'           => array(173, 255,  47, 255),
        'honeydew'              => array(240, 255, 240, 255),
        'hotpink'               => array(255, 105, 180, 255),
        'indianred'             => array(205,  92,  92, 255),
        'indigo'                => array( 75,   0, 130, 255),
        'ivory'                 => array(255, 255, 240, 255),
        'khaki'                 => array(240, 230, 140, 255),
        'lavender'              => array(230, 230, 250, 255),
        'lavenderblush'         => array(255, 240, 245, 255),
        'lawngreen'             => array(124, 252,   0, 255),
        'lemonchiffon'          => array(255, 250, 205, 255),
        'lightblue'             => array(173, 216, 230, 255),
        'lightcoral'            => array(240, 128, 128, 255),
        'lightcyan'             => array(224, 255, 255, 255),
        'lightgoldenrodyellow'  => array(250, 250, 210, 255),
        'lightgray'             => array(211, 211, 211, 255),
        'lightgreen'            => array(144, 238, 144, 255),
        'lightgrey'             => array(211, 211, 211, 255),
        'lightpink'             => array(255, 182, 193, 255),
        'lightsalmon'           => array(255, 160, 122, 255),
        'lightseagreen'         => array( 32, 178, 170, 255),
        'lightskyblue'          => array(135, 206, 250, 255),
        'lightslategray'        => array(119, 136, 153, 255),
        'lightslategrey'        => array(119, 136, 153, 255),
        'lightsteelblue'        => array(176, 196, 222, 255),
        'lightyellow'           => array(255, 255, 224, 255),
        'lime'                  => array(  0, 255,   0, 255),
        'limegreen'             => array( 50, 205,  50, 255),
        'linen'                 => array(250, 240, 230, 255),
        'magenta'               => array(255,   0, 255, 255),
        'maroon'                => array(128,   0,   0, 255),
        'mediumaquamarine'      => array(102, 205, 170, 255),
        'mediumblue'            => array(  0,   0, 205, 255),
        'mediumorchid'          => array(186,  85, 211, 255),
        'mediumpurple'          => array(147, 112, 219, 255),
        'mediumseagreen'        => array( 60, 179, 113, 255),
        'mediumslateblue'       => array(123, 104, 238, 255),
        'mediumspringgreen'     => array(  0, 250, 154, 255),
        'mediumturquoise'       => array( 72, 209, 204, 255),
        'mediumvioletred'       => array(199,  21, 133, 255),
        'midnightblue'          => array( 25,  25, 112, 255),
        'mintcream'             => array(245, 255, 250, 255),
        'mistyrose'             => array(255, 228, 225, 255),
        'moccasin'              => array(255, 228, 181, 255),
        'navajowhite'           => array(255, 222, 173, 255),
        'navy'                  => array(  0,   0, 128, 255),
        'oldlace'               => array(253, 245, 230, 255),
        'olive'                 => array(128, 128,   0, 255),
        'olivedrab'             => array(107, 142,  35, 255),
        'orange'                => array(255, 165,   0, 255),
        'orangered'             => array(255,  69,   0, 255),
        'orchid'                => array(218, 112, 214, 255),
        'palegoldenrod'         => array(238, 232, 170, 255),
        'palegreen'             => array(152, 251, 152, 255),
        'paleturquoise'         => array(175, 238, 238, 255),
        'palevioletred'         => array(219, 112, 147, 255),
        'papayawhip'            => array(255, 239, 213, 255),
        'peachpuff'             => array(255, 218, 185, 255),
        'peru'                  => array(205, 133,  63, 255),
        'pink'                  => array(255, 192, 203, 255),
        'plum'                  => array(221, 160, 221, 255),
        'powderblue'            => array(176, 224, 230, 255),
        'purple'                => array(128,   0, 128, 255),
        'red'                   => array(255,   0,   0, 255),
        'rosybrown'             => array(188, 143, 143, 255),
        'royalblue'             => array( 65, 105, 225, 255),
        'saddlebrown'           => array(139,  69,  19, 255),
        'salmon'                => array(250, 128, 114, 255),
        'sandybrown'            => array(244, 164,  96, 255),
        'seagreen'              => array( 46, 139,  87, 255),
        'seashell'              => array(255, 245, 238, 255),
        'sienna'                => array(160,  82,  45, 255),
        'silver'                => array(192, 192, 192, 255),
        'skyblue'               => array(135, 206, 235, 255),
        'slateblue'             => array(106,  90, 205, 255),
        'slategray'             => array(112, 128, 144, 255),
        'slategrey'             => array(112, 128, 144, 255),
        'snow'                  => array(255, 250, 250, 255),
        'springgreen'           => array(  0, 255, 127, 255),
        'steelblue'             => array( 70, 130, 180, 255),
        'tan'                   => array(210, 180, 140, 255),
        'teal'                  => array(  0, 128, 128, 255),
        'thistle'               => array(216, 191, 216, 255),
        'tomato'                => array(255,  99,  71, 255),
        'turquoise'             => array( 64, 224, 208, 255),
        'violet'                => array(238, 130, 238, 255),
        'wheat'                 => array(245, 222, 179, 255),
        'white'                 => array(255, 255, 255, 255),
        'whitesmoke'            => array(245, 245, 245, 255),
        'yellow'                => array(255, 255,   0, 255),
        'yellowgreen'           => array(154, 205,  50, 255),
    );
}
