<x-marketing-layout>
    <x-slot name="title">Privacy Policy - Event Schedule</x-slot>
    <x-slot name="description">Privacy Policy for Event Schedule - how we collect, use, and protect your data.</x-slot>
    <x-slot name="keywords">event schedule privacy, data protection, GDPR compliance, Google Calendar privacy, data security</x-slot>

    <!-- Header -->
    <section class="py-16 bg-gray-50 dark:bg-gray-800/50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-4">Privacy Policy</h1>
            <p class="text-gray-600 dark:text-gray-400">Event Schedule LLC</p>
        </div>
    </section>

    <!-- Content -->
    <section class="py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="prose prose-lg dark:prose-invert max-w-none">

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Privacy Policy, Consent to Process</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    This DPA (Data Privacy Addendum) applies to EventSchedule.com and all associated subdomains owned and operated by Event Schedule. PII (Personally Identifiable Information) is collected directly through account registration. This policy describes your options in deleting/purging your data permanently from Event Schedule in compliance with GDPR.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Security Procedures & Encryption</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    We implement technical safeguards to protect your data from unauthorized access. All data transmitted between our systems and users is encrypted using industry-standard encryption protocols (HTTPS/TLS). Sensitive information is also encrypted at rest. Access to user data is restricted through authentication mechanisms and role-based access controls.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Data obtained through Google APIs is handled in accordance with Google's policies and is never sold or shared with third parties. Such data is retained only as long as necessary for service provision and is deleted upon revocation of access.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Use of Google Calendar Data</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Users must explicitly authorize access to their Google Calendar data through Google's OAuth authorization process. We access Google Calendar data solely to provide and improve the core functionality of our services, including:
                </p>
                <ul class="list-disc pl-6 text-gray-600 dark:text-gray-300 mb-4 space-y-2">
                    <li>Viewing, creating, updating, or deleting calendar events as requested by the user</li>
                    <li>Synchronizing events between Google Calendar and Event Schedule</li>
                    <li>Sending notifications and reminders related to calendar events</li>
                </ul>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    We do not use Google Calendar data for advertising, marketing, or profiling purposes.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Google Calendar Data Storage & Retention</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    We retain Google Calendar data only for as long as necessary to provide our services. If you revoke access to your Google Calendar data through your Google Account settings, we will stop accessing your data and delete any stored calendar data within a reasonable timeframe, unless retention is required for legal or security purposes.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Google Calendar Limited Use Compliance</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Our use of Google Calendar data complies with the Google API Services User Data Policy, including the Limited Use requirements. We only access, use, store, and share Google Calendar data as permitted by these policies and only for the features and services explicitly requested by the user.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Consent: PII Data We Collect</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    We collect the following personal information:
                </p>
                <ul class="list-disc pl-6 text-gray-600 dark:text-gray-300 mb-6 space-y-2">
                    <li>Account name and email address</li>
                    <li>Optional company information (name, website, ID, VAT, phone, address, industry)</li>
                    <li>Geolocation based on IP address</li>
                    <li>For paid accounts: billing information including the last four digits of your card, expiration date, and billing address</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Third Party Data Access</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Per GDPR requirements, we disclose the third-party vendors that may access your data to operate our system:
                </p>
                <ul class="list-disc pl-6 text-gray-600 dark:text-gray-300 mb-6 space-y-2">
                    <li>Cloudflare - Content delivery and security</li>
                    <li>Google Apps - Email and productivity services</li>
                    <li>Stripe - Payment processing</li>
                    <li>SendGrid/Twilio - Email delivery</li>
                </ul>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Restriction/Erasure: Purging PII Data</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    To permanently delete your account and all associated data:
                </p>
                <ol class="list-decimal pl-6 text-gray-600 dark:text-gray-300 mb-4 space-y-2">
                    <li>Log in to your account</li>
                    <li>Click "Profile" from the top right menu</li>
                    <li>Scroll down to find the "Delete Account" option</li>
                    <li>Click "Delete Account" to permanently remove your data</li>
                </ol>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    The above method of data purge is final, total, and irreversible.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">How We Use Cookies</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    A cookie is a small file which asks permission to be placed on your computer's hard drive. Cookies help us analyze web traffic and remember your preferences. They allow web applications to tailor operations to your needs by gathering and storing information about your preferences.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Links to Other Websites</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Our website may contain links to other sites. Once you leave our site via these links, we have no control over that other website. We are not responsible for the protection and privacy of any information you provide on those sites, and they are not governed by this privacy policy or our terms of service.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Newsletter & Removal</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    We periodically send newsletters announcing new features to the email address registered with your account. You can request your email address purged from newsletters by contacting <a href="mailto:privacy@eventschedule.com" class="text-blue-600 dark:text-blue-400 hover:underline">privacy@eventschedule.com</a> or clicking the "unsubscribe" link in any newsletter. Note that we may still send legally required notifications to your registered email.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Age of Consent Privacy</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Our Service does not address anyone under the age of 18. We do not knowingly collect personally identifiable information from anyone under the age of 18. If you are a parent or guardian and you are aware that your child has provided us with personal data, please contact us immediately. If we become aware that we have collected personal data from anyone under the age of 18 without verification of parental consent, we will take steps to remove that information.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Changes to This Privacy Policy</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    We may update this privacy policy from time to time to reflect changes in our practices. If we make material changes, we will notify you by email and newsletter to your registered email address. We encourage you to periodically review this page for the latest information on our privacy practices.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Communication & Resolution</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    If you have any questions about your privacy, data usage, or how to purge your data, please contact us at <a href="mailto:privacy@eventschedule.com" class="text-blue-600 dark:text-blue-400 hover:underline">privacy@eventschedule.com</a>
                </p>
            </div>
        </div>
    </section>
</x-marketing-layout>
