<x-marketing-layout>
    <x-slot name="title">Self-Hosting Terms of Service - Event Schedule</x-slot>
    <x-slot name="description">Terms of Service for self-hosting Event Schedule - the rules and guidelines for running the open-source platform.</x-slot>
    <x-slot name="keywords">event schedule self-hosting, self-hosted terms, open source terms, event platform self-host</x-slot>

    <!-- Header -->
    <section class="py-16 bg-gray-50 dark:bg-gray-800/50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-4">Self-Hosting Terms of Service</h1>
            <p class="text-gray-600 dark:text-gray-400">Event Schedule LLC</p>
        </div>
    </section>

    <!-- Content -->
    <section class="py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="prose prose-lg dark:prose-invert max-w-none">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Self-hosting Event Schedule</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    All features from the hosted app are included in the open-source code. By self-hosting Event Schedule, you accept the platform "as is" and "with all faults," assuming all risks associated with running and maintaining your own instance.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Reselling Restrictions</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    The platform cannot be resold, integrated with third-party software for commercial purposes, white-labeled, or remarketed without a formal reseller agreement from Event Schedule LLC. For reseller inquiries, contact: <a href="mailto:contact@eventschedule.com" class="text-blue-600 dark:text-blue-400 hover:underline">contact@eventschedule.com</a>
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Data Ownership</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Self-hosters own their data and bear full responsibility for it. Event Schedule cannot access, modify, or remove self-hosted data.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Users must handle any losses or damages affecting their clients independently.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Amendment Rights</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Event Schedule may modify these terms with notice via email, dashboards, or websites. Changes become binding seven days after notice, unless longer periods apply by law. Users must cease use if they reject changes.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Definitions</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    "User Accounts" access eventschedule.com services. Their clients and attendees are referred to as "Clients."
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    The terms "data" and "content" are used interchangeably throughout this agreement.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Eligibility</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Users must be 18 years of age or older and confirm compliance with applicable laws. Prior suspension or removal from Event Schedule services disqualifies new access.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Personal Responsibility</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Users are responsible for securing their credentials and handling all legal obligations regarding data privacy, copyright, and international regulations independently.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Your Obligations</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Users remain solely responsible for goods, services, and customer obligations facilitated through the platform.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Customer Service</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Users provide their own customer support. Event Schedule only assists account users with platform functionality on the hosted version.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Data Use</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You hereby grant Event Schedule a non-exclusive, fully sublicensable, worldwide, royalty-free right to collect, use, copy, store, and transmit data solely for the purpose of providing services to User Accounts.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Restricted Businesses</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Illegal activities and high-risk jurisdictions (Cuba, Iran, North Korea, Crimea, Syria) are prohibited.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Prohibited categories include gambling, telemarketing, unauthorized multi-level marketing, weapons sales, and other restricted business types.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Indemnity & Liability</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Users indemnify Event Schedule against claims arising from platform use, agreement violations, or third-party rights infringement.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Event Schedule disclaims liability for damages, lost profits, or data loss.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Communication & Resolution</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    For privacy and data concerns, contact: <a href="mailto:legal@eventschedule.com" class="text-blue-600 dark:text-blue-400 hover:underline">legal@eventschedule.com</a>
                </p>
            </div>
        </div>
    </section>
</x-marketing-layout>
