<x-marketing-layout>
    <x-slot name="title">Terms of Service - Event Schedule</x-slot>
    <x-slot name="description">Terms of Service for Event Schedule - the rules and guidelines for using our platform.</x-slot>
    <x-slot name="keywords">event schedule terms, terms of service, user agreement, platform terms, event hosting terms</x-slot>

    <!-- Header -->
    <section class="py-16 bg-gray-50 dark:bg-gray-800/50">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-4">Terms of Service</h1>
            <p class="text-gray-600 dark:text-gray-400">Event Schedule LLC</p>
        </div>
    </section>

    <!-- Content -->
    <section class="py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="prose prose-lg dark:prose-invert max-w-none">
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    By Creating an Account with Event Schedule you are agreeing to the following terms. These Terms of Service apply to all websites, subdomains and URL extensions, including but not limited to eventschedule.com, owned by Event Schedule LLC. By utilizing the eventschedule.com website you are agreeing to the following terms of service & conditions of use and constitute a binding agreement. If you do not agree to the below terms & conditions, do not use the Event Schedule platform.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Definitions</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Users who create accounts to offer events and/or services on eventschedule.com are defined as "User Accounts" which include "Hosts", "Talent", "Venues", "Curators" or "Influences."
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Clients who use eventschedule.com services to view and/or book events are defined as "Attendees" or "Guests".
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Account Eligibility</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    By agreeing to these Terms, you represent and warrant to us: (i) that you are at least eighteen (18) years of age; (ii) that you have not previously been suspended or removed from the Website and (iii) that your use of the Website is in compliance with any and all applicable laws and regulations.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Personal Responsibility</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    User Accounts are responsible for all activity occurring within their account and saved profile and events including all laws relating to personal & public data, privacy, personal information, international copyright and trademark laws.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Profile & Event Legality</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Your profile and event data and its transfer must not violate any applicable local, state, federal and international laws and regulations ("Laws") (including without limitation those relating to export control or electronic communications).
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Your Event Obligations</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You are solely responsible for, and Event Schedule disclaims all liability for, the provision of any goods or services promoted and/or sold to your customers and/or attendees as part of your use of the Event Schedule platform, and any obligations you may owe to your clients.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Customer Service</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Customer service for your own event is your responsibility. We provide customer service to you, the account user, for use of the Event Schedule platform.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You are solely responsible for all customer service policies and issues relating to your profile and events. In performing customer service for your profile or event, you will always present yourself as a separate entity from Event Schedule.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Data Ownership & Access</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    The User owns all data generated in their eventschedule.com account.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Event Schedule will not access, modify or distribute User account data.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Platform Service & Data Use</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You hereby grant Event Schedule a non-exclusive, fully sublicensable, worldwide, royalty-free right to collect, use, copy, store, and transmit data solely for the purpose of providing services to User Accounts.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Limited License & Termination of Use</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Event Schedule grants Users & Clients a limited license to access eventschedule.com This limited license may be revoked if deemed legally necessary, without notice to the User or Client and penalty to Event Schedule.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You will lose your license to use the Service if you violate any provision of this Agreement. Event Schedule's policy is to investigate violations of this Agreement before terminating/deactivating accounts, however the decision to terminate any User account is the sole discretion of Event Schedule.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Limitation of Liability</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    To the maximum extent permitted by applicable law, in no event shall Event Schedule or its suppliers be liable for any special, incidental, indirect, or consequential damages whatsoever (including, but not limited to, damages for loss of profits, loss of data or other information, for business interruption, for personal injury, loss of privacy arising out of or in any way related to the use of or inability to use the Service, third-party software and/or third-party hardware used with the Service, or otherwise in connection with any provision of this Terms), even if the Company or any supplier has been advised of the possibility of such damages and even if the remedy fails of its essential purpose.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">"As Is" and "As Available" Disclaimer</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Without limiting the foregoing, neither Event Schedule nor any of the company's provider makes any representation or warranty of any kind, express or implied: (i) as to the operation or availability of the Service, or the information, content, and materials or products included thereon; (ii) that the Service will be uninterrupted or error-free; (iii) as to the accuracy, reliability, or currency of any information or content provided through the Service; or (iv) that the Service, its servers, the content, or e-mails sent from or on behalf of the Company are free of viruses, scripts, trojan horses, worms, malware, timebombs or other harmful components.
                </p>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Some jurisdictions do not allow the exclusion of certain types of warranties or limitations on applicable statutory rights of a consumer, so some or all of the above exclusions and limitations may not apply to You. But in such a case the exclusions and limitations set forth in this section shall be applied to the greatest extent enforceable under applicable law.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">United States Legal Compliance</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    You represent and warrant that (i) You are not located in a country that is subject to the United States government embargo, or that has been designated by the United States government as a "terrorist supporting" country, and (ii) You are not listed on any United States government list of prohibited or restricted parties.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Governing Law</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    The laws of the United States of America, State of Florida, shall govern these Terms of Service & Conditions of Use. Your use of Event Schedule may also be subject to other local, state, national, or international laws.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Right to Amend</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Event Schedule may amend this Agreement upon notice to you, which may be provided through email, your account dashboard, and/or the Event Schedule website. You agree that any changes to this Agreement will be binding on you 7 days after the amendment is made (or, if a longer period if required by applicable law). If you elect to not accept the changes to this Agreement, you must immediately cancel/cease using the Event Schedule platform.
                </p>

                <h2 class="text-2xl font-bold text-gray-900 dark:text-white mt-8 mb-4">Communication & Resolution</h2>
                <p class="text-gray-600 dark:text-gray-300 mb-6">
                    Questions regarding the terms & conditions of Event Schedule account(s), contact: <a href="mailto:legal@eventschedule.com" class="text-blue-600 dark:text-blue-400 hover:underline">legal@eventschedule.com</a>
                </p>
            </div>
        </div>
    </section>
</x-marketing-layout>
