

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `script_faveo203`
--


-- --------------------------------------------------------

--
-- Table structure for table `api_settings`
--

CREATE TABLE `api_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `banlist`
--

CREATE TABLE `banlist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ban_status` tinyint(1) NOT NULL DEFAULT '0',
  `email_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `bar_notifications`
--

CREATE TABLE `bar_notifications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `canned_response`
--

CREATE TABLE `canned_response` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `common_settings`
--

CREATE TABLE `common_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `optional_field` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `common_settings`
--

INSERT INTO `common_settings` VALUES
(1, 'itil', NULL, '0', NULL, NULL, NULL),
(2, 'ticket_token_time_duration', '1', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'enable_rtl', '', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(4, 'user_set_ticket_status', NULL, '1', NULL, '[[regtime]]', '[[regtime]]'),
(5, 'send_otp', NULL, '0', NULL, '[[regtime]]', '[[regtime]]'),
(6, 'email_mandatory', NULL, '1', NULL, '[[regtime]]', '[[regtime]]'),
(7, 'user_priority', NULL, '0', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `conditions`
--

CREATE TABLE `conditions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `job` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `country_code`
--

CREATE TABLE `country_code` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `iso` char(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nicename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iso3` char(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phonecode` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `country_code`
--

INSERT INTO `country_code` VALUES
(1, 'AF', 'AFGHANISTAN', 'Afghanistan', 'AFG', '4', 93, '[[regtime]]', '[[regtime]]'),
(2, 'AL', 'ALBANIA', 'Albania', 'ALB', '8', 355, '[[regtime]]', '[[regtime]]'),
(3, 'DZ', 'ALGERIA', 'Algeria', 'DZA', '12', 213, '[[regtime]]', '[[regtime]]'),
(4, 'AS', 'AMERICAN SAMOA', 'American Samoa', 'ASM', '16', 1684, '[[regtime]]', '[[regtime]]'),
(5, 'AD', 'ANDORRA', 'Andorra', 'AND', '20', 376, '[[regtime]]', '[[regtime]]'),
(6, 'AO', 'ANGOLA', 'Angola', 'AGO', '24', 244, '[[regtime]]', '[[regtime]]'),
(7, 'AI', 'ANGUILLA', 'Anguilla', 'AIA', '660', 1264, '[[regtime]]', '[[regtime]]'),
(8, 'AQ', 'ANTARCTICA', 'Antarctica', 'NULL', 'NULL', 0, '[[regtime]]', '[[regtime]]'),
(9, 'AG', 'ANTIGUA AND BARBUDA', 'Antigua and Barbuda', 'ATG', '28', 1268, '[[regtime]]', '[[regtime]]'),
(10, 'AR', 'ARGENTINA', 'Argentina', 'ARG', '32', 54, '[[regtime]]', '[[regtime]]'),
(11, 'AM', 'ARMENIA', 'Armenia', 'ARM', '51', 374, '[[regtime]]', '[[regtime]]'),
(12, 'AW', 'ARUBA', 'Aruba', 'ABW', '533', 297, '[[regtime]]', '[[regtime]]'),
(13, 'AU', 'AUSTRALIA', 'Australia', 'AUS', '36', 61, '[[regtime]]', '[[regtime]]'),
(14, 'AT', 'AUSTRIA', 'Austria', 'AUT', '40', 43, '[[regtime]]', '[[regtime]]'),
(15, 'AZ', 'AZERBAIJAN', 'Azerbaijan', 'AZE', '31', 994, '[[regtime]]', '[[regtime]]'),
(16, 'BS', 'BAHAMAS', 'Bahamas', 'BHS', '44', 1242, '[[regtime]]', '[[regtime]]'),
(17, 'BH', 'BAHRAIN', 'Bahrain', 'BHR', '48', 973, '[[regtime]]', '[[regtime]]'),
(18, 'BD', 'BANGLADESH', 'Bangladesh', 'BGD', '50', 880, '[[regtime]]', '[[regtime]]'),
(19, 'BB', 'BARBADOS', 'Barbados', 'BRB', '52', 1246, '[[regtime]]', '[[regtime]]'),
(20, 'BY', 'BELARUS', 'Belarus', 'BLR', '112', 375, '[[regtime]]', '[[regtime]]'),
(21, 'BE', 'BELGIUM', 'Belgium', 'BEL', '56', 32, '[[regtime]]', '[[regtime]]'),
(22, 'BZ', 'BELIZE', 'Belize', 'BLZ', '84', 501, '[[regtime]]', '[[regtime]]'),
(23, 'BJ', 'BENIN', 'Benin', 'BEN', '204', 229, '[[regtime]]', '[[regtime]]'),
(24, 'BM', 'BERMUDA', 'Bermuda', 'BMU', '60', 1441, '[[regtime]]', '[[regtime]]'),
(25, 'BT', 'BHUTAN', 'Bhutan', 'BTN', '64', 975, '[[regtime]]', '[[regtime]]'),
(26, 'BO', 'BOLIVIA', 'Bolivia', 'BOL', '68', 591, '[[regtime]]', '[[regtime]]'),
(27, 'BA', 'BOSNIA AND HERZEGOVINA', 'Bosnia and Herzegovina', 'BIH', '70', 387, '[[regtime]]', '[[regtime]]'),
(28, 'BW', 'BOTSWANA', 'Botswana', 'BWA', '72', 267, '[[regtime]]', '[[regtime]]'),
(29, 'BV', 'BOUVET ISLAND', 'Bouvet Island', 'NULL', 'NULL', 0, '[[regtime]]', '[[regtime]]'),
(30, 'BR', 'BRAZIL', 'Brazil', 'BRA', '76', 55, '[[regtime]]', '[[regtime]]'),
(31, 'IO', 'BRITISH INDIAN OCEAN TERRITORY', 'British Indian Ocean Territory', 'NULL', 'NULL', 246, '[[regtime]]', '[[regtime]]'),
(32, 'BN', 'BRUNEI DARUSSALAM', 'Brunei Darussalam', 'BRN', '96', 673, '[[regtime]]', '[[regtime]]'),
(33, 'BG', 'BULGARIA', 'Bulgaria', 'BGR', '100', 359, '[[regtime]]', '[[regtime]]'),
(34, 'BF', 'BURKINA FASO', 'Burkina Faso', 'BFA', '854', 226, '[[regtime]]', '[[regtime]]'),
(35, 'BI', 'BURUNDI', 'Burundi', 'BDI', '108', 257, '[[regtime]]', '[[regtime]]'),
(36, 'KH', 'CAMBODIA', 'Cambodia', 'KHM', '116', 855, '[[regtime]]', '[[regtime]]'),
(37, 'CM', 'CAMEROON', 'Cameroon', 'CMR', '120', 237, '[[regtime]]', '[[regtime]]'),
(38, 'CA', 'CANADA', 'Canada', 'CAN', '124', 1, '[[regtime]]', '[[regtime]]'),
(39, 'CV', 'CAPE VERDE', 'Cape Verde', 'CPV', '132', 238, '[[regtime]]', '[[regtime]]'),
(40, 'KY', 'CAYMAN ISLANDS', 'Cayman Islands', 'CYM', '136', 1345, '[[regtime]]', '[[regtime]]'),
(41, 'CF', 'CENTRAL AFRICAN REPUBLIC', 'Central African Republic', 'CAF', '140', 236, '[[regtime]]', '[[regtime]]'),
(42, 'TD', 'CHAD', 'Chad', 'TCD', '148', 235, '[[regtime]]', '[[regtime]]'),
(43, 'CL', 'CHILE', 'Chile', 'CHL', '152', 56, '[[regtime]]', '[[regtime]]'),
(44, 'CN', 'CHINA', 'China', 'CHN', '156', 86, '[[regtime]]', '[[regtime]]'),
(45, 'CX', 'CHRISTMAS ISLAND', 'Christmas Island', 'NULL', 'NULL', 61, '[[regtime]]', '[[regtime]]'),
(46, 'CC', 'COCOS (KEELING) ISLANDS', 'Cocos (Keeling) Islands', 'NULL', 'NULL', 672, '[[regtime]]', '[[regtime]]'),
(47, 'CO', 'COLOMBIA', 'Colombia', 'COL', '170', 57, '[[regtime]]', '[[regtime]]'),
(48, 'KM', 'COMOROS', 'Comoros', 'COM', '174', 269, '[[regtime]]', '[[regtime]]'),
(49, 'CG', 'CONGO', 'Congo', 'COG', '178', 242, '[[regtime]]', '[[regtime]]'),
(50, 'CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'Congo, the Democratic Republic of the', 'COD', '180', 242, '[[regtime]]', '[[regtime]]'),
(51, 'CK', 'COOK ISLANDS', 'Cook Islands', 'COK', '184', 682, '[[regtime]]', '[[regtime]]'),
(52, 'CR', 'COSTA RICA', 'Costa Rica', 'CRI', '188', 506, '[[regtime]]', '[[regtime]]'),
(53, 'CI', 'COTE DIVOIRE', 'Cote DIvoire', 'CIV', '384', 225, '[[regtime]]', '[[regtime]]'),
(54, 'HR', 'CROATIA', 'Croatia', 'HRV', '191', 385, '[[regtime]]', '[[regtime]]'),
(55, 'CU', 'CUBA', 'Cuba', 'CUB', '192', 53, '[[regtime]]', '[[regtime]]'),
(56, 'CY', 'CYPRUS', 'Cyprus', 'CYP', '196', 357, '[[regtime]]', '[[regtime]]'),
(57, 'CZ', 'CZECH REPUBLIC', 'Czech Republic', 'CZE', '203', 420, '[[regtime]]', '[[regtime]]'),
(58, 'DK', 'DENMARK', 'Denmark', 'DNK', '208', 45, '[[regtime]]', '[[regtime]]'),
(59, 'DJ', 'DJIBOUTI', 'Djibouti', 'DJI', '262', 253, '[[regtime]]', '[[regtime]]'),
(60, 'DM', 'DOMINICA', 'Dominica', 'DMA', '212', 1767, '[[regtime]]', '[[regtime]]'),
(61, 'DO', 'DOMINICAN REPUBLIC', 'Dominican Republic', 'DOM', '214', 1809, '[[regtime]]', '[[regtime]]'),
(62, 'EC', 'ECUADOR', 'Ecuador', 'ECU', '218', 593, '[[regtime]]', '[[regtime]]'),
(63, 'EG', 'EGYPT', 'Egypt', 'EGY', '818', 20, '[[regtime]]', '[[regtime]]'),
(64, 'SV', 'EL SALVADOR', 'El Salvador', 'SLV', '222', 503, '[[regtime]]', '[[regtime]]'),
(65, 'GQ', 'EQUATORIAL GUINEA', 'Equatorial Guinea', 'GNQ', '226', 240, '[[regtime]]', '[[regtime]]'),
(66, 'ER', 'ERITREA', 'Eritrea', 'ERI', '232', 291, '[[regtime]]', '[[regtime]]'),
(67, 'EE', 'ESTONIA', 'Estonia', 'EST', '233', 372, '[[regtime]]', '[[regtime]]'),
(68, 'ET', 'ETHIOPIA', 'Ethiopia', 'ETH', '231', 251, '[[regtime]]', '[[regtime]]'),
(69, 'FK', 'FALKLAND ISLANDS (MALVINAS)', 'Falkland Islands (Malvinas)', 'FLK', '238', 500, '[[regtime]]', '[[regtime]]'),
(70, 'FO', 'FAROE ISLANDS', 'Faroe Islands', 'FRO', '234', 298, '[[regtime]]', '[[regtime]]'),
(71, 'FJ', 'FIJI', 'Fiji', 'FJI', '242', 679, '[[regtime]]', '[[regtime]]'),
(72, 'FI', 'FINLAND', 'Finland', 'FIN', '246', 358, '[[regtime]]', '[[regtime]]'),
(73, 'FR', 'FRANCE', 'France', 'FRA', '250', 33, '[[regtime]]', '[[regtime]]'),
(74, 'GF', 'FRENCH GUIANA', 'French Guiana', 'GUF', '254', 594, '[[regtime]]', '[[regtime]]'),
(75, 'PF', 'FRENCH POLYNESIA', 'French Polynesia', 'PYF', '258', 689, '[[regtime]]', '[[regtime]]'),
(76, 'TF', 'FRENCH SOUTHERN TERRITORIES', 'French Southern Territories', 'NULL', 'NULL', 0, '[[regtime]]', '[[regtime]]'),
(77, 'GA', 'GABON', 'Gabon', 'GAB', '266', 241, '[[regtime]]', '[[regtime]]'),
(78, 'GM', 'GAMBIA', 'Gambia', 'GMB', '270', 220, '[[regtime]]', '[[regtime]]'),
(79, 'GE', 'GEORGIA', 'Georgia', 'GEO', '268', 995, '[[regtime]]', '[[regtime]]'),
(80, 'DE', 'GERMANY', 'Germany', 'DEU', '276', 49, '[[regtime]]', '[[regtime]]'),
(81, 'GH', 'GHANA', 'Ghana', 'GHA', '288', 233, '[[regtime]]', '[[regtime]]'),
(82, 'GI', 'GIBRALTAR', 'Gibraltar', 'GIB', '292', 350, '[[regtime]]', '[[regtime]]'),
(83, 'GR', 'GREECE', 'Greece', 'GRC', '300', 30, '[[regtime]]', '[[regtime]]'),
(84, 'GL', 'GREENLAND', 'Greenland', 'GRL', '304', 299, '[[regtime]]', '[[regtime]]'),
(85, 'GD', 'GRENADA', 'Grenada', 'GRD', '308', 1473, '[[regtime]]', '[[regtime]]'),
(86, 'GP', 'GUADELOUPE', 'Guadeloupe', 'GLP', '312', 590, '[[regtime]]', '[[regtime]]'),
(87, 'GU', 'GUAM', 'Guam', 'GUM', '316', 1671, '[[regtime]]', '[[regtime]]'),
(88, 'GT', 'GUATEMALA', 'Guatemala', 'GTM', '320', 502, '[[regtime]]', '[[regtime]]'),
(89, 'GN', 'GUINEA', 'Guinea', 'GIN', '324', 224, '[[regtime]]', '[[regtime]]'),
(90, 'GW', 'GUINEA-BISSAU', 'Guinea-Bissau', 'GNB', '624', 245, '[[regtime]]', '[[regtime]]'),
(91, 'GY', 'GUYANA', 'Guyana', 'GUY', '328', 592, '[[regtime]]', '[[regtime]]'),
(92, 'HT', 'HAITI', 'Haiti', 'HTI', '332', 509, '[[regtime]]', '[[regtime]]'),
(93, 'HM', 'HEARD ISLAND AND MCDONALD ISLANDS', 'Heard Island and Mcdonald Islands', 'NULL', 'NULL', 0, '[[regtime]]', '[[regtime]]'),
(94, 'VA', 'HOLY SEE (VATICAN CITY STATE)', 'Holy See (Vatican City State)', 'VAT', '336', 39, '[[regtime]]', '[[regtime]]'),
(95, 'HN', 'HONDURAS', 'Honduras', 'HND', '340', 504, '[[regtime]]', '[[regtime]]'),
(96, 'HK', 'HONG KONG', 'Hong Kong', 'HKG', '344', 852, '[[regtime]]', '[[regtime]]'),
(97, 'HU', 'HUNGARY', 'Hungary', 'HUN', '348', 36, '[[regtime]]', '[[regtime]]'),
(98, 'IS', 'ICELAND', 'Iceland', 'ISL', '352', 354, '[[regtime]]', '[[regtime]]'),
(99, 'IN', 'INDIA', 'India', 'IND', '356', 91, '[[regtime]]', '[[regtime]]'),
(100, 'ID', 'INDONESIA', 'Indonesia', 'IDN', '360', 62, '[[regtime]]', '[[regtime]]'),
(101, 'IR', 'IRAN, ISLAMIC REPUBLIC OF', 'Iran, Islamic Republic of', 'IRN', '364', 98, '[[regtime]]', '[[regtime]]'),
(102, 'IQ', 'IRAQ', 'Iraq', 'IRQ', '368', 964, '[[regtime]]', '[[regtime]]'),
(103, 'IE', 'IRELAND', 'Ireland', 'IRL', '372', 353, '[[regtime]]', '[[regtime]]'),
(104, 'IL', 'ISRAEL', 'Israel', 'ISR', '376', 972, '[[regtime]]', '[[regtime]]'),
(105, 'IT', 'ITALY', 'Italy', 'ITA', '380', 39, '[[regtime]]', '[[regtime]]'),
(106, 'JM', 'JAMAICA', 'Jamaica', 'JAM', '388', 1876, '[[regtime]]', '[[regtime]]'),
(107, 'JP', 'JAPAN', 'Japan', 'JPN', '392', 81, '[[regtime]]', '[[regtime]]'),
(108, 'JO', 'JORDAN', 'Jordan', 'JOR', '400', 962, '[[regtime]]', '[[regtime]]'),
(109, 'KZ', 'KAZAKHSTAN', 'Kazakhstan', 'KAZ', '398', 7, '[[regtime]]', '[[regtime]]'),
(110, 'KE', 'KENYA', 'Kenya', 'KEN', '404', 254, '[[regtime]]', '[[regtime]]'),
(111, 'KI', 'KIRIBATI', 'Kiribati', 'KIR', '296', 686, '[[regtime]]', '[[regtime]]'),
(112, 'KP', 'KOREA, DEMOCRATIC PEOPLES REPUBLIC OF', 'Korea, Democratic Peoples Republic of', 'PRK', '408', 850, '[[regtime]]', '[[regtime]]'),
(113, 'KR', 'KOREA, REPUBLIC OF', 'Korea, Republic of', 'KOR', '410', 82, '[[regtime]]', '[[regtime]]'),
(114, 'KW', 'KUWAIT', 'Kuwait', 'KWT', '414', 965, '[[regtime]]', '[[regtime]]'),
(115, 'KG', 'KYRGYZSTAN', 'Kyrgyzstan', 'KGZ', '417', 996, '[[regtime]]', '[[regtime]]'),
(116, 'LA', 'LAO PEOPLES DEMOCRATIC REPUBLIC', 'Lao Peoples Democratic Republic', 'LAO', '418', 856, '[[regtime]]', '[[regtime]]'),
(117, 'LV', 'LATVIA', 'Latvia', 'LVA', '428', 371, '[[regtime]]', '[[regtime]]'),
(118, 'LB', 'LEBANON', 'Lebanon', 'LBN', '422', 961, '[[regtime]]', '[[regtime]]'),
(119, 'LS', 'LESOTHO', 'Lesotho', 'LSO', '426', 266, '[[regtime]]', '[[regtime]]'),
(120, 'LR', 'LIBERIA', 'Liberia', 'LBR', '430', 231, '[[regtime]]', '[[regtime]]'),
(121, 'LY', 'LIBYAN ARAB JAMAHIRIYA', 'Libyan Arab Jamahiriya', 'LBY', '434', 218, '[[regtime]]', '[[regtime]]'),
(122, 'LI', 'LIECHTENSTEIN', 'Liechtenstein', 'LIE', '438', 423, '[[regtime]]', '[[regtime]]'),
(123, 'LT', 'LITHUANIA', 'Lithuania', 'LTU', '440', 370, '[[regtime]]', '[[regtime]]'),
(124, 'LU', 'LUXEMBOURG', 'Luxembourg', 'LUX', '442', 352, '[[regtime]]', '[[regtime]]'),
(125, 'MO', 'MACAO', 'Macao', 'MAC', '446', 853, '[[regtime]]', '[[regtime]]'),
(126, 'MK', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'Macedonia, the Former Yugoslav Republic of', 'MKD', '807', 389, '[[regtime]]', '[[regtime]]'),
(127, 'MG', 'MADAGASCAR', 'Madagascar', 'MDG', '450', 261, '[[regtime]]', '[[regtime]]'),
(128, 'MW', 'MALAWI', 'Malawi', 'MWI', '454', 265, '[[regtime]]', '[[regtime]]'),
(129, 'MY', 'MALAYSIA', 'Malaysia', 'MYS', '458', 60, '[[regtime]]', '[[regtime]]'),
(130, 'MV', 'MALDIVES', 'Maldives', 'MDV', '462', 960, '[[regtime]]', '[[regtime]]'),
(131, 'ML', 'MALI', 'Mali', 'MLI', '466', 223, '[[regtime]]', '[[regtime]]'),
(132, 'MT', 'MALTA', 'Malta', 'MLT', '470', 356, '[[regtime]]', '[[regtime]]'),
(133, 'MH', 'MARSHALL ISLANDS', 'Marshall Islands', 'MHL', '584', 692, '[[regtime]]', '[[regtime]]'),
(134, 'MQ', 'MARTINIQUE', 'Martinique', 'MTQ', '474', 596, '[[regtime]]', '[[regtime]]'),
(135, 'MR', 'MAURITANIA', 'Mauritania', 'MRT', '478', 222, '[[regtime]]', '[[regtime]]'),
(136, 'MU', 'MAURITIUS', 'Mauritius', 'MUS', '480', 230, '[[regtime]]', '[[regtime]]'),
(137, 'YT', 'MAYOTTE', 'Mayotte', 'NULL', 'NULL', 269, '[[regtime]]', '[[regtime]]'),
(138, 'MX', 'MEXICO', 'Mexico', 'MEX', '484', 52, '[[regtime]]', '[[regtime]]'),
(139, 'FM', 'MICRONESIA, FEDERATED STATES OF', 'Micronesia, Federated States of', 'FSM', '583', 691, '[[regtime]]', '[[regtime]]'),
(140, 'MD', 'MOLDOVA, REPUBLIC OF', 'Moldova, Republic of', 'MDA', '498', 373, '[[regtime]]', '[[regtime]]'),
(141, 'MC', 'MONACO', 'Monaco', 'MCO', '492', 377, '[[regtime]]', '[[regtime]]'),
(142, 'MN', 'MONGOLIA', 'Mongolia', 'MNG', '496', 976, '[[regtime]]', '[[regtime]]'),
(143, 'MS', 'MONTSERRAT', 'Montserrat', 'MSR', '500', 1664, '[[regtime]]', '[[regtime]]'),
(144, 'MA', 'MOROCCO', 'Morocco', 'MAR', '504', 212, '[[regtime]]', '[[regtime]]'),
(145, 'MZ', 'MOZAMBIQUE', 'Mozambique', 'MOZ', '508', 258, '[[regtime]]', '[[regtime]]'),
(146, 'MM', 'MYANMAR', 'Myanmar', 'MMR', '104', 95, '[[regtime]]', '[[regtime]]'),
(147, 'NA', 'NAMIBIA', 'Namibia', 'NAM', '516', 264, '[[regtime]]', '[[regtime]]'),
(148, 'NR', 'NAURU', 'Nauru', 'NRU', '520', 674, '[[regtime]]', '[[regtime]]'),
(149, 'NP', 'NEPAL', 'Nepal', 'NPL', '524', 977, '[[regtime]]', '[[regtime]]'),
(150, 'NL', 'NETHERLANDS', 'Netherlands', 'NLD', '528', 31, '[[regtime]]', '[[regtime]]'),
(151, 'AN', 'NETHERLANDS ANTILLES', 'Netherlands Antilles', 'ANT', '530', 599, '[[regtime]]', '[[regtime]]'),
(152, 'NC', 'NEW CALEDONIA', 'New Caledonia', 'NCL', '540', 687, '[[regtime]]', '[[regtime]]'),
(153, 'NZ', 'NEW ZEALAND', 'New Zealand', 'NZL', '554', 64, '[[regtime]]', '[[regtime]]'),
(154, 'NI', 'NICARAGUA', 'Nicaragua', 'NIC', '558', 505, '[[regtime]]', '[[regtime]]'),
(155, 'NE', 'NIGER', 'Niger', 'NER', '562', 227, '[[regtime]]', '[[regtime]]'),
(156, 'NG', 'NIGERIA', 'Nigeria', 'NGA', '566', 234, '[[regtime]]', '[[regtime]]'),
(157, 'NU', 'NIUE', 'Niue', 'NIU', '570', 683, '[[regtime]]', '[[regtime]]'),
(158, 'NF', 'NORFOLK ISLAND', 'Norfolk Island', 'NFK', '574', 672, '[[regtime]]', '[[regtime]]'),
(159, 'MP', 'NORTHERN MARIANA ISLANDS', 'Northern Mariana Islands', 'MNP', '580', 1670, '[[regtime]]', '[[regtime]]'),
(160, 'NO', 'NORWAY', 'Norway', 'NOR', '578', 47, '[[regtime]]', '[[regtime]]'),
(161, 'OM', 'OMAN', 'Oman', 'OMN', '512', 968, '[[regtime]]', '[[regtime]]'),
(162, 'PK', 'PAKISTAN', 'Pakistan', 'PAK', '586', 92, '[[regtime]]', '[[regtime]]'),
(163, 'PW', 'PALAU', 'Palau', 'PLW', '585', 680, '[[regtime]]', '[[regtime]]'),
(164, 'PS', 'PALESTINIAN TERRITORY, OCCUPIED', 'Palestinian Territory, Occupied', 'NULL', 'NULL', 970, '[[regtime]]', '[[regtime]]'),
(165, 'PA', 'PANAMA', 'Panama', 'PAN', '591', 507, '[[regtime]]', '[[regtime]]'),
(166, 'PG', 'PAPUA NEW GUINEA', 'Papua New Guinea', 'PNG', '598', 675, '[[regtime]]', '[[regtime]]'),
(167, 'PY', 'PARAGUAY', 'Paraguay', 'PRY', '600', 595, '[[regtime]]', '[[regtime]]'),
(168, 'PE', 'PERU', 'Peru', 'PER', '604', 51, '[[regtime]]', '[[regtime]]'),
(169, 'PH', 'PHILIPPINES', 'Philippines', 'PHL', '608', 63, '[[regtime]]', '[[regtime]]'),
(170, 'PN', 'PITCAIRN', 'Pitcairn', 'PCN', '612', 0, '[[regtime]]', '[[regtime]]'),
(171, 'PL', 'POLAND', 'Poland', 'POL', '616', 48, '[[regtime]]', '[[regtime]]'),
(172, 'PT', 'PORTUGAL', 'Portugal', 'PRT', '620', 351, '[[regtime]]', '[[regtime]]'),
(173, 'PR', 'PUERTO RICO', 'Puerto Rico', 'PRI', '630', 1787, '[[regtime]]', '[[regtime]]'),
(174, 'QA', 'QATAR', 'Qatar', 'QAT', '634', 974, '[[regtime]]', '[[regtime]]'),
(175, 'RE', 'REUNION', 'Reunion', 'REU', '638', 262, '[[regtime]]', '[[regtime]]'),
(176, 'RO', 'ROMANIA', 'Romania', 'ROM', '642', 40, '[[regtime]]', '[[regtime]]'),
(177, 'RU', 'RUSSIAN FEDERATION', 'Russian Federation', 'RUS', '643', 70, '[[regtime]]', '[[regtime]]'),
(178, 'RW', 'RWANDA', 'Rwanda', 'RWA', '646', 250, '[[regtime]]', '[[regtime]]'),
(179, 'SH', 'SAINT HELENA', 'Saint Helena', 'SHN', '654', 290, '[[regtime]]', '[[regtime]]'),
(180, 'KN', 'SAINT KITTS AND NEVIS', 'Saint Kitts and Nevis', 'KNA', '659', 1869, '[[regtime]]', '[[regtime]]'),
(181, 'LC', 'SAINT LUCIA', 'Saint Lucia', 'LCA', '662', 1758, '[[regtime]]', '[[regtime]]'),
(182, 'PM', 'SAINT PIERRE AND MIQUELON', 'Saint Pierre and Miquelon', 'SPM', '666', 508, '[[regtime]]', '[[regtime]]'),
(183, 'VC', 'SAINT VINCENT AND THE GRENADINES', 'Saint Vincent and the Grenadines', 'VCT', '670', 1784, '[[regtime]]', '[[regtime]]'),
(184, 'WS', 'SAMOA', 'Samoa', 'WSM', '882', 684, '[[regtime]]', '[[regtime]]'),
(185, 'SM', 'SAN MARINO', 'San Marino', 'SMR', '674', 378, '[[regtime]]', '[[regtime]]'),
(186, 'ST', 'SAO TOME AND PRINCIPE', 'Sao Tome and Principe', 'STP', '678', 239, '[[regtime]]', '[[regtime]]'),
(187, 'SA', 'SAUDI ARABIA', 'Saudi Arabia', 'SAU', '682', 966, '[[regtime]]', '[[regtime]]'),
(188, 'SN', 'SENEGAL', 'Senegal', 'SEN', '686', 221, '[[regtime]]', '[[regtime]]'),
(189, 'CS', 'SERBIA AND MONTENEGRO', 'Serbia and Montenegro', 'NULL', 'NULL', 381, '[[regtime]]', '[[regtime]]'),
(190, 'SC', 'SEYCHELLES', 'Seychelles', 'SYC', '690', 248, '[[regtime]]', '[[regtime]]'),
(191, 'SL', 'SIERRA LEONE', 'Sierra Leone', 'SLE', '694', 232, '[[regtime]]', '[[regtime]]'),
(192, 'SG', 'SINGAPORE', 'Singapore', 'SGP', '702', 65, '[[regtime]]', '[[regtime]]'),
(193, 'SK', 'SLOVAKIA', 'Slovakia', 'SVK', '703', 421, '[[regtime]]', '[[regtime]]'),
(194, 'SI', 'SLOVENIA', 'Slovenia', 'SVN', '705', 386, '[[regtime]]', '[[regtime]]'),
(195, 'SB', 'SOLOMON ISLANDS', 'Solomon Islands', 'SLB', '90', 677, '[[regtime]]', '[[regtime]]'),
(196, 'SO', 'SOMALIA', 'Somalia', 'SOM', '706', 252, '[[regtime]]', '[[regtime]]'),
(197, 'ZA', 'SOUTH AFRICA', 'South Africa', 'ZAF', '710', 27, '[[regtime]]', '[[regtime]]'),
(198, 'GS', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'South Georgia and the South Sandwich Islands', 'NULL', 'NULL', 0, '[[regtime]]', '[[regtime]]'),
(199, 'ES', 'SPAIN', 'Spain', 'ESP', '724', 34, '[[regtime]]', '[[regtime]]'),
(200, 'LK', 'SRI LANKA', 'Sri Lanka', 'LKA', '144', 94, '[[regtime]]', '[[regtime]]'),
(201, 'SD', 'SUDAN', 'Sudan', 'SDN', '736', 249, '[[regtime]]', '[[regtime]]'),
(202, 'SR', 'SURINAME', 'Suriname', 'SUR', '740', 597, '[[regtime]]', '[[regtime]]'),
(203, 'SJ', 'SVALBARD AND JAN MAYEN', 'Svalbard and Jan Mayen', 'SJM', '744', 47, '[[regtime]]', '[[regtime]]'),
(204, 'SZ', 'SWAZILAND', 'Swaziland', 'SWZ', '748', 268, '[[regtime]]', '[[regtime]]'),
(205, 'SE', 'SWEDEN', 'Sweden', 'SWE', '752', 46, '[[regtime]]', '[[regtime]]'),
(206, 'CH', 'SWITZERLAND', 'Switzerland', 'CHE', '756', 41, '[[regtime]]', '[[regtime]]'),
(207, 'SY', 'SYRIAN ARAB REPUBLIC', 'Syrian Arab Republic', 'SYR', '760', 963, '[[regtime]]', '[[regtime]]'),
(208, 'TW', 'TAIWAN, PROVINCE OF CHINA', 'Taiwan, Province of China', 'TWN', '158', 886, '[[regtime]]', '[[regtime]]'),
(209, 'TJ', 'TAJIKISTAN', 'Tajikistan', 'TJK', '762', 992, '[[regtime]]', '[[regtime]]'),
(210, 'TZ', 'TANZANIA, UNITED REPUBLIC OF', 'Tanzania, United Republic of', 'TZA', '834', 255, '[[regtime]]', '[[regtime]]'),
(211, 'TH', 'THAILAND', 'Thailand', 'THA', '764', 66, '[[regtime]]', '[[regtime]]'),
(212, 'TL', 'TIMOR-LESTE', 'Timor-Leste', 'NULL', 'NULL', 670, '[[regtime]]', '[[regtime]]'),
(213, 'TG', 'TOGO', 'Togo', 'TGO', '768', 228, '[[regtime]]', '[[regtime]]'),
(214, 'TK', 'TOKELAU', 'Tokelau', 'TKL', '772', 690, '[[regtime]]', '[[regtime]]'),
(215, 'TO', 'TONGA', 'Tonga', 'TON', '776', 676, '[[regtime]]', '[[regtime]]'),
(216, 'TT', 'TRINIDAD AND TOBAGO', 'Trinidad and Tobago', 'TTO', '780', 1868, '[[regtime]]', '[[regtime]]'),
(217, 'TN', 'TUNISIA', 'Tunisia', 'TUN', '788', 216, '[[regtime]]', '[[regtime]]'),
(218, 'TR', 'TURKEY', 'Turkey', 'TUR', '792', 90, '[[regtime]]', '[[regtime]]'),
(219, 'TM', 'TURKMENISTAN', 'Turkmenistan', 'TKM', '795', 7370, '[[regtime]]', '[[regtime]]'),
(220, 'TC', 'TURKS AND CAICOS ISLANDS', 'Turks and Caicos Islands', 'TCA', '796', 1649, '[[regtime]]', '[[regtime]]'),
(221, 'TV', 'TUVALU', 'Tuvalu', 'TUV', '798', 688, '[[regtime]]', '[[regtime]]'),
(222, 'UG', 'UGANDA', 'Uganda', 'UGA', '800', 256, '[[regtime]]', '[[regtime]]'),
(223, 'UA', 'UKRAINE', 'Ukraine', 'UKR', '804', 380, '[[regtime]]', '[[regtime]]'),
(224, 'AE', 'UNITED ARAB EMIRATES', 'United Arab Emirates', 'ARE', '784', 971, '[[regtime]]', '[[regtime]]'),
(225, 'GB', 'UNITED KINGDOM', 'United Kingdom', 'GBR', '826', 44, '[[regtime]]', '[[regtime]]'),
(226, 'US', 'UNITED STATES', 'United States', 'USA', '840', 1, '[[regtime]]', '[[regtime]]'),
(227, 'UM', 'UNITED STATES MINOR OUTLYING ISLANDS', 'United States Minor Outlying Islands', 'NULL', 'NULL', 1, '[[regtime]]', '[[regtime]]'),
(228, 'UY', 'URUGUAY', 'Uruguay', 'URY', '858', 598, '[[regtime]]', '[[regtime]]'),
(229, 'UZ', 'UZBEKISTAN', 'Uzbekistan', 'UZB', '860', 998, '[[regtime]]', '[[regtime]]'),
(230, 'VU', 'VANUATU', 'Vanuatu', 'VUT', '548', 678, '[[regtime]]', '[[regtime]]'),
(231, 'VE', 'VENEZUELA', 'Venezuela', 'VEN', '862', 58, '[[regtime]]', '[[regtime]]'),
(232, 'VN', 'VIET NAM', 'Viet Nam', 'VNM', '704', 84, '[[regtime]]', '[[regtime]]'),
(233, 'VG', 'VIRGIN ISLANDS, BRITISH', 'Virgin Islands, British', 'VGB', '92', 1284, '[[regtime]]', '[[regtime]]'),
(234, 'VI', 'VIRGIN ISLANDS, U.S.', 'Virgin Islands, U.s.', 'VIR', '850', 1340, '[[regtime]]', '[[regtime]]'),
(235, 'WF', 'WALLIS AND FUTUNA', 'Wallis and Futuna', 'WLF', '876', 681, '[[regtime]]', '[[regtime]]'),
(236, 'EH', 'WESTERN SAHARA', 'Western Sahara', 'ESH', '732', 212, '[[regtime]]', '[[regtime]]'),
(237, 'YE', 'YEMEN', 'Yemen', 'YEM', '887', 967, '[[regtime]]', '[[regtime]]'),
(238, 'ZM', 'ZAMBIA', 'Zambia', 'ZMB', '894', 260, '[[regtime]]', '[[regtime]]'),
(239, 'ZW', 'ZIMBABWE', 'Zimbabwe', 'ZWE', '716', 263, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `custom_forms`
--

CREATE TABLE `custom_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `formname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_form_fields`
--

CREATE TABLE `custom_form_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `forms_id` int NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `required` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `date_format`
--

CREATE TABLE `date_format` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `date_format`
--

INSERT INTO `date_format` VALUES
(1, 'dd/mm/yyyy'),
(2, 'dd-mm-yyyy'),
(3, 'dd.mm.yyyy'),
(4, 'mm/dd/yyyy'),
(5, 'mm:dd:yyyy'),
(6, 'mm-dd-yyyy'),
(7, 'yyyy/mm/dd'),
(8, 'yyyy.mm.dd'),
(9, 'yyyy-mm-dd');

-- --------------------------------------------------------

--
-- Table structure for table `date_time_format`
--

CREATE TABLE `date_time_format` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `date_time_format`
--

INSERT INTO `date_time_format` VALUES
(1, 'd/m/Y H:i:s'),
(2, 'd.m.Y H:i:s'),
(3, 'd-m-Y H:i:s'),
(4, 'm/d/Y H:i:s'),
(5, 'm.d.Y H:i:s'),
(6, 'm-d-Y H:i:s'),
(7, 'Y/m/d H:i:s'),
(8, 'Y.m.d H:i:s'),
(9, 'Y-m-d H:i:s');

-- --------------------------------------------------------

--
-- Table structure for table `department`
--

CREATE TABLE `department` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sla` int unsigned DEFAULT NULL,
  `manager` int unsigned DEFAULT NULL,
  `ticket_assignment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outgoing_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template_set` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_ticket_response` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_message_response` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_response_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recipient` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_access` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department_sign` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sla` (`sla`),
  KEY `manager_2` (`manager`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `department`
--

INSERT INTO `department` VALUES
(1, 'Support', '1', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(2, 'Sales', '1', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'Operation', '1', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `emails`
--

CREATE TABLE `emails` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` int unsigned DEFAULT NULL,
  `priority` int unsigned DEFAULT NULL,
  `help_topic` int unsigned DEFAULT NULL,
  `user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetching_host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetching_port` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetching_protocol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetching_encryption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mailbox_protocol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imap_config` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sending_host` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sending_port` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sending_protocol` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sending_encryption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_validate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_authentication` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_response` tinyint(1) NOT NULL DEFAULT '0',
  `fetching_status` tinyint(1) NOT NULL DEFAULT '0',
  `move_to_folder` tinyint(1) NOT NULL DEFAULT '0',
  `delete_email` tinyint(1) NOT NULL DEFAULT '0',
  `do_nothing` tinyint(1) NOT NULL DEFAULT '0',
  `sending_status` tinyint(1) NOT NULL DEFAULT '0',
  `authentication` tinyint(1) NOT NULL DEFAULT '0',
  `header_spoofing` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `department` (`department`,`priority`,`help_topic`),
  KEY `department_2` (`department`,`priority`,`help_topic`),
  KEY `priority` (`priority`),
  KEY `help_topic` (`help_topic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `faveo_mails`
--

CREATE TABLE `faveo_mails` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_id` int NOT NULL,
  `drive` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `faveo_queues`
--

CREATE TABLE `faveo_queues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `service_id` int NOT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `field_values`
--

CREATE TABLE `field_values` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `field_id` int unsigned DEFAULT NULL,
  `child_id` int unsigned DEFAULT NULL,
  `field_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `field_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `field_values_field_id_foreign` (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_status` tinyint(1) NOT NULL DEFAULT '0',
  `can_create_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_edit_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_post_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_close_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_assign_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_transfer_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_delete_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `can_ban_email` tinyint(1) NOT NULL DEFAULT '0',
  `can_manage_canned` tinyint(1) NOT NULL DEFAULT '0',
  `can_manage_faq` tinyint(1) NOT NULL DEFAULT '0',
  `can_view_agent_stats` tinyint(1) NOT NULL DEFAULT '0',
  `department_access` tinyint(1) NOT NULL DEFAULT '0',
  `admin_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` VALUES
(1, 'Group A', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, NULL, '[[regtime]]', '[[regtime]]'),
(2, 'Group B', 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'Group C', 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `group_assign_department`
--

CREATE TABLE `group_assign_department` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int unsigned NOT NULL,
  `department_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `help_topic`
--

CREATE TABLE `help_topic` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `topic` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_topic` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_form` int unsigned DEFAULT NULL,
  `department` int unsigned DEFAULT NULL,
  `ticket_status` int unsigned DEFAULT NULL,
  `priority` int unsigned DEFAULT NULL,
  `sla_plan` int unsigned DEFAULT NULL,
  `thank_page` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ticket_num_format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `auto_assign` int unsigned DEFAULT NULL,
  `auto_response` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_form` (`custom_form`),
  KEY `department` (`department`),
  KEY `ticket_status` (`ticket_status`),
  KEY `priority` (`priority`),
  KEY `sla_plan` (`sla_plan`),
  KEY `auto_assign_2` (`auto_assign`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `help_topic`
--

INSERT INTO `help_topic` VALUES
(1, 'Support query', NULL, NULL, 1, 1, 2, 1, NULL, '1', NULL, 1, 1, NULL, 0, '[[regtime]]', '[[regtime]]'),
(2, 'Sales query', NULL, NULL, 2, 1, 2, 1, NULL, '1', NULL, 0, 1, NULL, 0, '[[regtime]]', '[[regtime]]'),
(3, 'Operational query', NULL, NULL, 3, 1, 2, 1, NULL, '1', NULL, 0, 1, NULL, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(1) NOT NULL DEFAULT '0',
  `reserved` tinyint(1) NOT NULL DEFAULT '0',
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_reserved_reserved_at_index` (`queue`,`reserved`,`reserved_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_article`
--

CREATE TABLE `kb_article` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `publish_time` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `kb_article_relationship`
--

CREATE TABLE `kb_article_relationship` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `article_id` int unsigned NOT NULL,
  `category_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `article_relationship_article_id_foreign` (`article_id`),
  KEY `article_relationship_category_id_foreign` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_category`
--

CREATE TABLE `kb_category` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `parent` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `kb_comment`
--

CREATE TABLE `kb_comment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `article_id` int unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `comment_article_id_foreign` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_pages`
--

CREATE TABLE `kb_pages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `visibility` tinyint(1) NOT NULL DEFAULT '0',
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `kb_settings`
--

CREATE TABLE `kb_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pagination` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kb_settings`
--

INSERT INTO `kb_settings` VALUES
(1, 10, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `languages`
--

CREATE TABLE `languages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locale` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `languages`
--

INSERT INTO `languages` VALUES
(1, 'English', 'en'),
(2, 'Italian', 'it'),
(3, 'German', 'de'),
(4, 'French', 'fr'),
(5, 'Brazilian Portuguese', 'pt_BR'),
(6, 'Dutch', 'nl'),
(7, 'Spanish', 'es'),
(8, 'Norwegian', 'nb_NO'),
(9, 'Danish', 'da');

-- --------------------------------------------------------

--
-- Table structure for table `login_attempts`
--

CREATE TABLE `login_attempts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `User` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IP` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `Attempts` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `LastLogin` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `login_attempts`
--

INSERT INTO `login_attempts` VALUES
(1, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `log_notification`
--

CREATE TABLE `log_notification` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `log_notification`
--

INSERT INTO `log_notification` VALUES
(1, 'NOT-1', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `mailbox_protocol`
--

CREATE TABLE `mailbox_protocol` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mailbox_protocol`
--

INSERT INTO `mailbox_protocol` VALUES
(1, 'IMAP', '/imap'),
(2, 'IMAP+SSL', '/imap/ssl'),
(3, 'IMAP+TLS', '/imap/tls'),
(4, 'IMAP+SSL/No-validate', '/imap/ssl/novalidate-cert');

-- --------------------------------------------------------

--
-- Table structure for table `mail_services`
--

CREATE TABLE `mail_services` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `mail_services`
--

INSERT INTO `mail_services` VALUES
(1, 'SMTP', 'smtp', '[[regtime]]', '[[regtime]]'),
(2, 'Php Mail', 'mail', '[[regtime]]', '[[regtime]]'),
(3, 'Send Mail', 'sendmail', '[[regtime]]', '[[regtime]]'),
(4, 'Mailgun', 'mailgun', '[[regtime]]', '[[regtime]]'),
(5, 'Mandrill', 'mandrill', '[[regtime]]', '[[regtime]]'),
(6, 'Log file', 'log', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` VALUES
(1, '2016_02_16_140450_create_banlist_table', 1),
(2, '2016_02_16_140450_create_canned_response_table', 1),
(3, '2016_02_16_140450_create_custom_form_fields_table', 1),
(4, '2016_02_16_140450_create_custom_forms_table', 1),
(5, '2016_02_16_140450_create_date_format_table', 1),
(6, '2016_02_16_140450_create_date_time_format_table', 1),
(7, '2016_02_16_140450_create_department_table', 1),
(8, '2016_02_16_140450_create_emails_table', 1),
(9, '2016_02_16_140450_create_group_assign_department_table', 1),
(10, '2016_02_16_140450_create_groups_table', 1),
(11, '2016_02_16_140450_create_help_topic_table', 1),
(12, '2016_02_16_140450_create_kb_article_relationship_table', 1),
(13, '2016_02_16_140450_create_kb_article_table', 1),
(14, '2016_02_16_140450_create_kb_category_table', 1),
(15, '2016_02_16_140450_create_kb_comment_table', 1),
(16, '2016_02_16_140450_create_kb_pages_table', 1),
(17, '2016_02_16_140450_create_kb_settings_table', 1),
(18, '2016_02_16_140450_create_languages_table', 1),
(19, '2016_02_16_140450_create_log_notification_table', 1),
(20, '2016_02_16_140450_create_mailbox_protocol_table', 1),
(21, '2016_02_16_140450_create_organization_table', 1),
(22, '2016_02_16_140450_create_password_resets_table', 1),
(23, '2016_02_16_140450_create_plugins_table', 1),
(24, '2016_02_16_140450_create_settings_alert_notice_table', 1),
(25, '2016_02_16_140450_create_settings_auto_response_table', 1),
(26, '2016_02_16_140450_create_settings_company_table', 1),
(27, '2016_02_16_140450_create_settings_email_table', 1),
(28, '2016_02_16_140450_create_settings_ratings_table', 1),
(29, '2016_02_16_140450_create_settings_system_table', 1),
(30, '2016_02_16_140450_create_settings_ticket_table', 1),
(31, '2016_02_16_140450_create_sla_plan_table', 1),
(32, '2016_02_16_140450_create_team_assign_agent_table', 1),
(33, '2016_02_16_140450_create_teams_table', 1),
(34, '2016_02_16_140450_create_template_table', 1),
(35, '2016_02_16_140450_create_ticket_attachment_table', 1),
(36, '2016_02_16_140450_create_ticket_collaborator_table', 1),
(37, '2016_02_16_140450_create_ticket_form_data_table', 1),
(38, '2016_02_16_140450_create_ticket_priority_table', 1),
(39, '2016_02_16_140450_create_ticket_source_table', 1),
(40, '2016_02_16_140450_create_ticket_status_table', 1),
(41, '2016_02_16_140450_create_ticket_thread_table', 1),
(42, '2016_02_16_140450_create_tickets_table', 1),
(43, '2016_02_16_140450_create_time_format_table', 1),
(44, '2016_02_16_140450_create_timezone_table', 1),
(45, '2016_02_16_140450_create_user_assign_organization_table', 1),
(46, '2016_02_16_140450_create_users_table', 1),
(47, '2016_02_16_140450_create_version_check_table', 1),
(48, '2016_02_16_140450_create_widgets_table', 1),
(49, '2016_02_16_140454_add_foreign_keys_to_canned_response_table', 1),
(50, '2016_02_16_140454_add_foreign_keys_to_department_table', 1),
(51, '2016_02_16_140454_add_foreign_keys_to_emails_table', 1),
(52, '2016_02_16_140454_add_foreign_keys_to_group_assign_department_table', 1),
(53, '2016_02_16_140454_add_foreign_keys_to_help_topic_table', 1),
(54, '2016_02_16_140454_add_foreign_keys_to_kb_article_relationship_table', 1),
(55, '2016_02_16_140454_add_foreign_keys_to_kb_comment_table', 1),
(56, '2016_02_16_140454_add_foreign_keys_to_organization_table', 1),
(57, '2016_02_16_140454_add_foreign_keys_to_settings_system_table', 1),
(58, '2016_02_16_140454_add_foreign_keys_to_team_assign_agent_table', 1),
(59, '2016_02_16_140454_add_foreign_keys_to_teams_table', 1),
(60, '2016_02_16_140454_add_foreign_keys_to_ticket_attachment_table', 1),
(61, '2016_02_16_140454_add_foreign_keys_to_ticket_collaborator_table', 1),
(62, '2016_02_16_140454_add_foreign_keys_to_ticket_form_data_table', 1),
(63, '2016_02_16_140454_add_foreign_keys_to_ticket_thread_table', 1),
(64, '2016_02_16_140454_add_foreign_keys_to_tickets_table', 1),
(65, '2016_02_16_140454_add_foreign_keys_to_user_assign_organization_table', 1),
(66, '2016_02_16_140454_add_foreign_keys_to_users_table', 1),
(67, '2016_03_31_061239_create_notifications_table', 1),
(68, '2016_03_31_061534_create_notification_types_table', 1),
(69, '2016_03_31_061740_create_user_notification_table', 1),
(70, '2016_04_18_115852_create_workflow_name_table', 1),
(71, '2016_04_18_115900_create_workflow_rule_table', 1),
(72, '2016_04_18_115908_create_workflow_action_table', 1),
(73, '2016_05_10_102423_create_country_code_table', 1),
(74, '2016_05_10_102604_create_bar_notifications_table', 1),
(75, '2016_05_11_105244_create_api_settings_table', 1),
(76, '2016_05_19_055008_create_workflow_close_table', 1),
(77, '2016_06_02_072210_create_common_settings_table', 1),
(78, '2016_06_02_074913_create_login_attempts_table', 1),
(79, '2016_06_02_080005_create_ratings_table', 1),
(80, '2016_06_02_081020_create_rating_ref_table', 1),
(81, '2016_06_02_090225_create_settings_security_table', 1),
(82, '2016_06_02_090628_create_templates_table', 1),
(83, '2016_06_02_094409_create_template_sets_table', 1),
(84, '2016_06_02_094420_create_template_types_table', 1),
(85, '2016_06_02_095357_create_ticket_token_table', 1),
(86, '2016_06_28_141613_version1079table', 1),
(87, '2016_07_02_051247_create_jobs_table', 1),
(88, '2016_07_02_051439_create_failed_jobs_table', 1),
(89, '2016_07_19_071910_create_field_values_table', 1),
(90, '2016_07_26_084458_create_faveo_mails_table', 1),
(91, '2016_07_26_090201_create_faveo_queues_table', 1),
(92, '2016_07_26_094753_create_mail_services_table', 1),
(93, '2016_07_26_095020_create_queue_services_table', 1),
(94, '2016_07_29_113012_create_conditions_table', 1),
(95, '2016_08_08_095744_create_social_media_table', 1),
(96, '2016_08_12_104410_create_user_additional_infos_table', 1),
(97, '2016_08_16_104539_alter_ticket_source_table', 1),
(98, '2018_08_08_094653_alter_users_table_add_user_language_column', 1),
(99, '2018_08_13_075015_alter_emails_table_make_username_column_nullable', 1),
(100, '2023_01_07_000000_add_uuid_to_failed_jobs_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `model_id` int NOT NULL,
  `userid_created` int NOT NULL,
  `type_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notification_types`
--

CREATE TABLE `notification_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_class` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notification_types`
--

INSERT INTO `notification_types` VALUES
(1, 'A new user is registered', 'registration', 'fa fa-user', '[[regtime]]', '[[regtime]]'),
(2, 'You have a new reply on this ticket', 'reply', 'fa fa-envelope', '[[regtime]]', '[[regtime]]'),
(3, 'A new ticket has been created', 'new_ticket', 'fa fa-envelope', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `organization`
--

CREATE TABLE `organization` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `head` int unsigned DEFAULT NULL,
  `internal_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `head` (`head`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL,
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `plugins`
--

CREATE TABLE `plugins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `queue_services`
--

CREATE TABLE `queue_services` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `queue_services`
--

INSERT INTO `queue_services` VALUES
(1, 'Sync', 'sync', 1, '[[regtime]]', '[[regtime]]'),
(2, 'Database', 'database', 0, '[[regtime]]', '[[regtime]]'),
(3, 'Beanstalkd', 'beanstalkd', 0, '[[regtime]]', '[[regtime]]'),
(4, 'SQS', 'sqs', 0, '[[regtime]]', '[[regtime]]'),
(5, 'Iron', 'iron', 0, '[[regtime]]', '[[regtime]]'),
(6, 'Redis', 'redis', 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `ratings`
--

CREATE TABLE `ratings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_order` int NOT NULL,
  `allow_modification` int NOT NULL,
  `rating_scale` int NOT NULL,
  `rating_area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `restrict` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ratings`
--

INSERT INTO `ratings` VALUES
(1, 'OverAll Satisfaction', 1, 1, 5, 'Helpdesk Area', NULL, '[[regtime]]', '[[regtime]]'),
(2, 'Reply Rating', 1, 1, 5, 'Comment Area', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `rating_ref`
--

CREATE TABLE `rating_ref` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `rating_id` int NOT NULL,
  `ticket_id` int NOT NULL,
  `thread_id` int NOT NULL,
  `rating_value` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `settings_alert_notice`
--

CREATE TABLE `settings_alert_notice` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_status` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_admin_email` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_department_manager` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_department_member` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_organization_accmanager` tinyint(1) NOT NULL DEFAULT '0',
  `message_status` tinyint(1) NOT NULL DEFAULT '0',
  `message_last_responder` tinyint(1) NOT NULL DEFAULT '0',
  `message_assigned_agent` tinyint(1) NOT NULL DEFAULT '0',
  `message_department_manager` tinyint(1) NOT NULL DEFAULT '0',
  `message_organization_accmanager` tinyint(1) NOT NULL DEFAULT '0',
  `internal_status` tinyint(1) NOT NULL DEFAULT '0',
  `internal_last_responder` tinyint(1) NOT NULL DEFAULT '0',
  `internal_assigned_agent` tinyint(1) NOT NULL DEFAULT '0',
  `internal_department_manager` tinyint(1) NOT NULL DEFAULT '0',
  `assignment_status` tinyint(1) NOT NULL DEFAULT '0',
  `assignment_assigned_agent` tinyint(1) NOT NULL DEFAULT '0',
  `assignment_team_leader` tinyint(1) NOT NULL DEFAULT '0',
  `assignment_team_member` tinyint(1) NOT NULL DEFAULT '0',
  `transfer_status` tinyint(1) NOT NULL DEFAULT '0',
  `transfer_assigned_agent` tinyint(1) NOT NULL DEFAULT '0',
  `transfer_department_manager` tinyint(1) NOT NULL DEFAULT '0',
  `transfer_department_member` tinyint(1) NOT NULL DEFAULT '0',
  `overdue_status` tinyint(1) NOT NULL DEFAULT '0',
  `overdue_assigned_agent` tinyint(1) NOT NULL DEFAULT '0',
  `overdue_department_manager` tinyint(1) NOT NULL DEFAULT '0',
  `overdue_department_member` tinyint(1) NOT NULL DEFAULT '0',
  `system_error` tinyint(1) NOT NULL DEFAULT '0',
  `sql_error` tinyint(1) NOT NULL DEFAULT '0',
  `excessive_failure` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_alert_notice`
--

INSERT INTO `settings_alert_notice` VALUES
(1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_auto_response`
--

CREATE TABLE `settings_auto_response` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `new_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `agent_new_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `submitter` tinyint(1) NOT NULL DEFAULT '0',
  `participants` tinyint(1) NOT NULL DEFAULT '0',
  `overlimit` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_auto_response`
--

INSERT INTO `settings_auto_response` VALUES
(1, 1, 1, 0, 0, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_company`
--

CREATE TABLE `settings_company` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `offline_page` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thank_page` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_company`
--

INSERT INTO `settings_company` VALUES
(1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_email`
--

CREATE TABLE `settings_email` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sys_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alert_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `admin_email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mta` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_fetching` tinyint(1) NOT NULL DEFAULT '0',
  `notification_cron` tinyint(1) NOT NULL DEFAULT '0',
  `strip` tinyint(1) NOT NULL DEFAULT '0',
  `separator` tinyint(1) NOT NULL DEFAULT '0',
  `all_emails` tinyint(1) NOT NULL DEFAULT '0',
  `email_collaborator` tinyint(1) NOT NULL DEFAULT '0',
  `attachment` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_email`
--

INSERT INTO `settings_email` VALUES
(1, 'default', NULL, NULL, NULL, NULL, 1, 1, 0, 0, 1, 1, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_ratings`
--

CREATE TABLE `settings_ratings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `rating_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publish` int NOT NULL,
  `modify` int NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_ratings_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `settings_security`
--

CREATE TABLE `settings_security` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lockout_message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backlist_offender` int NOT NULL,
  `backlist_threshold` int NOT NULL,
  `lockout_period` int NOT NULL,
  `days_to_keep_logs` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_security`
--

INSERT INTO `settings_security` VALUES
(1, 'You have been locked out of application due to too many failed login attempts.', 0, 15, 15, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_system`
--

CREATE TABLE `settings_system` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_size` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_level` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purge_log` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `api_enable` int DEFAULT NULL,
  `api_key_mandatory` int DEFAULT NULL,
  `api_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name_format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_farmat` int unsigned DEFAULT NULL,
  `date_format` int unsigned DEFAULT NULL,
  `date_time_format` int unsigned DEFAULT NULL,
  `day_date_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_zone` int unsigned DEFAULT NULL,
  `content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time_farmat` (`time_farmat`),
  KEY `date_format` (`date_format`),
  KEY `date_time_format` (`date_time_format`),
  KEY `time_zone` (`time_zone`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `settings_system`
--

INSERT INTO `settings_system` VALUES
(1, 1, NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, 15, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `settings_ticket`
--

CREATE TABLE `settings_ticket` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `num_format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `num_sequence` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sla` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `help_topic` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_open_ticket` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `collision_avoid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lock_ticket_frequency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `captcha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `claim_response` tinyint(1) NOT NULL DEFAULT '0',
  `assigned_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `answered_ticket` tinyint(1) NOT NULL DEFAULT '0',
  `agent_mask` tinyint(1) NOT NULL DEFAULT '0',
  `html` tinyint(1) NOT NULL DEFAULT '0',
  `client_update` tinyint(1) NOT NULL DEFAULT '0',
  `max_file_size` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings_ticket`
--

INSERT INTO `settings_ticket` VALUES
(1, '$$$$-####-####', 'sequence', '1', '2', '1', NULL, '2', '0', NULL, 1, 0, 0, 0, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `sla_plan`
--

CREATE TABLE `sla_plan` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grace_period` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `admin_note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `transient` tinyint(1) DEFAULT '0',
  `ticket_overdue` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `sla_plan`
--

INSERT INTO `sla_plan` VALUES
(1, 'Sla 1', '6 Hours', NULL, 1, 0, 0, '[[regtime]]', '[[regtime]]'),
(2, 'Sla 2', '12 Hours', NULL, 1, 0, 0, '[[regtime]]', '[[regtime]]'),
(3, 'Sla 3', '24 Hours', NULL, 1, 0, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `social_media`
--

CREATE TABLE `social_media` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `provider` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `teams`
--

CREATE TABLE `teams` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `team_lead` int unsigned DEFAULT NULL,
  `assign_alert` tinyint(1) NOT NULL DEFAULT '0',
  `admin_notes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `team_lead` (`team_lead`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `teams`
--

INSERT INTO `teams` VALUES
(1, 'Level 1 Support', 1, NULL, 0, NULL, '[[regtime]]', '[[regtime]]'),
(2, 'Level 2 Support', 0, NULL, 0, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'Developer', 0, NULL, 0, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `team_assign_agent`
--

CREATE TABLE `team_assign_agent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `team_id` int unsigned DEFAULT NULL,
  `agent_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `team_id` (`team_id`),
  KEY `agent_id` (`agent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `template`
--

CREATE TABLE `template` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `template_set_to_clone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `templates`
--

CREATE TABLE `templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `variable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` int NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `set_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `templates`
--

INSERT INTO `templates` VALUES
(1, 'This template is for sending notice to agent when ticket is assigned to them', '0', 1, NULL, '<div>Hello {!!$ticket_agent_name!!},<br /><br /><b>Ticket No:</b> {!!$ticket_number!!}<br />Has been assigned to you by {!!$ticket_assigner!!} <br/> Please check and resppond on the ticket.<br /> Link: {!!$ticket_link!!}<br /><br />Thank You<br />Kind Regards,<br /> {!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(2, 'This template is for sending notice to client with ticket link to check ticket without logging in to system', '1', 2, 'Check your Ticket', '<div>Hello {!!$user!!},<br/><br/>Click the link below to view your requested ticket<br/> {!!$ticket_link_with_number!!}<br/><br/>Kind Regards,<br/> {!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(3, 'This template is for sending notice to client when ticket status is changed to close', '0', 3, NULL, '<div>Hello,<br/><br/>This message is regarding your ticket ID {!!$ticket_number!!}. We are changing the status of this ticket to "Closed" as the issue appears to be resolved.<br/><br/>Thank you<br/>Kind regards,<br/> {!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(4, 'This template is for sending notice to client on successful ticket creation', '0', 4, NULL, '<div><span>Hello {!!$user!!}<br/><br/></span><span>Thank you for contacting us. This is an automated response confirming the receipt of your ticket. Our team will get back to you as soon as possible. When replying, please make sure that the ticket ID is kept in the subject so that we can track your replies.<br/><br/></span><span><b>Ticket ID:</b> {!!$ticket_number!!} <br/><br/></span><span> {!!$department_sign!!}<br/></span>You can check the status of or update this ticket online at: {!!$system_link!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(5, 'This template is for sending notice to agent on new ticket creation', '0', 5, NULL, '<div>Hello {!!$ticket_agent_name!!},<br/><br/>New ticket {!!$ticket_number!!}created <br/><br/><b>From</b><br/><b>Name:</b> {!!$ticket_client_name!!}   <br/><b>E-mail:</b> {!!$ticket_client_email!!}<br/><br/> {!!$content!!}<br/><br/>Kind Regards,<br/> {!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(6, 'This template is for sending notice to client on new ticket created by agent in name of client', '0', 6, NULL, '<div> {!!$content!!}<br><br> {!!$agent_sign!!}<br><br>You can check the status of or update this ticket online at: {!!$system_link!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(7, 'This template is for sending notice to client on new registration during new ticket creation for un registered clients', '1', 7, 'Registration Confirmation', '<p>Hello {!!$user!!}, </p><p>This email is confirmation that you are now registered at our helpdesk.</p><p><b>Registered Email:</b> {!!$email_address!!}</p><p><b>Password:</b> {!!$user_password!!}</p><p>You can visit the helpdesk to browse articles and contact us at any time: {!!$system_link!!}</p><p>Thank You.</p><p>Kind Regards,</p><p> {!!$system_from!!} </p>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(8, 'This template is for sending notice to any user about reset password option', '1', 8, 'Reset your Password', 'Hello {!!$user!!},<br/><br/>You asked to reset your password. To do so, please click this link:<br/><br/> {!!$password_reset_link!!}<br/><br/>This will let you change your password to something new. If you didn''t ask for this, don''t worry, we''ll keep your password safe.<br/><br/>Thank You.<br/><br/>Kind Regards,<br/> {!!$system_from!!}', NULL, 1, '[[regtime]]', '[[regtime]]'),
(9, 'This template is for sending notice to client when a reply made to his/her ticket', '0', 9, NULL, '<span></span><div><span></span><p> {!!$content!!}<br/></p><p> {!!$agent_sign!!} </p><p><b>Ticket Details</b></p><p><b>Ticket ID:</b> {!!$ticket_number!!}</p></div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(10, 'This template is for sending notice to agent when ticket reply is made by client on a ticket', '0', 10, NULL, '<div>Hello {!!$ticket_agent_name!!},<br/><b><br/></b>A reply been made to ticket {!!$ticket_number!!}<br/><b><br/></b><b>From<br/></b><b>Name: </b>{!!$ticket_client_name!!}<br/><b>E-mail: </b>{!!$ticket_client_email!!}<br/><b><br/></b> {!!$content!!}<br/><b><br/></b>Kind Regards,<br/> {!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(11, 'This template is for sending notice to client about registration confirmation link', '1', 11, 'Verify your email address', '<p>Hello {!!$user!!}, </p><p>This email is confirmation that you are now registered at our helpdesk.</p><p><b>Registered Email:</b> {!!$email_address!!}</p><p>Please click on the below link to activate your account and Login to the system {!!$password_reset_link!!}</p><p>Thank You.</p><p>Kind Regards,</p><p> {!!$system_from!!} </p>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(12, 'This template is for sending notice to team when ticket is assigned to team', '1', 12, NULL, '<div>Hello {!!$ticket_agent_name!!},<br /><br /><b>Ticket No:</b> {!!$ticket_number!!}<br />Has been assigned to your team : {!!$team!!} by {!!$ticket_assigner!!} <br /><br />Thank You<br />Kind Regards,<br />{!!$system_from!!}</div>', NULL, 1, '[[regtime]]', '[[regtime]]'),
(13, 'This template is for sending notice to client when password is changed', '1', 13, 'Verify your email address', 'Hello {!!$user!!},<br /><br />Your password is successfully changed.Your new password is : {!!$user_password!!}<br /><br />Thank You.<br /><br />Kind Regards,<br /> {!!$system_from!!}', NULL, 1, '[[regtime]]', '[[regtime]]'),
(14, 'This template is to notify users when their tickets are merged.', '1', 14, 'Your tickets have been merged.', '<p>Hello {!!$user!!},<br />&nbsp;</p><p>Your ticket(s) with ticket number {!!$merged_ticket_numbers!!} have been closed and&nbsp;merged with <a href="{!!$ticket_link!!}">{!!$ticket_number!!}</a>.&nbsp;</p><p>Possible reasons for merging tickets</p><ul><li>Tickets are duplicate</li<li>Tickets state&nbsp;the same issue</li><li>Another member from your organization has created a ticket for the same issue</li></ul><p><a href="{!!$system_link!!}">Click here</a> to login to your account and check your tickets.</p><p>Regards,</p><p>{!!$system_from!!}</p>', NULL, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `template_sets`
--

CREATE TABLE `template_sets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `template_sets`
--

INSERT INTO `template_sets` VALUES
(1, 'default', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `template_types`
--

CREATE TABLE `template_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `template_types`
--

INSERT INTO `template_types` VALUES
(1, 'assign-ticket', '[[regtime]]', '[[regtime]]'),
(2, 'check-ticket', '[[regtime]]', '[[regtime]]'),
(3, 'close-ticket', '[[regtime]]', '[[regtime]]'),
(4, 'create-ticket', '[[regtime]]', '[[regtime]]'),
(5, 'create-ticket-agent', '[[regtime]]', '[[regtime]]'),
(6, 'create-ticket-by-agent', '[[regtime]]', '[[regtime]]'),
(7, 'registration-notification', '[[regtime]]', '[[regtime]]'),
(8, 'reset-password', '[[regtime]]', '[[regtime]]'),
(9, 'ticket-reply', '[[regtime]]', '[[regtime]]'),
(10, 'ticket-reply-agent', '[[regtime]]', '[[regtime]]'),
(11, 'registration', '[[regtime]]', '[[regtime]]'),
(12, 'team_assign_ticket', '[[regtime]]', '[[regtime]]'),
(13, 'reset_new_password', '[[regtime]]', '[[regtime]]'),
(14, 'merge-ticket-notification', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tickets`
--

CREATE TABLE `tickets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `dept_id` int unsigned DEFAULT NULL,
  `team_id` int unsigned DEFAULT NULL,
  `priority_id` int unsigned DEFAULT NULL,
  `sla` int unsigned DEFAULT NULL,
  `help_topic_id` int unsigned DEFAULT NULL,
  `status` int unsigned DEFAULT NULL,
  `rating` tinyint(1) NOT NULL DEFAULT '0',
  `ratingreply` tinyint(1) NOT NULL DEFAULT '0',
  `flags` int NOT NULL,
  `ip_address` int NOT NULL,
  `assigned_to` int unsigned DEFAULT NULL,
  `lock_by` int NOT NULL,
  `lock_at` datetime DEFAULT NULL,
  `source` int unsigned DEFAULT NULL,
  `isoverdue` int NOT NULL,
  `reopened` int NOT NULL,
  `isanswered` int NOT NULL,
  `html` int NOT NULL,
  `is_deleted` int NOT NULL,
  `closed` int NOT NULL,
  `is_transferred` tinyint(1) NOT NULL DEFAULT '0',
  `transferred_at` datetime NOT NULL,
  `reopened_at` datetime DEFAULT NULL,
  `duedate` datetime DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  `last_message_at` datetime DEFAULT NULL,
  `last_response_at` datetime DEFAULT NULL,
  `approval` int NOT NULL,
  `follow_up` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `dept_id` (`dept_id`),
  KEY `team_id` (`team_id`),
  KEY `priority_id` (`priority_id`),
  KEY `sla` (`sla`),
  KEY `help_topic_id` (`help_topic_id`),
  KEY `status` (`status`),
  KEY `assigned_to` (`assigned_to`),
  KEY `source` (`source`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_attachment`
--

CREATE TABLE `ticket_attachment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thread_id` int unsigned DEFAULT NULL,
  `size` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `file` mediumblob,
  PRIMARY KEY (`id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_collaborator`
--

CREATE TABLE `ticket_collaborator` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `isactive` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_form_data`
--

CREATE TABLE `ticket_form_data` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int unsigned DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_priority`
--

CREATE TABLE `ticket_priority` (
  `priority_id` int unsigned NOT NULL AUTO_INCREMENT,
  `priority` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority_desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority_urgency` tinyint(1) NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`priority_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ticket_priority`
--

INSERT INTO `ticket_priority` VALUES
(1, 'Low', '1', 'Low', '#00a65a', 4, 1, NULL, NULL, NULL),
(2, 'Normal', '1', 'Normal', '#00bfef', 3, 1, '1', NULL, NULL),
(3, 'High', '1', 'High', '#f39c11', 2, 1, NULL, NULL, NULL),
(4, 'Emergency', '1', 'Emergency', '#dd4b38', 1, 1, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ticket_source`
--

CREATE TABLE `ticket_source` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `ticket_source`
--

INSERT INTO `ticket_source` VALUES
(1, 'Web', 'Web', 'fa fa-globe'),
(2, 'Email', 'E-mail', 'fa fa-envelope'),
(3, 'Agent', 'Agent Panel', 'fa fa-user'),
(4, 'Facebook', 'Facebook', 'fa fa-facebook'),
(5, 'Twitter', 'Twitter', 'fa fa-twitter'),
(6, 'Call', 'Call', 'fa fa-phone'),
(7, 'Chat', 'Chat', 'fa fa-comment');

-- --------------------------------------------------------

--
-- Table structure for table `ticket_status`
--

CREATE TABLE `ticket_status` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mode` int NOT NULL,
  `message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flags` int NOT NULL,
  `sort` int NOT NULL,
  `email_user` int DEFAULT NULL,
  `icon_class` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ticket_status`
--

INSERT INTO `ticket_status` VALUES
(1, 'Open', 'open', 3, 'Ticket have been Reopened by', 0, 1, NULL, NULL, 'Open tickets.', '[[regtime]]', '[[regtime]]'),
(2, 'Resolved', 'closed', 1, 'Ticket have been Resolved by', 0, 2, NULL, NULL, 'Resolved tickets.', '[[regtime]]', '[[regtime]]'),
(3, 'Closed', 'closed', 3, 'Ticket have been Closed by', 0, 3, NULL, NULL, 'Closed tickets. Tickets will still be accessible on client and staff panels.', '[[regtime]]', '[[regtime]]'),
(4, 'Archived', 'archived', 3, 'Ticket have been Archived by', 0, 4, NULL, NULL, 'Tickets only adminstratively available but no longer accessible on ticket queues and client panel.', '[[regtime]]', '[[regtime]]'),
(5, 'Deleted', 'deleted', 3, 'Ticket have been Deleted by', 0, 5, NULL, NULL, 'Tickets queued for deletion. Not accessible on ticket queues.', '[[regtime]]', '[[regtime]]'),
(6, 'Unverified', 'unverified', 3, 'User account verification required.', 0, 6, NULL, NULL, 'Ticket will be open after user verifies his/her account.', '[[regtime]]', '[[regtime]]'),
(7, 'Request Approval', 'unverified', 3, 'Approval requested by', 0, 7, NULL, NULL, 'Ticket will be approve  after Admin verifies  this ticket', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `ticket_thread`
--

CREATE TABLE `ticket_thread` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `poster` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` int unsigned DEFAULT NULL,
  `reply_rating` int NOT NULL,
  `rating_count` int NOT NULL,
  `is_internal` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` longblob,
  `format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_id_2` (`ticket_id`),
  KEY `user_id` (`user_id`),
  KEY `source` (`source`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ticket_token`
--

CREATE TABLE `ticket_token` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticket_id` int NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `timezone`
--

CREATE TABLE `timezone` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `timezone`
--

INSERT INTO `timezone` VALUES
(1, 'Pacific/Midway', '(GMT-11:00) Midway Island'),
(2, 'US/Samoa', '(GMT-11:00) Samoa'),
(3, 'US/Hawaii', '(GMT-10:00) Hawaii'),
(4, 'US/Alaska', '(GMT-09:00) Alaska'),
(5, 'US/Pacific', '(GMT-08:00) Pacific Time (US &amp; Canada)'),
(6, 'America/Tijuana', '(GMT-08:00) Tijuana'),
(7, 'US/Arizona', '(GMT-07:00) Arizona'),
(8, 'US/Mountain', '(GMT-07:00) Mountain Time (US &amp; Canada)'),
(9, 'America/Chihuahua', '(GMT-07:00) Chihuahua'),
(10, 'America/Mazatlan', '(GMT-07:00) Mazatlan'),
(11, 'America/Mexico_City', '(GMT-06:00) Mexico City'),
(12, 'America/Monterrey', '(GMT-06:00) Monterrey'),
(13, 'Canada/Saskatchewan', '(GMT-06:00) Saskatchewan'),
(14, 'US/Central', '(GMT-06:00) Central Time (US &amp; Canada)'),
(15, 'US/Eastern', '(GMT-05:00) Eastern Time (US &amp; Canada)'),
(16, 'US/East-Indiana', '(GMT-05:00) Indiana (East)'),
(17, 'America/Bogota', '(GMT-05:00) Bogota'),
(18, 'America/Lima', '(GMT-05:00) Lima'),
(19, 'America/Caracas', '(GMT-04:30) Caracas'),
(20, 'Canada/Atlantic', '(GMT-04:00) Atlantic Time (Canada)'),
(21, 'America/La_Paz', '(GMT-04:00) La Paz'),
(22, 'America/Santiago', '(GMT-04:00) Santiago'),
(23, 'Canada/Newfoundland', '(GMT-03:30) Newfoundland'),
(24, 'America/Buenos_Aires', '(GMT-03:00) Buenos Aires'),
(25, 'Greenland', '(GMT-03:00) Greenland'),
(26, 'Atlantic/Stanley', '(GMT-02:00) Stanley'),
(27, 'Atlantic/Azores', '(GMT-01:00) Azores'),
(28, 'Atlantic/Cape_Verde', '(GMT-01:00) Cape Verde Is.'),
(29, 'Africa/Casablanca', '(GMT) Casablanca'),
(30, 'Europe/Dublin', '(GMT) Dublin'),
(31, 'Europe/Lisbon', '(GMT) Lisbon'),
(32, 'Europe/London', '(GMT) London'),
(33, 'Africa/Monrovia', '(GMT) Monrovia'),
(34, 'Europe/Amsterdam', '(GMT+01:00) Amsterdam'),
(35, 'Europe/Belgrade', '(GMT+01:00) Belgrade'),
(36, 'Europe/Berlin', '(GMT+01:00) Berlin'),
(37, 'Europe/Bratislava', '(GMT+01:00) Bratislava'),
(38, 'Europe/Brussels', '(GMT+01:00) Brussels'),
(39, 'Europe/Budapest', '(GMT+01:00) Budapest'),
(40, 'Europe/Copenhagen', '(GMT+01:00) Copenhagen'),
(41, 'Europe/Ljubljana', '(GMT+01:00) Ljubljana'),
(42, 'Europe/Madrid', '(GMT+01:00) Madrid'),
(43, 'Europe/Paris', '(GMT+01:00) Paris'),
(44, 'Europe/Prague', '(GMT+01:00) Prague'),
(45, 'Europe/Rome', '(GMT+01:00) Rome'),
(46, 'Europe/Sarajevo', '(GMT+01:00) Sarajevo'),
(47, 'Europe/Skopje', '(GMT+01:00) Skopje'),
(48, 'Europe/Stockholm', '(GMT+01:00) Stockholm'),
(49, 'Europe/Vienna', '(GMT+01:00) Vienna'),
(50, 'Europe/Warsaw', '(GMT+01:00) Warsaw'),
(51, 'Europe/Zagreb', '(GMT+01:00) Zagreb'),
(52, 'Europe/Athens', '(GMT+02:00) Athens'),
(53, 'Europe/Bucharest', '(GMT+02:00) Bucharest'),
(54, 'Africa/Cairo', '(GMT+02:00) Cairo'),
(55, 'Africa/Harare', '(GMT+02:00) Harare'),
(56, 'Europe/Helsinki', '(GMT+02:00) Helsinki'),
(57, 'Europe/Istanbul', '(GMT+02:00) Istanbul'),
(58, 'Asia/Jerusalem', '(GMT+02:00) Jerusalem'),
(59, 'Europe/Kiev', '(GMT+02:00) Kyiv'),
(60, 'Europe/Minsk', '(GMT+02:00) Minsk'),
(61, 'Europe/Riga', '(GMT+02:00) Riga'),
(62, 'Europe/Sofia', '(GMT+02:00) Sofia'),
(63, 'Europe/Tallinn', '(GMT+02:00) Tallinn'),
(64, 'Europe/Vilnius', '(GMT+02:00) Vilnius'),
(65, 'Asia/Baghdad', '(GMT+03:00) Baghdad'),
(66, 'Asia/Kuwait', '(GMT+03:00) Kuwait'),
(67, 'Africa/Nairobi', '(GMT+03:00) Nairobi'),
(68, 'Asia/Riyadh', '(GMT+03:00) Riyadh'),
(69, 'Asia/Tehran', '(GMT+03:30) Tehran'),
(70, 'Europe/Moscow', '(GMT+04:00) Moscow'),
(71, 'Asia/Baku', '(GMT+04:00) Baku'),
(72, 'Europe/Volgograd', '(GMT+04:00) Volgograd'),
(73, 'Asia/Muscat', '(GMT+04:00) Muscat'),
(74, 'Asia/Tbilisi', '(GMT+04:00) Tbilisi'),
(75, 'Asia/Yerevan', '(GMT+04:00) Yerevan'),
(76, 'Asia/Kabul', '(GMT+04:30) Kabul'),
(77, 'Asia/Karachi', '(GMT+05:00) Karachi'),
(78, 'Asia/Tashkent', '(GMT+05:00) Tashkent'),
(79, 'Asia/Kolkata', '(GMT+05:30) Kolkata'),
(80, 'Asia/Kathmandu', '(GMT+05:45) Kathmandu'),
(81, 'Asia/Yekaterinburg', '(GMT+06:00) Ekaterinburg'),
(82, 'Asia/Almaty', '(GMT+06:00) Almaty'),
(83, 'Asia/Dhaka', '(GMT+06:00) Dhaka'),
(84, 'Asia/Novosibirsk', '(GMT+07:00) Novosibirsk'),
(85, 'Asia/Bangkok', '(GMT+07:00) Bangkok'),
(86, 'Asia/Ho_Chi_Minh', '(GMT+07.00) Ho Chi Minh'),
(87, 'Asia/Jakarta', '(GMT+07:00) Jakarta'),
(88, 'Asia/Krasnoyarsk', '(GMT+08:00) Krasnoyarsk'),
(89, 'Asia/Chongqing', '(GMT+08:00) Chongqing'),
(90, 'Asia/Hong_Kong', '(GMT+08:00) Hong Kong'),
(91, 'Asia/Kuala_Lumpur', '(GMT+08:00) Kuala Lumpur'),
(92, 'Australia/Perth', '(GMT+08:00) Perth'),
(93, 'Asia/Singapore', '(GMT+08:00) Singapore'),
(94, 'Asia/Taipei', '(GMT+08:00) Taipei'),
(95, 'Asia/Ulaanbaatar', '(GMT+08:00) Ulaan Bataar'),
(96, 'Asia/Urumqi', '(GMT+08:00) Urumqi'),
(97, 'Asia/Irkutsk', '(GMT+09:00) Irkutsk'),
(98, 'Asia/Seoul', '(GMT+09:00) Seoul'),
(99, 'Asia/Tokyo', '(GMT+09:00) Tokyo'),
(100, 'Australia/Adelaide', '(GMT+09:30) Adelaide'),
(101, 'Australia/Darwin', '(GMT+09:30) Darwin'),
(102, 'Asia/Yakutsk', '(GMT+10:00) Yakutsk'),
(103, 'Australia/Brisbane', '(GMT+10:00) Brisbane'),
(104, 'Australia/Canberra', '(GMT+10:00) Canberra'),
(105, 'Pacific/Guam', '(GMT+10:00) Guam'),
(106, 'Australia/Hobart', '(GMT+10:00) Hobart'),
(107, 'Australia/Melbourne', '(GMT+10:00) Melbourne'),
(108, 'Pacific/Port_Moresby', '(GMT+10:00) Port Moresby'),
(109, 'Australia/Sydney', '(GMT+10:00) Sydney'),
(110, 'Asia/Vladivostok', '(GMT+11:00) Vladivostok'),
(111, 'Asia/Magadan', '(GMT+12:00) Magadan'),
(112, 'Pacific/Auckland', '(GMT+12:00) Auckland'),
(113, 'Pacific/Fiji', '(GMT+12:00) Fiji');

-- --------------------------------------------------------

--
-- Table structure for table `time_format`
--

CREATE TABLE `time_format` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `format` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `time_format`
--

INSERT INTO `time_format` VALUES
(1, 'H:i:s'),
(2, 'H.i.s');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ban` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` int NOT NULL,
  `is_delete` tinyint(1) NOT NULL DEFAULT '0',
  `ext` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_code` int DEFAULT NULL,
  `phone_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `agent_sign` text COLLATE utf8mb4_unicode_ci,
  `account_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assign_group` int unsigned DEFAULT NULL,
  `primary_dpt` int unsigned DEFAULT NULL,
  `agent_tzone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `daylight_save` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `limit_access` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `directory_listing` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vacation_mode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_pic` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_language` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_mobile_unique` (`mobile`),
  KEY `assign_group_3` (`assign_group`),
  KEY `primary_dpt_2` (`primary_dpt`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(1, '[[admin_username]]', '[[admin_fname]]', '[[admin_lname]]', 0, '[[admin_email]]', 0, '[[admin_pass]]', 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, 'admin', NULL, NULL, NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_additional_infos`
--

CREATE TABLE `user_additional_infos` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` int NOT NULL,
  `service` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_assign_organization`
--

CREATE TABLE `user_assign_organization` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `org_id` int unsigned DEFAULT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_notification`
--

CREATE TABLE `user_notification` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `notification_id` int NOT NULL,
  `user_id` int NOT NULL,
  `is_read` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `version_check`
--

CREATE TABLE `version_check` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `current_version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `version_check`
--

INSERT INTO `version_check` VALUES
(1, NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `widgets`
--

CREATE TABLE `widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `widgets`
--

INSERT INTO `widgets` VALUES
(1, 'footer1', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(2, 'footer2', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(3, 'footer3', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(4, 'footer4', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(7, 'linkedin', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(8, 'stumble', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(9, 'google', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(10, 'deviantart', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(11, 'flickr', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(12, 'skype', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(13, 'rss', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(14, 'twitter', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(15, 'facebook', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(16, 'youtube', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(17, 'vimeo', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(18, 'pinterest', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(19, 'dribbble', NULL, NULL, '[[regtime]]', '[[regtime]]'),
(20, 'instagram', NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `workflow_action`
--

CREATE TABLE `workflow_action` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `workflow_id` int unsigned NOT NULL,
  `condition` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `workflow_action_1` (`workflow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `workflow_close`
--

CREATE TABLE `workflow_close` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `days` int NOT NULL,
  `condition` int NOT NULL,
  `send_email` int NOT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `workflow_close`
--

INSERT INTO `workflow_close` VALUES
(1, 2, 1, 1, 3, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `workflow_name`
--

CREATE TABLE `workflow_name` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int NOT NULL,
  `order` int NOT NULL,
  `target` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `workflow_rules`
--

CREATE TABLE `workflow_rules` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `workflow_id` int unsigned NOT NULL,
  `matching_criteria` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `matching_scenario` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `matching_relation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `matching_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `workflow_rules_1` (`workflow_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `canned_response`
--
ALTER TABLE `canned_response`
  ADD CONSTRAINT `canned_response_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);

--
-- Constraints for table `department`
--
ALTER TABLE `department`
  ADD CONSTRAINT `department_ibfk_1` FOREIGN KEY (`sla`) REFERENCES `sla_plan` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `department_ibfk_2` FOREIGN KEY (`manager`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `emails`
--
ALTER TABLE `emails`
  ADD CONSTRAINT `emails_ibfk_1` FOREIGN KEY (`department`) REFERENCES `department` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `emails_ibfk_2` FOREIGN KEY (`priority`) REFERENCES `ticket_priority` (`priority_id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `emails_ibfk_3` FOREIGN KEY (`help_topic`) REFERENCES `help_topic` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `field_values`
--
ALTER TABLE `field_values`
  ADD CONSTRAINT `field_values_field_id_foreign` FOREIGN KEY (`field_id`) REFERENCES `custom_form_fields` (`id`);

--
-- Constraints for table `group_assign_department`
--
ALTER TABLE `group_assign_department`
  ADD CONSTRAINT `group_assign_department_ibfk_1` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `group_assign_department_ibfk_2` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `help_topic`
--
ALTER TABLE `help_topic`
  ADD CONSTRAINT `help_topic_ibfk_1` FOREIGN KEY (`custom_form`) REFERENCES `custom_forms` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `help_topic_ibfk_2` FOREIGN KEY (`department`) REFERENCES `department` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `help_topic_ibfk_3` FOREIGN KEY (`ticket_status`) REFERENCES `ticket_status` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `help_topic_ibfk_4` FOREIGN KEY (`priority`) REFERENCES `ticket_priority` (`priority_id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `help_topic_ibfk_5` FOREIGN KEY (`sla_plan`) REFERENCES `sla_plan` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `help_topic_ibfk_6` FOREIGN KEY (`auto_assign`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE RESTRICT;

--
-- Constraints for table `kb_article_relationship`
--
ALTER TABLE `kb_article_relationship`
  ADD CONSTRAINT `article_relationship_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `kb_article` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  ADD CONSTRAINT `article_relationship_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `kb_category` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Constraints for table `kb_comment`
--
ALTER TABLE `kb_comment`
  ADD CONSTRAINT `comment_article_id_foreign` FOREIGN KEY (`article_id`) REFERENCES `kb_article` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Constraints for table `organization`
--
ALTER TABLE `organization`
  ADD CONSTRAINT `organization_ibfk_1` FOREIGN KEY (`head`) REFERENCES `users` (`id`);

--
-- Constraints for table `settings_system`
--
ALTER TABLE `settings_system`
  ADD CONSTRAINT `settings_system_ibfk_1` FOREIGN KEY (`time_zone`) REFERENCES `timezone` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `settings_system_ibfk_2` FOREIGN KEY (`time_farmat`) REFERENCES `time_format` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `settings_system_ibfk_3` FOREIGN KEY (`date_format`) REFERENCES `date_format` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `settings_system_ibfk_4` FOREIGN KEY (`date_time_format`) REFERENCES `date_time_format` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `teams`
--
ALTER TABLE `teams`
  ADD CONSTRAINT `teams_ibfk_1` FOREIGN KEY (`team_lead`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `team_assign_agent`
--
ALTER TABLE `team_assign_agent`
  ADD CONSTRAINT `team_assign_agent_ibfk_1` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `team_assign_agent_ibfk_2` FOREIGN KEY (`agent_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `tickets`
--
ALTER TABLE `tickets`
  ADD CONSTRAINT `tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_2` FOREIGN KEY (`dept_id`) REFERENCES `department` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_3` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_4` FOREIGN KEY (`priority_id`) REFERENCES `ticket_priority` (`priority_id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_5` FOREIGN KEY (`sla`) REFERENCES `sla_plan` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_6` FOREIGN KEY (`help_topic_id`) REFERENCES `help_topic` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_7` FOREIGN KEY (`status`) REFERENCES `ticket_status` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_8` FOREIGN KEY (`source`) REFERENCES `ticket_source` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `tickets_ibfk_9` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `ticket_attachment`
--
ALTER TABLE `ticket_attachment`
  ADD CONSTRAINT `ticket_attachment_ibfk_1` FOREIGN KEY (`thread_id`) REFERENCES `ticket_thread` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `ticket_collaborator`
--
ALTER TABLE `ticket_collaborator`
  ADD CONSTRAINT `ticket_collaborator_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `ticket_collaborator_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `ticket_form_data`
--
ALTER TABLE `ticket_form_data`
  ADD CONSTRAINT `ticket_form_data_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `ticket_thread`
--
ALTER TABLE `ticket_thread`
  ADD CONSTRAINT `ticket_thread_ibfk_1` FOREIGN KEY (`ticket_id`) REFERENCES `tickets` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `ticket_thread_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `ticket_thread_ibfk_3` FOREIGN KEY (`source`) REFERENCES `ticket_source` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_ibfk_1` FOREIGN KEY (`assign_group`) REFERENCES `groups` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `users_ibfk_2` FOREIGN KEY (`primary_dpt`) REFERENCES `department` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `user_assign_organization`
--
ALTER TABLE `user_assign_organization`
  ADD CONSTRAINT `user_assign_organization_ibfk_1` FOREIGN KEY (`org_id`) REFERENCES `organization` (`id`) ON DELETE RESTRICT,
  ADD CONSTRAINT `user_assign_organization_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `workflow_action`
--
ALTER TABLE `workflow_action`
  ADD CONSTRAINT `workflow_action_1` FOREIGN KEY (`workflow_id`) REFERENCES `workflow_name` (`id`) ON DELETE RESTRICT;

--
-- Constraints for table `workflow_rules`
--
ALTER TABLE `workflow_rules`
  ADD CONSTRAINT `workflow_rules_1` FOREIGN KEY (`workflow_id`) REFERENCES `workflow_name` (`id`) ON DELETE RESTRICT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
