<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'محفوظ في ":timezone"',
    'displayed_in_tz'                           => 'معروض في ":timezone"',
    'close'                                     => 'إغلاق',
    'actions'                                   => 'الإجراءات',
    'edit'                                      => 'تعديل',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'معرف دفتر المعاملة',
    'delete'                                    => 'حذف',
    'split'                                     => 'تقسيم',
    'single_split'                              => 'تقسيم',
    'clone'                                     => 'نسخ',
    'clone_and_edit'                            => 'نسخ وتعديل',
    'confirm_action'                            => 'تأكيد الإجراء',
    'last_seven_days'                           => 'الأيام السبعة الماضية',
    'last_thirty_days'                          => 'الثلاثون يوماً الماضية',
    'last_180_days'                             => 'آخر 180 يوماً',
    'month_to_date'                             => 'من بداية الشهر حتى الآن',
    'year_to_date'                              => 'من بداية السنة حتى الآن',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'من بداية السنة',
    'welcome_back'                              => 'أهلاً وسهلاً!',
    'main_dashboard_page_title'                 => 'الصفحة الرئيسية',
    'everything'                                => 'كل شيء',
    'today'                                     => 'اليوم',
    'customRange'                               => 'نطاق مخصص',
    'date_range'                                => 'نطاق التاريخ',
    'apply'                                     => 'تطبيق',
    'select_date'                               => 'اختر التاريخ..',
    'cancel'                                    => 'إلغاء',
    'from'                                      => 'من',
    'to'                                        => 'إلى',
    'structure'                                 => 'الهيكل',
    'help_translating'                          => 'نص المساعدة هذا ليس متاحاً بلغتك بعد. <a href="https://crowdin.com/project/firefly-iii-help">هل ستساعد في الترجمة؟</a>',
    'showEverything'                            => 'إظهار كل شيء',
    'never'                                     => 'أبداً',
    'no_results_for_empty_search'               => 'بحثك كان فارغاً، لذلك لم يتم العثور على شيء.',
    'removed_amount'                            => 'تم إزالة :amount',
    'added_amount'                              => 'تم إضافة :amount',
    'asset_account_role_help'                   => 'يمكن تعيين أي خيارات إضافية ناتجة عن اختيارك لاحقاً.',
    'Opening balance'                           => 'الرصيد الافتتاحي',
    'create_new_stuff'                          => 'إنشاء أشياء جديدة',
    'new_withdrawal'                            => 'سحب جديد',
    'create_new_transaction'                    => 'إنشاء معاملة مالية جديدة',
    'sidebar_frontpage_create'                  => 'إنشاء',
    'new_transaction'                           => 'معاملة جديدة',
    'no_rules_for_bill'                         => 'هذا الاشتراك لا توجد له قواعد مرتبطة به.',
    'go_to_asset_accounts'                      => 'عرض حسابات الأصول',
    'go_to_budgets'                             => 'الذهاب إلى الميزانيات',
    'go_to_withdrawals'                         => 'الذهاب إلى المسحوبات',
    'clones_journal_x'                          => 'هذه المعاملة هي نسخة من ":description" (#:id)',
    'go_to_categories'                          => 'الذهاب إلى الفئات',
    'go_to_bills'                               => 'الذهاب إلى الاشتراكات',
    'go_to_expense_accounts'                    => 'مشاهدة حسابات النفقات',
    'go_to_revenue_accounts'                    => 'مشاهدة حسابات الإيرادات',
    'go_to_piggies'                             => 'الذهاب إلى الحصالات',
    'new_deposit'                               => 'إيداع جديد',
    'new_transfer'                              => 'تحويل جديد',
    'new_transfers'                             => 'تحويل جديد',
    'new_asset_account'                         => 'حساب أصول جديد',
    'new_expense_account'                       => 'حساب نفقات جديد',
    'new_revenue_account'                       => 'حساب إيرادات جديد',
    'new_liabilities_account'                   => 'التزام جديد',
    'new_budget'                                => 'ميزانية جديدة',
    'new_bill'                                  => 'اشتراك جديد',
    'block_account_logout'                      => 'تم تسجيل خروجك. الحسابات المحظورة لا يمكنها استخدام هذا الموقع. هل قمت بالتسجيل بعنوان بريد إلكتروني صحيح؟',
    'flash_success'                             => 'نجح!',
    'flash_info'                                => 'رسالة',
    'flash_warning'                             => 'تحذير!',
    'flash_error'                               => 'خطأ!',
    'flash_danger'                              => 'خطر!',
    'flash_info_multiple'                       => 'يوجد رسالة واحدة|يوجد :count رسائل',
    'flash_error_multiple'                      => 'يوجد خطأ واحد|يوجد :count أخطاء',
    'net_worth'                                 => 'صافي الثروة',
    'help_for_this_page'                        => 'مساعدة لهذه الصفحة',
    'help_for_this_page_body'                   => 'يمكنك العثور على مزيد من المعلومات حول هذه الصفحة <a href="https://docs.firefly-iii.org/">في الوثائق</a>.',
    'two_factor_welcome'                        => 'مرحباً!',
    'two_factor_enter_code'                     => 'للمتابعة، يرجى إدخال رمز المصادقة ثنائية العامل. يمكن لتطبيقك إنشاؤه لك.',
    'two_factor_code_here'                      => 'أدخل الرمز هنا',
    'two_factor_title'                          => 'المصادقة ثنائية العامل',
    'authenticate'                              => 'مصادقة',
    'two_factor_forgot_title'                   => 'فقدان المصادقة ثنائية العامل',
    'two_factor_forgot'                         => 'نسيت المصادقة ثنائية العامل.',
    'two_factor_lost_header'                    => 'فقدت المصادقة ثنائية العامل؟',
    'two_factor_lost_intro'                     => 'إذا فقدت الرموز الاحتياطية أيضاً، فلديك حظ سيء. هذا ليس شيئاً يمكنك إصلاحه من واجهة الويب. لديك خياران.',
    'two_factor_lost_fix_self'                  => 'إذا كنت تدير مثيلك الخاص من Firefly III، اقرأ <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">هذا الإدخال في الأسئلة الشائعة</a> للحصول على التعليمات.',
    'two_factor_lost_fix_owner'                 => 'وإلا، راسل مالك الموقع، <a href="mailto::site_owner">:site_owner</a> واطلب منه إعادة تعيين المصادقة ثنائية العامل.',
    'mfa_backup_code'                           => 'لقد استخدمت رمزاً احتياطياً لتسجيل الدخول إلى Firefly III. لا يمكن استخدامه مرة أخرى، لذا اشطبه من قائمتك.',
    'pref_two_factor_new_backup_codes'          => 'احصل على رموز احتياطية جديدة',
    'pref_two_factor_backup_code_count'         => 'لديك رمز احتياطي صحيح واحد.|لديك :count رموز احتياطية صحيحة.',
    '2fa_i_have_them'                           => 'لقد حفظتها!',
    'warning_much_data'                         => ':days أيام من البيانات قد تستغرق وقتاً للتحميل.',
    'registered'                                => 'لقد سجلت بنجاح!',
    'Default asset account'                     => 'حساب الأصول الافتراضي',
    'no_budget_pointer'                         => 'يبدو أنه ليس لديك ميزانيات بعد. يجب أن تنشئ بعضها في <a href="budgets">صفحة الميزانيات</a>. الميزانيات يمكن أن تساعدك في تتبع النفقات.',
    'no_bill_pointer'                           => 'يبدو أنه ليس لديك اشتراكات بعد. يجب أن تنشئ بعضها في <a href="subscriptions">صفحة الاشتراكات</a>. الاشتراكات يمكن أن تساعدك في تتبع النفقات.',
    'Savings account'                           => 'حساب توفير',
    'Credit card'                               => 'بطاقة ائتمان',
    'source_accounts'                           => 'حساب المصدر|حسابات المصدر',
    'destination_accounts'                      => 'حساب الوجهة|حسابات الوجهة',
    'user_id_is'                                => 'معرف المستخدم الخاص بك هو <strong>:user</strong>',
    'field_supports_markdown'                   => 'هذا الحقل يدعم <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'إذا كنت تحتاج مزيداً من المساعدة في استخدام Firefly III، يرجى <a href="https://github.com/firefly-iii/firefly-iii/issues">فتح تذكرة على Github</a>.',
    'reenable_intro_text'                       => 'يمكنك أيضاً إعادة تمكين <a href="#" id="reenableGuidance">الإرشادات التمهيدية</a>.',
    'intro_boxes_after_refresh'                 => 'ستظهر صناديق المقدمة مرة أخرى عند تحديث الصفحة.',
    'show_all_no_filter'                        => 'إظهار جميع المعاملات دون تجميعها حسب التاريخ.',
    'expenses_by_category'                      => 'النفقات حسب الفئة',
    'expenses_by_budget'                        => 'النفقات حسب الميزانية',
    'income_by_category'                        => 'الدخل حسب الفئة',
    'expenses_by_asset_account'                 => 'النفقات حسب حساب الأصول',
    'expenses_by_expense_account'               => 'النفقات حسب حساب الوجهة',
    'cannot_redirect_to_account'                => 'لا يستطيع Firefly III إعادة توجيهك إلى الصفحة الصحيحة. اعتذاراتنا.',
    'sum_of_expenses'                           => 'مجموع النفقات',
    'sum_of_income'                             => 'مجموع الدخل',
    'liabilities'                               => 'الالتزامات',
    'spent_in_specific_budget'                  => 'أُنفق في الميزانية ":budget"',
    'spent_in_specific_double'                  => 'أُنفق في الحساب ":account"',
    'earned_in_specific_double'                 => 'أُكتسب في الحساب ":account"',
    'source_account'                            => 'حساب المصدر',
    'source_account_reconciliation'             => 'لا يمكنك تعديل حساب المصدر لمعاملة التسوية.',
    'destination_account'                       => 'حساب الوجهة',
    'destination_account_reconciliation'        => 'لا يمكنك تعديل حساب الوجهة لمعاملة التسوية.',
    'sum_of_expenses_in_budget'                 => 'إجمالي المُنفق في الميزانية ":budget"',
    'left_in_budget_limit'                      => 'متبقي للإنفاق وفقاً للميزنة',
    'current_period'                            => 'الفترة الحالية',
    'show_the_current_period_and_overview'      => 'إظهار الفترة الحالية والنظرة العامة',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'لكي تعمل لغة غير الإنجليزية بشكل صحيح، يجب أن يكون نظام التشغيل الخاص بك مجهزاً بمعلومات المحلية الصحيحة. إذا لم تكن موجودة، فقد يتم تنسيق بيانات العملة والتواريخ والمبالغ بشكل خاطئ.',
    'budget_in_period'                          => 'جميع المعاملات للميزانية ":name" بين :start و :end في :currency',
    'chart_budget_in_period'                    => 'مخطط لجميع المعاملات للميزانية ":name" بين :start و :end في :currency',
    'chart_budget_in_period_only_currency'      => 'المبلغ الذي وضعته في الميزانية كان في :currency، لذا سيظهر هذا المخطط المعاملات في :currency فقط.',
    'chart_account_in_period'                   => 'مخطط لجميع المعاملات للحساب ":name" (:balance) بين :start و :end',
    'chart_category_in_period'                  => 'مخطط لجميع المعاملات للفئة ":name" بين :start و :end',
    'chart_category_all'                        => 'مخطط لجميع المعاملات للفئة ":name"',
    'clone_withdrawal'                          => 'نسخ هذا السحب',
    'clone_deposit'                             => 'نسخ هذا الإيداع',
    'clone_transfer'                            => 'نسخ هذا التحويل',
    'multi_select_no_selection'                 => 'لم يتم اختيار شيء',
    'multi_select_select_all'                   => 'اختيار الكل',
    'multi_select_n_selected'                   => 'مُختار',
    'multi_select_all_selected'                 => 'تم اختيار الكل',
    'multi_select_filter_placeholder'           => 'بحث..',
    'intro_next_label'                          => 'التالي',
    'intro_prev_label'                          => 'السابق',
    'intro_skip_label'                          => 'تخطي',
    'intro_done_label'                          => 'تم الانتهاء',
    'between_dates_breadcrumb'                  => 'بين :start و :end',
    'all_journals_without_budget'               => 'جميع المعاملات بدون ميزانية',
    'journals_without_budget'                   => 'معاملات بدون ميزانية',
    'all_journals_without_category'             => 'جميع المعاملات بدون فئة',
    'journals_without_category'                 => 'معاملات بدون فئة',
    'all_journals_for_account'                  => 'جميع المعاملات للحساب :name',
    'chart_all_journals_for_account'            => 'مخطط جميع المعاملات للحساب :name',
    'journals_in_period_for_account'            => 'جميع المعاملات للحساب :name بين :start و :end',
    'journals_in_period_for_account_js'         => 'جميع المعاملات للحساب {title} بين {start} و {end}',
    'transferred'                               => 'محول',
    'all_withdrawal'                            => 'جميع النفقات',
    'all_transactions'                          => 'جميع المعاملات',
    'title_withdrawal_between'                  => 'جميع النفقات بين :start و :end',
    'all_deposit'                               => 'جميع الإيرادات',
    'title_deposit_between'                     => 'جميع الإيرادات بين :start و :end',
    'all_transfers'                             => 'جميع التحويلات',
    'title_transfers_between'                   => 'جميع التحويلات بين :start و :end',
    'all_transfer'                              => 'جميع التحويلات',
    'all_journals_for_tag'                      => 'جميع المعاملات للوسم ":tag"',
    'title_transfer_between'                    => 'جميع التحويلات بين :start و :end',
    'all_journals_for_category'                 => 'جميع المعاملات للفئة :name',
    'all_journals_for_budget'                   => 'جميع المعاملات للميزانية :name',
    'chart_all_journals_for_budget'             => 'مخطط جميع المعاملات للميزانية :name',
    'journals_in_period_for_category'           => 'جميع المعاملات للفئة :name بين :start و :end',
    'journals_in_period_for_tag'                => 'جميع المعاملات للوسم :tag بين :start و :end',
    'not_available_demo_user'                   => 'الميزة التي تحاول الوصول إليها غير متاحة لمستخدمي العرض التوضيحي.',
    'exchange_rate_instructions'                => 'حساب الأصول "@name" يقبل المعاملات في @primary_currency فقط. إذا كنت ترغب في استخدام @foreign_currency بدلاً من ذلك، تأكد من أن المبلغ في @primary_currency معروف أيضاً:',
    'transfer_exchange_rate_instructions'       => 'حساب الأصول المصدر "@source_name" يقبل المعاملات في @source_currency فقط. حساب الأصول الوجهة "@dest_name" يقبل المعاملات في @dest_currency فقط. يجب عليك تقديم المبلغ المحول بشكل صحيح في كلا العملتين.',
    'transaction_data'                          => 'بيانات المعاملة',
    'invalid_server_configuration'              => 'إعدادات الخادم غير صالحة',
    'invalid_locale_settings'                   => 'لا يستطيع Firefly III تنسيق المبالغ المالية لأن الخادم يفتقد الحزم المطلوبة. توجد <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">تعليمات حول كيفية القيام بذلك</a>.',
    'quickswitch'                               => 'تبديل سريع',
    'sign_in_to_start'                          => 'سجّل الدخول لبدء جلستك',
    'sign_in'                                   => 'تسجيل الدخول',
    'register_new_account'                      => 'تسجيل حساب جديد',
    'forgot_my_password'                        => 'نسيت كلمة المرور',
    'problems_with_input'                       => 'حدثت بعض المشاكل في مدخلاتك.',
    'reset_password'                            => 'إعادة تعيين كلمة المرور',
    'button_reset_password'                     => 'إعادة تعيين كلمة المرور',
    'reset_button'                              => 'إعادة تعيين',
    'want_to_login'                             => 'أرغب في تسجيل الدخول',
    'login_page_title'                          => 'تسجيل الدخول إلى Firefly III',
    'register_page_title'                       => 'التسجيل في Firefly III',
    'forgot_pw_page_title'                      => 'نسيت كلمة المرور لـ Firefly III',
    'reset_pw_page_title'                       => 'إعادة تعيين كلمة المرور لـ Firefly III',
    'cannot_reset_demo_user'                    => 'لا يمكنك إعادة تعيين كلمة مرور مستخدم العرض التوضيحي.',
    'no_att_demo_user'                          => 'مستخدم العرض التوضيحي لا يمكنه رفع المرفقات.',
    'button_register'                           => 'تسجيل',
    'authorization'                             => 'تفويض',
    'active_bills_only'                         => 'اشتراك نشط فقط',
    'active_bills_only_total'                   => 'جميع الاشتراكات النشطة',
    'active_exp_bills_only'                     => 'الاشتراكات النشطة والمتوقعة فقط',
    'active_exp_bills_only_total'               => 'جميع الاشتراكات النشطة والمتوقعة فقط',
    'per_period_sum_1D'                         => 'التكاليف اليومية المتوقعة',
    'per_period_sum_1W'                         => 'التكاليف الأسبوعية المتوقعة',
    'per_period_sum_1M'                         => 'التكاليف الشهرية المتوقعة',
    'per_period_sum_3M'                         => 'التكاليف الفصلية المتوقعة',
    'per_period_sum_6M'                         => 'التكاليف نصف السنوية المتوقعة',
    'per_period_sum_1Y'                         => 'التكاليف السنوية المتوقعة',
    'average_per_bill'                          => 'المتوسط لكل اشتراك',
    'expected_total'                            => 'الإجمالي المتوقع',
    'reconciliation_account_name'               => 'تسوية :name (:currency)',
    'saved'                                     => 'تم الحفظ',
    'advanced_options'                          => 'خيارات متقدمة',
    'advanced_options_explain'                  => 'بعض الصفحات في Firefly III لديها خيارات متقدمة مخفية خلف هذا الزر. هذه الصفحة لا تحتوي على شيء مميز هنا، لكن تحقق من الصفحات الأخرى!',
    'here_be_dragons'                           => 'هنا يوجد تنبيه',
    'bad_date_transaction'                      => 'اكتشف Firefly III أن لديك معاملات من قبل عام 1970. يرجى تصحيح هذه المعاملات في أقرب وقت ممكن.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'ويب هوكس',
    'webhooks_breadcrumb'                       => 'ويب هوكس',
    'webhooks_menu_disabled'                    => 'معطل',
    'no_webhook_messages'                       => 'لا توجد رسائل ويب هوك',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'بعد إنشاء المعاملة',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'بعد تحديث المعاملة',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'بعد حذف المعاملة',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'تفاصيل المعاملة',
    'webhook_response_ACCOUNTS'                 => 'تفاصيل الحساب',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'تفقد',
    'create_new_webhook'                        => 'إنشاء ويب هوك جديد',
    'webhooks_create_breadcrumb'                => 'إنشاء ويب هوك جديد',
    'webhook_trigger_form_help'                 => 'حدد الحدث الذي سيشغل الويب هوك',
    'webhook_response_form_help'                => 'حدد ما يجب أن يرسله الويب هوك إلى الرابط.',
    'webhook_delivery_form_help'                => 'حدد أي صيغة يجب أن يرسل بها الويب هوك البيانات.',
    'webhook_active_form_help'                  => 'يجب أن يكون الويب هوك نشطاً وإلا لن يتم استدعاؤه.',
    'stored_new_webhook'                        => 'تم حفظ ويب هوك جديد ":title"',
    'delete_webhook'                            => 'حذف ويب هوك',
    'deleted_webhook'                           => 'تم حذف ويب هوك ":title"',
    'edit_webhook'                              => 'تعديل ويب هوك ":title"',
    'updated_webhook'                           => 'تم تحديث ويب هوك ":title"',
    'edit_webhook_js'                           => 'تعديل ويب هوك "{title}"',
    'show_webhook'                              => 'ويب هوك ":title"',
    'webhook_was_triggered'                     => 'تم تشغيل الويب هوك على المعاملة المحددة. يرجى الانتظار حتى تظهر النتائج.',
    'webhook_messages'                          => 'رسالة ويب هوك',
    'view_message'                              => 'عرض الرسالة',
    'view_attempts'                             => 'عرض المحاولات الفاشلة',
    'message_content_title'                     => 'محتوى رسالة الويب هوك',
    'message_content_help'                      => 'هذا هو محتوى الرسالة التي تم إرسالها (أو محاولة إرسالها) باستخدام هذا الويب هوك.',
    'attempt_content_title'                     => 'محاولات الويب هوك',
    'attempt_content_help'                      => 'هذه هي جميع المحاولات غير الناجحة لهذه الرسالة لإرسالها إلى الرابط المحدد. بعد فترة، سيتوقف Firefly III عن المحاولة.',
    'no_attempts'                               => 'لا توجد محاولات غير ناجحة. هذا أمر جيد!',
    'webhook_attempt_at'                        => 'محاولة في {moment}',
    'logs'                                      => 'السجلات',
    'response'                                  => 'الاستجابة',
    'visit_webhook_url'                         => 'زيارة رابط الويب هوك',
    'reset_webhook_secret'                      => 'إعادة تعيين سر الويب هوك',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">ويب هوك #{ID} ("{title}")</a> تم حفظه.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">ويب هوك #{ID}</a> ("{title}") تم تحديثه.',

    // API access
    'authorization_request'                     => 'طلب تفويض Firefly III v:version',
    'authorization_request_intro'               => 'التطبيق "<strong>:client</strong>" يطلب إذناً للوصول إلى إدارتك المالية. هل ترغب في تفويض <strong>:client</strong> للوصول إلى هذه السجلات؟',
    'authorization_request_site'                => 'سيتم إعادة توجيهك إلى <code>:url</code> والذي سيتمكن بعد ذلك من الوصول إلى بيانات Firefly III الخاصة بك.',
    'authorization_request_invalid'             => 'طلب الوصول هذا غير صالح. يرجى عدم اتباع هذا الرابط مرة أخرى.',
    'scopes_will_be_able'                       => 'سيكون هذا التطبيق قادراً على:',
    'button_authorize'                          => 'تفويض',
    'none_in_select_list'                       => '(لا يوجد)',
    'no_piggy_bank'                             => '(لا توجد حصالة)',
    'name_in_currency'                          => ':name بـ :currency',
    'paid_in_currency'                          => 'مدفوع بـ :currency',
    'unpaid_in_currency'                        => 'غير مدفوع بـ :currency',
    'is_alpha_warning'                          => 'أنت تستخدم إصدار ALPHA. كن حذراً من الأخطاء والمشاكل.',
    'is_beta_warning'                           => 'أنت تستخدم إصدار BETA. كن حذراً من الأخطاء والمشاكل.',
    'all_destination_accounts'                  => 'حسابات الوجهة',
    'all_source_accounts'                       => 'حسابات المصدر',
    'back_to_index'                             => 'العودة إلى الفهرس',
    'cant_logout_guard'                         => 'لا يمكن لـ Firefly III تسجيل خروجك.',
    'internal_reference'                        => 'مرجع داخلي',

    // check for updates:
    'update_check_title'                        => 'التحقق من التحديثات',
    'admin_update_check_title'                  => 'التحقق التلقائي من التحديثات',
    'admin_update_check_explain'                => 'يمكن لـ Firefly III التحقق من التحديثات تلقائياً. عند تفعيل هذا الخيار، سيتصل بخادم تحديثات Firefly III لمعرفة ما إذا كان هناك إصدار جديد متاح. عند توفره، ستتلقى إشعاراً. يمكنك اختبار هذا الإشعار باستخدام الزر على اليمين. يرجى تحديد ما إذا كنت تريد أن يتحقق Firefly III من التحديثات.',
    'check_for_updates_permission'              => 'يمكن لـ Firefly III التحقق من التحديثات، لكنه يحتاج إلى إذنك للقيام بذلك. يرجى الذهاب إلى <a href=":link">الإعدادات</a> لتحديد ما إذا كنت ترغب في تفعيل هذه الميزة.',
    'updates_ask_me_later'                      => 'اسألني لاحقاً',
    'updates_do_not_check'                      => 'لا تتحقق من التحديثات',
    'updates_enable_check'                      => 'تفعيل التحقق من التحديثات',
    'admin_update_check_now_title'              => 'تحقق من التحديثات الآن',
    'admin_update_check_now_explain'            => 'إذا ضغطت على الزر، سيتحقق Firefly III مما إذا كان إصدارك الحالي هو الأحدث.',
    'check_for_updates_button'                  => 'تحقق الآن!',
    'update_new_version_alert'                  => 'يتوفر إصدار جديد من Firefly III. أنت تستخدم :your_version، وأحدث إصدار هو :new_version الذي تم إصداره في :date.',
    'update_version_beta'                       => 'هذا الإصدار هو إصدار BETA. قد تواجه بعض المشاكل.',
    'update_version_alpha'                      => 'هذا الإصدار هو إصدار ALPHA. قد تواجه بعض المشاكل.',
    'update_current_dev_older'                  => 'أنت تستخدم إصدار تطوير ":version"، وهو أقدم من أحدث إصدار :new_version. يرجى التحديث!',
    'update_current_dev_newer'                  => 'أنت تستخدم إصدار تطوير ":version"، وهو أحدث من أحدث إصدار :new_version.',
    'update_current_version_alert'              => 'أنت تستخدم الإصدار :version، وهو أحدث إصدار متاح.',
    'update_newer_version_alert'                => 'أنت تستخدم الإصدار :your_version، وهو أحدث من أحدث إصدار، :new_version.',
    'update_check_error'                        => 'حدث خطأ أثناء التحقق من التحديثات: :error',
    'unknown_error'                             => 'خطأ غير معروف. نعتذر عن ذلك.',
    'disabled_but_check'                        => 'لقد عطلت التحقق من التحديثات. لذا لا تنس التحقق من التحديثات بنفسك من حين لآخر. شكراً لك!',
    'admin_update_channel_title'                => 'قناة التحديث',
    'admin_update_channel_explain'              => 'لدى Firefly III ثلاث "قنوات" تحديث تحدد مدى تقدمك في الميزات والتحسينات والأخطاء. استخدم قناة "بيتا" إذا كنت مغامراً و"ألفا" إذا كنت تحب المخاطرة.',
    'update_channel_stable'                     => 'مستقر. يجب أن يعمل كل شيء كما هو متوقع.',
    'update_channel_beta'                       => 'بيتا. ميزات جديدة لكن قد تكون هناك مشاكل.',
    'update_channel_alpha'                      => 'ألفا. نضيف كل شيء ونرى ما ينجح.',

    // search
    'search'                                    => 'بحث',
    'search_query'                              => 'استعلام',
    'search_found_transactions'                 => 'عثر Firefly III على معاملة واحدة في :time ثانية.|عثر Firefly III على :count معاملات في :time ثانية.',
    'search_found_more_transactions'            => 'عثر Firefly III على أكثر من :count معاملات في :time ثانية.',
    'search_for_overview'                       => 'يبحث Firefly III عن المعاملات التي تحقق <b>جميع</b> الشروط التالية:',
    'search_for_query'                          => 'يجب أن تكون جميع هذه الكلمات موجودة: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'يجب ألا تكون أي من هذه الكلمات موجودة: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'معاملات البحث هذه غير صحيحة وتم تجاهلها.',

    // old


    'search_modifier_date_on'                             => 'تاريخ المعاملة هو ":value"',
    'search_modifier_not_date_on'                         => 'تاريخ المعاملة ليس ":value"',
    'search_modifier_reconciled'                          => 'المعاملة تمت تسويتها',
    'search_modifier_not_reconciled'                      => 'المعاملة لم تتم تسويتها',
    'search_modifier_id'                                  => 'معرف المعاملة هو ":value"',
    'search_modifier_not_id'                              => 'معرف المعاملة ليس ":value"',
    'search_modifier_date_before'                         => 'تاريخ المعاملة قبل أو في ":value"',
    'search_modifier_date_after'                          => 'تاريخ المعاملة بعد أو في ":value"',
    'search_modifier_external_id_is'                      => 'المعرف الخارجي هو ":value"',
    'search_modifier_not_external_id_is'                  => 'المعرف الخارجي ليس ":value"',
    'search_modifier_no_external_url'                     => 'المعاملة ليس لديها رابط خارجي',
    'search_modifier_no_external_id'                      => 'المعاملة ليس لديها معرف خارجي',
    'search_modifier_not_any_external_url'                => 'المعاملة ليس لديها رابط خارجي',
    'search_modifier_not_any_external_id'                 => 'المعاملة ليس لديها معرف خارجي',
    'search_modifier_any_external_url'                    => 'يجب أن تحتوي المعاملة على رابط خارجي (أي رابط)',
    'search_modifier_any_external_id'                     => 'يجب أن تحتوي المعاملة على معرف خارجي (أي معرف)',
    'search_modifier_not_no_external_url'                 => 'يجب أن تحتوي المعاملة على رابط خارجي (أي رابط)',
    'search_modifier_not_no_external_id'                  => 'يجب أن تحتوي المعاملة على معرف خارجي (أي معرف)',
    'search_modifier_internal_reference_is'               => 'المرجع الداخلي هو ":value"',
    'search_modifier_not_internal_reference_is'           => 'المرجع الداخلي ليس ":value"',
    'search_modifier_description_starts'                  => 'الوصف يبدأ بـ ":value"',
    'search_modifier_not_description_starts'              => 'الوصف لا يبدأ بـ ":value"',
    'search_modifier_description_ends'                    => 'الوصف ينتهي بـ ":value"',
    'search_modifier_not_description_ends'                => 'الوصف لا ينتهي بـ ":value"',
    'search_modifier_description_contains'                => 'الوصف يحتوي على ":value"',
    'search_modifier_not_description_contains'            => 'الوصف لا يحتوي على ":value"',
    'search_modifier_description_is'                      => 'الوصف يساوي تماماً ":value"',
    'search_modifier_not_description_is'                  => 'الوصف لا يساوي تماماً ":value"',
    'search_modifier_currency_is'                         => 'عملة المعاملة (الأجنبية) هي ":value"',
    'search_modifier_not_currency_is'                     => 'عملة المعاملة (الأجنبية) ليست ":value"',
    'search_modifier_foreign_currency_is'                 => 'العملة الأجنبية للمعاملة هي ":value"',
    'search_modifier_not_foreign_currency_is'             => 'العملة الأجنبية للمعاملة ليست ":value"',
    'search_modifier_has_attachments'                     => 'يجب أن تحتوي المعاملة على مرفق',
    'search_modifier_has_no_category'                     => 'يجب ألا تحتوي المعاملة على فئة',
    'search_modifier_not_has_no_category'                 => 'يجب أن تحتوي المعاملة على فئة (أي فئة)',
    'search_modifier_not_has_any_category'                => 'يجب ألا تحتوي المعاملة على فئة',
    'search_modifier_has_any_category'                    => 'يجب أن تحتوي المعاملة على فئة (أي فئة)',
    'search_modifier_has_no_budget'                       => 'يجب ألا تحتوي المعاملة على ميزانية',
    'search_modifier_not_has_any_budget'                  => 'يجب ألا تحتوي المعاملة على ميزانية',
    'search_modifier_has_any_budget'                      => 'يجب أن تحتوي المعاملة على ميزانية (أي ميزانية)',
    'search_modifier_not_has_no_budget'                   => 'يجب أن تحتوي المعاملة على ميزانية (أي ميزانية)',
    'search_modifier_has_no_bill'                         => 'يجب ألا تحتوي المعاملة على اشتراك',
    'search_modifier_not_has_no_bill'                     => 'يجب أن تحتوي المعاملة على اشتراك (أي اشتراك)',
    'search_modifier_has_any_bill'                        => 'يجب أن تحتوي المعاملة على اشتراك (أي اشتراك)',
    'search_modifier_not_has_any_bill'                    => 'يجب ألا تحتوي المعاملة على اشتراك',
    'search_modifier_has_no_tag'                          => 'يجب ألا تحتوي المعاملة على وسوم',
    'search_modifier_not_has_any_tag'                     => 'يجب ألا تحتوي المعاملة على وسوم',
    'search_modifier_not_has_no_tag'                      => 'يجب أن تحتوي المعاملة على وسم (أي وسم)',
    'search_modifier_has_any_tag'                         => 'يجب أن تحتوي المعاملة على وسم (أي وسم)',
    'search_modifier_notes_contains'                      => 'ملاحظات المعاملة تحتوي على ":value"',
    'search_modifier_not_notes_contains'                  => 'ملاحظات المعاملة لا تحتوي على ":value"',
    'search_modifier_notes_starts'                        => 'ملاحظات المعاملة تبدأ بـ ":value"',
    'search_modifier_not_notes_starts'                    => 'ملاحظات المعاملة لا تبدأ بـ ":value"',
    'search_modifier_notes_ends'                          => 'ملاحظات المعاملة تنتهي بـ ":value"',
    'search_modifier_not_notes_ends'                      => 'ملاحظات المعاملة لا تنتهي بـ ":value"',
    'search_modifier_notes_is'                            => 'ملاحظات المعاملة تساوي تماماً ":value"',
    'search_modifier_not_notes_is'                        => 'ملاحظات المعاملة لا تساوي تماماً ":value"',
    'search_modifier_no_notes'                            => 'المعاملة ليس لديها ملاحظات',
    'search_modifier_not_no_notes'                        => 'يجب أن تحتوي المعاملة على ملاحظات',
    'search_modifier_any_notes'                           => 'يجب أن تحتوي المعاملة على ملاحظات',
    'search_modifier_not_any_notes'                       => 'المعاملة ليس لديها ملاحظات',
    'search_modifier_amount_is'                           => 'المبلغ يساوي تماماً :value',
    'search_modifier_not_amount_is'                       => 'المبلغ لا يساوي :value',
    'search_modifier_amount_less'                         => 'المبلغ أقل من أو يساوي :value',
    'search_modifier_not_amount_more'                     => 'المبلغ أقل من أو يساوي :value',
    'search_modifier_amount_more'                         => 'المبلغ أكبر من أو يساوي :value',
    'search_modifier_not_amount_less'                     => 'المبلغ أكبر من أو يساوي :value',
    'search_modifier_source_account_is'                   => 'اسم حساب المصدر يساوي تماماً ":value"',
    'search_modifier_not_source_account_is'               => 'اسم حساب المصدر لا يساوي ":value"',
    'search_modifier_source_account_contains'             => 'اسم حساب المصدر يحتوي على ":value"',
    'search_modifier_not_source_account_contains'         => 'اسم حساب المصدر لا يحتوي على ":value"',
    'search_modifier_source_account_starts'               => 'اسم حساب المصدر يبدأ بـ ":value"',
    'search_modifier_not_source_account_starts'           => 'اسم حساب المصدر لا يبدأ بـ ":value"',
    'search_modifier_source_account_ends'                 => 'اسم حساب المصدر ينتهي بـ ":value"',
    'search_modifier_not_source_account_ends'             => 'اسم حساب المصدر لا ينتهي بـ ":value"',
    'search_modifier_source_account_id'                   => 'معرف حساب المصدر هو :value',
    'search_modifier_not_source_account_id'               => 'معرف حساب المصدر ليس :value',
    'search_modifier_source_account_nr_is'                => 'رقم حساب المصدر (IBAN) هو ":value"',
    'search_modifier_not_source_account_nr_is'            => 'رقم حساب المصدر (IBAN) ليس ":value"',
    'search_modifier_source_account_nr_contains'          => 'رقم حساب المصدر (IBAN) يحتوي على ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'رقم حساب المصدر (IBAN) لا يحتوي على ":value"',
    'search_modifier_source_account_nr_starts'            => 'رقم حساب المصدر (IBAN) يبدأ بـ ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'رقم حساب المصدر (IBAN) لا يبدأ بـ ":value"',
    'search_modifier_source_account_nr_ends'              => 'رقم حساب المصدر (IBAN) ينتهي بـ ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'رقم حساب المصدر (IBAN) لا ينتهي بـ ":value"',
    'search_modifier_destination_account_is'              => 'اسم حساب الوجهة يساوي تماماً ":value"',
    'search_modifier_not_destination_account_is'          => 'اسم حساب الوجهة لا يساوي ":value"',
    'search_modifier_destination_account_contains'        => 'اسم حساب الوجهة يحتوي على ":value"',
    'search_modifier_not_destination_account_contains'    => 'اسم حساب الوجهة لا يحتوي على ":value"',
    'search_modifier_destination_account_starts'          => 'اسم حساب الوجهة يبدأ بـ ":value"',
    'search_modifier_not_destination_account_starts'      => 'اسم حساب الوجهة لا يبدأ بـ ":value"',
    'search_modifier_destination_account_ends'            => 'اسم حساب الوجهة ينتهي بـ ":value"',
    'search_modifier_not_destination_account_ends'        => 'اسم حساب الوجهة لا ينتهي بـ ":value"',
    'search_modifier_destination_account_id'              => 'معرف حساب الوجهة هو :value',
    'search_modifier_not_destination_account_id'          => 'معرف حساب الوجهة ليس :value',
    'search_modifier_destination_is_cash'                 => 'حساب الوجهة هو حساب "(نقد)"',
    'search_modifier_not_destination_is_cash'             => 'حساب الوجهة ليس حساب "(نقد)"',
    'search_modifier_source_is_cash'                      => 'حساب المصدر هو حساب "(نقد)"',
    'search_modifier_not_source_is_cash'                  => 'حساب المصدر ليس حساب "(نقد)"',
    'search_modifier_destination_account_nr_is'           => 'رقم حساب الوجهة (IBAN) هو ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'رقم حساب الوجهة (IBAN) ليس ":value"',
    'search_modifier_destination_account_nr_contains'     => 'رقم حساب الوجهة (IBAN) يحتوي على ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'رقم حساب الوجهة (IBAN) لا يحتوي على ":value"',
    'search_modifier_destination_account_nr_starts'       => 'رقم حساب الوجهة (IBAN) يبدأ بـ ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'رقم حساب الوجهة (IBAN) لا يبدأ بـ ":value"',
    'search_modifier_destination_account_nr_ends'         => 'رقم حساب الوجهة (IBAN) ينتهي بـ ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'رقم حساب الوجهة (IBAN) لا ينتهي بـ ":value"',
    'search_modifier_account_id'                          => 'معرف حساب المصدر أو الوجهة هو/هم: :value',
    'search_modifier_not_account_id'                      => 'معرف حساب المصدر أو الوجهة ليس/ليسو: :value',
    'search_modifier_category_is'                         => 'الفئة هي ":value"',
    'search_modifier_not_category_is'                     => 'الفئة ليست ":value"',
    'search_modifier_budget_is'                           => 'الميزانية هي ":value"',
    'search_modifier_not_budget_is'                       => 'الميزانية ليست ":value"',
    'search_modifier_bill_is'                             => 'الاشتراك هو ":value"',
    'search_modifier_not_bill_is'                         => 'الاشتراك ليس ":value"',
    'search_modifier_transaction_type'                    => 'نوع المعاملة هو ":value"',
    'search_modifier_not_transaction_type'                => 'نوع المعاملة ليس ":value"',
    'search_modifier_tag_is'                              => 'الوسم هو ":value"',
    'search_modifier_tag_contains'                        => 'الوسم يحتوي على ":value"',
    'search_modifier_not_tag_contains'                    => 'الوسم لا يحتوي على ":value"',
    'search_modifier_tag_ends'                            => 'الوسم ينتهي بـ ":value"',
    'search_modifier_tag_starts'                          => 'الوسم يبدأ بـ ":value"',
    'search_modifier_not_tag_is'                          => 'لا يوجد وسم هو ":value"',
    'search_modifier_date_on_year'                        => 'المعاملة في السنة ":value"',
    'search_modifier_not_date_on_year'                    => 'المعاملة ليست في السنة ":value"',
    'search_modifier_date_on_month'                       => 'المعاملة في الشهر ":value"',
    'search_modifier_not_date_on_month'                   => 'المعاملة ليست في الشهر ":value"',
    'search_modifier_date_on_day'                         => 'المعاملة في اليوم من الشهر ":value"',
    'search_modifier_not_date_on_day'                     => 'المعاملة ليست في اليوم من الشهر ":value"',
    'search_modifier_date_before_year'                    => 'المعاملة قبل أو في السنة ":value"',
    'search_modifier_date_before_month'                   => 'المعاملة قبل أو في الشهر ":value"',
    'search_modifier_date_before_day'                     => 'المعاملة قبل أو في اليوم من الشهر ":value"',
    'search_modifier_date_after_year'                     => 'المعاملة في أو بعد السنة ":value"',
    'search_modifier_date_after_month'                    => 'المعاملة في أو بعد الشهر ":value"',
    'search_modifier_date_after_day'                      => 'المعاملة بعد أو في اليوم من الشهر ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'لا يوجد وسم هو ":value"',
    'search_modifier_not_tag_is_not'                      => 'الوسم هو ":value"',
    'search_modifier_account_is'                          => 'أي من الحسابين هو ":value"',
    'search_modifier_not_account_is'                      => 'لا يوجد أي من الحسابين هو ":value"',
    'search_modifier_account_contains'                    => 'أي من الحسابين يحتوي على ":value"',
    'search_modifier_not_account_contains'                => 'لا يوجد أي من الحسابين يحتوي على ":value"',
    'search_modifier_account_ends'                        => 'أي من الحسابين ينتهي بـ ":value"',
    'search_modifier_not_account_ends'                    => 'لا يوجد أي من الحسابين ينتهي بـ ":value"',
    'search_modifier_account_starts'                      => 'أي من الحسابين يبدأ بـ ":value"',
    'search_modifier_not_account_starts'                  => 'لا يوجد أي من الحسابين يبدأ بـ ":value"',
    'search_modifier_account_nr_is'                       => 'أي من أرقام الحسابات / IBAN هو ":value"',
    'search_modifier_not_account_nr_is'                   => 'لا يوجد أي من أرقام الحسابات / IBAN هو ":value"',
    'search_modifier_account_nr_contains'                 => 'أي من أرقام الحسابات / IBAN يحتوي على ":value"',
    'search_modifier_not_account_nr_contains'             => 'لا يوجد أي من أرقام الحسابات / IBAN يحتوي على ":value"',
    'search_modifier_account_nr_ends'                     => 'أي من أرقام الحسابات / IBAN ينتهي بـ ":value"',
    'search_modifier_not_account_nr_ends'                 => 'لا يوجد أي من أرقام الحسابات / IBAN ينتهي بـ ":value"',
    'search_modifier_account_nr_starts'                   => 'أي من أرقام الحسابات / IBAN يبدأ بـ ":value"',
    'search_modifier_not_account_nr_starts'               => 'لا يوجد أي من أرقام الحسابات / IBAN يبدأ بـ ":value"',
    'search_modifier_category_contains'                   => 'الفئة تحتوي على ":value"',
    'search_modifier_not_category_contains'               => 'الفئة لا تحتوي على ":value"',
    'search_modifier_category_ends'                       => 'الفئة تنتهي بـ ":value"',
    'search_modifier_not_category_ends'                   => 'الفئة لا تنتهي بـ ":value"',
    'search_modifier_category_starts'                     => 'الفئة تبدأ بـ ":value"',
    'search_modifier_not_category_starts'                 => 'الفئة لا تبدأ بـ ":value"',
    'search_modifier_budget_contains'                     => 'الميزانية تحتوي على ":value"',
    'search_modifier_not_budget_contains'                 => 'الميزانية لا تحتوي على ":value"',
    'search_modifier_budget_ends'                         => 'الميزانية تنتهي بـ ":value"',
    'search_modifier_not_budget_ends'                     => 'الميزانية لا تنتهي بـ ":value"',
    'search_modifier_budget_starts'                       => 'الميزانية تبدأ بـ ":value"',
    'search_modifier_not_budget_starts'                   => 'الميزانية لا تبدأ بـ ":value"',
    'search_modifier_bill_contains'                       => 'الاشتراك يحتوي على ":value"',
    'search_modifier_not_bill_contains'                   => 'الاشتراك لا يحتوي على ":value"',
    'search_modifier_bill_ends'                           => 'الاشتراك ينتهي بـ ":value"',
    'search_modifier_not_bill_ends'                       => 'الاشتراك لا ينتهي بـ ":value"',
    'search_modifier_bill_starts'                         => 'الاشتراك يبدأ بـ ":value"',
    'search_modifier_not_bill_starts'                     => 'الاشتراك لا يبدأ بـ ":value"',
    'search_modifier_external_id_contains'                => 'المعرف الخارجي يحتوي على ":value"',
    'search_modifier_not_external_id_contains'            => 'المعرف الخارجي لا يحتوي على ":value"',
    'search_modifier_external_id_ends'                    => 'المعرف الخارجي ينتهي بـ ":value"',
    'search_modifier_not_external_id_ends'                => 'المعرف الخارجي لا ينتهي بـ ":value"',
    'search_modifier_external_id_starts'                  => 'المعرف الخارجي يبدأ بـ ":value"',
    'search_modifier_not_external_id_starts'              => 'المعرف الخارجي لا يبدأ بـ ":value"',
    'search_modifier_internal_reference_contains'         => 'المرجع الداخلي يحتوي على ":value"',
    'search_modifier_not_internal_reference_contains'     => 'المرجع الداخلي لا يحتوي على ":value"',
    'search_modifier_internal_reference_ends'             => 'المرجع الداخلي ينتهي بـ ":value"',
    'search_modifier_internal_reference_starts'           => 'المرجع الداخلي يبدأ بـ ":value"',
    'search_modifier_not_internal_reference_ends'         => 'المرجع الداخلي لا ينتهي بـ ":value"',
    'search_modifier_not_internal_reference_starts'       => 'المرجع الداخلي لا يبدأ بـ ":value"',
    'search_modifier_external_url_is'                     => 'الرابط الخارجي هو ":value"',
    'search_modifier_not_external_url_is'                 => 'الرابط الخارجي ليس ":value"',
    'search_modifier_external_url_contains'               => 'الرابط الخارجي يحتوي على ":value"',
    'search_modifier_not_external_url_contains'           => 'الرابط الخارجي لا يحتوي على ":value"',
    'search_modifier_external_url_ends'                   => 'الرابط الخارجي ينتهي بـ ":value"',
    'search_modifier_not_external_url_ends'               => 'الرابط الخارجي لا ينتهي بـ ":value"',
    'search_modifier_external_url_starts'                 => 'الرابط الخارجي يبدأ بـ ":value"',
    'search_modifier_not_external_url_starts'             => 'الرابط الخارجي لا يبدأ بـ ":value"',
    'search_modifier_has_no_attachments'                  => 'المعاملة ليس لديها مرفقات',
    'search_modifier_not_has_no_attachments'              => 'المعاملة لديها مرفقات',
    'search_modifier_not_has_attachments'                 => 'المعاملة ليس لديها مرفقات',
    'search_modifier_account_is_cash'                     => 'أي من الحسابين هو حساب "(نقد)".',
    'search_modifier_not_account_is_cash'                 => 'لا يوجد أي من الحسابين هو حساب "(نقد)".',
    'search_modifier_journal_id'                          => 'معرف دفتر اليومية هو ":value"',
    'search_modifier_not_journal_id'                      => 'معرف دفتر اليومية ليس ":value"',
    'search_modifier_recurrence_id'                       => 'معرف المعاملة المتكررة هو ":value"',
    'search_modifier_not_recurrence_id'                   => 'معرف المعاملة المتكررة ليس ":value"',
    'search_modifier_foreign_amount_is'                   => 'المبلغ الأجنبي هو ":value"',
    'search_modifier_not_foreign_amount_is'               => 'المبلغ الأجنبي ليس ":value"',
    'search_modifier_foreign_amount_less'                 => 'المبلغ الأجنبي أقل من ":value"',
    'search_modifier_not_foreign_amount_more'             => 'المبلغ الأجنبي أقل من ":value"',
    'search_modifier_not_foreign_amount_less'             => 'المبلغ الأجنبي أكبر من ":value"',
    'search_modifier_foreign_amount_more'                 => 'المبلغ الأجنبي أكبر من ":value"',
    'search_modifier_exists'                              => 'المعاملة موجودة (أي معاملة)',
    'search_modifier_not_exists'                          => 'المعاملة غير موجودة (لا توجد معاملة)',

    // date fields
    'search_modifier_interest_date_on'                    => 'تاريخ الفائدة للمعاملة هو ":value"',
    'search_modifier_not_interest_date_on'                => 'تاريخ الفائدة للمعاملة ليس ":value"',
    'search_modifier_interest_date_on_year'               => 'تاريخ الفائدة للمعاملة في السنة ":value"',
    'search_modifier_not_interest_date_on_year'           => 'تاريخ الفائدة للمعاملة ليس في السنة ":value"',
    'search_modifier_interest_date_on_month'              => 'تاريخ الفائدة للمعاملة في الشهر ":value"',
    'search_modifier_not_interest_date_on_month'          => 'تاريخ الفائدة للمعاملة ليس في الشهر ":value"',
    'search_modifier_interest_date_on_day'                => 'تاريخ الفائدة للمعاملة في اليوم من الشهر ":value"',
    'search_modifier_not_interest_date_on_day'            => 'تاريخ الفائدة للمعاملة ليس في اليوم من الشهر ":value"',
    'search_modifier_interest_date_before_year'           => 'تاريخ الفائدة للمعاملة قبل أو في السنة ":value"',
    'search_modifier_interest_date_before_month'          => 'تاريخ الفائدة للمعاملة قبل أو في الشهر ":value"',
    'search_modifier_interest_date_before_day'            => 'تاريخ الفائدة للمعاملة قبل أو في اليوم من الشهر ":value"',
    'search_modifier_interest_date_after_year'            => 'تاريخ الفائدة للمعاملة بعد أو في السنة ":value"',
    'search_modifier_interest_date_after_month'           => 'تاريخ الفائدة للمعاملة بعد أو في الشهر ":value"',
    'search_modifier_interest_date_after_day'             => 'تاريخ الفائدة للمعاملة بعد أو في اليوم من الشهر ":value"',
    'search_modifier_book_date_on_year'                   => 'تاريخ قيد المعاملة في السنة ":value"',
    'search_modifier_book_date_on_month'                  => 'تاريخ قيد المعاملة في الشهر ":value"',
    'search_modifier_book_date_on_day'                    => 'تاريخ قيد المعاملة في اليوم من الشهر ":value"',
    'search_modifier_not_book_date_on_year'               => 'تاريخ قيد المعاملة ليس في السنة ":value"',
    'search_modifier_not_book_date_on_month'              => 'تاريخ قيد المعاملة ليس في الشهر ":value"',
    'search_modifier_not_book_date_on_day'                => 'تاريخ قيد المعاملة ليس في اليوم من الشهر ":value"',
    'search_modifier_book_date_before_year'               => 'تاريخ قيد المعاملة قبل أو في السنة ":value"',
    'search_modifier_book_date_before_month'              => 'تاريخ قيد المعاملة قبل أو في الشهر ":value"',
    'search_modifier_book_date_before_day'                => 'تاريخ قيد المعاملة قبل أو في اليوم من الشهر ":value"',
    'search_modifier_book_date_after_year'                => 'تاريخ قيد المعاملة بعد أو في السنة ":value"',
    'search_modifier_book_date_after_month'               => 'تاريخ قيد المعاملة بعد أو في الشهر ":value"',
    'search_modifier_book_date_after_day'                 => 'تاريخ قيد المعاملة بعد أو في اليوم من الشهر ":value"',
    'search_modifier_process_date_on_year'                => 'تاريخ معالجة المعاملة في السنة ":value"',
    'search_modifier_process_date_on_month'               => 'تاريخ معالجة المعاملة في الشهر ":value"',
    'search_modifier_process_date_on_day'                 => 'تاريخ معالجة المعاملة في اليوم من الشهر ":value"',
    'search_modifier_not_process_date_on_year'            => 'تاريخ معالجة المعاملة ليس في السنة ":value"',
    'search_modifier_not_process_date_on_month'           => 'تاريخ معالجة المعاملة ليس في الشهر ":value"',
    'search_modifier_not_process_date_on_day'             => 'تاريخ معالجة المعاملة ليس في اليوم من الشهر ":value"',
    'search_modifier_process_date_before_year'            => 'تاريخ معالجة المعاملة قبل أو في السنة ":value"',
    'search_modifier_process_date_before_month'           => 'تاريخ معالجة المعاملة قبل أو في الشهر ":value"',
    'search_modifier_process_date_before_day'             => 'تاريخ معالجة المعاملة قبل أو في اليوم من الشهر ":value"',
    'search_modifier_process_date_after_year'             => 'تاريخ معالجة المعاملة بعد أو في السنة ":value"',
    'search_modifier_process_date_after_month'            => 'تاريخ معالجة المعاملة بعد أو في الشهر ":value"',
    'search_modifier_process_date_after_day'              => 'تاريخ معالجة المعاملة بعد أو في اليوم من الشهر ":value"',
    'search_modifier_due_date_on_year'                    => 'تاريخ الاستحقاق في السنة ":value"',
    'search_modifier_due_date_on_month'                   => 'تاريخ الاستحقاق في الشهر ":value"',
    'search_modifier_due_date_on_day'                     => 'تاريخ الاستحقاق في اليوم من الشهر ":value"',
    'search_modifier_not_due_date_on_year'                => 'تاريخ الاستحقاق ليس في السنة ":value"',
    'search_modifier_not_due_date_on_month'               => 'تاريخ الاستحقاق ليس في الشهر ":value"',
    'search_modifier_not_due_date_on_day'                 => 'تاريخ الاستحقاق ليس في اليوم من الشهر ":value"',
    'search_modifier_due_date_before_year'                => 'تاريخ الاستحقاق قبل أو في السنة ":value"',
    'search_modifier_due_date_before_month'               => 'تاريخ الاستحقاق قبل أو في الشهر ":value"',
    'search_modifier_due_date_before_day'                 => 'تاريخ الاستحقاق قبل أو في اليوم من الشهر ":value"',
    'search_modifier_due_date_after_year'                 => 'تاريخ الاستحقاق بعد أو في السنة ":value"',
    'search_modifier_due_date_after_month'                => 'تاريخ الاستحقاق بعد أو في الشهر ":value"',
    'search_modifier_due_date_after_day'                  => 'تاريخ الاستحقاق بعد أو في اليوم من الشهر ":value"',
    'search_modifier_payment_date_on_year'                => 'تاريخ الدفع في السنة ":value"',
    'search_modifier_payment_date_on_month'               => 'تاريخ الدفع في الشهر ":value"',
    'search_modifier_payment_date_on_day'                 => 'تاريخ الدفع في اليوم من الشهر ":value"',
    'search_modifier_not_payment_date_on_year'            => 'تاريخ الدفع ليس في السنة ":value"',
    'search_modifier_not_payment_date_on_month'           => 'تاريخ الدفع ليس في الشهر ":value"',
    'search_modifier_not_payment_date_on_day'             => 'تاريخ الدفع ليس في اليوم من الشهر ":value"',
    'search_modifier_payment_date_before_year'            => 'تاريخ الدفع قبل أو في السنة ":value"',
    'search_modifier_payment_date_before_month'           => 'تاريخ الدفع قبل أو في الشهر ":value"',
    'search_modifier_payment_date_before_day'             => 'تاريخ الدفع قبل أو في اليوم من الشهر ":value"',
    'search_modifier_payment_date_after_year'             => 'تاريخ الدفع بعد أو في السنة ":value"',
    'search_modifier_payment_date_after_month'            => 'تاريخ الدفع بعد أو في الشهر ":value"',
    'search_modifier_payment_date_after_day'              => 'تاريخ الدفع بعد أو في اليوم من الشهر ":value"',
    'search_modifier_invoice_date_on_year'                => 'تاريخ الفاتورة في السنة ":value"',
    'search_modifier_invoice_date_on_month'               => 'تاريخ الفاتورة في الشهر ":value"',
    'search_modifier_invoice_date_on_day'                 => 'تاريخ الفاتورة في اليوم من الشهر ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'تاريخ الفاتورة ليس في السنة ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'تاريخ الفاتورة ليس في الشهر ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'تاريخ الفاتورة ليس في اليوم من الشهر ":value"',
    'search_modifier_invoice_date_before_year'            => 'تاريخ الفاتورة قبل أو في السنة ":value"',
    'search_modifier_invoice_date_before_month'           => 'تاريخ الفاتورة قبل أو في الشهر ":value"',
    'search_modifier_invoice_date_before_day'             => 'تاريخ الفاتورة قبل أو في اليوم من الشهر ":value"',
    'search_modifier_invoice_date_after_year'             => 'تاريخ الفاتورة بعد أو في السنة ":value"',
    'search_modifier_invoice_date_after_month'            => 'تاريخ الفاتورة بعد أو في الشهر ":value"',
    'search_modifier_invoice_date_after_day'              => 'تاريخ الفاتورة بعد أو في اليوم من الشهر ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'تم تحديث المعاملة آخر مرة في السنة ":value"',
    'search_modifier_updated_at_on_month'                 => 'تم تحديث المعاملة آخر مرة في الشهر ":value"',
    'search_modifier_updated_at_on_day'                   => 'تم تحديث المعاملة آخر مرة في اليوم من الشهر ":value"',
    'search_modifier_not_updated_at_on_year'              => 'لم يتم تحديث المعاملة آخر مرة في السنة ":value"',
    'search_modifier_not_updated_at_on_month'             => 'لم يتم تحديث المعاملة آخر مرة في الشهر ":value"',
    'search_modifier_not_updated_at_on_day'               => 'لم يتم تحديث المعاملة آخر مرة في اليوم من الشهر ":value"',
    'search_modifier_updated_at_before_year'              => 'تم تحديث المعاملة آخر مرة في أو قبل السنة ":value"',
    'search_modifier_updated_at_before_month'             => 'تم تحديث المعاملة آخر مرة في أو قبل الشهر ":value"',
    'search_modifier_updated_at_before_day'               => 'تم تحديث المعاملة آخر مرة في أو قبل اليوم من الشهر ":value"',
    'search_modifier_updated_at_after_year'               => 'تم تحديث المعاملة آخر مرة في أو بعد السنة ":value"',
    'search_modifier_updated_at_after_month'              => 'تم تحديث المعاملة آخر مرة في أو بعد الشهر ":value"',
    'search_modifier_updated_at_after_day'                => 'تم تحديث المعاملة آخر مرة في أو بعد اليوم من الشهر ":value"',
    'search_modifier_created_at_on_year'                  => 'تم إنشاء المعاملة في السنة ":value"',
    'search_modifier_created_at_on_month'                 => 'تم إنشاء المعاملة في الشهر ":value"',
    'search_modifier_created_at_on_day'                   => 'تم إنشاء المعاملة في اليوم من الشهر ":value"',
    'search_modifier_not_created_at_on_year'              => 'لم يتم إنشاء المعاملة في السنة ":value"',
    'search_modifier_not_created_at_on_month'             => 'لم يتم إنشاء المعاملة في الشهر ":value"',
    'search_modifier_not_created_at_on_day'               => 'لم يتم إنشاء المعاملة في اليوم من الشهر ":value"',
    'search_modifier_created_at_before_year'              => 'تم إنشاء المعاملة في أو قبل السنة ":value"',
    'search_modifier_created_at_before_month'             => 'تم إنشاء المعاملة في أو قبل الشهر ":value"',
    'search_modifier_created_at_before_day'               => 'تم إنشاء المعاملة في أو قبل اليوم من الشهر ":value"',
    'search_modifier_created_at_after_year'               => 'تم إنشاء المعاملة في أو بعد السنة ":value"',
    'search_modifier_created_at_after_month'              => 'تم إنشاء المعاملة في أو بعد الشهر ":value"',
    'search_modifier_created_at_after_day'                => 'تم إنشاء المعاملة في أو بعد اليوم من الشهر ":value"',
    'search_modifier_interest_date_before'                => 'تاريخ الفائدة للمعاملة في أو قبل ":value"',
    'search_modifier_interest_date_after'                 => 'تاريخ الفائدة للمعاملة في أو بعد ":value"',
    'search_modifier_book_date_on'                        => 'تاريخ قيد المعاملة هو ":value"',
    'search_modifier_not_book_date_on'                    => 'تاريخ قيد المعاملة ليس ":value"',
    'search_modifier_book_date_before'                    => 'تاريخ قيد المعاملة في أو قبل ":value"',
    'search_modifier_book_date_after'                     => 'تاريخ قيد المعاملة في أو بعد ":value"',
    'search_modifier_process_date_on'                     => 'تاريخ معالجة المعاملة هو ":value"',
    'search_modifier_not_process_date_on'                 => 'تاريخ معالجة المعاملة ليس ":value"',
    'search_modifier_process_date_before'                 => 'تاريخ معالجة المعاملة في أو قبل ":value"',
    'search_modifier_process_date_after'                  => 'تاريخ معالجة المعاملة في أو بعد ":value"',
    'search_modifier_due_date_on'                         => 'تاريخ الاستحقاق هو ":value"',
    'search_modifier_not_due_date_on'                     => 'تاريخ الاستحقاق ليس ":value"',
    'search_modifier_due_date_before'                     => 'تاريخ الاستحقاق في أو قبل ":value"',
    'search_modifier_due_date_after'                      => 'تاريخ الاستحقاق في أو بعد ":value"',
    'search_modifier_payment_date_on'                     => 'تاريخ الدفع هو ":value"',
    'search_modifier_not_payment_date_on'                 => 'تاريخ الدفع ليس ":value"',
    'search_modifier_payment_date_before'                 => 'تاريخ الدفع في أو قبل ":value"',
    'search_modifier_payment_date_after'                  => 'تاريخ الدفع في أو بعد ":value"',
    'search_modifier_invoice_date_on'                     => 'تاريخ الفاتورة هو ":value"',
    'search_modifier_not_invoice_date_on'                 => 'تاريخ الفاتورة ليس ":value"',
    'search_modifier_invoice_date_before'                 => 'تاريخ الفاتورة في أو قبل ":value"',
    'search_modifier_invoice_date_after'                  => 'تاريخ الفاتورة في أو بعد ":value"',
    'search_modifier_created_at_on'                       => 'تم إنشاء المعاملة في ":value"',
    'search_modifier_not_created_at_on'                   => 'لم يتم إنشاء المعاملة في ":value"',
    'search_modifier_created_at_before'                   => 'تم إنشاء المعاملة في أو قبل ":value"',
    'search_modifier_created_at_after'                    => 'تم إنشاء المعاملة في أو بعد ":value"',
    'search_modifier_updated_at_on'                       => 'تم تحديث المعاملة في ":value"',
    'search_modifier_not_updated_at_on'                   => 'لم يتم تحديث المعاملة في ":value"',
    'search_modifier_updated_at_before'                   => 'تم تحديث المعاملة في أو قبل ":value"',
    'search_modifier_updated_at_after'                    => 'تم تحديث المعاملة في أو بعد ":value"',

    'search_modifier_attachment_name_is'            => 'اسم أي مرفق هو ":value"',
    'search_modifier_attachment_name_contains'      => 'اسم أي مرفق يحتوي على ":value"',
    'search_modifier_attachment_name_starts'        => 'اسم أي مرفق يبدأ بـ ":value"',
    'search_modifier_attachment_name_ends'          => 'اسم أي مرفق ينتهي بـ ":value"',
    'search_modifier_attachment_notes_are'          => 'ملاحظات أي مرفق هي ":value"',
    'search_modifier_attachment_notes_contains'     => 'ملاحظات أي مرفق تحتوي على ":value"',
    'search_modifier_attachment_notes_starts'       => 'ملاحظات أي مرفق تبدأ بـ ":value"',
    'search_modifier_attachment_notes_ends'         => 'ملاحظات أي مرفق تنتهي بـ ":value"',
    'search_modifier_not_attachment_name_is'        => 'اسم أي مرفق ليس ":value"',
    'search_modifier_not_attachment_name_contains'  => 'اسم أي مرفق لا يحتوي على ":value"',
    'search_modifier_not_attachment_name_starts'    => 'اسم أي مرفق لا يبدأ بـ ":value"',
    'search_modifier_not_attachment_name_ends'      => 'اسم أي مرفق لا ينتهي بـ ":value"',
    'search_modifier_not_attachment_notes_are'      => 'ملاحظات أي مرفق ليست ":value"',
    'search_modifier_not_attachment_notes_contains' => 'ملاحظات أي مرفق لا تحتوي على ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'ملاحظات أي مرفق لا تبدأ بـ ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'ملاحظات أي مرفق لا تنتهي بـ ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT هو ":value"',
    'update_rule_from_query'                        => 'تحديث القاعدة ":rule" من استعلام البحث',
    'create_rule_from_query'                        => 'إنشاء قاعدة جديدة من استعلام البحث',
    'rule_from_search_words'                        => 'واجه محرك القواعد صعوبة في معالجة ":string". قد تعطي القاعدة المقترحة التي تناسب استعلام البحث نتائج مختلفة. يرجى التحقق من المشغلات بعناية.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'رصيد حساب الوجهة يساوي تماماً ":value"',
    'search_modifier_not_destination_balance_is'    => 'رصيد حساب الوجهة لا يساوي تماماً ":value"',
    'search_modifier_source_balance_is'             => 'رصيد حساب المصدر يساوي تماماً ":value"',
    'search_modifier_not_source_balance_is'         => 'رصيد حساب المصدر لا يساوي تماماً ":value"',

    'search_modifier_destination_balance_lte'     => 'رصيد حساب الوجهة أقل من أو يساوي ":value"',
    'search_modifier_not_destination_balance_lte' => 'رصيد حساب الوجهة أكبر من ":value"',
    'search_modifier_source_balance_lte'          => 'رصيد حساب المصدر أقل من أو يساوي ":value"',
    'search_modifier_not_source_balance_lte'      => 'رصيد حساب المصدر أكبر من ":value"',

    'search_modifier_destination_balance_lt'     => 'رصيد حساب الوجهة أقل من ":value"',
    'search_modifier_not_destination_balance_lt' => 'رصيد حساب الوجهة أكبر من أو يساوي ":value"',
    'search_modifier_source_balance_lt'          => 'رصيد حساب المصدر أقل من ":value"',
    'search_modifier_not_source_balance_lt'      => 'رصيد حساب المصدر أكبر من أو يساوي ":value"',

    'search_modifier_destination_balance_gte'     => 'رصيد حساب الوجهة أكبر من أو يساوي ":value"',
    'search_modifier_not_destination_balance_gte' => 'رصيد حساب الوجهة أقل من ":value"',
    'search_modifier_source_balance_gte'          => 'رصيد حساب المصدر أكبر من أو يساوي ":value"',
    'search_modifier_not_source_balance_gte'      => 'رصيد حساب المصدر أقل من ":value"',

    'search_modifier_destination_balance_gt'              => 'رصيد حساب الوجهة أكبر من ":value"',
    'search_modifier_not_destination_balance_gt'          => 'رصيد حساب الوجهة أقل من أو يساوي ":value"',
    'search_modifier_source_balance_gt'                   => 'رصيد حساب المصدر أكبر من ":value"',
    'search_modifier_not_source_balance_gt'               => 'رصيد حساب المصدر أقل من أو يساوي ":value"',


    // END
    'general_search_error'                                => 'حدث خطأ أثناء البحث. يرجى مراجعة ملفات السجل لمزيد من المعلومات.',
    'search_box'                                          => 'بحث',
    'search_box_intro'                                    => 'مرحبًا بك في وظيفة البحث في Firefly III. أدخل استعلام البحث في المربع. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">تأكد من مراجعة ملف المساعدة</a> لأن البحث متقدم جدًا.',
    'search_error'                                        => 'حدث خطأ أثناء البحث',
    'search_searching'                                    => 'جاري البحث ...',
    'search_results'                                      => 'نتائج البحث',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'سنوي',
    'repeat_freq_half-year'                               => 'كل نصف سنة',
    'repeat_freq_quarterly'                               => 'كل ربع سنة',
    'repeat_freq_monthly'                                 => 'شهري',
    'repeat_freq_weekly'                                  => 'أسبوعي',
    'repeat_freq_daily'                                   => 'يومي',
    'daily'                                               => 'يومي',
    'weekly'                                              => 'أسبوعي',
    'quarterly'                                           => 'ربع سنوي',
    'half-year'                                           => 'كل نصف سنة',
    'yearly'                                              => 'سنوي',

    // rules
    'is_not_rule_trigger'                                 => 'ليس',
    'cannot_fire_inactive_rules'                          => 'لا يمكنك تنفيذ القواعد غير النشطة.',
    'show_triggers'                                       => 'عرض المشغلات',
    'show_actions'                                        => 'عرض الإجراءات',
    'rules'                                               => 'القواعد',
    'rule_name'                                           => 'اسم القاعدة',
    'rule_triggers'                                       => 'تشغيل القاعدة عند',
    'rule_actions'                                        => 'ستقوم القاعدة بـ',
    'new_rule'                                            => 'قاعدة جديدة',
    'new_rule_group'                                      => 'مجموعة قواعد جديدة',
    'rule_priority_up'                                    => 'إعطاء القاعدة أولوية أعلى',
    'rule_priority_down'                                  => 'إعطاء القاعدة أولوية أقل',
    'make_new_rule_group'                                 => 'إنشاء مجموعة قواعد جديدة',
    'store_new_rule_group'                                => 'حفظ مجموعة القواعد الجديدة',
    'created_new_rule_group'                              => 'تم حفظ مجموعة القواعد الجديدة ":title"!',
    'updated_rule_group'                                  => 'تم تحديث مجموعة القواعد ":title" بنجاح.',
    'edit_rule_group'                                     => 'تعديل مجموعة القواعد ":title"',
    'duplicate_rule'                                      => 'نسخ القاعدة ":title"',
    'rule_copy_of'                                        => 'نسخة من ":title"',
    'duplicated_rule'                                     => 'تم نسخ القاعدة ":title" إلى ":newTitle"',
    'delete_rule_group'                                   => 'حذف مجموعة القواعد ":title"',
    'deleted_rule_group'                                  => 'تم حذف مجموعة القواعد ":title"',
    'update_rule_group'                                   => 'تحديث مجموعة القواعد',
    'no_rules_in_group'                                   => 'لا توجد قواعد في هذه المجموعة',
    'move_rule_group_up'                                  => 'نقل مجموعة القواعد للأعلى',
    'move_rule_group_down'                                => 'نقل مجموعة القواعد للأسفل',
    'save_rules_by_moving'                                => 'احفظ هذه القاعدة بنقلها إلى مجموعة قواعد أخرى:|احفظ هذه القواعد بنقلها إلى مجموعة قواعد أخرى:',
    'make_new_rule'                                       => 'إنشاء قاعدة جديدة في مجموعة القواعد ":title"',
    'make_new_rule_no_group'                              => 'إنشاء قاعدة جديدة',
    'instructions_rule_from_bill'                         => 'لمطابقة المعاملات مع اشتراكك الجديد ":name"، يمكن لـ Firefly III إنشاء قاعدة يتم التحقق منها تلقائيًا مع أي معاملة تقوم بتخزينها. يرجى التحقق من التفاصيل أدناه وحفظ القاعدة ليقوم Firefly III بمطابقة المعاملات تلقائيًا مع اشتراكك الجديد.',
    'instructions_rule_from_journal'                      => 'إنشاء قاعدة بناءً على إحدى معاملاتك. أكمل أو أرسل النموذج أدناه.',
    'rule_is_strict'                                      => 'قاعدة صارمة',
    'rule_is_not_strict'                                  => 'قاعدة غير صارمة',
    'rule_help_stop_processing'                           => 'عند تحديد هذا الخيار، لن يتم تنفيذ القواعد اللاحقة في هذه المجموعة إذا تم تنفيذ هذه القاعدة.',
    'rule_help_strict'                                    => 'في القواعد الصارمة يجب أن تتحقق جميع المشغلات لتنفيذ الإجراء(ات). في القواعد غير الصارمة، يكفي تحقق أي مشغل لتنفيذ الإجراء(ات).',
    'rule_help_active'                                    => 'القواعد غير النشطة لن تعمل أبدًا.',
    'stored_new_rule'                                     => 'تم حفظ قاعدة جديدة بعنوان ":title"',
    'deleted_rule'                                        => 'تم حذف القاعدة بعنوان ":title"',
    'store_new_rule'                                      => 'حفظ قاعدة جديدة',
    'updated_rule'                                        => 'تم تحديث القاعدة بعنوان ":title"',
    'default_rule_group_name'                             => 'القواعد الافتراضية',
    'default_rule_group_description'                      => 'جميع القواعد التي ليست في مجموعة معينة.',
    'trigger'                                             => 'مشغل',
    'trigger_value'                                       => 'القيمة المشغلة',
    'stop_processing_other_triggers'                      => 'إيقاف معالجة المشغلات الأخرى',
    'add_rule_trigger'                                    => 'إضافة مشغل جديد',
    'action'                                              => 'إجراء',
    'action_value'                                        => 'قيمة الإجراء',
    'stop_executing_other_actions'                        => 'إيقاف تنفيذ الإجراءات الأخرى',
    'add_rule_action'                                     => 'إضافة إجراء جديد',
    'edit_rule'                                           => 'تعديل القاعدة #:nr ":title"',
    'delete_rule'                                         => 'حذف القاعدة ":title"',
    'update_rule'                                         => 'تحديث القاعدة',
    'test_rule_triggers'                                  => 'عرض المعاملات المطابقة',
    'warning_no_matching_transactions'                    => 'لم يتم العثور على معاملات مطابقة.',
    'warning_no_valid_triggers'                           => 'لم يتم تقديم مشغلات صالحة.',
    'apply_rule_selection'                                => 'تطبيق القاعدة ":title" على مجموعة من معاملاتك',
    'apply_rule_selection_intro'                          => 'يتم عادةً تطبيق القواعد مثل ":title" فقط على المعاملات الجديدة أو المحدثة، ولكن يمكنك أن تطلب من Firefly III تشغيلها على مجموعة من معاملاتك الحالية. قد يكون هذا مفيدًا عندما تقوم بتحديث قاعدة وتحتاج إلى تطبيق التغييرات على جميع معاملاتك الأخرى.',
    'include_transactions_from_accounts'                  => 'تضمين المعاملات من هذه الحسابات',
    'include'                                             => 'تضمين؟',
    'applied_rule_selection'                              => '{0} لم يتم تغيير أي معاملة في اختيارك بواسطة القاعدة ":title".|[1] تم تغيير معاملة واحدة في اختيارك بواسطة القاعدة ":title".|[2,*] تم تغيير :count معاملة في اختيارك بواسطة القاعدة ":title".',
    'execute'                                             => 'تنفيذ',
    'apply_rule_group_selection'                          => 'تطبيق مجموعة القواعد ":title" على مجموعة من معاملاتك',
    'apply_rule_group_selection_intro'                    => 'عادةً ما يتم تطبيق مجموعات القواعد مثل ":title" فقط على المعاملات الجديدة أو المحدثة، ولكن يمكنك أن تطلب من Firefly III تشغيل جميع القواعد في هذه المجموعة على مجموعة من معاملاتك الحالية. قد يكون هذا مفيدًا عندما تقوم بتحديث مجموعة من القواعد وتحتاج إلى تطبيق التغييرات على جميع معاملاتك الأخرى.',
    'applied_rule_group_selection'                        => 'تم تطبيق مجموعة القواعد ":title" على اختيارك.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'عند إنشاء معاملة',
    'rule_trigger_update_journal'                         => 'عند تحديث معاملة',
    'rule_trigger_manual'                                 => 'فقط عند تفعيل المستخدم',
    'rule_trigger_user_action'                            => 'إجراء المستخدم هو ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'اسم حساب المصدر يبدأ بـ ..',
    'rule_trigger_source_account_starts'                  => 'اسم حساب المصدر يبدأ بـ ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'اسم حساب المصدر ينتهي بـ ..',
    'rule_trigger_source_account_ends'                    => 'اسم حساب المصدر ينتهي بـ ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'اسم حساب المصدر هو ..',
    'rule_trigger_source_account_is'                      => 'اسم حساب المصدر هو ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'اسم حساب المصدر يحتوي على ..',
    'rule_trigger_source_account_contains'                => 'اسم حساب المصدر يحتوي على ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'معرف أي من الحسابين هو ..',
    'rule_trigger_account_id'                             => 'معرف أي من الحسابين هو :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'معرف حساب المصدر هو ..',
    'rule_trigger_source_account_id'                      => 'معرف حساب المصدر هو :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'معرف حساب الوجهة هو ..',
    'rule_trigger_destination_account_id'                 => 'معرف حساب الوجهة هو :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'أي من الحسابين هو (نقد)',
    'rule_trigger_account_is_cash'                        => 'أي من الحسابين هو (نقد)',
    'rule_trigger_source_is_cash_choice'                  => 'حساب المصدر هو (نقد)',
    'rule_trigger_source_is_cash'                         => 'حساب المصدر هو (نقد)',
    'rule_trigger_destination_is_cash_choice'             => 'حساب الوجهة هو (نقد)',
    'rule_trigger_destination_is_cash'                    => 'حساب الوجهة هو (نقد)',
    'rule_trigger_source_account_nr_starts_choice'        => 'رقم حساب المصدر / IBAN يبدأ بـ ..',
    'rule_trigger_source_account_nr_starts'               => 'رقم حساب المصدر / IBAN يبدأ بـ ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'رقم حساب المصدر / IBAN ينتهي بـ ..',
    'rule_trigger_source_account_nr_ends'                 => 'رقم حساب المصدر / IBAN ينتهي بـ ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'رقم حساب المصدر / IBAN هو ..',
    'rule_trigger_source_account_nr_is'                   => 'رقم حساب المصدر / IBAN هو ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'رقم حساب المصدر / IBAN يحتوي على ..',
    'rule_trigger_source_account_nr_contains'             => 'رقم حساب المصدر / IBAN يحتوي على ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'اسم حساب الوجهة يبدأ بـ ..',
    'rule_trigger_destination_account_starts'             => 'اسم حساب الوجهة يبدأ بـ ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'اسم حساب الوجهة ينتهي بـ ..',
    'rule_trigger_destination_account_ends'               => 'اسم حساب الوجهة ينتهي بـ ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'اسم حساب الوجهة هو ..',
    'rule_trigger_destination_account_is'                 => 'اسم حساب الوجهة هو ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'اسم حساب الوجهة يحتوي على ..',
    'rule_trigger_destination_account_contains'           => 'اسم حساب الوجهة يحتوي على ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'رقم حساب الوجهة / IBAN يبدأ بـ ..',
    'rule_trigger_destination_account_nr_starts'          => 'رقم حساب الوجهة / IBAN يبدأ بـ ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'رقم حساب الوجهة / IBAN ينتهي بـ ..',
    'rule_trigger_destination_account_nr_ends'            => 'رقم حساب الوجهة / IBAN ينتهي بـ ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'رقم حساب الوجهة / IBAN هو ..',
    'rule_trigger_destination_account_nr_is'              => 'رقم حساب الوجهة / IBAN هو ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'رقم حساب الوجهة / IBAN يحتوي على ..',
    'rule_trigger_destination_account_nr_contains'        => 'رقم حساب الوجهة / IBAN يحتوي على ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'نوع المعاملة هو ..',
    'rule_trigger_transaction_type'                       => 'نوع المعاملة هو ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'الفئة هي ..',
    'rule_trigger_category_is'                            => 'الفئة هي ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'المبلغ أقل من أو يساوي ..',
    'rule_trigger_amount_less'                            => 'المبلغ أقل من أو يساوي :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'المبلغ هو ..',
    'rule_trigger_amount_is'                              => 'المبلغ هو :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'المبلغ أكبر من أو يساوي ..',
    'rule_trigger_amount_more'                            => 'المبلغ أكبر من أو يساوي :trigger_value',
    'rule_trigger_description_starts_choice'              => 'الوصف يبدأ بـ ..',
    'rule_trigger_description_starts'                     => 'الوصف يبدأ بـ ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'الوصف ينتهي بـ ..',
    'rule_trigger_description_ends'                       => 'الوصف ينتهي بـ ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'الوصف يحتوي على ..',
    'rule_trigger_description_contains'                   => 'الوصف يحتوي على ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'الوصف هو ..',
    'rule_trigger_description_is'                         => 'الوصف هو ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'تاريخ المعاملة هو ..',
    'rule_trigger_date_on'                                => 'تاريخ المعاملة هو ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'تاريخ المعاملة قبل ..',
    'rule_trigger_date_before'                            => 'تاريخ المعاملة قبل ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'تاريخ المعاملة بعد ..',
    'rule_trigger_date_after'                             => 'تاريخ المعاملة بعد ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'تمت المعاملة في ..',
    'rule_trigger_created_at_on'                          => 'تمت المعاملة في ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'تم تعديل المعاملة آخر مرة في ..',
    'rule_trigger_updated_at_on'                          => 'تم تعديل المعاملة آخر مرة في ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'الميزانية هي ..',
    'rule_trigger_budget_is'                              => 'الميزانية هي ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'أي وسم هو ..',
    'rule_trigger_tag_is'                                 => 'أي وسم هو ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'أي وسم يحتوي على ..',
    'rule_trigger_tag_contains'                           => 'أي وسم يحتوي على ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'أي وسم ينتهي بـ ..',
    'rule_trigger_tag_ends'                               => 'أي وسم ينتهي بـ ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'أي وسم يبدأ بـ ..',
    'rule_trigger_tag_starts'                             => 'أي وسم يبدأ بـ ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'عملة المعاملة هي ..',
    'rule_trigger_currency_is'                            => 'عملة المعاملة هي ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'العملة الأجنبية للمعاملة هي ..',
    'rule_trigger_foreign_currency_is'                    => 'العملة الأجنبية للمعاملة هي ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'لديها مرفقات',
    'rule_trigger_has_attachments'                        => 'لديها مرفق(ات)',
    'rule_trigger_has_no_category_choice'                 => 'لا تحتوي على فئة',
    'rule_trigger_has_no_category'                        => 'المعاملة لا تحتوي على فئة',
    'rule_trigger_has_any_category_choice'                => 'تحتوي على فئة (أي فئة)',
    'rule_trigger_has_any_category'                       => 'المعاملة تحتوي على فئة (أي فئة)',
    'rule_trigger_has_no_budget_choice'                   => 'لا تحتوي على ميزانية',
    'rule_trigger_has_no_budget'                          => 'المعاملة لا تحتوي على ميزانية',
    'rule_trigger_has_any_budget_choice'                  => 'تحتوي على ميزانية (أي ميزانية)',
    'rule_trigger_has_any_budget'                         => 'المعاملة تحتوي على ميزانية (أي ميزانية)',
    'rule_trigger_has_no_bill_choice'                     => 'لا تحتوي على اشتراك',
    'rule_trigger_has_no_bill'                            => 'المعاملة لا تحتوي على اشتراك',
    'rule_trigger_has_any_bill_choice'                    => 'تحتوي على اشتراك (أي اشتراك)',
    'rule_trigger_has_any_bill'                           => 'المعاملة تحتوي على اشتراك (أي اشتراك)',
    'rule_trigger_has_no_tag_choice'                      => 'لا تحتوي على وسوم',
    'rule_trigger_has_no_tag'                             => 'المعاملة لا تحتوي على وسوم',
    'rule_trigger_has_any_tag_choice'                     => 'تحتوي على وسم أو أكثر (أي وسوم)',
    'rule_trigger_has_any_tag'                            => 'المعاملة تحتوي على وسم أو أكثر (أي وسوم)',
    'rule_trigger_any_notes_choice'                       => 'تحتوي على ملاحظات',
    'rule_trigger_any_notes'                              => 'المعاملة تحتوي على ملاحظات',
    'rule_trigger_no_notes_choice'                        => 'لا تحتوي على ملاحظات',
    'rule_trigger_no_notes'                               => 'المعاملة لا تحتوي على ملاحظات',
    'rule_trigger_notes_is_choice'                        => 'الملاحظات هي ..',
    'rule_trigger_notes_is'                               => 'الملاحظات هي ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'الملاحظات تحتوي على ..',
    'rule_trigger_notes_contains'                         => 'الملاحظات تحتوي على ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'الملاحظات تبدأ بـ ..',
    'rule_trigger_notes_starts'                           => 'الملاحظات تبدأ بـ ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'الملاحظات تنتهي بـ ..',
    'rule_trigger_notes_ends'                             => 'الملاحظات تنتهي بـ ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'الاشتراك هو ..',
    'rule_trigger_bill_is'                                => 'الاشتراك هو ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'المعرف الخارجي هو ..',
    'rule_trigger_external_id_is'                         => 'المعرف الخارجي هو ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'المرجع الداخلي هو ..',
    'rule_trigger_internal_reference_is'                  => 'المرجع الداخلي هو ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'معرف دفتر اليومية هو ..',
    'rule_trigger_journal_id'                             => 'معرف دفتر اليومية هو ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'المعاملة لديها رابط خارجي (أي رابط)',
    'rule_trigger_any_external_url_choice'                => 'المعاملة لديها رابط خارجي (أي رابط)',
    'rule_trigger_any_external_id'                        => 'المعاملة لديها معرف خارجي (أي معرف)',
    'rule_trigger_any_external_id_choice'                 => 'المعاملة لديها معرف خارجي (أي معرف)',
    'rule_trigger_no_external_url_choice'                 => 'المعاملة ليس لديها رابط خارجي',
    'rule_trigger_no_external_url'                        => 'المعاملة ليس لديها رابط خارجي',
    'rule_trigger_no_external_id_choice'                  => 'المعاملة ليس لديها معرف خارجي',
    'rule_trigger_no_external_id'                         => 'المعاملة ليس لديها معرف خارجي',
    'rule_trigger_id_choice'                              => 'معرف المعاملة هو ..',
    'rule_trigger_id'                                     => 'معرف المعاملة هو ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT هو ..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT هو ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'إجراء المستخدم هو ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'لا يوجد وسم هو ..',
    'rule_trigger_tag_is_not'                             => 'لا يوجد وسم هو ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'أي من الحسابين يساوي تماماً ..',
    'rule_trigger_account_is'                             => 'أي من الحسابين يساوي تماماً ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'أي من الحسابين يحتوي على ..',
    'rule_trigger_account_contains'                       => 'أي من الحسابين يحتوي على ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'أي من الحسابين ينتهي بـ ..',
    'rule_trigger_account_ends'                           => 'أي من الحسابين ينتهي بـ ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'أي من الحسابين يبدأ بـ ..',
    'rule_trigger_account_starts'                         => 'أي من الحسابين يبدأ بـ ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'أي من أرقام الحسابات / IBAN هو ..',
    'rule_trigger_account_nr_is'                          => 'أي من أرقام الحسابات / IBAN هو ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'أي من أرقام الحسابات / IBAN يحتوي على ..',
    'rule_trigger_account_nr_contains'                    => 'أي من أرقام الحسابات / IBAN يحتوي على ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'أي من أرقام الحسابات / IBAN ينتهي بـ ..',
    'rule_trigger_account_nr_ends'                        => 'أي من أرقام الحسابات / IBAN ينتهي بـ ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'أي من أرقام الحسابات / IBAN يبدأ بـ ..',
    'rule_trigger_account_nr_starts'                      => 'أي من أرقام الحسابات / IBAN يبدأ بـ ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'الفئة تحتوي على ..',
    'rule_trigger_category_contains'                      => 'الفئة تحتوي على ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'الفئة تنتهي بـ ..',
    'rule_trigger_category_ends'                          => 'الفئة تنتهي بـ ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'الفئة تبدأ بـ ..',
    'rule_trigger_category_starts'                        => 'الفئة تبدأ بـ ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'الميزانية تحتوي على ..',
    'rule_trigger_budget_contains'                        => 'الميزانية تحتوي على ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'الميزانية تنتهي بـ ..',
    'rule_trigger_budget_ends'                            => 'الميزانية تنتهي بـ ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'الميزانية تبدأ بـ ..',
    'rule_trigger_budget_starts'                          => 'الميزانية تبدأ بـ ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'الاشتراك يحتوي على ..',
    'rule_trigger_bill_contains'                          => 'الاشتراك يحتوي على ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'الاشتراك ينتهي بـ ..',
    'rule_trigger_bill_ends'                              => 'الاشتراك ينتهي بـ ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'الاشتراك يبدأ بـ ..',
    'rule_trigger_bill_starts'                            => 'الاشتراك يبدأ بـ ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'المعرف الخارجي يحتوي على ..',
    'rule_trigger_external_id_contains'                   => 'المعرف الخارجي يحتوي على ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'المعرف الخارجي ينتهي بـ ..',
    'rule_trigger_external_id_ends'                       => 'المعرف الخارجي ينتهي بـ ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'المعرف الخارجي يبدأ بـ ..',
    'rule_trigger_external_id_starts'                     => 'المعرف الخارجي يبدأ بـ ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'المرجع الداخلي يحتوي على ..',
    'rule_trigger_internal_reference_contains'            => 'المرجع الداخلي يحتوي على ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'المرجع الداخلي ينتهي بـ ..',
    'rule_trigger_internal_reference_ends'                => 'المرجع الداخلي ينتهي بـ ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'المرجع الداخلي يبدأ بـ ..',
    'rule_trigger_internal_reference_starts'              => 'المرجع الداخلي يبدأ بـ ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'الرابط الخارجي هو ..',
    'rule_trigger_external_url_is'                        => 'الرابط الخارجي هو ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'الرابط الخارجي يحتوي على ..',
    'rule_trigger_external_url_contains'                  => 'الرابط الخارجي يحتوي على ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'الرابط الخارجي ينتهي بـ ..',
    'rule_trigger_external_url_ends'                      => 'الرابط الخارجي ينتهي بـ ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'الرابط الخارجي يبدأ بـ ..',
    'rule_trigger_external_url_starts'                    => 'الرابط الخارجي يبدأ بـ ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'لا يوجد مرفقات',
    'rule_trigger_has_no_attachments'                     => 'المعاملة ليس لديها مرفقات',
    'rule_trigger_recurrence_id_choice'                   => 'معرف المعاملة المتكررة هو ..',
    'rule_trigger_recurrence_id'                          => 'معرف المعاملة المتكررة هو ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'تاريخ الفائدة هو ..',
    'rule_trigger_interest_date_on'                       => 'تاريخ الفائدة هو ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'تاريخ الفائدة قبل ..',
    'rule_trigger_interest_date_before'                   => 'تاريخ الفائدة قبل ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'تاريخ الفائدة بعد ..',
    'rule_trigger_interest_date_after'                    => 'تاريخ الفائدة بعد ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'تاريخ القيد هو ..',
    'rule_trigger_book_date_on'                           => 'تاريخ القيد هو ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'تاريخ القيد قبل ..',
    'rule_trigger_book_date_before'                       => 'تاريخ القيد قبل ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'تاريخ القيد بعد ..',
    'rule_trigger_book_date_after'                        => 'تاريخ القيد بعد ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'تاريخ المعالجة هو ..',
    'rule_trigger_process_date_on'                        => 'تاريخ المعالجة هو ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'تاريخ المعالجة قبل ..',
    'rule_trigger_process_date_before'                    => 'تاريخ المعالجة قبل ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'تاريخ المعالجة بعد ..',
    'rule_trigger_process_date_after'                     => 'تاريخ المعالجة بعد ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'تاريخ الاستحقاق هو ..',
    'rule_trigger_due_date_on'                            => 'تاريخ الاستحقاق هو ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'تاريخ الاستحقاق قبل ..',
    'rule_trigger_due_date_before'                        => 'تاريخ الاستحقاق قبل ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'تاريخ الاستحقاق بعد ..',
    'rule_trigger_due_date_after'                         => 'تاريخ الاستحقاق بعد ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'تاريخ الدفع هو ..',
    'rule_trigger_payment_date_on'                        => 'تاريخ الدفع هو ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'تاريخ الدفع قبل ..',
    'rule_trigger_payment_date_before'                    => 'تاريخ الدفع قبل ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'تاريخ الدفع بعد ..',
    'rule_trigger_payment_date_after'                     => 'تاريخ الدفع بعد ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'تاريخ الفاتورة هو ..',
    'rule_trigger_invoice_date_on'                        => 'تاريخ الفاتورة هو ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'تاريخ الفاتورة قبل ..',
    'rule_trigger_invoice_date_before'                    => 'تاريخ الفاتورة قبل ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'تاريخ الفاتورة بعد ..',
    'rule_trigger_invoice_date_after'                     => 'تاريخ الفاتورة بعد ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'تم إنشاء المعاملة قبل ..',
    'rule_trigger_created_at_before'                      => 'تم إنشاء المعاملة قبل ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'تم إنشاء المعاملة بعد ..',
    'rule_trigger_created_at_after'                       => 'تم إنشاء المعاملة بعد ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'تم تحديث المعاملة آخر مرة قبل ..',
    'rule_trigger_updated_at_before'                      => 'تم تحديث المعاملة آخر مرة قبل ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'تم تحديث المعاملة آخر مرة بعد ..',
    'rule_trigger_updated_at_after'                       => 'تم تحديث المعاملة آخر مرة بعد ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'المبلغ الأجنبي يساوي تماماً ..',
    'rule_trigger_foreign_amount_is'                      => 'المبلغ الأجنبي يساوي تماماً ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'المبلغ الأجنبي أقل من ..',
    'rule_trigger_foreign_amount_less'                    => 'المبلغ الأجنبي أقل من ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'المبلغ الأجنبي أكثر من ..',
    'rule_trigger_foreign_amount_more'                    => 'المبلغ الأجنبي أكثر من ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'اسم أي مرفق هو ..',
    'rule_trigger_attachment_name_is'                     => 'اسم أي مرفق هو ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'اسم أي مرفق يحتوي على ..',
    'rule_trigger_attachment_name_contains'               => 'اسم أي مرفق يحتوي على ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'اسم أي مرفق يبدأ بـ ..',
    'rule_trigger_attachment_name_starts'                 => 'اسم أي مرفق يبدأ بـ ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'اسم أي مرفق ينتهي بـ ..',
    'rule_trigger_attachment_name_ends'                   => 'اسم أي مرفق ينتهي بـ ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'ملاحظات أي مرفق هي ..',
    'rule_trigger_attachment_notes_are'                   => 'ملاحظات أي مرفق هي ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'ملاحظات أي مرفق تحتوي على ..',
    'rule_trigger_attachment_notes_contains'              => 'ملاحظات أي مرفق تحتوي على ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'ملاحظات أي مرفق تبدأ بـ ..',
    'rule_trigger_attachment_notes_starts'                => 'ملاحظات أي مرفق تبدأ بـ ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'ملاحظات أي مرفق تنتهي بـ ..',
    'rule_trigger_attachment_notes_ends'                  => 'ملاحظات أي مرفق تنتهي بـ ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'المعاملة تمت تسويتها',
    'rule_trigger_reconciled'                             => 'المعاملة تمت تسويتها',
    'rule_trigger_exists_choice'                          => 'توجد معاملة مطابقة(!)',
    'rule_trigger_exists'                                 => 'توجد معاملة مطابقة',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'معرف الحساب ليس ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'معرّف حساب المصدر ليس ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'معرف حساب الوجهة ليس :trigger_value',
    'rule_trigger_not_transaction_type'                   => 'نوع المعاملة ليس ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'الوسم ليس ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'الوسم هو ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'الوصف ليس ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'الوصف لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'الوصف لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'الملاحظات ليست ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'الملاحظات لا تحتوي على ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'الملاحظات لا تنتهي بـ ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'الملاحظات لا تبدأ بـ ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'الحساب المصدر ليس ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'الحساب المصدر لا يحتوي على ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'الحساب المصدر لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'حساب المصدر لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'رقم حساب المصدر / IBAN ليس ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'رقم حساب المصدر / IBAN لا يحتوي على ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'رقم حساب المصدر / IBAN لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'رقم حساب المصدر / IBAN لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'حساب الوجهة ليس ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'حساب الوجهة لا يحتوي على ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'حساب الوجهة لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'حساب الوجهة لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'رقم حساب الوجهة / IBAN ليس ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'رقم حساب الوجهة / IBAN لا يحتوي على ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'رقم حساب الوجهة / IBAN لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'رقم حساب الوجهة / IBAN لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'أي الحسابين ليس ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'أي الحسابين لا يحتوي على ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'أي الحسابين لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'أي الحسابين لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'أي من أرقام الحسابات / IBAN هو ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'أي من أرقام الحسابات / IBAN يحتوي على ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'أي من أرقام الحسابات / IBAN ينتهي بـ ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'أي من أرقام الحسابات / IBAN يبدأ بـ ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'الفئة ليست ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'الفئة لا تحتوي على ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'الفئة لا تنتهي بـ ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'الفئة لا تبدأ بـ ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'الميزانية ليست ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'الميزانية لا تحتوي على ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'الميزانية لا تنتهي بـ ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'الميزانية لا تبدأ بـ ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'الاشتراك ليس ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'الاشتراك لا يحتوي على ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'الاشتراك لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'الاشتراك لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'المعرف الخارجي ليس ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'المعرف الخارجي لا يحتوي على ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'المعرف الخارجي لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'المعرف الخارجي لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'المرجع الداخلي ليس ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'المرجع الداخلي لا يحتوي على ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'المرجع الداخلي لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'المرجع الداخلي لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'الرابط الخارجي ليس ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'الرابط الخارجي لا يحتوي على ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'الرابط الخارجي لا ينتهي بـ ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'الرابط الخارجي لا يبدأ بـ ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'العملة ليست ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'العملة الأجنبية ليست ":trigger_value"',
    'rule_trigger_not_id'                                 => 'رقم تعريف المعاملة ليس ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'معرف دفتر المعاملة ليس ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'معرف التكرار ليس ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'التاريخ ليس في ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'التاريخ ليس قبل ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'التاريخ ليس بعد ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'تاريخ الفائدة ليس في ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'تاريخ الفائدة ليس قبل ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'تاريخ الفائدة ليس بعد ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'تاريخ الكتاب ليس في ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'تاريخ الكتاب ليس قبل ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'تاريخ الكتاب ليس بعد ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'تاريخ العملية ليس في ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'تاريخ العملية ليس قبل ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'تاريخ المعالجة ليس بعد ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'تاريخ الاستحقاق ليس في ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'تاريخ الاستحقاق ليس قبل ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'تاريخ الاستحقاق ليس بعد ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'تاريخ الدفع ليس في ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'تاريخ الدفع ليس قبل ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'تاريخ الدفع ليس بعد ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'تاريخ الفاتورة ليس في ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'تاريخ الفاتورة ليس قبل ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'تاريخ الفاتورة ليس بعد ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'المعاملة لم تُنشأ في ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'المعاملة لم تُنشأ قبل ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'المعاملة لم تُنشأ بعد ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'المعاملة لم تُحدّث في ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'المعاملة لم تُحدّث قبل ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'المعاملة لم تُحدّث بعد ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'مبلغ المعاملة ليس ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'مبلغ المعاملة أكثر من ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'مبلغ المعاملة أقل من ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'المبلغ الأجنبي للمعاملة ليس ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'المبلغ الأجنبي للمعاملة أكثر من ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'المبلغ الأجنبي للمعاملة أقل من ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'لا يوجد مرفق اسمه ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'لا يوجد اسم مرفق يحتوي على ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'لا يوجد اسم مرفق يبدأ بـ ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'لا يوجد اسم مرفق ينتهي بـ ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'لا توجد ملاحظات مرفق هي ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'لا توجد ملاحظات مرفق تحتوي على ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'لا توجد ملاحظات مرفق تبدأ بـ ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'لا توجد ملاحظات مرفق تنتهي بـ ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'المعاملة لم تتم تسويتها',
    'rule_trigger_not_exists'                             => 'المعاملة غير موجودة',
    'rule_trigger_not_has_attachments'                    => 'المعاملة ليس لديها مرفقات',
    'rule_trigger_not_has_any_category'                   => 'المعاملة ليس لديها فئة',
    'rule_trigger_not_has_any_budget'                     => 'المعاملة ليس لديها ميزانية',
    'rule_trigger_not_has_any_bill'                       => 'المعاملة ليس لديها اشتراك',
    'rule_trigger_not_has_any_tag'                        => 'المعاملة ليس لديها وسوم',
    'rule_trigger_not_any_notes'                          => 'المعاملة ليس لديها ملاحظات',
    'rule_trigger_not_any_external_url'                   => 'المعاملة ليس لديها رابط خارجي',
    'rule_trigger_not_has_no_attachments'                 => 'المعاملة لديها مرفق (أو أكثر)',
    'rule_trigger_not_has_no_category'                    => 'المعاملة لديها فئة (أو أكثر)',
    'rule_trigger_not_has_no_budget'                      => 'المعاملة لديها ميزانية (أو أكثر)',
    'rule_trigger_not_has_no_bill'                        => 'المعاملة لديها اشتراك (أو أكثر)',
    'rule_trigger_not_has_no_tag'                         => 'المعاملة لديها وسم (أو أكثر)',
    'rule_trigger_not_no_notes'                           => 'المعاملة لديها ملاحظات',
    'rule_trigger_not_no_external_url'                    => 'المعاملة لديها رابط خارجي',
    'rule_trigger_not_source_is_cash'                     => 'حساب المصدر ليس نقدياً',
    'rule_trigger_not_destination_is_cash'                => 'حساب الوجهة ليس نقدياً',
    'rule_trigger_not_account_is_cash'                    => 'لا يوجد أي من الحسابين نقدياً',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'رصيد حساب الوجهة أكثر من ..',
    'rule_trigger_destination_balance_gte_choice'         => 'رصيد حساب الوجهة أكثر من أو يساوي ..',
    'rule_trigger_destination_balance_is_choice'          => 'رصيد حساب الوجهة يساوي تماماً ..',
    'rule_trigger_destination_balance_lt_choice'          => 'رصيد حساب الوجهة أقل من ..',
    'rule_trigger_destination_balance_lte_choice'         => 'رصيد حساب الوجهة أقل من أو يساوي ..',

    'rule_trigger_source_balance_gt_choice'  => 'رصيد حساب المصدر أكثر من ..',
    'rule_trigger_source_balance_gte_choice' => 'رصيد حساب المصدر أكثر من أو يساوي ..',
    'rule_trigger_source_balance_is_choice'  => 'رصيد حساب المصدر يساوي تماماً ..',
    'rule_trigger_source_balance_lt_choice'  => 'رصيد حساب المصدر أقل من ..',
    'rule_trigger_source_balance_lte_choice' => 'رصيد حساب المصدر أقل من أو يساوي ..',

    'rule_trigger_destination_balance_gt'  => 'رصيد حساب الوجهة أكثر من :trigger_value',
    'rule_trigger_destination_balance_gte' => 'رصيد حساب الوجهة أكثر من أو يساوي :trigger_value',
    'rule_trigger_destination_balance_is'  => 'رصيد حساب الوجهة يساوي تماماً :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'رصيد حساب الوجهة أقل من :trigger_value',
    'rule_trigger_destination_balance_lte' => 'رصيد حساب الوجهة أقل من أو يساوي :trigger_value',

    'rule_trigger_source_balance_gt'           => 'رصيد حساب المصدر أكثر من :trigger_value',
    'rule_trigger_source_balance_gte'          => 'رصيد حساب المصدر أكثر من أو يساوي :trigger_value',
    'rule_trigger_source_balance_is'           => 'رصيد حساب المصدر يساوي تماماً :trigger_value',
    'rule_trigger_source_balance_lt'           => 'رصيد حساب المصدر أقل من :trigger_value',
    'rule_trigger_source_balance_lte'          => 'رصيد حساب المصدر أقل من أو يساوي :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'رصيد حساب الوجهة أقل من أو يساوي :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'رصيد حساب الوجهة أقل من :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'رصيد حساب الوجهة ليس :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'رصيد حساب الوجهة أكثر من أو يساوي :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'رصيد حساب الوجهة أكثر من :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'رصيد حساب المصدر أقل من أو يساوي :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'رصيد حساب المصدر أقل من :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'رصيد حساب المصدر ليس :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'رصيد حساب المصدر أكثر من أو يساوي :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'رصيد حساب المصدر أكثر من :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'حذف المعاملة(!)',
    'rule_action_delete_transaction'             => 'حذف المعاملة(!)',
    'rule_action_set_category'                   => 'تعيين الفئة إلى ":action_value"',
    'rule_action_clear_category'                 => 'مسح الفئة',
    'rule_action_set_budget'                     => 'تعيين الميزانية إلى ":action_value"',
    'rule_action_clear_budget'                   => 'مسح الميزانية',
    'rule_action_add_tag'                        => 'إضافة الوسم ":action_value"',
    'rule_action_remove_tag'                     => 'إزالة الوسم ":action_value"',
    'rule_action_remove_all_tags'                => 'إزالة جميع الوسوم',
    'rule_action_set_description'                => 'تعيين الوصف إلى ":action_value"',
    'rule_action_append_description'             => 'إلحاق الوصف بـ ":action_value"',
    'rule_action_prepend_description'            => 'إضافة الوصف في البداية بـ ":action_value"',
    'rule_action_set_category_choice'            => 'تعيين الفئة إلى ..',
    'rule_action_clear_category_choice'          => 'مسح أي فئة',
    'rule_action_set_budget_choice'              => 'تعيين الميزانية إلى ..',
    'rule_action_clear_budget_choice'            => 'مسح أي ميزانية',
    'rule_action_add_tag_choice'                 => 'إضافة وسم ..',
    'rule_action_remove_tag_choice'              => 'إزالة وسم ..',
    'rule_action_remove_all_tags_choice'         => 'إزالة جميع الوسوم',
    'rule_action_set_description_choice'         => 'تعيين الوصف إلى ..',
    'rule_action_update_piggy_choice'            => 'إضافة / إزالة مبلغ المعاملة في حصالة ..',
    'rule_action_update_piggy'                   => 'إضافة / إزالة مبلغ المعاملة في الحصالة ":action_value"',
    'rule_action_append_description_choice'      => 'إلحاق الوصف بـ ..',
    'rule_action_prepend_description_choice'     => 'إضافة الوصف في البداية بـ ..',
    'rule_action_set_source_account_choice'      => 'تعيين حساب المصدر إلى ..',
    'rule_action_set_source_account'             => 'تعيين حساب المصدر إلى :action_value',
    'rule_action_set_destination_account_choice' => 'تعيين حساب الوجهة إلى ..',
    'rule_action_set_destination_account'        => 'تعيين حساب الوجهة إلى :action_value',
    'rule_action_append_notes_choice'            => 'إلحاق الملاحظات بـ ..',
    'rule_action_append_notes'                   => 'إلحاق الملاحظات بـ ":action_value"',
    'rule_action_prepend_notes_choice'           => 'إضافة الملاحظات في البداية بـ ..',
    'rule_action_prepend_notes'                  => 'إضافة الملاحظات في البداية بـ ":action_value"',
    'rule_action_clear_notes_choice'             => 'إزالة أي ملاحظات',
    'rule_action_clear_notes'                    => 'إزالة أي ملاحظات',
    'rule_action_set_notes_choice'               => 'تعيين الملاحظات إلى ..',
    'rule_action_link_to_bill_choice'            => 'ربط باشتراك ..',
    'rule_action_link_to_bill'                   => 'ربط بالاشتراك ":action_value"',
    'rule_action_switch_accounts_choice'         => 'تبديل حسابات المصدر والوجهة (للتحويلات فقط!)',
    'rule_action_switch_accounts'                => 'تبديل المصدر والوجهة',
    'rule_action_set_notes'                      => 'تعيين الملاحظات إلى ":action_value"',
    'rule_action_convert_deposit_choice'         => 'تحويل المعاملة إلى إيداع',
    'rule_action_convert_deposit'                => 'تحويل المعاملة إلى إيداع من ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'تحويل المعاملة إلى سحب',
    'rule_action_convert_withdrawal'             => 'تحويل المعاملة إلى سحب إلى ":action_value"',
    'rule_action_convert_transfer_choice'        => 'تحويل المعاملة إلى تحويل',
    'rule_action_convert_transfer'               => 'تحويل المعاملة إلى تحويل مع ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'إلحاق الوصف بملاحظات المعاملة',
    'rule_action_append_notes_to_descr_choice'   => 'إلحاق ملاحظات المعاملة بالوصف',
    'rule_action_move_descr_to_notes_choice'     => 'استبدال ملاحظات المعاملة الحالية بالوصف',
    'rule_action_move_notes_to_descr_choice'     => 'استبدال الوصف الحالي بملاحظات المعاملة',
    'rule_action_append_descr_to_notes'          => 'إلحاق الوصف بالملاحظات',
    'rule_action_append_notes_to_descr'          => 'إلحاق الملاحظات بالوصف',
    'rule_action_move_descr_to_notes'            => 'استبدال الملاحظات بالوصف',
    'rule_action_move_notes_to_descr'            => 'استبدال الوصف بالملاحظات',
    'rule_action_set_amount_choice'              => 'تعيين المبلغ إلى ..',
    'rule_action_set_amount'                     => 'تعيين المبلغ إلى ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'تعيين حساب الوجهة إلى (نقد)',
    'rule_action_set_source_to_cash_choice'      => 'تعيين حساب المصدر إلى (نقد)',
    'rulegroup_for_bills_title'                  => 'مجموعة قواعد للاشتراكات',
    'rulegroup_for_bills_description'            => 'مجموعة قواعد خاصة بجميع القواعد التي تتعلق بالاشتراكات.',
    'rule_for_bill_title'                        => 'قاعدة تم إنشاؤها تلقائياً للاشتراك ":name"',
    'rule_for_bill_description'                  => 'تم إنشاء هذه القاعدة تلقائياً لمحاولة مطابقة الاشتراك ":name".',
    'create_rule_for_bill'                       => 'إنشاء قاعدة جديدة للاشتراك ":name"',
    'create_rule_for_bill_txt'                   => 'لقد أنشأت للتو اشتراكاً جديداً باسم ":name"، تهانينا! يمكن لـ Firefly III مطابقة السحوبات الجديدة تلقائياً مع هذا الاشتراك. على سبيل المثال، كلما دفعت الإيجار، سيتم ربط الاشتراك "الإيجار" بالنفقة. بهذه الطريقة، يمكن لـ Firefly III أن يوضح لك بدقة الاشتراكات المستحقة وغير المستحقة. للقيام بذلك، يجب إنشاء قاعدة جديدة. قام Firefly III بملء بعض القيم الافتراضية المنطقية لك. يرجى التأكد من صحتها. إذا كانت هذه القيم صحيحة، سيربط Firefly III تلقائياً السحب الصحيح بالاشتراك الصحيح. يرجى مراجعة المشغلات للتأكد من صحتها، وأضف بعضها إذا كانت غير صحيحة.',
    'new_rule_for_bill_title'                    => 'قاعدة للاشتراك ":name"',
    'new_rule_for_bill_description'              => 'هذه القاعدة تميز المعاملات للاشتراك ":name".',

    'new_rule_for_journal_title'                => 'قاعدة بناءً على المعاملة ":description"',
    'new_rule_for_journal_description'          => 'هذه القاعدة مبنية على المعاملة ":description". ستطابق المعاملات التي هي نفسها تماماً.',

    // tags
    'store_new_tag'                             => 'حفظ وسم جديد',
    'update_tag'                                => 'تحديث الوسم',
    'no_location_set'                           => 'لم يتم تعيين موقع.',
    'meta_data'                                 => 'بيانات وصفية',
    'location'                                  => 'الموقع',
    'location_first_split'                      => 'يمكن تعيين موقع هذه المعاملة في أول تقسيم لها.',
    'without_date'                              => 'بدون تاريخ',
    'result'                                    => 'النتيجة',
    'sums_apply_to_range'                       => 'جميع المجاميع تنطبق على النطاق المحدد',
    'mapbox_api_key'                            => 'لاستخدام الخريطة، احصل على مفتاح API من <a href="https://www.mapbox.com/">Mapbox</a>. افتح ملف <code>.env</code> وأدخل هذا الكود بعد <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'انقر بزر الفأرة الأيمن أو اضغط مطولاً لتعيين موقع الكائن.',
    'click_tap_location'                        => 'انقر أو اضغط على الخريطة لإضافة موقع',
    'clear_location'                            => 'مسح الموقع',
    'delete_all_selected_tags'                  => 'حذف جميع الوسوم المحددة',
    'select_tags_to_delete'                     => 'لا تنس تحديد بعض الوسوم.',
    'deleted_x_tags'                            => 'تم حذف وسم واحد|تم حذف :count وسوم.',
    'create_rule_from_transaction'              => 'إنشاء قاعدة بناءً على معاملة',
    'create_recurring_from_transaction'         => 'إنشاء معاملة متكررة بناءً على معاملة',

    // preferences
    'test_notifications_buttons'                => 'لاختبار إعداداتك، استخدم الأزرار أدناه. يرجى ملاحظة أن الأزرار لا تحتوي على حماية من الرسائل المزعجة.',
    'dark_mode_option_browser'                  => 'دع المتصفح يقرر',
    'dark_mode_option_light'                    => 'دائماً فاتح',
    'dark_mode_option_dark'                     => 'دائماً داكن',
    'equal_to_language'                         => '(مطابق للغة)',
    'dark_mode_preference'                      => 'الوضع الداكن',
    'dark_mode_preference_help'                 => 'أخبر Firefly III متى يستخدم الوضع الداكن.',
    'pref_home_screen_accounts'                 => 'حسابات الشاشة الرئيسية',
    'pref_home_screen_accounts_help'            => 'ما هي الحسابات التي يجب عرضها في الصفحة الرئيسية؟',
    'pref_view_range'                           => 'نطاق العرض',
    'pref_view_range_help'                      => 'يتم تجميع بعض المخططات تلقائياً في فترات. سيتم أيضاً تجميع ميزانياتك في فترات. ما هي الفترة التي تفضلها؟',
    'pref_1D'                                   => 'يوم واحد',
    'pref_1W'                                   => 'أسبوع واحد',
    'pref_1M'                                   => 'شهر واحد',
    'pref_3M'                                   => 'ثلاثة أشهر (ربع سنة)',
    'pref_6M'                                   => 'ستة أشهر',
    'pref_1Y'                                   => 'سنة واحدة',
    'pref_last365'                              => 'السنة الماضية',
    'pref_last90'                               => 'آخر 90 يوم',
    'pref_last30'                               => 'آخر 30 يوم',
    'pref_last7'                                => 'آخر 7 أيام',
    'pref_YTD'                                  => 'من بداية السنة حتى الآن',
    'pref_QTD'                                  => 'من بداية الربع حتى الآن',
    'pref_MTD'                                  => 'من بداية الشهر حتى الآن',
    'pref_languages'                            => 'اللغات',
    'pref_locale'                               => 'إعدادات اللغة المحلية',
    'pref_languages_help'                       => 'يدعم Firefly III عدة لغات. أي واحدة تفضل؟',
    'pref_locale_help'                          => 'يسمح لك Firefly III بتعيين إعدادات محلية أخرى، مثل كيفية تنسيق العملات والأرقام والتواريخ. قد لا تدعم بعض الأنظمة هذه الإعدادات. لا يحتوي Firefly III على إعدادات تواريخ صحيحة لكل لغة محلية؛ تواصل معي للتحسينات.',
    'pref_locale_no_demo'                       => 'هذه الميزة لن تعمل مع مستخدم العرض التوضيحي.',
    'pref_convert_to_primary'                   => 'عرض المبالغ بعملتك الأساسية',
    'pref_convert_to_primary_help'              => 'سيحاول Firefly III عرض عملتك الأساسية في أكبر عدد ممكن من الأماكن، مع تحويل المبالغ عند الحاجة. هذا يضحي بالدقة من أجل سهولة الاستخدام، لأن التحويل ليس دائماً دقيقاً. يرجى التأكد من أن Firefly III لديه أسعار الصرف اللازمة في صفحة "أسعار الصرف".',
    'pref_convert_primary_help'                 => 'عرض المبالغ الأساسية',
    'pref_custom_fiscal_year'                   => 'إعدادات السنة المالية',
    'pref_custom_fiscal_year_label'             => 'مفعل',
    'pref_custom_fiscal_year_help'              => 'في البلدان التي تستخدم سنة مالية غير من 1 يناير إلى 31 ديسمبر، يمكنك تفعيل هذا الخيار وتحديد أيام بداية/نهاية السنة المالية',
    'pref_fiscal_year_start_label'              => 'تاريخ بداية السنة المالية',
    'pref_two_factor_auth'                      => 'المصادقة متعددة العوامل',
    'pref_two_factor_auth_help'                 => 'عند تفعيل المصادقة متعددة العوامل (المعروفة أيضاً بالمصادقة الثنائية)، تضيف طبقة أمان إضافية لحسابك. تسجل الدخول بشيء تعرفه (كلمة المرور) وشيء تملكه (رمز تحقق). يتم إنشاء رموز التحقق بواسطة تطبيق على هاتفك مثل Authy أو Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'تفعيل المصادقة متعددة العوامل',
    'pref_two_factor_auth_disabled'             => 'تمت إزالة رمز التحقق للمصادقة متعددة العوامل وتعطيله',
    'pref_two_factor_auth_remove_it'            => 'لا تنس إزالة الحساب من تطبيق المصادقة الخاص بك!',
    'pref_two_factor_auth_code'                 => 'تحقق من الرمز',
    'pref_two_factor_auth_code_help'            => 'امسح رمز QR باستخدام تطبيق على هاتفك مثل Authy أو Google Authenticator وأدخل الرمز الذي تم إنشاؤه. يتغير رمز QR في كل مرة تزور فيها هذه الصفحة. تأكد من استخدام أحدث رمز.',
    'pref_two_factor_auth_reset_code'           => 'إعادة تعيين رمز التحقق',
    'pref_two_factor_auth_disable_2fa'          => 'تعطيل المصادقة متعددة العوامل',
    '2fa_use_secret_instead'                    => 'إذا لم تتمكن من مسح رمز QR، يمكنك استخدام الرمز السري بدلاً من ذلك: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'احفظ هذه الرموز الاحتياطية للوصول في حال فقدت جهازك.',
    '2fa_already_enabled'                       => 'تم تفعيل التحقق للمصادقة متعددة العوامل بالفعل.',
    'wrong_mfa_code'                            => 'رمز المصادقة هذا غير صالح.',
    'pref_save_settings'                        => 'حفظ الإعدادات',
    'saved_preferences'                         => 'تم حفظ التفضيلات!',
    'preferences_general'                       => 'عام',
    'preferences_frontpage'                     => 'الشاشة الرئيسية',
    'preferences_security'                      => 'الأمان',
    'preferences_layout'                        => 'التخطيط',
    'preferences_notifications'                 => 'الإشعارات',
    'pref_home_show_deposits'                   => 'عرض الإيرادات في الشاشة الرئيسية',
    'pref_home_show_deposits_info'              => 'تعرض الشاشة الرئيسية بالفعل حسابات النفقات. هل يجب أن تعرض أيضاً حسابات الإيرادات؟',
    'pref_home_do_show_deposits'                => 'نعم، اعرضها',
    'successful_count'                          => 'منها :count ناجحة',
    'list_page_size_title'                      => 'حجم الصفحة',
    'list_page_size_help'                       => 'أي قائمة (حسابات، معاملات، إلخ) تعرض بحد أقصى هذا العدد في الصفحة.',
    'list_page_size_label'                      => 'حجم الصفحة',
    'between_dates'                             => '(:start و :end)',
    'pref_optional_fields_transaction'          => 'حقول اختيارية للمعاملات',
    'pref_optional_fields_transaction_help'     => 'بشكل افتراضي، لا يتم تفعيل جميع الحقول عند إنشاء معاملة جديدة (لتقليل الفوضى). أدناه، يمكنك تفعيل هذه الحقول إذا كنت تعتقد أنها قد تكون مفيدة لك. بالطبع، أي حقل تم تعطيله ولكنه مملوء بالفعل سيظهر بغض النظر عن الإعداد.',
    'optional_tj_date_fields'                   => 'حقول التاريخ',
    'optional_tj_other_fields'                  => 'حقول أخرى',
    'optional_tj_attachment_fields'             => 'حقول المرفقات',
    'pref_optional_tj_interest_date'            => 'تاريخ الفائدة',
    'pref_optional_tj_book_date'                => 'تاريخ القيد',
    'pref_optional_tj_process_date'             => 'تاريخ المعالجة',
    'pref_optional_tj_due_date'                 => 'تاريخ الاستحقاق',
    'pref_optional_tj_payment_date'             => 'تاريخ الدفع',
    'pref_optional_tj_invoice_date'             => 'تاريخ الفاتورة',
    'pref_optional_tj_internal_reference'       => 'مرجع داخلي',
    'pref_optional_tj_notes'                    => 'ملاحظات',
    'pref_optional_tj_attachments'              => 'المرفقات',
    'pref_optional_tj_external_url'             => 'رابط خارجي',
    'pref_optional_tj_location'                 => 'الموقع',
    'pref_optional_tj_links'                    => 'روابط المعاملة',
    'optional_field_meta_dates'                 => 'تواريخ',
    'optional_field_meta_business'              => 'الأعمال',
    'optional_field_attachments'                => 'المرفقات',
    'optional_field_meta_data'                  => 'بيانات وصفية اختيارية',
    'external_url'                              => 'رابط خارجي',
    'pref_notification_login_failure'           => 'فشل تسجيل الدخول',
    'pref_notification_bill_reminder'           => 'تذكير باشتراكات أوشكت على الانتهاء',
    'pref_notification_new_access_token'        => 'تنبيه عند إنشاء رمز وصول جديد لواجهة برمجة التطبيقات',
    'pref_notification_transaction_creation'    => 'تنبيه عند إنشاء معاملة تلقائياً',
    'pref_notification_user_login'              => 'تنبيه عند تسجيل الدخول من موقع جديد',
    'pref_notification_rule_action_failures'    => 'تنبيه عند فشل تنفيذ إجراءات القواعد (ليس عبر البريد الإلكتروني)',
    'pref_notification_new_password'            => 'تم تغيير كلمة المرور الخاصة بك',
    'pref_notification_enabled_mfa'             => 'تم تفعيل المصادقة متعددة العوامل',
    'pref_notification_disabled_mfa'            => 'تم تعطيل المصادقة متعددة العوامل',
    'pref_notification_few_left_mfa'            => 'لم يتبق لديك سوى عدد قليل من رموز النسخ الاحتياطي',
    'pref_notification_no_left_mfa'             => 'لم يتبق لديك أي رموز نسخ احتياطي',
    'pref_notification_many_failed_mfa'         => 'فشلت عملية التحقق من المصادقة متعددة العوامل عدة مرات',
    'pref_notification_new_backup_codes'        => 'تم إنشاء رموز نسخ احتياطي جديدة',
    'pref_notifications'                        => 'الإشعارات',
    'pref_notifications_help'                   => 'حدد إذا كنت ترغب في تلقي هذه الإشعارات. قد تحتوي بعض الإشعارات على معلومات مالية حساسة.',
    'pref_notifications_settings'               => 'إعدادات الإشعارات',
    'pref_notifications_settings_help'          => 'استخدم هذه الإعدادات لتكوين قنوات الإشعارات الخاصة بك. يرجى ملاحظة أن الإشعارات ستُرسل إلى جميع القنوات. يرجى حفظ الإعدادات أولاً.',
    'slack_url_label'                           => 'رابط "webhook" الوارد لـ Slack',
    'discord_url_label'                         => 'رابط webhook لـ Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'أسعار الصرف',
    'header_exchange_rates'                     => 'أسعار الصرف',
    'exchange_rates_intro'                      => 'يدعم Firefly III تنزيل واستخدام أسعار الصرف. اقرأ المزيد عن ذلك في <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">الوثائق</a>.',
    'exchange_rates_from_to'                    => 'بين {from} و{to} (وبالعكس)',
    'header_exchange_rates_rates'               => 'أسعار الصرف',
    'exchange_rates_intro_rates'                => 'يستخدم Firefly III أسعار الصرف التالية. يتم حساب العكس تلقائياً إذا لم يتم توفيره. إذا لم يوجد سعر صرف لتاريخ المعاملة، سيعود Firefly III بالزمن للعثور على واحد. إذا لم يوجد أي سعر، سيتم استخدام السعر "1".',
    'header_exchange_rates_table'               => 'جدول أسعار الصرف',
    'help_rate_form'                            => 'في هذا اليوم، كم {to} ستحصل مقابل واحد {from}؟',
    'save_new_rate'                             => 'حفظ سعر جديد',
    'add_new_rate'                              => 'إضافة سعر صرف جديد',
    'not_enough_currencies'                     => 'عدد العملات غير كافٍ',
    'not_enough_currencies_enabled'             => 'إذا كان لديك عملة واحدة فقط مفعلة، فلا داعي لإضافة أسعار صرف.',

    // Financial administrations
    'administration_index'                      => 'الإدارة المالية',
    'administrations_breadcrumb'                => 'الإدارات المالية',
    'administrations_page_title'                => 'الإدارات المالية',
    'administrations_index_menu'                => 'الإدارات المالية',
    'administrations_page_sub_title'            => 'نظرة عامة',
    'create_administration'                     => 'إنشاء إدارة جديدة',
    'administration_owner'                      => 'مالك الإدارة: {{email}}',
    'administration_you'                        => 'دورك: {{role}}',
    'other_users_in_admin'                      => 'مستخدمون آخرون في هذه الإدارة',
    'administrations_create_breadcrumb'         => 'إنشاء إدارة مالية جديدة',
    'administrations_page_create_sub_title'     => 'إنشاء إدارة مالية جديدة',
    'basic_administration_information'          => 'معلومات أساسية عن الإدارة',
    'new_administration_created'                => 'تم إنشاء إدارة مالية جديدة "{{title}}"',
    'edit_administration_breadcrumb'            => 'تعديل الإدارة المالية ":title"',
    'administrations_page_edit_sub_title'       => 'تعديل الإدارة المالية ":title"',
    'administrations_page_edit_sub_title_js'    => 'تعديل الإدارة المالية "{title}"',
    'temp_administrations_introduction'         => 'سيحصل Firefly III قريباً على إمكانية إدارة عدة إدارات مالية. حالياً لديك واحدة فقط. يمكنك تعيين عنوان هذه الإدارة وعملتها الأساسية. هذا يستبدل الإعداد السابق حيث كنت تعين "العملة الافتراضية". هذا الإعداد أصبح الآن مرتبطاً بالإدارة المالية ويمكن أن يختلف لكل إدارة.',
    'temp_administrations_introduction_edit'    => 'حالياً، يمكنك فقط تعيين "العملة الأساسية" للإدارة المالية الافتراضية. هذا يستبدل إعداد "العملة الافتراضية". هذا الإعداد أصبح الآن مرتبطاً بالإدارة المالية ويمكن أن يختلف لكل إدارة.',
    'administration_currency_form_help'         => 'قد يستغرق تحميل الصفحة وقتاً طويلاً إذا قمت بتغيير العملة الأساسية لأن المعاملات قد تحتاج إلى التحويل إلى عملتك (الجديدة) الأساسية.',
    'flash_administration_updated'              => 'تم تحديث الإدارة ":title"',
    'flash_administration_created'              => 'تم إنشاء الإدارة ":title"',
    'flash_administration_deleted'              => 'تم حذف الإدارة ":title"',

    // roles
    'administration_role_owner'                 => 'مالك',
    'administration_role_ro'                    => 'قراءة فقط',
    'administration_role_mng_trx'               => 'إدارة المعاملات',
    'administration_role_mng_meta'              => 'إدارة التصنيف والبيانات الوصفية',
    'administration_role_mng_budgets'           => 'إدارة الميزانيات',
    'administration_role_mng_piggies'           => 'إدارة الحصالات',
    'administration_role_mng_subscriptions'     => 'إدارة الاشتراكات',
    'administration_role_mng_rules'             => 'إدارة القواعد',
    'administration_role_mng_recurring'         => 'إدارة المعاملات المتكررة',
    'administration_role_mng_webhooks'          => 'إدارة الويب هوكس',
    'administration_role_mng_currencies'        => 'إدارة العملات',
    'administration_role_view_reports'          => 'عرض التقارير',
    'administration_role_full'                  => 'صلاحية كاملة',

    // mfa
    'enable_mfa'                                => 'تفعيل المصادقة متعددة العوامل',
    'mfa_index_title'                           => 'المصادقة متعددة العوامل',
    'mfa_index_intro'                           => 'يدعم Firefly III المصادقة متعددة العوامل (MFA). يمكنك تفعيل MFA لحسابك لإضافة طبقة أمان إضافية. يمكن استخدام تطبيقات مثل Authy وGoogle Authenticator وFreeOTP لإنشاء الرموز التي تحتاجها لتسجيل الدخول. مفاتيح الأمان غير مدعومة من قبل Firefly III ولكن يمكنك استخدام مفتاح أمان كجهاز تخزين لسر MFA الخاص بك.',
    'mfa_index_enabled'                         => 'المصادقة متعددة العوامل مفعلة لحسابك.',
    'mfa_index_disabled'                        => 'المصادقة متعددة العوامل غير مفعلة لحسابك.',
    'mfa_index_owner'                           => 'مالك هذا المثيل سيكون دائماً قادراً على تعطيل المصادقة متعددة العوامل لحسابك.',
    'current_password_confirm_mfa'              => 'أدخل كلمة المرور الحالية',
    'mfa_warning_code_changes'                  => 'قد تحصل على مربع حوار MFA بعد إدخال كلمة المرور ورمز MFA. في هذه الحالة، يرجى انتظار تطبيقك لإنشاء رمز MFA جديد، ولا تعيد استخدام الذي استخدمته للتو.',
    'mfa_already_disabled'                      => 'المصادقة متعددة العوامل غير مفعلة، لذلك لا يمكنك تعطيلها.',
    'disable_mfa_page'                          => 'تعطيل المصادقة متعددة العوامل',
    'disable_mfa_intro'                         => 'يمكنك تعطيل المصادقة متعددة العوامل. للقيام بذلك، يرجى إدخال كلمة المرور ورمز المصادقة متعددة العوامل. إذا كنت ترغب في تعطيل المصادقة متعددة العوامل لأنك فقدت الوصول إلى مولد الرموز الخاص بك، <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">يرجى الرجوع إلى الوثائق بدلاً من ذلك</a>.',
    'pref_disable_mfa'                          => 'تعطيل المصادقة متعددة العوامل',
    'mfa_not_enabled'                           => 'المصادقة متعددة العوامل غير مفعلة.',
    'mfa_backup_codes_intro'                    => 'يمكن لـ Firefly III إنشاء رموز احتياطية لك. يمكن استخدام هذه الرموز لتسجيل الدخول عندما لا تتمكن من استخدام مولد الرموز الخاص بك. يمكنك إنشاء مجموعة جديدة من الرموز في أي وقت. إذا أنشأت مجموعة جديدة، فستصبح المجموعة القديمة غير صالحة.',
    'mfa_backup_codes_quick'                    => 'إذا كنت سريعاً جداً قادماً من صفحة إعداد المصادقة متعددة العوامل، فقد لا يكون تطبيقك قد أنشأ رمزاً جديداً بعد. يرجى العلم أن رموز MFA يمكن استخدامها مرة واحدة فقط. تأكد من استخدام رمز مختلف عن السابق.',
    'mfa_backup_codes_title'                    => 'رموز النسخ الاحتياطي للمصادقة متعددة العوامل',
    'mfa_backup_codes_post_title'               => 'رموز النسخ الاحتياطي للمصادقة متعددة العوامل',

    // profile:
    'manage_mfa_settings'                       => 'إدارة إعدادات المصادقة متعددة العوامل',
    'purge_data_title'                          => 'حذف البيانات من Firefly III نهائياً',
    'purge_data_expl'                           => '"التطهير" يعني "حذف ما تم حذفه بالفعل". في الظروف العادية، لا يحذف Firefly III أي شيء نهائياً. إنه يخفيه فقط. الزر أدناه يحذف جميع هذه السجلات "المحذوفة" سابقاً إلى الأبد.',
    'delete_stuff_header'                       => 'حذف وتطهير البيانات',
    'purge_all_data'                            => 'حذف جميع السجلات المحذوفة',
    'purge_data'                                => 'حذف البيانات',
    'purged_all_records'                        => 'تم حذف جميع السجلات المحذوفة.',
    'delete_data_title'                         => 'حذف البيانات من Firefly III',
    'permanent_delete_stuff'                    => 'يمكنك حذف العناصر من Firefly III. استخدام الأزرار أدناه يعني أن عناصرَك ستُزال من العرض وتُخفى. لا يوجد زر تراجع لهذا، لكن قد تبقى العناصر في قاعدة البيانات حيث يمكنك استعادتها إذا لزم الأمر.',
    'other_sessions_logged_out'                 => 'تم تسجيل الخروج من جميع الجلسات الأخرى الخاصة بك.',
    'delete_unused_accounts'                    => 'حذف الحسابات غير المستخدمة سينظف قوائم الإكمال التلقائي لديك.',
    'delete_all_unused_accounts'                => 'حذف الحسابات غير المستخدمة',
    'deleted_all_unused_accounts'               => 'تم حذف جميع الحسابات غير المستخدمة',
    'delete_all_budgets'                        => 'حذف جميع الميزانيات',
    'delete_all_categories'                     => 'حذف جميع الفئات',
    'delete_all_tags'                           => 'حذف جميع الوسوم',
    'delete_all_bills'                          => 'حذف جميع الاشتراكات',
    'delete_all_piggy_banks'                    => 'حذف جميع الحصالات',
    'delete_all_rules'                          => 'حذف جميع القواعد',
    'delete_all_recurring'                      => 'حذف جميع المعاملات المتكررة',
    'delete_all_object_groups'                  => 'حذف جميع مجموعات الكائنات',
    'delete_all_accounts'                       => 'حذف جميع الحسابات',
    'delete_all_asset_accounts'                 => 'حذف جميع حسابات الأصول',
    'delete_all_expense_accounts'               => 'حذف جميع حسابات المصروفات',
    'delete_all_revenue_accounts'               => 'حذف جميع حسابات الإيرادات',
    'delete_all_liabilities'                    => 'حذف جميع الخصوم',
    'delete_all_transactions'                   => 'حذف جميع المعاملات',
    'delete_all_withdrawals'                    => 'حذف جميع السحوبات',
    'delete_all_deposits'                       => 'حذف جميع الإيداعات',
    'delete_all_transfers'                      => 'حذف جميع التحويلات',
    'also_delete_transactions'                  => 'حذف الحسابات سيؤدي أيضاً إلى حذف جميع السحوبات والإيداعات والتحويلات المرتبطة بها!',
    'deleted_all_budgets'                       => 'تم حذف جميع الميزانيات',
    'deleted_all_categories'                    => 'تم حذف جميع الفئات',
    'deleted_all_tags'                          => 'تم حذف جميع الوسوم',
    'deleted_all_bills'                         => 'تم حذف جميع الاشتراكات',
    'deleted_all_piggy_banks'                   => 'تم حذف جميع الحصالات',
    'deleted_all_rules'                         => 'تم حذف جميع القواعد ومجموعات القواعد',
    'deleted_all_object_groups'                 => 'تم حذف جميع المجموعات',
    'deleted_all_accounts'                      => 'تم حذف جميع الحسابات',
    'deleted_all_asset_accounts'                => 'تم حذف جميع حسابات الأصول',
    'deleted_all_expense_accounts'              => 'تم حذف جميع حسابات المصروفات',
    'deleted_all_revenue_accounts'              => 'تم حذف جميع حسابات الإيرادات',
    'deleted_all_liabilities'                   => 'تم حذف جميع الخصوم',
    'deleted_all_transactions'                  => 'تم حذف جميع المعاملات',
    'deleted_all_withdrawals'                   => 'تم حذف جميع السحوبات',
    'deleted_all_deposits'                      => 'تم حذف جميع الإيداعات',
    'deleted_all_transfers'                     => 'تم حذف جميع التحويلات',
    'deleted_all_recurring'                     => 'تم حذف جميع المعاملات المتكررة',
    'change_your_password'                      => 'غيّر كلمة المرور',
    'delete_account'                            => 'حذف الحساب',
    'current_password'                          => 'كلمة المرور الحالية',
    'new_password'                              => 'كلمة المرور الجديدة',
    'new_password_again'                        => 'كلمة المرور الجديدة (مرة أخرى)',
    'delete_your_account'                       => 'احذف حسابك',
    'delete_your_account_help'                  => 'حذف حسابك سيؤدي أيضاً لحذف أي حسابات أو معاملات أو <em>أي شيء</em> قد تكون حفظته في Firefly III. سيختفي نهائياً.',
    'delete_your_account_password'              => 'أدخل كلمة المرور للمتابعة.',
    'password'                                  => 'كلمة المرور',
    'are_you_sure'                              => 'هل أنت متأكد؟ لا يمكنك التراجع عن هذا.',
    'are_you_sure_confirm'                      => 'هل أنت متأكد؟',
    'delete_account_button'                     => 'احذف حسابك',
    'invalid_current_password'                  => 'كلمة المرور الحالية غير صحيحة!',
    'password_changed'                          => 'تم تغيير كلمة المرور!',
    'should_change'                             => 'الهدف هو تغيير كلمة المرور.',
    'invalid_password'                          => 'كلمة المرور غير صحيحة!',
    'what_is_pw_security'                       => 'ما هو "التحقق من أمان كلمة المرور"؟',
    'secure_pw_title'                           => 'كيفية اختيار كلمة مرور آمنة',
    'forgot_password_response'                  => 'شكراً لك. إذا كان هناك حساب موجود بعنوان البريد الإلكتروني هذا، ستجد التعليمات في صندوق الوارد الخاص بك.',
    'secure_pw_history'                         => 'لا يمر أسبوع دون أن تقرأ في الأخبار عن موقع يفقد كلمات مرور مستخدميه. يستخدم المتسللون واللصوص هذه كلمات المرور لمحاولة سرقة معلوماتك الخاصة. هذه المعلومات قيمة.',
    'secure_pw_ff'                              => 'هل تستخدم نفس كلمة المرور في جميع أنحاء الإنترنت؟ إذا فقد موقع واحد كلمة مرورك، فإن المتسللين يصلون إلى جميع بياناتك. يعتمد Firefly III عليك لاختيار كلمة مرور قوية وفريدة لحماية سجلاتك المالية.',
    'secure_pw_check_box'                       => 'لمساعدتك في ذلك، يمكن لـ Firefly III التحقق مما إذا كانت كلمة المرور التي تريد استخدامها قد تم سرقتها في الماضي. إذا كان الأمر كذلك، ينصحك Firefly III بعدم استخدام تلك كلمة المرور.',
    'secure_pw_working_title'                   => 'كيف يعمل هذا؟',
    'secure_pw_working'                         => 'عند تحديد المربع، سيرسل Firefly III أول خمسة أحرف من تجزئة SHA1 لكلمة مرورك إلى <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">موقع Troy Hunt</a> للتحقق مما إذا كانت ضمن القائمة. هذا سيمنعك من استخدام كلمات مرور غير آمنة كما هو موصى به في <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">أحدث منشور خاص من NIST</a> حول هذا الموضوع.',
    'secure_pw_should'                          => 'هل يجب أن أتحقق من المربع؟',
    'secure_pw_long_password'                   => 'نعم. تحقق دائماً من أن كلمة مرورك آمنة.',
    'command_line_token'                        => 'رمز سطر الأوامر',
    'explain_command_line_token'                => 'تحتاج إلى هذا الرمز لتنفيذ أوامر سطر الأوامر مثل تصدير البيانات. بدون هذا الرمز، لن تعمل تلك الأوامر الحساسة. لا تشارك رمز سطر الأوامر الخاص بك. لن يطلبه منك أحد، حتى أنا. إذا كنت تخشى أنك فقدته أو كنت قلقاً، أعد إنشاء هذا الرمز باستخدام الزر.',
    'regenerate_command_line_token'             => 'إعادة إنشاء رمز سطر الأوامر',
    'token_regenerated'                         => 'تم إنشاء رمز سطر أوامر جديد',
    'change_your_email'                         => 'غيّر عنوان بريدك الإلكتروني',
    'email_verification'                        => 'سيتم إرسال رسالة بريد إلكتروني إلى عنوانك القديم والجديد. لأسباب أمنية، لن تتمكن من تسجيل الدخول حتى تؤكد عنوان بريدك الإلكتروني الجديد. إذا لم تكن متأكداً من أن تثبيت Firefly III لديك قادر على إرسال البريد الإلكتروني، يرجى عدم استخدام هذه الميزة. إذا كنت مسؤولاً، يمكنك اختبار ذلك في <a href="settings">الإعدادات</a>.',
    'email_changed_logout'                      => 'حتى تؤكد عنوان بريدك الإلكتروني، لا يمكنك تسجيل الدخول.',
    'login_with_new_email'                      => 'يمكنك الآن تسجيل الدخول باستخدام عنوان بريدك الإلكتروني الجديد.',
    'login_with_old_email'                      => 'يمكنك الآن تسجيل الدخول باستخدام عنوان بريدك الإلكتروني القديم مرة أخرى.',
    'login_provider_local_only'                 => 'هذا الإجراء غير متاح عند المصادقة عبر ":login_provider".',
    'external_user_mgt_disabled'                => 'هذا الإجراء غير متاح عندما لا يكون Firefly III مسؤولاً عن إدارة المستخدمين أو المصادقة.',
    'external_auth_disabled'                    => 'هذا الإجراء غير متاح عندما لا يكون Firefly III مسؤولاً عن المصادقة.',
    'delete_local_info_only'                    => "لأن Firefly III ليس مسؤولاً عن إدارة المستخدمين أو المصادقة، ستقوم هذه الوظيفة فقط بحذف معلومات Firefly III المحلية.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'عملاء OAuth',
    'profile_oauth_no_clients'                  => 'لم تقم بإنشاء أي عملاء OAuth.',
    'profile_oauth_clients_external_auth'       => 'إذا كنت تستخدم موفر مصادقة خارجي مثل Authelia، فلن تعمل عملاء OAuth. يمكنك فقط استخدام رموز الوصول الشخصية.',
    'profile_oauth_clients_header'              => 'العملاء',
    'profile_oauth_client_id'                   => 'معرّف العميل',
    'profile_oauth_client_name'                 => 'الاسم',
    'profile_oauth_client_secret'               => 'السر',
    'profile_oauth_create_new_client'           => 'إنشاء عميل جديد',
    'profile_oauth_create_client'               => 'إنشاء عميل',
    'profile_oauth_edit_client'                 => 'تعديل العميل',
    'profile_oauth_name_help'                   => 'شيء سيتعرف عليه المستخدمون ويثقون به.',
    'profile_oauth_redirect_url'                => 'رابط إعادة التوجيه',
    'profile_oauth_redirect_url_help'           => 'رابط إعادة التوجيه لتطبيقك.',
    'profile_authorized_apps'                   => 'التطبيقات المصرح بها',
    'profile_authorized_clients'                => 'العملاء المصرح لهم',
    'profile_scopes'                            => 'النطاقات',
    'profile_revoke'                            => 'إلغاء',
    'profile_oauth_client_secret_title'         => 'سر العميل',
    'profile_oauth_client_secret_expl'          => 'هذا هو سر العميل الجديد الخاص بك. هذه هي المرة الوحيدة التي سيظهر فيها فلا تفقده! يمكنك الآن استخدام هذا السر لإجراء طلبات API.',
    'profile_personal_access_tokens'            => 'رموز الوصول الشخصية',
    'profile_personal_access_token'             => 'رمز الوصول الشخصي',
    'profile_oauth_confidential'                => 'سري',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'هذا هو رمز الوصول الشخصي الجديد الخاص بك. هذه هي المرة الوحيدة التي سيظهر فيها فلا تفقده! يمكنك الآن استخدام هذا الرمز لإجراء طلبات API.',
    'profile_no_personal_access_token'          => 'لم تقم بإنشاء أي رموز وصول شخصية.',
    'profile_create_new_token'                  => 'إنشاء رمز جديد',
    'profile_create_token'                      => 'إنشاء رمز',
    'profile_create'                            => 'إنشاء',
    'profile_save_changes'                      => 'حفظ التغييرات',
    'profile_whoops'                            => 'عذراً!',
    'profile_something_wrong'                   => 'حدث خطأ ما!',
    'profile_try_again'                         => 'حدث خطأ ما. يرجى المحاولة مرة أخرى.',
    'amounts'                                   => 'المبالغ',
    'multi_account_warning_unknown'             => 'اعتماداً على نوع المعاملة التي تنشئها، قد يتم تجاوز حساب المصدر و/أو الوجهة في التقسيمات اللاحقة بما هو محدد في أول تقسيم للمعاملة.',
    'multi_account_warning_withdrawal'          => 'ضع في اعتبارك أن حساب المصدر في التقسيمات اللاحقة سيتم تجاوزه بما هو محدد في أول تقسيم للسحب.',
    'multi_account_warning_deposit'             => 'ضع في اعتبارك أن حساب الوجهة في التقسيمات اللاحقة سيتم تجاوزه بما هو محدد في أول تقسيم للإيداع.',
    'multi_account_warning_transfer'            => 'ضع في اعتبارك أن حساب المصدر + الوجهة في التقسيمات اللاحقة سيتم تجاوزهما بما هو محدد في أول تقسيم للتحويل.',


    // export data:
    'export_data_title'                         => 'تصدير البيانات من Firefly III',
    'export_data_menu'                          => 'تصدير البيانات',
    'export_data_bc'                            => 'تصدير البيانات من Firefly III',
    'export_data_main_title'                    => 'تصدير البيانات من Firefly III',
    'export_data_expl'                          => 'يتيح لك هذا الرابط تصدير جميع المعاملات والبيانات الوصفية من Firefly III. يرجى الرجوع إلى المساعدة (أيقونة (?) في الأعلى يمين) لمزيد من المعلومات حول العملية.',
    'export_data_all_transactions'              => 'تصدير جميع المعاملات',
    'export_data_advanced_expl'                 => 'إذا كنت بحاجة إلى نوع تصدير أكثر تقدماً أو تحديداً، اقرأ المساعدة حول كيفية استخدام أمر الكونسول <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'مرفق واحد|:count مرفقات',
    'attachments'                               => 'المرفقات',
    'edit_attachment'                           => 'تعديل المرفق ":name"',
    'update_attachment'                         => 'تحديث المرفق',
    'delete_attachment'                         => 'حذف المرفق ":name"',
    'attachment_deleted'                        => 'تم حذف المرفق ":name"',
    'liabilities_deleted'                       => 'تم حذف الالتزام ":name"',
    'attachment_updated'                        => 'تم تحديث المرفق ":name"',
    'upload_max_file_size'                      => 'الحد الأقصى لحجم الملف: :size',
    'list_all_attachments'                      => 'قائمة بجميع المرفقات',

    // transaction index
    'is_reconciled_fields_dropped'              => 'لأن هذه المعاملة تمت تسويتها، لن تتمكن من تحديث الحسابات أو المبالغ إلا إذا أزلت علامة التسوية.',
    'is_reconciled'                             => 'تمت التسوية',
    'title_expenses'                            => 'المصروفات',
    'title_withdrawal'                          => 'المصروفات',
    'title_revenue'                             => 'الإيرادات / الدخل',
    'title_deposit'                             => 'الإيرادات / الدخل',
    'title_transfer'                            => 'التحويلات',
    'title_transfers'                           => 'التحويلات',
    'submission_options'                        => 'خيارات الإرسال',
    'apply_rules_checkbox'                      => 'تطبيق القواعد',
    'fire_webhooks_checkbox'                    => 'تشغيل Webhooks',
    'select_source_account'                     => 'يرجى اختيار أو كتابة اسم حساب مصدر صالح',
    'select_dest_account'                       => 'يرجى اختيار أو كتابة اسم حساب وجهة صالح',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'هذه المعاملة هي بالفعل سحب',
    'convert_is_already_type_Deposit'           => 'هذه المعاملة هي بالفعل إيداع',
    'convert_is_already_type_Transfer'          => 'هذه المعاملة هي بالفعل تحويل',
    'convert_to_Withdrawal'                     => 'تحويل ":description" إلى سحب',
    'convert_to_Deposit'                        => 'تحويل ":description" إلى إيداع',
    'convert_to_Transfer'                       => 'تحويل ":description" إلى تحويل',
    'convert_options_WithdrawalDeposit'         => 'تحويل السحب إلى إيداع',
    'convert_options_WithdrawalTransfer'        => 'تحويل السحب إلى تحويل',
    'convert_options_DepositTransfer'           => 'تحويل الإيداع إلى تحويل',
    'convert_options_DepositWithdrawal'         => 'تحويل الإيداع إلى سحب',
    'convert_options_TransferWithdrawal'        => 'تحويل التحويل إلى سحب',
    'convert_options_TransferDeposit'           => 'تحويل التحويل إلى إيداع',
    'convert_Withdrawal_to_deposit'             => 'حوّل هذا السحب إلى إيداع',
    'convert_Withdrawal_to_transfer'            => 'حوّل هذا السحب إلى تحويل',
    'convert_Deposit_to_withdrawal'             => 'حوّل هذا الإيداع إلى سحب',
    'convert_Deposit_to_transfer'               => 'حوّل هذا الإيداع إلى تحويل',
    'convert_Transfer_to_deposit'               => 'حوّل هذا التحويل إلى إيداع',
    'convert_Transfer_to_withdrawal'            => 'حوّل هذا التحويل إلى سحب',
    'convert_please_set_revenue_source'         => 'يرجى اختيار حساب الإيرادات الذي سيأتي منه المال.',
    'convert_please_set_asset_destination'      => 'يرجى اختيار حساب الأصول الذي سيذهب إليه المال.',
    'convert_please_set_expense_destination'    => 'يرجى اختيار حساب المصروفات الذي سيذهب إليه المال.',
    'convert_please_set_asset_source'           => 'يرجى اختيار حساب الأصول الذي سيأتي منه المال.',
    'convert_expl_w_d'                          => 'عند التحويل من سحب إلى إيداع، سيتم إيداع المال في حساب الوجهة المعروض بدلاً من سحبه منه.|عند التحويل من سحب إلى إيداع، سيتم إيداع المال في حسابات الوجهة المعروضة بدلاً من سحبها منها.',
    'convert_expl_w_t'                          => 'عند تحويل السحب إلى تحويل، سيتم تحويل المال من حساب المصدر إلى حساب أصول أو خصوم آخر بدلاً من إنفاقه على حساب المصروفات الأصلي.|عند تحويل السحب إلى تحويل، سيتم تحويل المال من حسابات المصدر إلى حسابات أصول أو خصوم أخرى بدلاً من إنفاقه على حسابات المصروفات الأصلية.',
    'convert_expl_d_w'                          => 'عند تحويل الإيداع إلى سحب، سيتم سحب المال من حساب المصدر المعروض بدلاً من إيداعه فيه.|عند تحويل الإيداع إلى سحب، سيتم سحب المال من حسابات المصدر المعروضة بدلاً من إيداعه فيها.',
    'convert_expl_d_t'                          => 'عند تحويل الإيداع إلى تحويل، سيتم إيداع المال في حساب الوجهة المدرج من أي حساب أصول أو خصوم لديك.|عند تحويل الإيداع إلى تحويل، سيتم إيداع المال في حسابات الوجهة المدرجة من أي حسابات أصول أو خصوم لديك.',
    'convert_expl_t_w'                          => 'عند تحويل التحويل إلى سحب، سيتم إنفاق المال على حساب الوجهة الذي تحدده هنا بدلاً من تحويله بعيداً.|عند تحويل التحويل إلى سحب، سيتم إنفاق المال على حسابات الوجهة التي تحددها هنا بدلاً من تحويله بعيداً.',
    'convert_expl_t_d'                          => 'عند تحويل التحويل إلى إيداع، سيتم إيداع المال في حساب الوجهة الذي تراه هنا بدلاً من تحويله إليه.|عند تحويل التحويل إلى إيداع، سيتم إيداع المال في حسابات الوجهة التي تراها هنا بدلاً من تحويله إليها.',
    'convert_select_sources'                    => 'لإكمال التحويل، يرجى تعيين حساب المصدر الجديد أدناه.|لإكمال التحويل، يرجى تعيين حسابات المصدر الجديدة أدناه.',
    'convert_select_destinations'               => 'لإكمال التحويل، يرجى اختيار حساب الوجهة الجديد أدناه.|لإكمال التحويل، يرجى اختيار حسابات الوجهة الجديدة أدناه.',
    'converted_to_Withdrawal'                   => 'تم تحويل المعاملة إلى سحب',
    'converted_to_Deposit'                      => 'تم تحويل المعاملة إلى إيداع',
    'converted_to_Transfer'                     => 'تم تحويل المعاملة إلى تحويل',
    'invalid_convert_selection'                 => 'الحساب الذي اخترته مستخدم بالفعل في هذه المعاملة أو غير موجود.',
    'source_or_dest_invalid'                    => 'تعذر العثور على تفاصيل المعاملة الصحيحة. التحويل غير ممكن.',
    'convert_to_withdrawal'                     => 'تحويل إلى سحب',
    'convert_to_deposit'                        => 'تحويل إلى إيداع',
    'convert_to_transfer'                       => 'تحويل إلى تحويل',

    // create new stuff:
    'create_new_withdrawal'                     => 'إنشاء سحب جديد',
    'create_new_deposit'                        => 'إنشاء إيداع جديد',
    'create_new_transfer'                       => 'إنشاء تحويل جديد',
    'create_new_asset'                          => 'إنشاء حساب أصول جديد',
    'create_new_liabilities'                    => 'إنشاء التزام جديد',
    'create_new_expense'                        => 'إنشاء حساب مصروفات جديد',
    'create_new_revenue'                        => 'إنشاء حساب إيرادات جديد',
    'create_new_piggy_bank'                     => 'إنشاء حصالة جديدة',
    'create_new_bill'                           => 'إنشاء اشتراك جديد',
    'create_new_subscription'                   => 'إنشاء اشتراك جديد',
    'create_new_rule'                           => 'إنشاء قاعدة جديدة',

    // currencies:
    'create_currency'                           => 'إنشاء عملة جديدة',
    'store_currency'                            => 'حفظ عملة جديدة',
    'update_currency'                           => 'تحديث العملة',
    'new_default_currency'                      => 'العملة الافتراضية الآن هي ":name".',
    'default_currency_failed'                   => 'تعذر تعيين ":name" كعملة افتراضية. يرجى مراجعة السجلات.',
    'cannot_delete_currency'                    => 'لا يمكن حذف :name لأنها لا تزال قيد الاستخدام.',
    'cannot_delete_fallback_currency'           => ':name هي عملة النظام الاحتياطية ولا يمكن حذفها.',
    'cannot_disable_currency_journals'          => 'لا يمكن تعطيل :name لأن المعاملات لا تزال تستخدمها.',
    'cannot_disable_currency_last_left'         => 'لا يمكن تعطيل :name لأنها آخر عملة مفعلة.',
    'cannot_disable_currency_account_meta'      => 'لا يمكن تعطيل :name لأنها مستخدمة في حسابات الأصول.',
    'cannot_disable_currency_bills'             => 'لا يمكن تعطيل :name لأنها مستخدمة في الاشتراكات.',
    'cannot_disable_currency_recurring'         => 'لا يمكن تعطيل :name لأنها مستخدمة في المعاملات المتكررة.',
    'cannot_disable_currency_available_budgets' => 'لا يمكن تعطيل :name لأنها مستخدمة في الميزانيات المتاحة.',
    'cannot_disable_currency_budget_limits'     => 'لا يمكن تعطيل :name لأنها مستخدمة في حدود الميزانية.',
    'cannot_disable_currency_current_default'   => 'لا يمكن تعطيل :name لأنها العملة الافتراضية الحالية.',
    'cannot_disable_currency_system_fallback'   => 'لا يمكن تعطيل :name لأنها عملة النظام الافتراضية.',
    'disable_EUR_side_effects'                  => 'اليورو هو عملة الطوارئ الاحتياطية للنظام. قد يؤدي تعطيله إلى آثار جانبية غير متوقعة وقد يبطل الضمان.',
    'deleted_currency'                          => 'تم حذف العملة :name',
    'created_currency'                          => 'تم إنشاء العملة :name',
    'could_not_store_currency'                  => 'تعذر حفظ العملة الجديدة.',
    'updated_currency'                          => 'تم تحديث العملة :name',
    'ask_site_owner'                            => 'يرجى طلب من :owner إضافة أو إزالة أو تعديل العملات.',
    'currencies_intro'                          => 'يدعم Firefly III عدة عملات يمكنك تعيينها وتفعيلها هنا.',
    'currencies_switch_default'                 => 'يمكنك تبديل العملة الأساسية لإدارتك الحالية من صفحة "الإدارات المالية".',
    'make_default_currency'                     => 'تعيين كافتراضي',
    'default_currency'                          => 'افتراضي',
    'primary_currency_button'                   => 'أساسي',
    'currency_is_disabled'                      => 'معطلة',
    'enable_currency'                           => 'تفعيل',
    'disable_currency'                          => 'تعطيل',
    'currencies_default_disabled'               => 'معظم هذه العملات معطلة افتراضياً. لاستخدامها، يجب تفعيلها أولاً.',
    'currency_is_now_enabled'                   => 'تم تفعيل العملة ":name"',
    'could_not_enable_currency'                 => 'تعذر تفعيل العملة ":name". يرجى مراجعة السجلات.',
    'currency_is_now_disabled'                  => 'تم تعطيل العملة ":name"',
    'could_not_disable_currency'                => 'تعذر تعطيل العملة ":name". ربما لا تزال قيد الاستخدام؟',

    // forms:
    'mandatoryFields'                           => 'حقول إلزامية',
    'optionalFields'                            => 'حقول اختيارية',
    'options'                                   => 'خيارات',

    // budgets:
    'daily_budgets'                             => 'ميزانيات يومية',
    'weekly_budgets'                            => 'ميزانيات أسبوعية',
    'monthly_budgets'                           => 'ميزانيات شهرية',
    'quarterly_budgets'                         => 'ميزانيات ربع سنوية',
    'half_year_budgets'                         => 'ميزانيات نصف سنوية',
    'yearly_budgets'                            => 'ميزانيات سنوية',
    'other_budgets'                             => 'ميزانيات مخصصة حسب الوقت',
    'budget_limit_not_in_range'                 => 'ينطبق هذا المبلغ من :start إلى :end:',
    'total_available_budget'                    => 'إجمالي الميزانية المتاحة (بين :start و :end)',
    'total_available_budget_in_currency'        => 'إجمالي الميزانية المتاحة بـ :currency',
    'see_below'                                 => 'انظر أدناه',
    'create_new_budget'                         => 'إنشاء ميزانية جديدة',
    'store_new_budget'                          => 'حفظ ميزانية جديدة',
    'stored_new_budget'                         => 'تم حفظ الميزانية الجديدة ":name"',
    'available_between'                         => 'المتوفر بين :start و :end',
    'transactionsWithoutBudget'                 => 'مصروفات بدون ميزانية',
    'transactions_no_budget'                    => 'مصروفات بدون ميزانية بين :start و :end',
    'spent_between'                             => 'تم إنفاقه بالفعل بين :start و :end',
    'spent_between_left'                        => 'تم إنفاق :spent بين :start و :end، والمتبقي :left.',
    'set_available_amount'                      => 'تعيين المبلغ المتاح',
    'update_available_amount'                   => 'تحديث المبلغ المتاح',
    'ab_basic_modal_explain'                    => 'استخدم هذا النموذج لتحديد المبلغ الذي تتوقع أن تتمكن من تخصيصه (إجمالاً، بـ :currency) في الفترة المحددة.',
    'createBudget'                              => 'ميزانية جديدة',
    'invalid_currency'                          => 'هذه عملة غير صالحة',
    'invalid_amount'                            => 'يرجى إدخال مبلغ',
    'set_ab'                                    => 'تم تعيين المبلغ المتاح للميزانية',
    'updated_ab'                                => 'تم تحديث المبلغ المتاح للميزانية',
    'deleted_ab'                                => 'تم حذف المبلغ المتاح للميزانية',
    'deleted_bl'                                => 'تمت إزالة المبلغ المخصص',
    'alt_currency_ab_create'                    => 'تعيين الميزانية المتاحة بعملة أخرى',
    'bl_create_btn'                             => 'تعيين الميزانية بعملة أخرى',
    'inactiveBudgets'                           => 'ميزانيات غير نشطة',
    'without_budget_between'                    => 'معاملات بدون ميزانية بين :start و :end',
    'delete_budget'                             => 'حذف الميزانية ":name"',
    'deleted_budget'                            => 'تم حذف الميزانية ":name"',
    'edit_budget'                               => 'تعديل الميزانية ":name"',
    'updated_budget'                            => 'تم تحديث الميزانية ":name"',
    'update_amount'                             => 'تحديث المبلغ',
    'update_budget'                             => 'تحديث الميزانية',
    'update_budget_amount_range'                => 'تحديث المبلغ المتوقع المتاح بين :start و :end',
    'set_budget_limit_title'                    => 'تعيين المبلغ المخصص للميزانية :budget بين :start و :end',
    'set_budget_limit'                          => 'تعيين المبلغ المخصص',
    'budget_period_navigator'                   => 'مُتنقل الفترات',
    'info_on_available_amount'                  => 'ما هو المتاح لدي؟',
    'available_amount_indication'               => 'استخدم هذه المبالغ للحصول على مؤشر لما يمكن أن تكون عليه ميزانيتك الإجمالية.',
    'suggested'                                 => 'مقترح',
    'average_between'                           => 'المتوسط بين :start و :end',
    'transferred_in'                            => 'تم التحويل (إلى الداخل)',
    'transferred_away'                          => 'تم التحويل (إلى الخارج)',
    'auto_budget_none'                          => 'لا ميزانية تلقائية',
    'auto_budget_reset'                         => 'تعيين مبلغ ثابت كل فترة',
    'auto_budget_rollover'                      => 'إضافة مبلغ كل فترة',
    'auto_budget_adjusted'                      => 'إضافة مبلغ كل فترة وتصحيح التجاوز',
    'auto_budget_period_daily'                  => 'يومي',
    'auto_budget_period_weekly'                 => 'أسبوعي',
    'auto_budget_period_monthly'                => 'شهري',
    'auto_budget_period_quarterly'              => 'ربع سنوي',
    'auto_budget_period_half_year'              => 'كل نصف سنة',
    'auto_budget_period_yearly'                 => 'سنوي',
    'auto_budget_help'                          => 'يمكنك قراءة المزيد عن هذه الميزة في المساعدة. انقر على أيقونة (?) في الأعلى يمين.',
    'auto_budget_reset_icon'                    => 'سيتم تعيين هذه الميزانية بشكل دوري',
    'auto_budget_rollover_icon'                 => 'سيزداد مبلغ الميزانية بشكل دوري',
    'auto_budget_adjusted_icon'                 => 'سيزداد مبلغ الميزانية بشكل دوري وسيتم تصحيح التجاوز',
    'remove_budgeted_amount'                    => 'إزالة المبلغ المخصص بـ :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'المتبقي للدفع',
    'less_than_expected'                        => 'أقل من المتوقع',
    'more_than_expected'                        => 'أكثر من المتوقع',
    'skip_help_text'                            => 'استخدم حقل التخطي لإنشاء فترات نصف شهرية (تخطي = 1) أو فترات مخصصة أخرى.',
    'subscription'                              => 'اشتراك',
    'not_expected_period'                       => 'غير متوقع في هذه الفترة',
    'subscriptions_in_group'                    => 'اشتراكات في المجموعة "{{title}}"',
    'subscr_expected_x_times'                   => 'توقع دفع {{amount}} {{times}} مرات في هذه الفترة',
    'not_or_not_yet'                            => 'ليس (بعد)',
    'visit_bill'                                => 'زيارة الاشتراك ":name" في Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'يتطابق الاشتراك مع المعاملات بين :low و :high.',
    'running_again_loss'                        => 'قد تفقد المعاملات المرتبطة سابقًا بهذا الاشتراك اتصالها، إذا كانت (لم تعد) تتطابق مع القاعدة (القواعد).',
    'bill_related_rules'                        => 'القواعد المتعلقة بهذا الاشتراك',
    'repeats'                                   => 'تكرار',
    'bill_end_date_help'                        => 'حقل اختياري. من المتوقع أن ينتهي الاشتراك في هذا التاريخ.',
    'bill_extension_date_help'                  => 'حقل اختياري. يجب تمديد الاشتراك (أو إلغاؤه) في أو قبل هذا التاريخ.',
    'bill_end_index_line'                       => 'ينتهي هذا الاشتراك في :date',
    'bill_extension_index_line'                 => 'يجب تمديد هذا الاشتراك أو إلغاؤه في :date',
    'connected_journals'                        => 'المعاملات المتصلة',
    'auto_match_on'                             => 'تمت المطابقة تلقائيًا بواسطة Firefly III',
    'auto_match_off'                            => 'لم تتم المطابقة تلقائيًا بواسطة Firefly III',
    'next_expected_match'                       => 'المطابقة المتوقعة التالية',
    'delete_bill'                               => 'حذف الاشتراك ":name"',
    'deleted_bill'                              => 'تم حذف الاشتراك ":name"',
    'edit_bill'                                 => 'تعديل الاشتراك ":name"',
    'more'                                      => 'المزيد',
    'rescan_old'                                => 'إعادة تشغيل القواعد مرة أخرى، على جميع المعاملات',
    'update_bill'                               => 'تحديث الاشتراك',
    'updated_bill'                              => 'تم تحديث الاشتراك ":name"',
    'store_new_bill'                            => 'تخزين اشتراك جديد',
    'stored_new_bill'                           => 'تم تخزين اشتراك جديد ":name"',
    'cannot_scan_inactive_bill'                 => 'لا يمكن فحص الاشتراكات غير النشطة.',
    'rescanned_bill'                            => 'تمت إعادة فحص كل شيء، وتم ربط :count معاملة بالاشتراك.|تمت إعادة فحص كل شيء، وتم ربط :count معاملة بالاشتراك.',
    'average_bill_amount_year'                  => 'متوسط مبلغ الاشتراك (:year)',
    'average_bill_amount_overall'               => 'متوسط مبلغ الاشتراك (بشكل عام)',
    'bill_is_active'                            => 'الاشتراك نشط',
    'bill_expected_between'                     => 'متوقع بين :start و :end',
    'bill_will_automatch'                       => 'سيتم ربط الاشتراك تلقائيًا بالمعاملات المتطابقة',
    'skips_over'                                => 'يتخطى',
    'bill_store_error'                          => 'حدث خطأ غير متوقع أثناء تخزين اشتراكك الجديد. يرجى التحقق من ملفات السجل',
    'list_inactive_rule'                        => 'قاعدة غير نشطة',
    'bill_edit_rules'                           => 'سيحاول Firefly III تعديل القاعدة المتعلقة بهذا الاشتراك أيضًا. ولكن إذا قمت بتعديل هذه القاعدة بنفسك، فلن يقوم Firefly III بأي تغييرات. | سيحاول Firefly III تعديل :count قواعد مرتبطة بهذا الاشتراك أيضًا. ولكن إذا قمت بتعديل هذه القواعد بنفسك، فلن يقوم Firefly III بأي تغييرات.',
    'bill_expected_date'                        => 'متوقع في :date',
    'bill_expected_date_js'                     => 'متوقع في {date}',
    'expected_amount'                           => 'المبلغ (المتوقع)',
    'bill_paid_on'                              => 'دُفع في {date}',
    'bill_repeats_weekly'                       => 'يتكرر أسبوعياً',
    'bill_repeats_monthly'                      => 'يتكرر شهرياً',
    'bill_repeats_quarterly'                    => 'يتكرر كل ربع سنة',
    'bill_repeats_half-year'                    => 'يتكرر كل نصف سنة',
    'bill_repeats_yearly'                       => 'يتكرر سنوياً',
    'bill_repeats_weekly_other'                 => 'يتكرر كل أسبوعين',
    'bill_repeats_monthly_other'                => 'يتكرر كل شهرين',
    'bill_repeats_quarterly_other'              => 'يتكرر كل ربعين',
    'bill_repeats_half-year_other'              => 'يتكرر سنوياً',
    'bill_repeats_yearly_other'                 => 'يتكرر كل سنتين',
    'bill_repeats_weekly_skip'                  => 'يتكرر كل {skip} أسابيع',
    'bill_repeats_monthly_skip'                 => 'يتكرر كل {skip} أشهر',
    'bill_repeats_quarterly_skip'               => 'يتكرر كل {skip} أرباع',
    'bill_repeats_half-year_skip'               => 'يتكرر كل {skip} نصف سنة',
    'bill_repeats_yearly_skip'                  => 'يتكرر كل {skip} سنوات',
    'subscriptions'                             => 'الاشتراكات',
    'go_to_subscriptions'                       => 'اذهب إلى اشتراكاتك',
    'forever'                                   => 'دائماً',
    'extension_date_is'                         => 'تاريخ التمديد هو {date}',

    // accounts:
    'account_locked_currency'                   => 'يجب أن تظل عملة هذا الحساب :name طالما أن هناك حصّالات مرتبطة به.',
    'i_am_owed_amount'                          => 'مبلغ مستحق لي',
    'i_owe_amount'                              => 'مبلغ مستحق علي',
    'inactive_account_link'                     => 'لديك :count حساب غير نشط (مؤرشف)، يمكنك عرضه في هذه الصفحة المنفصلة.|لديك :count حسابات غير نشطة (مؤرشفة)، يمكنك عرضها في هذه الصفحة المنفصلة.',
    'all_accounts_inactive'                     => 'هذه هي حساباتك غير النشطة.',
    'active_account_link'                       => 'هذا الرابط يعيدك إلى حساباتك النشطة.',
    'account_missing_transaction'               => 'لا يمكن عرض الحساب #:id (":name") مباشرة، ولا توجد معلومات إعادة توجيه.',
    'cc_monthly_payment_date_help'              => 'اختر أي سنة وأي شهر، سيتم تجاهلهما. اليوم فقط هو المهم.',
    'details_for_asset'                         => 'تفاصيل حساب الأصول ":name"',
    'details_for_expense'                       => 'تفاصيل حساب المصروفات ":name"',
    'details_for_revenue'                       => 'تفاصيل حساب الإيرادات ":name"',
    'details_for_cash'                          => 'تفاصيل الحساب النقدي ":name"',
    'store_new_asset_account'                   => 'حفظ حساب أصول جديد',
    'store_new_expense_account'                 => 'حفظ حساب مصروفات جديد',
    'store_new_revenue_account'                 => 'حفظ حساب إيرادات جديد',
    'edit_asset_account'                        => 'تعديل حساب الأصول ":name"',
    'edit_expense_account'                      => 'تعديل حساب المصروفات ":name"',
    'edit_revenue_account'                      => 'تعديل حساب الإيرادات ":name"',
    'delete_asset_account'                      => 'حذف حساب الأصول ":name"',
    'delete_expense_account'                    => 'حذف حساب المصروفات ":name"',
    'delete_revenue_account'                    => 'حذف حساب الإيرادات ":name"',
    'delete_liabilities_account'                => 'حذف الالتزام ":name"',
    'asset_deleted'                             => 'تم حذف حساب الأصول ":name" بنجاح',
    'account_deleted'                           => 'تم حذف الحساب ":name" بنجاح',
    'expense_deleted'                           => 'تم حذف حساب المصروفات ":name" بنجاح',
    'revenue_deleted'                           => 'تم حذف حساب الإيرادات ":name" بنجاح',
    'update_asset_account'                      => 'تحديث حساب الأصول',
    'update_undefined_account'                  => 'تحديث الحساب',
    'update_liabilities_account'                => 'تحديث الالتزام',
    'update_expense_account'                    => 'تحديث حساب المصروفات',
    'update_revenue_account'                    => 'تحديث حساب الإيرادات',
    'make_new_asset_account'                    => 'إنشاء حساب أصول جديد',
    'make_new_expense_account'                  => 'إنشاء حساب مصروفات جديد',
    'make_new_revenue_account'                  => 'إنشاء حساب إيرادات جديد',
    'make_new_liabilities_account'              => 'إنشاء التزام جديد',
    'asset_accounts'                            => 'حسابات الأصول',
    'undefined_accounts'                        => 'الحسابات',
    'asset_accounts_inactive'                   => 'حسابات الأصول (غير نشطة)',
    'expense_account'                           => 'حساب المصروفات',
    'expense_accounts'                          => 'حسابات المصروفات',
    'expense_accounts_inactive'                 => 'حسابات المصروفات (غير نشطة)',
    'revenue_account'                           => 'حساب الإيرادات',
    'revenue_accounts'                          => 'حسابات الإيرادات',
    'revenue_accounts_inactive'                 => 'حسابات الإيرادات (غير نشطة)',
    'cash_accounts'                             => 'الحسابات النقدية',
    'Cash account'                              => 'حساب نقدي',
    'liabilities_accounts'                      => 'الخصوم',
    'liabilities_accounts_inactive'             => 'الخصوم (غير نشطة)',
    'reconcile_account'                         => 'تسوية الحساب ":account"',
    'overview_of_reconcile_modal'               => 'نظرة عامة على التسوية',
    'delete_reconciliation'                     => 'حذف التسوية',
    'update_reconciliation'                     => 'تحديث التسوية',
    'amount_cannot_be_zero'                     => 'لا يمكن أن يكون المبلغ صفراً',
    'end_of_reconcile_period'                   => 'نهاية فترة التسوية: :period',
    'start_of_reconcile_period'                 => 'بداية فترة التسوية: :period',
    'start_balance'                             => 'الرصيد الابتدائي',
    'end_balance'                               => 'الرصيد النهائي',
    'update_balance_dates_instruction'          => 'طابق المبالغ والتواريخ أعلاه مع كشف حسابك البنكي، ثم اضغط "بدء التسوية"',
    'select_transactions_instruction'           => 'حدد المعاملات التي تظهر في كشف حسابك البنكي.',
    'select_range_and_balance'                  => 'تحقق أولاً من نطاق التواريخ والأرصدة. ثم اضغط "بدء التسوية"',
    'date_change_instruction'                   => 'إذا غيرت نطاق التواريخ الآن، سيتم فقد أي تقدم.',
    'update_selection'                          => 'تحديث التحديد',
    'store_reconcile'                           => 'حفظ التسوية',
    'reconciliation_transaction'                => 'معاملة التسوية',
    'Reconciliation'                            => 'التسوية',
    'reconciliation'                            => 'التسوية',
    'reconcile_options'                         => 'خيارات التسوية',
    'reconcile_range'                           => 'نطاق التسوية',
    'start_reconcile'                           => 'بدء التسوية',
    'cash_account_type'                         => 'نقد',
    'cash'                                      => 'نقد',
    'cant_find_redirect_account'                => 'حاول Firefly III إعادة توجيهك ولكن لم يتمكن. آسف لذلك. العودة إلى الفهرس.',
    'account_type'                              => 'نوع الحساب',
    'save_transactions_by_moving'               => 'احفظ هذه المعاملة بنقلها إلى حساب آخر:|احفظ هذه المعاملات بنقلها إلى حساب آخر:',
    'save_transactions_by_moving_js'            => 'لا توجد معاملات|احفظ هذه المعاملة بنقلها إلى حساب آخر. |احفظ هذه المعاملات بنقلها إلى حساب آخر.',
    'stored_new_account'                        => 'تم حفظ الحساب الجديد ":name"!',
    'stored_new_account_js'                     => 'تم حفظ الحساب الجديد "<a href="accounts/show/{ID}">{name}</a>"!',
    'updated_account'                           => 'تم تحديث الحساب ":name"',
    'updated_account_js'                        => 'تم تحديث الحساب "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'خيارات بطاقة الائتمان',
    'no_transactions_account'                   => 'لا توجد معاملات (في هذه الفترة) لحساب الأصول ":name".',
    'no_transactions_period'                    => 'لا توجد معاملات (في هذه الفترة).',
    'no_data_for_chart'                         => 'لا توجد معلومات كافية (حتى الآن) لإنشاء هذا الرسم البياني.',
    'select_at_least_one_account'               => 'يرجى تحديد حساب أصول واحد على الأقل',
    'select_at_least_one_category'              => 'يرجى تحديد فئة واحدة على الأقل',
    'select_at_least_one_budget'                => 'يرجى تحديد ميزانية واحدة على الأقل',
    'select_at_least_one_tag'                   => 'يرجى تحديد علامة واحدة على الأقل',
    'select_at_least_one_expense'               => 'يرجى تحديد مجموعة واحدة على الأقل من حسابات المصروفات / الإيرادات. إذا لم يكن لديك أي منها (القائمة فارغة) ، فإن هذا التقرير غير متاح.',
    'account_default_currency'                  => 'ستكون هذه هي العملة الافتراضية المرتبطة بهذا الحساب.',
    'piggy_default_currency'                    => 'يمكن أن تحتفظ حصّالات النقود بالمال في عملة واحدة فقط.',
    'piggy_account_currency_match'              => 'سيتم قبول الحسابات التي تستخدم العملة المحددة مسبقًا فقط.',
    'reconcile_has_more'                        => 'يحتوي دفتر أستاذ Firefly III الخاص بك على أموال أكثر مما تدعيه المصرف. هناك عدة خيارات. يرجى اختيار ما يجب القيام به. ثم اضغط على "تأكيد التسوية".',
    'reconcile_has_less'                        => 'يحتوي دفتر أستاذ Firefly III الخاص بك على أموال أقل مما تدعيه المصرف. هناك عدة خيارات. يرجى اختيار ما يجب القيام به. ثم اضغط على "تأكيد التسوية".',
    'reconcile_is_equal'                        => 'يتطابق دفتر أستاذ Firefly III الخاص بك مع كشوف حساباتك المصرفية. لا يوجد ما يجب القيام به. يرجى الضغط على "تأكيد التسوية" لتأكيد إدخالك.',
    'create_pos_reconcile_transaction'          => 'قم بمسح المعاملات المحددة، وأنشئ تصحيحًا يضيف :amount إلى حساب الأصول هذا.',
    'create_neg_reconcile_transaction'          => 'قم بمسح المعاملات المحددة، وأنشئ تصحيحًا يزيل :amount من حساب الأصول هذا.',
    'reconcile_do_nothing'                      => 'قم بمسح المعاملات المحددة، ولكن لا تقم بالتصحيح.',
    'reconcile_go_back'                         => 'يمكنك دائمًا تعديل أو حذف التصحيح لاحقًا.',
    'must_be_asset_account'                     => 'يمكنك فقط تسوية حسابات الأصول',
    'reconciliation_stored'                     => 'تم حفظ التسوية',
    'reconciliation_error'                      => 'نظرًا لوجود خطأ، تم وضع علامة على المعاملات على أنها متسقة ولكن لم يتم تخزين التصحيح: :error.',
    'reconciliation_transaction_title'          => 'التسوية (:from إلى :to)',
    'sum_of_reconciliation'                     => 'مجموع التسوية',
    'reconcile_this_account'                    => 'تسوية هذا الحساب',
    'reconcile'                                 => 'تسوية',
    'show'                                      => 'عرض',
    'confirm_reconciliation'                    => 'تأكيد التسوية',
    'submitted_start_balance'                   => 'الرصيد الابتدائي المقدم',
    'selected_transactions'                     => 'المعاملات المحددة (:count)',
    'already_cleared_transactions'              => 'المعاملات التي تم مسحها بالفعل (:count)',
    'submitted_end_balance'                     => 'الرصيد النهائي المقدم',
    'initial_balance_description'               => 'الرصيد الابتدائي لـ ":account"',
    'liability_credit_description'              => 'رصيد الالتزام لـ ":account"',
    'interest_calc_'                            => 'غير معروف',
    'interest_calc_daily'                       => 'يوميًا',
    'interest_calc_monthly'                     => 'شهريًا',
    'interest_calc_yearly'                      => 'سنويًا',
    'interest_calc_weekly'                      => 'أسبوعيًا',
    'interest_calc_half-year'                   => 'نصف سنويًا',
    'interest_calc_quarterly'                   => 'ربع سنويًا',
    'initial_balance_account'                   => 'حساب الرصيد الابتدائي لـ :account',
    'list_options'                              => 'خيارات القائمة',
    'account_column_opt_drag_and_drop'          => 'السحب والإفلات',
    'account_column_opt_active'                 => 'نشط',
    'account_column_opt_name'                   => 'الاسم',
    'account_column_opt_type'                   => 'النوع',
    'account_column_opt_liability_type'         => 'نوع الالتزام',
    'account_column_opt_liability_direction'    => 'اتجاه الالتزام',
    'account_column_opt_liability_interest'     => 'فائدة الالتزام',
    'account_column_opt_number'                 => 'رقم الحساب',
    'account_column_opt_current_balance'        => 'الرصيد الحالي',
    'account_column_opt_amount_due'             => 'المبلغ المستحق',
    'account_column_opt_last_activity'          => 'آخر نشاط',
    'account_column_opt_balance_difference'     => 'فرق الرصيد',
    'account_column_opt_menu'                   => 'القائمة',

    // categories:
    'new_category'                              => 'فئة جديدة',
    'create_new_category'                       => 'إنشاء فئة جديدة',
    'without_category'                          => 'بدون فئة',
    'update_category'                           => 'تحديث الفئة',
    'updated_category'                          => 'تم تحديث الفئة ":name"',
    'categories'                                => 'الفئات',
    'edit_category'                             => 'تعديل الفئة ":name"',
    'no_category'                               => '(لا توجد فئة)',
    'unknown_category_plain'                    => 'لا توجد فئة',
    'category'                                  => 'فئة',
    'delete_category'                           => 'حذف الفئة ":name"',
    'deleted_category'                          => 'تم حذف الفئة ":name"',
    'store_category'                            => 'تخزين فئة جديدة',
    'stored_category'                           => 'تم تخزين الفئة الجديدة ":name"',
    'without_category_between'                  => 'بدون فئة بين :start و :end',


    // transactions:
    'wait_loading_transaction'                  => 'يرجى الانتظار حتى يتم تحميل النموذج.',
    'wait_loading_data'                         => 'يرجى الانتظار حتى يتم تحميل معلوماتك...',
    'wait_attachments'                          => 'يرجى الانتظار حتى يتم تحميل المرفقات.',
    'errors_upload'                             => 'فشل التحميل. يرجى التحقق من وحدة التحكم في المتصفح للحصول على الخطأ.',
    'amount_foreign_if'                         => 'المبلغ بالعملة الأجنبية، إن وجد',
    'amount_destination_account'                => 'المبلغ بعملة حساب الوجهة',
    'edit_transaction_title'                    => 'تعديل المعاملة ":description"',
    'unreconcile'                               => 'تراجع عن التسوية',
    'update_withdrawal'                         => 'تحديث السحب',
    'update_deposit'                            => 'تحديث الإيداع',
    'update_transaction'                        => 'تحديث المعاملة',
    'update_transfer'                           => 'تحديث التحويل',
    'updated_withdrawal'                        => 'تم تحديث السحب ":description"',
    'updated_deposit'                           => 'تم تحديث الإيداع ":description"',
    'updated_transfer'                          => 'تم تحديث التحويل ":description"',
    'no_changes_withdrawal'                     => 'لم يتم تغيير السحب ":description".',
    'no_changes_deposit'                        => 'لم يتم تغيير الإيداع ":description".',
    'no_changes_transfer'                       => 'لم يتم تغيير التحويل ":description".',
    'delete_withdrawal'                         => 'حذف السحب ":description"',
    'delete_deposit'                            => 'حذف الإيداع ":description"',
    'delete_transfer'                           => 'حذف التحويل ":description"',
    'deleted_withdrawal'                        => 'تم حذف السحب ":description"',
    'deleted_deposit'                           => 'تم حذف الإيداع ":description"',
    'deleted_transfer'                          => 'تم حذف التحويل ":description"',
    'deleted_reconciliation'                    => 'تم حذف عملية التسوية ":description"',
    'stored_journal'                            => 'تم إنشاء معاملة جديدة ":description"',
    'stored_journal_js'                         => 'تم إنشاء معاملة جديدة بنجاح "{{description}}"',
    'stored_journal_no_descr'                   => 'تم إنشاء معاملة جديدة بنجاح',
    'updated_journal_no_descr'                  => 'تم تحديث معاملتك بنجاح',
    'select_transactions'                       => 'حدد المعاملات',
    'rule_group_select_transactions'            => 'تطبيق ":title" على المعاملات',
    'rule_select_transactions'                  => 'تطبيق ":title" على المعاملات',
    'stop_selection'                            => 'إيقاف تحديد المعاملات',
    'reconcile_selected'                        => 'تسوية',
    'mass_delete_journals'                      => 'حذف عدد من المعاملات',
    'mass_edit_journals'                        => 'تعديل عدد من المعاملات',
    'mass_bulk_journals'                        => 'تعديل عدد من المعاملات بشكل جماعي',
    'mass_bulk_journals_explain'                => 'تتيح لك هذه النموذج تغيير خصائص المعاملات المدرجة أدناه في تحديث شامل واحد. سيتم تحديث جميع المعاملات في الجدول عند تغيير المعلمات التي تراها هنا.',
    'part_of_split'                             => 'هذه المعاملة هي جزء من معاملة مجزأة. إذا لم تقم بتحديد جميع الأجزاء، فقد ينتهي بك الأمر بتغيير نصف المعاملة فقط.',
    'bulk_set_new_values'                       => 'استخدم المدخلات أدناه لتعيين قيم جديدة. إذا تركتها فارغة، فسيتم جعلها فارغة للجميع. أيضًا، لاحظ أنه سيتم منح الميزانية فقط للسحوبات.',
    'no_bulk_category'                          => 'لا تقم بتحديث الفئة',
    'no_bulk_budget'                            => 'لا تقم بتحديث الميزانية',
    'no_bulk_tags'                              => 'لا تقم بتحديث الأوسمة',
    'replace_with_these_tags'                   => 'استبدال هذه الأوسمة',
    'append_these_tags'                         => 'إضافة هذه الأوسمة',
    'mass_edit'                                 => 'تعديل المحدد بشكل فردي',
    'bulk_edit'                                 => 'تعديل المحدد بشكل جماعي',
    'mass_delete'                               => 'حذف المحدد',
    'cannot_edit_other_fields'                  => 'لا يمكنك تعديل الحقول الأخرى بشكل جماعي بخلاف تلك المعروضة هنا، لأنه لا يوجد مجال لعرضها. يرجى اتباع الرابط وتعديلها واحدة تلو الأخرى، إذا كنت بحاجة إلى تعديل هذه الحقول.',
    'cannot_change_amount_reconciled'           => 'لا يمكنك تغيير المبلغ أو الحسابات للمعاملات المتسوية.',
    'no_budget'                                 => '(لا توجد ميزانية)',
    'no_bill'                                   => '(لا توجد اشتراك)',
    'account_per_budget'                        => 'حساب لكل ميزانية',
    'account_per_category'                      => 'حساب لكل فئة',
    'create_new_object'                         => 'إنشاء',
    'empty'                                     => '(فارغ)',
    'all_other_budgets'                         => '(جميع الميزانيات الأخرى)',
    'all_other_accounts'                        => '(جميع الحسابات الأخرى)',
    'expense_per_source_account'                => 'المصروفات لكل حساب مصدر',
    'expense_per_destination_account'           => 'المصروفات لكل حساب وجهة',
    'income_per_destination_account'            => 'الإيرادات لكل حساب وجهة',
    'spent_in_specific_category'                => 'المصروفات في الفئة ":category"',
    'earned_in_specific_category'               => 'الإيرادات في الفئة ":category"',
    'spent_in_specific_tag'                     => 'المصروفات في الوسم ":tag"',
    'earned_in_specific_tag'                    => 'الإيرادات في الوسم ":tag"',
    'income_per_source_account'                 => 'الإيرادات لكل حساب مصدر',
    'average_spending_per_destination'          => 'متوسط المصروفات لكل حساب وجهة',
    'average_spending_per_source'               => 'متوسط المصروفات لكل حساب مصدر',
    'average_earning_per_source'                => 'متوسط الإيرادات لكل حساب مصدر',
    'average_earning_per_destination'           => 'متوسط الإيرادات لكل حساب وجهة',
    'account_per_tag'                           => 'حساب لكل وسم',
    'tag_report_expenses_listed_once'           => 'المصروفات والإيرادات لا يتم سردها مرتين. إذا كانت المعاملة تحتوي على وسوم متعددة، فقد تظهر فقط تحت أحد وسومها. قد يبدو أن هذه القائمة تفتقر إلى البيانات، ولكن المبالغ ستكون صحيحة.',
    'double_report_expenses_charted_once'       => 'المصروفات والإيرادات لا يتم عرضها مرتين. إذا كانت المعاملة تحتوي على وسوم متعددة، فقد تظهر فقط تحت أحد وسومها. قد يبدو أن هذا الرسم البياني يفتقر إلى البيانات، ولكن المبالغ ستكون صحيحة.',
    'tag_report_chart_single_tag'               => 'ينطبق هذا الرسم البياني على وسم واحد. إذا كانت المعاملة تحتوي على وسوم متعددة، فقد ينعكس ما تراه هنا في الرسوم البيانية لوسوم أخرى أيضًا.',
    'tag'                                       => 'وسم',
    'no_budget_squared'                         => '(لا يوجد ميزانية)',
    'perm-delete-many'                          => 'يمكن أن يكون حذف العديد من العناصر دفعة واحدة مزعجًا للغاية. يرجى توخي الحذر. يمكنك حذف جزء من معاملة مقسمة من هذه الصفحة، لذا كن حذرًا.',
    'mass_deleted_transactions_success'         => 'تم حذف :count معاملة.|تم حذف :count معاملات.',
    'mass_edited_transactions_success'          => 'تم تحديث :count معاملة.|تم تحديث :count معاملات.',
    'opt_group_'                                => '(لا يوجد نوع حساب)',
    'opt_group_no_account_type'                 => '(لا يوجد نوع حساب)',
    'opt_group_defaultAsset'                    => 'حسابات الأصول الافتراضية',
    'opt_group_savingAsset'                     => 'حسابات التوفير',
    'opt_group_sharedAsset'                     => 'حسابات الأصول المشتركة',
    'opt_group_ccAsset'                         => 'بطاقات الائتمان',
    'opt_group_cashWalletAsset'                 => 'محافظ النقود',
    'opt_group_expense_account'                 => 'حسابات المصروفات',
    'opt_group_revenue_account'                 => 'حسابات الإيرادات',
    'opt_group_l_Loan'                          => 'الالتزامات: قرض',
    'opt_group_cash_account'                    => 'حساب نقدي',
    'opt_group_l_Debt'                          => 'الخصوم: دين',
    'opt_group_l_Mortgage'                      => 'الخصوم: رهن عقاري',
    'opt_group_l_Credit card'                   => 'الخصوم: بطاقة ائتمان',
    'notes'                                     => 'ملاحظات',
    'view_notes'                                => 'عرض الملاحظات',
    'set_budget_limit_notes'                    => 'عرض الملاحظات لهذا المبلغ المخصص للميزانية',
    'edit_bl_notes'                             => 'تعديل الملاحظات',
    'update_bl_notes'                           => 'تحديث الملاحظات',
    'unknown_journal_error'                     => 'تعذر حفظ المعاملة. يرجى التحقق من ملفات السجل.',
    'attachment_not_found'                      => 'تعذر العثور على هذا المرفق.',
    'journal_link_bill'                         => 'هذه المعاملة مرتبطة بالاشتراك <a href=":route">:name</a>. لإزالة الربط، قم بإلغاء تحديد المربع. استخدم القواعد لربطها باشتراك آخر.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">المعاملة #{ID} ("{title}")</a> تم حفظها.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">المعاملة #{ID}</a> تم حفظها.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">المعاملة #{ID}</a> ("{title}") تم تحديثها.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">المعاملة #{ID}</a> ("{title}") لم تتغير.',
    'first_split_decides'                       => 'الجزء الأول يحدد قيمة هذا الحقل',
    'first_split_overrules_source'              => 'قد يتجاوز الجزء الأول حساب المصدر',
    'first_split_overrules_destination'         => 'قد يتجاوز الجزء الأول حساب الوجهة',
    'spent_x_of_y'                              => 'تم إنفاق {amount} من {total}',

    // new user:
    'welcome'                                   => 'مرحباً بك في Firefly III!',
    'submit'                                    => 'إرسال',
    'submission'                                => 'إرسال',
    'submit_yes_really'                         => 'إرسال (أعرف ما أفعل)',
    'getting_started'                           => 'البدء',
    'to_get_started'                            => 'من الجيد أن نرى أنك قمت بتثبيت Firefly III بنجاح. للبدء باستخدام هذه الأداة يرجى إدخال اسم البنك ورصيد حسابك الجاري الرئيسي. لا تقلق بعد إذا كان لديك حسابات متعددة. يمكنك إضافتها لاحقاً. إنه فقط أن Firefly III يحتاج شيئاً ليبدأ به.',
    'savings_balance_text'                      => 'سيقوم Firefly III بإنشاء حساب توفير لك تلقائياً. بشكل افتراضي، لن يكون هناك أموال في حساب التوفير، ولكن إذا أخبرت Firefly III بالرصيد فسيتم حفظه كذلك.',
    'finish_up_new_user'                        => 'هذا كل شيء! يمكنك المتابعة بالضغط على <strong>إرسال</strong>. ستنتقل إلى فهرس Firefly III.',
    'stored_new_accounts_new_user'              => 'رائع! تم حفظ حساباتك الجديدة.',
    'set_preferred_language'                    => 'إذا كنت تفضل استخدام Firefly III بلغة أخرى، يرجى الإشارة إلى ذلك هنا.',
    'language'                                  => 'اللغة',
    'new_savings_account'                       => 'حساب توفير :bank_name',
    'cash_wallet'                               => 'محفظة نقدية',
    'currency_not_present'                      => 'إذا لم تكن العملة التي تستخدمها عادةً مدرجة، لا تقلق. يمكنك إنشاء عملاتك الخاصة من خلال الخيارات > العملات.',

    // home page:
    'transaction_table_description'             => 'جدول يحتوي على معاملاتك',
    'opposing_account'                          => 'الحساب المقابل',
    'yourAccounts'                              => 'حساباتك',
    'your_accounts'                             => 'نظرة عامة على حساباتك',
    'category_overview'                         => 'نظرة عامة على الفئات',
    'expense_overview'                          => 'نظرة عامة على حسابات المصروفات',
    'revenue_overview'                          => 'نظرة عامة على حسابات الإيرادات',
    'budgetsAndSpending'                        => 'الميزانيات والإنفاق',
    'budgets_and_spending'                      => 'الميزانيات والإنفاق',
    'go_to_budget'                              => 'اذهب إلى الميزانية "{budget}"',
    'go_to_deposits'                            => 'اذهب إلى الإيداعات',
    'go_to_expenses'                            => 'اذهب إلى المصروفات',
    'savings'                                   => 'التوفير',
    'newWithdrawal'                             => 'مصروف جديد',
    'newDeposit'                                => 'إيداع جديد',
    'newTransfer'                               => 'تحويل جديد',
    'bills_to_pay'                              => 'اشتراكات يجب دفعها',
    'per_day'                                   => 'يوميًا',
    'left_to_spend_per_day'                     => 'المتبقي للإنفاق يوميًا',
    'bills_paid'                                => 'الاشتراكات المدفوعة',
    'custom_period'                             => 'فترة مخصصة',
    'reset_to_current'                          => 'إعادة التعيين للفترة الحالية',
    'select_period'                             => 'اختر فترة',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'العملة',
    'preferences'                               => 'الخيارات',
    'logout'                                    => 'تسجيل الخروج',
    'logout_other_sessions'                     => 'تسجيل الخروج من جميع الجلسات الأخرى',
    'toggleNavigation'                          => 'تبديل التنقل',
    'toggle_dropdown'                           => 'تبديل القائمة المنسدلة',
    'searchPlaceholder'                         => 'بحث...',
    'version'                                   => 'الإصدار',
    'dashboard'                                 => 'لوحة التحكم',
    'income_and_expense'                        => 'الدخل والنفقات',
    'all_money'                                 => 'جميع أموالك',
    'unknown_source_plain'                      => 'حساب مصدر غير معروف',
    'unknown_dest_plain'                        => 'حساب وجهة غير معروف',
    'unknown_any_plain'                         => 'حساب غير معروف',
    'unknown_budget_plain'                      => 'لا توجد ميزانية',
    'available_budget'                          => 'الميزانية المتاحة ({currency})',
    'currencies'                                => 'العملات',
    'activity'                                  => 'النشاط',
    'usage'                                     => 'الاستخدام',
    'accounts'                                  => 'الحسابات',
    'Asset account'                             => 'حساب الأصول',
    'Default account'                           => 'حساب الأصول',
    'Expense account'                           => 'حساب النفقات',
    'Revenue account'                           => 'حساب الإيرادات',
    'Initial balance account'                   => 'حساب الرصيد الافتتاحي',
    'account_type_Asset account'                => 'حساب الأصول',
    'account_type_Expense account'              => 'حساب النفقات',
    'account_type_Revenue account'              => 'حساب الإيرادات',
    'account_type_Debt'                         => 'دين',
    'account_type_Loan'                         => 'قرض',
    'account_type_Mortgage'                     => 'رهن عقاري',
    'account_type_debt'                         => 'دين',
    'account_type_loan'                         => 'قرض',
    'account_type_mortgage'                     => 'رهن عقاري',
    'account_type_Credit card'                  => 'بطاقة ائتمان',
    'credit_card_type_monthlyFull'              => 'دفع كامل كل شهر',
    'liability_direction_credit'                => 'أنا مدين بهذا الدين',
    'liability_direction_debit'                 => 'أدين بهذا الدين لشخص آخر',
    'liability_direction_credit_short'          => 'مدين بهذا الدين',
    'liability_direction_debit_short'           => 'أدين بهذا الدين',
    'liability_direction__short'                => 'غير معروف',
    'liability_direction_null_short'            => 'غير معروف',
    'Liability credit'                          => 'ائتمان الالتزام',
    'budgets'                                   => 'الميزانيات',
    'tags'                                      => 'الوسوم',
    'reports'                                   => 'التقارير',
    'transactions'                              => 'العمليات المالية',
    'expenses'                                  => 'النفقات',
    'income'                                    => 'الإيرادات / الدخل',
    'transfers'                                 => 'التحويلات',
    'moneyManagement'                           => 'إدارة الأموال',
    'money_management'                          => 'إدارة الأموال',
    'tools'                                     => 'الأدوات',
    'piggyBanks'                                => 'الحصالات',
    'piggy_banks'                               => 'الحصالات',
    'amount_x_of_y'                             => '{current} من {total}',
    'bills'                                     => 'الاشتراكات',
    'withdrawal'                                => 'سحب',
    'opening_balance'                           => 'الرصيد الافتتاحي',
    'deposit'                                   => 'إيداع',
    'account'                                   => 'حساب',
    'transfer'                                  => 'تحويل',
    'Withdrawal'                                => 'سحب',
    'Deposit'                                   => 'إيداع',
    'Transfer'                                  => 'تحويل',
    'bill'                                      => 'اشتراك',
    'yes'                                       => 'نعم',
    'no'                                        => 'لا',
    'amount'                                    => 'المبلغ',
    'overview'                                  => 'نظرة عامة',
    'saveOnAccount'                             => 'حفظ في الحساب',
    'saveOnAccounts'                            => 'حفظ في الحساب/الحسابات',
    'unknown'                                   => 'غير معروف',
    'monthly'                                   => 'شهرياً',
    'profile'                                   => 'الملف الشخصي',
    'errors'                                    => 'أخطاء',
    'debt_start_date'                           => 'تاريخ بداية الدين',
    'debt_start_amount'                         => 'مبلغ بداية الدين',
    'debt_start_amount_help'                    => 'من الأفضل دائمًا تعيين هذه القيمة إلى مبلغ سلبي. اقرأ صفحات المساعدة (أيقونة (?) في الأعلى يمين) لمزيد من المعلومات.',
    'interest_period_help'                      => 'هذا الحقل تجميلي فقط ولن يتم احتسابه لك. البنوك غالبًا ما تكون ماكرة، لذا Firefly III لا يصيبه دائمًا.',
    'store_new_liabilities_account'             => 'حفظ التزام جديد',
    'edit_liabilities_account'                  => 'تعديل الالتزام ":name"',
    'financial_control'                         => 'التحكم المالي',
    'accounting'                                => 'محاسبة',
    'automation'                                => 'أتمتة',
    'others'                                    => 'أخرى',
    'classification'                            => 'تصنيف',
    'store_transaction'                         => 'حفظ المعاملة',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'تقرير مالي افتراضي بين :start و :end',
    'report_audit'                              => 'نظرة عامة على سجل المعاملات بين :start و :end',
    'report_category'                           => 'تقرير الفئة بين :start و :end',
    'report_double'                             => 'تقرير حساب المصروفات/الإيرادات بين :start و :end',
    'report_budget'                             => 'تقرير الميزانية بين :start و :end',
    'report_tag'                                => 'تقرير الوسم بين :start و :end',
    'quick_link_reports'                        => 'روابط سريعة',
    'quick_link_examples'                       => 'هذه بعض الروابط النموذجية للبدء. راجع صفحات المساعدة تحت زر (?) لمعلومات عن جميع التقارير والكلمات السحرية التي يمكنك استخدامها.',
    'quick_link_default_report'                 => 'تقرير مالي افتراضي',
    'quick_link_audit_report'                   => 'نظرة عامة على سجل المعاملات',
    'report_this_month_quick'                   => 'الشهر الحالي، جميع الحسابات',
    'report_last_month_quick'                   => 'الشهر الماضي، جميع الحسابات',
    'report_this_year_quick'                    => 'السنة الحالية، جميع الحسابات',
    'report_this_fiscal_year_quick'             => 'السنة المالية الحالية، جميع الحسابات',
    'report_all_time_quick'                     => 'كل الوقت، جميع الحسابات',
    'reports_can_bookmark'                      => 'تذكر أنه يمكنك حفظ التقارير في المفضلة.',
    'incomeVsExpenses'                          => 'الدخل مقابل النفقات',
    'accountBalances'                           => 'أرصدة الحسابات',
    'balanceStart'                              => 'الرصيد في بداية الفترة',
    'balanceEnd'                                => 'الرصيد في نهاية الفترة',
    'splitByAccount'                            => 'تقسيم حسب الحساب',
    'coveredWithTags'                           => 'مغطى بالوسوم',
    'leftInBudget'                              => 'المتبقي في الميزانية',
    'left_in_debt'                              => 'المبلغ المستحق',
    'sumOfSums'                                 => 'مجموع المجاميع',
    'noCategory'                                => '(لا توجد فئة)',
    'notCharged'                                => 'لم يتم الخصم (بعد)',
    'inactive'                                  => 'غير نشط',
    'active'                                    => 'نشط',
    'difference'                                => 'الفرق',
    'money_flowing_in'                          => 'داخل',
    'money_flowing_out'                         => 'خارج',
    'topX'                                      => 'الأعلى :number',
    'show_full_list'                            => 'عرض القائمة الكاملة',
    'show_only_top'                             => 'عرض فقط الأعلى :number',
    'report_type'                               => 'نوع التقرير',
    'report_type_default'                       => 'نوع التقرير المالي الافتراضي',
    'report_type_audit'                         => 'نظرة عامة على سجل المعاملات (تدقيق)',
    'report_type_category'                      => 'تقرير الفئة',
    'report_type_budget'                        => 'تقرير الميزانية',
    'report_type_tag'                           => 'تقرير الوسم',
    'report_type_double'                        => 'تقرير حساب المصروفات/الإيرادات',
    'more_info_help'                            => 'يمكنك العثور على مزيد من المعلومات حول هذه الأنواع من التقارير في صفحات المساعدة. اضغط على أيقونة (?) في الزاوية اليمنى العليا.',
    'report_included_accounts'                  => 'الحسابات المضمنة',
    'report_date_range'                         => 'نطاق التواريخ',
    'report_preset_ranges'                      => 'نطاقات محددة مسبقًا',
    'shared'                                    => 'مشترك',
    'fiscal_year'                               => 'السنة المالية',
    'income_entry'                              => 'دخل من الحساب ":name" بين :start و :end',
    'expense_entry'                             => 'مصروفات إلى الحساب ":name" بين :start و :end',
    'category_entry'                            => 'المصروفات والدخل في الفئة ":name" بين :start و :end',
    'budget_spent_amount'                       => 'المصروفات في الميزانية ":budget" بين :start و :end',
    'balance_amount'                            => 'المصروفات في الميزانية ":budget" المدفوعة من الحساب ":account" بين :start و :end',
    'no_audit_activity'                         => 'لم يتم تسجيل أي نشاط على الحساب <a href=":url" title=":account_name">:account_name</a> بين :start و :end.',
    'audit_end_balance'                         => 'رصيد الحساب <a href=":url" title=":account_name">:account_name</a> في نهاية :end كان: :balance',
    'reports_extra_options'                     => 'خيارات إضافية',
    'report_has_no_extra_options'               => 'لا توجد خيارات إضافية لهذا التقرير',
    'reports_submit'                            => 'عرض التقرير',
    'end_after_start_date'                      => 'يجب أن يكون تاريخ نهاية التقرير بعد تاريخ البداية.',
    'select_category'                           => 'اختر الفئة/الفئات',
    'select_budget'                             => 'اختر الميزانية/الميزانيات.',
    'select_tag'                                => 'اختر الوسم/الوسوم.',
    'income_per_category'                       => 'الدخل لكل فئة',
    'expense_per_category'                      => 'المصروفات لكل فئة',
    'expense_per_budget'                        => 'المصروفات لكل ميزانية',
    'income_per_account'                        => 'الدخل لكل حساب',
    'expense_per_account'                       => 'المصروفات لكل حساب',
    'expense_per_tag'                           => 'المصروفات لكل وسم',
    'income_per_tag'                            => 'الدخل لكل وسم',
    'include_expense_not_in_budget'             => 'المصروفات المضمنة غير الموجودة في الميزانية/الميزانيات المحددة',
    'include_expense_not_in_account'            => 'المصروفات المضمنة غير الموجودة في الحساب/الحسابات المحددة',
    'include_expense_not_in_category'           => 'المصروفات المضمنة غير الموجودة في الفئة/الفئات المحددة',
    'include_income_not_in_category'            => 'الدخل المضمن غير الموجود في الفئة/الفئات المحددة',
    'include_income_not_in_account'             => 'الدخل المضمن غير الموجود في الحساب/الحسابات المحددة',
    'include_income_not_in_tags'                => 'الدخل المضمن غير الموجود في الوسم/الوسوم المحددة',
    'include_expense_not_in_tags'               => 'المصروفات المضمنة غير الموجودة في الوسم/الوسوم المحددة',
    'everything_else'                           => 'كل شيء آخر',
    'income_and_expenses'                       => 'الدخل والمصروفات',
    'spent_average'                             => 'متوسط الإنفاق',
    'income_average'                            => 'متوسط الدخل',
    'transaction_count'                         => 'عدد المعاملات',
    'average_spending_per_account'              => 'متوسط الإنفاق لكل حساب',
    'average_income_per_account'                => 'متوسط الدخل لكل حساب',
    'total'                                     => 'الإجمالي',
    'description'                               => 'الوصف',
    'sum_of_period'                             => 'مجموع الفترة',
    'average_in_period'                         => 'المتوسط في الفترة',
    'no_account_role'                           => '(بدون دور)',
    'account_role_defaultAsset'                 => 'حساب الأصول الافتراضي',
    'account_role_sharedAsset'                  => 'حساب الأصول المشترك',
    'account_role_savingAsset'                  => 'حساب التوفير',
    'account_role_ccAsset'                      => 'بطاقة ائتمان',
    'account_role_cashWalletAsset'              => 'محفظة نقدية',
    'budget_chart_click'                        => 'يرجى النقر على اسم الميزانية في الجدول أعلاه لرؤية الرسم البياني.',
    'category_chart_click'                      => 'يرجى النقر على اسم الفئة في الجدول أعلاه لرؤية الرسم البياني.',
    'in_out_accounts'                           => 'الدخل والمصروف لكل مجموعة',
    'in_out_accounts_per_asset'                 => 'الدخل والمصروف (لكل حساب أصول)',
    'in_out_per_category'                       => 'الدخل والمصروف لكل فئة',
    'out_per_budget'                            => 'المصروف لكل ميزانية',
    'select_expense_revenue'                    => 'اختر حساب المصروفات/الإيرادات',
    'multi_currency_report_sum'                 => 'نظرًا لأن هذه القائمة تحتوي على حسابات بعملات متعددة، قد لا يكون المجموع/المجاميع منطقية. سيعود التقرير دائمًا إلى عملتك الافتراضية.',
    'sum_in_default_currency'                   => 'سيكون المجموع دائمًا بعملتك الافتراضية.',
    'net_filtered_prefs'                        => 'لن يتضمن هذا الرسم البياني أبدًا الحسابات التي لم يتم تحديد خيار "تضمين في صافي الثروة" لها.',


    // charts:
    'chart'                                     => 'الرسم البياني',
    'month'                                     => 'شهر',
    'budget'                                    => 'ميزانية',
    'spent'                                     => 'تم إنفاقه',
    'spent_capped'                              => 'تم إنفاقه (محدد)',
    'spent_in_budget'                           => 'تم إنفاقه في الميزانية',
    'left_to_spend'                             => 'المتبقي للإنفاق',
    'earned'                                    => 'تم كسبه',
    'overspent'                                 => 'تم تجاوز الإنفاق',
    'left'                                      => 'المتبقي',
    'max-amount'                                => 'الحد الأقصى للمبلغ',
    'min-amount'                                => 'الحد الأدنى للمبلغ',
    'journal-amount'                            => 'إدخال الاشتراك الحالي',
    'name'                                      => 'الاسم',
    'expires_at'                                => 'تاريخ الانتهاء',
    'date'                                      => 'التاريخ',
    'date_and_time'                             => 'التاريخ والوقت',
    'time'                                      => 'الوقت',
    'paid'                                      => 'مدفوع',
    'unpaid'                                    => 'غير مدفوع',
    'day'                                       => 'يوم',
    'budgeted'                                  => 'مُدرج في الميزانية',
    'period'                                    => 'فترة',
    'balance'                                   => 'الرصيد',
    'in_out_period'                             => 'داخل + خارج هذه الفترة',
    'sum'                                       => 'المجموع',
    'summary'                                   => 'الملخص',
    'average'                                   => 'المتوسط',
    'balanceFor'                                => 'الرصيد لـ :name',
    'no_tags'                                   => '(لا توجد وسوم)',
    'nothing_found'                             => '(لا يوجد شيء)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'إعدادات الصفحة',
    'visible_columns'               => 'الأعمدة المرئية',
    'accounts_to_show'              => 'الحسابات المعروضة',
    'active_accounts_only'          => 'الحسابات النشطة فقط',
    'in_active_accounts_only'       => 'الحسابات غير النشطة فقط',
    'show_all_accounts'             => 'عرض جميع الحسابات',
    'group_accounts'                => 'تجميع الحسابات',

    // piggy banks:
    'event_history'                 => 'سجل الأحداث',
    'add_money_to_piggy'            => 'إضافة مال إلى الحصالة ":name"',
    'piggy_bank'                    => 'حصالة',
    'new_piggy_bank'                => 'حصالة جديدة',
    'store_piggy_bank'              => 'حفظ حصالة جديدة',
    'stored_piggy_bank'             => 'تم حفظ الحصالة الجديدة ":name"',
    'account_status'                => 'حالة الحساب',
    'left_for_piggy_banks'          => 'المتبقي للحصالات',
    'sum_of_piggy_banks'            => 'مجموع الحصالات',
    'saved_so_far'                  => 'تم ادخاره حتى الآن',
    'saved_so_far_total'            => 'تم ادخاره حتى الآن (إجمالي)',
    'reset_history'                 => 'إعادة تعيين السجل',
    'reset_history_confirm'         => 'هل أنت متأكد أنك تريد إعادة تعيين سجل هذه الحصالة؟ سيجعل ذلك الرسم البياني يطابق مبلغ الحصالة مرة أخرى.',
    'piggy_history_reset'           => 'تمت إعادة تعيين سجل الحصالة',
    'left_to_save'                  => 'المتبقي للادخار',
    'suggested_amount'              => 'المبلغ الشهري المقترح للادخار',
    'add_money_to_piggy_title'      => 'إضافة مال إلى الحصالة ":name"',
    'remove_money_from_piggy_title' => 'إزالة مال من الحصالة ":name"',
    'add'                           => 'إضافة',
    'no_money_for_piggy'            => 'ليس لديك مال لوضعه في هذه الحصالة.',
    'suggested_savings_per_month'   => 'مقترح شهريًا',

    'remove'                    => 'إزالة',
    'max_amount_add'            => 'أقصى مبلغ يمكنك إضافته هو',
    'max_amount_remove'         => 'أقصى مبلغ يمكنك إزالته هو',
    'update_piggy_button'       => 'تحديث الحصالة',
    'update_piggy_title'        => 'تحديث الحصالة ":name"',
    'updated_piggy_bank'        => 'تم تحديث الحصالة ":name"',
    'details'                   => 'تفاصيل',
    'events'                    => 'الأحداث',
    'target_amount'             => 'المبلغ المستهدف',
    'start_date'                => 'تاريخ البدء',
    'no_start_date'             => 'لا يوجد تاريخ بدء',
    'target_date'               => 'تاريخ الهدف',
    'no_target_date'            => 'لا يوجد تاريخ هدف',
    'table'                     => 'جدول',
    'delete_piggy_bank'         => 'حذف الحصالة ":name"',
    'cannot_add_amount_piggy'   => 'تعذر إضافة :amount إلى ":name".',
    'cannot_remove_from_piggy'  => 'تعذر إزالة :amount من ":name".',
    'deleted_piggy_bank'        => 'تم حذف الحصالة ":name"',
    'added_amount_to_piggy'     => 'تمت إضافة :amount إلى ":name"',
    'removed_amount_from_piggy' => 'تمت إزالة :amount من ":name"',
    'piggy_events'              => 'الحصالات ذات الصلة',

    // tags
    'delete_tag'                => 'حذف الوسم ":tag"',
    'deleted_tag'               => 'تم حذف الوسم ":tag"',
    'new_tag'                   => 'إنشاء وسم جديد',
    'edit_tag'                  => 'تعديل الوسم ":tag"',
    'updated_tag'               => 'تم تحديث الوسم ":tag"',
    'created_tag'               => 'تم إنشاء الوسم ":tag"!',

    'transaction_journal_information'               => 'معلومات المعاملة',
    'transaction_journal_amount'                    => 'معلومات المبلغ',
    'transaction_journal_meta'                      => 'معلومات التعريف',
    'transaction_journal_more'                      => 'معلومات إضافية',
    'basic_journal_information'                     => 'معلومات المعاملة الأساسية',
    'transaction_journal_extra'                     => 'معلومات إضافية',
    'att_part_of_journal'                           => 'مخزنة تحت ":journal"',
    'total_amount'                                  => 'إجمالي المبلغ',
    'number_of_decimals'                            => 'عدد الأرقام العشرية',


    // administration
    'invite_is_already_redeemed'                    => 'تم استخدام الدعوة إلى ":address" بالفعل.',
    'invite_is_deleted'                             => 'تم حذف الدعوة إلى ":address".',
    'invite_new_user_title'                         => 'دعوة مستخدم جديد',
    'invite_new_user_text'                          => 'بصفتك مسؤولاً، يمكنك دعوة المستخدمين للتسجيل في تثبيت Firefly III الخاص بك. باستخدام الرابط المباشر الذي يمكنك مشاركته معهم، سيتمكنون من تسجيل حساب. سيظهر المستخدم المدعو ورابط دعوته في الجدول أدناه. يمكنك مشاركة رابط الدعوة معهم بحرية.',
    'invited_user_mail'                             => 'عنوان البريد الإلكتروني',
    'invite_user'                                   => 'دعوة مستخدم',
    'user_is_invited'                               => 'تمت دعوة عنوان البريد الإلكتروني ":address" إلى Firefly III',
    'administration'                                => 'الإدارة',
    'system_settings'                               => 'إعدادات النظام',
    'code_already_used'                             => 'تم استخدام رمز الدعوة',
    'user_administration'                           => 'إدارة المستخدمين',
    'list_all_users'                                => 'جميع المستخدمين',
    'all_users'                                     => 'جميع المستخدمين',
    'instance_configuration'                        => 'الإعدادات',
    'firefly_instance_configuration'                => 'إعدادات Firefly III',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'وضع المستخدم الفردي',
    'setting_single_user_mode_explain'              => 'بشكل افتراضي، يقبل Firefly III تسجيل واحد (1): أنت. هذه تدبير أمني، يمنع الآخرين من استخدام مثيلك ما لم تسمح لهم بذلك. يتم حظر التسجيلات المستقبلية. عندما تقوم بإلغاء تحديد هذا المربع، يمكن للآخرين استخدام مثيلك أيضًا، بشرط أن يتمكنوا من الوصول إليه (عندما يكون متصلًا بالإنترنت).',
    'store_configuration'                           => 'إعدادات المتجر',
    'single_user_administration'                    => 'إدارة المستخدمين لـ :email',
    'edit_user'                                     => 'تعديل المستخدم :email',
    'hidden_fields_preferences'                     => 'يمكنك تمكين المزيد من خيارات المعاملات في <a href="preferences">التفضيلات</a> الخاصة بك.',
    'user_data_information'                         => 'بيانات المستخدم',
    'user_information'                              => 'معلومات المستخدم',
    'total_size'                                    => 'إجمالي الحجم',
    'budget_or_budgets'                             => ':count ميزانية|:count ميزانيات',
    'budgets_with_limits'                           => ':count ميزانية مع مبلغ محدد|:count ميزانيات مع مبلغ محدد',
    'nr_of_rules_in_total_groups'                   => ':count_rules قاعدة في :count_groups مجموعة قواعد',
    'tag_or_tags'                                   => ':count وسم|:count وسوم',
    'configuration_updated'                         => 'تم تحديث الإعدادات',
    'setting_is_demo_site'                          => 'موقع تجريبي',
    'setting_is_demo_site_explain'                  => 'إذا قمت بتحديد هذا المربع، ستتصرف هذه التثبيت كما لو كانت موقعًا تجريبيًا، مما قد يؤدي إلى آثار جانبية غريبة.',
    'block_code_bounced'                            => 'تمت إعادة رسالة البريد الإلكتروني',
    'block_code_expired'                            => 'انتهت صلاحية الحساب التجريبي',
    'no_block_code'                                 => 'لا سبب للحظر أو المستخدم غير محظور',
    'demo_user_export'                              => 'لا يمكن للمستخدم التجريبي تصدير البيانات',
    'block_code_email_changed'                      => 'لم يؤكد المستخدم بعد عنوان البريد الإلكتروني الجديد',
    'admin_update_email'                            => 'على عكس صفحة الملف الشخصي، لن يتم إخطار المستخدم بتغيير عنوان بريده الإلكتروني!',
    'update_user'                                   => 'تحديث المستخدم',
    'updated_user'                                  => 'تم تغيير بيانات المستخدم.',
    'delete_user'                                   => 'حذف المستخدم :email',
    'user_deleted'                                  => 'تم حذف المستخدم',
    'send_test_email'                               => 'إرسال رسالة بريد إلكتروني تجريبية',
    'send_test_email_text'                          => 'للتحقق مما إذا كانت التثبيت الخاص بك قادرًا على إرسال إشعار، يرجى الضغط على هذا الزر. لن ترى خطأ هنا (إن وجد)، <strong>ستعكس ملفات السجل أي أخطاء</strong>. يمكنك الضغط على هذا الزر عدة مرات كما تريد. لا يوجد تحكم في الرسائل غير المرغوب فيها. ستُرسل الرسالة إلى <code>:email</code> ويجب أن تصل قريبًا.',
    'send_message'                                  => 'إرسال رسالة',
    'send_test_triggered'                           => 'تم تفعيل الاختبار. تحقق من صندوق الوارد وملفات السجل.',
    'give_admin_careful'                            => 'يمكن للمستخدمين الذين يتم منحهم حقوق المسؤول سحب حقوقك. كن حذرًا.',
    'admin_maintanance_title'                       => 'الصيانة',
    'admin_maintanance_expl'                        => 'بعض الأزرار المفيدة لصيانة Firefly III',
    'admin_maintenance_clear_cache'                 => 'مسح الذاكرة المؤقتة',
    'owner_notifications'                           => 'إشعارات المسؤول',
    'owner_notifications_expl'                      => 'يمكن تمكين أو تعطيل الإشعارات التالية بواسطة المسؤول. سيتم إرسالها عبر جميع القنوات المكونة. يتم تكوين بعض القنوات في متغيرات البيئة الخاصة بك، بينما يمكن تعيين الأخرى هنا.',
    'channel_settings'                              => 'إعدادات قنوات الإشعارات',
    'notification_test_failed'                      => 'فشل اختبار الإشعار للقناة ":channel". ستحتوي السجلات على مزيد من التفاصيل.',
    'notification_test_executed'                    => 'تم تنفيذ اختبار الإشعار للقناة ":channel". تحقق من السجلات الخاصة بك للحصول على التفاصيل.',
    'settings_notifications'                        => 'إعدادات الإشعارات',
    'title_owner_notifications'                     => 'إشعارات المسؤول',
    'owner_notification_check_user_new_reg'         => 'يتلقى المستخدم رسالة ترحيب بعد التسجيل',
    'owner_notification_check_admin_new_reg'        => 'يتلقى المسؤول (المسؤولون) إشعار تسجيل مستخدم جديد',
    'owner_notification_check_new_version'          => 'يتوفر إصدار جديد',
    'owner_notification_check_invite_created'       => 'تمت دعوة مستخدم إلى Firefly III',
    'owner_notification_check_invite_redeemed'      => 'تم استرداد دعوة المستخدم',
    'owner_notification_check_unknown_user_attempt' => 'يحاول مستخدم غير معروف تسجيل الدخول',
    'all_invited_users'                             => 'جميع المستخدمين المدعوين',
    'save_notification_settings'                    => 'حفظ الإعدادات',
    'notification_settings'                         => 'إعدادات الإشعارات',
    'notification_settings_saved'                   => 'تم حفظ إعدادات الإشعارات',
    'available_channels_title'                      => 'القنوات المتاحة',
    'available_channels_expl'                       => 'هذه القنوات متاحة لإرسال الإشعارات. لاختبار التكوين الخاص بك، استخدم الأزرار أدناه. يرجى ملاحظة أن الأزرار لا تحتوي على تحكم في الرسائل غير المرغوب فيها.',
    'notification_channel_name_email'               => 'البريد الإلكتروني',
    'slack_discord_double'                          => 'يمكن لقناة إشعارات Slack أيضًا إرسال إشعارات إلى Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'غير متاح',
    'configure_channel_in_env'                      => 'يحتاج إلى متغيرات البيئة',
    'test_notification_channel_name_email'          => 'اختبار البريد الإلكتروني',
    'test_notification_channel_name_slack'          => 'اختبار Slack',
    'test_notification_channel_name_ntfy'           => 'اختبار Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'اختبار Pushover',
    'test_notification_channel_name_gotify'         => 'اختبار Gotify',
    'test_notification_channel_name_pushbullet'     => 'اختبار Pushbullet',

    'split_transaction_title'               => 'وصف المعاملة المنقسمة',
    'split_transaction_title_help'          => 'إذا قمت بإنشاء معاملة منقسمة، يجب أن يكون هناك وصف عالمي لجميع انقسامات المعاملة.',
    'split_title_help'                      => 'إذا قمت بإنشاء معاملة منقسمة، يجب أن يكون هناك وصف عالمي لجميع انقسامات المعاملة.',
    'you_create_transfer'                   => 'أنت تقوم بإنشاء تحويل.',
    'you_create_withdrawal'                 => 'أنت تقوم بإنشاء سحب.',
    'you_create_deposit'                    => 'أنت تقوم بإنشاء إيداع.',

    // links
    'journal_link_configuration'            => 'تكوين روابط المعاملات',
    'create_new_link_type'                  => 'إنشاء نوع رابط جديد',
    'store_new_link_type'                   => 'تخزين نوع رابط جديد',
    'update_link_type'                      => 'تحديث نوع الرابط',
    'edit_link_type'                        => 'تحرير نوع الرابط ":name"',
    'updated_link_type'                     => 'تم تحديث نوع الرابط ":name"',
    'delete_link_type'                      => 'حذف نوع الرابط ":name"',
    'deleted_link_type'                     => 'تم حذف نوع الرابط ":name"',
    'stored_new_link_type'                  => 'تخزين نوع رابط جديد ":name"',
    'cannot_edit_link_type'                 => 'لا يمكن تحرير نوع الرابط ":name"',
    'link_type_help_name'                   => 'مثل. "التكرارات"',
    'link_type_help_inward'                 => 'مثل. "التكرارات"',
    'link_type_help_outward'                => 'مثل. "يتم تكراره بواسطة"',
    'save_connections_by_moving'            => 'احفظ الرابط بين هذه المعاملات عن طريق نقلها إلى نوع رابط آخر:',
    'do_not_save_connection'                => '(لا تحفظ الاتصال)',
    'link_transaction'                      => 'ربط المعاملة',
    'link_to_other_transaction'             => 'ربط هذه المعاملة بمعاملة أخرى',
    'select_transaction_to_link'            => 'حدد معاملة لربط هذه المعاملة بها. الروابط غير مستخدمة حاليًا في Firefly III (بخلاف عرضها)، لكنني أخطط لتغيير ذلك في المستقبل. استخدم مربع البحث لتحديد معاملة إما بعنوانها أو برقم التعريف الخاص بها. إذا كنت ترغب في إضافة أنواع روابط مخصصة، تحقق من الإعدادات.',
    'this_transaction'                      => 'هذه المعاملة',
    'transaction'                           => 'معاملة',
    'comments'                              => 'تعليقات',
    'link_notes'                            => 'أي ملاحظات ترغب في تخزينها مع الرابط.',
    'invalid_link_selection'                => 'لا يمكن ربط هذه المعاملات',
    'selected_transaction'                  => 'المعاملة المحددة',
    'journals_linked'                       => 'تم ربط المعاملات.',
    'journals_error_linked'                 => 'تم ربط هذه المعاملات بالفعل.',
    'journals_link_to_self'                 => 'لا يمكنك ربط معاملة بنفسها',
    'journal_links'                         => 'روابط المعاملات',
    'this_withdrawal'                       => 'هذه السحب',
    'this_deposit'                          => 'هذه الإيداع',
    'this_transfer'                         => 'هذه التحويل',
    'overview_for_link'                     => 'نظرة عامة على نوع الرابط ":name"',
    'source_transaction'                    => 'معاملة المصدر',
    'link_description'                      => 'وصف الرابط',
    'destination_transaction'               => 'معاملة الوجهة',
    'delete_journal_link'                   => 'حذف الرابط بين <a href=":source_link">:source</a> و <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'تم حذف الرابط',

    // link translations:
    'Paid_name'                             => 'مدفوع',
    'Refund_name'                           => 'استرداد',
    'Reimbursement_name'                    => 'تعويض',
    'Related_name'                          => 'متعلق',
    'relates to_inward'                     => 'يتعلق بـ',
    'is (partially) refunded by_inward'     => 'تم (جزئيًا) استرداده بواسطة',
    'is (partially) paid for by_inward'     => 'تم (جزئيًا) دفعه بواسطة',
    'is (partially) reimbursed by_inward'   => 'تم (جزئيًا) تعويضه بواسطة',
    'inward_transaction'                    => 'معاملة واردة',
    'outward_transaction'                   => 'معاملة صادرة',
    'relates to_outward'                    => 'يتعلق بـ',
    '(partially) refunds_outward'           => '(جزئيًا) استرداد',
    '(partially) pays for_outward'          => '(جزئيًا) دفع',
    '(partially) reimburses_outward'        => '(جزئيًا) تعويض',
    'is (partially) refunded by'            => 'تم (جزئيًا) استرداده بواسطة',
    'is (partially) paid for by'            => 'تم (جزئيًا) دفعه بواسطة',
    'is (partially) reimbursed by'          => 'تم (جزئيًا) تعويضه بواسطة',
    'relates to'                            => 'يتعلق بـ',
    '(partially) refunds'                   => '(جزئيًا) استرداد',
    '(partially) pays for'                  => '(جزئيًا) دفع',
    '(partially) reimburses'                => '(جزئيًا) تعويض',

    // split a transaction:
    'splits'                                => 'تقسيم',
    'add_another_split'                     => 'إضافة تقسيم آخر',
    'cannot_edit_opening_balance'           => 'لا يمكنك تعديل الرصيد الافتتاحي لحساب.',
    'no_edit_multiple_left'                 => 'لم تقم بتحديد أي معاملات صالحة للتعديل.',
    'breadcrumb_convert_group'              => 'تحويل المعاملة',
    'convert_invalid_source'                => 'معلومات المصدر غير صالحة للمعاملة #%d.',
    'convert_invalid_destination'           => 'معلومات الوجهة غير صالحة للمعاملة #%d.',
    'create_another'                        => 'بعد التخزين، عد إلى هنا لإنشاء واحدة أخرى.',
    'after_update_create_another'           => 'بعد التحديث، عد إلى هنا لمتابعة التحرير.',
    'store_as_new'                          => 'تخزين كمعاملة جديدة بدلاً من التحديث.',
    'reset_after'                           => 'إعادة تعيين النموذج بعد الإرسال',
    'errors_submission'                     => 'كان هناك خطأ ما في تقديمك. يرجى التحقق من الأخطاء أدناه.',
    'errors_submission_v2'                  => 'كان هناك خطأ ما في تقديمك. يرجى التحقق من الأخطاء أدناه: {{errorMessage}}',
    'transaction_expand_split'              => 'توسيع التقسيم',
    'transaction_remove_split'              => 'إزالة التقسيم',
    'transaction_collapse_split'            => 'طي التقسيم',

    // object groups
    'default_group_title_name'              => '(غير مجمع)',
    'default_group_title_name_plain'        => 'غير مجمع',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'لننشئ حساب أصول!',
    'no_accounts_intro_asset'               => 'ليس لديك أي حسابات أصول حتى الآن. حسابات الأصول هي حساباتك الرئيسية: حسابك الجاري، حساب التوفير، الحساب المشترك أو حتى بطاقة الائتمان الخاصة بك.',
    'no_accounts_imperative_asset'          => 'للبدء في استخدام Firefly III، يجب عليك إنشاء حساب أصول واحد على الأقل. دعنا نفعل ذلك الآن:',
    'no_accounts_create_asset'              => 'إنشاء حساب أصول',
    'no_accounts_title_expense'             => 'لننشئ حساب مصاريف!',
    'no_accounts_intro_expense'             => 'ليس لديك أي حسابات مصاريف حتى الآن. حسابات المصاريف هي الأماكن التي تنفق فيها المال، مثل المتاجر والسوبرماركت.',
    'no_accounts_imperative_expense'        => 'تُنشأ حسابات المصاريف تلقائيًا عند إنشاء المعاملات، ولكن يمكنك إنشاء واحدة يدويًا أيضًا، إذا كنت ترغب في ذلك. دعنا ننشئ واحدة الآن:',
    'no_accounts_create_expense'            => 'إنشاء حساب مصاريف',
    'no_accounts_title_revenue'             => 'لننشئ حساب إيرادات!',
    'no_accounts_intro_revenue'             => 'ليس لديك أي حسابات إيرادات حتى الآن. حسابات الإيرادات هي الأماكن التي تتلقى منها المال، مثل صاحب العمل الخاص بك.',
    'no_accounts_imperative_revenue'        => 'تُنشأ حسابات الإيرادات تلقائيًا عند إنشاء المعاملات، ولكن يمكنك إنشاء واحدة يدويًا أيضًا، إذا كنت ترغب في ذلك. دعنا ننشئ واحدة الآن:',
    'no_accounts_create_revenue'            => 'إنشاء حساب إيرادات',
    'no_accounts_title_liabilities'         => 'لننشئ حساب التزامات!',
    'no_accounts_intro_liabilities'         => 'ليس لديك أي التزامات حتى الآن. الالتزامات هي الحسابات التي تسجل قروضك (الطلابية) والديون الأخرى.',
    'no_accounts_imperative_liabilities'    => 'لا يتعين عليك استخدام هذه الميزة، ولكن يمكن أن تكون مفيدة إذا كنت ترغب في تتبع هذه الأمور.',
    'no_accounts_create_liabilities'        => 'إنشاء حساب التزامات',
    'no_budgets_title_default'              => 'لننشئ ميزانية!',
    'no_rules_title_default'                => 'لننشئ قاعدة!',
    'no_budgets_intro_default'              => 'ليس لديك أي ميزانيات حتى الآن. تُستخدم الميزانيات لتنظيم مصاريفك في مجموعات منطقية، يمكنك إعطاؤها حدًا أقصى ناعمًا لتقييد مصاريفك.',
    'no_rules_intro_default'                => 'ليس لديك أي قواعد حتى الآن. القواعد هي أتمتة قوية يمكنها التعامل مع المعاملات نيابةً عنك.',
    'no_rules_imperative_default'           => 'يمكن أن تكون القواعد مفيدة جدًا عند إدارة المعاملات. دعنا ننشئ واحدة الآن:',
    'no_budgets_imperative_default'         => 'الميزانيات هي الأدوات الأساسية للإدارة المالية. دعنا ننشئ واحدة الآن:',
    'no_budgets_create_default'             => 'إنشاء ميزانية',
    'no_rules_create_default'               => 'إنشاء قاعدة',
    'no_categories_title_default'           => 'لننشئ فئة!',
    'no_categories_intro_default'           => 'ليس لديك أي فئات حتى الآن. تُستخدم الفئات لضبط معاملاتك بدقة ووضع علامة عليها بالفئة المخصصة لها.',
    'no_categories_imperative_default'      => 'تُنشأ الفئات تلقائيًا عند إنشاء المعاملات، ولكن يمكنك إنشاء واحدة يدويًا أيضًا. دعنا ننشئ واحدة الآن:',
    'no_categories_create_default'          => 'إنشاء فئة',
    'no_tags_title_default'                 => 'لننشئ علامة!',
    'no_tags_intro_default'                 => 'ليس لديك أي علامات حتى الآن. تُستخدم العلامات لضبط معاملاتك بدقة ووضع علامة عليها بالكلمات الرئيسية المحددة.',
    'no_tags_imperative_default'            => 'تُنشأ العلامات تلقائيًا عند إنشاء المعاملات، ولكن يمكنك إنشاء واحدة يدويًا أيضًا. دعنا ننشئ واحدة الآن:',
    'no_tags_create_default'                => 'إنشاء علامة',
    'no_transactions_title_withdrawal'      => 'لننشئ مصروفًا!',
    'no_transactions_intro_withdrawal'      => 'ليس لديك أي مصروفات حتى الآن. يجب عليك إنشاء مصروفات لبدء إدارة أموالك.',
    'no_transactions_imperative_withdrawal' => 'هل أنفقت بعض المال؟ إذن يجب عليك تدوينه:',
    'no_transactions_create_withdrawal'     => 'إنشاء مصروف',
    'no_transactions_title_deposit'         => 'لننشئ بعض الدخل!',
    'no_transactions_intro_deposit'         => 'ليس لديك أي دخل مسجل حتى الآن. يجب عليك إنشاء إدخالات دخل لبدء إدارة أموالك.',
    'no_transactions_imperative_deposit'    => 'هل تلقيت بعض المال؟ إذن يجب عليك تدوينه:',
    'no_transactions_create_deposit'        => 'إنشاء إيداع',
    'no_transactions_title_transfers'       => 'لننشئ تحويلًا!',
    'no_transactions_intro_transfers'       => 'ليس لديك أي تحويلات حتى الآن. عندما تقوم بنقل الأموال بين حسابات الأصول، يتم تسجيلها كتحويل.',
    'no_transactions_imperative_transfers'  => 'هل قمت بنقل بعض الأموال؟ إذن يجب عليك تدوينه:',
    'no_transactions_create_transfers'      => 'إنشاء تحويل',
    'no_piggies_title_default'              => 'لننشئ حصالة!',
    'no_piggies_intro_default'              => 'ليس لديك أي حصالات حتى الآن. يمكنك إنشاء حصالات لتقسيم مدخراتك وتتبع ما تدخره.',
    'no_piggies_imperative_default'         => 'هل لديك أشياء تدخر من أجلها؟ أنشئ حصالة وتتبع:',
    'no_piggies_create_default'             => 'إنشاء حصالة جديدة',
    'no_bills_title_default'                => 'لننشئ اشتراكًا!',
    'no_bills_intro_default'                => 'ليس لديك أي اشتراكات حتى الآن. يمكنك إنشاء اشتراكات لتتبع النفقات المنتظمة، مثل الإيجار أو التأمين.',
    'no_bills_imperative_default'           => 'هل لديك مثل هذه الاشتراكات المنتظمة؟ أنشئ اشتراكًا وتابع مدفوعاتك:',
    'no_bills_create_default'               => 'إنشاء اشتراك',

    // recurring transactions
    'recurrence_max_count'                  => 'هذا المعاملة المتكررة ستُنشأ بحد أقصى :max مرة(مرات)، وقد تم إنشاؤها :count مرة(مرات) بالفعل.',
    'create_right_now'                      => 'إنشاء الآن',
    'no_new_transaction_in_recurrence'      => 'لم يتم إنشاء أي معاملة جديدة. ربما تم تنفيذها بالفعل في هذا التاريخ؟',
    'recurrences'                           => 'المعاملات المتكررة',
    'repeat_until_in_past'                  => 'توقفت هذه المعاملة المتكررة عن التكرار في :date.',
    'recurring_calendar_view'               => 'التقويم',
    'no_recurring_title_default'            => 'لننشئ معاملة متكررة!',
    'no_recurring_intro_default'            => 'ليس لديك أي معاملات متكررة حتى الآن. يمكنك استخدام هذه الميزة لجعل Firefly III ينشئ معاملات تلقائيًا لك.',
    'no_recurring_imperative_default'       => 'هذه ميزة متقدمة إلى حد ما ولكنها يمكن أن تكون مفيدة للغاية. تأكد من قراءة الوثائق (رمز الاستفهام ?) في الزاوية العلوية اليمنى قبل المتابعة.',
    'no_recurring_create_default'           => 'إنشاء معاملة متكررة',
    'make_new_recurring'                    => 'إنشاء معاملة متكررة',
    'recurring_daily'                       => 'كل يوم',
    'recurring_weekly'                      => 'كل أسبوع في :weekday',
    'recurring_weekly_skip'                 => 'كل :skip أسبوع في :weekday',
    'recurring_monthly'                     => 'كل شهر في اليوم :dayOfMonth',
    'recurring_monthly_skip'                => 'كل :skip شهر في اليوم :dayOfMonth',
    'recurring_ndom'                        => 'كل شهر في اليوم :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'كل عام في :date',
    'overview_for_recurrence'               => 'نظرة عامة على المعاملة المتكررة ":title"',
    'warning_duplicates_repetitions'        => 'في حالات نادرة، تظهر التواريخ مرتين في هذه القائمة. يمكن أن يحدث هذا عندما تتداخل تكرارات متعددة. سيقوم Firefly III دائمًا بإنشاء معاملة واحدة لكل يوم.',
    'created_transactions'                  => 'المعاملات ذات الصلة',
    'expected_withdrawals'                  => 'السحوبات المتوقعة',
    'expected_deposits'                     => 'الودائع المتوقعة',
    'expected_transfers'                    => 'التحويلات المتوقعة',
    'created_withdrawals'                   => 'السحوبات التي تم إنشاؤها',
    'created_deposits'                      => 'الودائع التي تم إنشاؤها',
    'created_transfers'                     => 'التحويلات التي تم إنشاؤها',
    'recurring_info'                        => 'المعاملة المتكررة :count / :total',
    'created_from_recurrence'               => 'تم إنشاؤه من المعاملة المتكررة ":title" (#:id)',
    'recurring_never_cron'                  => 'يبدو أن وظيفة cron اللازمة لدعم المعاملات المتكررة لم تعمل أبدًا. هذا بالطبع أمر طبيعي عندما تقوم بتثبيت Firefly III للتو، ولكن يجب أن يكون هذا شيئًا يجب إعداده في أقرب وقت ممكن. يرجى الاطلاع على صفحات المساعدة باستخدام أيقونة (?) في الزاوية العلوية اليمنى من الصفحة.',
    'recurring_cron_long_ago'               => 'يبدو أنه قد مر أكثر من 36 ساعة منذ أن تم تشغيل وظيفة cron لدعم المعاملات المتكررة آخر مرة. هل أنت متأكد من أنه تم إعدادها بشكل صحيح؟ يرجى الاطلاع على صفحات المساعدة باستخدام أيقونة (?) في الزاوية العلوية اليمنى من الصفحة.',

    'create_new_recurrence'              => 'إنشاء معاملة متكررة جديدة',
    'help_first_date'                    => 'حدد أول تكرار متوقع. يجب أن يكون هذا في المستقبل.',
    'help_first_date_no_past'            => 'حدد أول تكرار متوقع. لن يقوم Firefly III بإنشاء معاملات في الماضي.',
    'no_currency'                        => '(لا عملة)',
    'mandatory_for_recurring'            => 'معلومات التكرار الإلزامية',
    'mandatory_for_transaction'          => 'معلومات المعاملة الإلزامية',
    'optional_for_recurring'             => 'معلومات التكرار الاختيارية',
    'optional_for_transaction'           => 'معلومات المعاملة الاختيارية',
    'change_date_other_options'          => 'قم بتغيير "التاريخ الأول" لرؤية المزيد من الخيارات.',
    'mandatory_fields_for_tranaction'    => 'القيم الموجودة هنا ستُدرج في المعاملة أو المعاملات التي سيتم إنشاؤها.',
    'click_for_calendar'                 => 'انقر هنا لعرض تقويم يوضح لك متى ستتكرر المعاملة.',
    'repeat_forever'                     => 'تكرار إلى الأبد',
    'repeat_until_date'                  => 'تكرار حتى تاريخ',
    'repeat_times'                       => 'تكرار عدد من المرات',
    'recurring_skips_one'                => 'كل أخرى',
    'recurring_skips_more'               => 'يتخطى :count حدوث',
    'store_new_recurrence'               => 'تخزين معاملة متكررة',
    'stored_new_recurrence'              => 'تم تخزين المعاملة المتكررة ":title" بنجاح.',
    'edit_recurrence'                    => 'تعديل المعاملة المتكررة ":title"',
    'recurring_repeats_until'            => 'يتكرر حتى :date',
    'recurring_repeats_forever'          => 'يتكرر إلى الأبد',
    'recurring_repeats_x_times'          => 'يتكرر :count مرة|يتكرر :count مرات',
    'update_recurrence'                  => 'تحديث المعاملة المتكررة',
    'updated_recurrence'                 => 'تم تحديث المعاملة المتكررة ":title"',
    'recurrence_is_inactive'             => 'هذه المعاملة المتكررة غير نشطة ولن تولد معاملات جديدة.',
    'delete_recurring'                   => 'حذف المعاملة المتكررة ":title"',
    'new_recurring_transaction'          => 'معاملة متكررة جديدة',
    'help_weekend'                       => 'ماذا يجب أن تفعل Firefly III عندما تقع المعاملة المتكررة في يوم السبت أو الأحد؟',
    'do_nothing'                         => 'فقط قم بإنشاء المعاملة',
    'skip_transaction'                   => 'تخطي الحدث',
    'jump_to_friday'                     => 'إنشاء المعاملة يوم الجمعة السابقة بدلاً من ذلك',
    'jump_to_monday'                     => 'إنشاء المعاملة يوم الاثنين التالي بدلاً من ذلك',
    'will_jump_friday'                   => 'سيتم إنشاؤه يوم الجمعة بدلاً من عطلة نهاية الأسبوع.',
    'will_jump_monday'                   => 'سيتم إنشاؤه يوم الاثنين بدلاً من عطلة نهاية الأسبوع.',
    'except_weekends'                    => 'باستثناء عطلات نهاية الأسبوع',
    'recurrence_deleted'                 => 'تم حذف المعاملة المتكررة ":title"',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'الرصيد (:currency)',
    'box_spent_in_currency'              => 'المصروفات (:currency)',
    'box_earned_in_currency'             => 'الإيرادات (:currency)',
    'box_budgeted_in_currency'           => 'الموازنة (:currency)',
    'box_bill_paid_in_currency'          => 'الاشتراكات المدفوعة (:currency)',
    'box_bill_unpaid_in_currency'        => 'الاشتراكات غير المدفوعة (:currency)',
    'box_left_to_spend_in_currency'      => 'المتبقي للإنفاق (:currency)',
    'box_net_worth_in_currency'          => 'صافي الثروة (:currency)',
    'box_spend_per_day'                  => 'المتبقي للإنفاق يومياً: :amount',

    // debug page
    'debug_page'                         => 'صفحة التصحيح',
    'debug_submit_instructions'          => 'إذا واجهت مشاكل، يمكنك استخدام المعلومات في هذا المربع كمعلومات تصحيح. يرجى نسخها ولصقها في <a href="https://github.com/firefly-iii/firefly-iii/issues">بلاغ جديد أو قائم على GitHub</a>. ستُولّد جدولًا جميلًا يمكن استخدامه لتشخيص مشكلتك بسرعة.',
    'debug_pretty_table'                 => 'إذا قمت بنسخ/لصق المربع أدناه في مشكلة GitHub، فسيتم إنشاء جدول. يرجى عدم إحاطة هذا النص بعلامات الاقتباس أو الاقتباسات.',
    'debug_additional_data'              => 'يمكنك أيضًا مشاركة محتوى المربع أدناه. يمكنك أيضًا نسخه ولصقه في مشكلة جديدة أو قائمة <a href="https://github.com/firefly-iii/firefly-iii/issues">على GitHub</a>. ومع ذلك، قد يحتوي محتوى هذا المربع على معلومات خاصة مثل أسماء الحسابات أو تفاصيل المعاملات أو عناوين البريد الإلكتروني.',

    // object groups
    'object_groups_menu_bar'             => 'المجموعات',
    'object_groups_page_title'           => 'المجموعات',
    'object_groups_breadcrumb'           => 'المجموعات',
    'object_groups_index'                => 'نظرة عامة',
    'object_groups'                      => 'المجموعات',
    'object_groups_empty_explain'        => 'يمكن تقسيم بعض الأشياء في Firefly III إلى مجموعات. على سبيل المثال، تحتوي البنوك المدخرة على حقل "المجموعة" في شاشات التحرير والإنشاء. عند تعيين هذا الحقل، يمكنك تعديل أسماء وترتيب المجموعات في هذه الصفحة. لمزيد من المعلومات، تحقق من صفحات المساعدة في الزاوية العلوية اليمنى، تحت أيقونة (?).',
    'object_group_title'                 => 'العنوان',
    'edit_object_group'                  => 'تعديل المجموعة ":title"',
    'delete_object_group'                => 'حذف المجموعة ":title"',
    'update_object_group'                => 'تحديث المجموعة',
    'updated_object_group'               => 'تم تحديث المجموعة ":title" بنجاح',
    'deleted_object_group'               => 'تم حذف المجموعة ":title" بنجاح',
    'object_group'                       => 'المجموعة',

    // other stuff
    'placeholder'                        => '[نص بديل]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'سجلات التدقيق',
    'ale_action_log_add'                 => 'تمت إضافة :amount إلى البنك المدخر ":name"',
    'ale_action_log_remove'              => 'تمت إزالة :amount من البنك المدخر ":name"',
    'ale_action_clear_budget'            => 'تمت إزالته من الميزانية',
    'ale_action_update_group_title'      => 'تم تحديث عنوان مجموعة المعاملة',
    'ale_action_update_date'             => 'تم تحديث تاريخ المعاملة',
    'ale_action_update_order'            => 'تم تحديث ترتيب المعاملة',
    'ale_action_clear_category'          => 'تمت إزالته من الفئة',
    'ale_action_clear_notes'             => 'تمت إزالة الملاحظات',
    'ale_action_clear_tag'               => 'تمت إزالة العلامة',
    'ale_action_clear_all_tags'          => 'تمت إزالة جميع العلامات',
    'ale_action_set_bill'                => 'تم ربطه بالاشتراك',
    'ale_action_switch_accounts'         => 'تم تبديل حساب المصدر وحساب الوجهة',
    'ale_action_set_budget'              => 'تعيين الميزانية',
    'ale_action_set_category'            => 'تعيين الفئة',
    'ale_action_set_source'              => 'تعيين حساب المصدر',
    'ale_action_set_destination'         => 'تعيين حساب الوجهة',
    'ale_action_update_transaction_type' => 'تغيير نوع المعاملة',
    'ale_action_update_notes'            => 'تغيير الملاحظات',
    'ale_action_update_description'      => 'تغيير الوصف',
    'ale_action_add_to_piggy'            => 'إضافة إلى البنك المدخر',
    'ale_action_remove_from_piggy'       => 'إزالة من البنك المدخر',
    'ale_action_add_tag'                 => 'إضافة علامة',
    'ale_action_update_amount'           => 'تحديث المبلغ',

    // dashboard
    'enable_auto_convert'                => 'تفعيل تحويل العملات',
    'disable_auto_convert'               => 'تعطيل تحويل العملات',
];
