<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Κλείσιμο',
    'actions'                                   => 'Ενέργειες',
    'edit'                                      => 'Επεξεργασία',
    'loading'                                   => 'Φόρτωση',
    'transaction_journal_id'                    => 'Αναγνωριστικό ημερολογίου συναλλαγών',
    'delete'                                    => 'Διαγραφή',
    'split'                                     => 'Διαχωρισμός',
    'single_split'                              => 'Διαχωρισμός',
    'clone'                                     => 'Κλωνοποίηση',
    'clone_and_edit'                            => 'Κλωνοποίηση και επεξεργασία',
    'confirm_action'                            => 'Επιβεβαίωση ενέργειας',
    'last_seven_days'                           => 'Τελευταίες επτά ημέρες',
    'last_thirty_days'                          => 'Τελευταίες τριάντα ημέρες',
    'last_180_days'                             => 'Τελευταίες 180 ημέρες',
    'month_to_date'                             => 'Μήνας μέχρι σήμερα',
    'year_to_date'                              => 'Έτος μέχρι σήμερα',
    'previous_year' => 'Προηγούμενο έτος (:year)',
    'YTD'                                       => 'ΤΡΕΧΟΝ ΕΤΟΣ',
    'welcome_back'                              => 'Τι παίζει;',
    'main_dashboard_page_title'                 => 'Αρχική',
    'everything'                                => 'Όλα',
    'today'                                     => 'σήμερα',
    'customRange'                               => 'Προσαρμοσμένο εύρος',
    'date_range'                                => 'Ημερολογιακό Εύρος',
    'apply'                                     => 'Εφαρμογή',
    'select_date'                               => 'Επιλογή ημερομηνίας..',
    'cancel'                                    => 'Άκυρο',
    'from'                                      => 'Από',
    'to'                                        => 'Προς',
    'structure'                                 => 'Δομή',
    'help_translating'                          => 'Αυτό το βοηθητικό κείμενο δεν είναι ακόμη διαθέσιμο στη γλώσσα σας.<a href="https://crowdin.com/project/firefly-iii-help">Θα βοηθήσετε στη μετάφραση;</a>',
    'showEverything'                            => 'Εμφάνιση όλων',
    'never'                                     => 'Ποτέ',
    'no_results_for_empty_search'               => 'Η αναζήτησή σας ήταν κενή, οπότε δε βρέθηκε τίποτα.',
    'removed_amount'                            => 'Αφαιρέθηκαν :amount',
    'added_amount'                              => 'Προστέθηκαν :amount',
    'asset_account_role_help'                   => 'Όποιες επιπλέον επιλογές προκύψουν από την προτίμησή σας μπορούν να ρυθμιστούν αργότερα.',
    'Opening balance'                           => 'Υπόλοιπο έναρξης',
    'create_new_stuff'                          => 'Νέα καταχώρηση',
    'new_withdrawal'                            => 'Νέα ανάληψη',
    'create_new_transaction'                    => 'Δημιουργία μιας νέας συναλλαγής',
    'sidebar_frontpage_create'                  => 'Δημιουργία',
    'new_transaction'                           => 'Νέα συναλλαγή',
    'no_rules_for_bill'                         => 'Αυτή η συνδρομή δεν έχει σχετιζόμενους κανόνες.',
    'go_to_asset_accounts'                      => 'Δείτε τους λογαριασμούς κεφαλαίου σας',
    'go_to_budgets'                             => 'Πηγαίνετε στους προϋπολογισμούς σας',
    'go_to_withdrawals'                         => 'Πηγαίνετε στις αναλήψεις σας',
    'clones_journal_x'                          => 'Αυτή η συναλλαγή είναι ένας κλώνος του ":description" (#:id)',
    'go_to_categories'                          => 'Πηγαίνετε στις κατηγορίες σας',
    'go_to_bills'                               => 'Μεταβείτε στις συνδρομές σας',
    'go_to_expense_accounts'                    => 'Δείτε τους λογαριασμούς δαπανών σας',
    'go_to_revenue_accounts'                    => 'Δείτε τους λογαριασμούς εσόδων σας',
    'go_to_piggies'                             => 'Πηγαίνετε στους κουμπαράδες σας',
    'new_deposit'                               => 'Νέα κατάθεση',
    'new_transfer'                              => 'Νέα μεταφορά',
    'new_transfers'                             => 'Νέα μεταφορά',
    'new_asset_account'                         => 'Νέος λογαριασμός κεφαλαίου',
    'new_expense_account'                       => 'Νέος λογαριασμός δαπανών',
    'new_revenue_account'                       => 'Νέος λογαριασμός εσόδων',
    'new_liabilities_account'                   => 'Νέα υποχρέωση',
    'new_budget'                                => 'Νέος προϋπολογισμός',
    'new_bill'                                  => 'Νέα συνδρομή',
    'block_account_logout'                      => 'Έχετε αποσυνδεθεί. Οι αποκλεισμένοι λογαριασμοί δεν μπορούν να χρησιμοποιήσουν αυτό τον ιστότοπο. Κάνατε εγγραφή με έγκυρο email;',
    'flash_success'                             => 'Επιτυχία!',
    'flash_info'                                => 'Μήνυμα',
    'flash_warning'                             => 'Προσοχή!',
    'flash_error'                               => 'Σφάλμα!',
    'flash_danger'                              => 'Κίνδυνος!',
    'flash_info_multiple'                       => 'Υπάρχει ένα μήνυμα|Υπάρχουν :count μηνύματα',
    'flash_error_multiple'                      => 'Υπάρχει ένα σφάλμα|Υπάρχουν :count σφάλματα',
    'net_worth'                                 => 'Καθαρή αξία',
    'help_for_this_page'                        => 'Βοήθεια για αυτή τη σελίδα',
    'help_for_this_page_body'                   => 'Μπορείτε να βρείτε περισσότερες πληροφορίες σχετικά με αυτή τη σελίδα <a href="https://docs.firefly-iii.org/">στην τεκμηρίωση</a>.',
    'two_factor_welcome'                        => 'Γειά!',
    'two_factor_enter_code'                     => 'Για να συνεχίσετε, παρακαλώ εισάγετε τον κωδικό επαλήθευσης δύο παραγόντων. Η εφαρμογή σας θα δημιουργήσει έναν για εσάς.',
    'two_factor_code_here'                      => 'Εισάγετε τον κωδικό εδώ',
    'two_factor_title'                          => 'Έλεγχος ταυτότητας δύο παραγόντων',
    'authenticate'                              => 'Ταυτοποίηση',
    'two_factor_forgot_title'                   => 'Απώλεια ταυτοποίησης δύο παραγόντων',
    'two_factor_forgot'                         => 'Ξέχασα τον παράγοντα ταυτοποίησης.',
    'two_factor_lost_header'                    => 'Χάσατε την ταυτότητα δύο παραγόντων;',
    'two_factor_lost_intro'                     => 'Εάν χάσατε τους εφεδρικούς κωδικούς σας επίσης, είστε άτυχοι. Αυτό δε μπορεί να διορθωθεί απευθείας. Έχετε δύο επιλογές.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Ειδάλλως, στείλτε email στον ιδιοκτήτη του ιστότοπου, <a href="mailto::site_owner">:site_owner</a> και ζητήστε να σας επαναφέρει την ταυτότητα δύο παραγόντων.',
    'mfa_backup_code'                           => 'Έχετε χρησιμοποιήσει ένα εφεδρικό κωδικό για να συνδεθείτε στο Firefly III. Δε μπορεί να χρησιμοποιηθεί ξανά, οπότε διαγράψτε το από τη λίστα σας.',
    'pref_two_factor_new_backup_codes'          => 'Λάβετε νέους εφεδρικούς κωδικούς',
    'pref_two_factor_backup_code_count'         => 'Έχετε :count έγκυρο εφεδρικό κωδικό.|Έχετε :count έγκυρους εφεδρικούς κωδικούς.',
    '2fa_i_have_them'                           => 'Τους αποθήκευσα!',
    'warning_much_data'                         => ':days ημέρες δεδομένων θα καθυστερήσουν λιγάκι να φορτώσουν.',
    'registered'                                => 'Έχετε εγγραφεί επιτυχώς!',
    'Default asset account'                     => 'Βασικός λογαριασμός κεφαλαίου',
    'no_budget_pointer'                         => 'Φαίνεται πως δεν έχετε ορίσει προϋπολογισμούς ακόμη. Πρέπει να δημιουργήσετε κάποιον στη σελίδα <a href="budgets">προϋπολογισμών</a>. Οι προϋπολογισμοί σας βοηθούν να επιβλέπετε τις δαπάνες σας.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Λογαριασμός αποταμίευσης',
    'Credit card'                               => 'Πιστωτική κάρτα',
    'source_accounts'                           => 'Λογαριασμός προέλευσης|Λογαριασμοί προέλευσης',
    'destination_accounts'                      => 'Λογαριασμός προορισμού|Λογαριασμοί προορισμού',
    'user_id_is'                                => 'Το αναγνωριστικό Id χρήστη είναι <strong>:user</strong>',
    'field_supports_markdown'                   => 'Αυτό το πεδίο υποστηρίζει <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Εάν χρειάζεστε περαιτέρω βοήθεια σχετικά με τη χρήση του Firefly III, παρακαλώ <a href="https://github.com/firefly-iii/firefly-iii/issues">ανοίξτε ένα ticket στο Github</a>.',
    'reenable_intro_text'                       => 'Μπορείτε επίσης να ενεργοποιήσετε και πάλι <a href="#" id="reenableGuidance">τον εισαγωγικό οδηγό</a>.',
    'intro_boxes_after_refresh'                 => 'Τα πλαίσια εισαγωγής θα επανεμφανιστούν όταν ανανεώσετε τη σελίδα.',
    'show_all_no_filter'                        => 'Εμφάνιση όλων των συναλλαγών χωρίς την ομαδοποίηση ανά ημερομηνία.',
    'expenses_by_category'                      => 'Δαπάνες ανά κατηγορία',
    'expenses_by_budget'                        => 'Δαπάνες ανά προϋπολογισμό',
    'income_by_category'                        => 'Έσοδα ανά κατηγορία',
    'expenses_by_asset_account'                 => 'Δαπάνες ανά αποταμιευτικό λογαριασμό',
    'expenses_by_expense_account'               => 'Δαπάνες ανά λογαριασμό προορισμού',
    'cannot_redirect_to_account'                => 'Το Firefly III δεν μπορεί να σας ανακατευθύνει στη σωστή σελίδα. Συγγνώμη.',
    'sum_of_expenses'                           => 'Σύνολο δαπανών',
    'sum_of_income'                             => 'Σύνολο εσόδων',
    'liabilities'                               => 'Υποχρεώσεις',
    'spent_in_specific_budget'                  => 'Δαπάνες στον προϋπολογισμό ":budget"',
    'spent_in_specific_double'                  => 'Δαπάνες στο λογαριασμό ":account"',
    'earned_in_specific_double'                 => 'Κέρδη στο λογαριασμό ":account"',
    'source_account'                            => 'Λογαριασμός προέλευσης',
    'source_account_reconciliation'             => 'Δεν μπορείτε να τροποποιήσετε τον λογαριασμό προέλευσης σε μια συναλλαγή τακτοποίησης.',
    'destination_account'                       => 'Λογαριασμός προορισμού',
    'destination_account_reconciliation'        => 'Δεν μπορείτε να τροποποιήσετε τον λογαριασμό προορισμού σε μια συναλλαγή τακτοποίησης.',
    'sum_of_expenses_in_budget'                 => 'Σύνολο δαπανών στον προϋπολογισμό ":budget"',
    'left_in_budget_limit'                      => 'Απομένουν για δαπάνες σύμφωνα με τον προϋπολογισμό',
    'current_period'                            => 'Τρέχουσα περίοδος',
    'show_the_current_period_and_overview'      => 'Εμφάνιση της τρέχουσας περιόδου και σύνοψη',
    'pref_anonymous' => 'Αποκρυμμένα ποσά',
    'pref_anonymous_help' => 'Για λόγους ιδιωτικότητας και ανωνυμίας, μπορείτε να ρυθμίσετε το Firefly III ώστε να αποκρύπτει όλα τα ποσά. Τα ποσά σε πλαίσια επεξεργασίας θα είναι ορατά, αλλά τα υπόλοιπα θα είναι κρυφά. Μπορείτε επίσης να το (απ)ενεργοποιήσετε αυτό με το μικρό εικονίδιο «ματιού» στην επάνω γραμμή.',
    'pref_anonymous_label' => 'Απόκρυψη ποσών',
    'pref_languages_locale'                     => 'Για να λειτουργήσει σωστά μια γλώσσα διαφορετική των Αγγλικών, το λειτουργικό σας σύστημα πρέπει να διαθέτει τις σωστές πληροφορίες τοποθεσίας (locale). Εάν αυτές δεν είναι σωστές τότε τα δεδομένα νομισμάτων, οι ημερομηνίες και τα ποσά μπορεί να έχουν λάθος μορφοποίηση.',
    'budget_in_period'                          => 'Όλες οι συναλλαγές του προϋπολογισμού ":name" μεταξύ :start και :end σε :currency',
    'chart_budget_in_period'                    => 'Διάγραμμα όλων των συναλλαγών του προϋπολογισμού ":name" μεταξύ :start και :end σε :currency',
    'chart_budget_in_period_only_currency'      => 'Το ποσό που προϋπολογίσατε ήταν σε :currency, έτσι αυτό το διάγραμμα δείχνει συναλλαγές μόνο σε :currency.',
    'chart_account_in_period'                   => 'Διάγραμμα όλων των συναλλαγών του λογαριασμού ":name" (:balance) μεταξύ :start και :end',
    'chart_category_in_period'                  => 'Διάγραμμα για όλες τις συναλλαγές της κατηγορίας ":name" μεταξύ :start και :end',
    'chart_category_all'                        => 'Διάγραμμα για όλες τις συναλλαγές της κατηγορίας ":name"',
    'clone_withdrawal'                          => 'Κλωνοποίηση αυτής της ανάληψης',
    'clone_deposit'                             => 'Κλωνοποίηση αυτής της κατάθεσης',
    'clone_transfer'                            => 'Κλωνοποίηση αυτής της μεταφοράς',
    'multi_select_no_selection'                 => 'Δεν επιλέχθηκε τίποτα',
    'multi_select_select_all'                   => 'Επιλογή όλων',
    'multi_select_n_selected'                   => 'επιλεγμένο(α)',
    'multi_select_all_selected'                 => 'Επιλέχθηκαν όλα',
    'multi_select_filter_placeholder'           => 'Εύρεση..',
    'intro_next_label'                          => 'Επόμενο',
    'intro_prev_label'                          => 'Προηγούμενο',
    'intro_skip_label'                          => 'Παράλειψη',
    'intro_done_label'                          => 'Ολοκληρώθηκε',
    'between_dates_breadcrumb'                  => 'Μεταξύ :start και :end',
    'all_journals_without_budget'               => 'Όλες οι συναλλαγές εκτός κάποιου προϋπολογισμού',
    'journals_without_budget'                   => 'Συναλλαγές εκτός κάποιου προϋπολογισμού',
    'all_journals_without_category'             => 'Όλες οι συναλλαγές χωρίς κατηγορία',
    'journals_without_category'                 => 'Συναλλαγές χωρίς κατηγορία',
    'all_journals_for_account'                  => 'Όλες οι συναλλαγές του λογαριασμού :name',
    'chart_all_journals_for_account'            => 'Διάγραμμα όλων των συναλλαγών του λογαριασμού :name',
    'journals_in_period_for_account'            => 'Όλες οι συναλλαγές του λογαριασμού :name μεταξύ :start και :end',
    'journals_in_period_for_account_js'         => 'Όλες οι συναλλαγές για τον λογαριασμό {title} μεταξύ {start} και {end}',
    'transferred'                               => 'Μεταφέρθηκαν',
    'all_withdrawal'                            => 'Όλες οι δαπάνες',
    'all_transactions'                          => 'Όλες οι συναλλαγές',
    'title_withdrawal_between'                  => 'Όλες οι δαπάνες μεταξύ :start και :end',
    'all_deposit'                               => 'Όλα τα έσοδα',
    'title_deposit_between'                     => 'Όλα τα έσοδα μεταξύ :start και :end',
    'all_transfers'                             => 'Όλες οι μεταφορές',
    'title_transfers_between'                   => 'Όλες οι μεταφορές μεταξύ :start και :end',
    'all_transfer'                              => 'Όλες οι μεταφορές',
    'all_journals_for_tag'                      => 'Όλες οι συναλλαγές με ετικέτα ":tag"',
    'title_transfer_between'                    => 'Όλες οι μεταφορές μεταξύ :start και :end',
    'all_journals_for_category'                 => 'Όλες οι συναλλαγές της κατηγορίας :name',
    'all_journals_for_budget'                   => 'Όλες οι συναλλαγές του προϋπολογισμού :name',
    'chart_all_journals_for_budget'             => 'Διάγραμμα όλων των συναλλαγών του προϋπολογισμού :name',
    'journals_in_period_for_category'           => 'Όλες οι συναλλαγές της κατηγορίας :name μεταξύ :start και :end',
    'journals_in_period_for_tag'                => 'Όλες οι συναλλαγές με ετικέτα :tag μεταξύ :start και :end',
    'not_available_demo_user'                   => 'Το χαρακτηριστικό στο οποίο προσπαθείτε να αποκτήσετε πρόσβαση δεν είναι διαθέσιμο σε χρήστες επίδειξης.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Ο κεφαλαιακός λογαριασμός προέλευσης "@source_name" δέχεται συναλλαγές μόνο σε @source_currency. Ο κεφαλαιακός λογαριασμός προορισμού "@dest_name" δέχεται συναλλαγές μόνο σε @dest_currency. Πρέπει να παρέχετε το σωστό μεταφερόμενο ποσό και στα δύο νομίσματα.',
    'transaction_data'                          => 'Δεδομένα συναλλαγής',
    'invalid_server_configuration'              => 'Μη έγκυρη παραμετροποίηση εξυπηρετητή',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Εναλλαγή',
    'sign_in_to_start'                          => 'Συνδεθείτε για να ξεκινήσετε τη συνεδρία σας',
    'sign_in'                                   => 'Είσοδος',
    'register_new_account'                      => 'Εγγραφή νέου λογαριασμού',
    'forgot_my_password'                        => 'Ξέχασα τον κωδικό μου',
    'problems_with_input'                       => 'Παρουσιάστηκαν κάποια προβλήματα με την εισαγωγή σας.',
    'reset_password'                            => 'Επαναφέρετε τον κωδικό σας',
    'button_reset_password'                     => 'Επαναφορά κωδικού πρόσβασης',
    'reset_button'                              => 'Επαναφορά',
    'want_to_login'                             => 'Θέλω να συνδεθώ',
    'login_page_title'                          => 'Σύνδεση στο Firefly III',
    'register_page_title'                       => 'Εγγραφή στο Firefly III',
    'forgot_pw_page_title'                      => 'Ξεχάσατε τον κωδικό πρόσβασης για το Firefly III',
    'reset_pw_page_title'                       => 'Επαναφέρετε τον κωδικό πρόσβασης για το Firefly III',
    'cannot_reset_demo_user'                    => 'Δε μπορείτε να επαναφέρετε τον κωδικό πρόσβασης του χρήστη επίδειξης.',
    'no_att_demo_user'                          => 'Ο χρήστης επίδειξης δε μπορεί να ανεβάσει συνημμένα.',
    'button_register'                           => 'Εγγραφή',
    'authorization'                             => 'Εξουσιοδότηση',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Αναμενόμενο ημερήσιο κόστος',
    'per_period_sum_1W'                         => 'Αναμενόμενο εβδομαδιαίο κόστος',
    'per_period_sum_1M'                         => 'Αναμενόμενο μηνιαίο κόστος',
    'per_period_sum_3M'                         => 'Αναμενόμενο τριμηνιαίο κόστος',
    'per_period_sum_6M'                         => 'Αναμενόμενο εξαμηνιαίο κόστος',
    'per_period_sum_1Y'                         => 'Αναμενόμενο ετήσιο κόστος',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'αναμενόμενο σύνολο',
    'reconciliation_account_name'               => ':name τακτοποίηση (:currency)',
    'saved'                                     => 'Αποθηκεύτηκε',
    'advanced_options'                          => 'Επιλογές για προχωρημένους',
    'advanced_options_explain'                  => 'Μερικές σελίδες στο Firefly III έχουν κρυμμένες επιλογές για προχωρημένους πίσω από αυτό το κουμπί. Αυτή η σελίδα δεν έχει τίποτα ουσιαστικό εδώ, αλλά ελέγξτε τις υπόλοιπες!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Το Firefly III διαπίστωσε ότι έχετε συναλλαγές πριν από το έτος 1970. Παρακαλώ διορθώστε αυτές τις συναλλαγές το συντομότερο δυνατό.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'απενεργοποιημένο',
    'no_webhook_messages'                       => 'Δεν υπάρχουν μηνύματα webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Μετά τη δημιουργία συναλλαγής',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Μετά την ενημέρωση της συναλλαγής',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Μετά τη διαγραφή συναλλαγής',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Λεπτομέρειες συναλλαγής',
    'webhook_response_ACCOUNTS'                 => 'Πληροφορίες λογαριασμού',
    'webhook_response_BUDGET'                   => 'Λεπτομέρειες προϋπολογισμού',
    'webhook_response_RELEVANT'                 => 'Σχετικές λεπτομέρειες',
    'webhook_response_NONE'                     => 'Δεν υπάρχουν λεπτομέρειες',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Έλεγχος',
    'create_new_webhook'                        => 'Δημιουργία νέου webhook',
    'webhooks_create_breadcrumb'                => 'Δημιουργία νέου webhook',
    'webhook_trigger_form_help'                 => 'Επιλέξτε που θα ενεργοποιηθεί το webhook',
    'webhook_response_form_help'                => 'Υποδείξτε τι πρέπει να υποβάλει το webhook στη διεύθυνση URL.',
    'webhook_delivery_form_help'                => 'Ποια μορφή πρέπει να παραδώσει δεδομένα στο webhook.',
    'webhook_active_form_help'                  => 'Το webhook πρέπει να είναι ενεργό αλλιώς δεν θα κληθεί.',
    'stored_new_webhook'                        => 'Αποθηκευμένο νέο webhook ":title"',
    'delete_webhook'                            => 'Διαγραφή webhook',
    'deleted_webhook'                           => 'Διαγραμμένο webhook ":title"',
    'edit_webhook'                              => 'Επεξεργασία webhook ":title"',
    'updated_webhook'                           => 'Ενημερωμένο webhook ":title"',
    'edit_webhook_js'                           => 'Επεξεργασία webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Το webhook ενεργοποιήθηκε στην επιλεγμένη συναλλαγή. Παρακαλώ περιμένετε να εμφανιστούν τα αποτελέσματα.',
    'webhook_messages'                          => 'Μήνυμα Webhook',
    'view_message'                              => 'Προβολή μηνύματος',
    'view_attempts'                             => 'Προβολή αποτυχημένων προσπαθειών',
    'message_content_title'                     => 'Περιεχόμενο μηνύματος Webhook',
    'message_content_help'                      => 'Αυτό είναι το περιεχόμενο του μηνύματος που στάλθηκε (ή δοκιμάστηκε) χρησιμοποιώντας αυτό το webhook.',
    'attempt_content_title'                     => 'Προσπάθειες Webhook',
    'attempt_content_help'                      => 'Αυτές είναι όλες οι ανεπιτυχείς προσπάθειες αυτού του μηνύματος webhook για υποβολή στην ρυθμισμένη διεύθυνση URL. Μετά από κάποιο χρονικό διάστημα, το Firefly III θα σταματήσει να προσπαθεί.',
    'no_attempts'                               => 'Δεν υπάρχουν ανεπιτυχείς προσπάθειες. Αυτό είναι καλό!',
    'webhook_attempt_at'                        => 'Προσπάθεια στο {moment}',
    'logs'                                      => 'Αρχεία καταγραφής (Logs)',
    'response'                                  => 'Απόκριση',
    'visit_webhook_url'                         => 'Επισκεφθείτε το URL του webhook',
    'reset_webhook_secret'                      => 'Επαναφορά μυστικού webhook',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> έχει αποθηκευτεί.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Το Webhook #{ID}</a> ("{title}") έχει ενημερωθεί.',

    // API access
    'authorization_request'                     => 'Αίτημα Εξουσιοδότησης Firefly III v:version',
    'authorization_request_intro'               => 'Η εφαρμογή "<strong>:client</strong>" ζητά άδεια πρόσβασης στην οικονομική σας διαχείριση. Θέλετε να εξουσιοδοτήσετε το <strong>:client</strong> να έχει πρόσβαση σε αυτές τις εγγραφές;',
    'authorization_request_site'                => 'Θα ανακατευθυνθείτε στο <code>:url</code> το οποίο στη συνέχεια θα έχει πρόσβαση στα δεδομένα σας Firefly III.',
    'authorization_request_invalid'             => 'Αυτό το αίτημα πρόσβασης δεν είναι έγκυρο. Παρακαλώ μην ακολουθήσετε ποτέ ξανά αυτόν τον σύνδεσμο.',
    'scopes_will_be_able'                       => 'Αυτή η εφαρμογή θα είναι σε θέση να:',
    'button_authorize'                          => 'Εξουσιοδότηση',
    'none_in_select_list'                       => '(τίποτα)',
    'no_piggy_bank'                             => '(χωρίς κουμπαρά)',
    'name_in_currency'                          => ':name σε :currency',
    'paid_in_currency'                          => 'Πληρώθηκε σε :currency',
    'unpaid_in_currency'                        => 'Απλήρωτο σε :currency',
    'is_alpha_warning'                          => 'Εκτελείτε μια προ-έκδοση ALPHA. Να είστε έτοιμοι να εντοπίσετε σφάλματα και άλλα ζητήματα.',
    'is_beta_warning'                           => 'Εκτελείτε μια δοκιμαστική έκδοση BETA. Να είστε έτοιμοι να εντοπίσετε σφάλματα και άλλα ζητήματα.',
    'all_destination_accounts'                  => 'Λογαριασμοί προορισμού',
    'all_source_accounts'                       => 'Λογαριασμοί προέλευσης',
    'back_to_index'                             => 'Επιστροφή στο ευρετήριο',
    'cant_logout_guard'                         => 'Το Firefly III δε μπορεί να σας αποσυνδέσει.',
    'internal_reference'                        => 'Εσωτερική αναφορά',

    // check for updates:
    'update_check_title'                        => 'Έλεγχος ενημερώσεων',
    'admin_update_check_title'                  => 'Αυτόματος έλεγχος ενημερώσεων',
    'admin_update_check_explain'                => 'Το Firefly III μπορεί να ελέγξει αυτόματα για ενημερώσεις. Όταν ενεργοποιήσετε αυτή τη ρύθμιση, θα επικοινωνεί με τον διακομιστή ενημέρωσης του Firefly III για να διαπιστώσει εάν είναι διαθέσιμη μια νέα έκδοση για να λάβετε μια ειδοποίηση. Μπορείτε να δοκιμάσετε αυτή την ειδοποίηση πατώντας το κουμπί στα δεξιά. Υποδείξτε παρακάτω εάν θέλετε το Firefly III να ελέγχει για ενημερώσεις.',
    'check_for_updates_permission'              => 'Το Firefly III μπορεί να ελέγχει για ενημερώσεις, αλλά χρειάζεται την άδειά σας για αυτό. Παρακαλώ πηγαίνετε στις <a href=":link">ρυθμίσεις</a> για να υποδείξετε εάν θέλετε να ενεργοποιηθεί αυτό το χαρακτηριστικό.',
    'updates_ask_me_later'                      => 'Να ερωτηθώ αργότερα',
    'updates_do_not_check'                      => 'Να μη γίνεται έλεγχος για ενημερώσεις',
    'updates_enable_check'                      => 'Ενεργοποίηση του ελέγχου ενημερώσεων',
    'admin_update_check_now_title'              => 'Έλεγχος για ενημερώσεις τώρα',
    'admin_update_check_now_explain'            => 'Εάν πατήσετε αυτό του κουμπί, το Firefly III θα ελέγξει εάν έχετε την τελευταία έκδοση.',
    'check_for_updates_button'                  => 'Έλεγχος τώρα!',
    'update_new_version_alert'                  => 'Μία νέα έκδοση του Firefly III είναι διαθέσιμη. Έχετε την v:your_version, ενώ η τελευταία έκδοση είναι η v:new_version που κυκλοφόρησε στις :date.',
    'update_version_beta'                       => 'Αυτή είναι μια BETA δοκιμαστική έκδοση. Μπορεί να συναντήσετε προβλήματα.',
    'update_version_alpha'                      => 'Αυτή είναι μια ALPHA δοκιμαστική έκδοση. Μπορεί να συναντήσετε προβλήματα.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Έχετε την έκδοση v:version, που είναι η τελευταία διαθέσιμη.',
    'update_newer_version_alert'                => 'Έχετε την έκδοση v:your_version, που είναι νεότερη από την τελευταία έκδοση, v:new_version.',
    'update_check_error'                        => 'Παρουσιάστηκε σφάλμα κατά τον έλεγχο για ενημερώσεις: :error',
    'unknown_error'                             => 'Άγνωστο σφάλμα. Μας συγχωρείτε γι αυτό.',
    'disabled_but_check'                        => 'Απενεργοποιήσατε τον έλεγχο ενημερώσεων. Επομένως, μην ξεχάσετε να ελέγχετε μόνος σας για τυχόν ενημερώσεις. Ευχαριστώ!',
    'admin_update_channel_title'                => 'Κανάλι ενημερώσεων',
    'admin_update_channel_explain'              => 'Το Firefly III έχει τρία "κανάλια" ενημερώσεων που καθορίζουν πόσο μπροστά είστε σε θέματα χαρακτηριστικών, βελτιστοποιήσεων και σφαλμάτων. Χρησιμοποιήστε το "beta" κανάλι εάν είστε τολμηροί και το "alpha" εάν είστε ριψοκίνδυνοι.',
    'update_channel_stable'                     => 'Σταθερή. Όλα λειτουργούν όπως προβλέπονται.',
    'update_channel_beta'                       => 'Beta. Νέα χαρακτηριστικά αλλά κάποια πράγματα μπορεί να μη λειτουργούν.',
    'update_channel_alpha'                      => 'Alpha. Δοκιμάζουμε πράγματα, και χρησιμοποιούμε αυτά που λειτουργούν.',

    // search
    'search'                                    => 'Αναζήτηση',
    'search_query'                              => 'Ερώτημα',
    'search_found_transactions'                 => 'Το Firefly III βρήκε :count συναλλαγή σε :time δευτερόλεπτα.|Το Firefly III βρήκε :count συναλλαγές σε :time δευτερόλεπτα.',
    'search_found_more_transactions'            => 'Το Firefly III βρήκε περισσότερες από :count συναλλαγές σε :time δευτερόλεπτα.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Αυτές οι παράμετροι αναζήτησης δεν είναι έγκυρες και έχουν αγνοηθεί.',

    // old


    'search_modifier_date_on'                             => 'Η ημερομηνία συναλλαγής είναι ":value"',
    'search_modifier_not_date_on'                         => 'Η ημερομηνία συναλλαγής δεν είναι ":value"',
    'search_modifier_reconciled'                          => 'Η συναλλαγή είναι τακτοποιημένη',
    'search_modifier_not_reconciled'                      => 'Η συναλλαγή δεν έχει τακτοποιηθεί',
    'search_modifier_id'                                  => 'Το ID συναλλαγής είναι ":value"',
    'search_modifier_not_id'                              => 'Το ID συναλλαγής δεν είναι ":value"',
    'search_modifier_date_before'                         => 'Η ημερομηνία συναλλαγής είναι πριν ή στις ":value"',
    'search_modifier_date_after'                          => 'Η ημερομηνία συναλλαγής είναι μετά ή στις ":value"',
    'search_modifier_external_id_is'                      => 'Το Εξωτερικό ID είναι ":value"',
    'search_modifier_not_external_id_is'                  => 'Το εξωτερικό ID δεν είναι ":value"',
    'search_modifier_no_external_url'                     => 'Η συναλλαγή δεν έχει εξωτερικό URL',
    'search_modifier_no_external_id'                      => 'Η συναλλαγή δεν έχει εξωτερικό ID',
    'search_modifier_not_any_external_url'                => 'Η συναλλαγή δεν έχει εξωτερικό URL',
    'search_modifier_not_any_external_id'                 => 'Η συναλλαγή δεν έχει εξωτερικό ID',
    'search_modifier_any_external_url'                    => 'Η συναλλαγή πρέπει να έχει ένα (οποιοδήποτε) εξωτερικό URL',
    'search_modifier_any_external_id'                     => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) εξωτερικό ID',
    'search_modifier_not_no_external_url'                 => 'Η συναλλαγή πρέπει να έχει ένα (οποιοδήποτε) εξωτερικό URL',
    'search_modifier_not_no_external_id'                  => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) εξωτερικό ID',
    'search_modifier_internal_reference_is'               => 'Η εσωτερική αναφορά είναι ":value"',
    'search_modifier_not_internal_reference_is'           => 'Η εσωτερική αναφορά δεν είναι ":value"',
    'search_modifier_description_starts'                  => 'Η περιγραφή ξεκινά με ":value"',
    'search_modifier_not_description_starts'              => 'Η περιγραφή δεν ξεκινά με ":value"',
    'search_modifier_description_ends'                    => 'Η περιγραφή τελειώνει στο ":value"',
    'search_modifier_not_description_ends'                => 'Η περιγραφή δεν τελειώνει στο ":value"',
    'search_modifier_description_contains'                => 'Η περιγραφή περιέχει ":value"',
    'search_modifier_not_description_contains'            => 'Η περιγραφή δεν περιέχει ":value"',
    'search_modifier_description_is'                      => 'Η περιγραφή είναι ακριβώς ":value"',
    'search_modifier_not_description_is'                  => 'Η περιγραφή δεν είναι ακριβώς ":value"',
    'search_modifier_currency_is'                         => 'Το (ξένο) νόμισμα της συναλλαγής είναι ":value"',
    'search_modifier_not_currency_is'                     => 'Το (ξένο) νόμισμα της συναλλαγής δεν είναι ":value"',
    'search_modifier_foreign_currency_is'                 => 'Το ξένο νόμισμα της συναλλαγής είναι ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Το ξένο νόμισμα της συναλλαγής δεν είναι ":value"',
    'search_modifier_has_attachments'                     => 'Η συναλλαγή πρέπει να έχει ένα συνημμένο',
    'search_modifier_has_no_category'                     => 'Η συναλλαγή δεν πρέπει να έχει κατηγορία',
    'search_modifier_not_has_no_category'                 => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) κατηγορία',
    'search_modifier_not_has_any_category'                => 'Η συναλλαγή δεν πρέπει να έχει κατηγορία',
    'search_modifier_has_any_category'                    => 'Η συναλλαγή πρέπει να έχει μία (οποιαδήποτε) κατηγορία',
    'search_modifier_has_no_budget'                       => 'Η συναλλαγή δεν πρέπει να έχει προϋπολογισμό',
    'search_modifier_not_has_any_budget'                  => 'Η συναλλαγή δεν πρέπει να έχει προϋπολογισμό',
    'search_modifier_has_any_budget'                      => 'Η συναλλαγή πρέπει να έχει έναν (οποιοδήποτε) προϋπολογισμό',
    'search_modifier_not_has_no_budget'                   => 'Η συναλλαγή πρέπει να έχει έναν (οποιοδήποτε) προϋπολογισμό',
    'search_modifier_has_no_bill'                         => 'Η συναλλαγή δεν πρέπει να έχει συνδρομή',
    'search_modifier_not_has_no_bill'                     => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) συνδρομή',
    'search_modifier_has_any_bill'                        => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) συνδρομή',
    'search_modifier_not_has_any_bill'                    => 'Η συναλλαγή δεν πρέπει να έχει συνδρομή',
    'search_modifier_has_no_tag'                          => 'Η συναλλαγή δεν πρέπει να έχει καμία ετικέτα',
    'search_modifier_not_has_any_tag'                     => 'Η συναλλαγή δεν πρέπει να έχει ετικέτα',
    'search_modifier_not_has_no_tag'                      => 'Η συναλλαγή πρέπει να έχει (οποιαδήποτε) ετικέτα',
    'search_modifier_has_any_tag'                         => 'Η συναλλαγή πρέπει να έχει μία (οποιαδήποτε) ετικέτα',
    'search_modifier_notes_contains'                      => 'Οι σημειώσεις της συναλλαγής περιέχουν ":value"',
    'search_modifier_not_notes_contains'                  => 'Οι σημειώσεις της συναλλαγής δεν περιέχουν ":value"',
    'search_modifier_notes_starts'                        => 'Οι σημειώσεις της συναλλαγής αρχίζουν με ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Η συναλλαγή δεν έχει σημειώσεις',
    'search_modifier_not_no_notes'                        => 'Η συναλλαγή πρέπει να έχει σημειώσεις',
    'search_modifier_any_notes'                           => 'Η συναλλαγή πρέπει να έχει σημειώσεις',
    'search_modifier_not_any_notes'                       => 'Η συναλλαγή δεν έχει σημειώσεις',
    'search_modifier_amount_is'                           => 'Το ποσό είναι ακριβώς :value',
    'search_modifier_not_amount_is'                       => 'Το ποσό δεν είναι :value',
    'search_modifier_amount_less'                         => 'Το ποσό είναι μικρότερο ή ίσο με :value',
    'search_modifier_not_amount_more'                     => 'Το ποσό είναι μικρότερο ή ίσο με :value',
    'search_modifier_amount_more'                         => 'Το ποσό είναι μεγαλύτερο ή ίσο με :value',
    'search_modifier_not_amount_less'                     => 'Το ποσό είναι μεγαλύτερο ή ίσο με :value',
    'search_modifier_source_account_is'                   => 'Το όνομα του λογαριασμού προέλευσης είναι ακριβώς ":value"',
    'search_modifier_not_source_account_is'               => 'Το όνομα του λογαριασμού προέλευσης δεν είναι ":value"',
    'search_modifier_source_account_contains'             => 'Το όνομα του λογαριασμού προέλευσης περιέχει ":value"',
    'search_modifier_not_source_account_contains'         => 'Το όνομα του λογαριασμού προέλευσης δεν περιέχει ":value"',
    'search_modifier_source_account_starts'               => 'Το όνομα του λογαριασμού προέλευσης αρχίζει με ":value"',
    'search_modifier_not_source_account_starts'           => 'Το όνομα του λογαριασμού προέλευσης δεν αρχίζει με ":value"',
    'search_modifier_source_account_ends'                 => 'Το όνομα του λογαριασμού προέλευσης τελειώνει με ":value"',
    'search_modifier_not_source_account_ends'             => 'Το όνομα του λογαριασμού προέλευσης δεν τελειώνει με ":value"',
    'search_modifier_source_account_id'                   => 'Το ID του λογαριασμού προέλευσης είναι :value',
    'search_modifier_not_source_account_id'               => 'Το ID του λογαριασμού προέλευσης δεν είναι :value',
    'search_modifier_source_account_nr_is'                => 'Ο αριθμός (IBAN) του λογαριασμού προέλευσης είναι ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Ο αριθμός (IBAN) του λογαριασμού προέλευσης περιέχει ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Ο αριθμός (IBAN) του λογαριασμού προέλευσης αρχίζει με ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Το όνομα του λογαριασμού προορισμού είναι ακριβώς ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Το όνομα του λογαριασμού προορισμού περιέχει ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Το όνομα του λογαριασμού προορισμού αρχίζει με ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Το ID του λογαριασμού προορισμού είναι :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Ο λογαριασμός προέλευσης είναι ο λογαριασμός «(μετρητά)»',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Ο αριθμός (IBAN) του λογαριασμού προορισμού είναι ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Ο αριθμός (IBAN) του λογαριασμού προορισμού περιέχει ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Ο αριθμός (IBAN) του λογαριασμού προορισμού αρχίζει με ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Ο αριθμός (IBAN) του λογαριασμού προορισμού τελειώνει με ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Το/Τα αναγνωριστικά λογαριασμού προέλευσης ή προορισμού είναι: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Η κατηγορία είναι ":value"',
    'search_modifier_not_category_is'                     => 'Η κατηγορία δεν είναι ":value"',
    'search_modifier_budget_is'                           => 'Ο προϋπολογισμός είναι ":value"',
    'search_modifier_not_budget_is'                       => 'Ο προϋπολογισμός δεν είναι ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Ο τύπος συναλλαγής είναι ":value"',
    'search_modifier_not_transaction_type'                => 'Ο τύπος συναλλαγής δεν είναι ":value"',
    'search_modifier_tag_is'                              => 'Η ετικέτα είναι ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Η συναλλαγή είναι στο έτος ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Η συναλλαγή είναι στον μήνα ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Η συναλλαγή είναι την ημέρα του μήνα ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Η συναλλαγή είναι πριν ή μέσα στο έτος ":value"',
    'search_modifier_date_before_month'                   => 'Η συναλλαγή είναι πριν ή μέσα στο μήνα ":value"',
    'search_modifier_date_before_day'                     => 'Η συναλλαγή είναι πριν ή την ημέρα του μήνα ":value"',
    'search_modifier_date_after_year'                     => 'Η συναλλαγή είναι μέσα ή μετά το έτος ":value"',
    'search_modifier_date_after_month'                    => 'Η συναλλαγή είναι μέσα ή μετά το μήνα ":value"',
    'search_modifier_date_after_day'                      => 'Η συναλλαγή είναι μετά ή την ημέρα του μήνα ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Δεν υπάρχει ετικέτα ":value"',
    'search_modifier_not_tag_is_not'                      => 'Η ετικέτα είναι ":value"',
    'search_modifier_account_is'                          => 'Οποιοσδήποτε λογαριασμός είναι ":value"',
    'search_modifier_not_account_is'                      => 'Κανένας λογαριασμός δεν είναι ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Κανένας αριθμός λογαριασμού / IBAN δεν είναι ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Η κατηγορία περιέχει ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Η κατηγορία αρχίζει με ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Ο προϋπολογισμός περιέχει ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Ο προϋπολογισμός τελειώνει σε ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Ο προϋπολογισμός αρχίζει με ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Ενημέρωση κανόνα ":rule" από το ερώτημα αναζήτησης',
    'create_rule_from_query'                        => 'Δημιουργία νέου κανόνα από το ερώτημα αναζήτησης',
    'rule_from_search_words'                        => 'Η ρουτίνα για τους κανόνες δυσκολεύτηκε στο χειρισμό του ":string". Ο προτεινόμενος κανόνας που ταιριάζει στο ερώτημά αναζήτησης μπορεί να δώσει διαφορετικά αποτελέσματα. Παρακαλώ να επιβεβαιώσετε προσεκτικά τους κανόνες ενεργοποίησης.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Ένα σφάλμα προέκυψε κατά την αναζήτηση. Παρακαλώ ελέγξτε τα αρχεία καταγραφής για περισσότερες πληροφορίες.',
    'search_box'                                          => 'Αναζήτηση',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Σφάλμα κατά την αναζήτηση',
    'search_searching'                                    => 'Αναζήτηση ...',
    'search_results'                                      => 'Αποτελέσματα αναζήτησης',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'ετησίως',
    'repeat_freq_half-year'                               => 'εξαμηνιαίως',
    'repeat_freq_quarterly'                               => 'τριμηνιαίως',
    'repeat_freq_monthly'                                 => 'μηνιαίως',
    'repeat_freq_weekly'                                  => 'εβδομαδιαίως',
    'repeat_freq_daily'                                   => 'ημερησίως',
    'daily'                                               => 'ημερησίως',
    'weekly'                                              => 'εβδομαδιαίως',
    'quarterly'                                           => 'τριμηνιαίως',
    'half-year'                                           => 'εξαμηνιαίως',
    'yearly'                                              => 'ετησίως',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Δεν μπορείτε να εκτελέσετε ανενεργούς κανόνες.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Κανόνες',
    'rule_name'                                           => 'Όνομα κανόνα',
    'rule_triggers'                                       => 'Ο κανόνας ενεργοποιείται όταν',
    'rule_actions'                                        => 'Ο κανόνας θα',
    'new_rule'                                            => 'Νέος κανόνας',
    'new_rule_group'                                      => 'Νέα ομάδα κανόνα',
    'rule_priority_up'                                    => 'Δώστε στον κανόνα μεγαλύτερη προτεραιότητα',
    'rule_priority_down'                                  => 'Δώστε στον κανόνα μικρότερη προτεραιότητα',
    'make_new_rule_group'                                 => 'Δημιουργία νέας ομάδας κανόνων',
    'store_new_rule_group'                                => 'Αποθήκευση νέας ομάδας κανόνων',
    'created_new_rule_group'                              => 'Η νέα ομάδα κανόνων ":title" αποθηκεύτηκε!',
    'updated_rule_group'                                  => 'Επιτυχής ενημέρωση της ομάδας κανόνων ":title".',
    'edit_rule_group'                                     => 'Επεξεργασία ομάδας κανόνων ":title"',
    'duplicate_rule'                                      => 'Αντιγραφή κανόνα ":title"',
    'rule_copy_of'                                        => 'Αντιγραφή του ":title"',
    'duplicated_rule'                                     => 'Έγινε αντιγραφή του κανόνα ":title" στο ":newTitle"',
    'delete_rule_group'                                   => 'Διαγραφή ομάδας κανόνων ":title"',
    'deleted_rule_group'                                  => 'Η ομάδα κανόνων ":title" διεγράφη',
    'update_rule_group'                                   => 'Ενημέρωση ομάδας κανόνων',
    'no_rules_in_group'                                   => 'Δεν υπάρχουν κανόνες σε αυτή την ομάδα',
    'move_rule_group_up'                                  => 'Μετακίνηση ομάδας κανόνων επάνω',
    'move_rule_group_down'                                => 'Μετακίνηση ομάδας κανόνων κάτω',
    'save_rules_by_moving'                                => 'Αποθηκεύστε αυτόν τον κανόνα μετακινώντας τον σε μια άλλη ομάδα κανόνων:|Αποθηκεύστε αυτούς τους κανόνες μετακινώντας τους σε μια άλλη ομάδα κανόνων:',
    'make_new_rule'                                       => 'Δημιουργία νέου κανόνα στην ομάδα κανόνων ":title"',
    'make_new_rule_no_group'                              => 'Δημιουργία νέου κανόνα',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Δημιουργία κανόνα που βασίζεται σε μία από τις συναλλαγές σας. Συμπληρώστε ή υποβάλετε μονομιάς την παρακάτω φόρμα.',
    'rule_is_strict'                                      => 'αυστηρός κανόνας',
    'rule_is_not_strict'                                  => 'μη-αυστηρός κανόνας',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'Στους αυστηρούς κανόνες πρέπει να ενεργοποιηθούν ΟΛΑ τα κριτήρια για να εκτελεστεί η αλυσίδα ενεργειών. Στους μη αυστηρούς κανόνες, η ενεργοποίηση ΟΠΟΙΟΥΔΗΠΟΤΕ κριτηρίου είναι αρκετή για να εκτελεστούν οι ενέργειες.',
    'rule_help_active'                                    => 'Οι ανενεργοί κανόνες δεν εκτελούνται ποτέ.',
    'stored_new_rule'                                     => 'Αποθηκεύτηκε νέος κανόνας με τίτλο ":title"',
    'deleted_rule'                                        => 'Διεγράφη ο κανόνας με τίτλο ":title"',
    'store_new_rule'                                      => 'Αποθήκευση νέου κανόνα',
    'updated_rule'                                        => 'Ενημέρωση του κανόνα με τίτλο ":title"',
    'default_rule_group_name'                             => 'Προεπιλεγμένοι κανόνες',
    'default_rule_group_description'                      => 'Όλοι οι κανόνες σας δεν είναι σε κάποια ιδιαίτερη ομάδα.',
    'trigger'                                             => 'Κριτήριο',
    'trigger_value'                                       => 'Τιμή ενεργοποίησης',
    'stop_processing_other_triggers'                      => 'Διακοπή ελέγχου στα υπόλοιπα κριτήρια',
    'add_rule_trigger'                                    => 'Προσθήκη νέου κριτηρίου',
    'action'                                              => 'Ενέργεια',
    'action_value'                                        => 'Τιμή ενέργειας',
    'stop_executing_other_actions'                        => 'Διακοπή εκτέλεσης άλλων ενεργειών',
    'add_rule_action'                                     => 'Προσθήκη νέας ενέργειας',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Διαγραφή κανόνα ":title"',
    'update_rule'                                         => 'Ενημέρωση κανόνα',
    'test_rule_triggers'                                  => 'Δείτε τις αντιστοιχιζόμενες συναλλαγές',
    'warning_no_matching_transactions'                    => 'Δεν βρέθηκαν συναλλαγές που να συμφωνούν με τα κριτήρια.',
    'warning_no_valid_triggers'                           => 'Δεν δώσατε έγκυρα κριτήρια.',
    'apply_rule_selection'                                => 'Εφαρμογή του κανόνα ":title" σε μία επιλογή των συναλλαγών σας',
    'apply_rule_selection_intro'                          => 'Κανόνες όπως ":title" εφαρμόζονται συνήθως σε νέες ή ενημερωμένες συναλλαγές, αλλά μπορείτε να πείτε στο Firefly ΙΙΙ να τους εκτελέσει σε μια επιλογή υπαρχόντων συναλλαγών. Αυτό μπορεί να είναι χρήσιμο όταν έχετε ενημερώσει έναν κανόνα και χρειάζεστε οι αλλαγές να εφαρμοστούν σε όλες τις άλλες συναλλαγές σας.',
    'include_transactions_from_accounts'                  => 'Συμπερίληψη συναλλαγών από αυτούς τους λογαριασμούς',
    'include'                                             => 'Περιλαμβάνεται;',
    'applied_rule_selection'                              => '{0} Καμία συναλλαγή στην επιλογή σας δεν άλλαξε από τον κανόνα ":title".|[1] Μία συναλλαγή στην επιλογή σας άλλαξε από τον κανόνα ":title".|[2,*]:count συναλλαγές στην επιλογή σας άλλαξαν από τον κανόνα ":title".',
    'execute'                                             => 'Εκτέλεση',
    'apply_rule_group_selection'                          => 'Εφαρμογή ομάδας κανόνων ":title" σε μία επιλογή των συναλλαγών σας',
    'apply_rule_group_selection_intro'                    => 'Ομάδες κανόνων όπως ":title" συνήθως εφαρμόζονται σε νέες ή ενημερωμένες συναλλαγές, αλλά μπορείτε να πείτε στο Firefly III να εκτελέσει όλους τους κανόνες σε αυτή την ομάδα σε μία επιλογή των υπαρχόντων συναλλαγών σας. Αυτό μπορεί να είναι χρήσιμο εάν ενημερώσατε μια ομάδα κανόνων και θέλετε οι αλλαγές να εφαρμοστούν σε όλες τις άλλες συναλλαγές σας.',
    'applied_rule_group_selection'                        => 'Η ομάδα κανόνων ":title" έχει εφαρμοστεί στην επιλογή σας.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Όταν δημιουργείται μια συναλλαγή',
    'rule_trigger_update_journal'                         => 'Όταν ενημερώνεται μία συναλλαγή',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Η ενέργεια χρήστη είναι ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Το όνομα του λογαριασμού προέλευσης αρχίζει με..',
    'rule_trigger_source_account_starts'                  => 'Το όνομα του λογαριασμού προέλευσης αρχίζει με ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Το όνομα του λογαριασμού προέλευσης τελειώνει με..',
    'rule_trigger_source_account_ends'                    => 'Το όνομα του λογαριασμού προέλευσης τελειώνει με ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Το όνομα του λογαριασμού προέλευσης είναι..',
    'rule_trigger_source_account_is'                      => 'Το όνομα του λογαριασμού προέλευσης είναι ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Το όνομα του λογαριασμού προέλευσης περιέχει..',
    'rule_trigger_source_account_contains'                => 'Το όνομα του λογαριασμού προέλευσης περιέχει ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Το ID του λογαριασμού προέλευσης είναι ακριβώς..',
    'rule_trigger_source_account_id'                      => 'Το ID του λογαριασμού προέλευσης είναι ακριβώς :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Το ID του λογαριασμού προορισμού είναι ακριβώς..',
    'rule_trigger_destination_account_id'                 => 'Το ID του λογαριασμού προορισμού είναι ακριβώς :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Ο λογαριασμός προέλευσης είναι λογαριασμός (μετρητών)',
    'rule_trigger_source_is_cash'                         => 'Ο λογαριασμός προέλευσης είναι λογαριασμός (μετρητών)',
    'rule_trigger_destination_is_cash_choice'             => 'Ο λογαριασμός προορισμού είναι λογαριασμός (μετρητών)',
    'rule_trigger_destination_is_cash'                    => 'Ο λογαριασμός προορισμού είναι λογαριασμός (μετρητών)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN αρχίζει με..',
    'rule_trigger_source_account_nr_starts'               => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN αρχίζει με ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN τελειώνει με..',
    'rule_trigger_source_account_nr_ends'                 => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN τελειώνει με ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN είναι..',
    'rule_trigger_source_account_nr_is'                   => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN είναι ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Ο αριθμός του λογαριασμού προέλευσης / IBAN περιέχει..',
    'rule_trigger_source_account_nr_contains'             => 'Ο αριθμός λογαριασμού προέλευσης /IBAN περιέχει ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Το όνομα του λογαριασμού προορισμού αρχίζει με..',
    'rule_trigger_destination_account_starts'             => 'Το όνομα του λογαριασμού προορισμού αρχίζει με ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Το όνομα του λογαριασμού προορισμού τελειώνει με..',
    'rule_trigger_destination_account_ends'               => 'Το όνομα του λογαριασμού προορισμού τελειώνει με ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Το όνομα του λογαριασμού προορισμού είναι..',
    'rule_trigger_destination_account_is'                 => 'Το όνομα του λογαριασμού προορισμού είναι ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Το όνομα του λογαριασμού προορισμού περιέχει..',
    'rule_trigger_destination_account_contains'           => 'Το όνομα του λογαριασμού προορισμού περιέχει ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Ο αριθμός του λογαριασμού προορισμού / IBAN αρχίζει με..',
    'rule_trigger_destination_account_nr_starts'          => 'Ο αριθμός του λογαριασμού προορισμού / IBAN αρχίζει με ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Ο αριθμός του λογαριασμού προορισμού / IBAN τελειώνει με..',
    'rule_trigger_destination_account_nr_ends'            => 'Ο αριθμός του λογαριασμού προορισμού / IBAN τελειώνει με ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Ο αριθμός / IBAN του λογαριασμού προορισμού είναι..',
    'rule_trigger_destination_account_nr_is'              => 'Ο αριθμός / IBAN του λογαριασμού προορισμού είναι ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Ο αριθμός / IBAN του λογαριασμού προορισμού περιέχει..',
    'rule_trigger_destination_account_nr_contains'        => 'Ο αριθμός / IBAN του λογαριασμού προορισμού περιέχει ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Η συναλλαγή είναι τύπου..',
    'rule_trigger_transaction_type'                       => 'Η συναλλαγή είναι τύπου ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Η κατηγορία είναι..',
    'rule_trigger_category_is'                            => 'Η κατηγορία είναι ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Η περιγραφή αρχίζει με..',
    'rule_trigger_description_starts'                     => 'Η περιγραφή αρχίζει με ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Η περιγραφή τελειώνει με..',
    'rule_trigger_description_ends'                       => 'Η περιγραφή τελειώνει με ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Η περιγραφή περιέχει..',
    'rule_trigger_description_contains'                   => 'Η περιγραφή περιέχει ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Η περιγραφή είναι..',
    'rule_trigger_description_is'                         => 'Η περιγραφή είναι ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Η ημερομηνία συναλλαγής είναι πριν από τις..',
    'rule_trigger_date_before'                            => 'Η ημερομηνία συναλλαγής είναι πριν από τις ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Η ημερομηνία συναλλαγής είναι μετά από τις..',
    'rule_trigger_date_after'                             => 'Η ημερομηνία συναλλαγής είναι μετά από τις ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Ο προϋπολογισμός είναι..',
    'rule_trigger_budget_is'                              => 'Ο προϋπολογισμός είναι ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Οποιαδήποτε ετικέτα είναι..',
    'rule_trigger_tag_is'                                 => 'Οποιαδήποτε ετικέτα είναι ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Το νόμισμα της συναλλαγής είναι..',
    'rule_trigger_currency_is'                            => 'Το νόμισμα της συναλλαγής είναι ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Το ξένο νόμισμα της συναλλαγής είναι..',
    'rule_trigger_foreign_currency_is'                    => 'Το ξένο νόμισμα της συναλλαγής είναι ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Δεν έχει κατηγορία',
    'rule_trigger_has_no_category'                        => 'Η συναλλαγή δεν έχει κατηγορία',
    'rule_trigger_has_any_category_choice'                => 'Έχει μία(οποιαδήποτε) κατηγορία',
    'rule_trigger_has_any_category'                       => 'Η συναλλαγή έχει μία (οποιαδήποτε) κατηγορία',
    'rule_trigger_has_no_budget_choice'                   => 'Δεν έχει προϋπολογισμό',
    'rule_trigger_has_no_budget'                          => 'Η συναλλαγή δεν έχει προϋπολογισμό',
    'rule_trigger_has_any_budget_choice'                  => 'Έχει έναν (οποιοδήποτε) προϋπολογισμό',
    'rule_trigger_has_any_budget'                         => 'Η συναλλαγή έχει έναν (οποιοδήποτε) προϋπολογισμό',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Δεν έχει ετικέτα(ες)',
    'rule_trigger_has_no_tag'                             => 'Η συναλλαγή δεν έχει ετικέτα(ες)',
    'rule_trigger_has_any_tag_choice'                     => 'Έχει περισσότερες από μία (οποιεσδήποτε) ετικέτες',
    'rule_trigger_has_any_tag'                            => 'Η συναλλαγή έχει περισσότερες από μία (οποιεσδήποτε) ετικέτες',
    'rule_trigger_any_notes_choice'                       => 'Έχει (οποιεσδήποτε) σημειώσεις',
    'rule_trigger_any_notes'                              => 'Η συναλλαγή έχει (οποιεσδήποτε) σημειώσεις',
    'rule_trigger_no_notes_choice'                        => 'Δεν έχει σημειώσεις',
    'rule_trigger_no_notes'                               => 'Η συναλλαγή δεν έχει σημειώσεις',
    'rule_trigger_notes_is_choice'                        => 'Οι σημειώσεις είναι..',
    'rule_trigger_notes_is'                               => 'Οι σημειώσεις είναι ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Οι σημειώσεις περιέχουν..',
    'rule_trigger_notes_contains'                         => 'Οι σημειώσεις περιέχουν ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Οι σημειώσεις αρχίζουν με..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Το ημερολογιακό ID της συναλλαγής είναι..',
    'rule_trigger_journal_id'                             => 'Το ημερολογιακό ID της συναλλαγής είναι ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Η συναλλαγή δεν έχει εξωτερικό URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Οποιοσδήποτε λογαριασμός αρχίζει με..',
    'rule_trigger_account_starts'                         => 'Οποιοσδήποτε λογαριασμός αρχίζει με ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'ΔΙΑΓΡΑΦΗ συναλλαγής (!)',
    'rule_action_delete_transaction'             => 'ΔΙΑΓΡΑΦΗ συναλλαγής (!)',
    'rule_action_set_category'                   => 'Ορίστε την κατηγορία σε ":action_value"',
    'rule_action_clear_category'                 => 'Καθαρισμός κατηγορίας',
    'rule_action_set_budget'                     => 'Ορίστε τον προϋπολογισμό σε ":action_value"',
    'rule_action_clear_budget'                   => 'Καθαρισμός προϋπολογισμού',
    'rule_action_add_tag'                        => 'Προσθήκη ετικέτας ":action_value"',
    'rule_action_remove_tag'                     => 'Αφαίρεση ετικέτας ":action_value"',
    'rule_action_remove_all_tags'                => 'Αφαίρεση όλων των ετικετών',
    'rule_action_set_description'                => 'Ορίστε την περιγραφή σε ":action_value"',
    'rule_action_append_description'             => 'Προσαρτήστε την περιγραφή με ":action_value"',
    'rule_action_prepend_description'            => 'Προεπιλέξτε την περιγραφή με ":action_value"',
    'rule_action_set_category_choice'            => 'Ορισμός κατηγορίας σε ..',
    'rule_action_clear_category_choice'          => 'Καθαρισμός οποιασδήποτε κατηγορίας',
    'rule_action_set_budget_choice'              => 'Ορισμός προϋπολογισμού σε ..',
    'rule_action_clear_budget_choice'            => 'Καθαρισμός οποιουδήποτε προϋπολογισμού',
    'rule_action_add_tag_choice'                 => 'Προσθήκη ετικέτας ..',
    'rule_action_remove_tag_choice'              => 'Αφαίρεση ετικέτας ..',
    'rule_action_remove_all_tags_choice'         => 'Αφαίρεση όλων των ετικετών',
    'rule_action_set_description_choice'         => 'Ορισμός περιγραφής σε ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Ορισμός του λογαριασμού προέλευσης σε :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Ορισμός του λογαριασμού προορισμού σε :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Προσάρτηση σημειώσεων με ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Προεπιλογή σημειώσεων με ":action_value"',
    'rule_action_clear_notes_choice'             => 'Αφαίρεση οποιονδήποτε σημειώσεων',
    'rule_action_clear_notes'                    => 'Αφαίρεση οποιονδήποτε σημειώσεων',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Ορισμός σημειώσεων σε ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Μετατροπή της συναλλαγής σε μία κατάθεση',
    'rule_action_convert_deposit'                => 'Μετατροπή της συναλλαγής σε μία κατάθεση από ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Μετατροπή της συναλλαγής σε μία ανάληψη',
    'rule_action_convert_withdrawal'             => 'Μετατροπή της συναλλαγής σε μία ανάληψη σε ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Μετατροπή της συναλλαγής σε μία μεταφορά',
    'rule_action_convert_transfer'               => 'Μετατροπή της συναλλαγής σε μία μεταφορά με ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Κανόνας με βάση τη συναλλαγή ":description"',
    'new_rule_for_journal_description'          => 'Αυτός ο κανόνας έχει βασιστεί στη συναλλαγή ":description". Θα αντιστοιχεί σε συναλλαγές που είναι ίδιες ακριβώς.',

    // tags
    'store_new_tag'                             => 'Αποθήκευση νέας ετικέτας',
    'update_tag'                                => 'Ενημέρωση ετικέτας',
    'no_location_set'                           => 'Δεν ορίστηκε τοποθεσία.',
    'meta_data'                                 => 'Μετα-δεδομένα',
    'location'                                  => 'Τοποθεσία',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Χωρίς ημερομηνία',
    'result'                                    => 'Αποτέλεσμα',
    'sums_apply_to_range'                       => 'Όλα τα σύνολα αφορούν το συγκεκριμένο εύρος',
    'mapbox_api_key'                            => 'Για τη χρήση χάρτη, λάβετε ένα κλειδί API από <a href="https://www.mapbox.com/">Mapbox</a>. Ανοίξτε το <code>.env</code> αρχείο σας και εισάγετε αυτόν τον κωδικό στο <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Κάντε δεξί κλικ ή πιέστε παρατεταμένα για να ορίσετε την τοποθεσία του αντικειμένου.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Εκκαθάριση τοποθεσίας',
    'delete_all_selected_tags'                  => 'Διαγραφή όλων των επιλεγμένων ετικετών',
    'select_tags_to_delete'                     => 'Μην ξεχάσετε να επιλέξετε ορισμένες ετικέτες.',
    'deleted_x_tags'                            => 'Διαγράφηκε :count ετικέτα.|Διαγράφηκαν :count ετικέτες.',
    'create_rule_from_transaction'              => 'Δημιουργία κανόνα με βάση τη συναλλαγή',
    'create_recurring_from_transaction'         => 'Δημιουργία επαναλαμβανόμενης συναλλαγής με βάση τη συναλλαγή',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Σύμφωνα με τις προτιμήσεις του περιηγητή σας',
    'dark_mode_option_light'                    => 'Πάντα φωτεινό',
    'dark_mode_option_dark'                     => 'Πάντα σκοτεινό',
    'equal_to_language'                         => '(ίδιο με τη γλώσσα)',
    'dark_mode_preference'                      => 'Σκοτεινή λειτουργία',
    'dark_mode_preference_help'                 => 'Πείτε στο Firefly III πότε να χρησιμοποιεί σκοτεινή λειτουργία.',
    'pref_home_screen_accounts'                 => 'Λογαριασμοί αρχικής οθόνης',
    'pref_home_screen_accounts_help'            => 'Ποιοι λογαριασμοί θα πρέπει να εμφανίζονται στην αρχική σελίδα;',
    'pref_view_range'                           => 'Εύρος εμφάνισης',
    'pref_view_range_help'                      => 'Κάποια διαγράμματα ομαδοποιούνται αυτόματα σε περιόδους. Οι προϋπολογισμοί σας θα ομαδοποιηθούν επίσης σε περιόδους. Ποιά περίοδο προτιμάτε;',
    'pref_1D'                                   => 'Μία ημέρα',
    'pref_1W'                                   => 'Μία εβδομάδα',
    'pref_1M'                                   => 'Ένα μήνα',
    'pref_3M'                                   => 'Τρεις μήνες (τρίμηνο)',
    'pref_6M'                                   => 'Έξι μήνες (εξάμηνο)',
    'pref_1Y'                                   => 'Ένα έτος',
    'pref_last365'                              => 'Προηγούμενο έτος',
    'pref_last90'                               => 'Τελευταίες 90 ημέρες',
    'pref_last30'                               => 'Τελευταίες 30 ημέρες',
    'pref_last7'                                => 'Τελευταίες 7 ημέρες',
    'pref_YTD'                                  => 'Έτος μέχρι σήμερα',
    'pref_QTD'                                  => 'Τρίμηνο μέχρι σήμερα',
    'pref_MTD'                                  => 'Μήνας μέχρι σήμερα',
    'pref_languages'                            => 'Γλώσσες',
    'pref_locale'                               => 'Ρυθμίσεις τοποθεσίας',
    'pref_languages_help'                       => 'Το Firefly III υποστηρίζει διάφορες γλώσσες. Ποιά προτιμάτε;',
    'pref_locale_help'                          => 'Το Firefly III σας επιτρέπει να ορίσετε ορισμένες ρυθμίσεις τοποθεσίας, όπως τον τρόπο μορφοποίησης νομισμάτων, αριθμών και ημερομηνιών. Οι καταχωρήσεις σε αυτήν τη λίστα ενδέχεται να μην υποστηρίζονται από το σύστημά σας. Το Firefly III δεν έχει τις σωστές ρυθμίσεις ημερομηνίας για κάθε τοποθεσία. επικοινωνήστε μαζί μου για βελτιώσεις.',
    'pref_locale_no_demo'                       => 'Αυτό το χαρακτηριστικό δε θα λειτουργήσει για τον χρήστη επίδειξης.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Ρυθμίσεις οικονομικού έτους',
    'pref_custom_fiscal_year_label'             => 'Ενεργοποιημένο',
    'pref_custom_fiscal_year_help'              => 'Σε χώρες που χρησιμοποιούν οικονομικό έτος διαφορετικό από 1 Ιανουαρίου εώς 31 Δεκεμβρίου, μπορείτε να ενεργοποιήσετε αυτή την επιλογή και να ορίσετε την αρχή και το τέλος του οικονομικού έτους',
    'pref_fiscal_year_start_label'              => 'Έναρξη οικονομικού έτους',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Μην ξεχάσετε να αφαιρέσετε το λογαριασμό από την εφαρμογή ταυτοποίησης στο κινητό σας!',
    'pref_two_factor_auth_code'                 => 'Επιβεβαίωση κωδικού',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Επαναφορά κωδικού επιβεβαίωσης',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Εάν δεν μπορείτε να σκανάρετε τον κωδικό QR, δοκιμάστε να χρησιμοποιήσετε το μυστικό ανταυτού: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Αποθηκεύστε αυτούς τους εφεδρικούς κωδικούς για να μπορείτε να έχετε πρόσβαση σε περίπτωση που χάσετε τη συσκευή σας.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Αυτός ο κωδικός MFA δεν είναι έγκυρος.',
    'pref_save_settings'                        => 'Αποθήκευση ρυθμίσεων',
    'saved_preferences'                         => 'Οι προτιμήσεις αποθηκεύτηκαν!',
    'preferences_general'                       => 'Γενικά',
    'preferences_frontpage'                     => 'Αρχική οθόνη',
    'preferences_security'                      => 'Ασφάλεια',
    'preferences_layout'                        => 'Διάταξη',
    'preferences_notifications'                 => 'Ειδοποιήσεις',
    'pref_home_show_deposits'                   => 'Εμφάνιση καταθέσεων στην αρχική οθόνη',
    'pref_home_show_deposits_info'              => 'Η αρχική οθόνη δείχνει ήδη τους λογαριασμούς δαπανών σας. Μήπως θα έπρεπε να δείχνει και τους λογαριασμούς εσόδων σας;',
    'pref_home_do_show_deposits'                => 'Ναι, δείξτε τους',
    'successful_count'                          => 'από τις οποίες :count με επιτυχία',
    'list_page_size_title'                      => 'Μέγεθος σελίδας',
    'list_page_size_help'                       => 'Κάθε λίστα αντικειμένων (λογαριασμοί, συναλλαγές, κλπ) εμφανίζει το πολύ, τόσα ανά σελίδα.',
    'list_page_size_label'                      => 'Μέγεθος σελίδας',
    'between_dates'                             => '(:start και :end)',
    'pref_optional_fields_transaction'          => 'Προαιρετικά πεδία για συναλλαγές',
    'pref_optional_fields_transaction_help'     => 'Από προεπιλογή δεν μπορούν να ενεργοποιηθούν όλα τα πεδία όταν δημιουργείται μία νέα συναλλαγή (εξαιτίας της σύγχυσης). Παρακάτω, μπορείτε να ενεργοποιήσετε αυτά τα πεδία εάν νομίζετε ότι θα σας φανούν χρήσιμα. Φυσικά, όποιο πεδίο απενεργοποιείται, αλλά είναι ήδη συμπληρωμένο, θα συνεχίζει να εμφανίζεται ασχέτως της ρύθμισης.',
    'optional_tj_date_fields'                   => 'Πεδία ημερομηνίας',
    'optional_tj_other_fields'                  => 'Άλλα πεδία',
    'optional_tj_attachment_fields'             => 'Πεδία συνημμένου',
    'pref_optional_tj_interest_date'            => 'Ημερομηνία τοκισμού',
    'pref_optional_tj_book_date'                => 'Ημερομηνία εγγραφής',
    'pref_optional_tj_process_date'             => 'Ημερομηνία επεξεργασίας',
    'pref_optional_tj_due_date'                 => 'Ημερομηνία προθεσμίας',
    'pref_optional_tj_payment_date'             => 'Ημερομηνία πληρωμής',
    'pref_optional_tj_invoice_date'             => 'Ημερομηνία τιμολόγησης',
    'pref_optional_tj_internal_reference'       => 'Εσωτερική αναφορά',
    'pref_optional_tj_notes'                    => 'Σημειώσεις',
    'pref_optional_tj_attachments'              => 'Συνημμένα',
    'pref_optional_tj_external_url'             => 'Εξωτερικό URL',
    'pref_optional_tj_location'                 => 'Τοποθεσία',
    'pref_optional_tj_links'                    => 'Συνδέσεις συναλλαγής',
    'optional_field_meta_dates'                 => 'Ημερομηνίες',
    'optional_field_meta_business'              => 'Επιχείρηση',
    'optional_field_attachments'                => 'Συνημμένα',
    'optional_field_meta_data'                  => 'Προαιρετικά μετα-δεδομένα',
    'external_url'                              => 'Εξωτερικό URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Ειδοποίηση όταν δημιουργείται ένα νέο διακριτικό πρόσβασης API',
    'pref_notification_transaction_creation'    => 'Ειδοποίηση όταν δημιουργείται αυτόματα μια συναλλαγή',
    'pref_notification_user_login'              => 'Ειδοποίηση όταν συνδέεστε από μια νέα τοποθεσία',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Ειδοποιήσεις',
    'pref_notifications_help'                   => 'Υποδείξτε εάν πρόκειται για ειδοποιήσεις που θέλετε να λαμβάνετε. Ορισμένες ειδοποιήσεις ενδέχεται να περιέχουν ευαίσθητες οικονομικές πληροφορίες.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => '"Εισερχόμενο webhook" URL στο Slack',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Οικονομική διαχείριση',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Εκκαθάριση δεδομένων από το Firefly III',
    'purge_data_expl'                           => '"Εκκαθάριση" σημαίνει "διαγραφή αυτού που έχει ήδη διαγραφεί". Σε κανονικές συνθήκες, το Firefly III δε διαγράφει τίποτα οριστικά. Απλώς το κρύβει. Το παρακάτω κουμπί διαγράφει όλες αυτές τις προηγουμένως "διαγραμμένες" εγγραφές ΓΙΑ ΠΑΝΤΑ.',
    'delete_stuff_header'                       => 'Διαγραφή και εκκαθάριση δεδομένων',
    'purge_all_data'                            => 'Εκκαθάριση όλων των διαγραμμένων εγγραφών',
    'purge_data'                                => 'Εκκαθάριση δεδομένων',
    'purged_all_records'                        => 'Όλες οι διαγραμμένες εγγραφές έχουν εκκαθαριστεί οριστικά.',
    'delete_data_title'                         => 'Διαγραφή δεδομένων από το Firefly III',
    'permanent_delete_stuff'                    => 'Μπορείτε να διαγράψετε πράγματα από το Firefly III. Η χρήση των παρακάτω κουμπιών σημαίνει ότι τα στοιχεία σας αυτά θα είναι κρυμμένα και δε θα εμφανίζονται. Δεν υπάρχει κουμπί αναίρεσης για αυτή την ενέργεια, αλλά τα στοιχεία θα παραμείνουν στη βάση δεδομένων όπου μπορείτε να τα αναζητήσετε χειροκίνητα σε κάποια άλλη στιγμή εάν είναι απαραίτητο.',
    'other_sessions_logged_out'                 => 'Όλες οι άλλες συνεδρίες σας έχουν αποσυνδεθεί.',
    'delete_unused_accounts'                    => 'Η διαγραφή αχρησιμοποίητων λογαριασμών θα καθαρίσει τις λίστες αυτόματης συμπλήρωσης.',
    'delete_all_unused_accounts'                => 'Διαγραφή αχρησιμοποίητων λογαριασμών',
    'deleted_all_unused_accounts'               => 'Όλοι οι αχρησιμοποίητοι λογαριασμοί έχουν διαγραφεί',
    'delete_all_budgets'                        => 'Διαγραφή ΟΛΩΝ των προϋπολογισμών σας',
    'delete_all_categories'                     => 'Διαγραφή ΟΛΩΝ των κατηγοριών σας',
    'delete_all_tags'                           => 'Διαγραφή ΟΛΩΝ των ετικετών σας',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Διαγραφή ΟΛΩΝ των κουμπαράδων σας',
    'delete_all_rules'                          => 'Διαγραφή ΟΛΩΝ των κανόνων σας',
    'delete_all_recurring'                      => 'Διαγραφή ΟΛΩΝ των επαναλαμβανόμενων συναλλαγών σας',
    'delete_all_object_groups'                  => 'Διαγραφή ΟΛΩΝ των ομάδων αντικειμένων σας',
    'delete_all_accounts'                       => 'Διαγραφή ΟΛΩΝ των λογαριασμών σας',
    'delete_all_asset_accounts'                 => 'Διαγραφή ΟΛΩΝ των λογαριασμών κεφαλαίων σας',
    'delete_all_expense_accounts'               => 'Διαγραφή ΟΛΩΝ των λογαριασμών δαπανών σας',
    'delete_all_revenue_accounts'               => 'Διαγραφή ΟΛΩΝ των λογαριασμών εσόδων σας',
    'delete_all_liabilities'                    => 'Διαγραφή ΟΛΩΝ των υποχρεώσεων σας',
    'delete_all_transactions'                   => 'Διαγραφή ΟΛΩΝ των συναλλαγών σας',
    'delete_all_withdrawals'                    => 'Διαγραφή ΟΛΩΝ των αναλήψεων σας',
    'delete_all_deposits'                       => 'Διαγραφή ΟΛΩΝ των καταθέσεων σας',
    'delete_all_transfers'                      => 'Διαγραφή ΟΛΩΝ των μεταφορών σας',
    'also_delete_transactions'                  => 'Η διαγραφή λογαριασμών θα διαγράψει επίσης ΟΛΕΣ τις σχετικές αναλήψεις, καταθέσεις και μεταφορές!',
    'deleted_all_budgets'                       => 'Όλοι οι προϋπολογισμοί έχουν διαγραφεί',
    'deleted_all_categories'                    => 'Όλες οι κατηγορίες έχουν διαγραφεί',
    'deleted_all_tags'                          => 'Όλες οι ετικέτες έχουν διαγραφεί',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Όλοι οι κουμπαράδες έχουν διαγραφεί',
    'deleted_all_rules'                         => 'Όλοι οι κανόνες και οι ομάδες κανόνων έχουν διαγραφεί',
    'deleted_all_object_groups'                 => 'Όλες οι ομάδες έχουν διαγραφεί',
    'deleted_all_accounts'                      => 'Όλοι οι λογαριασμοί έχουν διαγραφεί',
    'deleted_all_asset_accounts'                => 'Όλοι οι λογαριασμοί κεφαλαίων έχουν διαγραφεί',
    'deleted_all_expense_accounts'              => 'Όλοι οι λογαριασμοί δαπανών έχουν διαγραφεί',
    'deleted_all_revenue_accounts'              => 'Όλοι οι λογαριασμοί εσόδων έχουν διαγραφεί',
    'deleted_all_liabilities'                   => 'Όλες οι υποχρεώσεις έχουν διαγραφεί',
    'deleted_all_transactions'                  => 'Όλες οι συναλλαγές έχουν διαγραφεί',
    'deleted_all_withdrawals'                   => 'Όλες οι αναλήψεις έχουν διαγραφεί',
    'deleted_all_deposits'                      => 'Όλες οι καταθέσεις έχουν διαγραφεί',
    'deleted_all_transfers'                     => 'Όλες οι μεταφορές έχουν διαγραφεί',
    'deleted_all_recurring'                     => 'Όλες οι επαναλαμβανόμενες συναλλαγές έχουν διαγραφεί',
    'change_your_password'                      => 'Αλλαγή του κωδικού σας',
    'delete_account'                            => 'Διαγραφή λογαριασμού',
    'current_password'                          => 'Τρέχων κωδικός',
    'new_password'                              => 'Νέος κωδικός',
    'new_password_again'                        => 'Νέος κωδικός (επανάληψη)',
    'delete_your_account'                       => 'Διαγραφή του λογαριασμού σας',
    'delete_your_account_help'                  => 'Διαγράφοντας το λογαριασμό σας, θα διαγράψετε και όλες τις συναλλαγές, τους λογαριασμούς, <em>οτιδήποτε</em> μπορεί να έχετε αποθηκεύσει στο Firefly III. Θα ΕΞΑΦΑΝΙΣΤΟΥΝ.',
    'delete_your_account_password'              => 'Εισάγετε τον κωδικό σας για να συνεχίσετε.',
    'password'                                  => 'Κωδικός πρόσβασης',
    'are_you_sure'                              => 'Είστε σίγουρος; Δεν μπορείτε να το πάρετε πίσω.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'ΔΙΑΓΡΑΦΗ του λογαριασμού σας',
    'invalid_current_password'                  => 'Μη έγκυρος κωδικός!',
    'password_changed'                          => 'Ο κωδικός έχει αλλάξει!',
    'should_change'                             => 'Θα ήταν καλό να αλλάξετε τον κωδικό σας.',
    'invalid_password'                          => 'Άκυρος κωδικός!',
    'what_is_pw_security'                       => 'Τι είναι η "επιβεβαίωση ασφάλειας κωδικού";',
    'secure_pw_title'                           => 'Πως να διαλέξετε ένα ασφαλή κωδικό πρόσβασης',
    'forgot_password_response'                  => 'Σας ευχαριστούμε. Εάν υπάρχει λογαριασμός με αυτή τη διεύθυνση ηλεκτρονικού ταχυδρομείου, θα βρείτε οδηγίες στα εισερχόμενά σας.',
    'secure_pw_history'                         => 'Δεν περνάει ούτε μία εβδομάδα χωρίς να διαβάσεις για ένα site που έχασε τους κωδικούς των χρηστών του. Οι χάκερς και οι κλέφτες χρησιμοποιούν αυτούς τους κωδικούς για να κλέψουν προσωπικές σας πληροφορίες. Οι πληροφορίες αυτές είναι πολύτιμες.',
    'secure_pw_ff'                              => 'Χρησιμοποιείτε τον ίδιο κωδικό πρόσβασης παντού στο internet; Εάν ένας ιστότοπος διαρρεύσει τον κωδικό σας, οι χάκερ θα έχουν πρόσβαση σε όλα τα δεδομένα σας. Το Firefly III βασίζεται σε εσάς για να διαλέξετε ένα δυνατό και μοναδικό κωδικό για την προστασία των οικονομικών σας αρχείων.',
    'secure_pw_check_box'                       => 'Για να βοηθήσει σε αυτό το Firefly III μπορεί να ελέγξει εάν ο κωδικός που θέλετε να χρησιμοποιήσετε έχει κλαπεί στο παρελθόν. Εάν ισχύει αυτό, τότε το Firefly III σας συμβουλεύει να μη χρησιμοποιήσετε αυτό τον κωδικό.',
    'secure_pw_working_title'                   => 'Πως λειτουργεί;',
    'secure_pw_working'                         => 'Τσεκάροντας αυτό το πλαίσιο, το Firefly III θα στείλει τους 5 πρώτους χαρακτήρες του SHA1 hash του κωδικού σας στον <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Ιστότοπο του Troy Hunt</a> για να δει εάν είναι στη λίστα. Αυτό θα σας εμποδίσει να χρησιμοποιήσετε ένα μη ασφαλές κωδικό όπως συνιστάται στη τελευταία <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">Ειδική Έκδοση NIST</a> πάνω στο θέμα αυτό.',
    'secure_pw_should'                          => 'Θα πρέπει να τσεκάρω αυτό το πλαίσιο;',
    'secure_pw_long_password'                   => 'Ναι. Πάντα να επιβεβαιώνετε ότι ο κωδικός σας είναι ασφαλής.',
    'command_line_token'                        => 'Διακριτικό γραμμής εντολών',
    'explain_command_line_token'                => 'Χρειάζεστε αυτό το διακριτικό για να εκτελέσετε εργασίες γραμμής εντολών, όπως εξαγωγή δεδομένων. Χωρίς αυτό, οι εντολές δε θα λειτουργήσουν. Μην κοινοποιήσετε το διακριτικό της γραμμής εντολών. Κανείς δεν θα σας ζητήσει αυτό το διακριτικό. Εάν φοβάστε ότι το χάσατε, ή δε χρειάζεστε κάποιο ιδιαίτερο λόγο, δημιουργήστε ξανά αυτό το διακριτικό χρησιμοποιώντας το κουμπί.',
    'regenerate_command_line_token'             => 'Αναδημιουργία διακριτικού γραμμής εντολών',
    'token_regenerated'                         => 'Δημιουργήθηκε ένα νέο διακριτικό γραμμής εντολών',
    'change_your_email'                         => 'Αλλάξτε την διεύθυνση email σας',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Μέχρι να επιβεβαιώσετε την διεύθυνση email σας, δεν μπορείτε να συνδεθείτε.',
    'login_with_new_email'                      => 'Τώρα μπορείτε να συνδεθείτε με τη νέα σας διεύθυνση email.',
    'login_with_old_email'                      => 'Τώρα μπορείτε να συνδεθείτε με το παλιό σας email ξανά.',
    'login_provider_local_only'                 => 'Αυτή η λειτουργία δεν είναι διαθέσιμη όταν πιστοποιήστε μέσω ":login_provider".',
    'external_user_mgt_disabled'                => 'Αυτή η ενέργεια δεν είναι διαθέσιμη όταν το Firefly III δεν είναι υπεύθυνο για διαχείριση χρηστών ή έλεγχο ταυτότητας.',
    'external_auth_disabled'                    => 'Αυτή η ενέργεια δεν είναι διαθέσιμη όταν το Firefly III δεν είναι υπεύθυνο για το χειρισμό ελέγχου ταυτότητας.',
    'delete_local_info_only'                    => "Επειδή το Firefly III δεν είναι υπεύθυνο για διαχείριση χρηστών ή έλεγχο ταυτότητας, αυτή η λειτουργία θα διαγράψει μόνο τις τοπικές εγγραφές του Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Πελάτες OAuth',
    'profile_oauth_no_clients'                  => 'Δεν έχετε δημιουργήσει πελάτες OAuth.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Πελάτες',
    'profile_oauth_client_id'                   => 'Αναγνωριστικό πελάτη',
    'profile_oauth_client_name'                 => 'Όνομα',
    'profile_oauth_client_secret'               => 'Μυστικό',
    'profile_oauth_create_new_client'           => 'Δημιουργία νέου πελάτη',
    'profile_oauth_create_client'               => 'Δημιουργία πελάτη',
    'profile_oauth_edit_client'                 => 'Επεξεργασία πελάτη',
    'profile_oauth_name_help'                   => 'Κάτι που οι χρήστες σας θα αναγνωρίζουν και θα εμπιστεύονται.',
    'profile_oauth_redirect_url'                => 'URL ανακατεύθυνσης',
    'profile_oauth_redirect_url_help'           => 'To authorization callback URL της εφαρμογής σας.',
    'profile_authorized_apps'                   => 'Εξουσιοδοτημένες εφαρμογές',
    'profile_authorized_clients'                => 'Εξουσιοδοτημένοι πελάτες',
    'profile_scopes'                            => 'Πεδία εφαρμογής',
    'profile_revoke'                            => 'Ανάκληση',
    'profile_oauth_client_secret_title'         => 'Μυστικό Πελάτη',
    'profile_oauth_client_secret_expl'          => 'Εδώ είναι το νέο σας μυστικό πελάτη. Αυτή είναι η μόνη φορά που θα σας εμφανιστεί, οπότε μην το χάσετε! Μπορείτε να το χρησιμοποιείτε για να κάνετε αιτήματα API.',
    'profile_personal_access_tokens'            => 'Διακριτικά προσωπικής πρόσβασης',
    'profile_personal_access_token'             => 'Διακριτικά προσωπικής πρόσβασης',
    'profile_oauth_confidential'                => 'Εμπιστευτικό',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Εδώ είναι το νέο διακριτικό προσωπικής πρόσβασης. Αυτή είναι η μόνη φορά που θα εμφανιστεί, οπότε μη το χάσετε! Μπορείτε να χρησιμοποιείτε αυτό το διακριτικό για να κάνετε κλήσεις API.',
    'profile_no_personal_access_token'          => 'Δεν έχετε δημιουργήσει προσωπικά διακριτικά πρόσβασης.',
    'profile_create_new_token'                  => 'Δημιουργία νέου διακριτικού',
    'profile_create_token'                      => 'Δημιουργία διακριτικού',
    'profile_create'                            => 'Δημιουργία',
    'profile_save_changes'                      => 'Αποθήκευση αλλαγών',
    'profile_whoops'                            => 'Ούπς!',
    'profile_something_wrong'                   => 'Κάτι πήγε στραβά!',
    'profile_try_again'                         => 'Κάτι πήγε στραβά. Παρακαλώ προσπαθήστε ξανά.',
    'amounts'                                   => 'Ποσά',
    'multi_account_warning_unknown'             => 'Ανάλογα με τον τύπο της συναλλαγής που δημιουργείτε, ο λογαριασμός προέλευσης ή/και προορισμού των επόμενων διαχωρισμών ενδέχεται να παρακαμφθεί από αυτό που ορίζεται στο πρώτο διαχωρισμό της συναλλαγής.',
    'multi_account_warning_withdrawal'          => 'Λάβετε υπόψη ότι ο λογαριασμός προέλευσης των επόμενων διαχωρισμών θα υπερισχύσει αυτού του πρώτου διαχωρισμού της ανάληψης.',
    'multi_account_warning_deposit'             => 'Λάβετε υπόψη ότι ο λογαριασμός προορισμού των επόμενων διαχωρισμών θα υπερισχύσει αυτού του πρώτου διαχωρισμού της κατάθεσης.',
    'multi_account_warning_transfer'            => 'Λάβετε υπόψη ότι ο λογαριασμός προέλευσης και προορισμού των επόμενων διαχωρισμών θα υπερισχύσει αυτού του πρώτου διαχωρισμού της μεταφοράς.',


    // export data:
    'export_data_title'                         => 'Εξαγωγή δεδομένων από το Firefly III',
    'export_data_menu'                          => 'Εξαγωγή δεδομένων',
    'export_data_bc'                            => 'Εξαγωγή δεδομένων από το Firefly III',
    'export_data_main_title'                    => 'Εξαγωγή δεδομένων από το Firefly III',
    'export_data_expl'                          => 'Αυτός ο σύνδεσμος σας επιτρέπει να εξάγετε όλες τις συναλλαγές + μετα δεδομένα από το Firefly III. Παρακαλώ ανατρέξτε στη βοήθεια (εικονίδιο (?) επάνω δεξιά) για περισσότερες πληροφορίες για τη διαδικασία.',
    'export_data_all_transactions'              => 'Εξαγωγή όλων των συναλλαγών',
    'export_data_advanced_expl'                 => 'Εάν χρειάζεστε έναν πιο εξειδικευμένο ή συγκεκριμένο τύπο εξαγωγής, διαβάστε τη βοήθεια για το πως να χρησιμοποιήσετε την κονσόλα εντολών <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Ένα συνημμένο|:count συνημμένα',
    'attachments'                               => 'Συνημμένα',
    'edit_attachment'                           => 'Τροποποίηση συνημμένου ":name"',
    'update_attachment'                         => 'Ενημέρωση συνημμένου',
    'delete_attachment'                         => 'Διαγραφή συνημμένου ":name"',
    'attachment_deleted'                        => 'Διεγράφη το συνημμένο ":name"',
    'liabilities_deleted'                       => 'Διεγράφη η υποχρέωση ":name"',
    'attachment_updated'                        => 'Ενημερώθηκε το συνημμένο ":name"',
    'upload_max_file_size'                      => 'Μέγιστο μέγεθος αρχείου: :size',
    'list_all_attachments'                      => 'Λίστα όλων των συνημμένων',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Δαπάνες',
    'title_withdrawal'                          => 'Δαπάνες',
    'title_revenue'                             => 'Έσοδα',
    'title_deposit'                             => 'Έσοδα',
    'title_transfer'                            => 'Μεταφορές',
    'title_transfers'                           => 'Μεταφορές',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Ενεργοποίηση των webhook',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Αυτή η συναλλαγή είναι ήδη μία ανάληψη',
    'convert_is_already_type_Deposit'           => 'Αυτή η συναλλαγή είναι ήδη μία κατάθεση',
    'convert_is_already_type_Transfer'          => 'Αυτή η συναλλαγή είναι ήδη μία μεταφορά',
    'convert_to_Withdrawal'                     => 'Μετατροπή ":description" σε μία ανάληψη',
    'convert_to_Deposit'                        => 'Μετατροπή ":description" σε μία κατάθεση',
    'convert_to_Transfer'                       => 'Μετατροπή ":description" σε μία μεταφορά',
    'convert_options_WithdrawalDeposit'         => 'Μετατροπή μίας ανάληψης σε μία κατάθεση',
    'convert_options_WithdrawalTransfer'        => 'Μετατροπή μίας ανάληψης σε μία μεταφορά',
    'convert_options_DepositTransfer'           => 'Μετατροπή μίας κατάθεσης σε μία μεταφορά',
    'convert_options_DepositWithdrawal'         => 'Μετατροπή μίας κατάθεσης σε μία ανάληψη',
    'convert_options_TransferWithdrawal'        => 'Μετατροπή μίας μεταφοράς σε μία ανάληψη',
    'convert_options_TransferDeposit'           => 'Μετατροπή μία μεταφοράς σε μία κατάθεση',
    'convert_Withdrawal_to_deposit'             => 'Μετατροπή αυτή της ανάληψης σε κατάθεση',
    'convert_Withdrawal_to_transfer'            => 'Μετατροπή αυτής της ανάληψης σε μεταφορά',
    'convert_Deposit_to_withdrawal'             => 'Μετατροπή αυτής της κατάθεσης σε ανάληψη',
    'convert_Deposit_to_transfer'               => 'Μετατροπή αυτής της κατάθεσης σε μεταφορά',
    'convert_Transfer_to_deposit'               => 'Μετατροπή αυτής της μεταφοράς σε κατάθεση',
    'convert_Transfer_to_withdrawal'            => 'Μετατροπή αυτής της μεταφοράς σε ανάληψη',
    'convert_please_set_revenue_source'         => 'Παρακαλώ επιλέξτε το λογαριασμό εσόδων από τον οποίο θα προέλθουν τα χρήματα.',
    'convert_please_set_asset_destination'      => 'Επιλέξτε τον κεφαλαιακό λογαριασμό όπου θα μεταβιβαστούν τα χρήματα.',
    'convert_please_set_expense_destination'    => 'Επιλέξτε το λογαριασμό δαπανών όπου θα μεταβιβαστούν τα χρήματα.',
    'convert_please_set_asset_source'           => 'Παρακαλώ επιλέξτε τον κεφαλαιακό λογαριασμό από τον οποίο θα προέλθουν τα χρήματα.',
    'convert_expl_w_d'                          => 'Όταν μετατρέπετε μια ανάληψη σε κατάθεση, τα χρήματα θα κατατεθούν στο λογαριασμό προορισμού, αντί να αναληφθούν από αυτόν.|Όταν μετατρέπετε μια ανάληψη σε κατάθεση, τα χρήματα θα κατατεθούν στους λογαριασμούς προορισμού που βλέπετε εδώ, αντί να αναληφθούν από αυτούς.',
    'convert_expl_w_t'                          => 'Κατά τη μετατροπή μιας ανάληψης σε μεταφορά, τα χρήματα θα αφαιρεθούν από τον λογαριασμό προέλευσης σε άλλο λογαριασμό κεφαλαίου ή υποχρεώσεων αντί να δαπανηθούν στον αρχικό λογαριασμό εξόδων.|Κατά τη μετατροπή μιας ανάληψης σε μεταφορά, τα χρήματα θα αφαιρεθούν από τους λογαριασμούς πηγής σε άλλους λογαριασμούς κεφαλαίου ή υποχρεώσεων αντί να δαπανηθούν στους αρχικούς λογαριασμούς εξόδων.',
    'convert_expl_d_w'                          => 'Όταν μετατρέπετε μια κατάθεση σε ανάληψη, τα χρήματα θα αναληφθούν από τον λογαριασμό προορισμού που βλέπετε εδώ, αντί να κατατεθούν σε αυτόν.|Όταν μετατρέπετε μια κατάθεση σε ανάληψη, τα χρήματα θα αναληφθούν από τους λογαριασμούς προορισμού που βλέπετε εδώ, αντί να κατατεθούν σε αυτούς.',
    'convert_expl_d_t'                          => 'Όταν μετατρέπετε μια κατάθεση σε μεταφορά, τα χρήματα θα κατατεθούν στο λογαριασμό προορισμού που αναγράφεται από οποιοδήποτε λογαριασμό κεφαλαίου ή υποχρεώσεών σας.|Όταν μετατρέπετε μια κατάθεση σε μεταφορά, τα χρήματα θα κατατεθούν στους λογαριασμούς προορισμού που αναγράφονται από οποιονδήποτε από τους λογαριασμούς κεφαλαίου ή υποχρεώσεών σας.',
    'convert_expl_t_w'                          => 'Όταν μετατρέπετε μια μεταφορά σε ανάληψη τα χρήματα θα δαπανηθούν στο λογαριασμό προορισμού που ορίσατε εδώ, αντί να αφαιρεθούν.|Όταν μετατρέπετε μια μεταφορά σε ανάληψη τα χρήματα θα δαπανηθούν στους λογαριασμούς προορισμού που ορίσατε εδώ, αντί να αφαιρεθούν.',
    'convert_expl_t_d'                          => 'Όταν μετατρέπετε μια μεταφορά σε κατάθεση, τα χρήματα θα κατατεθούν στο λογαριασμό προορισμού που βλέπετε εδώ, αντί να μεταφερθούν σε αυτόν.|Όταν μετατρέπετε μια μεταφορά σε κατάθεση, τα χρήματα θα κατατεθούν στους λογαριασμούς προορισμού που βλέπετε εδώ, αντί να μεταφερθούν σε αυτούς.',
    'convert_select_sources'                    => 'Για να ολοκληρώσετε τη μετατροπή, παρακαλώ επιλέξτε το νέο λογαριασμό προέλευσης παρακάτω.|Για να ολοκληρώσετε τη μετατροπή, επιλέξτε τους νέους λογαριασμούς προέλευσης παρακάτω.',
    'convert_select_destinations'               => 'Για να ολοκληρώσετε τη μετατροπή, παρακαλώ επιλέξτε το νέο λογαριασμό προορισμού παρακάτω.|Για να ολοκληρώσετε τη μετατροπή, επιλέξτε τους νέους λογαριασμούς προορισμού παρακάτω.',
    'converted_to_Withdrawal'                   => 'Η συναλλαγή μετατράπηκε σε ανάληψη',
    'converted_to_Deposit'                      => 'Η συναλλαγή μετατράπηκε σε κατάθεση',
    'converted_to_Transfer'                     => 'Η συναλλαγή μετατράπηκε σε μεταφορά',
    'invalid_convert_selection'                 => 'Ο λογαριασμός που έχετε επιλέξει χρησιμοποιείται ήδη σε αυτή τη συναλλαγή ή δεν υπάρχει.',
    'source_or_dest_invalid'                    => 'Δεν είναι δυνατή η εύρεση των σωστών στοιχείων της συναλλαγής. Η μετατροπή δεν είναι δυνατή.',
    'convert_to_withdrawal'                     => 'Μετατροπή σε ανάληψη',
    'convert_to_deposit'                        => 'Μετατροπή σε κατάθεση',
    'convert_to_transfer'                       => 'Μετατροπή σε μεταφορά',

    // create new stuff:
    'create_new_withdrawal'                     => 'Δημιουργία νέας ανάληψης',
    'create_new_deposit'                        => 'Δημιουργία νέας κατάθεσης',
    'create_new_transfer'                       => 'Δημιουργία νέας μεταφοράς',
    'create_new_asset'                          => 'Δημιουργία νέου λογαριασμού κεφαλαίου',
    'create_new_liabilities'                    => 'Δημιουργία νέας υποχρέωσης',
    'create_new_expense'                        => 'Δημιουργία νέου λογαριασμού δαπανών',
    'create_new_revenue'                        => 'Δημιουργία νέου λογαριασμού εσόδων',
    'create_new_piggy_bank'                     => 'Δημιουργία ενός νέου κουμπαρά',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Δημιουργία νέου νομίσματος',
    'store_currency'                            => 'Αποθήκευση νέου νομίσματος',
    'update_currency'                           => 'Ενημέρωση νομίσματος',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή είναι ακόμα σε χρήση.',
    'cannot_delete_fallback_currency'           => ':name είναι το εφεδρικό νόμισμα του συστήματος και δεν μπορεί να διαγραφεί.',
    'cannot_disable_currency_journals'          => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή το χρησιμοποιούν ορισμένες συναλλαγές.',
    'cannot_disable_currency_last_left'         => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή είναι το μόνο ενεργό νόμισμα.',
    'cannot_disable_currency_account_meta'      => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή χρησιμοποιείται από λογαριασμούς κεφαλαίου.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή το χρησιμοποιούν ορισμένες επαναλαμβανόμενες συναλλαγές.',
    'cannot_disable_currency_available_budgets' => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή χρησιμοποιείται στους διαθέσιμους προϋπολογισμούς.',
    'cannot_disable_currency_budget_limits'     => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή χρησιμοποιείται σε όρια προϋπολογισμού.',
    'cannot_disable_currency_current_default'   => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή είναι το προεπιλεγμένο νόμισμα αυτή τη στιγμή.',
    'cannot_disable_currency_system_fallback'   => 'Δεν είναι δυνατή η απενεργοποίηση του :name επειδή είναι το προεπιλεγμένο νόμισμα του συστήματος.',
    'disable_EUR_side_effects'                  => 'Το Ευρώ είναι το εφεδρικό νόμισμα μετάπτωσης του συστήματος. Η απενεργοποίηση μπορεί να έχει ανεπιθύμητες παρενέργειες και μπορεί να ακυρώσει την εγγύησή σας.',
    'deleted_currency'                          => 'Το νόμισμα :name διαγράφηκε',
    'created_currency'                          => 'Το νόμισμα :name δημιουργήθηκε',
    'could_not_store_currency'                  => 'Δεν ήταν δυνατή η αποθήκευση του νέου νομίσματος.',
    'updated_currency'                          => 'Το νόμισμα :name ενημερώθηκε',
    'ask_site_owner'                            => 'Ζητήστε από τον :owner να προσθέσει, αφαιρέσει ή να επεξεργαστεί νομίσματα.',
    'currencies_intro'                          => 'Το Firefly III υποστηρίζει διάφορα νομίσματα τα οποία μπορείτε να ρυθμίσετε και να ενεργοποιήσετε εδώ.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Ορισμός ως προεπιλογή',
    'default_currency'                          => 'προεπιλογή',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Απενεργοποιημένο',
    'enable_currency'                           => 'Ενεργοποίηση',
    'disable_currency'                          => 'Απενεργοποίηση',
    'currencies_default_disabled'               => 'Τα περισσότερα από αυτά τα νομίσματα είναι απενεργοποιημένα από προεπιλογή. Για να τα χρησιμοποιήσετε, πρέπει πρώτα να τα ενεργοποιήσετε.',
    'currency_is_now_enabled'                   => 'Το νόμισμα:name ενεργοποιήθηκε',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Το νόμισμα:name απενεργοποιήθηκε',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Υποχρεωτικά πεδία',
    'optionalFields'                            => 'Προαιρετικά πεδία',
    'options'                                   => 'Επιλογές',

    // budgets:
    'daily_budgets'                             => 'Ημερήσιοι προϋπολογισμοί',
    'weekly_budgets'                            => 'Εβδομαδιαίοι προϋπολογισμοί',
    'monthly_budgets'                           => 'Μηνιαίοι προϋπολογισμοί',
    'quarterly_budgets'                         => 'Τριμηνιαίοι προϋπολογισμοί',
    'half_year_budgets'                         => 'Εξαμηνιαίοι προϋπολογισμοί',
    'yearly_budgets'                            => 'Ετήσιοι προϋπολογισμοί',
    'other_budgets'                             => 'Προϋπολογισμοί με χρονική προσαρμογή',
    'budget_limit_not_in_range'                 => 'Αυτό το ποσό ισχύει από :start έως :end:',
    'total_available_budget'                    => 'Συνολικός διαθέσιμος προϋπολογισμός (μεταξύ :start και :end)',
    'total_available_budget_in_currency'        => 'Συνολικός διαθέσιμος προϋπολογισμός σε :currency',
    'see_below'                                 => 'δες παρακάτω',
    'create_new_budget'                         => 'Δημιουργία νέου προϋπολογισμού',
    'store_new_budget'                          => 'Αποθήκευση νέου προϋπολογισμού',
    'stored_new_budget'                         => 'Αποθηκεύτηκε ο νέος προϋπολογισμός ":name"',
    'available_between'                         => 'Διαθέσιμο μεταξύ :start και :end',
    'transactionsWithoutBudget'                 => 'Δαπάνες εκτός κάποιου προϋπολογισμού',
    'transactions_no_budget'                    => 'Δαπάνες εκτός κάποιου προϋπολογισμού μεταξύ :start και :end',
    'spent_between'                             => 'Δαπανήθηκαν ήδη μεταξύ :start και :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Ορισμός διαθέσιμου ποσού',
    'update_available_amount'                   => 'Ενημέρωση διαθέσιμου ποσού',
    'ab_basic_modal_explain'                    => 'Χρησιμοποιήστε αυτή τη φόρμα για να υποδείξετε πόσα μπορείτε να προϋπολογίσετε (συνολικά, σε :currency) κατά την αναφερόμενη περίοδο.',
    'createBudget'                              => 'Νέος προϋπολογισμός',
    'invalid_currency'                          => 'Μη έγκυρο νόμισμα',
    'invalid_amount'                            => 'Παρακαλώ εισάγετε ένα ποσό',
    'set_ab'                                    => 'Το διαθέσιμο ποσό προϋπολογισμού έχει οριστεί',
    'updated_ab'                                => 'Το διαθέσιμο ποσό προϋπολογισμού έχει ενημερωθεί',
    'deleted_ab'                                => 'Το διαθέσιμο ποσό προϋπολογισμού έχει διαγραφεί',
    'deleted_bl'                                => 'Το ποσό προϋπολογισμού έχει καταργηθεί',
    'alt_currency_ab_create'                    => 'Ορίστε τον διαθέσιμο προϋπολογισμό σε άλλο νόμισμα',
    'bl_create_btn'                             => 'Ορισμός προϋπολογισμού σε άλλο νόμισμα',
    'inactiveBudgets'                           => 'Ανενεργοί προϋπολογισμοί',
    'without_budget_between'                    => 'Συναλλαγές εκτός κάποιου προϋπολογισμού μεταξύ :start και :end',
    'delete_budget'                             => 'Διαγραφή προϋπολογισμού ":name"',
    'deleted_budget'                            => 'Διαγράφηκε ο προϋπολογισμός ":name"',
    'edit_budget'                               => 'Επεξεργασία προϋπολογισμού ":name"',
    'updated_budget'                            => 'Ενημερώθηκε ο προϋπολογισμός ":name"',
    'update_amount'                             => 'Ενημέρωση ποσού',
    'update_budget'                             => 'Ενημέρωση προϋπολογισμού',
    'update_budget_amount_range'                => 'Ενημέρωση (αναμενόμενου) διαθέσιμου ποσού μεταξύ :start και :end',
    'set_budget_limit_title'                    => 'Ορισμός ποσού για τον προϋπολογισμό :budget μεταξύ :start και :end',
    'set_budget_limit'                          => 'Ορισμός ποσού προϋπολογισμού',
    'budget_period_navigator'                   => 'Περιήγηση περιόδου',
    'info_on_available_amount'                  => 'Τι έχω διαθέσιμο;',
    'available_amount_indication'               => 'Χρησιμοποιήστε αυτά τα ποσά για μια ένδειξη του συνολικού προϋπολογισμού σας.',
    'suggested'                                 => 'Πρόταση',
    'average_between'                           => 'Μέσος όρος μεταξύ :start και :end',
    'transferred_in'                            => 'Μεταφέρθηκαν (εντός)',
    'transferred_away'                          => 'Μεταφέρθηκαν (εκτός)',
    'auto_budget_none'                          => 'Χωρίς αυτόματο προϋπολογισμό',
    'auto_budget_reset'                         => 'Ορίστε ένα σταθερό ποσό κάθε περίοδο',
    'auto_budget_rollover'                      => 'Προσθέστε ένα ποσό σε κάθε περίοδο',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Ημερησίως',
    'auto_budget_period_weekly'                 => 'Εβδομαδιαίως',
    'auto_budget_period_monthly'                => 'Μηνιαίως',
    'auto_budget_period_quarterly'              => 'Τριμηνιαίως',
    'auto_budget_period_half_year'              => 'Εξαμηνιαίως',
    'auto_budget_period_yearly'                 => 'Ετησίως',
    'auto_budget_help'                          => 'Μπορείτε να διαβάσετε περισσότερα σχετικά με αυτή τη λειτουργία στη βοήθεια. Κάντε κλικ στο εικονίδιο (?) επάνω δεξιά.',
    'auto_budget_reset_icon'                    => 'Αυτός ο προϋπολογισμός θα οριστεί περιοδικά',
    'auto_budget_rollover_icon'                 => 'Το ποσό του προϋπολογισμού θα αυξηθεί περιοδικά',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Κατάργηση ποσού προϋπολογισμού σε :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Δεν αναμένεται αυτή την περίοδο',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Όχι (ακόμη)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Επαναλήψεις',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Συνδεδεμένες συναλλαγές',
    'auto_match_on'                             => 'Αυτόματη αντιστοίχιση από το Firefly III',
    'auto_match_off'                            => 'Μη αυτόματη αντιστοίχιση από το Firefly III',
    'next_expected_match'                       => 'Επόμενη αναμενόμενη αντιστοίχιση',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Περισσότερα',
    'rescan_old'                                => 'Επανεκτέλεση των κανόνων σε όλες τις συναλλαγές',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Αναμενόμενα μεταξύ :start και :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'παραλείπει',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'ανενεργός κανόνας',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Αναμένεται :date',
    'bill_expected_date_js'                     => 'Αναμένεται {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Πληρώθηκε στις {date}',
    'bill_repeats_weekly'                       => 'Επαναλαμβάνεται εβδομαδιαίως',
    'bill_repeats_monthly'                      => 'Επαναλαμβάνεται μηνιαίως',
    'bill_repeats_quarterly'                    => 'Επαναλαμβάνεται ανά τρίμηνο',
    'bill_repeats_half-year'                    => 'Επαναλαμβάνεται κάθε μισό χρόνο',
    'bill_repeats_yearly'                       => 'Επαναλαμβάνεται ετησίως',
    'bill_repeats_weekly_other'                 => 'Επαναλαμβάνεται κάθε δεύτερη εβδομάδα',
    'bill_repeats_monthly_other'                => 'Επαναλαμβάνεται κάθε δεύτερο μήνα',
    'bill_repeats_quarterly_other'              => 'Επαναλαμβάνεται κάθε δεύτερο τρίμηνο',
    'bill_repeats_half-year_other'              => 'Επαναλαμβάνεται ετησίως',
    'bill_repeats_yearly_other'                 => 'Επαναλαμβάνεται κάθε δεύτερο χρόνο',
    'bill_repeats_weekly_skip'                  => 'Επαναλαμβάνεται κάθε {skip} εβδομάδες',
    'bill_repeats_monthly_skip'                 => 'Επαναλαμβάνεται κάθε {skip} μήνες',
    'bill_repeats_quarterly_skip'               => 'Επαναλαμβάνεται κάθε {skip} τρίμηνα',
    'bill_repeats_half-year_skip'               => 'Επαναλαμβάνεται κάθε {skip} εξάμηνα',
    'bill_repeats_yearly_skip'                  => 'Επαναλαμβάνεται κάθε {skip} έτη',
    'subscriptions'                             => 'Συνδρομές',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Για πάντα',
    'extension_date_is'                         => 'Η ημερομηνία παράτασης είναι {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Έχετε :count ανενεργό λογαριασμό (σε αρχειοθέτηση), τον οποίο μπορείτε να δείτε σε αυτή τη ξεχωριστή σελίδα.|Έχετε :count ανενεργούς λογαριασμούς (σε αρχειοθέτηση), τους οποίους μπορείτε να δείτε σε αυτή τη ξεχωριστή σελίδα.',
    'all_accounts_inactive'                     => 'Αυτοί είναι οι ανενεργοί λογαριασμοί σας.',
    'active_account_link'                       => 'Αυτός ο σύνδεσμος πηγαίνει πίσω στους ενεργούς λογαριασμούς σας.',
    'account_missing_transaction'               => 'Ο λογαριασμός #:id (":name") δεν μπορεί να προβληθεί άμεσα, αλλά και το Firefly δεν έχει πληροφορίες ανακατεύθυνσης.',
    'cc_monthly_payment_date_help'              => 'Επιλέξτε οποιοδήποτε έτος και μήνα, θα αγνοηθούν ούτως ή άλλως. Μόνο η επιλογή ημέρας του μήνα είναι σχετική.',
    'details_for_asset'                         => 'Λεπτομέρειες για τον λογαριασμό κεφαλαίου ":name"',
    'details_for_expense'                       => 'Λεπτομέρειες για το λογαριασμό δαπανών ":name"',
    'details_for_revenue'                       => 'Λεπτομέρειες για τον λογαριασμό εσόδων ":name"',
    'details_for_cash'                          => 'Λεπτομέρειες για to λογαριασμό μετρητών ":name"',
    'store_new_asset_account'                   => 'Αποθήκευση νέου λογαριασμού κεφαλαίου',
    'store_new_expense_account'                 => 'Αποθήκευση νέου λογαριασμού δαπανών',
    'store_new_revenue_account'                 => 'Αποθήκευση νέου λογαριασμού εσόδων',
    'edit_asset_account'                        => 'Επεξεργασία του κεφαλαιακού λογαριασμού ":name"',
    'edit_expense_account'                      => 'Επεξεργασία του λογαριασμού δαπανών ":name"',
    'edit_revenue_account'                      => 'Επεξεργασία λογαριασμού εσόδων ":name"',
    'delete_asset_account'                      => 'Διαγραφή του κεφαλαιακού λογαριασμού ":name"',
    'delete_expense_account'                    => 'Διαγραφή του λογαριασμού δαπανών ":name"',
    'delete_revenue_account'                    => 'Διαγραφή λογαριασμού εσόδων ":name"',
    'delete_liabilities_account'                => 'Διαγραφή υποχρέωσης ":name"',
    'asset_deleted'                             => 'Επιτυχής διαγραφή του κεφαλαιακού λογαριασμού ":name"',
    'account_deleted'                           => 'Επιτυχής διαγραφή του λογαριασμού ":name"',
    'expense_deleted'                           => 'Επιτυχής διαγραφή του λογαριασμού δαπανών ":name"',
    'revenue_deleted'                           => 'Επιτυχής διαγραφή του λογαριασμού εσόδων ":name"',
    'update_asset_account'                      => 'Ενημέρωση λογαριασμού κεφαλαίου',
    'update_undefined_account'                  => 'Ενημέρωση λογαριασμού',
    'update_liabilities_account'                => 'Ενημέρωση υποχρέωσης',
    'update_expense_account'                    => 'Ενημέρωση λογαριασμού δαπανών',
    'update_revenue_account'                    => 'Ενημέρωση λογαριασμού εσόδων',
    'make_new_asset_account'                    => 'Δημιουργία νέου λογαριασμού κεφαλαίου',
    'make_new_expense_account'                  => 'Δημιουργία νέου λογαριασμού δαπανών',
    'make_new_revenue_account'                  => 'Δημιουργία νέου λογαριασμού εσόδων',
    'make_new_liabilities_account'              => 'Δημιουργία νέας υποχρέωσης',
    'asset_accounts'                            => 'Κεφάλαια',
    'undefined_accounts'                        => 'Λογαριασμοί',
    'asset_accounts_inactive'                   => 'Λογαριασμοί κεφαλαίου (ανενεργοί)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Δαπάνες',
    'expense_accounts_inactive'                 => 'Λογαριασμοί δαπανών (ανενεργοί)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Έσοδα',
    'revenue_accounts_inactive'                 => 'Λογαριασμοί εσόδων (ανενεργοί)',
    'cash_accounts'                             => 'Μετρητά',
    'Cash account'                              => 'Λογαριασμός μετρητών',
    'liabilities_accounts'                      => 'Υποχρεώσεις',
    'liabilities_accounts_inactive'             => 'Υποχρεώσεις (ανενεργές)',
    'reconcile_account'                         => 'Τακτοποίηση λογαριασμού ":account"',
    'overview_of_reconcile_modal'               => 'Επισκόπηση τακτοποίησης',
    'delete_reconciliation'                     => 'Διαγραφή τακτοποίησης',
    'update_reconciliation'                     => 'Ενημέρωση τακτοποίησης',
    'amount_cannot_be_zero'                     => 'Το ποσό δεν μπορεί να είναι μηδέν',
    'end_of_reconcile_period'                   => 'Τέλος περιόδου προς τακτοποίηση :period',
    'start_of_reconcile_period'                 => 'Έναρξη περιόδου προς τακτοποίηση :period',
    'start_balance'                             => 'Αρχικό υπόλοιπο',
    'end_balance'                               => 'Τελικό υπόλοιπο',
    'update_balance_dates_instruction'          => 'Αντιστοιχίστε τα παραπάνω ποσά και ημερομηνίες με την τραπεζική σας κατάσταση και πατήστε "Έναρξη τακτοποίησης"',
    'select_transactions_instruction'           => 'Επιλέξτε τις συναλλαγές που εμφανίζονται στην τραπεζική σας κατάσταση.',
    'select_range_and_balance'                  => 'Ελέγξτε πρώτα το χρονικό διάστημα καθώς και τα υπόλοιπα. Στη συνέχεια πατήστε "Έναρξη τακτοποίησης"',
    'date_change_instruction'                   => 'Εάν αλλάξετε τώρα το χρονικό διάστημα, θα χαθεί ότι είχατε εισάγει.',
    'update_selection'                          => 'Ενημέρωση επιλογής',
    'store_reconcile'                           => 'Αποθήκευση τακτοποίησης',
    'reconciliation_transaction'                => 'Συναλλαγή τακτοποίησης',
    'Reconciliation'                            => 'Τακτοποίηση',
    'reconciliation'                            => 'Τακτοποίηση',
    'reconcile_options'                         => 'Επιλογές τακτοποίησης',
    'reconcile_range'                           => 'Εύρος τακτοποίησης',
    'start_reconcile'                           => 'Έναρξη τακτοποίησης',
    'cash_account_type'                         => 'Μετρητά',
    'cash'                                      => 'μετρητά',
    'cant_find_redirect_account'                => 'Το Firefly III προσπάθησε να σας ανακατευθύνει αλλά δεν κατάφερε. Συγνώμη για αυτό. Πίσω στην αρχική.',
    'account_type'                              => 'Τύπος λογαριασμού',
    'save_transactions_by_moving'               => 'Αποθηκεύστε αυτή τη συναλλαγή μετακινώντας την σε ένα άλλο λογαριασμό:|Αποθηκεύστε αυτές τις συναλλαγές μετακινώντας τις σε ένα άλλο λογαριασμό:',
    'save_transactions_by_moving_js'            => 'Δεν υπάρχουν συναλλαγές|Αποθηκεύστε αυτή τη συναλλαγή μετακινώντας την σε άλλο λογαριασμό|Αποθηκεύστε αυτές τις συναλλαγές μετακινώντας τις σε άλλο λογαριασμό.',
    'stored_new_account'                        => 'Ο νέος λογαριασμός ":name" αποθηκεύτηκε!',
    'stored_new_account_js'                     => 'Ο νέος λογαριασμός "<a href="accounts/show/{ID}">{name}</a>" αποθηκεύτηκε!',
    'updated_account'                           => 'Ενημερώθηκε ο λογαριασμός ":name"',
    'updated_account_js'                        => 'Ενημερώθηκε ο λογαριασμός "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Επιλογές πιστωτικής κάρτας',
    'no_transactions_account'                   => 'Δεν υπάρχουν συναλλαγές (αυτήν την περίοδο) για τον λογαριασμό κεφαλαίου ":name".',
    'no_transactions_period'                    => 'Δεν υπάρχουν συναλλαγές (αυτήν την περίοδο).',
    'no_data_for_chart'                         => 'Δεν υπάρχουν αρκετές πληροφορίες (ακόμα) για να δημιουργηθεί αυτό το διάγραμμα.',
    'select_at_least_one_account'               => 'Παρακαλώ επιλέξτε τουλάχιστον ένα λογαριασμό κεφαλαίου',
    'select_at_least_one_category'              => 'Παρακαλώ επιλέξτε τουλάχιστον μια κατηγορία',
    'select_at_least_one_budget'                => 'Επιλέξτε τουλάχιστον έναν προϋπολογισμό',
    'select_at_least_one_tag'                   => 'Παρακαλώ επιλέξτε τουλάχιστον μια ετικέτα',
    'select_at_least_one_expense'               => 'Επιλέξτε τουλάχιστον έναν συνδυασμό λογαριασμών δαπανών / εσόδων. Εάν δεν έχετε (η λίστα είναι κενή) αυτή η αναφορά δεν είναι διαθέσιμη.',
    'account_default_currency'                  => 'Αυτό θα είναι το προεπιλεγμένο νόμισμα που σχετίζεται με αυτό το λογαριασμό.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Το καθολικό στο Firefly III έχει περισσότερα χρήματα από όσα εμφανίζει η κατάσταση της τράπεζας. Υπάρχουν πολλές επιλογές. Επιλέξτε τι θέλετε να κάνετε. Στη συνέχεια πατήστε "Επιβεβαίωση τακτοποίησης".',
    'reconcile_has_less'                        => 'Το καθολικό στο Firefly III έχει λιγότερα χρήματα από όσα εμφανίζει η κατάσταση της τράπεζας. Υπάρχουν πολλές επιλογές. Επιλέξτε τι θέλετε να κάνετε. Στη συνέχεια πατήστε "Επιβεβαίωση τακτοποίησης".',
    'reconcile_is_equal'                        => 'Το καθολικό στο Firefly III ταιριάζει με την κατάσταση της τράπεζας. Δεν υπάρχει τίποτα να κάνετε. Πατήστε "Επιβεβαίωση τακτοποίησης" για επιβεβαίωση.',
    'create_pos_reconcile_transaction'          => 'Εκκαθαρίστε τις επιλεγμένες συναλλαγές και δημιουργήστε μια διόρθωση προσθέτοντας :amount σε αυτό το λογαριασμό κεφαλαίου.',
    'create_neg_reconcile_transaction'          => 'Εκκαθαρίστε τις επιλεγμένες συναλλαγές και δημιουργήστε μια διόρθωση αφαιρώντας :amount από αυτό το λογαριασμό κεφαλαίου.',
    'reconcile_do_nothing'                      => 'Σβήστε τις επιλεγμένες συναλλαγές, αλλά χωρίς διόρθωση.',
    'reconcile_go_back'                         => 'Μπορείτε να επεξεργαστείτε ή να διαγράψετε μια διόρθωση αργότερα.',
    'must_be_asset_account'                     => 'Μπορείτε να κάνετε τακτοποίηση μόνο σε λογαριασμούς κεφαλαίου',
    'reconciliation_stored'                     => 'Η τακτοποίηση αποθηκεύτηκε',
    'reconciliation_error'                      => 'Λόγω σφάλματος, οι συναλλαγές επισημάνθηκαν ως τακτοποιημένες αλλά η διόρθωση δεν έχει αποθηκευτεί: :error.',
    'reconciliation_transaction_title'          => 'Τακτοποίηση (:from σε :to)',
    'sum_of_reconciliation'                     => 'Άθροισμα της τακτοποίησης',
    'reconcile_this_account'                    => 'Τακτοποίηση αυτού του λογαριασμού',
    'reconcile'                                 => 'Τακτοποίηση',
    'show'                                      => 'Εμφάνιση',
    'confirm_reconciliation'                    => 'Επιβεβαίωση τακτοποίησης',
    'submitted_start_balance'                   => 'Υποβλήθηκε το αρχικό υπόλοιπο',
    'selected_transactions'                     => 'Επιλεγμένες συναλλαγές (:count)',
    'already_cleared_transactions'              => 'Συναλλαγές που έχουν ήδη ελεγχθεί (:count)',
    'submitted_end_balance'                     => 'Υποβλήθηκε το τελικό υπόλοιπο',
    'initial_balance_description'               => 'Αρχικό υπόλοιπο για ":account"',
    'liability_credit_description'              => 'Πίστωση υποχρέωσης για ":account"',
    'interest_calc_'                            => 'άγνωστο',
    'interest_calc_daily'                       => 'Ανά ημέρα',
    'interest_calc_monthly'                     => 'Ανά μήνα',
    'interest_calc_yearly'                      => 'Ανά έτος',
    'interest_calc_weekly'                      => 'Ανά εβδομάδα',
    'interest_calc_half-year'                   => 'Ανά εξάμηνο',
    'interest_calc_quarterly'                   => 'Ανά τρίμηνο',
    'initial_balance_account'                   => 'Αρχικό υπόλοιπο του λογαριασμού :account',
    'list_options'                              => 'Επιλογές λίστας',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Νέα κατηγορία',
    'create_new_category'                       => 'Δημιουργήστε νέα κατηγορία',
    'without_category'                          => 'Χωρίς κατηγορία',
    'update_category'                           => 'Ενημέρωση κατηγορίας',
    'updated_category'                          => 'Ενημερώθηκε η κατηγορία ":name"',
    'categories'                                => 'Κατηγορίες',
    'edit_category'                             => 'Επεξεργασία κατηγορίας: ":name"',
    'no_category'                               => '(χωρίς κατηγορία)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Κατηγορία',
    'delete_category'                           => 'Διαγραφή κατηγορίας":name"',
    'deleted_category'                          => 'Διεγράφη η κατηγορία ":name"',
    'store_category'                            => 'Αποθήκευση νέας κατηγορίας',
    'stored_category'                           => 'Αποθηκεύτηκε η νέα κατηγορία ":name"',
    'without_category_between'                  => 'Χωρίς κατηγορία μεταξύ :start και :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Ενημέρωση ανάληψης',
    'update_deposit'                            => 'Ενημέρωση κατάθεσης',
    'update_transaction'                        => 'Ενημέρωση συναλλαγής',
    'update_transfer'                           => 'Ενημέρωση μεταφοράς',
    'updated_withdrawal'                        => 'Ενημερώθηκε η ανάληψη ":description"',
    'updated_deposit'                           => 'Ενημερώθηκε η κατάθεση ":description"',
    'updated_transfer'                          => 'Ενημερώθηκε η μεταφορά ":description"',
    'no_changes_withdrawal'                     => 'Η ανάληψη ":description" δεν άλλαξε.',
    'no_changes_deposit'                        => 'Η κατάθεση ":description" δεν άλλαξε.',
    'no_changes_transfer'                       => 'Η μεταφορά ":description" δεν άλλαξε.',
    'delete_withdrawal'                         => 'Διαγραφή ανάληψης ":description"',
    'delete_deposit'                            => 'Διαγραφή κατάθεσης ":description"',
    'delete_transfer'                           => 'Διαγραφή μεταφοράς ":description"',
    'deleted_withdrawal'                        => 'Επιτυχής διαγραφή της ανάληψης ":description"',
    'deleted_deposit'                           => 'Επιτυχής διαγραφή της κατάθεσης ":description"',
    'deleted_transfer'                          => 'Επιτυχής διαγραφή της μεταφοράς ":description"',
    'deleted_reconciliation'                    => 'Επιτυχής διαγραφή της τακτοποιημένης συναλλαγής ":description"',
    'stored_journal'                            => 'Δημιουργήθηκε επιτυχώς η νέα συναλλαγή ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Δημιουργήθηκε επιτυχώς η νέα συναλλαγή',
    'updated_journal_no_descr'                  => 'Ενημερώθηκε επιτυχώς η συναλλαγή σας',
    'select_transactions'                       => 'Επιλέξτε συναλλαγές',
    'rule_group_select_transactions'            => 'Εφαρμογή ":title" στις συναλλαγές',
    'rule_select_transactions'                  => 'Εφαρμογή ":title" στις συναλλαγές',
    'stop_selection'                            => 'Διακοπή επιλογής συναλλαγών',
    'reconcile_selected'                        => 'Τακτοποίηση',
    'mass_delete_journals'                      => 'Διαγραφή ενός πλήθους συναλλαγών',
    'mass_edit_journals'                        => 'Επεξεργασία ενός πλήθους συναλλαγών',
    'mass_bulk_journals'                        => 'Μαζική επεξεργασία ενός πλήθους συναλλαγών',
    'mass_bulk_journals_explain'                => 'Αυτή η φόρμα σάς επιτρέπει να αλλάξετε τις ιδιότητες των συναλλαγών που παρατίθενται παρακάτω με μία μαζική ενημέρωση. Όλες οι συναλλαγές στον πίνακα θα ενημερωθούν όταν αλλάξετε τις παραμέτρους που βλέπετε εδώ.',
    'part_of_split'                             => 'Αυτή η συναλλαγή αποτελεί μέρος μιας διαχωρισμένης συναλλαγής. Εάν δεν έχετε επιλέξει όλους τις διαχωρισμούς, ενδέχεται να καταλήξετε να αλλάξετε μόνο τη μισή συναλλαγή.',
    'bulk_set_new_values'                       => 'Χρησιμοποιήστε τις παρακάτω εισόδους στοιχείων για να ορίσετε νέες τιμές. Εάν τα αφήσετε κενά, θα γίνουν κενά για όλα. Επίσης, σημειώστε ότι μόνο οι αναλήψεις θα λάβουν έναν προϋπολογισμό.',
    'no_bulk_category'                          => 'Μην ενημερώσεις την κατηγορία',
    'no_bulk_budget'                            => 'Μην ενημερώσεις τον προϋπολογισμό',
    'no_bulk_tags'                              => 'Μην ενημερώσεις τις ετικέτες',
    'replace_with_these_tags'                   => 'Αντικατάσταση με αυτές τις ετικέτες',
    'append_these_tags'                         => 'Προσθήκη των ετικετών',
    'mass_edit'                                 => 'Μεμονωμένη επεξεργασία της επιλογής',
    'bulk_edit'                                 => 'Μαζική επεξεργασία της επιλογής',
    'mass_delete'                               => 'Διαγραφή επιλεγμένων',
    'cannot_edit_other_fields'                  => 'Δεν μπορείτε να επεξεργαστείτε μαζικά άλλα πεδία εκτός από αυτά εδώ, γιατί δεν υπάρχει χώρος για να εμφανιστούν. Ακολουθήστε τον σύνδεσμο και επεξεργαστείτε τα μεμονωμένα, αν θέλετε να επεξεργαστείτε αυτά τα πεδία.',
    'cannot_change_amount_reconciled'           => 'Δεν μπορείτε να αλλάξετε το ποσό ή τον λογαριασμό(ούς) σε τακτοποιημένες συναλλαγές.',
    'no_budget'                                 => '(χωρίς προϋπολογισμό)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Λογαριασμός ανά προϋπολογισμό',
    'account_per_category'                      => 'Λογαριασμοί ανά κατηγορία',
    'create_new_object'                         => 'Δημιουργία',
    'empty'                                     => '(κενό)',
    'all_other_budgets'                         => '(όλοι οι άλλοι προϋπολογισμοί)',
    'all_other_accounts'                        => '(όλοι οι άλλοι λογαριασμοί)',
    'expense_per_source_account'                => 'Δαπάνες ανά λογαριασμό προέλευσης',
    'expense_per_destination_account'           => 'Δαπάνες ανά λογαριασμό προορισμού',
    'income_per_destination_account'            => 'Έσοδα ανά λογαριασμό προορισμού',
    'spent_in_specific_category'                => 'Δαπάνες στην κατηγορία ":category"',
    'earned_in_specific_category'               => 'Κέρδη στην κατηγορία ":category"',
    'spent_in_specific_tag'                     => 'Δαπάνες με ετικέτα ":tag"',
    'earned_in_specific_tag'                    => 'Κέρδη με ετικέτα ":tag"',
    'income_per_source_account'                 => 'Έσοδα ανά λογαριασμό προέλευσης',
    'average_spending_per_destination'          => 'Μέση δαπάνη ανά λογαριασμό προορισμού',
    'average_spending_per_source'               => 'Μέση δαπάνη ανά λογαριασμό προέλευσης',
    'average_earning_per_source'                => 'Μέσο κέρδος ανά λογαριασμό προέλευσης',
    'average_earning_per_destination'           => 'Μέσο κέρδος ανά λογαριασμό προορισμού',
    'account_per_tag'                           => 'Λογαριασμός ανά ετικέτα',
    'tag_report_expenses_listed_once'           => 'Οι δαπάνες και τα έσοδα δεν αναφέρονται ποτέ δύο φορές. Εάν μια συναλλαγή έχει πολλές ετικέτες, μπορεί να εμφανιστεί μόνο κάτω από μία από τις ετικέτες της. Αυτή η λίστα μπορεί να φαίνεται ότι έχει ελλιπή δεδομένα, αλλά τα ποσά θα είναι σωστά.',
    'double_report_expenses_charted_once'       => 'Οι δαπάνες και τα έσοδα δεν εμφανίζονται ποτέ δύο φορές. Εάν μια συναλλαγή έχει πολλές ετικέτες, μπορεί να εμφανιστεί μόνο κάτω από μία από τις ετικέτες της. Αυτό το διάγραμμα ενδέχεται να φαίνεται ότι έχει ελλιπή δεδομένα, αλλά τα ποσά θα είναι σωστά.',
    'tag_report_chart_single_tag'               => 'Αυτό το διάγραμμα ισχύει για μια ετικέτα. Εάν μια συναλλαγή έχει πολλές ετικέτες, αυτό που βλέπετε εδώ μπορεί να αντικατοπτρίζεται και στα διαγράμματα άλλων ετικετών.',
    'tag'                                       => 'Ετικέτα',
    'no_budget_squared'                         => '(χωρίς προϋπολογισμό)',
    'perm-delete-many'                          => 'Η διαγραφή πολλών στοιχείων με μια κίνηση μπορεί να έχει απροσδόκητα αποτελέσματα. Παρακαλώ προσέξτε. Μπορείτε να διαγράψετε μέρος μιας διαχωρισμένης συναλλαγής από αυτήν τη σελίδα, οπότε δώστε προσοχή.',
    'mass_deleted_transactions_success'         => 'Διαγράφηκε :count συναλλαγή.|Διαγράφηκαν :count συναλλαγές.',
    'mass_edited_transactions_success'          => 'Ενημερώθηκε :count συναλλαγή.|Ενημερώθηκαν :count συναλλαγές.',
    'opt_group_'                                => '(χωρίς τύπο λογαριασμού)',
    'opt_group_no_account_type'                 => '(χωρίς τύπο λογαριασμού)',
    'opt_group_defaultAsset'                    => 'Βασικοί λογαριασμοί κεφαλαίου',
    'opt_group_savingAsset'                     => 'Λογαριασμοί αποταμίευσης',
    'opt_group_sharedAsset'                     => 'Κοινοί λογαριασμοί κεφαλαίου',
    'opt_group_ccAsset'                         => 'Πιστωτικές κάρτες',
    'opt_group_cashWalletAsset'                 => 'Πορτοφόλια μετρητών',
    'opt_group_expense_account'                 => 'Λογαριασμοί δαπανών',
    'opt_group_revenue_account'                 => 'Λογαριασμοί εσόδων',
    'opt_group_l_Loan'                          => 'Υποχρέωση: Δάνειο',
    'opt_group_cash_account'                    => 'Λογαριασμός μετρητών',
    'opt_group_l_Debt'                          => 'Υποχρέωση: Χρέος',
    'opt_group_l_Mortgage'                      => 'Υποχρέωση: Υποθήκη',
    'opt_group_l_Credit card'                   => 'Υποχρέωση: Πιστωτική κάρτα',
    'notes'                                     => 'Σημειώσεις',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Δεν ήταν δυνατή η αποθήκευση της συναλλαγής. Ελέγξτε τα αρχεία καταγραφής.',
    'attachment_not_found'                      => 'Αυτό το συνημμένο δεν βρέθηκε.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Η συναλλαγή #{ID} ("{title}")</a> έχει αποθηκευτεί.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Η συναλλαγή #{ID}</a> έχει αποθηκευτεί.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Η συναλλαγή #{ID}</a> ("{title}") έχει ενημερωθεί.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Η συναλλαγή #{ID}</a> ("{title}") παρέμεινε χωρίς καμία αλλαγή.',
    'first_split_decides'                       => 'Ο πρώτος διαχωρισμός καθορίζει την τιμή αυτού του πεδίου',
    'first_split_overrules_source'              => 'Ο πρώτος διαχωρισμός ενδέχεται να παρακάμψει τον λογαριασμό προέλευσης',
    'first_split_overrules_destination'         => 'Ο πρώτος διαχωρισμός ενδέχεται να παρακάμψει τον λογαριασμό προορισμού',
    'spent_x_of_y'                              => 'Δαπανήθηκαν {amount} από {total}',

    // new user:
    'welcome'                                   => 'Καλωσήρθατε στο Firefly III!',
    'submit'                                    => 'Υποβολή',
    'submission'                                => 'Υποβολή',
    'submit_yes_really'                         => 'Υποβολή (ξέρω τι κάνω)',
    'getting_started'                           => 'Ξεκινώντας',
    'to_get_started'                            => 'Είναι ευτυχής μια ακόμη επιτυχημένη εγκατάσταση του Firefly III. Για να ξεκινήσετε με αυτό το εργαλείο, εισαγάγετε το όνομα της τράπεζάς σας και το υπόλοιπο του κύριου τραπεζικού λογαριασμού. Μην ανησυχείτε αν έχετε πολλούς λογαριασμούς. Μπορείτε να τα προσθέσετε αργότερα. Απλά είναι το πρώτο αναγκαίο για να ξεκινήσει η χρήση του Firefly III.',
    'savings_balance_text'                      => 'Το Firefly III θα δημιουργήσει αυτόματα ένα λογαριασμό αποταμίευσης (ταμιευτήριο) για εσάς. Από προεπιλογή δε θα έχει χρήματα σε αυτό το λογαριασμό, εκτός και αν δώσετε το τρέχον υπόλοιπο στο Firefly III για καταχώρηση.',
    'finish_up_new_user'                        => 'Αυτό είναι! Μπορείτε να συνεχίσετε πατώντας το κουμπί <strong>Υποβολή</strong>. Θα μεταφερθείτε στο ευρετήριο του Firefly III.',
    'stored_new_accounts_new_user'              => 'Ναι! Οι νέοι λογαριασμοί σας έχουν αποθηκευτεί.',
    'set_preferred_language'                    => 'Εάν προτιμάτε να χρησιμοποιήσετε το Firefly III σε άλλη γλώσσα, παρακαλούμε να το αναφέρετε εδώ.',
    'language'                                  => 'Γλώσσα',
    'new_savings_account'                       => ':bank_name αποταμιευτικός λογαριασμός',
    'cash_wallet'                               => 'Πορτοφόλι μετρητών',
    'currency_not_present'                      => 'Αν δεν περιλαμβάνεται το νόμισμα που χρησιμοποιείτε, μην ανησυχείτε. Μπορείτε να δημιουργήσετε δικά σας νομίσματα στο Επιλογές > Νομίσματα.',

    // home page:
    'transaction_table_description'             => 'Ένας πίνακας με τις συναλλαγές σας',
    'opposing_account'                          => 'Έναντι λογαριασμός',
    'yourAccounts'                              => 'Οι λογαριασμοί σας',
    'your_accounts'                             => 'Επισκόπηση λογαριασμού',
    'category_overview'                         => 'Επισκόπηση κατηγορίας',
    'expense_overview'                          => 'Επισκόπηση λογαριασμού δαπανών',
    'revenue_overview'                          => 'Επισκόπηση λογαριασμού εσόδων',
    'budgetsAndSpending'                        => 'Προϋπολογισμοί και δαπάνες',
    'budgets_and_spending'                      => 'Προϋπολογισμοί και δαπάνες',
    'go_to_budget'                              => 'Πηγαίνετε στον προϋπολογισμό "{budget}"',
    'go_to_deposits'                            => 'Πηγαίνετε στις καταθέσεις',
    'go_to_expenses'                            => 'Πηγαίνετε στις δαπάνες',
    'savings'                                   => 'Αποταμιεύσεις',
    'newWithdrawal'                             => 'Νέα δαπάνη',
    'newDeposit'                                => 'Νέα κατάθεση',
    'newTransfer'                               => 'Νέα μεταφορά',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Ανά ημέρα',
    'left_to_spend_per_day'                     => 'Διαθέσιμα προϋπολογισμών ανά ημέρα',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Προσαρμοσμένη περίοδος',
    'reset_to_current'                          => 'Επαναφορά στην τρέχουσα περίοδο',
    'select_period'                             => 'Επιλέξτε περίοδο',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Νόμισμα',
    'preferences'                               => 'Προτιμήσεις',
    'logout'                                    => 'Αποσύνδεση',
    'logout_other_sessions'                     => 'Αποσυνδέσετε όλες τις άλλες συνεδρίες',
    'toggleNavigation'                          => 'Εναλλαγή περιήγησης',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Αναζήτηση...',
    'version'                                   => 'Έκδοση',
    'dashboard'                                 => 'Επισκόπηση',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Διαθέσιμος προϋπολογισμός ({currency})',
    'currencies'                                => 'Νομίσματα',
    'activity'                                  => 'Δραστηριότητα',
    'usage'                                     => 'Χρήση',
    'accounts'                                  => 'Λογαριασμοί',
    'Asset account'                             => 'Λογαριασμός κεφαλαίου',
    'Default account'                           => 'Λογαριασμός κεφαλαίου',
    'Expense account'                           => 'Λογαριασμός δαπανών',
    'Revenue account'                           => 'Λογαριασμός εσόδων',
    'Initial balance account'                   => 'Αρχικό υπόλοιπο λογαριασμού',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Χρέος',
    'account_type_Loan'                         => 'Δάνειο',
    'account_type_Mortgage'                     => 'Υποθήκη',
    'account_type_debt'                         => 'Χρέος',
    'account_type_loan'                         => 'Δάνειο',
    'account_type_mortgage'                     => 'Υποθήκη',
    'account_type_Credit card'                  => 'Πιστωτική κάρτα',
    'credit_card_type_monthlyFull'              => 'Εξόφληση κάθε μήνα',
    'liability_direction_credit'                => 'Μου οφείλουν αυτό το χρέος σε μένα',
    'liability_direction_debit'                 => 'Οφείλω αυτό το χρέος σε κάποιον άλλο',
    'liability_direction_credit_short'          => 'Μου οφείλουν αυτό το χρέος',
    'liability_direction_debit_short'           => 'Οφείλω αυτό το χρέος',
    'liability_direction__short'                => 'Άγνωστο',
    'liability_direction_null_short'            => 'Άγνωστο',
    'Liability credit'                          => 'Πίστωση υποχρέωσης',
    'budgets'                                   => 'Προϋπολογισμοί',
    'tags'                                      => 'Ετικέτες',
    'reports'                                   => 'Αναφορές',
    'transactions'                              => 'Συναλλαγές',
    'expenses'                                  => 'Δαπάνες',
    'income'                                    => 'Έσοδα',
    'transfers'                                 => 'Μεταφορές',
    'moneyManagement'                           => 'Διαχείριση χρημάτων',
    'money_management'                          => 'Διαχείριση χρημάτων',
    'tools'                                     => 'Εργαλεία',
    'piggyBanks'                                => 'Κουμπαράδες',
    'piggy_banks'                               => 'Κουμπαράδες',
    'amount_x_of_y'                             => '{current} από {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Ανάληψη',
    'opening_balance'                           => 'Υπόλοιπο έναρξης',
    'deposit'                                   => 'Κατάθεση',
    'account'                                   => 'Λογαριασμός',
    'transfer'                                  => 'Μεταφορά',
    'Withdrawal'                                => 'Ανάληψη',
    'Deposit'                                   => 'Κατάθεση',
    'Transfer'                                  => 'Μεταφορά',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Ναι',
    'no'                                        => 'Όχι',
    'amount'                                    => 'Ποσό',
    'overview'                                  => 'Επισκόπηση',
    'saveOnAccount'                             => 'Εντός του λογαριασμού',
    'saveOnAccounts'                            => 'Εντός του λογαριασμού(ών)',
    'unknown'                                   => 'Άγνωστο',
    'monthly'                                   => 'Μηνιαίως',
    'profile'                                   => 'Προφίλ',
    'errors'                                    => 'Σφάλματα',
    'debt_start_date'                           => 'Ημερομηνία έναρξης χρέους',
    'debt_start_amount'                         => 'Αρχικό ποσό χρέους',
    'debt_start_amount_help'                    => 'Είναι πάντα καλύτερα να ορίζετε σε αυτήν την τιμή ένα αρνητικό ποσό. Διαβάστε τις σελίδες βοήθειας (εικονίδιο (?) επάνω δεξιά) για περισσότερες πληροφορίες.',
    'interest_period_help'                      => 'Αυτό το πεδίο είναι διακοσμητικό και δεν θα υπολογιστεί για εσάς. Όπως φαίνεται, οι τράπεζες είναι αρκετά πονηρές οπότε το Firefly III δεν το βρίσκει ποτέ σωστά.',
    'store_new_liabilities_account'             => 'Αποθήκευση νέας υποχρέωσης',
    'edit_liabilities_account'                  => 'Επεξεργασία υποχρέωσης ":name"',
    'financial_control'                         => 'Οικονομικός έλεγχος',
    'accounting'                                => 'Λογιστική',
    'automation'                                => 'Αυτοματοποίηση',
    'others'                                    => 'Λοιπά',
    'classification'                            => 'Ταξινόμηση',
    'store_transaction'                         => 'Αποθήκευση συναλλαγής',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Προεπιλεγμένη οικονομική αναφορά μεταξύ :start και :end',
    'report_audit'                              => 'Επισκόπηση ιστορικού συναλλαγών μεταξύ :start και :end',
    'report_category'                           => 'Αναφορά κατηγορίας μεταξύ :start και :end',
    'report_double'                             => 'Έκθεση λογαριασμών δαπανών/εσόδων μεταξύ :start και :end',
    'report_budget'                             => 'Αναφορά προϋπολογισμού μεταξύ :start και :end',
    'report_tag'                                => 'Αναφορά ετικετών μεταξύ :start και :end',
    'quick_link_reports'                        => 'Άμεσοι σύνδεσμοι',
    'quick_link_examples'                       => 'Αυτά είναι μερικά παραδείγματα συνδέσμων για να ξεκινήσετε. Δείτε τις σελίδες βοήθειας στο κουμπί (?) για πληροφορίες σχετικά με όλες τις αναφορές και τις μαγικές λέξεις που μπορείτε να χρησιμοποιήσετε.',
    'quick_link_default_report'                 => 'Προεπιλεγμένη οικονομική αναφορά',
    'quick_link_audit_report'                   => 'Επισκόπηση ιστορικού συναλλαγών',
    'report_this_month_quick'                   => 'Αυτός ο μήνας, όλοι οι λογαριασμοί',
    'report_last_month_quick'                   => 'Προηγούμενος μήνας, όλοι οι λογαριασμοί',
    'report_this_year_quick'                    => 'Αυτό το έτος, όλοι οι λογαριασμοί',
    'report_this_fiscal_year_quick'             => 'Τρέχων οικονομικό έτος, όλοι οι λογαριασμοί',
    'report_all_time_quick'                     => 'Για όλο το διάστημα, όλοι οι λογαριασμοί',
    'reports_can_bookmark'                      => 'Θυμηθείτε ότι οι αναφορές μπορούν να καταχωρηθούν σε σελιδοδείκτες.',
    'incomeVsExpenses'                          => 'Έσοδα έναντι δαπανών',
    'accountBalances'                           => 'Υπόλοιπα λογαριασμών',
    'balanceStart'                              => 'Υπόλοιπο έναρξης περιόδου',
    'balanceEnd'                                => 'Υπόλοιπο λήξης περιόδου',
    'splitByAccount'                            => 'Διαχωρισμός ανά λογαριασμό',
    'coveredWithTags'                           => 'Καλύπτεται με ετικέτες',
    'leftInBudget'                              => 'Απομένουν στον προϋπολογισμό',
    'left_in_debt'                              => 'Οφειλόμενο ποσό',
    'sumOfSums'                                 => 'Σύνολο υποσυνόλων',
    'noCategory'                                => '(χωρίς κατηγορία)',
    'notCharged'                                => 'Χωρίς χρέωση (ακόμα)',
    'inactive'                                  => 'Ανενεργό',
    'active'                                    => 'Ενεργό',
    'difference'                                => 'Διαφορά',
    'money_flowing_in'                          => 'Εισροές',
    'money_flowing_out'                         => 'Εκροές',
    'topX'                                      => 'τα πρώτα :number',
    'show_full_list'                            => 'Εμφάνιση ολόκληρης της λίστας',
    'show_only_top'                             => 'Εμφάνισε μόνο τα πρώτα :number',
    'report_type'                               => 'Τύπος Αναφοράς',
    'report_type_default'                       => 'Προκαθορισμένη οικονομική αναφορά',
    'report_type_audit'                         => 'Επισκόπηση ιστορικού συναλλαγών (έλεγχος)',
    'report_type_category'                      => 'Αναφορά κατηγοριών',
    'report_type_budget'                        => 'Αναφορά προϋπολογισμών',
    'report_type_tag'                           => 'Αναφορά ετικετών',
    'report_type_double'                        => 'Έκθεση λογαριασμών δαπανών/εσόδων',
    'more_info_help'                            => 'Περισσότερες πληροφορίες σχετικά με αυτούς τους τύπους αναφορών μπορούν να βρεθούν στις σελίδες βοήθειας. Πατήστε το εικονίδιο (?) στην επάνω δεξιά γωνία.',
    'report_included_accounts'                  => 'Συμπεριλαμβανόμενοι λογαριασμοί',
    'report_date_range'                         => 'Χρονικό διάστημα',
    'report_preset_ranges'                      => 'Καθορισμένο διάστημα',
    'shared'                                    => 'Κοινοί',
    'fiscal_year'                               => 'Οικονομικό έτος',
    'income_entry'                              => 'Έσοδα από λογαριασμό ":name" μεταξύ :start και :end',
    'expense_entry'                             => 'Δαπάνες στο λογαριασμό ":name" μεταξύ :start και :end',
    'category_entry'                            => 'Δαπάνες και έσοδα στην κατηγορία ":name" μεταξύ :start και :end',
    'budget_spent_amount'                       => 'Δαπάνες του προϋπολογισμού ":budget" μεταξύ :start και :end',
    'balance_amount'                            => 'Δαπάνες του προϋπολογισμού ":budget" που θα πληρωθούν από το λογαριασμό ":account" μεταξύ :start και :end',
    'no_audit_activity'                         => 'Καμία δραστηριότητα δεν καταγράφηκε στο λογαριασμό <a href=":url" title=":account_name">:account_name</a> μεταξύ :start και :end.',
    'audit_end_balance'                         => 'Το υπόλοιπο του λογαριασμού <a href=":url" title=":account_name">:account_name</a> στο τέλος του :end ήταν :balance',
    'reports_extra_options'                     => 'Επιπλέον επιλογές',
    'report_has_no_extra_options'               => 'Αυτή η αναφορά δεν έχει επιπλέον επιλογές',
    'reports_submit'                            => 'Προβολή αναφοράς',
    'end_after_start_date'                      => 'Η ημερομηνία λήξης της αναφοράς πρέπει να είναι μεταγενέστερη της ημερομηνίας έναρξης.',
    'select_category'                           => 'Επιλογή κατηγοριών',
    'select_budget'                             => 'Επιλογή προϋπολογισμών',
    'select_tag'                                => 'Επιλογή ετικετών',
    'income_per_category'                       => 'Έσοδα ανά κατηγορία',
    'expense_per_category'                      => 'Δαπάνη ανά κατηγορία',
    'expense_per_budget'                        => 'Δαπάνη ανά προϋπολογισμό',
    'income_per_account'                        => 'Έσοδα ανά λογαριασμό',
    'expense_per_account'                       => 'Δαπάνη ανά λογαριασμό',
    'expense_per_tag'                           => 'Δαπάνη ανά ετικέτα',
    'income_per_tag'                            => 'Έσοδα ανά ετικέτα',
    'include_expense_not_in_budget'             => 'Οι συμπεριλαμβανόμενες δαπάνες δεν περιλαμβάνονται στον επιλεγμένο προϋπολογισμό(ους)',
    'include_expense_not_in_account'            => 'Οι συμπεριλαμβανόμενες δαπάνες δεν περιλαμβάνονται στον επιλεγμένο λογαριασμό(ους)',
    'include_expense_not_in_category'           => 'Οι συμπεριλαμβανόμενες δαπάνες δεν περιλαμβάνονται στην επιλεγμένη κατηγορία(ες)',
    'include_income_not_in_category'            => 'Τα συμπεριλαμβανόμενα έσοδα δεν είναι στην επιλεγμένη κατηγορία(ες)',
    'include_income_not_in_account'             => 'Τα συμπεριλαμβανόμενα έσοδα δεν είναι στον επιλεγμένο λογαριασμό(ους)',
    'include_income_not_in_tags'                => 'Τα συμπεριλαμβανόμενα έσοδα δεν είναι στην επιλεγμένη ετικέτα(ες)',
    'include_expense_not_in_tags'               => 'Οι συμπεριλαμβανόμενες δαπάνες δεν περιλαμβάνονται στην επιλεγμένη ετικέτα(ες)',
    'everything_else'                           => 'Οτιδήποτε άλλο',
    'income_and_expenses'                       => 'Έσοδα και δαπάνες',
    'spent_average'                             => 'Δαπάνες (μέσος όρος)',
    'income_average'                            => 'Έσοδα (μέσος όρος)',
    'transaction_count'                         => 'Καταμέτρηση συναλλαγών',
    'average_spending_per_account'              => 'Μέσες δαπάνες ανά λογαριασμό',
    'average_income_per_account'                => 'Μέσος όρος εσόδων ανά λογαριασμό',
    'total'                                     => 'Σύνολο',
    'description'                               => 'Περιγραφή',
    'sum_of_period'                             => 'Σύνολο περιόδου',
    'average_in_period'                         => 'Μέσος όρος περιόδου',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Βασικός λογαριασμός κεφαλαίου',
    'account_role_sharedAsset'                  => 'Κοινός λογαριασμός κεφαλαίου',
    'account_role_savingAsset'                  => 'Λογαριασμός αποταμίευσης',
    'account_role_ccAsset'                      => 'Πιστωτική κάρτα',
    'account_role_cashWalletAsset'              => 'Πορτοφόλι μετρητών',
    'budget_chart_click'                        => 'Κάντε κλικ σε ένα όνομα προϋπολογισμού στον παραπάνω πίνακα για να δείτε ένα διάγραμμα.',
    'category_chart_click'                      => 'Κάντε κλικ σε ένα όνομα κατηγορίας στον παραπάνω πίνακα για να δείτε ένα διάγραμμα.',
    'in_out_accounts'                           => 'Κέρδη και δαπάνες ανά συνδυασμό',
    'in_out_accounts_per_asset'                 => 'Κέρδη και δαπάνες (ανά λογαριασμό κεφαλαίου)',
    'in_out_per_category'                       => 'Κέρδη και δαπάνες ανά κατηγορία',
    'out_per_budget'                            => 'Δαπάνες ανά προϋπολογισμό',
    'select_expense_revenue'                    => 'Επιλέξτε λογαριασμό δαπανών/εσόδων',
    'multi_currency_report_sum'                 => 'Επειδή αυτή η λίστα περιέχει λογαριασμούς με πολλαπλά νομίσματα, το σύνολο(α) που βλέπετε μπορεί να μην έχει νόημα. Η αναφορά θα επιστρέφει πάντα στο προεπιλεγμένο σας νόμισμα.',
    'sum_in_default_currency'                   => 'Το σύνολο θα είναι πάντοτε στο προεπιλεγμένο σας νόμισμα.',
    'net_filtered_prefs'                        => 'Αυτό το διάγραμμα δε θα περιλαμβάνει ποτέ λογαριασμούς που δεν έχουν τσεκαρισμένη την επιλογή "Συμπεριλαμβάνεται στην καθαρή αξία".',


    // charts:
    'chart'                                     => 'Διάγραμμα',
    'month'                                     => 'Μήνας',
    'budget'                                    => 'Προϋπολογισμός',
    'spent'                                     => 'Δαπανήθηκαν',
    'spent_capped'                              => 'Δαπανήθηκαν (με όριο)',
    'spent_in_budget'                           => 'Δαπάνες ανά προϋπολογισμό',
    'left_to_spend'                             => 'Διαθέσιμα προϋπολογισμών',
    'earned'                                    => 'Κερδήθηκαν',
    'overspent'                                 => 'Υπέρβαση προϋπολογισμών',
    'left'                                      => 'Απομένουν',
    'max-amount'                                => 'Μέγιστο ποσό',
    'min-amount'                                => 'Ελάχιστο ποσό',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Όνομα',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Ημερομηνία',
    'date_and_time'                             => 'Ημερομηνία και ώρα',
    'time'                                      => 'Ώρα',
    'paid'                                      => 'Πληρωμένο',
    'unpaid'                                    => 'Απλήρωτο',
    'day'                                       => 'Ημέρα',
    'budgeted'                                  => 'Προϋπολογισμένο',
    'period'                                    => 'Περίοδος',
    'balance'                                   => 'Ισοζύγιο',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Σύνολο',
    'summary'                                   => 'Σύνοψη',
    'average'                                   => 'Μέσος όρος',
    'balanceFor'                                => 'Υπόλοιπο για :name',
    'no_tags'                                   => '(χωρίς ετικέτες)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Δέσμευση χρημάτων για τον κουμπαρά ":name"',
    'piggy_bank'                    => 'Κουμπαράς',
    'new_piggy_bank'                => 'Νέος κουμπαράς',
    'store_piggy_bank'              => 'Αποθήκευση νέου κουμπαρά',
    'stored_piggy_bank'             => 'Αποθήκευση του νέου κουμπαρά ":name"',
    'account_status'                => 'Κατάσταση λογαριασμού',
    'left_for_piggy_banks'          => 'Διαθέσιμα προς δέσμευση',
    'sum_of_piggy_banks'            => 'Σύνολο κουμπαράδων',
    'saved_so_far'                  => 'Δεσμεύτηκαν',
    'saved_so_far_total'            => 'Αποταμιεύτηκαν μέχρι στιγμής',
    'reset_history'                 => 'επαναφορά ιστορικού',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'Έγινε επαναφορά του ιστορικού του κουμπαρά',
    'left_to_save'                  => 'Απομένουν για αποταμίευση',
    'suggested_amount'              => 'Προτεινόμενο μηνιαίο ποσό για δέσμευση',
    'add_money_to_piggy_title'      => 'Δέσμευση χρημάτων για τον κουμπαρά ":name"',
    'remove_money_from_piggy_title' => 'Αποδέσμευση χρημάτων από τον κουμπαρά ":name"',
    'add'                           => 'Προσθήκη',
    'no_money_for_piggy'            => 'Δεν έχετε διαθέσιμα χρήματα προς δέσμευση για αυτόν τον κουμπαρά.',
    'suggested_savings_per_month'   => 'Προτείνεται ανά μήνα',

    'remove'                    => 'Αφαίρεση',
    'max_amount_add'            => 'Το μέγιστο ποσό που μπορείτε να δεσμεύσετε είναι',
    'max_amount_remove'         => 'Το μέγιστο ποσό που μπορείτε να αποδεσμεύσετε είναι',
    'update_piggy_button'       => 'Ενημέρωση κουμπαρά',
    'update_piggy_title'        => 'Ενημέρωση του κουμπαρά ":name"',
    'updated_piggy_bank'        => 'Ενημερώθηκε ο κουμπαράς":name"',
    'details'                   => 'Λεπτομέρειες',
    'events'                    => 'Συμβάντα',
    'target_amount'             => 'Ποσό στόχου',
    'start_date'                => 'Ημερομηνία έναρξης',
    'no_start_date'             => 'Χωρίς ημερομηνία έναρξης',
    'target_date'               => 'Ημερομηνία επίτευξης στόχου',
    'no_target_date'            => 'Χωρίς ημερομηνία επίτευξης στόχου',
    'table'                     => 'Πίνακας',
    'delete_piggy_bank'         => 'Διαγραφή του κουμπαρά ":name"',
    'cannot_add_amount_piggy'   => 'Δεν ήταν δυνατή η προσθήκη :amount στο ":name".',
    'cannot_remove_from_piggy'  => 'Δεν ήταν δυνατή η αποδέσμευση :amount από το ":name".',
    'deleted_piggy_bank'        => 'Διαγράφηκε ο κουμπαράς ":name"',
    'added_amount_to_piggy'     => 'Δεσμεύτηκαν :amount για το ":name"',
    'removed_amount_from_piggy' => 'Αποδεσμεύτηκαν :amount από το ":name"',
    'piggy_events'              => 'Σχετικοί κουμπαράδες',

    // tags
    'delete_tag'                => 'Διαγραφή ετικέτας ":tag"',
    'deleted_tag'               => 'Διαγράφηκε η ετικέτα ":tag"',
    'new_tag'                   => 'Δημιουργία νέας ετικέτας',
    'edit_tag'                  => 'Επεξεργασία ετικέτας ":tag"',
    'updated_tag'               => 'Ενημερώθηκε η ετικέτα ":tag"',
    'created_tag'               => 'Η ετικέτα ":tag" δημιουργήθηκε!',

    'transaction_journal_information'               => 'Πληροφορίες συναλλαγής',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Πληροφορίες μεταδεδομένων',
    'transaction_journal_more'                      => 'Περισσότερες πληροφορίες',
    'basic_journal_information'                     => 'Βασικές πληροφορίες συναλλαγής',
    'transaction_journal_extra'                     => 'Περισσότερες πληροφορίες',
    'att_part_of_journal'                           => 'Αποθηκεύτηκε στο ":journal"',
    'total_amount'                                  => 'Συνολικό ποσό',
    'number_of_decimals'                            => 'Πλήθος δεκαδικών ψηφίων',


    // administration
    'invite_is_already_redeemed'                    => 'Η πρόσκληση στο ":address" έχει ήδη χρησιμοποιηθεί.',
    'invite_is_deleted'                             => 'Η πρόσκληση στο ":address" έχει διαγραφεί.',
    'invite_new_user_title'                         => 'Πρόσκληση νέου χρήστη',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Διεύθυνση E-mail',
    'invite_user'                                   => 'Πρόσκληση χρήστη',
    'user_is_invited'                               => 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου ":address" έλαβε πρόσκληση για εγγραφή στο Firefly III',
    'administration'                                => 'Διαχείριση',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Ο κωδικός πρόσκλησης έχει χρησιμοποιηθεί',
    'user_administration'                           => 'Διαχείριση χρηστών',
    'list_all_users'                                => 'Όλοι οι χρήστες',
    'all_users'                                     => 'Όλοι οι χρήστες',
    'instance_configuration'                        => 'Παραμετροποίηση',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'config_security' => 'Παραμετροποίηση ασφάλειας',
    'config_features' => 'Ενεργοποιημένα χαρακτηριστικά',
    'config_tech' => 'Τεχνολογικά χαρακτηριστικά',
    'config_external_connections' => 'Ρυθμίσεις με επιπτώσεις στην ιδιωτικότητα (συνδέεται στο διαδίκτυο)',

    'setting_enable_exchange_rates' => 'Ενεργοποίηση συναλλαγματικών ισοτιμιών',
    'setting_enable_exchange_rates_explain' => 'Το Firefly III έχει τη δυνατότητα υπολογισμού των συναλλαγματικών ισοτιμιών για εσάς.',
    'setting_use_running_balance' => 'Χρήση στήλης και δεδομένων «τρέχοντος υπολοίπου»',
    'setting_use_running_balance_explain' => 'Το Firefly III μπορεί να υπολογίζει το τρέχον τρέχον υπόλοιπο για εσάς και να το εμφανίζει σε διάφορα μέρη. Αυτή η λειτουργεί είναι ακόμα ελαφρώς πειραματική και γι\' αυτό απενεργοποιημένή από προεπιλογή. Ίσως χρειαστεί να επανεκκινήσετε το container σας ή να εκτελέσετε την αρχική εντολή χειροκίνητα (ανατρέξτε στην τεκμηρίωση).',
    'setting_enable_external_map' => 'Χρήση εξωτερικής υπηρεσίας χάρτη',
    'setting_enable_external_map_explain' => 'Το Firefly III χρησιμοποιεί μια εξωτερική υπηρεσία για την εμφάνιση τοποθεσιών. Συμφωνείτε με αυτό;',
    'setting_enable_external_rates' => 'Λήψη συναλλαγματικών ισοτιμιών από το διαδίκτυο',
    'setting_enable_external_rates_explain' => 'Το Firefly III μπορεί να κατεβάζει τις συναλλαγματικές ισοτιμίες για τα ενσωματωμένα νομίσματα. Αυτό προϋποθέτει τη χρήση του cron job.',
    'setting_allow_webhooks' => 'Να επιτρέπονται τα webhooks',
    'setting_allow_webhooks_explain' => 'Να επιτρέπεται στο Firefly III η αποστολή webhooks;',
    'setting_valid_url_protocols' => 'Επιτρεπόμενα πρωτόκολλα URL',
    'setting_valid_url_protocols_explain' => 'Το Firefly III δέχεται μόνο τα κοινά πρωτόκολλα όπως HTTPS και FTP στα URL. Αν έχετε τεχνικές γνώσεις, έχετε την επιλογή να επιτρέψετε και άλλα.',


    'setting_single_user_mode'                      => 'Λειτουργία ενός μοναδικού χρήστη',
    'setting_single_user_mode_explain'              => 'Λόγω προεπιλογής το Firefly III δέχεται μόνο μία (1) εγγραφή χρήστη: εσάς. Πρόκειται για ένα μέτρο ασφαλείας που εμποδίζει τους άλλους να χρησιμοποιήσουν την εγκατάστασή σας, εκτός αν τους επιτρέπετε. Οι μελλοντικές εγγραφές χρηστών αποκλείονται. Όταν καταργήσετε την επιλογή σε αυτό το κουτάκι, άλλοι χρήστες θα μπορούν να χρησιμοποιήσουν την εγκατάστασή σας ταυτόχρονα, υποθέτοντας ότι μπορούν να συνδεθούν (σε περίπτωση σύνδεσης στο διαδίκτυο).',
    'store_configuration'                           => 'Αποθήκευση παραμετροποίησης',
    'single_user_administration'                    => 'Διαχείριση χρήστη :email',
    'edit_user'                                     => 'Επεξεργασία χρήστη :email',
    'hidden_fields_preferences'                     => 'Μπορείτε να ενεργοποιήσετε περισσότερες επιλογές συναλλαγών στις <a href="/preferences">προτιμήσεις</a>.',
    'user_data_information'                         => 'Δεδομένα χρήστη',
    'user_information'                              => 'Πληροφορίες χρήστη',
    'total_size'                                    => 'συνολικό μέγεθος',
    'budget_or_budgets'                             => ':count προϋπολογισμός|:count προϋπολογισμοί',
    'budgets_with_limits'                           => ':count προϋπολογισμός με καθορισμένο ποσό|:count προϋπολογισμοί με καθορισμένο ποσό',
    'nr_of_rules_in_total_groups'                   => ':count_rules κανόνες σε :count_groups ομάδες κανόνων',
    'tag_or_tags'                                   => ':count ετικέτα|:count ετικέτες',
    'configuration_updated'                         => 'Η παραμετροποίηση ενημερώθηκε',
    'setting_is_demo_site'                          => 'Ιστοσελίδα επίδειξης',
    'setting_is_demo_site_explain'                  => 'Εάν επιλέξετε αυτό το κουτάκι, η εγκατάσταση θα συμπεριφέρεται σαν ιστοσελίδα επίδειξης, το οποίο μπορεί να έχει παράξενες παρενέργειες.',
    'block_code_bounced'                            => 'Το Email επέστρεψε χωρίς να έχει παραδοθεί',
    'block_code_expired'                            => 'Ο λογαριασμός επίδειξης έληξε',
    'no_block_code'                                 => 'Δεν υπάρχει λόγος για αποκλεισμό ή ο χρήστης δεν είναι αποκλεισμένος',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Ο χρήστης δεν έχει ακόμη επιβεβαιώσει τη νέα διεύθυνση ηλεκτρονικού ταχυδρομείου',
    'admin_update_email'                            => 'Σε αντίθεση με τη σελίδα προφίλ, ο χρήστης ΔΕΝ θα ειδοποιηθεί ότι η διεύθυνση του ηλεκτρονικού ταχυδρομείου του έχει αλλάξει!',
    'update_user'                                   => 'Ενημέρωση χρήστη',
    'updated_user'                                  => 'Τα δεδομένα χρήστη έχουν αλλάξει.',
    'delete_user'                                   => 'Διαγραφή χρήστη :email',
    'user_deleted'                                  => 'Ο χρήστης έχει διαγραφεί',
    'send_test_email'                               => 'Αποστολή δοκιμαστικού μηνύματος email',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Αποστολή μηνύματος',
    'send_test_triggered'                           => 'Η δοκιμή ενεργοποιήθηκε. Ελέγξτε τα εισερχόμενα μηνύματα στο Email σας και τα αρχεία καταγραφής.',
    'give_admin_careful'                            => 'Οι χρήστες στους οποίους έχουν δοθεί δικαιώματα διαχειριστή μπορούν να καθαιρέσουν τη δική σας πρόσβαση. Ενεργήστε με προσοχή.',
    'admin_maintanance_title'                       => 'Συντήρηση',
    'admin_maintanance_expl'                        => 'Χρήσιμες λειτουργίες για συντήρηση στο Firefly III',
    'admin_maintenance_clear_cache'                 => 'Εκκαθάριση cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'Όλοι οι προσκεκλημένοι χρήστες',
    'save_notification_settings'                    => 'Αποθήκευση ρυθμίσεων',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'Οι ρυθμίσεις ειδοποιήσεων έχουν αποθηκευτεί',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Περιγραφή της συναλλαγής με διαχωρισμό',
    'split_transaction_title_help'          => 'Εάν δημιουργήσετε μια διαχωρισμένη συναλλαγή, πρέπει να υπάρχει μια καθολική περιγραφή για όλους τους διαχωρισμούς της συναλλαγής.',
    'split_title_help'                      => 'Εάν δημιουργήσετε μια διαχωρισμένη συναλλαγή, πρέπει να υπάρχει μια καθολική περιγραφή για όλους τους διαχωρισμούς της συναλλαγής.',
    'you_create_transfer'                   => 'Δημιουργείτε μια μεταφορά.',
    'you_create_withdrawal'                 => 'Δημιουργείτε μια ανάληψη.',
    'you_create_deposit'                    => 'Δημιουργείτε μια κατάθεση.',

    // links
    'journal_link_configuration'            => 'Παραμετροποίηση συνδέσεων συναλλαγών',
    'create_new_link_type'                  => 'Δημιουργία νέου τύπου συνδέσμου',
    'store_new_link_type'                   => 'Αποθήκευση νέου τύπου συνδέσμου',
    'update_link_type'                      => 'Ενημέρωση τύπου συνδέσμου',
    'edit_link_type'                        => 'Επεξεργασία τύπου συνδέσμου ":name"',
    'updated_link_type'                     => 'Ενημερώθηκε ο σύνδεσμος τύπου ":name"',
    'delete_link_type'                      => 'Διαγραφή τύπου συνδέσμου ":name"',
    'deleted_link_type'                     => 'Διαγράφηκε ο τύπος συνδέσμου ":name"',
    'stored_new_link_type'                  => 'Αποθήκευση νέου τύπου συνδέσμου ":name"',
    'cannot_edit_link_type'                 => 'Αδύνατη η επεξεργασία του τύπου συνδέσμου ":name"',
    'link_type_help_name'                   => 'Πχ. "Διπλότυπα"',
    'link_type_help_inward'                 => 'Πχ. "διπλότυπα"',
    'link_type_help_outward'                => 'Πχ. "Είναι διπλότυπο από"',
    'save_connections_by_moving'            => 'Αποθηκεύστε το σύνδεσμο μεταξύ αυτών των συναλλαγών μετακινώντας τις σε έναν άλλο τύπο συνδέσμου:',
    'do_not_save_connection'                => '(μην αποθηκεύσεις την σύνδεση)',
    'link_transaction'                      => 'Σύνδεση συναλλαγής',
    'link_to_other_transaction'             => 'Σύνδεση αυτής της συναλλαγής με μια άλλη συναλλαγή',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Αυτή η συναλλαγή',
    'transaction'                           => 'Συναλλαγή',
    'comments'                              => 'Σχόλια',
    'link_notes'                            => 'Τυχόν σημειώσεις που θέλετε να αποθηκεύσετε με τη σύνδεση.',
    'invalid_link_selection'                => 'Δεν είναι δυνατή η σύνδεση αυτών των συναλλαγών',
    'selected_transaction'                  => 'Επιλεγμένη συναλλαγή',
    'journals_linked'                       => 'Οι συναλλαγές είναι συνδεδεμένες.',
    'journals_error_linked'                 => 'Αυτές οι συναλλαγές είναι ήδη συνδεδεμένες.',
    'journals_link_to_self'                 => 'Δεν μπορείτε να συνδέσετε μια συναλλαγή με τον εαυτό της',
    'journal_links'                         => 'Συνδέσεις συναλλαγών',
    'this_withdrawal'                       => 'Αυτή η ανάληψη',
    'this_deposit'                          => 'Αυτή η κατάθεση',
    'this_transfer'                         => 'Αυτή η μεταφορά',
    'overview_for_link'                     => 'Επισκόπηση για τύπο συνδέσμου ":name"',
    'source_transaction'                    => 'Συναλλαγή προέλευσης',
    'link_description'                      => 'Περιγραφή σύνδεσης',
    'destination_transaction'               => 'Συναλλαγή προορισμού',
    'delete_journal_link'                   => 'Διαγραφή του συνδέσμου μεταξύ <a href=":source_link">:source</a> και <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Διαγραμμένος σύνδεσμος',

    // link translations:
    'Paid_name'                             => 'Πληρωμένο',
    'Refund_name'                           => 'Επιστροφή χρημάτων',
    'Reimbursement_name'                    => 'Αποζημίωση',
    'Related_name'                          => 'Σχετικά',
    'relates to_inward'                     => 'σχετίζεται με',
    'is (partially) refunded by_inward'     => 'έχει επιστραφεί (εν μέρει) από',
    'is (partially) paid for by_inward'     => 'έχει πληρωθεί (εν μέρει) από',
    'is (partially) reimbursed by_inward'   => 'έχει αποζημιωθεί (εν μέρει) από',
    'inward_transaction'                    => 'Εσωτερική συναλλαγή',
    'outward_transaction'                   => 'Εξωτερική συναλλαγή',
    'relates to_outward'                    => 'σχετίζεται με',
    '(partially) refunds_outward'           => '(εν μέρει) επιστροφές',
    '(partially) pays for_outward'          => '(εν μέρει) πληρωμές για',
    '(partially) reimburses_outward'        => '(εν μέρει) αποζημιώσεις',
    'is (partially) refunded by'            => 'έχει επιστραφεί (εν μέρει) από',
    'is (partially) paid for by'            => 'έχει πληρωθεί (εν μέρει) από',
    'is (partially) reimbursed by'          => 'έχει αποζημιωθεί (εν μέρει) από',
    'relates to'                            => 'σχετίζεται με',
    '(partially) refunds'                   => 'επιστρέφει (εν μέρει) για',
    '(partially) pays for'                  => 'πληρώνει (εν μέρη) για',
    '(partially) reimburses'                => 'αποζημιώνει (εν μέρει) για',

    // split a transaction:
    'splits'                                => 'Διαχωρισμός',
    'add_another_split'                     => 'Προσθήκη ενός ακόμα διαχωρισμού',
    'cannot_edit_opening_balance'           => 'Δεν μπορείτε να επεξεργαστείτε το υπόλοιπο έναρξης ενός λογαριασμού.',
    'no_edit_multiple_left'                 => 'Δεν έχετε επιλέξει έγκυρες συναλλαγές για επεξεργασία.',
    'breadcrumb_convert_group'              => 'Μετατροπή συναλλαγής',
    'convert_invalid_source'                => 'Οι πληροφορίες προέλευσης δεν είναι έγκυρες για τη συναλλαγή #%d.',
    'convert_invalid_destination'           => 'Οι πληροφορίες προορισμού δεν είναι έγκυρες για τη συναλλαγή #%d.',
    'create_another'                        => 'Μετά την αποθήκευση, επιστρέψτε εδώ για να δημιουργήσετε ακόμη ένα.',
    'after_update_create_another'           => 'Μετά την ενημέρωση, επιστρέψτε εδώ για να συνεχίσετε την επεξεργασία.',
    'store_as_new'                          => 'Αποθήκευση ως νέα συναλλαγή αντί για ενημέρωση.',
    'reset_after'                           => 'Επαναφορά φόρμας μετά την υποβολή',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Ανάπτυξη διαχωρισμού',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Σύμπτυξη διαχωρισμού',

    // object groups
    'default_group_title_name'              => '(χωρίς ομάδα)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Ας δημιουργήσουμε ένα λογαριασμό κεφαλαίου!',
    'no_accounts_intro_asset'               => 'Δεν έχετε ακόμα λογαριασμούς κεφαλαίου. Οι κεφαλαιακοί λογαριασμοί είναι οι κύριοι λογαριασμοί σας: ο τρεχούμενος λογαριασμός, ο αποταμιευτικός λογαριασμός, ο κοινόχρηστος λογαριασμός ή ακόμα και η πιστωτική σας κάρτα.',
    'no_accounts_imperative_asset'          => 'Για να ξεκινήσετε τη χρήση του Firefly III, πρέπει να δημιουργήσετε τουλάχιστον ένα λογαριασμό κεφαλαίου. Ας το κάνουμε τώρα:',
    'no_accounts_create_asset'              => 'Δημιουργία νέου λογαριασμού κεφαλαίου',
    'no_accounts_title_expense'             => 'Ας δημιουργήσουμε ένα λογαριασμό δαπανών!',
    'no_accounts_intro_expense'             => 'Δεν έχετε ακόμα λογαριασμούς δαπανών. Οι λογαριασμοί δαπανών είναι τα μέρη που ξοδεύετε χρήματα, όπως τα καταστήματα και τα σούπερ μάρκετ.',
    'no_accounts_imperative_expense'        => 'Οι λογαριασμοί δαπανών δημιουργούνται αυτόματα όταν δημιουργείτε συναλλαγές, αλλά μπορείτε να δημιουργήσετε ένα και χειροκίνητα αν θέλετε. Ας δημιουργήσουμε ένα τώρα:',
    'no_accounts_create_expense'            => 'Δημιουργία νέου λογαριασμού δαπανών',
    'no_accounts_title_revenue'             => 'Ας δημιουργήσουμε ένα λογαριασμό εσόδων!',
    'no_accounts_intro_revenue'             => 'Δεν έχετε ακόμα λογαριασμούς εσόδων. Οι λογαριασμοί εσόδων είναι αυτοί από τους οποίους λαμβάνετε χρήματα, όπως ο μισθός ή είσπραξη ενοικίων.',
    'no_accounts_imperative_revenue'        => 'Οι λογαριασμοί εσόδων δημιουργούνται αυτόματα όταν δημιουργείτε συναλλαγές, αλλά μπορείτε να δημιουργήσετε έναν και χειροκίνητα, αν θέλετε. Ας δημιουργήσουμε έναν τώρα:',
    'no_accounts_create_revenue'            => 'Δημιουργία νέου λογαριασμού εσόδων',
    'no_accounts_title_liabilities'         => 'Ας δημιουργήσουμε μια υποχρέωση!',
    'no_accounts_intro_liabilities'         => 'Δεν έχετε ακόμα υποχρεώσεις. Οι υποχρεώσεις είναι οι λογαριασμοί που καταγράφουν δάνεια και διάφορα άλλα χρέη σας.',
    'no_accounts_imperative_liabilities'    => 'Δεν χρειάζεται να χρησιμοποιήσετε αυτή τη λειτουργία, αλλά μπορεί να σας φανεί χρήσιμη εάν θέλετε να επιβλέπετε αυτά τα πράγματα.',
    'no_accounts_create_liabilities'        => 'Δημιουργία μιας υποχρέωσης',
    'no_budgets_title_default'              => 'Ας δημιουργήσουμε ένα προϋπολογισμό',
    'no_rules_title_default'                => 'Ας δημιουργήσουμε ένα κανόνα',
    'no_budgets_intro_default'              => 'Δεν έχετε ακόμα προϋπολογισμούς. Οι προϋπολογισμοί χρησιμοποιούνται για την οργάνωση των εξόδων σας σε λογικές ομάδες, στις οποίες μπορείτε να ορίσετε ένα λογικό άνω όριο με σκοπό να περιορίσετε τα έξοδά σας.',
    'no_rules_intro_default'                => 'Δεν έχετε κανόνες ακόμα. Οι κανόνες είναι ισχυροί αυτοματισμοί που μπορούν να χειριστούν συναλλαγές για εσάς.',
    'no_rules_imperative_default'           => 'Οι κανόνες μπορεί να είναι πολύ χρήσιμοι όταν διαχειρίζεστε συναλλαγές. Ας δημιουργήσουμε τώρα έναν:',
    'no_budgets_imperative_default'         => 'Οι προϋπολογισμοί είναι τα βασικά εργαλεία της οικονομικής διαχείρισης. Ας δημιουργήσουμε έναν τώρα:',
    'no_budgets_create_default'             => 'Δημιουργία ενός προϋπολογισμού',
    'no_rules_create_default'               => 'Δημιουργία κανόνα',
    'no_categories_title_default'           => 'Ας δημιουργήσουμε μια κατηγορία!',
    'no_categories_intro_default'           => 'Δεν έχετε ακόμα κατηγορίες. Οι κατηγορίες χρησιμοποιούνται για την τελειοποίηση των συναλλαγών σας σημειώνοντας τη συγκεκριμένη κατηγορία τους.',
    'no_categories_imperative_default'      => 'Οι κατηγορίες δημιουργούνται αυτόματα όταν δημιουργείτε συναλλαγές, αλλά μπορείτε να δημιουργήσετε μία και χειροκίνητα. Ας δημιουργήσουμε μια τώρα:',
    'no_categories_create_default'          => 'Δημιουργία μιας κατηγορίας',
    'no_tags_title_default'                 => 'Ας δημιουργήσουμε μια ετικέτα!',
    'no_tags_intro_default'                 => 'Δεν έχετε ακόμα ετικέτες. Οι ετικέτες χρησιμοποιούνται για την τελειοποίηση των συναλλαγών σας σημειώνοντας συγκεκριμένες λέξεις-κλειδιά.',
    'no_tags_imperative_default'            => 'Οι ετικέτες δημιουργούνται αυτόματα όταν δημιουργείτε συναλλαγές, αλλά μπορείτε να δημιουργήσετε μια και χειροκίνητα. Ας δημιουργήσουμε μια τώρα:',
    'no_tags_create_default'                => 'Δημιουργία νέας ετικέτας',
    'no_transactions_title_withdrawal'      => 'Ας δημιουργήσουμε μια δαπάνη!',
    'no_transactions_intro_withdrawal'      => 'Δεν έχετε ακόμη δαπάνες. Θα πρέπει να δημιουργήσετε δαπάνες για να ξεκινήσετε τη διαχείριση των οικονομικών σας.',
    'no_transactions_imperative_withdrawal' => 'Έχετε δαπανήσει κάποια χρήματα; Τότε θα πρέπει να το γράψετε:',
    'no_transactions_create_withdrawal'     => 'Δημιουργία μιας δαπάνης',
    'no_transactions_title_deposit'         => 'Ας δημιουργήσουμε ένα έσοδο!',
    'no_transactions_intro_deposit'         => 'Δεν έχετε ακόμη καταχωρημένα έσοδα. Θα πρέπει να εισάγετε κάποια έσοδα για να ξεκινήσετε τη διαχείριση των οικονομικών σας.',
    'no_transactions_imperative_deposit'    => 'Έχετε λάβει κάποια χρήματα; Τότε θα πρέπει να το γράψετε:',
    'no_transactions_create_deposit'        => 'Δημιουργία κατάθεσης',
    'no_transactions_title_transfers'       => 'Ας δημιουργήσουμε μια μεταφορά!',
    'no_transactions_intro_transfers'       => 'Δεν έχετε καταχωρήσει μεταφορές. Όταν μετακινείτε χρήματα μεταξύ δύο κεφαλαιακών λογαριασμών, αυτό καταγράφεται ως μια μεταφορά.',
    'no_transactions_imperative_transfers'  => 'Έχετε κάνει κάποια μεταφορά χρημάτων; Τότε θα πρέπει να το γράψετε:',
    'no_transactions_create_transfers'      => 'Δημιουργία νέας μεταφοράς',
    'no_piggies_title_default'              => 'Ας δημιουργήσουμε ένα κουμπαρά!',
    'no_piggies_intro_default'              => 'Δεν έχετε ορίσει κάποιο κουμπαρά. Μπορείτε να δημιουργήσετε κουμπαράδες για να καθορίσετε τις αποταμιεύσεις σας και να επιβλέπετε την πρόοδο της εξοικονόμησης.',
    'no_piggies_imperative_default'         => 'Έχετε πράγματα για τα οποία εξοικονομείτε χρήματα; Δημιουργήστε ένα κουμπαρά για σωστή επίβλεψη:',
    'no_piggies_create_default'             => 'Δημιουργία ενός νέου κουμπαρά',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Δημιουργία αυτή τη στιγμή',
    'no_new_transaction_in_recurrence'      => 'Δε δημιουργήθηκε καμία νέα συναλλαγή. Μήπως ενεργοποιήθηκε ήδη για αυτή την ημερομηνία;',
    'recurrences'                           => 'Επαναλαμβανόμενες συναλλαγές',
    'repeat_until_in_past'                  => 'Αυτή η επαναλαμβανόμενη συναλλαγή σταμάτησε να επαναλαμβάνεται στις :date.',
    'recurring_calendar_view'               => 'Ημερολόγιο',
    'no_recurring_title_default'            => 'Ας δημιουργήσουμε μια επαναλαμβανόμενη συναλλαγή!',
    'no_recurring_intro_default'            => 'Δεν έχετε ακόμα επαναλαμβανόμενες συναλλαγές. Μπορείτε να τις χρησιμοποιήσετε για να κάνετε το Firefly III να δημιουργεί αυτόματα συναλλαγές για εσάς.',
    'no_recurring_imperative_default'       => 'Αυτό είναι ένα αρκετά προηγμένο χαρακτηριστικό αλλά μπορεί να είναι εξαιρετικά χρήσιμο. Βεβαιωθείτε ότι έχετε διαβάσει την τεκμηρίωση στο εικονίδιο (?) επάνω δεξιά γωνία, προτού συνεχίσετε.',
    'no_recurring_create_default'           => 'Δημιουργία νέας επαναλαμβανόμενης συναλλαγής',
    'make_new_recurring'                    => 'Δημιουργία νέας επαναλαμβανόμενης συναλλαγής',
    'recurring_daily'                       => 'Καθημερινά',
    'recurring_weekly'                      => 'Κάθε εβδομάδα την :weekday',
    'recurring_weekly_skip'                 => 'Κάθε :skip(η/α/η/η) εβδομάδα την :weekday',
    'recurring_monthly'                     => 'Κάθε μήνα την :dayOfMonthη ημέρα',
    'recurring_monthly_skip'                => 'Κάθε :skipο μήνα την :dayOfMonthη ημέρα',
    'recurring_ndom'                        => 'Κάθε μήνα την :dayOfMonthη :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Ετήσια στις :date',
    'overview_for_recurrence'               => 'Επισκόπηση της επαναλαμβανόμενης συναλλαγής ":title"',
    'warning_duplicates_repetitions'        => 'Σε σπάνιες περιπτώσεις, οι ημερομηνίες εμφανίζονται δύο φορές σε αυτήν τη λίστα. Αυτό μπορεί να συμβεί όταν επικαλύπτονται πολλές επαναλήψεις. Το Firefly III θα παράγει πάντα μία συναλλαγή την ημέρα.',
    'created_transactions'                  => 'Σχετικές συναλλαγές',
    'expected_withdrawals'                  => 'Αναμενόμενες αναλήψεις',
    'expected_deposits'                     => 'Αναμενόμενες καταθέσεις',
    'expected_transfers'                    => 'Αναμενόμενες μεταφορές',
    'created_withdrawals'                   => 'Δημιουργήθηκαν αναλήψεις',
    'created_deposits'                      => 'Δημιουργήθηκαν καταθέσεις',
    'created_transfers'                     => 'Δημιουργήθηκαν μεταφορές',
    'recurring_info'                        => 'Επαναλαμβανόμενη συναλλαγή :count / :total',
    'created_from_recurrence'               => 'Δημιουργήθηκε από την επαναλαμβανόμενη συναλλαγή ":title" (#:id)',
    'recurring_never_cron'                  => 'Φαίνεται ότι το cron job που είναι απαραίτητο για την υποστήριξη των επαναλαμβανόμενων συναλλαγών δεν έχει τρέξει ποτέ. Αυτό είναι φυσιολογικό εάν έχετε μόλις εγκαταστήσει το Firefly III, αλλά αυτό θα πρέπει να ρυθμιστεί το συντομότερο δυνατό. Ελέγξτε τις σελίδες βοήθειας χρησιμοποιώντας το εικονίδιο (?) στην επάνω δεξιά γωνία της σελίδας.',
    'recurring_cron_long_ago'               => 'Φαίνεται ότι έχουν περάσει περισσότερες από 36 ώρες από τότε που το cron job για την υποστήριξη επαναλαμβανόμενων συναλλαγών έχει τρέξει για τελευταία φορά. Είστε βέβαιοι ότι έχει ρυθμιστεί σωστά; Ελέγξτε τις σελίδες βοήθειας χρησιμοποιώντας το εικονίδιο (?) στην επάνω δεξιά γωνία της σελίδας.',

    'create_new_recurrence'              => 'Δημιουργία νέας επαναλαμβανόμενης συναλλαγής',
    'help_first_date'                    => 'Αναφέρετε την πρώτη αναμενόμενη επανάληψη. Αυτό πρέπει να γίνει σε μελλοντικό χρόνο.',
    'help_first_date_no_past'            => 'Αναφέρετε την πρώτη αναμενόμενη επανάληψη. Το Firefly III δεν θα δημιουργήσει συναλλαγές στο παρελθόν.',
    'no_currency'                        => '(χωρίς νόμισμα)',
    'mandatory_for_recurring'            => 'Υποχρεωτικές πληροφορίες επανάληψης',
    'mandatory_for_transaction'          => 'Υποχρεωτικές πληροφορίες συναλλαγής',
    'optional_for_recurring'             => 'Προαιρετικές πληροφορίες επανάληψης',
    'optional_for_transaction'           => 'Προαιρετικές πληροφορίες συναλλαγής',
    'change_date_other_options'          => 'Αλλάξτε την "αρχική ημερομηνία" για να δείτε περισσότερες επιλογές.',
    'mandatory_fields_for_tranaction'    => 'Αυτές οι τιμές καταλήγουν στις συναλλαγές που θα δημιουργούνται',
    'click_for_calendar'                 => 'Κάντε κλικ εδώ για ένα ημερολόγιο που σας δείχνει πότε θα επαναληφθεί η συναλλαγή.',
    'repeat_forever'                     => 'Επανάληψη για πάντα',
    'repeat_until_date'                  => 'Επανάληψη με ημερομηνία λήξης',
    'repeat_times'                       => 'Επανάληψη για συγκεκριμένο αριθμό',
    'recurring_skips_one'                => 'Κάθε άλλη',
    'recurring_skips_more'               => 'Παραλείπει :count εμφανίσεις',
    'store_new_recurrence'               => 'Αποθήκευση επαναλαμβανόμενης συναλλαγής',
    'stored_new_recurrence'              => 'Η επαναλαμβανόμενη συναλλαγή ":title" αποθηκεύτηκε επιτυχώς.',
    'edit_recurrence'                    => 'Επεξεργασία επαναλαμβανόμενης συναλλαγής ":title"',
    'recurring_repeats_until'            => 'Επαναλαμβάνεται έως τις :date',
    'recurring_repeats_forever'          => 'Επαναλαμβάνεται για πάντα',
    'recurring_repeats_x_times'          => 'Επαναλαμβάνεται :count φορά|Επαναλαμβάνεται :count φορές',
    'update_recurrence'                  => 'Ενημέρωση επαναλαμβανόμενης συναλλαγής',
    'updated_recurrence'                 => 'Ενημερώθηκε η επαναλαμβανόμενη συναλλαγή ":title"',
    'recurrence_is_inactive'             => 'Αυτή η επαναλαμβανόμενη συναλλαγή δεν είναι ενεργή και δε θα δημιουργήσει νέες συναλλαγές.',
    'delete_recurring'                   => 'Διαγραφή επαναλαμβανόμενης συναλλαγής ":title"',
    'new_recurring_transaction'          => 'Νέα επαναλαμβανόμενη συναλλαγή',
    'help_weekend'                       => 'Τι θα πρέπει να κάνει το Firefly III όταν μια επαναλαμβανόμενη συναλλαγή πέφτει σε Σάββατο ή Κυριακή;',
    'do_nothing'                         => 'Απλά δημιούργησε τη συναλλαγή',
    'skip_transaction'                   => 'Παράλειψη της εμφάνισης',
    'jump_to_friday'                     => 'Δημιουργία της συναλλαγής για την προηγούμενη Παρασκευή',
    'jump_to_monday'                     => 'Δημιουργία της συναλλαγής για την επόμενη Δευτέρα',
    'will_jump_friday'                   => 'Θα δημιουργηθεί την Παρασκευή αντί για Σαββατοκύριακα.',
    'will_jump_monday'                   => 'Θα δημιουργηθεί τη Δευτέρα αντί για Σαββατοκύριακο.',
    'except_weekends'                    => 'Εκτός από τα Σαββατοκύριακα',
    'recurrence_deleted'                 => 'Η επαναλαμβανόμενη συναλλαγή ":title" διαγράφηκε',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Υπόλοιπο (:currency)',
    'box_spent_in_currency'              => 'Δαπάνες (:currency)',
    'box_earned_in_currency'             => 'Κερδήθηκαν (:currency)',
    'box_budgeted_in_currency'           => 'Προϋπολογισμένο (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Διαθέσιμα προϋπολογισμών (:currency)',
    'box_net_worth_in_currency'          => 'Καθαρή αξία (:currency)',
    'box_spend_per_day'                  => 'Απομένουν για δαπάνες ανά ημέρα: :amount',

    // debug page
    'debug_page'                         => 'Σελίδα αποσφαλμάτωσης',
    'debug_submit_instructions'          => 'Εάν αντιμετωπίζετε προβλήματα, μπορείτε να χρησιμοποιήσετε τις πληροφορίες σε αυτό το πλαίσιο ως πληροφορίες εντοπισμού σφαλμάτων. Αντιγράψτε και επικολλήστε σε νέο ή υπάρχον <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Θα δημιουργήσει έναν όμορφο πίνακα που μπορεί να χρησιμοποιηθεί για τη γρήγορη διάγνωση του προβλήματός σας.',
    'debug_pretty_table'                 => 'Εάν αντιγράψετε / επικολλήσετε το παρακάτω πλαίσιο σε ένα GitHub issue, θα δημιουργήσει ένα πίνακα. Μην περιβάλλετε αυτό το κείμενο με backticks ή εισαγωγικά.',
    'debug_additional_data'              => 'Μπορείτε επίσης να μοιραστείτε το περιεχόμενο του παρακάτω πλαισίου. Μπορείτε επίσης να αντιγράψετε και να επικολλήσετε αυτό σε νέο ή υπάρχον <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Ωστόσο, το περιεχόμενο αυτού του πλαισίου ενδέχεται να περιέχει ιδιωτικές πληροφορίες, όπως ονόματα λογαριασμών, λεπτομέρειες συναλλαγής ή διευθύνσεις ηλεκτρονικού ταχυδρομείου.',

    // object groups
    'object_groups_menu_bar'             => 'Ομάδες',
    'object_groups_page_title'           => 'Ομάδες',
    'object_groups_breadcrumb'           => 'Ομάδες',
    'object_groups_index'                => 'Επισκόπηση',
    'object_groups'                      => 'Ομάδες',
    'object_groups_empty_explain'        => 'Ορισμένα στοιχεία στο Firefly III μπορούν να χωριστούν σε ομάδες. Οι κουμπαράδες, για παράδειγμα, διαθέτουν το πεδίο "Ομάδα" στις οθόνες επεξεργασίας και δημιουργίας. Όταν ορίζετε αυτό το πεδίο, μπορείτε να επεξεργαστείτε τα ονόματα και τη σειρά των ομάδων σε αυτήν τη σελίδα. Για περισσότερες πληροφορίες, ανατρέξτε στις σελίδες βοήθειας στην επάνω δεξιά γωνία, στο εικονίδιο (?).',
    'object_group_title'                 => 'Τίτλος',
    'edit_object_group'                  => 'Επεξεργασία ομάδας ":title"',
    'delete_object_group'                => 'Διαγραφή ομάδας ":title"',
    'update_object_group'                => 'Ενημέρωση ομάδας',
    'updated_object_group'               => 'Επιτυχής ενημέρωση της ομάδας ":title"',
    'deleted_object_group'               => 'Επιτυχής διαγραφή της ομάδας ":title"',
    'object_group'                       => 'Ομάδα',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Δεν καταγράφονται όλα τα συμβάντα στο αρχείο καταγραφής.',
    'audit_log_entries'                  => 'Έλεγχος καταχώρησης',
    'ale_action_log_add'                 => 'Προστέθηκαν :amount στον κουμπαρά ":name"',
    'ale_action_log_remove'              => 'Αφαιρέθηκαν :amount από τον κουμπαρά ":name"',
    'ale_action_clear_budget'            => 'Αφαιρέθηκε από τον προϋπολογισμό',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Αφαιρέθηκε από την κατηγορία',
    'ale_action_clear_notes'             => 'Αφαιρέθηκαν σημειώσεις',
    'ale_action_clear_tag'               => 'Αφαίρεση ετικέτας',
    'ale_action_clear_all_tags'          => 'Αφαίρεση όλων των ετικετών',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Ορισμός προϋπολογισμού',
    'ale_action_set_category'            => 'Ορισμός κατηγορίας',
    'ale_action_set_source'              => 'Ορισμός λογαριασμού προέλευσης',
    'ale_action_set_destination'         => 'Ορισμός λογαριασμού προορισμού',
    'ale_action_update_transaction_type' => 'Αλλαγή τύπου συναλλαγής',
    'ale_action_update_notes'            => 'Αλλαγή σημειώσεων',
    'ale_action_update_description'      => 'Αλλαγή περιγραφής',
    'ale_action_add_to_piggy'            => 'Κουμπαράς',
    'ale_action_remove_from_piggy'       => 'Κουμπαράς',
    'ale_action_add_tag'                 => 'Προστέθηκε ετικέτα',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
