<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'almacenado en ":timezone"',
    'displayed_in_tz'                           => 'mostrado en ":timezone"',
    'close'                                     => 'Cerrar',
    'actions'                                   => 'Acciones',
    'edit'                                      => 'Editar',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'El ID del diario de transacción',
    'delete'                                    => 'Eliminar',
    'split'                                     => 'Separar',
    'single_split'                              => 'División',
    'clone'                                     => 'Duplicar',
    'clone_and_edit'                            => 'Clonar y editar',
    'confirm_action'                            => 'Confirmar acción',
    'last_seven_days'                           => 'Últimos siete días',
    'last_thirty_days'                          => 'Últimos treinta días',
    'last_180_days'                             => 'Últimos 180 días',
    'month_to_date'                             => 'Mes hasta la fecha',
    'year_to_date'                              => 'Año a la fecha',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'Año en curso',
    'welcome_back'                              => '¿Qué está pasando?',
    'main_dashboard_page_title'                 => 'Inicio',
    'everything'                                => 'Todo',
    'today'                                     => 'hoy',
    'customRange'                               => 'Rango personalizado',
    'date_range'                                => 'Rango de fechas',
    'apply'                                     => 'Aplicar',
    'select_date'                               => 'Seleccionar fecha...',
    'cancel'                                    => 'Cancelar',
    'from'                                      => 'Desde',
    'to'                                        => 'Hasta',
    'structure'                                 => 'Estructura',
    'help_translating'                          => 'Este texto de ayuda no está disponible en tu idioma. <a href="https://crowdin.com/project/firefly-iii-help">¿Nos ayudaría a traducir?</a>',
    'showEverything'                            => 'Mostrar todo',
    'never'                                     => 'Nunca',
    'no_results_for_empty_search'               => 'Su búsqueda estaba vacía, por lo que no se encontró nada.',
    'removed_amount'                            => 'Eliminado :amount',
    'added_amount'                              => 'Añadido :amount',
    'asset_account_role_help'                   => 'Las opciones extras como resultado de su elección se pueden establecer más tarde.',
    'Opening balance'                           => 'Balance inicial',
    'create_new_stuff'                          => 'Crear nueva etiqueta',
    'new_withdrawal'                            => 'Nuevo gasto',
    'create_new_transaction'                    => 'Crear una nueva transacción',
    'sidebar_frontpage_create'                  => 'Crear',
    'new_transaction'                           => 'Nueva transacción',
    'no_rules_for_bill'                         => 'Esta suscripción no tiene reglas asociadas a ella.',
    'go_to_asset_accounts'                      => 'Ver tus cuentas de activos',
    'go_to_budgets'                             => 'Ir a tus presupuestos',
    'go_to_withdrawals'                         => 'Ir a tus gastos',
    'clones_journal_x'                          => 'Esta transacción es una copia de ":description" (#:id)',
    'go_to_categories'                          => 'Ir a tus categorías',
    'go_to_bills'                               => 'Ir a tus suscripciones',
    'go_to_expense_accounts'                    => 'Ver tus cuentas de gastos',
    'go_to_revenue_accounts'                    => 'Ver tus cuentas de ingresos',
    'go_to_piggies'                             => 'Ir a tu hucha',
    'new_deposit'                               => 'Nuevo ingreso',
    'new_transfer'                              => 'Nueva transferencia',
    'new_transfers'                             => 'Nueva transferencia',
    'new_asset_account'                         => 'Nueva cuenta de activo',
    'new_expense_account'                       => 'Nueva cuenta de gastos',
    'new_revenue_account'                       => 'Nueva cuenta de ingresos',
    'new_liabilities_account'                   => 'Nuevo pasivo',
    'new_budget'                                => 'Nuevo presupuesto',
    'new_bill'                                  => 'Nueva suscripción',
    'block_account_logout'                      => 'Tu sesión ha sido cerrada. Las cuentas bloqueadas no pueden utilizar este sitio. ¿Registrarte con una dirección válida de correo electrónico?',
    'flash_success'                             => '¡Operación correcta!',
    'flash_info'                                => 'Mensaje',
    'flash_warning'                             => '¡Advertencia!',
    'flash_error'                               => '¡Error!',
    'flash_danger'                              => '¡Peligro!',
    'flash_info_multiple'                       => 'Hay un mensaje | Hay :count mensajes',
    'flash_error_multiple'                      => 'Hay un error|Hay :count errores',
    'net_worth'                                 => 'Valor Neto',
    'help_for_this_page'                        => 'Ayuda para esta página',
    'help_for_this_page_body'                   => 'Puedes encontrar más información sobre esta página <a href="https://docs.firefly-iii.org/">en la documentación</a>.',
    'two_factor_welcome'                        => '¡Hola!',
    'two_factor_enter_code'                     => 'Para continuar, introduce tu código de autenticación de dos pasos. La aplicación puede generarlo para usted.',
    'two_factor_code_here'                      => 'Introducir el código aquí',
    'two_factor_title'                          => 'Autenticación en dos pasos',
    'authenticate'                              => 'Autentificar',
    'two_factor_forgot_title'                   => 'Autenticación en dos pasos perdida',
    'two_factor_forgot'                         => 'Olvidé mi cosa de dos factores.',
    'two_factor_lost_header'                    => '¿Perdiste tu autenticación de doble factor?',
    'two_factor_lost_intro'                     => 'Si también perdiste tus códigos de copia de seguridad, tienes mala suerte. Esto no es algo que puedas arreglar desde la interfaz web. Tienes dos opciones.',
    'two_factor_lost_fix_self'                  => 'Si ejecutas tu propia instancia de Firefly III, lee <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">esta entrada en el FAQ</a> para obtener instrucciones.',
    'two_factor_lost_fix_owner'                 => 'De lo contrario, comunícate por mail con el dueño del sitio, <a href="mailto::site_owner">:site_owner</a> y pídele que restablezca tu autenticación de dos pasos.',
    'mfa_backup_code'                           => 'Has usado un código de respaldo para iniciar sesión en Firefly III. No se puede usar de nuevo, así que táchalo de tu lista.',
    'pref_two_factor_new_backup_codes'          => 'Obtener nuevos códigos de copia de seguridad',
    'pref_two_factor_backup_code_count'         => 'Tienes un código de seguridad válido. |Tienes :count códigos de seguridad válidos.',
    '2fa_i_have_them'                           => '¡Los he guardado!',
    'warning_much_data'                         => ':days días de datos pueden tardar en cargarse.',
    'registered'                                => '¡Te has registrado con éxito!',
    'Default asset account'                     => 'Cuenta de activos por defecto',
    'no_budget_pointer'                         => 'Parece que aún no tienes presupuestos. Debes crear algunos en la página <a href="budgets">presupuestos</a>. Los presupuestos pueden ayudarle a realizar un seguimiento de los gastos.',
    'no_bill_pointer'                           => 'Parece que aún no tienes suscripción. Deberías crear algunas en la página <a href="subscriptions">suscripción</a>. Las suscripciones pueden ayudarte a llevar un seguimiento de los gastos.',
    'Savings account'                           => 'Cuenta de ahorros',
    'Credit card'                               => 'Tarjeta de crédito',
    'source_accounts'                           => 'Cuenta origen|Cuentas de origen',
    'destination_accounts'                      => 'Cuenta de destino|Cuentas de destino',
    'user_id_is'                                => 'Tu id de usuario es <strong>:user</strong>',
    'field_supports_markdown'                   => 'Este campo admite <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Si necesita más ayuda con Firefly III, por favor <a href="https://github.com/firefly-iii/firefly-iii/issues">abre un ticket en Github</a>.',
    'reenable_intro_text'                       => 'También puedes reactivar <a href="#" id="reenableGuidance">la guía de introducción</a>.',
    'intro_boxes_after_refresh'                 => 'Los cuadros de introducción volverán a aparecer cuando actualices la página.',
    'show_all_no_filter'                        => 'Mostrar todas las transacciones sin agruparlas por fecha.',
    'expenses_by_category'                      => 'Gastos por categoría',
    'expenses_by_budget'                        => 'Gastos por presupuesto',
    'income_by_category'                        => 'Ingresos por categoría',
    'expenses_by_asset_account'                 => 'Gastos por cuenta de activos',
    'expenses_by_expense_account'               => 'Gastos por cuenta de destino',
    'cannot_redirect_to_account'                => 'Firefly III no puede redirigirlo a la página correcta. Disculpas.',
    'sum_of_expenses'                           => 'Total gastos',
    'sum_of_income'                             => 'Total ingresos',
    'liabilities'                               => 'Pasivos',
    'spent_in_specific_budget'                  => 'Gastado en el presupuesto ":budget"',
    'spent_in_specific_double'                  => 'Gastado en cuenta ":account"',
    'earned_in_specific_double'                 => 'Ganado en cuenta ":account"',
    'source_account'                            => 'Cuenta origen',
    'source_account_reconciliation'             => 'No puedes editar la cuenta de origen de una transacción de reconciliación.',
    'destination_account'                       => 'Cuenta destino',
    'destination_account_reconciliation'        => 'No puedes editar la cuenta de destino de una transacción de reconciliación.',
    'sum_of_expenses_in_budget'                 => 'Total gastado en el presupuesto ":budget"',
    'left_in_budget_limit'                      => 'Disponible para gasto según presupuesto',
    'current_period'                            => 'Período actual',
    'show_the_current_period_and_overview'      => 'Mostrar el período actual y el resumen',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'Para que un idioma distinto al inglés funcione correctamente, su sistema operativo debe disponer de la información regional correcta. Si no está disponible, los datos de divisas, fechas y cantidades pueden tener un formato incorrecto.',
    'budget_in_period'                          => 'Todas las transacciones del presupuesto ":name" entre :start y :end en :currency',
    'chart_budget_in_period'                    => 'Gráfico para todas las transacciones del presupuesto ":name" entre :start y :end en :currency',
    'chart_budget_in_period_only_currency'      => 'La cantidad que presupuestaste fue en :currency, por lo que este gráfico sólo mostrará transacciones en :currency.',
    'chart_account_in_period'                   => 'Gráfico para las transacciones de la cuenta ":name" (:balance) entre :start y :end',
    'chart_category_in_period'                  => 'Gráfico para las transacciones de la categoría ":name" entre :start y :end',
    'chart_category_all'                        => 'Gráfico para las transacciones de la categoría ":name"',
    'clone_withdrawal'                          => 'Duplicar este gasto',
    'clone_deposit'                             => 'Duplicar este ingreso',
    'clone_transfer'                            => 'Duplicar esta transferencia',
    'multi_select_no_selection'                 => 'Ninguno seleccionado',
    'multi_select_select_all'                   => 'Seleccionar todo',
    'multi_select_n_selected'                   => 'seleccionado',
    'multi_select_all_selected'                 => 'Todos seleccionados',
    'multi_select_filter_placeholder'           => 'Buscar...',
    'intro_next_label'                          => 'Siguiente',
    'intro_prev_label'                          => 'Anterior',
    'intro_skip_label'                          => 'Saltar',
    'intro_done_label'                          => 'Hecho',
    'between_dates_breadcrumb'                  => 'Entre :start y :end',
    'all_journals_without_budget'               => 'Todas las transacciones sin presupuesto',
    'journals_without_budget'                   => 'Transacciones sin presupuesto',
    'all_journals_without_category'             => 'Todas las transacciones sin categoría',
    'journals_without_category'                 => 'Transacciones sin categoría',
    'all_journals_for_account'                  => 'Todas las transacciones de la cuenta :name',
    'chart_all_journals_for_account'            => 'Gráfico de todas las transacciones de la cuenta :name',
    'journals_in_period_for_account'            => 'Todas las transacciones por cuenta :name entre :start y :end',
    'journals_in_period_for_account_js'         => 'Todas las transacciones de la cuenta {title} entre {start} y {end}',
    'transferred'                               => 'Transferido',
    'all_withdrawal'                            => 'Todos los gastos',
    'all_transactions'                          => 'Todas las transacciones',
    'title_withdrawal_between'                  => 'Todos los gastos entre :start y :end',
    'all_deposit'                               => 'Todos los ingresos',
    'title_deposit_between'                     => 'Todos los ingresos entre :start y :end',
    'all_transfers'                             => 'Todas las transferencias',
    'title_transfers_between'                   => 'Todas las transferencias entre :start y :end',
    'all_transfer'                              => 'Todas las transferencias',
    'all_journals_for_tag'                      => 'Todas las transacciones etiquetadas como ":tag"',
    'title_transfer_between'                    => 'Todas las transferencias entre :start y :end',
    'all_journals_for_category'                 => 'Todas las transacciones para la categoría :name',
    'all_journals_for_budget'                   => 'Todas las transacciones para el presupuesto :name',
    'chart_all_journals_for_budget'             => 'Gráfico de todas las transacciones para presupuesto :name',
    'journals_in_period_for_category'           => 'Todas las transacciones para la categoría :name entre :start y :end',
    'journals_in_period_for_tag'                => 'Todas las transacciones para etiqueta :tag entre :start y :end',
    'not_available_demo_user'                   => 'La característica a la que tratas de acceder no está disponible para usuarios de la demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'La cuenta de activos "@source_name" solo acepta transacciones en "@source_currency". cuenta de activos de destino "@dest_name" solo acepta transacciones en @dest_currency. Debes indicar la cantidad correcta transferida en ambas monedas.',
    'transaction_data'                          => 'Datos de transacción',
    'invalid_server_configuration'              => 'Configuración de servidor no válida',
    'invalid_locale_settings'                   => 'Firefly III no puede dar formato a las cantidades monetarias porque a tu servidor le faltan los paquetes necesarios. Hay <a href="">instrucciones de cómo hacerlo</a>.',
    'quickswitch'                               => 'Cambio rápido',
    'sign_in_to_start'                          => 'Iniciar sesión para comenzar',
    'sign_in'                                   => 'Iniciar sesión',
    'register_new_account'                      => 'Registrar una nueva cuenta',
    'forgot_my_password'                        => 'He olvidado mi contraseña',
    'problems_with_input'                       => 'Hubo algunos problemas con su entrada.',
    'reset_password'                            => 'Restablecer su contraseña',
    'button_reset_password'                     => 'Restablecer contraseña',
    'reset_button'                              => 'Restablecer',
    'want_to_login'                             => 'Quiero iniciar sesión',
    'login_page_title'                          => 'Iniciar sesión en Firefly III',
    'register_page_title'                       => 'Registrarse en Firefly III',
    'forgot_pw_page_title'                      => 'Olvidaste tu contraseña para Firefly III',
    'reset_pw_page_title'                       => 'Restablecer contraseña para Firefly III',
    'cannot_reset_demo_user'                    => 'No puedes restablecer la contraseña del usuario demo.',
    'no_att_demo_user'                          => 'El usuario de demostración no puede subir archivos adjuntos.',
    'button_register'                           => 'Registrarse',
    'authorization'                             => 'Autorización',
    'active_bills_only'                         => 'solo suscripción activa',
    'active_bills_only_total'                   => 'todas las suscripciones activas',
    'active_exp_bills_only'                     => 'solo suscripciones activas y esperadas',
    'active_exp_bills_only_total'               => 'todas las suscripciones activas esperadas',
    'per_period_sum_1D'                         => 'Costes diarios esperados',
    'per_period_sum_1W'                         => 'Costes semanales esperados',
    'per_period_sum_1M'                         => 'Costes mensuales esperados',
    'per_period_sum_3M'                         => 'Costes trimestrales esperados',
    'per_period_sum_6M'                         => 'Costes semestrales esperados',
    'per_period_sum_1Y'                         => 'Costes anuales esperados',
    'average_per_bill'                          => 'promedio por suscripción',
    'expected_total'                            => 'total esperado',
    'reconciliation_account_name'               => ':name reconciliación (:currency)',
    'saved'                                     => 'Guardado',
    'advanced_options'                          => 'Opciones avanzadas',
    'advanced_options_explain'                  => 'Algunas páginas de Firefly III tienen opciones avanzadas ocultas detrás de este botón. Esta página no tiene nada elegante, ¡pero echa un vistazo a las demás!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III ha detectado que tiene transacciones previas al año 1970. Por favor, corrija estas transacciones lo antes posible.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'deshabilitado',
    'no_webhook_messages'                       => 'No hay mensajes webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Después de crear la transacción',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Después de actualizar la transacción',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Después de eliminar la transacción',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Detalles de la transacción',
    'webhook_response_ACCOUNTS'                 => 'Detalles de la cuenta',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspeccionar',
    'create_new_webhook'                        => 'Crear un nuevo webhook',
    'webhooks_create_breadcrumb'                => 'Crear un nuevo Webhook',
    'webhook_trigger_form_help'                 => 'Indica en qué evento se activará el webhook',
    'webhook_response_form_help'                => 'Indique lo que el webhook debe enviar a la URL.',
    'webhook_delivery_form_help'                => 'En qué formato debe entregar los datos el webhook.',
    'webhook_active_form_help'                  => 'El webhook debe estar activo o no será llamado.',
    'stored_new_webhook'                        => 'Nuevo webhook almacenado ":title"',
    'delete_webhook'                            => 'Eliminar webhook',
    'deleted_webhook'                           => 'Webhook eliminado ":title"',
    'edit_webhook'                              => 'Editar webhook ":title " "',
    'updated_webhook'                           => 'Webhook actualizado ":title"',
    'edit_webhook_js'                           => 'Editar webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'El disparador se activó en la transacción indicada. Por favor, espere a que aparezcan los resultados.',
    'webhook_messages'                          => 'Mensaje de Webhook',
    'view_message'                              => 'Ver mensaje',
    'view_attempts'                             => 'Ver intentos fallidos',
    'message_content_title'                     => 'Contenido del mensaje del webhook',
    'message_content_help'                      => 'Este es el contenido del mensaje que se envió (o se intentó) usando este webhook.',
    'attempt_content_title'                     => 'Intentos de webhook',
    'attempt_content_help'                      => 'Estos son todos los intentos fallidos de enviar este mensaje de webhook a la URL configurada. Después de algún tiempo, Firefly III dejará de intentarlo.',
    'no_attempts'                               => 'No hay intentos fallidos. ¡Eso es bueno!',
    'webhook_attempt_at'                        => 'Intento a las {moment}',
    'logs'                                      => 'Registros',
    'response'                                  => 'Respuesta',
    'visit_webhook_url'                         => 'Visita la URL del webhook',
    'reset_webhook_secret'                      => 'Restablecer secreto del webhook',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">El webhook #{ID} ("{title}")</a> ha sido almacenado.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">El webhook #{ID} ("{title}")</a> ha sido actualizado.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Solicitud de autorización',
    'authorization_request_intro'               => '<strong>:client</strong> está pidiendo permiso para acceder a la administración de tus finanzas. ¿Deseas autorizar a <strong>:client</strong> a acceder a estos datos?',
    'authorization_request_site'                => 'Serás redirigido a <code>:url</code>, que podrá acceder a tus datos de Firefly III.',
    'authorization_request_invalid'             => 'Esta solicitud de acceso no es válida. Por favor, no vuelva a abrir este enlace.',
    'scopes_will_be_able'                       => 'Esta aplicación podrá:',
    'button_authorize'                          => 'Autorizar',
    'none_in_select_list'                       => '(ninguno)',
    'no_piggy_bank'                             => '(sin hucha)',
    'name_in_currency'                          => ':name en :currency',
    'paid_in_currency'                          => 'Pagado en :currency',
    'unpaid_in_currency'                        => 'Impagado en :currency',
    'is_alpha_warning'                          => 'Estás ejecutando una versión ALPHA. Ten cuidado con los errores y problemas.',
    'is_beta_warning'                           => 'Estás ejecutando una versión BETA. Ten cuidado con los errores y problemas.',
    'all_destination_accounts'                  => 'Cuentas destino',
    'all_source_accounts'                       => 'Cuentas origen',
    'back_to_index'                             => 'Volver al Índice',
    'cant_logout_guard'                         => 'Firefly III no puede cerrar sesión.',
    'internal_reference'                        => 'Referencia interna',

    // check for updates:
    'update_check_title'                        => 'Buscar actualizaciones',
    'admin_update_check_title'                  => 'Buscar actualizaciones automáticamente',
    'admin_update_check_explain'                => 'Firefly III puede buscar actualizaciones automáticamente. Cuando habilitas esta configuración, Firefly III contactará con el servidor de actualizaciones para comprobar si hay disponible una nueva versión. Cuando sea así, te llegará una notificación. Puedes probar esta notificación usando el botón de la derecha. Por favor, indica abajo si quieres que Firefly III busque actualizaciones.',
    'check_for_updates_permission'              => 'Firefly III puede comprobar si hay actualizaciones, pero necesita tu permiso para hacerlo. Vaya a la <a href=":link">ajustes</a> para indicar si desea que esta función esté habilitada.',
    'updates_ask_me_later'                      => 'Preguntarme mas tarde',
    'updates_do_not_check'                      => 'No buscar actualizaciones',
    'updates_enable_check'                      => 'Habilitar el buscar actualizaciones',
    'admin_update_check_now_title'              => 'Buscar actualizaciones ahora',
    'admin_update_check_now_explain'            => 'SI pulsas el botón, Firefly III comprobará si tu actual versión es la última.',
    'check_for_updates_button'                  => '¡Comprobar ahora!',
    'update_new_version_alert'                  => 'Una nueva versión de Firefly III esta disponible. Estás usando :your_version, la ultima versión es :new_version que se lanzó en :date.',
    'update_version_beta'                       => 'Esta versión es una versión BETA. Puede tener problemas.',
    'update_version_alpha'                      => 'Esta versión es una versión de ALPHA. Puede tener problemas.',
    'update_current_dev_older'                  => 'Estás ejecutando la versión de desarrollo ":version", que es más antigua que la última versión :new_version. ¡Por favor, actualice!',
    'update_current_dev_newer'                  => 'Estás ejecutando la versión de desarrollo ":version", que es más nueva que la última versión :new_version.',
    'update_current_version_alert'              => 'Estás usando :version, que es la última versión disponible.',
    'update_newer_version_alert'                => 'Estás usando :your_version, que es más reciente que la última versión, :new_version.',
    'update_check_error'                        => 'Se ha producido un error al buscar actualizaciones: :error',
    'unknown_error'                             => 'Error desconocido. Lo sentimos.',
    'disabled_but_check'                        => 'Has desactivado la comprobación de actualizaciones. Así que no olvides comprobar las actualizaciones tú mismo de vez en cuando. ¡Gracias!',
    'admin_update_channel_title'                => 'Canal de actualizaciones',
    'admin_update_channel_explain'              => 'Firefly III tiene tres "canales" de actualización que determinan cuán por delante está en términos de características, mejoras y errores. Usa el canal "beta" si eres aventurero y el "alfa" cuando quieras vivir la vida peligrosamente.',
    'update_channel_stable'                     => 'Estable. Todo debería funcionar como se espera.',
    'update_channel_beta'                       => 'Beta. Nuevas funcionalidades, pero las cosas pueden romperse.',
    'update_channel_alpha'                      => 'Alpha. Tiramos cosas y usamos lo que sea que se pegue.',

    // search
    'search'                                    => 'Buscar',
    'search_query'                              => 'Consulta',
    'search_found_transactions'                 => 'Firefly III encontrada :count transacción en :time segundos.|Firefly III encontradas :count transacciones en :time segundos.',
    'search_found_more_transactions'            => 'Firefly III encontró más de :count transacciones en :time segundos.',
    'search_for_overview'                       => 'Firefly III está buscando transacciones que cumplan <b>todas</b> de las siguientes condiciones:',
    'search_for_query'                          => 'Todas estas palabras deben estar presentes: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Ninguna de estas palabras puede estar presente: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Estos parámetros de búsqueda no son válidos y han sido ignorados.',

    // old


    'search_modifier_date_on'                             => 'La fecha de la transacción es ":value"',
    'search_modifier_not_date_on'                         => 'La fecha de la transacción no es ":value"',
    'search_modifier_reconciled'                          => 'La transacción está conciliada',
    'search_modifier_not_reconciled'                      => 'La transacción no está conciliada',
    'search_modifier_id'                                  => 'El ID de la transacción es ":value"',
    'search_modifier_not_id'                              => 'El ID de la transacción no es ":value"',
    'search_modifier_date_before'                         => 'La fecha de la transacción es anterior al ":value"',
    'search_modifier_date_after'                          => 'La fecha de la transacción es posterior al ":value"',
    'search_modifier_external_id_is'                      => 'La ID externo es ":value"',
    'search_modifier_not_external_id_is'                  => 'El ID externo no es ":value"',
    'search_modifier_no_external_url'                     => 'La transacción no tiene URL externa',
    'search_modifier_no_external_id'                      => 'La transacción no tiene ID externa',
    'search_modifier_not_any_external_url'                => 'La transacción no tiene URL externa',
    'search_modifier_not_any_external_id'                 => 'La transacción no tiene ID externa',
    'search_modifier_any_external_url'                    => 'La transacción debe tener alguna URL externa',
    'search_modifier_any_external_id'                     => 'La transacción debe tener una ID externa (cualquiera)',
    'search_modifier_not_no_external_url'                 => 'La transacción debe tener una URL externa (cualquiera)',
    'search_modifier_not_no_external_id'                  => 'La transacción debe tener una ID externa (cualquiera)',
    'search_modifier_internal_reference_is'               => 'La referencia interna es ":value"',
    'search_modifier_not_internal_reference_is'           => 'La referencia interna no es ":value"',
    'search_modifier_description_starts'                  => 'La descripción comienza con ":value"',
    'search_modifier_not_description_starts'              => 'La descripción no comienza con ":value"',
    'search_modifier_description_ends'                    => 'La descripción termina en ":value"',
    'search_modifier_not_description_ends'                => 'La descripción no termina en ":value"',
    'search_modifier_description_contains'                => 'La descripción contiene ":value"',
    'search_modifier_not_description_contains'            => 'La descripción no contiene ":value"',
    'search_modifier_description_is'                      => 'La descripción es exactamente ":value"',
    'search_modifier_not_description_is'                  => 'La descripción no es exactamente ":value"',
    'search_modifier_currency_is'                         => 'La transacción en moneda (extranjera) es ":value"',
    'search_modifier_not_currency_is'                     => 'La moneda (extranjera) de la transacción no es ":value"',
    'search_modifier_foreign_currency_is'                 => 'La transacción en moneda extranjera es ":value"',
    'search_modifier_not_foreign_currency_is'             => 'La moneda extranjera de la transacción no es ":value"',
    'search_modifier_has_attachments'                     => 'La transacción debe tener un archivo adjunto',
    'search_modifier_has_no_category'                     => 'La transacción no debe tener categoría',
    'search_modifier_not_has_no_category'                 => 'La transacción debe tener una categoría (cualquiera)',
    'search_modifier_not_has_any_category'                => 'La transacción no debe tener categoría',
    'search_modifier_has_any_category'                    => 'La transacción debe tener alguna categoría',
    'search_modifier_has_no_budget'                       => 'La transacción no debe tener presupuesto',
    'search_modifier_not_has_any_budget'                  => 'La transacción no debe tener presupuesto',
    'search_modifier_has_any_budget'                      => 'La transacción debe tener un presupuesto',
    'search_modifier_not_has_no_budget'                   => 'La transacción debe tener un presupuesto (cualquiera)',
    'search_modifier_has_no_bill'                         => 'La transacción no debe tener suscripción',
    'search_modifier_not_has_no_bill'                     => 'La transacción debe tener una (cualquiera) suscripción',
    'search_modifier_has_any_bill'                        => 'La transacción debe tener una (cualquiera) suscripción',
    'search_modifier_not_has_any_bill'                    => 'La transacción no debe tener suscripción',
    'search_modifier_has_no_tag'                          => 'La transacción no debe tener etiquetas',
    'search_modifier_not_has_any_tag'                     => 'La transacción no debe tener etiquetas',
    'search_modifier_not_has_no_tag'                      => 'La transacción debe tener una etiqueta (cualquiera)',
    'search_modifier_has_any_tag'                         => 'La transacción debe tener (alguna) etiqueta',
    'search_modifier_notes_contains'                      => 'Las notas de la transacción contienen ":value"',
    'search_modifier_not_notes_contains'                  => 'Las notas de la transacción no contienen ":value"',
    'search_modifier_notes_starts'                        => 'Las notas de la transacción comienzan con ":value"',
    'search_modifier_not_notes_starts'                    => 'Las notas de la transacción no comienzan con ":value"',
    'search_modifier_notes_ends'                          => 'Las notas de la transacción terminan con ":value"',
    'search_modifier_not_notes_ends'                      => 'Las notas de la transacción no terminan con ":value"',
    'search_modifier_notes_is'                            => 'Las notas de la transacción son exactamente ":value"',
    'search_modifier_not_notes_is'                        => 'Las notas de la transacción no son exactamente ":value"',
    'search_modifier_no_notes'                            => 'La transacción no tiene notas',
    'search_modifier_not_no_notes'                        => 'La transacción debe tener notas',
    'search_modifier_any_notes'                           => 'La transacción debe tener notas',
    'search_modifier_not_any_notes'                       => 'La transacción no tiene notas',
    'search_modifier_amount_is'                           => 'La cantidad es exactamente :value',
    'search_modifier_not_amount_is'                       => 'La cantidad no es :value',
    'search_modifier_amount_less'                         => 'Cantidad es menor o igual a :value',
    'search_modifier_not_amount_more'                     => 'La cantidad es menor o igual a :value',
    'search_modifier_amount_more'                         => 'Cantidad es mayor o igual a :value',
    'search_modifier_not_amount_less'                     => 'Cantidad es mayor o igual a :value',
    'search_modifier_source_account_is'                   => 'El nombre de la cuenta de origen es exactamente ":value"',
    'search_modifier_not_source_account_is'               => 'El nombre de la cuenta de origen no es exactamente ":value"',
    'search_modifier_source_account_contains'             => 'El nombre de la cuenta de origen contiene ":value"',
    'search_modifier_not_source_account_contains'         => 'El nombre de cuenta de origen no contiene ":value"',
    'search_modifier_source_account_starts'               => 'El nombre de la cuenta de origen comienza con ":value"',
    'search_modifier_not_source_account_starts'           => 'El nombre de cuenta de origen no comienza con ":value"',
    'search_modifier_source_account_ends'                 => 'El nombre de la cuenta de origen termina con ":value"',
    'search_modifier_not_source_account_ends'             => 'El nombre de la cuenta de origen no termina con ":value"',
    'search_modifier_source_account_id'                   => 'El ID de cuenta original es :value',
    'search_modifier_not_source_account_id'               => 'El ID de la cuenta de origen no es :value',
    'search_modifier_source_account_nr_is'                => 'Número de cuenta de origen (IBAN) es ":value"',
    'search_modifier_not_source_account_nr_is'            => 'El número de cuenta de origen (IBAN) no es ":value"',
    'search_modifier_source_account_nr_contains'          => 'El número de cuenta de origen (IBAN) contiene ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'El número de la cuenta de origen (IBAN) no contiene ":value"',
    'search_modifier_source_account_nr_starts'            => 'El número de cuenta de origen (IBAN) comienza con ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'El número de cuenta de origen (IBAN) no comienza con ":value"',
    'search_modifier_source_account_nr_ends'              => 'El número de cuenta fuente (IBAN) termina en ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'El número de cuenta de origen (IBAN) no termina en ":value"',
    'search_modifier_destination_account_is'              => 'El nombre de la cuenta de destino es exactamente ":value"',
    'search_modifier_not_destination_account_is'          => 'El nombre de cuenta de destino no es ":value"',
    'search_modifier_destination_account_contains'        => 'El nombre de la cuenta de destino contiene ":value"',
    'search_modifier_not_destination_account_contains'    => 'El nombre de cuenta de destino no contiene ":value"',
    'search_modifier_destination_account_starts'          => 'El nombre de cuenta de destino comienza con ":value"',
    'search_modifier_not_destination_account_starts'      => 'El nombre de cuenta de destino no comienza con ":value"',
    'search_modifier_destination_account_ends'            => 'El nombre de la cuenta de destino termina en ":value"',
    'search_modifier_not_destination_account_ends'        => 'El nombre de la cuenta de destino no termina en ":value"',
    'search_modifier_destination_account_id'              => 'El ID de la cuenta de destino es :value',
    'search_modifier_not_destination_account_id'          => 'El ID de cuenta de destino no es :value',
    'search_modifier_destination_is_cash'                 => 'La cuenta de destino es la cuenta "(efectivo)"',
    'search_modifier_not_destination_is_cash'             => 'La cuenta de destino no es la cuenta "(efectivo)"',
    'search_modifier_source_is_cash'                      => 'La cuenta de origen es la cuenta "(efectivo)"',
    'search_modifier_not_source_is_cash'                  => 'La cuenta de origen no es la cuenta "(efectivo)"',
    'search_modifier_destination_account_nr_is'           => 'El número de cuenta de destino (IBAN) es ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'El número de cuenta de destino (IBAN) es ":value"',
    'search_modifier_destination_account_nr_contains'     => 'El número de cuenta de destino (IBAN) contiene ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'El número de cuenta de destino (IBAN) no contiene ":value"',
    'search_modifier_destination_account_nr_starts'       => 'El número de cuenta de destino (IBAN) comienza con ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'El número de cuenta de destino (IBAN) no comienza con ":value"',
    'search_modifier_destination_account_nr_ends'         => 'El número de cuenta de destino (IBAN) termina con ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'El número de cuenta de destino (IBAN) no termina con ":value"',
    'search_modifier_account_id'                          => 'El ID de cuenta de origen o destino es/son: :value',
    'search_modifier_not_account_id'                      => 'Los ID de la cuenta de origen o destino no es/son: :value',
    'search_modifier_category_is'                         => 'La categoría es ":value"',
    'search_modifier_not_category_is'                     => 'La categoría no es ":value"',
    'search_modifier_budget_is'                           => 'El presupuesto es ":value"',
    'search_modifier_not_budget_is'                       => 'El presupuesto no es ":value"',
    'search_modifier_bill_is'                             => 'La suscripción es ":value"',
    'search_modifier_not_bill_is'                         => 'La suscripción no es ":value"',
    'search_modifier_transaction_type'                    => 'El tipo de transacción es ":value"',
    'search_modifier_not_transaction_type'                => 'El tipo de transacción no es ":value"',
    'search_modifier_tag_is'                              => 'La etiqueta es ":value"',
    'search_modifier_tag_contains'                        => 'La etiqueta contiene ":value"',
    'search_modifier_not_tag_contains'                    => 'La etiqueta no contiene ":value"',
    'search_modifier_tag_ends'                            => 'La etiqueta termina con ":value"',
    'search_modifier_tag_starts'                          => 'La etiqueta comienza con ":value"',
    'search_modifier_not_tag_is'                          => 'Ninguna etiqueta es ":value"',
    'search_modifier_date_on_year'                        => 'El año de la transacción es ":value"',
    'search_modifier_not_date_on_year'                    => 'El año de la transacción no es ":value"',
    'search_modifier_date_on_month'                       => 'El mes de la transacción es ":value"',
    'search_modifier_not_date_on_month'                   => 'El mes de la transacción no es ":value"',
    'search_modifier_date_on_day'                         => 'El día de la transacción es ":value"',
    'search_modifier_not_date_on_day'                     => 'La transacción no es el día del mes ":value"',
    'search_modifier_date_before_year'                    => 'El año de la transacción es anterior o igual a ":value"',
    'search_modifier_date_before_month'                   => 'El mes de la transacción es anterior o igual a ":value"',
    'search_modifier_date_before_day'                     => 'El día de la transacción es anterior o igual a ":value"',
    'search_modifier_date_after_year'                     => 'El año de la transacción es posterior o igual a ":value"',
    'search_modifier_date_after_month'                    => 'El mes de la transacción es posterior o igual a ":value"',
    'search_modifier_date_after_day'                      => 'El día de la transacción es posterior o igual a ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'La etiqueta no es ":value"',
    'search_modifier_not_tag_is_not'                      => 'La etiqueta es ":value"',
    'search_modifier_account_is'                          => 'Cualquier cuenta es ":value"',
    'search_modifier_not_account_is'                      => 'Ninguna cuenta es ":value"',
    'search_modifier_account_contains'                    => 'Cualquier cuenta contiene ":value"',
    'search_modifier_not_account_contains'                => 'Ninguna cuenta contiene ":value"',
    'search_modifier_account_ends'                        => 'Cualquier cuenta termina con ":value"',
    'search_modifier_not_account_ends'                    => 'Ninguna cuenta termina con ":value"',
    'search_modifier_account_starts'                      => 'Cualquier cuenta comienza con ":value"',
    'search_modifier_not_account_starts'                  => 'Ninguna cuenta comienza con ":value"',
    'search_modifier_account_nr_is'                       => 'Número / IBAN de cualquier cuenta es ":value"',
    'search_modifier_not_account_nr_is'                   => 'Ninguno de los números de cuenta / IBAN es ":value"',
    'search_modifier_account_nr_contains'                 => 'Número de cuenta / IBAN de cualquier cuenta contiene ":value"',
    'search_modifier_not_account_nr_contains'             => 'Ninguno de los números de cuenta / IBAN contiene ":value"',
    'search_modifier_account_nr_ends'                     => 'Número de cuenta / IBAN de cualquier cuenta termina con ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Ninguno de los números de cuenta / IBAN termina con ":value"',
    'search_modifier_account_nr_starts'                   => 'Número de cuenta / IBAN de cualquier cuenta empieza con ":value"',
    'search_modifier_not_account_nr_starts'               => 'Ninguno de los números de cuenta / IBAN comienza con ":value"',
    'search_modifier_category_contains'                   => 'La categoría contiene ":value"',
    'search_modifier_not_category_contains'               => 'La categoría no contiene ":value"',
    'search_modifier_category_ends'                       => 'La categoría termina en ":value"',
    'search_modifier_not_category_ends'                   => 'La categoría no termina en ":value"',
    'search_modifier_category_starts'                     => 'La categoría comienza con ":value"',
    'search_modifier_not_category_starts'                 => 'La categoría no empieza con ":value"',
    'search_modifier_budget_contains'                     => 'El presupuesto contiene ":value"',
    'search_modifier_not_budget_contains'                 => 'El presupuesto no contiene ":value"',
    'search_modifier_budget_ends'                         => 'El presupuesto termina con ":value"',
    'search_modifier_not_budget_ends'                     => 'El presupuesto no termina en ":value"',
    'search_modifier_budget_starts'                       => 'El presupuesto comienza con ":value"',
    'search_modifier_not_budget_starts'                   => 'El presupuesto no empieza con ":value"',
    'search_modifier_bill_contains'                       => 'La suscripción contiene ":value"',
    'search_modifier_not_bill_contains'                   => 'La suscripción no contiene ":value"',
    'search_modifier_bill_ends'                           => 'La suscripción termina en ":value"',
    'search_modifier_not_bill_ends'                       => 'La suscripción no termina en ":value"',
    'search_modifier_bill_starts'                         => 'La suscripción comienza con ":value"',
    'search_modifier_not_bill_starts'                     => 'La suscripción no comienza con ":value"',
    'search_modifier_external_id_contains'                => 'La ID externa contiene ":value"',
    'search_modifier_not_external_id_contains'            => 'El ID externo no contiene ":value"',
    'search_modifier_external_id_ends'                    => 'La ID externa termina con ":value"',
    'search_modifier_not_external_id_ends'                => 'El ID externo no termina en ":value"',
    'search_modifier_external_id_starts'                  => 'La ID externa comienza con ":value"',
    'search_modifier_not_external_id_starts'              => 'El ID externo no empieza con ":value"',
    'search_modifier_internal_reference_contains'         => 'La referencia interna contiene ":value"',
    'search_modifier_not_internal_reference_contains'     => 'La referencia interna no contiene ":value"',
    'search_modifier_internal_reference_ends'             => 'La referencia interna termina con ":value"',
    'search_modifier_internal_reference_starts'           => 'La referencia interna comienza con ":value"',
    'search_modifier_not_internal_reference_ends'         => 'La referencia interna no termina en ":value"',
    'search_modifier_not_internal_reference_starts'       => 'La referencia interna no empieza con ":value"',
    'search_modifier_external_url_is'                     => 'La URL externa es ":value"',
    'search_modifier_not_external_url_is'                 => 'La URL externa no es ":value"',
    'search_modifier_external_url_contains'               => 'La URL externa contiene ":value"',
    'search_modifier_not_external_url_contains'           => 'La URL externa no contiene ":value"',
    'search_modifier_external_url_ends'                   => 'La URL externa termina con ":value"',
    'search_modifier_not_external_url_ends'               => 'La URL externa no termina en ":value"',
    'search_modifier_external_url_starts'                 => 'La URL externa comienza con ":value"',
    'search_modifier_not_external_url_starts'             => 'La URL externa no empieza con ":value"',
    'search_modifier_has_no_attachments'                  => 'La transacción no tiene archivos adjuntos',
    'search_modifier_not_has_no_attachments'              => 'La transacción tiene archivos adjuntos',
    'search_modifier_not_has_attachments'                 => 'La transacción no tiene archivos adjuntos',
    'search_modifier_account_is_cash'                     => 'Cualquier cuenta es la cuenta de efectivo.',
    'search_modifier_not_account_is_cash'                 => 'Ninguna cuenta es la cuenta de efectivo.',
    'search_modifier_journal_id'                          => 'La ID del registro es ":value"',
    'search_modifier_not_journal_id'                      => 'La ID del registro no es ":value"',
    'search_modifier_recurrence_id'                       => 'El ID de transacción recurrente es ":value"',
    'search_modifier_not_recurrence_id'                   => 'El ID de transacción recurrente no es ":value"',
    'search_modifier_foreign_amount_is'                   => 'La cantidad en divisa extranjera es ":value"',
    'search_modifier_not_foreign_amount_is'               => 'La cantidad en divisa extranjera no es ":value"',
    'search_modifier_foreign_amount_less'                 => 'La cantidad en divisa extranjera es menor que ":value"',
    'search_modifier_not_foreign_amount_more'             => 'La cantidad en divisa extranjera es menor que ":value"',
    'search_modifier_not_foreign_amount_less'             => 'La cantidad en divisa extranjera es superior a ":value"',
    'search_modifier_foreign_amount_more'                 => 'La cantidad en divisa extranjera es superior a ":value"',
    'search_modifier_exists'                              => 'La transacción existe (cualquier transacción)',
    'search_modifier_not_exists'                          => 'La transacción no existe (ninguna transacción)',

    // date fields
    'search_modifier_interest_date_on'                    => 'La fecha de interés de la transacción es ":value"',
    'search_modifier_not_interest_date_on'                => 'La fecha de interés de la transacción no es ":value"',
    'search_modifier_interest_date_on_year'               => 'La fecha de interés de la transacción es en el año ":value"',
    'search_modifier_not_interest_date_on_year'           => 'La fecha de interés de la transacción no es en el año ":value"',
    'search_modifier_interest_date_on_month'              => 'La fecha de interés de la transacción es en el mes ":value"',
    'search_modifier_not_interest_date_on_month'          => 'La fecha de interés de la transacción no es en el mes ":value"',
    'search_modifier_interest_date_on_day'                => 'La fecha de interés de la transacción es en el día ":value"',
    'search_modifier_not_interest_date_on_day'            => 'La fecha de interés de la transacción no es en el día del mes ":value"',
    'search_modifier_interest_date_before_year'           => 'El año de interés de la transacción es anterior o igual a ":value"',
    'search_modifier_interest_date_before_month'          => 'La fecha de interés de la transacción es anterior o en el mes ":value"',
    'search_modifier_interest_date_before_day'            => 'La fecha de interés de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_interest_date_after_year'            => 'La fecha de interés de la transacción es posterior o en el año ":value"',
    'search_modifier_interest_date_after_month'           => 'La fecha de interés de la transacción es posterior o en el mes ":value"',
    'search_modifier_interest_date_after_day'             => 'La fecha de interés de la transacción es posterior o el día del mes ":value"',
    'search_modifier_book_date_on_year'                   => 'La fecha del registro de la transacción es en el año ":value"',
    'search_modifier_book_date_on_month'                  => 'La fecha del registro de la transacción es en el mes ":value"',
    'search_modifier_book_date_on_day'                    => 'La fecha del registro de la transacción es en el día del mes ":value"',
    'search_modifier_not_book_date_on_year'               => 'La fecha del registro de la transacción no es en el año ":value"',
    'search_modifier_not_book_date_on_month'              => 'La fecha del registro de la transacción no es en el mes ":value"',
    'search_modifier_not_book_date_on_day'                => 'La fecha del registro de la transacción no es en el día del mes ":value"',
    'search_modifier_book_date_before_year'               => 'La fecha del registro de la transacción es antes o en el año ":value"',
    'search_modifier_book_date_before_month'              => 'La fecha del registro de la transacción es antes o en el mes ":value"',
    'search_modifier_book_date_before_day'                => 'La fecha de registro de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_book_date_after_year'                => 'La fecha del registro de la transacción es después o en el año ":value"',
    'search_modifier_book_date_after_month'               => 'La fecha del registro de la transacción es después o en el mes ":value"',
    'search_modifier_book_date_after_day'                 => 'La fecha de registro de la transacción es después o en el día del mes ":value"',
    'search_modifier_process_date_on_year'                => 'La fecha del proceso de transacción es el año ":value"',
    'search_modifier_process_date_on_month'               => 'La fecha del proceso de transacción es en el mes ":value"',
    'search_modifier_process_date_on_day'                 => 'La fecha del proceso de transacción es el día del mes ":value"',
    'search_modifier_not_process_date_on_year'            => 'La fecha del proceso de transacción no es el año ":value"',
    'search_modifier_not_process_date_on_month'           => 'La fecha del proceso de transacción no es en el mes ":value"',
    'search_modifier_not_process_date_on_day'             => 'La fecha del proceso de transacción no es el día del mes ":value"',
    'search_modifier_process_date_before_year'            => 'La fecha del proceso de la transacción es antes o en el año ":value"',
    'search_modifier_process_date_before_month'           => 'La fecha del proceso de la transacción es antes o en el mes ":value"',
    'search_modifier_process_date_before_day'             => 'La fecha de proceso de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_process_date_after_year'             => 'La fecha del proceso de la transacción es después o en el año ":value"',
    'search_modifier_process_date_after_month'            => 'La fecha del proceso de la transacción es después o en el mes ":value"',
    'search_modifier_process_date_after_day'              => 'La fecha de proceso de la transacción es después o en el día del mes ":value"',
    'search_modifier_due_date_on_year'                    => 'La fecha de vencimiento de la transacción es en el año ":value"',
    'search_modifier_due_date_on_month'                   => 'La fecha del vencimiento de la transacción es en el mes ":value"',
    'search_modifier_due_date_on_day'                     => 'La fecha del vencimiento de la transacción es en el día del mes ":value"',
    'search_modifier_not_due_date_on_year'                => 'La fecha del vencimiento de la transacción no es en el año ":value"',
    'search_modifier_not_due_date_on_month'               => 'La fecha del vencimiento de la transacción no es en el mes ":value"',
    'search_modifier_not_due_date_on_day'                 => 'La fecha del vencimiento de la transacción no es en el día del mes ":value"',
    'search_modifier_due_date_before_year'                => 'La fecha de vencimiento de la transacción es antes o en el año ":value"',
    'search_modifier_due_date_before_month'               => 'La fecha de vencimiento de la transacción es antes o en el mes ":value"',
    'search_modifier_due_date_before_day'                 => 'La fecha de vencimiento de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_due_date_after_year'                 => 'La fecha del vencimiento de la transacción es después o en el año ":value"',
    'search_modifier_due_date_after_month'                => 'La fecha del vencimiento de la transacción es después o en el mes ":value"',
    'search_modifier_due_date_after_day'                  => 'La fecha de vencimiento de la transacción es después o en el día del mes ":value"',
    'search_modifier_payment_date_on_year'                => 'La fecha de pago de la transacción es en el año ":value"',
    'search_modifier_payment_date_on_month'               => 'La fecha de pago de la transacción es en el mes ":value"',
    'search_modifier_payment_date_on_day'                 => 'La fecha de pago de la transacción es el día del mes ":value"',
    'search_modifier_not_payment_date_on_year'            => 'La fecha de pago de la transacción no es en el año ":value"',
    'search_modifier_not_payment_date_on_month'           => 'La fecha de pago de la transacción no es en el mes ":value"',
    'search_modifier_not_payment_date_on_day'             => 'La fecha de pago de la transacción no es el día del mes ":value"',
    'search_modifier_payment_date_before_year'            => 'La fecha de pago de la transacción es antes o en el año ":value"',
    'search_modifier_payment_date_before_month'           => 'La fecha de pago de la transacción es antes o en el mes ":value"',
    'search_modifier_payment_date_before_day'             => 'La fecha de pago de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_payment_date_after_year'             => 'La fecha de pago de la transacción es después o en el año ":value"',
    'search_modifier_payment_date_after_month'            => 'La fecha de pago de la transacción es después o en el mes ":value"',
    'search_modifier_payment_date_after_day'              => 'La fecha de pago de la transacción es después o en el día del mes ":value"',
    'search_modifier_invoice_date_on_year'                => 'La fecha de facturación de la transacción es en el año ":value"',
    'search_modifier_invoice_date_on_month'               => 'La fecha de facturación de la transacción es en el mes ":value"',
    'search_modifier_invoice_date_on_day'                 => 'La fecha de facturación de la transacción es en el día ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'La fecha de facturación de la transacción no es en el año ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'La fecha de facturación de la transacción es en el mes ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'La fecha de facturación de la transacción no es en el día del mes ":value"',
    'search_modifier_invoice_date_before_year'            => 'La fecha de facturación de la transacción es antes o en el año ":value"',
    'search_modifier_invoice_date_before_month'           => 'La fecha de facturación de la transacción es antes o en el mes ":value"',
    'search_modifier_invoice_date_before_day'             => 'La fecha de facturación de la transacción es anterior o en el día del mes ":value"',
    'search_modifier_invoice_date_after_year'             => 'La fecha de facturación de la transacción es después o en el año ":value"',
    'search_modifier_invoice_date_after_month'            => 'La fecha de facturación de la transacción es después o en el mes ":value"',
    'search_modifier_invoice_date_after_day'              => 'La fecha de facturación de la transacción es después o en el día del mes ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'La transacción fue actualizada por última vez en el año":value"',
    'search_modifier_updated_at_on_month'                 => 'La transacción fue actualizada por última vez en el mes ":value"',
    'search_modifier_updated_at_on_day'                   => 'La transacción fue actualizada por última vez en el día del mes: ":value"',
    'search_modifier_not_updated_at_on_year'              => 'La transacción no fue actualizada por última vez en el año":value"',
    'search_modifier_not_updated_at_on_month'             => 'La transacción no fue actualizada por última vez en el mes ":value"',
    'search_modifier_not_updated_at_on_day'               => 'La transacción no fue actualizada por última vez en el día del mes ":value"',
    'search_modifier_updated_at_before_year'              => 'La transacción fue actualizada por última vez en o antes del año":value"',
    'search_modifier_updated_at_before_month'             => 'La transacción se actualizó por última vez en o antes del mes ":value"',
    'search_modifier_updated_at_before_day'               => 'La transacción se actualizó por última vez en o antes del día del mes ":value"',
    'search_modifier_updated_at_after_year'               => 'La transacción se actualizó por última vez en o después del año ":value"',
    'search_modifier_updated_at_after_month'              => 'La transacción se actualizó por última vez en o después del mes ":value"',
    'search_modifier_updated_at_after_day'                => 'La transacción se actualizó por última vez en o después día del mes ":value"',
    'search_modifier_created_at_on_year'                  => 'La transacción fue creada en el año":value"',
    'search_modifier_created_at_on_month'                 => 'La transacción fue creada en el mes ":value"',
    'search_modifier_created_at_on_day'                   => 'La transacción fue creada en el día del mes ":value"',
    'search_modifier_not_created_at_on_year'              => 'La transacción no fue creada en el año ":value"',
    'search_modifier_not_created_at_on_month'             => 'La transacción no fue creada en el mes ":value"',
    'search_modifier_not_created_at_on_day'               => 'La transacción no fue creada en el día del mes ":value"',
    'search_modifier_created_at_before_year'              => 'La transacción fue creada en o antes del año ":value"',
    'search_modifier_created_at_before_month'             => 'La transacción fue creada en o antes del mes ":value"',
    'search_modifier_created_at_before_day'               => 'La transacción fue creada en o antes del día del mes ":value"',
    'search_modifier_created_at_after_year'               => 'La transacción fue creada en o después del año ":value"',
    'search_modifier_created_at_after_month'              => 'La transacción fue creada en o después del mes ":value"',
    'search_modifier_created_at_after_day'                => 'La transacción fue creada en o después del día del mes ":value"',
    'search_modifier_interest_date_before'                => 'La fecha de interés de la transacción es en o antes de ":value"',
    'search_modifier_interest_date_after'                 => 'La fecha de interés de la transacción es en o después de ":value"',
    'search_modifier_book_date_on'                        => 'La fecha del registro de la transacción es en ":value"',
    'search_modifier_not_book_date_on'                    => 'La fecha del registro de la transacción no es en ":value"',
    'search_modifier_book_date_before'                    => 'La fecha de registro de la transacción es en o antes de ":value"',
    'search_modifier_book_date_after'                     => 'La fecha de registro de la transacción es en o después de ":value"',
    'search_modifier_process_date_on'                     => 'La fecha del proceso de transacción es el ":value"',
    'search_modifier_not_process_date_on'                 => 'La fecha del proceso de transacción no es el ":value"',
    'search_modifier_process_date_before'                 => 'La fecha de proceso de la transacción es en o antes de ":value"',
    'search_modifier_process_date_after'                  => 'La fecha de proceso de la transacción es en o después de ":value"',
    'search_modifier_due_date_on'                         => 'La fecha del vencimiento de la transacción es el ":value"',
    'search_modifier_not_due_date_on'                     => 'La fecha del vencimiento de la transacción no es el ":value"',
    'search_modifier_due_date_before'                     => 'La fecha de vencimiento de la transacción es en o antes de ":value"',
    'search_modifier_due_date_after'                      => 'La fecha de vencimiento de la transacción es en o después de ":value"',
    'search_modifier_payment_date_on'                     => 'La fecha de pago de transacción es el ":value"',
    'search_modifier_not_payment_date_on'                 => 'La fecha de pago de transacción no es el ":value"',
    'search_modifier_payment_date_before'                 => 'La fecha de pago de la transacción es en o antes de ":value"',
    'search_modifier_payment_date_after'                  => 'La fecha de pago de la transacción es en o después de ":value"',
    'search_modifier_invoice_date_on'                     => 'La fecha del facturación de la transacción es el ":value"',
    'search_modifier_not_invoice_date_on'                 => 'La fecha del facturación de la transacción no es el ":value"',
    'search_modifier_invoice_date_before'                 => 'La fecha de facturación de la transacción es en o antes de ":value"',
    'search_modifier_invoice_date_after'                  => 'La fecha de facturación de la transacción es en o después de ":value"',
    'search_modifier_created_at_on'                       => 'La transacción fue creada el ":value"',
    'search_modifier_not_created_at_on'                   => 'La transacción no fue creada el ":value"',
    'search_modifier_created_at_before'                   => 'La transacción fue creada en o antes de ":value"',
    'search_modifier_created_at_after'                    => 'La transacción fue creada en o después de ":value"',
    'search_modifier_updated_at_on'                       => 'La transacción fue actualizada el ":value"',
    'search_modifier_not_updated_at_on'                   => 'La transacción no fue actualizada el ":value"',
    'search_modifier_updated_at_before'                   => 'La transacción fue actualizada en o antes de ":value"',
    'search_modifier_updated_at_after'                    => 'La transacción fue actualizada en o después de ":value"',

    'search_modifier_attachment_name_is'            => 'El nombre de cualquier adjunto es ":value"',
    'search_modifier_attachment_name_contains'      => 'El nombre de cualquier adjunto contiene ":value"',
    'search_modifier_attachment_name_starts'        => 'El nombre de cualquier adjunto comienza con ":value"',
    'search_modifier_attachment_name_ends'          => 'El nombre de cualquier adjunto termina con ":value"',
    'search_modifier_attachment_notes_are'          => 'Las notas de cualquier adjunto son ":value"',
    'search_modifier_attachment_notes_contains'     => 'Las notas de cualquier adjunto contienen ":value"',
    'search_modifier_attachment_notes_starts'       => 'Las notas de cualquier adjunto comienzan con ":value"',
    'search_modifier_attachment_notes_ends'         => 'Las notas de cualquier adjunto terminan con ":value"',
    'search_modifier_not_attachment_name_is'        => 'El nombre de cualquier adjunto no es ":value"',
    'search_modifier_not_attachment_name_contains'  => 'El nombre de cualquier adjunto no contiene ":value"',
    'search_modifier_not_attachment_name_starts'    => 'El nombre de cualquier adjunto no comienza con ":value"',
    'search_modifier_not_attachment_name_ends'      => 'El nombre de cualquier adjunto no termina con ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Las notas de cualquier adjunto no son ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Las notas de cualquier adjunto no contienen ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Las notas de cualquier adjunto comienzan con ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Las notas de cualquier adjunto no terminan con ":value"',
    'search_modifier_sepa_ct_is'                    => 'El SEPA CT es ":value"',
    'update_rule_from_query'                        => 'Actualizar regla ":rule" de la consulta de búsqueda',
    'create_rule_from_query'                        => 'Crear nueva regla a partir de la consulta de búsqueda',
    'rule_from_search_words'                        => 'El motor de reglas tiene un manejo difícil ":string". La regla sugerida que se ajusta a su consulta de búsqueda puede dar diferentes resultados. Por favor verifique los activadores de la regla cuidadosamente.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'El saldo de la cuenta de destino es exactamente ":value"',
    'search_modifier_not_destination_balance_is'    => 'El saldo de la cuenta de destino NO es exactamente ":value"',
    'search_modifier_source_balance_is'             => 'El saldo de la cuenta original es exactamente ":value"',
    'search_modifier_not_source_balance_is'         => 'El saldo de la cuenta de origen NO es exactamente ":value"',

    'search_modifier_destination_balance_lte'     => 'El saldo de la cuenta de destino es menor o igual a ":value"',
    'search_modifier_not_destination_balance_lte' => 'El saldo de la cuenta de destino es superior a ":value"',
    'search_modifier_source_balance_lte'          => 'El saldo de la cuenta original es menor o igual a ":value"',
    'search_modifier_not_source_balance_lte'      => 'El saldo de la cuenta de origen es superior a ":value"',

    'search_modifier_destination_balance_lt'     => 'El saldo de la cuenta de destino es menor que ":value"',
    'search_modifier_not_destination_balance_lt' => 'El saldo de la cuenta de destino es mayor o igual a ":value"',
    'search_modifier_source_balance_lt'          => 'El saldo de la cuenta de origen es menor que ":value"',
    'search_modifier_not_source_balance_lt'      => 'El saldo de la cuenta de origen es mayor o igual a ":value"',

    'search_modifier_destination_balance_gte'     => 'El saldo de la cuenta de destino es mayor o igual a ":value"',
    'search_modifier_not_destination_balance_gte' => 'El saldo de la cuenta de destino es menor que ":value"',
    'search_modifier_source_balance_gte'          => 'El saldo de la cuenta de origen es mayor o igual a ":value"',
    'search_modifier_not_source_balance_gte'      => 'El saldo de la cuenta original es menor que ":value"',

    'search_modifier_destination_balance_gt'              => 'El saldo de la cuenta de destino es superior a ":value"',
    'search_modifier_not_destination_balance_gt'          => 'El saldo de la cuenta de destino es menor o igual a ":value"',
    'search_modifier_source_balance_gt'                   => 'El saldo de la cuenta de origen es mayor de ":value"',
    'search_modifier_not_source_balance_gt'               => 'El saldo de la cuenta de origen es menor o igual a ":value"',


    // END
    'general_search_error'                                => 'Se ha producido un error durante la búsqueda. Por favor, compruebe los archivos de registro para obtener más información.',
    'search_box'                                          => 'Buscar',
    'search_box_intro'                                    => 'Bienvenido a la función de búsqueda de Firefly III. Introduce tu consulta de búsqueda en el cuadro. Asegúrate de revisar el archivo de ayuda porque el buscador es bastante avanzado.',
    'search_error'                                        => 'Error durante la búsqueda',
    'search_searching'                                    => 'Buscando...',
    'search_results'                                      => 'Buscar resultados',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'anualmente',
    'repeat_freq_half-year'                               => 'cada medio año',
    'repeat_freq_quarterly'                               => 'trimestralmente',
    'repeat_freq_monthly'                                 => 'mensualmente',
    'repeat_freq_weekly'                                  => 'semanalmente',
    'repeat_freq_daily'                                   => 'diariamente',
    'daily'                                               => 'diariamente',
    'weekly'                                              => 'semanalmente',
    'quarterly'                                           => 'trimestralmente',
    'half-year'                                           => 'cada medio año',
    'yearly'                                              => 'anualmente',

    // rules
    'is_not_rule_trigger'                                 => 'No',
    'cannot_fire_inactive_rules'                          => 'No puedes ejecutar reglas inactivas.',
    'show_triggers'                                       => 'Mostrar disparadores',
    'show_actions'                                        => 'Mostrar acciones',
    'rules'                                               => 'Reglas',
    'rule_name'                                           => 'Nombre de la regla',
    'rule_triggers'                                       => 'La regla se activa cuando',
    'rule_actions'                                        => 'La regla será',
    'new_rule'                                            => 'Nueva regla',
    'new_rule_group'                                      => 'Nuevo grupo de reglas',
    'rule_priority_up'                                    => 'Dar más prioridad a una regla',
    'rule_priority_down'                                  => 'Dar menos prioridad a una regla',
    'make_new_rule_group'                                 => 'Hacer un nuevo grupo de reglas',
    'store_new_rule_group'                                => 'Crear grupo de reglas',
    'created_new_rule_group'                              => '¡Nuevo grupo de reglas ":title" guardado!',
    'updated_rule_group'                                  => 'Grupo de reglas actualizado correctamente ":title".',
    'edit_rule_group'                                     => 'Editar grupo de reglas ":title"',
    'duplicate_rule'                                      => 'Duplicar regla ":title"',
    'rule_copy_of'                                        => 'Copia de ":title"',
    'duplicated_rule'                                     => 'Regla ":title" duplicada en ":newTitle"',
    'delete_rule_group'                                   => 'Eliminar grupo de reglas ":title"',
    'deleted_rule_group'                                  => 'Eliminar grupo de reglas ":title"',
    'update_rule_group'                                   => 'Actualizar grupo de reglas',
    'no_rules_in_group'                                   => 'No hay reglas en este grupo',
    'move_rule_group_up'                                  => 'Mover la regla hacia arriba',
    'move_rule_group_down'                                => 'Mover el grupo de reglas hacia abajo',
    'save_rules_by_moving'                                => 'Guardar esta regla moviéndola a otro grupo de reglas:|Guardar estas reglas moviéndolas a otro grupo de reglas:',
    'make_new_rule'                                       => 'Crea una nueva regla en el grupo ":title"',
    'make_new_rule_no_group'                              => 'Crea una nueva regla',
    'instructions_rule_from_bill'                         => 'Para hacer coincidir las transacciones con su nueva suscripción ":name", Firefly III puede crear una regla que se comprobará automáticamente contra cualquier transacción que almacenes. Por favor verifique los detalles a continuación y almacene la regla para que Firefly III coincida automáticamente con las transacciones a su nueva factura.',
    'instructions_rule_from_journal'                      => 'Cree una regla basada en una de sus transacciones. Complemente o envíe el siguiente formulario.',
    'rule_is_strict'                                      => 'regla estricta',
    'rule_is_not_strict'                                  => 'regla no estricta',
    'rule_help_stop_processing'                           => 'Cuando marque esta casilla, las reglas posteriores en este grupo no se ejecutarán si se ejecuta esta regla en particular.',
    'rule_help_strict'                                    => 'En las reglas estrictas TODOS los desencadenadores deben actuar para acción(es) que será(n) ejecutada(s). En las reglas no estrictas, CUALQUIER desencadenador es suficiente para que la(s) acción(es) se ejecute(n).',
    'rule_help_active'                                    => 'Las reglas inactivas nunca se ejecutan.',
    'stored_new_rule'                                     => 'Guardar la nueva regla con titulo ":title"',
    'deleted_rule'                                        => 'Regla eliminada con titulo ":title"',
    'store_new_rule'                                      => 'Crear regla',
    'updated_rule'                                        => 'Regla actualizada con titulo ":title"',
    'default_rule_group_name'                             => 'Reglaspredeterminada',
    'default_rule_group_description'                      => 'Todas las reglas que no pertenecen a ningún grupo.',
    'trigger'                                             => 'Disparador',
    'trigger_value'                                       => 'Disparador en valor',
    'stop_processing_other_triggers'                      => 'Pare el procesamiento de otros disparadores',
    'add_rule_trigger'                                    => 'Añadir nuevo disparador',
    'action'                                              => 'Acción',
    'action_value'                                        => 'Valor de acción',
    'stop_executing_other_actions'                        => 'Dejar de ejecutar otras acciones',
    'add_rule_action'                                     => 'Añadir nueva acción',
    'edit_rule'                                           => 'Editar regla #:nr ":title"',
    'delete_rule'                                         => 'Eliminar regla ":title"',
    'update_rule'                                         => 'Actualizar regla',
    'test_rule_triggers'                                  => 'Ver transacciones que coinciden',
    'warning_no_matching_transactions'                    => 'No se encontraron transacciones coincidentes.',
    'warning_no_valid_triggers'                           => 'No se proveen disparadores validos.',
    'apply_rule_selection'                                => 'Aplique la regla ":title" a una seleccion de sus transacciones',
    'apply_rule_selection_intro'                          => 'Las reglas como ":title" normalmente sólo se aplican a transacciones nuevas o actualizadas, pero puedes indicarle a Firefly III que las ejecute en una selección de transacciones existentes. Esto puede ser útil si has actualizado una regla y necesitas que los cambios se apliquen a todas tus otras transacciones.',
    'include_transactions_from_accounts'                  => 'Introduzca transacciones desde estas cuentas',
    'include'                                             => '¿Incluir?',
    'applied_rule_selection'                              => '{0} Ninguna transacción en su selección fue cambiada por la regla ":title".|[1] Una transacción en su selección fue cambiada por la regla ":title".|[2,*] :count transacciones en su selección fueron cambiadas por la regla ":title".',
    'execute'                                             => 'Ejecutar',
    'apply_rule_group_selection'                          => 'Aplique la regla de grupo ":title" a una selección de sus transacciones',
    'apply_rule_group_selection_intro'                    => 'Los grupos de reglas como ":title" normalmente sólo se aplican a transacciones nuevas o actualizadas, pero puedes indicarle a Firefly III que ejecute todas las reglas de este grupo en una selección de transacciones existentes. Esto puede ser útil si has actualizado un grupo de reglas y necesitas que los cambios se apliquen a todas tus otras transacciones.',
    'applied_rule_group_selection'                        => 'El grupo de reglas ":title" ha sido aplicada a su selección.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Cuando la transacción es creada',
    'rule_trigger_update_journal'                         => 'Cuando la transacción es actualizada',
    'rule_trigger_manual'                                 => 'Sólo cuando el usuario lo active',
    'rule_trigger_user_action'                            => 'La acción del usuario es ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'El nombre de la cuenta de origen comienza con..',
    'rule_trigger_source_account_starts'                  => 'El nombre de la cuenta de origen comienza con ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'El nombre de la cuenta de origen termina con..',
    'rule_trigger_source_account_ends'                    => 'El nombre de la cuenta de origen termina con ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'El nombre de la cuenta origen es..',
    'rule_trigger_source_account_is'                      => 'El nombre de la cuenta origen es ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'El nombre de cuenta de origen contiene..',
    'rule_trigger_source_account_contains'                => 'El nombre de la cuenta origen contiene ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'El ID de cualquiera de las cuentas es exactamente..',
    'rule_trigger_account_id'                             => 'El ID de cualquiera de las cuentas es exactamente :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'El ID de la cuenta de origen es exactamente..',
    'rule_trigger_source_account_id'                      => 'El ID de cuenta origen es exactamente :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'El ID de la cuenta de destino es exactamente..',
    'rule_trigger_destination_account_id'                 => 'El ID de cuenta de destino es exactamente :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Cualquiera de las cuentas es efectivo',
    'rule_trigger_account_is_cash'                        => 'Cualquiera de las cuentas es efectivo',
    'rule_trigger_source_is_cash_choice'                  => 'La cuenta de origen es de efectivo',
    'rule_trigger_source_is_cash'                         => 'La cuenta de origen es de efectivo',
    'rule_trigger_destination_is_cash_choice'             => 'La cuenta de destino es de efectivo',
    'rule_trigger_destination_is_cash'                    => 'La cuenta de origen es de efectivo',
    'rule_trigger_source_account_nr_starts_choice'        => 'Número de la cuenta de origen / IBAN comienza con..',
    'rule_trigger_source_account_nr_starts'               => 'Número / IBAN de la cuenta origen empieza con ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Número / IBAN de la cuenta de origen termina con..',
    'rule_trigger_source_account_nr_ends'                 => 'Número de la cuenta de origen / IBAN termina con ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Número de la cuenta de origen / IBAN es..',
    'rule_trigger_source_account_nr_is'                   => 'Número de cuenta de origen / IBAN es ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Número de cuenta de origen / IBAN contiene..',
    'rule_trigger_source_account_nr_contains'             => 'Número de cuenta de origen / IBAN contiene ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'El nombre de cuenta de destino comienza con..',
    'rule_trigger_destination_account_starts'             => 'El nombre de cuenta de destino comienza con ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'El nombre de cuenta de destino termina con...',
    'rule_trigger_destination_account_ends'               => 'El nombre de la cuenta de destino termina con ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'El nombre de cuenta de destino es...',
    'rule_trigger_destination_account_is'                 => 'El nombre de la cuenta de destino es ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'El nombre de cuenta de destino contiene..',
    'rule_trigger_destination_account_contains'           => 'El nombre de la cuenta de destino contiene ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Número / IBAN de la cuenta de destino empieza con..',
    'rule_trigger_destination_account_nr_starts'          => 'Número de la cuenta de destino / IBAN comienza con ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Número de la cuenta de destino / IBAN termina con..',
    'rule_trigger_destination_account_nr_ends'            => 'Número de la cuenta de destino / IBAN termina con ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Número de la cuenta de destino / IBAN es..',
    'rule_trigger_destination_account_nr_is'              => 'Número de la cuenta de destino / IBAN es ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'El número de la cuenta de destino / IBAN contiene..',
    'rule_trigger_destination_account_nr_contains'        => 'El número de la cuenta de destino / IBAN contiene ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transacción es del tipo..',
    'rule_trigger_transaction_type'                       => 'La transacción es de tipo ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Categoría es..',
    'rule_trigger_category_is'                            => 'Categoría es ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'La cantidad es menor o igual a ..',
    'rule_trigger_amount_less'                            => 'La cantidad es menor o igual a :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Cantidad es..',
    'rule_trigger_amount_is'                              => 'Cantidad es :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Cantidad es mayor o igual a..',
    'rule_trigger_amount_more'                            => 'Cantidad es mayor o igual a :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Descripción comienza con..',
    'rule_trigger_description_starts'                     => 'La descripción comienza con ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Descripción termina con..',
    'rule_trigger_description_ends'                       => 'La descripción termina con ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Descripción contiene..',
    'rule_trigger_description_contains'                   => 'La descripción contiene ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Descripción es..',
    'rule_trigger_description_is'                         => 'La descripción es ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'La fecha de la transacción es..',
    'rule_trigger_date_on'                                => 'La fecha de la transacción es ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'La fecha de la transacción es anterior a..',
    'rule_trigger_date_before'                            => 'La fecha de la transacción es anterior a ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'La fecha de la transacción es después de..',
    'rule_trigger_date_after'                             => 'La fecha de la transacción es después de ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'La transacción se realizó el..',
    'rule_trigger_created_at_on'                          => 'La transacción se realizó el ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'La transacción fue editada por última vez el..',
    'rule_trigger_updated_at_on'                          => 'La transacción fue editada por última vez el ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Presupuesto es..',
    'rule_trigger_budget_is'                              => 'Presupuesto es ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Cualquier etiqueta es..',
    'rule_trigger_tag_is'                                 => 'Cualquier etiqueta es ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Cualquier etiqueta contiene..',
    'rule_trigger_tag_contains'                           => 'Cualquier etiqueta contiene ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Cualquier etiqueta termina en..',
    'rule_trigger_tag_ends'                               => 'Cualquier etiqueta termina en ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Cualquier etiqueta empieza con..',
    'rule_trigger_tag_starts'                             => 'Cualquier etiqueta empieza con ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'La moneda de la transacción es..',
    'rule_trigger_currency_is'                            => 'La moneda de la transacción es ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'La transacción en moneda extranjera es..',
    'rule_trigger_foreign_currency_is'                    => 'La transacción en moneda extranjera es ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Tiene cualquier archivo adjunto',
    'rule_trigger_has_attachments'                        => 'Tiene cualquier adjunto(s)',
    'rule_trigger_has_no_category_choice'                 => 'No tiene categoría',
    'rule_trigger_has_no_category'                        => 'La transacción no tiene categoría',
    'rule_trigger_has_any_category_choice'                => 'Tiene (cualquier) categoría',
    'rule_trigger_has_any_category'                       => 'La transacción tiene (cualquier) categoría',
    'rule_trigger_has_no_budget_choice'                   => 'No tiene presupuesto',
    'rule_trigger_has_no_budget'                          => 'Transacción no tiene presupuesto',
    'rule_trigger_has_any_budget_choice'                  => 'Tiene un (cualquier) presupuesto',
    'rule_trigger_has_any_budget'                         => 'La transacción tiene (cualquier) presupuesto',
    'rule_trigger_has_no_bill_choice'                     => 'No tiene suscripción',
    'rule_trigger_has_no_bill'                            => 'La transacción no tiene suscripción',
    'rule_trigger_has_any_bill_choice'                    => 'Tiene una (cualquiera) suscripción',
    'rule_trigger_has_any_bill'                           => 'La transacción tiene una (cualquiera) suscripción',
    'rule_trigger_has_no_tag_choice'                      => 'No tiene etiqueta(s)',
    'rule_trigger_has_no_tag'                             => 'La transacción no tiene etiqueta(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Tiene una o mas (cualquier) etiquetas',
    'rule_trigger_has_any_tag'                            => 'La transacción tiene una o mas (cualquier) etiquetas',
    'rule_trigger_any_notes_choice'                       => 'Tiene (cualquier) notas',
    'rule_trigger_any_notes'                              => 'La transacción tiene (cualquier) notas',
    'rule_trigger_no_notes_choice'                        => 'No tiene notas',
    'rule_trigger_no_notes'                               => 'Transacción no tiene notas',
    'rule_trigger_notes_is_choice'                        => 'Las notas son..',
    'rule_trigger_notes_is'                               => 'Las notas son ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Las notas contienen..',
    'rule_trigger_notes_contains'                         => 'Las notas contienen ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Las notas comienzan con..',
    'rule_trigger_notes_starts'                           => 'Las notas comienzan con ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Las notas terminan con..',
    'rule_trigger_notes_ends'                             => 'Las notas terminan con ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'La suscripción es..',
    'rule_trigger_bill_is'                                => 'La suscripción es ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'El ID externo es..',
    'rule_trigger_external_id_is'                         => 'El ID externo es ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'La referencia interna es..',
    'rule_trigger_internal_reference_is'                  => 'La referencia interna es ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'El ID del diario de transacciones es..',
    'rule_trigger_journal_id'                             => 'El ID del diario de transacciones es ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'La transacción tiene una (cualquiera) URL externa',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'La transacción tiene un (cualquiera) ID externo',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'La transacción no tiene URL externa',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'La transacción no tiene ID externa',
    'rule_trigger_id_choice'                              => 'La ID de la transacción es..',
    'rule_trigger_id'                                     => 'La ID de la transacción es ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'El SEPA CT es..',
    'rule_trigger_sepa_ct_is'                             => 'El SEPA CT es ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'La acción del usuario es ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Ninguna etiqueta es..',
    'rule_trigger_tag_is_not'                             => 'Ninguna etiqueta es ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Cualquiera de las cuentas es exactamente..',
    'rule_trigger_account_is'                             => 'Cualquiera de las cuentas es exactamente:trigger_value',
    'rule_trigger_account_contains_choice'                => 'Cualquier cuenta contiene..',
    'rule_trigger_account_contains'                       => 'Cualquier cuenta contiene ":trigger_value " "',
    'rule_trigger_account_ends_choice'                    => 'Cualquier cuenta termina con..',
    'rule_trigger_account_ends'                           => 'Cualquier cuenta termina con ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Cualquiera cuenta comienza con..',
    'rule_trigger_account_starts'                         => 'Cualquiera cuenta comienza con ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Cualquier número de cuenta / IBAN es..',
    'rule_trigger_account_nr_is'                          => 'Cualquier número de cuenta / IBAN es ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Cualquiera de los números de cuenta / IBAN contiene..',
    'rule_trigger_account_nr_contains'                    => 'Cualquiera de los números de cuenta / IBAN contiene ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Cualquiera de los números de cuenta / IBAN termina en..',
    'rule_trigger_account_nr_ends'                        => 'Cualquiera de los números de cuenta / IBAN termina en ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Cualquiera de los números de cuenta / IBAN comienza por..',
    'rule_trigger_account_nr_starts'                      => 'Cualquiera de los números de cuenta / IBAN comienza por ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'La categoría contiene..',
    'rule_trigger_category_contains'                      => 'La categoría contiene ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'La categoría termina con..',
    'rule_trigger_category_ends'                          => 'La categoría termina con ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'La categoría empieza por..',
    'rule_trigger_category_starts'                        => 'La categoría comienza con ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'El presupuesto contiene..',
    'rule_trigger_budget_contains'                        => 'El presupuesto contiene ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'El presupuesto termina con..',
    'rule_trigger_budget_ends'                            => 'El presupuesto termina con ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'El presupuesto comienza con..',
    'rule_trigger_budget_starts'                          => 'El presupuesto comienza con ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'La suscripción contiene..',
    'rule_trigger_bill_contains'                          => 'La suscripción contiene ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Suscripción termina con..',
    'rule_trigger_bill_ends'                              => 'La suscripción termina con ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Suscripción comienza con..',
    'rule_trigger_bill_starts'                            => 'La suscripción comienza con ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'El ID externo contiene..',
    'rule_trigger_external_id_contains'                   => 'El ID externo contiene ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'El ID externo termina con..',
    'rule_trigger_external_id_ends'                       => 'El ID externo termina con ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'ID externo comienza con..',
    'rule_trigger_external_id_starts'                     => 'ID externo comienza con ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'La referencia interna contiene..',
    'rule_trigger_internal_reference_contains'            => 'La referencia interna contiene ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'La referencia interna termina con..',
    'rule_trigger_internal_reference_ends'                => 'La referencia interna termina con ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Referencia interna comienza con..',
    'rule_trigger_internal_reference_starts'              => 'La referencia interna comienza con ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'La URL externa es..',
    'rule_trigger_external_url_is'                        => 'La URL externa es ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'La URL externa contiene..',
    'rule_trigger_external_url_contains'                  => 'La URL externa contiene ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'La URL externa termina con..',
    'rule_trigger_external_url_ends'                      => 'La URL externa termina con ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'La URL externa comienza con..',
    'rule_trigger_external_url_starts'                    => 'La URL externa comienza con ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'No tiene adjuntos',
    'rule_trigger_has_no_attachments'                     => 'La transacción no tiene adjuntos',
    'rule_trigger_recurrence_id_choice'                   => 'El ID de la transacción recurrente es..',
    'rule_trigger_recurrence_id'                          => 'El ID de la transacción recurrente es ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'La fecha de interés es el..',
    'rule_trigger_interest_date_on'                       => 'La fecha de interés es el ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'La fecha de interés es antes del..',
    'rule_trigger_interest_date_before'                   => 'La fecha de interés es anterior al ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'La fecha de interés es después del..',
    'rule_trigger_interest_date_after'                    => 'La fecha de interés es posterior al ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'La fecha de registro es el..',
    'rule_trigger_book_date_on'                           => 'La fecha del libro es el ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'La fecha del libro es anterior al..',
    'rule_trigger_book_date_before'                       => 'La fecha del libro es anterior al ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'La fecha del libro es posterior al..',
    'rule_trigger_book_date_after'                        => 'La fecha del libro es posterior al ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'La fecha de procesamiento es el..',
    'rule_trigger_process_date_on'                        => 'La fecha de procesamiento es el ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'La fecha de procesamientos es antes del..',
    'rule_trigger_process_date_before'                    => 'La fecha de procesamiento es antes del ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'La fecha de procesamiento es después del..',
    'rule_trigger_process_date_after'                     => 'La fecha de procesamiento es después del ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'La fecha de vencimiento es el..',
    'rule_trigger_due_date_on'                            => 'La fecha de vencimiento es el ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'La fecha de vencimiento es anterior al..',
    'rule_trigger_due_date_before'                        => 'La fecha de vencimiento es anterior al ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'La fecha de vencimiento es posterior al..',
    'rule_trigger_due_date_after'                         => 'La fecha de vencimiento es posterior al ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'La fecha de pago es el..',
    'rule_trigger_payment_date_on'                        => 'La fecha de pago es el ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'La fecha de pago es antes del..',
    'rule_trigger_payment_date_before'                    => 'La fecha de pago es anterior al ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'La fecha de pago es posterior al..',
    'rule_trigger_payment_date_after'                     => 'La fecha de pago es posterior al ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'La fecha de la factura es el..',
    'rule_trigger_invoice_date_on'                        => 'La fecha de la factura es el ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'La fecha de la factura es anterior al..',
    'rule_trigger_invoice_date_before'                    => 'La fecha de la factura es anterior al ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'La fecha de la factura es posterior al..',
    'rule_trigger_invoice_date_after'                     => 'La fecha de la factura es posterior al ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'La transacción fue creada antes del..',
    'rule_trigger_created_at_before'                      => 'La transacción se creó antes del ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'La transacción fue creada después del..',
    'rule_trigger_created_at_after'                       => 'La transacción se creó antes del ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'La transacción fue actualizada por última vez antes del..',
    'rule_trigger_updated_at_before'                      => 'La transacción se actualizó por última vez antes del ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'La transacción se actualizó por última vez después del..',
    'rule_trigger_updated_at_after'                       => 'La transacción se actualizó por última vez antes del ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'El importe extranjero es exactamente..',
    'rule_trigger_foreign_amount_is'                      => 'El importe extranjero es exactamente ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'El importe extranjero es menor que..',
    'rule_trigger_foreign_amount_less'                    => 'El importe extranjero es menor que ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'El importe extranjero es mayor que..',
    'rule_trigger_foreign_amount_more'                    => 'El importe extranjero es menor que ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'El nombre de cualquier archivo adjunto es..',
    'rule_trigger_attachment_name_is'                     => 'El nombre de cualquier archivo adjunto es ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'El nombre de cualquier archivo adjunto contiene..',
    'rule_trigger_attachment_name_contains'               => 'El nombre de cualquier archivo adjunto contiene ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'El nombre de cualquier archivo adjunto comienza con..',
    'rule_trigger_attachment_name_starts'                 => 'El nombre de cualquier archivo adjunto comienza con ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'El nombre de cualquier archivo adjunto termina con..',
    'rule_trigger_attachment_name_ends'                   => 'El nombre de cualquier archivo adjunto termina con ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Cualquier nota de archivos adjuntos es..',
    'rule_trigger_attachment_notes_are'                   => 'Cualquier nota de archivos adjuntos es ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Cualquier nota de archivos adjuntos contiene..',
    'rule_trigger_attachment_notes_contains'              => 'Cualquier nota de archivos adjuntos contiene ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Cualquier nota de archivos adjuntos comienza por..',
    'rule_trigger_attachment_notes_starts'                => 'Cualquier nota de archivos adjuntos comienza por ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Cualquier nota de archivos adjuntos termina con..',
    'rule_trigger_attachment_notes_ends'                  => 'Cualquier nota de archivos adjuntos termina con ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transacción conciliada',
    'rule_trigger_reconciled'                             => 'Transacción conciliada',
    'rule_trigger_exists_choice'                          => 'Cualquier transacción coincide(!)',
    'rule_trigger_exists'                                 => 'Cualquier transacción coincide',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'El ID de la cuenta no es ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'El ID de cuenta de origen no es ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'El ID de cuenta de destino no es ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'El tipo de transacción no es ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'La etiqueta no es ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'La etiqueta es ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'La descripción no es ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'La descripción no contiene: ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'La descripción no termina con ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'La descripción no comienza con ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Las notas no son ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Las notas no contienen ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Las notas no terminan en ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Las notas no comienzan con ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'La cuenta de origen no es ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'La cuenta de origen no contiene ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'La cuenta de origen no termina en ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'La cuenta de origen no comienza con ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'El número / IBAN de la cuenta de origen no es ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'El número / IBAN de la cuenta de origen no contiene ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'El número / IBAN de la cuenta de origen no termina en ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'El número / IBAN de la cuenta de origen no comienza con ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'La cuenta de destino no es ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'La cuenta de destino no contiene ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'La cuenta de destino no termina en ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'La cuenta de destino no comienza con ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'El número / IBAN de la cuenta de destino no es ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'El número / IBAN de la cuenta de destino no contiene ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'El número / IBAN de la cuenta de destino no termina en ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'El número / IBAN de la cuenta de destino no comienza por ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Ninguna cuenta es ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Ninguna cuenta contiene ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Ninguna cuenta termina en ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Ninguna cuenta comienza con ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Ninguno de los números de cuenta / IBAN es ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Ninguno de los números de cuenta / IBAN contiene ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Ninguno de los números de cuenta / IBAN termina en ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Ninguno de los números de cuenta / IBAN comienza con ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'La categoría no es ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'La categoría no contiene ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'La categoría no termina en ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'La categoría no empieza con ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'El presupuesto no es ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'El presupuesto no contiene ":trigger_value " "',
    'rule_trigger_not_budget_ends'                        => 'El presupuesto no termina en ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'El presupuesto no comienza con ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'La suscripción no es ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'La suscripción no contiene ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'La suscripción no termina con ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'La suscripción no termina con ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'El ID externo no es ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'El ID externo no contiene ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'El ID externo no termina en ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'El ID externo no comienza con ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'La referencia interna no es ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'La referencia interna no contiene ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'La referencia interna no termina en ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'La referencia interna no comienza con ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'La URL externa no es ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'La URL externa no contiene ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'La URL externa no termina en ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'La URL externa no comienza por ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'La moneda no es ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'La moneda extranjera no es ":trigger_value"',
    'rule_trigger_not_id'                                 => 'El ID de la transacción no es ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'El ID del diario de transacciones no es ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'El ID recurrente no es ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'La fecha no está en ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'La fecha no es anterior al ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'La fecha no es posterior al ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'La fecha de interés no es el ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'La fecha de interés no es anterior al ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'La fecha de interés no es posterior al ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'La fecha de registro no es el ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'La fecha de registro no es anterior al ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'La fecha de registro no es posterior al ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'La fecha de procesamiento no es el ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'La fecha de procesamiento no es anterior al ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'La fecha de procesamiento no es posterior al ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'La fecha de vencimiento no es el ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'La fecha de vencimiento no es anterior al ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'La fecha vencimiento no es posterior al ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'La fecha de pago no es el ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'La fecha de pago no es anterior al ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'La fecha de pago no es posterior al ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'La fecha de la factura no es el ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'La fecha de la factura no es anterior al ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'La fecha de la factura no es posterior al ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'La transacción no se creó el ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'La transacción no se creó antes del ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'La transacción no se crea después de ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'La transacción no se actualiza en ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'La transacción no se actualiza antes de ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'La transacción no se actualiza después de ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'El importe de la transacción no es ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'El importe de la transacción es superior a ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'El importe de la transacción es menor que ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'El importe de la transacción extranjera no es ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'El importe de la transacción extranjera es superior a ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'El importe de la transacción extranjera es menor de ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Ningún archivo adjunto se llama ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Ningún nombre de adjunto contiene ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Ningún nombre de adjuntos comienza con ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Ningún nombre de adjuntos termina en ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No hay notas adjuntas que sean ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No hay notas adjuntas que contengan ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No hay notas adjuntas que comiencen con ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No hay notas adjuntas que terminen en ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'La transacción no ha sido conciliada',
    'rule_trigger_not_exists'                             => 'La transacción no existe',
    'rule_trigger_not_has_attachments'                    => 'La transacción no tiene adjuntos',
    'rule_trigger_not_has_any_category'                   => 'La transacción no tiene categoría',
    'rule_trigger_not_has_any_budget'                     => 'Transacción no tiene presupuesto',
    'rule_trigger_not_has_any_bill'                       => 'La transacción no tiene suscripción',
    'rule_trigger_not_has_any_tag'                        => 'La transacción no tiene etiquetas',
    'rule_trigger_not_any_notes'                          => 'La transacción no tiene notas',
    'rule_trigger_not_any_external_url'                   => 'La transacción no tiene URL externa',
    'rule_trigger_not_has_no_attachments'                 => 'La transacción tiene (cualquier) adjunto(s)',
    'rule_trigger_not_has_no_category'                    => 'La transacción tiene una (cualquiera) categoría',
    'rule_trigger_not_has_no_budget'                      => 'La transacción tiene un (cualquiera) presupuesto',
    'rule_trigger_not_has_no_bill'                        => 'La transacción tiene una (cualquiera) suscripción',
    'rule_trigger_not_has_no_tag'                         => 'La transacción tiene una etiqueta (cualquiera)',
    'rule_trigger_not_no_notes'                           => 'La transacción tiene notas',
    'rule_trigger_not_no_external_url'                    => 'La transacción tiene una URL externa',
    'rule_trigger_not_source_is_cash'                     => 'La cuenta origen no es una cuenta de efectivo',
    'rule_trigger_not_destination_is_cash'                => 'La cuenta de destino no es una cuenta de efectivo',
    'rule_trigger_not_account_is_cash'                    => 'Ninguna de las cuentas es una cuenta de efectivo',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'El saldo de la cuenta de destino es mayor que..',
    'rule_trigger_destination_balance_gte_choice'         => 'El saldo de la cuenta de destino es mayor o igual a..',
    'rule_trigger_destination_balance_is_choice'          => 'El saldo de la cuenta de destino es exactamente..',
    'rule_trigger_destination_balance_lt_choice'          => 'El saldo de la cuenta de destino es menor que..',
    'rule_trigger_destination_balance_lte_choice'         => 'El saldo de la cuenta de destino es menor o igual a..',

    'rule_trigger_source_balance_gt_choice'  => 'El saldo de la cuenta original es más que..',
    'rule_trigger_source_balance_gte_choice' => 'El saldo de la cuenta original es mayor o igual a..',
    'rule_trigger_source_balance_is_choice'  => 'El saldo de la cuenta original es exactamente..',
    'rule_trigger_source_balance_lt_choice'  => 'El saldo de la cuenta original es menor que..',
    'rule_trigger_source_balance_lte_choice' => 'El saldo de la cuenta original es menor o igual a..',

    'rule_trigger_destination_balance_gt'  => 'El saldo de cuenta de destino es mayor que :trigger_value',
    'rule_trigger_destination_balance_gte' => 'El saldo de cuenta de destino es mayor o igual a :trigger_value',
    'rule_trigger_destination_balance_is'  => 'El saldo de cuenta de destino es exactamente :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'El saldo de cuenta de destino es menor que :trigger_value',
    'rule_trigger_destination_balance_lte' => 'El saldo de cuenta de destino es menor o igual a :trigger_value',

    'rule_trigger_source_balance_gt'           => 'El saldo de la cuenta original es mayor que :trigger_value',
    'rule_trigger_source_balance_gte'          => 'El saldo de la cuenta original es mayor o igual a :trigger_value',
    'rule_trigger_source_balance_is'           => 'El saldo de la cuenta original es exactamente :trigger_value',
    'rule_trigger_source_balance_lt'           => 'El saldo de la cuenta original es menor que :trigger_value',
    'rule_trigger_source_balance_lte'          => 'El saldo de la cuenta original es menor o igual a :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'El saldo de cuenta de destino es menor o igual a :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'El saldo de cuenta de destino es menor que :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'El saldo de cuenta de destino no es :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'El saldo de cuenta de destino es mayor o igual a :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'El saldo de cuenta de destino es mayor que :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'El saldo de la cuenta de origen es menor o igual a :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'El saldo de la cuenta de origen es menor que :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'El saldo de la cuenta de origen no es :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'El saldo de la cuenta de origen es mayor o igual a :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'El saldo de la cuenta de origen es mayor que :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'ELIMINAR transacción(!)',
    'rule_action_delete_transaction'             => 'ELIMINAR transacción(!)',
    'rule_action_set_category'                   => 'Establecer categoría en ":action_value"',
    'rule_action_clear_category'                 => 'Borrar categoría',
    'rule_action_set_budget'                     => 'Establecer presupuesto en ":action_value "',
    'rule_action_clear_budget'                   => 'Borrar presupuesto',
    'rule_action_add_tag'                        => 'Añadir etiqueta ":action_value"',
    'rule_action_remove_tag'                     => 'Quitar la etiqueta ":action_value"',
    'rule_action_remove_all_tags'                => 'Eliminar todas las etiquetas',
    'rule_action_set_description'                => 'Establecer la descripcion en ":action_value"',
    'rule_action_append_description'             => 'Anexar la descripción con ":action_value"',
    'rule_action_prepend_description'            => 'Anteponer la descripción con ":action_value"',
    'rule_action_set_category_choice'            => 'Establecer categoría ..',
    'rule_action_clear_category_choice'          => 'Eliminar cualquier categoría',
    'rule_action_set_budget_choice'              => 'Establecer presupuesto ..',
    'rule_action_clear_budget_choice'            => 'Eliminar cualquier presupuesto',
    'rule_action_add_tag_choice'                 => 'Añadir etiqueta ..',
    'rule_action_remove_tag_choice'              => 'Quitar etiqueta ..',
    'rule_action_remove_all_tags_choice'         => 'Eliminar todas las etiquetas',
    'rule_action_set_description_choice'         => 'Añadir descripción ..',
    'rule_action_update_piggy_choice'            => 'Añadir / quitar el importe de la transacción de la hucha ..',
    'rule_action_update_piggy'                   => 'Añadir / quitar el importe de la transacción de la hucha ":action_value"',
    'rule_action_append_description_choice'      => 'Añadir descripción con ..',
    'rule_action_prepend_description_choice'     => 'Anteponer descripción con ..',
    'rule_action_set_source_account_choice'      => 'Establecer cuenta de origen ..',
    'rule_action_set_source_account'             => 'Establecer cuenta de origen en :action_value',
    'rule_action_set_destination_account_choice' => 'Establecer cuenta de destino ..',
    'rule_action_set_destination_account'        => 'Establecer cuenta de destino en :action_value',
    'rule_action_append_notes_choice'            => 'Añadir notas con ..',
    'rule_action_append_notes'                   => 'Anexar notas con ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Anteponer notas con ..',
    'rule_action_prepend_notes'                  => 'Prepara notas con ":action_value"',
    'rule_action_clear_notes_choice'             => 'Eliminar cualquier nota',
    'rule_action_clear_notes'                    => 'Eliminar cualquier nota',
    'rule_action_set_notes_choice'               => 'Establecer nota ..',
    'rule_action_link_to_bill_choice'            => 'Enlace a una suscripción ..',
    'rule_action_link_to_bill'                   => 'Enlace a la suscripción ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Cambiar cuentas de origen y destino (sólo transferencias!)',
    'rule_action_switch_accounts'                => 'Cambiar origen y destino',
    'rule_action_set_notes'                      => 'Establecer notas para:action_value',
    'rule_action_convert_deposit_choice'         => 'Convertir transacción en un ingreso',
    'rule_action_convert_deposit'                => 'Convertir transacción en un ingreso de ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Convierta esta transacción en un gasto',
    'rule_action_convert_withdrawal'             => 'Convierta la transacción en un gasto de ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Convierta la transacción a una transferencia',
    'rule_action_convert_transfer'               => 'Convierta la transacción a una transferencia con ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Añadir la descripción a las notas de la transacción',
    'rule_action_append_notes_to_descr_choice'   => 'Añadir las notas de la transacción a la descripción',
    'rule_action_move_descr_to_notes_choice'     => 'Reemplazar las notas de transacción actuales por la descripción',
    'rule_action_move_notes_to_descr_choice'     => 'Reemplazar la descripción actual por las notas de la transacción',
    'rule_action_append_descr_to_notes'          => 'Añadir descripción a las notas',
    'rule_action_append_notes_to_descr'          => 'Añadir las notas a la descripción',
    'rule_action_move_descr_to_notes'            => 'Reemplazar las notas con la descripción',
    'rule_action_move_notes_to_descr'            => 'Reemplazar la descripción con notas',
    'rule_action_set_amount_choice'              => 'Establecer cantidad en ..',
    'rule_action_set_amount'                     => 'Establecer cantidad en ":action_value "',
    'rule_action_set_destination_to_cash_choice' => 'Establecer cuenta de destino a (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Establecer cuenta de origen a (cash)',
    'rulegroup_for_bills_title'                  => 'Grupo de reglas para suscripciones',
    'rulegroup_for_bills_description'            => 'Un grupo de reglas especiales para todas las reglas que involucren suscripciones.',
    'rule_for_bill_title'                        => 'Regla autogenerada para la suscripción ":name"',
    'rule_for_bill_description'                  => 'Esta regla se genera automáticamente para intentar coincidir con la suscripción ":name".',
    'create_rule_for_bill'                       => 'Crear una nueva regla para la suscripción ":name"',
    'create_rule_for_bill_txt'                   => 'Acaba de crear una nueva suscripción llamada ":name", ¡enhorabuena! Firefly III puede asociar de manera automágica nuevos gastos con esta suscripción. Por ejemplo, siempre que pague su alquiler, la suscripción "alquiler" será enlazada a ese gasto. De esta manera, Firefly III puede mostrarle de forma precisa qué suscripciones han vencido y cuáles no. Para ello, debe crear una nueva regla. Si estos valores son correctos, Firefly III enlazará automáticamente el gasto correspondiente con la suscripción correcta. Por favor, revise los disparadores para ver si son correctos, y añada algunos si son incorrectos.',
    'new_rule_for_bill_title'                    => 'Regla para la suscripción ":name"',
    'new_rule_for_bill_description'              => 'Esta regla marca las transacciones para la suscripción ":name".',

    'new_rule_for_journal_title'                => 'Regla basada en la transacción ":description"',
    'new_rule_for_journal_description'          => 'Esta regla se basa en la transacción ":description". Coincidirá con las transacciones que son exactamente iguales.',

    // tags
    'store_new_tag'                             => 'Crear etiqueta',
    'update_tag'                                => 'Actualizar etiqueta',
    'no_location_set'                           => 'Ubicación no establecida.',
    'meta_data'                                 => 'Meta Datos',
    'location'                                  => 'Ubicación',
    'location_first_split'                      => 'La ubicación de esta transacción puede establecerse en la primera división de esta transacción.',
    'without_date'                              => 'Sin fecha',
    'result'                                    => 'Resultado',
    'sums_apply_to_range'                       => 'Todas las sumas aplican al rango seleccionado',
    'mapbox_api_key'                            => 'Para usar el mapa, obtenga una clave API de <a href="https://www.mapbox.com/">Mapbox</a>Abra su<code>.env</code> y introduzca este código después de <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Haga clic o pulse de forma prolongada para definir la ubicación del objeto.',
    'click_tap_location'                        => 'Haga clic o toque el mapa para agregar una ubicación',
    'clear_location'                            => 'Eliminar ubicación',
    'delete_all_selected_tags'                  => 'Eliminar todas las etiquetas seleccionadas',
    'select_tags_to_delete'                     => 'No olvide seleccionar algunas etiquetas.',
    'deleted_x_tags'                            => 'Eliminado :count etiqueta.|Eliminado :count etiquetas.',
    'create_rule_from_transaction'              => 'Crear regla basada en la transacción',
    'create_recurring_from_transaction'         => 'Crear una transacción recurrente basada en la transacción',

    // preferences
    'test_notifications_buttons'                => 'Para probar su configuración, utilice los botones de abajo. Tenga en cuenta que los botones no tienen control de spam.',
    'dark_mode_option_browser'                  => 'Deja que tu navegador decida',
    'dark_mode_option_light'                    => 'Siempre claro',
    'dark_mode_option_dark'                     => 'Siempre oscuro',
    'equal_to_language'                         => '(igual al idioma)',
    'dark_mode_preference'                      => 'Modo oscuro',
    'dark_mode_preference_help'                 => 'Dígale a Firefly III cuándo usar el modo oscuro.',
    'pref_home_screen_accounts'                 => 'Cuentas de la pantalla de inicio',
    'pref_home_screen_accounts_help'            => '¿Qué cuentas se deben mostrar en la página de inicio?',
    'pref_view_range'                           => 'Rango de vision',
    'pref_view_range_help'                      => 'Algunas gráficas se agrupan automáticamente en periodos. Sus presupuestos se agruparán también en períodos. ¿Qué período prefieres?',
    'pref_1D'                                   => 'Un dia',
    'pref_1W'                                   => 'Una semana',
    'pref_1M'                                   => 'Un mes',
    'pref_3M'                                   => 'Tres meses (trimestre)',
    'pref_6M'                                   => 'Seis meses',
    'pref_1Y'                                   => 'Un año',
    'pref_last365'                              => 'Año pasado',
    'pref_last90'                               => 'Últimos 90 días',
    'pref_last30'                               => 'Últimos 30 días',
    'pref_last7'                                => 'Últimos 7 días',
    'pref_YTD'                                  => 'Año hasta hoy',
    'pref_QTD'                                  => 'Trimestre hasta hoy',
    'pref_MTD'                                  => 'Mes hasta hoy',
    'pref_languages'                            => 'Idiomas',
    'pref_locale'                               => 'Configuración del idioma',
    'pref_languages_help'                       => 'Firefly III soporta varios idiomas. ¿Cuál prefieres?',
    'pref_locale_help'                          => 'Firefly III le permite configurar otros ajustes locales, como cómo se da formato a las monedas, números y fechas. Las entradas en esta lista pueden no ser soportadas por su sistema. Firefly III no tiene los ajustes de fecha correctos para cada local; póngase en contacto conmigo para obtener mejoras.',
    'pref_locale_no_demo'                       => 'Esta característica no funcionará para el usuario demo.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Configuraciónes del año fiscal',
    'pref_custom_fiscal_year_label'             => 'Habilitado',
    'pref_custom_fiscal_year_help'              => 'En países que utilizan año fiscal diferente del 1 al 31 de diciembre, usted puede cambiarlo y especificar los días de inicio / y termino del año fiscal',
    'pref_fiscal_year_start_label'              => 'Fecha de inicio del año fiscal',
    'pref_two_factor_auth'                      => 'Autentificación multi-factor',
    'pref_two_factor_auth_help'                 => 'Cuando usted habilita la verificación en 2 pasos (también conocida como autenticación de dos factores), usted agrega una capa adicional de seguridad a su cuenta. Usted inicia la sesión que conoce (código de verificación). Los códigos de generación son generados por una aplicación de su teléfono, tales como Authy o Google Authenticador.',
    'pref_enable_two_factor_auth'               => 'Habilitar autentificación multi-factor',
    'pref_two_factor_auth_disabled'             => 'Código de verificación de autenticación de múltiples factores eliminado y deshabilitado',
    'pref_two_factor_auth_remove_it'            => 'No olvide eliminar la cuenta de su aplicación de autenticacion!',
    'pref_two_factor_auth_code'                 => 'Verificar código',
    'pref_two_factor_auth_code_help'            => 'Escanea el código QR con una aplicación en tu teléfono como Authy o Google Authenticator e introduce el código generado. El código QR cambia cada vez que visita esta página. Asegúrese de usar el más reciente.',
    'pref_two_factor_auth_reset_code'           => 'Reiniciar código de verificación',
    'pref_two_factor_auth_disable_2fa'          => 'Deshabilitar MFA',
    '2fa_use_secret_instead'                    => 'Si no puede escanear el código QR, no dude en utilizar en su lugar el código secreto: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Almacena estos códigos de copia de seguridad para acceder en caso de que pierda su dispositivo.',
    '2fa_already_enabled'                       => 'La verificación de autenticación de múltiples factores ya está habilitada.',
    'wrong_mfa_code'                            => 'Este código MFA no es válido.',
    'pref_save_settings'                        => 'Guardar la configuración',
    'saved_preferences'                         => '¡Preferencias guardadas!',
    'preferences_general'                       => 'General',
    'preferences_frontpage'                     => 'Pantalla de inicio',
    'preferences_security'                      => 'Seguridad',
    'preferences_layout'                        => 'Diseño',
    'preferences_notifications'                 => 'Notificaciones',
    'pref_home_show_deposits'                   => 'Mostrar ingresos en la pantalla de inicio',
    'pref_home_show_deposits_info'              => 'La pantalla de inicio ya muestra sus cuentas de gastos. ¿debería mostrar también su cuenta de ingresos?',
    'pref_home_do_show_deposits'                => 'Sí, mostrarlos',
    'successful_count'                          => 'de cual :count exitoso',
    'list_page_size_title'                      => 'Tamaño de pagina',
    'list_page_size_help'                       => 'Cualquier lista de cosas (cuentas, transacciones, etc) muestra como mucho esta cantidad por pagina.',
    'list_page_size_label'                      => 'Tamaño de pagina',
    'between_dates'                             => '(:start y :end)',
    'pref_optional_fields_transaction'          => 'Campos opcionales para transacciones',
    'pref_optional_fields_transaction_help'     => 'Por defecto no todos los campos se habilitan al crear una nueva transacción (debido al desorden). Aquí puedes habilitar estos campos si crees que pueden ser útiles. Aunque los campos estén desactivados, si los has rellenado serán visibles.',
    'optional_tj_date_fields'                   => 'Campos de fecha',
    'optional_tj_other_fields'                  => 'Otros campos',
    'optional_tj_attachment_fields'             => 'Campos de datos adjuntos',
    'pref_optional_tj_interest_date'            => 'Fecha de intereses',
    'pref_optional_tj_book_date'                => 'Fecha del libro de registro',
    'pref_optional_tj_process_date'             => 'Fecha de procesamiento',
    'pref_optional_tj_due_date'                 => 'Fecha de caducidad',
    'pref_optional_tj_payment_date'             => 'Fecha de pago',
    'pref_optional_tj_invoice_date'             => 'Fecha de la factura',
    'pref_optional_tj_internal_reference'       => 'Referencia interna',
    'pref_optional_tj_notes'                    => 'Notas',
    'pref_optional_tj_attachments'              => 'Adjuntos',
    'pref_optional_tj_external_url'             => 'URL externa',
    'pref_optional_tj_location'                 => 'Ubicación',
    'pref_optional_tj_links'                    => 'Enlaces de transacciones',
    'optional_field_meta_dates'                 => 'Fechas',
    'optional_field_meta_business'              => 'Negocios',
    'optional_field_attachments'                => 'Adjuntos',
    'optional_field_meta_data'                  => 'Opcional meta datos',
    'external_url'                              => 'URL externa',
    'pref_notification_login_failure'           => 'Fallo de inicio de sesión',
    'pref_notification_bill_reminder'           => 'Recordatorio sobre suscripciones que caducan pronto',
    'pref_notification_new_access_token'        => 'Alerta cuando se crea un nuevo token de acceso API',
    'pref_notification_transaction_creation'    => 'Alerta cuando una transacción se crea automáticamente',
    'pref_notification_user_login'              => 'Alertar cuando se inicie sesión desde una nueva ubicación',
    'pref_notification_rule_action_failures'    => 'Alerta cuando las acciones de regla fallan al ejecutar (no por correo electrónico)',
    'pref_notification_new_password'            => 'Tu contraseña ha cambiado',
    'pref_notification_enabled_mfa'             => 'La autenticación de múltiples factores está habilitada.',
    'pref_notification_disabled_mfa'            => 'La autenticación de múltiples factores está deshabilitada',
    'pref_notification_few_left_mfa'            => 'Quedan pocos códigos de respaldo',
    'pref_notification_no_left_mfa'             => 'No te quedan códigos de respaldo',
    'pref_notification_many_failed_mfa'         => 'La verificación de autenticación multi factor sigue fallando',
    'pref_notification_new_backup_codes'        => 'Se han generado nuevos códigos de respaldo',
    'pref_notifications'                        => 'Notificaciones',
    'pref_notifications_help'                   => 'Indique si desea recibir estas notificaciones. Algunas notificaciones pueden contener información financiera sensible.',
    'pref_notifications_settings'               => 'Configuración de notificaciones',
    'pref_notifications_settings_help'          => 'Utilice estos ajustes para configurar sus canales de notificación. Tenga en cuenta que las notificaciones se enviarán a TODOS los canales. Por favor, guarde sus ajustes PRIMERO.',
    'slack_url_label'                           => 'URL del webhook entrante de Slack',
    'discord_url_label'                         => 'URL del webhook de Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Tipos de cambio',
    'header_exchange_rates'                     => 'Tipos de cambio',
    'exchange_rates_intro'                      => 'Firefly III soporta la descarga y el uso de tipos de cambio. Lee más sobre esto en <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">la documentación</a>.',
    'exchange_rates_from_to'                    => 'Entre {from} y {to} (y viceversa)',
    'header_exchange_rates_rates'               => 'Tipos de cambio',
    'exchange_rates_intro_rates'                => 'Firefly III utiliza los siguientes tipos de cambio. El inverso se calcula automáticamente cuando no se proporciona. Si no existe un tipo de cambio para la fecha de la transacción, Firefly III retrocederá en el tiempo para encontrar uno. Si no hay ninguno presente, se usará la tasa "1".',
    'header_exchange_rates_table'               => 'Tabla con tipos de cambio',
    'help_rate_form'                            => 'En este día, ¿cuánto {to} conseguirás por un {from}?',
    'save_new_rate'                             => 'Guardar nuevo tipo de cambio',
    'add_new_rate'                              => 'Agregar un nuevo tipo de cambio',
    'not_enough_currencies'                     => 'No hay suficientes monedas',
    'not_enough_currencies_enabled'             => 'Si solo tiene una divisa habilitada, no es necesario añadir tipos de cambio.',

    // Financial administrations
    'administration_index'                      => 'Administración financiera',
    'administrations_breadcrumb'                => 'Administraciones financieras',
    'administrations_page_title'                => 'Administraciones financieras',
    'administrations_index_menu'                => 'Administraciones financieras',
    'administrations_page_sub_title'            => 'Resumen',
    'create_administration'                     => 'Crear nueva administración',
    'administration_owner'                      => 'Propietario de administración: {{email}}',
    'administration_you'                        => 'Tu rol: {{role}}',
    'other_users_in_admin'                      => 'Otros usuarios en esta administración',
    'administrations_create_breadcrumb'         => 'Crear nueva administración financiera',
    'administrations_page_create_sub_title'     => 'Crear nueva administración financiera',
    'basic_administration_information'          => 'Información básica de administración',
    'new_administration_created'                => 'Se ha creado la nueva administración financiera "{{title}}"',
    'edit_administration_breadcrumb'            => 'Editar administración financiera ":title"',
    'administrations_page_edit_sub_title'       => 'Editar administración financiera ":title"',
    'administrations_page_edit_sub_title_js'    => 'Editar administración financiera "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'Puede tomar más tiempo para que la página se cargue si cambia la moneda principal, porque puede que la transacción necesite ser convertida a su (nueva) moneda principal.',
    'flash_administration_updated'              => 'Administración ":title" ha sido actualizada',
    'flash_administration_created'              => 'Administración ":title" ha sido creada',
    'flash_administration_deleted'              => 'Administración ":title" ha sido eliminada',

    // roles
    'administration_role_owner'                 => 'Propietario',
    'administration_role_ro'                    => 'Sólo lectura',
    'administration_role_mng_trx'               => 'Gestionar transacciones',
    'administration_role_mng_meta'              => 'Administrar clasificación y meta-datos',
    'administration_role_mng_budgets'           => 'Administrar presupuestos',
    'administration_role_mng_piggies'           => 'Administrar huchas',
    'administration_role_mng_subscriptions'     => 'Administrar suscripciones',
    'administration_role_mng_rules'             => 'Administrar reglas',
    'administration_role_mng_recurring'         => 'Administrar transacciones recurrentes',
    'administration_role_mng_webhooks'          => 'Administrar webhooks',
    'administration_role_mng_currencies'        => 'Administrar monedas',
    'administration_role_view_reports'          => 'Ver reportes',
    'administration_role_full'                  => 'Acceso completo',

    // mfa
    'enable_mfa'                                => 'Habilitar la autenticación multi-factor',
    'mfa_index_title'                           => 'Autentificación multi-factor',
    'mfa_index_intro'                           => 'Firefly III soporta autenticación de múltiples factores (MFA). Puede habilitar MFA para su cuenta para agregar una capa extra de seguridad. Las aplicaciones como Authy, Google Authenticator y FreeOTP se pueden utilizar para generar los códigos que necesitas para iniciar sesión. Las claves de seguridad no están soportadas por Firefly III, pero puedes usar una clave de seguridad como un dispositivo de almacenamiento para tu secreto MFA.',
    'mfa_index_enabled'                         => 'La autenticación de múltiples factores está habilitada para su cuenta.',
    'mfa_index_disabled'                        => 'La autenticación de múltiples factores no está habilitada para su cuenta.',
    'mfa_index_owner'                           => 'El propietario de esta instancia siempre podrá desactivar la autenticación de múltiples factores para su cuenta.',
    'current_password_confirm_mfa'              => 'Escribe tu contraseña actual',
    'mfa_warning_code_changes'                  => 'Puede obtener un diálogo MFA después de introducir su contraseña y un código MFA. En ese caso, espere a que su aplicación genere un nuevo código MFA, y no recicle el que acaba de usar.',
    'mfa_already_disabled'                      => 'La autenticación de múltiples factores no está habilitada, por lo que no puede desactivarla.',
    'disable_mfa_page'                          => 'Desactivar autentificación multi-factor',
    'disable_mfa_intro'                         => 'Puede desactivar la autenticación de múltiples factores. Para hacerlo, introduzca su contraseña y un código de autenticación de múltiples factores. Si desea desactivar la autenticación multi-factor porque ha perdido el acceso a su generador de código, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">por favor consulte la documentación en su lugar</a>.',
    'pref_disable_mfa'                          => 'Desactivar autentificación multi-factor',
    'mfa_not_enabled'                           => 'La autenticación de múltiples factores no está habilitada.',
    'mfa_backup_codes_intro'                    => 'Firefly III puede generar códigos de copia de seguridad. Estos códigos pueden utilizarse para iniciar sesión cuando no puede utilizar su generador de códigos. Puedes generar un nuevo conjunto de códigos en cualquier momento. Si generas un nuevo conjunto, el conjunto antiguo será inválido.',
    'mfa_backup_codes_quick'                    => 'Si llegas muy rápido desde la página de configuración de autenticación de múltiples factores, es posible que tu aplicación aún no haya generado un nuevo código. Por favor, sepa que los códigos MFA solo pueden utilizarse una vez. Asegúrese de usar un código diferente al anterior.',
    'mfa_backup_codes_title'                    => 'Código de copia de seguridad de autenticación de múltiples factores',
    'mfa_backup_codes_post_title'               => 'Código de copia de seguridad de autenticación de múltiples factores',

    // profile:
    'manage_mfa_settings'                       => 'Administrar ajustes de autenticación de múltiples factores',
    'purge_data_title'                          => 'Purgar datos de Firefly III',
    'purge_data_expl'                           => '"Purgar" significa "eliminar lo que ya está eliminado". En circunstancias normales, Firefly III no elimina nada permanentemente. Sólo lo oculta. El botón de abajo borra todos estos registros previamente "eliminados" PARA SIEMPRE.',
    'delete_stuff_header'                       => 'Borrar y purgar datos',
    'purge_all_data'                            => 'Purgar todos los registros borrados',
    'purge_data'                                => 'Purgar datos',
    'purged_all_records'                        => 'Se han limpiado todos los registros borrados.',
    'delete_data_title'                         => 'Eliminar datos de Firefly III',
    'permanent_delete_stuff'                    => 'Puedes eliminar cosas de Firefly III. Usar los botones de abajo significa que tus objetos serán ocultados. No hay ningún botón de deshacer para esto, pero los elementos pueden permanecer en la base de datos y ser recuperados si es necesario.',
    'other_sessions_logged_out'                 => 'Todas las demás sesiones han sido desconectadas.',
    'delete_unused_accounts'                    => 'Eliminar cuentas sin usar limpiará sus listas de autocompletado.',
    'delete_all_unused_accounts'                => 'Eliminar cuentas no utilizadas',
    'deleted_all_unused_accounts'               => 'Todas las cuentas no utilizadas han sido eliminadas',
    'delete_all_budgets'                        => 'Eliminar todos sus presupuestos',
    'delete_all_categories'                     => 'Eliminar todas sus categorías',
    'delete_all_tags'                           => 'Eliminar todas sus etiquetas',
    'delete_all_bills'                          => 'Borrar TODAS sus suscripciones',
    'delete_all_piggy_banks'                    => 'Borrar TODAS sus huchas',
    'delete_all_rules'                          => 'Borrar TODAS sus reglas',
    'delete_all_recurring'                      => 'Borrar TODAS sus transacciones recurrentes',
    'delete_all_object_groups'                  => 'Borrar TODOS sus grupos de objetos',
    'delete_all_accounts'                       => 'Borrar TODAS sus cuentas',
    'delete_all_asset_accounts'                 => 'Borrar TODAS sus cuentas de activos',
    'delete_all_expense_accounts'               => 'Borrar TODAS sus cuentas de gastos',
    'delete_all_revenue_accounts'               => 'Borrar TODAS sus cuentas de ingresos',
    'delete_all_liabilities'                    => 'Borrar TODOS sus pasivos',
    'delete_all_transactions'                   => 'Borrar TODAS sus transacciones',
    'delete_all_withdrawals'                    => 'Borrar TODOS sus gastos',
    'delete_all_deposits'                       => 'Borrar TODOS sus ingresos',
    'delete_all_transfers'                      => 'Borrar TODAS sus transferencias',
    'also_delete_transactions'                  => '¡Eliminar cuentas también eliminará TODAS los gastos, ingresos y transferencias asociados!',
    'deleted_all_budgets'                       => 'Todos los presupuestos han sido eliminados',
    'deleted_all_categories'                    => 'Todas las categorías han sido eliminadas',
    'deleted_all_tags'                          => 'Todas las etiquetas han sido eliminadas',
    'deleted_all_bills'                         => 'Todas las suscripciones han sido eliminadas',
    'deleted_all_piggy_banks'                   => 'Todas las huchas han sido eliminadas',
    'deleted_all_rules'                         => 'Todas las reglas y grupos de reglas se han eliminado',
    'deleted_all_object_groups'                 => 'Todos los grupos han sido eliminados',
    'deleted_all_accounts'                      => 'Todas las cuentas han sido eliminadas',
    'deleted_all_asset_accounts'                => 'Todas las cuentas de activos han sido eliminadas',
    'deleted_all_expense_accounts'              => 'Todas las cuentas de gastos han sido eliminadas',
    'deleted_all_revenue_accounts'              => 'Todas las cuentas de ingresos han sido eliminadas',
    'deleted_all_liabilities'                   => 'Todos los pasivos se han eliminado',
    'deleted_all_transactions'                  => 'Todas las transacciones han sido eliminadas',
    'deleted_all_withdrawals'                   => 'Todos los gastos se han eliminado',
    'deleted_all_deposits'                      => 'Todos los ingresos han sido eliminados',
    'deleted_all_transfers'                     => 'Todas las transferencias han sido eliminadas',
    'deleted_all_recurring'                     => 'Todas las transacciones recurrentes han sido eliminadas',
    'change_your_password'                      => 'Cambie su contraseña',
    'delete_account'                            => 'Eliminar cuenta',
    'current_password'                          => 'Contraseña actual',
    'new_password'                              => 'Nueva contraseña',
    'new_password_again'                        => 'Nueva contraseña (de nuevo)',
    'delete_your_account'                       => 'Borre su cuenta',
    'delete_your_account_help'                  => 'Eliminando su cuenta también eliminara cualquier otra cuenta, transacciones,<em>cualquier</em>que podría haber salvado en Firefly III. se habrá IDO.',
    'delete_your_account_password'              => 'Introduzca su contraseña para continuar.',
    'password'                                  => 'Contraseña',
    'are_you_sure'                              => '¿Esta usted seguro? usted no puede deshacer esto.',
    'are_you_sure_confirm'                      => '¿Está seguro?',
    'delete_account_button'                     => 'BORRE su cuenta',
    'invalid_current_password'                  => 'Contraseña actual invalida!',
    'password_changed'                          => 'Contraseña cambiada!',
    'should_change'                             => 'La idea es cambiar su contraseña.',
    'invalid_password'                          => 'Contraseña invalida!',
    'what_is_pw_security'                       => '¿Que es "verificar la seguridad de contraseña?',
    'secure_pw_title'                           => 'Como escoger una contraseña segura',
    'forgot_password_response'                  => 'Gracias. Si existe una cuenta con esta dirección de correo electrónico, encontrarás instrucciones en tu bandeja de entrada.',
    'secure_pw_history'                         => 'Cada semana leemos en las noticias sobre un sitio que pierde las contraseñas de sus usuarios. Hackers y ladrones utilizan estas contraseñas para intentar robar tu información privada. Esta información es valiosa.',
    'secure_pw_ff'                              => '¿Utiliza la misma contraseña a través de Internet? Si un sitio pierde su contraseña, los hackers tienen acceso a todos sus datos. Firefly III depende de usted para elegir una contraseña fuerte y única para proteger sus registros financieros.',
    'secure_pw_check_box'                       => 'Para ayudarte a hacer eso Firefly III puede comprobar si la contraseña que quieres usar ha sido robada en el pasado. Si este es el caso, Firefly III te aconseja NO usar esa contraseña.',
    'secure_pw_working_title'                   => '¿Cómo funciona?',
    'secure_pw_working'                         => 'Marcando la casilla, Firefly III enviará los cinco primeros caracteres del hash SHA1 de su contraseña al <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">sitio web de Troy Hunt</a> para ver si esta en la lista. Esto le impedirá a usted usar contraseñas inseguras como se recomienda en la última <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">Publicación Especial de NISH</a> sobre este tema.',
    'secure_pw_should'                          => '¿Debo chequear la casilla?',
    'secure_pw_long_password'                   => 'Sí. Verificar siempre que su contraseña es segura.',
    'command_line_token'                        => 'Token de linea de comando',
    'explain_command_line_token'                => 'Necesita este token para realizar opciones de línea de comandos, como exportar datos. Sin él, ese comando sensible no funcionará. No comparta el token de línea de comandos. Nadie le pedirá este token, ni siquiera yo. Si teme que lo haya perdido, o si es paranoico, vuelva a generar este token usando el botón.',
    'regenerate_command_line_token'             => 'Regenerar token de línea de comando',
    'token_regenerated'                         => 'Se generó un nuevo token de línea de comandos',
    'change_your_email'                         => 'Cambie su dirección de correo',
    'email_verification'                        => 'Se enviará un mensaje de correo electrónico a su antigua Y nueva dirección de correo electrónico. Por razones de seguridad, no podrá iniciar sesión hasta que verifique su nueva dirección de correo electrónico. Si no está seguro de si su instalación de Firefly III es capaz de enviar correo electrónico, por favor no utilice esta función. Si usted es un administrador, puede probar esto en la <a href="settings">configuración</a>.',
    'email_changed_logout'                      => 'Hasta que usted verifique su dirección de correo electrónico, usted no puede iniciar sesión.',
    'login_with_new_email'                      => 'Usted puede ahora iniciar sesión con su nueva dirección de correo electrónico.',
    'login_with_old_email'                      => 'Usted puede ahora iniciar sesión con su vieja dirección de correo electrónico otra vez.',
    'login_provider_local_only'                 => 'Esta acción no está disponible cuando se identifica a través de ":login_provider".',
    'external_user_mgt_disabled'                => 'Esta acción no está disponible cuando Firefly III no es responsable de la gestión de usuarios o de la autenticación.',
    'external_auth_disabled'                    => 'Esta acción no está disponible cuando Firefly III no es responsable del manejo de la autenticación.',
    'delete_local_info_only'                    => "Debido a que Firefly III no es responsable de la gestión de usuarios o de la autenticación, esta función sólo eliminará la información local de Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clientes de OAuth',
    'profile_oauth_no_clients'                  => 'No ha creado ningún cliente OAuth.',
    'profile_oauth_clients_external_auth'       => 'Si está utilizando un proveedor de autenticación externo como Authelia, los clientes OAuth no funcionarán. Sólo puede utilizar tokens de acceso personal.',
    'profile_oauth_clients_header'              => 'Clientes',
    'profile_oauth_client_id'                   => 'ID del cliente',
    'profile_oauth_client_name'                 => 'Nombre',
    'profile_oauth_client_secret'               => 'Secreto',
    'profile_oauth_create_new_client'           => 'Crear un Nuevo Cliente',
    'profile_oauth_create_client'               => 'Crear Cliente',
    'profile_oauth_edit_client'                 => 'Editar Cliente',
    'profile_oauth_name_help'                   => 'Algo que sus usuarios reconocerán y confiarán.',
    'profile_oauth_redirect_url'                => 'Redirigir URL',
    'profile_oauth_redirect_url_help'           => 'La URL de devolución de autorización de su aplicación.',
    'profile_authorized_apps'                   => 'Aplicaciones autorizadas',
    'profile_authorized_clients'                => 'Clientes autorizados',
    'profile_scopes'                            => 'Ámbitos',
    'profile_revoke'                            => 'Revocar',
    'profile_oauth_client_secret_title'         => 'Secreto del Cliente',
    'profile_oauth_client_secret_expl'          => 'Aquí está su nuevo secreto de cliente. Esta es la única vez que se mostrará así que no lo pierda! Ahora puede usar este secreto para hacer solicitudes de API.',
    'profile_personal_access_tokens'            => 'Tokens de acceso personal',
    'profile_personal_access_token'             => 'Token de acceso personal',
    'profile_oauth_confidential'                => 'Confidencial',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Aquí está su nuevo token de acceso personal. Esta es la única vez que se mostrará así que ¡no lo pierda! Ahora puede usar este token para hacer solicitudes de la API.',
    'profile_no_personal_access_token'          => 'No ha creado ningún token de acceso personal.',
    'profile_create_new_token'                  => 'Crear nuevo token',
    'profile_create_token'                      => 'Crear token',
    'profile_create'                            => 'Crear',
    'profile_save_changes'                      => 'Guardar cambios',
    'profile_whoops'                            => '¡Ups!',
    'profile_something_wrong'                   => '¡Algo salió mal!',
    'profile_try_again'                         => 'Algo salió mal. Por favor, vuelva a intentarlo.',
    'amounts'                                   => 'Importes',
    'multi_account_warning_unknown'             => 'Dependiendo del tipo de transacción que cree, la cuenta de origen y/o destino de divisiones posteriores puede ser anulada por lo que se define en la primera división de la transacción.',
    'multi_account_warning_withdrawal'          => 'Tenga en cuenta que la cuenta de origen de las divisiones posteriores será anulada por lo que se defina en la primera división del gasto.',
    'multi_account_warning_deposit'             => 'Tenga en cuenta que la cuenta de destino de las divisiones posteriores será anulada por lo que se defina en la primera división del retiro.',
    'multi_account_warning_transfer'            => 'Tenga en cuenta que la cuenta de origen + destino de divisiones posteriores será anulada por lo que se defina en la primera división de la transferencia.',


    // export data:
    'export_data_title'                         => 'Exportar datos de Firefly III',
    'export_data_menu'                          => 'Exportar datos',
    'export_data_bc'                            => 'Exportar datos de Firefly III',
    'export_data_main_title'                    => 'Exportar datos de Firefly III',
    'export_data_expl'                          => 'Este enlace le permite exportar todas las transacciones + metadatos de Firefly III. Por favor, consulte la ayuda (icono (?) superior derecho) para obtener más información sobre el proceso.',
    'export_data_all_transactions'              => 'Exportar todas las transacciones',
    'export_data_advanced_expl'                 => 'Si necesita un tipo de exportación más avanzado o específico, lea la ayuda sobre cómo usar el comando de consola <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Un archivo adjunto:count archivos adjuntos',
    'attachments'                               => 'Archivos adjuntos',
    'edit_attachment'                           => 'Editar cuenta de archivos ":name"',
    'update_attachment'                         => 'Actualizar archivo adjunto',
    'delete_attachment'                         => 'Eliminar archivo adjunto ":name"',
    'attachment_deleted'                        => 'Eliminar archivo adjunto ":name"',
    'liabilities_deleted'                       => 'Pasivo eliminado ":name"',
    'attachment_updated'                        => 'Actualizar archivo adjunto ":name"',
    'upload_max_file_size'                      => 'Tamaño máximo de archivo::size',
    'list_all_attachments'                      => 'Listado de documentos adjuntos',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Debido a que esta transacción está reconciliada, no podrá actualizar las cuentas, ni la cantidad(es) a menos que elimine la bandera de reconciliación.',
    'is_reconciled'                             => 'Está reconciliado',
    'title_expenses'                            => 'Gastos',
    'title_withdrawal'                          => 'Gastos',
    'title_revenue'                             => 'Ingresos / salarios',
    'title_deposit'                             => 'Ingresos / salarios',
    'title_transfer'                            => 'Transferencias',
    'title_transfers'                           => 'Transferencias',
    'submission_options'                        => 'Opciones de envío',
    'apply_rules_checkbox'                      => 'Aplicar reglas',
    'fire_webhooks_checkbox'                    => 'Disparar webhooks',
    'select_source_account'                     => 'Por favor, seleccione o escriba un nombre de cuenta de origen válido',
    'select_dest_account'                       => 'Por favor, seleccione o escriba un nombre de cuenta de destino válido',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Esta transferencia ya es un gasto',
    'convert_is_already_type_Deposit'           => 'Esta transacción ya es un deposito',
    'convert_is_already_type_Transfer'          => 'Esta transacción ya es una transferencia',
    'convert_to_Withdrawal'                     => 'Convierta ":description" a un gasto',
    'convert_to_Deposit'                        => 'Convierta ":description" en un ingreso',
    'convert_to_Transfer'                       => 'Convierta ":description" en una transferencia',
    'convert_options_WithdrawalDeposit'         => 'Convertir un gasto de efectivo en un ingreso',
    'convert_options_WithdrawalTransfer'        => 'Convertir una retirada de efectivo en una transferencia',
    'convert_options_DepositTransfer'           => 'Convertir un ingreso en una transferencia',
    'convert_options_DepositWithdrawal'         => 'Convertir un depósito en una retirada de efectivo',
    'convert_options_TransferWithdrawal'        => 'Convertir una transferencia en una retirada de efectivo',
    'convert_options_TransferDeposit'           => 'Convertir una transferencia en un ingreso',
    'convert_Withdrawal_to_deposit'             => 'Convierta este gasto en un ingreso',
    'convert_Withdrawal_to_transfer'            => 'Convierta este gasto en una transferencia',
    'convert_Deposit_to_withdrawal'             => 'Convierta este ingreso en un gasto',
    'convert_Deposit_to_transfer'               => 'Convierta este ingreso en una transferencia',
    'convert_Transfer_to_deposit'               => 'Convierta esta transferencia en un deposito',
    'convert_Transfer_to_withdrawal'            => 'Convierta esta transferencia en un gasto',
    'convert_please_set_revenue_source'         => 'Por favor elija la cuenta de ingresos de donde vendrá el dinero.',
    'convert_please_set_asset_destination'      => 'Por favor elija la cuenta de activos a donde el dinero se destinara.',
    'convert_please_set_expense_destination'    => 'Por favor elija la cuenta de gastos a la que ira el dinero.',
    'convert_please_set_asset_source'           => 'Por favor elija la cuenta de activos de donde vendrá el dinero.',
    'convert_expl_w_d'                          => 'Al convertir de un gasto a un ingreso, el dinero será depositado en la cuenta de destino indicada en lugar de ser retirado de la misma.| Cuando se convierte de un gasto a un ingreso, el dinero será depositado en las cuentas de destino indicadas en lugar de ser retirado de las mismas.',
    'convert_expl_w_t'                          => 'Al convertir un gasto en una transferencia, el dinero se transferirá fuera de la cuenta de origen a otra cuenta de activos o pasivos en lugar de ser gastado en la cuenta de gastos originales. |Al convertir un gasto en una transferencia, el dinero se transferirá fuera de las cuentas de origen a otras cuentas de activos o pasivos en lugar de gastarse en las cuentas de gastos originales.',
    'convert_expl_d_w'                          => 'Al convertir un ingreso en gasto, el dinero será retirado de la cuenta de origen mostrada en lugar de ser depositado en ella. |Al convertir un ingreso en un gasto, el dinero se retirará de las cuentas de origen mostradas en lugar de depositarse en ellas.',
    'convert_expl_d_t'                          => 'Cuando convierte un depósito en una transferencia, el dinero será depositado en la cuenta de destino listada desde cualquiera de sus cuentas de activos o pasivos. Cuando usted convierte un depósito en una transferencia, el dinero será depositado en las cuentas de destino listadas desde cualquiera de sus cuentas de activos o de responsabilidad.',
    'convert_expl_t_w'                          => 'Cuando usted convierte una transferencia en un gasto, el dinero se gastará en la cuenta de destino que haya establecido aquí, en lugar de ser transferido.|Cuando usted convierte una transferencia en un gasto, el dinero se gastará en las cuentas de destino que haya establecido aquí, en lugar de ser transferido.',
    'convert_expl_t_d'                          => 'Cuando usted convierte una transferencia en un depósito, el dinero será depositado en la cuenta de destino que usted ve aquí, en lugar de ser transferido a ella. |Cuando usted convierte una transferencia en un depósito, el dinero será depositado en las cuentas de destino que usted ve aquí, en lugar de ser transferido a ellas.',
    'convert_select_sources'                    => 'Para completar la conversión, por favor establezca la nueva cuenta de origen a continuación.|Para completar la conversión, por favor configure las nuevas cuentas de origen a continuación.',
    'convert_select_destinations'               => 'Para completar la conversión, por favor establezca la nueva cuenta de origen a continuación.|Para completar la conversión, por favor configure las nuevas cuentas de origen a continuación.',
    'converted_to_Withdrawal'                   => 'La transacción se convirtió en un gasto',
    'converted_to_Deposit'                      => 'La transacción se ha convertido en un ingreso',
    'converted_to_Transfer'                     => 'La transacción se convirtió en transferencia',
    'invalid_convert_selection'                 => 'L a cuenta que usted ha selecionado ya esta en uso o no existe.',
    'source_or_dest_invalid'                    => 'No pude encontrar los detalles correctos de la transacción. La conversión no es posible.',
    'convert_to_withdrawal'                     => 'Convertir a gasto',
    'convert_to_deposit'                        => 'Convertir a ingreso',
    'convert_to_transfer'                       => 'Convertir a transferencia',

    // create new stuff:
    'create_new_withdrawal'                     => 'Crear nuevo gasto',
    'create_new_deposit'                        => 'Crear nuevo ingreso',
    'create_new_transfer'                       => 'Crear nueva transferencia',
    'create_new_asset'                          => 'Crear nueva cuenta de activos',
    'create_new_liabilities'                    => 'Crear nuevo pasivo',
    'create_new_expense'                        => 'Crear nueva cuenta de gastos',
    'create_new_revenue'                        => 'Crear nueva cuenta de ingresos',
    'create_new_piggy_bank'                     => 'Crear nueva hucha',
    'create_new_bill'                           => 'Crear nueva suscripción',
    'create_new_subscription'                   => 'Crear nueva suscripción',
    'create_new_rule'                           => 'Crear nueva regla',

    // currencies:
    'create_currency'                           => 'Crear nueva moneda',
    'store_currency'                            => 'Crear moneda',
    'update_currency'                           => 'Actualizar moneda',
    'new_default_currency'                      => '":name" es ahora la moneda predeterminada.',
    'default_currency_failed'                   => 'No se pudo establecer ":name" como moneda predeterminada. Por favor, compruebe los registros.',
    'cannot_delete_currency'                    => 'No puede eliminar :name porque todavía esta en uso.',
    'cannot_delete_fallback_currency'           => ':name es la moneda de reserva del sistema y no se puede eliminar.',
    'cannot_disable_currency_journals'          => 'No se puede desactivar :name porque las transacciones siguen utilizándola.',
    'cannot_disable_currency_last_left'         => 'No se puede desactivar :name porque es la última moneda habilitada.',
    'cannot_disable_currency_account_meta'      => 'No se puede desactivar :name porque se utiliza en cuentas de activos.',
    'cannot_disable_currency_bills'             => 'No se puede desactivar :name porque se utiliza en suscripción.',
    'cannot_disable_currency_recurring'         => 'No se puede desactivar :name porque se utiliza en transacciones recurrentes.',
    'cannot_disable_currency_available_budgets' => 'No se puede desactivar :name porque se utiliza en presupuestos disponibles.',
    'cannot_disable_currency_budget_limits'     => 'No se puede desactivar :name porque se utiliza en límites presupuestarios.',
    'cannot_disable_currency_current_default'   => 'No se puede desactivar :name porque es la moneda por defecto actual.',
    'cannot_disable_currency_system_fallback'   => 'No se puede desactivar :name porque es la moneda por defecto del sistema.',
    'disable_EUR_side_effects'                  => 'El Euro es la moneda de emergencia del sistema. Desactivarla puede tener efectos secundarios no deseados y puede anular su garantía.',
    'deleted_currency'                          => 'Moneda :name eliminada',
    'created_currency'                          => 'Moneda :name creada',
    'could_not_store_currency'                  => 'No se puede crear la nueva moneda.',
    'updated_currency'                          => 'Moneda :name actualizada',
    'ask_site_owner'                            => 'Por favor pregunte :owner por agregar,elimine o edite monedas.',
    'currencies_intro'                          => 'Firefly III respalda varias monedas que usted puede establecer y habilitar aquí.',
    'currencies_switch_default'                 => 'Puedes cambiar la moneda principal para su administración actual en la página de "Administraciones Financieras".',
    'make_default_currency'                     => 'Establecer por defecto',
    'default_currency'                          => 'por defecto',
    'primary_currency_button'                   => 'principal',
    'currency_is_disabled'                      => 'Deshabilitado',
    'enable_currency'                           => 'Activar',
    'disable_currency'                          => 'Desactivar',
    'currencies_default_disabled'               => 'La mayoría de estas monedas están desactivadas por defecto. Para usarlas, debes activarlas primero.',
    'currency_is_now_enabled'                   => 'Moneda ":name" ha sido activada',
    'could_not_enable_currency'                 => 'No se pudo habilitar la moneda ":name". Por favor, revise los registros.',
    'currency_is_now_disabled'                  => 'Moneda ":name" ha sido desactivada',
    'could_not_disable_currency'                => 'No se pudo deshabilitar la moneda ":name". ¿Tal vez todavía esté en uso?',

    // forms:
    'mandatoryFields'                           => 'Campos obligatorios',
    'optionalFields'                            => 'Campos opcionales',
    'options'                                   => 'Opciones',

    // budgets:
    'daily_budgets'                             => 'Presupuestos diarios',
    'weekly_budgets'                            => 'Presupuestos semanales',
    'monthly_budgets'                           => 'Presupuestos mensuales',
    'quarterly_budgets'                         => 'Presupuestos trimestrales',
    'half_year_budgets'                         => 'Presupuestos semestrales',
    'yearly_budgets'                            => 'Presupuestos anuales',
    'other_budgets'                             => 'Presupuestos de tiempo personalizado',
    'budget_limit_not_in_range'                 => 'Esta cantidad se aplica desde :start hasta :end:',
    'total_available_budget'                    => 'Presupuesto total disponible (entre :start y :end)',
    'total_available_budget_in_currency'        => 'Presupuesto total disponible en :currency',
    'see_below'                                 => 'ver abajo',
    'create_new_budget'                         => 'Crear un nuevo presupuesto',
    'store_new_budget'                          => 'Almacene el nuevo presupuesto',
    'stored_new_budget'                         => 'Presupuesto ":name" creado',
    'available_between'                         => 'Disponible entre :start y :end',
    'transactionsWithoutBudget'                 => 'Gastos sin presupuesto',
    'transactions_no_budget'                    => 'Gastos sin presupuesto entre :start y :end',
    'spent_between'                             => 'Gastado entre :start y :end',
    'spent_between_left'                        => 'Gastado :spent entre :start y :end, dejando :left.',
    'set_available_amount'                      => 'Fijar cantidad disponible',
    'update_available_amount'                   => 'Actualizar cantidad disponible',
    'ab_basic_modal_explain'                    => 'Utilice este formulario para indicar cuánto espera poder presupuestar (en total, en :currency) en el período indicado.',
    'createBudget'                              => 'Nuevo presupuesto',
    'invalid_currency'                          => 'Esta es una divisa no válida',
    'invalid_amount'                            => 'Por favor, introduzca una cantidad',
    'set_ab'                                    => 'Se ha establecido el presupuesto disponible',
    'updated_ab'                                => 'El presupuesto disponible ha sido actualizado',
    'deleted_ab'                                => 'El presupuesto disponible ha sido eliminado',
    'deleted_bl'                                => 'La cantidad presupuestada ha sido eliminada',
    'alt_currency_ab_create'                    => 'Establecer el presupuesto disponible en otra divisa',
    'bl_create_btn'                             => 'Establecer presupuesto en otra divisa',
    'inactiveBudgets'                           => 'Presupuestos inactivos',
    'without_budget_between'                    => 'Transacciones sin presupuesto entre :start y :end',
    'delete_budget'                             => 'Eliminar presupuesto ":name"',
    'deleted_budget'                            => 'Presupuesto eliminado ":name"',
    'edit_budget'                               => 'Editar presupuesto ":name"',
    'updated_budget'                            => 'Presupuesto actualizado ":name"',
    'update_amount'                             => 'Actualizar cantidad',
    'update_budget'                             => 'Actualizar presupuesto',
    'update_budget_amount_range'                => 'Cantidad disponible (esperada) actualizada entre :start y :end',
    'set_budget_limit_title'                    => 'Establecer el importe para el presupuesto :budget entre :start y :end',
    'set_budget_limit'                          => 'Establecer cantidad presupuestada',
    'budget_period_navigator'                   => 'Periodo navegador',
    'info_on_available_amount'                  => '¿ que tengo disponible?',
    'available_amount_indication'               => 'Utilice estas cantidades para obtener una indicación de lo que podría ser su presupuesto total.',
    'suggested'                                 => 'Sugerido',
    'average_between'                           => 'Promedio entre :start y :end',
    'transferred_in'                            => 'Transferido (dentro)',
    'transferred_away'                          => 'Transferido (fuera)',
    'auto_budget_none'                          => 'Sin autopresupuesto',
    'auto_budget_reset'                         => 'Establecer una cantidad fija cada periodo',
    'auto_budget_rollover'                      => 'Añadir una cantidad cada período',
    'auto_budget_adjusted'                      => 'Añadir una cantidad cada periodo y corregir el sobregasto',
    'auto_budget_period_daily'                  => 'Diario',
    'auto_budget_period_weekly'                 => 'Semanal',
    'auto_budget_period_monthly'                => 'Mensual',
    'auto_budget_period_quarterly'              => 'Trimestral',
    'auto_budget_period_half_year'              => 'Cada medio año',
    'auto_budget_period_yearly'                 => 'Anual',
    'auto_budget_help'                          => 'Puedes leer más sobre esta función en la ayuda. Haz clic en el icono de la parte superior derecha (?).',
    'auto_budget_reset_icon'                    => 'Este presupuesto se establecerá periódicamente',
    'auto_budget_rollover_icon'                 => 'La cantidad del presupuesto aumentará periódicamente',
    'auto_budget_adjusted_icon'                 => 'La cantidad del presupuesto aumentará de forma periódica y se corregirá el sobregasto',
    'remove_budgeted_amount'                    => 'Eliminar la cantidad presupuestada en :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'restante a pagar',
    'less_than_expected'                        => 'menos de lo esperado',
    'more_than_expected'                        => 'más de lo esperado',
    'skip_help_text'                            => 'Utilice el campo saltar para crear dos meses (saltar = 1) u otros intervalos personalizados.',
    'subscription'                              => 'Subscripción',
    'not_expected_period'                       => 'No se espera en este período',
    'subscriptions_in_group'                    => 'Suscripciones en el grupo "{{title}}"',
    'subscr_expected_x_times'                   => 'Se espera pagar {{amount}} {{times}} veces este periodo',
    'not_or_not_yet'                            => 'No (todavía)',
    'visit_bill'                                => 'Ver suscripción ":name" en Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'La suscripción iguala transacciones entre :low y :high.',
    'running_again_loss'                        => 'Las transacciones previamente vinculadas a esta suscripción pueden perder su conexión, si (ya) no coinciden con la(s) regla(s).',
    'bill_related_rules'                        => 'Reglas relacionadas con esta suscripción',
    'repeats'                                   => 'Repeticiones',
    'bill_end_date_help'                        => 'Campo opcional. Se espera que la suscripción venza en esta fecha.',
    'bill_extension_date_help'                  => 'Campo opcional. La suscripción debe ser prorrogada (o cancelada) en o antes de esta fecha.',
    'bill_end_index_line'                       => 'Esta suscripción termina el :date',
    'bill_extension_index_line'                 => 'Esta suscripción debe ser extendida o cancelada el :date',
    'connected_journals'                        => 'Transacciones conectadas',
    'auto_match_on'                             => 'Automáticamente igualado por Firefly III',
    'auto_match_off'                            => 'No igualado automaticamente por Firefly III',
    'next_expected_match'                       => 'Próxima coincidencia esperada',
    'delete_bill'                               => 'Eliminar suscripción ":name"',
    'deleted_bill'                              => 'Eliminó suscripción ":name"',
    'edit_bill'                                 => 'Editar suscripción ":name"',
    'more'                                      => 'Mas',
    'rescan_old'                                => 'Ejecutar las reglas de nuevo, en todas las transacciones',
    'update_bill'                               => 'Actualizar suscripción',
    'updated_bill'                              => 'Actualizó la suscripción ":name"',
    'store_new_bill'                            => 'Guardar nueva suscripción',
    'stored_new_bill'                           => 'Nueva suscripción almacenada ":name"',
    'cannot_scan_inactive_bill'                 => 'Las suscripciones inactivas no pueden ser escaneadas.',
    'rescanned_bill'                            => 'Se volvió a escanear todo, y vinculó :count transacción a la suscripción. | Se volvió a escanear todo, y vinculó :count transacciones a la suscripción.',
    'average_bill_amount_year'                  => 'Cantidad media de la suscripción (:year)',
    'average_bill_amount_overall'               => 'Cantidad media de las suscripciones (total)',
    'bill_is_active'                            => 'La suscripción está activa',
    'bill_expected_between'                     => 'Esperado entre :start y :end',
    'bill_will_automatch'                       => 'La suscripción se vinculará automáticamente a las transacciones coincidentes',
    'skips_over'                                => 'salta sobre',
    'bill_store_error'                          => 'Se ha producido un error inesperado mientras se almacenaba su nueva suscripción. Por favor, compruebe los archivos de registro',
    'list_inactive_rule'                        => 'regla inactiva',
    'bill_edit_rules'                           => 'Firefly III también intentará editar la regla relacionada con esta suscripción. Sin embargo, si ha editado esta regla usted mismo, Firefly III no cambiará nada.|Firefly III intentará editar también las :count reglas relacionadas con esta suscripción. Sin embargo, si ha editado estas reglas usted mismo, Firefly III no cambiará nada.',
    'bill_expected_date'                        => 'Se espera :date',
    'bill_expected_date_js'                     => 'Fecha prevista {date}',
    'expected_amount'                           => 'Cantidad (esperada)',
    'bill_paid_on'                              => 'Pagado el {date}',
    'bill_repeats_weekly'                       => 'Repetir semanalmente',
    'bill_repeats_monthly'                      => 'Repetir mensualmente',
    'bill_repeats_quarterly'                    => 'Repite trimestralmente',
    'bill_repeats_half-year'                    => 'Repetir cada 6 meses',
    'bill_repeats_yearly'                       => 'Repetir anualmente',
    'bill_repeats_weekly_other'                 => 'Repetir cada dos semanas',
    'bill_repeats_monthly_other'                => 'Repetir cada dos meses',
    'bill_repeats_quarterly_other'              => 'Repetir cada dos trimestres',
    'bill_repeats_half-year_other'              => 'Repetir anualmente',
    'bill_repeats_yearly_other'                 => 'Repetir cada dos años',
    'bill_repeats_weekly_skip'                  => 'Repetir cada {skip} semanas',
    'bill_repeats_monthly_skip'                 => 'Repetir cada {skip} meses',
    'bill_repeats_quarterly_skip'               => 'Repetir cada {skip} trimestres',
    'bill_repeats_half-year_skip'               => 'Repetir cada {skip} medios años',
    'bill_repeats_yearly_skip'                  => 'Repetir cada {skip} años',
    'subscriptions'                             => 'Suscripciones',
    'go_to_subscriptions'                       => 'Ir a tus suscripciones',
    'forever'                                   => 'Siempre',
    'extension_date_is'                         => 'Fecha de extensión es {date}',

    // accounts:
    'account_locked_currency'                   => 'La moneda de esta cuenta debe permanecer como :name siempre que existan huchas vinculadas a esta.',
    'i_am_owed_amount'                          => 'Se me debe una cantidad',
    'i_owe_amount'                              => 'Debo una cantidad',
    'inactive_account_link'                     => 'Tiene :count cuenta inactiva (archivada), que puedes ver en esta página separada.|Tienes cuentas :count inactivas (archivadas), que puedes ver en esta página separada.',
    'all_accounts_inactive'                     => 'Estas son sus cuentas inactivas.',
    'active_account_link'                       => 'Este enlace se regresa a sus cuentas activas.',
    'account_missing_transaction'               => 'Cuenta #:id (":name") no puede ser vista directamente, Firefly perdió información de redirección.',
    'cc_monthly_payment_date_help'              => 'Seleccione cualquier año y mes, será ignorado de todos modos. Sólo el día del mes es relevante.',
    'details_for_asset'                         => 'Detalles para la cuenta de activos ":name"',
    'details_for_expense'                       => 'Detalles para la cuenta de gastos ":name"',
    'details_for_revenue'                       => 'Detalles para la cuenta de ingresos ":name"',
    'details_for_cash'                          => 'Detalle para la cuenta de efectivo ":name"',
    'store_new_asset_account'                   => 'Crear cuenta de activos',
    'store_new_expense_account'                 => 'Crear cuenta de gastos',
    'store_new_revenue_account'                 => 'Crear cuenta de ingresos',
    'edit_asset_account'                        => 'Editar cuenta de activos ":name"',
    'edit_expense_account'                      => 'Editar cuenta de gastos ":name"',
    'edit_revenue_account'                      => 'Editar cuenta de ganancias ":name"',
    'delete_asset_account'                      => 'Eliminar cuenta de activo ":name"',
    'delete_expense_account'                    => 'Eliminar cuenta de gastos ":name"',
    'delete_revenue_account'                    => 'Eliminar cuenta de ganancias ":name"',
    'delete_liabilities_account'                => 'Eliminar pasivo ":name"',
    'asset_deleted'                             => 'Se ha eliminado exitosamente la cuenta de activos ":name"',
    'account_deleted'                           => 'Cuenta "::name" eliminada con éxito',
    'expense_deleted'                           => 'Exitosamente eliminado la cuenta de gastos ":name"',
    'revenue_deleted'                           => 'Exitosamente eliminado cuenta de ganacias ":name"',
    'update_asset_account'                      => 'Actualizar cuenta de activos',
    'update_undefined_account'                  => 'Actualizar cuenta',
    'update_liabilities_account'                => 'Actualizar pasivo',
    'update_expense_account'                    => 'Actualizar cuenta de gastos',
    'update_revenue_account'                    => 'Actualizar cuenta de ingresos',
    'make_new_asset_account'                    => 'Crear nueva cuenta de activo',
    'make_new_expense_account'                  => 'Crear nueva cuenta de gastos',
    'make_new_revenue_account'                  => 'Crear nueva cuenta de ingresos',
    'make_new_liabilities_account'              => 'Crear un nuevo pasivo',
    'asset_accounts'                            => 'Cuenta de activos',
    'undefined_accounts'                        => 'Cuentas',
    'asset_accounts_inactive'                   => 'Cuentas de activos (inactivas)',
    'expense_account'                           => 'Cuenta de gastos',
    'expense_accounts'                          => 'Cuentas de gastos',
    'expense_accounts_inactive'                 => 'Cuentas de gastos (inactivas)',
    'revenue_account'                           => 'Cuenta de ingresos',
    'revenue_accounts'                          => 'Cuentas de ingresos',
    'revenue_accounts_inactive'                 => 'Cuentas de ingresos (inactivas)',
    'cash_accounts'                             => 'Cuentas de efectivo',
    'Cash account'                              => 'Cuenta de efectivo',
    'liabilities_accounts'                      => 'Pasivos',
    'liabilities_accounts_inactive'             => 'Pasivos (inactivos)',
    'reconcile_account'                         => 'Reconciliar cuenta ":account"',
    'overview_of_reconcile_modal'               => 'Resumen de reconciliación',
    'delete_reconciliation'                     => 'Eliminar reconciliacion',
    'update_reconciliation'                     => 'Actualizar reconciliacion',
    'amount_cannot_be_zero'                     => 'La cantidad no puede ser cero',
    'end_of_reconcile_period'                   => 'Fin del periodo de reconciliacion::period',
    'start_of_reconcile_period'                 => 'Inicio de periodo de reconciliación::period',
    'start_balance'                             => 'Balance inicial',
    'end_balance'                               => 'Balance final',
    'update_balance_dates_instruction'          => 'Coinciden con las cantidades y fechas sobre su estado de cuenta, y presione "comenzar reconciliación"',
    'select_transactions_instruction'           => 'Seleccione las transacciones que aparecen en su estado bancario.',
    'select_range_and_balance'                  => 'Primero verifique el rango de las fechas y los saldos. luego presione "comenzar reconciliación"',
    'date_change_instruction'                   => 'Si usted cambia el rango de las fechas ahora, se perderá cualquier progreso.',
    'update_selection'                          => 'Selección de actualización',
    'store_reconcile'                           => 'Guardar reconciliación',
    'reconciliation_transaction'                => 'Transacción de reconciliación',
    'Reconciliation'                            => 'Reconciliacion',
    'reconciliation'                            => 'Reconciliacion',
    'reconcile_options'                         => 'Opciones de reconciliacion',
    'reconcile_range'                           => 'Rango de reconciliacion',
    'start_reconcile'                           => 'Comienzo de reconciliación',
    'cash_account_type'                         => 'Efectivo',
    'cash'                                      => 'efectivo',
    'cant_find_redirect_account'                => 'Firefly III le intentó redirigir pero no pudo. Lo sentimos. Volver al índice.',
    'account_type'                              => 'Tipo de cuenta',
    'save_transactions_by_moving'               => 'Guardar esta transacción moviéndola a otra cuenta:|Guardar estas transacciones moviéndolas a otra cuenta:',
    'save_transactions_by_moving_js'            => 'Ninguna transacción|Guardar esta transacción moviéndola a otra cuenta. |Guardar estas transacciones moviéndolas a otra cuenta.',
    'stored_new_account'                        => 'Nueva cuenta ":name" almacenada!',
    'stored_new_account_js'                     => 'Nueva cuenta "<a href="accounts/show/{ID}">{name}</a>" guardada!',
    'updated_account'                           => 'Cuenta actualizada ":name"',
    'updated_account_js'                        => 'Cuenta actualizada "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opciones de tarjeta de crédito',
    'no_transactions_account'                   => 'No hay transacciones ( en este periodo) para cuenta de activos ":name".',
    'no_transactions_period'                    => 'No hay transacciones (en este período).',
    'no_data_for_chart'                         => 'No hay suficiente información (todavía) para generar este gráfico.',
    'select_at_least_one_account'               => 'Por favor, seleccione al menos una cuenta',
    'select_at_least_one_category'              => 'Por favor, seleccione al menos una categoría',
    'select_at_least_one_budget'                => 'Por favor, seleccione al menos un presupuesto',
    'select_at_least_one_tag'                   => 'Por favor, seleccione al menos una etiqueta',
    'select_at_least_one_expense'               => 'Por favor, seleccione al menos una combinación de cuentas de gastos/ingresos. Si no tiene ninguna (la lista está vacía) este informe no está disponible.',
    'account_default_currency'                  => 'Esta será la moneda por defecto asociada a esta cuenta.',
    'piggy_default_currency'                    => 'Las huchas solo pueden ahorrar dinero en una moneda única.',
    'piggy_account_currency_match'              => 'Solo se aceptarán cuentas que usen la moneda seleccionada anteriormente.',
    'reconcile_has_more'                        => 'Su libro principal de Firefly III tiene mas dinero del que su banco afirma debería tener. Hay varias opciones. Por favor elija que hacer. Luego, presione "confirmar reconciliación".',
    'reconcile_has_less'                        => 'Su libro principal de Firefly III tiene menos dinero del que su banco dice que usted debería tener. Hay varias opciones. Por favor elija que hacer, luego presione "Confirmar reconciliación".',
    'reconcile_is_equal'                        => 'Su libro principal de Firefly III y sus estados de cuenta coinciden. No hay nada que hacer. por favor presione "Confirmar reconciliación" para confirmar su entrada.',
    'create_pos_reconcile_transaction'          => 'Marque las transacciones seleccionadas como conciliadas y cree una corrección agregando :amount a esta cuenta de activo.',
    'create_neg_reconcile_transaction'          => 'Marque las transacciones seleccionadas como conciliadas y cree una corrección eliminando :amount de esta cuenta de activo.',
    'reconcile_do_nothing'                      => 'Marque las transacciones seleccionadas como conciliadas, pero no las corrija.',
    'reconcile_go_back'                         => 'Usted puede siempre editar o eliminar una corrección mas tarde.',
    'must_be_asset_account'                     => 'Usted solo puede reconciliar cuentas de activos',
    'reconciliation_stored'                     => 'Reconciliación almacenada',
    'reconciliation_error'                      => 'Debido a un error, las transacciones fueron marcadas como reconciliadas, pero la corrección no se ha guardado: :error.',
    'reconciliation_transaction_title'          => 'Reconciliación (:from a :to)',
    'sum_of_reconciliation'                     => 'Suma de reconciliación',
    'reconcile_this_account'                    => 'Reconciliar esta cuenta',
    'reconcile'                                 => 'Reconciliar',
    'show'                                      => 'Mostrar',
    'confirm_reconciliation'                    => 'Confirmar la reconciliacion',
    'submitted_start_balance'                   => 'Balance final enviado',
    'selected_transactions'                     => 'Transacciones seleccionadas (:count)',
    'already_cleared_transactions'              => 'Transacciones ya despejadas (:count)',
    'submitted_end_balance'                     => 'Balance final enviado',
    'initial_balance_description'               => 'Balance inicial para ":account"',
    'liability_credit_description'              => 'Crédito pasivo para ":account"',
    'interest_calc_'                            => 'desconocido',
    'interest_calc_daily'                       => 'Por dia',
    'interest_calc_monthly'                     => 'Por mes',
    'interest_calc_yearly'                      => 'Por año',
    'interest_calc_weekly'                      => 'Por semana',
    'interest_calc_half-year'                   => 'Por semestre',
    'interest_calc_quarterly'                   => 'Por trimestre',
    'initial_balance_account'                   => 'Balance inicial de la cuenta :account',
    'list_options'                              => 'Opciones de lista',
    'account_column_opt_drag_and_drop'          => 'Arrastrar y soltar',
    'account_column_opt_active'                 => 'Activo',
    'account_column_opt_name'                   => 'Nombre',
    'account_column_opt_type'                   => 'Tipo',
    'account_column_opt_liability_type'         => 'Tipo de pasivo',
    'account_column_opt_liability_direction'    => 'Dirección de pasivo',
    'account_column_opt_liability_interest'     => 'Interés del pasivo',
    'account_column_opt_number'                 => 'Número de cuenta',
    'account_column_opt_current_balance'        => 'Balance actual',
    'account_column_opt_amount_due'             => 'Importe debido',
    'account_column_opt_last_activity'          => 'Última actividad',
    'account_column_opt_balance_difference'     => 'Diferencia de saldo',
    'account_column_opt_menu'                   => 'Menú',

    // categories:
    'new_category'                              => 'Nueva categoría',
    'create_new_category'                       => 'Crear una nueva categoria',
    'without_category'                          => 'Sin categoría',
    'update_category'                           => 'Actualizar categoría',
    'updated_category'                          => 'Actualizar categoría ":name"',
    'categories'                                => 'Categorías',
    'edit_category'                             => 'Editar categoría ":name"',
    'no_category'                               => '(sin categoría)',
    'unknown_category_plain'                    => 'Sin categoría',
    'category'                                  => 'Categoría',
    'delete_category'                           => 'Eliminar categoría ":name"',
    'deleted_category'                          => 'Categoría eliminada ":name"',
    'store_category'                            => 'Guardar nueva categoría',
    'stored_category'                           => 'Nueva categoría guardada ":name"',
    'without_category_between'                  => 'Sin categoría entre :start y:end',


    // transactions:
    'wait_loading_transaction'                  => 'Por favor, espere a que se cargue el formulario',
    'wait_loading_data'                         => 'Por favor, espere a que su información se cargue...',
    'wait_attachments'                          => 'Por favor, espere a que se carguen los archivos adjuntos.',
    'errors_upload'                             => 'La carga ha fallado. Por favor, comprueba el error en la consola de tu navegador.',
    'amount_foreign_if'                         => 'Importe en moneda extranjera, si existe',
    'amount_destination_account'                => 'Importe en la moneda de la cuenta de destino',
    'edit_transaction_title'                    => 'Editar transacción ":description"',
    'unreconcile'                               => 'Deshacer reconciliación',
    'update_withdrawal'                         => 'Actualización de gasto',
    'update_deposit'                            => 'Actualizar ingreso',
    'update_transaction'                        => 'Actualizar transacción',
    'update_transfer'                           => 'Actualización de transferencia',
    'updated_withdrawal'                        => 'Gasto actualizado',
    'updated_deposit'                           => 'Actualizado ingreso ":description"',
    'updated_transfer'                          => 'Transferencia actualizada ":description"',
    'no_changes_withdrawal'                     => 'El gasto ":description" no se cambió.',
    'no_changes_deposit'                        => 'El ingreso ":description" no se cambió.',
    'no_changes_transfer'                       => 'Transferencia ":description" no se cambió.',
    'delete_withdrawal'                         => 'Eliminar gasto ":description"',
    'delete_deposit'                            => 'Eliminar ingreso ":description"',
    'delete_transfer'                           => 'Eliminar transferencia ":description"',
    'deleted_withdrawal'                        => 'Eliminado correctamente',
    'deleted_deposit'                           => 'Ingreso eliminado correctamente ":description"',
    'deleted_transfer'                          => 'Transferencia eliminada exitosamente ":description"',
    'deleted_reconciliation'                    => 'Transacción de conciliación eliminada con éxito "::description"',
    'stored_journal'                            => 'Nueva transacción creada exitosamente ":description"',
    'stored_journal_js'                         => 'Nueva transacción creada con éxito "{{description}}"',
    'stored_journal_no_descr'                   => 'Se ha creado tu nueva transacción con éxito',
    'updated_journal_no_descr'                  => 'Se ha actualizado tu transacción con éxito',
    'select_transactions'                       => 'Seleccionar transacciones',
    'rule_group_select_transactions'            => 'Aplicar ":title" a las transacciones',
    'rule_select_transactions'                  => 'Aplicar ":title" a las transacciones',
    'stop_selection'                            => 'Pare de seleccionas transacciones',
    'reconcile_selected'                        => 'Reconciliar',
    'mass_delete_journals'                      => 'Eliminar un numero de transacciones',
    'mass_edit_journals'                        => 'Editar un numero de transacciones',
    'mass_bulk_journals'                        => 'Editar múltiples transacciones',
    'mass_bulk_journals_explain'                => 'Este formulario le permite cambiar las propiedades de las transacciones que aparecen a continuación en una actualización de barrido. Todas las transacciones en la tabla se actualizarán cuando cambie los parámetros que vea aquí.',
    'part_of_split'                             => 'Esta transacción es parte de una transacción dividida. Si no ha seleccionado todas las partes, puede terminar con cambiar sólo la mitad de la transacción.',
    'bulk_set_new_values'                       => 'Use las entradas abajo para establecer nuevos valores. Si usted los deja vacíos, serán vacíos para todos. también, tenga en cuenta que solo los gastos tendrán un presupuesto.',
    'no_bulk_category'                          => 'No actualizar la categoría',
    'no_bulk_budget'                            => 'No actualizar el presupuesto',
    'no_bulk_tags'                              => 'No actualizar etiqueta(s)',
    'replace_with_these_tags'                   => 'Reemplazar con estas etiquetas',
    'append_these_tags'                         => 'Añadir esas etiquetas',
    'mass_edit'                                 => 'Editar seleccionado individualmente',
    'bulk_edit'                                 => 'Editar seleccionados en masa',
    'mass_delete'                               => 'Eliminar seleccionados',
    'cannot_edit_other_fields'                  => 'Usted no puede editar en masa otros campos ademas de los que están aquí, porque no hay espacio para mostrarlos. siga el enlace y editelo uno a uno, si usted necesita editar estos campos.',
    'cannot_change_amount_reconciled'           => 'No puede cambiar la cantidad o cuenta(s) de las transacciones reconciliadas.',
    'no_budget'                                 => '(sin presupuesto)',
    'no_bill'                                   => '(sin suscripción)',
    'account_per_budget'                        => 'Cuenta por presupuesto',
    'account_per_category'                      => 'Cuenta por categoría',
    'create_new_object'                         => 'Crear',
    'empty'                                     => '(vacío)',
    'all_other_budgets'                         => '(todos los demás presupuestos)',
    'all_other_accounts'                        => '(todas las demás cuentas)',
    'expense_per_source_account'                => 'Gastos por cuenta de origen',
    'expense_per_destination_account'           => 'Gastos por cuenta destino',
    'income_per_destination_account'            => 'Ingresos por cuenta de destino',
    'spent_in_specific_category'                => 'Gastado en categoría ":category"',
    'earned_in_specific_category'               => 'Ganado en la categoría ":category"',
    'spent_in_specific_tag'                     => 'Gastado en etiqueta ":tag"',
    'earned_in_specific_tag'                    => 'Ganado en etiqueta ":tag"',
    'income_per_source_account'                 => 'Ingresos por cuenta fuente',
    'average_spending_per_destination'          => 'Gasto promedio por cuenta de destino',
    'average_spending_per_source'               => 'Gasto promedio por cuenta de origen',
    'average_earning_per_source'                => 'Ingreso promedio por cuenta de origen',
    'average_earning_per_destination'           => 'Ingreso promedio por cuenta de destino',
    'account_per_tag'                           => 'Cuenta por etiqueta',
    'tag_report_expenses_listed_once'           => 'Los gastos y los ingresos nunca se enumeran dos veces. Si una transacción tiene múltiples etiquetas, sólo puede aparecer bajo una de sus etiquetas. Esta lista puede parecer que faltan datos, pero las cantidades serán correctas.',
    'double_report_expenses_charted_once'       => 'Los gastos y los ingresos nunca se muestran dos veces. Si una transacción tiene múltiples etiquetas, sólo puede aparecer bajo una de sus etiquetas. Este gráfico puede parecer que faltan datos, pero las cantidades serán correctas.',
    'tag_report_chart_single_tag'               => 'Este gráfico se aplica a una sola etiqueta. Si una transacción tiene múltiples etiquetas, lo que ve aquí puede reflejarse también en los gráficos de otras etiquetas.',
    'tag'                                       => 'Etiqueta',
    'no_budget_squared'                         => '(sin presupuesto)',
    'perm-delete-many'                          => 'Eliminar muchos elementos en una sola vez puede ser muy perturbador. Por favor, tenga cuidado. Puede eliminar parte de una transacción dividida de esta página, así que tenga cuidado.',
    'mass_deleted_transactions_success'         => 'Eliminado :count transacción.|Eliminado :count transacciones.',
    'mass_edited_transactions_success'          => 'Actualizado :count transaction.|Actualizado :count transacciones.',
    'opt_group_'                                => '(Sin tipo de cuenta)',
    'opt_group_no_account_type'                 => '(Sin tipo de cuenta)',
    'opt_group_defaultAsset'                    => 'Cuentas de activos por defecto',
    'opt_group_savingAsset'                     => 'Cuenta de ahorros',
    'opt_group_sharedAsset'                     => 'Cuenta de activos compartidas',
    'opt_group_ccAsset'                         => 'Tarjetas de credito',
    'opt_group_cashWalletAsset'                 => 'Billeteras de efectivo',
    'opt_group_expense_account'                 => 'Cuentas de gastos',
    'opt_group_revenue_account'                 => 'Cuentas de ingresos',
    'opt_group_l_Loan'                          => 'Pasivo: Préstamo',
    'opt_group_cash_account'                    => 'Cuenta de efectivo',
    'opt_group_l_Debt'                          => 'Pasivo: Deuda',
    'opt_group_l_Mortgage'                      => 'Pasivo: Hipoteca',
    'opt_group_l_Credit card'                   => 'Pasivo: Tarjeta de crédito',
    'notes'                                     => 'Notas',
    'view_notes'                                => 'Ver notas',
    'set_budget_limit_notes'                    => 'Ver las notas de esta cantidad presupuestada',
    'edit_bl_notes'                             => 'Editar notas',
    'update_bl_notes'                           => 'Actualizar notas',
    'unknown_journal_error'                     => 'No se pudo guardar la transacción. Por favor, revise los archivos de registro.',
    'attachment_not_found'                      => 'No se pudo encontrar este adjunto.',
    'journal_link_bill'                         => 'Esta transacción está vinculada a la suscripción<a href=":route">:name</a>. Para eliminar la conexión, desmarca la casilla de verificación. Usa reglas para conectarla a otra factura.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">La transacción #{ID} ("{title}")</a> ha sido almacenada.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">La transacción #{ID}</a> ha sido guardada.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">La transacción #{ID}</a> ("{title}") ha sido actualizada.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">La transacción #{ID}</a> ("{title}") no recibió ningún cambio.',
    'first_split_decides'                       => 'La primera división determina el valor de este campo',
    'first_split_overrules_source'              => 'La primera división puede anular la cuenta de origen',
    'first_split_overrules_destination'         => 'La primera división puede anular la cuenta de destino',
    'spent_x_of_y'                              => '{amount} gastado de {total}',

    // new user:
    'welcome'                                   => 'Bienvenido a Firefly III!',
    'submit'                                    => 'Enviar',
    'submission'                                => 'Envío',
    'submit_yes_really'                         => 'Enviar (Se lo que estoy haciendo)',
    'getting_started'                           => 'Comenzando',
    'to_get_started'                            => 'Felicidades, has instalado con éxito Firefly III. Para empezar en esta herramienta, por favor escribe el nombre de tu banco y el saldo de su cuenta principal. Si tienes más de una cuenta, podrás agregarla más tarde. Firefly III necesita algo por lo que empezar.',
    'savings_balance_text'                      => 'Firefly III creará automáticamente una cuenta de ahorros. Por defecto, no habrá dinero en su cuenta de ahorros, pero si le dice a Firefly III el saldo se almacenará como tal.',
    'finish_up_new_user'                        => '¡Todo listo! Puedes continuar pulsando <strong>Enviar</strong>. Serás redirigido al inicio de Firefly III.',
    'stored_new_accounts_new_user'              => '¡Bien! Tus nuevas cuentas han sido almacenadas.',
    'set_preferred_language'                    => 'Si prefiere usar Firefly III en otro lenguaje, por favor indíquelo aquí.',
    'language'                                  => 'Idioma',
    'new_savings_account'                       => ':bank_name Cuenta de ahorros',
    'cash_wallet'                               => 'Billetera de efectivo',
    'currency_not_present'                      => 'Si la moneda que normalmente utiliza no se encuentra listada, no se preocupe. Puede crear su propia moneda desde Opciones>Monedas.',

    // home page:
    'transaction_table_description'             => 'Una tabla que contiene sus transacciones',
    'opposing_account'                          => 'Cuenta opuesta',
    'yourAccounts'                              => 'Tus cuentas',
    'your_accounts'                             => 'Resumen de su cuenta',
    'category_overview'                         => 'Resumen de categorías',
    'expense_overview'                          => 'Resumen de la cuenta de gastos',
    'revenue_overview'                          => 'Resumen de la cuenta de ingresos',
    'budgetsAndSpending'                        => 'Presupuestos y gastos',
    'budgets_and_spending'                      => 'Presupuestos y gastos',
    'go_to_budget'                              => 'Ir al presupuesto "{budget}"',
    'go_to_deposits'                            => 'Ir a ingresos',
    'go_to_expenses'                            => 'Ir a gastos',
    'savings'                                   => 'Ahorros',
    'newWithdrawal'                             => 'Nuevo gasto',
    'newDeposit'                                => 'Nuevo ingreso',
    'newTransfer'                               => 'Nueva transferencia',
    'bills_to_pay'                              => 'Suscripciones a pagar',
    'per_day'                                   => 'Por dia',
    'left_to_spend_per_day'                     => 'Disponible para gasto diario',
    'bills_paid'                                => 'Suscripciones pagadas',
    'custom_period'                             => 'Período personalizado',
    'reset_to_current'                          => 'Restablecer al período actual',
    'select_period'                             => 'Seleccione un período',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Moneda',
    'preferences'                               => 'Preferencias',
    'logout'                                    => 'Cerrar sesión',
    'logout_other_sessions'                     => 'Desconectar todas las demás sesiones',
    'toggleNavigation'                          => 'Activar navegación',
    'toggle_dropdown'                           => 'Alternar menú desplegable',
    'searchPlaceholder'                         => 'Buscar...',
    'version'                                   => 'Versión',
    'dashboard'                                 => 'Panel de control',
    'income_and_expense'                        => 'Ingresos y gastos',
    'all_money'                                 => 'Todo tu dinero',
    'unknown_source_plain'                      => 'Cuenta origen desconocida',
    'unknown_dest_plain'                        => 'Dirección de destino desconocida',
    'unknown_any_plain'                         => 'Cuenta desconocida',
    'unknown_budget_plain'                      => 'Sin presupuesto',
    'available_budget'                          => 'Presupuesto disponible ({currency})',
    'currencies'                                => 'Divisas',
    'activity'                                  => 'Actividad',
    'usage'                                     => 'Uso',
    'accounts'                                  => 'Cuentas',
    'Asset account'                             => 'Cuenta de activos',
    'Default account'                           => 'Cuenta de activos',
    'Expense account'                           => 'Cuenta de gastos',
    'Revenue account'                           => 'Cuenta de ganancia',
    'Initial balance account'                   => 'Cuenta de balance inicial',
    'account_type_Asset account'                => 'Cuenta de activos',
    'account_type_Expense account'              => 'Cuenta de gastos',
    'account_type_Revenue account'              => 'Cuenta de ingresos',
    'account_type_Debt'                         => 'Deuda',
    'account_type_Loan'                         => 'Préstamo',
    'account_type_Mortgage'                     => 'Hipoteca',
    'account_type_debt'                         => 'Deuda',
    'account_type_loan'                         => 'Préstamo',
    'account_type_mortgage'                     => 'Hipoteca',
    'account_type_Credit card'                  => 'Tarjeta de crédito',
    'credit_card_type_monthlyFull'              => 'Pago completo cada mes',
    'liability_direction_credit'                => 'Se me debe esta deuda',
    'liability_direction_debit'                 => 'Le debo esta deuda a otra persona',
    'liability_direction_credit_short'          => 'Tenía esta deuda',
    'liability_direction_debit_short'           => 'Tiene esta deuda',
    'liability_direction__short'                => 'Desconocido',
    'liability_direction_null_short'            => 'Desconocido',
    'Liability credit'                          => 'Crédito pasivo',
    'budgets'                                   => 'Presupuestos',
    'tags'                                      => 'Etiquetas',
    'reports'                                   => 'Informes',
    'transactions'                              => 'Transacciones',
    'expenses'                                  => 'Gastos',
    'income'                                    => 'Ingresos / salarios',
    'transfers'                                 => 'Transferencias',
    'moneyManagement'                           => 'Gestión del dinero',
    'money_management'                          => 'Gestión del dinero',
    'tools'                                     => 'Herramientas',
    'piggyBanks'                                => 'Huchas',
    'piggy_banks'                               => 'Huchas',
    'amount_x_of_y'                             => '{current} de {total}',
    'bills'                                     => 'Suscripciones',
    'withdrawal'                                => 'gasto',
    'opening_balance'                           => 'Saldo inicial',
    'deposit'                                   => 'Ingreso',
    'account'                                   => 'Cuenta',
    'transfer'                                  => 'Transferencia',
    'Withdrawal'                                => 'Gasto',
    'Deposit'                                   => 'Ingreso',
    'Transfer'                                  => 'Transferencia',
    'bill'                                      => 'Suscripción',
    'yes'                                       => 'Si',
    'no'                                        => 'No',
    'amount'                                    => 'Cantidad',
    'overview'                                  => 'Resumen',
    'saveOnAccount'                             => 'Guardar en cuenta',
    'saveOnAccounts'                            => 'Guardar en cuenta(s)',
    'unknown'                                   => 'Desconocido',
    'monthly'                                   => 'Mensual',
    'profile'                                   => 'Perfil',
    'errors'                                    => 'Errores',
    'debt_start_date'                           => 'Fecha de inicio de deuda',
    'debt_start_amount'                         => 'Cantidad inicial de la deuda',
    'debt_start_amount_help'                    => 'Siempre es mejor establecer este valor a una cantidad negativa. Lea las páginas de ayuda (arriba a la derecha (icono-?)) para más información.',
    'interest_period_help'                      => 'Este campo es meramente cosmético y no se calculará para usted. Como resulta que los bancos son muy estrepitosos, por lo que Firefly III nunca lo hace bien.',
    'store_new_liabilities_account'             => 'Crear nuevo pasivo',
    'edit_liabilities_account'                  => 'Editar pasivo ":name"',
    'financial_control'                         => 'Control financiero',
    'accounting'                                => 'Contabilidad',
    'automation'                                => 'Automatización',
    'others'                                    => 'Otros',
    'classification'                            => 'Clasificación',
    'store_transaction'                         => 'Guardar transacción',


    // reports:
    'quick_link_needs_accounts'                 => 'Para poder generar informes, es necesario añadir al menos una cuenta de activos a Firefly III.',
    'report_default'                            => 'Reporte financiero por defecto entre :start y :end',
    'report_audit'                              => 'Transacción general del historial entre :start y :end',
    'report_category'                           => 'Reporte de categoría entre :start y :end',
    'report_double'                             => 'Informe de cuenta de gastos/ingresos entre :start y :end',
    'report_budget'                             => 'Reporte de presupuesto entre :start y :end',
    'report_tag'                                => 'Reporte de etiqueta entre :start y :end',
    'quick_link_reports'                        => 'Enlaces rápidos',
    'quick_link_examples'                       => 'Estos son sólo algunos enlaces de ejemplo para empezar. Echa un vistazo a las páginas de ayuda bajo el botón (?)-para obtener información sobre todos los informes y las palabras mágicas que puedes usar.',
    'quick_link_default_report'                 => 'Reporte financiero por defecto',
    'quick_link_audit_report'                   => 'Resumen del historial de transacciones',
    'report_this_month_quick'                   => 'Mes en curso, todas las cuentas',
    'report_last_month_quick'                   => 'Último mes, todas las cuentas',
    'report_this_year_quick'                    => 'Año en curso, todas las cuentas',
    'report_this_fiscal_year_quick'             => 'Año fiscal en curso, todas las cuentas',
    'report_all_time_quick'                     => 'Todo el tiempo, todas las cuentas',
    'reports_can_bookmark'                      => 'Recuerda que los informes pueden ser marcados como favoritos.',
    'incomeVsExpenses'                          => 'Ingresos vs. gastos',
    'accountBalances'                           => 'Balances de cuentas',
    'balanceStart'                              => 'Balance al inicio de un periodo',
    'balanceEnd'                                => 'Balance al final de un periodo',
    'splitByAccount'                            => 'Separada por cuenta',
    'coveredWithTags'                           => 'Cubierta con etiquetas',
    'leftInBudget'                              => 'Disponible en presupuesto',
    'left_in_debt'                              => 'Importe debido',
    'sumOfSums'                                 => 'Suma de sumas',
    'noCategory'                                => '(sin categoría)',
    'notCharged'                                => 'No cargado (todavía)',
    'inactive'                                  => 'Inactivo',
    'active'                                    => 'Activo',
    'difference'                                => 'Diferente',
    'money_flowing_in'                          => 'Entrada',
    'money_flowing_out'                         => 'Salida',
    'topX'                                      => 'tope :number',
    'show_full_list'                            => 'Mostrar lista entera',
    'show_only_top'                             => 'Mostrar solo tope :number',
    'report_type'                               => 'Tipo de reporte',
    'report_type_default'                       => 'Informe financiero predeterminado',
    'report_type_audit'                         => 'Resumen del historial de transacciones (auditar)',
    'report_type_category'                      => 'Reporte de categoría',
    'report_type_budget'                        => 'Reporte de presupuesto',
    'report_type_tag'                           => 'Reporte de etiqueta',
    'report_type_double'                        => 'Informe de cuenta de gastos/ingresos',
    'more_info_help'                            => 'Puedes encontrar más información sobre estos tipos de informes en las páginas de ayuda. Pulsa el icono (?) En la esquina superior derecha.',
    'report_included_accounts'                  => 'Cuentas incluidas',
    'report_date_range'                         => 'Rango de fechas',
    'report_preset_ranges'                      => 'Rangos preestablecidos',
    'shared'                                    => 'Compartido',
    'fiscal_year'                               => 'Año fiscal',
    'income_entry'                              => 'Ingresos de la cuenta ":name" entre :start y :end',
    'expense_entry'                             => 'Gastos a cuenta ":name" entre :start y :end',
    'category_entry'                            => 'Gastos e ingresos en la categoría ":name" entre :start y :end',
    'budget_spent_amount'                       => 'Gastos en presupuesto ":budget" entre :start y :end',
    'balance_amount'                            => 'Gastos en presupuesto ":budget" pago desde la cuenta ":account" entre :start y :end',
    'no_audit_activity'                         => 'Ninguna actividad fue registrada en la cuenta <a href=":url" title=":account_name">:account_name</a> entre :start y :end.',
    'audit_end_balance'                         => 'Saldo de cuenta de <a href=":url" title=":account_name">:account_name</a> en el final de :end fue :balance',
    'reports_extra_options'                     => 'Opciones adicionales',
    'report_has_no_extra_options'               => 'Este informe no tiene opciones adicionales',
    'reports_submit'                            => 'Ver informe',
    'end_after_start_date'                      => 'Fecha final de reporte debe ser después de la fecha de inicio.',
    'select_category'                           => 'Seleccionar categoría (as)',
    'select_budget'                             => 'Seleccionar presupuesto (s).',
    'select_tag'                                => 'Seleccionar etiqueta (s).',
    'income_per_category'                       => 'Ingresos por categoría',
    'expense_per_category'                      => 'Gastos por categoría',
    'expense_per_budget'                        => 'Gastos por presupuestos',
    'income_per_account'                        => 'Ingresos por cuenta',
    'expense_per_account'                       => 'Gastos por cuenta',
    'expense_per_tag'                           => 'Gastos por etiqueta',
    'income_per_tag'                            => 'Ingreso por etiqueta',
    'include_expense_not_in_budget'             => 'Gastos incluidos que no están en el presupuesto (s) seleccionado',
    'include_expense_not_in_account'            => 'Gastos incluidos que no están en la cuenta (s) seleccionada',
    'include_expense_not_in_category'           => 'Gastos incluidos que no están en la categoría (s) seleccionada',
    'include_income_not_in_category'            => 'Ingresos incluidos que no están en la categoría(s) seleccionada',
    'include_income_not_in_account'             => 'Ingresos incluidos que no están en la cuenta (s) seleccionada',
    'include_income_not_in_tags'                => 'Ingresos incluidos no en la etiqueta (s) seleccionadas',
    'include_expense_not_in_tags'               => 'Gastos incluidos no seleccionados con etiqueta',
    'everything_else'                           => 'Todo lo demas',
    'income_and_expenses'                       => 'Ingresos y gastos',
    'spent_average'                             => 'Gastado (promedio)',
    'income_average'                            => 'Ingresos (promedio)',
    'transaction_count'                         => 'Cuenta de transacciones',
    'average_spending_per_account'              => 'Promedio de gasto por cuenta',
    'average_income_per_account'                => 'Promedio de ingreso por cuenta',
    'total'                                     => 'Total',
    'description'                               => 'Descripción',
    'sum_of_period'                             => 'Suma de período',
    'average_in_period'                         => 'Promedio en el período',
    'no_account_role'                           => '(sin rol)',
    'account_role_defaultAsset'                 => 'Cuentas de ingresos por defecto',
    'account_role_sharedAsset'                  => 'Cuenta de ingresos compartida',
    'account_role_savingAsset'                  => 'Cuentas de ahorros',
    'account_role_ccAsset'                      => 'Tarjeta de Crédito',
    'account_role_cashWalletAsset'              => 'Billetera de efectivo',
    'budget_chart_click'                        => 'Por favor de click el nombre del presupuesto en la tabla de arriba para ver el cuadro.',
    'category_chart_click'                      => 'Por favor de click en el nombre de categoría en la tabla de arriba para ver el cuadro.',
    'in_out_accounts'                           => 'Ganado y gastado por combinación',
    'in_out_accounts_per_asset'                 => 'Ganado y gastado (por cuenta de activos)',
    'in_out_per_category'                       => 'Ganado y gastado por categoría',
    'out_per_budget'                            => 'Gasto por presupuesto',
    'select_expense_revenue'                    => 'Seleccione cuenta de gastos/ingresos',
    'multi_currency_report_sum'                 => 'Como esta lista contiene cuentas con múltiples monedas, la(s) suma(s) que veas puede no tener sentido. El reporte siempre figurará en tu moneda predeterminada.',
    'sum_in_default_currency'                   => 'La suma siempre estará en tu moneda predeterminada.',
    'net_filtered_prefs'                        => 'Este gráfico nunca incluirá cuentas que tengan la opción "Incluir en el valor neto" no marcada.',


    // charts:
    'chart'                                     => 'Grafico',
    'month'                                     => 'Mes',
    'budget'                                    => 'Presupuesto',
    'spent'                                     => 'Gastado',
    'spent_capped'                              => 'Gastado (tope)',
    'spent_in_budget'                           => 'Gastado en presupuesto',
    'left_to_spend'                             => 'Disponible para gastar',
    'earned'                                    => 'Ganado',
    'overspent'                                 => 'Sobrepasadas',
    'left'                                      => 'Disponible',
    'max-amount'                                => 'Cantidad máxima',
    'min-amount'                                => 'Monto mínimo',
    'journal-amount'                            => 'Entrada de suscripción actual',
    'name'                                      => 'Nombre',
    'expires_at'                                => 'Expira el',
    'date'                                      => 'Fecha',
    'date_and_time'                             => 'Fecha y hora',
    'time'                                      => 'Hora',
    'paid'                                      => 'Pagado',
    'unpaid'                                    => 'No pagado',
    'day'                                       => 'Día',
    'budgeted'                                  => 'Presupuestado',
    'period'                                    => 'Período',
    'balance'                                   => 'Balance',
    'in_out_period'                             => 'Entrada y salida este periodo',
    'sum'                                       => 'Suma',
    'summary'                                   => 'Resumen',
    'average'                                   => 'Promedio',
    'balanceFor'                                => 'Saldo por :name',
    'no_tags'                                   => '(sin etiquetas)',
    'nothing_found'                             => '(no se encontró nada)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Configuración de página',
    'visible_columns'               => 'Columnas visibles',
    'accounts_to_show'              => 'Cuentas a mostrar',
    'active_accounts_only'          => 'Sólo cuentas activas',
    'in_active_accounts_only'       => 'Sólo cuentas activas',
    'show_all_accounts'             => 'Mostrar todas las cuentas',
    'group_accounts'                => 'Grupo de cuentas',

    // piggy banks:
    'event_history'                 => 'Historial de eventos',
    'add_money_to_piggy'            => 'Añadir dinero a la hucha ":name"',
    'piggy_bank'                    => 'Hucha',
    'new_piggy_bank'                => 'Nueva hucha',
    'store_piggy_bank'              => 'Crear hucha',
    'stored_piggy_bank'             => 'Crear hucha ":name"',
    'account_status'                => 'Estado de cuenta',
    'left_for_piggy_banks'          => 'Apartado para las huchas',
    'sum_of_piggy_banks'            => 'Total de las huchas',
    'saved_so_far'                  => 'Guardado hasta el momento',
    'saved_so_far_total'            => 'Guardado hasta ahora en total',
    'reset_history'                 => 'Restablecer el historial',
    'reset_history_confirm'         => '¿Está seguro que desea restablecer el historial de este banco hucha? Esto hará que el gráfico coincida con la cantidad del banco hucha de nuevo.',
    'piggy_history_reset'           => 'El historial de la hucha se ha restablecido',
    'left_to_save'                  => 'Disponible para ahorro',
    'suggested_amount'              => 'Cantidad mensual sugerida para ahorrar',
    'add_money_to_piggy_title'      => 'Añadir dinero a la hucha ":name"',
    'remove_money_from_piggy_title' => 'Quitar dinero de la hucha ":name"',
    'add'                           => 'Añadir',
    'no_money_for_piggy'            => 'Usted no tiene dinero para añadir a esta hucha.',
    'suggested_savings_per_month'   => 'Sugerido por mes',

    'remove'                    => 'Eliminar',
    'max_amount_add'            => 'La cantidad máxima que usted puede agregar es',
    'max_amount_remove'         => 'La cantidad máxima que usted puede retirar es',
    'update_piggy_button'       => 'Actualizar hucha',
    'update_piggy_title'        => 'Actualizar hucha ":name"',
    'updated_piggy_bank'        => 'Hucha ":name" actualizada',
    'details'                   => 'Detalles',
    'events'                    => 'Eventos',
    'target_amount'             => 'Cantidad objetivo',
    'start_date'                => 'Fecha de inicio',
    'no_start_date'             => 'Sin fecha de inicio',
    'target_date'               => 'Fecha objetivo',
    'no_target_date'            => 'Sin fecha de objetivo',
    'table'                     => 'Mesa',
    'delete_piggy_bank'         => 'Eliminar hucha ":name"',
    'cannot_add_amount_piggy'   => 'No se pudo agregar :amount a ":name.".',
    'cannot_remove_from_piggy'  => 'No se pudo eliminar :amount de :name.',
    'deleted_piggy_bank'        => 'Hucha ":name" eliminada',
    'added_amount_to_piggy'     => 'Agregado :amount a ":name"',
    'removed_amount_from_piggy' => 'Eliminado :amount de :name',
    'piggy_events'              => 'Huchas relacionadas',

    // tags
    'delete_tag'                => 'Eliminar etiqueta ":tag"',
    'deleted_tag'               => 'Eliminar etiqueta ":tag"',
    'new_tag'                   => 'Hacer nueva etiqueta',
    'edit_tag'                  => 'Editar etiqueta ":tag"',
    'updated_tag'               => 'Actualizar etiqueta ":tag"',
    'created_tag'               => 'Etiqueta ":tag" ha sido creado!',

    'transaction_journal_information'               => 'Información de transacción',
    'transaction_journal_amount'                    => 'Información de cantidad',
    'transaction_journal_meta'                      => 'Metainformación',
    'transaction_journal_more'                      => 'Más información',
    'basic_journal_information'                     => 'Información básica de transacción',
    'transaction_journal_extra'                     => 'Información adicional',
    'att_part_of_journal'                           => 'Guardado en ":journal"',
    'total_amount'                                  => 'Cantidad total',
    'number_of_decimals'                            => 'Número de decimales',


    // administration
    'invite_is_already_redeemed'                    => 'La invitación a ":address" ya ha sido canjeada.',
    'invite_is_deleted'                             => 'La invitación a ":address" ha sido eliminada.',
    'invite_new_user_title'                         => 'Invitar a un nuevo usuario',
    'invite_new_user_text'                          => 'Como administrador, puede invitar a los usuarios a registrarse en su instalación de Firefly III. Usando el enlace directo que puedes compartir con ellos, podrán registrar una cuenta. El usuario invitado y su enlace de invitación aparecerán en la tabla de abajo. Es libre de compartir el enlace de invitación con ellos.',
    'invited_user_mail'                             => 'Dirección de correo electrónico',
    'invite_user'                                   => 'Invitar a un usuario',
    'user_is_invited'                               => 'La dirección de correo electrónico ":address" ha sido invitada a Firefly III',
    'administration'                                => 'Administración',
    'system_settings'                               => 'Ajustes del sistema',
    'code_already_used'                             => 'Se ha utilizado el código de invitación',
    'user_administration'                           => 'Administración de usuarios',
    'list_all_users'                                => 'Todos los usuarios',
    'all_users'                                     => 'Todo usuario',
    'instance_configuration'                        => 'Configuracion',
    'firefly_instance_configuration'                => 'Configuración de Firefly III',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'Modo de usuario único',
    'setting_single_user_mode_explain'              => 'Por defecto, Firefly III solo acepta un único usuario: tú. Esto es una medida de seguridad para impedir que otros utilicen su instancia a menos que lo permitas. Si desmarcas esta casilla, otros podrán registrarse en esta instancia si tienen acceso a ella.',
    'store_configuration'                           => 'Guardar configuración',
    'single_user_administration'                    => 'Administración de usuarios para :email',
    'edit_user'                                     => 'Editar usuario :email',
    'hidden_fields_preferences'                     => 'Puede habilitar más opciones de transacción en sus <a href="preferences">ajustes </a>.',
    'user_data_information'                         => 'Datos del usuario',
    'user_information'                              => 'Información del usuario',
    'total_size'                                    => 'tamaño total',
    'budget_or_budgets'                             => ':count presupuesto|:count presupuestos',
    'budgets_with_limits'                           => ':count presupuesto con cantidad configurada|:count presupuestos con cantidad configurada',
    'nr_of_rules_in_total_groups'                   => ':count_rules reglas en :count_groups grupo de reglas',
    'tag_or_tags'                                   => ':count etiqueta|:count etiquetas',
    'configuration_updated'                         => 'La configuración ha sido actualizada',
    'setting_is_demo_site'                          => 'Sitio de demostracion',
    'setting_is_demo_site_explain'                  => 'Si usted chequea esta casilla, esta instalación se comportara como si fuera el sitio de demostración, que puede tener efectos secundarios extraños.',
    'block_code_bounced'                            => 'Mensaje (s) de correo rebotados',
    'block_code_expired'                            => 'Cuenta de demostración vencida',
    'no_block_code'                                 => 'No hay razón para el bloqueo o usuario bloqueado',
    'demo_user_export'                              => 'El usuario demo no puede exportar datos',
    'block_code_email_changed'                      => 'El usuario no ha confirmado aun una nueva dirección de correo',
    'admin_update_email'                            => 'Contrario a la pagina de perfil, El usuario NO se notificara que su dirección de correo ha cambiado!',
    'update_user'                                   => 'Actualizar usuario',
    'updated_user'                                  => 'Los datos del usuario han sido cambiados.',
    'delete_user'                                   => 'Eliminar usuario :email',
    'user_deleted'                                  => 'El usuario ha sido eliminado',
    'send_test_email'                               => 'Enviar mensaje de correo electrónico de prueba',
    'send_test_email_text'                          => 'Para ver si su instalación es capaz de enviar una notificación, pulse este botón. No verás un error aquí (si lo hay), <strong>los archivos de registro reflejarán los errores</strong>. Puedes pulsar este botón tantas veces como quieras. No hay control de spam. El mensaje se enviará a la <code>:email</code> y llegará pronto.',
    'send_message'                                  => 'Enviar mensaje',
    'send_test_triggered'                           => 'La prueba fue disparada. Chequee su bandeja de entrada y archivos de registro.',
    'give_admin_careful'                            => 'Los usuarios a los que se les conceden derechos de administrador pueden quitarte el tuyo. Ten cuidado.',
    'admin_maintanance_title'                       => 'Mantenimiento',
    'admin_maintanance_expl'                        => 'Algunos botones útiles para mantenimiento de Firefly III',
    'admin_maintenance_clear_cache'                 => 'Limpiar cache',
    'owner_notifications'                           => 'Notificaciones del administrador',
    'owner_notifications_expl'                      => 'El administrador puede activar o desactivar las siguientes notificaciones. Se enviará a través de TODOS los canales configurados. Algunos canales están configurados en sus variables de entorno, otros pueden configurarse aquí.',
    'channel_settings'                              => 'Configuración de canales de notificación',
    'notification_test_failed'                      => 'Prueba de notificación del canal ":channel" falló. Los registros tendrán más detalles.',
    'notification_test_executed'                    => 'Prueba de notificación para el canal ":channel" ejecutada. Revisa tus registros para más detalles.',
    'settings_notifications'                        => 'Configuración de notificaciones',
    'title_owner_notifications'                     => 'Notificaciones del propietario',
    'owner_notification_check_user_new_reg'         => 'El usuario recibe un mensaje de bienvenida tras el registro',
    'owner_notification_check_admin_new_reg'        => 'Administrador(es) reciben una notificación de registro de un nuevo usuario',
    'owner_notification_check_new_version'          => 'Una nueva versión está disponible',
    'owner_notification_check_invite_created'       => 'Un usuario ha sido invitado a Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Una invitación de usuario ha sido canjeada',
    'owner_notification_check_unknown_user_attempt' => 'Un usuario desconocido intentó iniciar sesión',
    'all_invited_users'                             => 'Todos los usuarios invitados',
    'save_notification_settings'                    => 'Guardar ajustes',
    'notification_settings'                         => 'Configuración de notificaciones',
    'notification_settings_saved'                   => 'Se han guardado los ajustes de notificación',
    'available_channels_title'                      => 'Canales disponibles',
    'available_channels_expl'                       => 'Estos canales están disponibles para enviar notificaciones. Para probar su configuración, utilice los botones de abajo. Tenga en cuenta que los botones no tienen control de spam.',
    'notification_channel_name_email'               => 'Correo electrónico',
    'slack_discord_double'                          => 'El canal de notificación de Slack también puede enviar notificaciones a Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'no disponible',
    'configure_channel_in_env'                      => 'necesita variables de entorno',
    'test_notification_channel_name_email'          => 'Correo electrónico de prueba',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Probar Pushover',
    'test_notification_channel_name_gotify'         => 'Probar Gotify',
    'test_notification_channel_name_pushbullet'     => 'Probar Pushbullet',

    'split_transaction_title'               => 'Descripción de la transacción dividida',
    'split_transaction_title_help'          => 'Si crea una transacción dividida, debe existir una descripción global para todas las divisiones de la transacción.',
    'split_title_help'                      => 'Si crea una transacción dividida, debe haber una descripción global para todos los fragmentos de la transacción.',
    'you_create_transfer'                   => 'Está creando una transferencia.',
    'you_create_withdrawal'                 => 'Está creando un gasto.',
    'you_create_deposit'                    => 'Está creando un ingreso.',

    // links
    'journal_link_configuration'            => 'Configuración de enlaces de transacción',
    'create_new_link_type'                  => 'Crear un nuevo tipo de enlace',
    'store_new_link_type'                   => 'Crear tipo de enlace',
    'update_link_type'                      => 'Actualizar tipo de enlace',
    'edit_link_type'                        => 'Editar tipo de enlace ":name"',
    'updated_link_type'                     => 'Actualizar tipo de enlace ":name"',
    'delete_link_type'                      => 'Eliminar tipo de enlace ":name"',
    'deleted_link_type'                     => 'Eliminar tipo de enlace ":name"',
    'stored_new_link_type'                  => 'Guardar nuevo tipo de enlace ":name"',
    'cannot_edit_link_type'                 => 'No puede editar el tipo de enlace ":name"',
    'link_type_help_name'                   => 'Ie "Duplicados"',
    'link_type_help_inward'                 => 'Ie."duplicados"',
    'link_type_help_outward'                => 'Ie."esta duplicado por"',
    'save_connections_by_moving'            => 'Guarde el enlace entre estas transacciones moviéndolas a otro tipo de enlace:',
    'do_not_save_connection'                => '(no guarde la conexión)',
    'link_transaction'                      => 'Enlazar transacción',
    'link_to_other_transaction'             => 'Enlazar esta transacción con otra',
    'select_transaction_to_link'            => 'Seleccione una transacción a la que vincular esta transacción. Los enlaces no se utilizan actualmente en Firefly III (aparte de mostrarse), pero tengo previsto cambiar esto en el futuro. Utilice el cuadro de búsqueda para seleccionar una transacción por título o por ID. Si desea añadir tipos de enlace personalizados, revise la configuración.',
    'this_transaction'                      => 'Esta transacción',
    'transaction'                           => 'Transaccion',
    'comments'                              => 'Comentarios',
    'link_notes'                            => 'Cualquier nota que desee almacenar con el enlace.',
    'invalid_link_selection'                => 'No se puede vincular esta transacción',
    'selected_transaction'                  => 'Transacción seleccionada',
    'journals_linked'                       => 'Las transacciones están vinculadas.',
    'journals_error_linked'                 => 'Estas transacciones ya están vinculadas.',
    'journals_link_to_self'                 => 'No puede relacionar una transacción consigo misma',
    'journal_links'                         => 'Enlaces de transacciones',
    'this_withdrawal'                       => 'Este gasto',
    'this_deposit'                          => 'Este ingreso',
    'this_transfer'                         => 'Esta transferencia',
    'overview_for_link'                     => 'Visión en conjunto para el tipo de enlace ":name"',
    'source_transaction'                    => 'Transacción fuente',
    'link_description'                      => 'Descripción de enlace',
    'destination_transaction'               => 'Transacción de destino',
    'delete_journal_link'                   => 'Elimine el link entre <a href=":source_link"><a href=":source_link"><a href=":source_link">:source</a> y <a href=":destination_link"><a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Enlace borrado',

    // link translations:
    'Paid_name'                             => 'Pagado',
    'Refund_name'                           => 'Reembolso',
    'Reimbursement_name'                    => 'Reembolso',
    'Related_name'                          => 'Relacionado',
    'relates to_inward'                     => 'relacionado con',
    'is (partially) refunded by_inward'     => 'es (parcialmente) devuelto por',
    'is (partially) paid for by_inward'     => 'es(parcialmente) pagado por',
    'is (partially) reimbursed by_inward'   => 'es(parcialmente) reembolsado por',
    'inward_transaction'                    => 'Transacción interna',
    'outward_transaction'                   => 'Transacción externa',
    'relates to_outward'                    => 'relacionado con',
    '(partially) refunds_outward'           => '(parcialmente) reembolso',
    '(partially) pays for_outward'          => '(parcialmente) paga por',
    '(partially) reimburses_outward'        => '(parcialmente) reembolsa',
    'is (partially) refunded by'            => 'es (parcialmente) devuelto por',
    'is (partially) paid for by'            => 'es(parcialmente) pagado por',
    'is (partially) reimbursed by'          => 'es(parcialmente) reembolsado por',
    'relates to'                            => 'relacionado con',
    '(partially) refunds'                   => '(parcialmente) reembolsado',
    '(partially) pays for'                  => 'paga (parcialmente) por',
    '(partially) reimburses'                => 'reembolsa (parcialmente)',

    // split a transaction:
    'splits'                                => 'Divisiones',
    'add_another_split'                     => 'Añadir otra división',
    'cannot_edit_opening_balance'           => 'Usted no puede editar el balance de apertura de una cuenta.',
    'no_edit_multiple_left'                 => 'Usted no ha seleccionado transacciones válidas para editar.',
    'breadcrumb_convert_group'              => 'Convertir transacción',
    'convert_invalid_source'                => 'La información de origen no es válida para la transacción #%d.',
    'convert_invalid_destination'           => 'La información de destino no es válida para la transacción #%d.',
    'create_another'                        => 'Después de guardar, vuelve aquí para crear otro.',
    'after_update_create_another'           => 'Después de actualizar, vuelve aquí para continuar editando.',
    'store_as_new'                          => 'Almacenar como una nueva transacción en lugar de actualizar.',
    'reset_after'                           => 'Restablecer formulario después del envío',
    'errors_submission'                     => 'Hubo un problema con su envío. Por favor, compruebe los siguientes errores.',
    'errors_submission_v2'                  => 'Hubo un problema con su envío. Por favor, compruebe los siguientes errores: {{errorMessage}}',
    'transaction_expand_split'              => 'Expandir división',
    'transaction_remove_split'              => 'Eliminar división',
    'transaction_collapse_split'            => 'Colapsar división',

    // object groups
    'default_group_title_name'              => '(sin agrupación)',
    'default_group_title_name_plain'        => 'sin agrupar',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => '¡Vamos a crear una cuenta de activos!',
    'no_accounts_intro_asset'               => 'Usted aun no tiene cuenta de activos. las cuentas de activos son sus cuentas principales: sus cuentas de cheques, cuenta de ahorros, cuenta compartida o incluso su tarjeta de crédito.',
    'no_accounts_imperative_asset'          => 'Para comenzar a utilizar Firefly III Usted debe crear al menos una cuenta de activo. Vamos a hacerlo ahora:',
    'no_accounts_create_asset'              => 'Crear una cuenta de activos',
    'no_accounts_title_expense'             => '¡Vamos a crear una cuenta de gastos!',
    'no_accounts_intro_expense'             => 'Usted aun no tiene cuentas de gastos. Las cuentas de gastos son los lugares donde se gasta dinero, tales como tiendas y supermercados.',
    'no_accounts_imperative_expense'        => 'Las cuentas de gastos se crean automáticamente cuando crea transacciones, pero usted puede crear una manualmente también. si usted quiere. vamos a crear una ahora:',
    'no_accounts_create_expense'            => 'Crear una cuenta de gastos',
    'no_accounts_title_revenue'             => '¡Vamos a crear una cuenta de ingresos!',
    'no_accounts_intro_revenue'             => 'Usted no tiene cuentas de ingresos aun. Cuentas de ingresos son los lugares donde usted recibe dinero, como su empleador.',
    'no_accounts_imperative_revenue'        => 'Las cuentas de ganancias se crean automáticamente cuando usted crea transacciones, pero usted puede crear una manualmente también, si usted quiere. vamos a crear una ahora:',
    'no_accounts_create_revenue'            => 'Crear una cuenta de ingresos',
    'no_accounts_title_liabilities'         => '¡Vamos a crear un pasivo!',
    'no_accounts_intro_liabilities'         => 'Todavía no tienes pasivos. Los pasivos son las cuentas que registran sus préstamos y otras deudas.',
    'no_accounts_imperative_liabilities'    => 'No necesita usar esta función pero, puede ser muy útil si desea hacer un seguimiento de estas cosas.',
    'no_accounts_create_liabilities'        => 'Crear un pasivo',
    'no_budgets_title_default'              => 'Vamos a crear un presupuesto',
    'no_rules_title_default'                => 'Vamos a crear una regla',
    'no_budgets_intro_default'              => 'Todavía no tienes presupuestos. Los presupuestos se usan para organizar tus gastos en grupos, a los que puedes asignar un tope para limitarlos.',
    'no_rules_intro_default'                => 'Aún no tiene reglas. Las reglas son potentes automatizaciones que pueden manejar transacciones por usted.',
    'no_rules_imperative_default'           => 'Las reglas pueden ser muy útiles cuando está gestionando transacciones. Vamos a crear una ahora:',
    'no_budgets_imperative_default'         => 'Los presupuestos son las herramientas básicas de la gestión financiera. Vamos a crear uno ahora:',
    'no_budgets_create_default'             => 'Crear un presupuesto',
    'no_rules_create_default'               => 'Crear regla',
    'no_categories_title_default'           => '¡Vamos a crear una categoría!',
    'no_categories_intro_default'           => 'Todavía no tienes categorías. Las categorías se utilizan para ajustar sus transacciones y etiquetarlas con su categoría designada.',
    'no_categories_imperative_default'      => 'Las categorías se crean automáticamente al crear transacciones, pero también puedes crearlas manualmente. Vamos a crear una:',
    'no_categories_create_default'          => 'Crear una categoría',
    'no_tags_title_default'                 => '¡Vamos a crear una etiqueta!',
    'no_tags_intro_default'                 => 'Todavía no tienes etiquetas. Las etiquetas se utilizan para ajustar tus transacciones y etiquetarlas con palabras clave específicas.',
    'no_tags_imperative_default'            => 'Las etiquetas se crean automáticamente al crear transacciones, pero también puedes crearlas manualmente. Vamos a crear una:',
    'no_tags_create_default'                => 'Crear etiqueta',
    'no_transactions_title_withdrawal'      => '¡Vamos a crear un gasto!',
    'no_transactions_intro_withdrawal'      => 'Usted no tiene gastos todavía. Usted debe crear gastos paran comenzar a administrar sus finanzas.',
    'no_transactions_imperative_withdrawal' => '¿Has gastado algo de dinero? Entonces usted debería escribirlo:',
    'no_transactions_create_withdrawal'     => 'Crear un gasto',
    'no_transactions_title_deposit'         => '¡Vamos a crear algún ingreso!',
    'no_transactions_intro_deposit'         => 'Usted no tiene gastos grabados todavía. Usted debe crear entradas de ingresos para comenzar a gerenciar sus finanzas.',
    'no_transactions_imperative_deposit'    => '¿ A recibido usted algún dinero? Entonces usted debería escribirlo:',
    'no_transactions_create_deposit'        => 'Cree un ingreso',
    'no_transactions_title_transfers'       => '¡Vamos a crear una tranferencia!',
    'no_transactions_intro_transfers'       => 'Usted no tiene transferencias aun. Cuando usted mueve dinero entre cuentas de activos, se registra como una transferencia.',
    'no_transactions_imperative_transfers'  => '¿Has movido algo de dinero? Entonces usted debería escribirlo:',
    'no_transactions_create_transfers'      => 'Crear una transferencia',
    'no_piggies_title_default'              => '¡Vamos a crear una hucha!',
    'no_piggies_intro_default'              => 'Aún no tienes huchas. Puedes crear huchas para dividir tus ahorros y hacer un seguimiento de lo que estés ahorrando.',
    'no_piggies_imperative_default'         => '¿Tiene cosas para las cuales está ahorrando dinero? Cree una hucha y haga su seguimiento:',
    'no_piggies_create_default'             => 'Crear una nueva hucha',
    'no_bills_title_default'                => '¡Vamos a crear una suscripción!',
    'no_bills_intro_default'                => 'Usted no tiene suscripciones aún. Usted puede crear suscripciones para hacer un seguimiento de los gastos regulares, como su alquiler o el seguro.',
    'no_bills_imperative_default'           => '¿Tienes suscripciones periódicas? Crea una suscripción y haz un seguimiento de tus pagos:',
    'no_bills_create_default'               => 'Crear una suscripción',

    // recurring transactions
    'recurrence_max_count'                  => 'Estas transacciones recurrentes se crearán como máximo :max vece(s) y ya se han creado :count vece(s).',
    'create_right_now'                      => 'Crear ahora mismo',
    'no_new_transaction_in_recurrence'      => 'No se ha creado ninguna nueva transacción. ¿Tal vez ya ha sido lanzada para esta fecha?',
    'recurrences'                           => 'Transacciones Recurrentes',
    'repeat_until_in_past'                  => 'Esta transacción recurrente dejó de repetirse el :date.',
    'recurring_calendar_view'               => 'Calendario',
    'no_recurring_title_default'            => 'Vamos a crear una transacción recurrente!',
    'no_recurring_intro_default'            => 'Usted no tiene transacciones recurrentes aún. Puede usar esto para hacer que Firefly III cree transacciones por usted.',
    'no_recurring_imperative_default'       => 'Esta es una característica bastante avanzada pero, puede ser extremadamente útil. Asegúrese de haber leído la documentación (?- Icono en la esquina derecha) antes de continuar.',
    'no_recurring_create_default'           => 'Crear una transacción recurrente',
    'make_new_recurring'                    => 'Crear una transacción recurrente',
    'recurring_daily'                       => 'Diario',
    'recurring_weekly'                      => 'Cada semana los :weekday',
    'recurring_weekly_skip'                 => 'Cada :skip(er/a) semana en :weekday',
    'recurring_monthly'                     => 'Todos los meses, el :dayOfMonthº día',
    'recurring_monthly_skip'                => 'Cada :skip(er/o) mes en el :dayOfMonth(er/o) día',
    'recurring_ndom'                        => 'Todos los meses, el :dayOfMonthº :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Cada año en :date',
    'overview_for_recurrence'               => 'Resumen de transacción recurrente ":title"',
    'warning_duplicates_repetitions'        => 'En algunas ocasiones, las fechas aparecen duplicadas en esta lista. Esto puede ocurrir porque múltiples repeticiones chocan. Firefly III siempre generará una transacción por día.',
    'created_transactions'                  => 'Transacciones relacionadas',
    'expected_withdrawals'                  => 'Gastos previstos',
    'expected_deposits'                     => 'Ingresos previstos',
    'expected_transfers'                    => 'Transferencias previstas',
    'created_withdrawals'                   => 'Gastos creados',
    'created_deposits'                      => 'Ingresos creados',
    'created_transfers'                     => 'Transferencias creadas',
    'recurring_info'                        => 'Transacción recurrente :count / :total',
    'created_from_recurrence'               => 'Creado a partir de transacción recurrente ":title" (#:id)',
    'recurring_never_cron'                  => 'Al parecer, el cron job necesario para realizar las transacciones recurrentes nunca se ejecutó. Esto es normal por supuesto, cuando acabas de instalar Firefly III pero, es algo que deberías configurar lo antes posible. Por favor, revisa las páginas de ayuda usando el ícono-(?) en la esquina derecha de la página.',
    'recurring_cron_long_ago'               => 'Aparentemente han pasado mas de 36 horas desde que el cron job para dar soporte a las transacciones recurrentes se ha disparado por última vez. Está usted seguro que lo ha configurado correctamente? Por favor, revise las páginas de ayuda usando el ícono-(?) en la esquina derecha de la página.',

    'create_new_recurrence'              => 'Crear transacción recurrente',
    'help_first_date'                    => 'Indique la primera recurrencia esperada. Esto debe ser en un tiempo futuro.',
    'help_first_date_no_past'            => 'Indique la primera recurrencia esperada. Firefly III no creará transacciones en el pasado.',
    'no_currency'                        => '(sin moneda)',
    'mandatory_for_recurring'            => 'Información de recurrencia obligatorio',
    'mandatory_for_transaction'          => 'Información obligatoria de transacción',
    'optional_for_recurring'             => 'Información de recurrencia opcional',
    'optional_for_transaction'           => 'Información de transacción opcional',
    'change_date_other_options'          => 'Cambie la "primera fecha" para ver más opciones.',
    'mandatory_fields_for_tranaction'    => 'Los valores de aquí van a terminar en las transaccion(es) que se están creando',
    'click_for_calendar'                 => 'Haga clic aquí para ver un calendario que le muestra cuando se repetirá la transacción.',
    'repeat_forever'                     => 'Repetir por siempre',
    'repeat_until_date'                  => 'Repetir hasta',
    'repeat_times'                       => 'Repetir un número de veces',
    'recurring_skips_one'                => 'Intercalado',
    'recurring_skips_more'               => 'Saltea :count ocurrencias',
    'store_new_recurrence'               => 'Crear transacción recurrente',
    'stored_new_recurrence'              => 'Transacción recurrente ":title" almacenada con éxito.',
    'edit_recurrence'                    => 'Editar transacción recurrente ":title"',
    'recurring_repeats_until'            => 'Repetir hasta :date',
    'recurring_repeats_forever'          => 'Repetir por siempre',
    'recurring_repeats_x_times'          => 'Repetir :count vez|Repetir :count veces',
    'update_recurrence'                  => 'Actualizar transacción recurrente',
    'updated_recurrence'                 => 'Transacción recurrente ":title" actualizada',
    'recurrence_is_inactive'             => 'Esta transacción recurrente no está activa y no generará nuevas transacciones.',
    'delete_recurring'                   => 'Borrar Transacción Recurrente ":title"',
    'new_recurring_transaction'          => 'Nueva Transacción Recurrente',
    'help_weekend'                       => '¿Qué debe hacer Firefly III cuando la transacción recurrente cae el sábado o el domingo?',
    'do_nothing'                         => 'Sólo crear la transacción',
    'skip_transaction'                   => 'Saltar la ocurrencia',
    'jump_to_friday'                     => 'Crear la transacción el viernes anterior en su lugar',
    'jump_to_monday'                     => 'Crear la transacción el lunes próximo en su lugar',
    'will_jump_friday'                   => 'Se creará el viernes en lugar de los fines de semana.',
    'will_jump_monday'                   => 'Se creará el lunes en lugar de los fines de semana.',
    'except_weekends'                    => 'Excluir los fines de semana',
    'recurrence_deleted'                 => 'Transacción recurrente ":title" eliminada',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Gasto (:currency)',
    'box_earned_in_currency'             => 'Ganado (:currency)',
    'box_budgeted_in_currency'           => 'Presupuestado (:currency)',
    'box_bill_paid_in_currency'          => 'Suscripciones pagadas (:currency)',
    'box_bill_unpaid_in_currency'        => 'Suscripciones sin pagar (:currency)',
    'box_left_to_spend_in_currency'      => 'Disponible para gasto (:currency)',
    'box_net_worth_in_currency'          => 'Valor neto (:currency)',
    'box_spend_per_day'                  => 'Disponible para gasto diario: :amount',

    // debug page
    'debug_page'                         => 'Pagina de depuración',
    'debug_submit_instructions'          => 'Si está teniendo problemas, puede usar la información en este cuadro como información de depuración. Por favor, copie y pegue en un nuevo o existente <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Generará una hermosa tabla que se puede utilizar para diagnosticar rápidamente su problema.',
    'debug_pretty_table'                 => 'Si copia/pega la casilla de abajo en un problema de GitHub, generará una tabla. Por favor, no envuelva este texto con comillas.',
    'debug_additional_data'              => 'También puede compartir el contenido del cuadro de abajo. También puede copiar y pegar esto en un <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a> nuevo o existente. Sin embargo, el contenido de este cuadro puede contener información privada como nombres de cuenta, detalles de transacción o direcciones de correo electrónico.',

    // object groups
    'object_groups_menu_bar'             => 'Grupos',
    'object_groups_page_title'           => 'Grupos',
    'object_groups_breadcrumb'           => 'Grupos',
    'object_groups_index'                => 'Resumen',
    'object_groups'                      => 'Grupos',
    'object_groups_empty_explain'        => 'Algunas cosas en Firefly III se pueden dividir en grupos. Las huchas, por ejemplo, incluyen un campo "Grupo" en las pantallas de edición y creación. Cuando establece este campo, puede editar los nombres y el orden de los grupos en esta página. Para obtener más información, consulte las páginas de ayuda en la esquina superior derecha, debajo del icono (?).',
    'object_group_title'                 => 'Título',
    'edit_object_group'                  => 'Editar grupo ":title"',
    'delete_object_group'                => 'Eliminar grupo ":title"',
    'update_object_group'                => 'Actualizar grupo',
    'updated_object_group'               => 'Grupo ":title" actualizado con éxito',
    'deleted_object_group'               => 'Grupo ":title" eliminado con éxito',
    'object_group'                       => 'Grupo',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'Auditoría de entradas de registro',
    'ale_action_log_add'                 => 'Añadido :amount a la hucha ":name"',
    'ale_action_log_remove'              => 'Eliminado :amount de la hucha ":name"',
    'ale_action_clear_budget'            => 'Eliminado del presupuesto',
    'ale_action_update_group_title'      => 'Título del grupo de transacciones actualizado',
    'ale_action_update_date'             => 'Fecha de transacción actualizada',
    'ale_action_update_order'            => 'Orden de transacción actualizado',
    'ale_action_clear_category'          => 'Eliminado de la categoría',
    'ale_action_clear_notes'             => 'Notas eliminadas',
    'ale_action_clear_tag'               => 'Etiqueta limpiada',
    'ale_action_clear_all_tags'          => 'Limpiar todas las etiquetas',
    'ale_action_set_bill'                => 'Enlazado a una suscripción',
    'ale_action_switch_accounts'         => 'Cuentas de origen y destino cambiadas',
    'ale_action_set_budget'              => 'Establecer presupuesto',
    'ale_action_set_category'            => 'Establecer categoría',
    'ale_action_set_source'              => 'Establecer cuenta de origen',
    'ale_action_set_destination'         => 'Establecer cuenta de destino',
    'ale_action_update_transaction_type' => 'Tipo de transacción cambiado',
    'ale_action_update_notes'            => 'Notas cambiadas',
    'ale_action_update_description'      => 'Descripción cambiada',
    'ale_action_add_to_piggy'            => 'Hucha',
    'ale_action_remove_from_piggy'       => 'Hucha',
    'ale_action_add_tag'                 => 'Etiqueta añadida',
    'ale_action_update_amount'           => 'Cantidad actualizada',

    // dashboard
    'enable_auto_convert'                => 'Habilitar conversión de moneda',
    'disable_auto_convert'               => 'Deshabilitar conversión de moneda',
];
