<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => '":timezone"-ban tárolt',
    'displayed_in_tz'                           => '":timezone"-ban kijelzett',
    'close'                                     => 'Bezárás',
    'actions'                                   => 'Műveletek',
    'edit'                                      => 'Szerkesztés',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Törlés',
    'split'                                     => 'Felosztás',
    'single_split'                              => 'Felosztás',
    'clone'                                     => 'Másolás',
    'clone_and_edit'                            => 'Másol és szerkeszt',
    'confirm_action'                            => 'Művelet megerősítése',
    'last_seven_days'                           => 'Utolsó hét nap',
    'last_thirty_days'                          => 'Elmúlt harminc nap',
    'last_180_days'                             => 'Az utóbbi 180 nap',
    'month_to_date'                             => 'Hónap a mai napig',
    'year_to_date'                              => 'Év elejétől',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'Folyó év',
    'welcome_back'                              => 'Mi a helyzet?',
    'main_dashboard_page_title'                 => 'Főoldal',
    'everything'                                => 'Minden',
    'today'                                     => 'ma',
    'customRange'                               => 'Egyéni tartomány',
    'date_range'                                => 'Dátum intervallum',
    'apply'                                     => 'Alkalmaz',
    'select_date'                               => 'Dátum kiválasztása..',
    'cancel'                                    => 'Mégse',
    'from'                                      => 'Honnan',
    'to'                                        => 'Hova',
    'structure'                                 => 'Struktúra',
    'help_translating'                          => 'Ez a súgószöveg még nem elérhető az oldal nyelvén. <a href="https://crowdin.com/project/firefly-iii-help">Itt lehet segíteni a fordításban.</a>',
    'showEverything'                            => 'Összes megjelenítése',
    'never'                                     => 'Soha',
    'no_results_for_empty_search'               => 'A keresés üres volt, így nincs találat.',
    'removed_amount'                            => ':amount eltávolítva',
    'added_amount'                              => ':amount hozzáadva',
    'asset_account_role_help'                   => 'A választásoktól függő további lehetőségeket később lehet beállítani.',
    'Opening balance'                           => 'Nyitó egyenleg',
    'create_new_stuff'                          => 'Új dolog létrehozása',
    'new_withdrawal'                            => 'Új költség',
    'create_new_transaction'                    => 'Új tranzakció létrehozása',
    'sidebar_frontpage_create'                  => 'Létrehozás',
    'new_transaction'                           => 'Új tranzakció',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Eszközszámlák megtekintése',
    'go_to_budgets'                             => 'Ugrás a költségkeretekhez',
    'go_to_withdrawals'                         => 'Ugrás a költségekhez',
    'clones_journal_x'                          => 'Ez a tranzakció ":description" (#:id) klónja',
    'go_to_categories'                          => 'Ugrás a kategóriákhoz',
    'go_to_bills'                               => 'Ugrás az előfizetéseidhez',
    'go_to_expense_accounts'                    => 'Költségszámlák megtekintése',
    'go_to_revenue_accounts'                    => 'Jövedelemszámlák megtekintése',
    'go_to_piggies'                             => 'Ugrás a malacperselyekhez',
    'new_deposit'                               => 'Új bevétel',
    'new_transfer'                              => 'Új átvezetés',
    'new_transfers'                             => 'Új átvezetés',
    'new_asset_account'                         => 'Új eszközszámla',
    'new_expense_account'                       => 'Új költségszámla',
    'new_revenue_account'                       => 'Új jövedelemszámla',
    'new_liabilities_account'                   => 'Új kötelezettség',
    'new_budget'                                => 'Új költségkeret',
    'new_bill'                                  => 'Új előfizetés',
    'block_account_logout'                      => 'Ön kijelentkezett. A blokkolt fiókok nem használhatják ezt a webhelyet. Érvényes e-mail címmel regisztrált?',
    'flash_success'                             => 'Siker!',
    'flash_info'                                => 'Üzenet',
    'flash_warning'                             => 'Figyelmeztetés!',
    'flash_error'                               => 'Hiba!',
    'flash_danger'                              => 'Vigyázat!',
    'flash_info_multiple'                       => 'Egy üzenet érkezett | :count üzenet érkezett',
    'flash_error_multiple'                      => 'Egy hiba történt|:count hiba történt',
    'net_worth'                                 => 'Nettó érték',
    'help_for_this_page'                        => 'Az oldal súgója',
    'help_for_this_page_body'                   => 'További információkat találhat erről a lapról a <a href="https://docs.firefly-iii.org/">dokumentáció</a>ban.',
    'two_factor_welcome'                        => 'Helló!',
    'two_factor_enter_code'                     => 'A folytatáshoz meg kell adni a kétlépcsős azonosítás kódját. Az alkalmazás létre tudja hozni ezt a kódot.',
    'two_factor_code_here'                      => 'Kód beírása',
    'two_factor_title'                          => 'Kétlépcsős hitelesítés',
    'authenticate'                              => 'Hitelesítés',
    'two_factor_forgot_title'                   => 'Elvesztett kétlépcsős hitelesítés',
    'two_factor_forgot'                         => 'Elfelejtett kétlépcsős azonosítás.',
    'two_factor_lost_header'                    => 'Elvesztett kétlépcsős hitelesítés?',
    'two_factor_lost_intro'                     => 'Ha a biztonsági kódok is elvesztek, akkor bajban vagy. Ezt nem lehet a webes felületről megjavítani, így két lehetőséged van.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Ellenkező esetben emailt kell küldeni a webhely tulajdonosának a <a href="mailto::site_owner">:site_owner</a> címre, és meg kell kérni, hogy állítsa vissza a kétfaktoros hitelesítést.',
    'mfa_backup_code'                           => 'A biztonsági kód fel lett használva a Firefly III-hoz. Ezt többé nem használhatod fel, így a listáról ez kihúzható.',
    'pref_two_factor_new_backup_codes'          => 'Új biztonsági kódok igénylése',
    'pref_two_factor_backup_code_count'         => 'Még :count érvényes visszaállítási kódod van.|Még :count érvényes visszaállítási kódod van.',
    '2fa_i_have_them'                           => 'Eltároltam!',
    'warning_much_data'                         => ':days napi adat betöltése eltarthat egy ideig.',
    'registered'                                => 'A regisztráció sikeres!',
    'Default asset account'                     => 'Alapértelmezett eszközszámla',
    'no_budget_pointer'                         => 'Úgy tűnik, még nincsenek költségkeretek. Költségkereteket a <a href="budgets">költségkeretek</a> oldalon lehet létrehozni. A költségkeretek segítenek nyomon követni a költségeket.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Megtakarítási számla',
    'Credit card'                               => 'Hitelkártya',
    'source_accounts'                           => 'Forrásszámla|Forrásszámlák',
    'destination_accounts'                      => 'Célszámla|Célszámlák',
    'user_id_is'                                => 'A felhasználói azonosító <strong>:user</strong>',
    'field_supports_markdown'                   => 'Ez a mező támogatja a <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a> használatát.',
    'need_more_help'                            => 'A Firefly III használatához további segítség kérhető a <a href="https://github.com/firefly-iii/firefly-iii/issues">a Githubon egy hibajegy nyitásával</a>.',
    'reenable_intro_text'                       => '<a href="#" id="reenableGuidance">A bevezető útmutatót</a> újra lehet engedélyezni.',
    'intro_boxes_after_refresh'                 => 'A bevezető dobozok újra megjelennek az oldal frissítésekor.',
    'show_all_no_filter'                        => 'Az összes tranzakció megjelenítése dátum szerinti csoportosítás nélkül.',
    'expenses_by_category'                      => 'Költségek kategóriák szerint',
    'expenses_by_budget'                        => 'Költségek költségkeretek szerint',
    'income_by_category'                        => 'Jövedelem kategória szerint',
    'expenses_by_asset_account'                 => 'Költségek eszközszámla szerint',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'A Firefly III nem tud átirányítani a megfelelő oldalra. Elnézést.',
    'sum_of_expenses'                           => 'A költségek összege',
    'sum_of_income'                             => 'Jövedelem összege',
    'liabilities'                               => 'Kötelezettségek',
    'spent_in_specific_budget'                  => 'Költés ":budget" költségkeretben',
    'spent_in_specific_double'                  => 'A(z) ":account" fiókon elköltött',
    'earned_in_specific_double'                 => 'A(z) ":account" fiókon megkeresett',
    'source_account'                            => 'Forrás számla',
    'source_account_reconciliation'             => 'Nem lehet szerkeszteni egy egyeztetett tranzakció forrásszámláját.',
    'destination_account'                       => 'Célszámla',
    'destination_account_reconciliation'        => 'Nem lehet szerkeszteni egy egyeztetett tranzakció célszámláját.',
    'sum_of_expenses_in_budget'                 => 'Összes költés ":budget" költségkeretben',
    'left_in_budget_limit'                      => 'A költségvetés szerinti elkölthető összeg',
    'current_period'                            => 'Jelenlegi időszak',
    'show_the_current_period_and_overview'      => 'Az aktuális időszak és az áttekintés megjelenítése',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'Ahhoz, hogy egy angoltól eltérő nyelv megfelelően működjön, az operációs rendszernek a helyes helyspecifikus információkkal kell rendelkeznie. Ha ezek nincsenek jelen, akkor a pénznem adat, a dátumok és az összegek formázása hibás lehet.',
    'budget_in_period'                          => '":name" költségkeret összes tranzakciója :start és :end között :currency pénznemben',
    'chart_budget_in_period'                    => 'Diagram ":name" költségkeret minden tranzakciójáról :start és :end között :currency pénznemben',
    'chart_budget_in_period_only_currency'      => 'A költségkeretben előirányzott összeg pénzneme :currency, Így ez a diagram csak azokat a tranzakciókat mutatja amiknek a pénznem :currency.',
    'chart_account_in_period'                   => 'Diagram ":name" (:balance) bankszámla minden tranzakciójáról :start és :end között',
    'chart_category_in_period'                  => 'Diagram ":name" kategória minden tranzakciójáról :start és :end között',
    'chart_category_all'                        => 'Diagram ":name" kategória minden tranzakciójáról',
    'clone_withdrawal'                          => 'Költség klónozása',
    'clone_deposit'                             => 'Bevétel klónozása',
    'clone_transfer'                            => 'Átvezetés klónozása',
    'multi_select_no_selection'                 => 'Egy sincs kiválasztva',
    'multi_select_select_all'                   => 'Összes kijelölése',
    'multi_select_n_selected'                   => 'kijelölt',
    'multi_select_all_selected'                 => 'Minden kiválasztott',
    'multi_select_filter_placeholder'           => 'Keresés..',
    'intro_next_label'                          => 'Következő',
    'intro_prev_label'                          => 'Előző',
    'intro_skip_label'                          => 'Kihagyás',
    'intro_done_label'                          => 'Kész',
    'between_dates_breadcrumb'                  => ':start és :end között',
    'all_journals_without_budget'               => 'Minden költségkeret nélküli tranzakció',
    'journals_without_budget'                   => 'Költségkeret nélküli tranzakciók',
    'all_journals_without_category'             => 'Minden kategória nélküli tranzakció',
    'journals_without_category'                 => 'Kategória nélküli tranzakciók',
    'all_journals_for_account'                  => ':name bankszámla összes tranzakciója',
    'chart_all_journals_for_account'            => 'Diagram :name bankszámla minden tranzakciójáról',
    'journals_in_period_for_account'            => '":name" bankszámla összes tranzakciója :start és :end között',
    'journals_in_period_for_account_js'         => 'Minden tranzakció a(z) {title} számlán {start} és {end} között',
    'transferred'                               => 'Átvezetett',
    'all_withdrawal'                            => 'Minden költség',
    'all_transactions'                          => 'Minden tranzakció',
    'title_withdrawal_between'                  => 'Minden költség :start és :end között',
    'all_deposit'                               => 'Összes jövedelem',
    'title_deposit_between'                     => 'Összes jövedelem :start és :end között',
    'all_transfers'                             => 'Minden átvezetés',
    'title_transfers_between'                   => 'Minden átvezetés :start és :end között',
    'all_transfer'                              => 'Minden átvezetés',
    'all_journals_for_tag'                      => '":tag" címke összes tranzakciója',
    'title_transfer_between'                    => 'Minden átvezetés :start és :end között',
    'all_journals_for_category'                 => ':name kategória összes tranzakciója',
    'all_journals_for_budget'                   => ':name költségkeret összes tranzakciója',
    'chart_all_journals_for_budget'             => 'Diagram :name költségkeret minden tranzakciójáról',
    'journals_in_period_for_category'           => ':name kategória összes tranzakciója :start és :end között',
    'journals_in_period_for_tag'                => ':tag címke összes tranzakciója :start és :end között',
    'not_available_demo_user'                   => 'A használni kívánt szolgáltatás nem érhető el a bemutató felhasználók számára.',
    'exchange_rate_instructions'                => 'A "@name" vagyonszámla csak a @primary_currency tranzakciókat fogadja el. Ha inkább @foreign_currency pénznemet szeretne használni, győződjön meg róla, hogy a @primary_currency összege is ismert:',
    'transfer_exchange_rate_instructions'       => 'A "@source_name" forrás vagyonszámla csak a @source_currency tranzakciókat fogadja el. A "@dest_name" cél vagyonszámla csak a @dest_currency tranzakciókat fogadja el. Mindkét pénznemben helyesen kell megadnia az átutalt összeget.',
    'transaction_data'                          => 'Tranzakciós adatok',
    'invalid_server_configuration'              => 'Érvénytelen kiszolgálóbeállítás',
    'invalid_locale_settings'                   => 'Firefly II nem tudja megfelelően formázni a pénznemeket, mert a szerverről hiányoznak a szükséges csomagok. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">Itt talál iránymutatást a javításra</a>.',
    'quickswitch'                               => 'Gyorsváltó',
    'sign_in_to_start'                          => 'A munkamenet megkezdéséhez be kell jelentkezni',
    'sign_in'                                   => 'Bejelentkezés',
    'register_new_account'                      => 'Új fiók regisztrációja',
    'forgot_my_password'                        => 'Elfelejtett jelszó',
    'problems_with_input'                       => 'Volt néhány probléma a bevitt adatokkal.',
    'reset_password'                            => 'Jelszó visszaállítása',
    'button_reset_password'                     => 'Jelszó visszaállítása',
    'reset_button'                              => 'Visszaállítás',
    'want_to_login'                             => 'Bejelentkezés',
    'login_page_title'                          => 'Bejelentkezés a Firefly III-ba',
    'register_page_title'                       => 'Regisztrálás a Firefly III-ba',
    'forgot_pw_page_title'                      => 'Elfelejtette a jelszavát a Firefly III-hoz',
    'reset_pw_page_title'                       => 'Firefly III jelszó visszaállítása',
    'cannot_reset_demo_user'                    => 'A bemutató felhasználónak nem nem lehet visszaállítani a jelszavát.',
    'no_att_demo_user'                          => 'Demo felhasználó nem tölthet fel csatolmányokat.',
    'button_register'                           => 'Regisztráció',
    'authorization'                             => 'Hitelesítés',
    'active_bills_only'                         => 'csak aktív előfizetés',
    'active_bills_only_total'                   => 'minden aktív előfizetés',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Várható napi költségek',
    'per_period_sum_1W'                         => 'Várható heti költségek',
    'per_period_sum_1M'                         => 'Várható havi költségek',
    'per_period_sum_3M'                         => 'Várható negyedéves költségek',
    'per_period_sum_6M'                         => 'Várható féléves költségek',
    'per_period_sum_1Y'                         => 'Várható éves költségek',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'várható teljes összeg',
    'reconciliation_account_name'               => ':name egyeztetés (:currency)',
    'saved'                                     => 'Mentve',
    'advanced_options'                          => 'Haladó beállítások',
    'advanced_options_explain'                  => 'A Firefly III egyes oldalakon spceiális beálításokat rejt emögött a gomb mögött. Ezen az oldalon nincs itt semmi érdekes, de érdemes megnézni a többit!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhook-ok',
    'webhooks_breadcrumb'                       => 'Webhook-ok',
    'webhooks_menu_disabled'                    => 'letiltva',
    'no_webhook_messages'                       => 'Nincsenek webhook üzenetek',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Tranzakció létrehozása után',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Tranzakció frissítése után',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Tranzakció törlése után',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Tranzakció részletei',
    'webhook_response_ACCOUNTS'                 => 'Számlaadatok',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Vizsgálat',
    'create_new_webhook'                        => 'Új webhook létrehozása',
    'webhooks_create_breadcrumb'                => 'Új webhook létrehozása',
    'webhook_trigger_form_help'                 => 'Adja meg, hogy a webhook-ot milyen eseményre indítja el',
    'webhook_response_form_help'                => 'Adja meg, hogy a webhook mit küldjön az URL-re.',
    'webhook_delivery_form_help'                => 'Milyen formátumban kézbesítse a webhook az adatokat.',
    'webhook_active_form_help'                  => 'A webhook-nak aktívnak kell lennie, különben nem fogják meghívni.',
    'stored_new_webhook'                        => 'Új webhook ":title" tárolva',
    'delete_webhook'                            => 'Webhook törlése',
    'deleted_webhook'                           => 'Webhook ":title" törölve',
    'edit_webhook'                              => 'Webhook ":title" módosítása',
    'updated_webhook'                           => 'Webhook ":title" frissítve',
    'edit_webhook_js'                           => 'Webhook "{title}" módosítása',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'A webhook a jelzett tranzakciónál aktiválódott. Kérem, várjon az eredmények megjelítésére.',
    'webhook_messages'                          => 'Webhook üzenet',
    'view_message'                              => 'Üzenet megtekintése',
    'view_attempts'                             => 'Sikertelen kísérletek megjelenítése',
    'message_content_title'                     => 'Webhook üzenet tartalma',
    'message_content_help'                      => 'Az üzenet tartalma amit a webhook küldött (vagy kísérelt meg küldeni).',
    'attempt_content_title'                     => 'Webhook kísérletek',
    'attempt_content_help'                      => 'Az összes sikertelenül küldött webhook üzenet a beállított URL-re. Idővel a Firefly III felhagy a próbálkozással.',
    'no_attempts'                               => 'Nincsenek sikertelen kísérletek. Nagyon jó!',
    'webhook_attempt_at'                        => 'Kísérlet {moment}-kor',
    'logs'                                      => 'Naplók',
    'response'                                  => 'Válasz',
    'visit_webhook_url'                         => 'Webhook URL meglátogatása',
    'reset_webhook_secret'                      => 'Webhook titok visszaállítása',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> eltárolva.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") frissítve.',

    // API access
    'authorization_request'                     => 'Firefly III v:version engedély kérelem',
    'authorization_request_intro'               => 'A(z) "<strong>:client</strong>" alkalmazás hozzáférést kér a pénzügyi nyilvántartásához. Szeretné megadni a hozzáférést ezekhez az adatokhoz a(z) "<strong>:client</strong>" részére?',
    'authorization_request_site'                => 'Átirányítjuk a <code>:url</code> címre, ami aztán képes lesz hozzáférni az Ön Firefly III adataihoz.',
    'authorization_request_invalid'             => 'Ez a hozzáférési kérelem érvénytelen. Kérjük, soha többé ne kövesse ezt a linket.',
    'scopes_will_be_able'                       => 'Ez az alkalmazás képes lesz arra, hogy:',
    'button_authorize'                          => 'Engedélyezés',
    'none_in_select_list'                       => '(nincs)',
    'no_piggy_bank'                             => '(nincs malacpersely)',
    'name_in_currency'                          => ':name - :currency',
    'paid_in_currency'                          => 'Fizetve :currency -ban',
    'unpaid_in_currency'                        => 'Be nem fizetett :currency -ban',
    'is_alpha_warning'                          => 'Jelenleg egy ALPHA verzió fut. Felléphetnek programhibák és problémák.',
    'is_beta_warning'                           => 'Jelenleg egy BETA verzió fut. Felléphetnek programhibák és problémák.',
    'all_destination_accounts'                  => 'Célszámlák',
    'all_source_accounts'                       => 'Forrásszámlák',
    'back_to_index'                             => 'Vissza a kezdőoldalra',
    'cant_logout_guard'                         => 'Firefly III nem tudja kijelentkeztetni.',
    'internal_reference'                        => 'Belső hivatkozás',

    // check for updates:
    'update_check_title'                        => 'Frissítések ellenőrzése',
    'admin_update_check_title'                  => 'Frissítés automatikus ellenőrzése',
    'admin_update_check_explain'                => 'A Firefly III képes automatikusan ellenőrizni a frissítéseket. Ha engedélyezi ezt a beállítást, akkor a Firefly III frissítési kiszolgálóval kommunikálva ellenőrzésre kerül, hogy rendelkezésre áll-e a Firefly III új verziója. Ha igen, értesítést kap. Ezt az értesítést a jobb oldalon található gombra kattintva tesztelheti. Kérjük jelezze alább, ha szeretné, hogy a Firefly III ellenőrizze a frissítéseket.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Kérdezze később',
    'updates_do_not_check'                      => 'Ne ellenőrizze a frissítéseket',
    'updates_enable_check'                      => 'Frissítések ellenőrzésének engedélyezése',
    'admin_update_check_now_title'              => 'Frissítések keresése most',
    'admin_update_check_now_explain'            => 'Ha megnyomja a gombot, a Firefly III ellenőrinzi fogja, hogy a legfrissebb változatot használja -e.',
    'check_for_updates_button'                  => 'Ellenőrzés most!',
    'update_new_version_alert'                  => 'A Firefly III új verziója elérhető. A jelenleg használt verzió :your_version, a legújabb verzió pedig :new_version, amely ekkor jelent meg: :date.',
    'update_version_beta'                       => 'Ez egy BETA verzió. Előfordulhatnak problémák.',
    'update_version_alpha'                      => 'Ez egy ALPHA verzió. Előfordulhatnak problémák.',
    'update_current_dev_older'                  => 'Régebbi fejlesztői verziót (:version) használsz, mint a legutolsó kiadás (:new_version). Kérlek frissíts!',
    'update_current_dev_newer'                  => 'Újabb fejlesztői verziót (:version) használsz, mint a legutolsó kiadás (:new_version).',
    'update_current_version_alert'              => 'A jelenlegi verzió :version, ez egyben a legfrissebb elérhető verzió is.',
    'update_newer_version_alert'                => 'A jelenlegi verzió :your_version, amely újabb, mint a legfrissebb kiadott verzió, ami a :new_version.',
    'update_check_error'                        => 'Hiba történt a frissítések ellenőrzése közben: :error',
    'unknown_error'                             => 'Ismeretlen hiba. Elnézést kérünk.',
    'disabled_but_check'                        => 'Kikapcsolta a frissítések automata keresését. Ne feledje az elérhető verziók rendszeres ellenőrzését. Köszönjük!',
    'admin_update_channel_title'                => 'Frissítési csatorna',
    'admin_update_channel_explain'              => 'A Firefly III-hoz három frissítési csatorna létezik, melyek meghatározzák, hogy a felhasználók mennyivel járnak előbbre a funkciók, fejlesztések és hibák szempontjából. A kalandvágyók használhatják a "beta" csatornát, míg azok akik szeretnek veszélyesen élni az "alpha"-t.',
    'update_channel_stable'                     => 'Stabil. Mindennek az elvártnak megfelelően kell működnie.',
    'update_channel_beta'                       => 'Beta. Új funkciók, de elromolhatnak dolgok.',
    'update_channel_alpha'                      => 'Alpha. Bedobálunk dolgokat, és azt használjuk, ami hasznosnak ígérkezik.',

    // search
    'search'                                    => 'Keresés',
    'search_query'                              => 'Lekérdezés',
    'search_found_transactions'                 => 'Firefly III :count tranzakciót talált :time másodperc alatt.|Firefly III :count tranzakciót talált :time másodperc alatt.',
    'search_found_more_transactions'            => 'A Firefly III :count tranzakciót talált :time másodperc alatt.',
    'search_for_overview'                       => 'Firefly III olyan tranzakciókat keres amelyek teljesítik az <b>összes</b> alábbi feltételt:',
    'search_for_query'                          => 'A összes következő szónak szerepelni kell: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Egyik következő szó sem szerepelhet: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Ezek a keresési paraméterek érvénytelenek, és figyelmen kívül hagytuk őket.',

    // old


    'search_modifier_date_on'                             => 'Tranzakció dátuma ":value"',
    'search_modifier_not_date_on'                         => 'Tranzakció dátuma nem ":value"',
    'search_modifier_reconciled'                          => 'Tranzakció kiegyenlítve',
    'search_modifier_not_reconciled'                      => 'Tranzakció nincs kiegyenlítve',
    'search_modifier_id'                                  => 'Tranzakció azonosító ":value"',
    'search_modifier_not_id'                              => 'Tranzakció azonosító nem ":value"',
    'search_modifier_date_before'                         => 'Tranzakció dátuma :value előtt van',
    'search_modifier_date_after'                          => 'Tranzakció dátuma :value után van',
    'search_modifier_external_id_is'                      => 'Külső azonosító ":value"',
    'search_modifier_not_external_id_is'                  => 'Külső azonosító nem ":value"',
    'search_modifier_no_external_url'                     => 'A tranzakciónak nincs külső URL-je',
    'search_modifier_no_external_id'                      => 'A tranzakciónak nincs külső azonosítója',
    'search_modifier_not_any_external_url'                => 'A tranzakciónak nincs külső URL-je',
    'search_modifier_not_any_external_id'                 => 'A tranzakciónak nincs külső azonosítója',
    'search_modifier_any_external_url'                    => 'A tranzakciónak rendelkeznie kell egy (bármilyen) külső URL-el',
    'search_modifier_any_external_id'                     => 'A tranzakciónak rendelkeznie kell egy (bármilyen) külső azonosítóval',
    'search_modifier_not_no_external_url'                 => 'A tranzakciónak rendelkeznie kell egy (bármilyen) külső URL-el',
    'search_modifier_not_no_external_id'                  => 'A tranzakciónak rendelkeznie kell egy (bármilyen) külső azonosítóval',
    'search_modifier_internal_reference_is'               => 'Belső hivatkozás: :value',
    'search_modifier_not_internal_reference_is'           => 'Belső hivatkozás nem ":value"',
    'search_modifier_description_starts'                  => 'Leírás eleje: ":value"',
    'search_modifier_not_description_starts'              => 'Leírás eleje nem: ":value"',
    'search_modifier_description_ends'                    => 'Leírás vége: ":value"',
    'search_modifier_not_description_ends'                => 'Leírás vége nem: ":value"',
    'search_modifier_description_contains'                => 'Leírás tartalmazza: ":value"',
    'search_modifier_not_description_contains'            => 'Leírás nem tartalmazza: ":value"',
    'search_modifier_description_is'                      => 'Leírás: ":value"',
    'search_modifier_not_description_is'                  => 'Leírás pontosan nem ":value"',
    'search_modifier_currency_is'                         => 'Tranzakció valutája ":value"',
    'search_modifier_not_currency_is'                     => 'Tranzakció valutája nem ":value"',
    'search_modifier_foreign_currency_is'                 => 'Tranzakció valutája ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Tranzakció valutája nem ":value"',
    'search_modifier_has_attachments'                     => 'Tranzakcióhoz kell legyen melléklet',
    'search_modifier_has_no_category'                     => 'A tranzakcióhoz nincs kategória',
    'search_modifier_not_has_no_category'                 => 'A tranzakciónak rendelkeznie kell egy (bármilyen) kategóriával',
    'search_modifier_not_has_any_category'                => 'A tranzakciónak nem lehet kategóriája',
    'search_modifier_has_any_category'                    => 'A tranzakciónak van kategóriája',
    'search_modifier_has_no_budget'                       => 'A tranzakcióhoz nincs költségkeret',
    'search_modifier_not_has_any_budget'                  => 'A tranzakciónak nem lehet kültségkerete',
    'search_modifier_has_any_budget'                      => 'A tranzakciónak van költségkerete',
    'search_modifier_not_has_no_budget'                   => 'A tranzakciónak rendelkeznie kell egy (bármilyen) költségkerettel',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'A tranzakcióhoz nincs címke',
    'search_modifier_not_has_any_tag'                     => 'A tranzakciónak nem lehet cimkéje',
    'search_modifier_not_has_no_tag'                      => 'A tranzakciónak rendelkeznie kell egy (bármilyen) cimkével',
    'search_modifier_has_any_tag'                         => 'A tranzakciónak van címkéje',
    'search_modifier_notes_contains'                      => 'Tranzakció megjegyzése tartalmazza ":value"',
    'search_modifier_not_notes_contains'                  => 'Tranzakció megjegyzése nem tartalmazza ":value"',
    'search_modifier_notes_starts'                        => 'Tranzakció megjegyzésének kezdete ":value"',
    'search_modifier_not_notes_starts'                    => 'Tranzakció megjegyzésének kezdete nem ":value"',
    'search_modifier_notes_ends'                          => 'Tranzakció megjegyzésének vége ":value"',
    'search_modifier_not_notes_ends'                      => 'Tranzakció megjegyzésének vége nem ":value"',
    'search_modifier_notes_is'                            => 'Tranzakció megjegyzése pontosan ":value"',
    'search_modifier_not_notes_is'                        => 'Tranzakció megjegyzése pontosan nem ":value"',
    'search_modifier_no_notes'                            => 'Tranzakciónak nincs megjegyzése',
    'search_modifier_not_no_notes'                        => 'Tranzakciónak rendelkeznie kell megjegyzéssel',
    'search_modifier_any_notes'                           => 'Tranzakciónak van megjegyzése',
    'search_modifier_not_any_notes'                       => 'Tranzakciónak nincs megjegyzése',
    'search_modifier_amount_is'                           => 'Összeg pontosan :value',
    'search_modifier_not_amount_is'                       => 'Összeg nem :value',
    'search_modifier_amount_less'                         => 'Összeg legfeljebb :value',
    'search_modifier_not_amount_more'                     => 'Összeg legfeljebb :value',
    'search_modifier_amount_more'                         => 'Összeg legalább :value',
    'search_modifier_not_amount_less'                     => 'Összeg legalább :value',
    'search_modifier_source_account_is'                   => 'Forrásszámla neve pontosan ":value"',
    'search_modifier_not_source_account_is'               => 'Forrásszámla vége nem ":value"',
    'search_modifier_source_account_contains'             => 'Forrásszámla neve tartalmazza ":value"',
    'search_modifier_not_source_account_contains'         => 'Forrásszámla neve nem tartalmazza ":value"',
    'search_modifier_source_account_starts'               => 'Forrásszámla nevének eleje":value"',
    'search_modifier_not_source_account_starts'           => 'Forrásszámla nevének eleje nem ":value"',
    'search_modifier_source_account_ends'                 => 'Forrásszámla vége ":value"',
    'search_modifier_not_source_account_ends'             => 'Forrásszámla nevének vége nem ":value"',
    'search_modifier_source_account_id'                   => 'Forrásszámla ID pontosan :value',
    'search_modifier_not_source_account_id'               => 'Forrásszámla ID nem :value',
    'search_modifier_source_account_nr_is'                => 'Forrásszámla számlaszáma (IBAN) pontosan ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Forrásszámla számlaszáma (IBAN) nem ":value"',
    'search_modifier_source_account_nr_contains'          => 'Forrásszámla számlaszáma (IBAN) tartalmazza ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Forrásszámla számlaszáma (IBAN) nem tartalmazza ":value"',
    'search_modifier_source_account_nr_starts'            => 'Forrásszámla számlaszáma (IBAN) kezdete ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Forrásszámla számlaszám (IBAN) kezdete nem ":value"',
    'search_modifier_source_account_nr_ends'              => 'Forrásszámla számlaszáma (IBAN) vége ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Forrásszámla számlaszáma (IBAN) nem így végződik ":value"',
    'search_modifier_destination_account_is'              => 'Célszámla neve pontosan ":value"',
    'search_modifier_not_destination_account_is'          => 'Célszámla neve nem ":value"',
    'search_modifier_destination_account_contains'        => 'Célszámla neve tartalmazza ":value"',
    'search_modifier_not_destination_account_contains'    => 'Célszámla neve nem tartalmazza ":value"',
    'search_modifier_destination_account_starts'          => 'Célszámla nevének eleje: ":value"',
    'search_modifier_not_destination_account_starts'      => 'Célszámla neve nem így kezdődik ":value"',
    'search_modifier_destination_account_ends'            => 'Célszámla nevének vége ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Destination account ID is :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Célszámla számlaszám (IBAN) pontosan: ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Célszámla számlaszám (IBAN) tartalmazza ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Célszámla számlaszáma (IBAN) eleje: ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Célszámla számlaszám (IBAN) vége ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Source or destination account ID\'s is/are: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'A kategória ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'A költségkeret ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Tranzakció típusa: :value',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'A címke ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Transaction is before or in year ":value"',
    'search_modifier_date_before_month'                   => 'Transaction is before or in month ":value"',
    'search_modifier_date_before_day'                     => 'Transaction is before or on day of month ":value"',
    'search_modifier_date_after_year'                     => 'Transaction is in or after year ":value"',
    'search_modifier_date_after_month'                    => 'Transaction is in or after month ":value"',
    'search_modifier_date_after_day'                      => 'Transaction is after or on day of month ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => '":rule" szabály frissítése a keresési feltételek alapján',
    'create_rule_from_query'                        => 'Új szabály létrehozása a keresési feltételek alapján',
    'rule_from_search_words'                        => 'The rule engine has a hard time handling ":string". The suggested rule that fits your search query may give different results. Please verify the rule triggers carefully.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Hiba történt keresés közben. További információ a naplófájlokban található.',
    'search_box'                                          => 'Keresés',
    'search_box_intro'                                    => 'Üdvözöljük a Firefly III kereső funkciójában. Írja be a keresési kifejezését a mezőbe. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Győződjön meg róla, hogy alaposan tanulmányozta a súgót</a>, mert a keresés meglehetősen összetett funkció.',
    'search_error'                                        => 'Hiba történt keresés közben',
    'search_searching'                                    => 'Keresés ...',
    'search_results'                                      => 'Keresési eredmények',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'éves',
    'repeat_freq_half-year'                               => 'félévente',
    'repeat_freq_quarterly'                               => 'negyedéves',
    'repeat_freq_monthly'                                 => 'havi',
    'repeat_freq_weekly'                                  => 'heti',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => 'heti',
    'quarterly'                                           => 'negyedéves',
    'half-year'                                           => 'félévente',
    'yearly'                                              => 'éves',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Inaktív szabályokat nem lehet futtatni.',
    'show_triggers'                                       => 'Mutasd az eseményindítókat',
    'show_actions'                                        => 'Műveletek mutatása',
    'rules'                                               => 'Szabályok',
    'rule_name'                                           => 'Szabály neve',
    'rule_triggers'                                       => 'A szabály életbe lép amikor',
    'rule_actions'                                        => 'A szabály ez lesz',
    'new_rule'                                            => 'Új szabály',
    'new_rule_group'                                      => 'Új szabálycsoport',
    'rule_priority_up'                                    => 'Nagyobb prioritás a szabálynak',
    'rule_priority_down'                                  => 'Kissebb prioritás a szabálynak',
    'make_new_rule_group'                                 => 'Új szabálycsoport létrehozása',
    'store_new_rule_group'                                => 'Új szabálycsoport tárolása',
    'created_new_rule_group'                              => '":title" szabálycsoport tárolva!',
    'updated_rule_group'                                  => '":title" szabálycsoport sikeresen frissítve.',
    'edit_rule_group'                                     => '":title" szabálycsoport szerkesztése',
    'duplicate_rule'                                      => 'Duplikált szabály: ":title"',
    'rule_copy_of'                                        => '":title" másolata',
    'duplicated_rule'                                     => '":title" szabály duplikálva ide: ":newTitle"',
    'delete_rule_group'                                   => '":title" szabálycsoport törlése',
    'deleted_rule_group'                                  => '":title" szabálycsoport törölve',
    'update_rule_group'                                   => 'Szabálycsoport frissítése',
    'no_rules_in_group'                                   => 'Ebben a csoportban nincsenek szabályok',
    'move_rule_group_up'                                  => 'Szabálycsoport felfelé mozgatása',
    'move_rule_group_down'                                => 'Szabálycsoport lefelé mozgatása',
    'save_rules_by_moving'                                => 'Save this rule by moving it to another rule group:|Save these rules by moving them to another rule group:',
    'make_new_rule'                                       => 'Új szabály létrehozása a ":title" szabálycsoportban',
    'make_new_rule_no_group'                              => 'Szabály létrehozás',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Szabály létrehozása egy tranzakció alapján. Ki kell egészíteni vagy be kell küldeni a lenti űrlapot.',
    'rule_is_strict'                                      => 'szigorú szabály',
    'rule_is_not_strict'                                  => 'nem szigorú szabály',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'A szigorú szabályokban a műveletek végrehajtásához MINDEN eseményindítónak el kell indulnia. A nem szigorú szabályokban BÁRMELY eseményindító elég a műveletek végrehajtásához.',
    'rule_help_active'                                    => 'Az inaktív szabályok sose fognak életbe lépni.',
    'stored_new_rule'                                     => 'Új szabály ":title" címmel eltárolva',
    'deleted_rule'                                        => '":title" című szabály törölve',
    'store_new_rule'                                      => 'Új szabály tárolása',
    'updated_rule'                                        => '":title" című szabály frissítve',
    'default_rule_group_name'                             => 'Alapértelmezés szerinti szabályok',
    'default_rule_group_description'                      => 'Csoporthoz nem rendelt szabályok.',
    'trigger'                                             => 'Eseményindító',
    'trigger_value'                                       => 'Eseményindító értéke',
    'stop_processing_other_triggers'                      => 'Egyéb eseményindítók feldolgozásának leállítása',
    'add_rule_trigger'                                    => 'Új eseményindító hozzáadása',
    'action'                                              => 'Művelet',
    'action_value'                                        => 'Művelet érték',
    'stop_executing_other_actions'                        => 'Egyéb műveletek végrehajtásának leállítása',
    'add_rule_action'                                     => 'Új művelet hozzáadása',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => '":title" szabály törlése',
    'update_rule'                                         => 'Frissítési szabály',
    'test_rule_triggers'                                  => 'Egyező tranzakciók mutatása',
    'warning_no_matching_transactions'                    => 'Nincs a feltételeknek megfelelő tranzakció.',
    'warning_no_valid_triggers'                           => 'Nincs megadva érvényes eseményindító.',
    'apply_rule_selection'                                => '":title" szabály alkalmazása a tranzakciók egy csoportján',
    'apply_rule_selection_intro'                          => 'Az olyan szabályok mint a ":title" normális esetben csak az új vagy a frissített tranzakciókon lesznek alkalmazva, de meg lehet mondani a Firefly III-nak, hogy futtassa le a már létező tranzakciókon. Ez hasznos lehet, ha egy szabály frissítve lett és a módosításokat az összes tranzakción alkalmazni kell.',
    'include_transactions_from_accounts'                  => 'Beleértve a tranzakciókat ezekből a számlákból',
    'include'                                             => 'Include?',
    'applied_rule_selection'                              => '{0} No transactions in your selection were changed by rule ":title".|[1] One transaction in your selection was changed by rule ":title".|[2,*] :count transactions in your selection were changed by rule ":title".',
    'execute'                                             => 'Végrehajtás',
    'apply_rule_group_selection'                          => '":title" szabálycsoport alkalmazása a tranzakciók egy csoportján',
    'apply_rule_group_selection_intro'                    => 'Az olyan szabálycsoportok mint a ":title" normális esetben csak az új vagy a frissített tranzakciókon lesznek alkalmazva, de meg lehet mondani a Firefly III-nak, hogy futtassa le a csoportban lévő összes szabályt a már létező tranzakciókon. Ez hasznos lehet, ha egy szabálycsoport frissítve lett és a módosításokat az összes tranzakción alkalmazni kell.',
    'applied_rule_group_selection'                        => '":title" szabálycsoport alkalmazva a kiválasztásra.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Tranzakció létrehozásakor',
    'rule_trigger_update_journal'                         => 'Tranzakció frissítésekor',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'A felhasználói művelet ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Forrásszámla nevének eleje..',
    'rule_trigger_source_account_starts'                  => 'Forrásszámla nevének eleje: ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Forrásszámla nevének vége..',
    'rule_trigger_source_account_ends'                    => 'Forrásszámla nevének vége ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'A forrásszámla neve..',
    'rule_trigger_source_account_is'                      => 'Forrásszámla neve: ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Forrásszámla neve tartalmazza..',
    'rule_trigger_source_account_contains'                => 'Forrásszámla neve tartalmazza: ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Forrásszámla ID pontosan..',
    'rule_trigger_source_account_id'                      => 'Forrásszámla ID pontosan :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Célszámla ID pontosan..',
    'rule_trigger_destination_account_id'                 => 'Célszámla ID pontosan :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Forrásszámla egy készpénz számla',
    'rule_trigger_source_is_cash'                         => 'Forrásszámla egy készpénz számla',
    'rule_trigger_destination_is_cash_choice'             => 'Célszámla egy készpénz számla',
    'rule_trigger_destination_is_cash'                    => 'Célszámla egy készpénz számla',
    'rule_trigger_source_account_nr_starts_choice'        => 'Forrásszámla számlaszáma / IBAN eleje..',
    'rule_trigger_source_account_nr_starts'               => 'Forrásszámla számlaszáma / IBAN eleje: ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Forrásszámla számlaszáma / IBAN vége..',
    'rule_trigger_source_account_nr_ends'                 => 'Forrásszámla számlaszáma / IBAN vége: ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Forrásszámla száma / IBAN..',
    'rule_trigger_source_account_nr_is'                   => 'Forrásszámla száma / IBAN: ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Forrásszámla száma / IBAN tartalmazza..',
    'rule_trigger_source_account_nr_contains'             => 'Forrásszámla száma / IBAN tartalmazza: ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Célszámla nevének eleje..',
    'rule_trigger_destination_account_starts'             => 'Célszámla nevének eleje: ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Célszámla nevének vége..',
    'rule_trigger_destination_account_ends'               => 'Célszámla nevének vége: ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'A célszámla neve..',
    'rule_trigger_destination_account_is'                 => 'Célszámla neve: ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'A célszámla neve tartalmazza..',
    'rule_trigger_destination_account_contains'           => 'Célszámla neve tartalmazza: ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Célszámla számlaszáma / IBAN eleje..',
    'rule_trigger_destination_account_nr_starts'          => 'Célszámla számlaszáma / IBAN eleje: ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Célszámla számlaszáma / IBAN eleje..',
    'rule_trigger_destination_account_nr_ends'            => 'Célszámla számlaszáma / IBAN vége: ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Célszámla száma / IBAN..',
    'rule_trigger_destination_account_nr_is'              => 'Célszámla száma / IBAN: ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Célszámla száma / IBAN tartalmazza..',
    'rule_trigger_destination_account_nr_contains'        => 'Célszámla száma / IBAN tartalmazza: ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'A tranzakció típusa..',
    'rule_trigger_transaction_type'                       => 'Tranzakció típusa ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'A kategória..',
    'rule_trigger_category_is'                            => 'A kategória ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Leírás eleje..',
    'rule_trigger_description_starts'                     => 'Leírás eleje: ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Leírás vége..',
    'rule_trigger_description_ends'                       => 'Leírás vége: ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'A leírás tartalmazza..',
    'rule_trigger_description_contains'                   => 'Leírás tartalmazza: ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'A leírás pontosan..',
    'rule_trigger_description_is'                         => 'Leírás: ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Tranzakció dátuma korábbi, mint..',
    'rule_trigger_date_before'                            => 'Tranzakció dátuma korábbi, mint ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Tranzakció dátuma későbbi, mint..',
    'rule_trigger_date_after'                             => 'Tranzakció dátuma későbbi, mint ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'A költségkeret..',
    'rule_trigger_budget_is'                              => 'Költségkeret: ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'A tranzakció pénzneme..',
    'rule_trigger_currency_is'                            => 'A tranzakció pénzneme: ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transaction foreign currency is..',
    'rule_trigger_foreign_currency_is'                    => 'Transaction foreign currency is ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Nincs kategóriája',
    'rule_trigger_has_no_category'                        => 'A tranzakcióhoz nincs kategóriája',
    'rule_trigger_has_any_category_choice'                => 'Van kategóriája',
    'rule_trigger_has_any_category'                       => 'A tranzakciónak van kategóriája',
    'rule_trigger_has_no_budget_choice'                   => 'Nincs költségkerete',
    'rule_trigger_has_no_budget'                          => 'Költségkeret nélküli tranzakciók',
    'rule_trigger_has_any_budget_choice'                  => 'Van költségkerete',
    'rule_trigger_has_any_budget'                         => 'Költségkerettel rendelkező tranzakció',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Nincsenek címkéi',
    'rule_trigger_has_no_tag'                             => 'Címke nélküli tranzakció',
    'rule_trigger_has_any_tag_choice'                     => 'Van legalább egy címkéje',
    'rule_trigger_has_any_tag'                            => 'A tranzakciónak van legalább egy címkéje',
    'rule_trigger_any_notes_choice'                       => 'Van megjegyzése',
    'rule_trigger_any_notes'                              => 'A tranzakciónak van megjegyzése',
    'rule_trigger_no_notes_choice'                        => 'Nincsenek megjegyzései',
    'rule_trigger_no_notes'                               => 'A tranzakciónak nincs megjegyzése',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaction journal ID is..',
    'rule_trigger_journal_id'                             => 'Transaction journal ID is ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaction has no external URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaction ID is..',
    'rule_trigger_id'                                     => 'Transaction ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Kategória beállítása ":action_value"',
    'rule_action_clear_category'                 => 'Kategória törlése',
    'rule_action_set_budget'                     => 'Költségvetés beállítása: ":action_value"',
    'rule_action_clear_budget'                   => 'Költségkeret törlése',
    'rule_action_add_tag'                        => 'Címke hozzáadása ":action_value"',
    'rule_action_remove_tag'                     => 'Címke eltávolítása ":action_value"',
    'rule_action_remove_all_tags'                => 'Minden címke eltávolítása',
    'rule_action_set_description'                => 'Leírást megadása: ":action_value"',
    'rule_action_append_description'             => 'Hozzáfűzés a leírás végéhez ":action_value"',
    'rule_action_prepend_description'            => 'Hozzáfűzés a leírás elejéhez ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Minden kategória törlése',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Minden költségvetés törlése',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Minden címke eltávolítása',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Forrásfiók beállítása :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Célfiók beállítása :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Hozzáfűzés a jegyzetekhez ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Hozzáfűzés a jegyzetek elejéhez ":action_value"',
    'rule_action_clear_notes_choice'             => 'Megjegyzések eltávolítása',
    'rule_action_clear_notes'                    => 'Megjegyzések eltávolítása',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Jegyzetek megadása: ":action_value"',
    'rule_action_convert_deposit_choice'         => 'A tranzakció bevétellé konvertálása',
    'rule_action_convert_deposit'                => 'Tranzakció bevétellé konvertálása innen: ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'A tranzakció költséggé konvertálása',
    'rule_action_convert_withdrawal'             => 'Tranzakció költséggé konvertálása ide: ":action_value"',
    'rule_action_convert_transfer_choice'        => 'A tranzakció átvezetéssé konvertálása',
    'rule_action_convert_transfer'               => 'Tranzakció átvezetéssé konvertálása ezzel: ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => '":description" tranzakción alapuló szabály',
    'new_rule_for_journal_description'          => 'Ez a szabály ":description" tranzakción alapul. A pontosan azonos tranzakciókkal fog egyezni.',

    // tags
    'store_new_tag'                             => 'Új címke tárolása',
    'update_tag'                                => 'Címke frissítése',
    'no_location_set'                           => 'Nincs hely beállítása.',
    'meta_data'                                 => 'Metaadat',
    'location'                                  => 'Hely',
    'location_first_split'                      => 'A tranzakció helyszíne a tranzakció első bontásánál állítható be.',
    'without_date'                              => 'Dátum nélkül',
    'result'                                    => 'Eredmény',
    'sums_apply_to_range'                       => 'Minden összeg alkalmazása a kiválasztott tartományra',
    'mapbox_api_key'                            => 'A térkép használatához be kell szerezni egy API kulcsot a <a href="https://www.mapbox.com/">Mapbox</a> oldalról. A kódot a <code>.env</code> fájlba, a <code>MAPBOX_API_KEY = </code> után kell beírni.',
    'press_object_location'                     => 'Jobb kattintással vagy az egérgomb hosszan nyomva tartásával lehet beállítani az objektum helyét.',
    'click_tap_location'                        => 'Kattints, vagy érintsd meg a térképet helyszín hozzáadásához',
    'clear_location'                            => 'Hely törlése',
    'delete_all_selected_tags'                  => 'Minden kiválasztott címke törlése',
    'select_tags_to_delete'                     => 'Ki kell választani néhány címkét.',
    'deleted_x_tags'                            => 'Deleted :count tag.|Deleted :count tags.',
    'create_rule_from_transaction'              => 'Szabály létrehozása tranzakció alapján',
    'create_recurring_from_transaction'         => 'Ismétlődő tranzakció létrehozása a tranzakció alapján',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(nyelvvel megegyező)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Kezdőoldali számlák',
    'pref_home_screen_accounts_help'            => 'Melyik számlák legyenek megjelenítve a kezdőoldalon?',
    'pref_view_range'                           => 'Tartomány mutatása',
    'pref_view_range_help'                      => 'Néhány diagram automatikusan időszakokba lesz csoportosítva. A költségkeretek szintén időszakokba lesznek csoportosítva. Milyen időszakot részesít előnyben?',
    'pref_1D'                                   => 'Egy nap',
    'pref_1W'                                   => 'Egy hét',
    'pref_1M'                                   => 'Egy hónap',
    'pref_3M'                                   => 'Három hónap (negyedév)',
    'pref_6M'                                   => 'Hat hónap',
    'pref_1Y'                                   => 'Egy év',
    'pref_last365'                              => 'Last year',
    'pref_last90'                               => 'Last 90 days',
    'pref_last30'                               => 'Last 30 days',
    'pref_last7'                                => 'Last 7 days',
    'pref_YTD'                                  => 'Year to date',
    'pref_QTD'                                  => 'Quarter to date',
    'pref_MTD'                                  => 'Month to date',
    'pref_languages'                            => 'Nyelvek',
    'pref_locale'                               => 'Területi beállítások',
    'pref_languages_help'                       => 'A Firefly III több nyelven is elérhető. Melyiket szeretné használni?',
    'pref_locale_help'                          => 'Firefly III allows you to set other local settings, like how currencies, numbers and dates are formatted. Entries in this list may not be supported by your system. Firefly III doesn\'t have the correct date settings for every locale; contact me for improvements.',
    'pref_locale_no_demo'                       => 'Ez a funkció nem működik a demo felhasználónak.',
    'pref_convert_to_primary'                   => 'Összegek kijelzése az elsődleges pénznemben',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Költségvetési év beállításai',
    'pref_custom_fiscal_year_label'             => 'Engedélyezett',
    'pref_custom_fiscal_year_help'              => 'Azokban az országokban ahol a pénzügyi év nem Január 1 és December 31 közé esik, be lehet ezt kapcsolni és meg lehet adni a pénzügyi év kezdő- és végdátumát',
    'pref_fiscal_year_start_label'              => 'Üzleti év kezdődátuma',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Ne felejtse el törölni a fiókot a hitelesítő alkalmazásából!',
    'pref_two_factor_auth_code'                 => 'Kód megerősítése',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Ellenőrző kód visszaállítása',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Ha nincs lehetőség a QR kód beolvasására, akkor helyette a titkos kulcs is hasznáható: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Mentsd el a biztonsági kódokat, arra az esetre, ha elveszted az eszközödet.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Ez az MFA kód nem érvényes.',
    'pref_save_settings'                        => 'Beállítások mentése',
    'saved_preferences'                         => 'Beállítások elmentve!',
    'preferences_general'                       => 'Általános',
    'preferences_frontpage'                     => 'Kezdőoldal',
    'preferences_security'                      => 'Biztonság',
    'preferences_layout'                        => 'Elrendezés',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Bevételek mutatása a kezdőoldalon',
    'pref_home_show_deposits_info'              => 'A kezdőoldalon már látszanak a költségszámlák. Szeretné a jövedelemszámlákat is megjeleníteni?',
    'pref_home_do_show_deposits'                => 'Igen, mutasd',
    'successful_count'                          => 'ebből :count sikeres',
    'list_page_size_title'                      => 'Oldal mérete',
    'list_page_size_help'                       => 'Minden dologból (számlák, tranzakciók, stb) legfeljebb ennyi lesz megjelenítve oldalanként.',
    'list_page_size_label'                      => 'Oldal mérete',
    'between_dates'                             => '(:start és :end)',
    'pref_optional_fields_transaction'          => 'Tranzakciók választható mezői',
    'pref_optional_fields_transaction_help'     => 'Alapértelmezés szerint új tranzakció létrehozásakor nem minden mező engedélyezett (hogy elkerüljük a túlzsúfoltságot). Ezeket a mezőket lent lehet engedélyezni ha valamelyikre szükség van. Természetesen azok a letiltott mezők amelyek már ki vannak töltve, a beállítástól függetlenül láthatóak lesznek.',
    'optional_tj_date_fields'                   => 'Dátummezők',
    'optional_tj_other_fields'                  => 'Other fields',
    'optional_tj_attachment_fields'             => 'Melléklet mezők',
    'pref_optional_tj_interest_date'            => 'Kamatfizetési időpont',
    'pref_optional_tj_book_date'                => 'Könyvelés dátuma',
    'pref_optional_tj_process_date'             => 'Feldolgozás dátuma',
    'pref_optional_tj_due_date'                 => 'Esedékesség dátuma',
    'pref_optional_tj_payment_date'             => 'Kifizetés dátuma',
    'pref_optional_tj_invoice_date'             => 'Számla dátuma',
    'pref_optional_tj_internal_reference'       => 'Belső hivatkozás',
    'pref_optional_tj_notes'                    => 'Megjegyzések',
    'pref_optional_tj_attachments'              => 'Mellékletek',
    'pref_optional_tj_external_url'             => 'External URL',
    'pref_optional_tj_location'                 => 'Location',
    'pref_optional_tj_links'                    => 'Transaction links',
    'optional_field_meta_dates'                 => 'Dátumok',
    'optional_field_meta_business'              => 'Üzleti',
    'optional_field_attachments'                => 'Mellékletek',
    'optional_field_meta_data'                  => 'Opcionális metaadat',
    'external_url'                              => 'External URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Nincs elég pénznem',
    'not_enough_currencies_enabled'             => 'Amennyiben csak egyetlen pénznem engedélyezett, akkor nincs szükség árfolyam beállításokra.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Minden másik bejelentkezésed ki lett léptetve.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'MINDEN költségkeret törlése',
    'delete_all_categories'                     => 'MINDEN kategória törlése',
    'delete_all_tags'                           => 'MINDEN címke törlése',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'MINDEN malacpersely törlése',
    'delete_all_rules'                          => 'MINDEN szabály törlése',
    'delete_all_recurring'                      => 'MINDEN ismétlődő tranzakció törlése',
    'delete_all_object_groups'                  => 'MINDEN csoport törlése',
    'delete_all_accounts'                       => 'MINDEN költségszámla törlése',
    'delete_all_asset_accounts'                 => 'MINDEN eszközszámla törlése',
    'delete_all_expense_accounts'               => 'MINDEN költségszámla törlése',
    'delete_all_revenue_accounts'               => 'MINDEN jövedelemszámla törlése',
    'delete_all_liabilities'                    => 'MINDEN kötelezettség törlése',
    'delete_all_transactions'                   => 'MINDEN tranzakció törlése',
    'delete_all_withdrawals'                    => 'MINDEN költség törlése',
    'delete_all_deposits'                       => 'MINDEN bevétel törlése',
    'delete_all_transfers'                      => 'MINDEN átvezetés törlése',
    'also_delete_transactions'                  => 'Számlák törlése során MINDEN hozzá kapcsolódó költség, bevétel és átvezetés is törlődik!',
    'deleted_all_budgets'                       => 'Minden költségkeret törölve',
    'deleted_all_categories'                    => 'Minden kategória törölve',
    'deleted_all_tags'                          => 'Minden címke törölve',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Minden malacpersely törölve lett',
    'deleted_all_rules'                         => 'Minden szabály és szabálycsoport törölve lett',
    'deleted_all_object_groups'                 => 'Minden csoport törölve lett',
    'deleted_all_accounts'                      => 'Minden számla törölve lett',
    'deleted_all_asset_accounts'                => 'Minden eszközszámla törölve lett',
    'deleted_all_expense_accounts'              => 'Minden költségszámla törölve lett',
    'deleted_all_revenue_accounts'              => 'Minden jövedelemszámla törölve lett',
    'deleted_all_liabilities'                   => 'Minden kötelezettség törölve lett',
    'deleted_all_transactions'                  => 'Minden tranzakció törölve lett',
    'deleted_all_withdrawals'                   => 'Minden költség törölve lett',
    'deleted_all_deposits'                      => 'Minden bevétel törölve lett',
    'deleted_all_transfers'                     => 'Minden átvezetés törölve lett',
    'deleted_all_recurring'                     => 'Minden ismétlődő tranzakció törölve lett',
    'change_your_password'                      => 'Jelszó módosítása',
    'delete_account'                            => 'Fiók törlése',
    'current_password'                          => 'Jelenlegi jelszó',
    'new_password'                              => 'Új jelszó',
    'new_password_again'                        => 'Új jelszó megismétlése',
    'delete_your_account'                       => 'Saját fiók törlése',
    'delete_your_account_help'                  => 'A fiók törlése minden a Firefly III-ba elmentett számlát, tranzakciót, <em>MINDENT</em> törölni fog. Ezek EL FOGNAK TŰNNI.',
    'delete_your_account_password'              => 'Meg kell adni a jelszót a folytatáshoz.',
    'password'                                  => 'Jelszó',
    'are_you_sure'                              => 'Biztos? Nem vonható vissza.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'Saját fiók TÖRLÉSE',
    'invalid_current_password'                  => 'Érvénytelen jelenlegi jelszó!',
    'password_changed'                          => 'Jelszó módosítva!',
    'should_change'                             => 'Az ötlet az, hogy megváltoztasd a jelszavad.',
    'invalid_password'                          => 'Érvénytelen jelszó!',
    'what_is_pw_security'                       => 'Mit jelent a "jelszóbiztonság ellenőrzése"?',
    'secure_pw_title'                           => 'Hogyan válasszon biztonságos jelszót',
    'forgot_password_response'                  => 'Thank you. If an account exists with this email address, you will find instructions in your inbox.',
    'secure_pw_history'                         => 'Nincs olyan hét, hogy a hírekben ne lehetne arról olvasni, hogy egy weboldal elvesztette a felhasználói jelszavait. A hekkerek és a tolvajok a privát információk ellopására használják ezeket az jelszavakat. Ezek az információk értékesek.',
    'secure_pw_ff'                              => 'Ugyanazt a jelszót használod az egész interneten? Ha egy weboldal elveszti a jelszavadat a hekkerek minden adatodhoz hozzá fognak férni. A Firefly III rád bízza, hogy erős és egyedi jelszót válassz a pénzügyi adataid védelméhez.',
    'secure_pw_check_box'                       => 'A Firefly III úgy segít ebben, hogy ellenőrzi nem lopták-e el a múltban a megadott jelszót. Ha ez történt a Firefly III javasolni fogja, hogy NE használd ezt a jelszót.',
    'secure_pw_working_title'                   => 'Hogyan működik?',
    'secure_pw_working'                         => 'Bejelölve, a Firefly III elküldi a jelszó az SHA1 hashének első őt karakterét <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Troy Hunt weboldalának</a>, hogy ellenőrizze szerepel-e a listában. Ez megakadályozza, hogy nem biztonságos jelszavakat használj ahogy az a legutolsó <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a>-ban javasolják.',
    'secure_pw_should'                          => 'Kipipáljam a négyzetet?',
    'secure_pw_long_password'                   => 'Igen. Mindig ellenőrizze, hogy a jelszavam biztonságos-e.',
    'command_line_token'                        => 'Parancssori token',
    'explain_command_line_token'                => 'Erre a tokenre parancssori lehetőségek végrehajtásához van szükség, mint például adatok exportálása. Enélkül néhány érzékeny parancs nem fog működni. Ezt a tokent senki nem fogja kérni tőled, még a fejlesztő sem. A lenti gombbal újragenerálhatod, ha félsz hogy illetéktelenek kezébe került.',
    'regenerate_command_line_token'             => 'Parancssori token újragenerálása',
    'token_regenerated'                         => 'Az új parancssori token generálódott',
    'change_your_email'                         => 'Email cím módosítása',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Amíg nem ellenőrizted az email címed addig nem tudsz bejelentkezni.',
    'login_with_new_email'                      => 'Most már bejelentkezhet az új email címével.',
    'login_with_old_email'                      => 'Most már bejelentkezhet újra a régi email címével.',
    'login_provider_local_only'                 => 'Ez a művelet nem érhető el ":login_provider" általi hitelesítésekor.',
    'external_user_mgt_disabled'                => 'Ez a művelet nem elérhető, amikor a felhasználó kezelést és bejelentkeztetést nem a Firely III végzi.',
    'external_auth_disabled'                    => 'Ez a művelet nem elérhető, amikor a bejelentkeztetést nem a Firefly III végzi.',
    'delete_local_info_only'                    => "Mivel nem a Firefly III végzi a felhasználók kezelését és a bejelentkeztetést, ez a funkció csak a lokális Firefly III információkat törli.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth kliensek',
    'profile_oauth_no_clients'                  => 'Nincs létrehozva egyetlen OAuth kliens sem.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Kliensek',
    'profile_oauth_client_id'                   => 'Kliens ID',
    'profile_oauth_client_name'                 => 'Megnevezés',
    'profile_oauth_client_secret'               => 'Titkos kód',
    'profile_oauth_create_new_client'           => 'Új kliens létrehozása',
    'profile_oauth_create_client'               => 'Kliens létrehozása',
    'profile_oauth_edit_client'                 => 'Kliens szerkesztése',
    'profile_oauth_name_help'                   => 'Segítség, hogy a felhasználók tudják mihez kapcsolódik.',
    'profile_oauth_redirect_url'                => 'Átirányítási URL',
    'profile_oauth_redirect_url_help'           => 'Az alkalmazásban használt autentikációs URL.',
    'profile_authorized_apps'                   => 'Engedélyezett alkalmazások',
    'profile_authorized_clients'                => 'Engedélyezett kliensek',
    'profile_scopes'                            => 'Hatáskörök',
    'profile_revoke'                            => 'Visszavonás',
    'profile_oauth_client_secret_title'         => 'Kliens titkos kódja',
    'profile_oauth_client_secret_expl'          => 'Ez a kliens titkos kódja. Ez az egyetlen alkalom, amikor meg van jelenítve, ne hagyd el! Ezzel a kóddal végezhetsz API hívásokat.',
    'profile_personal_access_tokens'            => 'Személyes hozzáférési tokenek',
    'profile_personal_access_token'             => 'Személyes hozzáférési token',
    'profile_oauth_confidential'                => 'Bizalmas',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Here is your new personal access token. This is the only time it will be shown so don\'t lose it! You may now use this token to make API requests.',
    'profile_no_personal_access_token'          => 'Nincs létrehozva egyetlen személyes hozzáférési token sem.',
    'profile_create_new_token'                  => 'Új token létrehozása',
    'profile_create_token'                      => 'Token létrehozása',
    'profile_create'                            => 'Létrehozás',
    'profile_save_changes'                      => 'Módosítások mentése',
    'profile_whoops'                            => 'Hoppá!',
    'profile_something_wrong'                   => 'Hiba történt!',
    'profile_try_again'                         => 'Hiba történt. Kérjük, próbálja meg újra.',
    'amounts'                                   => 'Mennyiségek',
    'multi_account_warning_unknown'             => 'Depending on the type of transaction you create, the source and/or destination account of subsequent splits may be overruled by whatever is defined in the first split of the transaction.',
    'multi_account_warning_withdrawal'          => 'Keep in mind that the source account of subsequent splits will be overruled by whatever is defined in the first split of the withdrawal.',
    'multi_account_warning_deposit'             => 'Keep in mind that the destination account of subsequent splits will be overruled by whatever is defined in the first split of the deposit.',
    'multi_account_warning_transfer'            => 'Keep in mind that the source + destination account of subsequent splits will be overruled by whatever is defined in the first split of the transfer.',


    // export data:
    'export_data_title'                         => 'Adatok exportálása a Firefly III-ból',
    'export_data_menu'                          => 'Adat exportálása',
    'export_data_bc'                            => 'Adatok exportálása a Firefly III-ból',
    'export_data_main_title'                    => 'Adatok exportálása a Firefly III-ból',
    'export_data_expl'                          => 'Ezek a hivatkozások lehetővé teszik az összes tranzakció + a metaadatok exportálását a Firefly III-ból. A folyamatról további információ a súgóban ((?) ikon a jobb felső sarokban) található.',
    'export_data_all_transactions'              => 'Összes tranzakció exportálása',
    'export_data_advanced_expl'                 => 'Ha szükséged van speciális exportálásra, akkor olvass utána a következő parancssori parancsnak: <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Egy melléklet|:count melléklet',
    'attachments'                               => 'Mellékletek',
    'edit_attachment'                           => 'Melléklet szerkesztése ":name"',
    'update_attachment'                         => 'Melléklet frissítése',
    'delete_attachment'                         => '":name" melléklet törlése',
    'attachment_deleted'                        => 'Törölt melléklet ":name"',
    'liabilities_deleted'                       => '":name" kötelezettség törölve',
    'attachment_updated'                        => 'Melléklet frissítve ":name"',
    'upload_max_file_size'                      => 'Maximális fájlméret: :size',
    'list_all_attachments'                      => 'Mellékletek listája',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Költségek',
    'title_withdrawal'                          => 'Költségek',
    'title_revenue'                             => 'Jövedelem / bevétel',
    'title_deposit'                             => 'Jövedelem / bevétel',
    'title_transfer'                            => 'Átvezetések',
    'title_transfers'                           => 'Átvezetések',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Ez a tranzakció már egy költség',
    'convert_is_already_type_Deposit'           => 'Ez a tranzakció már egy bevétel',
    'convert_is_already_type_Transfer'          => 'Ez a tranzakció már egy utalás',
    'convert_to_Withdrawal'                     => '":description" költséggé konvertálása',
    'convert_to_Deposit'                        => '":description" bevétellé alakítása',
    'convert_to_Transfer'                       => 'Átutalássá alakítás ":description"',
    'convert_options_WithdrawalDeposit'         => 'Egy költség bevétellé alakítása',
    'convert_options_WithdrawalTransfer'        => 'Egy költség átvezetéssé konvertálása',
    'convert_options_DepositTransfer'           => 'Egy bevétel átvezetéssé alakítása',
    'convert_options_DepositWithdrawal'         => 'Egy bevétel költséggé konvertálása',
    'convert_options_TransferWithdrawal'        => 'Utalás kiadássá alakítása',
    'convert_options_TransferDeposit'           => 'Egy átvezetés bevétellé alakítása',
    'convert_Withdrawal_to_deposit'             => 'Költség bevétellé konvertálása',
    'convert_Withdrawal_to_transfer'            => 'Költség átvezetéssé alakítása',
    'convert_Deposit_to_withdrawal'             => 'Bevétel költséggé alakítása',
    'convert_Deposit_to_transfer'               => 'Bevétel átvezetéssé alakítása',
    'convert_Transfer_to_deposit'               => 'Átvezetés bevétellé alakítása',
    'convert_Transfer_to_withdrawal'            => 'Átvezetés költséggé konvertálása',
    'convert_please_set_revenue_source'         => 'Kérem válasszon ki egy bevételiszámlát, ahonnan a pénz fog érkezni.',
    'convert_please_set_asset_destination'      => 'Kérem válasszon ki egy eszközszámlát, ahova a pénz fog menni.',
    'convert_please_set_expense_destination'    => 'Ki kell választani egy költségszámlát, ahova a pénz fog menni.',
    'convert_please_set_asset_source'           => 'Kérem válasszon ki egy eszközszámlát, ahonnan a pénz fog érkezni.',
    'convert_expl_w_d'                          => 'When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination account, instead of being withdrawn from it.|When converting from a withdrawal to a deposit, the money will be deposited into the displayed destination accounts, instead of being withdrawn from them.',
    'convert_expl_w_t'                          => 'When converting a withdrawal into a transfer, the money will be transferred away from the source account into other asset or liability account instead of being spent on the original expense account.|When converting a withdrawal into a transfer, the money will be transferred away from the source accounts into other asset or liability accounts instead of being spent on the original expense accounts.',
    'convert_expl_d_w'                          => 'When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source account, instead of being deposited into it.|When converting a deposit into a withdrawal, the money will be withdrawn from the displayed source accounts, instead of being deposited into them.',
    'convert_expl_d_t'                          => 'When you convert a deposit into a transfer, the money will be deposited into the listed destination account from any of your asset or liability account.|When you convert a deposit into a transfer, the money will be deposited into the listed destination accounts from any of your asset or liability accounts.',
    'convert_expl_t_w'                          => 'When you convert a transfer into a withdrawal, the money will be spent on the destination account you set here, instead of being transferred away.|When you convert a transfer into a withdrawal, the money will be spent on the destination accounts you set here, instead of being transferred away.',
    'convert_expl_t_d'                          => 'When you convert a transfer into a deposit, the money will be deposited into the destination account you see here, instead of being transferred into it.|When you convert a transfer into a deposit, the money will be deposited into the destination accounts you see here, instead of being transferred into them.',
    'convert_select_sources'                    => 'A konverzió befejezéséhez be kell állítani az új forrásszámlát.|A konverzió befejezéséhez be kell állítani az új forrásszámlákat.',
    'convert_select_destinations'               => 'To complete the conversion, please select the new destination account below.|To complete the conversion, please select the new destination accounts below.',
    'converted_to_Withdrawal'                   => 'Tranzakció költséggé konvertálva',
    'converted_to_Deposit'                      => 'A tranzakció bevétellé konvertálva',
    'converted_to_Transfer'                     => 'Tranzakció átvezetéssé konvertálva',
    'invalid_convert_selection'                 => 'A kiválasztott számla már használatban van ebben a tranzakcióban vagy nem létezik.',
    'source_or_dest_invalid'                    => 'Nem találhatóak a megfelelő tranzakció részletek. A konverzió nem lehetséges.',
    'convert_to_withdrawal'                     => 'Konvertálás költséggé',
    'convert_to_deposit'                        => 'Konvertálás egy bevétellé',
    'convert_to_transfer'                       => 'Konvertálás átvezetéssé',

    // create new stuff:
    'create_new_withdrawal'                     => 'Új költség létrehozása',
    'create_new_deposit'                        => 'Új bevétel létrehozása',
    'create_new_transfer'                       => 'Új átvezetés létrehozása',
    'create_new_asset'                          => 'Új eszközszámla létrehozása',
    'create_new_liabilities'                    => 'Create new liability',
    'create_new_expense'                        => 'Új költségszámla létrehozása',
    'create_new_revenue'                        => 'Új jövedelemszámla létrehozása',
    'create_new_piggy_bank'                     => 'Új malacpersely létrehozása',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Új pénznem létrehozása',
    'store_currency'                            => 'Új pénznem tárolása',
    'update_currency'                           => 'Pénznem frissítése',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => ':name nem törölhető mert még használatban van.',
    'cannot_delete_fallback_currency'           => ':name a rendszer biztonsági pénzneme és nem törölhető.',
    'cannot_disable_currency_journals'          => ':name nem tiltható le mert még használják tranzakciók.',
    'cannot_disable_currency_last_left'         => ':name nem tiltható le mert ez az utolsó engedélyezett pénznem.',
    'cannot_disable_currency_account_meta'      => ':name nem tiltható le, mert eszközszámlákban használatban van.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => ':name nem tiltható le, mert rendszeres tranzakciókban használva van.',
    'cannot_disable_currency_available_budgets' => ':name nem tiltható le, mert rendelkezésre álló költségkeretekben használatban van.',
    'cannot_disable_currency_budget_limits'     => ':name nem tiltható le, mert költségvetési limitekben használatban van.',
    'cannot_disable_currency_current_default'   => ':name nem tiltható le, mert ez az aktuális alapértelmezett pénznem.',
    'cannot_disable_currency_system_fallback'   => ':name nem tiltható le, mert ez a rendszer alapértelmezett pénzneme.',
    'disable_EUR_side_effects'                  => 'Az euró a rendszer alapértelmezett vészhelyzeti devizaneme. Inaktiválás esetén nem várt mellékhatások lehetnek.',
    'deleted_currency'                          => 'A pénznem :name törölve lett',
    'created_currency'                          => 'Pénznem :name létrehozva',
    'could_not_store_currency'                  => 'Az új pénznem nem tárolható.',
    'updated_currency'                          => 'Pénznem :name frissítve',
    'ask_site_owner'                            => ':owner tud pénznemeket hozzáadni, törölni vagy szerkeszteni.',
    'currencies_intro'                          => 'A Firefly III különböző pénznemeket támogat amelyeket itt lehet beállítani, és engedélyezni.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Legyen alapértelmezett',
    'default_currency'                          => 'alapértelmezett',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Letiltva',
    'enable_currency'                           => 'Engedélyezés',
    'disable_currency'                          => 'Tiltás',
    'currencies_default_disabled'               => 'A pénznemek többsége alapértelmezés szerint tiltva van. A használathoz először engedélyezni kell azokat.',
    'currency_is_now_enabled'                   => 'Pénznem ":name" engedélyezve',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Pénznem ":name" letiltva',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Kötelező mezők',
    'optionalFields'                            => 'Nem kötelező mezők',
    'options'                                   => 'Beállítások',

    // budgets:
    'daily_budgets'                             => 'Daily budgets',
    'weekly_budgets'                            => 'Weekly budgets',
    'monthly_budgets'                           => 'Havi költségkeretek',
    'quarterly_budgets'                         => 'Quarterly budgets',
    'half_year_budgets'                         => 'Half-yearly budgets',
    'yearly_budgets'                            => 'Yearly budgets',
    'other_budgets'                             => 'Custom timed budgets',
    'budget_limit_not_in_range'                 => 'This amount applies from :start to :end:',
    'total_available_budget'                    => 'Teljes elérhető költségkeret (:start és :end között)',
    'total_available_budget_in_currency'        => 'Teljes elérhető költségkeret :currency pénznemben',
    'see_below'                                 => 'lásd lentebb',
    'create_new_budget'                         => 'Új költségkeret létrehozása',
    'store_new_budget'                          => 'Új költségkeret létrehozása',
    'stored_new_budget'                         => 'Új költségkeret létrehozva ":name"',
    'available_between'                         => ':start és :end között rendelkezésre áll',
    'transactionsWithoutBudget'                 => 'Költségkeret nélküli költségek',
    'transactions_no_budget'                    => 'Költségkeret nélküli költségek :start és :end között',
    'spent_between'                             => 'Már elköltött :start és :end között',
    'spent_between_left'                        => ':start és :end között :spent költöttél, így maradt :left.',
    'set_available_amount'                      => 'Rendelkezésre álló összeg beállítása',
    'update_available_amount'                   => 'Rendelkezésre álló összeg frissítése',
    'ab_basic_modal_explain'                    => 'Használja ezt az űrlapot a költségvetés beállításához (összesen, :currency devizában) a feltüntetett időszakban.',
    'createBudget'                              => 'Új költségkeret',
    'invalid_currency'                          => 'Ez egy érvénytelen pénznem',
    'invalid_amount'                            => 'Kérlek, írj be egy összeget',
    'set_ab'                                    => 'A rendelkezésre álló költségkeret összeg beéllítva',
    'updated_ab'                                => 'A rendelkezésre álló költségkeret összeg frissítve',
    'deleted_ab'                                => 'A rendelkezésre álló költségkeret összeg törölve',
    'deleted_bl'                                => 'A költségvetésbe felvett összeg el lett távolítva',
    'alt_currency_ab_create'                    => 'A rendelkezésre álló költségkeret beállítása más pénznemben',
    'bl_create_btn'                             => 'Költségkeret beállítása más pénznemben',
    'inactiveBudgets'                           => 'Inaktív költségkeretek',
    'without_budget_between'                    => 'Költségkeret nélküli tranzakció :start és :end között',
    'delete_budget'                             => '":name" költségkeret törlése',
    'deleted_budget'                            => 'Költségkeret törölve ":name"',
    'edit_budget'                               => '":name" költségkeret szerkesztése',
    'updated_budget'                            => 'Költségkeret frissítve ":name"',
    'update_amount'                             => 'Összeg frissítése',
    'update_budget'                             => 'Költségvetés frissítése',
    'update_budget_amount_range'                => 'A (várt) rendelkezésre álló összeg frissítése :start és :end között',
    'set_budget_limit_title'                    => 'Tervezett költégvetés :start és :end időszakra a(z) :budget költségvetéshez',
    'set_budget_limit'                          => 'Tervezett költségvetési összeg',
    'budget_period_navigator'                   => 'Időszak navigátor',
    'info_on_available_amount'                  => 'Mivel rendelkezem?',
    'available_amount_indication'               => 'Ezeket az összeget felhasználva lehet megtudni, hogy mekkorának kéne lennie a teljes költségkeretnek.',
    'suggested'                                 => 'Javasolt',
    'average_between'                           => 'Átlag :start és :end között',
    'transferred_in'                            => 'Átvezetett (be)',
    'transferred_away'                          => '(Máshova) átvezetett',
    'auto_budget_none'                          => 'Nincs auto-költségkeret',
    'auto_budget_reset'                         => 'Fix összeg beállítása minden időszakra',
    'auto_budget_rollover'                      => 'Összeg hozzáadása minden időszakhoz',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Napi',
    'auto_budget_period_weekly'                 => 'Heti',
    'auto_budget_period_monthly'                => 'Havi',
    'auto_budget_period_quarterly'              => 'Negyedéves',
    'auto_budget_period_half_year'              => 'Félévente',
    'auto_budget_period_yearly'                 => 'Éves',
    'auto_budget_help'                          => 'Erről a funkcióról további információ a súgóban található. A súgó a jobb felső (?) ikonra kattintva érhető el.',
    'auto_budget_reset_icon'                    => 'A költségvetés periodikusan újraszámlálódik',
    'auto_budget_rollover_icon'                 => 'A költségvetési összeg periodikusan növekszik',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Remove budgeted amount in :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Nem várható ebben az időszakban',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Nincs (még)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Ismétlődések',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Kapcsolódó tranzakciók',
    'auto_match_on'                             => 'A Firefly III által automatikusan egyeztetett',
    'auto_match_off'                            => 'A Firefly III által nem automatikusan egyeztetett',
    'next_expected_match'                       => 'Következő várható egyezés',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Több',
    'rescan_old'                                => 'Szabályok újrafuttatása az összes tranzakción',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Várható :start és :end között',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'kihagy',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inaktív szabály',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Várható dátum :date',
    'bill_expected_date_js'                     => 'Expected {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Paid on {date}',
    'bill_repeats_weekly'                       => 'Repeats weekly',
    'bill_repeats_monthly'                      => 'Repeats monthly',
    'bill_repeats_quarterly'                    => 'Repeats quarterly',
    'bill_repeats_half-year'                    => 'Repeats every half year',
    'bill_repeats_yearly'                       => 'Repeats yearly',
    'bill_repeats_weekly_other'                 => 'Repeats every other week',
    'bill_repeats_monthly_other'                => 'Repeats every other month',
    'bill_repeats_quarterly_other'              => 'Repeats every other quarter',
    'bill_repeats_half-year_other'              => 'Repeats yearly',
    'bill_repeats_yearly_other'                 => 'Repeats every other year',
    'bill_repeats_weekly_skip'                  => 'Repeats every {skip} weeks',
    'bill_repeats_monthly_skip'                 => 'Repeats every {skip} months',
    'bill_repeats_quarterly_skip'               => 'Repeats every {skip} quarters',
    'bill_repeats_half-year_skip'               => 'Repeats every {skip} half years',
    'bill_repeats_yearly_skip'                  => 'Repeats every {skip} years',
    'subscriptions'                             => 'Subscriptions',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Örökre',
    'extension_date_is'                         => 'Extension date is {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'You have :count inactive (archived) account, which you can view on this separate page.|You have :count inactive (archived) accounts, which you can view on this separate page.',
    'all_accounts_inactive'                     => 'Ezek az inaktív számlák.',
    'active_account_link'                       => 'Ez a hivatkozás visszavisz az aktív számlákhoz.',
    'account_missing_transaction'               => ':id (":name") számla nem tekinthető meg közvetlenül, de a Fireflyból hiányzik az átirányítási információ.',
    'cc_monthly_payment_date_help'              => 'Select any year and any month, it will be ignored anyway. Only the day of the month is relevant.',
    'details_for_asset'                         => '":name" eszközszámla részletei',
    'details_for_expense'                       => '":name" költségszámla részletei',
    'details_for_revenue'                       => '":name" jövedelemszámla részletei',
    'details_for_cash'                          => '":name" készpénzszámla részletei',
    'store_new_asset_account'                   => 'Új eszközszámla tárolása',
    'store_new_expense_account'                 => 'Új költségszámla tárolása',
    'store_new_revenue_account'                 => 'Új jövedelemszámla létrehozása',
    'edit_asset_account'                        => '":name" eszközszámla szerkesztése',
    'edit_expense_account'                      => '":name" költségszámla szerkesztése',
    'edit_revenue_account'                      => '":name" jövedelemszámla szerkesztése',
    'delete_asset_account'                      => '":name" eszközszámla törlése',
    'delete_expense_account'                    => '":name" költségszámla törlése',
    'delete_revenue_account'                    => '":name" jövedelemszámla törlése',
    'delete_liabilities_account'                => '":name" kötelezettség törlése',
    'asset_deleted'                             => '":name" eszközszámla sikeresen törölve',
    'account_deleted'                           => 'Successfully deleted account ":name"',
    'expense_deleted'                           => '":name" költségszámla sikeresen törölve',
    'revenue_deleted'                           => '":name" jövedelemszámla sikeresen törölve',
    'update_asset_account'                      => 'Eszközszámla frissítése',
    'update_undefined_account'                  => 'Update account',
    'update_liabilities_account'                => 'Kötelezettség frissítése',
    'update_expense_account'                    => 'Költségszámla frissítése',
    'update_revenue_account'                    => 'Jövedelemszámla frissítése',
    'make_new_asset_account'                    => 'Új eszközszámla létrehozása',
    'make_new_expense_account'                  => 'Új költségszámla létrehozása',
    'make_new_revenue_account'                  => 'Új jövedelemszámla létrehozása',
    'make_new_liabilities_account'              => 'Új kötelezettség létrehozása',
    'asset_accounts'                            => 'Eszközszámlák',
    'undefined_accounts'                        => 'Accounts',
    'asset_accounts_inactive'                   => 'Eszközszámlák (inaktív)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Költségszámlák',
    'expense_accounts_inactive'                 => 'Költségszámlák (inaktív)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Jövedelemszámlák',
    'revenue_accounts_inactive'                 => 'Revenue accounts (inactive)',
    'cash_accounts'                             => 'Készpénzszámlák',
    'Cash account'                              => 'Készpénzszámla',
    'liabilities_accounts'                      => 'Kötelezettségek',
    'liabilities_accounts_inactive'             => 'Liabilities (inactive)',
    'reconcile_account'                         => '":account" számla egyeztetése',
    'overview_of_reconcile_modal'               => 'Egyeztetés áttekintése',
    'delete_reconciliation'                     => 'Egyeztetés törlése',
    'update_reconciliation'                     => 'Egyeztetés frissítése',
    'amount_cannot_be_zero'                     => 'Az összeg nem lehet nulla',
    'end_of_reconcile_period'                   => 'Egyeztetési időszak vége: :period',
    'start_of_reconcile_period'                 => 'Egyeztetési időszak kezdete: :period',
    'start_balance'                             => 'Kezdő egyenleg',
    'end_balance'                               => 'Záró egyenleg',
    'update_balance_dates_instruction'          => 'Ha a fenti összegek és dátumok összevetése a bankszámlakivonattal megtörtént, az "Egyeztetés indítása" gombra kell kattintani',
    'select_transactions_instruction'           => 'A bankszámlakivonaton szereplő tranzakciók kiválasztása.',
    'select_range_and_balance'                  => 'Először ellenőrizd a dátum időszakot és az egyenlegeket. Utána nyomd meg az "Egyeztetés indítása" gombot',
    'date_change_instruction'                   => 'Az időintervallum megváltoztatásával minden előrehaladás el fog veszni.',
    'update_selection'                          => 'Kiválasztás frissítése',
    'store_reconcile'                           => 'Egyeztetés letárolása',
    'reconciliation_transaction'                => 'Tranzakció egyeztetése',
    'Reconciliation'                            => 'Egyeztetés',
    'reconciliation'                            => 'Egyeztetés',
    'reconcile_options'                         => 'Egyeztetés beállításai',
    'reconcile_range'                           => 'Egyeztetés időszaka',
    'start_reconcile'                           => 'Egyeztetés indítása',
    'cash_account_type'                         => 'Készpénz',
    'cash'                                      => 'készpénz',
    'cant_find_redirect_account'                => 'A Firefly III megpróbálkozott az átirányítással de az nem sikerült. Elnézést kérünk. Vissza a kezdőlapra.',
    'account_type'                              => 'Bankszámla típusa',
    'save_transactions_by_moving'               => 'Save this transaction by moving it to another account:|Save these transactions by moving them to another account:',
    'save_transactions_by_moving_js'            => 'No transactions|Save this transaction by moving it to another account. |Save these transactions by moving them to another account.',
    'stored_new_account'                        => '":name" új számla letárolva!',
    'stored_new_account_js'                     => 'New account "<a href="accounts/show/{ID}">{name}</a>" stored!',
    'updated_account'                           => '":name" számla frissítve',
    'updated_account_js'                        => 'Updated account "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Hitelkártya opciók',
    'no_transactions_account'                   => 'Nincsenek tranzakciók (ebben az időszakban) az eszközszámlához: ":name".',
    'no_transactions_period'                    => 'Nincsenek tranzakció ebben az időszakban.',
    'no_data_for_chart'                         => 'Nincs elegendő információ (még) a diagram létrehozásához.',
    'select_at_least_one_account'               => 'Kérem, jelöljön ki legalább egy eszközszámlát',
    'select_at_least_one_category'              => 'Legalább egy kategóriát ki kell választani',
    'select_at_least_one_budget'                => 'Legalább egy költségkeretet ki kell választani',
    'select_at_least_one_tag'                   => 'Legalább egy címkét ki kell választani',
    'select_at_least_one_expense'               => 'Legalább egy költség- jövedelemszámla kombinációt ki kell választani. Ha nincs egy sem (a lista üres), ez a jelenés nem érhető el.',
    'account_default_currency'                  => 'Ez az ehhez a számlához társított alapértelmezett pénznem.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'A Firefly III főkönyvben több pénz van mint amennyinek a bank szerint lennie kellene. Több lehetőség van. Ki kell választani mi történjen. Ezután az "Egyeztetés megerősítése" gombra kell kattintani.',
    'reconcile_has_less'                        => 'A Firefly III főkönyvben kevesebb pénz van mint amennyinek a bank szerint lennie kellene. Több lehetőség van. Ki kell választani mi történjen. Ezután az "Egyeztetés megerősítése" gombra kell kattintani.',
    'reconcile_is_equal'                        => 'A Firefly III főkönyv és a bankszámlakivonatok egyeznek. Nem kell semmit sem tenni. Az importálás megerősítéséhez az "Egyeztetés megerősítése" gombra kell kattintani.',
    'create_pos_reconcile_transaction'          => 'A kiválasztott tranzakciók törlése és egy korrekció létrehozása :amount hozzáadásával ehhez az eszközszámlához.',
    'create_neg_reconcile_transaction'          => 'A kiválasztott tranzakciók törlése, és egy korrekció létrehozása :amount eltávolításával az eszközszámláról.',
    'reconcile_do_nothing'                      => 'Kijelölt tranzakciók ürítése, javítás nélkül.',
    'reconcile_go_back'                         => 'Egy korrekció később bármikor szerkeszthető vagy törölhető.',
    'must_be_asset_account'                     => 'Csak eszközszámlákat lehet egyeztetni',
    'reconciliation_stored'                     => 'Egyeztetés letárolva',
    'reconciliation_error'                      => 'Hiba miatt a tranzakciók meg lettek jelölve egyeztetésre, de az egyeztetés nem lett eltárolva: :error.',
    'reconciliation_transaction_title'          => 'Egyeztetés (:from - :to)',
    'sum_of_reconciliation'                     => 'Egyeztetés összege',
    'reconcile_this_account'                    => 'Számla egyeztetése',
    'reconcile'                                 => 'Egyeztetés',
    'show'                                      => 'Mutat',
    'confirm_reconciliation'                    => 'Számla megerősítése',
    'submitted_start_balance'                   => 'Beküldött kezdő egyenleg',
    'selected_transactions'                     => 'Kiválasztott tranzakciók (:count)',
    'already_cleared_transactions'              => 'Már törölt tranzakciók (:count)',
    'submitted_end_balance'                     => 'Beküldött záró egyenleg',
    'initial_balance_description'               => '":account" kezdeti egyenlege',
    'liability_credit_description'              => 'Liability credit for ":account"',
    'interest_calc_'                            => 'ismeretlen',
    'interest_calc_daily'                       => 'Naponta',
    'interest_calc_monthly'                     => 'Havonta',
    'interest_calc_yearly'                      => 'Évente',
    'interest_calc_weekly'                      => 'Hetente',
    'interest_calc_half-year'                   => 'Félévente',
    'interest_calc_quarterly'                   => 'Negyedévente',
    'initial_balance_account'                   => ':account kezdeti egyenlegfiókja',
    'list_options'                              => 'List options',
    'account_column_opt_drag_and_drop'          => 'Fogd és vidd',
    'account_column_opt_active'                 => 'Aktív',
    'account_column_opt_name'                   => 'Név',
    'account_column_opt_type'                   => 'Típus',
    'account_column_opt_liability_type'         => 'Kötelezettség típusa',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Legutóbbi tevékenység',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menü',

    // categories:
    'new_category'                              => 'Új kategória',
    'create_new_category'                       => 'Új kategória létrehozása',
    'without_category'                          => 'Kategória nélkül',
    'update_category'                           => 'Kategória frissítése',
    'updated_category'                          => '":name" kategória frissítve',
    'categories'                                => 'Kategóriák',
    'edit_category'                             => '":name" kategória szerkesztése',
    'no_category'                               => '(nincs kategória)',
    'unknown_category_plain'                    => 'Nincs kategória',
    'category'                                  => 'Kategória',
    'delete_category'                           => '":name" kategória törlése',
    'deleted_category'                          => '":name" kategória törlése',
    'store_category'                            => 'Új kategória tárolása',
    'stored_category'                           => 'Új kategória létrehozva ":name"',
    'without_category_between'                  => 'Kategória nélkül :start és :end között',


    // transactions:
    'wait_loading_transaction'                  => 'Kérlek várj az űrlap betöltéséig',
    'wait_loading_data'                         => 'Kérlek várj amíg betöltjük az adatokat...',
    'wait_attachments'                          => 'Kérlek várj a mellékletek feltöltésére.',
    'errors_upload'                             => 'A feltöltés sikertelen. A hibáért kérlek, ellenőrizd a böngésző konzolt.',
    'amount_foreign_if'                         => 'Összeg devizában, ha van ilyen',
    'amount_destination_account'                => 'Összeg a célszámla pénznemében',
    'edit_transaction_title'                    => 'Tranzakció módosítása ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Költség frissítése',
    'update_deposit'                            => 'Bevétel szerkesztése',
    'update_transaction'                        => 'Tranzakció frissítése',
    'update_transfer'                           => 'Utalás szerkesztése',
    'updated_withdrawal'                        => 'Költség frissítve ":description"',
    'updated_deposit'                           => '":description" bevétel frissítve',
    'updated_transfer'                          => 'Átvezetés frissítve ":description"',
    'no_changes_withdrawal'                     => 'Withdrawal ":description" was not changed.',
    'no_changes_deposit'                        => 'Deposit ":description" was not changed.',
    'no_changes_transfer'                       => 'Transfer ":description" was not changed.',
    'delete_withdrawal'                         => 'Költség törölve ":description"',
    'delete_deposit'                            => '":description" bevétel törlése',
    'delete_transfer'                           => 'Átvezetés törlése ":description"',
    'deleted_withdrawal'                        => 'A költség sikeresen törölve ":description"',
    'deleted_deposit'                           => '":description" bevétel sikeresen törölve',
    'deleted_transfer'                          => '":description" átvezetés sikeresen törölve',
    'deleted_reconciliation'                    => '":description" egyeztető tranzakció sikeresen törölve',
    'stored_journal'                            => '":description" új tranzakció sikeresen létrehozva',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Új tranzakció sikeresen létrehozva',
    'updated_journal_no_descr'                  => 'Tranzakció sikeresen frissítve',
    'select_transactions'                       => 'Tranzakciók kiválasztása',
    'rule_group_select_transactions'            => '":title" alkalmazása tranzakciókon',
    'rule_select_transactions'                  => '":title" alkalmazása tranzakciókon',
    'stop_selection'                            => 'Tranzakciók kiválasztásának leállítása',
    'reconcile_selected'                        => 'Egyeztetés',
    'mass_delete_journals'                      => 'Több tranzakció törlése',
    'mass_edit_journals'                        => 'Több tranzakció szerkesztése',
    'mass_bulk_journals'                        => 'Több tranzakció tömeges szerkesztése',
    'mass_bulk_journals_explain'                => 'Az űrlap segítségévle egyszerre lehet több tranzakció tulajdonságát is módosítani. Az űrlapon szereplő minden egyes tranzakció frissítve lesz azokkal a tulajdonságokkal, amelyek a táblázatban megtalálhatóak.',
    'part_of_split'                             => 'Ez a tranzakció egy része egy felosztott tranzakciónak. Ha nincs a tranzakcióhoz tartozó összes rész kiválasztva, úgy csak a résztranzakció fog módosulni.',
    'bulk_set_new_values'                       => 'Új értékeket a lenti mezőkben lehet megadni. Üresen hagyva mindig üresek lesznek. Fontos tudni, hogy csak a költségekhez lesz költségkeret rendelve.',
    'no_bulk_category'                          => 'Ne frissítse a kategóriát',
    'no_bulk_budget'                            => 'Ne frissítse a költségkeretet',
    'no_bulk_tags'                              => 'Ne frissítse a cimké(ke)t',
    'replace_with_these_tags'                   => 'Címkék cseréje',
    'append_these_tags'                         => 'Címkék hozzáadása',
    'mass_edit'                                 => 'Kijelöltek szerkesztése egyesével',
    'bulk_edit'                                 => 'Kijelöltek tömeges szerkesztése',
    'mass_delete'                               => 'Kijelöltek törlése',
    'cannot_edit_other_fields'                  => 'Ezeken kívül nem lehet más mezőket tömegesen szerkeszteni, mert nincs elég hely a megjelenítésükhöz. Ha szerkeszteni kell ezeket a mezőket, a hivatkozás használatával lehet megtenni egyesével.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(nincs költségkeret)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Számla költségkeret szerint',
    'account_per_category'                      => 'Számal kategória szerint',
    'create_new_object'                         => 'Létrehozás',
    'empty'                                     => '(üres)',
    'all_other_budgets'                         => '(minden más költségkeret)',
    'all_other_accounts'                        => '(minden más számla)',
    'expense_per_source_account'                => 'Költségek forrásszámla szerint',
    'expense_per_destination_account'           => 'Költségek célszámla szerint',
    'income_per_destination_account'            => 'Bevétel célszámla szerint',
    'spent_in_specific_category'                => '":category" kategóriában elköltve',
    'earned_in_specific_category'               => '":category" kategóriában megkeresve',
    'spent_in_specific_tag'                     => '":tag" címkében elköltve',
    'earned_in_specific_tag'                    => '":tag" címkében megkeresve',
    'income_per_source_account'                 => 'Bevétel forrásszámla szerint',
    'average_spending_per_destination'          => 'Átlagos költség célszámla szerint',
    'average_spending_per_source'               => 'Átlagos költség forrásszámla alapján',
    'average_earning_per_source'                => 'Átlagos bevétel forrásszámlánként',
    'average_earning_per_destination'           => 'Átlagos bevétel célszámlánként',
    'account_per_tag'                           => 'Számla címke alapján',
    'tag_report_expenses_listed_once'           => 'Bevételek és kiadások sosem kerülnek egyszerre kilistázásra. Ha a tranzakciónak több címkéje is van, akkor csak egyetlen címke alatt lesz megtalálható. A lista lehet, hogy nem tartalmaz minden egyes elemet, de a végösszeg helyes.',
    'double_report_expenses_charted_once'       => 'Bevételek és kiadások sosem kerülnek egyszerre kilistázásra. Ha a tranzakciónak több címkéje is van, akkor csak egyetlen címke alatt lesz megtalálható. A lista lehet, hogy nem tartalmaz minden egyes elemet, de a végösszeg helyes.',
    'tag_report_chart_single_tag'               => 'A táblázat egyetlen címkére értendő. Ha a tranzakciónak több címkéje is van, akkor más címkékhez tartozó táblázatokban is meg fog jelenni.',
    'tag'                                       => 'Címke',
    'no_budget_squared'                         => '(nincs költségkeret)',
    'perm-delete-many'                          => 'Egyszerre több elem törlése zavaró lehet. Legyen elővigyázatos. Felosztott tranzakciók egyes elemei is törölhetőek erről a lapról.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(nincs számlatípus)',
    'opt_group_no_account_type'                 => '(nincs számlatípus)',
    'opt_group_defaultAsset'                    => 'Alapértelmezett eszközszámlák',
    'opt_group_savingAsset'                     => 'Megtakarítási számlák',
    'opt_group_sharedAsset'                     => 'Megosztott eszközszámlák',
    'opt_group_ccAsset'                         => 'Hitelkártyák',
    'opt_group_cashWalletAsset'                 => 'Készpénz',
    'opt_group_expense_account'                 => 'Költségszámlák',
    'opt_group_revenue_account'                 => 'Jövedelemszámlák',
    'opt_group_l_Loan'                          => 'Kötelezettség: hitel',
    'opt_group_cash_account'                    => 'Készpénzszámla',
    'opt_group_l_Debt'                          => 'Kötelezettség: adósság',
    'opt_group_l_Mortgage'                      => 'Kötelezettség: jelzálog',
    'opt_group_l_Credit card'                   => 'Kötelezettség: hitelkártya',
    'notes'                                     => 'Megjegyzések',
    'view_notes'                                => 'Megjegyzések megtekintése',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Megjegyzések szerkesztése',
    'update_bl_notes'                           => 'Megjegyzések frissítése',
    'unknown_journal_error'                     => 'Nem lehet letárolni a tranzakciót. Ellenőrizni kell a naplófájlokat.',
    'attachment_not_found'                      => 'Ez a melléklet nem található.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaction #{ID} ("{title}")</a> mentve.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaction #{ID}</a> mentve.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") has been updated.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaction #{ID}</a> ("{title}") did not receive any changes.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Spent {amount} of {total}',

    // new user:
    'welcome'                                   => 'Üdvözöli a Firefly III!',
    'submit'                                    => 'Beküldés',
    'submission'                                => 'Feliratkozás',
    'submit_yes_really'                         => 'Beküldés (tudom mit csinálok)',
    'getting_started'                           => 'Első lépések',
    'to_get_started'                            => 'Gratulálunk a Firefly III sikeres telepítéséhez. A használat megkezdéséhez meg kell adni a bank nevét és a főszámla egyenlegét. Semmi probléma ha több bankszámlát is kezelni kell, ezeket később hozzá lehet adni. Most csak a Firefly III használatának elkezdéséhez szükséges néhány adatot kell megadni.',
    'savings_balance_text'                      => 'A Firefly III automatikusan létrehoz egy megtakarítási számlát. Alapértelmezés szerint pénz nem lesz a megtakarítási számlán, de megadható a Firefly III-nak egy mérleg, ami el lesz tárolva.',
    'finish_up_new_user'                        => 'Kész is! A továbblépéshez a <strong>Beküldés</strong> gombra kell kattintani. A gombra kattintás után megnyílik a Firefly III kezdőlapja.',
    'stored_new_accounts_new_user'              => 'Hurrá! Az új bankszámlák tárolva lettek.',
    'set_preferred_language'                    => 'Ha más nyelven szeretnéd használni a Firefly III-at, kérjük jelezd itt.',
    'language'                                  => 'Nyelv',
    'new_savings_account'                       => ':bank_name megtakarítási számla',
    'cash_wallet'                               => 'Készpénz',
    'currency_not_present'                      => 'Ne aggódj ha az általad normál esetben használt pénznem nincs a listában. Létrehozhatod a saját pénznemedet a Beállítások -> Pénznemek alatt.',

    // home page:
    'transaction_table_description'             => 'Tranzakciókat tartalmazó táblázat',
    'opposing_account'                          => 'Ellenoldali számla',
    'yourAccounts'                              => 'Bankszámlák',
    'your_accounts'                             => 'Számla áttekintése',
    'category_overview'                         => 'Kategória áttekintés',
    'expense_overview'                          => 'Költségszámla áttekintése',
    'revenue_overview'                          => 'Jövedelemszámla áttekintése',
    'budgetsAndSpending'                        => 'Költségkeretek és kiadások',
    'budgets_and_spending'                      => 'Költségkeretek és kiadások',
    'go_to_budget'                              => 'Ugrás költségkerethez "{budget}"',
    'go_to_deposits'                            => 'Ugrás a bevételekre',
    'go_to_expenses'                            => 'Ugrás a kiadásokra',
    'savings'                                   => 'Magtakarítások',
    'newWithdrawal'                             => 'Új költség',
    'newDeposit'                                => 'Új bevétel',
    'newTransfer'                               => 'Új átvezetés',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Naponta',
    'left_to_spend_per_day'                     => 'Naponta elkölthető',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Egyéni időszak',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Select a period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Pénznem',
    'preferences'                               => 'Beállítások',
    'logout'                                    => 'Kijelentkezés',
    'logout_other_sessions'                     => 'Minden más munkamenet kijelentkeztetése',
    'toggleNavigation'                          => 'Navigációs mód átkapcsolása',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Keresés...',
    'version'                                   => 'Verzió',
    'dashboard'                                 => 'Műszerfal',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'Nincs költségkeret',
    'available_budget'                          => 'Rendelkezésre álló költségkeret ({currency})',
    'currencies'                                => 'Pénznemek',
    'activity'                                  => 'Tevékenység',
    'usage'                                     => 'Használat',
    'accounts'                                  => 'Számlák',
    'Asset account'                             => 'Eszközszámla',
    'Default account'                           => 'Eszközszámla',
    'Expense account'                           => 'Költségszámla',
    'Revenue account'                           => 'Jövedelemszámla',
    'Initial balance account'                   => 'Számla kezdeti egyenlege',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Adósság',
    'account_type_Loan'                         => 'Hitel',
    'account_type_Mortgage'                     => 'Jelzálog',
    'account_type_debt'                         => 'Debt',
    'account_type_loan'                         => 'Loan',
    'account_type_mortgage'                     => 'Mortgage',
    'account_type_Credit card'                  => 'Hitelkártya',
    'credit_card_type_monthlyFull'              => 'Full payment every month',
    'liability_direction_credit'                => 'I am owed this debt',
    'liability_direction_debit'                 => 'I owe this debt to somebody else',
    'liability_direction_credit_short'          => 'Owed this debt',
    'liability_direction_debit_short'           => 'Owe this debt',
    'liability_direction__short'                => 'Ismeretlen',
    'liability_direction_null_short'            => 'Ismeretlen',
    'Liability credit'                          => 'Liability credit',
    'budgets'                                   => 'Költségkeretek',
    'tags'                                      => 'Címkék',
    'reports'                                   => 'Jelentések',
    'transactions'                              => 'Tranzakciók',
    'expenses'                                  => 'Költségek',
    'income'                                    => 'Jövedelem / bevétel',
    'transfers'                                 => 'Átvezetések',
    'moneyManagement'                           => 'Pénzkezelés',
    'money_management'                          => 'Pénzkezelés',
    'tools'                                     => 'Eszközök',
    'piggyBanks'                                => 'Malacperselyek',
    'piggy_banks'                               => 'Malacperselyek',
    'amount_x_of_y'                             => '{current} / {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Költség',
    'opening_balance'                           => 'Nyitó egyenleg',
    'deposit'                                   => 'Bevétel',
    'account'                                   => 'Bankszámla',
    'transfer'                                  => 'Átvezetés',
    'Withdrawal'                                => 'Költség',
    'Deposit'                                   => 'Bevétel',
    'Transfer'                                  => 'Átvezetés',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Igen',
    'no'                                        => 'Nem',
    'amount'                                    => 'Összeg',
    'overview'                                  => 'Áttekintés',
    'saveOnAccount'                             => 'Megtakarítás a számlán:',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Ismeretlen',
    'monthly'                                   => 'Havi',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Hibák',
    'debt_start_date'                           => 'Adósság kezdete',
    'debt_start_amount'                         => 'Adósság kezdeti összege',
    'debt_start_amount_help'                    => 'A legjobb ezt az összeget negatívra állítani. Olvassa el a súgót (a kérdőjel-ikon a jobb felső sarokban) további információkért.',
    'interest_period_help'                      => 'Ez kizárólag kozmetikázásra használt mező, nem fog a számláláshoz hozzáadódni. Mint kiderült, a bankok néha sunyik és a Firefly III tévedhet.',
    'store_new_liabilities_account'             => 'Új kötelezettség eltárolása',
    'edit_liabilities_account'                  => '":name" kötelezettség szerkesztése',
    'financial_control'                         => 'Pénzügyi felügyelet',
    'accounting'                                => 'Számlázás',
    'automation'                                => 'Automatizálás',
    'others'                                    => 'Egyebek',
    'classification'                            => 'Besorolás',
    'store_transaction'                         => 'Store transaction',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Alapértelmezett pénzügyi jelentés :start és :end között',
    'report_audit'                              => 'Tranzakciótörténet áttekintése :start és :end között',
    'report_category'                           => 'Kategória jelentés :start és :end között',
    'report_double'                             => 'Költség- jövedelemszámla jelentés :start és :end között',
    'report_budget'                             => 'Költségkeret jelentés :start és :end között',
    'report_tag'                                => 'Címke jelentés :start és :end között',
    'quick_link_reports'                        => 'Gyorshivatkozások',
    'quick_link_examples'                       => 'Itt csak az indulást segítő néhány példa hivatkozás található. A súgó oldalakon, a (?) ikon alatt, további információ található a jelentésekről és a használható mágikus szavakról.',
    'quick_link_default_report'                 => 'Alapértelmezett pénzügyi jelentés',
    'quick_link_audit_report'                   => 'Tranzakciótörténeti áttekintés',
    'report_this_month_quick'                   => 'Aktuális hónap, minden bankszámla',
    'report_last_month_quick'                   => 'Utolsó hónap, minden számla',
    'report_this_year_quick'                    => 'Folyó év, minden bankszámla',
    'report_this_fiscal_year_quick'             => 'Jelenlegi pénzügyi év, minden bankszámla',
    'report_all_time_quick'                     => 'Mindig, minden számla',
    'reports_can_bookmark'                      => 'A jelentéseket meg lehet jelölni könyvjelzővel.',
    'incomeVsExpenses'                          => 'Bevételek - Költségek',
    'accountBalances'                           => 'Számla egyenlegek',
    'balanceStart'                              => 'Egyenleg az időszak kezdetén',
    'balanceEnd'                                => 'Egyenleg az időszak végén',
    'splitByAccount'                            => 'Bankszámlákra osztva',
    'coveredWithTags'                           => 'Címkékkel fedezve',
    'leftInBudget'                              => 'Költségkeretből maradt',
    'left_in_debt'                              => 'Amount due',
    'sumOfSums'                                 => 'Összegek összege',
    'noCategory'                                => '(nincs kategória)',
    'notCharged'                                => 'Nem változott (még)',
    'inactive'                                  => 'Inaktív',
    'active'                                    => 'Aktív',
    'difference'                                => 'Különbség',
    'money_flowing_in'                          => 'Be',
    'money_flowing_out'                         => 'Ki',
    'topX'                                      => 'top :number',
    'show_full_list'                            => 'Teljes lista megjelenítése',
    'show_only_top'                             => 'Csak a top mutatása: :number',
    'report_type'                               => 'Jelentés típusa',
    'report_type_default'                       => 'Alapértelmezett pénzügyi jelentés',
    'report_type_audit'                         => 'Tranzakciótörténeti áttekintés (auditálás)',
    'report_type_category'                      => 'Kategória jelentés',
    'report_type_budget'                        => 'Költségkeret jelentés',
    'report_type_tag'                           => 'Címke jelentés',
    'report_type_double'                        => 'Költség- jövedelemszámla jelentés',
    'more_info_help'                            => 'Ezekkel a jelentéstípusokkal kapcsolatban további információ található a súgóoldalakon. A súgó a jobb felső sarokban található (?) ikonra kattintva érhető el.',
    'report_included_accounts'                  => 'Befoglalt számlák',
    'report_date_range'                         => 'Dátum intervallum',
    'report_preset_ranges'                      => 'Előre beállított intervallumok',
    'shared'                                    => 'Megosztott',
    'fiscal_year'                               => 'Pénzügyi év',
    'income_entry'                              => '":name" bevételei :start és :end között',
    'expense_entry'                             => '":name" számla kiadásai :start és :end között',
    'category_entry'                            => '":name" kategória kiadásai és bevételei :start és :end között',
    'budget_spent_amount'                       => '":budget" költségkeret kiadásai :start és :end között',
    'balance_amount'                            => '":budget" költségkeret ":account" számláról fizetett kiadásai :start és :end között',
    'no_audit_activity'                         => '<a href=":url" title=":account_name">:account_name</a> számlán nem volt aktivitás :start és :end között.',
    'audit_end_balance'                         => '<a href=":url" title=":account_name">:account_name</a> számlaegyenlege :end végén :balance volt',
    'reports_extra_options'                     => 'További beállítások',
    'report_has_no_extra_options'               => 'Ennek a jelentésnek nincsenek további beállításai',
    'reports_submit'                            => 'Jelentés megtekintése',
    'end_after_start_date'                      => 'A jelentés végdátumának a kezdődátum után kell lennie.',
    'select_category'                           => 'Kategóriák kiválasztása',
    'select_budget'                             => 'Költségkeretek kiválasztása.',
    'select_tag'                                => 'Címkék kiválasztása.',
    'income_per_category'                       => 'Bevétel kategória szerint',
    'expense_per_category'                      => 'Költség kategória szerint',
    'expense_per_budget'                        => 'Költség költségkeret szerint',
    'income_per_account'                        => 'Bevétel bankszámla szerint',
    'expense_per_account'                       => 'Költség bankszámlák szerint',
    'expense_per_tag'                           => 'Költség címke szerint',
    'income_per_tag'                            => 'Bevétel címke szerint',
    'include_expense_not_in_budget'             => 'A kiválasztott költségkeretekben nem szereplő költségeket is beleértve',
    'include_expense_not_in_account'            => 'A kiválasztott számlákban nem szereplő költségeket is beleértve',
    'include_expense_not_in_category'           => 'A kiválasztott kategóriákban nem szereplő költségeket is beleértve',
    'include_income_not_in_category'            => 'A kiválasztott kategóriákban nem szereplő bevételeket is beleértve',
    'include_income_not_in_account'             => 'A kiválasztott számlákban nem szereplő bevételeket is beleértve',
    'include_income_not_in_tags'                => 'A kiválasztott címkékben nem szereplő bevételeket is beleértve',
    'include_expense_not_in_tags'               => 'A kiválasztott címkékben nem szereplő költségeket is beleértve',
    'everything_else'                           => 'Minden más',
    'income_and_expenses'                       => 'Bevételek és költségek',
    'spent_average'                             => 'Költés (átlag)',
    'income_average'                            => 'Bevétel (átlag)',
    'transaction_count'                         => 'Tranzakciók száma',
    'average_spending_per_account'              => 'Átlagos kiadások bankszámlák szerint',
    'average_income_per_account'                => 'Átlagos bevétel címke szerint',
    'total'                                     => 'Össszesen',
    'description'                               => 'Leírás',
    'sum_of_period'                             => 'Időszak összege',
    'average_in_period'                         => 'Átlag az időszakban',
    'no_account_role'                           => '(nincs szerepkör)',
    'account_role_defaultAsset'                 => 'Alapértelmezett eszközszámla',
    'account_role_sharedAsset'                  => 'Megosztott eszközszámla',
    'account_role_savingAsset'                  => 'Megtakarítási számla',
    'account_role_ccAsset'                      => 'Hitelkártya',
    'account_role_cashWalletAsset'              => 'Készpénz',
    'budget_chart_click'                        => 'A diagram megjelenítéséhez egy költségkeret nevére kell kattintani a fenti táblázatban.',
    'category_chart_click'                      => 'A diagram megjelenítéséhez egy kategória nevére kell kattintani a fenti táblázatban.',
    'in_out_accounts'                           => 'Megkeresett és költött kombinációként',
    'in_out_accounts_per_asset'                 => 'Bevételek és kiadások (számlánként)',
    'in_out_per_category'                       => 'Megkeresett és költött kategóriaként',
    'out_per_budget'                            => 'Kiadás költségkeret szerint',
    'select_expense_revenue'                    => 'Költség- jövedelemszámla kiválasztása',
    'multi_currency_report_sum'                 => 'Mivel a lista több eltérő pénznemet használó számlát tartalmaz, az összegeknek nem lesz értelme. A jelentés mindig az alapértelmezés szerinti pénznemet fogja használni.',
    'sum_in_default_currency'                   => 'Az összeg mindig az alapértelmezett pénznemben lesz.',
    'net_filtered_prefs'                        => 'Ezen a diagramon sose fognak szerepelni azok a számlák melyeknél a "Befoglalva a nettó értékbe" beállítás nincs bekapcsolva.',


    // charts:
    'chart'                                     => 'Diagram',
    'month'                                     => 'Hónap',
    'budget'                                    => 'Költségkeret',
    'spent'                                     => 'Elköltött',
    'spent_capped'                              => 'Elköltve (korlátozva)',
    'spent_in_budget'                           => 'Költségkeretből elköltve',
    'left_to_spend'                             => 'Elkölthető',
    'earned'                                    => 'Megkeresett',
    'overspent'                                 => 'Túlköltött',
    'left'                                      => 'Maradvány',
    'max-amount'                                => 'Maximális összeg',
    'min-amount'                                => 'Minimális összeg',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Név',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Dátum',
    'date_and_time'                             => 'Dátum és idő',
    'time'                                      => 'Idő',
    'paid'                                      => 'Kifizetve',
    'unpaid'                                    => 'Nincs fizetve',
    'day'                                       => 'Nap',
    'budgeted'                                  => 'Betervezett',
    'period'                                    => 'Időszak',
    'balance'                                   => 'Egyenleg',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Összesen',
    'summary'                                   => 'Összefoglaló',
    'average'                                   => 'Átlag',
    'balanceFor'                                => 'Egyenleg: :name',
    'no_tags'                                   => '(nincsenek címkék)',
    'nothing_found'                             => '(nincs találat)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Oldalbeállítások',
    'visible_columns'               => 'Látható oszlopok',
    'accounts_to_show'              => 'Megjelenített számlák',
    'active_accounts_only'          => 'Csak az aktív számlák',
    'in_active_accounts_only'       => 'Csak az inaktív számlák',
    'show_all_accounts'             => 'Minden számla megjelenítése',
    'group_accounts'                => 'Csoportszámlák',

    // piggy banks:
    'event_history'                 => 'Eseménytörténet',
    'add_money_to_piggy'            => 'Pénz hozzáadása ":name" malacperselyhez',
    'piggy_bank'                    => 'Malacpersely',
    'new_piggy_bank'                => 'Új malacpersely',
    'store_piggy_bank'              => 'Új malacpersely tárolása',
    'stored_piggy_bank'             => 'Új ":name" malacpersely eltárolva',
    'account_status'                => 'Számla állapota',
    'left_for_piggy_banks'          => 'Maradt a malacperselyeknek',
    'sum_of_piggy_banks'            => 'Malacperselyek összesen',
    'saved_so_far'                  => 'Megtakarítás eddig',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Megtakarítható',
    'suggested_amount'              => 'Javasolt havi megtakarítási összeg',
    'add_money_to_piggy_title'      => 'Pénz elhelyezése ":name" malacperselyben',
    'remove_money_from_piggy_title' => 'Pénz kivétele ":name" malacperselyből',
    'add'                           => 'Hozzáadás',
    'no_money_for_piggy'            => 'Nincs pénz amit be lehetne tenni ebbe a malacperselybe.',
    'suggested_savings_per_month'   => 'Havonként javasolt',

    'remove'                    => 'Eltávolítás',
    'max_amount_add'            => 'A maximálisan hozzáadható összeg',
    'max_amount_remove'         => 'A maximálisan kivehető összeg',
    'update_piggy_button'       => 'Malacpersely frissítése',
    'update_piggy_title'        => '":name" malacpersely frissítése',
    'updated_piggy_bank'        => '":name" malacpersely frissítve',
    'details'                   => 'Részletek',
    'events'                    => 'Események',
    'target_amount'             => 'Cél összeg',
    'start_date'                => 'Kezdő dátum',
    'no_start_date'             => 'Nincs kezdő dátum',
    'target_date'               => 'Cél dátum',
    'no_target_date'            => 'Nincs kezdő dátuma',
    'table'                     => 'Táblázat',
    'delete_piggy_bank'         => '":name" malacpersely törlése',
    'cannot_add_amount_piggy'   => ':amount nem adható hozzá ehhez: ":name".',
    'cannot_remove_from_piggy'  => ':amount nem távolítható el innen: ":name".',
    'deleted_piggy_bank'        => '":name" malacpersely törölve',
    'added_amount_to_piggy'     => ':amount hozzáadva ehhez: ":name"',
    'removed_amount_from_piggy' => ':amount eltávolítva innen: ":name"',
    'piggy_events'              => 'Kapcsolódó Malacperselyek',

    // tags
    'delete_tag'                => '":tag" címke törlése',
    'deleted_tag'               => '":tag" címke törölve',
    'new_tag'                   => 'Új címke készítése',
    'edit_tag'                  => '":tag" címke szerkesztése',
    'updated_tag'               => '":tag" címke frissítve',
    'created_tag'               => '":tag" címke létrehozva!',

    'transaction_journal_information'               => 'Tranzakciós információk',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Meta-információ',
    'transaction_journal_more'                      => 'További információ',
    'basic_journal_information'                     => 'Basic transaction information',
    'transaction_journal_extra'                     => 'Extra information',
    'att_part_of_journal'                           => 'Eltárolva ":journal" alatt',
    'total_amount'                                  => 'Teljes összeg',
    'number_of_decimals'                            => 'Tizedesjegyek száma',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Új felhasználó meghívása',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email cím',
    'invite_user'                                   => 'Felhasználó meghívása',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Adminisztráció',
    'system_settings'                               => 'Rendszerbeállítások',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Felhasználók adminisztrálása',
    'list_all_users'                                => 'Összes felhasználó',
    'all_users'                                     => 'Összes felhasználó',
    'instance_configuration'                        => 'Beállítás',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'Egyfelhasználós mód',
    'setting_single_user_mode_explain'              => 'Alapértelmezetten Firefly III kizárólag egy felhasználót enged regisztrálni. Ez egy szándékos biztonsági lépés, megakadályozva azt, hogy esetleg más is hozzáférjen a privát adataihoz. További regisztrációk ezen az eszközön tiltottak. Amikor ezt a jelölőt kikattintja, úgy mások is hozzáférhetnek az eszköz adataihoz (ha van internetkapcsolat).',
    'store_configuration'                           => 'Beállítás tárolása',
    'single_user_administration'                    => ':email felhasználó adminisztrációja',
    'edit_user'                                     => ':email felhasználó szerkesztése',
    'hidden_fields_preferences'                     => 'A <a href="preferences">beállításokban</a> több mező is engedélyezhető.',
    'user_data_information'                         => 'Felhasználói adatok',
    'user_information'                              => 'Felhasználó információk',
    'total_size'                                    => 'teljes méret',
    'budget_or_budgets'                             => ':count költségkeret|:count költségkeret',
    'budgets_with_limits'                           => ':count budget with configured amount|:count budgets with configured amount',
    'nr_of_rules_in_total_groups'                   => ':count_rules szabály :count_groups szabálycsoportban',
    'tag_or_tags'                                   => ':count címke|:count címke',
    'configuration_updated'                         => 'A konfiguráció frissítése megtörtént',
    'setting_is_demo_site'                          => 'Bemutató oldal',
    'setting_is_demo_site_explain'                  => 'Ha bejelölt, a telepítés bemutató oldalként fog viselkedni, aminek furcsa mellékhatásai lehetnek.',
    'block_code_bounced'                            => 'Visszapattant email üzenetek',
    'block_code_expired'                            => 'A Demo számla lejárt',
    'no_block_code'                                 => 'Nincs oka a zárolásnak, vagy a felhasználó nincs zárolva',
    'demo_user_export'                              => 'A demo felhasználó nem exportálhat adatot',
    'block_code_email_changed'                      => 'A felhasználó még nem erősítette meg az új email címét',
    'admin_update_email'                            => 'A profil oldallal ellentétben a felhasználó NEM kap értesítést az email címe megváltozásáról!',
    'update_user'                                   => 'Felhasználó frissítése',
    'updated_user'                                  => 'Felhasználói adatok módosítva.',
    'delete_user'                                   => 'Felhasználó törlése ":email"',
    'user_deleted'                                  => 'A felhasználó törölve lett',
    'send_test_email'                               => 'Teszt email küldése',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Üzenet küldése',
    'send_test_triggered'                           => 'Teszt elindítva. Ellenőrizd a bejövő üzeneteidet és a naplófájlokat.',
    'give_admin_careful'                            => 'Adminisztrátornak kinevezett felhasználók visszavonhatják akár a te adminisztrátori felhatalmazásodat. Légy óvatos.',
    'admin_maintanance_title'                       => 'Karbantartás',
    'admin_maintanance_expl'                        => 'Firefly III karbantartását kezelő gombok',
    'admin_maintenance_clear_cache'                 => 'Gyorsítótár ürítése',
    'owner_notifications'                           => 'Admin értesítések',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Beállítások mentése',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'nem elérhető',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Teszt e-mail',
    'test_notification_channel_name_slack'          => 'Slack tesztelése',
    'test_notification_channel_name_ntfy'           => 'Ntfy.sh tesztelése',
    'test_notification_channel_name_pushover'       => 'Pushover tesztelése',
    'test_notification_channel_name_gotify'         => 'Gotify tesztelése',
    'test_notification_channel_name_pushbullet'     => 'Pushbullet tesztelése',

    'split_transaction_title'               => 'Felosztott tranzakció leírása',
    'split_transaction_title_help'          => 'Felosztott tranzakció létrehozásakor meg kell adni egy globális leírást a tranzakció összes felosztása részére.',
    'split_title_help'                      => 'Felosztott tranzakció létrehozásakor meg kell adni egy globális leírást a tranzakció összes felosztása részére.',
    'you_create_transfer'                   => 'Egy átutalás létrehozása.',
    'you_create_withdrawal'                 => 'Egy költség létrehozása.',
    'you_create_deposit'                    => 'Egy bevétel létrehozása.',

    // links
    'journal_link_configuration'            => 'Tranzakciós kapcsolatok beállítása',
    'create_new_link_type'                  => 'Új kapcsolattípus létrehozása',
    'store_new_link_type'                   => 'Új kapcsolattípus tárolása',
    'update_link_type'                      => 'Kapcsolattípus frissítése',
    'edit_link_type'                        => '":name" kapcsolattípus szerkesztése',
    'updated_link_type'                     => '":name" kapcsolattípus frissítve',
    'delete_link_type'                      => '":name" kapcsolattípus törlése',
    'deleted_link_type'                     => '":name" kapcsolattípus törölve',
    'stored_new_link_type'                  => '":name" új kapcsolattípus tárolása',
    'cannot_edit_link_type'                 => '":name" kapcsolattípus nem szerkeszthető',
    'link_type_help_name'                   => 'Pl. "Duplikátumok"',
    'link_type_help_inward'                 => 'Pl. "duplikátumok"',
    'link_type_help_outward'                => 'Pl. "duplikálta"',
    'save_connections_by_moving'            => 'Ezen tranzakciók közötti kapcsolat mentése másik kapcsolattípusba mozgatással:',
    'do_not_save_connection'                => '(ne mentse a kapcsolatot)',
    'link_transaction'                      => 'Tranzakció kapcsolása',
    'link_to_other_transaction'             => 'Tranzakció hozzákapcsolása egy másik tranzakcióhoz',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Ez a tranzakció',
    'transaction'                           => 'Tranzakció',
    'comments'                              => 'Megjegyzések',
    'link_notes'                            => 'Bármilyen megjegyzés, amit a hivatkozáshoz tárolni szeretne.',
    'invalid_link_selection'                => 'Ezeket a tranzakciókat nem lehet összekapcsolni',
    'selected_transaction'                  => 'Kiválasztott tranzakció',
    'journals_linked'                       => 'Tranzakciók összekapcsolva.',
    'journals_error_linked'                 => 'Ezek a tranzakciók már össze vannak kapcsolva.',
    'journals_link_to_self'                 => 'Tranzakciót nem lehet saját magához csatolni',
    'journal_links'                         => 'Tranzakció összekapcsolások',
    'this_withdrawal'                       => 'Ez a költség',
    'this_deposit'                          => 'Ez a bevétel',
    'this_transfer'                         => 'Ez az átvezetés',
    'overview_for_link'                     => '":name" kapcsolattípus áttekintése',
    'source_transaction'                    => 'Forrás tranzakció',
    'link_description'                      => 'Kapcsolat leírása',
    'destination_transaction'               => 'Cél tranzakció',
    'delete_journal_link'                   => '<a href=":source_link">:source</a> és <a href=":destination_link">:destination</a> közötti kapcsolat törlése',
    'deleted_link'                          => 'Törölt kapcsolat',

    // link translations:
    'Paid_name'                             => 'Fizetve',
    'Refund_name'                           => 'Visszatérítés',
    'Reimbursement_name'                    => 'Visszafizetés',
    'Related_name'                          => 'Kapcsolódó',
    'relates to_inward'                     => 'kapcsolódó',
    'is (partially) refunded by_inward'     => '(részben) visszatérítette',
    'is (partially) paid for by_inward'     => '(részben) kifizette',
    'is (partially) reimbursed by_inward'   => '(részben) visszafizette',
    'inward_transaction'                    => 'Bejövő tranzakciók',
    'outward_transaction'                   => 'Kimenő tranzakciók',
    'relates to_outward'                    => 'kapcsolódik',
    '(partially) refunds_outward'           => '(részben) visszatérítve',
    '(partially) pays for_outward'          => '(részben) fizet',
    '(partially) reimburses_outward'        => '(részben) visszafizetve',
    'is (partially) refunded by'            => '(részben) visszatérítette',
    'is (partially) paid for by'            => '(részben) kifizette',
    'is (partially) reimbursed by'          => '(részben) visszafizette',
    'relates to'                            => 'kapcsolódó',
    '(partially) refunds'                   => '(részben) visszatérítve',
    '(partially) pays for'                  => '(részben) fizet',
    '(partially) reimburses'                => '(részben) visszafizetve',

    // split a transaction:
    'splits'                                => 'Felosztások',
    'add_another_split'                     => 'Másik felosztás hozzáadása',
    'cannot_edit_opening_balance'           => 'Nem lehet szerkeszteni egy bankszámla nyitóegyenlegét.',
    'no_edit_multiple_left'                 => 'Nincs kiválasztva érvényes tranzakció a szerkesztéshez.',
    'breadcrumb_convert_group'              => 'Tranzakció konvertálása',
    'convert_invalid_source'                => 'A forrás információ érvénytelen #%d tranzakció számára.',
    'convert_invalid_destination'           => 'A cél információ érvénytelen #%d tranzakció számára.',
    'create_another'                        => 'A tárolás után térjen vissza ide új létrehozásához.',
    'after_update_create_another'           => 'A frissítés után térjen vissza ide a szerkesztés folytatásához.',
    'store_as_new'                          => 'Tárolás új tranzakcióként frissítés helyett.',
    'reset_after'                           => 'Űrlap törlése a beküldés után',
    'errors_submission'                     => 'Hiba történt a beküldés során. Kérlek javítsd az alábbi hibákat.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expand split',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Collapse split',

    // object groups
    'default_group_title_name'              => '(nem csoportosított)',
    'default_group_title_name_plain'        => 'nem csoportosított',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Ideje létrehozni egy eszközszámlát!',
    'no_accounts_intro_asset'               => 'Még nincsenek eszközszámlák. Az eszközszámlák a fő számlák: folyószámla, megtakarítási számlák, megosztott számlák vagy akár hitelkártya.',
    'no_accounts_imperative_asset'          => 'A Firefly III használatának megkezdéséhez létre kell hozni legalább egy eszközszámlát. Csináljuk meg most:',
    'no_accounts_create_asset'              => 'Egy eszközszámla létrehozása',
    'no_accounts_title_expense'             => 'Ideje létrehozni egy költségszámlát!',
    'no_accounts_intro_expense'             => 'Még nincs költségszámlád. A költségszámlák azok a helyek, ahol pénzköltés történik, például üzletek és szupermarketek.',
    'no_accounts_imperative_expense'        => 'A költségszámlák automatikusan jönnek létre tranzakciók létrehozásakor, de kézzel is létre lehet hozni. Hozzunk létre egyet most:',
    'no_accounts_create_expense'            => 'Költségszámla létrehozása',
    'no_accounts_title_revenue'             => 'Ideje létrehozni egy jövedelemszámlát!',
    'no_accounts_intro_revenue'             => 'Még nincsenek jövedelemszámlák. A jövedelemszámlák azok a helyek, ahonnan pénz jön, ilyen például a munkáltató.',
    'no_accounts_imperative_revenue'        => 'A jövedelemszámlák automatikusan létrejönnek tranzakciók létrehozásakor, de ha szükséges, létre lehet hozni manuálisan is. Létrehozás most:',
    'no_accounts_create_revenue'            => 'Új jövedelemszámla létrehozása',
    'no_accounts_title_liabilities'         => 'Ideje létrehozni egy kötelezettséget!',
    'no_accounts_intro_liabilities'         => 'Még nincsenek kötelezettségek. A kötelezettségek azok a számlák amik a (diák)hiteleket és egyéb adósságokat regisztrálják.',
    'no_accounts_imperative_liabilities'    => 'Nem kötelező használni ezt a funkciót, de hasznos lehet ha szükséges követni ezeket a dolgokat.',
    'no_accounts_create_liabilities'        => 'Új kötelezettség létrehozása',
    'no_budgets_title_default'              => 'Ideje létrehozni egy költségkeretet',
    'no_rules_title_default'                => 'Ideje létrehozni egy szabályt',
    'no_budgets_intro_default'              => 'Még nincsenek költségkeretek. A költségkeretek arra szolgálnak, hogy a költségeket logikai csoportokba szervezhessük, amelyekhez a költségek csökkentéséhez megadható egy átléphető felső határ.',
    'no_rules_intro_default'                => 'You have no rules yet. Rules are powerful automations that can handle transactions for you.',
    'no_rules_imperative_default'           => 'Rules can be very useful when you\'re managing transactions. Let\'s create one now:',
    'no_budgets_imperative_default'         => 'A költségkeretek a pénzügyi menedzsment alapvető eszközei. Létrehozás most:',
    'no_budgets_create_default'             => 'Költségkeret létrehozása',
    'no_rules_create_default'               => 'Szabály létrehozása',
    'no_categories_title_default'           => 'Ideje létrehozni egy kategóriát!',
    'no_categories_intro_default'           => 'Még nincsenek kategóriák. A kategóriákat a tranzakciók finomhangolására, kijelölt kategóriákkal történő megjelölésére használják.',
    'no_categories_imperative_default'      => 'A kategóriák automatikusan létrejönnek tranzakciók létrehozásakor, de ha szükséges, létre lehet hozni manuálisan is. Létrehozás most:',
    'no_categories_create_default'          => 'Kategória létrehozása',
    'no_tags_title_default'                 => 'Ideje létrehozni egy címkét!',
    'no_tags_intro_default'                 => 'Még nincsenek címkék. A címkéket a tranzakciók finomhangolására, speciális kulcsszavakkal történő megjelölésére használják.',
    'no_tags_imperative_default'            => 'A címkék automatikusan létrejönnek tranzakciók létrehozásakor, de ha szükséges, létre lehet hozni manuálisan is. Létrehozás most:',
    'no_tags_create_default'                => 'Címke létrehozása',
    'no_transactions_title_withdrawal'      => 'Ideje létrehozni egy költséget!',
    'no_transactions_intro_withdrawal'      => 'Még nincsenek költségek. A pénzügyek kezeléséhez létre kell hozni költségeket.',
    'no_transactions_imperative_withdrawal' => 'Pénzt költöttél? Akkor le kellene írni:',
    'no_transactions_create_withdrawal'     => 'Költség létrehozása',
    'no_transactions_title_deposit'         => 'Hozzunk létre bevételt!',
    'no_transactions_intro_deposit'         => 'Még nincs rögzített bevétel. A pénzügyek kezeléséhez létre kell hozni bevételi bejegyzéseket.',
    'no_transactions_imperative_deposit'    => 'Pénzhez jutottál? Akkor le kellene írni:',
    'no_transactions_create_deposit'        => 'Új bevétel létrehozása',
    'no_transactions_title_transfers'       => 'Ideje létrehozni egy átvezetést!',
    'no_transactions_intro_transfers'       => 'Még nincsenek átvezetések. Eszközszámlák közötti pénzmozgás átvezetésként lesz rögzítve.',
    'no_transactions_imperative_transfers'  => 'Pénzt költöttél? Akkor le kellene írni:',
    'no_transactions_create_transfers'      => 'Átvezetés létrehozása',
    'no_piggies_title_default'              => 'Ideje létrehozni egy malacperselyt!',
    'no_piggies_intro_default'              => 'Még nincsenek malacperselyek. Létre lehet hozni malacperselyeket a megtakarítások felosztásához és a megtakarítások nyomon követéséhez.',
    'no_piggies_imperative_default'         => 'Van valami, amire pénzt kellene megtakarítani? Hozz létre egy malacperselyt és kövesd nyomon:',
    'no_piggies_create_default'             => 'Új malacpersely létrehozása',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Ismétlődő tranzakciók',
    'repeat_until_in_past'                  => 'Ez a rendszeres tranzakció leállt ekkor: :date.',
    'recurring_calendar_view'               => 'Naptár',
    'no_recurring_title_default'            => 'Hozzunk létre egy ismétlődő tranzakciót!',
    'no_recurring_intro_default'            => 'Még nincsenek ismétlődő tranzakciók. Ezek használatával a Firefly III automatikusan létrehozza a tranzakciókat.',
    'no_recurring_imperative_default'       => 'Ez egy elég fejlett funkció ami rendkívül hasznos tud lenni. Erősen ajánlott elolvasni a dokumentációt (?) ikon a jobb felső sarokban) a folytatás előtt.',
    'no_recurring_create_default'           => 'Ismétlődő tranzakció létrehozása',
    'make_new_recurring'                    => 'Ismétlődő tranzakció létrehozása',
    'recurring_daily'                       => 'Mindennap',
    'recurring_weekly'                      => 'Minden héten ekkor: :weekday',
    'recurring_weekly_skip'                 => 'Minden :skip. héten, hétköznap',
    'recurring_monthly'                     => 'Minden hónap ezen napján: :dayOfMonth',
    'recurring_monthly_skip'                => 'Minden :skip. hónapon, a(z) :dayOfMonth. napon',
    'recurring_ndom'                        => 'Minden hónapban ekkor: :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Minden évben ekkor: :date',
    'overview_for_recurrence'               => '":title" ismétlődő tranzakció áttekintése',
    'warning_duplicates_repetitions'        => 'Ritka esetben a dátumok kétszer jelennek meg a listában. Ez akkor fordulhat elő amikor több ismétlődés ütközik egymással. A Firefly III minden esetben csak egy tranzakciót hoz létre naponta.',
    'created_transactions'                  => 'Kapcsolódó tranzakciók',
    'expected_withdrawals'                  => 'Várható költségek',
    'expected_deposits'                     => 'Várható bevételek',
    'expected_transfers'                    => 'Várható átvezetések',
    'created_withdrawals'                   => 'Létrehozott költségek',
    'created_deposits'                      => 'Létrehozott bevételek',
    'created_transfers'                     => 'Átvezetések létrehozva',
    'recurring_info'                        => 'Ismétlődő tranzakciók :count / :total',
    'created_from_recurrence'               => 'Létrehozva ":title" (#:id) ismétlődő tranzakcióból',
    'recurring_never_cron'                  => 'Az ismétlődő tranzakció funkcióhoz tartozó ütemezett feladat sosem futott még le. Ez normális jelenség, ha most Firefly III frissen lett telepítve, de ennek rövid időn belül változnia kellene. Ellenőrizd a súgóban a hibaelháítási lehetőségeket, a (?) gombra kattintva a jobb felső sarokban.',
    'recurring_cron_long_ago'               => 'Úgy látszik, hogy több, mint 36 óra telt el a legutolsó ismétlődő tranzakciókat végrehajtó ütemezett feladat elindítása óta. Biztos vagy abban, hogy helyesen lett beállítva minden? Ellenőrizd a súgóban a hibaelháítási lehetőségeket, a (?) gombra kattintva a jobb felső sarokban.',

    'create_new_recurrence'              => 'Új ismétlődő tranzakció létrehozása',
    'help_first_date'                    => 'Az első várható ismétlést jelöli. A jövőben kell lennie.',
    'help_first_date_no_past'            => 'Az első várható ismétlést jelöli. A Firefly III nem fog tranzakciókat létrehozni a múltban.',
    'no_currency'                        => '(nincs pénznem)',
    'mandatory_for_recurring'            => 'Kötelező ismétlődési információ',
    'mandatory_for_transaction'          => 'Kötelező tranzakció információ',
    'optional_for_recurring'             => 'Nem kötelező ismétlődési információ',
    'optional_for_transaction'           => 'Nem kötelező tranzakció információ',
    'change_date_other_options'          => 'További lehetőségek megtekintéséhez módosítani kell az "első dátum"-ot.',
    'mandatory_fields_for_tranaction'    => 'Az itteni értékek a létrehozott tranzakciókba kerülnek',
    'click_for_calendar'                 => 'Ide kattintva egy naptár jelenik meg ami megmutatja, hogy a tranzakció mikor lesz megismételve.',
    'repeat_forever'                     => 'Folyamatos ismétlés',
    'repeat_until_date'                  => 'Ismétlés egy időpontig',
    'repeat_times'                       => 'Ismétlés többször',
    'recurring_skips_one'                => 'Minden más',
    'recurring_skips_more'               => ':count előfordulás kihagyása',
    'store_new_recurrence'               => 'Ismétlődő tranzakció letárolása',
    'stored_new_recurrence'              => '":title" ismétlődő tranzakció sikeresen letárolva.',
    'edit_recurrence'                    => '":title" ismétlődő tranzakció szerkesztése',
    'recurring_repeats_until'            => 'Ismétlés :date-ig',
    'recurring_repeats_forever'          => 'Folyamatos ismétlés',
    'recurring_repeats_x_times'          => ':count alkalommal ismétlődik|:count alkalommal ismétlődik',
    'update_recurrence'                  => 'Ismétlődő tranzakció frissítése',
    'updated_recurrence'                 => '":title" ismétlődő tranzakció frissítve',
    'recurrence_is_inactive'             => 'Ez az ismétlődő tranzakció nem aktív, nem fog új tranzakciókat létrehozni.',
    'delete_recurring'                   => '":title" ismétlődő tranzakció törlése',
    'new_recurring_transaction'          => 'Új ismétlődő tranzakció',
    'help_weekend'                       => 'Mit tegyen a Firefly III ha az ismétlődő tranzakció szombatra vagy vasárnapra esik?',
    'do_nothing'                         => 'Hozza létre a tranzakciót',
    'skip_transaction'                   => 'Előfordulás kihagyása',
    'jump_to_friday'                     => 'A tranzakció inkább az előző pénteken jöjjön létre',
    'jump_to_monday'                     => 'A tranzakció inkább az következő hétfőn jöjjön létre',
    'will_jump_friday'                   => 'Pénteken lesz létrehozva hétvége helyett.',
    'will_jump_monday'                   => 'Hétfőn lesz létrehozva hétvége helyett.',
    'except_weekends'                    => 'Kivéve hétvégék',
    'recurrence_deleted'                 => '":title" ismétlődő tranzakció törölve',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Egyenleg (:currency)',
    'box_spent_in_currency'              => 'Költés (:currency)',
    'box_earned_in_currency'             => 'Megkeresett (:currency)',
    'box_budgeted_in_currency'           => 'Megkeresett (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Elkölthető (:currency)',
    'box_net_worth_in_currency'          => 'Nettó érték (:currency)',
    'box_spend_per_day'                  => 'Naponta elkölthető: :amount',

    // debug page
    'debug_page'                         => 'Debug információk',
    'debug_submit_instructions'          => 'Ha hibába ütköznél, a lenti információk használhatóak a vizsgálatához. Kérlek küld el egy új vagy már létező, hasonló témájú <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub hibajegybe</a>. Ez így egy átlátható táblázatot fog generálni, ami segíteni fog a hiba okának keresésében.',
    'debug_pretty_table'                 => 'Ha bemásolod a lenti adatokat egy GitHub hibajegy megjegyzésébe, egy átlátható táblázatot fog generálni. Kérlek ne használj idézőjeleket körülötte.',
    'debug_additional_data'              => 'A lenti információkat is megoszthatod. Kimásolható a <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub hibajegybe</a>. Viszont tartalmazhat szenzitív információkat, mint számla és tranzakció adatok vagy e-mail címek.',

    // object groups
    'object_groups_menu_bar'             => 'Csoportok',
    'object_groups_page_title'           => 'Csoportok',
    'object_groups_breadcrumb'           => 'Csoportok',
    'object_groups_index'                => 'Áttekintés',
    'object_groups'                      => 'Csoportok',
    'object_groups_empty_explain'        => 'Sok elem csoportosítható Firefly III-ban. Például malacperselyeknek beállítható a "Csoport" mezője. Szerkeszthető a csoportok megnevezése és sorrendje. További információkért nézd meg a súgót a jobb felső sarokban lévő (?) ikonra kattintva.',
    'object_group_title'                 => 'Cím',
    'edit_object_group'                  => '":title" csoport szerkesztése',
    'delete_object_group'                => '":title" csoport törlése',
    'update_object_group'                => 'Csoport frissítése',
    'updated_object_group'               => 'Successfully updated group ":title"',
    'deleted_object_group'               => 'Successfully deleted group ":title"',
    'object_group'                       => 'Csoport',

    // other stuff
    'placeholder'                        => '[Helykitöltő]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Módosított tranzakciótípus',
    'ale_action_update_notes'            => 'Módosított megjegyzések',
    'ale_action_update_description'      => 'Módosított leírás',
    'ale_action_add_to_piggy'            => 'Malacpersely',
    'ale_action_remove_from_piggy'       => 'Malacpersely',
    'ale_action_add_tag'                 => 'Hozzáadott címke',
    'ale_action_update_amount'           => 'Frissített összeg',

    // dashboard
    'enable_auto_convert'                => 'Pénznem váltás engedélyezése',
    'disable_auto_convert'               => 'Pénznem váltás letiltása',
];
