<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Lukk',
    'actions'                                   => 'Handlinger',
    'edit'                                      => 'Rediger',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Slett',
    'split'                                     => 'Del opp',
    'single_split'                              => 'Del opp',
    'clone'                                     => 'Klon',
    'clone_and_edit'                            => 'Clone and edit',
    'confirm_action'                            => 'Bekreft handling',
    'last_seven_days'                           => 'Syv siste dager',
    'last_thirty_days'                          => 'Tredve siste dager',
    'last_180_days'                             => 'Siste 180 dager',
    'month_to_date'                             => 'Måned til dato',
    'year_to_date'                              => 'År til dato',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'Hittil i år',
    'welcome_back'                              => 'Korleis går det?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Alt',
    'today'                                     => 'i dag',
    'customRange'                               => 'Egendefinert utval',
    'date_range'                                => 'Datointervall',
    'apply'                                     => 'Bruk',
    'select_date'                               => 'Vel dato..',
    'cancel'                                    => 'Avbryt',
    'from'                                      => 'Frå',
    'to'                                        => 'Til',
    'structure'                                 => 'Struktur',
    'help_translating'                          => 'Denne hjelpeteksten er ikkje tilgjengelig på ditt språk. <a href="https://crowdin.com/project/firefly-iii-help">Vil du hjelpa å oversetta?</a>',
    'showEverything'                            => 'Vis alt',
    'never'                                     => 'Aldri',
    'no_results_for_empty_search'               => 'Søket ditt var tomt, så ingenting vart funnet.',
    'removed_amount'                            => 'Fjerna :amount',
    'added_amount'                              => 'La til :amount',
    'asset_account_role_help'                   => 'Eventuelle ekstra alternativ som følge av ditt val kan settes senere.',
    'Opening balance'                           => 'Startsaldo',
    'create_new_stuff'                          => 'Lag nye ting',
    'new_withdrawal'                            => 'Nytt uttak',
    'create_new_transaction'                    => 'Opprett ny transaksjon',
    'sidebar_frontpage_create'                  => 'Opprett',
    'new_transaction'                           => 'Ny transaksjon',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Sjå aktivakontoane dine',
    'go_to_budgets'                             => 'Gå til budsjetta dine',
    'go_to_withdrawals'                         => 'Gå til uttaka dine',
    'clones_journal_x'                          => 'Denne transaksjonen er ein klone av ":description" (#:id)',
    'go_to_categories'                          => 'Gå til kategoriane dine',
    'go_to_bills'                               => 'Gå til ditt abonnement',
    'go_to_expense_accounts'                    => 'Sjå utgiftskontoane dine',
    'go_to_revenue_accounts'                    => 'Sjå inntektskontoane dine',
    'go_to_piggies'                             => 'Gå til sparegrisane dine',
    'new_deposit'                               => 'Nytt innskot',
    'new_transfer'                              => 'Ny overføring',
    'new_transfers'                             => 'Ny overføring',
    'new_asset_account'                         => 'Ny aktivakonto',
    'new_expense_account'                       => 'Ny utgiftskonto',
    'new_revenue_account'                       => 'Ny inntektskonto',
    'new_liabilities_account'                   => 'Ny gjeld',
    'new_budget'                                => 'Nytt budsjett',
    'new_bill'                                  => 'Nytt abonnement',
    'block_account_logout'                      => 'Du har vorte logga ut. Blokkerte kontoar kan ikkje bruka denne nettstaden. Har du registrert deg med ei gyldig e-postadresse?',
    'flash_success'                             => 'Suksess!',
    'flash_info'                                => 'Melding',
    'flash_warning'                             => 'Advarsel!',
    'flash_error'                               => 'Feil!',
    'flash_danger'                              => 'Fare!',
    'flash_info_multiple'                       => 'Det eksisterar ei melding | Det eksisterar :count meldingar',
    'flash_error_multiple'                      => 'Det er ein feil | Det er :count feil',
    'net_worth'                                 => 'Formue',
    'help_for_this_page'                        => 'Hjelp for denne sida',
    'help_for_this_page_body'                   => 'Du finn meir informasjon om denne sida <a href="https://docs.firefly-iii.org/">i dokumentasjonen</a>.',
    'two_factor_welcome'                        => 'Hallo!',
    'two_factor_enter_code'                     => 'Ver venleg å skriv inn tofaktorautentiseringskoden for å fortsetja. Appen på telefonen kan generera den for deg.',
    'two_factor_code_here'                      => 'Skriv koden her',
    'two_factor_title'                          => 'Tofaktorautentisering',
    'authenticate'                              => 'Autentisere',
    'two_factor_forgot_title'                   => 'Mista tofaktorautentisering',
    'two_factor_forgot'                         => 'Jeg har glemt/mistet min tofaktor-ting.',
    'two_factor_lost_header'                    => 'Mista tofaktorautentisering?',
    'two_factor_lost_intro'                     => 'Om du òg har mistet sikkerhetskodane din, har du uflaks. Noko du ikkje kan fiksa frå webgrensesnittet. Du har to val.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Ellers sender ein epost til eigaren av nettsida, <a href="mailto::site_owner">:site_owner</a> og spør vedkommande om å tilbakestille tofaktorautentiseringa din.',
    'mfa_backup_code'                           => 'Du har brukt ein sikkerhetskode for å logge inn i Firefly III. Den kan ikkje brukes igjen, så kryss den frå lista din.',
    'pref_two_factor_new_backup_codes'          => 'Få nye sikkerhetskoder',
    'pref_two_factor_backup_code_count'         => 'Du har :count gyldige backup-koder. You have :count valid backup koder.',
    '2fa_i_have_them'                           => 'Jeg lagra dem!',
    'warning_much_data'                         => ':days dager med data kan ta litt tid å laste.',
    'registered'                                => 'Registreringen var vellukka!',
    'Default asset account'                     => 'Standard aktivakonto',
    'no_budget_pointer'                         => 'Det ser ikkje ut til at du har budsjett enda. Du bør oppretta nokon på <a href="/budgets">budsjett</a>-sida. Budsjett kan hjelpa deg med å halda oversikt over utgifter.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Sparekonto',
    'Credit card'                               => 'Kredittkort',
    'source_accounts'                           => 'Kjeldekonto|Kjeldekontoar',
    'destination_accounts'                      => 'Målkonto|Målkontoar',
    'user_id_is'                                => 'Din brukar-ID er <strong>:user</strong>',
    'field_supports_markdown'                   => 'Dette feltet støttar <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Om du treng meir hjelp med å bruka Firefly III, ver venleg å <a href="https://github.com/firefly-iii/firefly-iii/issues">opprett ei sak på Github</a>.',
    'reenable_intro_text'                       => 'Du kan òg reaktivera <a href="#" id="reenableGuidance">introduksjonsveiledningen</a>.',
    'intro_boxes_after_refresh'                 => 'Innføringsboksane vil dukke opp igjen når du laster sida på nytt.',
    'show_all_no_filter'                        => 'Vis alle transaksjonar uten å gruppere dei etter dato.',
    'expenses_by_category'                      => 'Utgifter etter kategori',
    'expenses_by_budget'                        => 'Utgifter etter budsjett',
    'income_by_category'                        => 'Inntekt etter kategori',
    'expenses_by_asset_account'                 => 'Utgifter etter aktivakonto',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III kan ikkje videresende deg til rett side. Beklager.',
    'sum_of_expenses'                           => 'Sum av utgifter',
    'sum_of_income'                             => 'Sum av inntekt',
    'liabilities'                               => 'Gjeld',
    'spent_in_specific_budget'                  => 'Brukt i budsjett ":budget"',
    'spent_in_specific_double'                  => 'Brukt i konto ":account',
    'earned_in_specific_double'                 => 'Opptjent i konto ":account',
    'source_account'                            => 'Kjeldekonto',
    'source_account_reconciliation'             => 'Du kan ikkje redigera kildekontoen for ein avstemmingstransaksjon.',
    'destination_account'                       => 'Målkonto',
    'destination_account_reconciliation'        => 'Du kan ikkje redigera kildekontoen for ein avstemmingstransaksjon.',
    'sum_of_expenses_in_budget'                 => 'Brukt totalt i budsjett «:budget»',
    'left_in_budget_limit'                      => 'Att å bruka i følge budsjett',
    'current_period'                            => 'Noverande periode',
    'show_the_current_period_and_overview'      => 'Vis gjeldande periode og oversikt',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'For at eit anna språk enn engelsk skal fungera skikkelig, må operativsystemet ditt vera utstyrt med rett lokalinformasjon. Om dette ikkje er på plass, kan valutadata, datoar og beløp verta vist feil.',
    'budget_in_period'                          => 'Alle transaksjonar for budsjett ":name" mellom :start og :end i :currency',
    'chart_budget_in_period'                    => 'Diagram for alle transaksjonar for budsjett ":name" mellom :start og :end i :currency',
    'chart_budget_in_period_only_currency'      => 'Beløpet du budsjetterte var i :currency, så dette diagrammet vil berre visa transaksjonar i :currency.',
    'chart_account_in_period'                   => 'Diagram for alle transaksjonar for konto ":name" (:balance) mellom :start og :end',
    'chart_category_in_period'                  => 'Diagram for alle transaksjonar for kategori ":name" mellom :start og :end',
    'chart_category_all'                        => 'Graf over alle transaksjonar for kategori ":name"',
    'clone_withdrawal'                          => 'Klone dette uttaket',
    'clone_deposit'                             => 'Klone dette innskuddet',
    'clone_transfer'                            => 'Klone denne overføringen',
    'multi_select_no_selection'                 => 'Ingen valt',
    'multi_select_select_all'                   => 'Vel alle',
    'multi_select_n_selected'                   => 'valt',
    'multi_select_all_selected'                 => 'Alle valde',
    'multi_select_filter_placeholder'           => 'Finn..',
    'intro_next_label'                          => 'Neste',
    'intro_prev_label'                          => 'Forrige',
    'intro_skip_label'                          => 'Hopp over',
    'intro_done_label'                          => 'Ferdig',
    'between_dates_breadcrumb'                  => 'Mellom :start og :end',
    'all_journals_without_budget'               => 'Alle transaksjonar uten budsjett',
    'journals_without_budget'                   => 'Transaksjoner uten budsjett',
    'all_journals_without_category'             => 'Alle ukategoriserte transaksjonar',
    'journals_without_category'                 => 'Ukategoriserte transaksjonar',
    'all_journals_for_account'                  => 'Alle transaksjonar for konto :name',
    'chart_all_journals_for_account'            => 'Graf over alle transaksjonar for konto :name',
    'journals_in_period_for_account'            => 'Alle transaksjonar for konto :name mellom :start og :end',
    'journals_in_period_for_account_js'         => 'Alle transaksjonar for konto {title} mellom {start} og {end}',
    'transferred'                               => 'Overført',
    'all_withdrawal'                            => 'Alle utgifter',
    'all_transactions'                          => 'Alle transaksjonar',
    'title_withdrawal_between'                  => 'Alle utgifter mellom :start og :end',
    'all_deposit'                               => 'Alle inntekter',
    'title_deposit_between'                     => 'Alle inntekter mellom :start og :end',
    'all_transfers'                             => 'Alle overføringer',
    'title_transfers_between'                   => 'Alle overføringer mellom :start og :end',
    'all_transfer'                              => 'Alle overføringer',
    'all_journals_for_tag'                      => 'Alle transaksjonar for nøkkelordet «:tag»',
    'title_transfer_between'                    => 'Alle overføringer mellom :start og :end',
    'all_journals_for_category'                 => 'Alle transaksjonar for kategori :name',
    'all_journals_for_budget'                   => 'Alle transaksjonar for budsjett :name',
    'chart_all_journals_for_budget'             => 'Graf over alle transaksjonar for budsjett :name',
    'journals_in_period_for_category'           => 'Alle transaksjonar for kategori :name mellom :start og :end',
    'journals_in_period_for_tag'                => 'Alle transaksjonar for nøkkelordet :tag mellom :start og :end',
    'not_available_demo_user'                   => 'Funksjonen du prøvar å få tilgang til, er ikkje tilgjengeleg for demobrukarar.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Kjeldekonto "@source_name" godtar kun transaksjonar i @source_currency. Destinasjonskonto "@dest_name" aksepterer berre transaksjonar i @dest_currency. Du må angi overført beløp rett i begge valutaene.',
    'transaction_data'                          => 'Transaksjonsdata',
    'invalid_server_configuration'              => 'Ugyldig serverkonfigurasjon',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Hurtigbryter',
    'sign_in_to_start'                          => 'Logg inn for å starte økten',
    'sign_in'                                   => 'Logg inn',
    'register_new_account'                      => 'Registrer ein ny konto',
    'forgot_my_password'                        => 'Jeg har glemt passordet mitt',
    'problems_with_input'                       => 'Det var nokon problemer med utfyllingen din.',
    'reset_password'                            => 'Tilbakestill passordet ditt',
    'button_reset_password'                     => 'Tilbakestill passord',
    'reset_button'                              => 'Tilbakestill',
    'want_to_login'                             => 'Jeg vil logge inn',
    'login_page_title'                          => 'Innlogging til Firefly III',
    'register_page_title'                       => 'Registrer deg på Firefly III',
    'forgot_pw_page_title'                      => 'Glemt passord for Firefly III',
    'reset_pw_page_title'                       => 'Nullstill passord for Firefly III',
    'cannot_reset_demo_user'                    => 'Du kan ikkje nustille passordet til demo brukar.',
    'no_att_demo_user'                          => 'Demo brukaren kan ikkje laste opp vedlegg.',
    'button_register'                           => 'Registrer',
    'authorization'                             => 'Autorisasjon',
    'active_bills_only'                         => 'kun aktivt abonnement',
    'active_bills_only_total'                   => 'alle aktive abonnement',
    'active_exp_bills_only'                     => 'berre aktive og forventa abonnement',
    'active_exp_bills_only_total'               => 'berre alle aktive forventa abonnement',
    'per_period_sum_1D'                         => 'Forventa daglege kostnadar',
    'per_period_sum_1W'                         => 'Forventa vekentlege kostnadar',
    'per_period_sum_1M'                         => 'Forventa månadlege kostnadar',
    'per_period_sum_3M'                         => 'Forventa kvartalskostnadar',
    'per_period_sum_6M'                         => 'Forventa halvårlege kostnadar',
    'per_period_sum_1Y'                         => 'Forventa årlege kostnadar',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'forventet totalt',
    'reconciliation_account_name'               => ':name avstemming (:currency)',
    'saved'                                     => 'Lagret',
    'advanced_options'                          => 'Avanserte innstillinger',
    'advanced_options_explain'                  => 'Nokre sider i Firefly III har avanserte alternativ gøymt bak denne knappen. Denne sida har ikkje noko spesielt her, men sjekk ut dei andre!',
    'here_be_dragons'                           => 'Her eksisterar drager',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'deaktivert',
    'no_webhook_messages'                       => 'Ingen Webhook meldingar',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Etter transaksjons opprettelse',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Etter transaksjons oppdatering',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Etter transaksjons sletting',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaksjonsdetaljer',
    'webhook_response_ACCOUNTS'                 => 'Kontodetaljer',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspiser',
    'create_new_webhook'                        => 'Opprett ny Webhook',
    'webhooks_create_breadcrumb'                => 'Opprett ny Webhook',
    'webhook_trigger_form_help'                 => 'Kva for ei hending skal Webhook utløysa',
    'webhook_response_form_help'                => 'Kva skal Webhook må senda til URL.',
    'webhook_delivery_form_help'                => 'Kva format skal Webhook sende data i.',
    'webhook_active_form_help'                  => 'Webhook må aktiverast for å fungera.',
    'stored_new_webhook'                        => 'Lagret ny webhook ":title"',
    'delete_webhook'                            => 'Slett Webhook',
    'deleted_webhook'                           => 'Sletta Webhook ":title"',
    'edit_webhook'                              => 'Rediger Webhook ":title"',
    'updated_webhook'                           => 'Oppdatert Webhook ":title"',
    'edit_webhook_js'                           => 'Rediger Webhook "{title}"',
    'show_webhook'                              => 'Webhook «:title»',
    'webhook_was_triggered'                     => 'Webhook vart trigget på den angitte transaksjonen. Ver venleg å vent på resultatet.',
    'webhook_messages'                          => 'Webhook melding',
    'view_message'                              => 'Vis melding',
    'view_attempts'                             => 'Vis mislykkede forsøk',
    'message_content_title'                     => 'Webhook meldingsinnhold',
    'message_content_help'                      => 'Dette er innhaldet av meldinga som vart sendt (eller forsøkt sendt) med denne Webhook.',
    'attempt_content_title'                     => 'Webhook forsøk',
    'attempt_content_help'                      => 'Dette er alle mislykkede forsøk på denne webhook-meldinga som vert sendt til den konfigurerte URL-en. Etter ein tid vil Firefly III slutta å prøve.',
    'no_attempts'                               => 'Det er ingen mislykkede forsøk. Det er god ting!',
    'webhook_attempt_at'                        => 'Forsøk på {moment}',
    'logs'                                      => 'Logger',
    'response'                                  => 'Respons',
    'visit_webhook_url'                         => 'Besøk URL til webhook',
    'reset_webhook_secret'                      => 'Tilbakestill Webhook hemmelegheit',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> er lagra.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") er oppdatert.',

    // API access
    'authorization_request'                     => 'Firefly III v:version autorisasjonsspørsmål',
    'authorization_request_intro'               => 'Applikasjonen "<strong>:client</strong>" spør om tilgang til din finansielle administrasjon. Vil du tillata <strong>:client</strong> slik at han får tilgang til dine data?',
    'authorization_request_site'                => 'Du vil verta omdirigert til <code>:url</code> som vil gje tilgang til dine Firefly III data.',
    'authorization_request_invalid'             => 'Dette tilgangsspørsmålet er ugyldig. Ver venleg å ikkje følg denne koplinga igjen.',
    'scopes_will_be_able'                       => 'Denne applikasjonen vil kunne:',
    'button_authorize'                          => 'Autoriser',
    'none_in_select_list'                       => '(ingen)',
    'no_piggy_bank'                             => '(ingen sparegriser)',
    'name_in_currency'                          => ':name i :currency',
    'paid_in_currency'                          => 'Betalt i :currency',
    'unpaid_in_currency'                        => 'Ubetalt i :currency',
    'is_alpha_warning'                          => 'Du køyrer ein ALPHA-versjon. Vær varsom for feil og problemer.',
    'is_beta_warning'                           => 'Du køyrer ein BETA-versjon. Vær varsom for bugs og problemer.',
    'all_destination_accounts'                  => 'Målkonto',
    'all_source_accounts'                       => 'Kjeldekontoar',
    'back_to_index'                             => 'Tilbake til index',
    'cant_logout_guard'                         => 'Firefly III kan ikkje logge deg ut.',
    'internal_reference'                        => 'Intern referanse',

    // check for updates:
    'update_check_title'                        => 'Sjå etter oppdateringar',
    'admin_update_check_title'                  => 'Sjå etter oppdateringar automatisk',
    'admin_update_check_explain'                => 'Firefly III kan sjekka etter oppdateringar automatisk. Når du aktiverar denne innstillinga, vil systemet kontakta Github for å sjå om ein ny versjon av Firefly III er tilgjengeleg. Når det er kjem ei ny oppdatering, vil du få beskjed. Du kan testa denne beskjeden ved å bruka knappen til høgre. Ver venleg å marker nedanfor om du vil at Firefly III skal sjå etter oppdateringar.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Spør meg senere',
    'updates_do_not_check'                      => 'Ikke sjå etter oppdateringar',
    'updates_enable_check'                      => 'Aktiver oppdateringssjekk',
    'admin_update_check_now_title'              => 'Sjå etter oppdateringar no',
    'admin_update_check_now_explain'            => 'Om du trykker på knappen, vil Firefly III sjå om din noverande versjon er den nyaste.',
    'check_for_updates_button'                  => 'Sjekk no!',
    'update_new_version_alert'                  => 'Ein ny versjon av Firefly III er tilgjengeleg. Du køyrer :your_version, den nyaste versjonen er :new_version som vart utgitt den :date.',
    'update_version_beta'                       => 'Dette er ein BETA versjon, du kan oppleve problemer.',
    'update_version_alpha'                      => 'Dette er ein ALPHA versjon, du kan oppleve problemer.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Du køyrer :version, som er den nyaste tilgjengelege utgjevinga.',
    'update_newer_version_alert'                => 'Du køyrer :your_version, som er nyare enn den nyaste versjonen, :new_version.',
    'update_check_error'                        => 'Det oppstod ein feil under søk etter oppdatering: :error',
    'unknown_error'                             => 'Ukjent feil. Beklager det.',
    'disabled_but_check'                        => 'Du har deaktivert oppdateringssjekk. Ikke gløym å oppdatera sjølv av og til. Tusen takk!',
    'admin_update_channel_title'                => 'Oppdater kanal',
    'admin_update_channel_explain'              => 'Firefly III har tre oppdaterings "kanaler" som bestemmer kor mykje du ønskar å ligga foran med tanke på funksjoner, forbetringar og feil. Bruk beta-kanalen dersom du er eventyrlysten og "alfa" når du likar å leva farleg.',
    'update_channel_stable'                     => 'Stable. Alt skal fungera som forventet.',
    'update_channel_beta'                       => 'Beta. Nye funksjoner, men kan ha enkelte programfeil.',
    'update_channel_alpha'                      => 'Alfa. Me sleng nye ting inn, og brukar det som fell av.',

    // search
    'search'                                    => 'Søk',
    'search_query'                              => 'Spørring',
    'search_found_transactions'                 => 'Firefly III fant :count transaksjon på :time sekunder|Firefly III fant :count transaksjonar på :time sekunder.',
    'search_found_more_transactions'            => 'Firefly III fant meir enn :count transaksjonar på :time sekunder.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Desse søkeparametrane er ikkje gyldige og vart ignorert.',

    // old


    'search_modifier_date_on'                             => 'Transaksjons dato er ":value"',
    'search_modifier_not_date_on'                         => 'Transaksjonsdato er ikkje ":value"',
    'search_modifier_reconciled'                          => 'Transaksjonen er avstemt',
    'search_modifier_not_reconciled'                      => 'Transaksjonen er ikkje avstemt',
    'search_modifier_id'                                  => 'Transaksjons ID er ":value"',
    'search_modifier_not_id'                              => 'Transaksjons ID er ikkje ":value"',
    'search_modifier_date_before'                         => 'Transaksjonsdato er før eller på ":value"',
    'search_modifier_date_after'                          => 'Transaksjons dato er etter eller på ":value"',
    'search_modifier_external_id_is'                      => 'Ekstern ID er ":value"',
    'search_modifier_not_external_id_is'                  => 'Ekstern ID er ikkje ":value"',
    'search_modifier_no_external_url'                     => 'Transaksjonen har ingen ekstern URL',
    'search_modifier_no_external_id'                      => 'Transaksjonen har ingen ekstern ID',
    'search_modifier_not_any_external_url'                => 'Transaksjonen har ingen ekstern URL',
    'search_modifier_not_any_external_id'                 => 'Transaksjonen har ingen ekstern ID',
    'search_modifier_any_external_url'                    => 'Transaksjonen må ha minst ein ekstern URL',
    'search_modifier_any_external_id'                     => 'Transaksjonen må ha ein (vilkårleg) ekstern ID',
    'search_modifier_not_no_external_url'                 => 'Transaksjonen må ha ein (vilkårleg) ekstern URL',
    'search_modifier_not_no_external_id'                  => 'Transaksjonen må ha ein (vilkårleg) ekstern ID',
    'search_modifier_internal_reference_is'               => 'Intern referanse er ":value"',
    'search_modifier_not_internal_reference_is'           => 'Intern referanse er ikkje ":value"',
    'search_modifier_description_starts'                  => 'Beskrivinga byrjar med ":value',
    'search_modifier_not_description_starts'              => 'Beskrivinga byrjar ikkje med ":value"',
    'search_modifier_description_ends'                    => 'Beskrivinga sluttar på ":value',
    'search_modifier_not_description_ends'                => 'Beskrivinga sluttar ikkje på ":value',
    'search_modifier_description_contains'                => 'Beskrivinga inneheld ":value"',
    'search_modifier_not_description_contains'            => 'Beskrivinga inneheld ikkje ":value',
    'search_modifier_description_is'                      => 'Beskrivinga er nøyaktig ":value""',
    'search_modifier_not_description_is'                  => 'Beskrivinga er nøyaktig ikkje ":value',
    'search_modifier_currency_is'                         => 'Transaksjon (fremmed) valuta er ":value"',
    'search_modifier_not_currency_is'                     => 'Transaksjon (fremmed) valuta er ikkje ":value"',
    'search_modifier_foreign_currency_is'                 => 'Transaksjonen for utenlansk valuta er ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaksjonen fremmed valuta er ikkje ":value"',
    'search_modifier_has_attachments'                     => 'Transaksjonen må ha minst eit vedlegg',
    'search_modifier_has_no_category'                     => 'Transaksjonen kan ikkje ha nokon kategori',
    'search_modifier_not_has_no_category'                 => 'Transaksjonen må ha ein (vilkårleg) kategori',
    'search_modifier_not_has_any_category'                => 'Transaksjonen må ikkje ha nokon kategori',
    'search_modifier_has_any_category'                    => 'Transaksjonen må ha ein (nokre) kategori(ar)',
    'search_modifier_has_no_budget'                       => 'Transaksjonen må ikkje ha noko budsjett',
    'search_modifier_not_has_any_budget'                  => 'Transaksjonen må ikkje ha noko budsjett',
    'search_modifier_has_any_budget'                      => 'Transaksjonen må ha ein (nokre) kategori(ar)',
    'search_modifier_not_has_no_budget'                   => 'Transaksjonen må ha eit (kva som helst) budsjett',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transaksjonen må ikkje ha nøkkelord',
    'search_modifier_not_has_any_tag'                     => 'Transaksjonen må ikkje ha nøkkelord',
    'search_modifier_not_has_no_tag'                      => 'Transaksjonen må ha eit (vilkårleg) nøkkelord',
    'search_modifier_has_any_tag'                         => 'Transaksjonen må ha minst eit (vilkårleg) nøkkelord',
    'search_modifier_notes_contains'                      => 'Transaksjonsnotata inneheld ":value"',
    'search_modifier_not_notes_contains'                  => 'Transaksjonsnotata inneheld ikkje ":value',
    'search_modifier_notes_starts'                        => 'Transaksjons notat inneheld ":value"',
    'search_modifier_not_notes_starts'                    => 'Transaksjonsnotata byrjar ikkje med ":value',
    'search_modifier_notes_ends'                          => 'Transaksjons notat ender med ":value"',
    'search_modifier_not_notes_ends'                      => 'Transaksjonsnotata sluttar ikkje med ":value',
    'search_modifier_notes_is'                            => 'Transaksjonsnotata er nøyaktig ":value"',
    'search_modifier_not_notes_is'                        => 'Transaksjonsnotata er nøyaktig ikkje ":value',
    'search_modifier_no_notes'                            => 'Transaksjonen har ingen notat',
    'search_modifier_not_no_notes'                        => 'Transaksjonen må ha notat',
    'search_modifier_any_notes'                           => 'Transaksjonen må ha notat',
    'search_modifier_not_any_notes'                       => 'Transaksjonen har ingen notat',
    'search_modifier_amount_is'                           => 'Beløpet er nøyaktig :value',
    'search_modifier_not_amount_is'                       => 'Beløpet er ikkje :value',
    'search_modifier_amount_less'                         => 'Beløpet er mindre enn eller lik :value',
    'search_modifier_not_amount_more'                     => 'Beløpet er mindre enn eller lik :value',
    'search_modifier_amount_more'                         => 'Beløpet er meir enn eller lik :value',
    'search_modifier_not_amount_less'                     => 'Beløpet er meir enn eller lik :value',
    'search_modifier_source_account_is'                   => 'Kjeldekonto er nøyaktig ":value"',
    'search_modifier_not_source_account_is'               => 'Kjeldekonto namn er ikkje ":value"',
    'search_modifier_source_account_contains'             => 'Kjeldekonto namn inneheld ":value"',
    'search_modifier_not_source_account_contains'         => 'Kjeldekonto namn inneheld ikkje ":value"',
    'search_modifier_source_account_starts'               => 'Kjeldekonto namn byrjar med ":value"',
    'search_modifier_not_source_account_starts'           => 'Kjeldekonto namn byrjar ikkje med ":value"',
    'search_modifier_source_account_ends'                 => 'Kild konto namn sluttar med ":value"',
    'search_modifier_not_source_account_ends'             => 'Kjeldekonto namn sluttar ikkje med ":value"',
    'search_modifier_source_account_id'                   => 'Kjeldekonto ID er :value',
    'search_modifier_not_source_account_id'               => 'Kjeldekonto ID er ikkje :value',
    'search_modifier_source_account_nr_is'                => 'Kjeldekontonummer (IBAN) er ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Kjeldekonto nummer (IBAN) er ikkje ":value"',
    'search_modifier_source_account_nr_contains'          => 'Kjeldekontonummer (IBAN) inneheld ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Kjeldekonto nummer (IBAN) inneheld ikkje ":value"',
    'search_modifier_source_account_nr_starts'            => 'Kjeldekontonummer (IBAN) byrjar med ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Kjeldekonto nummer (IBAN) byrjar ikkje med ":value"',
    'search_modifier_source_account_nr_ends'              => 'Kjeldekonto nummer (IBAN) sluttar på ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Kjeldekonto nummer (IBAN) sluttar ikkje på ":value"',
    'search_modifier_destination_account_is'              => 'Målkontonamn er nøyaktig ":value"',
    'search_modifier_not_destination_account_is'          => 'Målkonto namn er ikkje ":value"',
    'search_modifier_destination_account_contains'        => 'Målkontonamnet inneheld ":value"',
    'search_modifier_not_destination_account_contains'    => 'Målkonto namn inneheld ikkje ":value"',
    'search_modifier_destination_account_starts'          => 'Målkontonamnet byrjar med ":value"',
    'search_modifier_not_destination_account_starts'      => 'Målkonto namn byrjar ikkje med ":value"',
    'search_modifier_destination_account_ends'            => 'Målkonto namn sluttar på ":value"',
    'search_modifier_not_destination_account_ends'        => 'Målkonto namn sluttar ikkje på ":value"',
    'search_modifier_destination_account_id'              => 'Målkonto ID er :value',
    'search_modifier_not_destination_account_id'          => 'Målkonto ID er ikkje :value',
    'search_modifier_destination_is_cash'                 => 'Målkonto er "(cash)"-kontoen',
    'search_modifier_not_destination_is_cash'             => 'Målkonto er ikkje "(cash)"-kontoen',
    'search_modifier_source_is_cash'                      => 'Kjeldekonto er "(cash)"-kontoen',
    'search_modifier_not_source_is_cash'                  => 'Kjeldekonto er ikkje "(cash)"-kontoen',
    'search_modifier_destination_account_nr_is'           => 'Målkontonummer (IBAN) er ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Målkonto nummer (IBAN) er ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Målkontonummer (IBAN) inneheld ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Målkonto nummer (CIBAN) inneheld ikkje ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Målkontonummer (CIBAN) byrjar med ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Målkonto nummer (CIBAN) byrjar ikkje med ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Kjeldekontonummer (IBAN) sluttar med ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Målkonto nummer (CIBAN) ender ikkje med ":value"',
    'search_modifier_account_id'                          => 'Kjelde eller målkonto-IDer er: :value',
    'search_modifier_not_account_id'                      => 'Kjelde eller målkonto ID er/er ikkje: :value',
    'search_modifier_category_is'                         => 'Kategorien er ":value"',
    'search_modifier_not_category_is'                     => 'Kategorien er ikkje ":value"',
    'search_modifier_budget_is'                           => 'Budsjettet er ":value"',
    'search_modifier_not_budget_is'                       => 'Budsjettet er ikkje ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Transaksjonstype er ":value"',
    'search_modifier_not_transaction_type'                => 'Transaksjonstype er ikkje ":value"',
    'search_modifier_tag_is'                              => 'Nøkkelordet er «:value»',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'Ingen nøkkelord er «:value»',
    'search_modifier_date_on_year'                        => 'Transaksjonen er i år ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaksjonen er ikkje i året ":value"',
    'search_modifier_date_on_month'                       => 'Transaksjonen er i månaden ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaksjonen er ikkje i måneden ":value"',
    'search_modifier_date_on_day'                         => 'Transaksjonen er på dagen i måneden ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaksjonen er ikkje på dagen for månaden ":value"',
    'search_modifier_date_before_year'                    => 'Transaksjonen er før eller i år ":value"',
    'search_modifier_date_before_month'                   => 'Transaksjonen er før eller i månaden ":value"',
    'search_modifier_date_before_day'                     => 'Transaksjonen er før eller på dagen i månaden ":value"',
    'search_modifier_date_after_year'                     => 'Transaksjonen er i eller etter år ":value"',
    'search_modifier_date_after_month'                    => 'Transaksjonen er i eller etter månaden ":value"',
    'search_modifier_date_after_day'                      => 'Transaksjonen er etter eller på dagen i månaden ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Ingen nøkkelord er «:value»',
    'search_modifier_not_tag_is_not'                      => 'Nøkkelordet er «:value»',
    'search_modifier_account_is'                          => 'Alle kontoane er ":value"',
    'search_modifier_not_account_is'                      => 'Ingen av kontoane er ":value"',
    'search_modifier_account_contains'                    => 'Alle kontoane inneheld ":value"',
    'search_modifier_not_account_contains'                => 'Ingen av kontoane inneheld ":value"',
    'search_modifier_account_ends'                        => 'Alle kontoane sluttar med ":value"',
    'search_modifier_not_account_ends'                    => 'Ingen av kontoane sluttar med ":value"',
    'search_modifier_account_starts'                      => 'Alle kontoane byrjar med ":value"',
    'search_modifier_not_account_starts'                  => 'Ingen av kontoane byrjar med ":value"',
    'search_modifier_account_nr_is'                       => 'Alle kontonummer / IBAN er ":value"',
    'search_modifier_not_account_nr_is'                   => 'Ingen kontonummer / IBAN er ":value"',
    'search_modifier_account_nr_contains'                 => 'Alle kontonummer / IBAN inneheld ":value"',
    'search_modifier_not_account_nr_contains'             => 'Ingen kontonummer / IBAN inneheld ":value"',
    'search_modifier_account_nr_ends'                     => 'Alle kontonummer / IBAN sluttar med ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Ingen kontonummer / IBAN sluttar med ":value"',
    'search_modifier_account_nr_starts'                   => 'Alle kontonummer / IBAN byrjar med ":value"',
    'search_modifier_not_account_nr_starts'               => 'Ingen kontonummer / IBAN byrjar med ":value"',
    'search_modifier_category_contains'                   => 'Kategorien inneheld ":value"',
    'search_modifier_not_category_contains'               => 'Kategorien inneheld ikkje ":value"',
    'search_modifier_category_ends'                       => 'Kategorien sluttar på ":value"',
    'search_modifier_not_category_ends'                   => 'Kategorien sluttar ikkje på ":value"',
    'search_modifier_category_starts'                     => 'Kategorien byrjar med ":value"',
    'search_modifier_not_category_starts'                 => 'Kategorien byrjar ikkje med ":value"',
    'search_modifier_budget_contains'                     => 'Budsjettet inneheld ":value"',
    'search_modifier_not_budget_contains'                 => 'Budsjettet inneheld ikkje ":value"',
    'search_modifier_budget_ends'                         => 'Budsjettet sluttar med ":value"',
    'search_modifier_not_budget_ends'                     => 'Budsjettet sluttar ikkje på ":value"',
    'search_modifier_budget_starts'                       => 'Budsjettet byrjar med ":value"',
    'search_modifier_not_budget_starts'                   => 'Budsjettet byrjar ikkje med ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'Ekstern ID inneheld ":value"',
    'search_modifier_not_external_id_contains'            => 'Ekstern ID inneheld ikkje ":value"',
    'search_modifier_external_id_ends'                    => 'Ekstern ID sluttar med ":value"',
    'search_modifier_not_external_id_ends'                => 'Ekstern ID sluttar ikkje med ":value"',
    'search_modifier_external_id_starts'                  => 'Ekstern ID byrjar med ":value"',
    'search_modifier_not_external_id_starts'              => 'Ekstern ID byrjar ikkje med ":value"',
    'search_modifier_internal_reference_contains'         => 'Intern referanse inneheld ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Intern referanse inneheld ikkje ":value"',
    'search_modifier_internal_reference_ends'             => 'Intern referanse sluttar med ":value"',
    'search_modifier_internal_reference_starts'           => 'Intern referanse byrjar med ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Intern referanse sluttar ikkje med ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Intern referanse byrjar ikkje med ":value"',
    'search_modifier_external_url_is'                     => 'Ekstern URL er ":value"',
    'search_modifier_not_external_url_is'                 => 'Ekstern URL er ikkje ":value"',
    'search_modifier_external_url_contains'               => 'Ekstern URL inneheld ":value"',
    'search_modifier_not_external_url_contains'           => 'Ekstern URL inneheld ikkje ":value"',
    'search_modifier_external_url_ends'                   => 'Ekstern URL sluttar med ":value"',
    'search_modifier_not_external_url_ends'               => 'Ekstern URL sluttar ikkje med ":value"',
    'search_modifier_external_url_starts'                 => 'Ekstern URL byrjar med ":value"',
    'search_modifier_not_external_url_starts'             => 'Ekstern URL byrjar ikkje med ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaksjonen har ingen vedlegg',
    'search_modifier_not_has_no_attachments'              => 'Transaksjonen har vedlegg',
    'search_modifier_not_has_attachments'                 => 'Transaksjonen har ingen vedlegg',
    'search_modifier_account_is_cash'                     => 'Alle konti er "(cash)"-konto.',
    'search_modifier_not_account_is_cash'                 => 'Ingen konti er "(cash)"-kontoen.',
    'search_modifier_journal_id'                          => 'Journal ID er ":value"',
    'search_modifier_not_journal_id'                      => 'Journal ID er ikkje ":value"',
    'search_modifier_recurrence_id'                       => 'Den gjentakande transaksjons ID er ":value"',
    'search_modifier_not_recurrence_id'                   => 'Den gjentakande transaksjons ID er ikkje ":value"',
    'search_modifier_foreign_amount_is'                   => 'Det utenlandske beløpet er ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Det utenlandske beløpet er ikkje ":value"',
    'search_modifier_foreign_amount_less'                 => 'Det utenlandske beløpet er mindre enn ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Det utenlandske beløpet er mindre enn ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Det utenlandske beløpet er meir enn ":value"',
    'search_modifier_foreign_amount_more'                 => 'Det utenlandske beløpet er meir enn ":value"',
    'search_modifier_exists'                              => 'Transaksjon eksisterer (vilkårleg transaksjon)',
    'search_modifier_not_exists'                          => 'Transaksjonen eksisterer ikkje (alle transaksjonar)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaksjonens rentedato er ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaksjonens rentedato er ikkje ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaksjonsrentens dato er i år ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaksjonens rentedato er ikkje i år ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaksjonsrentens dato er i månaden ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaksjonens rentedato er ikkje i månaden ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaksjonsrentens dato er på dagen i månaden ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaksjonens rentedato er ikkje på dag i månaden ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaksjonsrentens dato er før eller i år ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaksjonsrentens dato er før eller i månaden ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaksjonsrentenedato er før eller på dagen i månaden ":value',
    'search_modifier_interest_date_after_year'            => 'Transaksjonsrentens dato er etter eller i år ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaksjonsrentens dato er etter eller i månaden ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaksjonsrentens dato er etter eller på dagen i månaden ":value',
    'search_modifier_book_date_on_year'                   => 'Bokføringsdato for transaksjonen er i år ":value"',
    'search_modifier_book_date_on_month'                  => 'Bokføringsdato for transaksjonen er i månaden ":value"',
    'search_modifier_book_date_on_day'                    => 'Bokføringsdato for transaksjonen er på dagen i månaden ":value"',
    'search_modifier_not_book_date_on_year'               => 'Bokføringsdato for transaksjonen er ikkje i år ":value"',
    'search_modifier_not_book_date_on_month'              => 'Bokføringsdato for transaksjonen er ikkje i månaden ":value"',
    'search_modifier_not_book_date_on_day'                => 'Bokføringsdato for transaksjonen er ikkje på dag i månaden ":value"',
    'search_modifier_book_date_before_year'               => 'Transaksjons bokdato er før eller i år ":value"',
    'search_modifier_book_date_before_month'              => 'Bokføringsdato for transaksjonen er før eller i månaden ":value"',
    'search_modifier_book_date_before_day'                => 'Bokføringsdato for transaksjonen er før eller på dagen i månaden ":value"',
    'search_modifier_book_date_after_year'                => 'Bokføringsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_book_date_after_month'               => 'Bokføringsdato for transaksjonen er etter eller i månaden ":value"',
    'search_modifier_book_date_after_day'                 => 'Bokføringsdato for transaksjonen er etter eller på dagen i månaden ":value"',
    'search_modifier_process_date_on_year'                => 'Transaksjonsprosessdato er i år ":value"',
    'search_modifier_process_date_on_month'               => 'Transaksjonsprosessdato er i månaden ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaksjonsprosessdato er på dagen i månaden ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaksjonens utførelsesdato er ikkje i år ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaksjonens utførelsesdato er ikkje i månaden ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaksjonen er ikkje på dagen for månaden ":value',
    'search_modifier_process_date_before_year'            => 'Transaksjonsprosessdato er før eller i år ":value"',
    'search_modifier_process_date_before_month'           => 'Transaksjonsdato er før eller i månaden ":value"',
    'search_modifier_process_date_before_day'             => 'Transaksjonsprosessdato er før eller på dagen i månaden ":value"',
    'search_modifier_process_date_after_year'             => 'Transaksjonsprosessdato er etter eller i år ":value"',
    'search_modifier_process_date_after_month'            => 'Transaksjonsprosessdato er etter eller i månaden ":value"',
    'search_modifier_process_date_after_day'              => 'Transaksjonsprosessdato er etter eller på dagen i månaden ":value',
    'search_modifier_due_date_on_year'                    => 'Forfallsdato for transaksjonen er i år ":value"',
    'search_modifier_due_date_on_month'                   => 'Forfallsdato for transaksjonen er i månaden ":value"',
    'search_modifier_due_date_on_day'                     => 'Forfallsdato for transaksjonen er på dagen i månaden ":value"',
    'search_modifier_not_due_date_on_year'                => 'Forfallsdato for transaksjonen er ikkje i år ":value"',
    'search_modifier_not_due_date_on_month'               => 'Forfallsdato for transaksjonen er ikkje i månaden ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Forfallsdato for transaksjonen er ikkje på dag i månaden ":value"',
    'search_modifier_due_date_before_year'                => 'Forfallsdato for transaksjonen er før eller i år ":value"',
    'search_modifier_due_date_before_month'               => 'Forfallsdato for transaksjonen er før eller i månaden ":value"',
    'search_modifier_due_date_before_day'                 => 'Forfallsdato for transaksjonen er før eller på dagen i måneden ":value"',
    'search_modifier_due_date_after_year'                 => 'Forfallsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_due_date_after_month'                => 'Forfallsdato for transaksjonen er etter eller i månaden ":value"',
    'search_modifier_due_date_after_day'                  => 'Forfallsdato for transaksjonen er etter eller på dagen i månaden ":value',
    'search_modifier_payment_date_on_year'                => 'Betalingsdato i år ":value"',
    'search_modifier_payment_date_on_month'               => 'Betalingsdato for transaksjonen er i månaden ":value"',
    'search_modifier_payment_date_on_day'                 => 'Betalingsdato for transaksjonen er på dagen i månaden ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Betalingsdato for transaksjonen er ikkje i år ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Betalingsdato for transaksjonen er ikkje i månaden ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Betalingsdato for transaksjonen er ikkje på dagen i månaden ":value"',
    'search_modifier_payment_date_before_year'            => 'Betalingsdato for transaksjonen er før eller i år ":value"',
    'search_modifier_payment_date_before_month'           => 'Betalingsdato for transaksjonen er før eller i månaden ":value"',
    'search_modifier_payment_date_before_day'             => 'Betalingsdato for transaksjonen er før eller på dagen i månaden ":value"',
    'search_modifier_payment_date_after_year'             => 'Betalingsdato for transaksjonen er etter eller i år ":value"',
    'search_modifier_payment_date_after_month'            => 'Bokføringsdato for transaksjonen er etter eller i månaden ":value"',
    'search_modifier_payment_date_after_day'              => 'Betalingsdato for transaksjonen er etter eller på dagen i månaden ":value"',
    'search_modifier_invoice_date_on_year'                => 'Fakturadato for transaksjon er i år ":value"',
    'search_modifier_invoice_date_on_month'               => 'Fakturadato for transaksjon er i månaden ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Fakturadato for transaksjon er på dagen i månaden ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Fakturadato for transaksjonen er ikkje i år ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Fakturadato for transaksjonen er ikkje i månaden ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Fakturadato for transaksjon er ikkje på dag i månaden ":value"',
    'search_modifier_invoice_date_before_year'            => 'Fakturadato for transaksjon er før eller i år ":value"',
    'search_modifier_invoice_date_before_month'           => 'Fakturadato for transaksjon er før eller i månaden ":value"',
    'search_modifier_invoice_date_before_day'             => 'Fakturadato for transaksjon er før eller på dagen i månaden ":value"',
    'search_modifier_invoice_date_after_year'             => 'Fakturadato for transaksjon er etter eller i år ":value"',
    'search_modifier_invoice_date_after_month'            => 'Fakturadato for transaksjon er etter eller i månaden ":value"',
    'search_modifier_invoice_date_after_day'              => 'Fakturadato for transaksjon er etter eller på dagen i månaden ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaksjonen vart oppdatert i år ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaksjonen vart oppdatert i månaden ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaksjonen vart sist oppdatert på dagen i månaden ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaksjonen vart ikkje oppdatert sist i år ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaksjonen vart ikkje sist oppdatert i månaden ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaksjonen vart ikkje sist oppdatert på dag i månaden ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaksjonen vart sist oppdatert i eller før år ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaksjonen vart sist oppdatert i eller før månaden ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaksjonen vart sist oppdatert på eller før dag i månaden ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaksjonen vart sist oppdatert i eller etter år ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaksjonen vart sist oppdatert i eller etter månaden ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaksjonen vart sist oppdatert på eller etter ein dag i månaden ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaksjonen vart oppretta i år ":value',
    'search_modifier_created_at_on_month'                 => 'Transaksjonen vart oppretta i månaden ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaksjonen vart oppretta på dag i månaden ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaksjonen vart ikkje oppretta i år ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaksjonen vart ikkje oppretta i månaden ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaksjonen vart ikkje oppretta på dag i måneden ":value"',
    'search_modifier_created_at_before_year'              => 'Transaksjonen vart oppretta i eller før år ":value"',
    'search_modifier_created_at_before_month'             => 'Transaksjonen vart oppretta i eller før månaden ":value"',
    'search_modifier_created_at_before_day'               => 'Transaksjonen vart oppretta på eller før dag i måneden ":value"',
    'search_modifier_created_at_after_year'               => 'Transaksjonen vart oppretta i eller etter år ":value"',
    'search_modifier_created_at_after_month'              => 'Transaksjonen vart oppretta i eller etter månaden ":value"',
    'search_modifier_created_at_after_day'                => 'Transaksjonen vart oppretta på eller etter dag i måneden ":value',
    'search_modifier_interest_date_before'                => 'Transaksjonsrentens dato er på eller før ":value"',
    'search_modifier_interest_date_after'                 => 'Transaksjonens rentedato er på eller etter ":value"',
    'search_modifier_book_date_on'                        => 'Bokføringsdato for transaksjonen er ":value"',
    'search_modifier_not_book_date_on'                    => 'Bokføringsdato for transaksjonen er ikkje ":value"',
    'search_modifier_book_date_before'                    => 'Bokføringsdato for transaksjonen er på eller før ":value"',
    'search_modifier_book_date_after'                     => 'Bokføringsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_process_date_on'                     => 'Transaksjonens utførelsesdato er ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaksjonens utførelsesdato er ikkje ":value"',
    'search_modifier_process_date_before'                 => 'Transaksjonens utførelsesdato er på eller før ":value"',
    'search_modifier_process_date_after'                  => 'Transaksjonens utførelsesdato er på eller etter ":value"',
    'search_modifier_due_date_on'                         => 'Forfallsdato for transaksjonen er ":value"',
    'search_modifier_not_due_date_on'                     => 'Forfallsdato for transaksjonen er ikkje ":value"',
    'search_modifier_due_date_before'                     => 'Forfallsdato for transaksjonen er på eller før ":value"',
    'search_modifier_due_date_after'                      => 'Forfallsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_payment_date_on'                     => 'Betalingsdato for transaksjonen er ":value"',
    'search_modifier_not_payment_date_on'                 => 'Betalingsdato for transaksjonen er ikkje ":value"',
    'search_modifier_payment_date_before'                 => 'Betalingsdato for transaksjonen er på eller før ":value"',
    'search_modifier_payment_date_after'                  => 'Betalingsdato for transaksjonen er på eller etter ":value"',
    'search_modifier_invoice_date_on'                     => 'Fakturadato for transaksjon er på ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Fakturadato for transaksjon er ikkje ":value"',
    'search_modifier_invoice_date_before'                 => 'Fakturadato for transaksjon er på eller før ":value"',
    'search_modifier_invoice_date_after'                  => 'Fakturadato for transaksjon er på eller etter ":value"',
    'search_modifier_created_at_on'                       => 'Transaksjonen vart oppretta på ":value',
    'search_modifier_not_created_at_on'                   => 'Transaksjonen vart ikkje oppretta på ":value',
    'search_modifier_created_at_before'                   => 'Transaksjonen vart oppretta på eller før ":value"',
    'search_modifier_created_at_after'                    => 'Transaksjonen vart oppretta på eller etter ":value"',
    'search_modifier_updated_at_on'                       => 'Transaksjonen vart oppdatert ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaksjonen vart ikkje oppdatert ":value"',
    'search_modifier_updated_at_before'                   => 'Transaksjonen vart oppdatert på dato eller før ":value"',
    'search_modifier_updated_at_after'                    => 'Transaksjonen vart oppdatert på eller etter ":value"',

    'search_modifier_attachment_name_is'            => 'Namn på vedlegg er ":value"',
    'search_modifier_attachment_name_contains'      => 'Namn på vedlegg inneheld ":value"',
    'search_modifier_attachment_name_starts'        => 'Namn på vedlegg byrjar med ":value"',
    'search_modifier_attachment_name_ends'          => 'Namn på vedlegg sluttar med ":value"',
    'search_modifier_attachment_notes_are'          => 'Notat på eventuelle vedlegg er ":value"',
    'search_modifier_attachment_notes_contains'     => 'Notat på eventuelle vedlegg inneheld ":value"',
    'search_modifier_attachment_notes_starts'       => 'Notat på eventuelle vedlegg byrjar med ":value"',
    'search_modifier_attachment_notes_ends'         => 'Notat på eventuelle vedlegg sluttar med ":value"',
    'search_modifier_not_attachment_name_is'        => 'Namn på vedlegg er ikkje ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Namn på vedlegg inneheld ikkje ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Namn på vedlegg byrjar ikkje med ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Namn på vedlegg sluttar ikkje med ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Notat på eventuelle vedlegg er ikkje ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Notat på eventuelle vedlegg inneheld ikkje ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Notat på eventuelle vedlegg byrjar med ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Notat på eventuelle vedlegg sluttar ikkje med ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT er ":value"',
    'update_rule_from_query'                        => 'Oppdater regel ":rule" frå søk',
    'create_rule_from_query'                        => 'Lag ny regel frå søk',
    'rule_from_search_words'                        => 'Regelverksmotoren har problemer med søkeparameteren ":string". Den foreslåtte regelen som passar til ditt søk kan gje eit anna resultat. Ver venleg å kontroller reglane nøye.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Det oppstod ein feil under søking. Ver venleg å sjekk loggfilene for meir informasjon.',
    'search_box'                                          => 'Søk',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Feil under søking',
    'search_searching'                                    => 'Søker ...',
    'search_results'                                      => 'Søkeresultater',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'årleg',
    'repeat_freq_half-year'                               => 'kvart halvår',
    'repeat_freq_quarterly'                               => 'kvartalsvis',
    'repeat_freq_monthly'                                 => 'månadleg',
    'repeat_freq_weekly'                                  => 'ukentlig',
    'repeat_freq_daily'                                   => 'dagleg',
    'daily'                                               => 'dagleg',
    'weekly'                                              => 'ukentlig',
    'quarterly'                                           => 'kvartalsvis',
    'half-year'                                           => 'kvart halvår',
    'yearly'                                              => 'årleg',

    // rules
    'is_not_rule_trigger'                                 => 'Ikke',
    'cannot_fire_inactive_rules'                          => 'Du kan ikkje køyra inaktive reglar.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Regler',
    'rule_name'                                           => 'Namn på regel',
    'rule_triggers'                                       => 'Regel utløses når',
    'rule_actions'                                        => 'Regel vil',
    'new_rule'                                            => 'Ny regel',
    'new_rule_group'                                      => 'Ny regelgruppe',
    'rule_priority_up'                                    => 'Gi regel høyere prioritet',
    'rule_priority_down'                                  => 'Gi regel lavere prioritet',
    'make_new_rule_group'                                 => 'Opprett ny regelgruppe',
    'store_new_rule_group'                                => 'Lagra ny regelgruppe',
    'created_new_rule_group'                              => 'Ny regelgruppe ":title" vart lagra!',
    'updated_rule_group'                                  => 'Oppdaterte regelgruppen ":title".',
    'edit_rule_group'                                     => 'Rediger regelgruppe ":title"',
    'duplicate_rule'                                      => 'Kopier regel ":title"',
    'rule_copy_of'                                        => 'Duplikat av ":title"',
    'duplicated_rule'                                     => 'Duplisert regel:title" inn i ":newTitle"',
    'delete_rule_group'                                   => 'Slett regelgruppe ":title"',
    'deleted_rule_group'                                  => 'Sletta regelgruppe ":title"',
    'update_rule_group'                                   => 'Oppdater regelgruppe',
    'no_rules_in_group'                                   => 'Det eksisterar ingen reglar i denne gruppen',
    'move_rule_group_up'                                  => 'Flytt regelgruppen opp',
    'move_rule_group_down'                                => 'Flytt regelgruppen ned',
    'save_rules_by_moving'                                => 'Lagra denne regelen ved å flytte den til ein annan regelgruppe: Lagra desse reglane ved å flytte dei til ein annan regelgruppe:',
    'make_new_rule'                                       => 'Opprett ny regel i regelgruppen ":title"',
    'make_new_rule_no_group'                              => 'Lag ein ny regel',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Opprett ein regel basert på ein av dine transaksjonar. Fullfør eller send inn skjemaet nedanfor.',
    'rule_is_strict'                                      => 'strikt regel',
    'rule_is_not_strict'                                  => 'ikkje-strikt regel',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'I strikte reglar må ALLE triggere slå til for at aksjonen skal verta utført. Ved ikkje-strikt reglar kan UANSETT trigger få aksjonen til å verta utført.',
    'rule_help_active'                                    => 'Inaktive reglar vil aldri utløses.',
    'stored_new_rule'                                     => 'Lagret ny regel med tittel ":title"',
    'deleted_rule'                                        => 'Sletta regel med tittel ":title"',
    'store_new_rule'                                      => 'Lagra ny regel',
    'updated_rule'                                        => 'Oppdaterte regel med tittel ":title"',
    'default_rule_group_name'                             => 'Standardregler',
    'default_rule_group_description'                      => 'Alle dine reglar ligg ikkje i noko bestemt gruppe.',
    'trigger'                                             => 'Utløser',
    'trigger_value'                                       => 'Utløs på verdi',
    'stop_processing_other_triggers'                      => 'Slutt å prosessere andre utløsere',
    'add_rule_trigger'                                    => 'Legg til ny utløser',
    'action'                                              => 'Handling',
    'action_value'                                        => 'Handlingsverdi',
    'stop_executing_other_actions'                        => 'Slutt å utføre andre handlinger',
    'add_rule_action'                                     => 'Legg til ny handling',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Slett regel ":title"',
    'update_rule'                                         => 'Oppdater regel',
    'test_rule_triggers'                                  => 'Sjå transaksjonar som passar',
    'warning_no_matching_transactions'                    => 'Ingen samsvarende transaksjonar funnet.',
    'warning_no_valid_triggers'                           => 'Ingen gyldige utløsere oppgitt.',
    'apply_rule_selection'                                => 'Bruk regel ":title" til eit utval av dine transaksjonar',
    'apply_rule_selection_intro'                          => 'Regler som «:title» vert vanlegvis berre brukt til nye eller oppdaterte transaksjonar, men du kan få Firefly III til å køyra dei på eit utval av dine eksisterande transaksjonar. Dette kan vera nyttig når du har oppdatert ein regel, og du treng at endringane vert brukt på alle dine tidlegare transaksjonar.',
    'include_transactions_from_accounts'                  => 'Ta med transaksjonar frå desse kontoane',
    'include'                                             => 'Inkluder?',
    'applied_rule_selection'                              => '{0} Ingen transaksjonar i ditt utval vart endra med regel ":title.[1] Ein transaksjon i ditt val vart endra av regel ":title". [2,*] :count transaksjonar i utvalet vart endra ved regel ":title. ".',
    'execute'                                             => 'Kjør',
    'apply_rule_group_selection'                          => 'Bruk regelgruppe ":title" til eit utval av dine transaksjonar',
    'apply_rule_group_selection_intro'                    => 'Regelgrupper som «:title» vert vanlegvis berre berre brukt til nye eller oppdaterte transaksjonar, men du kan få Firefly III til å køyra dei på eit utval av dine eksisterande transaksjonar. Dette kan vera nyttig når du har oppdatert ei regelgruppe, og du treng at endringane vert brukt på alle dine tidlegare transaksjonar.',
    'applied_rule_group_selection'                        => 'Regelgruppe ":title" har vorte brukt på ditt utval.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Når ein transaksjon er opprettet',
    'rule_trigger_update_journal'                         => 'Når ein transaksjon er oppdatert',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Brukarhandling er ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Kjeldekonto namn byrjar med..',
    'rule_trigger_source_account_starts'                  => 'Kjeldenamnet byrjar med ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Kjeldenamnet sluttar med..',
    'rule_trigger_source_account_ends'                    => 'Kjeldekontonamnet sluttar med ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Kjeldekonto namn er..',
    'rule_trigger_source_account_is'                      => 'Kjeldekonto namnet er ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Kjeldekonto namn inneheld..',
    'rule_trigger_source_account_contains'                => 'Kjeldekonto namnet inneheld ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Ein av konto ID\'er, er nøyaktig.',
    'rule_trigger_account_id'                             => 'Ein av konto ID\'er, er nøyaktig :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Kjeldekonto-ID er nøyaktig..',
    'rule_trigger_source_account_id'                      => 'Kjeldekonto-IDen er nøyaktig :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Målkonto ID er nøyaktig..',
    'rule_trigger_destination_account_id'                 => 'Målkonto ID er nøyaktig :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Ein av konto er kontant',
    'rule_trigger_account_is_cash'                        => 'Ein av konto er kontant',
    'rule_trigger_source_is_cash_choice'                  => 'Kjeldekonto er (kontant) konto',
    'rule_trigger_source_is_cash'                         => 'Kjeldekonto er (kontant) konto',
    'rule_trigger_destination_is_cash_choice'             => 'Målkonto er (kontant) konto',
    'rule_trigger_destination_is_cash'                    => 'Målkonto er (kontant) konto',
    'rule_trigger_source_account_nr_starts_choice'        => 'Kjeldekontonummer / IBAN byrjar med..',
    'rule_trigger_source_account_nr_starts'               => 'Kjeldekontoummer / IBAN byrjar med ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Kjeldekontonummer / IBAN sluttar med..',
    'rule_trigger_source_account_nr_ends'                 => 'Kjeldekontoummer / IBAN sluttar med ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Kjeldekontonummer / IBAN er..',
    'rule_trigger_source_account_nr_is'                   => 'Kjeldekontoummer / IBAN er ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Kjeldekontonummer / IBAN inneheld..',
    'rule_trigger_source_account_nr_contains'             => 'Kjeldekontonummer / IBAN inneheld ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Målkontonamnet byrjar med..',
    'rule_trigger_destination_account_starts'             => 'Målkontonamnet byrjar med ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Målkontonamnet sluttar med..',
    'rule_trigger_destination_account_ends'               => 'Målkonto namn sluttar med ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Målkonto namn sluttar med..',
    'rule_trigger_destination_account_is'                 => 'Målkontonamn er ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Målkontonamn inneheld..',
    'rule_trigger_destination_account_contains'           => 'Målkontonamnet inneheld ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Målkontonummer / IBAN byrjar med..',
    'rule_trigger_destination_account_nr_starts'          => 'Målkontonummer / IBAN byrjar med ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Målkontonummer / IBAN sluttar med..',
    'rule_trigger_destination_account_nr_ends'            => 'Målkontonummer / IBAN sluttar med ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Målkontonummer / IBAN er..',
    'rule_trigger_destination_account_nr_is'              => 'Målkontonummer / IBAN er ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Målkontonummer / IBAN inneheld..',
    'rule_trigger_destination_account_nr_contains'        => 'Målkontonummer / IBAN inneheld ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transaksjonen er av typen..',
    'rule_trigger_transaction_type'                       => 'Transaksjonen er av typen ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategori er..',
    'rule_trigger_category_is'                            => 'Kategori er ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Beløpet er mindre eller lik ..',
    'rule_trigger_amount_less'                            => 'Beløpet er mindre eller likt :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Beløpet er..',
    'rule_trigger_amount_is'                              => 'Beløpet er :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Beløpet er meir eller lik..',
    'rule_trigger_amount_more'                            => 'Beløpet er meir eller lik :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Beskrivinga byrjar med..',
    'rule_trigger_description_starts'                     => 'Beskrivinga byrjar med ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Beskrivinga sluttar med..',
    'rule_trigger_description_ends'                       => 'Beskrivinga sluttar med ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Beskrivinga inneheld..',
    'rule_trigger_description_contains'                   => 'Beskrivinga inneheld ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Beskrivinga er..',
    'rule_trigger_description_is'                         => 'Beskrivinga er ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaksjonsdato er..',
    'rule_trigger_date_on'                                => 'Transaksjons dato er ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transaksjons dato er før..',
    'rule_trigger_date_before'                            => 'Transaksjons dato er før ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transaksjons dato er etter..',
    'rule_trigger_date_after'                             => 'Transaksjons dato er etter ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaksjonen vart gjort på..',
    'rule_trigger_created_at_on'                          => 'Transaksjonen vart gjort på ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaksjonen vart sist redigert den..',
    'rule_trigger_updated_at_on'                          => 'Transaksjonen vart sist redigert den ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budsjett er..',
    'rule_trigger_budget_is'                              => 'Budsjett er ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Eit vilkårleg nøkkelord er..',
    'rule_trigger_tag_is'                                 => 'Eit vilkårleg nøkkelord er «:trigger_value»',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transaksjonsvaluta er..',
    'rule_trigger_currency_is'                            => 'Transaksjonsvaluta er ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transaksjonens fremmed valuta er..',
    'rule_trigger_foreign_currency_is'                    => 'Transaksjonens fremmed valuta er ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Har ingen kategori',
    'rule_trigger_has_no_category'                        => 'Transaksjonen har ingen kategori',
    'rule_trigger_has_any_category_choice'                => 'Har ein (vilkårleg) kategori',
    'rule_trigger_has_any_category'                       => 'Transaksjonen har ein (vilkårleg) kategori',
    'rule_trigger_has_no_budget_choice'                   => 'Har ingen budsjett',
    'rule_trigger_has_no_budget'                          => 'Transaksjonen har ikkje noko budsjett',
    'rule_trigger_has_any_budget_choice'                  => 'Har eit (kva som helst) budsjett',
    'rule_trigger_has_any_budget'                         => 'Transaksjonen har eit (kva som helst) budsjett',
    'rule_trigger_has_no_bill_choice'                     => 'Har ikkje abonnement',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Har ingen nøkkelord',
    'rule_trigger_has_no_tag'                             => 'Transaksjonen har ingen nøkkelord',
    'rule_trigger_has_any_tag_choice'                     => 'Har eit eller fleire (vilkårlege) nøkkelord',
    'rule_trigger_has_any_tag'                            => 'Transaksjonen har ein eller fleire (vikårlege) nøkkelord',
    'rule_trigger_any_notes_choice'                       => 'Har notat',
    'rule_trigger_any_notes'                              => 'Transaksjonen har notat',
    'rule_trigger_no_notes_choice'                        => 'Har ikkje notat',
    'rule_trigger_no_notes'                               => 'Transaksjonen har ikkje notat',
    'rule_trigger_notes_is_choice'                        => 'Notat er..',
    'rule_trigger_notes_is'                               => 'Notat er ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notat inneheld..',
    'rule_trigger_notes_contains'                         => 'Notat inneheld ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notat byrjar med..',
    'rule_trigger_notes_starts'                           => 'Notat byrjar med ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notat sluttar med..',
    'rule_trigger_notes_ends'                             => 'Notat sluttar med ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Ekstern ID er..',
    'rule_trigger_external_id_is'                         => 'Ekstern ID er ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Intern referanse er..',
    'rule_trigger_internal_reference_is'                  => 'Ekstern referanse er ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaksjonens journal ID er..',
    'rule_trigger_journal_id'                             => 'Transaksjonens journal ID er ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaksjonen har ingen ekstern URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaksjons-ID er',
    'rule_trigger_id'                                     => 'Transaksjons ID er ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT er..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT er ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Brukarhandling er ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Ingen nøkkelord er..',
    'rule_trigger_tag_is_not'                             => 'Ingen nøkkelord er «:trigger_value»',
    'rule_trigger_account_is_choice'                      => 'Ein av kontoane er nøyaktig..',
    'rule_trigger_account_is'                             => 'Ein av kontoane er nøyaktig ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Ein av kontoane inneheld..',
    'rule_trigger_account_contains'                       => 'Ein av kontoane inneheld ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Ein av kontoane sluttar med..',
    'rule_trigger_account_ends'                           => 'Beskrivinga sluttar med ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Ein av kontoane byrjar med..',
    'rule_trigger_account_starts'                         => 'Ein av kontoane byrjar med ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Ein av kontoanes nummer / IBAN er..',
    'rule_trigger_account_nr_is'                          => 'Kontonummer / IBAN er ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Kontonummer / IBAN inneheld..',
    'rule_trigger_account_nr_contains'                    => 'Alle kontonummer / IBAN inneheld ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Alle kontonummer / IBAN sluttar med..',
    'rule_trigger_account_nr_ends'                        => 'Alle kontonummer / IBAN sluttar med ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Alle kontonummer / IBAN byrjar med..',
    'rule_trigger_account_nr_starts'                      => 'Alle kontonummer / IBAN byrjar med ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategori inneheld..',
    'rule_trigger_category_contains'                      => 'Kategorien inneheld ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategori slutter med..',
    'rule_trigger_category_ends'                          => 'Kategorien sluttar med ":trigger_value',
    'rule_trigger_category_starts_choice'                 => 'Kategori byrjar med..',
    'rule_trigger_category_starts'                        => 'Kategorien byrjar med ":trigger_value',
    'rule_trigger_budget_contains_choice'                 => 'Budsjett inneheld..',
    'rule_trigger_budget_contains'                        => 'Budsjettet inneheld ":trigger_value',
    'rule_trigger_budget_ends_choice'                     => 'Budsjettet sluttar med..',
    'rule_trigger_budget_ends'                            => 'Budsjettet sluttar med ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budsjettet byrjar med..',
    'rule_trigger_budget_starts'                          => 'Budsjettet byrjar med ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Ekstern ID inneheld..',
    'rule_trigger_external_id_contains'                   => 'Ekstern ID inneheld ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Ekstern ID sluttar med..',
    'rule_trigger_external_id_ends'                       => 'Ekstern ID sluttar med ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Ekstern ID byrjar med..',
    'rule_trigger_external_id_starts'                     => 'Ekstern ID byrjar med ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Intern referanse inneheld..',
    'rule_trigger_internal_reference_contains'            => 'Ekstern referanse ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Intern referanse ender med..',
    'rule_trigger_internal_reference_ends'                => 'Intern referanse ender med ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Intern referanse byrjar med..',
    'rule_trigger_internal_reference_starts'              => 'Intern referanse byrjar med ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Ekstern URL er..',
    'rule_trigger_external_url_is'                        => 'Ekstern URL er ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Ekstern URL inneheld..',
    'rule_trigger_external_url_contains'                  => 'Ekstern URL inneheld ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Ekstern URL sluttar med..',
    'rule_trigger_external_url_ends'                      => 'Ekstern URL sluttar med ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Ekstern URL byrjar med..',
    'rule_trigger_external_url_starts'                    => 'Ekstern URL byrjar med ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Har ingen vedlegg',
    'rule_trigger_has_no_attachments'                     => 'Transaksjonen har ingen vedlegg',
    'rule_trigger_recurrence_id_choice'                   => 'Gjentakande transaksjons ID er..',
    'rule_trigger_recurrence_id'                          => 'Gjentakande transaksjons ID er ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Rentedato er..',
    'rule_trigger_interest_date_on'                       => 'Rentedato er ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Rentedato er før..',
    'rule_trigger_interest_date_before'                   => 'Rentedato er før ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Rentedato er etter..',
    'rule_trigger_interest_date_after'                    => 'Rentedato er etter ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Bokført dato er..',
    'rule_trigger_book_date_on'                           => 'Bokført dato er ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Bokført dato er før..',
    'rule_trigger_book_date_before'                       => 'Bokført dato er før ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Bokført dato er etter..',
    'rule_trigger_book_date_after'                        => 'Bokført dato er etter ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Prosessdato er..',
    'rule_trigger_process_date_on'                        => 'Prosessdato er ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Prosessdato er før..',
    'rule_trigger_process_date_before'                    => 'Prosessdato er før ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Prosessdato er etter..',
    'rule_trigger_process_date_after'                     => 'Prosessdato er etter ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Forfallsdato er..',
    'rule_trigger_due_date_on'                            => 'Forfallsdato er den ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Forfallsdato er før..',
    'rule_trigger_due_date_before'                        => 'Forfallsdato er før ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Forfallsdato er etter..',
    'rule_trigger_due_date_after'                         => 'Forfallsdato er etter ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Betalingsdato er på..',
    'rule_trigger_payment_date_on'                        => 'Betalingsdato er på ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Betalingsdato er før..',
    'rule_trigger_payment_date_before'                    => 'Betalingsdato er før ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Betalingsdato er etter..',
    'rule_trigger_payment_date_after'                     => 'Betalingsdato er etter ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Fakturadato er på..',
    'rule_trigger_invoice_date_on'                        => 'Fakturadato er den ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Fakturadato er før..',
    'rule_trigger_invoice_date_before'                    => 'Fakturadato er før ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Fakturadato er etter..',
    'rule_trigger_invoice_date_after'                     => 'Fakturadato er etter ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaksjonen vart oppretta før..',
    'rule_trigger_created_at_before'                      => 'Transaksjonen vart oppretta før ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaksjonen vart oppretta etter..',
    'rule_trigger_created_at_after'                       => 'Transaksjonen vart oppretta etter ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaksjonen vart sist oppdatert før..',
    'rule_trigger_updated_at_before'                      => 'Transaksjonen vart sist oppdatert før ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaksjonen vart sist oppdatert etter..',
    'rule_trigger_updated_at_after'                       => 'Transaksjonen vart sist oppdatert etter ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Det utenlanske beløpet er nøyaktig..',
    'rule_trigger_foreign_amount_is'                      => 'Utenlanske beløpet er nøyaktig ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Utenlandske beløpet er mindre enn..',
    'rule_trigger_foreign_amount_less'                    => 'Utenlandske beløpet er mindre enn ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Utenlandske beløpet er meir enn..',
    'rule_trigger_foreign_amount_more'                    => 'Utenlandske beløpet er meir enn ":trigger_value',
    'rule_trigger_attachment_name_is_choice'              => 'Eventuelle vedlagte namn er..',
    'rule_trigger_attachment_name_is'                     => 'Namn på eventuelle vedlegg er ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Eventuelle vedlagte namn inneheld..',
    'rule_trigger_attachment_name_contains'               => 'Eventuelle vedlagte namn inneheld ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Namn på eventuelle vedlegg byrjar med..',
    'rule_trigger_attachment_name_starts'                 => 'Eventuelle vedlagte namn byrjar med ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Eventuelle vedlegg sluttar med..',
    'rule_trigger_attachment_name_ends'                   => 'Eventuelle vedlagte namn sluttar med ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Notat på eventuelle vedlegg er..',
    'rule_trigger_attachment_notes_are'                   => 'Notat på eventuelle vedlegg er ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Notat på eventuelle vedlegg inneheld..',
    'rule_trigger_attachment_notes_contains'              => 'Notat på eventuelle vedlegg inneheld ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Notat på eventuelle vedlegg byrjar med..',
    'rule_trigger_attachment_notes_starts'                => 'Notat på eventuelle vedlegg byrjar med ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Notat på eventuelle vedlegg sluttar med..',
    'rule_trigger_attachment_notes_ends'                  => 'Notat på eventuelle vedlegg sluttar med ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaksjonen er avstemt',
    'rule_trigger_reconciled'                             => 'Transaksjonen er avstemt',
    'rule_trigger_exists_choice'                          => 'Alle transaksjonar passar(!)',
    'rule_trigger_exists'                                 => 'Alle transaksjonar passar',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Konto ID er ikkje ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Kjeldekonto ID er ikkje ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Målkonto ID er ikkje ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaksjonstype er ikkje ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Nøkkelordet er ikkje «:trigger_value»',
    'rule_trigger_not_tag_is_not'                         => 'Nøkkelordet er «:trigger_value»',
    'rule_trigger_not_description_is'                     => 'Beskrivinga er ikkje ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Beskrivinga sluttar ikkje med ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Beskrivinga byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notata er ikkje ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notata inneheld ikkje ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notata sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notata byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Kjeldekonto er ikkje ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Kjeldekonto inneheld ikkje ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Kjeldekontoen inneheld ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Kjeldekontoen byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Kjeldekontonummer / IBAN er ikkje ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Kjeldekontonummer / IBAN inneheld ikkje ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Kjeldekontonummer / IBAN sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Kjeldekontoummer / IBAN byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Målkonto er ikkje ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Målkonto inneheld ikkje ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Målkonto sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Målkonto byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Målkonto nummer / IBAN er ikkje ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Målkonto nummer / IBAN inneheld ikkje ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Målkonto nummer / IBAN sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Målkonto nummer / IBAN byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Ingen konto er ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Ingen konto inneheld ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Ingen konto sluttar på ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Ingen konto byrjar med ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Ingen kontonummer / IBAN er ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Ingen kontonummer / IBAN inneheld ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Ingen kontonummer / IBAN sluttar på":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Ingen kontonummer / IBAN byrjar med ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Kategori er ikkje ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategori inneheld ikkje ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategori sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Kategori byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budsjett er ikkje ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budsjett inneheld ikkje ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budsjett sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budsjettet byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Ekstern ID er ikkje ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Ekstern ID inneheld ikkje ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Ekstern ID sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Ekstern ID byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Intern referanse er ikkje ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Intern referanse inneheld ikkje ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Intern referanse sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Intern referanse byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Ekstern URL er ikkje ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Ekstern URL inneheld ikkje ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Ekstern URL sluttar ikkje på ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Ekstern URL byrjar ikkje med ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Valuta er ikkje ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Fremmed valuta er ikkje ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaksjons ID er ikkje ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaksjonens journal ID er ikkje ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Gjentakande ID er ikkje ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Datoen er ikkje på ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Dato er ikkje før ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Datoen er ikkje etter ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Rentedato er ikkje på ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Rentedato er ikkje før ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Rentedato er ikkje etter ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Bokføringsdato er ikkje på ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Bokføringsdato er ikkje før ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Bokføringsdato er ikkje etter ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Prosessdato er ikkje på ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Prosessdato er ikkje før ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Prosessdato er ikkje etter ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Forfallsdato er ikkje den ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Forfallsdato er ikkje før ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Forfallsdato er ikkje etter ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Betalingsdato er ikkje på ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Betalingsdato er ikkje før ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Betalingsdato er ikkje etter ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Fakturadato er ikkje på ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Fakturadato er ikkje før ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Fakturadato er ikkje etter ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaksjonen er ikkje oppretta på ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaksjonen er ikkje oppretta før ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaksjonen er ikkje oppretta etter ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaksjonen er ikkje oppdatert på ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaksjonen er ikkje oppdatert før ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaksjonen er ikkje oppdatert etter ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaksjonsbeløp er ikkje ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaksjonsbeløp er meir enn ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaksjonsbeløp er mindre enn ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Utenlandsk transaksjonsbeløp er ikkje ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Utenlandsk transaksjonsbeløp er meir enn ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Utenlandsk transaksjonsbeløp er mindre enn ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Ingen vedlegg heter ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Intet vedleggsnamn inneheld ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Ingen vedleggsnamn byrjar med ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Ingen vedleggsnamn sluttar på ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Ingen vedlagte notat er ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Ingen vedlagte notat inneheld ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Ingen vedlagte notat byrjar med ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Ingen vedlagte notat sluttar på ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaksjonen er ikkje avstemt',
    'rule_trigger_not_exists'                             => 'Transaksjonen eksisterer ikkje',
    'rule_trigger_not_has_attachments'                    => 'Transaksjonen har ingen vedlegg',
    'rule_trigger_not_has_any_category'                   => 'Transaksjonen har ingen kategori',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaksjonen har ingen nøkkelord',
    'rule_trigger_not_any_notes'                          => 'Transaksjonen har ingen notat',
    'rule_trigger_not_any_external_url'                   => 'Transaksjonen har ingen ekstern URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaksjonen har eit (kva som helst) vedlegg',
    'rule_trigger_not_has_no_category'                    => 'Transaksjonen har ein (hvem som helst) kategori',
    'rule_trigger_not_has_no_budget'                      => 'Transaksjonen har eit (kva som helst) budsjett',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaksjonen har eit (vilkårleg) nøkkelord',
    'rule_trigger_not_no_notes'                           => 'Transaksjonen har notat',
    'rule_trigger_not_no_external_url'                    => 'Transaksjonen har ein ekstern URL',
    'rule_trigger_not_source_is_cash'                     => 'Kjeldekonto er ikkje ein kontantkonto',
    'rule_trigger_not_destination_is_cash'                => 'Målkonto er ikkje ein kontantkonto',
    'rule_trigger_not_account_is_cash'                    => 'Ingen konto er ein kontantkonto',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'SLETT transaksjon(!)',
    'rule_action_delete_transaction'             => 'SLETT transaksjon(!)',
    'rule_action_set_category'                   => 'Sett kategori til ":action_value"',
    'rule_action_clear_category'                 => 'Tøm kategori',
    'rule_action_set_budget'                     => 'Sett budsjett til ":action_value"',
    'rule_action_clear_budget'                   => 'Tøm budsjett',
    'rule_action_add_tag'                        => 'Legg til nøkkelordet «:action_value»',
    'rule_action_remove_tag'                     => 'Fjern nøkkelordet «:action_value»',
    'rule_action_remove_all_tags'                => 'Fjern alle nøkkelord',
    'rule_action_set_description'                => 'Sett beskriving til ":action_value"',
    'rule_action_append_description'             => 'Legg til ":action_value" på slutten av beskrivinga',
    'rule_action_prepend_description'            => 'Legg til ":action_value" på begynnelsen av beskrivinga',
    'rule_action_set_category_choice'            => 'Sett kategori til ..',
    'rule_action_clear_category_choice'          => 'Tøm alle kategoriar',
    'rule_action_set_budget_choice'              => 'Sett budsjett til ..',
    'rule_action_clear_budget_choice'            => 'Tøm alle budsjett',
    'rule_action_add_tag_choice'                 => 'Legg til nøkkelord ..',
    'rule_action_remove_tag_choice'              => 'Fjern nøkkelord ..',
    'rule_action_remove_all_tags_choice'         => 'Fjern alle nøkkelord',
    'rule_action_set_description_choice'         => 'Sett beskriving til ..',
    'rule_action_update_piggy_choice'            => 'Legg til / fjern transaksjonsbeløp i sparegris ..',
    'rule_action_update_piggy'                   => 'Legg til / fjern transaksjonsbeløp i sparegrisen ":action_value"',
    'rule_action_append_description_choice'      => 'Legg til i beskriving ..',
    'rule_action_prepend_description_choice'     => 'Legg til foran beskrivinga med ..',
    'rule_action_set_source_account_choice'      => 'Sett kjeldekonto til ..',
    'rule_action_set_source_account'             => 'Sett kjeldekonto til :action_value',
    'rule_action_set_destination_account_choice' => 'Sett målkonto til ..',
    'rule_action_set_destination_account'        => 'Sett målkonto til :action_value',
    'rule_action_append_notes_choice'            => 'Legg til notat med ..',
    'rule_action_append_notes'                   => 'Legg til notat med ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Legg følgande framfor notat ..',
    'rule_action_prepend_notes'                  => 'Legg ":action_value" framfor notatet',
    'rule_action_clear_notes_choice'             => 'Fjern notat',
    'rule_action_clear_notes'                    => 'Fjern notat',
    'rule_action_set_notes_choice'               => 'Sett notat til ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Sett notat til ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Konverter transaksjonen til eit innskot',
    'rule_action_convert_deposit'                => 'Konverter transaksjonen til eit innskot frå ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Konverter denne transaksjonen til eit uttak',
    'rule_action_convert_withdrawal'             => 'Konverter transaksjonen til eit uttak til ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Konverter transaksjonen til ein overføring',
    'rule_action_convert_transfer'               => 'Konverter transaksjonen til ein overføring med ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Legg til beskrivinga på transaksjonsnotata',
    'rule_action_append_notes_to_descr_choice'   => 'Legg transaksjonsnotatet til beskrivinga',
    'rule_action_move_descr_to_notes_choice'     => 'Erstatt gjeldande transaksjonsnotat med beskrivinga',
    'rule_action_move_notes_to_descr_choice'     => 'Erstatt gjeldande beskriving med transaksjonsnotata',
    'rule_action_append_descr_to_notes'          => 'Legg beskrivinga til notata',
    'rule_action_append_notes_to_descr'          => 'Legg notat til beskrivinga',
    'rule_action_move_descr_to_notes'            => 'Erstatt notat med beskriving',
    'rule_action_move_notes_to_descr'            => 'Erstatt beskriving med notat',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regel basert på transaksjon ":description"',
    'new_rule_for_journal_description'          => 'Denne regelen er basert på transaksjon ":description. Den vil passa transaksjonar som er like.',

    // tags
    'store_new_tag'                             => 'Lagra nytt nøkkelord',
    'update_tag'                                => 'Oppdater nøkkelord',
    'no_location_set'                           => 'Ingen plassering spesifisert.',
    'meta_data'                                 => 'Metadata',
    'location'                                  => 'Sted',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Uten dato',
    'result'                                    => 'Resultat',
    'sums_apply_to_range'                       => 'Alle beløp gjelder for det valde området',
    'mapbox_api_key'                            => 'For å bruka kart, få ein API-nøkkel frå <a href="https://www.mapbox.com/">Mapbox</a>. Åpne <code>.env</code> filen og angi denne koden etter <code>MAPBOX_API_KEY =</code>.',
    'press_object_location'                     => 'Høyreklikk eller trykk lenge for å angi objektets plassering.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Tøm lokasjon',
    'delete_all_selected_tags'                  => 'Slett alle valde nøkkelord',
    'select_tags_to_delete'                     => 'Ikke gløym å velja nokre nøkkelord.',
    'deleted_x_tags'                            => 'Sletta :count nøkkelord.|Sletta :count nøkkelord.',
    'create_rule_from_transaction'              => 'Opprett regel basert på transaksjon',
    'create_recurring_from_transaction'         => 'Opprett gjentakande transaksjon basert på transaksjon',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'La nettleseren din avgjera',
    'dark_mode_option_light'                    => 'Alltid lys',
    'dark_mode_option_dark'                     => 'Alltid mørk',
    'equal_to_language'                         => '(likt språk)',
    'dark_mode_preference'                      => 'Mørk modus',
    'dark_mode_preference_help'                 => 'Fortell Firefly III når den skal bruka mørk modus.',
    'pref_home_screen_accounts'                 => 'Startskjermkontoar',
    'pref_home_screen_accounts_help'            => 'Kva kontoar skal visast på startsida?',
    'pref_view_range'                           => 'Visningsgrense',
    'pref_view_range_help'                      => 'Nokre diagram er automatisk gruppert i periodar. Budsjetta grupperast òg i periodar. Kva for ein periode føretrekk du?',
    'pref_1D'                                   => 'Én dag',
    'pref_1W'                                   => 'Én veke',
    'pref_1M'                                   => 'Ein månad',
    'pref_3M'                                   => 'Tre måneder (kvartal)',
    'pref_6M'                                   => 'Seks måneder',
    'pref_1Y'                                   => 'Ett år',
    'pref_last365'                              => 'I fjor',
    'pref_last90'                               => 'Siste 90 dager',
    'pref_last30'                               => 'Siste 30 dagene',
    'pref_last7'                                => 'Siste 7 dager',
    'pref_YTD'                                  => 'År til dato',
    'pref_QTD'                                  => 'Kvartal til dato',
    'pref_MTD'                                  => 'Måned til dato',
    'pref_languages'                            => 'Språk',
    'pref_locale'                               => 'Instillinger for språk',
    'pref_languages_help'                       => 'Firefly III støttar fleire språk. Kva føretrekk du?',
    'pref_locale_help'                          => 'Firefly III lar deg velga andre lokale innstillinger, som korleis valutaer, tal og datoar er formatert. Oppføringar i denne lista vert kanskje ikkje støtta av systemet ditt. Firefly III har ikkje rett dato innstillinger for alle steder; kontakt meg gjerne for forbetringar.',
    'pref_locale_no_demo'                       => 'Denne funksjonen vil ikkje fungera for demo-brukar.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Innstillinger for rekneskapsår',
    'pref_custom_fiscal_year_label'             => 'Aktivert',
    'pref_custom_fiscal_year_help'              => 'I land som brukar eit anna rekneskapsår enn 1. januar til 31. desember, kan du slå på dette og angi start- og sluttdager for rekneskapsåret',
    'pref_fiscal_year_start_label'              => 'Rekneskapsårets startdato',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Ikke gløym å fjerna kontoen frå autentiseringsappen din!',
    'pref_two_factor_auth_code'                 => 'Bekreftelseskode',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Tilbakestill verifiseringskoden',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Om du ikkje kan skanne QR- koden, bruk gjerne hemmelegheita i staden: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Lagra desse sikkerhetskodane for å få tilgang i tilfelle du mister enheten.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Denne MFA-koden er ikkje gyldig.',
    'pref_save_settings'                        => 'Lagra innstillinger',
    'saved_preferences'                         => 'Innstillinger lagra!',
    'preferences_general'                       => 'Generelt',
    'preferences_frontpage'                     => 'Startskjermen',
    'preferences_security'                      => 'Sikkerhet',
    'preferences_layout'                        => 'Oppsett',
    'preferences_notifications'                 => 'Varsler',
    'pref_home_show_deposits'                   => 'Vis innskot på startskjermen',
    'pref_home_show_deposits_info'              => 'Startskjermen visar allereie kostnadskontoane dine. Skal den òg vise inntektskontoane dine?',
    'pref_home_do_show_deposits'                => 'Ja, vis dem',
    'successful_count'                          => 'korav :count var vellukka',
    'list_page_size_title'                      => 'Sidestørrelse',
    'list_page_size_help'                       => 'Ei liste over ting (kontoar, transaksjonar osv.). Visar maksimalt dette antal element på kvar side.',
    'list_page_size_label'                      => 'Sidestørrelse',
    'between_dates'                             => '(:start og :end)',
    'pref_optional_fields_transaction'          => 'Valgfrie felt for transaksjonar',
    'pref_optional_fields_transaction_help'     => 'Som standard er ikkje alle felt aktivert når du oppretter ein ny transaksjon (for å unngå forvirring). Nedanfor kan du aktivera desse felta om du trur dei kan vera nyttige for deg. Selvfølgelig vil eit felt som er deaktivert, men allereie fylt inn, vera synlig, uavhengig av innstillinga.',
    'optional_tj_date_fields'                   => 'Datofelter',
    'optional_tj_other_fields'                  => 'Andre felt',
    'optional_tj_attachment_fields'             => 'Vedleggsfelter',
    'pref_optional_tj_interest_date'            => 'Rentedato',
    'pref_optional_tj_book_date'                => 'Bokføringsdato',
    'pref_optional_tj_process_date'             => 'Prosesseringsdato',
    'pref_optional_tj_due_date'                 => 'Forfallsdato',
    'pref_optional_tj_payment_date'             => 'Betalingsdato',
    'pref_optional_tj_invoice_date'             => 'Fakturadato',
    'pref_optional_tj_internal_reference'       => 'Intern referanse',
    'pref_optional_tj_notes'                    => 'Notat',
    'pref_optional_tj_attachments'              => 'Vedlegg',
    'pref_optional_tj_external_url'             => 'Ekstern URL',
    'pref_optional_tj_location'                 => 'Sted',
    'pref_optional_tj_links'                    => 'Transaksjonskoplingar',
    'optional_field_meta_dates'                 => 'Datoer',
    'optional_field_meta_business'              => 'Bedrift',
    'optional_field_attachments'                => 'Vedlegg',
    'optional_field_meta_data'                  => 'Valgfri metadata',
    'external_url'                              => 'Ekstern URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Varsle når eit nytt API tilgangstoken er opprettet',
    'pref_notification_transaction_creation'    => 'Varsle når ein transaksjon opprettes automatisk',
    'pref_notification_user_login'              => 'Varsle når du loggar inn frå eit ny plass',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Varslinger',
    'pref_notifications_help'                   => 'Angi om dette er varsler du ønskar å få. Nokre meldingar kan inneholda sensitiv økonomisk informasjon.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack «incoming webhook» URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Økonomisk administrasjon',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Rens data frå Firefly III',
    'purge_data_expl'                           => 'Rensing betyr «slett det som allereie er sletta». Under normale omstendigheiter slettar Firefly III ingenting permanent. Det gjemmer det. Knappen under slettar alle desse tidlegare «sletta» oppføringane FOR ALLTID.',
    'delete_stuff_header'                       => 'Slett og rens data',
    'purge_all_data'                            => 'Rens alle sletta postar',
    'purge_data'                                => 'Rens data',
    'purged_all_records'                        => 'Alle sletta postar vart fjerna.',
    'delete_data_title'                         => 'Slett data frå Firefly III',
    'permanent_delete_stuff'                    => 'Du kan sletta ting frå Firefly III. Ved å bruka knappane under betyr at oppføringane dine vil verta fjerna frå visning og skjult. Det er ikkje mogleg å angre på dette, men elementa kan forbli i databasen kor du kan hente dei tilbake om nødvendig.',
    'other_sessions_logged_out'                 => 'Alle dine andre økter har vorte logget ut.',
    'delete_unused_accounts'                    => 'Sletting av ubrukte kontoar vil tømma auto-fullfør listene dine.',
    'delete_all_unused_accounts'                => 'Slett ubrukte kontoar',
    'deleted_all_unused_accounts'               => 'Alle ubrukte kontoar er sletta',
    'delete_all_budgets'                        => 'Slett ALLE budsjett',
    'delete_all_categories'                     => 'Slett ALLE kategoriane dine',
    'delete_all_tags'                           => 'Slett ALLE nøkkelorda dine',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Slett ALLE sparegriser',
    'delete_all_rules'                          => 'Slett ALLE reglane dine',
    'delete_all_recurring'                      => 'Slett ALLE gjentakande transaksjonar',
    'delete_all_object_groups'                  => 'Slett ALLE objektgrupper',
    'delete_all_accounts'                       => 'Slett ALLE kontoane dine',
    'delete_all_asset_accounts'                 => 'Slett ALLE aktivakontoane dine',
    'delete_all_expense_accounts'               => 'Slett ALLE utgiftskontoane dine',
    'delete_all_revenue_accounts'               => 'Slett ALLE inntektskontoane dine',
    'delete_all_liabilities'                    => 'Slett ALLE forpliktelser',
    'delete_all_transactions'                   => 'Slett ALLE transaksjonane dine',
    'delete_all_withdrawals'                    => 'Slett ALLE uttaka dine',
    'delete_all_deposits'                       => 'Slett ALLE innskot',
    'delete_all_transfers'                      => 'Slett ALLE overføringer',
    'also_delete_transactions'                  => 'Når kontoar vert sletta så vert ALLE tilhøyrande uttak, innskot og overføringar sletta!',
    'deleted_all_budgets'                       => 'Alle budsjett har vorte sletta',
    'deleted_all_categories'                    => 'Alle kategoriar har vorte sletta',
    'deleted_all_tags'                          => 'Alle nøkkelorda har vorte sletta',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Alle sparegriser er sletta',
    'deleted_all_rules'                         => 'Alle reglar og regelgrupper er sletta',
    'deleted_all_object_groups'                 => 'Alle grupper har vorte sletta',
    'deleted_all_accounts'                      => 'Alle kontoar har vorte sletta',
    'deleted_all_asset_accounts'                => 'Alle aktivakontoar har vorte sletta',
    'deleted_all_expense_accounts'              => 'Alle utgiftskontoar har blitt sletta',
    'deleted_all_revenue_accounts'              => 'Alle inntektskontoar har blitt sletta',
    'deleted_all_liabilities'                   => 'Alle forpliktelser har vorte sletta',
    'deleted_all_transactions'                  => 'Alle transaksjonar har vorte sletta',
    'deleted_all_withdrawals'                   => 'Alle uttak er sletta',
    'deleted_all_deposits'                      => 'Alle innskot er sletta',
    'deleted_all_transfers'                     => 'Alle overføringer er sletta',
    'deleted_all_recurring'                     => 'Alle gjentakande transaksjonar har vorte sletta',
    'change_your_password'                      => 'Endre passord',
    'delete_account'                            => 'Slett konto',
    'current_password'                          => 'Noverande passord',
    'new_password'                              => 'Nytt passord',
    'new_password_again'                        => 'Nytt passord (gjenta)',
    'delete_your_account'                       => 'Slett din konto',
    'delete_your_account_help'                  => 'Om du slettar brukarkontoen din så vert og alle kontoar, transaksjonar, <em>og alt anna</em> du har lagra i Firefly III sletta. Det vert vekke FOR GODT.',
    'delete_your_account_password'              => 'Skriv inn passordet ditt for å fortsetja.',
    'password'                                  => 'Passord',
    'are_you_sure'                              => 'Er du sikker? Du kan ikkje angre på dette.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'SLETT din konto',
    'invalid_current_password'                  => 'Ugyldig noverande passord!',
    'password_changed'                          => 'Passord endra!',
    'should_change'                             => 'Tanken er å endra passordet ditt.',
    'invalid_password'                          => 'Ugyldig passord!',
    'what_is_pw_security'                       => 'Kva er «sjekk passordsikkerhet»?',
    'secure_pw_title'                           => 'Korleis velga eit sikkert passord',
    'forgot_password_response'                  => 'Takk skal du ha. Om det eksisterar ein konto med denne e-postadressa, finn du instruksjonar i innboksen din.',
    'secure_pw_history'                         => 'Ikke ein veke går uten at du leser i nyheitene om eit nettsted som har mistet passord for brukarane sine. Hackere og tyver brukar desse passorda for å prøve å stjela din private informasjon. Denne informasjonen er verdifull.',
    'secure_pw_ff'                              => 'Brukar du det same passordet over alt på Internett? Om berre ein nettstad mistar passordet, har datasnokar tilgang til alle dine data. Firefly III er avhengig av at du vel eit sterkt og unikt passord for å beskytta dine finansielle data.',
    'secure_pw_check_box'                       => 'For å hjelpa deg kan Firefly III sjekka om passordet du vil bruka har vorte stole tidlegare. Om dette er tilfelle, rådar Firefly III deg til ikkje å bruka dette passordet.',
    'secure_pw_working_title'                   => 'Korleis virker det?',
    'secure_pw_working'                         => 'Ved å huke av denne boksen vil Firefly III sende dei fem første teikna til SHA1-hashen av passordet ditt til <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">nettsida til Troy Hunt</a> for å sjå om det er på lista hans. Dette vil stoppe deg frå å bruka usikre passord som anbefalt i den siste <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">spesialpublikasjonen frå NIST</a> om dette emnet.',
    'secure_pw_should'                          => 'Bør eg huke av boksen?',
    'secure_pw_long_password'                   => 'Ja. Alltid bekreft at passordet ditt er trygt.',
    'command_line_token'                        => 'Kommandolinjenøkkel',
    'explain_command_line_token'                => 'Du trenger dette "token" for å utføre kommander på kommandolinje som f. eks. importere eller eksportere. Uten dette teiknet fungerar ikkje kommandoene. Ikke del din kommandolinje token. Ingen vil spørre deg om dette spesialteiknet, ikkje engang meg. Om du frykter at du har mistet dette, eller ved paranoia, trykk på knappen for å generera eit nytt "token".',
    'regenerate_command_line_token'             => 'Regenerer kommandolinjenøkkel',
    'token_regenerated'                         => 'Ein ny kommandolinjenøkkel vart generert',
    'change_your_email'                         => 'Endre din epostadresse',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Inntil du bekrefter e-postadressa din, kan du ikkje logge inn.',
    'login_with_new_email'                      => 'Du kan no logge inn med din nye e-postadresse.',
    'login_with_old_email'                      => 'Du kan no logge inn med din gamle e-postadresse igjen.',
    'login_provider_local_only'                 => 'Denne handlinga er ikkje tilgjengeleg ved autentisering gjennom «:login_provider».',
    'external_user_mgt_disabled'                => 'Denne handlinga er ikkje tilgjengelig når Firefly III ikkje er ansvarlig for brukarstyring eller autentiseringshandtering.',
    'external_auth_disabled'                    => 'Denne handlinga er ikkje tilgjengeleg når Firefly III ikkje er ansvarlig for autentiseringshandtering.',
    'delete_local_info_only'                    => "Fordi Firefly III ikkje er ansvarlig for brukarstyring eller autentiseringshandtering, vil denne funksjonen berre sletta lokal informasjon om Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth klienter',
    'profile_oauth_no_clients'                  => 'Du har ikkje oppretta nokon OAuth klienter.',
    'profile_oauth_clients_external_auth'       => 'Om du brukar ein ekstern autentiseringsleverandør som Authelia, vil ikkje OAuth klientar fungera. Du kan berre bruka personlege tilgangsnøklar.',
    'profile_oauth_clients_header'              => 'Klienter',
    'profile_oauth_client_id'                   => 'Klient-ID',
    'profile_oauth_client_name'                 => 'Namn',
    'profile_oauth_client_secret'               => 'Hemmelegheit',
    'profile_oauth_create_new_client'           => 'Opprett Ny Klient',
    'profile_oauth_create_client'               => 'Opprett Klient',
    'profile_oauth_edit_client'                 => 'Rediger Klient',
    'profile_oauth_name_help'                   => 'Noko brukarane dine vil gjenkjenne og stole på.',
    'profile_oauth_redirect_url'                => 'Videresendings-URL',
    'profile_oauth_redirect_url_help'           => 'Programmets tilbakekallingslenkje for autorisering.',
    'profile_authorized_apps'                   => 'Dine autoriserte applikasjoner',
    'profile_authorized_clients'                => 'Autoriserte klienter',
    'profile_scopes'                            => 'Omfang',
    'profile_revoke'                            => 'Tilbakekall',
    'profile_oauth_client_secret_title'         => 'Klient Hemmelegheit',
    'profile_oauth_client_secret_expl'          => 'Her er din nye klienthemmelegheit. Dette er den einaste gongen han vert vist så ikkje mist han! Du kan bruka denne hemmeligheita til å laga API-spørsmål.',
    'profile_personal_access_tokens'            => 'Personleg tilgangsnøkkel',
    'profile_personal_access_token'             => 'Personleg tilgangsnøkkel',
    'profile_oauth_confidential'                => 'Konfidensiell',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Her er din nye personlege tilgangsnøkkel. Dette er den einaste gongen han vert vist så ikkje mist han! Du kan no bruka tilgangsnøkkelen til å laga API-spørsmål.',
    'profile_no_personal_access_token'          => 'Du har ikkje oppretta personlege tilgangsnøklar.',
    'profile_create_new_token'                  => 'Opprette nytt token',
    'profile_create_token'                      => 'Opprett token',
    'profile_create'                            => 'Opprett',
    'profile_save_changes'                      => 'Lagra endringer',
    'profile_whoops'                            => 'Oisann!',
    'profile_something_wrong'                   => 'Noko gjekk gale!',
    'profile_try_again'                         => 'Noko gjekk gale. Prøv på nytt.',
    'amounts'                                   => 'Beløp',
    'multi_account_warning_unknown'             => 'Avhengig av kva type transaksjon du opprettar, Kjelde og/eller målkonto for etterfølgande delingar kan overstyrast av det som er definert i transaksjonens første del.',
    'multi_account_warning_withdrawal'          => 'Husk at kildekontoen for etterfølgende oppsplitting skal overlates av kva som defineres i den første delen av uttrekket.',
    'multi_account_warning_deposit'             => 'Husk at mottakerkontoen for etterfølgende oppsplitting skal overstyres av det som er definert i den første delen av depositumet.',
    'multi_account_warning_transfer'            => 'Husk at kildens pluss destinasjonskonto med etterfølgende oppdeling overstyres av det som er definert i ein første del av overføringen.',


    // export data:
    'export_data_title'                         => 'Eksportere data frå Firefly III',
    'export_data_menu'                          => 'Eksporter data',
    'export_data_bc'                            => 'Eksportere data frå Firefly III',
    'export_data_main_title'                    => 'Importer data til Firefly III',
    'export_data_expl'                          => 'Denne lenkja lar deg eksportera alle transaksjonar + metadata frå Firefly III. Referer til hjelp (øvst til høgre (?)-ikon) for meir informasjon om prosessen.',
    'export_data_all_transactions'              => 'Eksportere alle transaksjonar',
    'export_data_advanced_expl'                 => 'Dersom du trenger ein meir avansert eller spesifikk type eksport, les "hjelpen" om korleis man brukar konsollkommandoen <code>php artisan help firefly-ii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Ett vedlegg|:count vedlegg',
    'attachments'                               => 'Vedlegg',
    'edit_attachment'                           => 'Rediger vedlegg ":name"',
    'update_attachment'                         => 'Oppdater vedlegget',
    'delete_attachment'                         => 'Slett vedlegg ":name"',
    'attachment_deleted'                        => 'Sletta vedlegg ":name"',
    'liabilities_deleted'                       => 'Sletta gjeld ":name"',
    'attachment_updated'                        => 'Oppdatert vedlegg ":name"',
    'upload_max_file_size'                      => 'Maks filstørrelse: :size',
    'list_all_attachments'                      => 'Liste over alle vedlegg',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Utgifter',
    'title_withdrawal'                          => 'Utgifter',
    'title_revenue'                             => 'Inntekt',
    'title_deposit'                             => 'Inntekt',
    'title_transfer'                            => 'Overføringer',
    'title_transfers'                           => 'Overføringer',
    'submission_options'                        => 'Alternativer for innsending',
    'apply_rules_checkbox'                      => 'Bruk reglar',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Denne transaksjonen er allereie eit uttak',
    'convert_is_already_type_Deposit'           => 'Denne transaksjonen er allereie eit innskot',
    'convert_is_already_type_Transfer'          => 'Denne transaksjonen er allereie ein overføring',
    'convert_to_Withdrawal'                     => 'Konverter ":description" til eit uttak',
    'convert_to_Deposit'                        => 'Konverter ":description" til eit innskot',
    'convert_to_Transfer'                       => 'Konverter ":description" til ein overføring',
    'convert_options_WithdrawalDeposit'         => 'Konverter eit uttak til eit innskot',
    'convert_options_WithdrawalTransfer'        => 'Konverter eit uttak til ein overføring',
    'convert_options_DepositTransfer'           => 'Konverter eit innskot til ein overføring',
    'convert_options_DepositWithdrawal'         => 'Konverter eit innskot til eit uttak',
    'convert_options_TransferWithdrawal'        => 'Konverter ein overføring til eit uttak',
    'convert_options_TransferDeposit'           => 'Konverter ein overføring til eit innskot',
    'convert_Withdrawal_to_deposit'             => 'Konverter dette uttaket til eit innskot',
    'convert_Withdrawal_to_transfer'            => 'Konverter dette uttaket til ein overføring',
    'convert_Deposit_to_withdrawal'             => 'Konverter dette innskuddet til eit uttak',
    'convert_Deposit_to_transfer'               => 'Konverter dette innskuddet til ein overføring',
    'convert_Transfer_to_deposit'               => 'Konverter denne overføringen til eit innskot',
    'convert_Transfer_to_withdrawal'            => 'Konverter denne overføringen til eit uttak',
    'convert_please_set_revenue_source'         => 'Ver venleg å vel inntektskontoen pengane vil komma frå.',
    'convert_please_set_asset_destination'      => 'Ver venleg å vel aktivakontoen pengane skal gå til.',
    'convert_please_set_expense_destination'    => 'Ver venleg å vel utgiftsskontoen pengane skal gå til.',
    'convert_please_set_asset_source'           => 'Ver venleg å vel aktivakontoen pengane kjem frå.',
    'convert_expl_w_d'                          => 'Når du endrar eit uttak til eit innskot, vert pengane bli satt inn på den angitte målkontoen i staden for å verta tatt ut av den.|Når du endrar eit uttak til eit innskot, vert pengane bli satt inn på dei angitte målkontoane i staden for å verta tatt ut av dei.',
    'convert_expl_w_t'                          => 'Ved konvertering frå uttak til overføring, vil pengane overføres frå kildekontoen til andre aktiva eller gjeld i staden for å verta brukt på den opprinnelige utgiftskontoen.|Ved konvertering frå uttak til overføring, vil pengane overføres frå kjeldekontoane til andre aktiva eller gjeldskontoar i staden for å verta brukt på den opprinnelige utgiftskontoen.',
    'convert_expl_d_w'                          => 'Når du endrar eit innskot til eit uttak, vert pengane bli tatt ut av den angitte kjeldekontoen i staden for å verta satt inn.|Når du endrar eit innskot til eit uttak, vert pengane bli tatt ut av dei angitte kjeldekontoane i staden for å verta satt inn.',
    'convert_expl_d_t'                          => 'When you convert a deposit into a transfer, the money will be deposited into the listed destination account from any of your asset or liability account.|When you convert a deposit into a transfer, the money will be deposited into the listed destination accounts from any of your asset or liability accounts.',
    'convert_expl_t_w'                          => 'Når du konverterar ei overføring til eit uttak, vert pengene brukt på målkontoen du vel her, i staden for å verta overført.|Når du konverterar ei overføring til eit uttak, vert pengene brukt på målkontoane du vel her, i staden for å verta overført.',
    'convert_expl_t_d'                          => 'When you convert a transfer into a deposit, the money will be deposited into the destination account you see here, instead of being transferred into it.|When you convert a transfer into a deposit, the money will be deposited into the destination accounts you see here, instead of being transferred into them.',
    'convert_select_sources'                    => 'To complete the conversion, please set the new source account below.|To complete the conversion, please set the new source accounts below.',
    'convert_select_destinations'               => 'To complete the conversion, please select the new destination account below.|To complete the conversion, please select the new destination accounts below.',
    'converted_to_Withdrawal'                   => 'Transaksjonen er konvertert til eit uttak',
    'converted_to_Deposit'                      => 'Transaksjonen er konvertert til eit innskot',
    'converted_to_Transfer'                     => 'Transaksjonen er konvertert til ein overføring',
    'invalid_convert_selection'                 => 'Kontoen du har valt er allereie brukt i denne transaksjonen eller eksisterar ikkje.',
    'source_or_dest_invalid'                    => 'Finner ikkje rett transaksjonsdetaljer. Konvertering er ikkje mogleg.',
    'convert_to_withdrawal'                     => 'Konverter til eit uttak',
    'convert_to_deposit'                        => 'Konverter til eit innskot',
    'convert_to_transfer'                       => 'Konverter til ei overføring',

    // create new stuff:
    'create_new_withdrawal'                     => 'Opprett nytt uttak',
    'create_new_deposit'                        => 'Opprett nytt innskot',
    'create_new_transfer'                       => 'Opprett ny overføring',
    'create_new_asset'                          => 'Opprett ny aktivakonto',
    'create_new_liabilities'                    => 'Opprett ny gjeld',
    'create_new_expense'                        => 'Opprett ny utgiftskonto',
    'create_new_revenue'                        => 'Opprett ny inntektskonto',
    'create_new_piggy_bank'                     => 'Opprett ny sparegris',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Opprett nytt abonnement',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Opprett ein ny valuta',
    'store_currency'                            => 'Lagra ny valuta',
    'update_currency'                           => 'Oppdater valuta',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Kan ikkje sletta :name fordi det er fortsatt i bruk.',
    'cannot_delete_fallback_currency'           => ':name is the system fallback currency and can\'t be deleted.',
    'cannot_disable_currency_journals'          => 'Cannot disable :name because transactions are still using it.',
    'cannot_disable_currency_last_left'         => 'Kan ikkje deaktivera :name fordi det er den siste aktive valutaen.',
    'cannot_disable_currency_account_meta'      => 'Cannot disable :name because it is used in asset accounts.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Cannot disable :name because it is used in recurring transactions.',
    'cannot_disable_currency_available_budgets' => 'Cannot disable :name because it is used in available budgets.',
    'cannot_disable_currency_budget_limits'     => 'Cannot disable :name because it is used in budget limits.',
    'cannot_disable_currency_current_default'   => 'Cannot disable :name because it is the current default currency.',
    'cannot_disable_currency_system_fallback'   => 'Cannot disable :name because it is the system default currency.',
    'disable_EUR_side_effects'                  => 'The Euro is the system\'s emergency fallback currency. Disabling it may have unintended side-effects and may void your warranty.',
    'deleted_currency'                          => 'Valuta :name sletta',
    'created_currency'                          => 'Valuta :name opprettet',
    'could_not_store_currency'                  => 'Kan ikkje lagra den nye valutaen.',
    'updated_currency'                          => 'Valuta :name oppdatert',
    'ask_site_owner'                            => 'Spør :owner om å legga til, fjerna eller redigera valutaer.',
    'currencies_intro'                          => 'Firefly III støttar ulike valutaer som du kan definere og aktivera her.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Sett som standard',
    'default_currency'                          => 'standard',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Deaktivert',
    'enable_currency'                           => 'Aktiver',
    'disable_currency'                          => 'Deaktiver',
    'currencies_default_disabled'               => 'Dei fleste valutaene er deaktivert som standard. For å bruka dem, må du aktivera dei først.',
    'currency_is_now_enabled'                   => 'Valuta ":name" er aktivert',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Valuta ":name" er deaktivert',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Obligatoriske felter',
    'optionalFields'                            => 'Valgfrie felter',
    'options'                                   => 'Alternativer',

    // budgets:
    'daily_budgets'                             => 'Daily budgets',
    'weekly_budgets'                            => 'Weekly budgets',
    'monthly_budgets'                           => 'Monthly budgets',
    'quarterly_budgets'                         => 'Quarterly budgets',
    'half_year_budgets'                         => 'Half-yearly budgets',
    'yearly_budgets'                            => 'Yearly budgets',
    'other_budgets'                             => 'Custom timed budgets',
    'budget_limit_not_in_range'                 => 'Dette beløpet gjeld frå :start til :end:',
    'total_available_budget'                    => 'Totalt tilgjengeleg budsjett (mellom :start og :end)',
    'total_available_budget_in_currency'        => 'Totalt tilgjengeleg budsjett i :currency',
    'see_below'                                 => 'sjå nedanfor',
    'create_new_budget'                         => 'Opprett eit nytt budsjett',
    'store_new_budget'                          => 'Lagra nytt budsjett',
    'stored_new_budget'                         => 'Lagret nytt budsjett ":name"',
    'available_between'                         => 'Tilgjengeleg mellom :start og :end',
    'transactionsWithoutBudget'                 => 'Utgifter uten budsjett',
    'transactions_no_budget'                    => 'Utgifter uten budsjett mellom :start og :end',
    'spent_between'                             => 'Allereie brukt mellom :start og :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Sett tilgjengeleg beløp',
    'update_available_amount'                   => 'Oppdater tilgjengeleg beløp',
    'ab_basic_modal_explain'                    => 'Use this form to indicate how much you expect to be able to budget (in total, in :currency) in the indicated period.',
    'createBudget'                              => 'Nytt budsjett',
    'invalid_currency'                          => 'Dette er ein ugyldig valuta',
    'invalid_amount'                            => 'Ver venleg og skriv inn eit beløp',
    'set_ab'                                    => 'Det tilgjengelege budsjettbeløpet er satt',
    'updated_ab'                                => 'Det tilgjengelege budsjettbeløpet har vorte oppdatert',
    'deleted_ab'                                => 'Det tilgjengelege budsjettbeløpet har vorte sletta',
    'deleted_bl'                                => 'Det budsjetterte beløpet er fjerna',
    'alt_currency_ab_create'                    => 'Sett tilgjengeleg budsjett i annan valuta',
    'bl_create_btn'                             => 'Angi budsjett i annan valuta',
    'inactiveBudgets'                           => 'Inaktive budsjett',
    'without_budget_between'                    => 'Transaksjoner uten eit budsjett mellom :start og :end',
    'delete_budget'                             => 'Slett budsjett ":name"',
    'deleted_budget'                            => 'Slett budsjett ":name"',
    'edit_budget'                               => 'Rediger budsjett ":name"',
    'updated_budget'                            => 'Oppdater budsjett ":name"',
    'update_amount'                             => 'Oppdater beløp',
    'update_budget'                             => 'Oppdater budsjett',
    'update_budget_amount_range'                => 'Oppdater (forventa) tilgjengeleg beløp mellom :start og :end',
    'set_budget_limit_title'                    => 'Sett budsjettert beløp for budsjett :budget mellom :start og :end',
    'set_budget_limit'                          => 'Angi budsjettert beløp',
    'budget_period_navigator'                   => 'Periodenavigering',
    'info_on_available_amount'                  => 'Kva har eg tilgjengeleg?',
    'available_amount_indication'               => 'Bruk desse beløpa for å få ein indikasjon på kva ditt totale budsjett kan vera.',
    'suggested'                                 => 'Foreslått',
    'average_between'                           => 'Gjennomsnitt mellom :start og :end',
    'transferred_in'                            => 'Overført (in)',
    'transferred_away'                          => 'Overført (vekke)',
    'auto_budget_none'                          => 'Ingen automatisk budsjett',
    'auto_budget_reset'                         => 'Angi eit fast beløp kvar periode',
    'auto_budget_rollover'                      => 'Legg til eit fast beløp kvar periode',
    'auto_budget_adjusted'                      => 'Legg til eit beløp kvar periode og korriger for overforbruk',
    'auto_budget_period_daily'                  => 'Dagleg',
    'auto_budget_period_weekly'                 => 'Ukentlig',
    'auto_budget_period_monthly'                => 'Månadleg',
    'auto_budget_period_quarterly'              => 'Kvartalsvis',
    'auto_budget_period_half_year'              => 'Kvart halvår',
    'auto_budget_period_yearly'                 => 'Årleg',
    'auto_budget_help'                          => 'Du kan lesa meir om denne funksjonen under hjelp. Klikk ikonet øvst til høgre (?).',
    'auto_budget_reset_icon'                    => 'Budsjettet vert fastsatt periodisk',
    'auto_budget_rollover_icon'                 => 'Budsjettbeløpet vil øke periodisk',
    'auto_budget_adjusted_icon'                 => 'Budsjettbeløpet vil periodevis auka og korrigerast for overforbruk',
    'remove_budgeted_amount'                    => 'Fjern budsjettert beløp i :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Abonnement',
    'not_expected_period'                       => 'Ikke forventet denne perioden',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Ikke (enda)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Gjentas',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Tilknyttede transaksjonar',
    'auto_match_on'                             => 'Automatisk kopla av Firefly III',
    'auto_match_off'                            => 'Ikke automatisk kopla av Firefly III',
    'next_expected_match'                       => 'Neste forventa treff',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mer',
    'rescan_old'                                => 'Kjør reglar igjen, på alle transaksjonar',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Forventet mellom :start og :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'hopper over',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inaktiv regel',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Forventet :date',
    'bill_expected_date_js'                     => 'Forventet {date}',
    'expected_amount'                           => '(Forventa) beløp',
    'bill_paid_on'                              => 'Betalt den {date}',
    'bill_repeats_weekly'                       => 'Gjentas ukentlig',
    'bill_repeats_monthly'                      => 'Gjentas månadleg',
    'bill_repeats_quarterly'                    => 'Gjentas kvartalsvis',
    'bill_repeats_half-year'                    => 'Gjentas kvart halvår',
    'bill_repeats_yearly'                       => 'Gjentas årleg',
    'bill_repeats_weekly_other'                 => 'Gjentas annankvar veke',
    'bill_repeats_monthly_other'                => 'Gjentas annankvar månad',
    'bill_repeats_quarterly_other'              => 'Gjentas annankvar kvartal',
    'bill_repeats_half-year_other'              => 'Gjentas årleg',
    'bill_repeats_yearly_other'                 => 'Gjentas annankvar år',
    'bill_repeats_weekly_skip'                  => 'Gjentas kvar {skip} veke',
    'bill_repeats_monthly_skip'                 => 'Gjentas kvar {skip} månad',
    'bill_repeats_quarterly_skip'               => 'Gjentas annankvar {skip} kvartal',
    'bill_repeats_half-year_skip'               => 'Gjentas kvart {skip} halvår',
    'bill_repeats_yearly_skip'                  => 'Gjentas kvart {skip} år',
    'subscriptions'                             => 'Abonnement',
    'go_to_subscriptions'                       => 'Gå til dine abonnement',
    'forever'                                   => 'For alltid',
    'extension_date_is'                         => 'Forlengelsesdato er {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'Jeg er skyldig beløp',
    'i_owe_amount'                              => 'Jeg skylder beløp',
    'inactive_account_link'                     => 'Du har :count inaktiv (arkivert) konto, som du kan sjå på denne separate sida. Du har :count inaktive (arkiverte) kontoar som du kan sjå på denne separate sida.',
    'all_accounts_inactive'                     => 'Dette er dine inaktive kontoar.',
    'active_account_link'                       => 'Denne lenkja går tilbake til dei aktive kontoane.',
    'account_missing_transaction'               => 'Konto #:id (":name") kan ikkje verta vist direkte, Firefly mangler omdirigerings informasjon.',
    'cc_monthly_payment_date_help'              => 'Vel eit år og ein månad, det vert ignorert likevel. Berre dagen i måneden er relevant.',
    'details_for_asset'                         => 'Detaljer for brukskonto ":name"',
    'details_for_expense'                       => 'Detaljer for utgiftskonto ":name"',
    'details_for_revenue'                       => 'Detaljer for inntektskonto ":name"',
    'details_for_cash'                          => 'Detaljer for kontantkonto ":name"',
    'store_new_asset_account'                   => 'Lagra ny brukskonto',
    'store_new_expense_account'                 => 'Lagra ny utgiftskonto',
    'store_new_revenue_account'                 => 'Lagra ny inntektskonto',
    'edit_asset_account'                        => 'Rediger brukskonto ":name"',
    'edit_expense_account'                      => 'Rediger utgiftskonto ":name"',
    'edit_revenue_account'                      => 'Rediger inntektskonto ":name"',
    'delete_asset_account'                      => 'Slett brukskonto ":name"',
    'delete_expense_account'                    => 'Slett utgiftskonto ":name"',
    'delete_revenue_account'                    => 'Slett inntektskonto ":name"',
    'delete_liabilities_account'                => 'Slett gjeld ":name"',
    'asset_deleted'                             => 'Sletting av brukskonto ":name" var vellukka',
    'account_deleted'                           => 'Sletting av konto ":name" var vellukka',
    'expense_deleted'                           => 'Sletting av utgiftskonto ":name" var vellukka',
    'revenue_deleted'                           => 'Sletting av inntekskonto ":name" var vellukka',
    'update_asset_account'                      => 'Oppdater aktivakonto',
    'update_undefined_account'                  => 'Oppdater konto',
    'update_liabilities_account'                => 'Oppdater gjeld',
    'update_expense_account'                    => 'Oppdater utgiftskonto',
    'update_revenue_account'                    => 'Oppdater inntektskonto',
    'make_new_asset_account'                    => 'Opprett ein ny aktivakonto',
    'make_new_expense_account'                  => 'Opprett ein ny utgiftskonto',
    'make_new_revenue_account'                  => 'Opprett ein ny inntektskonto',
    'make_new_liabilities_account'              => 'Opprett ny gjeld',
    'asset_accounts'                            => 'Aktivakontoar',
    'undefined_accounts'                        => 'Kontoar',
    'asset_accounts_inactive'                   => 'Aktivakontoar (inaktive)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Utgiftskontoar',
    'expense_accounts_inactive'                 => 'Utgiftskontoar (inaktive)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Inntektskontoar',
    'revenue_accounts_inactive'                 => 'Inntektskontoar (inaktive)',
    'cash_accounts'                             => 'Kontantkontoar',
    'Cash account'                              => 'Kontantkonto',
    'liabilities_accounts'                      => 'Gjeldskonto',
    'liabilities_accounts_inactive'             => 'Gjeldskonto (inaktive)',
    'reconcile_account'                         => 'Avstem konto ":account"',
    'overview_of_reconcile_modal'               => 'Balanseoversikt',
    'delete_reconciliation'                     => 'Slett avstemming',
    'update_reconciliation'                     => 'Oppdater avstemming',
    'amount_cannot_be_zero'                     => 'Beløpet kan ikkje vera null',
    'end_of_reconcile_period'                   => 'Slutten av balanse perioden :period',
    'start_of_reconcile_period'                 => 'Starten av balanse perioden :period',
    'start_balance'                             => 'Startsaldo',
    'end_balance'                               => 'Sluttsaldo',
    'update_balance_dates_instruction'          => 'Koble beløpa og datoane over til kontoutskrifta, og trykk på "Start avstemning"',
    'select_transactions_instruction'           => 'Vel transaksjonane som visast på kontoutskrifta.',
    'select_range_and_balance'                  => 'Kontroller først datoperiode og saldo. Deretter trykker du på "Start avstemning"',
    'date_change_instruction'                   => 'Om du endrer datointervallet no, vil du miste all foreløpig framdrift.',
    'update_selection'                          => 'Oppdater utval',
    'store_reconcile'                           => 'Lagra avstemming',
    'reconciliation_transaction'                => 'Avstemmingstransaksjon',
    'Reconciliation'                            => 'Avstemming',
    'reconciliation'                            => 'Avstemming',
    'reconcile_options'                         => 'Avstemmingsalternativer',
    'reconcile_range'                           => 'Avstemningsområde',
    'start_reconcile'                           => 'Start avstemming',
    'cash_account_type'                         => 'Kontanter',
    'cash'                                      => 'kontanter',
    'cant_find_redirect_account'                => 'Firefly III prøvde å omdirigere deg, men kan ikkje. Beklager det. Tilbake til indeksen.',
    'account_type'                              => 'Kontotype',
    'save_transactions_by_moving'               => 'Lagra denne transaksjonen ved å flytte den til ein annan konto:|Lagra desse transaksjonane ved å flytte dei til ein annan konto:',
    'save_transactions_by_moving_js'            => 'Ingen transaksjonar|Lagra denne transaksjonen ved å flytte den til ein annan konto. |Lagra desse transaksjonane ved å flytte dei til ein annan konto.',
    'stored_new_account'                        => 'Ny konto:name: lagra!',
    'stored_new_account_js'                     => 'Ny konto "<a href="accounts/show/{ID}">{name}</a>" lagra!',
    'updated_account'                           => 'Oppdatert konto ":name"',
    'updated_account_js'                        => 'Oppdatert konto "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Kredittkortvalg',
    'no_transactions_account'                   => 'Det eksisterar ingen transaksjonar (i denne perioden) for brukskonto ":name".',
    'no_transactions_period'                    => 'Det eksisterar ingen transaksjonar (i denne perioden).',
    'no_data_for_chart'                         => 'Det er ikkje nok informasjon (enda) til å generera dette diagrammet.',
    'select_at_least_one_account'               => 'Vel minst ein brukskonto',
    'select_at_least_one_category'              => 'Vel minst ein kategori',
    'select_at_least_one_budget'                => 'Vel minst eit budsjett',
    'select_at_least_one_tag'                   => 'Vel minst eit nøkkelord',
    'select_at_least_one_expense'               => 'Vel minst ein kombinasjon av utgift/inntekts konto. Om du ikkje har ein (lista er tom) så vil ikkje denne rapporten vera tilgjengeleg.',
    'account_default_currency'                  => 'Dette vert standard valuta for denne kontoen.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Din Firefly III-hovedbok har meir pengar i seg enn banken hevder du burde ha. Det eksisterar fleire alternativ. Ver venleg å vel kva du skal gjera. Deretter trykker du på "Bekreft avstemming".',
    'reconcile_has_less'                        => 'Din Firefly III-hovedbok har mindre pengar i seg enn banken hevder du burde ha. Det eksisterar fleire alternativ. Ver venleg å vel kva du skal gjera. Deretter trykker du på "Bekreft avstemming".',
    'reconcile_is_equal'                        => 'Din Firefly III-hovedbok og dine kontoutskriftar samsvarar. Det er ingenting du treng gjera. Ver venleg å trykk "Bekreft avstemming" for å fortsetja.',
    'create_pos_reconcile_transaction'          => 'Fjern dei valde transaksjonene, og opprett ein korrigering som legger til :amount til denne aktivakontoen.',
    'create_neg_reconcile_transaction'          => 'Fjern dei valde transaksjonene, og opprett ein korrigering som tek bort :amount frå denne aktivakontoen.',
    'reconcile_do_nothing'                      => 'Fjern dei valde transaksjonene, men ikkje korriger.',
    'reconcile_go_back'                         => 'Du kan alltid redigera eller sletta ein korrigering senere.',
    'must_be_asset_account'                     => 'Du kan berre avstemma aktivakontoar',
    'reconciliation_stored'                     => 'Avstemming lagra',
    'reconciliation_error'                      => 'På grunn av ein feil vart transaksjonane markert som avstemt, men korrigeringen har ikkje vorte lagra: :error.',
    'reconciliation_transaction_title'          => 'Avstemming (:from til :to)',
    'sum_of_reconciliation'                     => 'Sum av avstemming',
    'reconcile_this_account'                    => 'Avstem denne kontoen',
    'reconcile'                                 => 'Avstem',
    'show'                                      => 'Vis',
    'confirm_reconciliation'                    => 'Bekreft avstemming',
    'submitted_start_balance'                   => 'Innsendt startsaldo',
    'selected_transactions'                     => 'Valgte transaksjonar (:count)',
    'already_cleared_transactions'              => 'Tidlegare rydda transaksjonar (:count)',
    'submitted_end_balance'                     => 'Innsendt sluttsaldo',
    'initial_balance_description'               => 'Start saldo for ":account"',
    'liability_credit_description'              => 'Gjeld på lån ":account"',
    'interest_calc_'                            => 'ukjent',
    'interest_calc_daily'                       => 'Per dag',
    'interest_calc_monthly'                     => 'Per månad',
    'interest_calc_yearly'                      => 'Per år',
    'interest_calc_weekly'                      => 'Per veke',
    'interest_calc_half-year'                   => 'Per halvår',
    'interest_calc_quarterly'                   => 'Per kvartal',
    'initial_balance_account'                   => 'Inngående balanse for :account',
    'list_options'                              => 'Listealternativer',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Ny kategori',
    'create_new_category'                       => 'Opprett ein ny kategori',
    'without_category'                          => 'Uten kategori',
    'update_category'                           => 'Oppdater kategori',
    'updated_category'                          => 'Oppdatert kategori ":name"',
    'categories'                                => 'Kategorier',
    'edit_category'                             => 'Rediger kategori ":name"',
    'no_category'                               => '(ingen kategori)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategori',
    'delete_category'                           => 'Slett kategori ":name"',
    'deleted_category'                          => 'Sletta kategori ":name"',
    'store_category'                            => 'Lagra ny kategori',
    'stored_category'                           => 'Lagret ny kategori ":name"',
    'without_category_between'                  => 'Uten kategori mellom :start og :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Oppdater uttak',
    'update_deposit'                            => 'Oppdater innskot',
    'update_transaction'                        => 'Oppdater transaksjonen',
    'update_transfer'                           => 'Oppdater overføring',
    'updated_withdrawal'                        => 'Oppdatert uttak ":description"',
    'updated_deposit'                           => 'Oppdatert innskot ":description"',
    'updated_transfer'                          => 'Oppdatert overføring ":description"',
    'no_changes_withdrawal'                     => 'Uttak ":description" vart ikkje endra.',
    'no_changes_deposit'                        => 'Innskudd ":description" vart ikkje endra.',
    'no_changes_transfer'                       => 'Overføring ":description" vart ikkje endra.',
    'delete_withdrawal'                         => 'Slett uttak ":description"',
    'delete_deposit'                            => 'Slett innskot ":description"',
    'delete_transfer'                           => 'Slett overføring ":description"',
    'deleted_withdrawal'                        => 'Sletta uttak ":description"',
    'deleted_deposit'                           => 'Sletta innskot ":description"',
    'deleted_transfer'                          => 'Sletta overføring ":description"',
    'deleted_reconciliation'                    => 'Sletta avstemmingstransaksjon ":description"',
    'stored_journal'                            => 'Opprettet ny transaksjon ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Vellykket! Ny transaksjon er opprettet',
    'updated_journal_no_descr'                  => 'Transaksjonen din vart oppdatert',
    'select_transactions'                       => 'Vel transaksjonar',
    'rule_group_select_transactions'            => 'Påfør ":title" på transaksjonene',
    'rule_select_transactions'                  => 'Påfør ":title" på transaksjonene',
    'stop_selection'                            => 'Stop val av transaksjonar',
    'reconcile_selected'                        => 'Avstem',
    'mass_delete_journals'                      => 'Slett fleire transaksjonar',
    'mass_edit_journals'                        => 'Rediger fleire transaksjonar',
    'mass_bulk_journals'                        => 'Rediger fleire transaksjonar samtidig',
    'mass_bulk_journals_explain'                => 'Dette skjemaet lar deg endra eigenskapar for transaksjonane nedanfor i ei oppdatering. Alle transaksjonane i tabellen vil verta oppdatert når du endrer parametrane du ser her.',
    'part_of_split'                             => 'Denne transaksjonen er ein del av ein delt transaksjon. Om du ikkje har valt alle delane, kan du enda opp med å endra berre halvparten av transaksjonen.',
    'bulk_set_new_values'                       => 'Bruk innstillingane nedanfor for å angi nye verdiar. Om du lar dei stå tomme, vert dei verande tomme. Vær òg oppmerksom på at kun uttak vil verta gitt eit budsjett.',
    'no_bulk_category'                          => 'Ikke oppdater kategori',
    'no_bulk_budget'                            => 'Ikke oppdater budsjett',
    'no_bulk_tags'                              => 'Ikkje oppdater nøkkelord',
    'replace_with_these_tags'                   => 'Erstatt med desse nøkkelorda',
    'append_these_tags'                         => 'Legg til desse nøkkelorda',
    'mass_edit'                                 => 'Rediger individuelt valde',
    'bulk_edit'                                 => 'Rediger valde i bulk',
    'mass_delete'                               => 'Slett valde',
    'cannot_edit_other_fields'                  => 'Du kan ikkje masseredigere andre felt enn dei som er her, fordi det er ikkje plass til å vise dem. Ver venleg å følg linken og rediger desse ein om gongen om du må redigera desse felta.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(ingen budsjett)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Konto per budsjett',
    'account_per_category'                      => 'Konto per kategori',
    'create_new_object'                         => 'Opprett',
    'empty'                                     => '(tom)',
    'all_other_budgets'                         => '(alle andre budsjett)',
    'all_other_accounts'                        => '(alle andre kontoar)',
    'expense_per_source_account'                => 'Expenses per source account',
    'expense_per_destination_account'           => 'Expenses per destination account',
    'income_per_destination_account'            => 'Income per destination account',
    'spent_in_specific_category'                => 'Brukt i kategori «:category»',
    'earned_in_specific_category'               => 'Opptjent i kategori ":category"',
    'spent_in_specific_tag'                     => 'Brukt i nøkkelordet «:tag»',
    'earned_in_specific_tag'                    => 'Opptjent i nøkkelordet «:tag»',
    'income_per_source_account'                 => 'Inntekter per kildekonto',
    'average_spending_per_destination'          => 'Gjennomsnittlig utgift per målkonto',
    'average_spending_per_source'               => 'Gjennomsnittlig utgift per kildekonto',
    'average_earning_per_source'                => 'Gjennomsnittlig opptjente per kildekonto',
    'average_earning_per_destination'           => 'Gjennomsnittlig opptjente per målkonto',
    'account_per_tag'                           => 'Konto per nøkkelord',
    'tag_report_expenses_listed_once'           => 'Utgifter og inntekter vert aldri vist to ganger. Dersom ein transaksjon har fleire nøkkelord, vil han kun bli vist under eit av nøkkelorda sine. Denne lista kan sjå ut til å mangla data, men beløpa vil være korrekte.',
    'double_report_expenses_charted_once'       => 'Utgifter og inntekter vert aldri vist to ganger. Dersom ein transaksjon har fleire nøkkelord, vil han kun bli vist under eit av nøkkelorda sine. Dette diagrammet kan sjå ut til å mangla data, men beløpa vil være korrekte.',
    'tag_report_chart_single_tag'               => 'Diagrammet gjeld eit enkelt nøkkelord. Hvis ein transaksjon har fleire nøkkelord, vil det du ser her bli reflektert i diagram for andre nøkkelord i tillegg.',
    'tag'                                       => 'Nøkkelord',
    'no_budget_squared'                         => '(ingen budsjett)',
    'perm-delete-many'                          => 'Deleting many items in one go can be very disruptive. Please be cautious. You can delete part of a split transaction from this page, so take care.',
    'mass_deleted_transactions_success'         => 'Deleted :count transaction.|Deleted :count transactions.',
    'mass_edited_transactions_success'          => 'Updated :count transaction.|Updated :count transactions.',
    'opt_group_'                                => '(ingen kontotype)',
    'opt_group_no_account_type'                 => '(ingen kontotype)',
    'opt_group_defaultAsset'                    => 'Standard aktivakontoar',
    'opt_group_savingAsset'                     => 'Sparekontoar',
    'opt_group_sharedAsset'                     => 'Delte aktivakontoar',
    'opt_group_ccAsset'                         => 'Kredittkort',
    'opt_group_cashWalletAsset'                 => 'Kontant lommebok',
    'opt_group_expense_account'                 => 'Utgiftskontoar',
    'opt_group_revenue_account'                 => 'Inntektskontoar',
    'opt_group_l_Loan'                          => 'Gjeld: Lån',
    'opt_group_cash_account'                    => 'Kontantkonto',
    'opt_group_l_Debt'                          => 'Gjeld: Gjeld',
    'opt_group_l_Mortgage'                      => 'Gjeld: Huslån',
    'opt_group_l_Credit card'                   => 'Gjeld: Kredittkort',
    'notes'                                     => 'Notat',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Kunne ikkje lagra transaksjonen. Ver venleg å sjekk loggfilene.',
    'attachment_not_found'                      => 'Finner ikkje dette vedlegget.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> har vorte lagra.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaksjon #{ID}</a> har vorte lagra.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> har vorte oppdatert.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaksjon #{ID} ("{title}")</a> fekk ingen endringar.',
    'first_split_decides'                       => 'The first split determines the value of this field',
    'first_split_overrules_source'              => 'The first split may overrule the source account',
    'first_split_overrules_destination'         => 'The first split may overrule the destination account',
    'spent_x_of_y'                              => 'Brukt {amount} av {total}',

    // new user:
    'welcome'                                   => 'Velkomen til Firefly III!',
    'submit'                                    => 'Send inn',
    'submission'                                => 'Submission',
    'submit_yes_really'                         => 'Registrer (Jeg veit kva eg gjer)',
    'getting_started'                           => 'Kom igang',
    'to_get_started'                            => 'Det er godt å sjå at du har installert Firefly III. Ver venleg å skriv inn bankens namn og saldo på hovedkontoen din for å komma i gang. Du treng Ikke bekymra deg om du har fleire kontoar. Du kan legga dei til seinare. Dette her er berre for at Firefly III skal få noko data å starta med.',
    'savings_balance_text'                      => 'Firefly III vil automatisk oppretta ein sparekonto for deg. Som standard vil det ikkje vera pengar på sparekontoen din, men om du oppgir saldoen din til Firefly III så vert den lagt inn for deg.',
    'finish_up_new_user'                        => 'Det var alt! Du kan fortsetja ved å trykke <strong>Send</strong>. Deretter vil du verta tatt til startskjermen til Firefly III.',
    'stored_new_accounts_new_user'              => 'Jippi! Dei nye kontoane dine vart lagra.',
    'set_preferred_language'                    => 'Om du føretrekk å bruka Firefly III med eit anna språk, ver venleg å indiker det her.',
    'language'                                  => 'Språk',
    'new_savings_account'                       => ':bank_name sparekonto',
    'cash_wallet'                               => 'Kontanter lommebok',
    'currency_not_present'                      => 'Om valutaen du vanligvis brukar ikkje er i lista, fortvil ikkje. Du kan oppretta din eigen valuta under Alternativer > valuta.',

    // home page:
    'transaction_table_description'             => 'Ein tabell som inneheld transaksjonane dine',
    'opposing_account'                          => 'Opposing account',
    'yourAccounts'                              => 'Dine kontoar',
    'your_accounts'                             => 'Din konto oversikt',
    'category_overview'                         => 'Kategori oversikt',
    'expense_overview'                          => 'Utgiftskonto oversikt',
    'revenue_overview'                          => 'Inntektskonto oversikt',
    'budgetsAndSpending'                        => 'Budsjett og forbruk',
    'budgets_and_spending'                      => 'Budsjett og forbruk',
    'go_to_budget'                              => 'Gå til budsjett "{budget}"',
    'go_to_deposits'                            => 'Gå til innskot',
    'go_to_expenses'                            => 'Gå til utgifter',
    'savings'                                   => 'Oppspart',
    'newWithdrawal'                             => 'Ny utgift',
    'newDeposit'                                => 'Nytt innskot',
    'newTransfer'                               => 'Ny overføring',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Per dag',
    'left_to_spend_per_day'                     => 'Att å bruka per dag',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Tilpassa periode',
    'reset_to_current'                          => 'Reset to current period',
    'select_period'                             => 'Vel periode',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Innstillinger',
    'logout'                                    => 'Logg ut',
    'logout_other_sessions'                     => 'Logg ut alle andre økter',
    'toggleNavigation'                          => 'Vis/Skjul navigation',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Søk...',
    'version'                                   => 'Versjon',
    'dashboard'                                 => 'Startskjerm',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Tilgjengelege budsjett ({currency})',
    'currencies'                                => 'Valutaer',
    'activity'                                  => 'Aktivitet',
    'usage'                                     => 'Bruk',
    'accounts'                                  => 'Kontoar',
    'Asset account'                             => 'Aktivakonto',
    'Default account'                           => 'Aktivakonto',
    'Expense account'                           => 'Utgiftskonto',
    'Revenue account'                           => 'Inntektskonto',
    'Initial balance account'                   => 'Startsaldokonto',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Gjeld',
    'account_type_Loan'                         => 'Lån',
    'account_type_Mortgage'                     => 'Boliglån',
    'account_type_debt'                         => 'Gjeld',
    'account_type_loan'                         => 'Lån',
    'account_type_mortgage'                     => 'Boliglån',
    'account_type_Credit card'                  => 'Kredittkort',
    'credit_card_type_monthlyFull'              => 'Full betaling kvar månad',
    'liability_direction_credit'                => 'Jeg skylder denne gjelda',
    'liability_direction_debit'                 => 'Jeg skylder denne gjelda til ein annan',
    'liability_direction_credit_short'          => 'Jeg skuldet denne gjelda',
    'liability_direction_debit_short'           => 'Owe this debt',
    'liability_direction__short'                => 'Ukjent',
    'liability_direction_null_short'            => 'Ukjent',
    'Liability credit'                          => 'Lån kreditt',
    'budgets'                                   => 'Budsjett',
    'tags'                                      => 'Nøkkelord',
    'reports'                                   => 'Rapportar',
    'transactions'                              => 'Transaksjoner',
    'expenses'                                  => 'Utgifter',
    'income'                                    => 'Inntekt',
    'transfers'                                 => 'Overføringer',
    'moneyManagement'                           => 'Pengestyring',
    'money_management'                          => 'Pengestyring',
    'tools'                                     => 'Verktøy',
    'piggyBanks'                                => 'Sparegrisar',
    'piggy_banks'                               => 'Sparegriser',
    'amount_x_of_y'                             => '{current} av {total}',
    'bills'                                     => 'Abonnement',
    'withdrawal'                                => 'Uttak',
    'opening_balance'                           => 'Startsaldo',
    'deposit'                                   => 'Innskudd',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Overføring',
    'Withdrawal'                                => 'Uttak',
    'Deposit'                                   => 'Innskudd',
    'Transfer'                                  => 'Overføring',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nei',
    'amount'                                    => 'Beløp',
    'overview'                                  => 'Oversikt',
    'saveOnAccount'                             => 'Spar på konto',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Ukjent',
    'monthly'                                   => 'Månadleg',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Feil',
    'debt_start_date'                           => 'Startdato for gjeld',
    'debt_start_amount'                         => 'Start beløp for gjeld',
    'debt_start_amount_help'                    => 'Det er alltid best å definera denne verdien til eit negativt beløp. Les hjelpesidene (topp til høgre (?)-ikonet) for meir informasjon.',
    'interest_period_help'                      => 'Dette feltet er rent kosmetisk og vil ikkje verta berekna for deg. Sidan det visar seg at bankane er svært sneaky så Firefly III aldri får det rett.',
    'store_new_liabilities_account'             => 'Lagra ny gjeld',
    'edit_liabilities_account'                  => 'Rediger gjeld ":name"',
    'financial_control'                         => 'Financial control',
    'accounting'                                => 'Rekneskap',
    'automation'                                => 'Automatisering',
    'others'                                    => 'Andre',
    'classification'                            => 'Klassifisering',
    'store_transaction'                         => 'Lagra transaksjon',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Standard finansiell rapport mellom :start og :end',
    'report_audit'                              => 'Transaksjonshistorikk og oversikt mellom :start og :end',
    'report_category'                           => 'Kategori rapport mellom :start og :end',
    'report_double'                             => 'Utgift/Inntekt kontorapport mellom :start og :end',
    'report_budget'                             => 'Budsjettrapport mellom :start og :end',
    'report_tag'                                => 'Nøkkelordrapport mellom :start og :end',
    'quick_link_reports'                        => 'Hurtiglenkjer',
    'quick_link_examples'                       => 'Dette er berre nokon eksempel linker for å komma i gang. Sjekk ut hjelpesidene under (?) -knappen for informasjon om alle rapportar og dei magiske orda som du kan bruka.',
    'quick_link_default_report'                 => 'Standard finansiell rapport',
    'quick_link_audit_report'                   => 'Oversikt over transaksjonshistorikk',
    'report_this_month_quick'                   => 'Inneverande månad, alle kontoar',
    'report_last_month_quick'                   => 'Forrige månad, alle kontoar',
    'report_this_year_quick'                    => 'Inneverande år, alle kontoar',
    'report_this_fiscal_year_quick'             => 'Inneverande rekneskapsår, alle kontoar',
    'report_all_time_quick'                     => 'Frå tidenes morgon, alle kontoar',
    'reports_can_bookmark'                      => 'Husk at rapportar kan bokmerkast.',
    'incomeVsExpenses'                          => 'Inntekter vs. utgifter',
    'accountBalances'                           => 'Saldo',
    'balanceStart'                              => 'Saldo ved starten av periode',
    'balanceEnd'                                => 'Saldo ved utgongen av perioden',
    'splitByAccount'                            => 'Del opp på konto',
    'coveredWithTags'                           => 'Dekket med nøkkelord',
    'leftInBudget'                              => 'Att i budsjett',
    'left_in_debt'                              => 'Skuldig beløp',
    'sumOfSums'                                 => 'Sum av summer',
    'noCategory'                                => '(ingen kategori)',
    'notCharged'                                => 'Ikke belastet (enda)',
    'inactive'                                  => 'Inaktiv',
    'active'                                    => 'Aktiv',
    'difference'                                => 'Differanse',
    'money_flowing_in'                          => 'Inn',
    'money_flowing_out'                         => 'Ut',
    'topX'                                      => 'topp :number',
    'show_full_list'                            => 'Vis hele lista',
    'show_only_top'                             => 'Vis berre topp :number',
    'report_type'                               => 'Rapporttype',
    'report_type_default'                       => 'Standard finansiell rapport',
    'report_type_audit'                         => 'Transaksjonshistorikk (revisjon)',
    'report_type_category'                      => 'Kategorirapport',
    'report_type_budget'                        => 'Budsjettrapport',
    'report_type_tag'                           => 'Nøkkelordrapport',
    'report_type_double'                        => 'Rapport for kostnadar / inntekter',
    'more_info_help'                            => 'Mer informasjon om desse rapportane finn du på hjelpesidene. Trykk på (?) -ikonet øvst til høgre.',
    'report_included_accounts'                  => 'Inkluderte kontoar',
    'report_date_range'                         => 'Datointervall',
    'report_preset_ranges'                      => 'Forhåndsinnstilte områder',
    'shared'                                    => 'Delt',
    'fiscal_year'                               => 'Rekneskapsår',
    'income_entry'                              => 'Inntekter frå konto ":name" mellom :start og :end',
    'expense_entry'                             => 'Utgifter til konto ":name" mellom :start og :end',
    'category_entry'                            => 'Expenses and income in category ":name" between :start and :end',
    'budget_spent_amount'                       => 'Utgifter i budsjettet «:budget» mellom :start og :end',
    'balance_amount'                            => 'Utgifter i budsjett ":budget" betalt frå konto ":account" mellom :start og :end',
    'no_audit_activity'                         => 'Ingen aktivitet er registrert på konto <a href=":url" title=":account_name">:account_name</a> mellom :start og :end.',
    'audit_end_balance'                         => 'Kontobalanse frå <a href=":url" title=":account_name">:account_name</a> ved slutten av :end var: :balance',
    'reports_extra_options'                     => 'Ekstra alternativ',
    'report_has_no_extra_options'               => 'Denne rapporten har ingen ekstra alternativ',
    'reports_submit'                            => 'Vis rapport',
    'end_after_start_date'                      => 'Sluttdato for rapport må vera etter startdato.',
    'select_category'                           => 'Vel kategori(ar)',
    'select_budget'                             => 'Vel budsjett.',
    'select_tag'                                => 'Vel nøkkelord.',
    'income_per_category'                       => 'Inntekter per kategori',
    'expense_per_category'                      => 'Utgifter per kategori',
    'expense_per_budget'                        => 'Utgifter per budsjett',
    'income_per_account'                        => 'Inntekter per konto',
    'expense_per_account'                       => 'Utgifter per konto',
    'expense_per_tag'                           => 'Utgifter per nøkkelord',
    'income_per_tag'                            => 'Inntekter per nøkkelord',
    'include_expense_not_in_budget'             => 'Inkluderte utgifter ikkje med i dei valde budsjettene',
    'include_expense_not_in_account'            => 'Inkluderte utgifter ikkje med i dei valde kontoane',
    'include_expense_not_in_category'           => 'Inkluderte utgifter ikkje med i dei valde kategoriene',
    'include_income_not_in_category'            => 'Inkluderte inntekter ikkje med i dei valde kategoriene',
    'include_income_not_in_account'             => 'Inkluderte inntekter ikkje med i dei valde kontoane',
    'include_income_not_in_tags'                => 'Inkluderte inntekter ikkje i valde nøkkelord',
    'include_expense_not_in_tags'               => 'Inkluderte utgifter ikkje i valde nøkkelord',
    'everything_else'                           => 'Alt anna',
    'income_and_expenses'                       => 'Inntekter og utgifter',
    'spent_average'                             => 'Brukt (gjennomsnittlig)',
    'income_average'                            => 'Inntekt (gjennomsnittlig)',
    'transaction_count'                         => 'Transaksjonsantal',
    'average_spending_per_account'              => 'Gjennomsnittlig bruk per konto',
    'average_income_per_account'                => 'Gjennomsnittlig inntekt per konto',
    'total'                                     => 'Totalt',
    'description'                               => 'Beskriving',
    'sum_of_period'                             => 'Sum for perioden',
    'average_in_period'                         => 'Gjennomsnitt for periode',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Standard aktivakonto',
    'account_role_sharedAsset'                  => 'Delt aktivakonto',
    'account_role_savingAsset'                  => 'Sparekonto',
    'account_role_ccAsset'                      => 'Kredittkort',
    'account_role_cashWalletAsset'              => 'Kontant lommebok',
    'budget_chart_click'                        => 'Ver venleg å trykk på eit budsjettnamn i tabellen ovenfor for å sjå eit diagram.',
    'category_chart_click'                      => 'Ver venleg å trykk på eit kategorinamn i tabellen ovenfor for å sjå eit diagram.',
    'in_out_accounts'                           => 'Tjent og brukt pr. kombinasjon',
    'in_out_accounts_per_asset'                 => 'Tjent og brukt (per aktivakonto)',
    'in_out_per_category'                       => 'Tjent og brukt per kategori',
    'out_per_budget'                            => 'Brukt per budsjett',
    'select_expense_revenue'                    => 'Vel utgifts-/inntektskonto',
    'multi_currency_report_sum'                 => 'Sidan denne lista inneheld kontoar med forskjellig valuta vil summen(summane) mest sannsynleg ikkje gje meining. Rapporten vil alltid falla tilbake på din standardvaluta.',
    'sum_in_default_currency'                   => 'Summen vil alltid be i din standard valuta.',
    'net_filtered_prefs'                        => 'Dette diagrammet vil aldri inkludere kontoar som ikkje har "Inkluder i nettoverdi"-valget avkryssa.',


    // charts:
    'chart'                                     => 'Diagram',
    'month'                                     => 'Måned',
    'budget'                                    => 'Budsjett',
    'spent'                                     => 'Brukt',
    'spent_capped'                              => 'Brukt (Avkorta)',
    'spent_in_budget'                           => 'Brukt i budsjett',
    'left_to_spend'                             => 'Att å bruka',
    'earned'                                    => 'Opptjent',
    'overspent'                                 => 'Overforbruk',
    'left'                                      => 'Att',
    'max-amount'                                => 'Maksimumsbeløp',
    'min-amount'                                => 'Minimumsbeløp',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Namn',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Dato',
    'date_and_time'                             => 'Dato og klokkeslett',
    'time'                                      => 'Tid',
    'paid'                                      => 'Betalt',
    'unpaid'                                    => 'Ikke betalt',
    'day'                                       => 'Dag',
    'budgeted'                                  => 'Budsjettert',
    'period'                                    => 'Periode',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Inn + ut denne perioden',
    'sum'                                       => 'Sum',
    'summary'                                   => 'Oppsummering',
    'average'                                   => 'Gjennomsnitt',
    'balanceFor'                                => 'Saldo for :name',
    'no_tags'                                   => '(ingen nøkkelord)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Hendelseshistorikk',
    'add_money_to_piggy'            => 'Legg til pengar i sparegris ":name"',
    'piggy_bank'                    => 'Sparegris',
    'new_piggy_bank'                => 'Ny sparegris',
    'store_piggy_bank'              => 'Opprett ny sparegris',
    'stored_piggy_bank'             => 'Lagra ny sparegris ":name"',
    'account_status'                => 'Kontostatus',
    'left_for_piggy_banks'          => 'Att i sparegriser',
    'sum_of_piggy_banks'            => 'Sum i sparegriser',
    'saved_so_far'                  => 'Spart til no',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Att å spara',
    'suggested_amount'              => 'Foreslått månadleg beløp for å spara',
    'add_money_to_piggy_title'      => 'Legg til pengar i sparegris ":name"',
    'remove_money_from_piggy_title' => 'Fjern pengar frå sparegris ":name"',
    'add'                           => 'Legg til',
    'no_money_for_piggy'            => 'Du har ikkje fleire pengar å legga i denne sparegrisen.',
    'suggested_savings_per_month'   => 'Foreslått pr. månad',

    'remove'                    => 'Fjern',
    'max_amount_add'            => 'Maksimumsbeløpet du kan legga til er',
    'max_amount_remove'         => 'Maksimumsbeløpet du kan fjerna er',
    'update_piggy_button'       => 'Oppdater sparegris',
    'update_piggy_title'        => 'Oppdater sparegris ":name"',
    'updated_piggy_bank'        => 'Oppdatert sparegris ":name"',
    'details'                   => 'Detaljer',
    'events'                    => 'Hendelser',
    'target_amount'             => 'Målbeløp',
    'start_date'                => 'Startdato',
    'no_start_date'             => 'Ingen start dato',
    'target_date'               => 'Måldato',
    'no_target_date'            => 'Ingen måldato',
    'table'                     => 'Tabell',
    'delete_piggy_bank'         => 'Slett sparegris ":name"',
    'cannot_add_amount_piggy'   => 'Kan ikkje legga :amount til i ":name".',
    'cannot_remove_from_piggy'  => 'Kan ikkje fjerna :amount frå ":name".',
    'deleted_piggy_bank'        => 'Sletta sparegris ":name"',
    'added_amount_to_piggy'     => 'La til :amount i ":name"',
    'removed_amount_from_piggy' => 'Fjerna :amount frå ":name"',
    'piggy_events'              => 'Tilhøyrande sparegrisar',

    // tags
    'delete_tag'                => 'Slett nøkkelordet «:tag»',
    'deleted_tag'               => 'Sletta nøkkelordet «:tag»',
    'new_tag'                   => 'Lag nytt nøkkelord',
    'edit_tag'                  => 'Rediger nøkkelordet «:tag»',
    'updated_tag'               => 'Oppdaterte nøkkelordet «:tag»',
    'created_tag'               => 'Nøkkelordet «:tag» har vorte oppretta!',

    'transaction_journal_information'               => 'Transaksjonsinformasjon',
    'transaction_journal_amount'                    => 'Beløpsinformasjon',
    'transaction_journal_meta'                      => 'Metainformasjon',
    'transaction_journal_more'                      => 'Meir informasjon',
    'basic_journal_information'                     => 'Grunnleggande transaksjonsinformasjon',
    'transaction_journal_extra'                     => 'Ekstra informasjon',
    'att_part_of_journal'                           => 'Lagra under «:journal»',
    'total_amount'                                  => 'Totalbeløp',
    'number_of_decimals'                            => 'Antal desimalar',


    // administration
    'invite_is_already_redeemed'                    => 'Invitasjonen til «:address» har allerede vorte innløyst.',
    'invite_is_deleted'                             => 'Invitasjonen til «:address» vart sletta.',
    'invite_new_user_title'                         => 'Inviter ny brukar',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'E-postadresse',
    'invite_user'                                   => 'Inviter brukar',
    'user_is_invited'                               => 'E-postadressa «:address» vart invitert til Firefly III',
    'administration'                                => 'Administrasjon',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invitasjonskoden er allereie brukt',
    'user_administration'                           => 'Brukaradministrasjon',
    'list_all_users'                                => 'Alle brukarar',
    'all_users'                                     => 'Alle brukarar',
    'instance_configuration'                        => 'Konfigurasjon',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'Enkeltbrukarmodus',
    'setting_single_user_mode_explain'              => 'Som standard godtar Firefly III berre ein (1) registrering: deg. Dette er eit sikkerhetstiltak, som hindrer andre i å bruka din instans om du ikkje tillatar dei det. Fremtidige registreringer er blokkert. Når du kryssar av denne ruten kan andre bruka din førekomst, forutsatt at dei kan nå serveren (når den er kopla til Internett).',
    'store_configuration'                           => 'Lagra konfigurasjon',
    'single_user_administration'                    => 'Brukaradministrasjon for :email',
    'edit_user'                                     => 'Rediger brukar :email',
    'hidden_fields_preferences'                     => 'You can enable more transaction options in your <a href="preferences">preferences</a>.',
    'user_data_information'                         => 'Brukardata',
    'user_information'                              => 'Brukarinformasjon',
    'total_size'                                    => 'totalstørrelse',
    'budget_or_budgets'                             => ':count budsjett|:count budsjett',
    'budgets_with_limits'                           => ':count budsjett med konfigurert beløp|:count budsjett med konfigurert beløp',
    'nr_of_rules_in_total_groups'                   => ':count_rules reglar i :count_groups regel gruppe(r)',
    'tag_or_tags'                                   => ':count nøkkelord|:count nøkkelord',
    'configuration_updated'                         => 'Konfigurasjonen er oppdatert',
    'setting_is_demo_site'                          => 'Demo nettsted',
    'setting_is_demo_site_explain'                  => 'Om du avhuker denne boksen, vil installasjonen oppføre seg som om det er ein demo site, som kan ha rare bivirkninger.',
    'block_code_bounced'                            => 'Epostmelding(ar) kunne ikkje leveres',
    'block_code_expired'                            => 'Demo-konto utløpt',
    'no_block_code'                                 => 'Ingen grunn for utestengelse eller brukaren er ikkje utestengt',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Brukaren har ikkje bekreftet ny e-postadresse enda',
    'admin_update_email'                            => 'I motsetning til profilsida, vil brukaren IKKE verta varslet om at e-postadressa er endra!',
    'update_user'                                   => 'Oppdater brukar',
    'updated_user'                                  => 'Brukardata er endra.',
    'delete_user'                                   => 'Slett brukar :email',
    'user_deleted'                                  => 'Brukaren er sletta',
    'send_test_email'                               => 'Send test-epostmelding',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Send melding',
    'send_test_triggered'                           => 'Test vart utløst. Sjekk innboksen din og loggfilene.',
    'give_admin_careful'                            => 'Brukarar som får administrative rettigheter kan ta bort din. Vær forsiktig.',
    'admin_maintanance_title'                       => 'Vedlikehold',
    'admin_maintanance_expl'                        => 'Nokre smarte knappar for Firefly III vedlikehald',
    'admin_maintenance_clear_cache'                 => 'Tøm hurtigminne',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'Alle inviterte brukarar',
    'save_notification_settings'                    => 'Lagra innstillingar',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'Varslingsinnstillingane har vorte lagra',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Beskrivinga av den splitta transaksjonen',
    'split_transaction_title_help'          => 'Om du oppretter ein splittet transaksjon, må du ha ein hoved beskriving for alle deler av transaksjonen.',
    'split_title_help'                      => 'Om du oppretter ein splittet transaksjon, må du ha ein global beskriving for alle deler av transaksjonen.',
    'you_create_transfer'                   => 'Du lager ein overføring.',
    'you_create_withdrawal'                 => 'Du lager eit uttak.',
    'you_create_deposit'                    => 'Du lager ein innskud.',

    // links
    'journal_link_configuration'            => 'Konfigurasjon av transaksjonslenkjer',
    'create_new_link_type'                  => 'Opprett ny lenktype',
    'store_new_link_type'                   => 'Lagra ny koblingstype',
    'update_link_type'                      => 'Oppdater koblingstype',
    'edit_link_type'                        => 'Rediger lenkjetype «:name»',
    'updated_link_type'                     => 'Oppdatert lenkjetype «:name»',
    'delete_link_type'                      => 'Slett lenkjetype «:name»',
    'deleted_link_type'                     => 'Sletta lenkjetype «:name»',
    'stored_new_link_type'                  => 'Lagra ny lenkjetype «:name»',
    'cannot_edit_link_type'                 => 'Kan ikkje redigera lenkjetype «:name»',
    'link_type_help_name'                   => 'Dvs. "Duplikater"',
    'link_type_help_inward'                 => 'Dvs. "duplikater"',
    'link_type_help_outward'                => 'Dvs. "dupliseres av"',
    'save_connections_by_moving'            => 'Lagra koblingen mellom desse transaksjonane ved å flytte dei til ein annan lenktype:',
    'do_not_save_connection'                => '(ikkje lagra kobling)',
    'link_transaction'                      => 'Sammenkoble transaksjon',
    'link_to_other_transaction'             => 'Koble denne transaksjonen til ein annan transaksjon',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Denne transaksjonen',
    'transaction'                           => 'Transaksjon',
    'comments'                              => 'Kommentarar',
    'link_notes'                            => 'Any notes you wish to store with the link.',
    'invalid_link_selection'                => 'Kan ikkje koble desse transaksjonane saman',
    'selected_transaction'                  => 'Vel transaksjonar',
    'journals_linked'                       => 'Transaksjonane er knytt saman.',
    'journals_error_linked'                 => 'Desse transaksjonane er allereie knytt saman.',
    'journals_link_to_self'                 => 'Du kan ikkje koble ein transaksjon til seg sjølv',
    'journal_links'                         => 'Transaksjonskoblinger',
    'this_withdrawal'                       => 'Dette uttaket',
    'this_deposit'                          => 'Dette innskuddet',
    'this_transfer'                         => 'Denne overføringen',
    'overview_for_link'                     => 'Oversikt for linktype «:name»',
    'source_transaction'                    => 'Kjeldetransaksjon',
    'link_description'                      => 'Lenkjebeskriving',
    'destination_transaction'               => 'Destinasjonstransaksjon',
    'delete_journal_link'                   => 'Slett koblingen mellom <a href=":source_link">:source</a> og <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Sletta kobling',

    // link translations:
    'Paid_name'                             => 'Betalt',
    'Refund_name'                           => 'Refusjon',
    'Reimbursement_name'                    => 'Tilbakebetaling',
    'Related_name'                          => 'Relatert',
    'relates to_inward'                     => 'relatert til',
    'is (partially) refunded by_inward'     => 'er (delvis) refundert av',
    'is (partially) paid for by_inward'     => 'er (delvis) betalt av',
    'is (partially) reimbursed by_inward'   => 'er (delvis) tilbakebetalt av',
    'inward_transaction'                    => 'Innlands transaksjon',
    'outward_transaction'                   => 'Utenland transaksjon',
    'relates to_outward'                    => 'relatert til',
    '(partially) refunds_outward'           => '(delvise) refusjoner',
    '(partially) pays for_outward'          => 'betaler (delvis) for',
    '(partially) reimburses_outward'        => 'tilbakebetaler (delvis)',
    'is (partially) refunded by'            => 'er (delvis) refundert av',
    'is (partially) paid for by'            => 'er (delvis) betalt av',
    'is (partially) reimbursed by'          => 'er (delvis) tilbakebetalt av',
    'relates to'                            => 'relatert til',
    '(partially) refunds'                   => '(delvise) refusjoner',
    '(partially) pays for'                  => 'betaler (delvis) for',
    '(partially) reimburses'                => 'tilbakebetaler (delvis)',

    // split a transaction:
    'splits'                                => 'Deler opp',
    'add_another_split'                     => 'Legg til ein oppdeling til',
    'cannot_edit_opening_balance'           => 'Du kan ikkje redigera åpningssaldoen til ein konto.',
    'no_edit_multiple_left'                 => 'Du har ikkje valt ein tillatt transaksjon for redigering.',
    'breadcrumb_convert_group'              => 'Konverter transaksjonen',
    'convert_invalid_source'                => 'Kjeldeinformasjon er ugyldig for transaksjon #%d.',
    'convert_invalid_destination'           => 'Målinformasjon er ugyldig for transaksjon #%d.',
    'create_another'                        => 'Gå tilbake hit etter lagring for å oppretta ein ny.',
    'after_update_create_another'           => 'Gå tilbake hit etter oppdatering, for å fortsetja å redigera.',
    'store_as_new'                          => 'Lagra som ein ny transaksjon istedenfor å oppdatera.',
    'reset_after'                           => 'Nullstill skjema etter innsending',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Utvid splitt',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Kollaps deling',

    // object groups
    'default_group_title_name'              => '(ikkje gruppert)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'La oss oppretta ein aktivakonto!',
    'no_accounts_intro_asset'               => 'Du har ingen aktivakontoar enda. Aktivakontoar er hovedkontoane dine: brukskonto, sparekonto, delt konto eller til og med kredittkortet ditt.',
    'no_accounts_imperative_asset'          => 'For å begynne å bruka Firefly III må du oppretta minst ein aktivakonto. La oss gjera det no:',
    'no_accounts_create_asset'              => 'Opprett ein aktivakonto',
    'no_accounts_title_expense'             => 'La oss laga ein utgiftskonto!',
    'no_accounts_intro_expense'             => 'Du har ingen utgiftskonto enda. Utgiftskontoar er dei stadane du brukar pengar, for eksempel butikkar og supermarked.',
    'no_accounts_imperative_expense'        => 'Utgiftskontoar vert oppretta automatisk når du opprettar transaksjonar, men du kan og oppretta dei manuelt om du vil. La oss laga ein no:',
    'no_accounts_create_expense'            => 'Opprett ein utgiftskonto',
    'no_accounts_title_revenue'             => 'La oss oppretta ein inntektskonto!',
    'no_accounts_intro_revenue'             => 'Du har ingen inntektskonto enda. Inntektskontoar er dei stadane du mottek pengar frå, for eksempel arbeidsgjevaren din.',
    'no_accounts_imperative_revenue'        => 'Inntektsskontoar vert oppretta automatisk når du opprettar transaksjonar, men du kan og oppretta dei manuelt om du vil. La oss laga ein no:',
    'no_accounts_create_revenue'            => 'Opprett ein inntektskonto',
    'no_accounts_title_liabilities'         => 'La oss laga eit lån!',
    'no_accounts_intro_liabilities'         => 'Du har ikkje gjeld enda. "Gjeldskonto" er kontoar som du registrerar ditt (studie) lån og andre formar for gjeld på.',
    'no_accounts_imperative_liabilities'    => 'Du behøver ikkje bruka denne funksjonen, men den kan vera fornuftig å bruka når du vil ha kontroll på desse tingene.',
    'no_accounts_create_liabilities'        => 'Opprett gjeld',
    'no_budgets_title_default'              => 'La oss laga eit budsjett',
    'no_rules_title_default'                => 'La oss laga ein regel',
    'no_budgets_intro_default'              => 'Du har ingen budsjett enda. Budsjett brukes til å organisere utgiftane i logiske grupper, som du kan definera tak på for å begrense utgiftane dine.',
    'no_rules_intro_default'                => 'Du har ingen reglar enda. Regler er kraftfulle automatiseringer som kan håndtere transaksjonar for deg.',
    'no_rules_imperative_default'           => 'Regler kan vera veldig nyttige når du håndterer transaksjonar. La oss laga ein no:',
    'no_budgets_imperative_default'         => 'Budsjett er eit basis verktøy for finansiell administrasjon. La oss laga eit no:',
    'no_budgets_create_default'             => 'Opprett eit budsjett',
    'no_rules_create_default'               => 'Opprett ein regel',
    'no_categories_title_default'           => 'La oss laga ein kategori!',
    'no_categories_intro_default'           => 'Du har ingen kategoriar enda. Kategorier brukes til å finjustere dine transaksjonar og merke dei med sin eigen kategori.',
    'no_categories_imperative_default'      => 'Kategorier opprettes automatisk når du oppretter transaksjonar, men du kan oppretta ein manuelt òg. La oss oppretta ein no:',
    'no_categories_create_default'          => 'Opprett ein kategori',
    'no_tags_title_default'                 => 'La oss laga eit nøkkelord!',
    'no_tags_intro_default'                 => 'Du har ingen nøkkelord enda. Nøkkelord vert benytta til å finjustera transaksjonar og merka dei med spesifikke ord.',
    'no_tags_imperative_default'            => 'Nøkkelord vert oppretta automatisk når du lagar transaksjonar, men du kan òg laga dei manuelt. La oss laga eit no:',
    'no_tags_create_default'                => 'Opprett nøkkelord',
    'no_transactions_title_withdrawal'      => 'La oss laga ein utgift!',
    'no_transactions_intro_withdrawal'      => 'Du har ingen utgifter enda. Du kan legga inn utgifter for å begynne å administrere din økonomi.',
    'no_transactions_imperative_withdrawal' => 'Har du brukt pengar? Då bør du skriva det ned:',
    'no_transactions_create_withdrawal'     => 'Opprett ein utgift',
    'no_transactions_title_deposit'         => 'La oss legga inn nokon inntekter!',
    'no_transactions_intro_deposit'         => 'Du har ingen registrert inntekt enda. Du kan legga inn inntekter for å begynne å administrere din økonomi.',
    'no_transactions_imperative_deposit'    => 'Har du mottatt pengar? Da bør du skrive det ned:',
    'no_transactions_create_deposit'        => 'Opprett eit innskot',
    'no_transactions_title_transfers'       => 'La oss legga inn ein overføring!',
    'no_transactions_intro_transfers'       => 'Du har ingen overføringar enda. Når du flyttar pengar mellom aktivakontoar, registreres dette som ei overføring.',
    'no_transactions_imperative_transfers'  => 'Har du flyttet pengar rundt? Da bør du skrive det ned:',
    'no_transactions_create_transfers'      => 'Opprett ein overføring',
    'no_piggies_title_default'              => 'La oss laga ein sparegris!',
    'no_piggies_intro_default'              => 'Du har ingen sparegriser enda. Du kan oppretta sparegriser for å forenkle sparing og halde oversikt over kva du sparar til.',
    'no_piggies_imperative_default'         => 'Har du ting du sparar pengar til? Lag ein sparegris for å få kontroll på sparinga:',
    'no_piggies_create_default'             => 'Lag ein ny sparegris',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Opprett med ein gang',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Gjentakande transaksjonar',
    'repeat_until_in_past'                  => 'Denne gjentakande transaksjonen slutta å gjenta :date.',
    'recurring_calendar_view'               => 'Kalender',
    'no_recurring_title_default'            => 'La oss oppretta ein gjentakande transaksjon!',
    'no_recurring_intro_default'            => 'Du har ingen gjentakande transaksjonar enda. Du kan bruka desse for å få Firefly III til å automatisk oppretta transaksjonar for deg.',
    'no_recurring_imperative_default'       => 'Dette er ein ganske avansert funksjon, men den kan vera svært nyttig. Husk å lesa dokumentasjonen (?)-ikonet øvst til høgre) før du fortset.',
    'no_recurring_create_default'           => 'Opprett ein gjentakande transaksjon',
    'make_new_recurring'                    => 'Opprett ein gjentakande transaksjon',
    'recurring_daily'                       => 'Dagleg',
    'recurring_weekly'                      => 'Kvar veke på :weekday',
    'recurring_weekly_skip'                 => 'Every :skip(st/nd/rd/th) week on :weekday',
    'recurring_monthly'                     => 'Kvar månad på :dayOfMonth :weekday',
    'recurring_monthly_skip'                => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) day',
    'recurring_ndom'                        => 'Kvar månad på :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Kvart år den :date',
    'overview_for_recurrence'               => 'Oversikt for gjentakande transaksjon ":title"',
    'warning_duplicates_repetitions'        => 'I sjeldne tilfeller datoane vist to gonger i lista. Dette kan skje når fleire gjentakingar kolliderer. Firefly III genererer alltid ein transaksjon per dag.',
    'created_transactions'                  => 'Relaterte transaksjonar',
    'expected_withdrawals'                  => 'Forventa uttak',
    'expected_deposits'                     => 'Forventa innskot',
    'expected_transfers'                    => 'Forventa overføringar',
    'created_withdrawals'                   => 'Opprettede uttak',
    'created_deposits'                      => 'Opprettede innskot',
    'created_transfers'                     => 'Opprettede overføringer',
    'recurring_info'                        => 'Gjentakande transaksjon :count / :total',
    'created_from_recurrence'               => 'Opprettet frå gjentakande transaksjon ":title" (#:id)',
    'recurring_never_cron'                  => 'Det kan sjå ut til at cron jobben som er nødvendig for å støtta gjentakande transaksjonar aldri har køyrt. Dette er sjølvsagt normalt når du nettopp har installert Firefly III, men dette bør settast opp så snart som mogleg. Sjekk ut hjelp-sidene ved å bruka (?) -ikonet øvst i høgre hjørne på sida.',
    'recurring_cron_long_ago'               => 'Det ser ut som det har gått meir enn 36 timer sida cron jobben for å støtta gjentakande transaksjonar har køyrt. Er du sikker på at den er satt opp rett? Sjekk ut hjelpe-sidene ved å bruka (?) -ikonet øvst i høgre hjørne på sida.',

    'create_new_recurrence'              => 'Lag ny gjentakande transaksjon',
    'help_first_date'                    => 'Spesifiser den første forventa gjentakinga. Den må vera i framtida.',
    'help_first_date_no_past'            => 'Spesifiser den første forventa gjentakinga. Firefly III vil ikkje oppretta transaksjonar i fortida.',
    'no_currency'                        => '(ingen valuta)',
    'mandatory_for_recurring'            => 'Pålagt gjentakelses informasjon',
    'mandatory_for_transaction'          => 'Pålagt transaksjons informasjon',
    'optional_for_recurring'             => 'Valgfritt gjentakelses informasjon',
    'optional_for_transaction'           => 'Valgfritt transaksjons informasjon',
    'change_date_other_options'          => 'Ved å endra på "første dato" får du fleire val.',
    'mandatory_fields_for_tranaction'    => 'Verdiane her vil enda opp i transaksjonen(ane) som vert oppretta',
    'click_for_calendar'                 => 'Trykk her for å få ein kalender som visar deg når transaksjonen vil gjenta seg.',
    'repeat_forever'                     => 'Gjenta for alltid',
    'repeat_until_date'                  => 'Gjenta til dato',
    'repeat_times'                       => 'Gjenta antal gonger',
    'recurring_skips_one'                => 'Annankvar',
    'recurring_skips_more'               => 'Hopper over :count forekomster',
    'store_new_recurrence'               => 'Lagra gjentakande transaksjon',
    'stored_new_recurrence'              => 'Gjentakande transaksjon ":title" lagra.',
    'edit_recurrence'                    => 'Rediger gjentakande transaksjon ":title"',
    'recurring_repeats_until'            => 'Gjenta til :date',
    'recurring_repeats_forever'          => 'Gjenta for alltid',
    'recurring_repeats_x_times'          => 'Repeats :count time|Repeats :count times',
    'update_recurrence'                  => 'Oppdater gjentakande transaksjon',
    'updated_recurrence'                 => 'Oppdatert gjentakande transaksjon ":title"',
    'recurrence_is_inactive'             => 'Denne gjentakande transaksjonen er ikkje aktiv og vil ikkje generera nye transaksjonar.',
    'delete_recurring'                   => 'Slett gjentakande transaksjon ":title"',
    'new_recurring_transaction'          => 'Opprett gjentakande transaksjon',
    'help_weekend'                       => 'Kva skal Firefly III gjera når gjentakande transaksjon fell på ein Laurdag eller Søndag?',
    'do_nothing'                         => 'Berre opprett transaksjonen',
    'skip_transaction'                   => 'Hopp over forekomsten',
    'jump_to_friday'                     => 'Opprett transaksjonen på foregående Fredag i staden',
    'jump_to_monday'                     => 'Opprett transaksjonen på neste Måndag i staden',
    'will_jump_friday'                   => 'Opprettes på Fredag i staden for i helgane.',
    'will_jump_monday'                   => 'Opprettes på Måndag i staden for i helgane.',
    'except_weekends'                    => 'Unntatt helger',
    'recurrence_deleted'                 => 'Gjentakande transaksjon ":title" sletta',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balanse i (:currency)',
    'box_spent_in_currency'              => 'Brukt (:currency)',
    'box_earned_in_currency'             => 'Opptjent (:currency)',
    'box_budgeted_in_currency'           => 'Budsjettert (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Att å bruka (:currency)',
    'box_net_worth_in_currency'          => 'Net worth (:currency)',
    'box_spend_per_day'                  => 'Att å bruka per dag: :amount',

    // debug page
    'debug_page'                         => 'Debug page',
    'debug_submit_instructions'          => 'If you are running into problems, you can use the information in this box as debug information. Please copy-and-paste into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. It will generate a beautiful table that can be used to quickly diagnose your problem.',
    'debug_pretty_table'                 => 'If you copy/paste the box below into a GitHub issue it will generate a table. Please do not surround this text with backticks or quotes.',
    'debug_additional_data'              => 'You may also share the content of the box below. You can also copy-and-paste this into a new or existing <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. However, the content of this box may contain private information such as account names, transaction details or email addresses.',

    // object groups
    'object_groups_menu_bar'             => 'Grupper',
    'object_groups_page_title'           => 'Grupper',
    'object_groups_breadcrumb'           => 'Grupper',
    'object_groups_index'                => 'Oversikt',
    'object_groups'                      => 'Grupper',
    'object_groups_empty_explain'        => 'Some things in Firefly III can be divided into groups. Piggy banks for example, feature a "Group" field in the edit and create screens. When you set this field, you can edit the names and the order of the groups on this page. For more information, check out the help-pages in the top right corner, under the (?)-icon.',
    'object_group_title'                 => 'Tittel',
    'edit_object_group'                  => 'Rediger gruppa «:title»',
    'delete_object_group'                => 'Slett gruppa «:title»',
    'update_object_group'                => 'Oppdater gruppe',
    'updated_object_group'               => 'Gruppa «:title» vart oppdatert',
    'deleted_object_group'               => 'Gruppa «:title» vart sletta',
    'object_group'                       => 'Gruppe',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'La til :amount i sparegrisen «:name»',
    'ale_action_log_remove'              => 'Fjerna :amount frå sparegrisen «:name»',
    'ale_action_clear_budget'            => 'Fjerna frå budsjett',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Fjerna fra kategori',
    'ale_action_clear_notes'             => 'Fjerna notat',
    'ale_action_clear_tag'               => 'Fjerna nøkkelord',
    'ale_action_clear_all_tags'          => 'Fjerna alle nøkkelord',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Sett budsjett',
    'ale_action_set_category'            => 'Sett kategori',
    'ale_action_set_source'              => 'Sett kjeldekonto',
    'ale_action_set_destination'         => 'Sett målkonto',
    'ale_action_update_transaction_type' => 'Endra transaksjonstype',
    'ale_action_update_notes'            => 'Endra notat',
    'ale_action_update_description'      => 'Endra beskriving',
    'ale_action_add_to_piggy'            => 'Sparegris',
    'ale_action_remove_from_piggy'       => 'Sparegris',
    'ale_action_add_tag'                 => 'La til nøkkelord',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
