<?php

/**
 * config.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    'html_language'            => 'pt-br',
    'locale'                   => 'pt-br, pt_BR.utf8, pt_BR.UTF-8',
    // 'month'                   => '%B %Y',
    'month_js'                 => 'MMMM [de] YYYY',

    // 'month_and_day'           => '%B %e, %Y',
    'month_and_day_moment_js'  => 'DD [de] MMMM [de] YYYY',
    'month_and_day_fns'        => 'd [de] MMMM [de] y',
    'month_and_day_js'         => 'DD [de] MMMM [de] YYYY',

    // 'month_and_date_day'      => '%A %B %e, %Y',
    'month_and_date_day_js'    => 'dddd, D [de] MMMM [de] YYYY',

    // 'month_and_day_no_year'   => '%B %e',
    'month_and_day_no_year_js' => 'D [de] MMMM',



    // 'date_time'               => '%B %e, %Y, @ %T',
    'date_time_js'             => 'DD [de] MMMM [de] YYYY, [às] HH:mm:ss',
    'date_time_fns'            => 'dd \'de\' MMMM \'de\' yyyy, \'às\' HH:mm:ss',
    'date_time_fns_short'      => 'dd/MMM/yyyy HH:mm',

    // 'specific_day'            => '%e %B %Y',
    'specific_day_js'          => 'DD [de] MMMM [de] YYYY',

    // 'week_in_year'            => 'Week %V, %G',
    'week_in_year_js'          => '[Semana] W, GGGG',
    'week_in_year_fns'         => "'Semana' w 'de' yyyy",

    // 'year'                    => '%Y',
    'year_js'                  => 'YYYY',

    // 'half_year'               => '%B %Y',
    'half_year_js'             => '\TQ YYYY',

    'quarter_fns'              => "'T'Q, yyyy",
    'half_year_fns'            => "'S{half}', yyyy",
    'dow_1'                    => 'Segunda',
    'dow_2'                    => 'Terça',
    'dow_3'                    => 'Quarta',
    'dow_4'                    => 'Quinta',
    'dow_5'                    => 'Sexta',
    'dow_6'                    => 'Sábado',
    'dow_7'                    => 'Domingo',
];
