<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Nome do banco',
    'bank_balance'                 => 'Saldo',
    'current_balance'              => 'Current balance',
    'savings_balance'              => 'Saldo nas poupanças',
    'credit_card_limit'            => 'Limite do cartão de crédito',
    'automatch'                    => 'Corresponder automaticamente',
    'skip'                         => 'Pular',
    'enabled'                      => 'Ativo',
    'name'                         => 'Nome',
    'active'                       => 'Ativo',
    'amount_min'                   => 'Montante mínimo',
    'amount_max'                   => 'Montante máximo',
    'match'                        => 'Corresponde em',
    'strict'                       => 'Modo restrito',
    'repeat_freq'                  => 'Repete',
    'object_group'                 => 'Grupo',
    'location'                     => 'Localização',
    'update_channel'               => 'Canal de atualização',
    'currency_id'                  => 'Moeda',
    'transaction_currency_id'      => 'Moeda',
    'auto_budget_currency_id'      => 'Moeda',
    'external_ip'                  => 'IP externo do seu servidor',
    'attachments'                  => 'Anexos',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Verificar a segurança da palavra-passe',
    'source_account'               => 'Conta de origem',
    'destination_account'          => 'Conta de destino',
    'asset_destination_account'    => 'Conta de destino',
    'include_net_worth'            => 'Incluir na posição global',
    'asset_source_account'         => 'Conta de origem',
    'journal_description'          => 'Descrição',
    'note'                         => 'Notas',
    'currency'                     => 'Moeda',
    'account_id'                   => 'Conta de ativos',
    'budget_id'                    => 'Orçamento',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => 'Saldo inicial',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Saldo virtual',
    'run_after_form' => 'Run this rule',
    'valid_url_protocols' => 'Valid URL protocols',
    'allow_webhooks' => 'Allow webhooks',
    'enable_external_rates' => 'Enable external exchange rates',
    'enable_external_map' => 'Enable external map',
    'use_running_balance' => 'Calculate running balances',
    'enable_exchange_rates' => 'Enable exchange rates',
    'targetamount'                 => 'Montante alvo',
    'target_amount'                => 'Target amount',
    'account_role'                 => 'Tipo de conta',
    'opening_balance_date'         => 'Data do saldo inicial',
    'cc_type'                      => 'Plano de pagamento do cartão de crédito',
    'cc_monthly_payment_date'      => 'Data de pagamento mensal do cartão de crédito',
    'piggy_bank_id'                => 'Mealheiro',
    'returnHere'                   => 'Voltar aqui',
    'returnHereExplanation'        => 'Depois de inserir, voltar aqui para criar outro.',
    'returnHereUpdateExplanation'  => 'Depois de atualizar, voltar aqui.',
    'description'                  => 'Descrição',
    'expense_account'              => 'Conta de despesas',
    'revenue_account'              => 'Conta de receitas',
    'decimal_places'               => 'Casas decimais',
    'destination_amount'           => 'Montante (destino)',
    'new_email_address'            => 'Novo email',
    'verification'                 => 'Verificação',
    'api_key'                      => 'Chave API',
    'remember_me'                  => 'Lembrar-me',
    'liability_type_id'            => 'Tipo de passivo',
    'liability_type'               => 'Tipo de passivo',
    'interest'                     => 'Juro',
    'interest_period'              => 'Periodo de juros',
    'extension_date'               => 'Data da extensão',
    'type'                         => 'Tipo',
    'convert_Withdrawal'           => 'Converter levantamento',
    'convert_Deposit'              => 'Converter depósito',
    'convert_Transfer'             => 'Converter transferência',
    'amount'                       => 'Montante',
    'foreign_amount'               => 'Montante estrangeiro',
    'date'                         => 'Data',
    'interest_date'                => 'Data de juros',
    'book_date'                    => 'Data de registo',
    'process_date'                 => 'Data de processamento',
    'category'                     => 'Categoria',
    'tags'                         => 'Etiquetas',
    'deletePermanently'            => 'Apagar permanentemente',
    'cancel'                       => 'Cancelar',
    'targetdate'                   => 'Data alvo',
    'target_date'                  => 'Target date',
    'startdate'                    => 'Data de início',
    'start_date'                   => 'Start date',
    'tag'                          => 'Etiqueta',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Sob',
    'symbol'                       => 'Símbolo',
    'code'                         => 'Código',
    'iban'                         => 'IBAN',
    'account_number'               => 'Número de conta',
    'creditCardNumber'             => 'Número do cartão de crédito',
    'has_headers'                  => 'Cabeçalhos',
    'date_format'                  => 'Formato da data',
    'attachments[]'                => 'Anexos',
    'title'                        => 'Título',
    'notes'                        => 'Notas',
    'filename'                     => 'Nome do ficheiro',
    'mime'                         => 'Formato do ficheiro',
    'size'                         => 'Tamanho',
    'trigger'                      => 'Gatilho',
    'stop_processing'              => 'Parar processamento',
    'end_date'                     => 'End date',
    'enddate'                      => 'Data do término',
    'move_rules_before_delete'     => 'Grupo de regras',
    'start'                        => 'Início do intervalo',
    'end'                          => 'Fim do intervalo',
    'delete_account'               => 'Apagar conta ":name"',
    'delete_webhook'               => 'Apagar webhook ":title"',
    'delete_bill'                  => 'Delete subscription ":name"',
    'delete_budget'                => 'Apagar orçamento ":name"',
    'delete_category'              => 'Apagar categoria ":name"',
    'delete_currency'              => 'Apagar moeda ":name"',
    'delete_journal'               => 'Apagar transação com a descrição ":description"',
    'delete_attachment'            => 'Apagar anexo ":name"',
    'delete_rule'                  => 'Apagar regra ":title"',
    'delete_rule_group'            => 'Apagar grupo de regras ":title"',
    'delete_link_type'             => 'Apagar tipo de ligação ":name"',
    'delete_user'                  => 'Apagar utilizador ":email"',
    'delete_recurring'             => 'Apagar transação recorrente ":title"',
    'user_areYouSure'              => 'Se eliminar o utilizador ":email", vai desaparecer tudo. Não existe retorno. Se eliminar a sua própria conta, vai perder o acesso a esta instância do Firefly III.',
    'attachment_areYouSure'        => 'Tem a certeza que pretende apagar o anexo chamado ":name"?',
    'account_areYouSure'           => 'Tem a certeza que pretende apagar a conta chamada ":name"?',
    'account_areYouSure_js'        => 'Tem a certeza que deseja eliminar a conta chamada "{name}?',
    'bill_areYouSure'              => 'Are you sure you want to delete the subscription named ":name"?',
    'rule_areYouSure'              => 'Tem a certeza que pretende apagar a regra intitulada ":title"?',
    'object_group_areYouSure'      => 'Tem certeza que quer apagar o grupo ":title"?',
    'ruleGroup_areYouSure'         => 'Tem a certeza que pretende apagar o grupo de regras ":title"?',
    'budget_areYouSure'            => 'Tem a certeza que pretende apagar o orçamento chamado ":name"?',
    'webhook_areYouSure'           => 'Tem a certeza que quer apagar o webhook ":title"?',
    'category_areYouSure'          => 'Tem a certeza que pretende apagar a categoria chamada ":name"?',
    'recurring_areYouSure'         => 'Tem a certeza que pretende apagar a transação recorrente chamada ":title"?',
    'currency_areYouSure'          => 'Tem a certeza que pretende apagar a moeda chamada ":name"?',
    'piggyBank_areYouSure'         => 'Tem a certeza que pretende apagar o mealheiro chamado ":name"?',
    'journal_areYouSure'           => 'Tem a certeza que pretende apagar a transação com descrição ":description"?',
    'mass_journal_are_you_sure'    => 'Tem a certeza que pretende apagar estas transações?',



    'tag_areYouSure'               => 'Tem a certeza que pretende apagar a etiqueta ":tag"?',
    'journal_link_areYouSure'      => 'Tem a certeza que pretende apagar a ligação entre <a href=":source_link">:source</a> e <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Tem a certeza que pretende apagar o tipo de link ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Apagar elementos do Firefly III é permanente e não pode ser revertido.',
    'mass_make_selection'          => 'Ainda pode evitar eliminar alguns itens limpando a caixa de seleção.',
    'delete_all_permanently'       => 'Apagar os selecionados, permanentemente',
    'update_all_journals'          => 'Atualizar estas transações',
    'also_delete_transactions'     => 'A única transação vinculada a esta conta vai ser também apagada.|Todas as :count transações vinculadas a esta conta serão também apagadas.',
    'also_delete_transactions_js'  => 'Nenhuma transação| A única transação ligada a esta conta será também apagada.|Todas as {count} transações ligadas a esta conta serão também apagadas.',
    'also_delete_connections'      => 'A única transação vinculada a este tipo de ligação irá perder a ligação.|Todas as :count transações vinculadas a este tipo de ligação irão perder as suas ligações.',
    'also_delete_rules'            => 'A única regra vinculada a este grupo de regras vai ser apagada também.|Todas as :count regras vinculadas a este grupo de regras vão ser apagadas também.',
    'also_delete_piggyBanks'       => 'O único mealheiro vinculado a esta conta vai ser apagado também.|Todos os :count mealheiros vinculados a esta conta vão ser apagados também.',
    'also_delete_piggyBanks_js'    => 'Nenhum mealheiro|O único mealheiro ligado a esta conta será também eliminado.|Todos os {count} mealheiros ligados a esta conta serão também eliminados.',
    'not_delete_piggy_banks'       => 'O mealheiro ligado a este grupo não vai ser apagado. Os :count mealheiros ligados a este grupo não vão ser apagados.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => 'A única transação vinculada a este orçamento não vai ser apagada.|Nenhuma :count transação vinculada a este orçamento será apagada.',
    'category_keep_transactions'   => 'A única transação vinculada a esta categoria não vai ser apagada.|Nenhuma :count transação vinculada a esta categoria será apagada.',
    'recurring_keep_transactions'  => 'A única transação criada a partir desta transação recorrente não vai ser apagada.|Nenhuma :count transação criada a partir desta transação recorrente será apagada.',
    'tag_keep_transactions'        => 'A única transação vinculada a esta etiqueta não vai ser apagada.|Nenhuma :count transação vinculada a esta etiqueta será apagada.',
    'check_for_updates'            => 'Procurar atualizações',
    'liability_direction'          => 'Passivo entrada/saída',
    'delete_object_group'          => 'Apagar grupo ":title"',
    'email'                        => 'Endereço de email',
    'password'                     => 'Palavra-passe',
    'password_confirmation'        => 'Palavra-passe (novamente)',
    'blocked'                      => 'Está bloqueado?',
    'blocked_code'                 => 'Razão para o bloqueio',
    'login_name'                   => 'Iniciar sessão',
    'is_owner'                     => 'É administrador?',
    'url'                          => 'URL',
    'bill_end_date'                => 'Data final',

    // import
    'apply_rules'                  => 'Aplicar regras',
    'artist'                       => 'Artista',
    'album'                        => 'Álbum',
    'song'                         => 'Música',

    // admin
    'domain'                       => 'Domínio',
    'single_user_mode'             => 'Desativar registo de utilizadores',
    'is_demo_site'                 => 'Site de demonstração',

    // import
    'configuration_file'           => 'Ficheiro de configuração',
    'csv_comma'                    => 'Vírgula (,)',
    'csv_semicolon'                => 'Ponto e vírgula (;)',
    'csv_tab'                      => 'Uma tabulação (invisível)',
    'csv_delimiter'                => 'Delimitador de campos CSV',
    'client_id'                    => 'ID do cliente',
    'app_id'                       => 'ID da aplicação',
    'secret'                       => 'Código secreto',
    'public_key'                   => 'Chave pública',
    'country_code'                 => 'Código do país',
    'provider_code'                => 'Banco ou provedor de dados',
    'fints_url'                    => 'URL da API FinTS',
    'fints_port'                   => 'Porta',
    'fints_bank_code'              => 'Código do banco',
    'fints_username'               => 'Utilizador',
    'fints_password'               => 'PIN / Palavra-passe',
    'fints_account'                => 'Conta FinTS',
    'local_account'                => 'Conta Firefly III',



    'from_date'                    => 'Data desde',
    'to_date'                      => 'Data até',
    'due_date'                     => 'Data de vencimento',
    'payment_date'                 => 'Data de pagamento',
    'invoice_date'                 => 'Data da fatura',
    'internal_reference'           => 'Referência interna',
    'inward'                       => 'Descrição interna',
    'outward'                      => 'Descrição externa',
    'rule_group_id'                => 'Grupo de regras',
    'transaction_description'      => 'Descrição da transação',
    'first_date'                   => 'Primeira data',
    'transaction_type'             => 'Tipo de transação',
    'repeat_until'                 => 'Repetir até',
    'recurring_description'        => 'Descrição da transação recorrente',
    'repetition_type'              => 'Tipo de repetição',
    'foreign_currency_id'          => 'Moeda estrangeira',
    'repetition_end'               => 'Repetição termina',
    'repetitions'                  => 'Repetições',
    'calendar'                     => 'Calendário',
    'weekend'                      => 'Fim de semana',
    'client_secret'                => 'Segredo do cliente',
    'withdrawal_destination_id'    => 'Conta de destino',
    'deposit_source_id'            => 'Conta de origem',
    'expected_on'                  => 'Esperado em',
    'paid'                         => 'Pago',
    'auto_budget_type'             => 'Orçamento automático',
    'auto_budget_amount'           => 'Montante do orçamento automático',
    'auto_budget_period'           => 'Período do orçamento automático',
    'collected'                    => 'Recebido',
    'submitted'                    => 'Enviado',
    'key'                          => 'Chave',
    'value'                        => 'Conteúdo do registo',
    'webhook_delivery'             => 'Entrega',
    'webhook_response'             => 'Resposta',
    'webhook_trigger'              => 'Gatilho',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy username',
    'ntfy_pass'                    => 'Ntfy password',
];
