<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'shranjeno v ":timezone"',
    'displayed_in_tz'                           => 'prikazano v ":timezone"',
    'close'                                     => 'Zapri',
    'actions'                                   => 'Dejanja',
    'edit'                                      => 'Uredi',
    'loading'                                   => 'Nalagam',
    'transaction_journal_id'                    => 'ID dnevnika transakcij',
    'delete'                                    => 'Izbriši',
    'split'                                     => 'Razdeli',
    'single_split'                              => 'Razdeli',
    'clone'                                     => 'Kloniraj',
    'clone_and_edit'                            => 'Kloniraj in uredi',
    'confirm_action'                            => 'Potrdi dejanje',
    'last_seven_days'                           => 'Zadnjih sedem dni',
    'last_thirty_days'                          => 'Zadnjih 30 dni',
    'last_180_days'                             => 'Zadnjih 180 dni',
    'month_to_date'                             => 'Od meseca do datuma',
    'year_to_date'                              => 'Leto do datuma',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => 'Kaj vse se dogaja?',
    'main_dashboard_page_title'                 => 'Domov',
    'everything'                                => 'Vse',
    'today'                                     => 'danes',
    'customRange'                               => 'Obseg po meri',
    'date_range'                                => 'Datumski obseg',
    'apply'                                     => 'Uporabi',
    'select_date'                               => 'Izberi datum..',
    'cancel'                                    => 'Prekliči',
    'from'                                      => 'Od',
    'to'                                        => 'Do',
    'structure'                                 => 'Struktura',
    'help_translating'                          => 'Pomoč še ni na voljo v tvojem jeziku. <a href="https://crowdin.com/project/firefly-iii-help"> Boš pomagal pri prevodu?</a>',
    'showEverything'                            => 'Pokaži vse',
    'never'                                     => 'Nikoli',
    'no_results_for_empty_search'               => 'Vaše polje iskanja je prazno, zato ni bilo mogoče najti ničesar.',
    'removed_amount'                            => 'Odstranjeno :amount',
    'added_amount'                              => 'Dodano :amount',
    'asset_account_role_help'                   => 'Dodatne možnosti se lahko nastavljajo tudi kasneje.',
    'Opening balance'                           => 'Začetno stanje',
    'create_new_stuff'                          => 'Ustvari novo stvar',
    'new_withdrawal'                            => 'Nov odliv',
    'create_new_transaction'                    => 'Ustvari novo transakcijo',
    'sidebar_frontpage_create'                  => 'Ustvari',
    'new_transaction'                           => 'Nova transakcija',
    'no_rules_for_bill'                         => 'Ta naročnina nima povezanih pravil.',
    'go_to_asset_accounts'                      => 'Oglej si račune sredstev',
    'go_to_budgets'                             => 'Na proračune',
    'go_to_withdrawals'                         => 'Pojdi na svoje odlive',
    'clones_journal_x'                          => 'Ta transakcija je kopija ":description" (#:id)',
    'go_to_categories'                          => 'Na kategorije',
    'go_to_bills'                               => 'Pojdi na svoje naročnine',
    'go_to_expense_accounts'                    => 'Oglej si račune stroškov',
    'go_to_revenue_accounts'                    => 'Oglej si račune prihodkov',
    'go_to_piggies'                             => 'Na hranilnike',
    'new_deposit'                               => 'Nov priliv',
    'new_transfer'                              => 'Nov prenos',
    'new_transfers'                             => 'Nov prenos',
    'new_asset_account'                         => 'Nov račun sredstev',
    'new_expense_account'                       => 'Nov račun stroškov',
    'new_revenue_account'                       => 'Nov račun prihodkov',
    'new_liabilities_account'                   => 'Nova obveznost',
    'new_budget'                                => 'Nov proračun',
    'new_bill'                                  => 'Nova naročnina',
    'block_account_logout'                      => 'Odjavljeni ste. Blokirani računi ne morejo uporabljati te spletne strani. Ali ste se registrirali z veljavnim e-poštnim naslovom?',
    'flash_success'                             => 'Uspelo je!',
    'flash_info'                                => 'Sporočilo',
    'flash_warning'                             => 'Opozorilo!',
    'flash_error'                               => 'Napaka!',
    'flash_danger'                              => 'Nevarnost!',
    'flash_info_multiple'                       => 'Tu je eno sporočilo | Tu je :count sporočil',
    'flash_error_multiple'                      => 'Tu je ena napaka | Tu je :count napak',
    'net_worth'                                 => 'Neto vrednost',
    'help_for_this_page'                        => 'Pomoč za to stran',
    'help_for_this_page_body'                   => 'Več informacij o tej strani najdete <a href="https://docs.firefly-iii.org/">v dokumentaciji</a>.',
    'two_factor_welcome'                        => 'Zdravo!',
    'two_factor_enter_code'                     => 'Če želite nadaljevati, vnesite vašo dvofaktorsko kodo. Vaš program za prijavo jo lahko ustvari za vas.',
    'two_factor_code_here'                      => 'Tukaj vnesi kodo',
    'two_factor_title'                          => 'Dvofaktorska avtentikacija',
    'authenticate'                              => 'Avtentikacija',
    'two_factor_forgot_title'                   => 'Izguba dvofaktorske avtentikacije',
    'two_factor_forgot'                         => 'Pozabil sem svojo reč za dva koraka.',
    'two_factor_lost_header'                    => 'Nimate dostopa do dvofaktorske avtentikacije?',
    'two_factor_lost_intro'                     => 'Če ste izgubili tudi varnostne kode imate res smolo. Tega ne morete popraviti preko spletnega vmesnika. Imate dve možnosti.',
    'two_factor_lost_fix_self'                  => 'Če imate svojo namestitev Firefly III, preberite <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator -or-2fa-has-stopped-working">ta vnos v pogostih vprašanjih</a> za navodila.',
    'two_factor_lost_fix_owner'                 => 'V nasprotnem primeru pišite po e-pošti lastniku spletnega mesta <a href="mailto::site_owner">:site_owner</a> in ga prosite, da ponastavi vaše preverjanje pristnosti v dveh korakih.',
    'mfa_backup_code'                           => 'V Firefly III si se prijavil z rezervno kodo. Te kode ne moreš več uporabiti zato jo na seznamu prečrtaj.',
    'pref_two_factor_new_backup_codes'          => 'Pridobi nove varnostne kode',
    'pref_two_factor_backup_code_count'         => 'Imate :count veljavno varnostno kodo.|Imate :count veljavnih varnostnih kod.',
    '2fa_i_have_them'                           => 'Spravil sem jih!',
    'warning_much_data'                         => ':days dni podatkov se lahko nalaga kar nekaj časa.',
    'registered'                                => 'Uspešno ste se registrirali!',
    'Default asset account'                     => 'Privzeti premoženjski račun',
    'no_budget_pointer'                         => 'Zdi se, da še nimate proračuna. Ustvarite jih nekaj na strani <a href="budgets">proračuni</a>. Proračuni vam lahko pomagajo spremljati stroške.',
    'no_bill_pointer'                           => 'Zdi se, da še nimate naročnine. Ustvarite jih na strani za <a href="subscriptions">naročnine</a>. Naročnine vam lahko pomagajo spremljati stroške.',
    'Savings account'                           => 'Varčevalni račun',
    'Credit card'                               => 'Kreditna kartica',
    'source_accounts'                           => 'Izvorni račun|Izvorni računi',
    'destination_accounts'                      => 'Ciljni račun|Ciljni računi',
    'user_id_is'                                => 'Vaše uporabniško ime je <strong>:user</strong>',
    'field_supports_markdown'                   => 'To polje podpira <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Če potrebujete več pomoči pri uporabi Firefly III, prosimo, da odprete zahtevek za pomoč na <a href="https://github.com/firefly-iii/firefly-iii/issues">Githubu</a>.',
    'reenable_intro_text'                       => '<a href="#" id="reenableGuidance">Vodiča</a> lahko ponovno aktiviraš.',
    'intro_boxes_after_refresh'                 => 'Info polja se ponovno pojavijo, ko osvežite stran.',
    'show_all_no_filter'                        => 'Pokaži vse transakcije brez omejitve datuma.',
    'expenses_by_category'                      => 'Stroški po kategorijah',
    'expenses_by_budget'                        => 'Stroški po proračunih',
    'income_by_category'                        => 'Prihodki po kategorijah',
    'expenses_by_asset_account'                 => 'Stroški po premoženjskih računih',
    'expenses_by_expense_account'               => 'Stroški po ciljnem računu',
    'cannot_redirect_to_account'                => 'Oprostite, ne moremo vas preusmeriti na pravo stran.',
    'sum_of_expenses'                           => 'Vsota stroškov',
    'sum_of_income'                             => 'Vsota prihodkov',
    'liabilities'                               => 'Obveznosti',
    'spent_in_specific_budget'                  => 'Porabljeno v proračunu ":budget"',
    'spent_in_specific_double'                  => 'Porabljeno po računu/ih ":account"',
    'earned_in_specific_double'                 => 'Prisluženo po računu/ih ":account"',
    'source_account'                            => 'Izvorni račun',
    'source_account_reconciliation'             => 'Pri usklajevalni transakciji ni možno urejati izvornega računa.',
    'destination_account'                       => 'Ciljni račun',
    'destination_account_reconciliation'        => 'Pri usklajevalni transakciji ni možno urejati ciljnega računa.',
    'sum_of_expenses_in_budget'                 => 'Skupaj porabljeno v ":budget"',
    'left_in_budget_limit'                      => 'Na voljo za zapravljanje glede na proračun',
    'current_period'                            => 'Tekoče obdobje',
    'show_the_current_period_and_overview'      => 'Pokaži trenutno obdobje in pregled',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'Za ostale jezike, razen Angleščine, je potrebno na operacijski sistem namestiti prave jezikovne nastavitve. Če le-te niso nastavljene pravilno se valuta, datumi in zneski ne bodo pravilno prikazovali.',
    'budget_in_period'                          => 'Vse transakcije za proračun ":name" med :start in :end v :currency',
    'chart_budget_in_period'                    => 'Diagram vseh transakcij za proračun ":name" med :start in :end v :currency',
    'chart_budget_in_period_only_currency'      => 'Proračunski znesek je v :currency, zato bodo na grafikonu prikazane samo transakcije v :currency.',
    'chart_account_in_period'                   => 'Grafikon vseh transakcij za račun ":name" (:balance) med :start in :end',
    'chart_category_in_period'                  => 'Grafikon vseh transakcij za kategorijo ":name" med :start in :end',
    'chart_category_all'                        => 'Grafikon vseh transakcij za kategorijo ":name"',
    'clone_withdrawal'                          => 'Kloniraj ta odliv',
    'clone_deposit'                             => 'Kloniraj ta priliv',
    'clone_transfer'                            => 'Kloniraj ta prenos',
    'multi_select_no_selection'                 => 'Nič ni izbrano',
    'multi_select_select_all'                   => 'Izberi vse',
    'multi_select_n_selected'                   => 'izbrano',
    'multi_select_all_selected'                 => 'Vse je izbrano',
    'multi_select_filter_placeholder'           => 'Najdi..',
    'intro_next_label'                          => 'Naslednji',
    'intro_prev_label'                          => 'Predhodnji',
    'intro_skip_label'                          => 'Preskoči',
    'intro_done_label'                          => 'Končano',
    'between_dates_breadcrumb'                  => 'Med :start in :end',
    'all_journals_without_budget'               => 'Vse transakcije brez proračuna',
    'journals_without_budget'                   => 'Transakcije brez proračuna',
    'all_journals_without_category'             => 'Vse transakcije brez kategorije',
    'journals_without_category'                 => 'Transakcije brez kategorije',
    'all_journals_for_account'                  => 'Vse transakcije za račun :name',
    'chart_all_journals_for_account'            => 'Grafikon vseh transakcij za račun :name',
    'journals_in_period_for_account'            => 'Vse transakcije za račun ":name" med :start in :end',
    'journals_in_period_for_account_js'         => 'Vse transakcije za račun {title} med {start} in {end}',
    'transferred'                               => 'Preneseno',
    'all_withdrawal'                            => 'Vsi stroški',
    'all_transactions'                          => 'Vse transakcije',
    'title_withdrawal_between'                  => 'Vsi stroški med :start in :end',
    'all_deposit'                               => 'Vsi dohodki',
    'title_deposit_between'                     => 'Vsi dohodki med :start in :end',
    'all_transfers'                             => 'Vsi prenosi',
    'title_transfers_between'                   => 'Vsi prenosi med :start in :end',
    'all_transfer'                              => 'Vsi prenosi',
    'all_journals_for_tag'                      => 'Vse transakcije za oznako ":tag"',
    'title_transfer_between'                    => 'Vse transakcije med :start in :end',
    'all_journals_for_category'                 => 'Vse transakcije v kategoriji :name',
    'all_journals_for_budget'                   => 'Vse transakcije za v proračunu :name',
    'chart_all_journals_for_budget'             => 'Grafikon vseh transakcij za proračun :name',
    'journals_in_period_for_category'           => 'Vse transakcije na računu ":name" med :start in :end',
    'journals_in_period_for_tag'                => 'Vse transakcije z oznako :tag med :start in :end',
    'not_available_demo_user'                   => 'Funkcija ni na voljo za demo uporabnike.',
    'exchange_rate_instructions'                => 'Račun sredstev "@name" sprejema samo transakcije v @primary_currency. Če želite namesto tega uporabiti @foreign_currency, morate podati tudi znesek v @primary_currency:',
    'transfer_exchange_rate_instructions'       => 'Izvorni račun sredstev "@source_name" sprejema samo transakcije v @source_currency. Ciljni račun sredstev "@dest_name" pa sprejema samo transakcije v @dest_currency. Podati morate znesek v obeh valutah.',
    'transaction_data'                          => 'Podrobnosti transakcije',
    'invalid_server_configuration'              => 'Neveljavna nastavitev strežnika',
    'invalid_locale_settings'                   => 'Firefly III ne more oblikovati denarnih zneskov, ker vašemu strežniku manjkajo zahtevani paketi. Obstajajo <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">navodila za to</a>.',
    'quickswitch'                               => 'Hitri preklop',
    'sign_in_to_start'                          => 'Za nadaljevanje se prijavi',
    'sign_in'                                   => 'Prijava',
    'register_new_account'                      => 'Ustvari nov račun',
    'forgot_my_password'                        => 'Pozabil sem geslo',
    'problems_with_input'                       => 'Z vašim vnosom so težave.',
    'reset_password'                            => 'Ponastavite vaše geslo',
    'button_reset_password'                     => 'Ponastavite geslo',
    'reset_button'                              => 'Ponastavite',
    'want_to_login'                             => 'Želim se prijaviti',
    'login_page_title'                          => 'Prijava v Firefly III',
    'register_page_title'                       => 'Ustvari nov račun za Firefly III',
    'forgot_pw_page_title'                      => 'Ste pozabil geslo za Firefly III',
    'reset_pw_page_title'                       => 'Ponastavite geslo za Firefly III',
    'cannot_reset_demo_user'                    => 'Za demo uporabnika gesla ni mogoče ponastaviti.',
    'no_att_demo_user'                          => 'Demo uporabnik ne more naložiti prilog.',
    'button_register'                           => 'Registracija',
    'authorization'                             => 'Avtorizacija',
    'active_bills_only'                         => 'samo aktivne naročnine',
    'active_bills_only_total'                   => 'vse aktivne naročnine',
    'active_exp_bills_only'                     => 'samo aktivne in pričakovane naročnine',
    'active_exp_bills_only_total'               => 'samo vse aktivne pričakovane naročnine',
    'per_period_sum_1D'                         => 'Predvideni dnevni stroški',
    'per_period_sum_1W'                         => 'Predvideni tedenski stroški',
    'per_period_sum_1M'                         => 'Predvideni mesečni stroški',
    'per_period_sum_3M'                         => 'Pričakovani četrtletni stroški',
    'per_period_sum_6M'                         => 'Predvideni polletni stroški',
    'per_period_sum_1Y'                         => 'Predvideni letni stroški',
    'average_per_bill'                          => 'povprečno na naročnino',
    'expected_total'                            => 'predvidena vsota',
    'reconciliation_account_name'               => 'Usklajevanje :name (:currency)',
    'saved'                                     => 'Shranjeno',
    'advanced_options'                          => 'Napredne možnosti',
    'advanced_options_explain'                  => 'Nekatere strani v Firefly III imajo za tem gumbom skrite napredne možnosti. Ta stran nima nič posebnega, vendar si oglejte še druge!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III je zaznal, da imate transakcije izpred leta 1970. Prosimo, da te transakcije čim prej popravite.',
    'anonymous_warning_on'                      => 'Zaradi vaše zasebnosti so vsi zneski zdaj prikazani kot "nič". Opozorilo: polja za vnos besedila lahko še vedno prikazujejo prvotne zneske!',
    'anonymous_warning_off'                     => 'Zneski bodo spet vidni. Bodite pozorni na svojo okolico.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'onemogočeno',
    'no_webhook_messages'                       => 'Tukaj ni webhook sporočil',
    'webhook_trigger_ANY'         => 'Po katerem koli dogodku',
    'webhook_trigger_STORE_TRANSACTION'         => 'Po ustvarjanju transakcije',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Po posodabljanju transakcije',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Po brisanju transakcije',
    'webhook_trigger_STORE_BUDGET'              => 'Po izdelavi proračuna',
    'webhook_trigger_UPDATE_BUDGET'             => 'Po posodobitvi proračuna',
    'webhook_trigger_DESTROY_BUDGET'            => 'Po izbrisu proračuna',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'Po spremembi zneska v proračunu',
    'webhook_response_TRANSACTIONS'             => 'Podrobnosti transakcije',
    'webhook_response_ACCOUNTS'                 => 'Podrobnosti računa',
    'webhook_response_BUDGET'                   => 'Podatki o proračunu',
    'webhook_response_RELEVANT'                 => 'Relevantni podatki',
    'webhook_response_NONE'                     => 'Ni podrobnosti',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Preglejte',
    'create_new_webhook'                        => 'Ustvari nov webhook',
    'webhooks_create_breadcrumb'                => 'Ustvari nov webhook',
    'webhook_trigger_form_help'                 => 'Navedite, ob katerem dogodku se bo sprožil webhook',
    'webhook_response_form_help'                => 'Navedite, kaj mora webhook poslati po URL-ju.',
    'webhook_delivery_form_help'                => 'V kateri obliki mora webhook dostaviti podatke.',
    'webhook_active_form_help'                  => 'Webhook mora biti aktiven, sicer ne bo poklican.',
    'stored_new_webhook'                        => 'Shranjen nov webhook ":title"',
    'delete_webhook'                            => 'Izbriši Webhook',
    'deleted_webhook'                           => 'Izbrisan webhook ":title"',
    'edit_webhook'                              => 'Uredi webhook ":title"',
    'updated_webhook'                           => 'Posodobljen webhook ":title"',
    'edit_webhook_js'                           => 'Uredi webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Webhook je bil sprožen ob navedeni transakciji. Počakajte, da se prikažejo rezultati.',
    'webhook_messages'                          => 'Webhook sporočilo',
    'view_message'                              => 'Poglej sporočilo',
    'view_attempts'                             => 'Ogled neuspelih poskusov',
    'message_content_title'                     => 'Vsebina sporočila Webhook',
    'message_content_help'                      => 'To je vsebina sporočila, ki je bilo poslano (ali poskuseno) s tem webhookom.',
    'attempt_content_title'                     => 'Poskusi Webhook',
    'attempt_content_help'                      => 'To so vsi neuspešni poskusi pošiljanja tega sporočila webhook na konfigurirani URL. Čez nekaj časa bo Firefly III nehal poskušati.',
    'no_attempts'                               => 'Ni neuspešnih poskusov. To je dobra stvar!',
    'webhook_attempt_at'                        => 'Poskus ob {moment}',
    'logs'                                      => 'Dnevniki',
    'response'                                  => 'Odziv',
    'visit_webhook_url'                         => 'Obiščite URL webhooka',
    'reset_webhook_secret'                      => 'Ponastavi skrivno kodo webhooka',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> je bil shranjen.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") je bil posodobljen.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Zahteva za avtorizacijo',
    'authorization_request_intro'               => '<strong>:client</strong> je zahteval dostop do upravljanja tvojih financ. Dovoliš da <strong>:client</strong> dostopa do teh podatkov?',
    'authorization_request_site'                => 'Preusmerjeni boste na <code>:url</code>, ki bo nato lahko dostopal do vaših podatkov Firefly III.',
    'authorization_request_invalid'             => 'Ta zahteva za dostop je neveljavna. Nikoli več ne sledite tej povezavi.',
    'scopes_will_be_able'                       => 'Ta aplikacija bo lahko:',
    'button_authorize'                          => 'Avtoriziraj',
    'none_in_select_list'                       => '(brez)',
    'no_piggy_bank'                             => '(brez hranilnika)',
    'name_in_currency'                          => ':name v :currency',
    'paid_in_currency'                          => 'Plačano v :currency',
    'unpaid_in_currency'                        => 'Neplačano v :currency',
    'is_alpha_warning'                          => 'Poganjate ALFA verzijo. Bodite pozorni na hrošče in težave.',
    'is_beta_warning'                           => 'Poganjate BETA verzijo. Bodite pozorni na hrošče in težave.',
    'all_destination_accounts'                  => 'Ciljni računi',
    'all_source_accounts'                       => 'Izvorni računi',
    'back_to_index'                             => 'Nazaj na kazalo',
    'cant_logout_guard'                         => 'Firefly III vas ne more odjaviti.',
    'internal_reference'                        => 'Interna referenca',

    // check for updates:
    'update_check_title'                        => 'Preverite za posodobitve',
    'admin_update_check_title'                  => 'Samodejno preverjaj za posodobitve',
    'admin_update_check_explain'                => 'Firefly III lahko samodejno preverja posodobitve. Če to omogočite, bomo na Github-u preverjali ali je na voljo nova različica in vas o tem obvestili. To obvestilo lahko preizkusite z gumbom na desni. Označite spodaj, če želite, da Firefly III preveri, ali so posodobitve na voljo.',
    'check_for_updates_permission'              => 'Firefly III lahko preveri posodobitve, vendar za to potrebuje vaše dovoljenje. Pojdite v <a href=":link">nastavitve</a> in označite, ali želite, da je ta funkcija omogočena.',
    'updates_ask_me_later'                      => 'Vprašaj me kasneje',
    'updates_do_not_check'                      => 'Ne preverjaj posodobitev',
    'updates_enable_check'                      => 'Omogoči preverjanje posodobitev',
    'admin_update_check_now_title'              => 'Preveri za posodobitve zdaj',
    'admin_update_check_now_explain'            => 'Če pritisnete gumb, bo Firefly III preveril, ali je vaša trenutna različica zadnja.',
    'check_for_updates_button'                  => 'Preveri zdaj!',
    'update_new_version_alert'                  => 'Na voljo je nova različica Firefly III. Trenutno uporabljate :your_version, najnovejša različica pa je :new_version, izdana :date.',
    'update_version_beta'                       => 'To je BETA verzija. Lahko naletite na težave.',
    'update_version_alpha'                      => 'To je ALFA verzija. Lahko naletite na težave.',
    'update_current_dev_older'                  => 'Poganjate razvojno izdajo ":version", ki je starejša od zadnje izdaje :new_version. Posodobite prosim!',
    'update_current_dev_newer'                  => 'Poganjate razvojno izdajo ":version", ki je novejša od zadnje izdaje :new_version.',
    'update_current_version_alert'              => 'Uporabljate :version, ki je zadnja razpoložljiva izdaja.',
    'update_newer_version_alert'                => 'Uporabljate :your_version, ki je novejša od zadnje izdaje, :new_version.',
    'update_check_error'                        => 'Pri preverjanju posodobitev smo naleteli na težavo: :error',
    'unknown_error'                             => 'Neznana napaka. Oprostite prosim.',
    'disabled_but_check'                        => 'Onemogočili ste preverjanje posodobitev. Zato ne pozabite občasno preveriti, ali so na voljo posodobitve. Hvala vam!',
    'admin_update_channel_title'                => 'Kanal posodobitev',
    'admin_update_channel_explain'              => 'Firefly III ima tri "kanale" posodobitev, ki določajo, kako hitro prejmete nove funkcije, izboljšave in odprave napak. Uporabite kanal "beta", če ste pustolovec, in "alfa", če radi živite nevarno življenje.',
    'update_channel_stable'                     => 'Stabilno. Vse naj bi delovalo po pričakovanjih.',
    'update_channel_beta'                       => 'Beta. Nove funkcionalnosti, vendar ni nujno, da vse deluje.',
    'update_channel_alpha'                      => 'Alfa. Noter vržemo razne stvari da vidimo kaj se "prime".',

    // search
    'search'                                    => 'Iskanje',
    'search_query'                              => 'Poizvedba',
    'search_found_transactions'                 => 'Firefly III je našel :count transakcijo v :time sekundah.|Firefly III je našel :count transakcij v :time sekundah.',
    'search_found_more_transactions'            => 'Firefly III je našel več kot :count transakcij v :time sekundah.',
    'search_for_overview'                       => 'Firefly III išče transakcije, ki izpolnjujejo <b>vse</b> naslednje pogoje:',
    'search_for_query'                          => 'Prisotne morajo biti vse te besede: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Nobena od teh besed ne sme biti prisotna: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Ti iskalni parametri niso veljavni in so bili prezrti.',

    // old


    'search_modifier_date_on'                             => 'Datum transakcije je ":value"',
    'search_modifier_not_date_on'                         => 'Datum transakcije ni ":value"',
    'search_modifier_reconciled'                          => 'Transakcija je usklajena',
    'search_modifier_not_reconciled'                      => 'Transakcija ni usklajena',
    'search_modifier_id'                                  => 'ID transakcije je ":value"',
    'search_modifier_not_id'                              => 'ID transakcije ni ":value"',
    'search_modifier_date_before'                         => 'Datum transakcije je pred ali na ":value"',
    'search_modifier_date_after'                          => 'Datum transakcije je po ali na ":value"',
    'search_modifier_external_id_is'                      => 'Zunanji ID je ":value"',
    'search_modifier_not_external_id_is'                  => 'Zunanji ID ni ":value"',
    'search_modifier_no_external_url'                     => 'Transakcija nima zunanjega URL-ja',
    'search_modifier_no_external_id'                      => 'Transakcija nima zunanjega ID-ja',
    'search_modifier_not_any_external_url'                => 'Transakcija nima zunanjega URL-ja',
    'search_modifier_not_any_external_id'                 => 'Transakcija nima zunanjega ID-ja',
    'search_modifier_any_external_url'                    => 'Transakcija mora imeti (poljubni) zunanji URL',
    'search_modifier_any_external_id'                     => 'Transakcija mora imeti (poljubni) zunanji ID',
    'search_modifier_not_no_external_url'                 => 'Transakcija mora imeti (poljubni) zunanji URL',
    'search_modifier_not_no_external_id'                  => 'Transakcija mora imeti (poljubni) zunanji ID',
    'search_modifier_internal_reference_is'               => 'Notranja referenca je ":value"',
    'search_modifier_not_internal_reference_is'           => 'Notranja referenca ni ":value"',
    'search_modifier_description_starts'                  => 'Opis se začne s ":value"',
    'search_modifier_not_description_starts'              => 'Opis se ne začne s ":value"',
    'search_modifier_description_ends'                    => 'Opis se konča s ":value"',
    'search_modifier_not_description_ends'                => 'Opis se ne konča s ":value"',
    'search_modifier_description_contains'                => 'Opis vsebuje ":value"',
    'search_modifier_not_description_contains'            => 'Opis ne vsebuje ":value"',
    'search_modifier_description_is'                      => 'Opis je točno ":value"',
    'search_modifier_not_description_is'                  => 'Opis natanko ni ":value"',
    'search_modifier_currency_is'                         => 'Transakcijska (tuja) valuta je ":value"',
    'search_modifier_not_currency_is'                     => 'Transakcijska (tuja) valuta ni ":value"',
    'search_modifier_foreign_currency_is'                 => 'Tuja valuta transakcije je ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Tuja valuta transakcije ni ":value"',
    'search_modifier_has_attachments'                     => 'Transakcija mora imeti prilogo',
    'search_modifier_has_no_category'                     => 'Transakcija ne sme imeti kategorije',
    'search_modifier_not_has_no_category'                 => 'Transakcija mora imeti (poljubno) kategorijo',
    'search_modifier_not_has_any_category'                => 'Transakcija ne sme imeti kategorije',
    'search_modifier_has_any_category'                    => 'Transakcija mora imeti (poljubno) kategorijo',
    'search_modifier_has_no_budget'                       => 'Transakcija ne sme imeti proračuna',
    'search_modifier_not_has_any_budget'                  => 'Transakcija ne sme imeti proračuna',
    'search_modifier_has_any_budget'                      => 'Transakcija mora imeti (poljubni) proračun',
    'search_modifier_not_has_no_budget'                   => 'Transakcija mora imeti (poljubni) proračun',
    'search_modifier_has_no_bill'                         => 'Transakcija ne sme imeti naročnine',
    'search_modifier_not_has_no_bill'                     => 'Transakcija mora imeti (katerokoli) naročnino',
    'search_modifier_has_any_bill'                        => 'Transakcija mora imeti (katerokoli) naročnino',
    'search_modifier_not_has_any_bill'                    => 'Transakcija ne sme imeti naročnine',
    'search_modifier_has_no_tag'                          => 'Transakcija ne sme imeti oznak',
    'search_modifier_not_has_any_tag'                     => 'Transakcija ne sme imeti oznak',
    'search_modifier_not_has_no_tag'                      => 'Transakcija nima (poljubne) oznake',
    'search_modifier_has_any_tag'                         => 'Transakcija mora imeti (poljubno) oznako',
    'search_modifier_notes_contains'                      => 'Opombe o transakcijah vsebujejo ":value"',
    'search_modifier_not_notes_contains'                  => 'Opombe o transakciji ne vsebujejo ":value"',
    'search_modifier_notes_starts'                        => 'Opombe o transakciji se začnejo z ":value"',
    'search_modifier_not_notes_starts'                    => 'Opombe o transakciji se ne začnejo z ":value"',
    'search_modifier_notes_ends'                          => 'Opombe o transakciji se končajo s ":value"',
    'search_modifier_not_notes_ends'                      => 'Opombe o transakciji se ne končajo s ":value"',
    'search_modifier_notes_is'                            => 'Opombe o transakciji so točno ":value"',
    'search_modifier_not_notes_is'                        => 'Opombe o transakciji natanko niso ":value"',
    'search_modifier_no_notes'                            => 'Transakcija nima opomb',
    'search_modifier_not_no_notes'                        => 'Transakcija mora imeti opombe',
    'search_modifier_any_notes'                           => 'Transakcija mora imeti opombe',
    'search_modifier_not_any_notes'                       => 'Transakcija nima opomb',
    'search_modifier_amount_is'                           => 'Znesek je točno :value',
    'search_modifier_not_amount_is'                       => 'Znesek ni :value',
    'search_modifier_amount_less'                         => 'Znesek je manjši ali enak :value',
    'search_modifier_not_amount_more'                     => 'Znesek je manjši ali enak :value',
    'search_modifier_amount_more'                         => 'Znesek je večji ali enak :value',
    'search_modifier_not_amount_less'                     => 'Znesek je večji ali enak :value',
    'search_modifier_source_account_is'                   => 'Ime izvornega računa je točno ":value"',
    'search_modifier_not_source_account_is'               => 'Ime izvornega računa ni ":value"',
    'search_modifier_source_account_contains'             => 'Ime izvornega računa vsebuje ":value"',
    'search_modifier_not_source_account_contains'         => 'Ime izvornega računa ne vsebuje ":value"',
    'search_modifier_source_account_starts'               => 'Ime izvornega računa se začne z ":value"',
    'search_modifier_not_source_account_starts'           => 'Ime izvornega računa se ne začne z ":value"',
    'search_modifier_source_account_ends'                 => 'Ime izvornega računa se konča s ":value"',
    'search_modifier_not_source_account_ends'             => 'Ime izvornega računa se ne konča s ":value"',
    'search_modifier_source_account_id'                   => 'ID izvornega računa je :value',
    'search_modifier_not_source_account_id'               => 'ID izvornega računa ni :value',
    'search_modifier_source_account_nr_is'                => 'Izvorna številka računa (IBAN) je ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Izvorna številka računa (IBAN) ni ":value"',
    'search_modifier_source_account_nr_contains'          => 'Izvorna številka računa (IBAN) vsebuje ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Izvorna številka računa (IBAN) ne vsebuje ":value"',
    'search_modifier_source_account_nr_starts'            => 'Izvorna številka računa (IBAN) se začne z ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Izvorna številka računa (IBAN) se ne začne z ":value"',
    'search_modifier_source_account_nr_ends'              => 'Izvorna številka računa (IBAN) se konča na ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Izvorna številka računa (IBAN) se ne konča na ":value"',
    'search_modifier_destination_account_is'              => 'Ime ciljnega računa je točno ":value"',
    'search_modifier_not_destination_account_is'          => 'Ime ciljnega računa ni ":value"',
    'search_modifier_destination_account_contains'        => 'Ime ciljnega računa vsebuje ":value"',
    'search_modifier_not_destination_account_contains'    => 'Ime ciljnega računa ne vsebuje ":value"',
    'search_modifier_destination_account_starts'          => 'Ime ciljnega računa se začne z ":value"',
    'search_modifier_not_destination_account_starts'      => 'Ime ciljnega računa se ne začne z ":value"',
    'search_modifier_destination_account_ends'            => 'Ime ciljnega računa se konča na ":value"',
    'search_modifier_not_destination_account_ends'        => 'Ime ciljnega računa se ne konča na ":value"',
    'search_modifier_destination_account_id'              => 'ID ciljnega računa je :value',
    'search_modifier_not_destination_account_id'          => 'ID ciljnega računa ni :value',
    'search_modifier_destination_is_cash'                 => 'Ciljni račun je "(gotovina)"',
    'search_modifier_not_destination_is_cash'             => 'Ciljni račun ni račun "(gotovina)"',
    'search_modifier_source_is_cash'                      => 'Izvorni račun je račun "(gotovina)"',
    'search_modifier_not_source_is_cash'                  => 'Izvorni račun ni račun "(gotovina)"',
    'search_modifier_destination_account_nr_is'           => 'Številka ciljnega računa (IBAN) je ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Številka ciljnega računa (IBAN) je ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Številka ciljnega računa (IBAN) vsebuje ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Številka ciljnega računa (IBAN) ne vsebuje ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Številka ciljnega računa (IBAN) se začne z ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Številka ciljnega računa (IBAN) se ne začne z ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Številka ciljnega računa (IBAN) se konča s ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Številka ciljnega računa (IBAN) se ne konča s ":value"',
    'search_modifier_account_id'                          => 'ID-ji izvornega ali ciljnega računa so: :value',
    'search_modifier_not_account_id'                      => 'ID-ji izvornega ali ciljnega računa ni: :value',
    'search_modifier_category_is'                         => 'Kategorija je ":value"',
    'search_modifier_not_category_is'                     => 'Kategorija ni ":value"',
    'search_modifier_budget_is'                           => 'Proračun je ":value"',
    'search_modifier_not_budget_is'                       => 'Proračun ni ":value"',
    'search_modifier_bill_is'                             => 'Naročnina je ":value"',
    'search_modifier_not_bill_is'                         => 'Naročnina ni ":value"',
    'search_modifier_transaction_type'                    => 'Vrsta transakcije je ":value"',
    'search_modifier_not_transaction_type'                => 'Vrsta transakcije ni ":value"',
    'search_modifier_tag_is'                              => 'Oznaka je ":value"',
    'search_modifier_tag_contains'                        => 'Oznaka vsebuje ":value"',
    'search_modifier_not_tag_contains'                    => 'Oznaka ne vsebuje ":value"',
    'search_modifier_tag_ends'                            => 'Oznaka se konča z ":value"',
    'search_modifier_tag_starts'                          => 'Oznaka se začne z ":value"',
    'search_modifier_not_tag_is'                          => 'Nobena oznaka ni ":value"',
    'search_modifier_date_on_year'                        => 'Transakcija je v letu ":value"',
    'search_modifier_not_date_on_year'                    => 'Transakcija ni v letu ":value"',
    'search_modifier_date_on_month'                       => 'Transakcija je v mesecu ":value"',
    'search_modifier_not_date_on_month'                   => 'Transakcija ni v mesecu ":value"',
    'search_modifier_date_on_day'                         => 'Transakcija je na dan v mesecu ":value"',
    'search_modifier_not_date_on_day'                     => 'Transakcija ni na dan v mesecu ":value"',
    'search_modifier_date_before_year'                    => 'Transakcija je pred ali v letu ":value"',
    'search_modifier_date_before_month'                   => 'Transakcija je pred ali v mesecu ":value"',
    'search_modifier_date_before_day'                     => 'Transakcija je pred ali na dan v mesecu ":value"',
    'search_modifier_date_after_year'                     => 'Transakcija je v ali po letu ":value"',
    'search_modifier_date_after_month'                    => 'Transakcija je v ali po mesecu ":value"',
    'search_modifier_date_after_day'                      => 'Transakcija je po ali na dan v mesecu ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Nobena oznaka ni ":value',
    'search_modifier_not_tag_is_not'                      => 'Oznaka je ":value"',
    'search_modifier_account_is'                          => 'Kateri koli račun je ":value"',
    'search_modifier_not_account_is'                      => 'Noben račun ni ":value"',
    'search_modifier_account_contains'                    => 'Kateri koli račun vsebuje ":value"',
    'search_modifier_not_account_contains'                => 'Noben račun ne vsebuje ":value"',
    'search_modifier_account_ends'                        => 'Oba računa se končata s ":value"',
    'search_modifier_not_account_ends'                    => 'Noben račun se ne konča s ":value"',
    'search_modifier_account_starts'                      => 'Oba računa se začneta z ":value"',
    'search_modifier_not_account_starts'                  => 'Noben račun se ne začne z ":value"',
    'search_modifier_account_nr_is'                       => 'Številka računa/IBAN je ":value"',
    'search_modifier_not_account_nr_is'                   => 'Nobena številka računa/IBAN ni ":value"',
    'search_modifier_account_nr_contains'                 => 'Številka računa/IBAN vsebuje ":value"',
    'search_modifier_not_account_nr_contains'             => 'Nobena številka računa / IBAN ne vsebuje ":value"',
    'search_modifier_account_nr_ends'                     => 'Številka računa / IBAN se konča s ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Nobena številka računa / IBAN se ne konča s ":value"',
    'search_modifier_account_nr_starts'                   => 'Številka računa/IBAN se začne z ":value"',
    'search_modifier_not_account_nr_starts'               => 'Nobena številka računa / IBAN se ne začne z ":value"',
    'search_modifier_category_contains'                   => 'Kategorija vsebuje ":value"',
    'search_modifier_not_category_contains'               => 'Kategorija ne vsebuje ":value"',
    'search_modifier_category_ends'                       => 'Kategorija se konča na ":value"',
    'search_modifier_not_category_ends'                   => 'Kategorija se ne konča na ":value"',
    'search_modifier_category_starts'                     => 'Kategorija se začne z ":value"',
    'search_modifier_not_category_starts'                 => 'Kategorija se ne začne z ":value"',
    'search_modifier_budget_contains'                     => 'Proračun vsebuje ":value"',
    'search_modifier_not_budget_contains'                 => 'Proračun ne vsebuje ":value"',
    'search_modifier_budget_ends'                         => 'Proračun se konča s ":value"',
    'search_modifier_not_budget_ends'                     => 'Proračun se ne konča na ":value"',
    'search_modifier_budget_starts'                       => 'Proračun se začne z ":value"',
    'search_modifier_not_budget_starts'                   => 'Proračun se ne začne z ":value"',
    'search_modifier_bill_contains'                       => 'Naročnina vsebuje ":value"',
    'search_modifier_not_bill_contains'                   => 'Naročnina ne vsebuje ":value"',
    'search_modifier_bill_ends'                           => 'Naročnina se konča s ":value"',
    'search_modifier_not_bill_ends'                       => 'Naročnina se ne konča s ":value"',
    'search_modifier_bill_starts'                         => 'Naročnina se začne s ":value"',
    'search_modifier_not_bill_starts'                     => 'Naročnina se ne začne s ":value"',
    'search_modifier_external_id_contains'                => 'Zunanji ID vsebuje ":value"',
    'search_modifier_not_external_id_contains'            => 'Zunanji ID ne vsebuje ":value"',
    'search_modifier_external_id_ends'                    => 'Zunanji ID se konča s ":value"',
    'search_modifier_not_external_id_ends'                => 'Zunanji ID se ne konča s ":value"',
    'search_modifier_external_id_starts'                  => 'Zunanji ID se začne z ":value"',
    'search_modifier_not_external_id_starts'              => 'Zunanji ID se ne začne z ":value"',
    'search_modifier_internal_reference_contains'         => 'Notranja referenca vsebuje ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Notranja referenca ne vsebuje ":value"',
    'search_modifier_internal_reference_ends'             => 'Notranja referenca se konča s ":value"',
    'search_modifier_internal_reference_starts'           => 'Notranja referenca se začne z ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Notranja referenca se ne konča s ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Notranja referenca se ne začne z ":value"',
    'search_modifier_external_url_is'                     => 'Zunanji URL je ":value"',
    'search_modifier_not_external_url_is'                 => 'Zunanji URL ni ":value"',
    'search_modifier_external_url_contains'               => 'Zunanji URL vsebuje ":value"',
    'search_modifier_not_external_url_contains'           => 'Zunanji URL ne vsebuje ":value"',
    'search_modifier_external_url_ends'                   => 'Zunanji URL se konča s ":value"',
    'search_modifier_not_external_url_ends'               => 'Zunanji URL se ne konča s ":value"',
    'search_modifier_external_url_starts'                 => 'Zunanji URL se začne z ":value"',
    'search_modifier_not_external_url_starts'             => 'Zunanji URL se ne začne z ":value"',
    'search_modifier_has_no_attachments'                  => 'Transakcija nima prilog',
    'search_modifier_not_has_no_attachments'              => 'Transakcija ima priloge',
    'search_modifier_not_has_attachments'                 => 'Transakcija nima prilog',
    'search_modifier_account_is_cash'                     => 'Kateri koli račun je račun "(gotovina)".',
    'search_modifier_not_account_is_cash'                 => 'Noben račun ni račun "(gotovina)".',
    'search_modifier_journal_id'                          => 'ID dnevnika je ":value"',
    'search_modifier_not_journal_id'                      => 'ID dnevnika ni ":value"',
    'search_modifier_recurrence_id'                       => 'ID ponavljajoče se transakcije je ":value"',
    'search_modifier_not_recurrence_id'                   => 'ID ponavljajoče se transakcije ni »:value«',
    'search_modifier_foreign_amount_is'                   => 'Tuji znesek je ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Tuji znesek ni ":value"',
    'search_modifier_foreign_amount_less'                 => 'Tuji znesek je manjši od ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Tuji znesek je manjši od ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Tuji znesek je večji od ":value"',
    'search_modifier_foreign_amount_more'                 => 'Tuji znesek je večji od ":value"',
    'search_modifier_exists'                              => 'Transakcija obstaja (katera koli transakcija)',
    'search_modifier_not_exists'                          => 'Transakcija ne obstaja (ni transakcije)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Datum obresti transakcije je ":value"',
    'search_modifier_not_interest_date_on'                => 'Datum obresti transakcije ni ":value"',
    'search_modifier_interest_date_on_year'               => 'Datum obresti transakcije je v letu ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Datum obresti transakcije ni v letu ":value"',
    'search_modifier_interest_date_on_month'              => 'Datum obresti transakcije je v mesecu ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Datum obresti transakcije ni v mesecu ":value"',
    'search_modifier_interest_date_on_day'                => 'Datum obresti transakcije je na dan v mesecu ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Datum obresti transakcije ni na dan v mesecu ":value"',
    'search_modifier_interest_date_before_year'           => 'Datum obresti transakcije je pred ali v letu ":value"',
    'search_modifier_interest_date_before_month'          => 'Datum obresti transakcije je pred ali v mesecu ":value"',
    'search_modifier_interest_date_before_day'            => 'Datum obresti transakcije je pred ali na dan v mesecu ":value"',
    'search_modifier_interest_date_after_year'            => 'Datum obresti transakcije je po ali v letu ":value"',
    'search_modifier_interest_date_after_month'           => 'Datum obresti transakcije je po ali v mesecu ":value"',
    'search_modifier_interest_date_after_day'             => 'Datum obresti transakcije je po ali na dan v mesecu ":value"',
    'search_modifier_book_date_on_year'                   => 'Datum knjiženja je v letu ":value"',
    'search_modifier_book_date_on_month'                  => 'Datum knjiženja je v mesecu ":value"',
    'search_modifier_book_date_on_day'                    => 'Datum knjiženja je na dan v mesecu ":value"',
    'search_modifier_not_book_date_on_year'               => 'Datum knjiženja ni v letu ":value"',
    'search_modifier_not_book_date_on_month'              => 'Datum knjiženja ni v mesecu ":value"',
    'search_modifier_not_book_date_on_day'                => 'Datum knjiženja ni na dan v mesecu ":value"',
    'search_modifier_book_date_before_year'               => 'Datum knjiženja je pred ali v letu ":value"',
    'search_modifier_book_date_before_month'              => 'Datum knjiženja je pred ali v mesecu ":value"',
    'search_modifier_book_date_before_day'                => 'Datum knjiženja je pred ali na dan v mesecu ":value"',
    'search_modifier_book_date_after_year'                => 'Datum knjiženja je za ali v letu ":value"',
    'search_modifier_book_date_after_month'               => 'Datum knjiženja je za ali v mesecu ":value"',
    'search_modifier_book_date_after_day'                 => 'Datum knjiženja je za ali na dan v mesecu ":value"',
    'search_modifier_process_date_on_year'                => 'Datum postopka transakcije je v letu ":value"',
    'search_modifier_process_date_on_month'               => 'Datum postopka transakcije je v mesecu ":value"',
    'search_modifier_process_date_on_day'                 => 'Datum postopka transakcije je na dan v mesecu ":value"',
    'search_modifier_not_process_date_on_year'            => 'Datum postopka transakcije ni v letu ":value"',
    'search_modifier_not_process_date_on_month'           => 'Datum postopka transakcije ni v mesecu ":value"',
    'search_modifier_not_process_date_on_day'             => 'Datum postopka transakcije ni na dan v mesecu ":value"',
    'search_modifier_process_date_before_year'            => 'Datum postopka transakcije je pred ali v letu ":value"',
    'search_modifier_process_date_before_month'           => 'Datum postopka transakcije je pred ali v mesecu ":value"',
    'search_modifier_process_date_before_day'             => 'Datum postopka transakcije je pred ali na dan v mesecu ":value"',
    'search_modifier_process_date_after_year'             => 'Datum postopka transakcije je za ali v letu ":value"',
    'search_modifier_process_date_after_month'            => 'Datum postopka transakcije je po ali v mesecu ":value"',
    'search_modifier_process_date_after_day'              => 'Datum postopka transakcije je po ali na dan v mesecu ":value"',
    'search_modifier_due_date_on_year'                    => 'Rok zapadlosti transakcije je v letu ":value"',
    'search_modifier_due_date_on_month'                   => 'Rok zapadlosti transakcije je v mesecu ":value"',
    'search_modifier_due_date_on_day'                     => 'Rok zapadlosti transakcije je na dan v mesecu ":value"',
    'search_modifier_not_due_date_on_year'                => 'Rok zapadlosti transakcije ni v letu ":value"',
    'search_modifier_not_due_date_on_month'               => 'Rok zapadlosti transakcije ni v mesecu ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Datum zapadlosti transakcije ni na dan v mesecu ":value"',
    'search_modifier_due_date_before_year'                => 'Rok zapadlosti transakcije je pred ali v letu ":value"',
    'search_modifier_due_date_before_month'               => 'Rok zapadlosti transakcije je pred ali v mesecu ":value"',
    'search_modifier_due_date_before_day'                 => 'Datum zapadlosti transakcije je pred ali na dan v mesecu ":value"',
    'search_modifier_due_date_after_year'                 => 'Rok zapadlosti transakcije je po ali v letu ":value"',
    'search_modifier_due_date_after_month'                => 'Rok zapadlosti transakcije je po ali v mesecu ":value"',
    'search_modifier_due_date_after_day'                  => 'Datum zapadlosti transakcije je po ali na dan v mesecu ":value"',
    'search_modifier_payment_date_on_year'                => 'Datum plačila transakcije je v letu ":value"',
    'search_modifier_payment_date_on_month'               => 'Datum plačila transakcije je v mesecu ":value"',
    'search_modifier_payment_date_on_day'                 => 'Datum plačila transakcije je dan v mesecu ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Datum plačila transakcije ni v letu ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Datum plačila transakcije ni v mesecu ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Datum plačila transakcije ni na dan v mesecu ":value"',
    'search_modifier_payment_date_before_year'            => 'Datum plačila transakcije je pred ali v letu ":value"',
    'search_modifier_payment_date_before_month'           => 'Datum plačila transakcije je pred ali v mesecu ":value"',
    'search_modifier_payment_date_before_day'             => 'Datum plačila transakcije je pred ali na dan v mesecu ":value"',
    'search_modifier_payment_date_after_year'             => 'Datum plačila transakcije je po ali v letu ":value"',
    'search_modifier_payment_date_after_month'            => 'Datum plačila transakcije je po ali v mesecu ":value"',
    'search_modifier_payment_date_after_day'              => 'Datum plačila transakcije je po ali na dan v mesecu ":value"',
    'search_modifier_invoice_date_on_year'                => 'Datum transakcijskega računa je v letu ":value"',
    'search_modifier_invoice_date_on_month'               => 'Datum transakcijskega računa je v mesecu ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Datum transakcijskega računa je na dan v mesecu ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Datum transakcijskega računa ni v letu ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Datum transakcijskega računa ni v mesecu ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Datum transakcijskega računa ni na dan v mesecu ":value"',
    'search_modifier_invoice_date_before_year'            => 'Datum transakcijskega računa je pred ali v letu ":value"',
    'search_modifier_invoice_date_before_month'           => 'Datum transakcijskega računa je pred ali v mesecu ":value"',
    'search_modifier_invoice_date_before_day'             => 'Datum transakcijskega računa je pred ali na dan v mesecu ":value"',
    'search_modifier_invoice_date_after_year'             => 'Datum transakcijskega računa je za ali v letu ":value"',
    'search_modifier_invoice_date_after_month'            => 'Datum transakcijskega računa je po ali v mesecu ":value"',
    'search_modifier_invoice_date_after_day'              => 'Datum transakcijskega računa je po ali na dan v mesecu ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transakcija je bila nazadnje posodobljena v letu ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transakcija je bila nazadnje posodobljena v mesecu ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transakcija je bila nazadnje posodobljena na dan v mesecu ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transakcija ni bila nazadnje posodobljena v letu ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transakcija ni bila nazadnje posodobljena v mesecu ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transakcija ni bila nazadnje posodobljena na dan v mesecu ":value"',
    'search_modifier_updated_at_before_year'              => 'Transakcija je bila nazadnje posodobljena v ali pred letom ":value"',
    'search_modifier_updated_at_before_month'             => 'Transakcija je bila nazadnje posodobljena v ali pred mesecem ":value"',
    'search_modifier_updated_at_before_day'               => 'Transakcija je bila nazadnje posodobljena na ali pred dnevom v mesecu ":value"',
    'search_modifier_updated_at_after_year'               => 'Transakcija je bila nazadnje posodobljena v ali po letu ":value"',
    'search_modifier_updated_at_after_month'              => 'Transakcija je bila nazadnje posodobljena v ali po mesecu ":value"',
    'search_modifier_updated_at_after_day'                => 'Transakcija je bila nazadnje posodobljena na ali po dnevu v mesecu ":value"',
    'search_modifier_created_at_on_year'                  => 'Transakcija je bila ustvarjena v letu ":value"',
    'search_modifier_created_at_on_month'                 => 'Transakcija je bila ustvarjena v mesecu ":value"',
    'search_modifier_created_at_on_day'                   => 'Transakcija je bila ustvarjena na dan v mesecu ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transakcija ni bila ustvarjena v letu ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transakcija ni bila ustvarjena v mesecu ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transakcija ni bila ustvarjena na dan v mesecu ":value"',
    'search_modifier_created_at_before_year'              => 'Transakcija je bila ustvarjena v ali pred letom ":value"',
    'search_modifier_created_at_before_month'             => 'Transakcija je bila ustvarjena v ali pred mesecem ":value"',
    'search_modifier_created_at_before_day'               => 'Transakcija je bila ustvarjena na ali pred dnevom v mesecu ":value"',
    'search_modifier_created_at_after_year'               => 'Transakcija je bila ustvarjena na ali po ":value"',
    'search_modifier_created_at_after_month'              => 'Transakcija je bila ustvarjena v ali po mesecu ":value"',
    'search_modifier_created_at_after_day'                => 'Transakcija je bila ustvarjena na ali po dnevu v mesecu ":value"',
    'search_modifier_interest_date_before'                => 'Datum obresti transakcije je na ali pred ":value"',
    'search_modifier_interest_date_after'                 => 'Datum obresti transakcije je na ali po ":value"',
    'search_modifier_book_date_on'                        => 'Datum knjiženja je ":value"',
    'search_modifier_not_book_date_on'                    => 'Datum knjiženja ni ":value"',
    'search_modifier_book_date_before'                    => 'Datum knjiženja je na ali pred ":value"',
    'search_modifier_book_date_after'                     => 'Datum knjiženja je na ali po ":value"',
    'search_modifier_process_date_on'                     => 'Datum postopka transakcije je na ":value"',
    'search_modifier_not_process_date_on'                 => 'Datum postopka transakcije ni na ":value"',
    'search_modifier_process_date_before'                 => 'Datum postopka transakcije je na ali pred ":value"',
    'search_modifier_process_date_after'                  => 'Datum postopka transakcije je na ali po ":value"',
    'search_modifier_due_date_on'                         => 'Rok transakcije je na ":value"',
    'search_modifier_not_due_date_on'                     => 'Rok zapadlosti transakcije ni na ":value"',
    'search_modifier_due_date_before'                     => 'Datum zapadlosti transakcije je na ali pred ":value"',
    'search_modifier_due_date_after'                      => 'Datum zapadlosti transakcije je na ali po ":value"',
    'search_modifier_payment_date_on'                     => 'Datum plačila transakcije je na ":value"',
    'search_modifier_not_payment_date_on'                 => 'Datum plačila transakcije ni na ":value"',
    'search_modifier_payment_date_before'                 => 'Datum plačila transakcije je na ali pred ":value"',
    'search_modifier_payment_date_after'                  => 'Datum plačila transakcije je na ali po ":value"',
    'search_modifier_invoice_date_on'                     => 'Datum transakcijskega računa je na ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Datum transakcijskega računa ni na ":value"',
    'search_modifier_invoice_date_before'                 => 'Datum transakcijskega računa je na ali pred ":value"',
    'search_modifier_invoice_date_after'                  => 'Datum transakcijskega računa je na ali po ":value"',
    'search_modifier_created_at_on'                       => 'Transakcija je bila ustvarjena na ":value"',
    'search_modifier_not_created_at_on'                   => 'Transakcija ni bila ustvarjena na ":value"',
    'search_modifier_created_at_before'                   => 'Transakcija je bila ustvarjena na ali pred ":value"',
    'search_modifier_created_at_after'                    => 'Transakcija je bila ustvarjena na ali po ":value"',
    'search_modifier_updated_at_on'                       => 'Transakcija je bila posodobljena na ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transakcija ni bila posodobljena na ":value"',
    'search_modifier_updated_at_before'                   => 'Transakcija je bila posodobljena na ali pred ":value"',
    'search_modifier_updated_at_after'                    => 'Transakcija je bila posodobljena na ali po ":value"',

    'search_modifier_attachment_name_is'            => 'Ime katere koli priloge je ":value"',
    'search_modifier_attachment_name_contains'      => 'Vsako ime priloge vsebuje ":value"',
    'search_modifier_attachment_name_starts'        => 'Vsako ime priloge se začne z ":value"',
    'search_modifier_attachment_name_ends'          => 'Vsako ime priloge se konča s ":value"',
    'search_modifier_attachment_notes_are'          => 'Vse opombe k prilogi so ":value"',
    'search_modifier_attachment_notes_contains'     => 'Vse opombe k prilogi vsebujejo ":value"',
    'search_modifier_attachment_notes_starts'       => 'Vse opombe k prilogi se začnejo z ":value"',
    'search_modifier_attachment_notes_ends'         => 'Opombe katere koli priloge se končajo s ":value"',
    'search_modifier_not_attachment_name_is'        => 'Ime nobene priloge ni ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Ime nobene priloge ne vsebuje ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Ime nobene priloge se ne začne z ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Ime nobene priloge se ne konča s ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Opombe k prilogi niso »:value«',
    'search_modifier_not_attachment_notes_contains' => 'Opombe k prilogi ne vsebujejo ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Vse opombe k prilogi se začnejo z ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Opombe k prilogi se ne končajo s ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT je ":value"',
    'update_rule_from_query'                        => 'Posodobite pravilo ":rule" iz iskalne poizvedbe',
    'create_rule_from_query'                        => 'Ustvari novo pravilo iz iskalne poizvedbe',
    'rule_from_search_words'                        => 'Mehanizem pravil težko obravnava ":string".  Predlagano pravilo, ki ustreza vaši iskalni poizvedbi, lahko daje drugačne rezultate.  Pazljivo preverite sprožilce pravila.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Stanje na ciljnem računu je točno ":value"',
    'search_modifier_not_destination_balance_is'    => 'Stanje na ciljnem računu NI točno ":value"',
    'search_modifier_source_balance_is'             => 'Stanje na izvornem računu je točno ":value"',
    'search_modifier_not_source_balance_is'         => 'Stanje na izvornem računu NI točno ":value"',

    'search_modifier_destination_balance_lte'     => 'Stanje na ciljnem računu je manjše ali enako ":value"',
    'search_modifier_not_destination_balance_lte' => 'Stanje na ciljnem računu je več kot ":value"',
    'search_modifier_source_balance_lte'          => 'Stanje na izvornem računu je manjše ali enako ":value"',
    'search_modifier_not_source_balance_lte'      => 'Stanje na izvornem računu je več kot ":value"',

    'search_modifier_destination_balance_lt'     => 'Stanje na ciljnem računu je manjše od ":value"',
    'search_modifier_not_destination_balance_lt' => 'Stanje na ciljnem računu je večje ali enako ":value"',
    'search_modifier_source_balance_lt'          => 'Stanje na izvornem računu je manjše od ":value"',
    'search_modifier_not_source_balance_lt'      => 'Stanje na izvornem računu je večje ali enako ":value"',

    'search_modifier_destination_balance_gte'     => 'Stanje na ciljnem računu je večje ali enako ":value"',
    'search_modifier_not_destination_balance_gte' => 'Stanje na ciljnem računu je manjše od ":value"',
    'search_modifier_source_balance_gte'          => 'Stanje na izvornem računu je večje ali enako ":value"',
    'search_modifier_not_source_balance_gte'      => 'Stanje na izvornem računu je manjše od ":value"',

    'search_modifier_destination_balance_gt'              => 'Stanje na ciljnem računu je več kot ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Stanje na ciljnem računu je manjše ali enako ":value"',
    'search_modifier_source_balance_gt'                   => 'Stanje na izvornem računu je več kot ":value"',
    'search_modifier_not_source_balance_gt'               => 'Stanje na izvornem računu je manjše ali enako ":value"',


    // END
    'general_search_error'                                => 'Pri iskanju je prišlo do napake. Za več informacij preverite datoteke dnevnika.',
    'search_box'                                          => 'Iskanje',
    'search_box_intro'                                    => 'Dobrodošli v iskalni funkciji Firefly III. V polje vnesite iskalno poizvedbo. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Prepričajte se, da ste preverili datoteko s pomočjo</a>, ker je iskanje precej napredno.',
    'search_error'                                        => 'Napaka med iskanjem',
    'search_searching'                                    => 'Iščem...',
    'search_results'                                      => 'Rezultati iskanja',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'letno',
    'repeat_freq_half-year'                               => 'polletno',
    'repeat_freq_quarterly'                               => 'četrtletno',
    'repeat_freq_monthly'                                 => 'mesečno',
    'repeat_freq_weekly'                                  => 'tedensko',
    'repeat_freq_daily'                                   => 'dnevno',
    'daily'                                               => 'dnevno',
    'weekly'                                              => 'tedensko',
    'quarterly'                                           => 'četrtletno',
    'half-year'                                           => 'polletno',
    'yearly'                                              => 'letno',

    // rules
    'is_not_rule_trigger'                                 => 'Ni',
    'cannot_fire_inactive_rules'                          => 'Neaktivnih pravil ne morete izvajati.',
    'show_triggers'                                       => 'Prikaži sprožilce',
    'show_actions'                                        => 'Prikaži dejanja',
    'rules'                                               => 'Pravila',
    'rule_name'                                           => 'Naziv pravila',
    'rule_triggers'                                       => 'Pravilo se sproži, ko',
    'rule_actions'                                        => 'Pravilo bo',
    'new_rule'                                            => 'Novo pravilo',
    'new_rule_group'                                      => 'Nova skupina pravil',
    'rule_priority_up'                                    => 'Pravilu povišajte prioriteto',
    'rule_priority_down'                                  => 'Pravilu znižajte prioriteto',
    'make_new_rule_group'                                 => 'Ustvari novo skupino pravil',
    'store_new_rule_group'                                => 'Shrani novo skupino pravil',
    'created_new_rule_group'                              => 'Nova skupina pravil ":title" je shranjena!',
    'updated_rule_group'                                  => 'Skupina pravil ":title" je uspešno posodobljena.',
    'edit_rule_group'                                     => 'Uredi skupino pravil ":title"',
    'duplicate_rule'                                      => 'Ustvari dvojnik pravila ":title"',
    'rule_copy_of'                                        => 'Kopija ":title"',
    'duplicated_rule'                                     => 'Pravilo ":title" podvojeno v ":newTitle"',
    'delete_rule_group'                                   => 'Izbriši skupino pravil ":title"',
    'deleted_rule_group'                                  => 'Skupina pravil ":title" je izbrisana',
    'update_rule_group'                                   => 'Posodobite skupino pravil',
    'no_rules_in_group'                                   => 'V tej skupini ni pravil',
    'move_rule_group_up'                                  => 'Premakni skupino pravil gor',
    'move_rule_group_down'                                => 'Premakni skupino pravil dol',
    'save_rules_by_moving'                                => 'Shranite to pravilo tako, da ga premaknete v drugo skupino pravil:|Shranite ta pravila tako, da jih premaknete v drugo skupino pravil:',
    'make_new_rule'                                       => 'Ustvari novo pravilo v skupini ":title"',
    'make_new_rule_no_group'                              => 'Ustvari novo pravilo',
    'instructions_rule_from_bill'                         => 'Za ujemanje transakcij z vašo novo naročnino ":name" lahko Firefly III ustvari pravilo, ki bo samodejno preverjeno glede na vse transakcije, ki jih shranite. Preverite spodnje podrobnosti in shranite pravilo, da Firefly III samodejno poveže transakcije z vašim novim računom.',
    'instructions_rule_from_journal'                      => 'Ustvarite pravilo na podlagi transakcije. Dopolnite ali uredite spodnji obrazec.',
    'rule_is_strict'                                      => 'strogo pravilo',
    'rule_is_not_strict'                                  => 'togo pravilo',
    'rule_help_stop_processing'                           => 'Ko potrdite to polje, se poznejša pravila v tej skupini ne bodo izvršila, če se izvede to določeno pravilo.',
    'rule_help_strict'                                    => 'V strogih pravilih se morajo sprožiti vsi sprožilci da se dejanje izvede. V togih pravilih je KATERIKOLI sprožilec dovolj za izvedbo dejanj.',
    'rule_help_active'                                    => 'Neaktivna pravila se ne bodo sprožila.',
    'stored_new_rule'                                     => 'Shranjeno novo pravilo z naslovom ":title"',
    'deleted_rule'                                        => 'Pravilo z naslovom ":title" izbrisano',
    'store_new_rule'                                      => 'Shrani novo pravilo',
    'updated_rule'                                        => 'Pravilo z naslovom ":title" je posodobljeno',
    'default_rule_group_name'                             => 'Privzeto pravilo',
    'default_rule_group_description'                      => 'Vsa pravila ki niso v skupini.',
    'trigger'                                             => 'Sprožilec',
    'trigger_value'                                       => 'Sprožilec na vrednost',
    'stop_processing_other_triggers'                      => 'Ustavi izvajanje drugih sprožilcev',
    'add_rule_trigger'                                    => 'Dodaj nov sprožilec',
    'action'                                              => 'Dejanje',
    'action_value'                                        => 'Vrednost dejanja',
    'stop_executing_other_actions'                        => 'Ustavi izvajanje drugih dejanj',
    'add_rule_action'                                     => 'Dodaj dejanje',
    'edit_rule'                                           => 'Uredi pravilo št.:nr: ":title"',
    'delete_rule'                                         => 'Izbriši pravilo ":title"',
    'update_rule'                                         => 'Uredi pravilo',
    'test_rule_triggers'                                  => 'Poglej ujemajoče se transakcije',
    'warning_no_matching_transactions'                    => 'Ni ustreznih transakcij.',
    'warning_no_valid_triggers'                           => 'Sprožilci niso veljavni.',
    'apply_rule_selection'                                => 'Uporabi pravilo ":title" za izbor transakcij',
    'apply_rule_selection_intro'                          => 'Pravila, kot je ":title", se običajno uporabljajo samo za nove ali posodobljene transakcije, vendar lahko označite da jih Firefly III zažene ob izbiri obstoječih transakcij. To je lahko uporabno, če ste posodobili pravilo in morate spremembe uporabiti za vse druge transakcije.',
    'include_transactions_from_accounts'                  => 'Vključi transakcije iz teh računov',
    'include'                                             => 'Vključim?',
    'applied_rule_selection'                              => '{0} Pravilo »:title« ni spremenilo nobene transakcije v vašem izboru.|[1] Eno transakcijo v vašem izboru je spremenilo pravilo »:title«.|[2,*] :count transakcij v vašem izboru je spremenilo  pravilo ":naslov".',
    'execute'                                             => 'Izvedi',
    'apply_rule_group_selection'                          => 'Uporabite skupino pravil ":title" za izbor transakcij',
    'apply_rule_group_selection_intro'                    => 'Skupine pravil, kot je ":title", se običajno uporabljajo samo za nove ali posodobljene transakcije, vendar lahko označite da jih Firefly III zažene ob izbiri obstoječih transakcij. To je lahko uporabno, če ste posodobili pravilo in morate spremembe uporabiti za vse druge transakcije.',
    'applied_rule_group_selection'                        => 'Skupina pravil ":title" je bila uporabljena za vašo izbiro.',
    'rule_run_after_creation' => 'Če potrdite to polje, boste imeli možnost zagnati pravilo, ko bo ustvarjeno.',
    'rule_run_after_edit' => 'Če potrdite to polje, boste imeli možnost zagnati pravilo po posodobitvi.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Ko je transakcija ustvarjena',
    'rule_trigger_update_journal'                         => 'Ko je transakcija posodobljena',
    'rule_trigger_manual'                                 => 'Samo, ko ga aktivira uporabnik',
    'rule_trigger_user_action'                            => 'Dejanje uporabnika je ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Ime izvornega računa se začne z ...',
    'rule_trigger_source_account_starts'                  => 'Ime izvornega računa se začne z ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Ime izvornega računa se konča s..',
    'rule_trigger_source_account_ends'                    => 'Ime izvornega računa se konča s ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Ime izvornega računa je ...',
    'rule_trigger_source_account_is'                      => 'Ime izvornega računa je ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Ime izvornega računa vsebuje ...',
    'rule_trigger_source_account_contains'                => 'Ime izvornega računa vsebuje ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'ID računa je natančno ...',
    'rule_trigger_account_id'                             => 'ID katerega koli računa je točno :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID izvornega računa je točno ...',
    'rule_trigger_source_account_id'                      => 'ID izvornega računa je točno :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID ciljnega računa je točno ...',
    'rule_trigger_destination_account_id'                 => 'ID ciljnega računa je točno :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Kateri koli račun je gotovina',
    'rule_trigger_account_is_cash'                        => 'Kateri koli račun je gotovina',
    'rule_trigger_source_is_cash_choice'                  => 'Izvorni račun je gotovinski račun',
    'rule_trigger_source_is_cash'                         => 'Izvorni račun je gotovinski račun',
    'rule_trigger_destination_is_cash_choice'             => 'Ciljni račun je (gotovinski) račun',
    'rule_trigger_destination_is_cash'                    => 'Ciljni račun je (gotovinski) račun',
    'rule_trigger_source_account_nr_starts_choice'        => 'Izvorna številka računa / IBAN se začne z ...',
    'rule_trigger_source_account_nr_starts'               => 'Izvorna številka računa / IBAN se začne z ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Izvorna številka računa / IBAN se konča s..',
    'rule_trigger_source_account_nr_ends'                 => 'Izvorna številka računa / IBAN se konča s ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Izvorna številka računa / IBAN je ...',
    'rule_trigger_source_account_nr_is'                   => 'Izvorna številka računa/IBAN je ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Izvorna številka računa / IBAN vsebuje ...',
    'rule_trigger_source_account_nr_contains'             => 'Izvorna številka računa/IBAN vsebuje ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Ime ciljnega računa se začne z ...',
    'rule_trigger_destination_account_starts'             => 'Ime ciljnega računa se začne z ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Ime ciljnega računa se konča s..',
    'rule_trigger_destination_account_ends'               => 'Ime ciljnega računa se konča s ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Ime ciljnega računa je ...',
    'rule_trigger_destination_account_is'                 => 'Ime ciljnega računa je ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Ime ciljnega računa vsebuje ...',
    'rule_trigger_destination_account_contains'           => 'Ime ciljnega računa vsebuje ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Številka ciljnega računa / IBAN se začne s..',
    'rule_trigger_destination_account_nr_starts'          => 'Številka ciljnega računa / IBAN se začne s ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Številka ciljnega računa / IBAN se konča s..',
    'rule_trigger_destination_account_nr_ends'            => 'Številka ciljnega računa / IBAN se konča s ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Številka ciljnega računa / IBAN je ...',
    'rule_trigger_destination_account_nr_is'              => 'Številka ciljnega računa/IBAN je ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Številka ciljnega računa / IBAN vsebuje ...',
    'rule_trigger_destination_account_nr_contains'        => 'Številka ciljnega računa / IBAN vsebuje ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Tip transakcije je..',
    'rule_trigger_transaction_type'                       => 'Tip transakcije je ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategorija je..',
    'rule_trigger_category_is'                            => 'Kategorija je ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Znesek je manjši ali enak ...',
    'rule_trigger_amount_less'                            => 'Znesek je manjši ali enak :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Znesek je..',
    'rule_trigger_amount_is'                              => 'Znesek je :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Znesek je večji ali enak ...',
    'rule_trigger_amount_more'                            => 'Znesek je večji ali enak :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Opis se začne s..',
    'rule_trigger_description_starts'                     => 'Opis se začne s ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Opis se konča s..',
    'rule_trigger_description_ends'                       => 'Opis se konča s ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Opis vsebuje..',
    'rule_trigger_description_contains'                   => 'Opis vsebuje ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Opis je..',
    'rule_trigger_description_is'                         => 'Opis je ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Datum transakcije je ...',
    'rule_trigger_date_on'                                => 'Datum transakcije je ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Datum transakcije je pred ...',
    'rule_trigger_date_before'                            => 'Datum transakcije je pred ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Datum transakcije je po ...',
    'rule_trigger_date_after'                             => 'Datum transakcije je za ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transakcija je bila izvedena dne ...',
    'rule_trigger_created_at_on'                          => 'Transakcija je bila izvedena na ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transakcija je bila nazadnje urejena ...',
    'rule_trigger_updated_at_on'                          => 'Transakcija je bila nazadnje urejena dne ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Proračun je..',
    'rule_trigger_budget_is'                              => 'Proračun je ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Vsaka oznaka je ...',
    'rule_trigger_tag_is'                                 => 'Katera koli oznaka je ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Katera koli oznaka vsebuje..',
    'rule_trigger_tag_contains'                           => 'Katera koli oznaka vsebuje ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'Ne obstaja oznaka ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Katera koli oznaka se konča s..',
    'rule_trigger_tag_ends'                               => 'Katera koli oznaka se konča s ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Katera koli oznaka se začne s..',
    'rule_trigger_tag_starts'                             => 'Katera koli oznaka se začne s ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Valuta transakcije je..',
    'rule_trigger_currency_is'                            => 'Valuta transakcije je ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Tuja valuta transakcije je ...',
    'rule_trigger_foreign_currency_is'                    => 'Tuja valuta transakcije je ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Ima priloge',
    'rule_trigger_has_attachments'                        => 'Ima kakršne koli priloge',
    'rule_trigger_has_no_category_choice'                 => 'Nima kategorije',
    'rule_trigger_has_no_category'                        => 'Transakcija nima kategorije',
    'rule_trigger_has_any_category_choice'                => 'Ima kategorijo',
    'rule_trigger_has_any_category'                       => 'Transakcija ima (katerokoli) kategorijo',
    'rule_trigger_has_no_budget_choice'                   => 'Nima proračuna',
    'rule_trigger_has_no_budget'                          => 'Transakcija nima proračuna',
    'rule_trigger_has_any_budget_choice'                  => 'Ima (katerikoli) proračun',
    'rule_trigger_has_any_budget'                         => 'Transakcija ima (katerikoli) proračun',
    'rule_trigger_has_no_bill_choice'                     => 'Nima naročnine',
    'rule_trigger_has_no_bill'                            => 'Transakcija nima naročnine',
    'rule_trigger_has_any_bill_choice'                    => 'Ima (katerokoli) naročnino',
    'rule_trigger_has_any_bill'                           => 'Transakcija ima (katerokoli) naročnino',
    'rule_trigger_has_no_tag_choice'                      => 'Nima oznak',
    'rule_trigger_has_no_tag'                             => 'Transakcija nima oznak(e)',
    'rule_trigger_has_any_tag_choice'                     => 'Ima eno ali več oznak',
    'rule_trigger_has_any_tag'                            => 'Transakcija ima eno ali več oznak',
    'rule_trigger_any_notes_choice'                       => 'Ima zaznamke',
    'rule_trigger_any_notes'                              => 'Transakcija ima zaznamke',
    'rule_trigger_no_notes_choice'                        => 'Nima zaznamkov',
    'rule_trigger_no_notes'                               => 'Transakcija nima zaznamkov',
    'rule_trigger_notes_is_choice'                        => 'Opombe so..',
    'rule_trigger_notes_is'                               => 'Opombe so ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Opombe vsebujejo ...',
    'rule_trigger_notes_contains'                         => 'Opombe vsebujejo ":trigger_value',
    'rule_trigger_notes_starts_choice'                    => 'Opombe se začnejo s..',
    'rule_trigger_notes_starts'                           => 'Opombe se začnejo s ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Opombe se končajo s..',
    'rule_trigger_notes_ends'                             => 'Opombe se končajo s ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Naročnina je..',
    'rule_trigger_bill_is'                                => 'Naročnina je ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Zunanji ID je ...',
    'rule_trigger_external_id_is'                         => 'Zunanji ID je ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Notranja referenca je ..',
    'rule_trigger_internal_reference_is'                  => 'Notranja referenca je ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID dnevnika transakcij je ...',
    'rule_trigger_journal_id'                             => 'ID dnevnika transakcij je ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transakcija ima (kateri koli) zunanji URL',
    'rule_trigger_any_external_url_choice'                => 'Ima (kateri koli) zunanji URL',
    'rule_trigger_any_external_id'                        => 'Transakcija ima (poljubni) zunanji ID',
    'rule_trigger_any_external_id_choice'                 => 'Ima (kateri koli) zunanji ID',
    'rule_trigger_no_external_url_choice'                 => 'Nima zunanjega URL-ja',
    'rule_trigger_no_external_url'                        => 'Transakcija nima zunanjega URL-ja',
    'rule_trigger_no_external_id_choice'                  => 'Nima zunanjega ID-ja',
    'rule_trigger_no_external_id'                         => 'Transakcija nima zunanjega ID-ja',
    'rule_trigger_id_choice'                              => 'ID transakcije je ...',
    'rule_trigger_id'                                     => 'ID transakcije je ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT je ...',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT je ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Dejanje uporabnika je ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Nobena oznaka ni..',
    'rule_trigger_tag_is_not'                             => 'Nobena oznaka ni ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Vsak račun je točno ...',
    'rule_trigger_account_is'                             => 'Kateri koli račun je točno ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Vsak račun vsebuje ...',
    'rule_trigger_account_contains'                       => 'Kateri koli račun vsebuje ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Kateri koli račun se konča s..',
    'rule_trigger_account_ends'                           => 'Oba računa se končata s ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Vsak račun se začne s..',
    'rule_trigger_account_starts'                         => 'Oba računa se začneta s ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Številka računa / IBAN je ...',
    'rule_trigger_account_nr_is'                          => 'Številka računa/IBAN je ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Številka računa / IBAN vsebuje ...',
    'rule_trigger_account_nr_contains'                    => 'Številka računa/IBAN vsebuje ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Katera koli številka računa / IBAN se konča s..',
    'rule_trigger_account_nr_ends'                        => 'Številka računa/IBAN se konča s ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Številka računa/IBAN se začne s..',
    'rule_trigger_account_nr_starts'                      => 'Številka računa/IBAN se začne z ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Kategorija vsebuje ...',
    'rule_trigger_category_contains'                      => 'Kategorija vsebuje ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Kategorija se konča s..',
    'rule_trigger_category_ends'                          => 'Kategorija se konča s ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Kategorija se začne s..',
    'rule_trigger_category_starts'                        => 'Kategorija se začne s ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Proračun vsebuje ...',
    'rule_trigger_budget_contains'                        => 'Proračun vsebuje ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Proračun se konča s..',
    'rule_trigger_budget_ends'                            => 'Proračun se konča s ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Proračun se začne s..',
    'rule_trigger_budget_starts'                          => 'Proračun se začne s ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Naročnina vsebuje..',
    'rule_trigger_bill_contains'                          => 'Naročnina vsebuje ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Naročnina se konča s..',
    'rule_trigger_bill_ends'                              => 'Naročnina se konča s ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Naročnina se začne s..',
    'rule_trigger_bill_starts'                            => 'Naročnina se začne s ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Zunanji ID vsebuje ...',
    'rule_trigger_external_id_contains'                   => 'Zunanji ID vsebuje ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Zunanji ID se konča s..',
    'rule_trigger_external_id_ends'                       => 'Zunanji ID se konča s ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Zunanji ID se začne s..',
    'rule_trigger_external_id_starts'                     => 'Zunanji ID se začne s ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Notranja referenca vsebuje ...',
    'rule_trigger_internal_reference_contains'            => 'Notranja referenca vsebuje ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Notranja referenca se konča s..',
    'rule_trigger_internal_reference_ends'                => 'Notranja referenca se konča s ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Notranja referenca se začne s..',
    'rule_trigger_internal_reference_starts'              => 'Notranja referenca se začne s ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Zunanji URL je ...',
    'rule_trigger_external_url_is'                        => 'Zunanji URL je ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Zunanji URL vsebuje ...',
    'rule_trigger_external_url_contains'                  => 'Zunanji URL vsebuje ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Zunanji URL se konča s..',
    'rule_trigger_external_url_ends'                      => 'Zunanji URL se konča s ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Zunanji URL se začne s..',
    'rule_trigger_external_url_starts'                    => 'Zunanji URL se začne s ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Nima prilog',
    'rule_trigger_has_no_attachments'                     => 'Transakcija nima prilog',
    'rule_trigger_recurrence_id_choice'                   => 'ID ponavljajoče se transakcije je ...',
    'rule_trigger_recurrence_id'                          => 'ID ponavljajoče se transakcije je ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Datum obresti je ...',
    'rule_trigger_interest_date_on'                       => 'Datum obresti je na ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Datum obresti je pred ...',
    'rule_trigger_interest_date_before'                   => 'Datum obresti je pred ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Datum obresti je po ...',
    'rule_trigger_interest_date_after'                    => 'Datum obresti je za ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Datum knjige je ...',
    'rule_trigger_book_date_on'                           => 'Datum knjige je na ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Datum knjige je pred ...',
    'rule_trigger_book_date_before'                       => 'Datum knjige je pred ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Datum knjige je po ...',
    'rule_trigger_book_date_after'                        => 'Datum knjige je za ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Datum postopka je ..',
    'rule_trigger_process_date_on'                        => 'Datum postopka je ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Datum postopka je pred ...',
    'rule_trigger_process_date_before'                    => 'Datum postopka je pred ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Datum postopka je po ...',
    'rule_trigger_process_date_after'                     => 'Datum postopka je za ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Rok je na ...',
    'rule_trigger_due_date_on'                            => 'Rok je na ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Rok je pred ...',
    'rule_trigger_due_date_before'                        => 'Rok je pred ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Rok je po ...',
    'rule_trigger_due_date_after'                         => 'Rok je za ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Datum plačila je ...',
    'rule_trigger_payment_date_on'                        => 'Datum plačila je ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Datum plačila je pred ...',
    'rule_trigger_payment_date_before'                    => 'Datum plačila je pred ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Datum plačila je po ...',
    'rule_trigger_payment_date_after'                     => 'Datum plačila je po ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Datum računa je ...',
    'rule_trigger_invoice_date_on'                        => 'Datum računa je na ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Datum računa je pred ...',
    'rule_trigger_invoice_date_before'                    => 'Datum računa je pred ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Datum računa je po ...',
    'rule_trigger_invoice_date_after'                     => 'Datum računa je za ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transakcija je bila ustvarjena pred ...',
    'rule_trigger_created_at_before'                      => 'Transakcija je bila ustvarjena pred ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transakcija je bila ustvarjena po ...',
    'rule_trigger_created_at_after'                       => 'Transakcija je bila ustvarjena po ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transakcija je bila nazadnje posodobljena pred ...',
    'rule_trigger_updated_at_before'                      => 'Transakcija je bila nazadnje posodobljena pred ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transakcija je bila nazadnje posodobljena po ...',
    'rule_trigger_updated_at_after'                       => 'Transakcija je bila nazadnje posodobljena po ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Tuji znesek je točno ...',
    'rule_trigger_foreign_amount_is'                      => 'Tuji znesek je točno ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Tuji znesek je manjši od ...',
    'rule_trigger_foreign_amount_less'                    => 'Tuji znesek je manjši od ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Tuji znesek je več kot ...',
    'rule_trigger_foreign_amount_more'                    => 'Tuji znesek je večji od ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Ime katere koli priloge je ...',
    'rule_trigger_attachment_name_is'                     => 'Ime katere koli priloge je ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Vsako ime priloge vsebuje ...',
    'rule_trigger_attachment_name_contains'               => 'Vsako ime priloge vsebuje ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Vsako ime priloge se začne z ...',
    'rule_trigger_attachment_name_starts'                 => 'Vsako ime priloge se začne z ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Vsako ime priloge se konča s..',
    'rule_trigger_attachment_name_ends'                   => 'Vsako ime priloge se konča s ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Morebitne opombe k prilogi so ...',
    'rule_trigger_attachment_notes_are'                   => 'Vse opombe k prilogi so ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Vse opombe k prilogi vsebujejo ...',
    'rule_trigger_attachment_notes_contains'              => 'Vse opombe k prilogi vsebujejo ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Vse opombe k prilogi se začnejo s..',
    'rule_trigger_attachment_notes_starts'                => 'Vse opombe k prilogi se začnejo s ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Vse opombe k prilogi se končajo s..',
    'rule_trigger_attachment_notes_ends'                  => 'Vse opombe k prilogi se končajo s ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transakcija je usklajena',
    'rule_trigger_reconciled'                             => 'Transakcija je usklajena',
    'rule_trigger_exists_choice'                          => 'Katera koli transakcija se ujema(!)',
    'rule_trigger_exists'                                 => 'Vsaka transakcija se ujema',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'ID računa ni ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'ID izvornega računa ni ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID ciljnega računa ni ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Vrsta transakcije ni ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Oznaka ni ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Oznaka je ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Opis ni ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Opis ne vsebuje ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Opis se začne s ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Opis se ne začne s ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Opombe niso ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Opombe ne vsebujejo ":trigger_value',
    'rule_trigger_not_notes_ends'                         => 'Opombe se ne končajo na ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Opombe se ne začnejo s ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Izvorni račun ni ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Izvorni račun ne vsebuje ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Izvorni račun se ne konča na ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Izvorni račun se ne začne s ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Izvorna številka računa/IBAN ni ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Izvorna številka računa/IBAN ne vsebuje ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Izvorna številka računa / IBAN se ne konča na ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Izvorna številka računa/IBAN se ne začne s ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Ciljni račun ni ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Ciljni račun ne vsebuje ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Ciljni račun se ne konča na ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Ciljni račun se ne začne s ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Številka ciljnega računa/IBAN ni ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Številka ciljnega računa / IBAN ne vsebuje ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Številka ciljnega računa / IBAN se ne konča na ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Številka ciljnega računa / IBAN se ne začne s ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Noben račun ni ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Noben račun ne vsebuje ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Noben račun se ne konča na ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Noben račun se ne začne s ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Nobena številka računa/IBAN ni ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Nobena številka računa / IBAN ne vsebuje ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Nobena številka računa / IBAN se ne konča na ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Nobena številka računa / IBAN se začne z ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Kategorija ni ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Kategorija ne vsebuje ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Kategorija se ne konča na ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Kategorija se ne začne s ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Proračun ni ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Proračun ne vsebuje ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Proračun se ne konča na ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Proračun se ne začne z ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Naročnina ni ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Naročnina ne vsebuje ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Naročnina se ne konča na ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Naročnina se ne konča s ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Zunanji ID ni ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Zunanji ID ne vsebuje ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Zunanji ID se ne konča na ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Zunanji ID se ne začne s ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Notranja referenca ni ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Notranja referenca ne vsebuje ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Notranja referenca se ne konča na ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Notranja referenca se ne začne s ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Zunanji URL ni ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Zunanji URL ne vsebuje ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Zunanji URL se ne konča na ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Zunanji URL se ne začne s ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Valuta ni ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Tuja valuta ni ":trigger_value"',
    'rule_trigger_not_id'                                 => 'ID transakcije ni ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'ID dnevnika transakcij ni ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'ID ponavljanja ni ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Datum ni na ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Datum ni pred ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Datum ni po ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Datum obresti ni na ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Datum obresti ni pred ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Datum obresti ni po ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Datum knjige ni na ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Datum knjige ni pred ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Datum knjige ni za ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Datum postopka ni na ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Datum postopka ni pred ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Datum postopka ni po ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Rok ni na ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Rok ni pred ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Rok ni za ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Datum plačila ni na ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Datum plačila ni pred ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Datum plačila ni po ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Datum računa ni na ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Datum računa ni pred ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Datum računa ni za ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transakcija ni ustvarjena na ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transakcija ni ustvarjena pred ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transakcija ni ustvarjena po ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transakcija ni posodobljena na ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transakcija ni posodobljena pred ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transakcija ni posodobljena po ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Znesek transakcije ni ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Znesek transakcije je večji od ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Znesek transakcije je manjši od ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Znesek transakcije v tujini ni ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Znesek tuje transakcije je večji od ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Znesek tuje transakcije je manjši od ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Nobena priloga ni imenovana ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Nobeno ime priloge ne vsebuje ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Nobeno ime priloge se ne začne z ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Nobeno ime priloge se ne konča na ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Nobena opomba v prilogi ni ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Nobena opomba v prilogi ne vsebuje ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Nobena opomba v prilogi se ne začne z ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Nobena opomba v prilogi se ne konča na ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transakcija ni usklajena',
    'rule_trigger_not_exists'                             => 'Transakcija ne obstaja',
    'rule_trigger_not_has_attachments'                    => 'Transakcija nima prilog',
    'rule_trigger_not_has_any_category'                   => 'Transakcija nima kategorije',
    'rule_trigger_not_has_any_budget'                     => 'Transakcija nima proračuna',
    'rule_trigger_not_has_any_bill'                       => 'Transakcija nima naročnine',
    'rule_trigger_not_has_any_tag'                        => 'Transakcija nima oznak',
    'rule_trigger_not_any_notes'                          => 'Transakcija nima opomb',
    'rule_trigger_not_any_external_url'                   => 'Transakcija nima zunanjega URL-ja',
    'rule_trigger_not_has_no_attachments'                 => 'Transakcija ima (poljubne) priloge',
    'rule_trigger_not_has_no_category'                    => 'Transakcija ima (poljubno) kategorijo',
    'rule_trigger_not_has_no_budget'                      => 'Transakcija ima (poljubni) proračun',
    'rule_trigger_not_has_no_bill'                        => 'Transakcija ima (katerokoli) naročnino',
    'rule_trigger_not_has_no_tag'                         => 'Transakcija ima (poljubno) oznako',
    'rule_trigger_not_no_notes'                           => 'Transakcija ima morebitne opombe',
    'rule_trigger_not_no_external_url'                    => 'Transakcija ima zunanji URL',
    'rule_trigger_not_source_is_cash'                     => 'Izvorni račun ni gotovinski račun',
    'rule_trigger_not_destination_is_cash'                => 'Ciljni račun ni gotovinski račun',
    'rule_trigger_not_account_is_cash'                    => 'Noben račun ni denarni račun',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Stanje na ciljnem računu je več kot..',
    'rule_trigger_destination_balance_gte_choice'         => 'Stanje na ciljnem računu je večje ali enako..',
    'rule_trigger_destination_balance_is_choice'          => 'Stanje na ciljnem računu je točno..',
    'rule_trigger_destination_balance_lt_choice'          => 'Stanje na ciljnem računu je manjše od..',
    'rule_trigger_destination_balance_lte_choice'         => 'Stanje na ciljnem računu je manjše ali enako..',

    'rule_trigger_source_balance_gt_choice'  => 'Stanje na izvornem računu je več kot..',
    'rule_trigger_source_balance_gte_choice' => 'Stanje na izvornem računu je večje ali enako..',
    'rule_trigger_source_balance_is_choice'  => 'Stanje na izvornem računu je točno..',
    'rule_trigger_source_balance_lt_choice'  => 'Stanje na izvornem računu je manjše od..',
    'rule_trigger_source_balance_lte_choice' => 'Stanje na izvornem računu je manjše ali enako..',

    'rule_trigger_destination_balance_gt'  => 'Stanje na ciljnem računu je več kot :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Stanje na ciljnem računu je večje ali enako :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Stanje na ciljnem računu je točno :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Stanje na ciljnem računu je nižje od :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Stanje na ciljnem računu je manjše ali enako :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Stanje na izvornem računu je večje kot :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Stanje na izvornem računu je večje ali enako :trigger_value',
    'rule_trigger_source_balance_is'           => 'Stanje na izvornem računu je točno :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Stanje na izvornem računu je manjše od :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Stanje na izvornem računu je manjše ali enako :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Stanje na ciljnem računu je manjše ali enako :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Stanje na ciljnem računu je nižje od :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Stanje na ciljnem računu ni :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Stanje na ciljnem računu je večje ali enako :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Stanje na ciljnem računu je več kot :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Stanje na izvornem računu je manjše ali enako :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Stanje na izvornem računu je manjše od :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Stanje na izvornem računu ni :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Stanje na izvornem računu je večje ali enako :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Stanje na izvornem računu je več kot :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'IZBRIŠI transakcijo (!)',
    'rule_action_delete_transaction'             => 'IZBRIŠI transakcijo (!)',
    'rule_action_set_category'                   => 'Nastavi kategorijo na ":action_value"',
    'rule_action_clear_category'                 => 'Počisti kategorijo',
    'rule_action_set_budget'                     => 'Nastavi proračun na ":action_value"',
    'rule_action_clear_budget'                   => 'Počisti proračun',
    'rule_action_add_tag'                        => 'Dodaj oznako ":action_value"',
    'rule_action_remove_tag'                     => 'Odstrani oznako ":action_value"',
    'rule_action_remove_all_tags'                => 'Odstrani vse oznake',
    'rule_action_set_description'                => 'Nastavi opis na ":action_value"',
    'rule_action_append_description'             => 'Opisu dodaj ":action_value"',
    'rule_action_prepend_description'            => 'Pred opis dodaj ":action_value"',
    'rule_action_set_category_choice'            => 'Nastavi kategorijo na ...',
    'rule_action_clear_category_choice'          => 'Počisti kategorijo',
    'rule_action_set_budget_choice'              => 'Nastavi proračun na ...',
    'rule_action_clear_budget_choice'            => 'Počisti proračun',
    'rule_action_add_tag_choice'                 => 'Dodaj oznako ..',
    'rule_action_remove_tag_choice'              => 'Odstrani oznako ..',
    'rule_action_remove_all_tags_choice'         => 'Odstrani vse oznake',
    'rule_action_set_description_choice'         => 'Nastavi opis na ...',
    'rule_action_update_piggy_choice'            => 'Dodaj/odstrani znesek transakcije v hranilniku ...',
    'rule_action_update_piggy'                   => 'Dodajte / odstranite znesek transakcije v hranilnik ":action_value"',
    'rule_action_append_description_choice'      => 'Opisu dodaj ..',
    'rule_action_prepend_description_choice'     => 'Pred opis dodaj ...',
    'rule_action_set_source_account_choice'      => 'Nastavi izvorni račun na ...',
    'rule_action_set_source_account'             => 'Nastavi izvorni račun na :action_value',
    'rule_action_set_destination_account_choice' => 'Nastavi ciljni račun na ...',
    'rule_action_set_destination_account'        => 'Nastavi ciljni račun na :action_value',
    'rule_action_append_notes_choice'            => 'Opombi dodaj ..',
    'rule_action_append_notes'                   => 'Opombi dodaj ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Pred opombo dodaj ...',
    'rule_action_prepend_notes'                  => 'Pred opombo dodaj ":action_value"',
    'rule_action_clear_notes_choice'             => 'Odstrani opombe',
    'rule_action_clear_notes'                    => 'Odstrani opombe',
    'rule_action_set_notes_choice'               => 'Nastavi opombe na ...',
    'rule_action_link_to_bill_choice'            => 'Povezava do naročnine..',
    'rule_action_link_to_bill'                   => 'Poveži z naročnino ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Zamenjajte izvorni in ciljni račun (samo prenosi!)',
    'rule_action_switch_accounts'                => 'Zamenjava vira in cilja',
    'rule_action_set_notes'                      => 'Nastavi opombe na ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Pretvori transakcijo v priliv',
    'rule_action_convert_deposit'                => 'Pretvori transakcijo v priliv iz ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Pretvori transakcijo v odliv',
    'rule_action_convert_withdrawal'             => 'Pretvori transakcijo v odliv na ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Pretvori transakcijo v prenos',
    'rule_action_convert_transfer'               => 'Pretvori transakcijo v prenos z ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Opis dodajte opombam o transakciji',
    'rule_action_append_notes_to_descr_choice'   => 'Opombe o transakciji dodajte opisu',
    'rule_action_move_descr_to_notes_choice'     => 'Zamenjajte trenutne opombe o transakciji z opisom',
    'rule_action_move_notes_to_descr_choice'     => 'Zamenjajte trenutni opis z opombami o transakciji',
    'rule_action_append_descr_to_notes'          => 'Dodaj opis k opombami',
    'rule_action_append_notes_to_descr'          => 'Dodaj opombe k opisu',
    'rule_action_move_descr_to_notes'            => 'Opombe zamenjajte z opisom',
    'rule_action_move_notes_to_descr'            => 'Zamenjajte opis z opombami',
    'rule_action_set_amount_choice'              => 'Nastavi znesek na ..',
    'rule_action_set_amount'                     => 'Nastavi znesek na ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Nastavi ciljni račun na (gotovina)',
    'rule_action_set_source_to_cash_choice'      => 'Nastavi izvorni račun na (gotovina)',
    'rulegroup_for_bills_title'                  => 'Skupina pravil za naročnine',
    'rulegroup_for_bills_description'            => 'Posebna skupina pravil za vsa pravila, ki vključujejo naročnine.',
    'rule_for_bill_title'                        => 'Samodejno ustvarjeno pravilo za naročnino ":name"',
    'rule_for_bill_description'                  => 'To pravilo je samodejno ustvarjeno, da se poskuša ujemati z naročnino ":name".',
    'create_rule_for_bill'                       => 'Ustvari novo pravilo za naročnino ":name"',
    'create_rule_for_bill_txt'                   => 'Pravkar ste ustvarili novo naročnino z imenom ":name", čestitamo! Firefly III lahko samodejno poveže nove dvige s to naročnino. Na primer, kadar koli plačate najemnino, bo naročnina "najemnina" povezana s stroški. Tako vam lahko Firefly III natančno pokaže, katere naročnine so zapadle in katere ne. Če želite to narediti, je treba ustvariti novo pravilo. Firefly III je za vas izpolnil nekaj smiselnih privzetih vrednosti. Preverite, ali so pravilni. Če so te vrednosti pravilne, Firefly III samodejno poveže pravilen dvig s pravilno naročnino. Preverite sprožilce, da vidite, ali so pravilni, in jih dodajte, če so napačni.',
    'new_rule_for_bill_title'                    => 'Pravilo za naročnino ":name"',
    'new_rule_for_bill_description'              => 'To pravilo označuje transakcije za naročnino ":name".',

    'new_rule_for_journal_title'                => 'Pravilo, ki temelji na transakciji ":description"',
    'new_rule_for_journal_description'          => 'To pravilo temelji na transakciji ":description". Ujemalo se bo le s popolnoma enakimi transakcijami.',

    // tags
    'store_new_tag'                             => 'Shrani novo oznako',
    'update_tag'                                => 'Posodobi oznako',
    'no_location_set'                           => 'Lokacija ni nastavljena.',
    'meta_data'                                 => 'Meta podatki',
    'location'                                  => 'Lokacija',
    'location_first_split'                      => 'Mesto za to transakcijo je mogoče nastaviti ob prvi delitvi te transakcije.',
    'without_date'                              => 'Brez datuma',
    'result'                                    => 'Rezultati',
    'sums_apply_to_range'                       => 'Vsi zneski veljajo za izbran interval',
    'mapbox_api_key'                            => 'Če želite uporabiti zemljevid, pridobite API ključ iz <a href="https://www.mapbox.com/"> Mapbox-a</a>. Odprite datoteko <code>.env</code> in vanjo vnesite kodo za <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Z desnim klikom ali dolgim pritiskom nastavite lokacijo objekta.',
    'click_tap_location'                        => 'Kliknite ali tapnite zemljevid, da dodate lokacijo',
    'clear_location'                            => 'Počisti lokacijo',
    'delete_all_selected_tags'                  => 'Izbriši vse izbrane oznake',
    'select_tags_to_delete'                     => 'Ne pozabite izbrati oznak.',
    'deleted_x_tags'                            => 'Izbrisana :count oznaka.|Izbrisanih :count oznak.',
    'create_rule_from_transaction'              => 'Ustvarite pravilo, ki temelji na transakciji',
    'create_recurring_from_transaction'         => 'Ustvarite ponavljajočo se transakcijo na podlagi transakcije',

    // preferences
    'test_notifications_buttons'                => 'Če želite preizkusiti svoje nastavitve, uporabite spodnje gumbe. Upoštevajte, da gumbi nimajo nadzora neželene pošte.',
    'dark_mode_option_browser'                  => 'Dovolite, da določi brskalnik',
    'dark_mode_option_light'                    => 'Vedno svetla tema',
    'dark_mode_option_dark'                     => 'Vedno temna tema',
    'equal_to_language'                         => '(enako jeziku)',
    'dark_mode_preference'                      => 'Temen način',
    'dark_mode_preference_help'                 => 'Povejte Firefly III, kdaj naj uporabi temni način.',
    'pref_home_screen_accounts'                 => 'Računi na začetni strani',
    'pref_home_screen_accounts_help'            => 'Kateri računi naj bodo prikazani na začetni strani?',
    'pref_view_range'                           => 'Interval pogleda',
    'pref_view_range_help'                      => 'Nekateri diagrami so samodejno združeni v obdobja. Tudi proračuni bodo združeni v obdobjih. Kakšno obdobje želite?',
    'pref_1D'                                   => 'En dan',
    'pref_1W'                                   => 'En teden',
    'pref_1M'                                   => 'En mesec',
    'pref_3M'                                   => 'Trije meseci (četrtletje)',
    'pref_6M'                                   => 'Šest mesecev',
    'pref_1Y'                                   => 'Eno leto',
    'pref_last365'                              => 'Zadnje leto',
    'pref_last90'                               => 'Zadnjih 90 dni',
    'pref_last30'                               => 'Zadnjih 30 dni',
    'pref_last7'                                => 'Zadnjih 7 dni',
    'pref_YTD'                                  => 'Leto do datuma',
    'pref_QTD'                                  => 'Četrtletje do danes',
    'pref_MTD'                                  => 'Mesec do datuma',
    'pref_languages'                            => 'Jeziki',
    'pref_locale'                               => 'Področne nastavitve',
    'pref_languages_help'                       => 'Firefly III podpira več jezikov. Kateri vam je ljubši?',
    'pref_locale_help'                          => 'V Firefly III lahko nastavite ostale nastavitve lokalizacije, kot na primer prikaz valut, števil in datumov. Vaš sistem morda ne podpira vnosov na tem seznamu. Firefly III nima pravilnih nastavitev prikaza datuma za vse lokalizacije; kontaktirajte me za izboljšave.',
    'pref_locale_no_demo'                       => 'Ta funkcija ne bo delovala za demo uporabnika.',
    'pref_convert_to_primary'                   => 'Prikažite zneske v svoji glavni valuti',
    'pref_convert_to_primary_help'              => 'S to možnostjo bo Firefly III poskušal prikazati in pokazati vašo glavno valuto na čim več mestih, po potrebi pa pretvoriti zneske. To žrtvuje natančnost zaradi enostavne uporabe, ker pretvorba ni vedno natančna. Preverite, ali ima Firefly III potrebna menjalna razmerja na strani "menjalni tečaji".',
    'pref_convert_primary_help'                 => 'Prikaži glavne zneske',
    'pref_custom_fiscal_year'                   => 'Nastavitve fiskalnega leta',
    'pref_custom_fiscal_year_label'             => 'Omogočeno',
    'pref_custom_fiscal_year_help'              => 'V državah, ki uporabljajo finančno leto, ki je drugače od 1. januarja do 31. decembra, lahko to vklopite in določite prvi / zadnji dan fiskalnega leta',
    'pref_fiscal_year_start_label'              => 'Začetek fiskalnega leta',
    'pref_two_factor_auth'                      => 'Večfaktorska avtentikacija',
    'pref_two_factor_auth_help'                 => 'Ko omogočite večfaktorsko preverjanje pristnosti (znano tudi kot dvofaktorsko preverjanje pristnosti), svojemu računu dodate dodatno raven varnosti. Prijavite se z nečim, kar poznate (vaše geslo) in nečim, kar imate (koda za preverjanje). Kode za preverjanje lahko ustvari aplikacija v vašem telefonu, na primer Authy ali Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Omogoči večfaktorsko avtentikacijo',
    'pref_two_factor_auth_disabled'             => 'Koda večfaktorske avtentikacije je odstranjena in onemogočena',
    'pref_two_factor_auth_remove_it'            => 'Ne pozabite odstraniti računa iz aplikacije za preverjanje pristnosti!',
    'pref_two_factor_auth_code'                 => 'Preverite kodo',
    'pref_two_factor_auth_code_help'            => 'Skenirajte kodo QR z aplikacijo v telefonu, kot je Authy ali Google Authenticator in vnesite ustvarjeno kodo. Koda QR se spremeni vsakič, ko obiščete to stran. Prepričajte se, da uporabljate najnovejšo.',
    'pref_two_factor_auth_reset_code'           => 'Ponastavite kodo za preverjanje',
    'pref_two_factor_auth_disable_2fa'          => 'Onemogoči MFA',
    '2fa_use_secret_instead'                    => 'Če ne morete skenirati QR kode, raje uporabite skrivno kodo: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Te varnostne kode varno spravite za primer, če izgubite svojo napravo.',
    '2fa_already_enabled'                       => 'Večfaktorska avtentikacija je že omogočena.',
    'wrong_mfa_code'                            => 'Ta MFA koda ni veljavna.',
    'pref_save_settings'                        => 'Shrani nastavitve',
    'saved_preferences'                         => 'Nastavitve shranjene!',
    'preferences_general'                       => 'Splošno',
    'preferences_frontpage'                     => 'Začetni zaslon',
    'preferences_security'                      => 'Varnost',
    'preferences_layout'                        => 'Postavitev',
    'preferences_notifications'                 => 'Obvestila',
    'pref_home_show_deposits'                   => 'Pokaži prilive na začetni strani',
    'pref_home_show_deposits_info'              => 'Prva stran že prikazuje vaše račune stroškov. Ali naj prikazuje tudi račune prihodkov?',
    'pref_home_do_show_deposits'                => 'Da, pokaži jih',
    'successful_count'                          => 'od tega :count uspešno',
    'list_page_size_title'                      => 'Velikost strani',
    'list_page_size_help'                       => 'Vsak seznam stvari (računi, transakcije itd.) pokaže največ toliko na stran.',
    'list_page_size_label'                      => 'Velikost strani',
    'between_dates'                             => '(:start in :end)',
    'pref_optional_fields_transaction'          => 'Neobvezna polja za transakcije',
    'pref_optional_fields_transaction_help'     => 'Privzeto pri ustvarjanju nove transakcije niso omogočena vsa polja (zaradi nepreglednosti). V nadaljevanju lahko omogočite dodatna polja, če menite, da bi vam to lahko koristilo. Seveda je vsako polje, ki je onemogočeno, vendar že izpolnjeno, vidno ne glede na nastavitev.',
    'optional_tj_date_fields'                   => 'Datumska polja',
    'optional_tj_other_fields'                  => 'Druga polja',
    'optional_tj_attachment_fields'             => 'Polja prilog',
    'pref_optional_tj_interest_date'            => 'Datum obresti',
    'pref_optional_tj_book_date'                => 'Datum knjiženja',
    'pref_optional_tj_process_date'             => 'Datum obdelave',
    'pref_optional_tj_due_date'                 => 'Datum zapadlosti',
    'pref_optional_tj_payment_date'             => 'Datum plačila',
    'pref_optional_tj_invoice_date'             => 'Datum računa',
    'pref_optional_tj_internal_reference'       => 'Notranji sklic',
    'pref_optional_tj_notes'                    => 'Opombe',
    'pref_optional_tj_attachments'              => 'Priloge',
    'pref_optional_tj_external_url'             => 'Zunanji URL',
    'pref_optional_tj_location'                 => 'Lokacija',
    'pref_optional_tj_links'                    => 'Povezave transakcije',
    'optional_field_meta_dates'                 => 'Datumi',
    'optional_field_meta_business'              => 'Poslovno',
    'optional_field_attachments'                => 'Priloge',
    'optional_field_meta_data'                  => 'Izbirni meta podatki',
    'external_url'                              => 'Zunanji URL',
    'pref_notification_login_failure'           => 'Napaka pri prijavi',
    'pref_notification_bill_reminder'           => 'Opomnik o poteku naročnine',
    'pref_notification_new_access_token'        => 'Opozorilo, ko je ustvarjen nov žeton za dostop do API-ja',
    'pref_notification_transaction_creation'    => 'Opozorilo, ko je transakcija ustvarjena samodejno',
    'pref_notification_user_login'              => 'Opozorilo, ko se prijavite z nove lokacije',
    'pref_notification_rule_action_failures'    => 'Opozorilo, ko se dejanja pravila ne izvedejo (ne preko e-pošte)',
    'pref_notification_new_password'            => 'Vaše geslo je spremenjeno',
    'pref_notification_enabled_mfa'             => 'Večfaktorska avtentikacija je omogočena',
    'pref_notification_disabled_mfa'            => 'Večfaktorska avtentikacija je onemogočena',
    'pref_notification_few_left_mfa'            => 'Imate le še nekaj varnostnih kod',
    'pref_notification_no_left_mfa'             => 'Nimate več varnostnih kod',
    'pref_notification_many_failed_mfa'         => 'Večfaktorsko preverjanje pristnosti vedno znova ne uspe',
    'pref_notification_new_backup_codes'        => 'Ustvarjene so bile nove varnostne kode',
    'pref_notifications'                        => 'Obvestila',
    'pref_notifications_help'                   => 'Označite, ali so to obvestila, ki jih želite prejemati.  Nekatera obvestila lahko vsebujejo občutljive finančne podatke.',
    'pref_notifications_settings'               => 'Nastavitve obvestil',
    'pref_notifications_settings_help'          => 'S temi nastavitvami nastavljate kanale za obveščanje. Upoštevajte, da bodo obvestila poslana na VSE kanale. NAJPREJ shranite nastavitve.',
    'slack_url_label'                           => 'Slack "dohodni webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Menjalni tečaji',
    'header_exchange_rates'                     => 'Menjalni tečaji',
    'exchange_rates_intro'                      => 'Firefly III podpira prenos in uporabo menjalnih tečajev. Preberite več o tem v <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">dokumentaciji</a>.',
    'exchange_rates_from_to'                    => 'Med {from} in {to} (in obratno)',
    'header_exchange_rates_rates'               => 'Menjalni tečaji',
    'exchange_rates_intro_rates'                => 'Firefly III uporablja naslednje menjalne tečaje. Obratna vrednost se samodejno izračuna, če ni na voljo. Če na dan transakcije ni menjalnega tečaja, se bo Firefly III vrnil v preteklost, da bi ga našel. Če jih ni, se uporabi tečaj "1".',
    'header_exchange_rates_table'               => 'Tabela s tečaji',
    'help_rate_form'                            => 'Na ta dan, koliko {to} boste dobili za enega {from}?',
    'save_new_rate'                             => 'Shrani nov tečaj',
    'add_new_rate'                              => 'Dodaj nov menjalni tečaj',
    'not_enough_currencies'                     => 'Ni dovolj valut',
    'not_enough_currencies_enabled'             => 'Če imate omogočeno samo eno valuto, menjalnih tečajev ni treba dodajati.',

    // Financial administrations
    'administration_index'                      => 'Finančna administracija',
    'administrations_breadcrumb'                => 'Finančne administracije',
    'administrations_page_title'                => 'Finančne administracije',
    'administrations_index_menu'                => 'Finančne administracije',
    'administrations_page_sub_title'            => 'Pregled',
    'create_administration'                     => 'Ustvari novo administracijo',
    'administration_owner'                      => 'Lastnik administracije: {{email}}',
    'administration_you'                        => 'Vaša vloga: {{role}}',
    'other_users_in_admin'                      => 'Drugi uporabniki v tej administraciji',
    'administrations_create_breadcrumb'         => 'Ustvari novo finančno administracijo',
    'administrations_page_create_sub_title'     => 'Ustvari novo finančno administracijo',
    'basic_administration_information'          => 'Osnovne informacije o administraciji',
    'new_administration_created'                => 'Ustvarjena je bila nova finančna administracija "{{title}}"',
    'edit_administration_breadcrumb'            => 'Uredi finančno administracijo ":title"',
    'administrations_page_edit_sub_title'       => 'Uredi finančno administracijo ":title"',
    'administrations_page_edit_sub_title_js'    => 'Uredi finančno administracijo "{title}"',
    'temp_administrations_introduction'         => 'Firefly III bo kmalu dobil možnost upravljanja več finančnih administracij. Trenutno imate samo eno. Nastavite lahko naziv te administracije in njeno glavno valuto. To nadomešča prejšnjo nastavitev, kjer bi nastavili svojo "privzeto valuto". Ta nastavitev je zdaj vezana na finančno administracijo in se lahko razlikuje glede na administracijo.',
    'temp_administrations_introduction_edit'    => 'Trenutno lahko nastavite samo "domačo valuto" privzete finančne administracije. To nadomesti nastavitev "privzeta valuta". Ta nastavitev je zdaj vezana na finančno administracijo in se lahko razlikuje glede na administracijo.',
    'administration_currency_form_help'         => 'Če spremenite domačo valuto, lahko traja dolgo časa, da se stran naloži, ker bo transakcijo morda treba pretvoriti v vašo (novo) domačo valuto.',
    'flash_administration_updated'              => 'Administracija ":title" je bila posodobljena',
    'flash_administration_created'              => 'Administracija ":title" je bila ustvarjena',
    'flash_administration_deleted'              => 'Administracija ":title" je bila izbrisana',

    // roles
    'administration_role_owner'                 => 'Lastnik',
    'administration_role_ro'                    => 'Samo za branje',
    'administration_role_mng_trx'               => 'Upravljanje transakcij',
    'administration_role_mng_meta'              => 'Upravljanje klasifikacij in metapodatkov',
    'administration_role_mng_budgets'           => 'Upravljanje proračunov',
    'administration_role_mng_piggies'           => 'Upravljanje hranilnikov',
    'administration_role_mng_subscriptions'     => 'Upravljanje naročnin',
    'administration_role_mng_rules'             => 'Upravljanje pravil',
    'administration_role_mng_recurring'         => 'Upravljanje ponavljajoče se transakcije',
    'administration_role_mng_webhooks'          => 'Upravljanje webhookov',
    'administration_role_mng_currencies'        => 'Upravljanje valut',
    'administration_role_view_reports'          => 'Prikaz poročil',
    'administration_role_full'                  => 'Polni dostop',

    // mfa
    'enable_mfa'                                => 'Omogoči večfaktorsko avtentikacijo',
    'mfa_index_title'                           => 'Večfaktorska avtentikacija',
    'mfa_index_intro'                           => 'Firefly III podpira večfaktorsko avtentikacijo (MFA). Za svoj račun lahko omogočite MFA, da dodate dodatno raven varnosti. Aplikacije, kot so Authy, Google Authenticator in FreeOTP, lahko uporabite za ustvarjanje kod, ki jih potrebujete za prijavo. Firefly III ne podpira varnostnih ključev, vendar lahko uporabite varnostni ključ kot napravo za shranjevanje vašega MFA skritega ključa.',
    'mfa_index_enabled'                         => 'Za vaš račun je omogočena večfaktorska avtentikacija.',
    'mfa_index_disabled'                        => 'Za vaš račun je večfaktorska avtentikacija onemogočena.',
    'mfa_index_owner'                           => 'Lastnik te namestitve bo vedno lahko onemogočil večfaktorsko avtentikacijo za vaš račun.',
    'current_password_confirm_mfa'              => 'Vnesite trenutno geslo',
    'mfa_warning_code_changes'                  => 'Po vnosu gesla in kode MFA se lahko prikaže pogovorno okno MFA. V tem primeru počakajte, da vaša aplikacija ustvari novo kodo MFA in ne uporabite ponovno tiste, ki ste jo pravkar uporabili.',
    'mfa_already_disabled'                      => 'Večfaktorsko preverjanje ni omogočeno, zato ga ne morete onemogočiti.',
    'disable_mfa_page'                          => 'Onemogoči večfaktorsko avtentikacijo',
    'disable_mfa_intro'                         => 'Večfaktorsko avtentikacijo lahko onemogočite. Če želite to narediti, vnesite svoje geslo in kodo za večfaktorsko avtentikacijo. Če želite onemogočiti večfaktorsko preverjanje pristnosti, ker ste izgubili dostop do generatorja kode, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost -my-2fa-token-generator-or-2fa-has-stopped-working">si namesto tega oglejte dokumentacijo</a>.',
    'pref_disable_mfa'                          => 'Onemogoči večfaktorsko avtentikacijo',
    'mfa_not_enabled'                           => 'Večfaktorska avtentikacija ni omogočena.',
    'mfa_backup_codes_intro'                    => 'Firefly III lahko za vas ustvari varnostne kode. Te kode lahko uporabite za prijavo, ko ne morete uporabiti generatorja kod. Nov niz kod lahko ustvarite kadar koli. Če ustvarite nov niz, bo stari niz razveljavljen.',
    'mfa_backup_codes_quick'                    => 'Če zelo hitro prihajate s strani z nastavitvami večfaktorske avtentikacije, vaša aplikacija morda še ni ustvarila nove kode. Upoštevajte, da je kode MFA mogoče uporabiti samo enkrat. Prepričajte se, da uporabljate drugačno kodo od prejšnje.',
    'mfa_backup_codes_title'                    => 'Varnostne kode za večfaktorsko preverjanje pristnosti',
    'mfa_backup_codes_post_title'               => 'Varnostne kode za večfaktorsko preverjanje pristnosti',

    // profile:
    'manage_mfa_settings'                       => 'Upravljajte nastavitev večfaktorske avtentikacije',
    'purge_data_title'                          => 'Čiščenje podatkov iz Firefly III',
    'purge_data_expl'                           => '"Čiščenje" pomeni "brisanje tistega, kar je že izbrisano".  V normalnih okoliščinah Firefly III ničesar trajno ne izbriše.  To samo skriva.  Spodnji gumb izbriše vse te prej "izbrisane" zapise ZA VEDNO.',
    'delete_stuff_header'                       => 'Brisanje in čiščenje podatkov',
    'purge_all_data'                            => 'Počisti vse izbrisane zapise',
    'purge_data'                                => 'Izbris podatkov',
    'purged_all_records'                        => 'Vsi izbrisani zapisi so bili izbrisani.',
    'delete_data_title'                         => 'Izbriši podatke iz Firefly III',
    'permanent_delete_stuff'                    => 'Iz Firefly III lahko izbrišete stvari.  Uporaba spodnjih gumbov pomeni, da bodo vaši predmeti odstranjeni iz pogleda in skriti.  Za to ni gumba za razveljavitev, vendar lahko elementi ostanejo v bazi podatkov, kjer jih lahko po potrebi rešite.',
    'other_sessions_logged_out'                 => 'Vse vaše druge seje so bile odjavljene.',
    'delete_unused_accounts'                    => 'Če izbrišete neuporabljene račune, boste počistili svoje sezname za samodejno dokončanje.',
    'delete_all_unused_accounts'                => 'Izbriši neuporabljene račune',
    'deleted_all_unused_accounts'               => 'Vsi neuporabljeni računi so izbrisani',
    'delete_all_budgets'                        => 'Izbriši VSE proračune',
    'delete_all_categories'                     => 'Izbriši VSE kategorije',
    'delete_all_tags'                           => 'Izbriši VSE oznake',
    'delete_all_bills'                          => 'Izbriši VSE naročnine',
    'delete_all_piggy_banks'                    => 'Izbriši VSE hranilnike',
    'delete_all_rules'                          => 'Izbriši VSA pravila',
    'delete_all_recurring'                      => 'Izbriši VSE ponavljajoče se transakcije',
    'delete_all_object_groups'                  => 'Izbriši VSE skupine predmetov',
    'delete_all_accounts'                       => 'Izbriši VSE račune',
    'delete_all_asset_accounts'                 => 'Izbriši VSE račune sredstev',
    'delete_all_expense_accounts'               => 'Izbriši VSE račune stroškov',
    'delete_all_revenue_accounts'               => 'Izbriši VSE račune prihodkov',
    'delete_all_liabilities'                    => 'Izbriši VSE obveznosti',
    'delete_all_transactions'                   => 'Izbriši VSE transakcije',
    'delete_all_withdrawals'                    => 'Izbriši VSE odlive',
    'delete_all_deposits'                       => 'Izbriši VSE prilive',
    'delete_all_transfers'                      => 'Izbriši VSE prenose ',
    'also_delete_transactions'                  => 'Brisanje računa bo pobrisalo tudi VSE povezane odlive, prilive in prenose!',
    'deleted_all_budgets'                       => 'Vsi proračuni so bili izbrisani',
    'deleted_all_categories'                    => 'Vse kategorije so bile izbrisane',
    'deleted_all_tags'                          => 'Vse oznake so bile izbrisane',
    'deleted_all_bills'                         => 'Vse naročnine so bile izbrisane',
    'deleted_all_piggy_banks'                   => 'Vsi hranilniki so bili izbrisani',
    'deleted_all_rules'                         => 'Vsa pravila in skupine pravil so bila izbrisana',
    'deleted_all_object_groups'                 => 'Vse skupine so bile izbrisane',
    'deleted_all_accounts'                      => 'Vsi računi so bili izbrisani',
    'deleted_all_asset_accounts'                => 'Vsi računi sredstev so bili izbrisani',
    'deleted_all_expense_accounts'              => 'Vsi računi stroškov so bili izbrisani',
    'deleted_all_revenue_accounts'              => 'Vsi računi prihodkov so bili izbrisani',
    'deleted_all_liabilities'                   => 'Vse obveznosti so bile izbrisane',
    'deleted_all_transactions'                  => 'Vse transakcije so bile izbrisane',
    'deleted_all_withdrawals'                   => 'Vsi odlivi so bili izbrisani',
    'deleted_all_deposits'                      => 'Vsi prilivi so bili izbrisani',
    'deleted_all_transfers'                     => 'Vsi prenosi so bili izbrisani',
    'deleted_all_recurring'                     => 'Vse ponavljajoče se transakcije so bile izbrisane',
    'change_your_password'                      => 'Spremeni geslo',
    'delete_account'                            => 'Izbriši račun',
    'current_password'                          => 'Trenutno geslo',
    'new_password'                              => 'Novo geslo',
    'new_password_again'                        => 'Novo geslo (ponovno)',
    'delete_your_account'                       => 'Izbriši račun',
    'delete_your_account_help'                  => 'Če izbrišete račun, bodo izbrisani tudi vsi računi, transakcije, <em>karkoli</em> ste morda shranili v storitev Firefly III bo izgubljeno.',
    'delete_your_account_password'              => 'Za nadaljevanje vpišite geslo.',
    'password'                                  => 'Geslo',
    'are_you_sure'                              => 'Ali ste prepričan? Tega se ne da razveljaviti.',
    'are_you_sure_confirm'                      => 'Ste prepričani?',
    'delete_account_button'                     => 'IZBRIŠI račun',
    'invalid_current_password'                  => 'Obstoječe geslo je napačno!',
    'password_changed'                          => 'Geslo spremenjeno!',
    'should_change'                             => 'Namen je spremeniti vaše geslo.',
    'invalid_password'                          => 'Napačno geslo!',
    'what_is_pw_security'                       => 'Kaj je »preverjanje varnosti gesla«?',
    'secure_pw_title'                           => 'Kako izbrati varno geslo',
    'forgot_password_response'                  => 'Hvala vam. Če obstaja račun s tem e-poštnim naslovom, boste navodila našli v mapi »Prejeto«.',
    'secure_pw_history'                         => 'Niti teden še ni minil, ko ste prebrali v novicah o strani, ki izgublja gesla svojih uporabnikov. Hekerji in tatovi uporabljajo ta gesla, da bi poskušali ukrasti vaše zasebne podatke. Te informacije so dragocene.',
    'secure_pw_ff'                              => 'Ali uporabljate isto geslo po vsem internetu? Če eno mesto izgubi geslo, imajo hekerji dostop do vseh vaših podatkov. Firefly III se zanaša na vas, da izberete močno in edinstveno geslo za zaščito vaših finančnih zapisov.',
    'secure_pw_check_box'                       => 'Da bi vam pomagali, lahko Firefly III preveri, ali je bilo geslo, ki ga želite uporabiti, ukradeno v preteklosti. V tem primeru vam svetuje, da NE uporabljate tega gesla.',
    'secure_pw_working_title'                   => 'Kako deluje?',
    'secure_pw_working'                         => 'S potrditvijo tega polja bo Firefly III poslal prvih pet znakov zgoščenega zapisa SHA1 vašega gesla na <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/"> spletno stran Troy Hunta</a>, da vidite, ali je na seznamu. Tako ne boste mogli uporabljati nevarnih gesel, kot je priporočeno v najnovejši <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">posebni publikaciji NIST</a> na to temo.',
    'secure_pw_should'                          => 'Naj potrdim polje?',
    'secure_pw_long_password'                   => 'Da. Vedno preverite, ali je vaše geslo varno.',
    'command_line_token'                        => 'Žeton za ukazno vrstico',
    'explain_command_line_token'                => 'Ta žeton potrebujete za izvajanje možnosti ukazne vrstice, kot je izvoz podatkov. Brez tega ta občutljiv ukaz ne bo deloval. Ne delite svojega žetona ukazne vrstice. Nihče vas ne bo prosil za ta žeton, tudi jaz ne. Če se bojite, da ste to izgubili, ali ko ste paranoični, znova ustvarite ta žeton z gumbom.',
    'regenerate_command_line_token'             => 'Ponovno ustvari žeton za ukazno vrstico',
    'token_regenerated'                         => 'Nov žeton ukazne vrstice je bil ustvarjen',
    'change_your_email'                         => 'Spremeni elektronski naslov',
    'email_verification'                        => 'E-poštno sporočilo bo poslano na vaš stari IN novi e-poštni naslov. Iz varnostnih razlogov se ne boste mogli prijaviti, dokler ne potrdite svojega novega e-poštnega naslova. Če niste prepričani, ali vaša namestitev Firefly III omogoča pošiljanje e-pošte, prosimo, ne uporabljajte te funkcije. Če ste skrbnik, lahko to preizkusite v <a href="settings">nastavitvah</a>.',
    'email_changed_logout'                      => 'Dokler ne potrdite svojega elektronskega naslova, se ne morete prijaviti.',
    'login_with_new_email'                      => 'Zdaj se lahko prijavite z novim e-poštnim naslovom.',
    'login_with_old_email'                      => 'Znova se lahko prijavite s starim elektronskim naslovom.',
    'login_provider_local_only'                 => 'To dejanje ni na voljo pri preverjanju pristnosti preko ":login_provider".',
    'external_user_mgt_disabled'                => 'To dejanje ni na voljo, če Firefly III ni odgovoren za upravljanje uporabnikov ali preverjanje pristnosti.',
    'external_auth_disabled'                    => 'To dejanje ni na voljo, če Firefly III ni odgovoren za upravljanje uporabnikov ali preverjanje pristnosti.',
    'delete_local_info_only'                    => "Ker Firefly III ni odgovoren za upravljanje uporabnikov ali preverjanje pristnosti, bo ta funkcija izbrisala samo lokalne podatke Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Odjemalci OAuth',
    'profile_oauth_no_clients'                  => 'Ustvarili niste še nobenega odjemalca OAuth.',
    'profile_oauth_clients_external_auth'       => 'Če uporabljate zunanjega ponudnika preverjanja pristnosti, kot je Authelia, odjemalci OAuth ne bodo delovali. Uporabljate lahko samo osebne žetone za dostop.',
    'profile_oauth_clients_header'              => 'Odjemalci',
    'profile_oauth_client_id'                   => 'Client ID',
    'profile_oauth_client_name'                 => 'Ime',
    'profile_oauth_client_secret'               => 'Skrivna koda',
    'profile_oauth_create_new_client'           => 'Ustvari novega odjemalca',
    'profile_oauth_create_client'               => 'Ustvari odjemalca',
    'profile_oauth_edit_client'                 => 'Urejanje odjemalca',
    'profile_oauth_name_help'                   => 'Nekaj, kar bodo vaši uporabniki prepoznali in mu zaupali.',
    'profile_oauth_redirect_url'                => 'URL preusmeritve',
    'profile_oauth_redirect_url_help'           => 'URL povratnega klica avtorizacije vaše aplikacije.',
    'profile_authorized_apps'                   => 'Pooblaščene aplikacije',
    'profile_authorized_clients'                => 'Pooblaščeni odjemalci',
    'profile_scopes'                            => 'Področja',
    'profile_revoke'                            => 'Odvzemi dostop',
    'profile_oauth_client_secret_title'         => 'Skrivna koda odjemalca',
    'profile_oauth_client_secret_expl'          => 'Tukaj je skrivna koda vašega odjemalca. To je edini čas, da bo prikazana, zato je ne izgubite! Zdaj lahko uporabite to skrivno kodo za pošiljanje zahtev API.',
    'profile_personal_access_tokens'            => 'Osebni dostopni žetoni',
    'profile_personal_access_token'             => 'Osebni dostopni žeton',
    'profile_oauth_confidential'                => 'Zaupno',
    'profile_oauth_confidential_help'           => 'Od odjemalca zahtevajte avtentikacijo s skrivno kodo. Zaupni odjemalci imajo lahko poverilnice na varen način, ne da bi jih izpostavili nepooblaščenim osebam. Javne aplikacije, kot so izvorne namizne aplikacije ali aplikacije JavaScript SPA, ne morejo varno hraniti skrivnih kod.',
    'profile_personal_access_token_explanation' => 'Tukaj je vaš novi žeton za osebni dostop. To je edini čas, da bo prikazan, zato ga ne izgubite! Od zdaj naprej lahko uporabite ta žeton za pošiljanje zahtev API.',
    'profile_no_personal_access_token'          => 'Niste ustvarili nobenih osebnih žetonov za dostop.',
    'profile_create_new_token'                  => 'Ustvari nov žeton',
    'profile_create_token'                      => 'Ustvari žeton',
    'profile_create'                            => 'Ustvari',
    'profile_save_changes'                      => 'Shrani spremembe',
    'profile_whoops'                            => 'Ups!',
    'profile_something_wrong'                   => 'Nekaj je šlo narobe!',
    'profile_try_again'                         => 'Nekaj ​​je šlo narobe. Prosim poskusite znova.',
    'amounts'                                   => 'Zneski',
    'multi_account_warning_unknown'             => 'Odvisno od vrste transakcije, ki jo ustvarite, lahko izvorni in/ali ciljni račun poznejših razdelitev preglasi tisto, kar je definirano v prvi razdelitvi transakcije.',
    'multi_account_warning_withdrawal'          => 'Upoštevajte, da bo izvorni račun poznejših razdelitev preglasilo tisto, kar je definirano v prvi razdelitvi odliva.',
    'multi_account_warning_deposit'             => 'Upoštevajte, da bo ciljni račun poznejših delitev preglasilo tisto, kar je opredeljeno v prvi delitvi priliva.',
    'multi_account_warning_transfer'            => 'Upoštevajte, da bo izvorni + ciljni račun poznejših razdelitev preglasilo tisto, kar je definirano v prvi razdelitvi prenosa.',


    // export data:
    'export_data_title'                         => 'Izvozi podatke iz Firefly III',
    'export_data_menu'                          => 'Izvozi podatke',
    'export_data_bc'                            => 'Izvozi podatke iz Firefly III',
    'export_data_main_title'                    => 'Izvozi podatke iz Firefly III',
    'export_data_expl'                          => 'Ta povezava vam omogoča izvoz vseh transakcij + meta podatkov iz Firefly III. Prosimo, glejte pomoč (zgornja desna (?)-ikona) za več informacij o postopku.',
    'export_data_all_transactions'              => 'Izvozi vse transakcije',
    'export_data_advanced_expl'                 => 'Če potrebujete naprednejšo ali specifično vrsto izvoza, preberite pomoč o uporabi konzolnega ukaza <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Ena priloga|:count prilog',
    'attachments'                               => 'Priloge',
    'edit_attachment'                           => 'Uredi prilogo ":name"',
    'update_attachment'                         => 'Posodobi prilogo',
    'delete_attachment'                         => 'Izbriši prilogo ":name"',
    'attachment_deleted'                        => 'Priloga ":name" izbrisana',
    'liabilities_deleted'                       => 'Izbrisana odgovornost ":name"',
    'attachment_updated'                        => 'Priloga ":name" je posodobljena',
    'upload_max_file_size'                      => 'Največja velikost datoteke: :size',
    'list_all_attachments'                      => 'Seznam vseh prilog',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Ker je ta transakcija usklajena, ne boste mogli posodobiti računov niti zneskov.',
    'is_reconciled'                             => 'Je usklajena',
    'title_expenses'                            => 'Stroški',
    'title_withdrawal'                          => 'Stroški',
    'title_revenue'                             => 'Dohodki / prihodki',
    'title_deposit'                             => 'Dohodki / prihodki',
    'title_transfer'                            => 'Prenosi',
    'title_transfers'                           => 'Prenosi',
    'submission_options'                        => 'Možnosti oddaje',
    'apply_rules_checkbox'                      => 'Uporabite pravila',
    'fire_webhooks_checkbox'                    => 'Sprožite Webhooke',
    'select_source_account'                     => 'Izberite ali vnesite veljavno ime izvornega računa',
    'select_dest_account'                       => 'Izberite ali vnesite veljavno ime ciljnega računa',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Ta transakcija je že odliv',
    'convert_is_already_type_Deposit'           => 'Ta transakcija je že priliv',
    'convert_is_already_type_Transfer'          => 'Ta transakcija je že prenos',
    'convert_to_Withdrawal'                     => 'Pretvori ":description" v odliv',
    'convert_to_Deposit'                        => 'Pretvori ":description" v priliv',
    'convert_to_Transfer'                       => 'Pretvori ":description" v prenos',
    'convert_options_WithdrawalDeposit'         => 'Pretvori odliv v priliv',
    'convert_options_WithdrawalTransfer'        => 'Pretvori odliv v prenos',
    'convert_options_DepositTransfer'           => 'Pretvori priliv v prenos',
    'convert_options_DepositWithdrawal'         => 'Pretvori polog v odliv',
    'convert_options_TransferWithdrawal'        => 'Pretvori prenos v odliv',
    'convert_options_TransferDeposit'           => 'Pretvori prenos v priliv',
    'convert_Withdrawal_to_deposit'             => 'Pretvori ta odliv v priliv',
    'convert_Withdrawal_to_transfer'            => 'Pretvori ta dvig v prenos',
    'convert_Deposit_to_withdrawal'             => 'Pretvori ta priliv v odliv',
    'convert_Deposit_to_transfer'               => 'Pretvori ta priliv v prenos',
    'convert_Transfer_to_deposit'               => 'Pretvori ta prenos v priliv',
    'convert_Transfer_to_withdrawal'            => 'Pretvori ta prenos v odliv',
    'convert_please_set_revenue_source'         => 'Izberite račun prihodkov iz katerega boste prenesli denar.',
    'convert_please_set_asset_destination'      => 'Izberite račun sredstev na katerega boste prenesli denar.',
    'convert_please_set_expense_destination'    => 'Izberite na kateri račun stroškov bo šel denar.',
    'convert_please_set_asset_source'           => 'Izberite račun sredstev iz katerega boste prenesli denar.',
    'convert_expl_w_d'                          => 'Pri pretvorbi iz odliva v priliv bo denar položen na prikazani ciljni račun, namesto da bi bil dvignjen z njega.|Pri pretvorbi iz odliva v priliv bo denar položen na prikazane ciljne račune, namesto da se od njih umika.',
    'convert_expl_w_t'                          => 'Pri pretvorbi odliva v prenos bo denar prenesen stran od izvornega računa na drug račun sredstev ali obveznosti, namesto da bi bil porabljen na prvotnem računu stroškov.|Pri pretvarjanju odliva v prenos bo denar prenesen stran od izvornega računa na druge račune sredstev ali obveznosti, namesto da bi bili porabljeni na prvotnih računih odhodkov.',
    'convert_expl_d_w'                          => 'Pri pretvorbi priliva v odliv, bo denar dvignjen s prikazanega izvornega računa, namesto da bi bil položen nanj.|Pri pretvorbi priliva v odliv, bo denar dvignjen s prikazanih izvornih računov, namesto da bi bil položen nanje.',
    'convert_expl_d_t'                          => 'Ko pretvorite priliv v prenos, bo denar položen na navedeni ciljni račun s katerega koli računa sredstev ali obveznosti.|Ko pretvorite priliv v prenos, bo denar položen na navedene ciljne račune s katerega koli vaših računov sredstev ali obveznosti.',
    'convert_expl_t_w'                          => 'Ko pretvorite nakazilo v odliv, bo denar porabljen na ciljnem računu, ki ga nastavite tukaj, namesto da bi bil prenesen stran.|Ko pretvorite prenos v odliv, bo denar porabljen na ciljnih računih, ki ste jih nastavili tukaj, namesto da bi bil premeščen.',
    'convert_expl_t_d'                          => 'Ko pretvorite nakazilo v priliv, bo denar položen na ciljni račun, ki ga vidite tukaj, namesto da bi bil nakazan vanj.|Ko pretvorite nakazilo v priliv, bo denar položen na ciljne račune, ki jih vidite tukaj, namesto da bi bil prenesen vanje.',
    'convert_select_sources'                    => 'Če želite dokončati pretvorbo, nastavite nov izvorni račun spodaj.|Za dokončanje pretvorbe nastavite nove izvorne račune spodaj.',
    'convert_select_destinations'               => 'Za dokončanje konverzije spodaj izberite nov ciljni račun.|Za dokončanje konverzije spodaj izberite nove ciljne račune.',
    'converted_to_Withdrawal'                   => 'Transakcija je bila pretvorjena v odliv',
    'converted_to_Deposit'                      => 'Transakcija je bila pretvorjena v priliv',
    'converted_to_Transfer'                     => 'Transakcija je bila pretvorjena v prenos',
    'invalid_convert_selection'                 => 'Račun, ki ste ga izbrali, je v tej transakciji že uporabljen ali pa ne obstaja.',
    'source_or_dest_invalid'                    => 'Ne najdem pravilnih podrobnosti o transakciji. Pretvorba ni mogoča.',
    'convert_to_withdrawal'                     => 'Pretvori v odliv',
    'convert_to_deposit'                        => 'Pretvori v priliv',
    'convert_to_transfer'                       => 'Pretvori v prenos',

    // create new stuff:
    'create_new_withdrawal'                     => 'Ustvari nov odliv',
    'create_new_deposit'                        => 'Ustvari nov priliv',
    'create_new_transfer'                       => 'Ustvari nov prenos',
    'create_new_asset'                          => 'Ustvari nov račun sredstev',
    'create_new_liabilities'                    => 'Ustvari novo obveznost',
    'create_new_expense'                        => 'Ustvari nov račun stroškov',
    'create_new_revenue'                        => 'Ustvari nov račun prihodkov',
    'create_new_piggy_bank'                     => 'Ustvari nov hranilnik',
    'create_new_bill'                           => 'Ustvari novo naročnino',
    'create_new_subscription'                   => 'Ustvari novo naročnino',
    'create_new_rule'                           => 'Ustvari novo pravilo',

    // currencies:
    'create_currency'                           => 'Ustvari novo valuto',
    'store_currency'                            => 'Shrani novo valuto',
    'update_currency'                           => 'Osveži valuto',
    'new_default_currency'                      => '":name" je zdaj privzeta valuta.',
    'default_currency_failed'                   => '»:name« ni bilo mogoče narediti za privzeto valuto. Preverite dnevnike.',
    'cannot_delete_currency'                    => 'Ne morem izbrisati :name ker je v uporabi.',
    'cannot_delete_fallback_currency'           => ':name je sistemska nadomestna valuta in je ni mogoče izbrisati.',
    'cannot_disable_currency_journals'          => ':name ni mogoče onemogočiti, ker ga transakcije še vedno uporabljajo.',
    'cannot_disable_currency_last_left'         => ':name ni mogoče onemogočiti, ker je to zadnja omogočena valuta.',
    'cannot_disable_currency_account_meta'      => 'Ne morem onemogočiti :name, ker je uporabljen v računih sredstev.',
    'cannot_disable_currency_bills'             => 'Ni mogoče onemogočiti :name, ker se uporablja v naročninah.',
    'cannot_disable_currency_recurring'         => ':name ni mogoče onemogočiti, ker se uporablja v ponavljajočih se transakcijah.',
    'cannot_disable_currency_available_budgets' => ':name ni mogoče onemogočiti, ker se uporablja v ponavljajočih se transakcijah.',
    'cannot_disable_currency_budget_limits'     => 'Ni mogoče onemogočiti :name, ker se uporablja v proračunskih omejitvah.',
    'cannot_disable_currency_current_default'   => ':name ni mogoče onemogočiti, ker je to trenutna privzeta valuta.',
    'cannot_disable_currency_system_fallback'   => ':name ni mogoče onemogočiti, ker je sistemska privzeta valuta.',
    'disable_EUR_side_effects'                  => 'Evro je rezervna valuta sistema v sili. Če ga onemogočite, lahko pride do nenamernih stranskih učinkov in lahko razveljavi vašo garancijo.',
    'deleted_currency'                          => 'Valuta :name je izbrisana',
    'created_currency'                          => 'Valuta :name je ustvarjena',
    'could_not_store_currency'                  => 'Nove valute ni bilo mogoče shraniti.',
    'updated_currency'                          => 'Valuta :name je posodobljena',
    'ask_site_owner'                            => 'Prosim dogovorite se s :owner da doda, odstrani ali uredi valute.',
    'currencies_intro'                          => 'Firefly III podpira različne valute, ki jih lahko nastavite in omogočite tukaj.',
    'currencies_switch_default'                 => 'Domačo valuto za vašo trenutno administracijo lahko zamenjate na strani "Finančne administracije".',
    'make_default_currency'                     => 'Nastavi za privzeto',
    'default_currency'                          => 'privzeto',
    'primary_currency_button'                   => 'glavna',
    'currency_is_disabled'                      => 'Onemogočeno',
    'enable_currency'                           => 'Omogoči',
    'disable_currency'                          => 'Onemogoči',
    'currencies_default_disabled'               => 'Večina teh valut je privzeto onemogočena. Če jih želite uporabiti, jih morate najprej omogočiti.',
    'currency_is_now_enabled'                   => 'Valuta ":name" je bila omogočena',
    'could_not_enable_currency'                 => 'Ni bilo mogoče omogočiti valute ":name". Prosimo, preglejte dnevnike.',
    'currency_is_now_disabled'                  => 'Valuta ":name" je bila onemogočena',
    'could_not_disable_currency'                => 'Ni bilo mogoče onemogočiti valute ":name". Mogoče je še v uporabi?',

    // forms:
    'mandatoryFields'                           => 'Obvezna polja',
    'optionalFields'                            => 'Izbirna polja',
    'options'                                   => 'Možnosti',

    // budgets:
    'daily_budgets'                             => 'Dnevni proračuni',
    'weekly_budgets'                            => 'Tedenski proračuni',
    'monthly_budgets'                           => 'Mesečni proračuni',
    'quarterly_budgets'                         => 'Četrtletni proračuni',
    'half_year_budgets'                         => 'Polletni proračuni',
    'yearly_budgets'                            => 'Letni proračuni',
    'other_budgets'                             => 'Časovni proračuni po meri',
    'budget_limit_not_in_range'                 => 'Ta znesek velja od :start do :end:',
    'total_available_budget'                    => 'Skupni razpoložljivi proračun (med :start in :end)',
    'total_available_budget_in_currency'        => 'Skupni razpoložljivi proračun v :currency',
    'see_below'                                 => 'glej spodaj',
    'create_new_budget'                         => 'Ustvari nov proračun',
    'store_new_budget'                          => 'Shrani nov proračun',
    'stored_new_budget'                         => 'Nov proračun ":name" je shranjen',
    'available_between'                         => 'Na voljo med :start in :end',
    'transactionsWithoutBudget'                 => 'Stroški brez proračuna',
    'transactions_no_budget'                    => 'Stroški brez proračuna med :start in :end',
    'spent_between'                             => 'Že porabljeno med :start in :end',
    'spent_between_left'                        => 'Porabljeno :spent med :start in :end, preostane še :left.',
    'set_available_amount'                      => 'Nastavi razpoložljivo količino',
    'update_available_amount'                   => 'Posodobi razpoložljivo količino',
    'ab_basic_modal_explain'                    => 'S tem obrazcem navedite, koliko pričakujete, da boste lahko dodali v proračun (skupaj, v :currency) v navedenem obdobju.',
    'createBudget'                              => 'Nov proračun',
    'invalid_currency'                          => 'To je neveljavna valuta',
    'invalid_amount'                            => 'Prosim, vnesite znesek',
    'set_ab'                                    => 'Razpoložljivi proračunski znesek je nastavljen',
    'updated_ab'                                => 'Razpoložljivi proračunski znesek je posodobljen',
    'deleted_ab'                                => 'Razpoložljivi znesek proračuna je bil izbrisan',
    'deleted_bl'                                => 'Proračunski znesek je bil odstranjen',
    'alt_currency_ab_create'                    => 'Nastavite razpoložljivi proračun v drugi valuti',
    'bl_create_btn'                             => 'Nastavite proračun v drugi valuti',
    'inactiveBudgets'                           => 'Neaktivni proračuni',
    'without_budget_between'                    => 'Transakcije brez proračuna med :start in :end',
    'delete_budget'                             => 'Izbriši proračun ":name"',
    'deleted_budget'                            => 'Proračun ":name" izbrisan',
    'edit_budget'                               => 'Uredi proračun ":name"',
    'updated_budget'                            => 'Proračun ":name" je posodobljen',
    'update_amount'                             => 'Posodobi znesek',
    'update_budget'                             => 'Posodobi proračun',
    'update_budget_amount_range'                => 'Posodobi (pričakovani) razpoložljivi znesek med :start in :end',
    'set_budget_limit_title'                    => 'Nastavite proračunski znesek za proračun :budget med :start in :end',
    'set_budget_limit'                          => 'Določite proračunski znesek',
    'budget_period_navigator'                   => 'Obdobje',
    'info_on_available_amount'                  => 'Kaj imam na voljo?',
    'available_amount_indication'               => 'Uporabi te zneske za informacijo kakšen bi bil skupni proračun.',
    'suggested'                                 => 'Predlagano',
    'average_between'                           => 'Povprečno med :start in :end',
    'transferred_in'                            => 'Preneseno (v)',
    'transferred_away'                          => 'Preneseno (iz)',
    'auto_budget_none'                          => 'Brez samodejnega proračuna',
    'auto_budget_reset'                         => 'Nastavite fiksni znesek za vsako obdobje',
    'auto_budget_rollover'                      => 'Dodajte znesek za vsako obdobje',
    'auto_budget_adjusted'                      => 'Vsako obdobje dodajte znesek in popravite preveliko porabo',
    'auto_budget_period_daily'                  => 'Dnevno',
    'auto_budget_period_weekly'                 => 'Tedensko',
    'auto_budget_period_monthly'                => 'Mesečno',
    'auto_budget_period_quarterly'              => 'Četrtletno',
    'auto_budget_period_half_year'              => 'Polletno',
    'auto_budget_period_yearly'                 => 'Letno',
    'auto_budget_help'                          => 'Več o tej funkciji lahko preberete v pomoči. Kliknite ikono zgoraj desno (?).',
    'auto_budget_reset_icon'                    => 'Ta proračun bo nastavljen periodično',
    'auto_budget_rollover_icon'                 => 'Proračunski znesek se bo občasno povečeval',
    'auto_budget_adjusted_icon'                 => 'Proračunski znesek se bo občasno povečeval in popravljal za prekomerno porabo',
    'remove_budgeted_amount'                    => 'Odstrani proračunski znesek v :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'aktivne, pričakovane in še neplačane naročnine',
    'left_to_pay_lc'                            => 'ostane za plačilo',
    'less_than_expected'                        => 'manj kot pričakovano',
    'more_than_expected'                        => 'več kot pričakovano',
    'skip_help_text'                            => 'Uporabite polje za preskok za ustvarjanje dvomesečnih (preskok = 1) ali drugih intervalov po meri.',
    'subscription'                              => 'Naročnina',
    'not_expected_period'                       => 'Ni pričakovano v tem obdobju',
    'subscriptions_in_group'                    => 'Naročnine v skupini "{{title}}"',
    'subscr_expected_x_times'                   => 'Pričakujte, da boste v tem obdobju plačali {{amount}} {{times}}-krat',
    'not_or_not_yet'                            => 'Ne (še)',
    'visit_bill'                                => 'Obiščite naročnino ":name" v Firefly III',
    'visit_bills'                               => 'Obiščite naročnine na Firefly III',
    'match_between_amounts'                     => 'Naročnina se ujema s transakcijami med :low in :high.',
    'running_again_loss'                        => 'Prej povezane transakcije s to naročnino lahko izgubijo povezavo, če se (ne) ujemajo s pravili.',
    'bill_related_rules'                        => 'Pravila v zvezi s to naročnino',
    'repeats'                                   => 'Ponovitve',
    'bill_end_date_help'                        => 'Izbirno polje. Naročnina se bo predvidoma končala na ta datum.',
    'bill_extension_date_help'                  => 'Izbirno polje. Naročnino je treba podaljšati (ali preklicati) na ali pred tem datumom.',
    'bill_end_index_line'                       => 'Ta naročnina se konča dne :date',
    'bill_extension_index_line'                 => 'To naročnino je treba podaljšati ali preklicati dne :date',
    'connected_journals'                        => 'Povezane transakcije',
    'auto_match_on'                             => 'Samodejno povezano s Firefly III',
    'auto_match_off'                            => 'Ne povezano samodejno s Firefly III',
    'next_expected_match'                       => 'Naslednje pričakovano ujemanje',
    'delete_bill'                               => 'Izbriši naročnino ":name"',
    'deleted_bill'                              => 'Izbrisana naročnina ":name"',
    'edit_bill'                                 => 'Uredi naročnino ":name"',
    'more'                                      => 'Več',
    'rescan_old'                                => 'Znova zaženite pravila za vse transakcije',
    'update_bill'                               => 'Posodobi naročnino',
    'updated_bill'                              => 'Posodobljena naročnina ":name"',
    'store_new_bill'                            => 'Shrani novo naročnino',
    'stored_new_bill'                           => 'Shranjena nova naročnina ":name"',
    'cannot_scan_inactive_bill'                 => 'Neaktivnih naročnin ni mogoče pregledati.',
    'rescanned_bill'                            => 'Ponovno pregledal vse in povezal :count transakcije z naročninami.|Znova pregledal vse in povezal :count transakcij z naročninami.',
    'average_bill_amount_year'                  => 'Povprečni znesek naročnin (:year)',
    'average_bill_amount_overall'               => 'Povprečni znesek naročnin (skupno)',
    'bill_is_active'                            => 'Naročnina je aktivna',
    'bill_expected_between'                     => 'Pričakovano med :start in :end',
    'bill_will_automatch'                       => 'Naročnina bo samodejno povezana z ustreznimi transakcijami',
    'skips_over'                                => 'preskoči',
    'bill_store_error'                          => 'Med shranjevanjem vaše nove naročnine je prišlo do nepričakovane napake. Preverite dnevniške datoteke',
    'list_inactive_rule'                        => 'neaktivno pravilo',
    'bill_edit_rules'                           => 'Firefly III bo poskušal urediti tudi pravilo, povezano s to naročnino. Če ste to pravilo uredili sami, Firefly III ne bo spremenil ničesar.|Firefly III bo poskušal urediti tudi :count pravil, povezanih s to naročnino. Če pa ste ta pravila uredili sami, Firefly III ne bo spremenil ničesar.',
    'bill_expected_date'                        => 'Pričakovano :date',
    'bill_expected_date_js'                     => 'Pričakovano {date}',
    'expected_amount'                           => '(Pričakovan) znesek',
    'bill_paid_on'                              => 'Plačano na {date}',
    'bill_repeats_weekly'                       => 'Ponovi vsak teden',
    'bill_repeats_monthly'                      => 'Ponavlja se mesečno',
    'bill_repeats_quarterly'                    => 'Ponavlja se četrtletno',
    'bill_repeats_half-year'                    => 'Ponavlja se vsake pol leta',
    'bill_repeats_yearly'                       => 'Ponovi se vsako leto',
    'bill_repeats_weekly_other'                 => 'Ponavlja se vsak drugi teden',
    'bill_repeats_monthly_other'                => 'Ponavlja se vsak drugi mesec',
    'bill_repeats_quarterly_other'              => 'Ponovi vsako drugo četrtletje',
    'bill_repeats_half-year_other'              => 'Ponovi se vsako leto',
    'bill_repeats_yearly_other'                 => 'Ponavlja se vsako drugo leto',
    'bill_repeats_weekly_skip'                  => 'Ponovi se vsakih {skip} tednov',
    'bill_repeats_monthly_skip'                 => 'Ponovi se vsakih {skip} mesecev',
    'bill_repeats_quarterly_skip'               => 'Ponovi se vsakih {skip} četrtletij',
    'bill_repeats_half-year_skip'               => 'Ponovi se vsake {skip} pol leta',
    'bill_repeats_yearly_skip'                  => 'Ponovi se vsakih {skip} let',
    'subscriptions'                             => 'Naročnine',
    'go_to_subscriptions'                       => 'Pojdite na svoje naročnine',
    'forever'                                   => 'V nedolged',
    'extension_date_is'                         => 'Datum podaljšanja je {date}',

    // accounts:
    'account_locked_currency'                   => 'Valuta tega računa mora ostati :name, dokler so z njim povezani hranilniki.',
    'i_am_owed_amount'                          => 'Dolžan sem znesek',
    'i_owe_amount'                              => 'Dolgujem znesek',
    'inactive_account_link'                     => 'Imate :count neaktivnih (arhiviranih) računov, ki si jih lahko ogledate na tej ločeni strani.|Imate :count neaktivnih (arhiviranih) računov, ki si jih lahko ogledate na tej ločeni strani.',
    'all_accounts_inactive'                     => 'To so vaši neaktivni računi.',
    'active_account_link'                       => 'Ta povezava vodi nazaj do vaših aktivnih računov.',
    'account_missing_transaction'               => 'Računa #:id (":name") si ni mogoče neposredno ogledati, vendar Firefly-u manjkajo informacije o preusmeritvi.',
    'cc_monthly_payment_date_help'              => 'Izberite katero koli leto in kateri koli mesec, vseeno bo prezrt. Pomemben je le dan v mesecu.',
    'details_for_asset'                         => 'Podrobnosti za račun sredstev ":name"',
    'details_for_expense'                       => 'Podrobnosti računa stroškov ":name"',
    'details_for_revenue'                       => 'Podrobnosti za račun prihodkov ":name"',
    'details_for_cash'                          => 'Podrobnosti za gotovinski račun ":name"',
    'store_new_asset_account'                   => 'Shrani nov račun sredstev',
    'store_new_expense_account'                 => 'Shrani nov račun stroškov',
    'store_new_revenue_account'                 => 'Shrani nov račun prihodkov',
    'edit_asset_account'                        => 'Uredi račun sredstev ":name"',
    'edit_expense_account'                      => 'Uredi račun stroškov ":name"',
    'edit_revenue_account'                      => 'Uredi račun prihodkov ":name"',
    'delete_asset_account'                      => 'Izbriši račun sredstev ":name"',
    'delete_expense_account'                    => 'Izbriši račun stroškov ":name"',
    'delete_revenue_account'                    => 'Izbriši račun prihodkov ":name"',
    'delete_liabilities_account'                => 'Izbriši obveznost ":name"',
    'asset_deleted'                             => 'Račun sredstev ":name" je bil uspešno izbrisan',
    'account_deleted'                           => 'Uspešno izbrisan račun ":name"',
    'expense_deleted'                           => 'Račun stroškov ":name" je bil uspešno izbrisan',
    'revenue_deleted'                           => 'Račun prihodkov ":name" je bil uspešno izbrisan',
    'update_asset_account'                      => 'Posodobite račun sredstev',
    'update_undefined_account'                  => 'Posodobi račun',
    'update_liabilities_account'                => 'Uredi obveznost',
    'update_expense_account'                    => 'Posodobi račun stroškov',
    'update_revenue_account'                    => 'Posodobi račun prihodkov',
    'make_new_asset_account'                    => 'Ustvari nov račun sredstev',
    'make_new_expense_account'                  => 'Ustvari nov račun stroškov',
    'make_new_revenue_account'                  => 'Ustvari nov račun prihodkov',
    'make_new_liabilities_account'              => 'Ustvari novo obveznost',
    'asset_accounts'                            => 'Računi sredstev',
    'undefined_accounts'                        => 'Računi',
    'asset_accounts_inactive'                   => 'Računi sredstev (neaktivno)',
    'expense_account'                           => 'Račun stroškov',
    'expense_accounts'                          => 'Računi stroškov',
    'expense_accounts_inactive'                 => 'Računi sredstev (neaktivno)',
    'revenue_account'                           => 'Račun prihodkov',
    'revenue_accounts'                          => 'Računi prihodkov',
    'revenue_accounts_inactive'                 => 'Računi prihodkov (neaktivno)',
    'cash_accounts'                             => 'Gotovinski računi',
    'Cash account'                              => 'Gotovinski račun',
    'liabilities_accounts'                      => 'Obveznosti',
    'liabilities_accounts_inactive'             => 'Obveznosti (neaktivno)',
    'reconcile_account'                         => 'Uskladi račun: ":account"',
    'overview_of_reconcile_modal'               => 'Pregled usklajevanja',
    'delete_reconciliation'                     => 'Izbriši uskladitev',
    'update_reconciliation'                     => 'Posodobi uskladitev',
    'amount_cannot_be_zero'                     => 'Znesek ne sme biti nič',
    'end_of_reconcile_period'                   => 'Konec obdobja usklajevanja :period',
    'start_of_reconcile_period'                 => 'Začetek obdobja usklajevanja :period',
    'start_balance'                             => 'Začetno stanje',
    'end_balance'                               => 'Končno stanje',
    'update_balance_dates_instruction'          => 'Zgornje zneske in datume uskladite z bančnim izpiskom in pritisnite »Začni usklajevanje«',
    'select_transactions_instruction'           => 'Izberite transakcije, ki so prikazane v bančnem izpisku.',
    'select_range_and_balance'                  => 'Najprej preverite obseg datuma in stanje. Nato pritisnite »Začni usklajevanje«',
    'date_change_instruction'                   => 'Če zdaj spremenite časovno obdobje, se celotna zgodovina izgubi.',
    'update_selection'                          => 'Posodobi izbor',
    'store_reconcile'                           => 'Shrani uskladitev',
    'reconciliation_transaction'                => 'Uskladitvena transakcija',
    'Reconciliation'                            => 'Usklajevanje',
    'reconciliation'                            => 'Usklajevanje',
    'reconcile_options'                         => 'Možnosti usklajevanja',
    'reconcile_range'                           => 'Obseg usklajevanja',
    'start_reconcile'                           => 'Začni usklajevanje',
    'cash_account_type'                         => 'Gotovina',
    'cash'                                      => 'gotovina',
    'cant_find_redirect_account'                => 'Firefly III vas je poskušal preusmeriti, a ni mogel. Oprostite za to. Nazaj na kazalo.',
    'account_type'                              => 'Vrsta računa',
    'save_transactions_by_moving'               => 'Shranite to transakcijo tako, da jo premaknete na drug račun:|Shranite te transakcije tako, da jih premaknete na drug račun:',
    'save_transactions_by_moving_js'            => 'Brez transakcij|Shranite to transakcijo tako, da jo premaknete na drug račun. |Shranite te transakcije tako, da jih premaknete na drug račun.',
    'stored_new_account'                        => 'Nov račun ":name" je shranjen!',
    'stored_new_account_js'                     => 'Nov račun "<a href="accounts/show/{ID}">{name}</a>" je shranjen!',
    'updated_account'                           => 'Račun ":name" je posodobljen',
    'updated_account_js'                        => 'Posodobljen račun "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Možnosti kreditne kartice',
    'no_transactions_account'                   => 'Ni transakcij (za to obdobje) za račun sredstev ":name".',
    'no_transactions_period'                    => 'V tem obdobju ni transakcij.',
    'no_data_for_chart'                         => 'Za ustvarjanje tega diagrama (še) ni dovolj informacij.',
    'select_at_least_one_account'               => 'Prosim izberite vsaj en račun sredstev',
    'select_at_least_one_category'              => 'Prosim izberite vsaj eno kategorijo',
    'select_at_least_one_budget'                => 'Prosim izberite vsaj en proračun',
    'select_at_least_one_tag'                   => 'Prosim izberite vsaj eno oznako',
    'select_at_least_one_expense'               => 'Prosim izberite vsaj eno kombinacijo računov za stroške/prihodke. Če jih nimate (prazen seznam), to poročilo ni na voljo.',
    'account_default_currency'                  => 'To bo privzeta valuta tega računa.',
    'piggy_default_currency'                    => 'Hranilniki lahko varčujejo denar samo v eni valuti.',
    'piggy_account_currency_match'              => 'Sprejeti bodo le računi, ki uporabljajo predhodno izbrano valuto.',
    'reconcile_has_more'                        => 'V Firefly III glavni knjigi je več denarja, kot vaša banka trdi, da bi morali imeti. Obstaja več možnosti. Izberi, kaj želiš storiti. Nato pritisni "Potrdi usklajevanje".',
    'reconcile_has_less'                        => 'V Firefly III glavni knjigi je manj denarja, kot vaša banka trdi, da bi morali imeti. Obstaja več možnosti. Izberite, kaj želite storiti. Nato pritisnite "Potrdi usklajevanje".',
    'reconcile_is_equal'                        => 'Firefly III glavna knjiga in vaši bančni izpiski se ujemajo. Ničesar vam ni treba storiti. Pritisnite »Potrdi usklajevanje«, da potrdite vnos.',
    'create_pos_reconcile_transaction'          => 'Počisti izbrane transakcije in ustvarite popravek, ki bo dodal :amount na ta račun sredstev.',
    'create_neg_reconcile_transaction'          => 'Počisti izbrane transakcije in ustvari popravek, ki bo odvzel :amount s tega računa sredstev.',
    'reconcile_do_nothing'                      => 'Počisti izbrane transakcije, vendar jih ne popravi.',
    'reconcile_go_back'                         => 'Popravke lahko kadar koli uredite ali izbrišete.',
    'must_be_asset_account'                     => 'Uskladite lahko samo račune sredstev',
    'reconciliation_stored'                     => 'Usklajevanje je shranjeno',
    'reconciliation_error'                      => 'Zaradi napake so bile transakcije označene kot usklajene, vendar popravek ni bil shranjen: :error.',
    'reconciliation_transaction_title'          => 'Uskladitev (:from do :to)',
    'sum_of_reconciliation'                     => 'Vsota uskladitev',
    'reconcile_this_account'                    => 'Uskladi ta račun',
    'reconcile'                                 => 'Uskladi',
    'show'                                      => 'Prikaži',
    'confirm_reconciliation'                    => 'Potrdite uskladitev',
    'submitted_start_balance'                   => 'Predloženo začetno stanje',
    'selected_transactions'                     => 'Izbrane transakcije (:count)',
    'already_cleared_transactions'              => 'Že obračunane transakcije (:count)',
    'submitted_end_balance'                     => 'Predloženo končno stanje',
    'initial_balance_description'               => 'Začetno stanje za ":account"',
    'liability_credit_description'              => 'Dobropis obveznosti za ":account"',
    'interest_calc_'                            => 'neznano',
    'interest_calc_daily'                       => 'Na dan',
    'interest_calc_monthly'                     => 'Na mesec',
    'interest_calc_yearly'                      => 'Na leto',
    'interest_calc_weekly'                      => 'Tedensko',
    'interest_calc_half-year'                   => 'Na pol leta',
    'interest_calc_quarterly'                   => 'Na četrtletje',
    'initial_balance_account'                   => 'Začetno stanje na računu :account',
    'list_options'                              => 'Seznam možnosti',
    'account_column_opt_drag_and_drop'          => 'Povleci in spusti',
    'account_column_opt_active'                 => 'Aktivno',
    'account_column_opt_name'                   => 'Ime',
    'account_column_opt_type'                   => 'Vrsta',
    'account_column_opt_liability_type'         => 'Vrsta obveznosti',
    'account_column_opt_liability_direction'    => 'Smer obveznosti',
    'account_column_opt_liability_interest'     => 'Obresti obveznosti',
    'account_column_opt_number'                 => 'Številka računa',
    'account_column_opt_current_balance'        => 'Trenutno stanje',
    'account_column_opt_amount_due'             => 'Dolgovani znesek',
    'account_column_opt_last_activity'          => 'Zadnja aktivnost',
    'account_column_opt_balance_difference'     => 'Bilančna razlika',
    'account_column_opt_menu'                   => 'Meni',

    // categories:
    'new_category'                              => 'Nova kategorija',
    'create_new_category'                       => 'Ustvari novo kategorijo',
    'without_category'                          => 'Brez kategorije',
    'update_category'                           => 'Posodobi kategorije',
    'updated_category'                          => 'Kategorija ":name" je posodobljena',
    'categories'                                => 'Kategorije',
    'edit_category'                             => 'Uredi kategorijo ":name"',
    'no_category'                               => '(brez kategorije)',
    'unknown_category_plain'                    => 'Brez kategorije',
    'category'                                  => 'Kategorija',
    'delete_category'                           => 'Izbriši kategorijo ":name"',
    'deleted_category'                          => 'Kategorija ":name" je izbrisana',
    'store_category'                            => 'Shrani novo kategorijo',
    'stored_category'                           => 'Nova kategorija ":name" je shranjena',
    'without_category_between'                  => 'Brez kategorije med :start in :end',


    // transactions:
    'wait_loading_transaction'                  => 'Počakajte, da se obrazec naloži',
    'wait_loading_data'                         => 'Počakajte, da se vaši podatki naložijo...',
    'wait_attachments'                          => 'Počakajte, da se priloge naložijo.',
    'errors_upload'                             => 'Nalaganje ni uspelo. Preverite, ali je v konzoli brskalnika prišlo do napake.',
    'amount_foreign_if'                         => 'Znesek v tuji valuti, če obstaja',
    'amount_destination_account'                => 'Znesek v valuti ciljnega računa',
    'edit_transaction_title'                    => 'Uredi transakcijo ":description"',
    'unreconcile'                               => 'Razveljavi uskladitev',
    'update_withdrawal'                         => 'Posodobi odliv',
    'update_deposit'                            => 'Posodobi priliv',
    'update_transaction'                        => 'Posodobi transakcijo',
    'update_transfer'                           => 'Posodobi prenos',
    'updated_withdrawal'                        => 'Odliv ":description" je posodobljen',
    'updated_deposit'                           => 'Priliv ":description" je posodobljen',
    'updated_transfer'                          => 'Prenos ":description" je posodobljen',
    'no_changes_withdrawal'                     => 'Odliv ":description" ni bil spremenjen.',
    'no_changes_deposit'                        => 'Priliv ":description" ni bil spremenjen.',
    'no_changes_transfer'                       => 'Prenos ":description" ni bil spremenjen.',
    'delete_withdrawal'                         => 'Odliv ":description" je izbrisan',
    'delete_deposit'                            => 'Izbriši priliv ":description"',
    'delete_transfer'                           => 'Izbriši prenos ":description"',
    'deleted_withdrawal'                        => 'Odliv ":description" je uspešno izbrisan',
    'deleted_deposit'                           => 'Priliv ":description" je uspešno izbrisan',
    'deleted_transfer'                          => 'Prenos ":description" je uspešno izbrisan',
    'deleted_reconciliation'                    => 'Transakcija usklajevanja ":description" je bila uspešno izbrisana',
    'stored_journal'                            => 'Nova transakcija ":description" je uspešno ustvarjena',
    'stored_journal_js'                         => 'Nova transakcija "{{description}}" je uspešno ustvarjena',
    'stored_journal_no_descr'                   => 'Vaša nova transakcija je uspešno ustvarjena',
    'updated_journal_no_descr'                  => 'Vaša transakcija je bila uspešno posodobljena',
    'select_transactions'                       => 'Izberi transakcije',
    'rule_group_select_transactions'            => 'Uporabi ":title" za transakcije',
    'rule_select_transactions'                  => 'Uporabi ":title" za transakcije',
    'stop_selection'                            => 'Končaj z izbiro transakcij',
    'reconcile_selected'                        => 'Uskladi',
    'mass_delete_journals'                      => 'Izbriši število transakcij',
    'mass_edit_journals'                        => 'Uredi več transakcij',
    'mass_bulk_journals'                        => 'Množično urejanje transakcij',
    'mass_bulk_journals_explain'                => 'Ta obrazec vam omogoča spreminjanje lastnosti spodaj navedenih transakcij v eni obsežni posodobitvi. Vse transakcije v tabeli bodo posodobljene, ko spremenite parametre, ki jih vidite tukaj.',
    'part_of_split'                             => 'Ta transakcija je del razdeljene transakcije. Če niste izbrali vseh razdelitev, boste morda na koncu spremenili le polovico transakcije.',
    'bulk_set_new_values'                       => 'S spodnjimi vnosi nastaviš nove vrednosti. Če jih pustiš prazne, bodo za vse prazne. Upoštevajte tudi, da bo proračun dodeljen samo odlivom.',
    'no_bulk_category'                          => 'Ne posodobi kategorije',
    'no_bulk_budget'                            => 'Ne posodobi proračuna',
    'no_bulk_tags'                              => 'Ne posodobi oznak(e)',
    'replace_with_these_tags'                   => 'Zamenjaj s temi oznakami',
    'append_these_tags'                         => 'Dodaj te oznake',
    'mass_edit'                                 => 'Uredi izbrano posamično',
    'bulk_edit'                                 => 'Uredi izbrano v večjem obsegu',
    'mass_delete'                               => 'Izbriši izbrano',
    'cannot_edit_other_fields'                  => 'Drugih polj ne morete množično urejati, ker ni prostora za prikaz. Če želite urediti ta polja, sledite povezavi in jih uredite posebej.',
    'cannot_change_amount_reconciled'           => 'Zneska ali računa usklajenih transakcij ne morete spremeniti.',
    'no_budget'                                 => '(brez proračuna)',
    'no_bill'                                   => '(brez naročnin)',
    'account_per_budget'                        => 'Porabljeno po proračunu',
    'account_per_category'                      => 'Račun po kategoriji',
    'create_new_object'                         => 'Ustvari',
    'empty'                                     => '(prazno)',
    'all_other_budgets'                         => '(vsi ostali proračuni)',
    'all_other_accounts'                        => '(vsi ostali računi)',
    'expense_per_source_account'                => 'Stroški po računih',
    'expense_per_destination_account'           => 'Stroški na ciljnem računu',
    'income_per_destination_account'            => 'Dohodek na ciljni račun',
    'spent_in_specific_category'                => 'Porabljeno v kategoriji ":category"',
    'earned_in_specific_category'               => 'Prisluženo v kategoriji ":category"',
    'spent_in_specific_tag'                     => 'Porabljeno v oznaki ":tag"',
    'earned_in_specific_tag'                    => 'Zasluženo v oznaki ":tag"',
    'income_per_source_account'                 => 'Dohodek na izvorni račun',
    'average_spending_per_destination'          => 'Povprečni stroški na ciljni račun',
    'average_spending_per_source'               => 'Povprečni stroški na izvorni račun',
    'average_earning_per_source'                => 'Povprečni zaslužek na izvorni račun',
    'average_earning_per_destination'           => 'Povprečni zaslužek na ciljni račun',
    'account_per_tag'                           => 'Račun po oznaki',
    'tag_report_expenses_listed_once'           => 'Stroški in prihodki niso nikoli navedeni dvakrat. Če ima transakcija več oznak, se lahko prikaže le pod eno od njenih oznak. Morda se zdi, da na tem seznamu manjkajo podatki, vendar bodo zneski pravilni.',
    'double_report_expenses_charted_once'       => 'Odhodki in prihodki niso nikoli prikazani dvakrat. Če ima transakcija več oznak, se lahko prikaže le pod eno od njenih oznak. Morda se zdi, da v tem grafikonu manjkajo podatki, vendar bodo zneski pravilni.',
    'tag_report_chart_single_tag'               => 'Ta grafikon velja za posamezno oznako. Če ima transakcija več oznak, se lahko to, kar vidite tukaj, odraža tudi v grafikonih drugih oznak.',
    'tag'                                       => 'Oznaka',
    'no_budget_squared'                         => '(brez proračuna)',
    'perm-delete-many'                          => 'Brisanje več elementov naenkrat je lahko zelo moteče. Bodite previdni. S te strani lahko izbrišete del razdeljene transakcije, zato bodite previdni.',
    'mass_deleted_transactions_success'         => 'Izbrisano :count transakcij.|Izbrisano :count transakcij.',
    'mass_edited_transactions_success'          => 'Posodobljeno :count transakcij.|Posodobljeno :count transakcij.',
    'opt_group_'                                => '(brez tipa računa)',
    'opt_group_no_account_type'                 => '(brez tipa računa)',
    'opt_group_defaultAsset'                    => 'Privzeti računi sredstev',
    'opt_group_savingAsset'                     => 'Varčevalni račun',
    'opt_group_sharedAsset'                     => 'Skupni računi sredstev',
    'opt_group_ccAsset'                         => 'Kreditne kartice',
    'opt_group_cashWalletAsset'                 => 'Gotovina',
    'opt_group_expense_account'                 => 'Računi odhodkov',
    'opt_group_revenue_account'                 => 'Računi prihodkov',
    'opt_group_l_Loan'                          => 'Obveznost: Posojilo',
    'opt_group_cash_account'                    => 'Gotovinski račun',
    'opt_group_l_Debt'                          => 'Obveznost: Dolg',
    'opt_group_l_Mortgage'                      => 'Obveznost: Hipoteka',
    'opt_group_l_Credit card'                   => 'Obveznost: Kreditna kartica',
    'notes'                                     => 'Opombe',
    'view_notes'                                => 'Pokaži opombe',
    'set_budget_limit_notes'                    => 'Oglej si opombe za ta znesek proračuna',
    'edit_bl_notes'                             => 'Uredi opombe',
    'update_bl_notes'                           => 'Posodobi opombe',
    'unknown_journal_error'                     => 'Transakcije ni bilo mogoče shraniti. Preverite datoteke dnevnika.',
    'attachment_not_found'                      => 'Te priloge ni bilo mogoče najti.',
    'journal_link_bill'                         => 'Ta transakcija je povezana z naročnino <a href=":route">:name</a>. Če želite odstraniti povezavo, počistite potrditveno polje. Uporabite pravila, da ga povežete z drugo naročnino.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transakcija št. #{ID} ("{title}")</a> je bila shranjena.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transakcija št. #{ID}</a> je bila shranjena.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transakcija št. #{ID}</a> ("{title}") je bila posodobljena.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transakcija št. #{ID}</a> ("{title}") ni prejela nobenih sprememb.',
    'first_split_decides'                       => 'Prva razdelitev določa vrednost tega polja',
    'first_split_overrules_source'              => 'Prva razdelitev lahko razveljavi izvorni račun',
    'first_split_overrules_destination'         => 'Prva razdelitev lahko razveljavi ciljni račun',
    'spent_x_of_y'                              => 'Porabljen {amount} od {total}',

    // new user:
    'welcome'                                   => 'Dobrodošli v Firefly III!',
    'submit'                                    => 'Potrdite',
    'submission'                                => 'Predložitev',
    'submit_yes_really'                         => 'Predložite (vem kaj počnem)',
    'getting_started'                           => 'Kako začeti',
    'to_get_started'                            => 'Lepo je videti, da ste uspešno namestili Firefly III. Če želite začeti z uporabo tega orodja, vnesite ime banke in stanje glavnega tekočega računa. Ne skrbite, če imate več računov. Lahko jih dodate pozneje. Firefly III pač potrebuje nekaj za začetek.',
    'savings_balance_text'                      => 'Firefly III ti bo samodejno ustvaril varčevalni račun. Privzeto na varčevalnem računu ne bo nobenega denarja, če pa Firefly III zaupate stanje, bo le-to nastavljeno.',
    'finish_up_new_user'                        => 'To je to! Nadaljujete s pritiskom na <strong>Pošlji</strong>. Preusmerjeni boste na kazalo Firefly III.',
    'stored_new_accounts_new_user'              => 'Juhu! Vaši novi računi so shranjeni.',
    'set_preferred_language'                    => 'Če želite uporabiti Firefly III v drugem jeziku, prosimo, označite tukaj.',
    'language'                                  => 'Jezik',
    'new_savings_account'                       => ':bank_name varčevalni račun',
    'cash_wallet'                               => 'Gotovina',
    'currency_not_present'                      => 'Če valuta, ki jo običajno uporabljate, ni navedena, ne skrbite. Ustvarite lahko lastne valute pod Možnosti> Valute.',

    // home page:
    'transaction_table_description'             => 'Tabela z vašimi transakcijami',
    'opposing_account'                          => 'Nasprotni račun',
    'yourAccounts'                              => 'Vaši računi',
    'your_accounts'                             => 'Pregled računov',
    'category_overview'                         => 'Pregled kategorij',
    'expense_overview'                          => 'Pregled računov stroškov',
    'revenue_overview'                          => 'Pregled računov prihodkov',
    'budgetsAndSpending'                        => 'Proračuni in poraba',
    'budgets_and_spending'                      => 'Proračuni in poraba',
    'go_to_budget'                              => 'Pojdi na proračun "{budget}"',
    'go_to_deposits'                            => 'Pojdi na prilive',
    'go_to_expenses'                            => 'Pojdi na izdatke',
    'savings'                                   => 'Prihranki',
    'newWithdrawal'                             => 'Nov strošek',
    'newDeposit'                                => 'Nov priliv',
    'newTransfer'                               => 'Nov prenos',
    'bills_to_pay'                              => 'Naročnine za plačilo',
    'per_day'                                   => 'Na dan',
    'left_to_spend_per_day'                     => 'Ostane za porabit na dan',
    'bills_paid'                                => 'Plačane naročnine',
    'custom_period'                             => 'Obdobje po meri',
    'reset_to_current'                          => 'Ponastavi na trenutno obdobje',
    'select_period'                             => 'Izberite obdobje',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Možnosti',
    'logout'                                    => 'Odjava',
    'logout_other_sessions'                     => 'Odjavi vse druge seje',
    'toggleNavigation'                          => 'Preklopi navigacijo',
    'toggle_dropdown'                           => 'Preklopi spustni seznam',
    'searchPlaceholder'                         => 'Iskanje...',
    'version'                                   => 'Različica',
    'dashboard'                                 => 'Nadzorna plošča',
    'income_and_expense'                        => 'Prihodki in odhodki',
    'all_money'                                 => 'Ves vaš denar',
    'unknown_source_plain'                      => 'Neznan izvorni račun',
    'unknown_dest_plain'                        => 'Neznan ciljni račun',
    'unknown_any_plain'                         => 'Neznan račun',
    'unknown_budget_plain'                      => 'Ni proračuna',
    'available_budget'                          => 'Razpoložljiv proračun ({currency})',
    'currencies'                                => 'Valute',
    'activity'                                  => 'Dejavnost',
    'usage'                                     => 'Uporaba',
    'accounts'                                  => 'Računi',
    'Asset account'                             => 'Račun sredstev',
    'Default account'                           => 'Račun sredstev',
    'Expense account'                           => 'Račun stroškov',
    'Revenue account'                           => 'Račun prihodkov',
    'Initial balance account'                   => 'Začetno stanje',
    'account_type_Asset account'                => 'Račun sredstev',
    'account_type_Expense account'              => 'Račun stroškov',
    'account_type_Revenue account'              => 'Račun prihodkov',
    'account_type_Debt'                         => 'Dolg',
    'account_type_Loan'                         => 'Posojilo',
    'account_type_Mortgage'                     => 'Hipoteka',
    'account_type_debt'                         => 'Dolg',
    'account_type_loan'                         => 'Posojilo',
    'account_type_mortgage'                     => 'Hipoteka',
    'account_type_Credit card'                  => 'Kreditna kartica',
    'credit_card_type_monthlyFull'              => 'Polno plačilo vsak mesec',
    'liability_direction_credit'                => 'Dolžan sem ta dolg',
    'liability_direction_debit'                 => 'Ta dolg dolgujem nekomu drugemu',
    'liability_direction_credit_short'          => 'Ta dolg je bil dolgovan',
    'liability_direction_debit_short'           => 'Dolgujem',
    'liability_direction__short'                => 'Neznano',
    'liability_direction_null_short'            => 'Neznano',
    'Liability credit'                          => 'Kredit za obveznost',
    'budgets'                                   => 'Proračuni',
    'tags'                                      => 'Oznake',
    'reports'                                   => 'Poročila',
    'transactions'                              => 'Transakcije',
    'expenses'                                  => 'Stroški',
    'income'                                    => 'Dohodki / prihodki',
    'transfers'                                 => 'Prenosi',
    'moneyManagement'                           => 'Upravljanje denarja',
    'money_management'                          => 'Upravljanje denarja',
    'tools'                                     => 'Orodja',
    'piggyBanks'                                => 'Hranilniki',
    'piggy_banks'                               => 'Hranilniki',
    'amount_x_of_y'                             => '{current} od {total}',
    'bills'                                     => 'Naročnine',
    'withdrawal'                                => 'Odliv',
    'opening_balance'                           => 'Začetno stanje',
    'deposit'                                   => 'Priliv',
    'account'                                   => 'Račun',
    'transfer'                                  => 'Prenos',
    'Withdrawal'                                => 'Odliv',
    'Deposit'                                   => 'Priliv',
    'Transfer'                                  => 'Prenos',
    'bill'                                      => 'Naročnina',
    'yes'                                       => 'Da',
    'no'                                        => 'Ne',
    'amount'                                    => 'Znesek',
    'overview'                                  => 'Pregled',
    'saveOnAccount'                             => 'Shrani na račun',
    'saveOnAccounts'                            => 'Shrani na račun/račune',
    'unknown'                                   => 'Neznano',
    'monthly'                                   => 'Mesečno',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Napake',
    'debt_start_date'                           => 'Začetni datum dolga',
    'debt_start_amount'                         => 'Začetni znesek dolga',
    'debt_start_amount_help'                    => 'Vedno je najbolje, da to vrednost nastavite na negativno vrednost. Za več informacij preberite strani s pomočjo (zgornja desna (?)-ikona).',
    'interest_period_help'                      => 'To polje je zgolj kozmetično in ga ne bomo izračunali namesto vas. Kot se je izkazalo, so banke zelo zahrbtne, zato Firefly III nikoli ne zadane pravilno.',
    'store_new_liabilities_account'             => 'Shrani novo obveznost',
    'edit_liabilities_account'                  => 'Uredi obveznost ":name"',
    'financial_control'                         => 'Nadzor financ',
    'accounting'                                => 'Računovodstvo',
    'automation'                                => 'Avtomatizacija',
    'others'                                    => 'Drugo',
    'classification'                            => 'Klasifikacija',
    'store_transaction'                         => 'Shrani transakcijo',


    // reports:
    'quick_link_needs_accounts'                 => 'Za ustvarjanje poročil morate v Firefly III dodati vsaj en račun sredstev.',
    'report_default'                            => 'Privzeto finančno poročilo med :start in :end',
    'report_audit'                              => 'Pregled zgodovine transakcij med :start in :end',
    'report_category'                           => 'Poročilo po kategorijah med :start in :end',
    'report_double'                             => 'Poročilo o odhodkih/prihodkih med :start in :end',
    'report_budget'                             => 'Poročilo proračunov med :start in :end',
    'report_tag'                                => 'Poročilo oznakah med :start in :end',
    'quick_link_reports'                        => 'Hitre povezave',
    'quick_link_examples'                       => 'To so le nekateri primeri povezav za začetek. Oglejte si strani za pomoč pod gumbom (?) za informacije o vseh poročilih in "čarobnih besedah", ki jih lahko uporabite.',
    'quick_link_default_report'                 => 'Privzeto finančno poročilo',
    'quick_link_audit_report'                   => 'Pregled zgodovine transakcij',
    'report_this_month_quick'                   => 'Tekoči mesec, vsi računi',
    'report_last_month_quick'                   => 'Zadnji mesec, vsi računi',
    'report_this_year_quick'                    => 'Tekoče leto, vsi računi',
    'report_this_fiscal_year_quick'             => 'Tekoče fiskalno leto, vsi računi',
    'report_all_time_quick'                     => 'Kadarkoli, vsi računi',
    'reports_can_bookmark'                      => 'Poročila lahko shranite med zaznamke.',
    'incomeVsExpenses'                          => 'Prihodki napram odhodkom',
    'accountBalances'                           => 'Stanje na računih',
    'balanceStart'                              => 'Stanje na začetku obdobja',
    'balanceEnd'                                => 'Stanje na koncu obdobja',
    'splitByAccount'                            => 'Razdeljeno po računih',
    'coveredWithTags'                           => 'Z oznakami',
    'leftInBudget'                              => 'Ostanek v proračunu',
    'left_in_debt'                              => 'Dolgovani znesek',
    'sumOfSums'                                 => 'Vsota vsot',
    'noCategory'                                => '(brez kategorije)',
    'notCharged'                                => 'Ne (še) zaračunano',
    'inactive'                                  => 'Neaktivno',
    'active'                                    => 'Aktiven',
    'difference'                                => 'Razlika',
    'money_flowing_in'                          => 'Na',
    'money_flowing_out'                         => 'Iz',
    'topX'                                      => 'prvih :number',
    'show_full_list'                            => 'Pokažite celoten seznam',
    'show_only_top'                             => 'Pokažite samo prvih :number',
    'report_type'                               => 'Vrsta poročila',
    'report_type_default'                       => 'Privzeto finančno poročilo',
    'report_type_audit'                         => 'Pregled zgodovine transakcij (revizija)',
    'report_type_category'                      => 'Poročilo kategorij',
    'report_type_budget'                        => 'Poročilo proračunov',
    'report_type_tag'                           => 'Poročilo oznak',
    'report_type_double'                        => 'Poročilo o odhodkih/prihodkih',
    'more_info_help'                            => 'Več informacij o teh vrstah poročil lahko najdete na straneh s pomočjo. Pritisnite ikono (?) v zgornjem desnem kotu.',
    'report_included_accounts'                  => 'Vključeni računi',
    'report_date_range'                         => 'Datumski obseg',
    'report_preset_ranges'                      => 'Prednastavljeni obsegi',
    'shared'                                    => 'Skupni',
    'fiscal_year'                               => 'Fiskalno leto',
    'income_entry'                              => 'Prihodki na računi ":name" med :start in :end',
    'expense_entry'                             => 'Stroški na računu ":name" med :start in :end',
    'category_entry'                            => 'Odhodki in prihodki v kategoriji ":name" med :start in :end',
    'budget_spent_amount'                       => 'Stroški v proračunu "::budget" med :start in :end',
    'balance_amount'                            => 'Stroški v proračunu ":budget", plačani iz računa ":account" med :start in :end',
    'no_audit_activity'                         => 'Na račun ni bila zabeležena nobena dejavnost <a href=":url" title=":account_name">:account_name</a> med :start in :end.',
    'audit_end_balance'                         => 'Stanje na računu <a href=":url" title=":account_name">:account_name</a> na koncu :end je bilo :balance',
    'reports_extra_options'                     => 'Dodatne možnosti',
    'report_has_no_extra_options'               => 'To poročilo nima dodatnih možnosti',
    'reports_submit'                            => 'Ogled poročila',
    'end_after_start_date'                      => 'Končni datum poročila mora biti po začetnem datumu.',
    'select_category'                           => 'Izberi kategorije',
    'select_budget'                             => 'Izberi proračun(e).',
    'select_tag'                                => 'Izberi oznake.',
    'income_per_category'                       => 'Prihodki po kategoriji',
    'expense_per_category'                      => 'Stroški po kategorijah',
    'expense_per_budget'                        => 'Stroški po proračunu',
    'income_per_account'                        => 'Prihodki pa računu',
    'expense_per_account'                       => 'Stroški po računih',
    'expense_per_tag'                           => 'Stroški po oznakah',
    'income_per_tag'                            => 'Prihodki po oznaki',
    'include_expense_not_in_budget'             => 'Vključeni stroški niso v izbranih proračunih',
    'include_expense_not_in_account'            => 'Vključeni stroški niso v izbranih računih',
    'include_expense_not_in_category'           => 'Vključeni stroški niso v izbranih kategorijah',
    'include_income_not_in_category'            => 'Vključeni prihodki niso v izbranih kategorijah',
    'include_income_not_in_account'             => 'Vključeni prihodki niso v izbranih računih',
    'include_income_not_in_tags'                => 'Vključeni prihodki nimajo izbranih oznak',
    'include_expense_not_in_tags'               => 'Vključeni stroški nimajo izbranih oznak',
    'everything_else'                           => 'Vse ostalo',
    'income_and_expenses'                       => 'Prihodki in odhodki',
    'spent_average'                             => 'Porabljeno (povprečje)',
    'income_average'                            => 'Prihodki (povprečno)',
    'transaction_count'                         => 'Število transakcije',
    'average_spending_per_account'              => 'Povprečna poraba po računu',
    'average_income_per_account'                => 'Povprečni prihodek po računu',
    'total'                                     => 'Skupaj',
    'description'                               => 'Opis',
    'sum_of_period'                             => 'Seštevek obdobja',
    'average_in_period'                         => 'Povprečno v obdobju',
    'no_account_role'                           => '(brez vloge)',
    'account_role_defaultAsset'                 => 'Privzeti račun sredstev',
    'account_role_sharedAsset'                  => 'Skupni račun sredstev',
    'account_role_savingAsset'                  => 'Varčevalni račun',
    'account_role_ccAsset'                      => 'Kreditna kartica',
    'account_role_cashWalletAsset'              => 'Gotovina',
    'budget_chart_click'                        => 'V zgornji tabeli kliknite na ime proračuna, za ogled grafikona.',
    'category_chart_click'                      => 'Za ogled grafikona v zgornji tabeli kliknite na ime kategorije.',
    'in_out_accounts'                           => 'Kombinacija zasluženo/porabljeno',
    'in_out_accounts_per_asset'                 => 'Zasluženo in porabljeno (po računih sredstev)',
    'in_out_per_category'                       => 'Zasluženo in porabljeno po kategoriji',
    'out_per_budget'                            => 'Porabljeno po proračunu',
    'select_expense_revenue'                    => 'Izberite račun stroškov/prihodkov',
    'multi_currency_report_sum'                 => 'Ker ta seznam vsebuje račune z več valutami, vsota, ki jo vidite, morda nima smisla. Poročilo se vedno vrne na privzeto valuto.',
    'sum_in_default_currency'                   => 'Vsota bo vedno v privzeti valuti.',
    'net_filtered_prefs'                        => 'Ta grafikon nikoli ne bo vključeval računov, ki nimajo izbrano »Vključi v neto vrednost«.',


    // charts:
    'chart'                                     => 'Grafikon',
    'month'                                     => 'Mesec',
    'budget'                                    => 'Proračun',
    'spent'                                     => 'Porabljeno',
    'spent_capped'                              => 'Porabljeno (omejeno)',
    'spent_in_budget'                           => 'Porabljeno v proračunu',
    'left_to_spend'                             => 'Ostane za porabit',
    'earned'                                    => 'Prisluženo',
    'overspent'                                 => 'Preveč porabljeno',
    'left'                                      => 'Preostalo',
    'max-amount'                                => 'Najvišji znesek',
    'min-amount'                                => 'Najmanjša vrednost',
    'journal-amount'                            => 'Trenutni vnos naročnine',
    'name'                                      => 'Ime',
    'expires_at'                                => 'Poteče ob',
    'date'                                      => 'Datum',
    'date_and_time'                             => 'Datum in čas',
    'time'                                      => 'Čas',
    'paid'                                      => 'Plačano',
    'unpaid'                                    => 'Neplačano',
    'day'                                       => 'Dan',
    'budgeted'                                  => 'Proračunski znesek',
    'period'                                    => 'Obdobje',
    'balance'                                   => 'Stanje',
    'in_out_period'                             => 'V + iz tega obdobja',
    'sum'                                       => 'Vsota',
    'summary'                                   => 'Povzetek',
    'average'                                   => 'Povprečno',
    'balanceFor'                                => 'Stanje za :name',
    'no_tags'                                   => '(ni oznak)',
    'nothing_found'                             => '(nič najdenega)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Nastavitve strani',
    'visible_columns'               => 'Prikazani stolpci',
    'accounts_to_show'              => 'Računi za prikaz',
    'active_accounts_only'          => 'Samo aktivni računi',
    'in_active_accounts_only'       => 'Samo neaktivni računi',
    'show_all_accounts'             => 'Prikaži vse račune',
    'group_accounts'                => 'Združi račune',

    // piggy banks:
    'event_history'                 => 'Zgodovina dogodkov',
    'add_money_to_piggy'            => 'Dodaj denar na hranilnik ":name"',
    'piggy_bank'                    => 'Dodaj hranilnik',
    'new_piggy_bank'                => 'Nov hranilnik',
    'store_piggy_bank'              => 'Shrani nov hranilnik',
    'stored_piggy_bank'             => 'Shrani nov hranilnik ":name"',
    'account_status'                => 'Stanje računa',
    'left_for_piggy_banks'          => 'Preostalo za hranilnike',
    'sum_of_piggy_banks'            => 'Vsota hranilnikov',
    'saved_so_far'                  => 'Privarčevano do sedaj',
    'saved_so_far_total'            => 'Do sedaj skupaj shranjeno',
    'reset_history'                 => 'ponastavi zgodovino',
    'reset_history_confirm'         => 'Ali ste prepričani, da želite ponastaviti zgodovino tega hranilnika? S tem se bo grafikon znova ujemal z zneskom v hranilniku.',
    'piggy_history_reset'           => 'Zgodovina hranilnika je bila ponastavljena',
    'left_to_save'                  => 'Preostalo za varčevanje',
    'suggested_amount'              => 'Predlagani mesečni znesek varčevanja',
    'add_money_to_piggy_title'      => 'Dodaj denar na hranilnik ":name"',
    'remove_money_from_piggy_title' => 'Odstrani denar s hranilnika ":name"',
    'add'                           => 'Dodaj',
    'no_money_for_piggy'            => 'Nimate denarja, da bi ga dali v ta hranilnik.',
    'suggested_savings_per_month'   => 'Predlagano na mesec',

    'remove'                    => 'Odstrani',
    'max_amount_add'            => 'Najvišji znesek, ki ga lahko dodate, je',
    'max_amount_remove'         => 'Najvišji znesek, ki ga lahko odstranite, je',
    'update_piggy_button'       => 'Posodobi hranilnik',
    'update_piggy_title'        => 'Posodobi hranilnik ":name"',
    'updated_piggy_bank'        => 'Hranilnik ":name" je posodobljen',
    'details'                   => 'Podrobnosti',
    'events'                    => 'Dogodki',
    'target_amount'             => 'Ciljni znesek',
    'start_date'                => 'Začetni datum',
    'no_start_date'             => 'Brez začetnega datuma',
    'target_date'               => 'Ciljni datum',
    'no_target_date'            => 'Brez ciljnega datuma',
    'table'                     => 'Tabela',
    'delete_piggy_bank'         => 'Izbriši hranilnik ":name"',
    'cannot_add_amount_piggy'   => 'Zneska :amount ni bilo mogoče dodati na ":name".',
    'cannot_remove_from_piggy'  => 'Zneska :amount ni bilo mogoče odstraniti iz ":name".',
    'deleted_piggy_bank'        => 'Hranilnik ":name" je izbrisan',
    'added_amount_to_piggy'     => 'Znesek :amount dodan na ":name"',
    'removed_amount_from_piggy' => 'Znesek :amount odstranjen iz ":name"',
    'piggy_events'              => 'Sorodni hranilniki',

    // tags
    'delete_tag'                => 'Izbriši oznako ":tag"',
    'deleted_tag'               => 'Oznaka ":tag" je izbrisana',
    'new_tag'                   => 'Ustvari novo oznako',
    'edit_tag'                  => 'Uredi oznako ":tag"',
    'updated_tag'               => 'Posodobi oznako ":tag"',
    'created_tag'               => 'Oznaka ":tag" je bila ustvarjena!',

    'transaction_journal_information'               => 'Informacije o transakciji',
    'transaction_journal_amount'                    => 'Informacije o znesku',
    'transaction_journal_meta'                      => 'Meta informacije',
    'transaction_journal_more'                      => 'Več informacij',
    'basic_journal_information'                     => 'Osnovne informacije o transakciji',
    'transaction_journal_extra'                     => 'Dodatne informacije',
    'att_part_of_journal'                           => 'Shranjeno v ":journal"',
    'total_amount'                                  => 'Skupni znesek',
    'number_of_decimals'                            => 'Število decimalk',


    // administration
    'invite_is_already_redeemed'                    => 'Povabilo na ":address" je že unovčeno.',
    'invite_is_deleted'                             => 'Povabilo na ":address" je bilo izbrisano.',
    'invite_new_user_title'                         => 'Povabi nove uporabnike',
    'invite_new_user_text'                          => 'Kot skrbnik lahko povabite uporabnike, da se registrirajo v vašo namestitev Firefly III. Z uporabo neposredne povezave, ki jo lahko delite z njimi, bodo lahko registrirali račun. Povabljeni uporabnik in njegova povezava do povabila bosta prikazana v spodnji tabeli. Z njimi lahko delite povezavo do povabila.',
    'invited_user_mail'                             => 'E-poštni naslov',
    'invite_user'                                   => 'Povabi uporabnika',
    'user_is_invited'                               => 'E-poštni naslov ":address" je bil povabljen na Firefly III',
    'administration'                                => 'Administracija',
    'system_settings'                               => 'Sistemske nastavitve',
    'code_already_used'                             => 'Uporabljena je bila koda povabila',
    'user_administration'                           => 'Upravljanje uporabnikov',
    'list_all_users'                                => 'Vsi uporabniki',
    'all_users'                                     => 'Vsi uporabniki',
    'instance_configuration'                        => 'Nastavitve',
    'firefly_instance_configuration'                => 'Firefly III nastavitve',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'Enouporabniški način',
    'setting_single_user_mode_explain'              => 'Privzeto Firefly III dovoli samo eno (1) registracijo: vašo. To je varnostni ukrep, ki preprečuje drugim, da uporabljajo vašo instanco, razen če jim tega ne dovolite. Nadaljnje registracije so blokirane. Ko počistite to potrditveno polje, lahko tudi drugi uporabijo vašo instanco, če do nje lahko dostopajo (ko je objavljena na internetu).',
    'store_configuration'                           => 'Shranite nastavitve',
    'single_user_administration'                    => 'Uporabniške nastavitve za :email',
    'edit_user'                                     => 'Uredi uporabnika :email',
    'hidden_fields_preferences'                     => 'Več možnosti transakcije lahko omogočite v <a href="preferences">nastavitvah</a>.',
    'user_data_information'                         => 'Uporabniški podatki',
    'user_information'                              => 'Podatki o uporabniku',
    'total_size'                                    => 'skupna velikost',
    'budget_or_budgets'                             => ':count proračun|:count proračunov',
    'budgets_with_limits'                           => 'Proračun:count z nastavljenim zneskom|:count proračuni z nastavljenim zneskom',
    'nr_of_rules_in_total_groups'                   => ':count_rules pravil v :count_groups skupinskem/ih pravilu/ih',
    'tag_or_tags'                                   => ':count oznak|:count oznak',
    'configuration_updated'                         => 'Nastavitve so bili posodobljene',
    'setting_is_demo_site'                          => 'Demo stran',
    'setting_is_demo_site_explain'                  => 'Če potrdite to polje, se bo ta namestitev obnašala, kot da je to demo spletno mesto in ima lahko čudne stranske učinke.',
    'block_code_bounced'                            => 'Elektronsko sporočilo je bilo zavrnjeno',
    'block_code_expired'                            => 'Demo račun je potekel',
    'no_block_code'                                 => 'Brez razloga za blokiranje ali pa uporabnik ni blokiran',
    'demo_user_export'                              => 'Demo uporabnik ne more izvoziti podatkov',
    'block_code_email_changed'                      => 'Uporabnik še ni potrdil novega elektronskega naslova',
    'admin_update_email'                            => 'V nasprotju s stranjo profila, uporabnik NE bo obveščen o spremembi svojega elektronskega naslova!',
    'update_user'                                   => 'Posodobi uporabnika',
    'updated_user'                                  => 'Uporabniški podatki spremenjeni.',
    'delete_user'                                   => 'Izbriši uporabnika :email',
    'user_deleted'                                  => 'Uporabnik je izbrisan',
    'send_test_email'                               => 'Pošlji testno elektronsko sporočilo',
    'send_test_email_text'                          => 'Če želite preveriti, ali lahko vaša namestitev pošlje obvestilo, pritisnite ta gumb. Tukaj ne boste videli napake (če obstaja), <strong>dnevniške datoteke bodo odražale vse napake</strong>. Ta gumb lahko pritisnete tolikokrat, kot želite. Ni nadzora neželene pošte. Sporočilo bo poslano na <code>:email</code> in bi moralo prispeti kmalu.',
    'send_message'                                  => 'Pošlji sporočilo',
    'send_test_triggered'                           => 'Test je bil sprožen. Preverite mapo »Prejeto« in datoteke dnevnika.',
    'give_admin_careful'                            => 'Uporabniki, ki imajo skrbniške pravice, vam lahko odvzamejo vaše. Bodi previden.',
    'admin_maintanance_title'                       => 'Vzdrževanje',
    'admin_maintanance_expl'                        => 'Nekaj čudovitih gumbov za vzdrževanje Firefly III',
    'admin_maintenance_clear_cache'                 => 'Izpraznite predpomnilnik',
    'owner_notifications'                           => 'Skrbniška obvestila',
    'owner_notifications_expl'                      => 'Skrbnik lahko omogoči ali onemogoči naslednja obvestila. Poslano bo po VSEH nastavljenih kanalih. Nekateri kanali so nastavljeni v spremenljivkah vašega okolja, druge lahko nastavite tukaj.',
    'channel_settings'                              => 'Nastavitve kanalov za obvestila',
    'notification_test_failed'                      => 'Preizkus obvestil za kanal »:channel« ni uspel. Več podrobnosti lahko najdete je v dnevnikih.',
    'notification_test_executed'                    => 'Preizkus obvestila za kanal ":channel" je bil izveden. Preverite svoje dnevnike za podrobnosti.',
    'settings_notifications'                        => 'Nastavitve za obvestila',
    'title_owner_notifications'                     => 'Obvestila lastnika',
    'owner_notification_check_user_new_reg'         => 'Uporabnik prejme pozdravno sporočilo po registraciji',
    'owner_notification_check_admin_new_reg'        => 'Skrbniki prejmejo obvestilo o registraciji novega uporabnika',
    'owner_notification_check_new_version'          => 'Na voljo je nova različica',
    'owner_notification_check_invite_created'       => 'Uporabnik je bil povabljen v Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Uporabniško povabilo je unovčeno',
    'owner_notification_check_unknown_user_attempt' => 'Neznani uporabnik se poskuša prijaviti',
    'all_invited_users'                             => 'Vsi povabljeni uporabniki',
    'save_notification_settings'                    => 'Shrani nastavitve',
    'notification_settings'                         => 'Nastavitve za obvestila',
    'notification_settings_saved'                   => 'Nastavitve obvestil so shranjene',
    'available_channels_title'                      => 'Kanali na voljo',
    'available_channels_expl'                       => 'Ti kanali so na voljo za pošiljanje obvestil. Če želite preizkusiti svoje nastavitve, uporabite spodnje gumbe. Upoštevajte, da gumbi nimajo nadzora neželene pošte.',
    'notification_channel_name_email'               => 'E-pošta',
    'slack_discord_double'                          => 'Kanal za obveščanje Slack lahko pošilja obvestila tudi Discordu.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'ni na voljo',
    'configure_channel_in_env'                      => 'potrebuje spremenljivke okolja',
    'test_notification_channel_name_email'          => 'Preizkusi e-pošto',
    'test_notification_channel_name_slack'          => 'Preizkusi Slack',
    'test_notification_channel_name_ntfy'           => 'Preizkusi Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Preizkusi Pushover',
    'test_notification_channel_name_gotify'         => 'Preizkusi Gotify',
    'test_notification_channel_name_pushbullet'     => 'Preizkusi Pushbullet',

    'split_transaction_title'               => 'Opis razdeljene transakcije',
    'split_transaction_title_help'          => 'Če ustvarite razdeljeno transakcijo, mora obstajati globalni opis za vse razdelitve transakcije.',
    'split_title_help'                      => 'Če ustvarite razdeljeno transakcijo, mora obstajati globalni opis za vse dele transakcije.',
    'you_create_transfer'                   => 'Ustvarjate prenos.',
    'you_create_withdrawal'                 => 'Ustvarjate odliv.',
    'you_create_deposit'                    => 'Ustvarjaš priliv.',

    // links
    'journal_link_configuration'            => 'Nastavitev povezav transakcije',
    'create_new_link_type'                  => 'Ustvari novo vrsto povezave',
    'store_new_link_type'                   => 'Shrani novo vrsto povezave',
    'update_link_type'                      => 'Posodobi vrsto povezave',
    'edit_link_type'                        => 'Uredi vrsto povezave ":name"',
    'updated_link_type'                     => 'Vrsta povezave ":name" je posodobljena',
    'delete_link_type'                      => 'Izbriši vrsto povezave ":name"',
    'deleted_link_type'                     => 'Vrsta povezave ":name" je izbrisana',
    'stored_new_link_type'                  => 'Shranite vrsto povezave ":name"',
    'cannot_edit_link_type'                 => 'Ne morem urediti vrste povezave ":name"',
    'link_type_help_name'                   => 'Npr. "Dvojniki"',
    'link_type_help_inward'                 => 'Npr. "dvojniki"',
    'link_type_help_outward'                => 'Npr. "podvojil ga je"',
    'save_connections_by_moving'            => 'Shranite povezavo med temi transakcijami tako, da jih premaknete na drugo vrsto povezave:',
    'do_not_save_connection'                => '(ne shrani povezave)',
    'link_transaction'                      => 'Poveži transakcijo',
    'link_to_other_transaction'             => 'Poveži to transakcijo z drugo transakcijo',
    'select_transaction_to_link'            => 'Izberite transakcijo, s katero želite povezati to transakcijo. Povezave trenutno niso v uporabi v Firefly III (razen tega, da so prikazane), vendar nameravam to spremeniti v prihodnosti. Z iskalnim poljem izberite transakcijo po naslovu ali ID-ju. Če želite dodati vrste povezav po meri, preverite nastavitve.',
    'this_transaction'                      => 'Ta transakcija',
    'transaction'                           => 'Transakcija',
    'comments'                              => 'Komentarji',
    'link_notes'                            => 'Vse opombe, ki jih želite shraniti s povezavo.',
    'invalid_link_selection'                => 'Teh transakcij se ne da povezati',
    'selected_transaction'                  => 'Izbrana transakcija',
    'journals_linked'                       => 'Transakcije so povezane.',
    'journals_error_linked'                 => 'Te transakcije so že povezane.',
    'journals_link_to_self'                 => 'Transakcije ni mogoče povezati samo nase',
    'journal_links'                         => 'Povezave transakcije',
    'this_withdrawal'                       => 'Ta odliv',
    'this_deposit'                          => 'Ta priliv',
    'this_transfer'                         => 'Ta prenos',
    'overview_for_link'                     => 'Pregled vrste povezav ":name"',
    'source_transaction'                    => 'Izvorna transakcija',
    'link_description'                      => 'Opis povezave',
    'destination_transaction'               => 'Ciljna transakcija',
    'delete_journal_link'                   => 'Izbriši povezavo med <a href=":source_link">:source</a> in <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Povezava izbrisana',

    // link translations:
    'Paid_name'                             => 'Plačano',
    'Refund_name'                           => 'Vračilo',
    'Reimbursement_name'                    => 'Povračilo',
    'Related_name'                          => 'Povezano',
    'relates to_inward'                     => 'se nanaša na',
    'is (partially) refunded by_inward'     => 'je (delno) vrnjen iz',
    'is (partially) paid for by_inward'     => 'je (delno) plačan iz',
    'is (partially) reimbursed by_inward'   => 'je (delno) povrnjen iz',
    'inward_transaction'                    => 'Dohodno plačilo',
    'outward_transaction'                   => 'Odhodno plačilo',
    'relates to_outward'                    => 'povezan z',
    '(partially) refunds_outward'           => '(delno) poplača',
    '(partially) pays for_outward'          => '(delno) plača za',
    '(partially) reimburses_outward'        => '(delno) povrnjen',
    'is (partially) refunded by'            => 'znesek je (delno) povrnen od',
    'is (partially) paid for by'            => 'je (delno) plačan od',
    'is (partially) reimbursed by'          => 'je (delno) povrnjen od',
    'relates to'                            => 'povezan z',
    '(partially) refunds'                   => '(delna) povračila',
    '(partially) pays for'                  => '(delno) plačan za',
    '(partially) reimburses'                => '(delno) povrnjen',

    // split a transaction:
    'splits'                                => 'Razdelitve',
    'add_another_split'                     => 'Dodaj še eno razdelitev',
    'cannot_edit_opening_balance'           => 'Ne morete urejati začetnega stanja računa.',
    'no_edit_multiple_left'                 => 'Za urejanje niste izbrali veljavnih transakcij.',
    'breadcrumb_convert_group'              => 'Pretvori transakcijo',
    'convert_invalid_source'                => 'Podatki o izvoru niso veljavni za transakcijo #%d.',
    'convert_invalid_destination'           => 'Informacije o cilju niso veljavne za transakcijo #%d.',
    'create_another'                        => 'Po shranjevanju se vrnite sem, da ustvarite še enega.',
    'after_update_create_another'           => 'Po posodobitvi se vrnite sem za nadaljevanje urejanja.',
    'store_as_new'                          => 'Shranite kot novo transakcijo namesto posodabljanja.',
    'reset_after'                           => 'Po predložitvi ponastavite obrazec',
    'errors_submission'                     => 'Nekaj je bilo narobe z vašo oddajo. Preverite spodnje napake.',
    'errors_submission_v2'                  => 'Nekaj je bilo narobe z vašo oddajo. Preverite spodnje napake: {{errorMessage}}',
    'transaction_expand_split'              => 'Razširi razdelitev',
    'transaction_remove_split'              => 'Odstrani delitev',
    'transaction_collapse_split'            => 'Skrči razdelitev',

    // object groups
    'default_group_title_name'              => '(nezdruženo)',
    'default_group_title_name_plain'        => 'nezdruženo',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Ustvarimo račun sredstev!',
    'no_accounts_intro_asset'               => 'Še nobenega računa sredstev nimate. Ti računi so vaši glavni računi sredstev: tekoči računi, skupni računi, varčevalni računi in celo računi kreditnih kartic.',
    'no_accounts_imperative_asset'          => 'Za začetek uporabe Firefly III, morate ustvariti vsaj en račun sredstev. Naredite to zdaj:',
    'no_accounts_create_asset'              => 'Ustvari račun sredstev',
    'no_accounts_title_expense'             => 'Ustvarimo nov račun stroškov!',
    'no_accounts_intro_expense'             => 'Nimate še nobenega računa stroškov. Računi stroškov so računi kamor knjižite denar, ki ste ga zapravili kot npr. trgovine in supermarketi.',
    'no_accounts_imperative_expense'        => 'Računi stroškov se ustvarijo samodejno pri kreiranju transakcije, če pa želite, jih lahko ustvarite tudi ročno. Ustvarite enega zdaj:',
    'no_accounts_create_expense'            => 'Ustvari račun stroškov',
    'no_accounts_title_revenue'             => 'Ustvarimo račun prihodkov!',
    'no_accounts_intro_revenue'             => 'Računov prihodkov še nimate. Računi prihodkov so tisti v katere prejemate denar, kot je na primer vaš od vašega delodajalca.',
    'no_accounts_imperative_revenue'        => 'Računi prihodkov se ustvarijo samodejno ko ustvarite transakcije, lahko pa jih ustvarite tudi ročno, če želite:',
    'no_accounts_create_revenue'            => 'Ustvari račun prihodkov',
    'no_accounts_title_liabilities'         => 'Ustvarimo obveznost!',
    'no_accounts_intro_liabilities'         => 'Obveznosti še nimaš. Obveznosti so računi, ki evidentirajo (študentska) posojila in druge dolgove.',
    'no_accounts_imperative_liabilities'    => 'Te funkcije ni treba uporabljati, vendar je lahko uporabna, če želite slediti tem stvarem.',
    'no_accounts_create_liabilities'        => 'Ustvari obveznost',
    'no_budgets_title_default'              => 'Ustvarimo proračun',
    'no_rules_title_default'                => 'Ustvarimo pravilo',
    'no_budgets_intro_default'              => 'Nimate še nobenega proračuna. Proračuni se uporabljajo za organiziranje vaših stroškov v logične skupine, ki jim lahko dodelite poljubne zneske za omejitev svojih stroškov.',
    'no_rules_intro_default'                => 'Nimate še nobenih pravil. Pravila so močna avtomatizacija, ki lahko upravlja transakcije namesto vas.',
    'no_rules_imperative_default'           => 'Pravila so lahko zelo uporabna, ko upravljate transakcije. Ustvarimo ga zdaj:',
    'no_budgets_imperative_default'         => 'Proračuni so osnovno orodje finančnega upravljanja. Ustvarimo enega zdaj:',
    'no_budgets_create_default'             => 'Ustvari proračun',
    'no_rules_create_default'               => 'Ustvari pravilo',
    'no_categories_title_default'           => 'Ustvarimo kategorijo!',
    'no_categories_intro_default'           => 'Nimate še kategorij. Kategorije se uporabljajo za natančno nastavitev transakcij in označevanje z določeno kategorijo.',
    'no_categories_imperative_default'      => 'Kategorije se ustvarijo avtomatično, ko ustvarite transakcije, lahko pa jih ustvarite tudi ročno, če želite:',
    'no_categories_create_default'          => 'Ustvari kategorijo',
    'no_tags_title_default'                 => 'Ustvarimo novo oznako!',
    'no_tags_intro_default'                 => 'Oznak še nimaš. Oznake se uporabljajo za natančno nastavitev transakcij in označevanje z določenimi ključnimi besedami.',
    'no_tags_imperative_default'            => 'Oznake se ustvarijo samodejno ko ustvarite transakcije, lahko pa jih ustvarite tudi ročno, če želite:',
    'no_tags_create_default'                => 'Ustvari oznako',
    'no_transactions_title_withdrawal'      => 'Ustvarimo nov strošek!',
    'no_transactions_intro_withdrawal'      => 'Stroškov še nimate. Za upravljanje svojih financ morate ustvariti stroške.',
    'no_transactions_imperative_withdrawal' => 'Ste porabili nekaj denarja? Potem pa to vnesite:',
    'no_transactions_create_withdrawal'     => 'Ustvari strošek',
    'no_transactions_title_deposit'         => 'Ustvarimo nov prihodek!',
    'no_transactions_intro_deposit'         => 'Prihodkov še nimate. Za upravljanje vaših financ morate začeti beležiti prihodke.',
    'no_transactions_imperative_deposit'    => 'Ste dobil nekaj denarja? Potem pa to vnesite:',
    'no_transactions_create_deposit'        => 'Ustvari priliv',
    'no_transactions_title_transfers'       => 'Ustvarimo nov prenos!',
    'no_transactions_intro_transfers'       => 'Nimate še nobenih prenosov. Če prenašate denar med računi sredstev, se to zabeleži kot prenos.',
    'no_transactions_imperative_transfers'  => 'Ste že premikali denar naokoli? Potem pa to vnesite:',
    'no_transactions_create_transfers'      => 'Ustvari prenos',
    'no_piggies_title_default'              => 'Ustvarimo nov hranilnik!',
    'no_piggies_intro_default'              => 'Nimate še hranilnikov. Lahko jih ustvarite, da razdelite svoje prihranke in spremljate, za kaj varčujete.',
    'no_piggies_imperative_default'         => 'Ali imate stvari za katere varčujete? Ustvarite hranilnik in z njim sledite varčevanju:',
    'no_piggies_create_default'             => 'Ustvari nov hranilnik',
    'no_bills_title_default'                => 'Ustvarimo naročnino!',
    'no_bills_intro_default'                => 'Nimate še nobene naročnine. Ustvarite lahko naročnine, da spremljate redne stroške, kot je najemnina ali zavarovanje.',
    'no_bills_imperative_default'           => 'Imate tako redne naročnine? Ustvarite naročnino in spremljajte svoja plačila:',
    'no_bills_create_default'               => 'Ustvari novo naročnino',

    // recurring transactions
    'recurrence_max_count'                  => 'Te ponavljajoče se transakcije bodo ustvarjene za največ :max časa in so bile ustvarjene že :count krat.',
    'create_right_now'                      => 'Ustvari takoj',
    'no_new_transaction_in_recurrence'      => 'Ustvarjena ni bila nobena nova transakcija. Mogoče je bila za ta datum že sprožena?',
    'recurrences'                           => 'Ponavljajoče se transakcije',
    'repeat_until_in_past'                  => 'Ta ponavljajoča se transakcija se je prenehala ponavljati dne :date.',
    'recurring_calendar_view'               => 'Koledar',
    'no_recurring_title_default'            => 'Ustvarimo ponavljajočo se transakcijo!',
    'no_recurring_intro_default'            => 'Ponavljajočih transakcij še nimate. Uporabite jih lahko zato, da vam Firefly III samodejno ustvari transakcije.',
    'no_recurring_imperative_default'       => 'To je precej napredna funkcija, vendar je lahko zelo uporabna. Preden nadaljuješ, se prepričaj, da si v zgornjem desnem kotu prebral dokumentacijo (ikona ?).',
    'no_recurring_create_default'           => 'Ustvari ponavljajočo se transakcijo',
    'make_new_recurring'                    => 'Ustvari ponavljajočo se transakcijo',
    'recurring_daily'                       => 'Vsak dan',
    'recurring_weekly'                      => 'Vsak teden v :weekday',
    'recurring_weekly_skip'                 => 'Vsak :skip teden na :weekday',
    'recurring_monthly'                     => 'Vsak mesec :dayOfMonth. dan',
    'recurring_monthly_skip'                => 'Vsak :skip mesec na :dayOfMonth dan',
    'recurring_ndom'                        => 'Vsak mesec :dayOfMonth. :weekday',
    'recurring_ndom_skip'                   => 'Vsak :skip(i) mesec na :dayOfMonth(ega) :weekday',
    'recurring_yearly'                      => 'Vsako leto na :date',
    'overview_for_recurrence'               => 'Pregled ponavljajočih se transakcij ":title"',
    'warning_duplicates_repetitions'        => 'V redkih primerih se datumi na tem seznamu pojavijo dvakrat. To se lahko zgodi, če pride do večkratnih ponovitev. Firefly III bo vedno ustvaril eno transakcijo na dan.',
    'created_transactions'                  => 'Sorodne transakcije',
    'expected_withdrawals'                  => 'Pričakovani odlivi',
    'expected_deposits'                     => 'Pričakovani prilivi',
    'expected_transfers'                    => 'Pričakovani prenosi',
    'created_withdrawals'                   => 'Ustvarjeni odlivi',
    'created_deposits'                      => 'Ustvarjeni prilivi',
    'created_transfers'                     => 'Ustvarjeno prenosi',
    'recurring_info'                        => 'Ponavljajoča se transakcija :count / :total',
    'created_from_recurrence'               => 'Ustvarjeno iz ponavljajoče se transakcije ":title" (#:id)',
    'recurring_never_cron'                  => 'Zdi se, da se cron opravilo, ki je potrebno za podporo ponavljajočih se transakcij ni še nikoli zagnalo. To je seveda normalno, če ste pravkar namestili Firefly III, vendar je to nekaj, kar morate čim prej nastaviti. Oglejte si strani s pomočjo z ikono (?) - v zgornjem desnem kotu strani.',
    'recurring_cron_long_ago'               => 'Izgleda, da je preteklo več kot 36 ur, odkar je zadnje cron opravilo, ki podpira ponavljajoče se transakcije, sprožilo. Ali ste prepričan, da je bilo pravilno nastavljeno? Oglejte si strani s pomočjo z ikono (?) v zgornjem desnem kotu strani.',

    'create_new_recurrence'              => 'Ustvari novo ponavljajočo se transakcijo',
    'help_first_date'                    => 'Navedi prvo pričakovano ponovitev. To mora biti v prihodnosti.',
    'help_first_date_no_past'            => 'Firefly III ne bo ustvarjal transakcij v preteklosti.',
    'no_currency'                        => '(brez valute)',
    'mandatory_for_recurring'            => 'Obvezne informacije o ponovitvah',
    'mandatory_for_transaction'          => 'Obvezne informacije o transakcijah',
    'optional_for_recurring'             => 'Neobvezne informacije o ponovitvah',
    'optional_for_transaction'           => 'Neobvezne informacije o transakcijah',
    'change_date_other_options'          => 'Spremenite "prvi datum", za več možnosti.',
    'mandatory_fields_for_tranaction'    => 'Te vrednosti bodo končale v ustvarjenih transakcijah',
    'click_for_calendar'                 => 'Kliknite tu za koledar, ki vam pokaže, kdaj se transakcija ponovi.',
    'repeat_forever'                     => 'Ponavljaj v nedogled',
    'repeat_until_date'                  => 'Ponavljaj do datuma',
    'repeat_times'                       => 'Ponavljaj večkrat',
    'recurring_skips_one'                => 'Vsak drugi',
    'recurring_skips_more'               => 'Preskoči :count ponovitev',
    'store_new_recurrence'               => 'Shranite ponavljajočo se transakcijo',
    'stored_new_recurrence'              => 'Ponavljajoča se transakcija ":title" uspešno shranjena.',
    'edit_recurrence'                    => 'Uredi ponavljajočo se transakcijo ":title"',
    'recurring_repeats_until'            => 'Ponavlja se do :date',
    'recurring_repeats_forever'          => 'Ponavlja se v nedogled',
    'recurring_repeats_x_times'          => 'Ponavlja se :count časa|Ponavlja se :count krat',
    'update_recurrence'                  => 'Uredi ponavljajočo se transakcijo',
    'updated_recurrence'                 => 'Ponavljajoča se transakcija ":title" je bila urejena',
    'recurrence_is_inactive'             => 'Ta ponavljajoča se transakcija ni aktivna in ne bo ustvarila novih transakcij.',
    'delete_recurring'                   => 'Izbriši ponavljajočo se transakcijo ":title"',
    'new_recurring_transaction'          => 'Nova ponavljajoča se transakcija',
    'help_weekend'                       => 'Kaj naj Firefly III stori, ko ponavljajoča se transakcija pade na soboto ali nedeljo?',
    'do_nothing'                         => 'Samo ustvari transakcijo',
    'skip_transaction'                   => 'Preskoči ponovitev',
    'jump_to_friday'                     => 'Namesto tega ustvari transakcijo na prejšnji petek',
    'jump_to_monday'                     => 'Namesto tega ustvari transakcijo na naslednji ponedeljek',
    'will_jump_friday'                   => 'Bo ustvarjena v petek namesto ob vikendih.',
    'will_jump_monday'                   => 'Bo ustvarjena v ponedeljek namesto ob vikendih.',
    'except_weekends'                    => 'Razen vikendov',
    'recurrence_deleted'                 => 'Ponavljajoča se transakcija ":title" izbrisana',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Stanje (:currency)',
    'box_spent_in_currency'              => 'Porabljeno (:currency)',
    'box_earned_in_currency'             => 'Zasluženo (:currency)',
    'box_budgeted_in_currency'           => 'Proračunski znesek (:currency)',
    'box_bill_paid_in_currency'          => 'Plačane naročnine (:currency)',
    'box_bill_unpaid_in_currency'        => 'Neplačane naročnine (:currency)',
    'box_left_to_spend_in_currency'      => 'Še za porabit (:currency)',
    'box_net_worth_in_currency'          => 'Neto vrednost (:currency)',
    'box_spend_per_day'                  => 'Še za zapravit na dan :amount',

    // debug page
    'debug_page'                         => 'Stran za odpravljanje napak',
    'debug_submit_instructions'          => 'Če imate težave, lahko informacije v tem polju uporabite kot informacije za odpravljanje napak. Kopirajte in prilepite v novo ali obstoječo <a href="https://github.com/firefly-iii/firefly-iii/issues">izdajo GitHub</a>. Ustvaril bo čudovito tabelo, ki jo lahko uporabite za hitro diagnosticiranje vaše težave.',
    'debug_pretty_table'                 => 'Če kopirate/prilepite spodnje polje v izdajo GitHub, se ustvari tabela. Prosimo, da tega besedila ne obdajate s povratnimi kljukicami ali narekovaji.',
    'debug_additional_data'              => 'Lahko tudi delite vsebino spodnjega polja. To lahko tudi kopirate in prilepite v novo ali obstoječo <a href="https://github.com/firefly-iii/firefly-iii/issues">izdajo GitHub</a>. Vendar lahko vsebina tega polja vsebuje zasebne podatke, kot so imena računov, podrobnosti o transakcijah ali e-poštni naslovi.',

    // object groups
    'object_groups_menu_bar'             => 'Skupine',
    'object_groups_page_title'           => 'Skupine',
    'object_groups_breadcrumb'           => 'Skupine',
    'object_groups_index'                => 'Pregled',
    'object_groups'                      => 'Skupine',
    'object_groups_empty_explain'        => 'Nekatere stvari v Firefly III lahko razdelimo v skupine. Hranilniki imajo na primer polje »Skupina« na zaslonih za urejanje in ustvarjanje. Ko nastavite to polje, lahko uredite imena in vrstni red skupin na tej strani. Za več informacij si oglejte strani s pomočjo v zgornjem desnem kotu pod ikono (?).',
    'object_group_title'                 => 'Naslov',
    'edit_object_group'                  => 'Uredi skupino ":title"',
    'delete_object_group'                => 'Izbriši skupino ":title"',
    'update_object_group'                => 'Posodobi skupino',
    'updated_object_group'               => 'Uspešno posodobljena skupina ":title"',
    'deleted_object_group'               => 'Uspešno izbrisana skupina ":title"',
    'object_group'                       => 'Skupina',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'Vnosi v revizijskem dnevniku',
    'ale_action_log_add'                 => 'Dodan :amount v hranilnik ":name"',
    'ale_action_log_remove'              => 'Odstranjeno :amount iz hranilnika ":name"',
    'ale_action_clear_budget'            => 'Odstranjeno iz proračuna',
    'ale_action_update_group_title'      => 'Posodobljen naslov transakcijske skupine',
    'ale_action_update_date'             => 'Posodobljen datum transakcije',
    'ale_action_update_order'            => 'Posodobljeno transakcijsko naročilo',
    'ale_action_clear_category'          => 'Odstranjeno iz kategorije',
    'ale_action_clear_notes'             => 'Odstrani opombe',
    'ale_action_clear_tag'               => 'Počiščena oznaka',
    'ale_action_clear_all_tags'          => 'Izbrisane vse oznake',
    'ale_action_set_bill'                => 'Povezano z naročnino',
    'ale_action_switch_accounts'         => 'Zamenjan izvorni in ciljni račun',
    'ale_action_set_budget'              => 'Določite proračun',
    'ale_action_set_category'            => 'Nastavi kategorijo',
    'ale_action_set_source'              => 'Nastavi izvorni račun',
    'ale_action_set_destination'         => 'Nastavi ciljni račun',
    'ale_action_update_transaction_type' => 'Spremenjena vrsta transakcije',
    'ale_action_update_notes'            => 'Spremenjene opombe',
    'ale_action_update_description'      => 'Spremenjen opis',
    'ale_action_add_to_piggy'            => 'Hranilnik',
    'ale_action_remove_from_piggy'       => 'Hranilnik',
    'ale_action_add_tag'                 => 'Dodana oznaka',
    'ale_action_update_amount'           => 'Posodobljen znesek',

    // dashboard
    'enable_auto_convert'                => 'Omogoči pretvorbo valut',
    'disable_auto_convert'               => 'Onemogoči pretvorbo valut',
];
