<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Stäng',
    'actions'                                   => 'Åtgärder',
    'edit'                                      => 'Redigera',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Ta bort',
    'split'                                     => 'Dela',
    'single_split'                              => 'Dela',
    'clone'                                     => 'Klona',
    'clone_and_edit'                            => 'Klona och redigera',
    'confirm_action'                            => 'Bekräfta åtgärd',
    'last_seven_days'                           => 'Senaste 7 dagarna',
    'last_thirty_days'                          => 'Senaste 30 dagarna',
    'last_180_days'                             => 'Senaste 180 dagarna',
    'month_to_date'                             => 'Månad hittills',
    'year_to_date'                              => 'År hittills',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'ÅTD',
    'welcome_back'                              => 'Vad spelas?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Allt',
    'today'                                     => 'idag',
    'customRange'                               => 'Egen tidsperiod',
    'date_range'                                => 'Datumintervall',
    'apply'                                     => 'Bekräfta',
    'select_date'                               => 'Välj datum..',
    'cancel'                                    => 'Avbryt',
    'from'                                      => 'Från',
    'to'                                        => 'Till',
    'structure'                                 => 'Struktur',
    'help_translating'                          => 'Den här hjälptexten finns inte på svenska än. <a href="https://crowdin.com/project/firefly-iii-help">Kan du hjälpa till att översätta?</a>',
    'showEverything'                            => 'Visa allt',
    'never'                                     => 'Aldrig',
    'no_results_for_empty_search'               => 'Din sökning var tom, så ingenting hittades.',
    'removed_amount'                            => 'Borttaget :amount',
    'added_amount'                              => 'Lade till :amount',
    'asset_account_role_help'                   => 'Extra alternativ utifrån ditt val kan ändras senare.',
    'Opening balance'                           => 'Ingående balans',
    'create_new_stuff'                          => 'Skapa nya saker',
    'new_withdrawal'                            => 'Nytt uttag',
    'create_new_transaction'                    => 'Skapa en ny transaktion',
    'sidebar_frontpage_create'                  => 'Skapa',
    'new_transaction'                           => 'Lägg till transaktion',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Visa dina tillgångskonton',
    'go_to_budgets'                             => 'Gå till dina budgetar',
    'go_to_withdrawals'                         => 'Gå till dina uttag',
    'clones_journal_x'                          => 'Denna transaktion är en klon av ":description" (#:id)',
    'go_to_categories'                          => 'Gå till dina kategorier',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => 'Se dina utgiftskonton',
    'go_to_revenue_accounts'                    => 'Se din intäktskonton',
    'go_to_piggies'                             => 'Gå till dina sparbössor',
    'new_deposit'                               => 'Ny insättning',
    'new_transfer'                              => 'Ny överföring',
    'new_transfers'                             => 'Ny överföring',
    'new_asset_account'                         => 'Nytt tillgångskonto',
    'new_expense_account'                       => 'Nytt utgiftskonto',
    'new_revenue_account'                       => 'Nytt intäktskonto',
    'new_liabilities_account'                   => 'Ny skuld',
    'new_budget'                                => 'Ny budget',
    'new_bill'                                  => 'New subscription',
    'block_account_logout'                      => 'Du har loggats ut. Blockerade konton kan inte använda den här sidan. Registrerade du dig med en giltig e-postadress?',
    'flash_success'                             => 'Slutförd!',
    'flash_info'                                => 'Meddelande',
    'flash_warning'                             => 'Varning!',
    'flash_error'                               => 'Fel!',
    'flash_danger'                              => 'Fara!',
    'flash_info_multiple'                       => 'Det finns ett meddelande|Det finns :count meddelanden',
    'flash_error_multiple'                      => 'Det finns ett felmeddelande|Det finns :count felmeddelanden',
    'net_worth'                                 => 'Nettoförmögenhet',
    'help_for_this_page'                        => 'Hjälp för denna sidan',
    'help_for_this_page_body'                   => 'Du hittar mer information om denna sida <a href="https://docs.firefly-iii.org/">i dokumentationen</a>.',
    'two_factor_welcome'                        => 'Hej!',
    'two_factor_enter_code'                     => 'För att fortsätta, mata in din tvåfaktorsautentiseringkod. Din applikation kan generera den åt dig.',
    'two_factor_code_here'                      => 'Skriv in koden',
    'two_factor_title'                          => 'Tvåfaktorsautensiering',
    'authenticate'                              => 'Autentisera',
    'two_factor_forgot_title'                   => 'Förlorad tvåfaktorsautentisering',
    'two_factor_forgot'                         => 'Jag har glömt min tvåfaktors-pryl.',
    'two_factor_lost_header'                    => 'Förlorad tvåfaktorsautentisering?',
    'two_factor_lost_intro'                     => 'Om du har förlorat även dina backupkoder har du otur. Detta är inte något du kan fixa från webbgränssnittet. Du har två val.',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'Annars, skicka epost till sajt-ägaren, <a href="mailto::site_owner">:site_owner</a> och be hen att återställa din tvåfaktorsautentisering.',
    'mfa_backup_code'                           => 'Du har använt en engångskod för att logga in i Firefly III. Den kan inte användas igen, så stryk den från din lista.',
    'pref_two_factor_new_backup_codes'          => 'Generera nya engångskoder',
    'pref_two_factor_backup_code_count'         => 'Du har :count giltig backup kod.|Du har :count giltiga backup koder.',
    '2fa_i_have_them'                           => 'Sparade!',
    'warning_much_data'                         => ':days dagar med data kan ta ett tag att ladda.',
    'registered'                                => 'Din registrering lyckades!',
    'Default asset account'                     => 'Förvalt tillgångskonto',
    'no_budget_pointer'                         => 'Du verkar inte ha några budgetar än. Du bör skapa några på <a href="budgets">budgetar</a>-sidan. Budgetar kan hjälpa dig att hålla reda på utgifter.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Sparkonto',
    'Credit card'                               => 'Kreditkort',
    'source_accounts'                           => 'Källkonto|Källkonton',
    'destination_accounts'                      => 'Destination konto|Destination konton',
    'user_id_is'                                => 'Ditt användarid är <strong>:user</strong>',
    'field_supports_markdown'                   => 'Detta fält stödjer <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Om du behöver mer hjälp med att använda Firefly III, <a href="https://github.com/firefly-iii/firefly-iii/issues">öppna en ticket på GitHub</a>.',
    'reenable_intro_text'                       => 'Du kan också aktivera <a href="#" id="reenableGuidance">introduktionsguidningen</a>.',
    'intro_boxes_after_refresh'                 => 'Introduktionsrutorna dyker upp igen när du uppdaterar sidan.',
    'show_all_no_filter'                        => 'Visa alla transaktioner utan att gruppera dem efter datum.',
    'expenses_by_category'                      => 'Utgifter per kategori',
    'expenses_by_budget'                        => 'Utgifter per budget',
    'income_by_category'                        => 'Intäkter per kategori',
    'expenses_by_asset_account'                 => 'Kostnader per tillgångskonto',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Förlåt, Firefly III kan inte omdirigera dig till rätt sida.',
    'sum_of_expenses'                           => 'Summa av kostnader',
    'sum_of_income'                             => 'Summa av inkomst',
    'liabilities'                               => 'Skulder',
    'spent_in_specific_budget'                  => 'Spenderad budget ":budget"',
    'spent_in_specific_double'                  => 'Spenderat i kontot ":account"',
    'earned_in_specific_double'                 => 'Intjänat i kontot ":account"',
    'source_account'                            => 'Källkonto',
    'source_account_reconciliation'             => 'Du kan inte redigera källkontot för en avstämningstransaktion.',
    'destination_account'                       => 'Till konto',
    'destination_account_reconciliation'        => 'Du kan inte redigera destinationskontot för en avstämningstransaktion.',
    'sum_of_expenses_in_budget'                 => 'Spenderat totalt i budget ":budget"',
    'left_in_budget_limit'                      => 'Kvar att spender enligt budget',
    'current_period'                            => 'Nuvarande period',
    'show_the_current_period_and_overview'      => 'Visa nuvarande period och översikt',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => 'För att ett språk förutom Engelska ska fungera bra, behöver ditt operativsystem ha de rätta språkinställningarna. Annars kommer inte valuta information, datum och summor visas på rätt sätt.',
    'budget_in_period'                          => 'Alla transaktioner för budget ":name" mellan :start och :end för :currency',
    'chart_budget_in_period'                    => 'Diagram med alla transaktioner för budget ":name" mellan :start och :end för :currency',
    'chart_budget_in_period_only_currency'      => 'Summan du budgeterat var i :currency, detta diagram visar bara transaktioner i :currency.',
    'chart_account_in_period'                   => 'Diagram för alla transaktioner för kontot ":name" (:balance) mellan :start och :end',
    'chart_category_in_period'                  => 'Diagram med alla transaktioner för kategorin ":name" mellan :start och :end',
    'chart_category_all'                        => 'Diagram med alla transaktioner för kategorin ":name"',
    'clone_withdrawal'                          => 'Klona detta uttag',
    'clone_deposit'                             => 'Klona denna insättning',
    'clone_transfer'                            => 'Klona denna överföring',
    'multi_select_no_selection'                 => 'Inget valt',
    'multi_select_select_all'                   => 'Markera allt',
    'multi_select_n_selected'                   => 'vald',
    'multi_select_all_selected'                 => 'Allt valt',
    'multi_select_filter_placeholder'           => 'Sök..',
    'intro_next_label'                          => 'Nästa',
    'intro_prev_label'                          => 'Föregående',
    'intro_skip_label'                          => 'Hoppa över',
    'intro_done_label'                          => 'Klart',
    'between_dates_breadcrumb'                  => 'Mellan :start och :end',
    'all_journals_without_budget'               => 'Alla transaktioner utan en budget',
    'journals_without_budget'                   => 'Transaktioner utan budget',
    'all_journals_without_category'             => 'Alla transaktioner utan en kategori',
    'journals_without_category'                 => 'Transaktioner utan en kategori',
    'all_journals_for_account'                  => 'Alla transaktioner för konto :name',
    'chart_all_journals_for_account'            => 'Diagram med alla transaktioner för konto :name',
    'journals_in_period_for_account'            => 'Alla transaktioner för konto :name mellan :start och :end',
    'journals_in_period_for_account_js'         => 'Alla transaktioner för konto {title} mellan {start} och {end}',
    'transferred'                               => 'Överfört',
    'all_withdrawal'                            => 'All utgifter',
    'all_transactions'                          => 'Alla transaktioner',
    'title_withdrawal_between'                  => 'Alla utgifter mellan :start och :end',
    'all_deposit'                               => 'Alla intäkter',
    'title_deposit_between'                     => 'Alla intäkter mellan :start och :end',
    'all_transfers'                             => 'Alla överföringar',
    'title_transfers_between'                   => 'Alla överföringar mellan :start och :end',
    'all_transfer'                              => 'Alla överföringar',
    'all_journals_for_tag'                      => 'Alla överföringar märkta med ":tag"',
    'title_transfer_between'                    => 'Alla överföringar mellan :start och :end',
    'all_journals_for_category'                 => 'Alla transaktioner för kategori :name',
    'all_journals_for_budget'                   => 'Alla transaktioner för budget :name',
    'chart_all_journals_for_budget'             => 'Diagram med alla transaktioner för budget :name',
    'journals_in_period_for_category'           => 'Alla transaktioner för kategori :name mellan :start och :end',
    'journals_in_period_for_tag'                => 'Alla transaktioner märkta :tag mellan :start och :end',
    'not_available_demo_user'                   => 'Denna funktionen är inte tillgänglig för demo användare.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Källkontot "@source_name" accepterar bara transaktioner i @source_currency. Mottagarkontot "@dest_name" accepterar bara transaktioner i @dest_currencty. Du behöver ange det överförda beloppet korrekt i båda valutorna.',
    'transaction_data'                          => 'Transaktionsdata',
    'invalid_server_configuration'              => 'Ogiltig serverkonfiguration',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Snabbbyte',
    'sign_in_to_start'                          => 'Logga in för att börja din session',
    'sign_in'                                   => 'Logga in',
    'register_new_account'                      => 'Registrera ett nytt konto',
    'forgot_my_password'                        => 'Glömt mitt lösenord',
    'problems_with_input'                       => 'Det fanns program med din inmatning.',
    'reset_password'                            => 'Återställ ditt lösenord',
    'button_reset_password'                     => 'Återställ lösenord',
    'reset_button'                              => 'Återställ',
    'want_to_login'                             => 'Jag vill logga in',
    'login_page_title'                          => 'Logga in till Firefly III',
    'register_page_title'                       => 'Registrera hos Firefly III',
    'forgot_pw_page_title'                      => 'Glömt ditt lösenord till Firefly III',
    'reset_pw_page_title'                       => 'Återställ ditt lösenord för Firefly III',
    'cannot_reset_demo_user'                    => 'Går inte att återställa lösenordet för demo användaren.',
    'no_att_demo_user'                          => 'Demoanvändaren kan inte ladda upp bilagor.',
    'button_register'                           => 'Registrera',
    'authorization'                             => 'Auktorisering',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Förväntade dagliga kostnader',
    'per_period_sum_1W'                         => 'Förväntade veckokostnader',
    'per_period_sum_1M'                         => 'Förväntade månadskostnader',
    'per_period_sum_3M'                         => 'Förväntade kvartalskostnader',
    'per_period_sum_6M'                         => 'Förväntade halvårskostnader',
    'per_period_sum_1Y'                         => 'Förväntade årliga kostnader',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'total förväntad',
    'reconciliation_account_name'               => ':name avstämning (:currency)',
    'saved'                                     => 'Sparad',
    'advanced_options'                          => 'Avancerade alternativ',
    'advanced_options_explain'                  => 'Vissa sidor i Firefly III har avancerade alternativ gömda bakom den här knappen. Den här sidan har inget tjusigt här, men kolla in de andra!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhookar',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'inaktiverad',
    'no_webhook_messages'                       => 'There are no webhook messages',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Efter skapande av transaktion',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'After transaction update',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'After transaction delete',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaktionsdetaljer',
    'webhook_response_ACCOUNTS'                 => 'Kontodetaljer',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspektera',
    'create_new_webhook'                        => 'Create new webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Which format the webhook must deliver data in.',
    'webhook_active_form_help'                  => 'The webhook must be active or it won\'t be called.',
    'stored_new_webhook'                        => 'Stored new webhook ":title"',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'Visa meddelande',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Loggar',
    'response'                                  => 'Svar',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Auktorisationsbegäran',
    'authorization_request_intro'               => 'Applikationen "<strong>:client</strong>" begär behörighet att få tillgång till din ekonomiska administration. Vill du ge <strong>:client</strong> tillgång till dessa poster?',
    'authorization_request_site'                => 'Du kommer omdirigeras till <code>:url</code> som sedan kommer få tillgång till dina Firefly III-data.',
    'authorization_request_invalid'             => 'Denna begäran om åtkomst är ogiltig. Följ aldrig den här länken igen.',
    'scopes_will_be_able'                       => 'Detta program kommer att kunna:',
    'button_authorize'                          => 'Godkänn',
    'none_in_select_list'                       => '(Ingen)',
    'no_piggy_bank'                             => '(ingen spargris)',
    'name_in_currency'                          => ':name i :currency',
    'paid_in_currency'                          => 'Betalad i :currency',
    'unpaid_in_currency'                        => 'Obetalad i :currency',
    'is_alpha_warning'                          => 'Du kör en ALPHA-version. Var försiktig med buggar och problem.',
    'is_beta_warning'                           => 'Du kör en BETA-version. Var försiktig med buggar och problem.',
    'all_destination_accounts'                  => 'Destinationskonton',
    'all_source_accounts'                       => 'Källkonton',
    'back_to_index'                             => 'Åter till index',
    'cant_logout_guard'                         => 'Firefly III kan inte logga ut dig.',
    'internal_reference'                        => 'Intern referens',

    // check for updates:
    'update_check_title'                        => 'Sök uppdateringar',
    'admin_update_check_title'                  => 'Sök automatiskt efter uppdateringar',
    'admin_update_check_explain'                => 'Firefly III kan söka efter uppdateringar automatiskt. När du aktiverar denna inställning, kommer den kontakta Firefly III uppdateringsserver för att se om en ny version av Firefly III finns tillgänglig. När det gör det så får du en notifiering. Du kan testa dessa notifieringar via knappen till höger. Välj nedan om du vill att Firefly III ska automatiskt söka efter uppdateringar.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Fråga mig senare',
    'updates_do_not_check'                      => 'Sök inte efter uppdateringar',
    'updates_enable_check'                      => 'Aktivera för att leta efter uppdateringar',
    'admin_update_check_now_title'              => 'Sök efter uppdateringar nu',
    'admin_update_check_now_explain'            => 'Om du trycker på knappen, kontrollerar Firefly III om du har den senaste versionen.',
    'check_for_updates_button'                  => 'Kontrollera nu!',
    'update_new_version_alert'                  => 'En ny version av Firefly III är tillgänglig. Du har :your_version, den senaste är :new_version vilken släpptes :date.',
    'update_version_beta'                       => 'Denna version är en BETA version. Det kan förekomma problem.',
    'update_version_alpha'                      => 'Denna version är en ALPHA version. Det kan förekomma problem.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Du har :version, vilken är den senaste tillgängliga utgåva.',
    'update_newer_version_alert'                => 'Du har :your_version, vilken är nyare än senaste utgåva, :new_version.',
    'update_check_error'                        => 'Ett fel inträffade vid sökning efter uppdateringar: :error',
    'unknown_error'                             => 'Okänt fel. Ledsen för det.',
    'disabled_but_check'                        => 'Du inaktiverade uppdateringskontroll. Så glöm inte att söka efter uppdateringar själv då och då. Tack!',
    'admin_update_channel_title'                => 'Uppdatera kanal',
    'admin_update_channel_explain'              => 'Firefly III har tre uppdaterings "kanaler" som bestämmer hur frammåt i kurvan du är i form av funktioner, förbättringar och buggar. Använd "beta" kanalen om du är äventyrslysten och "alpha" om du tycket om att leva farligt.',
    'update_channel_stable'                     => 'Stabil. Allting fungerar som förväntat.',
    'update_channel_beta'                       => 'Beta. Nya funktioner men saker kan vara trasiga.',
    'update_channel_alpha'                      => 'Alpha. Vi kastar in saker, det som fastnar det fastnar.',

    // search
    'search'                                    => 'Sök',
    'search_query'                              => 'Fråga',
    'search_found_transactions'                 => 'Firefly III hittade :count transaktion i :time sekunder.|Firefly III hittade :count transaktioner i :time sekunder.',
    'search_found_more_transactions'            => 'Firefly III hittade mer än :count transaktioner i :time sekunder.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Sökparametrarna är inte giltiga och har ignorerats.',

    // old


    'search_modifier_date_on'                             => 'Transaction date is ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Transaktions ID är: ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'Transaktions datum är före eller på ":value"',
    'search_modifier_date_after'                          => 'Transaktions datum är efter eller på ":value"',
    'search_modifier_external_id_is'                      => 'External ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'External ID is not ":value"',
    'search_modifier_no_external_url'                     => 'Transaktionen saknar extern URL',
    'search_modifier_no_external_id'                      => 'The transaction has no external ID',
    'search_modifier_not_any_external_url'                => 'The transaction has no external URL',
    'search_modifier_not_any_external_id'                 => 'The transaction has no external ID',
    'search_modifier_any_external_url'                    => 'Transaktionen måste ha en extern URL (valfri)',
    'search_modifier_any_external_id'                     => 'The transaction must have a (any) external ID',
    'search_modifier_not_no_external_url'                 => 'The transaction must have a (any) external URL',
    'search_modifier_not_no_external_id'                  => 'The transaction must have a (any) external ID',
    'search_modifier_internal_reference_is'               => 'Internal reference is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Internal reference is not ":value"',
    'search_modifier_description_starts'                  => 'Description starts with ":value"',
    'search_modifier_not_description_starts'              => 'Description does not start with ":value"',
    'search_modifier_description_ends'                    => 'Description ends on ":value"',
    'search_modifier_not_description_ends'                => 'Description does not end on ":value"',
    'search_modifier_description_contains'                => 'Beskrivning innehåller ":value"',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Beskrivningen är ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => 'Transaktion (utländsk) valuta är ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Transaktion med utländsk valuta är ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'Transaktionen måste ha en bilaga',
    'search_modifier_has_no_category'                     => 'Transaktionen får inte ha någon kategori',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'Transaktionen måste ha (valfri) kategori',
    'search_modifier_has_no_budget'                       => 'Transaktionen får inte ha någon budget',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'Transaktionen måste ha (valfri) budget',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Transaktionen får inte ha några taggar',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'Transaktionen måste ha en (valfri) tagg',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Transaktionen saknar anteckningar',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'Transaktionen måste ha anteckningar',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Amount is exactly :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Beloppet är mindre än eller lika med :value',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Beloppet är mer än eller lika med :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Källkontonamn är exakt ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Källkontonamn innehåller ":value"',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Källkontonamn börjar med ":value"',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Källkontonamn slutar med ":value"',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'Källkonto ID är :value',
    'search_modifier_not_source_account_id'               => 'Source account ID is not :value',
    'search_modifier_source_account_nr_is'                => 'Källkontonummer (IBAN) är ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Source account number (IBAN) is not ":value"',
    'search_modifier_source_account_nr_contains'          => 'Källkontonummer (IBAN) innehåller ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Source account number (IBAN) does not contain ":value"',
    'search_modifier_source_account_nr_starts'            => 'Källkontonummer (IBAN) börjar med ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Source account number (IBAN) does not start with ":value"',
    'search_modifier_source_account_nr_ends'              => 'Source account number (IBAN) ends on ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Source account number (IBAN) does not end on ":value"',
    'search_modifier_destination_account_is'              => 'Destinationens kontonamn är exakt ":value"',
    'search_modifier_not_destination_account_is'          => 'Destination account name is not ":value"',
    'search_modifier_destination_account_contains'        => 'Destinationens kontonamn innehåller ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Destinationens kontonamn börjar med ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Destinationskonto ID är :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Destinationskontonummer (IBAN) är ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Destination account number (IBAN) is ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Destinationskontonummer (IBAN) innehåller ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Destinationskontonummer (IBAN) börjar med ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Destinationskontonummer (IBAN) slutar med ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Källa eller destinationskonto ID är/är: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Kategorin är ":value"',
    'search_modifier_not_category_is'                     => 'Category is not ":value"',
    'search_modifier_budget_is'                           => 'Budget är ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Transaktionstypen är ":value"',
    'search_modifier_not_transaction_type'                => 'Transaction type is not ":value"',
    'search_modifier_tag_is'                              => 'Taggen är ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transaction is in year ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Transaktionen är före eller under år ":value"',
    'search_modifier_date_before_month'                   => 'Transaktionen är före eller under månaden ":value"',
    'search_modifier_date_before_day'                     => 'Transaktionen är före eller på dagen i månaden ":value"',
    'search_modifier_date_after_year'                     => 'Transaktionen är i eller efter år ":value"',
    'search_modifier_date_after_month'                    => 'Transaktionen är i eller efter månad ":value"',
    'search_modifier_date_after_day'                      => 'Transaktionen är efter eller på dagen i månaden ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'No tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Category contains ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Category starts with ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budget contains ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budget ends with ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budget starts with ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Internal reference contains ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Internal reference does not contain ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Transaction has no attachments',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Transaction due date is in year ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Transaction was created in year ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Uppdatera regel ":rule" från sökfråga',
    'create_rule_from_query'                        => 'Skapa ny regel från sökfrågan',
    'rule_from_search_words'                        => 'Regelmotorn har svårt att hantera ":string". Den föreslagna regeln som passar din sökfråga kan ge olika resultat. Kontrollera regelutlösarna noggrant.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Ett fel uppstod vid sökning. Kontrollera loggfilerna för mer information.',
    'search_box'                                          => 'Sök',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Fel vid sökning',
    'search_searching'                                    => 'Söker ...',
    'search_results'                                      => 'Sökresultat',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'årligen',
    'repeat_freq_half-year'                               => 'varje halvår',
    'repeat_freq_quarterly'                               => 'kvartal',
    'repeat_freq_monthly'                                 => 'månadsvis',
    'repeat_freq_weekly'                                  => 'veckovis',
    'repeat_freq_daily'                                   => 'dagligen',
    'daily'                                               => 'dagligen',
    'weekly'                                              => 'veckovis',
    'quarterly'                                           => 'kvartal',
    'half-year'                                           => 'varje halvår',
    'yearly'                                              => 'årligen',

    // rules
    'is_not_rule_trigger'                                 => 'Not',
    'cannot_fire_inactive_rules'                          => 'Du kan inte köra inaktiva regler.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Regler',
    'rule_name'                                           => 'Namn på regel',
    'rule_triggers'                                       => 'Regel triggas när',
    'rule_actions'                                        => 'Regel kommer',
    'new_rule'                                            => 'Ny regel',
    'new_rule_group'                                      => 'Ny regel grupp',
    'rule_priority_up'                                    => 'Ge regel mer prioritet',
    'rule_priority_down'                                  => 'Ge regel mindre prioritet',
    'make_new_rule_group'                                 => 'Skapa ny regelgrupp',
    'store_new_rule_group'                                => 'Spara ny regelgrupp',
    'created_new_rule_group'                              => 'Ny regelgrupp ":title" sparad!',
    'updated_rule_group'                                  => 'Lyckades uppdatera regelgrupp ":title".',
    'edit_rule_group'                                     => 'Ändra regelgrupp ":title"',
    'duplicate_rule'                                      => 'Duplicera regel ":title"',
    'rule_copy_of'                                        => 'Kopia av ":title"',
    'duplicated_rule'                                     => 'Duplicerad regel ":title" till ":newTitle"',
    'delete_rule_group'                                   => 'Ta bort regelgrupp ":title"',
    'deleted_rule_group'                                  => 'Tog bort regelgrupp ":title"',
    'update_rule_group'                                   => 'Uppdatera regelgrupp',
    'no_rules_in_group'                                   => 'Inga regler i denna grupp',
    'move_rule_group_up'                                  => 'Flytta upp regelgrupp',
    'move_rule_group_down'                                => 'Flytta ned regelgrupp',
    'save_rules_by_moving'                                => 'Spara denna regel genom att flytta den till en annan regelgrupp:|Spara dessa regler genom att flytta dem till en annan regelgrupp:',
    'make_new_rule'                                       => 'Skapa en ny regel i regelgrupp ":title"',
    'make_new_rule_no_group'                              => 'Skapa en ny regel',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Skapa en regel baserad på en av dina transaktioner. Komplettera eller skicka formuläret nedan.',
    'rule_is_strict'                                      => 'strikt regel',
    'rule_is_not_strict'                                  => 'icke-strikt regel',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'Med strikta regler måste ALLA utlösare köras för att åtgärd(erna) ska genomföras. Med icke-strikta regler är vilken trigger som helst nog för att åtgärd(erna) ska genomföras.',
    'rule_help_active'                                    => 'Inaktiva regler körs aldrig.',
    'stored_new_rule'                                     => 'Sparade ny regel med titel ":title"',
    'deleted_rule'                                        => 'Tog bort regel med titel ":title"',
    'store_new_rule'                                      => 'Spara ny regel',
    'updated_rule'                                        => 'Uppdaterade regel med titel ":title"',
    'default_rule_group_name'                             => 'Standard regler',
    'default_rule_group_description'                      => 'Alla dina regler inte i en viss grupp.',
    'trigger'                                             => 'Utlösare',
    'trigger_value'                                       => 'Utlösare på värde',
    'stop_processing_other_triggers'                      => 'Sluta bearbeta andra utlösare',
    'add_rule_trigger'                                    => 'Lägg till utlösare',
    'action'                                              => 'Händelse',
    'action_value'                                        => 'Åtgärdsvärde',
    'stop_executing_other_actions'                        => 'Sluta köra andra åtgärder',
    'add_rule_action'                                     => 'Lägg till ny åtgärd',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Ta bort regel ":title"',
    'update_rule'                                         => 'Uppdatera regel',
    'test_rule_triggers'                                  => 'Se matchande transaktioner',
    'warning_no_matching_transactions'                    => 'Inga matchande transaktioner hittades.',
    'warning_no_valid_triggers'                           => 'Inga giltiga händelser tillhandahållna.',
    'apply_rule_selection'                                => 'Tillämpa regel ":title" till ditt val av transaktioner',
    'apply_rule_selection_intro'                          => 'Regler som ":title" används normalt bara för nya eller uppdaterade transaktioner, men du kan få Firefly III att köra det på ett utval av nuvarande transaktioner. Detta kan vara användbart när du har uppdaterat en regel ändringen behöver göras på alla dina transaktioner.',
    'include_transactions_from_accounts'                  => 'Inkludera transaktioner från dessa konton',
    'include'                                             => 'Inkludera?',
    'applied_rule_selection'                              => '{0} Inga transaktioner i ditt urval ändrades av regeln ":title".|[1] En transaktion i ditt urval ändrades av regeln ":title".|[2,*] :count transaktioner i ditt urval ändrades av regeln ":title".',
    'execute'                                             => 'Utför',
    'apply_rule_group_selection'                          => 'Tillämpa regel grupp ":title" till dit val av transaktioner',
    'apply_rule_group_selection_intro'                    => 'Regelgrupper som ":title" används normalt bara för nya eller uppdaterade transaktioner, men du kan få Firefly III att köra alla regler i gruppen på ett utval av nuvarande transaktioner. Detta är användbart när du har uppdaterat en grupp med regler och dessa förändringar behöver göras på alla dina andra transaktioner.',
    'applied_rule_group_selection'                        => 'Regelgrupp ":title" har tillämpats på ditt val.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'När en transaktion skapas',
    'rule_trigger_update_journal'                         => 'När en transaktion uppdateras',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Användaråtgärd är ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Källkontonamn börjar med..',
    'rule_trigger_source_account_starts'                  => 'Källkontonamn börjar med ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Källkontonamn slutar med..',
    'rule_trigger_source_account_ends'                    => 'Källkontonamn slutar med ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Källkontonamn är..',
    'rule_trigger_source_account_is'                      => 'Källkontonamn är ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Källkontonamn innehåller..',
    'rule_trigger_source_account_contains'                => 'Källkontonamn innehåller ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Källkonto-ID är exakt..',
    'rule_trigger_source_account_id'                      => 'Källkonto-ID är exakt :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Destination konto-ID är exakt..',
    'rule_trigger_destination_account_id'                 => 'Destinationskonto ID är exakt :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Källkonto är (kontant) konto',
    'rule_trigger_source_is_cash'                         => 'Källkonto är (kontant) konto',
    'rule_trigger_destination_is_cash_choice'             => 'Destinationskonto är (kontant) konto',
    'rule_trigger_destination_is_cash'                    => 'Destinationskonto är (kontant) konto',
    'rule_trigger_source_account_nr_starts_choice'        => 'Källkontonummer / IBAN börjar med..',
    'rule_trigger_source_account_nr_starts'               => 'Källkontonummer / IBAN börjar med ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Källkontonummer / IBAN slutar med..',
    'rule_trigger_source_account_nr_ends'                 => 'Källkontonummer / IBAN slutar med ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Källkontonummer / IBAN är..',
    'rule_trigger_source_account_nr_is'                   => 'Källkontonummer / IBAN är ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Källkontonummer / IBAN innehåller..',
    'rule_trigger_source_account_nr_contains'             => 'Källkontonummer / IBAN innehåller ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Destinationskontonamn börjar med..',
    'rule_trigger_destination_account_starts'             => 'Destinationskontonamn börjar med ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Destinationskontonamn slutar med..',
    'rule_trigger_destination_account_ends'               => 'Destinationskontonamn slutar med ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Destinationskontonamn är..',
    'rule_trigger_destination_account_is'                 => 'Destinationskontonamn är ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Destinationenskontonamn innehåller..',
    'rule_trigger_destination_account_contains'           => 'Destinationenskontonamn innehåller ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Destinationskontonummer/IBAN börjar med..',
    'rule_trigger_destination_account_nr_starts'          => 'Destinationskontonummer / IBAN börjar med ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Destinationskontonummer / IBAN slutar med..',
    'rule_trigger_destination_account_nr_ends'            => 'Destinationskontonummer / IBAN slutar med ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Destinationskontonummer / IBAN är..',
    'rule_trigger_destination_account_nr_is'              => 'Destinationskontonummer / IBAN är ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Destinationskontonummer / IBAN innehåller..',
    'rule_trigger_destination_account_nr_contains'        => 'Destinationskontonummer / IBAN innehåller ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transaktion är av typen..',
    'rule_trigger_transaction_type'                       => 'Transaktion är av typen ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategori är..',
    'rule_trigger_category_is'                            => 'Kategori är ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Amount is..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Beskrivning börjar med..',
    'rule_trigger_description_starts'                     => 'Beskrivning börjar med ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Beskrivning slutar med..',
    'rule_trigger_description_ends'                       => 'Beskrivning slutar med ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Beskrivningen innehåller..',
    'rule_trigger_description_contains'                   => 'Beskrivning innehåller ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Beskrivning är..',
    'rule_trigger_description_is'                         => 'Beskrivning är ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transaction date is..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transaktionsdatum är innan..',
    'rule_trigger_date_before'                            => 'Transaktionsdatum är före ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transaktionsdatum är efter..',
    'rule_trigger_date_after'                             => 'Transaktionsdatum är efter ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budget är..',
    'rule_trigger_budget_is'                              => 'Budget är ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transaktionsvalutan är..',
    'rule_trigger_currency_is'                            => 'Transaktionsvalutan är ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transaktion med utländsk valuta är..',
    'rule_trigger_foreign_currency_is'                    => 'Transaktion med utländsk valuta är ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Har ingen kategori',
    'rule_trigger_has_no_category'                        => 'Transaktion saknar kategori',
    'rule_trigger_has_any_category_choice'                => 'Har en (valfri) kategori',
    'rule_trigger_has_any_category'                       => 'Transaktion har (valfri) kategori',
    'rule_trigger_has_no_budget_choice'                   => 'Saknar budget',
    'rule_trigger_has_no_budget'                          => 'Transaktion saknar budget',
    'rule_trigger_has_any_budget_choice'                  => 'Har (valfri) budget',
    'rule_trigger_has_any_budget'                         => 'Transaktion har (valfri) budget',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Saknar etikett(er)',
    'rule_trigger_has_no_tag'                             => 'Transaktion saknar etikett(er)',
    'rule_trigger_has_any_tag_choice'                     => 'Har en eller flera (valfria) etiketter',
    'rule_trigger_has_any_tag'                            => 'Transaktion har en eller flera (valfria) etiketter',
    'rule_trigger_any_notes_choice'                       => 'Har (valfria) anteckningar',
    'rule_trigger_any_notes'                              => 'Transaktion har (valfria) anteckningar',
    'rule_trigger_no_notes_choice'                        => 'Har inga anteckningar',
    'rule_trigger_no_notes'                               => 'Transaktion saknar anteckningar',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transaktionsjournal-ID är..',
    'rule_trigger_journal_id'                             => 'Transaktionsjournal-ID är ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Transaktionen saknar extern URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Transaktions-ID är..',
    'rule_trigger_id'                                     => 'Transaktions-ID är ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Har inga bilagor',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Sätt kategori till ":action_value"',
    'rule_action_clear_category'                 => 'Rensa kategori',
    'rule_action_set_budget'                     => 'Sätt budget till ":action_value"',
    'rule_action_clear_budget'                   => 'Rensa budget',
    'rule_action_add_tag'                        => 'Lägg till etikett ":action_value"',
    'rule_action_remove_tag'                     => 'Ta bort etikett ":action_value"',
    'rule_action_remove_all_tags'                => 'Ta bort alla etiketter',
    'rule_action_set_description'                => 'Sätt beskrivning till ":action_value"',
    'rule_action_append_description'             => 'Lägg till beskrivning med ":action_value"',
    'rule_action_prepend_description'            => 'Förbered beskrivning med ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Rensa alla kategorier',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Rensa alla budgetar',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Ta bort alla etiketter',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Sätt källkonto till :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Sätt destinationskonto till :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Lägg till anteckningar med ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Förbered anteckningar med ":action_value"',
    'rule_action_clear_notes_choice'             => 'Ta bort alla anteckningar',
    'rule_action_clear_notes'                    => 'Ta bort alla anteckningar',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Sätt anteckningar till ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Konvertera transaktionen till en insättning',
    'rule_action_convert_deposit'                => 'Konvertera transaktionen till en insättning från ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Konvertera transaktionen till ett uttag',
    'rule_action_convert_withdrawal'             => 'Konvertera transaktionen till ett uttag från ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Gör transaktionen till en överföring',
    'rule_action_convert_transfer'               => 'Gör transaktionen till en överföring med ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Regel baserad på transaktionen ":description"',
    'new_rule_for_journal_description'          => 'Den här regeln är baserad på transaktionen ":description". Den kommer matcha transaktioner som är exakt likadana.',

    // tags
    'store_new_tag'                             => 'Spara ny etikett',
    'update_tag'                                => 'Uppdatera etikett',
    'no_location_set'                           => 'Ingen plats inställd.',
    'meta_data'                                 => 'Metadata',
    'location'                                  => 'Plats',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Utan datum',
    'result'                                    => 'Resultat',
    'sums_apply_to_range'                       => 'Alla summor gäller för valt intervall',
    'mapbox_api_key'                            => 'För att använda karta, hämta en API nyckel från <a href="https://www.mapbox.com/">Mapbox</a>. Öppna din <code>.env</code> fil och ange koden efter <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Högerklicka eller långtryck för att ställa in objektets plats.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Rena plats',
    'delete_all_selected_tags'                  => 'Ta bort alla markerade etiketter',
    'select_tags_to_delete'                     => 'Glöm inte att välja några etiketter.',
    'deleted_x_tags'                            => 'Tog bort :count tag.|Tog bort :count taggar.',
    'create_rule_from_transaction'              => 'Skapa regel baserad på transaktion',
    'create_recurring_from_transaction'         => 'Skapa återkommande transaktion baserat på transaktion',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Låt din webbläsare bestämma',
    'dark_mode_option_light'                    => 'Alltid ljust',
    'dark_mode_option_dark'                     => 'Alltid mörkt',
    'equal_to_language'                         => '(lika med språk)',
    'dark_mode_preference'                      => 'Mörkt läge',
    'dark_mode_preference_help'                 => 'Berätta för Firefly III när mörkt läge ska användas.',
    'pref_home_screen_accounts'                 => 'Startskäm konton',
    'pref_home_screen_accounts_help'            => 'Vilka konton ska visas på startskärmen?',
    'pref_view_range'                           => 'Visa intervall',
    'pref_view_range_help'                      => 'Vissa diagram grupperas automatiskt i perioder. Dina budgetar grupperas också i perioder. Vilken period föredrar du?',
    'pref_1D'                                   => 'En dag',
    'pref_1W'                                   => 'En vecka',
    'pref_1M'                                   => 'En månad',
    'pref_3M'                                   => 'Tre månader (kvartal)',
    'pref_6M'                                   => 'Sex månader',
    'pref_1Y'                                   => 'Ett år',
    'pref_last365'                              => 'Föregående år',
    'pref_last90'                               => 'Senaste 90 dagarna',
    'pref_last30'                               => 'Senaste 30 dagarna',
    'pref_last7'                                => 'Senaste 7 dagarna',
    'pref_YTD'                                  => 'Hittills i år',
    'pref_QTD'                                  => 'Kvartal hittills',
    'pref_MTD'                                  => 'Månad hittills',
    'pref_languages'                            => 'Språk',
    'pref_locale'                               => 'Nationella inställningar',
    'pref_languages_help'                       => 'Firefly III stödjer flera språk. Vilket föredrar du?',
    'pref_locale_help'                          => 'Firefly III låter dig ställa in andra lokala inställningar, som hur valutor, siffror och datum formateras. Poster i denna lista kanske inte stöds av ditt system. Firefly III har inte rätt datuminställningar för varje lokal; kontakta mig för förbättringar.',
    'pref_locale_no_demo'                       => 'Denna funktion fungerar inte för demoanvändaren.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Räkneskapsårs inställningar',
    'pref_custom_fiscal_year_label'             => 'Aktiverad',
    'pref_custom_fiscal_year_help'              => 'I länder som använder räkneskapsår annat än 1a Januari till 31a December, går det att ändra detta och välja start / slut dagar för räkneskapsåret',
    'pref_fiscal_year_start_label'              => 'Startdatum för räkneskapsår',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Glöm inte att ta bort kontot från din autentiseringsapp!',
    'pref_two_factor_auth_code'                 => 'Verifiera kod',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Nollställ verifieringskod',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'Om du inte kan scanna QR koden, använd denna hemliga istället <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Spara dessa backup koder för åtkomst ifall du tappar bort din enhet.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'MFA-koden är inte giltig.',
    'pref_save_settings'                        => 'Spara inställningar',
    'saved_preferences'                         => 'Inställningar sparade!',
    'preferences_general'                       => 'Allmänt',
    'preferences_frontpage'                     => 'Startsidan',
    'preferences_security'                      => 'Säkerhet',
    'preferences_layout'                        => 'Layout',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Visa insättningar på startskärmen',
    'pref_home_show_deposits_info'              => 'Startskärmen visar redan dina utgiftskonton. Ska den även visa intäktskonton?',
    'pref_home_do_show_deposits'                => 'Ja, visa dem',
    'successful_count'                          => 'av :count framgångsrikt',
    'list_page_size_title'                      => 'Sidstorlek',
    'list_page_size_help'                       => 'Alla listor med (konton, transaktioner, etc) visar som mest så här många per sida.',
    'list_page_size_label'                      => 'Sidstorlek',
    'between_dates'                             => '(:start och :end)',
    'pref_optional_fields_transaction'          => 'Alternativa fält för transaktioner',
    'pref_optional_fields_transaction_help'     => 'Per default är inte alla fält aktiverade vid skapande av en ny transaktion (underlätta röran). Nedanför går det att aktivera dessa fält om de är användbara för dig. Självklar, ett fält som är ifyllt men inaktiverat, visas oavsett denna inställning.',
    'optional_tj_date_fields'                   => 'Datumfält',
    'optional_tj_other_fields'                  => 'Andra fält',
    'optional_tj_attachment_fields'             => 'Bilagefält',
    'pref_optional_tj_interest_date'            => 'Räntedatum',
    'pref_optional_tj_book_date'                => 'Bokföringsdatum',
    'pref_optional_tj_process_date'             => 'Behandlingsdatum',
    'pref_optional_tj_due_date'                 => 'Förfallodatum',
    'pref_optional_tj_payment_date'             => 'Betalningsdatum',
    'pref_optional_tj_invoice_date'             => 'Fakturadatum',
    'pref_optional_tj_internal_reference'       => 'Intern referens',
    'pref_optional_tj_notes'                    => 'Anteckningar',
    'pref_optional_tj_attachments'              => 'Bilagor',
    'pref_optional_tj_external_url'             => 'Extern URL',
    'pref_optional_tj_location'                 => 'Plats',
    'pref_optional_tj_links'                    => 'Transaktionslänkar',
    'optional_field_meta_dates'                 => 'Datum',
    'optional_field_meta_business'              => 'Affärsverksamhet',
    'optional_field_attachments'                => 'Bilagor',
    'optional_field_meta_data'                  => 'Valfri metadata',
    'external_url'                              => 'Extern URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Radera data från Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Alla dina andra sessioner har loggats ut.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Radera oanvända konton',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Ta bort ALLA dina budgetar',
    'delete_all_categories'                     => 'Ta bort ALLA dina kategorier',
    'delete_all_tags'                           => 'Ta bort ALLA etiketter',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Ta bort ALLA dina spargrisar',
    'delete_all_rules'                          => 'Ta bort ALLA dina regler',
    'delete_all_recurring'                      => 'Ta bort ALLA dina återkommande transaktioner',
    'delete_all_object_groups'                  => 'Ta bort ALLA dina objektgrupper',
    'delete_all_accounts'                       => 'Ta bort ALLA dina konton',
    'delete_all_asset_accounts'                 => 'Ta bort ALLA dina tillgångskonton',
    'delete_all_expense_accounts'               => 'Ta bort ALLA dina utgiftskonton',
    'delete_all_revenue_accounts'               => 'Ta bort ALLA dina intäktskonton',
    'delete_all_liabilities'                    => 'Ta bort ALLA dina skulder',
    'delete_all_transactions'                   => 'Ta bort ALLA dina transaktioner',
    'delete_all_withdrawals'                    => 'Ta bort ALLA dina uttag',
    'delete_all_deposits'                       => 'Ta bort ALLA dina insättningar',
    'delete_all_transfers'                      => 'Ta bort ALLA dina överföringar',
    'also_delete_transactions'                  => 'Att ta bort konton kommer också ta bort ALLA associerade uttag, insättningar och överföringar!',
    'deleted_all_budgets'                       => 'Alla budgetar har raderats',
    'deleted_all_categories'                    => 'Alla kategorier har tagits bort',
    'deleted_all_tags'                          => 'Alla etiketter har tagits bort',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Alla spargrisar har tagits bort',
    'deleted_all_rules'                         => 'Alla regler och regelgrupper har tagits bort',
    'deleted_all_object_groups'                 => 'Alla grupper har tagits bort',
    'deleted_all_accounts'                      => 'Alla konton har tagits bort',
    'deleted_all_asset_accounts'                => 'Alla tillgångskonton har tagits bort',
    'deleted_all_expense_accounts'              => 'Alla utgiftskonton har tagits bort',
    'deleted_all_revenue_accounts'              => 'Alla intäktskonton har tagits bort',
    'deleted_all_liabilities'                   => 'Alla skulder har tagits bort',
    'deleted_all_transactions'                  => 'Alla transaktioner har tagits bort',
    'deleted_all_withdrawals'                   => 'Alla uttag har tagits bort',
    'deleted_all_deposits'                      => 'Alla insättningar har tagits bort',
    'deleted_all_transfers'                     => 'Alla överföringar har tagits bort',
    'deleted_all_recurring'                     => 'Alla återkommande transaktioner har tagits bort',
    'change_your_password'                      => 'Ändra ditt lösenord',
    'delete_account'                            => 'Ta bort konto',
    'current_password'                          => 'Nuvarande lösenord',
    'new_password'                              => 'Nytt lösenord',
    'new_password_again'                        => 'Repetera lösenord',
    'delete_your_account'                       => 'Radera ditt konto',
    'delete_your_account_help'                  => 'Radering av ditt konto tar även bort alla konton, transaktioner, <em>allt</em> du kan ha sparat i Firefly III. Det kommer att vara BORTA.',
    'delete_your_account_password'              => 'Ange ditt lösenord för att fortsätta.',
    'password'                                  => 'Lösenord',
    'are_you_sure'                              => 'Är du säker? Du kan inte ångra detta.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'TA BORT ditt konto',
    'invalid_current_password'                  => 'Ogiltigt nuvarande lösenord!',
    'password_changed'                          => 'Lösenordet har ändrats!',
    'should_change'                             => 'Tanken är att byta ditt lösenord.',
    'invalid_password'                          => 'Ogiltigt lösenord!',
    'what_is_pw_security'                       => 'Vad är "verifiera lösenordssäkerhet"?',
    'secure_pw_title'                           => 'Hur man väljer ett säkert lösenord',
    'forgot_password_response'                  => 'Tack. Om ett konto finns med denna e-postadress, hittar du instruktioner i din inkorg.',
    'secure_pw_history'                         => 'Det går inte en vecka utan att man läser i nyheterna om en sida som förlorat lösenord till sina användare. Hackare och tjuvar använder dessa lösenord för att stjäla din privata information. Denna information är värdefull.',
    'secure_pw_ff'                              => 'Använder du samma lösenord överallt på internet? Om en av dessa sidor förlorar ditt lösenord, så har hackare åtkomst till all din data. Firefly III förlitar sig att du väljer ett starkt och unikt lösenord för att skydda dina ekonomiska uppgifter.',
    'secure_pw_check_box'                       => 'För att hjälpa dig så kan Firefly III kontrollera om lösenordet du vill använda blivit stulet tidigare. Om detta är fallet, kommer Firefly III råda dig att INTE använda det lösenordet.',
    'secure_pw_working_title'                   => 'Hur fungerar det?',
    'secure_pw_working'                         => 'Kryssa i rutan, Firefly III kommer att skicka de fem första tecknen i SHA1 hash av ditt lösenord till <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">webbsidan av Troy Hunt</a> för att se om det finns med på listan. Detta kommer att stoppa dig från att använda osäkra lösenord vilket rekommenderas i den senaste <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> om ämnet.',
    'secure_pw_should'                          => 'Borde jag kryssa i rutan?',
    'secure_pw_long_password'                   => 'Ja. Verifiera alltid att ditt lösenord är säkert.',
    'command_line_token'                        => 'Kommandoradstoken',
    'explain_command_line_token'                => 'Du behöver denna token för att utföra kommandoradsalternativ, till exempel exportera data. Utan det kommer det känsliga kommandot inte att fungera. Dela inte din kommandoradssymbol. Ingen kommer att be er om detta tecken, inte ens jag. Om du är rädd för att du förlorade detta, eller när du är paranoid, regenerera denna token med hjälp av knappen.',
    'regenerate_command_line_token'             => 'Återskapa kommandoradstoken',
    'token_regenerated'                         => 'En ny kommandoradstoken har skapats',
    'change_your_email'                         => 'Ändra din e-postadress',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Tills e-postadress blivit verifierad, så kan du inte logga in.',
    'login_with_new_email'                      => 'Du kan nu logga in med din nya epost-adress.',
    'login_with_old_email'                      => 'Du kan nu logga in med din gamla epost-adress igen.',
    'login_provider_local_only'                 => 'Denna åtgärd är inte tillgänlig vid autentisiering genom ":login_provider".',
    'external_user_mgt_disabled'                => 'Denna åtgärd är inte tillgänglig när Firefly III inte är ansvarig för användarhantering eller autentiseringshantering.',
    'external_auth_disabled'                    => 'Denna åtgärd är inte tillgänglig när Firefly III inte är ansvarig för autentiseringshantering.',
    'delete_local_info_only'                    => "Eftersom Firefly III inte är ansvarig för användarhantering eller autentiseringshantering, kommer denna funktion endast ta bort lokal Firefly III-information.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth klienter',
    'profile_oauth_no_clients'                  => 'Du har inte skapat några OAuth klienter.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Klienter',
    'profile_oauth_client_id'                   => 'Klient ID',
    'profile_oauth_client_name'                 => 'Namn',
    'profile_oauth_client_secret'               => 'Hemlighet',
    'profile_oauth_create_new_client'           => 'Skapa ny klient',
    'profile_oauth_create_client'               => 'Skapa klient',
    'profile_oauth_edit_client'                 => 'Redigera klient',
    'profile_oauth_name_help'                   => 'Något som dina användare kommer att känna igen och lita på.',
    'profile_oauth_redirect_url'                => 'Omdirigera URL',
    'profile_oauth_redirect_url_help'           => 'Din applikations auktorisering callback URL.',
    'profile_authorized_apps'                   => 'Auktoriserade applikationer',
    'profile_authorized_clients'                => 'Auktoriserade klienter',
    'profile_scopes'                            => 'Omfattningar',
    'profile_revoke'                            => 'Återkalla',
    'profile_oauth_client_secret_title'         => 'Klienthemlighet',
    'profile_oauth_client_secret_expl'          => 'Här är din nya klient hemlighet. Detta är den enda gången det kommer att visas så förlora inte det! Du kan nu använda denna hemlighet för att göra API-förfrågningar.',
    'profile_personal_access_tokens'            => 'Personliga åtkomst-Tokens',
    'profile_personal_access_token'             => 'Personlig åtkomsttoken',
    'profile_oauth_confidential'                => 'Konfidentiell',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Här är din nya personliga tillgångs token. Detta är den enda gången det kommer att visas så förlora inte det! Du kan nu använda denna token för att göra API-förfrågningar.',
    'profile_no_personal_access_token'          => 'Du har inte skapat några personliga åtkomsttokens.',
    'profile_create_new_token'                  => 'Skapa ny token',
    'profile_create_token'                      => 'Skapa token',
    'profile_create'                            => 'Skapa',
    'profile_save_changes'                      => 'Spara ändringar',
    'profile_whoops'                            => 'Hoppsan!',
    'profile_something_wrong'                   => 'Något gick fel!',
    'profile_try_again'                         => 'Något gick fel. Försök igen.',
    'amounts'                                   => 'Belopp',
    'multi_account_warning_unknown'             => 'Beroende på vilken typ av transaktion du skapar, källan och/eller destinationskontot för efterföljande delningar kan åsidosättas av vad som än definieras i den första delningen av transaktionen.',
    'multi_account_warning_withdrawal'          => 'Tänk på att källkontot för efterföljande uppdelningar kommer att upphävas av vad som än definieras i den första uppdelningen av uttaget.',
    'multi_account_warning_deposit'             => 'Tänk på att destinationskontot för efterföljande uppdelningar kommer att styras av vad som än definieras i den första uppdelningen av insättningen.',
    'multi_account_warning_transfer'            => 'Tänk på att käll + destinationskonto av efterföljande delningar kommer att styras av vad som definieras i den första uppdelningen av överföringen.',


    // export data:
    'export_data_title'                         => 'Exportera data från Firefly III',
    'export_data_menu'                          => 'Exportera data',
    'export_data_bc'                            => 'Exportera data från Firefly III',
    'export_data_main_title'                    => 'Exportera data från Firefly III',
    'export_data_expl'                          => 'Denna länk låter dig exportera alla transaktioner + meta data från Firefly III. Se hjälpen (högst upp till höger (?)-ikonen) för mer information om processen.',
    'export_data_all_transactions'              => 'Exportera alla transaktioner',
    'export_data_advanced_expl'                 => 'Om du behöver en mer avancerad eller specifik typ av export, läs hjälpen om hur man använder konsolkommandot <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'En bilaga|:count bilagor',
    'attachments'                               => 'Bilagor',
    'edit_attachment'                           => 'Ändra bilaga ":name"',
    'update_attachment'                         => 'Uppdatera bifogad fil',
    'delete_attachment'                         => 'Ta bort bilaga ":name"',
    'attachment_deleted'                        => 'Tog bort bilaga ":name"',
    'liabilities_deleted'                       => 'Raderat skuld ":name"',
    'attachment_updated'                        => 'Uppdaterat bilaga ":name"',
    'upload_max_file_size'                      => 'Maximal filstorlek är :size',
    'list_all_attachments'                      => 'Lista alla bilagor',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Utgifter',
    'title_withdrawal'                          => 'Utgifter',
    'title_revenue'                             => 'Intäkter / inkomst',
    'title_deposit'                             => 'Intäkter / inkomst',
    'title_transfer'                            => 'Överföringar',
    'title_transfers'                           => 'Överföringar',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Transaktionen är redan ett uttag',
    'convert_is_already_type_Deposit'           => 'Transaktionen är redan en insättning',
    'convert_is_already_type_Transfer'          => 'Transaktionen är redan en överföring',
    'convert_to_Withdrawal'                     => 'Konvertera ":description" till ett uttag',
    'convert_to_Deposit'                        => 'Konvertera ":description" till en insättning',
    'convert_to_Transfer'                       => 'Konvertera ":description" till en överföring',
    'convert_options_WithdrawalDeposit'         => 'Konvertera ett uttag till en insättning',
    'convert_options_WithdrawalTransfer'        => 'Konvertera ett uttag till en överföring',
    'convert_options_DepositTransfer'           => 'Konvertera en insättning till en överföring',
    'convert_options_DepositWithdrawal'         => 'Konvertera en insättning till ett uttag',
    'convert_options_TransferWithdrawal'        => 'Konvertera en överföring till ett uttag',
    'convert_options_TransferDeposit'           => 'Konvertera överföring till en insättning',
    'convert_Withdrawal_to_deposit'             => 'Konvertera detta uttg till en insättning',
    'convert_Withdrawal_to_transfer'            => 'Konvertera detta uttag till en överföring',
    'convert_Deposit_to_withdrawal'             => 'Konvertera denna insättning till ett uttag',
    'convert_Deposit_to_transfer'               => 'Konvertera denna insättning till överföring',
    'convert_Transfer_to_deposit'               => 'Konvertera överföring till en insättning',
    'convert_Transfer_to_withdrawal'            => 'Konvertera överföring till ett uttag',
    'convert_please_set_revenue_source'         => 'Vänligen välj intäktskonto där pengarna kommer från.',
    'convert_please_set_asset_destination'      => 'Välj tillgångskonto pengarna kommer att gå till.',
    'convert_please_set_expense_destination'    => 'Välj utgiftskonto som pengarna går till.',
    'convert_please_set_asset_source'           => 'Välj tillgångskonto pengarna kommer från.',
    'convert_expl_w_d'                          => 'När du konverterar från ett uttag till en insättning, kommer pengarna att deponeras till det visade destinationskontot, istället för att tas ut från det. När du konverterar från ett uttag till en insättning, kommer pengarna att deponeras till de visade destinationskontona, istället för att tas ut från dem.',
    'convert_expl_w_t'                          => 'När du konverterar ett uttag till en överföring, pengarna överförs från källkontot till annat tillgångs- eller ansvarskonto istället för att spenderas på det ursprungliga utgiftskontot.|När du konverterar ett uttag till en överföring, pengarna överförs från källräkenskaperna till andra tillgångs- eller ansvarskonton istället för att spenderas på de ursprungliga kostnadskontona.',
    'convert_expl_d_w'                          => 'När du konverterar en insättning till ett uttag kommer pengarna att tas ut från det visade källkontot istället för att deponeras till det.|När du konverterar en insättning till ett uttag kommer pengarna att tas ut från de visade källkontona istället för att deponeras till dem.',
    'convert_expl_d_t'                          => 'När du konverterar en insättning till en överföring, pengarna kommer att sättas in på det angivna destinationskontot från något av ditt tillgångs- eller ansvarskonto.|När du konverterar en insättning till en överföring, pengarna kommer att sättas in på de angivna destinationskontona från någon av dina tillgångs- eller ansvarskonton.',
    'convert_expl_t_w'                          => 'När du konverterar en överföring till ett uttag kommer pengarna att spenderas på det destinationskonto du anger här, istället för att överföras bort.|När du konverterar en överföring till ett uttag kommer pengarna att spenderas på de destinationskonton du anger här, istället för att överföras bort.',
    'convert_expl_t_d'                          => 'När du konverterar från ett uttag till en insättning, kommer pengarna att deponeras till det visade destinationskontot, istället för att tas ut från det.|När du konverterar från ett uttag till en insättning, kommer pengarna att deponeras till de visade destinationskontona, istället för att tas ut från dem.',
    'convert_select_sources'                    => 'För att slutföra konverteringen, ange det nya källkontot nedan.|För att slutföra konverteringen, vänligen ange de nya källkontona nedan.',
    'convert_select_destinations'               => 'För att slutföra konverteringen, välj det nya destinationskontot nedan.|För att slutföra konverteringen, vänligen välj de nya destinationskontona nedan.',
    'converted_to_Withdrawal'                   => 'Transaktion har konverterats till ett uttag',
    'converted_to_Deposit'                      => 'Transaktion har konverterats till en insättning',
    'converted_to_Transfer'                     => 'Transaktionen har konverterats till en överföring',
    'invalid_convert_selection'                 => 'Valt konto används redan i transaktion eller saknas helt.',
    'source_or_dest_invalid'                    => 'Finner inte rätt transaktionsdetaljer. Konvertering inte möjlig.',
    'convert_to_withdrawal'                     => 'Konvertera till ett uttag',
    'convert_to_deposit'                        => 'Konvertera till en insättning',
    'convert_to_transfer'                       => 'Konvertera till en överföring',

    // create new stuff:
    'create_new_withdrawal'                     => 'Skapa ett nytt uttag',
    'create_new_deposit'                        => 'Skapa en ny insättning',
    'create_new_transfer'                       => 'Skapa en ny överföring',
    'create_new_asset'                          => 'Skapa ett nytt tillgångskonto',
    'create_new_liabilities'                    => 'Skapa ny skuld',
    'create_new_expense'                        => 'Skapa ett nytt utgiftskonto',
    'create_new_revenue'                        => 'Skapa ett nytt intäktskonto',
    'create_new_piggy_bank'                     => 'Skapa en ny spargris',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Skapa ny prenumeration',
    'create_new_rule'                           => 'Skapa ny regel',

    // currencies:
    'create_currency'                           => 'Skapa en ny valuta',
    'store_currency'                            => 'Lagra en ny valuta',
    'update_currency'                           => 'Uppdatera valuta',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Kan ej ta bort :name då den fortfarande används.',
    'cannot_delete_fallback_currency'           => ':name är systemets reservvaluta och kan inte tas bort.',
    'cannot_disable_currency_journals'          => 'Kan inte inaktivera :name då transaktioner fortfarande använder den.',
    'cannot_disable_currency_last_left'         => 'Kan inte inaktivera :name efter det är den sista aktiverade valutan.',
    'cannot_disable_currency_account_meta'      => 'Kan inte inaktivera :name, används i tillgångskonton.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Kan inte inaktivera :name, används i återkommande transaktioner.',
    'cannot_disable_currency_available_budgets' => 'Kan inte inaktivera :name, används i tillgängliga budgetar.',
    'cannot_disable_currency_budget_limits'     => 'Kan inte inaktivera :name, används i budgetgränser.',
    'cannot_disable_currency_current_default'   => 'Kan inte inaktivera :name, används som aktuell standardvaluta.',
    'cannot_disable_currency_system_fallback'   => 'Kan inte inaktivera :name, är systemets standardvaluta.',
    'disable_EUR_side_effects'                  => 'Euron är systemets nödfallsvaluta. Inaktivering kan ha oavsiktliga bieffekter och kan upphäva din garanti.',
    'deleted_currency'                          => 'Valuta :name borttagen',
    'created_currency'                          => 'Valuta :name skapad',
    'could_not_store_currency'                  => 'Kunde inte lagra den nya valutan.',
    'updated_currency'                          => 'Valuta :name uppdaterad',
    'ask_site_owner'                            => 'Be :owner att lägga till, ta bort eller ändra valutor.',
    'currencies_intro'                          => 'Firefly III stödjer olika valutor vilket du kan ställa in här.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Gör till standard',
    'default_currency'                          => 'standard',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Inaktiverad',
    'enable_currency'                           => 'Aktivera',
    'disable_currency'                          => 'Inaktivera',
    'currencies_default_disabled'               => 'De flesta valutor är inaktiverade som standard. För att använda dem, så måste de aktiveras först.',
    'currency_is_now_enabled'                   => 'Valuta ":name" har aktiverats',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Valuta ":name" har inaktiverats',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Obligatoriska fält',
    'optionalFields'                            => 'Valfria fält',
    'options'                                   => 'Alternativ',

    // budgets:
    'daily_budgets'                             => 'Dagliga budgetar',
    'weekly_budgets'                            => 'Veckovis budgetar',
    'monthly_budgets'                           => 'Månatliga budgetar',
    'quarterly_budgets'                         => 'Kvartalsbudgetar',
    'half_year_budgets'                         => 'Halvårsbudgetar',
    'yearly_budgets'                            => 'Årliga budgetar',
    'other_budgets'                             => 'Anpassade tidsinställda budgetar',
    'budget_limit_not_in_range'                 => 'Detta belopp gäller från :start till :end:',
    'total_available_budget'                    => 'Total tillgänglig budget (mellan :start och :end)',
    'total_available_budget_in_currency'        => 'Total tillgänglig budget i :currency',
    'see_below'                                 => 'se nedan',
    'create_new_budget'                         => 'Skapa en ny budget',
    'store_new_budget'                          => 'Lagra ny budget',
    'stored_new_budget'                         => 'Lagrade ny budget ":name"',
    'available_between'                         => 'Tillgänglig mellan :start och :end',
    'transactionsWithoutBudget'                 => 'Utgifter utan budget',
    'transactions_no_budget'                    => 'Utgifter utan budget mellan :start och :end',
    'spent_between'                             => 'Redan spenderat mellan :start och :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Valt tillgängligt belopp',
    'update_available_amount'                   => 'Uppdatera tillgängligt belopp',
    'ab_basic_modal_explain'                    => 'Detta formulär används för hur mycket du förväntas kunna budgetera (totalt i :currency) under angiven period.',
    'createBudget'                              => 'Ny budget',
    'invalid_currency'                          => 'Detta är en ogiltig valuta',
    'invalid_amount'                            => 'Ange ett belopp',
    'set_ab'                                    => 'Summan på tillgänlig budget har satts',
    'updated_ab'                                => 'Summan på tillgänlig budget har uppdaterats',
    'deleted_ab'                                => 'Summan på tillgänglig budget har tagits bort',
    'deleted_bl'                                => 'Den budgeterade summan har tagits bort',
    'alt_currency_ab_create'                    => 'Ange tillgänglig budget i annan valuta',
    'bl_create_btn'                             => 'Ange budget i annan valuta',
    'inactiveBudgets'                           => 'Inaktiva budgetar',
    'without_budget_between'                    => 'Transaktioner utan budget mellan :start och :end',
    'delete_budget'                             => 'Ta bort budget ":name"',
    'deleted_budget'                            => 'Borttagen budget ":name"',
    'edit_budget'                               => 'Ändra budget ":name"',
    'updated_budget'                            => 'Uppdatera budget ":name"',
    'update_amount'                             => 'Uppdatera belopp',
    'update_budget'                             => 'Uppdatera budget',
    'update_budget_amount_range'                => 'Uppdatera (förväntad) tillgänglig summa mellan :start och :end',
    'set_budget_limit_title'                    => 'Sätt budgeterat belopp för budget :budget mellan :start och :end',
    'set_budget_limit'                          => 'Sätt budgeterat belopp',
    'budget_period_navigator'                   => 'Periodnavigator',
    'info_on_available_amount'                  => 'Vad är tillgängligt?',
    'available_amount_indication'               => 'Använd dessa summor för en indikering av vad din totala budget kan bli.',
    'suggested'                                 => 'Föreslagen',
    'average_between'                           => 'Genomsnitt mellan :start och :end',
    'transferred_in'                            => 'Överfört (in)',
    'transferred_away'                          => 'Överfört (bort)',
    'auto_budget_none'                          => 'Ingen auto-budget',
    'auto_budget_reset'                         => 'Ange ett fast belopp varje period',
    'auto_budget_rollover'                      => 'Lägg till ett belopp varje period',
    'auto_budget_adjusted'                      => 'Lägg till ett belopp varje period och korrigera för överkonsumtion',
    'auto_budget_period_daily'                  => 'Dagligen',
    'auto_budget_period_weekly'                 => 'Veckovis',
    'auto_budget_period_monthly'                => 'Månadsvis',
    'auto_budget_period_quarterly'              => 'Kvartalsvis',
    'auto_budget_period_half_year'              => 'Varje halvår',
    'auto_budget_period_yearly'                 => 'Årligen',
    'auto_budget_help'                          => 'Du kan läsa mer om denna funktion i hjälpen. Klicka på (?) ikonen uppe till höger.',
    'auto_budget_reset_icon'                    => 'Denna budget kommer att fastställas periodvis',
    'auto_budget_rollover_icon'                 => 'Budgetbeloppet kommer att öka periodiskt',
    'auto_budget_adjusted_icon'                 => 'Budgetbeloppet kommer att öka periodiskt och kommer att korrigera för överkonsumtion',
    'remove_budgeted_amount'                    => 'Ta bort budgeterat belopp i :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Prenumeration',
    'not_expected_period'                       => 'Inte väntat denna period',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Inte (ännu)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Återkommande',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Anslutna transaktioner',
    'auto_match_on'                             => 'Automatiskt matchade av Firefly III',
    'auto_match_off'                            => 'Inte automatiskt matchad av Firefly III',
    'next_expected_match'                       => 'Nästa förväntade träff',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Mer',
    'rescan_old'                                => 'Kör regler igen, på alla transaktioner',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Förväntas mellan :start och :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'hoppas över',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'inaktiv regel',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Förväntat :date',
    'bill_expected_date_js'                     => 'Förväntat {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Betalad den {date}',
    'bill_repeats_weekly'                       => 'Upprepas veckovis',
    'bill_repeats_monthly'                      => 'Upprepas månadsvis',
    'bill_repeats_quarterly'                    => 'Upprepas kvartalsvis',
    'bill_repeats_half-year'                    => 'Uprepas varje halvår',
    'bill_repeats_yearly'                       => 'Upprepas årsvis',
    'bill_repeats_weekly_other'                 => 'Upprepas varannan vecka',
    'bill_repeats_monthly_other'                => 'Upprepas varannan månad',
    'bill_repeats_quarterly_other'              => 'Upprepas varannat kvartal',
    'bill_repeats_half-year_other'              => 'Upprepas årsvis',
    'bill_repeats_yearly_other'                 => 'Upprepas varannat år',
    'bill_repeats_weekly_skip'                  => 'Upprepas varje {skip} veckor',
    'bill_repeats_monthly_skip'                 => 'Upprepas varje {skip} månad',
    'bill_repeats_quarterly_skip'               => 'Upprepas varje {skip} kvartal',
    'bill_repeats_half-year_skip'               => 'Upprepas varje {skip} halvår',
    'bill_repeats_yearly_skip'                  => 'Upprepas varje {skip} år',
    'subscriptions'                             => 'Prenumerationer',
    'go_to_subscriptions'                       => 'Gå till dina prenumerationer',
    'forever'                                   => 'För alltid',
    'extension_date_is'                         => 'Tillägg datum är {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Du har :count inaktiva (arkiverat) konto, som du kan se på denna separata sida.|Du har :count inaktiva (arkiverade) konton, som du kan se på denna separata sida.',
    'all_accounts_inactive'                     => 'Dessa är dina inaktiva konton.',
    'active_account_link'                       => 'Denna länk går tillbaka till dina aktiva konton.',
    'account_missing_transaction'               => 'Konto #:id (":name") kan inte visas direkt, men Firefly saknar information för omdirigering.',
    'cc_monthly_payment_date_help'              => 'Välj ett år och en månad, det kommer att ignoreras ändå. Endast dagen i månaden är relevant.',
    'details_for_asset'                         => 'Detaljer för tillgångskonto ":name"',
    'details_for_expense'                       => 'Detaljer för utgiftskonto ":name"',
    'details_for_revenue'                       => 'Detaljer för intäktskonto ":name"',
    'details_for_cash'                          => 'Detaljer för kontantkonto ":name"',
    'store_new_asset_account'                   => 'Lagra nytt tillgångskonto',
    'store_new_expense_account'                 => 'Spara nytt utgiftskonto',
    'store_new_revenue_account'                 => 'Spara nytt intäktskonto',
    'edit_asset_account'                        => 'Ändra tillgångskonto ":name"',
    'edit_expense_account'                      => 'Ändra utgiftskonto ":name"',
    'edit_revenue_account'                      => 'Ändra intäktskonto ":name"',
    'delete_asset_account'                      => 'Ta bort tillgångskonto ":name"',
    'delete_expense_account'                    => 'Ta bort utgiftskonto ":name"',
    'delete_revenue_account'                    => 'Ta bort intäktskonto ":name"',
    'delete_liabilities_account'                => 'Ta bort skuld ":name"',
    'asset_deleted'                             => 'Tillgångskonto togs bort ":name"',
    'account_deleted'                           => 'Kontot ":name" togs bort',
    'expense_deleted'                           => 'Utgiftskonto togs bort ":name"',
    'revenue_deleted'                           => 'Intäktskonto togs bort ":name"',
    'update_asset_account'                      => 'Uppdatera tillgångskonto',
    'update_undefined_account'                  => 'Uppdatera konto',
    'update_liabilities_account'                => 'Uppdatera skuld',
    'update_expense_account'                    => 'Uppdatera utgiftskonto',
    'update_revenue_account'                    => 'Uppdatera intäktskonto',
    'make_new_asset_account'                    => 'Skapa ett nytt tillgångskonto',
    'make_new_expense_account'                  => 'Skapa ett nytt utgiftskonto',
    'make_new_revenue_account'                  => 'Skapa ett nytt intäktskonto',
    'make_new_liabilities_account'              => 'Skapa en ny skuld',
    'asset_accounts'                            => 'Tillgångskonton',
    'undefined_accounts'                        => 'Konton',
    'asset_accounts_inactive'                   => 'Tillgångskonton (inaktiva)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Kostnadskonto',
    'expense_accounts_inactive'                 => 'Utgiftskonton (inaktiva)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Intäktskonton',
    'revenue_accounts_inactive'                 => 'Intäktskonton (inaktiv)',
    'cash_accounts'                             => 'Kontantkonton',
    'Cash account'                              => 'Kontantkonto',
    'liabilities_accounts'                      => 'Skulder',
    'liabilities_accounts_inactive'             => 'Skulder (inaktiva)',
    'reconcile_account'                         => 'Sammansätt konto ":account"',
    'overview_of_reconcile_modal'               => 'Översikt av sammansättning',
    'delete_reconciliation'                     => 'Ta bort sammansättning',
    'update_reconciliation'                     => 'Uppdatera sammansättning',
    'amount_cannot_be_zero'                     => 'Beloppet kan inte vara noll',
    'end_of_reconcile_period'                   => 'Slut på avstämningsperiod: :period',
    'start_of_reconcile_period'                 => 'Start av avstämningsperiod: :period',
    'start_balance'                             => 'Startsaldo',
    'end_balance'                               => 'Slutsaldo',
    'update_balance_dates_instruction'          => 'Matcha beloppen och datum ovan mot dina bankutdrag, och tryck "Börja avstämning"',
    'select_transactions_instruction'           => 'Välj transaktioner som visas på kontoutdrag.',
    'select_range_and_balance'                  => 'Verifiera först datumintervall och balanser. Tryck sedan på "Börja sammanfoga"',
    'date_change_instruction'                   => 'Byte av datumområde nu kan framsteg förloras.',
    'update_selection'                          => 'Uppdatera val',
    'store_reconcile'                           => 'Lagra avstämning',
    'reconciliation_transaction'                => 'Stäm av transaktion',
    'Reconciliation'                            => 'Avstämning',
    'reconciliation'                            => 'Avstämning',
    'reconcile_options'                         => 'Avstämningsval',
    'reconcile_range'                           => 'Avstämningsområde',
    'start_reconcile'                           => 'Börja stämma av',
    'cash_account_type'                         => 'Kontant',
    'cash'                                      => 'kontant',
    'cant_find_redirect_account'                => 'Firefly III försökte omdirigera dig men misslyckades. Förlåt, åter till index.',
    'account_type'                              => 'Kontotyp',
    'save_transactions_by_moving'               => 'Spara denna transaktion genom att flytta den till ett annat konto:|Spara dessa transaktioner genom att flytta dem till ett annat konto:',
    'save_transactions_by_moving_js'            => 'Inga transaktioner|Spara denna transaktion genom att flytta den till ett annat konto.|Spara dessa transaktioner genom att flytta dem till ett annat konto.',
    'stored_new_account'                        => 'Nytt konto ":name" lagrat!',
    'stored_new_account_js'                     => 'Nytt konto "<a href="accounts/show/{ID}">{name}</a>" lagrat!',
    'updated_account'                           => 'Konto ":name" uppdaterad',
    'updated_account_js'                        => 'Uppdaterade kontot "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Kreditkortalternativ',
    'no_transactions_account'                   => 'Inga transaktioner (i denna period) för tillgångskonto ":name".',
    'no_transactions_period'                    => 'Inga transaktioner (i denna period).',
    'no_data_for_chart'                         => 'Saknas information (fortfarande) för att generera detta diagram.',
    'select_at_least_one_account'               => 'Välj minst ett tillgångskonto',
    'select_at_least_one_category'              => 'Välj åtminstone en kategori',
    'select_at_least_one_budget'                => 'Välj minst en budget',
    'select_at_least_one_tag'                   => 'Välj åtminstone en etikett',
    'select_at_least_one_expense'               => 'Välj åtminstone en kombination av utgift/intäcktskonton. Om dessa saknas (listan är tom) är inte denna rapport tillgänglig.',
    'account_default_currency'                  => 'Detta är standard valut associerad till detta konto.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Firefly III huvudbok har mer penger än vad din bank påstår det bör vara. Det finns flera alternativ. Vänligen välj vad som ska ske. Tryck sedan "Bekräfta avstämning".',
    'reconcile_has_less'                        => 'Firefly III huvudbok har mindre penger än vad din bank påstår det bör vara. Det finns flera alternativ. Vänligen välj vad som ska ske. Tryck sedan "Bekräfta avstämning".',
    'reconcile_is_equal'                        => 'Firefly III huvudbok och kontoutdrag stämmer överens. Det finns inget att göra. Tryck "Bekräfta avstämning" för att bekräfta din inmatning.',
    'create_pos_reconcile_transaction'          => 'Rensa de valda transaktionerna och skapa en korrigering som lägger till :amount till detta tillgångskonto.',
    'create_neg_reconcile_transaction'          => 'Rensa de valda transaktionerna och skapa en korrigering som tar bort :amount från detta tillgångskonto.',
    'reconcile_do_nothing'                      => 'Rensa de valda transaktionerna, men korrigera inget.',
    'reconcile_go_back'                         => 'Det går att ändra eller ta bort en rättelse senare.',
    'must_be_asset_account'                     => 'Du kan bara stämma av tillgångskonton',
    'reconciliation_stored'                     => 'Avstämning sparad',
    'reconciliation_error'                      => 'På grund av ett fel markerades transaktionerna som avstämda men korrigeringen har inte sparats: :error.',
    'reconciliation_transaction_title'          => 'Avstämning (:from till :to)',
    'sum_of_reconciliation'                     => 'Summa av avstämning',
    'reconcile_this_account'                    => 'Stäm av detta konto',
    'reconcile'                                 => 'Avstämning',
    'show'                                      => 'Visa',
    'confirm_reconciliation'                    => 'Bekräfta avstämning',
    'submitted_start_balance'                   => 'Inskickad startbalans',
    'selected_transactions'                     => 'Valda transaktioner (:count)',
    'already_cleared_transactions'              => 'Slutförda transaktioner (:count)',
    'submitted_end_balance'                     => 'Inskickad slutbalans',
    'initial_balance_description'               => 'Startbalans för ":account"',
    'liability_credit_description'              => 'Ansvarskredit för ":account"',
    'interest_calc_'                            => 'okänd',
    'interest_calc_daily'                       => 'Per dag',
    'interest_calc_monthly'                     => 'Per månad',
    'interest_calc_yearly'                      => 'Per år',
    'interest_calc_weekly'                      => 'Per vecka',
    'interest_calc_half-year'                   => 'Per halvår',
    'interest_calc_quarterly'                   => 'Per kvartal',
    'initial_balance_account'                   => 'Startbalans för konto :account',
    'list_options'                              => 'Listalternativ',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Ny kategori',
    'create_new_category'                       => 'Skapa en ny kategori',
    'without_category'                          => 'Kategori saknas',
    'update_category'                           => 'Uppdatera kategori',
    'updated_category'                          => 'Kategori ":name" uppdaterad',
    'categories'                                => 'Kategorier',
    'edit_category'                             => 'Redigera kategori ":name"',
    'no_category'                               => '(utan kategori)',
    'unknown_category_plain'                    => 'Ingen kategori',
    'category'                                  => 'Kategori',
    'delete_category'                           => 'Ta bort kategori ":name"',
    'deleted_category'                          => 'Kategori ":name" togs bort',
    'store_category'                            => 'Lagra ny kategori',
    'stored_category'                           => 'Ny kategori ":name" lagrades',
    'without_category_between'                  => 'Utan kategori mellan :start och :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Uppdatera uttag',
    'update_deposit'                            => 'Uppdatera insättning',
    'update_transaction'                        => 'Uppdatera transaktion',
    'update_transfer'                           => 'Uppdatera överföring',
    'updated_withdrawal'                        => 'Uppdatera uttag ":description"',
    'updated_deposit'                           => 'Uppdatera insättning ":description"',
    'updated_transfer'                          => 'Uppdatera överföring ":description"',
    'no_changes_withdrawal'                     => 'Uttag ":description" har inte ändrats.',
    'no_changes_deposit'                        => 'Insättning ":description" har inte ändrats.',
    'no_changes_transfer'                       => 'Överföring ":description" har inte ändrats.',
    'delete_withdrawal'                         => 'Ta bort uttag ":description"',
    'delete_deposit'                            => 'Ta bort insättning ":description"',
    'delete_transfer'                           => 'Ta bort överföring ":description"',
    'deleted_withdrawal'                        => 'Uttag ":description" har tagits bort',
    'deleted_deposit'                           => 'Insättning ":description" har tagits bort',
    'deleted_transfer'                          => 'Överföring ":description" har tagits bort',
    'deleted_reconciliation'                    => 'Avstämningstransaktionen ":description" togs bort lyckat',
    'stored_journal'                            => 'Skapade ny transaktion ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Ny transaktion skapades lyckat',
    'updated_journal_no_descr'                  => 'Transaktion har uppdaterats',
    'select_transactions'                       => 'Välj transaktioner',
    'rule_group_select_transactions'            => 'Tillämpa ":title" till transaktioner',
    'rule_select_transactions'                  => 'Tillämpa ":title" till transaktioner',
    'stop_selection'                            => 'Sluta välja transaktioner',
    'reconcile_selected'                        => 'Avstämning',
    'mass_delete_journals'                      => 'Ta bort ett antal transaktioner',
    'mass_edit_journals'                        => 'Ändra ett antal transaktioner',
    'mass_bulk_journals'                        => 'Ändra flera transaktioner',
    'mass_bulk_journals_explain'                => 'Detta formulär tillåter dig att ändra egenskaperna på transaktionerna listade nedan i ett enda svep. Alla transaktioner i tabellen uppdateras när du ändrar parametrarna du ser här.',
    'part_of_split'                             => 'Denna transaktion är del av en delad transaktion. Om du inte har valt alla delarna, kan det bli att du bara ändrar halva transaktionen.',
    'bulk_set_new_values'                       => 'Använd valen nedan för att sätta nya värden. Om de lämnas tomma, blir de tomma för alla. Notera också att endast uttag kommer att ges en budget.',
    'no_bulk_category'                          => 'Uppdatera inte kategori',
    'no_bulk_budget'                            => 'Uppdatera inte budget',
    'no_bulk_tags'                              => 'Uppdatera inte etikett(er)',
    'replace_with_these_tags'                   => 'Ersätt med dessa taggar',
    'append_these_tags'                         => 'Lägg till dessa taggar',
    'mass_edit'                                 => 'Ändra valda individuellt',
    'bulk_edit'                                 => 'Massredigera valda',
    'mass_delete'                               => 'Ta bort valda',
    'cannot_edit_other_fields'                  => 'Går ej att massredigera andra fält än dessa, eftersom det inte finns utrymme att visa andra. Vänligen följ länken och redigera dem en efter en om andra fält behöver redigeras.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(ingen budget)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Konto per budget',
    'account_per_category'                      => 'Konto per etikett',
    'create_new_object'                         => 'Skapa',
    'empty'                                     => '(tom)',
    'all_other_budgets'                         => '(övriga budgetar)',
    'all_other_accounts'                        => '(alla övriga konton)',
    'expense_per_source_account'                => 'Utgifter per källkonto',
    'expense_per_destination_account'           => 'Utgifter per målkonto',
    'income_per_destination_account'            => 'Inkomst per målkonto',
    'spent_in_specific_category'                => 'Spenderat i kategori ":category"',
    'earned_in_specific_category'               => 'Intjänat i kategori ":category"',
    'spent_in_specific_tag'                     => 'Spenderat i etikett ":tag"',
    'earned_in_specific_tag'                    => 'Tjänat i etikett ":tag"',
    'income_per_source_account'                 => 'Inkomst per källkonto',
    'average_spending_per_destination'          => 'Medel kostnad per målkonto',
    'average_spending_per_source'               => 'Medel kostnad per källkonto',
    'average_earning_per_source'                => 'Medel intjäning per källkonto',
    'average_earning_per_destination'           => 'Medel intjäning per målkonto',
    'account_per_tag'                           => 'Konton per etikett',
    'tag_report_expenses_listed_once'           => 'Utgifter och inkomster visas aldrig dubbelt. Om en transaktioner har flera etiketter, visas den bara under en av dessa. Detta diagram kan tyckas sakna data, men summan kommer att stämma.',
    'double_report_expenses_charted_once'       => 'Utgifter och inkomster visas aldrig dubbelt. Om en transaktioner har flera etiketter, visas den bara under en av dessa. Detta diagram kan tyckas sakna data, men summan kommer att stämma.',
    'tag_report_chart_single_tag'               => 'Detta diagram tillämpas bara för en etikett. Om en transaktion har flera etiketter, det som visas i diagrammen kan komma från andra etiketter också.',
    'tag'                                       => 'Etikett',
    'no_budget_squared'                         => '(ingen budget)',
    'perm-delete-many'                          => 'Att ta bort så mycket på en gång kan vara problematiskt. Var försiktig. Du kan ta bort delar av en delad transaktion från denna sida, så var försiktig.',
    'mass_deleted_transactions_success'         => 'Borttagna :count transaktion.|Borttagna :count transaktioner.',
    'mass_edited_transactions_success'          => 'Uppdaterade :count transaktion.|Uppdaterade :count transaktioner.',
    'opt_group_'                                => '(saknar kontotyp)',
    'opt_group_no_account_type'                 => '(saknar kontotyp)',
    'opt_group_defaultAsset'                    => 'Förvalt tillgångskonton',
    'opt_group_savingAsset'                     => 'Sparkonton',
    'opt_group_sharedAsset'                     => 'Delade tillgångskonton',
    'opt_group_ccAsset'                         => 'Kreditkort',
    'opt_group_cashWalletAsset'                 => 'Plånböcker',
    'opt_group_expense_account'                 => 'Kostnadskonton',
    'opt_group_revenue_account'                 => 'Intäktskonton',
    'opt_group_l_Loan'                          => 'Skuld: Lån',
    'opt_group_cash_account'                    => 'Kontantkonto',
    'opt_group_l_Debt'                          => 'Skuld: Skuld',
    'opt_group_l_Mortgage'                      => 'Skuld: Bolån',
    'opt_group_l_Credit card'                   => 'Skuld: Kreditkort',
    'notes'                                     => 'Noteringar',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Transaktion kunde inte lagras. Vänligen se loggfiler.',
    'attachment_not_found'                      => 'Denna bilaga kunde inte hittas.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transaktion #{ID} ("{title}")</a> sparades.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transaktion #{ID}</a> sparades.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transaktion #{ID}</a> ("{title}") uppdaterades.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transaktion #{ID}</a> ("{title}") fick inga ändringar.',
    'first_split_decides'                       => 'Första delningen bestämmer värdet på detta fält',
    'first_split_overrules_source'              => 'Den första delningen kan åsidosätta källkontot',
    'first_split_overrules_destination'         => 'Den första delningen kan åsidosätta målkontot',
    'spent_x_of_y'                              => 'Spenderade {amount} av {total}',

    // new user:
    'welcome'                                   => 'Välkommen till Firefly III!',
    'submit'                                    => 'Skicka',
    'submission'                                => 'Inskickning',
    'submit_yes_really'                         => 'Skicka (Jag vet vad jag gör)',
    'getting_started'                           => 'Komma igång',
    'to_get_started'                            => 'Det är bra att se att du har lyckats installera Firefly III. För att komma igång med detta verktyg vänligen ange din banks namn och saldot på ditt huvudkonto. Oroa dig in om du har flera konton. Dessa går att lägga till senare. Firefly III behöver något att börja med.',
    'savings_balance_text'                      => 'Firefly III skapar automatiskt sparkonto åt dig. Som standard finns det inga pengar i dina sparkonton, men om du berättar för Firefly III om balansen så lagras detta.',
    'finish_up_new_user'                        => 'Det var allt! Du kan fortsätta genom att klicka på <strong>Skicka</strong>. Du kommer då till startsidan för Firefly III.',
    'stored_new_accounts_new_user'              => 'Jippie! Dina nya konton har lagrats.',
    'set_preferred_language'                    => 'Om du föredrar att använda Firefly III i annat språk, välj sådant här.',
    'language'                                  => 'Språk',
    'new_savings_account'                       => ':bank_name sparkonto',
    'cash_wallet'                               => 'Plånbok',
    'currency_not_present'                      => 'Om valutan du normalt använder inte finns med, oroa dig inte. Du kan skapa nya valutor under Alternativ > Valutor.',

    // home page:
    'transaction_table_description'             => 'En tabell som innehåller dina transaktioner',
    'opposing_account'                          => 'Motsatt konto',
    'yourAccounts'                              => 'Dina konton',
    'your_accounts'                             => 'Din kontoöversikt',
    'category_overview'                         => 'Kategori översikt',
    'expense_overview'                          => 'Översikt kostnadskonto',
    'revenue_overview'                          => 'Översikt intäktskonto',
    'budgetsAndSpending'                        => 'Budgetar och utgifter',
    'budgets_and_spending'                      => 'Budgetar och utgifter',
    'go_to_budget'                              => 'Gå till budget "{budget}"',
    'go_to_deposits'                            => 'Gå till insättningar',
    'go_to_expenses'                            => 'Gå till utgifter',
    'savings'                                   => 'Sparande',
    'newWithdrawal'                             => 'Ny utgift',
    'newDeposit'                                => 'Ny insättning',
    'newTransfer'                               => 'Ny överföring',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Per dag',
    'left_to_spend_per_day'                     => 'Kvar att spendera per dag',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Anpassad period',
    'reset_to_current'                          => 'Återställ till nuvarande period',
    'select_period'                             => 'Välj en period',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Inställningar',
    'logout'                                    => 'Logga ut',
    'logout_other_sessions'                     => 'Logga ut alla andra sessioner',
    'toggleNavigation'                          => 'Växla navigering',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Sök...',
    'version'                                   => 'Version',
    'dashboard'                                 => 'Kontrollpanel',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Tillgänglig budget ({currency})',
    'currencies'                                => 'Valutor',
    'activity'                                  => 'Aktivitet',
    'usage'                                     => 'Användning',
    'accounts'                                  => 'Konton',
    'Asset account'                             => 'Tillgångskonto',
    'Default account'                           => 'Tillgångskonto',
    'Expense account'                           => 'Kostnadskonto',
    'Revenue account'                           => 'Intäktskonton',
    'Initial balance account'                   => 'Startbalans konto',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Skuld',
    'account_type_Loan'                         => 'Lån',
    'account_type_Mortgage'                     => 'Bolån',
    'account_type_debt'                         => 'Skuld',
    'account_type_loan'                         => 'Lån',
    'account_type_mortgage'                     => 'Bolån',
    'account_type_Credit card'                  => 'Kreditkort',
    'credit_card_type_monthlyFull'              => 'Full betalning varje månad',
    'liability_direction_credit'                => 'Någon skyller mig denna skuld',
    'liability_direction_debit'                 => 'Jag är skyldig någon annan denna skuld',
    'liability_direction_credit_short'          => 'Ägde denna skuld',
    'liability_direction_debit_short'           => 'Äger denna skuld',
    'liability_direction__short'                => 'Okänd',
    'liability_direction_null_short'            => 'Okänd',
    'Liability credit'                          => 'Ansvar kredit',
    'budgets'                                   => 'Budgetar',
    'tags'                                      => 'Etiketter',
    'reports'                                   => 'Rapporter',
    'transactions'                              => 'Transaktioner',
    'expenses'                                  => 'Utgifter',
    'income'                                    => 'Intäkter / inkomster',
    'transfers'                                 => 'Överföringar',
    'moneyManagement'                           => 'Penninghantering',
    'money_management'                          => 'Penninghantering',
    'tools'                                     => 'Verktyg',
    'piggyBanks'                                => 'Spargrisar',
    'piggy_banks'                               => 'Spargrisar',
    'amount_x_of_y'                             => '{current} av {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Uttag',
    'opening_balance'                           => 'Ingående balans',
    'deposit'                                   => 'Insättning',
    'account'                                   => 'Konto',
    'transfer'                                  => 'Överföring',
    'Withdrawal'                                => 'Uttag',
    'Deposit'                                   => 'Insättning',
    'Transfer'                                  => 'Överföring',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nej',
    'amount'                                    => 'Belopp',
    'overview'                                  => 'Översikt',
    'saveOnAccount'                             => 'Spara till konto',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Okänd',
    'monthly'                                   => 'Månatlig',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Fel',
    'debt_start_date'                           => 'Skuldens startdatum',
    'debt_start_amount'                         => 'Skuldens startsumma',
    'debt_start_amount_help'                    => 'Det är alltid bäst att ställa in detta värde till ett negativt belopp. Läs hjälpsidorna (högst upp till höger (?)-ikonen) för mer information.',
    'interest_period_help'                      => 'Detta fält är rent kosmetiskt och kommer inte att beräknas för dig. Det har visat sig att banker är mycket lömska så Firefly III får det aldrig rätt.',
    'store_new_liabilities_account'             => 'Spara en ny skuld',
    'edit_liabilities_account'                  => 'Ändra skuld ":name"',
    'financial_control'                         => 'Finansiell kontroll',
    'accounting'                                => 'Redovisning',
    'automation'                                => 'Automatisering',
    'others'                                    => 'Andra',
    'classification'                            => 'Klassificering',
    'store_transaction'                         => 'Lagra transaktion',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Standard ekonomisk rapport mellan :start och :end',
    'report_audit'                              => 'Transaktionshistoriköversikt mellan :start och :end',
    'report_category'                           => 'Kategorirapport mellan :start och :end',
    'report_double'                             => 'Kostnad/intäktskonto rapport mellan :start och :end',
    'report_budget'                             => 'Budgetrapport mellan :start och :end',
    'report_tag'                                => 'Etikett rapport mellan :start och :end',
    'quick_link_reports'                        => 'Snabblänkar',
    'quick_link_examples'                       => 'Dessa är några exempel länkar för dig att komma igång. Se hjälpsidorna under (?)-knappen för information om alla rapporter och magiska ord du kan använda.',
    'quick_link_default_report'                 => 'Standard ekonomisk rapport',
    'quick_link_audit_report'                   => 'Transaktionshistoriköversikt',
    'report_this_month_quick'                   => 'Nuvarande månad, alla konton',
    'report_last_month_quick'                   => 'Föregående månad, alla konton',
    'report_this_year_quick'                    => 'Nuvarande år, alla konton',
    'report_this_fiscal_year_quick'             => 'Nuvarande bokföringsår, alla konton',
    'report_all_time_quick'                     => 'Komplett, alla konton',
    'reports_can_bookmark'                      => 'Kom ihåg att rapporter kan bokmärkas.',
    'incomeVsExpenses'                          => 'Inkomster vs utgifter',
    'accountBalances'                           => 'Kontobalanser',
    'balanceStart'                              => 'Balans vid början av period',
    'balanceEnd'                                => 'Balans vid slut av period',
    'splitByAccount'                            => 'Dela efter konto',
    'coveredWithTags'                           => 'Belagd med etiketter',
    'leftInBudget'                              => 'Kvar i budget',
    'left_in_debt'                              => 'Att betala',
    'sumOfSums'                                 => 'Summan av beloppen',
    'noCategory'                                => '(ingen kategori)',
    'notCharged'                                => 'Inte debiterade (ännu)',
    'inactive'                                  => 'Inaktiv',
    'active'                                    => 'Aktiv',
    'difference'                                => 'Skillnad',
    'money_flowing_in'                          => 'In',
    'money_flowing_out'                         => 'Ut',
    'topX'                                      => 'topp :number',
    'show_full_list'                            => 'Visa hela listan',
    'show_only_top'                             => 'Visa bara första :number',
    'report_type'                               => 'Rapporttyp',
    'report_type_default'                       => 'Standard ekonomisk rapport',
    'report_type_audit'                         => 'Transaktionshistoriköversikt (granskning)',
    'report_type_category'                      => 'Kategorirapport',
    'report_type_budget'                        => 'Budgetrapport',
    'report_type_tag'                           => 'Etikettrapport',
    'report_type_double'                        => 'Utgift/intäktskonto rapport',
    'more_info_help'                            => 'Mer information om dessa typer av rapporter kan hittas i hjälpsidorna. Tryck på (?) ikonen i det övre högra hörnet.',
    'report_included_accounts'                  => 'Inkludera konton',
    'report_date_range'                         => 'Datumintervall',
    'report_preset_ranges'                      => 'Förinställda intervall',
    'shared'                                    => 'Delad',
    'fiscal_year'                               => 'Räkenskapsår',
    'income_entry'                              => 'Inkomst från konto ":name" mellan :start och :end',
    'expense_entry'                             => 'Utgifter från konto ":name" mellan :start och :end',
    'category_entry'                            => 'Utgifter och inkomster i kategori ":name" mellan :start och :end',
    'budget_spent_amount'                       => 'Utgifter i budget ":budget" mellan :start och :end',
    'balance_amount'                            => 'Utgifter i budget ":budget" betalad från konto ":account" mellan :start och :end',
    'no_audit_activity'                         => 'Ingen aktivitet registrerad på konto <a href=":url" title=":account_name">:account_name</a> mellan :start och :end.',
    'audit_end_balance'                         => 'Kontosaldot på <a href=":url" title=":account_name">:account_name</a> vid slutet av :end var :balance',
    'reports_extra_options'                     => 'Extra alternativ',
    'report_has_no_extra_options'               => 'Denna rapport saknar extra alternativ',
    'reports_submit'                            => 'Visa rapport',
    'end_after_start_date'                      => 'Slutdatum för rapporten måste vara efter startdatum.',
    'select_category'                           => 'Välj kategori(er)',
    'select_budget'                             => 'Välj budget(ar).',
    'select_tag'                                => 'Välj etikett(er).',
    'income_per_category'                       => 'Intäkter per kategori',
    'expense_per_category'                      => 'Utgifter per kategori',
    'expense_per_budget'                        => 'Utgifter per budget',
    'income_per_account'                        => 'Inkomst per konto',
    'expense_per_account'                       => 'Utgifter per konto',
    'expense_per_tag'                           => 'Kostnader per etikett',
    'income_per_tag'                            => 'Inkomster per etikett',
    'include_expense_not_in_budget'             => 'Inkludera utgifter utanför valda budget(er)',
    'include_expense_not_in_account'            => 'Inkludera utgifter utanför valda konto(n)',
    'include_expense_not_in_category'           => 'Inkludera utgifter utanför valda kategori(er)',
    'include_income_not_in_category'            => 'Inkludes inkomster utanför valda kategori(er)',
    'include_income_not_in_account'             => 'Inkludera inkomster utanför valda konto(n)',
    'include_income_not_in_tags'                => 'Inkludera inkomster utanför valda etikett(er)',
    'include_expense_not_in_tags'               => 'Inkludera utgifter utanför valda etikett(er)',
    'everything_else'                           => 'Allt annat',
    'income_and_expenses'                       => 'Inkomster och utgifter',
    'spent_average'                             => 'Spenderat (medel)',
    'income_average'                            => 'Inkomst (medel)',
    'transaction_count'                         => 'Antal transaktioner',
    'average_spending_per_account'              => 'Medel spenderat per konto',
    'average_income_per_account'                => 'Medel inkomst per konto',
    'total'                                     => 'Total',
    'description'                               => 'Beskrivning',
    'sum_of_period'                             => 'Summa på period',
    'average_in_period'                         => 'Medel av period',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Förvalt tillgångskonto',
    'account_role_sharedAsset'                  => 'Delat tillgångskonto',
    'account_role_savingAsset'                  => 'Sparkonto',
    'account_role_ccAsset'                      => 'Kreditkort',
    'account_role_cashWalletAsset'              => 'Plånbok',
    'budget_chart_click'                        => 'Klicka på ett budgetnamn i tabellen nedan för att se ett diagram.',
    'category_chart_click'                      => 'Klicka på ett kategorinamn i tabellen nedan för att se ett diagram.',
    'in_out_accounts'                           => 'Intjänat och spenderat per kombination',
    'in_out_accounts_per_asset'                 => 'Intjänat och spenderat (per tillgångskonto)',
    'in_out_per_category'                       => 'Intjänat och spenderat per kategori',
    'out_per_budget'                            => 'Spenderat per budget',
    'select_expense_revenue'                    => 'Välj utgifts-/intäktskonto',
    'multi_currency_report_sum'                 => 'Då denna lista innehåller konton med flera valutor, kan summor(na) se konstiga ut. Rapporten faller alltid tillbaka på din standard valuta.',
    'sum_in_default_currency'                   => 'Summan kommer alltid att vara i din standardvaluta.',
    'net_filtered_prefs'                        => 'Det här diagrammet kommer aldrig att innehålla konton som har alternativet "Inkludera i nätet värdet" avmarkerat.',


    // charts:
    'chart'                                     => 'Graf',
    'month'                                     => 'Månad',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Spenderat',
    'spent_capped'                              => 'Spenderade (kantade)',
    'spent_in_budget'                           => 'Spenderat per budget',
    'left_to_spend'                             => 'Återstår att spendera',
    'earned'                                    => 'Tjänat',
    'overspent'                                 => 'Överansträngd',
    'left'                                      => 'Återstår',
    'max-amount'                                => 'Högsta belopp',
    'min-amount'                                => 'Lägsta belopp',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Namn',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Datum',
    'date_and_time'                             => 'Datum och tid',
    'time'                                      => 'Tid',
    'paid'                                      => 'Betald',
    'unpaid'                                    => 'Obetald',
    'day'                                       => 'Dag',
    'budgeted'                                  => 'Budgeterat',
    'period'                                    => 'Period',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'In + ut denna period',
    'sum'                                       => 'Summa',
    'summary'                                   => 'Översikt',
    'average'                                   => 'Medel',
    'balanceFor'                                => 'Saldo för :name',
    'no_tags'                                   => '(inga etiketter)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Lägg till pengar till spargris ":name"',
    'piggy_bank'                    => 'Spargris',
    'new_piggy_bank'                => 'Ny spargris',
    'store_piggy_bank'              => 'Lagra ny spargris',
    'stored_piggy_bank'             => 'Lagra ny spargris ":name"',
    'account_status'                => 'Kontostatus',
    'left_for_piggy_banks'          => 'Kvar för spargrisar',
    'sum_of_piggy_banks'            => 'Summa sparbanker',
    'saved_so_far'                  => 'Sparat hittills',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Kvar att spara',
    'suggested_amount'              => 'Föreslaget månadsbelopp att spara',
    'add_money_to_piggy_title'      => 'Lägg till pengar till spargris ":name"',
    'remove_money_from_piggy_title' => 'Ta bort pengar från spargris ":name"',
    'add'                           => 'Lägg till',
    'no_money_for_piggy'            => 'Du saknar pengar att lägga till i denna spargris.',
    'suggested_savings_per_month'   => 'Föreslaget per månad',

    'remove'                    => 'Ta bort',
    'max_amount_add'            => 'Max belopp du kan lägga till är',
    'max_amount_remove'         => 'Max belopp du kan ta bort är',
    'update_piggy_button'       => 'Uppdatera spargris',
    'update_piggy_title'        => 'Uppdatera spargris ":name"',
    'updated_piggy_bank'        => 'Uppdaterat spargris ":name"',
    'details'                   => 'Detaljer',
    'events'                    => 'Händelser',
    'target_amount'             => 'Mål belopp',
    'start_date'                => 'Startdatum',
    'no_start_date'             => 'Inget startdatum',
    'target_date'               => 'Måldatum',
    'no_target_date'            => 'Inget måldatum',
    'table'                     => 'Tabell',
    'delete_piggy_bank'         => 'Ta bort spargris ":name"',
    'cannot_add_amount_piggy'   => ':amount kunde inte läggas till ":name".',
    'cannot_remove_from_piggy'  => ':amount kunde inte tas bort från ":name".',
    'deleted_piggy_bank'        => 'Spargris ":name" har tagits bort',
    'added_amount_to_piggy'     => ':amount lades till ":name"',
    'removed_amount_from_piggy' => ':amount togs bort från ":name"',
    'piggy_events'              => 'Relaterade spargrisar',

    // tags
    'delete_tag'                => 'Ta bort etiketten ":tag"',
    'deleted_tag'               => 'Tog bort etiketten ":tag"',
    'new_tag'                   => 'Skapa en ny etikett',
    'edit_tag'                  => 'Ändra etikett ":tag"',
    'updated_tag'               => 'Uppdatera etikett ":tag"',
    'created_tag'               => 'Etiketten ":tag" har skapats!',

    'transaction_journal_information'               => 'Transaktionsinformation',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Metadata',
    'transaction_journal_more'                      => 'Mer information',
    'basic_journal_information'                     => 'Grundläggande transaktionsinformation',
    'transaction_journal_extra'                     => 'Extra information',
    'att_part_of_journal'                           => 'Sparad under ":journal"',
    'total_amount'                                  => 'Totala summan',
    'number_of_decimals'                            => 'Antal decimaler',


    // administration
    'invite_is_already_redeemed'                    => 'Inbjudan till ":address" har redan lösts in.',
    'invite_is_deleted'                             => 'Inbjudan till ":address" har tagits bort.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'E-postadress',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Administration',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Användaradministration',
    'list_all_users'                                => 'Alla användare',
    'all_users'                                     => 'Alla användare',
    'instance_configuration'                        => 'Konfiguration',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'Enkelanvändarläge',
    'setting_single_user_mode_explain'              => 'Som standard accepterar Firefly III endas en (1) registrator: du. Detta är en säkerhetstanke, för att förhindra andra från att använda din instans bara om du tillåter det. Framtida registreringar är blockerade. Om du kryssar ur denna ruta, så kan andra användare också använda din instans, förutsatt att de kan nå den (när den är ansluten till internet).',
    'store_configuration'                           => 'Spara konfiguration',
    'single_user_administration'                    => 'Användaradministration för :email',
    'edit_user'                                     => 'Redigera användare :email',
    'hidden_fields_preferences'                     => 'Du kan aktivera fler transaktionsalternativ i dina <a href="preferences">inställningar</a>.',
    'user_data_information'                         => 'Användardata',
    'user_information'                              => 'Användar information',
    'total_size'                                    => 'total storlek',
    'budget_or_budgets'                             => ':count budget|:count budgetar',
    'budgets_with_limits'                           => ':count budget med konfigurerat belopp|:count budgetar med konfigurerat belopp',
    'nr_of_rules_in_total_groups'                   => ':count_rules regel/regler i :count_groups regelgrupp(er)',
    'tag_or_tags'                                   => ':count tag|:count taggar',
    'configuration_updated'                         => 'Konfigurationen har uppdaterats',
    'setting_is_demo_site'                          => 'Demo webbplats',
    'setting_is_demo_site_explain'                  => 'Om du kryssar i denna ruta, kommer installation att bete sig som om det är demosidan, vilket kan ha konstiga biverkningar.',
    'block_code_bounced'                            => 'E-postmeddelande(n) studsade',
    'block_code_expired'                            => 'Demo-konto har löpt ut',
    'no_block_code'                                 => 'Ingen anledning till blockering eller användare inte blockerad',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Användaren har ännu inte bekräftat ny e-postadress',
    'admin_update_email'                            => 'I motsats till profilsidan kommer användaren INTE att meddelas att deras e-postadress har ändrats!',
    'update_user'                                   => 'Uppdatera användare',
    'updated_user'                                  => 'Användardata har ändrats.',
    'delete_user'                                   => 'Ta bort användare :email',
    'user_deleted'                                  => 'Användaren har tagits bort',
    'send_test_email'                               => 'Skicka testmeddelande via e-post',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Skicka meddelande',
    'send_test_triggered'                           => 'Test utlöst. Kontrollera din inkorg och loggfilerna.',
    'give_admin_careful'                            => 'Användare som får administratörsrättigheter kan ta bort din. Var försiktig.',
    'admin_maintanance_title'                       => 'Underhåll',
    'admin_maintanance_expl'                        => 'Några fiffiga knappar för Firefly III underhåll',
    'admin_maintenance_clear_cache'                 => 'Rensa cache',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Spara inställningar',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Beskrivning av delad transaktion',
    'split_transaction_title_help'          => 'Om du skapar en delad transaktion måste det finnas en global beskrivning för alla delningar av transaktionen.',
    'split_title_help'                      => 'Om du skapar en delad transaktion måste det finnas en global beskrivning för alla delningar av transaktionen.',
    'you_create_transfer'                   => 'Du skapar en överföring.',
    'you_create_withdrawal'                 => 'Du skapar ett uttag.',
    'you_create_deposit'                    => 'Du skapar en insättning.',

    // links
    'journal_link_configuration'            => 'Konfiguration av transaktionslänkar',
    'create_new_link_type'                  => 'Skapa ny länktyp',
    'store_new_link_type'                   => 'Lagra ny länktyp',
    'update_link_type'                      => 'Uppdatera länktyp',
    'edit_link_type'                        => 'Redigera länktyp ":name"',
    'updated_link_type'                     => 'Länktypen ":name" uppdaterades',
    'delete_link_type'                      => 'Ta bort länktyp ":name"',
    'deleted_link_type'                     => 'Länktypen ":name" raderad',
    'stored_new_link_type'                  => 'Lagra ny länktyp ":name"',
    'cannot_edit_link_type'                 => 'Kan inte redigera länktyp ":name"',
    'link_type_help_name'                   => 'T. ex. "dubbletter"',
    'link_type_help_inward'                 => 'T. ex. "dubbletter"',
    'link_type_help_outward'                => 'T. ex. "är dubbellet av"',
    'save_connections_by_moving'            => 'Spara länken mellan dessa transaktioner genom att flytta dem till en annan länktyp:',
    'do_not_save_connection'                => '(spara inte koppling)',
    'link_transaction'                      => 'Länka transaktion',
    'link_to_other_transaction'             => 'Länka denna transaktion till en annan transaktion',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Denna transaktion',
    'transaction'                           => 'Transaktion',
    'comments'                              => 'Kommentarer',
    'link_notes'                            => 'Eventuella anteckningar som du vill lagra med länken.',
    'invalid_link_selection'                => 'Kan inte länka dessa transaktioner',
    'selected_transaction'                  => 'Vald transaktion',
    'journals_linked'                       => 'Transaktioner är länkade.',
    'journals_error_linked'                 => 'Dessa transaktioner är redan länkade.',
    'journals_link_to_self'                 => 'Går inte länka en transaktion till sig själv',
    'journal_links'                         => 'Transaktionslänkar',
    'this_withdrawal'                       => 'Detta uttag',
    'this_deposit'                          => 'Denna insättning',
    'this_transfer'                         => 'Denna överföring',
    'overview_for_link'                     => 'Översikt för länktyp ":name"',
    'source_transaction'                    => 'Källtransaktion',
    'link_description'                      => 'Länkbeskrivning',
    'destination_transaction'               => 'Destinationstransaktion',
    'delete_journal_link'                   => 'Ta bort länk mellan <a href=":source_link">:source</a> och <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Länk borttagen',

    // link translations:
    'Paid_name'                             => 'Betalad',
    'Refund_name'                           => 'Återbetalning',
    'Reimbursement_name'                    => 'Ersättning',
    'Related_name'                          => 'Relaterad',
    'relates to_inward'                     => 'relaterad till',
    'is (partially) refunded by_inward'     => 'är (delvis) återbetalad av',
    'is (partially) paid for by_inward'     => 'är (delvis) betalad från',
    'is (partially) reimbursed by_inward'   => 'är (delvis) ersatt från',
    'inward_transaction'                    => 'Intransaktion',
    'outward_transaction'                   => 'Utgående transaktion',
    'relates to_outward'                    => 'relaterad till',
    '(partially) refunds_outward'           => '(delvis) återbetalningar',
    '(partially) pays for_outward'          => '(delvis) betalning för',
    '(partially) reimburses_outward'        => '(delvis) ersättning',
    'is (partially) refunded by'            => 'är (delvis) återbetalad av',
    'is (partially) paid for by'            => 'betalas (delvis) av',
    'is (partially) reimbursed by'          => 'ersätts (delvis) av',
    'relates to'                            => 'relaterar till',
    '(partially) refunds'                   => '(delvis) återbetalning',
    '(partially) pays for'                  => '(delvis) betalar för',
    '(partially) reimburses'                => '(delvis) återbetalar',

    // split a transaction:
    'splits'                                => 'Dela upp',
    'add_another_split'                     => 'Lägga till en annan delning',
    'cannot_edit_opening_balance'           => 'Går inte ändra öppningsbalansen på ett konto.',
    'no_edit_multiple_left'                 => 'Du har inte valt en giltig transaktion att ändra.',
    'breadcrumb_convert_group'              => 'Konvertera transaktion',
    'convert_invalid_source'                => 'Källinformation är ogiltig för transaktion #%d.',
    'convert_invalid_destination'           => 'Destinationsinformation är ogiltig för transaktion #%d.',
    'create_another'                        => 'Efter sparat, återkom hit för att skapa ytterligare en.',
    'after_update_create_another'           => 'Efter uppdaterat, återkom hit för att fortsätta redigera.',
    'store_as_new'                          => 'Spara en ny transaktion istället för att uppdatera.',
    'reset_after'                           => 'Återställ formulär efter inskickat',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Expandera delningen',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Minimera delning',

    // object groups
    'default_group_title_name'              => '(ogrupperad)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Låt oss skapa ett tillgångskonto!',
    'no_accounts_intro_asset'               => 'Inga tillgångskonton ännu. Tillgångskonton är dina huvudkonton: kontrollkonto, sparkonto, delat konto eller även ditt kreditkort.',
    'no_accounts_imperative_asset'          => 'För att börja använda Firefly III måste du skapa minst ett tillgångskonto. Låt oss göra det nu:',
    'no_accounts_create_asset'              => 'Skapa ett tillgångskonto',
    'no_accounts_title_expense'             => 'Låt oss skapa ett utgiftskonton!',
    'no_accounts_intro_expense'             => 'Du har inga utgiftskonton ännu. Utgiftskonton är de platser där du spenderar pengar, såsom butiker och stormarknader.',
    'no_accounts_imperative_expense'        => 'Utgiftskonton skapas automatiskt när du skapar transaktioner, men du kan skapa en manuellt också, om du vill. Låt oss skapa en nu:',
    'no_accounts_create_expense'            => 'Skapa ett utgiftskonto',
    'no_accounts_title_revenue'             => 'Låt oss skapa ett intäktskonto!',
    'no_accounts_intro_revenue'             => 'Du har inga intäktskonton än. Intäktskonton är de platser där du får pengar från, till exempel din arbetsgivare.',
    'no_accounts_imperative_revenue'        => 'Intäktskonton skapas automatiskt när du skapar transaktioner, men du kan skapa en manuellt också, om du vill. Låt oss skapa en nu:',
    'no_accounts_create_revenue'            => 'Skapa ett intäktskonto',
    'no_accounts_title_liabilities'         => 'Låt oss skapa en skuld!',
    'no_accounts_intro_liabilities'         => 'Du har inga skulder ännu. Skulder är de konton som registrerar dina (studerande) lån och andra skulder.',
    'no_accounts_imperative_liabilities'    => 'Du behöver inte använda den här funktionen, men det kan vara användbart om du vill hålla reda på dessa saker.',
    'no_accounts_create_liabilities'        => 'Skapa en ny skuld',
    'no_budgets_title_default'              => 'Låt oss skapa en budget',
    'no_rules_title_default'                => 'Låt oss skapa en regel',
    'no_budgets_intro_default'              => 'Du har inga budgetar ännu. Budgetar används för att organisera dina utgifter i logiska grupper, som du kan ge en soft-cap för att begränsa dina utgifter.',
    'no_rules_intro_default'                => 'Du har inga regler ännu. Regler är kraftfulla automatiseringar som kan hantera transaktioner åt dig.',
    'no_rules_imperative_default'           => 'Regler kan vara mycket användbara när du hanterar transaktioner. Låt oss skapa en nu:',
    'no_budgets_imperative_default'         => 'Budgetarna är de grundläggande verktygen för ekonomisk förvaltning. Låt oss skapa ett nu:',
    'no_budgets_create_default'             => 'Skapa en budget',
    'no_rules_create_default'               => 'Skapa en regel',
    'no_categories_title_default'           => 'Låt oss skapa en kategori!',
    'no_categories_intro_default'           => 'Du har inga kategorier ännu. Kategorier används för att finjustera dina transaktioner och märka dem med deras utsedda kategori.',
    'no_categories_imperative_default'      => 'Kategorier skapas automatiskt när du skapar transaktioner, men du kan skapa en manuellt också. Låt oss skapa en nu:',
    'no_categories_create_default'          => 'Skapa en kategori',
    'no_tags_title_default'                 => 'Skapa en etikett!',
    'no_tags_intro_default'                 => 'Du har inga etiketter ännu. Etiketter används för att finjustera transaktioner och märka dem med specifika nyckelord.',
    'no_tags_imperative_default'            => 'Etiketter skapas automatiskt när du skapar transaktioner, men de går att skapa manuellt också. Låt oss skapa en nu:',
    'no_tags_create_default'                => 'Skapa en etikett',
    'no_transactions_title_withdrawal'      => 'Låt oss skapa en kostnad!',
    'no_transactions_intro_withdrawal'      => 'Du har inga utgifter ännu. Du bör skapa utgifter för att börja hantera din ekonomi.',
    'no_transactions_imperative_withdrawal' => 'Har du spenderat lite pengar? Då ska du skriva ner det:',
    'no_transactions_create_withdrawal'     => 'Skapa en kostnad',
    'no_transactions_title_deposit'         => 'Låt oss skapa lite inkomst!',
    'no_transactions_intro_deposit'         => 'Du har inga registrerade inkomster ännu. Du bör skapa inkomstposter för att börja hantera din ekonomi.',
    'no_transactions_imperative_deposit'    => 'Har du fått lite pengar? Då ska du skriva ner det:',
    'no_transactions_create_deposit'        => 'Skapa en insättning',
    'no_transactions_title_transfers'       => 'Låt oss skapa en överföring!',
    'no_transactions_intro_transfers'       => 'Du har inga överföringar ännu. När du flyttar pengar mellan tillgångskonton registreras det som överföring.',
    'no_transactions_imperative_transfers'  => 'Har du flyttat lite pengar runt? Då ska du skriva ner det:',
    'no_transactions_create_transfers'      => 'Skapa en överföring',
    'no_piggies_title_default'              => 'Låt oss skapa en spargris!',
    'no_piggies_intro_default'              => 'Du har inga spargrisar ännu. Du kan skapa spargrisar för att dela upp dina besparingar och hålla reda på vad du sparar på.',
    'no_piggies_imperative_default'         => 'Har du saker du sparar pengar till? Skapa en spargris och håll reda på:',
    'no_piggies_create_default'             => 'Skapa en ny sparbank',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Återkommande transaktioner',
    'repeat_until_in_past'                  => 'Denna återkommande transaktion slutade upprepas :date.',
    'recurring_calendar_view'               => 'Kalender',
    'no_recurring_title_default'            => 'Låt oss skapa en återkommande transaktion!',
    'no_recurring_intro_default'            => 'Du har inga återkommande transaktioner än. Dessa kan användas för att låta Firefly III automatiskt skapa transaktioner åt dig.',
    'no_recurring_imperative_default'       => 'Detta är en ganska avancerad funktion, men det kan vara mycket användbart. Se till att du läser dokumentationen (?)-ikonen i det övre högra hörnet) innan du fortsätter.',
    'no_recurring_create_default'           => 'Skapa en återkommande transaktion',
    'make_new_recurring'                    => 'Skapa en återkommande transaktion',
    'recurring_daily'                       => 'Dagligen',
    'recurring_weekly'                      => 'Varje vecka på :weekday',
    'recurring_weekly_skip'                 => 'Varje :skip(a/e) vecka på :weekday',
    'recurring_monthly'                     => 'Varje månad på :dayOfMonth(a/e) dag',
    'recurring_monthly_skip'                => 'Varje :skip(st/nd/rd/th) månad :dayOfMonth(st/nd/rd/th) dag',
    'recurring_ndom'                        => 'Varje månad på :dayOfMonth(a/e) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Varje år på :date',
    'overview_for_recurrence'               => 'Översikt för återkommande transaktioner ":title"',
    'warning_duplicates_repetitions'        => 'I sällsynta fall, kan datum förekomma flera gånger i denna lista. Detta kan ske när flera upprepningar kolliderar. Firefly III generar alltid en transaktion per dag.',
    'created_transactions'                  => 'Relaterade transaktioner',
    'expected_withdrawals'                  => 'Förväntade uttag',
    'expected_deposits'                     => 'Förväntade insättningar',
    'expected_transfers'                    => 'Förväntade överföringar',
    'created_withdrawals'                   => 'Skapade uttag',
    'created_deposits'                      => 'Skapade insättning',
    'created_transfers'                     => 'Skapade överföringar',
    'recurring_info'                        => 'Återkommande transaktion :count / :total',
    'created_from_recurrence'               => 'Skapad från återkommande transaktion ":title" (#:id)',
    'recurring_never_cron'                  => 'Det verkar som om cron-jobbet som är nödvändigt för att stödja återkommande transaktioner aldrig har kört. Detta är naturligtvis normalt när du just har installerat Firefly III, men detta bör vara något att ställa upp så snart som möjligt. Kolla in hjälpsidorna med hjälp av (?)-ikonen i det övre högra hörnet av sidan.',
    'recurring_cron_long_ago'               => 'Det verkar som om det har gått mer än 36 timmar sedan cronjobbet för att stödja återkommande transaktioner har sparkats för sista gången. Är du säker på att den har konfigurerats korrekt? Kolla in hjälpsidorna med hjälp av (?)-ikonen i det övre högra hörnet av sidan.',

    'create_new_recurrence'              => 'Skapa ny återkommande transaktion',
    'help_first_date'                    => 'Ange den första förväntade upprepningen. Detta måste vara i framtiden.',
    'help_first_date_no_past'            => 'Ange den första förväntade upprepningen. Firefly III kommer inte att skapa transaktioner i det förflutna.',
    'no_currency'                        => '(ingen valuta)',
    'mandatory_for_recurring'            => 'Obligatorisk återkommande information',
    'mandatory_for_transaction'          => 'Obligatorisk transaktionsinformation',
    'optional_for_recurring'             => 'Valfri återkommande information',
    'optional_for_transaction'           => 'Valfri transaktionsinformation',
    'change_date_other_options'          => 'Ändra "första datumet" för att se fler alternativ.',
    'mandatory_fields_for_tranaction'    => 'Värdena här kommer att hamna i de transaktion(er) som skapas',
    'click_for_calendar'                 => 'Klicka här för en kalender som visar dig när transaktionen ska upprepas.',
    'repeat_forever'                     => 'Upprepa för alltid',
    'repeat_until_date'                  => 'Upprepa till datum',
    'repeat_times'                       => 'Upprepa ett antal gånger',
    'recurring_skips_one'                => 'Varannan',
    'recurring_skips_more'               => 'Hoppar över :count förekomster',
    'store_new_recurrence'               => 'Lagra återkommande transaktion',
    'stored_new_recurrence'              => 'Återkommande transaktion ":title" lagras framgångsrikt.',
    'edit_recurrence'                    => 'Redigera återkommande transaktion ":title"',
    'recurring_repeats_until'            => 'Upprepas till :date',
    'recurring_repeats_forever'          => 'Upprepa för alltid',
    'recurring_repeats_x_times'          => 'Upprepas :count gång|Upprepas :count gånger',
    'update_recurrence'                  => 'Uppdatera återkommande transaktion',
    'updated_recurrence'                 => 'Uppdaterade återkommande transaktion ":title"',
    'recurrence_is_inactive'             => 'Denna återkommande transaktion är inte aktiv och kommer inte generera nya transaktioner.',
    'delete_recurring'                   => 'Ta bort återkommande transaktion ":title"',
    'new_recurring_transaction'          => 'Ny återkommande transaktion',
    'help_weekend'                       => 'Vad ska Firefly III göra när den återkommande transaktionen infaller på en lördag eller söndag?',
    'do_nothing'                         => 'Skapa bara transaktionen',
    'skip_transaction'                   => 'Hoppa över förekomsten',
    'jump_to_friday'                     => 'Skapa transaktionen på föregående fredag istället',
    'jump_to_monday'                     => 'Skapa transaktionen nästa måndag istället',
    'will_jump_friday'                   => 'Kommer att skapas på fredag istället för helgerna.',
    'will_jump_monday'                   => 'Kommer att skapas på måndag istället för helgerna.',
    'except_weekends'                    => 'Förutom helger',
    'recurrence_deleted'                 => 'Återkommande transaktion ":title" raderad',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Balans (:currency)',
    'box_spent_in_currency'              => 'Spenderat (:currency)',
    'box_earned_in_currency'             => 'Intjänat (:currency)',
    'box_budgeted_in_currency'           => 'Budgeterat (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Kvar att spendera (:currency)',
    'box_net_worth_in_currency'          => 'Netto värde (:currency)',
    'box_spend_per_day'                  => 'Kvar att spendera per dag :amount',

    // debug page
    'debug_page'                         => 'Debug sida',
    'debug_submit_instructions'          => 'Om du stöter på problem kan du använda informationen i den här rutan som felsökningsinformation. Kopiera och klistra in i ett nytt eller befintligt <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub-problem</a>. Det kommer att generera en vacker tabell som kan användas för att snabbt diagnostisera ditt problem.',
    'debug_pretty_table'                 => 'Om du kopierar/klistrar in rutan nedan i ett GitHub-problem kommer det att generera en tabell. Omge inte denna text med backticks eller citat.',
    'debug_additional_data'              => 'Du kan också dela innehållet i rutan nedan. Du kan också kopiera och klistra in detta i en ny eller befintlig <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub-utgåva</a>. Innehållet i denna ruta kan dock innehålla privat information som kontonamn, transaktionsuppgifter eller e-postadresser.',

    // object groups
    'object_groups_menu_bar'             => 'Grupper',
    'object_groups_page_title'           => 'Grupper',
    'object_groups_breadcrumb'           => 'Grupper',
    'object_groups_index'                => 'Översikt',
    'object_groups'                      => 'Grupper',
    'object_groups_empty_explain'        => 'Vissa saker i Firefly III kan delas in i grupper. Spargrisar till exempel, har ett "Grupp" fält i redigera och skapa vyerna. När du anger det här fältet kan du redigera gruppernas namn och ordning på den här sidan. För mer information, kolla in hjälpsidorna i det övre högra hörnet, under (?)-ikonen.',
    'object_group_title'                 => 'Titel',
    'edit_object_group'                  => 'Redigera grupp ":title"',
    'delete_object_group'                => 'Ta bort grupp ":title"',
    'update_object_group'                => 'Uppdatera grupp',
    'updated_object_group'               => 'Uppdaterade gruppen ":title"',
    'deleted_object_group'               => 'Tog bort gruppen ":title"',
    'object_group'                       => 'Grupp',

    // other stuff
    'placeholder'                        => '[Platshållare]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Spargris',
    'ale_action_remove_from_piggy'       => 'Spargris',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
