<?php

/**
 * ConfigurationRequest.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace FireflyIII\Api\V1\Requests\System;

use FireflyIII\Rules\IsBoolean;
use FireflyIII\Support\Request\ChecksLogin;
use FireflyIII\Support\Request\ConvertsDataTypes;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class UpdateRequest
 */
class UpdateRequest extends FormRequest
{
    use ChecksLogin;
    use ConvertsDataTypes;

    private array $booleans = ['configuration.is_demo_site', 'configuration.single_user_mode', 'configuration.enable_exchange_rates', 'configuration.use_running_balance', 'configuration.enable_external_map', 'configuration.enable_external_rates', 'configuration.allow_webhooks'];
    private array $integers = ['configuration.permission_update_check', 'configuration.last_update_check'];

    /**
     * Get all data from the request.
     */
    public function getAll(): array
    {
        $name = $this->route()->parameter('dynamicConfigKey');
        if (in_array($name, $this->booleans, true)) {
            return ['value' => $this->boolean('value')];
        }
        if (in_array($name, $this->integers, true)) {
            return ['value' => $this->convertInteger('value')];
        }

        return ['value' => $this->convertString('value')];
    }

    /**
     * The rules that the incoming request must be matched against.
     */
    public function rules(): array
    {
        $name = $this->route()->parameter('configName');

        if (in_array($name, $this->booleans, true)) {
            return ['value' => ['required', new IsBoolean()]];
        }
        if ('configuration.permission_update_check' === $name) {
            return ['value' => 'required|numeric|min:-1|max:1'];
        }
        if (in_array($name, $this->integers, true)) {
            return ['value' => 'required|numeric|min:464272080'];
        }

        return ['value' => 'required'];
    }
}
