<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stocké en ":timezone"',
    'displayed_in_tz'                           => 'affiché en ":timezone"',
    'close'                                     => 'Fermer',
    'actions'                                   => 'Actions',
    'edit'                                      => 'Modifier',
    'loading'                                   => 'Сhargement',
    'transaction_journal_id'                    => 'ID du journal des opérations',
    'delete'                                    => 'Supprimer',
    'split'                                     => 'Séparation',
    'single_split'                              => 'Séparation unique',
    'clone'                                     => 'Cloner',
    'clone_and_edit'                            => 'Cloner et modifier',
    'confirm_action'                            => 'Confirmer l\'action',
    'last_seven_days'                           => '7 Derniers Jours',
    'last_thirty_days'                          => 'Trente derniers jours',
    'last_180_days'                             => '180 derniers jours',
    'month_to_date'                             => 'Ce mois-ci',
    'year_to_date'                              => 'Année en cours',
    'previous_year' => 'Année précédente (:year)',
    'YTD'                                       => 'Année en cours',
    'welcome_back'                              => 'Quoi de neuf ?',
    'main_dashboard_page_title'                 => 'Accueil',
    'everything'                                => 'Tout',
    'today'                                     => 'aujourd\'hui',
    'customRange'                               => 'Intervalle personnalisé',
    'date_range'                                => 'Intervalle de dates',
    'apply'                                     => 'Appliquer',
    'select_date'                               => 'Sélectionner une date...',
    'cancel'                                    => 'Annuler',
    'from'                                      => 'Depuis',
    'to'                                        => 'A',
    'structure'                                 => 'Structure',
    'help_translating'                          => 'Ce texte d\'aide n\'est pas encore disponible en français. <a href="https://crowdin.com/project/firefly-iii-help">Voulez-vous aider à le traduire ?</a>',
    'showEverything'                            => 'Tout Afficher',
    'never'                                     => 'Jamais',
    'no_results_for_empty_search'               => 'Votre recherche était vide, rien n’a été trouvé.',
    'removed_amount'                            => 'Enlevé :amount',
    'added_amount'                              => 'Ajouté :amount',
    'asset_account_role_help'                   => 'Toutes options supplémentaires résultant de votre choix peuvent être réglées plus tard.',
    'Opening balance'                           => 'Solde initial',
    'create_new_stuff'                          => 'Créer de nouvelles choses',
    'new_withdrawal'                            => 'Nouvelle dépense',
    'create_new_transaction'                    => 'Créer une nouvelle opération',
    'sidebar_frontpage_create'                  => 'Créer',
    'new_transaction'                           => 'Nouvelle opération',
    'no_rules_for_bill'                         => 'Cet abonnement n\'a aucune règle associée.',
    'go_to_asset_accounts'                      => 'Afficher vos comptes d\'actifs',
    'go_to_budgets'                             => 'Gérer vos budgets',
    'go_to_withdrawals'                         => 'Accéder à vos retraits',
    'clones_journal_x'                          => 'Cette opération est un clone de ":description" (#:id)',
    'go_to_categories'                          => 'Gérer vos catégories',
    'go_to_bills'                               => 'Accédez à vos abonnements',
    'go_to_expense_accounts'                    => 'Voir vos comptes de dépenses',
    'go_to_revenue_accounts'                    => 'Voir vos comptes de revenus',
    'go_to_piggies'                             => 'Gérer vos tirelires',
    'new_deposit'                               => 'Nouveau dépôt',
    'new_transfer'                              => 'Nouveau transfert',
    'new_transfers'                             => 'Nouveau transfert',
    'new_asset_account'                         => 'Nouveau compte d’actif',
    'new_expense_account'                       => 'Nouveau compte de dépenses',
    'new_revenue_account'                       => 'Nouveau compte de recettes',
    'new_liabilities_account'                   => 'Nouveau passif',
    'new_budget'                                => 'Nouveau budget',
    'new_bill'                                  => 'Nouvel abonnement',
    'block_account_logout'                      => 'Vous avez été déconnecté. Les comptes bloqués ne peuvent pas utiliser ce site. Vous êtes-vous enregistré avec une adresse e-mail valide ?',
    'flash_success'                             => 'Super !',
    'flash_info'                                => 'Message',
    'flash_warning'                             => 'Attention !',
    'flash_error'                               => 'Erreur !',
    'flash_danger'                              => 'Danger !',
    'flash_info_multiple'                       => 'Il y a un message| Il y a :count messages',
    'flash_error_multiple'                      => 'Il y a une erreur|Il y a :count erreurs',
    'net_worth'                                 => 'Avoir net',
    'help_for_this_page'                        => 'Aide pour cette page',
    'help_for_this_page_body'                   => 'Vous pouvez trouver plus d\'informations sur cette page <a href="https://docs.firefly-iii.org/">dans la documentation</a>.',
    'two_factor_welcome'                        => 'Bonjour !',
    'two_factor_enter_code'                     => 'Pour continuer, veuillez entrer votre code d’authentification à deux facteurs. Votre application peut la générer pour vous.',
    'two_factor_code_here'                      => 'Entrez votre code ici',
    'two_factor_title'                          => 'Authentification à deux facteurs',
    'authenticate'                              => 'S\'authentifier',
    'two_factor_forgot_title'                   => 'Perte de l’authentification à deux facteurs',
    'two_factor_forgot'                         => 'J’ai oublié mon code d\'identification à deux facteurs.',
    'two_factor_lost_header'                    => 'Perdu votre authentification à deux facteurs ?',
    'two_factor_lost_intro'                     => 'Si vous avez aussi perdu vos codes de récupération, vous n\'avez pas de chance. Ce n\'est pas quelque chose que vous pouvez corriger depuis l\'interface web. Vous avez deux choix.',
    'two_factor_lost_fix_self'                  => 'Si vous utilisez votre propre instance de Firefly III, lisez <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">cette entrée de la FAQ</a> pour obtenir des instructions.',
    'two_factor_lost_fix_owner'                 => 'Dans le cas contraire, contactez le propriétaire du site par courriel <a href="mailto::site_owner">:site_owner</a> et demandez-lui de réinitialiser votre authentification à deux facteurs.',
    'mfa_backup_code'                           => 'Vous avez utilisé un code de récupération pour vous connecter à Firefly III. Il ne peut être réutilisé, donc rayez-le de votre liste.',
    'pref_two_factor_new_backup_codes'          => 'Obtenir de nouveaux codes de récupération',
    'pref_two_factor_backup_code_count'         => 'Vous avez :count code de récupération valide.|Vous avez :count codes de récupération valides.',
    '2fa_i_have_them'                           => 'Je les ai enregistrés !',
    'warning_much_data'                         => ':days jours de données peuvent prendre un certain temps à charger.',
    'registered'                                => 'Vous avez été enregistré avec succès !',
    'Default asset account'                     => 'Compte d’actif par défaut',
    'no_budget_pointer'                         => 'Vous semblez n’avoir encore aucun budget. Vous devriez en créer un sur la page des <a href="budgets">budgets</a>. Les budgets peuvent vous aider à garder une trace des dépenses.',
    'no_bill_pointer'                           => 'Vous semblez n’avoir encore aucun abonnement. Vous devriez en créer un sur la page des <a href="subscriptions">abonnements</a>. Les abonnements peuvent vous aider à garder une trace des dépenses.',
    'Savings account'                           => 'Compte d’épargne',
    'Credit card'                               => 'Carte de Crédit',
    'source_accounts'                           => 'Compte source|Comptes source',
    'destination_accounts'                      => 'Compte de destination|Comptes de destination',
    'user_id_is'                                => 'Votre identifiant d’utilisateur est <strong>:user</strong>',
    'field_supports_markdown'                   => 'Ce champ prend en charge la <a href="https://en.support.wordpress.com/markdown-quick-reference/">syntaxe Markdown</a>.',
    'need_more_help'                            => 'Si vous désirez plus de renseignements sur l\'utilisation de Firefly III, merci <a href="https://github.com/firefly-iii/firefly-iii/issues">d\'ouvrir un ticket sur Github</a>.',
    'reenable_intro_text'                       => 'Vous pouvez également réactiver <a href="#" id="reenableGuidance">le guide d\'introduction</a>.',
    'intro_boxes_after_refresh'                 => 'Les boîtes d\'introduction réapparaîtront lorsque vous actualiserez la page.',
    'show_all_no_filter'                        => 'Montrer toutes les opérations sans les classer par date.',
    'expenses_by_category'                      => 'Dépenses par catégorie',
    'expenses_by_budget'                        => 'Dépenses par budget',
    'income_by_category'                        => 'Revenu par catégorie',
    'expenses_by_asset_account'                 => 'Dépenses par compte d’actif',
    'expenses_by_expense_account'               => 'Dépenses par compte de destination',
    'cannot_redirect_to_account'                => 'Firefly III n\'est pas en mesure de vous rediriger vers la bonne page. Veuillez nous en excuser.',
    'sum_of_expenses'                           => 'Montant des dépenses',
    'sum_of_income'                             => 'Montant des revenus',
    'liabilities'                               => 'Passifs',
    'spent_in_specific_budget'                  => 'Dépensé dans le budget ":budget"',
    'spent_in_specific_double'                  => 'Dépensé dans le compte ":account"',
    'earned_in_specific_double'                 => 'Gagné dans le compte ":account"',
    'source_account'                            => 'Compte source',
    'source_account_reconciliation'             => 'Vous ne pouvez pas modifier le compte source d\'une opération de rapprochement.',
    'destination_account'                       => 'Compte de destination',
    'destination_account_reconciliation'        => 'Vous ne pouvez pas modifier le compte de destination d\'une opération de rapprochement.',
    'sum_of_expenses_in_budget'                 => 'Total dépensé dans le budget ":budget"',
    'left_in_budget_limit'                      => 'Reste à dépenser selon budget',
    'current_period'                            => 'Période en cours',
    'show_the_current_period_and_overview'      => 'Afficher l’exercice en cours et sa vue d’ensemble',
    'pref_anonymous' => 'Montants masqués',
    'pref_anonymous_help' => 'Vous pouvez faire en sorte que Firefly III masque tous les montants pour des raisons de confidentialité et d\'anonymat. Cela ne masquera pas les montants dans les boîtes d\'édition, mais le reste sera caché. Vous pouvez également activer/désactiver cela avec la petite icône "oeil" dans la barre du haut.',
    'pref_anonymous_label' => 'Masquer les montants',
    'pref_languages_locale'                     => 'Pour une langue autre que l’anglais et pour fonctionner correctement, votre système d’exploitation doit être équipé avec les paramètres régionaux corrects. S\'ils ne sont pas présents, les données de devises, les dates et les montants peuvent être mal formatés.',
    'budget_in_period'                          => 'Toutes les opérations pour le budget ":name" entre :start et :end dans la monnaie :currency',
    'chart_budget_in_period'                    => 'Graphique pour toutes les opérations pour le budget ":name" entre :start et :end dans :currency',
    'chart_budget_in_period_only_currency'      => 'Le montant que vous avez budgété était en :currency, ce graphique ne montrera donc que les opérations en :currency.',
    'chart_account_in_period'                   => 'Graphique pour toutes les opérations pour le compte ":name" (:balance) entre :start et :end',
    'chart_category_in_period'                  => 'Graphique pour toutes les opérations pour la catégorie ":name" entre :start et :end',
    'chart_category_all'                        => 'Graphique pour toutes les opérations pour la catégorie ":name"',
    'clone_withdrawal'                          => 'Cloner cette dépense',
    'clone_deposit'                             => 'Cloner ce dépôt',
    'clone_transfer'                            => 'Cloner ce transfert',
    'multi_select_no_selection'                 => 'Aucun sélectionné',
    'multi_select_select_all'                   => 'Tout sélectionner',
    'multi_select_n_selected'                   => 'sélectionné',
    'multi_select_all_selected'                 => 'Tous sélectionnés',
    'multi_select_filter_placeholder'           => 'Rechercher..',
    'intro_next_label'                          => 'Suivant',
    'intro_prev_label'                          => 'Précédent',
    'intro_skip_label'                          => 'Ignorer',
    'intro_done_label'                          => 'Terminé',
    'between_dates_breadcrumb'                  => 'Entre :start et :end',
    'all_journals_without_budget'               => 'Toutes les opérations sans budget',
    'journals_without_budget'                   => 'Opérations sans budget',
    'all_journals_without_category'             => 'Toutes les opérations sans catégorie',
    'journals_without_category'                 => 'Opérations sans catégorie',
    'all_journals_for_account'                  => 'Toutes les opérations pour le compte :name',
    'chart_all_journals_for_account'            => 'Tableau de toutes les opérations pour le compte :name',
    'journals_in_period_for_account'            => 'Toutes les opérations pour le compte :name entre :start et :end',
    'journals_in_period_for_account_js'         => 'Toutes les opérations pour le compte {title} entre {start} et {end}',
    'transferred'                               => 'Transféré',
    'all_withdrawal'                            => 'Toutes les dépenses',
    'all_transactions'                          => 'Toutes les opérations',
    'title_withdrawal_between'                  => 'Toutes les dépenses entre :start et :end',
    'all_deposit'                               => 'Toutes les recettes',
    'title_deposit_between'                     => 'Toutes les recettes entre :start et :end',
    'all_transfers'                             => 'Tous les transferts',
    'title_transfers_between'                   => 'Tous les transferts entre :start et :end',
    'all_transfer'                              => 'Tous les transferts',
    'all_journals_for_tag'                      => 'Toutes les opérations pour le tag ":tag"',
    'title_transfer_between'                    => 'Tous les transferts entre :start et :end',
    'all_journals_for_category'                 => 'Toutes les opérations pour la catégorie :name',
    'all_journals_for_budget'                   => 'Toutes les opérations pour le budget :name',
    'chart_all_journals_for_budget'             => 'Graphique pour toutes les opérations pour le budget :name',
    'journals_in_period_for_category'           => 'Toutes les opérations pour la catégorie :name entre :start et :end',
    'journals_in_period_for_tag'                => 'Toutes les opérations de tag :tag entre :start et :end',
    'not_available_demo_user'                   => 'La fonctionnalité à laquelle vous essayez d’accéder n’est pas disponible pour les utilisateurs de la démo.',
    'exchange_rate_instructions'                => 'Le compte d’actif "@name" n’accepte que les opérations en @primary_currency. Si vous souhaitez utiliser @foreign_currency à la place, assurez-vous que le montant en @primary_currency est aussi bien connu :',
    'transfer_exchange_rate_instructions'       => 'Compte d’actif source "@source_name" n’accepte que les opérations en @source_currency. Compte d’actif "@dest_name" de destination n’accepte que les opérations en @dest_currency. Vous devez fournir le montant transféré correctement dans les deux devises.',
    'transaction_data'                          => 'Données d\'opération',
    'invalid_server_configuration'              => 'Configuration de serveur invalide',
    'invalid_locale_settings'                   => 'Firefly III ne parvient pas à formater les montants monétaires car il manque des paquets logiciels sur votre serveur. Voici <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">des instructions sur comment procéder</a>.',
    'quickswitch'                               => 'Changement rapide',
    'sign_in_to_start'                          => 'Identifiez-vous pour commencer votre session',
    'sign_in'                                   => 'S\'identifier',
    'register_new_account'                      => 'Créer un nouveau compte',
    'forgot_my_password'                        => 'J\'ai oublié mon mot de passe',
    'problems_with_input'                       => 'Il y a eu quelques problèmes avec votre saisie.',
    'reset_password'                            => 'Réinitialisez votre mot de passe',
    'button_reset_password'                     => 'Réinitialiser le mot de passe',
    'reset_button'                              => 'Réinitialiser',
    'want_to_login'                             => 'Je veux me connecter',
    'login_page_title'                          => 'Connectez-vous à Firefly III',
    'register_page_title'                       => 'Enregistrez-vous à Firefly III',
    'forgot_pw_page_title'                      => 'Mot de passe Firefly III oublié',
    'reset_pw_page_title'                       => 'Réinitialiser votre mot de passe Firefly III',
    'cannot_reset_demo_user'                    => 'Vous ne pouvez pas réinitialiser le mot de passe de l\'utilisateur de démonstration.',
    'no_att_demo_user'                          => 'L\'utilisateur de la démo ne peut pas envoyer de pièces jointes.',
    'button_register'                           => 'S\'inscrire',
    'authorization'                             => 'Autorisation',
    'active_bills_only'                         => 'abonnement actif uniquement',
    'active_bills_only_total'                   => 'tous les abonnements actifs',
    'active_exp_bills_only'                     => 'uniquement les abonnements actifs et attendus',
    'active_exp_bills_only_total'               => 'uniquement les abonnements actifs attendus',
    'per_period_sum_1D'                         => 'Coûts journaliers attendus',
    'per_period_sum_1W'                         => 'Coûts hebdomadaires attendus',
    'per_period_sum_1M'                         => 'Coûts mensuels attendus',
    'per_period_sum_3M'                         => 'Coûts trimestriels attendus',
    'per_period_sum_6M'                         => 'Coûts semestriels attendus',
    'per_period_sum_1Y'                         => 'Coûts annuels attendus',
    'average_per_bill'                          => 'moyenne par abonnement',
    'expected_total'                            => 'total prévu',
    'reconciliation_account_name'               => 'Régularisation de :name (:currency)',
    'saved'                                     => 'Sauvegardé',
    'advanced_options'                          => 'Options avancées',
    'advanced_options_explain'                  => 'Certaines pages de Firefly III ont des options avancées cachées derrière ce bouton. Cette page n\'a rien de bien utile ici, mais regardez les autres !',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III a détecté que vous avez des opérations avant l\'année 1970. Veuillez corriger ces transactions au plus vite.',
    'anonymous_warning_on'                      => 'Pour votre confidentialité, tous les montants sont maintenant affichés comme "zéro". Attention : les champs de saisie de texte peuvent toujours afficher les montants d\'origine !',
    'anonymous_warning_off'                     => 'Les montants seront à nouveau visibles. Soyez vigilant.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'désactivé',
    'no_webhook_messages'                       => 'Il n\'y a pas de messages webhook',
    'webhook_trigger_ANY'         => 'Après n\'importe quel événement',
    'webhook_trigger_STORE_TRANSACTION'         => 'Après la création de l\'opération',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Après la mise à jour de l\'opération',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Après la suppression de l\'opération',
    'webhook_trigger_STORE_BUDGET'              => 'Après la création du budget',
    'webhook_trigger_UPDATE_BUDGET'             => 'Après la mise à jour du budget',
    'webhook_trigger_DESTROY_BUDGET'            => 'Après la suppression du budget',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'Après le changement du montant budgétisé',
    'webhook_response_TRANSACTIONS'             => 'Détails de l\'opération',
    'webhook_response_ACCOUNTS'                 => 'Détails du compte',
    'webhook_response_BUDGET'                   => 'Détails du budget',
    'webhook_response_RELEVANT'                 => 'Détails pertinents',
    'webhook_response_NONE'                     => 'Aucun détail',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspecter',
    'create_new_webhook'                        => 'Créer un nouveau webhook',
    'webhooks_create_breadcrumb'                => 'Créer un nouveau webhook',
    'webhook_trigger_form_help'                 => 'Indique sur quel événement le webhook va se déclencher',
    'webhook_response_form_help'                => 'Indiquer ce que le webhook doit envoyer à l\'URL.',
    'webhook_delivery_form_help'                => 'Le format dans lequel le webhook doit fournir des données.',
    'webhook_active_form_help'                  => 'Le webhook doit être actif, sinon il ne sera pas appelé.',
    'stored_new_webhook'                        => 'Nouveau webhook ":title " sauvegardé',
    'delete_webhook'                            => 'Supprimer le webhook',
    'deleted_webhook'                           => 'Webhook ":title" supprimé',
    'edit_webhook'                              => 'Modifier le webhook ":title"',
    'updated_webhook'                           => 'Webhook ":title" mis à jour',
    'edit_webhook_js'                           => 'Modifier le webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'Le webhook a été déclenché sur l\'opération indiquée. Veuillez attendre que les résultats apparaissent.',
    'webhook_messages'                          => 'Message webhook',
    'view_message'                              => 'Afficher le message',
    'view_attempts'                             => 'Voir les tentatives échouées',
    'message_content_title'                     => 'Contenu du message webhook',
    'message_content_help'                      => 'Il s\'agit du contenu du message qui a été envoyé (ou essayé) avec ce webhook.',
    'attempt_content_title'                     => 'Tentatives de webhook',
    'attempt_content_help'                      => 'Ce sont toutes les tentatives infructueuses de ce message webhook à envoyer à l\'URL configurée. Après un certain temps, Firefly III cessera d\'essayer.',
    'no_attempts'                               => 'Il n\'y a pas de tentatives infructueuses. C\'est une bonne chose !',
    'webhook_attempt_at'                        => 'Tentative à {moment}',
    'logs'                                      => 'Journaux',
    'response'                                  => 'Réponse',
    'visit_webhook_url'                         => 'Visiter l\'URL du webhook',
    'reset_webhook_secret'                      => 'Réinitialiser le secret du webhook',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Le Webhook #{ID} ("{title}")</a> a été enregistré.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Le webhook #{ID}</a> ("{title}") a été mis à jour.',

    // API access
    'authorization_request'                     => 'Firefly III v:version demande d\'autorisation',
    'authorization_request_intro'               => 'L\'application "<strong>:client</strong>" demande l\'autorisation d\'accéder à votre administration financière. Voulez-vous autoriser <strong>:client</strong> à accéder à ces enregistrements ?',
    'authorization_request_site'                => 'Vous allez être redirigé vers <code>:url</code> qui pourra ensuite accéder à vos données Firefly III.',
    'authorization_request_invalid'             => 'Cette demande d\'accès n\'est pas valide. Veuillez ne plus suivre ce lien.',
    'scopes_will_be_able'                       => 'Cette application pourra :',
    'button_authorize'                          => 'Autoriser',
    'none_in_select_list'                       => '(aucun)',
    'no_piggy_bank'                             => '(aucune tirelire)',
    'name_in_currency'                          => ':name en :currency',
    'paid_in_currency'                          => 'Payé en :currency',
    'unpaid_in_currency'                        => 'Non payé en :currency',
    'is_alpha_warning'                          => 'Vous utilisez une version ALPHA. Méfiez-vous des bogues et des problèmes.',
    'is_beta_warning'                           => 'Vous utilisez une version BETA. Méfiez-vous des bogues et des problèmes.',
    'all_destination_accounts'                  => 'Comptes de destination',
    'all_source_accounts'                       => 'Comptes source',
    'back_to_index'                             => 'Retour à l\'accueil',
    'cant_logout_guard'                         => 'Firefly III ne peut pas vous déconnecter.',
    'internal_reference'                        => 'Référence interne',

    // check for updates:
    'update_check_title'                        => 'Vérifier les mises à jour',
    'admin_update_check_title'                  => 'Rechercher automatiquement les mises à jour',
    'admin_update_check_explain'                => 'Firefly III peut vérifier les mises à jour automatiquement. Lorsque vous activez ce paramètre, il contacte le serveur de mise à jour de Firefly III pour voir si une nouvelle version de Firefly III est disponible. Quand c\'est le cas, vous recevrez une notification. Vous pouvez tester cette notification en utilisant le bouton sur la droite. Veuillez indiquer ci-dessous si vous voulez que Firefly III vérifie les mises à jour.',
    'check_for_updates_permission'              => 'Firefly III peut vérifier les mises à jour, mais il a besoin de votre permission pour le faire. Veuillez vous rendre dans les <a href=":link">paramètres</a> pour indiquer si vous souhaitez que cette fonctionnalité soit activée.',
    'updates_ask_me_later'                      => 'Me demander plus tard',
    'updates_do_not_check'                      => 'Ne pas vérifier les mises à jour',
    'updates_enable_check'                      => 'Activer la vérification des mises à jour',
    'admin_update_check_now_title'              => 'Vérifier les mises à jour maintenant',
    'admin_update_check_now_explain'            => 'Si vous appuyez sur le bouton, Firefly III verra si votre version actuelle est la dernière.',
    'check_for_updates_button'                  => 'Vérifier maintenant !',
    'update_new_version_alert'                  => 'Une nouvelle version de Firefly III est disponible. Vous utilisez v:your_version. La dernière version v:new_version a été publiée le :date.',
    'update_version_beta'                       => 'Cette version est une version BETA. Vous pouvez rencontrer des problèmes.',
    'update_version_alpha'                      => 'Cette version est une version ALPHA. Vous pourriez rencontrer des problèmes.',
    'update_current_dev_older'                  => 'Vous utilisez la version de développement ":version", qui est plus ancienne que la dernière version :new_version. Veuillez la mettre à jour !',
    'update_current_dev_newer'                  => 'Vous utilisez la version de développement ":version", qui est plus récente que la dernière version :new_version.',
    'update_current_version_alert'              => 'Vous utilisez v:version, la dernière version disponible.',
    'update_newer_version_alert'                => 'Vous utilisez v:your_version, qui est plus récente que la dernière version, v:new_version.',
    'update_check_error'                        => 'Une erreur est survenue lors de la vérification d\'une mise à jour : :error',
    'unknown_error'                             => 'Erreur inconnue. Désolé.',
    'disabled_but_check'                        => 'Vous avez désactivé la vérification des mises à jour. N\'oubliez donc pas de vérifier vous-même les mises à jour de temps en temps. Merci !',
    'admin_update_channel_title'                => 'Canal de mise à jour',
    'admin_update_channel_explain'              => 'Firefly III dispose de trois canaux de mise à jour qui déterminent ce que vous êtes prêt à accepter en termes de fonctionnalités, d\'améliorations et de bogues. Utilisez le canal « bêta » si vous êtes aventurier et le « alpha » lorsque vous aimez vivre dangereusement.',
    'update_channel_stable'                     => 'Stable. Tout devrait fonctionner comme prévu.',
    'update_channel_beta'                       => 'Bêta. De nouvelles fonctionnalités sont présentes, mais il peut exister des régressions.',
    'update_channel_alpha'                      => 'Alpha. Nous essayons des choses et gardons ce qui fonctionne.',

    // search
    'search'                                    => 'Rechercher',
    'search_query'                              => 'Requête',
    'search_found_transactions'                 => 'Firefly III a trouvé :count opération en :time secondes.|Firefly III a trouvé :count opérations en :time secondes.',
    'search_found_more_transactions'            => 'Firefly III a trouvé plus de :count transactions en :time secondes.',
    'search_for_overview'                       => 'Firefly III recherche des opérations qui remplissent <b>toutes</b> les conditions suivantes :',
    'search_for_query'                          => 'Tous ces mots doivent être présents : <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Aucun de ces mots ne doit être présent : <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Ces paramètres de recherche ne sont pas valides et ont été ignorés.',

    // old


    'search_modifier_date_on'                             => 'La date de l\'opération est ":value"',
    'search_modifier_not_date_on'                         => 'La date de l\'opération n\'est pas ":value"',
    'search_modifier_reconciled'                          => 'L\'opération est rapprochée',
    'search_modifier_not_reconciled'                      => 'L\'opération n\'est pas rapprochée',
    'search_modifier_id'                                  => 'L\'ID de l\'opération est ":value"',
    'search_modifier_not_id'                              => 'L\'ID de l\'opération n\'est pas ":value"',
    'search_modifier_date_before'                         => 'La date de l\'opération est avant ou le ":value"',
    'search_modifier_date_after'                          => 'La date de l\'opération est après ou le ":value"',
    'search_modifier_external_id_is'                      => 'L\'ID externe est ":value"',
    'search_modifier_not_external_id_is'                  => 'L\'ID externe n\'est pas ":value"',
    'search_modifier_no_external_url'                     => 'L\'opération n\'a pas d\'URL externe',
    'search_modifier_no_external_id'                      => 'L\'opération n\'a pas d\'ID externe',
    'search_modifier_not_any_external_url'                => 'L\'opération n\'a pas d\'URL externe',
    'search_modifier_not_any_external_id'                 => 'L\'opération n\'a pas d\'ID externe',
    'search_modifier_any_external_url'                    => 'L\'opération doit avoir une URL externe',
    'search_modifier_any_external_id'                     => 'L\'opération doit avoir un ID externe (n\'importe lequel)',
    'search_modifier_not_no_external_url'                 => 'L\'opération doit avoir une URL externe',
    'search_modifier_not_no_external_id'                  => 'L\'opération doit avoir un ID externe (n\'importe lequel)',
    'search_modifier_internal_reference_is'               => 'La référence interne est ":value"',
    'search_modifier_not_internal_reference_is'           => 'La référence interne n\'est pas ":value"',
    'search_modifier_description_starts'                  => 'La description commence par ":value"',
    'search_modifier_not_description_starts'              => 'La description ne commence pas par ":value"',
    'search_modifier_description_ends'                    => 'La description se termine par ":value"',
    'search_modifier_not_description_ends'                => 'La description ne se termine pas par ":value"',
    'search_modifier_description_contains'                => 'La description contient ":value"',
    'search_modifier_not_description_contains'            => 'La description ne contient pas ":value"',
    'search_modifier_description_is'                      => 'La description est exactement ":value"',
    'search_modifier_not_description_is'                  => 'La description n\'est pas exactement ":value"',
    'search_modifier_currency_is'                         => 'La devise (étrangère) de l\'opération est ":value"',
    'search_modifier_not_currency_is'                     => 'La devise (étrangère) de l\'opération n\'est pas ":value"',
    'search_modifier_foreign_currency_is'                 => 'La devise étrangère de l\'opération est ":value"',
    'search_modifier_not_foreign_currency_is'             => 'La devise étrangère de l\'opération n\'est pas ":value"',
    'search_modifier_has_attachments'                     => 'L\'opération doit avoir une pièce jointe',
    'search_modifier_has_no_category'                     => 'L\'opération ne doit pas avoir de catégorie',
    'search_modifier_not_has_no_category'                 => 'L\'opération doit avoir une catégorie',
    'search_modifier_not_has_any_category'                => 'L\'opération ne doit pas avoir de catégorie',
    'search_modifier_has_any_category'                    => 'L\'opération doit avoir une catégorie',
    'search_modifier_has_no_budget'                       => 'L\'opération ne doit pas avoir de budget',
    'search_modifier_not_has_any_budget'                  => 'L\'opération ne doit pas avoir de budget',
    'search_modifier_has_any_budget'                      => 'L\'opération doit avoir un budget',
    'search_modifier_not_has_no_budget'                   => 'L\'opération doit avoir un budget',
    'search_modifier_has_no_bill'                         => 'L\'opération ne doit pas avoir d’abonnement',
    'search_modifier_not_has_no_bill'                     => 'L\'opération doit avoir un abonnement',
    'search_modifier_has_any_bill'                        => 'L\'opération doit avoir un abonnement',
    'search_modifier_not_has_any_bill'                    => 'L\'opération ne doit pas avoir d’abonnement',
    'search_modifier_has_no_tag'                          => 'L\'opération ne doit pas avoir de tags',
    'search_modifier_not_has_any_tag'                     => 'L\'opération ne doit pas avoir de tags',
    'search_modifier_not_has_no_tag'                      => 'L\'opération doit avoir (au moins) un tag',
    'search_modifier_has_any_tag'                         => 'L\'opération doit avoir un tag (n\'importe lequel)',
    'search_modifier_notes_contains'                      => 'Les notes de l\'opération contiennent ":value"',
    'search_modifier_not_notes_contains'                  => 'Les notes de l\'opération ne contiennent pas ":value"',
    'search_modifier_notes_starts'                        => 'Les notes de l\'opération commencent par ":value"',
    'search_modifier_not_notes_starts'                    => 'Les notes de l\'opération ne commencent pas par ":value"',
    'search_modifier_notes_ends'                          => 'Les notes de l\'opération se terminent par ":value"',
    'search_modifier_not_notes_ends'                      => 'Les notes de l\'opération ne se terminent pas par ":value"',
    'search_modifier_notes_is'                            => 'Les notes de l\'opération sont exactement ":value"',
    'search_modifier_not_notes_is'                        => 'Les notes de l\'opération ne sont pas exactement ":value"',
    'search_modifier_no_notes'                            => 'L\'opération n\'a pas de note',
    'search_modifier_not_no_notes'                        => 'L\'opération doit avoir des notes',
    'search_modifier_any_notes'                           => 'L\'opération doit avoir des notes',
    'search_modifier_not_any_notes'                       => 'L\'opération n\'a pas de note',
    'search_modifier_amount_is'                           => 'Le montant est exactement :value',
    'search_modifier_not_amount_is'                       => 'Le montant n\'est pas :value',
    'search_modifier_amount_less'                         => 'Le montant est inférieur ou égal à :value',
    'search_modifier_not_amount_more'                     => 'Le montant est inférieur ou égal à :value',
    'search_modifier_amount_more'                         => 'Le montant est supérieur ou égal à :value',
    'search_modifier_not_amount_less'                     => 'Le montant est supérieur ou égal à :value',
    'search_modifier_source_account_is'                   => 'Le nom du compte source est exactement ":value"',
    'search_modifier_not_source_account_is'               => 'Le nom du compte source n\'est pas ":value"',
    'search_modifier_source_account_contains'             => 'Le nom du compte source contient ":value"',
    'search_modifier_not_source_account_contains'         => 'Le nom du compte source ne contient pas ":value"',
    'search_modifier_source_account_starts'               => 'Le nom du compte source commence par ":value"',
    'search_modifier_not_source_account_starts'           => 'Le nom du compte source ne commence pas par ":value"',
    'search_modifier_source_account_ends'                 => 'Le nom du compte source se termine par ":value"',
    'search_modifier_not_source_account_ends'             => 'Le nom du compte source ne se termine pas par «:value»',
    'search_modifier_source_account_id'                   => 'L\'ID du compte source est :value',
    'search_modifier_not_source_account_id'               => 'L\'ID du compte source n\'est pas :value',
    'search_modifier_source_account_nr_is'                => 'Le numéro du compte source (IBAN) est ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Le numéro du compte source (IBAN) n\'est pas «:value»',
    'search_modifier_source_account_nr_contains'          => 'Le numéro du compte source (IBAN) contient ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Le numéro du compte source (IBAN) ne contient pas ":value"',
    'search_modifier_source_account_nr_starts'            => 'Le numéro du compte source (IBAN) commence par ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Le numéro du compte source (IBAN) ne commence pas par ":value"',
    'search_modifier_source_account_nr_ends'              => 'Le numéro du compte source (IBAN) se termine par ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Le numéro du compte source (IBAN) ne se termine pas par ":value"',
    'search_modifier_destination_account_is'              => 'Le nom du compte de destination est exactement ":value"',
    'search_modifier_not_destination_account_is'          => 'Le nom du compte de destination n\'est pas «:value»',
    'search_modifier_destination_account_contains'        => 'Le nom du compte de destination contient ":value"',
    'search_modifier_not_destination_account_contains'    => 'Le nom du compte de destination ne contient pas «:value»',
    'search_modifier_destination_account_starts'          => 'Le nom du compte de destination commence par ":value"',
    'search_modifier_not_destination_account_starts'      => 'Le nom du compte de destination ne commence pas par ":value"',
    'search_modifier_destination_account_ends'            => 'Le nom du compte de destination se termine par ":value"',
    'search_modifier_not_destination_account_ends'        => 'Le nom du compte de destination ne se termine pas par ":value"',
    'search_modifier_destination_account_id'              => 'L\'ID du compte de destination est :value',
    'search_modifier_not_destination_account_id'          => 'L\'ID du compte de destination n\'est pas :value',
    'search_modifier_destination_is_cash'                 => 'Le compte de destination est le compte "(espèces)"',
    'search_modifier_not_destination_is_cash'             => 'Le compte de destination n\'est pas le compte "(espèces)"',
    'search_modifier_source_is_cash'                      => 'Le compte source est le compte "(espèces)"',
    'search_modifier_not_source_is_cash'                  => 'Le compte source n\'est pas le compte "(espèces)"',
    'search_modifier_destination_account_nr_is'           => 'Le numéro du compte de destination (IBAN) est ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Le numéro du compte de destination (IBAN) est ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Le numéro du compte de destination (IBAN) contient ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Le numéro du compte de destination (IBAN) ne contient pas «:value»',
    'search_modifier_destination_account_nr_starts'       => 'Le numéro du compte de destination (IBAN) commence par ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Le numéro du compte de destination (IBAN) ne commence pas par ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Le numéro du compte de destination (IBAN) se termine par ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Le numéro du compte de destination (IBAN) ne se termine pas par «:value»',
    'search_modifier_account_id'                          => 'Les IDs du compte source ou de destination est/sont : :value',
    'search_modifier_not_account_id'                      => 'Les IDs du compte source ou de destination n\'est/ne sont pas : :value',
    'search_modifier_category_is'                         => 'La catégorie est ":value"',
    'search_modifier_not_category_is'                     => 'La catégorie n\'est pas ":value"',
    'search_modifier_budget_is'                           => 'Le budget est ":value"',
    'search_modifier_not_budget_is'                       => 'Le budget n\'est pas ":value"',
    'search_modifier_bill_is'                             => 'L’abonnement est ":value"',
    'search_modifier_not_bill_is'                         => 'L’abonnement n’est pas ":value"',
    'search_modifier_transaction_type'                    => 'Le type de transaction est ":value"',
    'search_modifier_not_transaction_type'                => 'Le type de l\'opération n\'est pas :value',
    'search_modifier_tag_is'                              => 'Le tag est ":value"',
    'search_modifier_tag_contains'                        => 'Le tag contient ":value"',
    'search_modifier_not_tag_contains'                    => 'Le tag ne contient pas «:value»',
    'search_modifier_tag_ends'                            => 'Le tag se termine par «:value»',
    'search_modifier_tag_starts'                          => 'Le tag commence par «:value»',
    'search_modifier_not_tag_is'                          => 'Aucun tag n\'est ":value"',
    'search_modifier_date_on_year'                        => 'L\'opération est dans l\'année ":value"',
    'search_modifier_not_date_on_year'                    => 'L\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_date_on_month'                       => 'L\'opération est dans le mois ":value"',
    'search_modifier_not_date_on_month'                   => 'L\'opération n\'est dans le mois de ":value"',
    'search_modifier_date_on_day'                         => 'L\'opération est le jour du mois ":value"',
    'search_modifier_not_date_on_day'                     => 'L\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_date_before_year'                    => 'L\'opération est avant ou dans l\'année ":value"',
    'search_modifier_date_before_month'                   => 'L\'opération est avant ou dans le mois ":value"',
    'search_modifier_date_before_day'                     => 'L\'opération est avant ou le jour du mois ":value"',
    'search_modifier_date_after_year'                     => 'L\'opération est dans ou après l\'année ":value"',
    'search_modifier_date_after_month'                    => 'L\'opération est dans ou après le mois ":value"',
    'search_modifier_date_after_day'                      => 'L\'opération est après ou le jour du mois ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Aucun tag n\'est ":value"',
    'search_modifier_not_tag_is_not'                      => 'Le tag est ":value"',
    'search_modifier_account_is'                          => 'L\'un des comptes est ":value"',
    'search_modifier_not_account_is'                      => 'Aucun compte n\'est ":value"',
    'search_modifier_account_contains'                    => 'L\'un des comptes contient ":value"',
    'search_modifier_not_account_contains'                => 'Aucun compte ne contient ":value"',
    'search_modifier_account_ends'                        => 'L\'un des comptes se termine par ":value"',
    'search_modifier_not_account_ends'                    => 'Aucun compte ne se termine par ":value"',
    'search_modifier_account_starts'                      => 'L\'un des comptes commence par ":value"',
    'search_modifier_not_account_starts'                  => 'Aucun compte ne commence par ":value"',
    'search_modifier_account_nr_is'                       => 'L\'un des numéros de compte / IBAN est ":value"',
    'search_modifier_not_account_nr_is'                   => 'Aucun n° de compte n\'est ":value"',
    'search_modifier_account_nr_contains'                 => 'L\'un des numéros de compte / IBAN contient ":value"',
    'search_modifier_not_account_nr_contains'             => 'Aucun n° de compte ne contient ":value"',
    'search_modifier_account_nr_ends'                     => 'L\'un des numéros de compte / IBAN se termine par ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Aucun n° de compte ne se termine par ":value"',
    'search_modifier_account_nr_starts'                   => 'L\'un des numéros de compte / IBAN commence par ":value"',
    'search_modifier_not_account_nr_starts'               => 'Aucun n° de compte ne commence par ":value"',
    'search_modifier_category_contains'                   => 'La catégorie contient ":value"',
    'search_modifier_not_category_contains'               => 'La catégorie ne contient pas «:value»',
    'search_modifier_category_ends'                       => 'La catégorie se termine par ":value"',
    'search_modifier_not_category_ends'                   => 'La catégorie ne se termine pas par ":value"',
    'search_modifier_category_starts'                     => 'La catégorie commence par ":value"',
    'search_modifier_not_category_starts'                 => 'La catégorie ne commence pas par ":value"',
    'search_modifier_budget_contains'                     => 'Le budget contient ":value"',
    'search_modifier_not_budget_contains'                 => 'Le budget ne contient pas ":value"',
    'search_modifier_budget_ends'                         => 'Le budget se termine par ":value"',
    'search_modifier_not_budget_ends'                     => 'Le budget ne se termine pas par ":value"',
    'search_modifier_budget_starts'                       => 'Le budget commence par ":value"',
    'search_modifier_not_budget_starts'                   => 'Le budget ne commence pas par ":value"',
    'search_modifier_bill_contains'                       => 'L’abonnement contient ":value"',
    'search_modifier_not_bill_contains'                   => 'L’abonnement ne contient pas ":value"',
    'search_modifier_bill_ends'                           => 'L’abonnement se termine par ":value"',
    'search_modifier_not_bill_ends'                       => 'L’abonnement ne se termine pas par ":value"',
    'search_modifier_bill_starts'                         => 'L’abonnement commence par ":value"',
    'search_modifier_not_bill_starts'                     => 'L’abonnement ne commence pas par ":value"',
    'search_modifier_external_id_contains'                => 'L\'ID externe contient ":value"',
    'search_modifier_not_external_id_contains'            => 'L\'ID externe ne contient pas ":value"',
    'search_modifier_external_id_ends'                    => 'L\'ID externe se termine par ":value"',
    'search_modifier_not_external_id_ends'                => 'L\'ID externe ne se termine pas par ":value"',
    'search_modifier_external_id_starts'                  => 'L\'ID externe commence par ":value"',
    'search_modifier_not_external_id_starts'              => 'L\'ID externe ne commence pas par ":value"',
    'search_modifier_internal_reference_contains'         => 'La référence interne contient ":value"',
    'search_modifier_not_internal_reference_contains'     => 'La référence interne ne contient pas ":value"',
    'search_modifier_internal_reference_ends'             => 'La référence interne se termine par ":value"',
    'search_modifier_internal_reference_starts'           => 'La référence interne commence par ":value"',
    'search_modifier_not_internal_reference_ends'         => 'La référence interne ne se termine pas par ":value"',
    'search_modifier_not_internal_reference_starts'       => 'La référence interne ne commence pas par ":value"',
    'search_modifier_external_url_is'                     => 'L\'URL externe est ":value"',
    'search_modifier_not_external_url_is'                 => 'L\'URL externe n\'est pas ":value"',
    'search_modifier_external_url_contains'               => 'L\'URL externe contient ":value"',
    'search_modifier_not_external_url_contains'           => 'L\'URL externe ne contient pas ":value"',
    'search_modifier_external_url_ends'                   => 'L\'URL externe se termine par ":value"',
    'search_modifier_not_external_url_ends'               => 'L\'URL externe ne se termine pas par ":value"',
    'search_modifier_external_url_starts'                 => 'L\'URL externe commence par ":value"',
    'search_modifier_not_external_url_starts'             => 'L\'URL externe ne commence pas par ":value"',
    'search_modifier_has_no_attachments'                  => 'L\'opération n\'a pas de pièces jointes',
    'search_modifier_not_has_no_attachments'              => 'L\'opération a des pièces jointes',
    'search_modifier_not_has_attachments'                 => 'L\'opération n\'a pas de pièces jointes',
    'search_modifier_account_is_cash'                     => 'L\'un des comptes est le compte "(espèces)".',
    'search_modifier_not_account_is_cash'                 => 'Aucun compte n\'est le compte "(espèces)".',
    'search_modifier_journal_id'                          => 'L\'ID du journal est ":value"',
    'search_modifier_not_journal_id'                      => 'L\'ID du journal n\'est pas «:value»',
    'search_modifier_recurrence_id'                       => 'L\'ID de l\'opération récurrente est ":value"',
    'search_modifier_not_recurrence_id'                   => 'L\'ID de l\'opération récurrente n\'est pas ":value"',
    'search_modifier_foreign_amount_is'                   => 'Le montant en devise étrangère est ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Le montant en devise étrangère n\'est pas ":value"',
    'search_modifier_foreign_amount_less'                 => 'Le montant en devise étrangère est inférieur à ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Le montant en devise étrangère est inférieur à ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Le montant en devise étrangère est supérieur à ":value"',
    'search_modifier_foreign_amount_more'                 => 'Le montant en devise étrangère est supérieur à ":value"',
    'search_modifier_exists'                              => 'Une opération existe',
    'search_modifier_not_exists'                          => 'L\'opération n\'existe pas (aucune opération)',

    // date fields
    'search_modifier_interest_date_on'                    => 'La date d\'intérêt de l\'opération est ":value"',
    'search_modifier_not_interest_date_on'                => 'La date d\'intérêt de l\'opération n\'est pas ":value"',
    'search_modifier_interest_date_on_year'               => 'La date d\'intérêt de l\'opération est dans l\'année ":value"',
    'search_modifier_not_interest_date_on_year'           => 'La date d\'intérêt de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_interest_date_on_month'              => 'La date d\'intérêt de l\'opération est dans le mois ":value"',
    'search_modifier_not_interest_date_on_month'          => 'La date d\'intérêt de l\'opération n\'est dans le mois de ":value"',
    'search_modifier_interest_date_on_day'                => 'La date d\'intérêt de l\'opération est le jour du mois ":value"',
    'search_modifier_not_interest_date_on_day'            => 'La date d\'intérêt de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_interest_date_before_year'           => 'La date d\'intérêt de l\'opération est antérieure à ou dans l\'année ":value"',
    'search_modifier_interest_date_before_month'          => 'La date d\'intérêt de l\'opération est antérieure à ou dans le mois ":value"',
    'search_modifier_interest_date_before_day'            => 'La date d\'intérêt de l\'opération est antérieure à ou le jour du mois «:value»',
    'search_modifier_interest_date_after_year'            => 'La date d\'intérêt de l\'opération est postérieure ou dans l\'année ":value"',
    'search_modifier_interest_date_after_month'           => 'La date d\'intérêt de l\'opération est postérieure ou dans le mois ":value"',
    'search_modifier_interest_date_after_day'             => 'La date d\'intérêt de l\'opération est postérieure ou le jour du mois ":value"',
    'search_modifier_book_date_on_year'                   => 'La date d\'enregistrement de l\'opération est dans l\'année ":value"',
    'search_modifier_book_date_on_month'                  => 'La date d\'enregistrement de l\'opération est dans le mois ":value"',
    'search_modifier_book_date_on_day'                    => 'La date d\'enregistrement de l\'opération est le jour du mois ":value"',
    'search_modifier_not_book_date_on_year'               => 'La date d\'enregistrement de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_not_book_date_on_month'              => 'La date d\'enregistrement de l\'opération n\'est pas dans le mois de ":value"',
    'search_modifier_not_book_date_on_day'                => 'La date d\'enregistrement de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_book_date_before_year'               => 'La date d\'enregistrement de l\'opération est avant ou dans l\'année ":value"',
    'search_modifier_book_date_before_month'              => 'La date d\'enregistrement de l\'opération est avant ou dans le mois ":value"',
    'search_modifier_book_date_before_day'                => 'La date d\'enregistrement de l\'opération est avant ou le jour du mois ":value"',
    'search_modifier_book_date_after_year'                => 'La date d\'enregistrement de l\'opération est après ou dans l\'année ":value"',
    'search_modifier_book_date_after_month'               => 'La date d\'enregistrement de l\'opération est après ou dans le mois ":value"',
    'search_modifier_book_date_after_day'                 => 'La date d\'enregistrement de l\'opération est après ou le jour du mois ":value"',
    'search_modifier_process_date_on_year'                => 'La date de traitement de l\'opération est dans l\'année ":value"',
    'search_modifier_process_date_on_month'               => 'La date de traitement de l\'opération est dans le mois ":value"',
    'search_modifier_process_date_on_day'                 => 'La date de traitement de l\'opération est le jour du mois ":value"',
    'search_modifier_not_process_date_on_year'            => 'La date de traitement de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_not_process_date_on_month'           => 'La date de traitement de l\'opération n\'est pas dans le mois de ":value"',
    'search_modifier_not_process_date_on_day'             => 'La date de traitement de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_process_date_before_year'            => 'La date de traitement de l\'opération est avant ou dans l\'année ":value"',
    'search_modifier_process_date_before_month'           => 'La date de traitement de l\'opération est avant ou dans le mois ":value"',
    'search_modifier_process_date_before_day'             => 'La date de traitement de l\'opération est avant ou le jour du mois ":value"',
    'search_modifier_process_date_after_year'             => 'La date de traitement de l\'opération est après ou dans l\'année ":value"',
    'search_modifier_process_date_after_month'            => 'La date de traitement de l\'opération est après ou dans le mois ":value"',
    'search_modifier_process_date_after_day'              => 'La date de traitement de l\'opération est après ou le jour du mois ":value"',
    'search_modifier_due_date_on_year'                    => 'La date d\'échéance de l\'opération est dans l\'année ":value"',
    'search_modifier_due_date_on_month'                   => 'La date d\'échéance de l\'opération est dans le mois ":value"',
    'search_modifier_due_date_on_day'                     => 'La date d\'échéance de l\'opération est le jour du mois ":value"',
    'search_modifier_not_due_date_on_year'                => 'La date d\'échéance de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_not_due_date_on_month'               => 'La date d\'échéance de l\'opération n\'est pas dans le mois de ":value"',
    'search_modifier_not_due_date_on_day'                 => 'La date d\'échéance de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_due_date_before_year'                => 'La date d\'échéance de l\'opération est avant ou dans l\'année ":value"',
    'search_modifier_due_date_before_month'               => 'La date d\'échéance de l\'opération est avant ou dans le mois ":value"',
    'search_modifier_due_date_before_day'                 => 'La date d\'échéance de l\'opération est avant ou le jour du mois ":value"',
    'search_modifier_due_date_after_year'                 => 'La date d\'échéance de l\'opération est après ou dans l\'année ":value"',
    'search_modifier_due_date_after_month'                => 'La date d\'échéance de l\'opération est après ou dans le mois ":value"',
    'search_modifier_due_date_after_day'                  => 'La date d\'échéance de l\'opération est après ou le jour du mois ":value"',
    'search_modifier_payment_date_on_year'                => 'La date de paiement de l\'opération est dans l\'année ":value"',
    'search_modifier_payment_date_on_month'               => 'La date de paiement de l\'opération est dans le mois ":value"',
    'search_modifier_payment_date_on_day'                 => 'La date de paiement de l\'opération est le jour du mois ":value"',
    'search_modifier_not_payment_date_on_year'            => 'La date de paiement de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_not_payment_date_on_month'           => 'La date de paiement de l\'opération n\'est dans le mois de ":value"',
    'search_modifier_not_payment_date_on_day'             => 'La date de paiement de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_payment_date_before_year'            => 'La date de paiement de l\'opération est avant ou dans l\'année ":value"',
    'search_modifier_payment_date_before_month'           => 'La date de paiement de l\'opération est avant ou dans le mois ":value"',
    'search_modifier_payment_date_before_day'             => 'La date de paiement de l\'opération est avant ou le jour du mois ":value"',
    'search_modifier_payment_date_after_year'             => 'La date de paiement de l\'opération est après ou dans l\'année "\':value"',
    'search_modifier_payment_date_after_month'            => 'La date de paiement de l\'opération est après ou dans le mois ":value"',
    'search_modifier_payment_date_after_day'              => 'La date de paiement de l\'opération est après ou le jour du mois ":value"',
    'search_modifier_invoice_date_on_year'                => 'La date de facturation de l\'opération est dans l\'année ":value"',
    'search_modifier_invoice_date_on_month'               => 'La date de facturation de l\'opération est dans le mois de ":value"',
    'search_modifier_invoice_date_on_day'                 => 'La date de facturation de l\'opération est le jour du mois ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'La date de facturation de l\'opération n\'est pas dans l\'année ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'La date de facturation de l\'opération n\'est pas dans le mois de ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'La date de facturation de l\'opération n\'est pas le jour du mois ":value"',
    'search_modifier_invoice_date_before_year'            => 'La date de facturation de l\'opération est avant ou dans l\'année ":value"',
    'search_modifier_invoice_date_before_month'           => 'La date de facturation de l\'opération est avant ou dans le mois de ":value"',
    'search_modifier_invoice_date_before_day'             => 'La date de facturation de l\'opération est avant ou le jour du mois ":value"',
    'search_modifier_invoice_date_after_year'             => 'La date de facture de l\'opération est après ou dans l\'année ":value"',
    'search_modifier_invoice_date_after_month'            => 'La date de facture de l\'opération est après ou dans le mois ":value"',
    'search_modifier_invoice_date_after_day'              => 'La date de facturation de l\'opération est après ou le jour du mois ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'L\'opération a été mise à jour pour la dernière fois en ":value"',
    'search_modifier_updated_at_on_month'                 => 'L\'opération a été mise à jour pour la dernière fois en ":value"',
    'search_modifier_updated_at_on_day'                   => 'La dernière mise à jour de l\'opération date du jour du mois ":value"',
    'search_modifier_not_updated_at_on_year'              => 'L\'opération n\'a pas été mise à jour pour la dernière fois en ":value"',
    'search_modifier_not_updated_at_on_month'             => 'L\'opération n\'a pas été mise à jour pour la dernière fois en ":value"',
    'search_modifier_not_updated_at_on_day'               => 'La dernière mise à jour de l\'opération ne date pas du jour du mois ":value"',
    'search_modifier_updated_at_before_year'              => 'La transaction a été mise à jour la dernière fois ":value" ou avant',
    'search_modifier_updated_at_before_month'             => 'L\'opération a été mise à jour pour la dernière fois en ":value" ou avant',
    'search_modifier_updated_at_before_day'               => 'La dernière mise à jour de l\'opération date du jour du mois ":value" ou avant',
    'search_modifier_updated_at_after_year'               => 'L\'opération a été mise à jour pour la dernière fois après ":value"',
    'search_modifier_updated_at_after_month'              => 'La dernière mise à jour de l\'opération date du mois de ":value" ou après',
    'search_modifier_updated_at_after_day'                => 'La dernière mise à jour de l\'opération date du jour du mois ":value" ou après',
    'search_modifier_created_at_on_year'                  => 'L\'opération a été créée dans l\'année ":value"',
    'search_modifier_created_at_on_month'                 => 'L\'opération a été créée au mois de ":value"',
    'search_modifier_created_at_on_day'                   => 'L\'opération a été créée le jour du mois ":value"',
    'search_modifier_not_created_at_on_year'              => 'L\'opération n\'a pas été créée dans l\'année ":value"',
    'search_modifier_not_created_at_on_month'             => 'L\'opération n\'a pas été créée au mois de ":value"',
    'search_modifier_not_created_at_on_day'               => 'L\'opération n\'a pas été créée le jour du mois ":value"',
    'search_modifier_created_at_before_year'              => 'L\'opération a été créée dans l\'année ":value" ou avant',
    'search_modifier_created_at_before_month'             => 'L\'opération a été créée dans le mois de ":value" ou avant',
    'search_modifier_created_at_before_day'               => 'L\'opération a été créée le jour du mois ":value" ou avant',
    'search_modifier_created_at_after_year'               => 'L\'opération a été créée dans l\'année ":value" ou après',
    'search_modifier_created_at_after_month'              => 'L\'opération a été créée au mois de ":value" ou après',
    'search_modifier_created_at_after_day'                => 'L\'opération a été créée le jour du mois ":value" ou après',
    'search_modifier_interest_date_before'                => 'La date d\'intérêt de l\'opération est dans le mois de ":value" ou avant',
    'search_modifier_interest_date_after'                 => 'La date d\'intérêt de l\'opération est le ":value" ou après',
    'search_modifier_book_date_on'                        => 'La date d\'enregistrement de l\'opération est le ":value"',
    'search_modifier_not_book_date_on'                    => 'La date d\'enregistrement de l\'opération n\'est pas le ":value"',
    'search_modifier_book_date_before'                    => 'La date d\'enregistrement de l\'opération est avant ou le ":value"',
    'search_modifier_book_date_after'                     => 'La date d\'enregistrement de l\'opération est après ou le ":value"',
    'search_modifier_process_date_on'                     => 'La date de traitement de l\'opération est le ":value"',
    'search_modifier_not_process_date_on'                 => 'La date de traitement de l\'opération n\'est pas le ":value"',
    'search_modifier_process_date_before'                 => 'La date de traitement de l\'opération est le ":value" ou avant',
    'search_modifier_process_date_after'                  => 'La date de traitement de l\'opération est le ":value" ou après',
    'search_modifier_due_date_on'                         => 'La date d\'échéance de l\'opération est le ":value"',
    'search_modifier_not_due_date_on'                     => 'La date d\'échéance de l\'opération n\'est pas le ":value"',
    'search_modifier_due_date_before'                     => 'La date d\'échéance de l\'opération est le ":value" ou avant',
    'search_modifier_due_date_after'                      => 'La date d\'échéance de l\'opération est le ":value" ou après',
    'search_modifier_payment_date_on'                     => 'La date d\'échéance de l\'opération est le ":value"',
    'search_modifier_not_payment_date_on'                 => 'La date d\'échéance de l\'opération n\'est pas le ":value"',
    'search_modifier_payment_date_before'                 => 'La date de paiement de l\'opération est le ":value" ou avant',
    'search_modifier_payment_date_after'                  => 'La date de paiement de l\'opération est le ":value" ou après',
    'search_modifier_invoice_date_on'                     => 'La date de facturation de l\'opération est le ":value"',
    'search_modifier_not_invoice_date_on'                 => 'La date de facturation de l\'opération n\'est pas le ":value"',
    'search_modifier_invoice_date_before'                 => 'La date de facturation de l\'opération est le ":value" ou avant',
    'search_modifier_invoice_date_after'                  => 'La date de facturation de l\'opération est le ":value" ou après',
    'search_modifier_created_at_on'                       => 'L\'opération a été créée le ":value"',
    'search_modifier_not_created_at_on'                   => 'L\'opération n\'a pas été créée le ":value"',
    'search_modifier_created_at_before'                   => 'L\'opération a été créée le ":value" ou avant',
    'search_modifier_created_at_after'                    => 'L\'opération a été créée le ":value" ou après',
    'search_modifier_updated_at_on'                       => 'L\'opération a été mise à jour le ":value"',
    'search_modifier_not_updated_at_on'                   => 'L\'opération n\'a pas été mise à jour pour la dernière fois le ":value"',
    'search_modifier_updated_at_before'                   => 'L\'opération a été mise à jour le ":value" ou avant',
    'search_modifier_updated_at_after'                    => 'L\'opération a été mise à jour le ":value" ou après',

    'search_modifier_attachment_name_is'            => 'Une pièce jointe se nomme ":value"',
    'search_modifier_attachment_name_contains'      => 'Le nom d\'une pièce jointe contient ":value"',
    'search_modifier_attachment_name_starts'        => 'Le nom d\'une pièce jointe commence par ":value"',
    'search_modifier_attachment_name_ends'          => 'Le nom d\'une pièce jointe se termine par ":value"',
    'search_modifier_attachment_notes_are'          => 'Les notes d\'une pièce jointe sont ":value"',
    'search_modifier_attachment_notes_contains'     => 'Les notes d\'une pièce jointe contiennent ":value"',
    'search_modifier_attachment_notes_starts'       => 'Les notes d\'une pièce jointe commencent par ":value"',
    'search_modifier_attachment_notes_ends'         => 'Les notes d\'une pièce jointe se terminent par ":value"',
    'search_modifier_not_attachment_name_is'        => 'Une pièce jointe ne se nomme pas ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Les notes d\'une pièce jointe ne contiennent pas ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Les notes d\'une pièce jointe ne commencent pas par ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Le nom d\'une pièce jointe ne se termine pas par ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Les notes d\'une pièce jointe ne sont pas ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Les notes d\'une pièce jointe ne contiennent pas ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Les notes d\'une pièce jointe commencent par ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Les notes d\'une pièce jointe ne se terminent pas par ":value"',
    'search_modifier_sepa_ct_is'                    => 'Le virement SEPA est ":value"',
    'update_rule_from_query'                        => 'Mettre à jour la règle ":rule" à partir de la requête de recherche',
    'create_rule_from_query'                        => 'Créer une nouvelle règle à partir de la requête de recherche',
    'rule_from_search_words'                        => 'Le moteur de règles a du mal à gérer ":string". La règle suggérée qui correspond à votre requête de recherche peut donner des résultats différents. Veuillez vérifier que la règle se déclenche correctement.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Le solde du compte de destination est exactement ":value"',
    'search_modifier_not_destination_balance_is'    => 'Le solde du compte de destination n\'est PAS exactement ":value"',
    'search_modifier_source_balance_is'             => 'Le solde du compte source est exactement ":value"',
    'search_modifier_not_source_balance_is'         => 'Le solde du compte source n\'est PAS exactement ":value"',

    'search_modifier_destination_balance_lte'     => 'Le solde du compte de destination est inférieur ou égal à ":value"',
    'search_modifier_not_destination_balance_lte' => 'Le solde du compte de destination est supérieur à ":value"',
    'search_modifier_source_balance_lte'          => 'Le solde du compte source est inférieur ou égal à ":value"',
    'search_modifier_not_source_balance_lte'      => 'Le solde du compte source est supérieur à ":value"',

    'search_modifier_destination_balance_lt'     => 'Le solde du compte de destination est inférieur à ":value"',
    'search_modifier_not_destination_balance_lt' => 'Le solde du compte de destination est supérieur ou égal à ":value"',
    'search_modifier_source_balance_lt'          => 'Le solde du compte source est inférieur à ":value"',
    'search_modifier_not_source_balance_lt'      => 'Le solde du compte source est supérieur ou égal à ":value"',

    'search_modifier_destination_balance_gte'     => 'Le solde du compte de destination est supérieur ou égal à ":value"',
    'search_modifier_not_destination_balance_gte' => 'Le solde du compte de destination est inférieur à ":value"',
    'search_modifier_source_balance_gte'          => 'Le solde du compte source est supérieur ou égal à ":value"',
    'search_modifier_not_source_balance_gte'      => 'Le solde du compte source est inférieur à ":value"',

    'search_modifier_destination_balance_gt'              => 'Le solde du compte de destination est supérieur à ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Le solde du compte de destination est inférieur ou égal à ":value"',
    'search_modifier_source_balance_gt'                   => 'Le solde du compte source est supérieur à ":value"',
    'search_modifier_not_source_balance_gt'               => 'Le solde du compte source est inférieur ou égal à ":value"',


    // END
    'general_search_error'                                => 'Une erreur s\'est produite lors de la recherche. Veuillez vérifier les fichiers journaux pour plus d\'informations.',
    'search_box'                                          => 'Rechercher',
    'search_box_intro'                                    => 'Bienvenue à la fonction de recherche de Firefly III. Entrez votre requête de recherche dans la zone. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Assurez-vous de consulter le fichier d’aide</a> parce que la recherche est assez avancée.',
    'search_error'                                        => 'Erreur lors de la recherche',
    'search_searching'                                    => 'Recherche ...',
    'search_results'                                      => 'Résultats de la recherche',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'annuellement',
    'repeat_freq_half-year'                               => 'semestriel',
    'repeat_freq_quarterly'                               => 'trimestriel',
    'repeat_freq_monthly'                                 => 'mensuel',
    'repeat_freq_weekly'                                  => 'hebdomadaire',
    'repeat_freq_daily'                                   => 'quotidien',
    'daily'                                               => 'quotidien',
    'weekly'                                              => 'hebdomadaire',
    'quarterly'                                           => 'trimestriel',
    'half-year'                                           => 'semestriel',
    'yearly'                                              => 'annuel',

    // rules
    'is_not_rule_trigger'                                 => 'Inverser',
    'cannot_fire_inactive_rules'                          => 'Vous ne pouvez pas exécuter des règles inactives.',
    'show_triggers'                                       => 'Afficher les déclencheurs',
    'show_actions'                                        => 'Afficher les actions',
    'rules'                                               => 'Règles',
    'rule_name'                                           => 'Nom de la règle',
    'rule_triggers'                                       => 'La règle se déclenchera lorsque',
    'rule_actions'                                        => 'La règle va',
    'new_rule'                                            => 'Nouvelle règle',
    'new_rule_group'                                      => 'Nouveau groupe de règles',
    'rule_priority_up'                                    => 'Donner à la règle plus de priorité',
    'rule_priority_down'                                  => 'Donner à la règle moins de priorité',
    'make_new_rule_group'                                 => 'Créer un nouveau groupe de règles',
    'store_new_rule_group'                                => 'Créer un nouveau groupe de règles',
    'created_new_rule_group'                              => 'Le nouveau groupe de règles ":title" est créé !',
    'updated_rule_group'                                  => 'Groupe de règles ":title" mis à jour avec succès.',
    'edit_rule_group'                                     => 'Modifier le groupe de règles ":title"',
    'duplicate_rule'                                      => 'Dupliquer la règle ":title"',
    'rule_copy_of'                                        => 'Copie de ":title"',
    'duplicated_rule'                                     => 'Règle ":title" dupliquée en ":newTitle"',
    'delete_rule_group'                                   => 'Supprimer le groupe de règles ":title"',
    'deleted_rule_group'                                  => 'Groupe de règles ":title" supprimé',
    'update_rule_group'                                   => 'Mettre à jour le groupe de règles',
    'no_rules_in_group'                                   => 'Il n’y a pas de règle dans ce groupe',
    'move_rule_group_up'                                  => 'Monter le groupe de règles',
    'move_rule_group_down'                                => 'Descendre le groupe de règles',
    'save_rules_by_moving'                                => 'Enregistrer cette règle en la déplaçant dans un autre groupe de règles :|Enregistrer ces règles en les déplaçant dans un autre groupe de règles :',
    'make_new_rule'                                       => 'Créer une nouvelle règle dans le groupe de règles ":title"',
    'make_new_rule_no_group'                              => 'Créer une nouvelle règle',
    'instructions_rule_from_bill'                         => 'Afin d’associer des opérations à votre nouvel abonnement « :name », Firefly III peut créer une règle qui sera automatiquement appliquée sur toutes les opérations déjà enregistrées. Veuillez vérifier les détails ci-après et enregistrer la règle pour que Firefly III associe automatiquement des opérations à votre nouvelle facture.',
    'instructions_rule_from_journal'                      => 'Créez une règle basée sur une de vos opérations. Complétez ou soumettez le formulaire ci-dessous.',
    'rule_is_strict'                                      => 'règle stricte',
    'rule_is_not_strict'                                  => 'règle non stricte',
    'rule_help_stop_processing'                           => 'Lorsque vous cochez cette case, les règles suivantes dans ce groupe ne seront pas exécutées si cette règle est exécutée.',
    'rule_help_strict'                                    => 'En mode strict, TOUS les déclencheurs doivent être activés pour que les actions s\'exécutent. Si décoché, N\'IMPORTE QUEL déclencheur est suffisant pour que les actions soit exécutées.',
    'rule_help_active'                                    => 'Les règles inactives ne se déclencheront jamais.',
    'stored_new_rule'                                     => 'Nouvelle règle créée avec le titre ":title"',
    'deleted_rule'                                        => 'Règle avec le titre ":title" supprimée',
    'store_new_rule'                                      => 'Créer une nouvelle règle',
    'updated_rule'                                        => 'Règle avec le titre ":title" mise à jour',
    'default_rule_group_name'                             => 'Règles par défaut',
    'default_rule_group_description'                      => 'Toutes vos règles n\'étant pas dans un groupe particulier.',
    'trigger'                                             => 'Déclencheur',
    'trigger_value'                                       => 'Déclenchement sur valeur',
    'stop_processing_other_triggers'                      => 'Arrêter le traitement d’autres déclencheurs',
    'add_rule_trigger'                                    => 'Ajouter un nouveau déclencheur',
    'action'                                              => 'Action',
    'action_value'                                        => 'Valeur de l’action',
    'stop_executing_other_actions'                        => 'Arrêter l’exécution des autres actions',
    'add_rule_action'                                     => 'Ajouter une nouvelle action',
    'edit_rule'                                           => 'Modifier la règle n°:nr ":title"',
    'delete_rule'                                         => 'Supprimer la règle ":title"',
    'update_rule'                                         => 'Mettre à jour la règle',
    'test_rule_triggers'                                  => 'Voir les opérations correspondantes',
    'warning_no_matching_transactions'                    => 'Aucune opération trouvée.',
    'warning_no_valid_triggers'                           => 'Aucun déclencheur valide fourni.',
    'apply_rule_selection'                                => 'Appliquer la règle ":title" à une sélection de vos opérations',
    'apply_rule_selection_intro'                          => 'Les règles comme ":title" ne s\'appliquent normalement qu\'aux opérations nouvelles ou mises à jour, mais vous pouvez dire à Firefly III de l’exécuter sur une sélection de vos opérations existantes. Cela peut être utile lorsque vous avez mis à jour une règle et avez besoin que les modifications soient appliquées à l’ensemble de vos autres opérations.',
    'include_transactions_from_accounts'                  => 'Inclure les opérations depuis ces comptes',
    'include'                                             => 'Inclure ?',
    'applied_rule_selection'                              => '{0} Aucune opération dans votre sélection n\'a été modifiée par la règle ":title".|[1] Une opération dans votre sélection a été modifiée par la règle ":title".|[2,*] :count opérations dans votre sélection ont été modifiées par la règle ":title".',
    'execute'                                             => 'Exécuter',
    'apply_rule_group_selection'                          => 'Appliquer le groupe de règles ":title" à une sélection de vos opérations',
    'apply_rule_group_selection_intro'                    => 'Les groupes de règles comme ":title" ne s\'appliquent normalement qu\'aux opérations nouvelles ou mises à jour, mais vous pouvez dire à Firefly III d\'exécuter toutes les règles de ce groupe sur une sélection de vos opérations existantes. Cela peut être utile lorsque vous avez mis à jour un groupe de règles et avez besoin que les modifications soient appliquées à l’ensemble de vos autres opérations.',
    'applied_rule_group_selection'                        => 'Le groupe de règles ":title" a été appliqué à votre sélection.',
    'rule_run_after_creation' => 'Si vous cochez cette case, vous aurez la possibilité d\'exécuter la règle après sa création.',
    'rule_run_after_edit' => 'Si vous cochez cette case, vous aurez la possibilité d\'exécuter la règle après sa mise à jour.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Lorsqu’une opération est créée',
    'rule_trigger_update_journal'                         => 'Lorsqu’une opération est mise à jour',
    'rule_trigger_manual'                                 => 'Manuel : uniquement sur demande de l\'utilisateur',
    'rule_trigger_user_action'                            => 'L\'action de l’utilisateur est ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Le nom du compte source commence par..',
    'rule_trigger_source_account_starts'                  => 'Le nom du compte source commence par ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Le nom du compte source se termine par..',
    'rule_trigger_source_account_ends'                    => 'Le nom du compte source se termine par ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Le nom du compte source est..',
    'rule_trigger_source_account_is'                      => 'Le nom du compte source est ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Le nom du compte source contient..',
    'rule_trigger_source_account_contains'                => 'Le nom du compte source contient ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'L\'un des deux comptes a pour identifiant..',
    'rule_trigger_account_id'                             => 'L\'un des deux comptes a pour identifiant :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'L\'ID du compte source est exactement..',
    'rule_trigger_source_account_id'                      => 'L\'ID du compte source est exactement :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'L\'ID du compte de destination est exactement..',
    'rule_trigger_destination_account_id'                 => 'L\'ID du compte de destination est exactement :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'L\'un des deux comptes est en espèces',
    'rule_trigger_account_is_cash'                        => 'L\'un des deux comptes est en espèces',
    'rule_trigger_source_is_cash_choice'                  => 'Le compte source est un compte (d\'espèces)',
    'rule_trigger_source_is_cash'                         => 'Le compte source est un compte (d\'espèces)',
    'rule_trigger_destination_is_cash_choice'             => 'Le compte de destination est un compte (d\'espèces)',
    'rule_trigger_destination_is_cash'                    => 'Le compte de destination est un compte (d\'espèces)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Le numéro / IBAN du compte source commence par..',
    'rule_trigger_source_account_nr_starts'               => 'Le numéro / IBAN du compte source commence par ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Le numéro / IBAN du compte source se termine par..',
    'rule_trigger_source_account_nr_ends'                 => 'Le numéro / IBAN du compte source se termine par ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Le numéro / IBAN du compte source est..',
    'rule_trigger_source_account_nr_is'                   => 'Le numéro / IBAN du compte source est ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Le numéro / IBAN du compte source contient..',
    'rule_trigger_source_account_nr_contains'             => 'Le numéro / IBAN du compte source contient ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Le nom du compte de destination commence par..',
    'rule_trigger_destination_account_starts'             => 'Le nom du compte de destination commence par ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Le nom du compte de destination se termine par..',
    'rule_trigger_destination_account_ends'               => 'Le nom du compte de destination se termine par ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Le nom du compte de destination est..',
    'rule_trigger_destination_account_is'                 => 'Le nom du compte de destination est ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Le nom du compte de destination contient..',
    'rule_trigger_destination_account_contains'           => 'Le nom du compte de destination contient ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Le numéro / IBAN du compte de destination commence par..',
    'rule_trigger_destination_account_nr_starts'          => 'Le numéro / IBAN du compte de destination commence par ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Le numéro / IBAN du compte de destination se termine par..',
    'rule_trigger_destination_account_nr_ends'            => 'Le numéro / IBAN du compte de destination se termine par.. ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Le numéro / IBAN du compte de destination est..',
    'rule_trigger_destination_account_nr_is'              => 'Le numéro / IBAN du compte de destination est ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Le numéro / IBAN du compte de destination contient..',
    'rule_trigger_destination_account_nr_contains'        => 'Le numéro / IBAN du compte de destination contient ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'L\'opération est du type..',
    'rule_trigger_transaction_type'                       => 'L\'opération est du type ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'La catégorie est..',
    'rule_trigger_category_is'                            => 'La catégorie est ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Le montant est inférieur ou égal à ..',
    'rule_trigger_amount_less'                            => 'Le montant est inférieur ou égal à :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Le montant est..',
    'rule_trigger_amount_is'                              => 'Le montant est :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Le montant est supérieur ou égal à..',
    'rule_trigger_amount_more'                            => 'Le montant est supérieur ou égal à :trigger_value',
    'rule_trigger_description_starts_choice'              => 'La description commence par..',
    'rule_trigger_description_starts'                     => 'La description commence par ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'La description se termine par..',
    'rule_trigger_description_ends'                       => 'La description se termine par ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'La description contient..',
    'rule_trigger_description_contains'                   => 'La description contient ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'La description est..',
    'rule_trigger_description_is'                         => 'La description est ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'La date de l\'opération est..',
    'rule_trigger_date_on'                                => 'La date de l\'opération est.. ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'La date de l\'opération se situe avant..',
    'rule_trigger_date_before'                            => 'La date de l\'opération se situe avant ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'La date de l\'opération se situe après..',
    'rule_trigger_date_after'                             => 'La date de l\'opération se situe après ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'L\'opération a été créée le..',
    'rule_trigger_created_at_on'                          => 'L\'opération a été créée le ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'L\'opération a été mise à jour pour la dernière fois le..',
    'rule_trigger_updated_at_on'                          => 'L\'opération a été mise à jour pour la dernière fois le ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Le budget est..',
    'rule_trigger_budget_is'                              => 'Le budget est ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Un tag est..',
    'rule_trigger_tag_is'                                 => 'Un tag est ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'N\'importe quel tag contient..',
    'rule_trigger_tag_contains'                           => 'N\'importe quel tag contient ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'Aucun tag ne contient ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'N\'importe quel tag se termine par..',
    'rule_trigger_tag_ends'                               => 'N\'importe quel tag se termine par ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'N\'importe quel tag commence par..',
    'rule_trigger_tag_starts'                             => 'N\'importe quel tag commence par ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'La devise de l\'opération est..',
    'rule_trigger_currency_is'                            => 'La devise de l\'opération est ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'La devise étrangère de l\'opération est..',
    'rule_trigger_foreign_currency_is'                    => 'La devise étrangère de l\'opération est ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'A des pièces jointes',
    'rule_trigger_has_attachments'                        => 'A une ou plusieurs pièces jointes',
    'rule_trigger_has_no_category_choice'                 => 'N\'a pas de catégorie',
    'rule_trigger_has_no_category'                        => 'L\'opération n\'a pas de catégorie',
    'rule_trigger_has_any_category_choice'                => 'A une catégorie',
    'rule_trigger_has_any_category'                       => 'L\'opération comporte une catégorie',
    'rule_trigger_has_no_budget_choice'                   => 'N\'a pas de budget',
    'rule_trigger_has_no_budget'                          => 'L\'opération n\'a pas de budget',
    'rule_trigger_has_any_budget_choice'                  => 'A un budget',
    'rule_trigger_has_any_budget'                         => 'L\'opération a un(des) budget(s)',
    'rule_trigger_has_no_bill_choice'                     => 'N\'a pas d\'abonnement',
    'rule_trigger_has_no_bill'                            => 'L\'opération n\'a pas d\'abonnement',
    'rule_trigger_has_any_bill_choice'                    => 'A un abonnement',
    'rule_trigger_has_any_bill'                           => 'L\'opération a un abonnement',
    'rule_trigger_has_no_tag_choice'                      => 'N\'a pas de tag·s',
    'rule_trigger_has_no_tag'                             => 'L\'opération n\'a pas de tag·s',
    'rule_trigger_has_any_tag_choice'                     => 'Dispose d\'un ou de plusieurs tags',
    'rule_trigger_has_any_tag'                            => 'L\'opération comporte un ou plusieurs tags',
    'rule_trigger_any_notes_choice'                       => 'A une (ou plusieurs) note(s)',
    'rule_trigger_any_notes'                              => 'L\'opération a une (ou plusieurs) note(s)',
    'rule_trigger_no_notes_choice'                        => 'N\'a pas de note',
    'rule_trigger_no_notes'                               => 'L\'opération n\'a pas de note',
    'rule_trigger_notes_is_choice'                        => 'Les notes sont..',
    'rule_trigger_notes_is'                               => 'Les notes sont ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Les notes contiennent..',
    'rule_trigger_notes_contains'                         => 'Les notes contiennent ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Les notes commencent par..',
    'rule_trigger_notes_starts'                           => 'Les notes commencent par ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Les notes se terminent par..',
    'rule_trigger_notes_ends'                             => 'Les notes se finissent par ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'L\'abonnement est..',
    'rule_trigger_bill_is'                                => 'L\'abonnement est ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'L\'ID externe est..',
    'rule_trigger_external_id_is'                         => 'L\'ID externe est ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'La référence interne est..',
    'rule_trigger_internal_reference_is'                  => 'La référence interne est ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'L\'ID du journal d\'opérations est..',
    'rule_trigger_journal_id'                             => 'L\'ID du journal d\'opérations est ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'La transaction a une (quelconque) URL externe',
    'rule_trigger_any_external_url_choice'                => 'A une URL externe',
    'rule_trigger_any_external_id'                        => 'La transaction a un ID externe (quelconque)',
    'rule_trigger_any_external_id_choice'                 => 'A un ID externe',
    'rule_trigger_no_external_url_choice'                 => 'N\'a pas d\'URL externe',
    'rule_trigger_no_external_url'                        => 'L\'opération n\'a pas d\'URL externe',
    'rule_trigger_no_external_id_choice'                  => 'N\'a pas d\'ID externe',
    'rule_trigger_no_external_id'                         => 'La transaction n\'a pas d\'ID externe',
    'rule_trigger_id_choice'                              => 'L\'ID de l\'opération est..',
    'rule_trigger_id'                                     => 'L\'ID de l\'opération est ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'Le virement SEPA est..',
    'rule_trigger_sepa_ct_is'                             => 'Le virement SEPA est ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'L\'action de l’utilisateur est ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Aucun tag n\'est..',
    'rule_trigger_tag_is_not'                             => 'Aucun tag n\'est ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'L\'un des comptes est exactement..',
    'rule_trigger_account_is'                             => 'L\'un des comptes est exactement ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'L\'un des comptes contient..',
    'rule_trigger_account_contains'                       => 'L\'un des comptes contient ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'L\'un des comptes se termine par..',
    'rule_trigger_account_ends'                           => 'L\'un des comptes se termine par ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'L\'un des comptes commence par..',
    'rule_trigger_account_starts'                         => 'L\'un des comptes commence par ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'L\'un des numéros de compte / IBAN est..',
    'rule_trigger_account_nr_is'                          => 'L\'un des numéros de compte / IBAN est ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'L\'un des numéros de compte / IBAN contient..',
    'rule_trigger_account_nr_contains'                    => 'L\'un des numéros de compte / IBAN contient ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'L\'un des numéros de compte / IBAN se termine par..',
    'rule_trigger_account_nr_ends'                        => 'L\'un des numéros de compte / IBAN se termine par ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'L\'un des numéros de compte / IBAN commence par..',
    'rule_trigger_account_nr_starts'                      => 'L\'un des numéros de compte / IBAN commence par ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'La catégorie contient..',
    'rule_trigger_category_contains'                      => 'La catégorie contient ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'La catégorie se termine par..',
    'rule_trigger_category_ends'                          => 'La catégorie se termine par ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'La catégorie commence par..',
    'rule_trigger_category_starts'                        => 'La catégorie commence par ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Le budget contient..',
    'rule_trigger_budget_contains'                        => 'Le budget contient ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Le budget se termine par..',
    'rule_trigger_budget_ends'                            => 'Le budget se termine par «:trigger_value»',
    'rule_trigger_budget_starts_choice'                   => 'Le budget commence par..',
    'rule_trigger_budget_starts'                          => 'Le budget commence par «:trigger_value»',
    'rule_trigger_bill_contains_choice'                   => 'L\'abonnement contient..',
    'rule_trigger_bill_contains'                          => 'L\'abonnement contient ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'L\'abonnement se termine par..',
    'rule_trigger_bill_ends'                              => 'L\'abonnement se termine par ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'L\'abonnement commence par..',
    'rule_trigger_bill_starts'                            => 'L\'abonnement commence par ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'L\'ID externe contient..',
    'rule_trigger_external_id_contains'                   => 'L\'ID externe contient ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'L\'ID externe se termine par..',
    'rule_trigger_external_id_ends'                       => 'L\'ID externe se termine par ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'L\'ID externe commence par..',
    'rule_trigger_external_id_starts'                     => 'L\'ID externe commence par ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'La référence interne contient..',
    'rule_trigger_internal_reference_contains'            => 'La référence interne contient ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'La référence interne se termine par..',
    'rule_trigger_internal_reference_ends'                => 'La référence interne se termine par ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'La référence interne commence par..',
    'rule_trigger_internal_reference_starts'              => 'La référence interne commence par «:trigger_value»',
    'rule_trigger_external_url_is_choice'                 => 'L\'URL externe est..',
    'rule_trigger_external_url_is'                        => 'L\'URL externe est ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'L\'URL externe contient..',
    'rule_trigger_external_url_contains'                  => 'L\'URL externe contient ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'L\'URL externe se termine par..',
    'rule_trigger_external_url_ends'                      => 'L\'URL externe se termine par ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'L\'URL externe commence par..',
    'rule_trigger_external_url_starts'                    => 'L\'URL externe commence par ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'N\'a pas de pièce jointe',
    'rule_trigger_has_no_attachments'                     => 'L\'opération n\'a pas de pièces jointes',
    'rule_trigger_recurrence_id_choice'                   => 'L\'ID de l\'opération récurrente est..',
    'rule_trigger_recurrence_id'                          => 'L\'ID de l\'opération récurrente est «:trigger_value»',
    'rule_trigger_interest_date_on_choice'                => 'La date d\'intérêt est le..',
    'rule_trigger_interest_date_on'                       => 'La date d\'intérêt est le ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'La date d\'intérêt est antérieure à..',
    'rule_trigger_interest_date_before'                   => 'La date d\'intérêt est antérieure à ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'La date d\'intérêt est postérieure à..',
    'rule_trigger_interest_date_after'                    => 'La date d\'intérêt est après ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'La date d\'enregistrement est le..',
    'rule_trigger_book_date_on'                           => 'La date d\'enregistrement est le ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'La date d\'enregistrement est avant..',
    'rule_trigger_book_date_before'                       => 'La date d\'enregistrement est avant ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'La date d\'enregistrement est après..',
    'rule_trigger_book_date_after'                        => 'La date d\'enregistrement est après le ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'La date de traitement est le..',
    'rule_trigger_process_date_on'                        => 'La date de traitement est le ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'La date de traitement est antérieure à..',
    'rule_trigger_process_date_before'                    => 'La date de traitement est antérieure au ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'La date de traitement est postérieure au..',
    'rule_trigger_process_date_after'                     => 'La date de traitement est postérieure au ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'La date d\'échéance est le..',
    'rule_trigger_due_date_on'                            => 'La date d\'échéance est le ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'La date d\'échéance est avant..',
    'rule_trigger_due_date_before'                        => 'La date d\'échéance est avant le ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'La date d\'échéance est après..',
    'rule_trigger_due_date_after'                         => 'La date d\'échéance est après le ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'La date de paiement est le..',
    'rule_trigger_payment_date_on'                        => 'La date de paiement est le ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'La date de paiement est avant le..',
    'rule_trigger_payment_date_before'                    => 'La date de paiement est avant le ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'La date de paiement est après..',
    'rule_trigger_payment_date_after'                     => 'La date de paiement est après le ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'La date de facturation est..',
    'rule_trigger_invoice_date_on'                        => 'La date de facturation est le ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'La date de facturation est avant..',
    'rule_trigger_invoice_date_before'                    => 'La date de facturation est avant le ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'La date de facturation est après..',
    'rule_trigger_invoice_date_after'                     => 'La date de facturation est après le ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'L\'opération a été créée avant..',
    'rule_trigger_created_at_before'                      => 'L\'opération a été créée avant le ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'L\'opération a été créée après..',
    'rule_trigger_created_at_after'                       => 'L\'opération a été créée après le ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'L\'opération a été mise à jour pour la dernière fois avant..',
    'rule_trigger_updated_at_before'                      => 'L\'opération a été mise à jour pour la dernière fois avant le ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'L\'opération a été mise à jour pour la dernière fois après..',
    'rule_trigger_updated_at_after'                       => 'L\'opération a été mise à jour pour la dernière fois après le ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Le montant en devise étrangère est exactement..',
    'rule_trigger_foreign_amount_is'                      => 'Le montant en devise étrangère est exactement ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Le montant en devise étrangère est inférieur à..',
    'rule_trigger_foreign_amount_less'                    => 'Le montant en devise étrangère est inférieur à ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Le montant en devise étrangère est supérieur à..',
    'rule_trigger_foreign_amount_more'                    => 'Le montant en devise étrangère est supérieur à ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Une pièce jointe se nomme..',
    'rule_trigger_attachment_name_is'                     => 'Une pièce jointe se nomme ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Le nom d\'une pièce jointe contient..',
    'rule_trigger_attachment_name_contains'               => 'Le nom d\'une pièce jointe contient ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Le nom d\'une pièce jointe commence par..',
    'rule_trigger_attachment_name_starts'                 => 'Le nom d\'une pièce jointe commence par ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Le nom d\'une pièce jointe se termine par..',
    'rule_trigger_attachment_name_ends'                   => 'Le nom d\'une pièce jointe se termine par ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Les notes d\'une pièce jointe sont..',
    'rule_trigger_attachment_notes_are'                   => 'Les notes d\'une pièce jointe sont ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Les notes d\'une pièce jointe contiennent..',
    'rule_trigger_attachment_notes_contains'              => 'Les notes d\'une pièce jointe contiennent ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Les notes d\'une pièce jointe commencent par..',
    'rule_trigger_attachment_notes_starts'                => 'Les notes d\'une pièce jointe commencent par ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Les notes d\'une pièce jointe se terminent par..',
    'rule_trigger_attachment_notes_ends'                  => 'Les notes d\'une pièce jointe se termine par ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'L\'opération est rapprochée',
    'rule_trigger_reconciled'                             => 'L\'opération est rapprochée',
    'rule_trigger_exists_choice'                          => 'N\'importe quelle opération correspond (!)',
    'rule_trigger_exists'                                 => 'N\'importe quelle opération correspond',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'L\'ID du compte n\'est pas «:trigger_value»',
    'rule_trigger_not_source_account_id'                  => 'L\'ID du compte source n\'est pas «:trigger_value»',
    'rule_trigger_not_destination_account_id'             => 'L\'ID du compte de destination n\'est pas «:trigger_value»',
    'rule_trigger_not_transaction_type'                   => 'Le type d\'opération n\'est pas «:trigger_value»',
    'rule_trigger_not_tag_is'                             => 'Le tag n\'est pas «:trigger_value»',
    'rule_trigger_not_tag_is_not'                         => 'Le tag est ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'La description n\'est pas «:trigger_value»',
    'rule_trigger_not_description_contains'               => 'La description ne contient pas «:trigger_value»',
    'rule_trigger_not_description_ends'                   => 'La description ne se termine pas par «:trigger_value»',
    'rule_trigger_not_description_starts'                 => 'La description ne commence pas par ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Les notes ne sont pas «:trigger_value»',
    'rule_trigger_not_notes_contains'                     => 'Les notes ne contiennent pas «:trigger_value»',
    'rule_trigger_not_notes_ends'                         => 'Les notes ne se terminent pas sur ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Les notes ne commencent pas par ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Le compte source n\'est pas «:trigger_value»',
    'rule_trigger_not_source_account_contains'            => 'Le compte source ne contient pas «:trigger_value»',
    'rule_trigger_not_source_account_ends'                => 'Le compte source ne se termine pas par ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Le compte source ne commence pas par «:trigger_value»',
    'rule_trigger_not_source_account_nr_is'               => 'Le numéro / IBAN du compte source n\'est pas ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Le numéro / IBAN du compte source ne contient pas ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Le numéro / IBAN du compte source ne se termine pas par ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Le numéro / IBAN du compte source ne commence pas par ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Le compte de destination n\'est pas «:trigger_value»',
    'rule_trigger_not_destination_account_contains'       => 'Le compte de destination ne contient pas ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Le compte de destination ne se termine pas par ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Le compte de destination ne commence pas par ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Le numéro / IBAN du compte de destination n\'est pas ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Le numéro / IBAN du compte de destination ne contient pas ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Le numéro / IBAN du compte de destination ne se termine pas par ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Le numéro / IBAN du compte de destination ne commence pas par ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Aucun compte n\'est ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Aucun compte ne contient ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Aucun compte ne se termine par ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Aucun compte ne commence par ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Aucun numéro / IBAN de compte n\'est ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Aucun numéro / IBAN de compte ne contient ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Aucun numéro / IBAN de compte ne se termine par ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Aucun numéro / IBAN de compte ne commence par ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'La catégorie n\'est pas «:trigger_value»',
    'rule_trigger_not_category_contains'                  => 'La catégorie ne contient pas «:trigger_value»',
    'rule_trigger_not_category_ends'                      => 'La catégorie ne se termine pas par ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'La catégorie ne commence pas par ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Le budget n\'est pas «:trigger_value»',
    'rule_trigger_not_budget_contains'                    => 'Le budget ne contient pas ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Le budget ne se termine pas par ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Le budget ne commence pas par ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'L\'abonnement n\'est pas ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'L\'abonnement ne contient pas ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'L\'abonnement ne se termine pas par ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'L\'abonnement ne se termine pas par ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'L\'ID externe n\'est pas ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'L\'ID externe ne contient pas ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'L\'ID externe ne se termine pas par ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'L\'ID externe ne commence pas par ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'La référence interne n\'est pas ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'La référence interne ne contient pas ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'La référence interne ne se termine pas par ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'La référence interne ne commence pas par «:trigger_value»',
    'rule_trigger_not_external_url_is'                    => 'L\'URL externe n\'est pas ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'L\'URL externe ne contient pas ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'L\'URL externe ne se termine pas par ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'L\'URL externe ne commence pas par ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'La devise n\'est pas «:trigger_value»',
    'rule_trigger_not_foreign_currency_is'                => 'La devise étrangère n\'est pas «:trigger_value»',
    'rule_trigger_not_id'                                 => 'L\'ID de l\'opération n\'est pas ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'L\'ID du journal d\'opérations n\'est pas ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'L\'ID de récurrence n\'est pas «:trigger_value»',
    'rule_trigger_not_date_on'                            => 'La date n\'est pas le ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'La date n\'est pas antérieure à ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'La date n\'est pas après ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'La date d\'intérêt n\'est pas le ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'La date d\'intérêt n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'La date d\'intérêt n\'est pas après le ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'La date d\'enregistrement n\'est pas le ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'La date d\'enregistrement n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'La date d\'enregistrement n\'est pas après le ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'La date de traitement n\'est pas le ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'La date de traitement n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'La date de traitement n\'est pas après le ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'La date d\'échéance n\'est pas le ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'La date d\'échéance n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'La date d\'échéance n\'est pas après le ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'La date de paiement n\'est pas le ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'La date de paiement n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'La date de paiement n\'est pas après le ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'La date de facturation n\'est pas le ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'La date de facturation n\'est pas avant le ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'La date de facturation n\'est pas après le ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'L\'opération n\'a pas été créée le ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'L\'opération n\'a pas été créée avant le ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'L\'opération n\'a pas été créée après le ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'L\'opération n\'a pas été mise à jour le ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'L\'opération n\'a pas été mise à jour avant le ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'L\'opération n\'a pas été mise à jour après le ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Le montant de l\'opération n\'est pas ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Le montant de l\'opération n\'est pas supérieur à ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Le montant de l\'opération n\'est pas inférieur à ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Le montant en devise étrangère n\'est pas ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Le montant en devise étrangère n\'est pas supérieur à ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Le montant en devise étrangère n\'est pas inférieur à ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Aucune pièce jointe ne se nomme ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Aucun nom de pièce jointe ne contient ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Aucun nom de pièce jointe ne commence par ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Aucun nom de pièce jointe ne se termine par ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Aucune note de pièce jointe n\'est ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Aucune note de pièce jointe ne contient ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Aucune note de pièce jointe ne commence par ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Aucune note de pièce jointe ne se termine par ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'L\'opération n\'est pas rapprochée',
    'rule_trigger_not_exists'                             => 'L\'opération n\'existe pas',
    'rule_trigger_not_has_attachments'                    => 'L\'opération n\'a pas de pièce jointe',
    'rule_trigger_not_has_any_category'                   => 'L\'opération n\'a pas de catégorie',
    'rule_trigger_not_has_any_budget'                     => 'L\'opération n\'a pas de budget',
    'rule_trigger_not_has_any_bill'                       => 'L\'opération n\'a pas d\'abonnement',
    'rule_trigger_not_has_any_tag'                        => 'L\'opération n\'a pas de tag',
    'rule_trigger_not_any_notes'                          => 'L\'opération n\'a pas de note',
    'rule_trigger_not_any_external_url'                   => 'L\'opération n\'a pas d\'URL externe',
    'rule_trigger_not_has_no_attachments'                 => 'L\'opération a au moins une pièce jointe',
    'rule_trigger_not_has_no_category'                    => 'L\'opération a une catégorie',
    'rule_trigger_not_has_no_budget'                      => 'L\'opération a un budget',
    'rule_trigger_not_has_no_bill'                        => 'L\'opération a un abonnement',
    'rule_trigger_not_has_no_tag'                         => 'L\'opération a un tag',
    'rule_trigger_not_no_notes'                           => 'L\'opération a au moins une note',
    'rule_trigger_not_no_external_url'                    => 'L\'opération a une URL externe',
    'rule_trigger_not_source_is_cash'                     => 'Le compte source n\'est pas un compte en espèces',
    'rule_trigger_not_destination_is_cash'                => 'Le compte de destination n\'est pas un compte en espèces',
    'rule_trigger_not_account_is_cash'                    => 'Aucun compte n\'est un compte en espèces',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Le solde du compte de destination est supérieur à..',
    'rule_trigger_destination_balance_gte_choice'         => 'Le solde du compte de destination est supérieur ou égal à..',
    'rule_trigger_destination_balance_is_choice'          => 'Le solde du compte de destination est exactement..',
    'rule_trigger_destination_balance_lt_choice'          => 'Le solde du compte de destination est inférieur à..',
    'rule_trigger_destination_balance_lte_choice'         => 'Le solde du compte de destination est inférieur ou égal à..',

    'rule_trigger_source_balance_gt_choice'  => 'Le solde du compte source est supérieur à..',
    'rule_trigger_source_balance_gte_choice' => 'Le solde du compte source est supérieur ou égal à..',
    'rule_trigger_source_balance_is_choice'  => 'Le solde du compte source est exactement..',
    'rule_trigger_source_balance_lt_choice'  => 'Le solde du compte source est inférieur à..',
    'rule_trigger_source_balance_lte_choice' => 'Le solde du compte source est inférieur ou égal à..',

    'rule_trigger_destination_balance_gt'  => 'Le solde du compte de destination est supérieur à :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Le solde du compte de destination est supérieur ou égal à :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Le solde du compte de destination est exactement :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Le solde du compte de destination est inférieur à :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Le solde du compte de destination est inférieur ou égal à :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Le solde du compte source est supérieur à :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Le solde du compte source est supérieur ou égal à :trigger_value',
    'rule_trigger_source_balance_is'           => 'Le solde du compte source est exactement :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Le solde du compte source est inférieur à :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Le solde du compte source est inférieur ou égal à :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Le solde du compte de destination est inférieur ou égal à :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Le solde du compte de destination est inférieur à :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Le solde du compte de destination n\'est pas :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Le solde du compte de destination est supérieur ou égal à :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Le solde du compte de destination est supérieur à :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Le solde du compte source est inférieur ou égal à :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Le solde du compte source est inférieur à :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Le solde du compte source n\'est pas :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Le solde du compte source est supérieur ou égal à :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Le solde du compte source est supérieur à :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'SUPPRIMER l\'opération(!)',
    'rule_action_delete_transaction'             => 'SUPPRIMER l\'opération(!)',
    'rule_action_set_category'                   => 'Définir la catégorie à ":action_value"',
    'rule_action_clear_category'                 => 'Supprimer de la catégorie',
    'rule_action_set_budget'                     => 'Définir le budget à ":action_value"',
    'rule_action_clear_budget'                   => 'Supprimer du budget',
    'rule_action_add_tag'                        => 'Ajouter un tag ":action_value"',
    'rule_action_remove_tag'                     => 'Retirer le tag ":action_value"',
    'rule_action_remove_all_tags'                => 'Retirer tous les tags',
    'rule_action_set_description'                => 'Définir la description à ":action_value"',
    'rule_action_append_description'             => 'Ajouter à la description ":action_value"',
    'rule_action_prepend_description'            => 'Préfixer la description avec ":action_value"',
    'rule_action_set_category_choice'            => 'Définir la catégorie à..',
    'rule_action_clear_category_choice'          => 'Effacer les catégories',
    'rule_action_set_budget_choice'              => 'Définir le budget à..',
    'rule_action_clear_budget_choice'            => 'Effacer les budgets',
    'rule_action_add_tag_choice'                 => 'Ajouter un tag..',
    'rule_action_remove_tag_choice'              => 'Retirer le tag..',
    'rule_action_remove_all_tags_choice'         => 'Supprimer tous les tags',
    'rule_action_set_description_choice'         => 'Définir la description à..',
    'rule_action_update_piggy_choice'            => 'Ajouter/supprimer un montant dans la tirelire..',
    'rule_action_update_piggy'                   => 'Ajouter/supprimer le montant de l\'opération dans la tirelire ":action_value"',
    'rule_action_append_description_choice'      => 'Suffixer la description avec..',
    'rule_action_prepend_description_choice'     => 'Préfixer la description avec..',
    'rule_action_set_source_account_choice'      => 'Définir le compte source à..',
    'rule_action_set_source_account'             => 'Définir le compte source à :action_value',
    'rule_action_set_destination_account_choice' => 'Définir le compte de destination à..',
    'rule_action_set_destination_account'        => 'Définir le compte de destination à :action_value',
    'rule_action_append_notes_choice'            => 'Ajouter aux notes ..',
    'rule_action_append_notes'                   => 'Rajouter aux notes ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Ajouter au début des notes..',
    'rule_action_prepend_notes'                  => 'Rajouter au début des notes ":action_value"',
    'rule_action_clear_notes_choice'             => 'Supprimer les notes',
    'rule_action_clear_notes'                    => 'Supprimer les notes',
    'rule_action_set_notes_choice'               => 'Remplacer les notes par..',
    'rule_action_link_to_bill_choice'            => 'Lier à un abonnement.',
    'rule_action_link_to_bill'                   => 'Lier à l\'abonnement ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Intervertir les comptes source et destination (transferts uniquement !)',
    'rule_action_switch_accounts'                => 'Inverser source et destination',
    'rule_action_set_notes'                      => 'Remplacer les notes par ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Convertir cette opération en dépôt',
    'rule_action_convert_deposit'                => 'Convertir cette opération en dépôt depuis ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Convertir cette opération en dépense',
    'rule_action_convert_withdrawal'             => 'Convertir cette opération en dépense vers ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Convertir cette opération en transfert',
    'rule_action_convert_transfer'               => 'Convertir cette opération en transfert avec ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Ajouter la description à la fin des notes de l\'opération',
    'rule_action_append_notes_to_descr_choice'   => 'Ajouter les notes de l\'opération à la description',
    'rule_action_move_descr_to_notes_choice'     => 'Remplacer les notes actuelles de l\'opération par la description',
    'rule_action_move_notes_to_descr_choice'     => 'Remplacer la description actuelle par les notes de l\'opération',
    'rule_action_append_descr_to_notes'          => 'Ajouter la description aux notes',
    'rule_action_append_notes_to_descr'          => 'Ajouter les notes à la description',
    'rule_action_move_descr_to_notes'            => 'Remplacer les notes par la description',
    'rule_action_move_notes_to_descr'            => 'Remplacer la description par les notes',
    'rule_action_set_amount_choice'              => 'Définir le montant à ..',
    'rule_action_set_amount'                     => 'Définir le montant à ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Définir le compte de destination à (espèces)',
    'rule_action_set_source_to_cash_choice'      => 'Définir le compte source à (espèces)',
    'rulegroup_for_bills_title'                  => 'Groupe de règles pour les abonnements',
    'rulegroup_for_bills_description'            => 'Un groupe de règles spéciales pour toutes les règles qui impliquent des abonnements.',
    'rule_for_bill_title'                        => 'Règle auto-générée pour l\'abonnement ":name"',
    'rule_for_bill_description'                  => 'Cette règle est générée automatiquement pour essayer de correspondre à l\'abonnement ":name".',
    'create_rule_for_bill'                       => 'Créer une nouvelle règle pour l\'abonnement ":name"',
    'create_rule_for_bill_txt'                   => 'Vous venez de créer une nouvel abonnement appelé ":name", félicitations ! Firefly III peut auto-magiquement raccrocher de nouvelles dépenses à cet abonnement. Par exemple, chaque fois que vous payez votre loyer, l\'abonnement "loyer" sera lié à la dépense. De cette façon, Firefly III peut vous montrer exactement quels abonnements sont dûs et lesquels ne le sont pas. Pour ce faire, une nouvelle règle doit être créée. Firefly III a rempli certaines valeurs qui doivent être logiques pour vous. Veuillez vous assurer qu\'elles sont correctes. Si c\'est le cas, Firefly III liera automatiquement la bonne dépense au bon abonnement. Veuillez également vérifier les déclencheurs pour voir s\'ils sont corrects, s\'il faut en ajouter ou s\'il faut en corriger.',
    'new_rule_for_bill_title'                    => 'Règle pour l\'abonnement «:name»',
    'new_rule_for_bill_description'              => 'Cette règle marque les transactions de l\'abonnement «:name».',

    'new_rule_for_journal_title'                => 'Règle basée sur l\'opération ":description"',
    'new_rule_for_journal_description'          => 'Cette règle est basée sur l\'opération ":description". Elle générera une correspondance sur les opérations strictement identiques.',

    // tags
    'store_new_tag'                             => 'Créer un nouveau tag',
    'update_tag'                                => 'Mettre à jour le tag',
    'no_location_set'                           => 'Aucun emplacement défini.',
    'meta_data'                                 => 'Métadonnées',
    'location'                                  => 'Emplacement',
    'location_first_split'                      => 'La localisation de cette opération peut être définie lors du premier fractionnement de cette opération.',
    'without_date'                              => 'Sans date',
    'result'                                    => 'Résultat',
    'sums_apply_to_range'                       => 'Toutes les sommes s\'appliquent à l\'ensemble sélectionné',
    'mapbox_api_key'                            => 'Pour utiliser la carte, obtenez une clé d\'API auprès de <a href="https://www.mapbox.com/">Mapbox</a>. Ouvrez votre fichier <code>.env</code> et saisissez le code après <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Faites un clic droit ou appuyez longuement pour définir l\'emplacement de l\'objet.',
    'click_tap_location'                        => 'Cliquez ou appuyez sur la carte pour ajouter un emplacement',
    'clear_location'                            => 'Effacer la localisation',
    'delete_all_selected_tags'                  => 'Supprimer tous les tags sélectionnés',
    'select_tags_to_delete'                     => 'N\'oubliez pas de sélectionner des tags.',
    'deleted_x_tags'                            => ':count tag supprimé.|:count tags supprimés.',
    'create_rule_from_transaction'              => 'Créer une règle basée sur une opération',
    'create_recurring_from_transaction'         => 'Créer une opération récurrente sur base d\'une opération',

    // preferences
    'test_notifications_buttons'                => 'Pour tester votre configuration, utilisez les boutons ci-dessous. Veuillez noter que les boutons n\'ont pas de contrôle de spam.',
    'dark_mode_option_browser'                  => 'Laisser le navigateur décider',
    'dark_mode_option_light'                    => 'Toujours clair',
    'dark_mode_option_dark'                     => 'Toujours sombre',
    'equal_to_language'                         => '(égal à la langue)',
    'dark_mode_preference'                      => 'Mode sombre',
    'dark_mode_preference_help'                 => 'Dire à Firefly III quand utiliser le mode sombre.',
    'pref_home_screen_accounts'                 => 'Comptes de l’écran d’accueil',
    'pref_home_screen_accounts_help'            => 'Quels sont les comptes à afficher sur la page d’accueil ?',
    'pref_view_range'                           => 'Intervalle d\'affichage',
    'pref_view_range_help'                      => 'Certains graphiques sont automatiquement regroupés par périodes. Vos budgets seront aussi organisés par périodes. Quelle période préférez-vous ?',
    'pref_1D'                                   => 'Un jour',
    'pref_1W'                                   => 'Une semaine',
    'pref_1M'                                   => 'Un mois',
    'pref_3M'                                   => 'Trois mois (trimestre)',
    'pref_6M'                                   => 'Six mois',
    'pref_1Y'                                   => 'Un an',
    'pref_last365'                              => 'L\'année dernière',
    'pref_last90'                               => 'Les 90 derniers jours',
    'pref_last30'                               => 'Les 30 derniers jours',
    'pref_last7'                                => 'Les 7 derniers jours',
    'pref_YTD'                                  => 'Année en cours',
    'pref_QTD'                                  => 'Ce trimestre',
    'pref_MTD'                                  => 'Depuis le début du mois',
    'pref_languages'                            => 'Langues',
    'pref_locale'                               => 'Paramètres régionaux',
    'pref_languages_help'                       => 'Firefly III prend en charge plusieurs langues. Laquelle préférez-vous ?',
    'pref_locale_help'                          => 'Firefly III vous permet de définir d\'autres paramètres locaux, comme la façon dont les devises, les nombres et les dates sont formatées. Les entrées dans cette liste peuvent ne pas être prises en charge par votre système. Firefly III n\'est pas paramétré correctement pour toutes les langues ; contactez-moi pour les améliorer.',
    'pref_locale_no_demo'                       => 'Cette fonctionnalité ne fonctionnera pas pour l\'utilisateur de démonstration.',
    'pref_convert_to_primary'                   => 'Afficher les montants dans votre devise principale',
    'pref_convert_to_primary_help'              => 'Cette option permettra à Firefly III d\'essayer d\'afficher et de montrer votre devise principale dans autant d\'endroits que possible, en convertissant les montants si nécessaire. Cela sacrifie la précision pour faciliter l’utilisation, car la conversion n’est pas toujours exacte. Veuillez vérifier que Firefly III a les taux de conversion nécessaires sur la page « taux de change ».',
    'pref_convert_primary_help'                 => 'Afficher les montants principaux',
    'pref_custom_fiscal_year'                   => 'Paramètres fiscaux de l\'année',
    'pref_custom_fiscal_year_label'             => 'Activé',
    'pref_custom_fiscal_year_help'              => 'Dans les pays qui utilisent une année financière autre que du 1er janvier au 31 décembre, vous pouvez la changer en spécifiant le jour de début et de fin de l\'année fiscale',
    'pref_fiscal_year_start_label'              => 'Date du début de l\'année fiscale',
    'pref_two_factor_auth'                      => 'Authentification multi-facteurs',
    'pref_two_factor_auth_help'                 => 'Lorsque vous activez l\'authentification multi-facteurs (également connue sous le nom d\'authentification à deux étapes), vous ajoutez une couche de sécurité supplémentaire à votre compte. Vous vous connectez avec quelque chose que vous connaissez (votre mot de passe) et quelque chose que vous avez (un code de vérification). Les codes de vérification sont générés par une application sur votre téléphone, comme Authy ou Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Activer l\'authentification multi-facteurs',
    'pref_two_factor_auth_disabled'             => 'Code de vérification d\'authentification multi-facteurs supprimé et désactivé',
    'pref_two_factor_auth_remove_it'            => 'N’oubliez pas de supprimer ce compte de votre application d’authentification !',
    'pref_two_factor_auth_code'                 => 'Vérifier le code',
    'pref_two_factor_auth_code_help'            => 'Scannez le QR code avec une application sur votre téléphone comme Authy ou Google Authenticator et saisissez le code généré. Le QR code change chaque fois que vous visitez cette page. Assurez-vous d\'utiliser le code le plus récent.',
    'pref_two_factor_auth_reset_code'           => 'Réinitialiser le code de vérification',
    'pref_two_factor_auth_disable_2fa'          => 'Désactiver l\'authentification multi-facteurs',
    '2fa_use_secret_instead'                    => 'Si vous ne pouvez pas scanner le code QR, vous pouvez utiliser le code suivant à la place : <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Stockez ces codes de récupération pour vous connecter au cas où vous perdez votre appareil.',
    '2fa_already_enabled'                       => 'L\'authentification multi-facteurs est déjà activée.',
    'wrong_mfa_code'                            => 'Le code MFA n\'est pas valide.',
    'pref_save_settings'                        => 'Enregistrer les paramètres',
    'saved_preferences'                         => 'Préférences enregistrées !',
    'preferences_general'                       => 'Général',
    'preferences_frontpage'                     => 'Écran d\'accueil',
    'preferences_security'                      => 'Sécurité',
    'preferences_layout'                        => 'Mise en Page',
    'preferences_notifications'                 => 'Notifications',
    'pref_home_show_deposits'                   => 'Afficher les dépôts sur l\'écran d\'accueil',
    'pref_home_show_deposits_info'              => 'L\'écran d\'accueil affiche déjà vos comptes de dépenses. Devrait-il aussi afficher vos comptes de revenus ?',
    'pref_home_do_show_deposits'                => 'Oui, montrez-les',
    'successful_count'                          => 'dont :count avec succès',
    'list_page_size_title'                      => 'Taille de la page',
    'list_page_size_help'                       => 'Les listes d\'éléments (comptes, opérations, etc) affichent un nombre maximum d\'élément par page.',
    'list_page_size_label'                      => 'Nombre d\'élément par page',
    'between_dates'                             => '(:start et :end)',
    'pref_optional_fields_transaction'          => 'Champs optionnels pour les opérations',
    'pref_optional_fields_transaction_help'     => 'Par défaut, tous les champs ne sont pas disponibles lors de la création d\'une nouvelle opération (pour éviter de surcharger la page). Vous pouvez activer les champs suivants si vous pensez qu\'ils peuvent vous être utiles. Bien sûr, tout champ désactivé mais précédemment rempli restera visible quel que soit son paramétrage.',
    'optional_tj_date_fields'                   => 'Champ date',
    'optional_tj_other_fields'                  => 'Autres champs',
    'optional_tj_attachment_fields'             => 'Champs de pièces jointes',
    'pref_optional_tj_interest_date'            => 'Date de valeur (intérêts)',
    'pref_optional_tj_book_date'                => 'Date d\'enregistrement',
    'pref_optional_tj_process_date'             => 'Date de traitement',
    'pref_optional_tj_due_date'                 => 'Échéance',
    'pref_optional_tj_payment_date'             => 'Date de paiement',
    'pref_optional_tj_invoice_date'             => 'Date de facturation',
    'pref_optional_tj_internal_reference'       => 'Référence interne',
    'pref_optional_tj_notes'                    => 'Notes',
    'pref_optional_tj_attachments'              => 'Pièces jointes',
    'pref_optional_tj_external_url'             => 'URL externe',
    'pref_optional_tj_location'                 => 'Emplacement',
    'pref_optional_tj_links'                    => 'Liens d\'opération',
    'optional_field_meta_dates'                 => 'Dates',
    'optional_field_meta_business'              => 'Commerce',
    'optional_field_attachments'                => 'Pièces jointes',
    'optional_field_meta_data'                  => 'Métadonnées facultatives',
    'external_url'                              => 'URL externe',
    'pref_notification_login_failure'           => 'Échec de la connexion',
    'pref_notification_bill_reminder'           => 'Rappel concernant les abonnements arrivant à échéance',
    'pref_notification_new_access_token'        => 'Alerte à la création d\'un nouveau jeton d\'accès API',
    'pref_notification_transaction_creation'    => 'Alerte à la création automatique d\'une opération',
    'pref_notification_user_login'              => 'Alerte à la connexion depuis un nouvel emplacement',
    'pref_notification_rule_action_failures'    => 'Alerte lorsque les actions des règles ne s\'exécutent pas (pas par e-mail)',
    'pref_notification_new_password'            => 'Votre mot de passe a été modifié',
    'pref_notification_enabled_mfa'             => 'L\'authentification multi-facteurs est activée',
    'pref_notification_disabled_mfa'            => 'L\'authentification multi-facteurs est désactivée',
    'pref_notification_few_left_mfa'            => 'Il ne vous reste que quelques codes de secours',
    'pref_notification_no_left_mfa'             => 'Il ne vous reste aucun code de secours',
    'pref_notification_many_failed_mfa'         => 'La vérification de l\'authentification multi-facteurs échoue',
    'pref_notification_new_backup_codes'        => 'De nouveaux codes de secours ont été générés',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Sélectionnez les notifications que vous souhaitez recevoir. Certaines notifications peuvent contenir des informations financières sensibles.',
    'pref_notifications_settings'               => 'Paramètres des notifications',
    'pref_notifications_settings_help'          => 'Utilisez ces paramètres pour configurer vos canaux de notification. Veuillez noter que les notifications seront envoyées à TOUS les canaux. Veuillez D\'ABORD enregistrer vos paramètres.',
    'slack_url_label'                           => 'URL du webhook entrant de Slack',
    'discord_url_label'                         => 'URL du webhook Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Taux de change',
    'header_exchange_rates'                     => 'Taux de change',
    'exchange_rates_intro'                      => 'Firefly III prend en charge le chargement et l\'utilisation des taux de change. En savoir plus à ce sujet dans <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">la documentation</a>.',
    'exchange_rates_from_to'                    => 'Entre {from} et {to} (et l\'inverse)',
    'header_exchange_rates_rates'               => 'Taux de change',
    'exchange_rates_intro_rates'                => 'Firefly III utilise les taux de change suivants. L\'inverse est calculé automatiquement lorsqu\'il n\'est pas fourni. Si aucun taux de change n\'existe pour la date de la transaction, Firefly III reviendra dans le temps pour en trouver un. Si aucun n\'est présent, le taux "1" sera utilisé.',
    'header_exchange_rates_table'               => 'Table avec taux de change',
    'help_rate_form'                            => 'Aujourd\'hui, combien de {to} obtiendrez-vous pour un {from} ?',
    'save_new_rate'                             => 'Enregistrer le nouveau taux',
    'add_new_rate'                              => 'Ajouter un nouveau taux de change',
    'not_enough_currencies'                     => 'Pas assez de devises',
    'not_enough_currencies_enabled'             => 'Si vous n\'avez qu\'une seule devise activée, il n\'y a pas besoin d\'ajouter des taux de change.',

    // Financial administrations
    'administration_index'                      => 'Administration financière',
    'administrations_breadcrumb'                => 'Administrations financières',
    'administrations_page_title'                => 'Administrations financières',
    'administrations_index_menu'                => 'Administrations financières',
    'administrations_page_sub_title'            => 'Vue d\'ensemble',
    'create_administration'                     => 'Créer une nouvelle administration',
    'administration_owner'                      => 'Propriétaire de l\'administration : {{email}}',
    'administration_you'                        => 'Votre rôle : {{role}}',
    'other_users_in_admin'                      => 'Autres utilisateurs dans cette administration',
    'administrations_create_breadcrumb'         => 'Créer une nouvelle administration financière',
    'administrations_page_create_sub_title'     => 'Créer une nouvelle administration financière',
    'basic_administration_information'          => 'Informations de base sur l\'administration',
    'new_administration_created'                => 'La nouvelle administration financière "{{title}}" a été créée',
    'edit_administration_breadcrumb'            => 'Modifier l\'administration financière ":title"',
    'administrations_page_edit_sub_title'       => 'Modifier l\'administration financière ":title"',
    'administrations_page_edit_sub_title_js'    => 'Modifier l\'administration financière "{title}"',
    'temp_administrations_introduction'         => 'Firefly III aura bientôt la possibilité de gérer plusieurs administrations financières. Pour le moment, vous n\'en avez qu\'une. Vous pouvez définir le titre de cette administration et de sa devise principale. Cela remplace le paramètre précédent où vous définissiez votre "devise par défaut". Ce paramètre est désormais lié à l\'administration financière et peut être différent par administration.',
    'temp_administrations_introduction_edit'    => 'Actuellement, vous ne pouvez définir que la "devise principale" de l\'administration financière par défaut. Cela remplace le paramètre "devise par défaut". Ce paramètre est désormais lié à l\'administration financière et peut être différent par administration.',
    'administration_currency_form_help'         => 'La page peut mettre longtemps à charger si vous modifiez la devise principale, car des opérations peuvent nécessiter une conversion vers votre (nouvelle) devise principale.',
    'flash_administration_updated'              => 'L\'administration «:title» a été mise à jour',
    'flash_administration_created'              => 'L\'administration «:title» a été créée',
    'flash_administration_deleted'              => 'L\'administration ":title" a été supprimée',

    // roles
    'administration_role_owner'                 => 'Propriétaire',
    'administration_role_ro'                    => 'Lecture seule',
    'administration_role_mng_trx'               => 'Gérer les opérations',
    'administration_role_mng_meta'              => 'Gérer la classification et les métadonnées',
    'administration_role_mng_budgets'           => 'Gérer les budgets',
    'administration_role_mng_piggies'           => 'Gérer les tirelires',
    'administration_role_mng_subscriptions'     => 'Gérer les abonnements',
    'administration_role_mng_rules'             => 'Gérer les règles',
    'administration_role_mng_recurring'         => 'Gérer les opérations périodiques',
    'administration_role_mng_webhooks'          => 'Gérer les webhooks',
    'administration_role_mng_currencies'        => 'Gérer les devises',
    'administration_role_view_reports'          => 'Afficher les rapports',
    'administration_role_full'                  => 'Accès complet',

    // mfa
    'enable_mfa'                                => 'Activer l\'authentification multi-facteurs',
    'mfa_index_title'                           => 'Authentification multi-facteurs',
    'mfa_index_intro'                           => 'Firefly III prend en charge l\'authentification multi-facteurs (MFA). Vous pouvez activer l\'authentification multi-facteurs sur votre compte pour ajouter une couche de sécurité supplémentaire. Des applications comme Authy, Google Authenticator et FreeOTP peuvent être utilisées pour générer les codes dont vous avez besoin pour vous connecter. Les clés de sécurité ne sont pas prises en charge par Firefly III, mais vous pouvez utiliser une clé de sécurité comme périphérique de stockage pour votre secret MFA.',
    'mfa_index_enabled'                         => 'L\'authentification multi-facteurs est activée pour votre compte.',
    'mfa_index_disabled'                        => 'L\'authentification multi-facteurs n\'est pas activée pour votre compte.',
    'mfa_index_owner'                           => 'Le propriétaire de cette instance sera toujours en mesure de désactiver l\'authentification multi-facteurs pour votre compte.',
    'current_password_confirm_mfa'              => 'Entrez votre mot de passe actuel',
    'mfa_warning_code_changes'                  => 'Il est possible que vous obteniez une boîte de dialogue MFA après avoir entré votre mot de passe et un code MFA. Dans ce cas, veuillez attendre que votre application génère un nouveau code MFA et ne pas réutiliser celui que vous venez d\'utiliser.',
    'mfa_already_disabled'                      => 'L\'authentification multi-facteurs n\'est pas activée, vous ne pouvez donc pas la désactiver.',
    'disable_mfa_page'                          => 'Désactiver l\'authentification multi-facteurs',
    'disable_mfa_intro'                         => 'Vous pouvez désactiver l\'authentification multi-facteurs. Pour ce faire, saisissez votre mot de passe et un code d\'authentification multi-facteurs. Si vous souhaitez désactiver l\'authentification multi-facteurs car vous avez perdu accès à votre générateur de codes, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">veuillez consulter la documentation</a>.',
    'pref_disable_mfa'                          => 'Désactiver l\'authentification multi-facteurs',
    'mfa_not_enabled'                           => 'L\'authentification multi-facteurs n\'est pas activée.',
    'mfa_backup_codes_intro'                    => 'Firefly III peut générer des codes de secours pour vous. Ces codes peuvent être utilisés pour vous connecter lorsque vous ne pouvez pas utiliser votre générateur de code. Vous pouvez générer un nouvel ensemble de codes à tout moment. Si vous générez un nouvel ensemble, l\'ancien jeu sera invalidé.',
    'mfa_backup_codes_quick'                    => 'Si vous êtes venu très rapidement de la page de configuration de l\'authentification multi-facteurs, votre application n\'a peut-être pas encore généré de nouveau code. Sachez que les codes MFA ne peuvent être utilisés qu\'une seule fois. Assurez-vous d\'utiliser un code différent du précédent.',
    'mfa_backup_codes_title'                    => 'Codes de secours d\'authentification multi-facteurs',
    'mfa_backup_codes_post_title'               => 'Codes de secours d\'authentification multi-facteurs',

    // profile:
    'manage_mfa_settings'                       => 'Gérer les paramètres d\'authentification multi-facteurs',
    'purge_data_title'                          => 'Purger des données de Firefly III',
    'purge_data_expl'                           => '« Purger » signifie « supprimer ce qui est déjà supprimé ». En temps normal, Firefly III ne supprime rien définitivement. Il ne fait que le cacher. Le bouton ci-dessous supprime tous ces enregistrements précédemment "supprimés".',
    'delete_stuff_header'                       => 'Supprimer et purger les données',
    'purge_all_data'                            => 'Purger tous les enregistrements supprimés',
    'purge_data'                                => 'Purger les données',
    'purged_all_records'                        => 'Tous les enregistrements supprimés ont été purgés.',
    'delete_data_title'                         => 'Supprimer des données de Firefly III',
    'permanent_delete_stuff'                    => 'Vous pouvez supprimer des éléments de Firefly III. En utilisant les boutons ci-dessous, vos éléments seront cachés. Il n\'y a pas de bouton d\'annulation pour cela, mais les éléments peuvent rester dans la base de données où vous pouvez les restaurer si nécessaire.',
    'other_sessions_logged_out'                 => 'Toutes vos autres sessions ont été déconnectées.',
    'delete_unused_accounts'                    => 'La suppression des comptes inutilisés effacera vos listes de remplissage automatique.',
    'delete_all_unused_accounts'                => 'Supprimer les comptes inutilisés',
    'deleted_all_unused_accounts'               => 'Tous les comptes inutilisés sont supprimés',
    'delete_all_budgets'                        => 'Supprimer TOUS vos budgets',
    'delete_all_categories'                     => 'Supprimer TOUTES vos catégories',
    'delete_all_tags'                           => 'Supprimer TOUS vos tags',
    'delete_all_bills'                          => 'Supprimer TOUS vos abonnements',
    'delete_all_piggy_banks'                    => 'Supprimer TOUTES vos tirelires',
    'delete_all_rules'                          => 'Supprimer TOUTES vos règles',
    'delete_all_recurring'                      => 'Supprimer TOUTES vos opérations récurrentes',
    'delete_all_object_groups'                  => 'Supprimer TOUS vos groupes d\'objets',
    'delete_all_accounts'                       => 'Supprimer TOUS vos comptes',
    'delete_all_asset_accounts'                 => 'Supprimer TOUS vos comptes d\'actifs',
    'delete_all_expense_accounts'               => 'Supprimer TOUS vos comptes de dépenses',
    'delete_all_revenue_accounts'               => 'Supprimer TOUS vos comptes de revenus',
    'delete_all_liabilities'                    => 'Supprimer TOUS vos passifs',
    'delete_all_transactions'                   => 'Supprimer TOUTES vos opérations',
    'delete_all_withdrawals'                    => 'Supprimer TOUTES vos dépenses',
    'delete_all_deposits'                       => 'Supprimer TOUS vos dépôts',
    'delete_all_transfers'                      => 'Supprimer TOUS vos transferts',
    'also_delete_transactions'                  => 'La suppression des comptes supprimera également TOU(TE)S les dépenses, dépôts et transferts associé(e)s !',
    'deleted_all_budgets'                       => 'Tous les budgets ont été supprimés',
    'deleted_all_categories'                    => 'Toutes les catégories ont été supprimées',
    'deleted_all_tags'                          => 'Tous les étiquettes ont été supprimés',
    'deleted_all_bills'                         => 'Tous les abonnements ont été supprimés',
    'deleted_all_piggy_banks'                   => 'Toutes les tirelires ont été supprimées',
    'deleted_all_rules'                         => 'Toutes les règles et les groupes de règles ont été supprimés',
    'deleted_all_object_groups'                 => 'Tous les groupes ont été supprimés',
    'deleted_all_accounts'                      => 'Tous les comptes ont été supprimés',
    'deleted_all_asset_accounts'                => 'Tous les comptes d\'actifs ont été supprimés',
    'deleted_all_expense_accounts'              => 'Tous les comptes de dépenses ont été supprimés',
    'deleted_all_revenue_accounts'              => 'Tous les comptes de revenus ont été supprimés',
    'deleted_all_liabilities'                   => 'Tous les passifs ont été supprimés',
    'deleted_all_transactions'                  => 'Toutes les opérations ont été supprimées',
    'deleted_all_withdrawals'                   => 'Toutes les dépenses ont été supprimés',
    'deleted_all_deposits'                      => 'Tous les dépôts ont été supprimés',
    'deleted_all_transfers'                     => 'Tous les transferts ont été supprimés',
    'deleted_all_recurring'                     => 'Toutes les opérations récurrentes ont été supprimées',
    'change_your_password'                      => 'Modifier votre mot de passe',
    'delete_account'                            => 'Supprimer le compte',
    'current_password'                          => 'Mot de passe actuel',
    'new_password'                              => 'Nouveau mot de passe ',
    'new_password_again'                        => 'Nouveau mot de passe (confirmation)',
    'delete_your_account'                       => 'Supprimer votre compte',
    'delete_your_account_help'                  => 'La suppression de votre compte supprimera également les comptes, les opérations, <em>tout</em> ce que vous pourriez avoir enregistré dans Firefly III. Tout sera SUPPRIMÉ.',
    'delete_your_account_password'              => 'Entrez votre mot de passe pour continuer.',
    'password'                                  => 'Mot de passe',
    'are_you_sure'                              => 'Êtes-vous sûr ? Vous ne pourrez pas annuler cette action.',
    'are_you_sure_confirm'                      => 'Êtes-vous sûr(e) ?',
    'delete_account_button'                     => 'SUPPRIMER votre compte',
    'invalid_current_password'                  => 'Mot de passe actuel non valide !',
    'password_changed'                          => 'Mot de passe modifié !',
    'should_change'                             => 'L’idée est de changer votre mot de passe.',
    'invalid_password'                          => 'Mot de passe incorrect !',
    'what_is_pw_security'                       => 'Qu\'est-ce que "vérifier la sécurité du mot de passe" ?',
    'secure_pw_title'                           => 'Comment choisir un mot de passe sécurisé',
    'forgot_password_response'                  => 'Merci. Si un compte existe avec cette adresse e-mail, vous trouverez des instructions dans votre boîte de réception.',
    'secure_pw_history'                         => 'Pas une semaine ne se passe sans que vous lisiez dans la presse qu\'un site s\'est fait dérober les mots de passe de ses utilisateurs. Les pirates et les voleurs utilisent ces mots de passe pour tenter de voler vos informations personnelles. Cette information est précieuse.',
    'secure_pw_ff'                              => 'Vous utilisez le même mot de passe partout sur Internet ? Si un seul site se fait dérober ce mot de passe, c\'est l\'ensemble de vos comptes et données qui sont exposées aux pirates. Firefly III compte sur vous pour choisir un mot de passe unique et fort pour protéger vos informations financières.',
    'secure_pw_check_box'                       => 'Pour vous y aider Firefly III peut vérifier que le mot de passe que vous souhaitez utiliser n\'a jamais été dérobé auparavant. Si c\'est le cas, Firefly III vous conseille de NE PAS utiliser ce mot de passe.',
    'secure_pw_working_title'                   => 'Comment est-ce que cela fonctionne ?',
    'secure_pw_working'                         => 'Si vous cochez l\'option, Firefly III enverra les 5 premiers caractères de l\'empreinte SHA1 de votre mot de passe au <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">site Web de Troy Hunt</a> pour contrôler si elle y apparait. Cela vous empêchera d\'utiliser des mots de passe non sûrs tel que recommandé par la dernière <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">publication spéciale NIST</a> sur le sujet.',
    'secure_pw_should'                          => 'Dois-je cocher la case ?',
    'secure_pw_long_password'                   => 'Oui. Toujours vérifier que votre mot de passe est sûr.',
    'command_line_token'                        => 'Jeton de ligne de commande',
    'explain_command_line_token'                => 'Vous avez besoin de ce jeton pour exécuter des lignes de commande telles qu\'exporter des données. Sans celui-ci, une telle commande ne fonctionnera pas. Ne partagez jamais votre jeton. Personne ne vous le demandera, pas même moi. Si vous craignez de le perdre, ou si vous êtes parano, régénérez ce jeton à l\'aide du bouton.',
    'regenerate_command_line_token'             => 'Régénérer le jeton de ligne de commande',
    'token_regenerated'                         => 'Un nouveau jeton en ligne de commande a été généré',
    'change_your_email'                         => 'Changer votre adresse e-mail',
    'email_verification'                        => 'Un e-mail sera envoyé à votre ancienne ET votre nouvelle adresse. Pour des raisons de sécurité, vous ne pourrez pas vous connecter jusqu\'à ce que vous ayez vérifié votre nouvelle adresse. Si vous n\'êtes pas certain que votre installation de Firefly III soit capable d\'envoyer un e-mail, n\'utilisez pas cette fonctionnalité. Si vous êtes un administrateur, vous pouvez tester l\'envoi des e-mails en allant dans les <a href="/admin">paramètres</a>.',
    'email_changed_logout'                      => 'Vous ne pouvez pas vous connecter tant que vous n\'aurez pas vérifié votre adresse e-mail.',
    'login_with_new_email'                      => 'Vous pouvez désormais vous connecter avec votre nouvelle adresse e-mail.',
    'login_with_old_email'                      => 'Vous pouvez à nouveau vous connecter à l\'aide de votre ancienne adresse e-mail.',
    'login_provider_local_only'                 => 'Cette action n’est pas disponible lors de l’authentification par ":login_provider".',
    'external_user_mgt_disabled'                => 'Cette action n\'est pas disponible lorsque Firefly III n\'est pas responsable de la gestion des utilisateurs ou de l\'authentification.',
    'external_auth_disabled'                    => 'Cette action n\'est pas disponible lorsque Firefly III n\'est pas responsable de la gestion de l\'authentification.',
    'delete_local_info_only'                    => "Comme Firefly III n'est pas responsable de la gestion des utilisateurs ou de l'authentification, cette fonction ne supprimera que les informations locales de Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clients OAuth',
    'profile_oauth_no_clients'                  => 'Vous n’avez pas encore créé de client OAuth.',
    'profile_oauth_clients_external_auth'       => 'Si vous utilisez un fournisseur d\'authentification externe comme Authelia, les clients OAuth ne fonctionneront pas. Vous ne pouvez utiliser que des jetons d\'accès personnel.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'Identifiant',
    'profile_oauth_client_name'                 => 'Nom',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Créer un nouveau client',
    'profile_oauth_create_client'               => 'Créer un client',
    'profile_oauth_edit_client'                 => 'Modifier le client',
    'profile_oauth_name_help'                   => 'Quelque chose que vos utilisateurs reconnaîtront et qui inspirera confiance.',
    'profile_oauth_redirect_url'                => 'URL de redirection',
    'profile_oauth_redirect_url_help'           => 'URL de callback de votre application.',
    'profile_authorized_apps'                   => 'Applications autorisées',
    'profile_authorized_clients'                => 'Clients autorisés',
    'profile_scopes'                            => 'Permissions',
    'profile_revoke'                            => 'Révoquer',
    'profile_oauth_client_secret_title'         => 'Secret du client',
    'profile_oauth_client_secret_expl'          => 'Voici votre nouveau secret de client. C\'est la seule fois qu\'il sera affiché, donc ne le perdez pas ! Vous pouvez maintenant utiliser ce secret pour faire des requêtes d\'API.',
    'profile_personal_access_tokens'            => 'Jetons d\'accès personnels',
    'profile_personal_access_token'             => 'Jeton d\'accès personnel',
    'profile_oauth_confidential'                => 'Confidentiel',
    'profile_oauth_confidential_help'           => 'Exiger que le client s\'authentifie avec un secret. Les clients confidentiels peuvent détenir des informations d\'identification de manière sécurisée sans les exposer à des tiers non autorisés. Les applications publiques, telles que les applications de bureau natif ou les SPA JavaScript, ne peuvent pas tenir des secrets en toute sécurité.',
    'profile_personal_access_token_explanation' => 'Voici votre nouveau jeton d’accès personnel. Ceci est la seule fois où vous pourrez le voir, ne le perdez pas ! Vous pouvez dès à présent utiliser ce jeton pour lancer des requêtes avec l’API.',
    'profile_no_personal_access_token'          => 'Vous n’avez pas encore créé de jeton d’accès personnel.',
    'profile_create_new_token'                  => 'Créer un nouveau jeton',
    'profile_create_token'                      => 'Créer un jeton',
    'profile_create'                            => 'Créer',
    'profile_save_changes'                      => 'Enregistrer les modifications',
    'profile_whoops'                            => 'Oups !',
    'profile_something_wrong'                   => 'Une erreur s\'est produite !',
    'profile_try_again'                         => 'Une erreur s’est produite. Merci d’essayer à nouveau.',
    'amounts'                                   => 'Montants',
    'multi_account_warning_unknown'             => 'Selon le type d\'opération que vous créez, le(s) compte(s) source et/ou de destination des séparations suivantes peuvent être remplacés par celui de la première séparation de l\'opération.',
    'multi_account_warning_withdrawal'          => 'Gardez en tête que le compte source des séparations suivantes peut être remplacé par celui de la première séparation de la dépense.',
    'multi_account_warning_deposit'             => 'Gardez en tête que le compte de destination des séparations suivantes peut être remplacé par celui de la première séparation du dépôt.',
    'multi_account_warning_transfer'            => 'Gardez en tête que les comptes source et de destination des séparations suivantes peuvent être remplacés par ceux de la première séparation du transfert.',


    // export data:
    'export_data_title'                         => 'Exporter des données depuis Firefly III',
    'export_data_menu'                          => 'Exporter des données',
    'export_data_bc'                            => 'Exporter des données depuis Firefly III',
    'export_data_main_title'                    => 'Exporter des données depuis Firefly III',
    'export_data_expl'                          => 'Ce lien vous permet d\'exporter toutes les opérations et métadonnées de Firefly III. Plus d\'informations dans l\'aide (icône (?) en haut à droite).',
    'export_data_all_transactions'              => 'Exporter toutes les opérations',
    'export_data_advanced_expl'                 => 'Si vous avez besoin d\'un type d\'exportation plus avancé ou plus spécifique, lisez l\'aide sur comment utiliser la commande <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Une pièce jointe|:count pièces jointes',
    'attachments'                               => 'Pièces jointes',
    'edit_attachment'                           => 'Modifier la pièce jointe ":name"',
    'update_attachment'                         => 'Mettre à jour la pièce jointe',
    'delete_attachment'                         => 'Supprimer la pièce jointe ":name"',
    'attachment_deleted'                        => 'Pièce jointe ":name" supprimée',
    'liabilities_deleted'                       => 'Passif ":name" supprimé',
    'attachment_updated'                        => 'Pièce jointe ":name" mise à jour',
    'upload_max_file_size'                      => 'Taille maximum du fichier : :size',
    'list_all_attachments'                      => 'Liste de toutes les pièces jointes',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Comme cette opération est rapprochée, vous ne pourrez pas modifier les comptes, ni le(s) montant(s) à moins de retirer l\'indicateur de réconciliation.',
    'is_reconciled'                             => 'Est rapproché',
    'title_expenses'                            => 'Dépenses',
    'title_withdrawal'                          => 'Dépenses',
    'title_revenue'                             => 'Recette / revenu',
    'title_deposit'                             => 'Recette / revenu',
    'title_transfer'                            => 'Transferts',
    'title_transfers'                           => 'Transferts',
    'submission_options'                        => 'Options de soumission',
    'apply_rules_checkbox'                      => 'Appliquer les règles',
    'fire_webhooks_checkbox'                    => 'Lancer les webhooks',
    'select_source_account'                     => 'Veuillez sélectionner ou saisir un nom de compte source valide',
    'select_dest_account'                       => 'Veuillez sélectionner ou saisir un nom de compte de destination valide',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Cette opération est déjà une dépense',
    'convert_is_already_type_Deposit'           => 'Cette opération est déjà un dépôt',
    'convert_is_already_type_Transfer'          => 'Cette opération est déjà un transfert',
    'convert_to_Withdrawal'                     => 'Convertir ":description" en dépense',
    'convert_to_Deposit'                        => 'Convertir ":description" en dépôt',
    'convert_to_Transfer'                       => 'Convertir ":description" en transfert',
    'convert_options_WithdrawalDeposit'         => 'Convertir un retrait en dépôt',
    'convert_options_WithdrawalTransfer'        => 'Convertir une dépense en transfert',
    'convert_options_DepositTransfer'           => 'Convertir un dépôt en transfert',
    'convert_options_DepositWithdrawal'         => 'Convertir un dépôt en dépense',
    'convert_options_TransferWithdrawal'        => 'Convertir un transfert en dépense',
    'convert_options_TransferDeposit'           => 'Convertir un transfert en dépôt',
    'convert_Withdrawal_to_deposit'             => 'Convertir cette dépense en dépôt',
    'convert_Withdrawal_to_transfer'            => 'Convertir cette dépense en transfert',
    'convert_Deposit_to_withdrawal'             => 'Convertir ce dépôt en dépense',
    'convert_Deposit_to_transfer'               => 'Convertir ce dépôt en transfert',
    'convert_Transfer_to_deposit'               => 'Convertir ce transfert en dépôt',
    'convert_Transfer_to_withdrawal'            => 'Convertir ce transfert en dépense',
    'convert_please_set_revenue_source'         => 'Veuillez choisir le compte de recettes d\'où proviendra l’argent.',
    'convert_please_set_asset_destination'      => 'Veuillez choisir le compte d\'actifs sur lequel l\'argent sera versé.',
    'convert_please_set_expense_destination'    => 'Veuillez choisir le compte de dépenses sur lequel l\'argent sera versé.',
    'convert_please_set_asset_source'           => 'Veuillez choisir le compte d’actifs d\'où proviendra l’argent.',
    'convert_expl_w_d'                          => 'Lors de la conversion d\'une dépense en dépôt, l\'argent sera déposé dans le compte de destination affiché, au lieu d\'en être retiré.|Lors de la conversion d\'une dépense en dépôt, l\'argent sera déposé dans les comptes de destination affichés, au lieu de leur être retiré.',
    'convert_expl_w_t'                          => 'Lors de la conversion d\'une dépense en transfert, l\'argent sera transféré du compte source vers un autre compte d\'actif ou de passif au lieu d\'être dépensé sur le comptes de dépenses originaux.|Lors de la conversion d\'une dépense en transfert, l\'argent sera transféré des comptes source vers d\'autres comptes d\'actif ou de passif au lieu d\'être dépensé sur les comptes de dépenses originaux.',
    'convert_expl_d_w'                          => 'Lors de la conversion d\'un dépôt en dépense, l\'argent sera retiré du compte source affiché, au lieu d\'y être déposé.|Lors de la conversion d\'un dépôt en dépense, l\'argent sera retiré des comptes source affichés, au lieu d\'y être déposé.',
    'convert_expl_d_t'                          => 'Lorsque vous convertissez un dépôt en transfert, l\'argent sera déposé dans le compte de destination affiché à partir de l\'un de vos comptes d\'actif ou passif.|Lorsque vous convertissez un dépôt en transfert, l\'argent sera déposé dans les comptes de destination affichés à partir de l\'un de vos comptes d\'actif ou passif.',
    'convert_expl_t_w'                          => 'Lorsque vous convertissez un transfert en dépense, l\'argent sera dépensé sur le compte de destination que vous avez défini ici, au lieu d\'être transféré.|Lorsque vous convertissez un transfert en dépense, l\'argent sera dépensé sur les comptes de destination que vous avez définis ici, au lieu d\'être transféré.',
    'convert_expl_t_d'                          => 'Lorsque vous convertissez un transfert en dépôt, l\'argent sera déposé dans le compte de destination que vous voyez ici, au lieu de lui être transféré.|Lorsque vous convertissez un transfert en dépôt, l\'argent sera déposé dans les comptes de destination que vous voyez ici, au lieu de leur être transféré.',
    'convert_select_sources'                    => 'Veuillez sélectionner le nouveau compte source pour terminer la conversion.| Veuillez sélectionner les nouveaux comptes source pour terminer la conversion.',
    'convert_select_destinations'               => 'Veuillez sélectionner le nouveau compte de destination pour terminer la conversion.|Veuillez sélectionner les nouveaux comptes de destination pour terminer la conversion.',
    'converted_to_Withdrawal'                   => 'L\'opération a été convertie en dépense',
    'converted_to_Deposit'                      => 'L\'opération a été convertie en dépôt',
    'converted_to_Transfer'                     => 'L\'opération a été convertie en transfert',
    'invalid_convert_selection'                 => 'Le compte que vous avez sélectionné est déjà utilisé dans cette opération ou n\'existe pas.',
    'source_or_dest_invalid'                    => 'Impossible de trouver les détails d\'opération corrects. La conversion n\'est pas possible.',
    'convert_to_withdrawal'                     => 'Convertir en dépense',
    'convert_to_deposit'                        => 'Convertir en dépôt',
    'convert_to_transfer'                       => 'Convertir en transfert',

    // create new stuff:
    'create_new_withdrawal'                     => 'Créer une nouvelle dépense',
    'create_new_deposit'                        => 'Créer un nouveau dépôt',
    'create_new_transfer'                       => 'Créer un nouveau transfert',
    'create_new_asset'                          => 'Créer un nouveau compte d’actif',
    'create_new_liabilities'                    => 'Créer un nouveau passif',
    'create_new_expense'                        => 'Créer nouveau compte de dépenses',
    'create_new_revenue'                        => 'Créer nouveau compte de recettes',
    'create_new_piggy_bank'                     => 'Créer une nouvelle tirelire',
    'create_new_bill'                           => 'Créer un nouvel abonnement',
    'create_new_subscription'                   => 'Créer un nouvel abonnement',
    'create_new_rule'                           => 'Créer une nouvelle règle',

    // currencies:
    'create_currency'                           => 'Créer une nouvelle devise',
    'store_currency'                            => 'Créer une nouvelle devise',
    'update_currency'                           => 'Mise à jour de la devise',
    'new_default_currency'                      => '«:name» est maintenant la devise par défaut.',
    'default_currency_failed'                   => 'Impossible de faire de modifier la devise par défaut à «:name». Veuillez vérifier les logs.',
    'cannot_delete_currency'                    => 'Impossible de supprimer :name car il est encore utilisé.',
    'cannot_delete_fallback_currency'           => ':name est la devise par défaut du système et ne peut pas être supprimée.',
    'cannot_disable_currency_journals'          => 'Impossible de désactiver la devise :name car les opérations l\'utilisent toujours.',
    'cannot_disable_currency_last_left'         => 'Impossible de désactiver la devise :name car c\'est la dernière activée.',
    'cannot_disable_currency_account_meta'      => 'Impossible de désactiver la devise :name car elle est utilisée dans les comptes d\'actifs.',
    'cannot_disable_currency_bills'             => 'Impossible de désactiver :name car lié à des abonnements.',
    'cannot_disable_currency_recurring'         => 'Impossible de désactiver la devise :name car elle est utilisée dans les opérations périodiques.',
    'cannot_disable_currency_available_budgets' => 'Impossible de désactiver la devise :name car elle est utilisée dans les budgets existants.',
    'cannot_disable_currency_budget_limits'     => 'Impossible de désactiver la devise :name car elle est utilisée dans les limites des budgets.',
    'cannot_disable_currency_current_default'   => 'Impossible de désactiver la devise :name car elle est définie comme devise par défaut.',
    'cannot_disable_currency_system_fallback'   => 'Impossible de désactiver la devise :name car elle est définie comme devise par défaut du système.',
    'disable_EUR_side_effects'                  => 'L\'Euro est la devise de secours utilisée par le système. La désactiver peut provoquer des effets indésirables et peut annuler votre garantie.',
    'deleted_currency'                          => 'Devise ":name" supprimée',
    'created_currency'                          => 'Devise ":name" créée',
    'could_not_store_currency'                  => 'Impossible d\'enregistrer la nouvelle devise.',
    'updated_currency'                          => 'Devise ":name" mise à jour',
    'ask_site_owner'                            => 'Merci de demander à :owner pour ajouter, modifier ou supprimer des devises.',
    'currencies_intro'                          => 'Firefly III prend en charge diverses devises que vous pouvez configurer et activer ici.',
    'currencies_switch_default'                 => 'Vous pouvez changer la devise principale de votre administration actuelle sur la page "Administration financière".',
    'make_default_currency'                     => 'Utiliser par défaut',
    'default_currency'                          => 'par défaut',
    'primary_currency_button'                   => 'principale',
    'currency_is_disabled'                      => 'Désactivé',
    'enable_currency'                           => 'Activer',
    'disable_currency'                          => 'Désactiver',
    'currencies_default_disabled'               => 'La plupart de ces devises sont désactivées par défaut. Vous devez d\'abord les activer pour pouvoir les utiliser.',
    'currency_is_now_enabled'                   => 'La devise ":name" a été activée',
    'could_not_enable_currency'                 => 'Impossible d\'activer la devise ":name". Veuillez consulter les logs.',
    'currency_is_now_disabled'                  => 'La devise ":name" a été désactivée',
    'could_not_disable_currency'                => 'Impossible de désactiver la devise «:name». Peut-être est-elle encore utilisée ?',

    // forms:
    'mandatoryFields'                           => 'Champs obligatoires',
    'optionalFields'                            => 'Champs optionnels',
    'options'                                   => 'Options',

    // budgets:
    'daily_budgets'                             => 'Budgets quotidiens',
    'weekly_budgets'                            => 'Budgets hebdomadaires',
    'monthly_budgets'                           => 'Budgets mensuels',
    'quarterly_budgets'                         => 'Budgets trimestriels',
    'half_year_budgets'                         => 'Budgets semestriels',
    'yearly_budgets'                            => 'Budgets annuels',
    'other_budgets'                             => 'Budgets à période personnalisée',
    'budget_limit_not_in_range'                 => 'Ce montant s\'applique du :start au :end :',
    'total_available_budget'                    => 'Budget total disponible (entre :start et :end)',
    'total_available_budget_in_currency'        => 'Budget total disponible en :currency',
    'see_below'                                 => 'voir ci-dessous',
    'create_new_budget'                         => 'Créer un nouveau budget',
    'store_new_budget'                          => 'Créer un nouveau budget',
    'stored_new_budget'                         => 'Nouveau budget ":name" créé',
    'available_between'                         => 'Disponible entre le :start et le :end',
    'transactionsWithoutBudget'                 => 'Dépenses non budgétisées',
    'transactions_no_budget'                    => 'Dépenses non budgétisées entre le :start et le :end',
    'spent_between'                             => 'Déjà dépensé entre le :start et le :end',
    'spent_between_left'                        => ':spent dépensé du :start au :end, :left restant.',
    'set_available_amount'                      => 'Définir le montant disponible',
    'update_available_amount'                   => 'Mettre à jour le montant disponible',
    'ab_basic_modal_explain'                    => 'Utilisez ce formulaire pour indiquer combien vous vous attendez à pouvoir budgéter (au total, en :currency) dans la période indiquée.',
    'createBudget'                              => 'Nouveau budget',
    'invalid_currency'                          => 'Ceci est une devise invalide',
    'invalid_amount'                            => 'Veuillez saisir un montant',
    'set_ab'                                    => 'Le montant du budget disponible a été fixé',
    'updated_ab'                                => 'Le montant du budget disponible a été mis à jour',
    'deleted_ab'                                => 'Le montant du budget disponible a été supprimé',
    'deleted_bl'                                => 'Le montant budgétisé a été supprimé',
    'alt_currency_ab_create'                    => 'Définir le budget disponible dans une autre devise',
    'bl_create_btn'                             => 'Définir le budget dans une autre devise',
    'inactiveBudgets'                           => 'Budgets inactifs',
    'without_budget_between'                    => 'Opérations non budgétisées entre le :start et le :end',
    'delete_budget'                             => 'Supprimer le budget ":name"',
    'deleted_budget'                            => 'Budget ":name" supprimé',
    'edit_budget'                               => 'Modifier le budget ":name"',
    'updated_budget'                            => 'Budget ":name" mis à jour',
    'update_amount'                             => 'Mettre à jour le montant',
    'update_budget'                             => 'Mettre à jour le budget',
    'update_budget_amount_range'                => 'Mettre à jour le montant disponible (prévu) entre le :start et le :end',
    'set_budget_limit_title'                    => 'Définir le montant budgétisé pour le budget :budget entre le :start et le :end',
    'set_budget_limit'                          => 'Définir le montant budgétisé',
    'budget_period_navigator'                   => 'Navigateur de période',
    'info_on_available_amount'                  => 'Qu\'est-ce que j\'ai de disponible ?',
    'available_amount_indication'               => 'Utilisez ces montants pour avoir une indication de ce que pourrait être votre budget total.',
    'suggested'                                 => 'Suggéré',
    'average_between'                           => 'Moyenne entre :start et :end',
    'transferred_in'                            => 'Transféré (entrant)',
    'transferred_away'                          => 'Transféré (sortant)',
    'auto_budget_none'                          => 'Pas de budget automatique',
    'auto_budget_reset'                         => 'Définir un montant fixe à chaque période',
    'auto_budget_rollover'                      => 'Ajouter un montant à chaque période',
    'auto_budget_adjusted'                      => 'Ajouter un montant à chaque période et rectifier en fonction des dépenses excessives',
    'auto_budget_period_daily'                  => 'Quotidien',
    'auto_budget_period_weekly'                 => 'Hebdomadaire',
    'auto_budget_period_monthly'                => 'Mensuel',
    'auto_budget_period_quarterly'              => 'Trimestriel',
    'auto_budget_period_half_year'              => 'Semestriel',
    'auto_budget_period_yearly'                 => 'Annuel',
    'auto_budget_help'                          => 'Vous pouvez en savoir plus sur cette fonctionnalité dans l\'aide. Cliquez sur l\'icône (?) en haut à droite.',
    'auto_budget_reset_icon'                    => 'Ce budget sera défini périodiquement',
    'auto_budget_rollover_icon'                 => 'Le montant du budget augmentera périodiquement',
    'auto_budget_adjusted_icon'                 => 'Le montant du budget augmentera périodiquement et corrigera les dépassements de budget',
    'remove_budgeted_amount'                    => 'Supprimer le montant budgétisé en :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'les abonnements actifs, attendus et pas encore payés',
    'left_to_pay_lc'                            => 'restant à payer',
    'less_than_expected'                        => 'moins qu\'attendu',
    'more_than_expected'                        => 'plus qu\'attendu',
    'skip_help_text'                            => 'Utilisez le champ "ignorer" pour créer des intervalles bimensuels ("ignorer" = 1) ou d\'autres intervalles personnalisés.',
    'subscription'                              => 'Abonnement',
    'not_expected_period'                       => 'Pas attendu cette période',
    'subscriptions_in_group'                    => 'Abonnements dans le groupe "{{title}}"',
    'subscr_expected_x_times'                   => '{{amount}} à payer {{times}} fois cette période',
    'not_or_not_yet'                            => 'Non (pas encore)',
    'visit_bill'                                => 'Consultez l\'abonnement ":name" sur Firefly III',
    'visit_bills'                               => 'Consulter les abonnements sur Firefly III',
    'match_between_amounts'                     => 'L\'abonnement correspond aux transactions entre :low et :high.',
    'running_again_loss'                        => 'Les transactions précédemment liées à cet abonnement peuvent perdre leur connexion, si elles ne correspondent plus à la ou aux règles.',
    'bill_related_rules'                        => 'Règles relatives à cet abonnement',
    'repeats'                                   => 'Répétitions',
    'bill_end_date_help'                        => 'Champ facultatif. L\'abonnement est censé prendre fin à cette date.',
    'bill_extension_date_help'                  => 'Champ facultatif. L\'abonnement doit être prolongé (ou annulé) au plus tard à cette date.',
    'bill_end_index_line'                       => 'Cet abonnement prend fin le :date',
    'bill_extension_index_line'                 => 'Cet abonnement doit être prolongé ou annulé en date du :date',
    'connected_journals'                        => 'Opérations liées',
    'auto_match_on'                             => 'Automatiquement mis en correspondance par Firefly III',
    'auto_match_off'                            => 'Pas mis automatiquement en correspondance par Firefly III',
    'next_expected_match'                       => 'Prochain montant attendu',
    'delete_bill'                               => 'Supprimer l’abonnement ":name"',
    'deleted_bill'                              => 'Abonnement supprimé «:name»',
    'edit_bill'                                 => 'Modifier l’abonnement ":name"',
    'more'                                      => 'Plus',
    'rescan_old'                                => 'Exécuter les règles à nouveau, sur toutes les opérations',
    'update_bill'                               => 'Mettre à jour l’abonnement',
    'updated_bill'                              => 'Abonnement ":name " mis à jour',
    'store_new_bill'                            => 'Enregistrer le nouvel abonnement',
    'stored_new_bill'                           => 'Nouvel abonnement ":name " enregistré',
    'cannot_scan_inactive_bill'                 => 'Les abonnements inactifs ne peuvent pas être scannés.',
    'rescanned_bill'                            => 'Tout a été re-scanné et :count opération(s) a(ont) été liée à l\'abonnement.',
    'average_bill_amount_year'                  => 'Montant moyen de l\'abonnement (:year)',
    'average_bill_amount_overall'               => 'Montant moyen de l\'abonnement (global)',
    'bill_is_active'                            => 'L\'abonnement est actif',
    'bill_expected_between'                     => 'Attendu entre le :start et le :end',
    'bill_will_automatch'                       => 'L\'abonnement sera automatiquement lié aux transactions correspondantes',
    'skips_over'                                => 'saute',
    'bill_store_error'                          => 'Une erreur inattendue s\'est produite lors de l\'enregistrement de votre nouvel abonnement. Veuillez vérifier les fichiers journaux',
    'list_inactive_rule'                        => 'règle inactive',
    'bill_edit_rules'                           => 'Firefly III tentera également de modifier la règle relative à cet abonnement. Si vous avez modifié cette règle vous-même, Firefly III ne changera rien. Firefly III tentera également de modifier les :count règles relatives à cet abonnement. Si vous avez modifié ces règles vous-même, Firefly III ne changera rien.',
    'bill_expected_date'                        => 'Prévu :date',
    'bill_expected_date_js'                     => 'Attendu le {date}',
    'expected_amount'                           => 'Montant (attendu)',
    'bill_paid_on'                              => 'Payé le {date}',
    'bill_repeats_weekly'                       => 'Se répète toutes les semaines',
    'bill_repeats_monthly'                      => 'Se répète tous les mois',
    'bill_repeats_quarterly'                    => 'Se répète tous les trimestres',
    'bill_repeats_half-year'                    => 'Se répète tous les semestres',
    'bill_repeats_yearly'                       => 'Se répète tous les ans',
    'bill_repeats_weekly_other'                 => 'Se répète toutes les deux semaines',
    'bill_repeats_monthly_other'                => 'Se répète tous les deux mois',
    'bill_repeats_quarterly_other'              => 'Se répète tous les deux trimestres',
    'bill_repeats_half-year_other'              => 'Se répète tous les ans',
    'bill_repeats_yearly_other'                 => 'Se répète tous les deux ans',
    'bill_repeats_weekly_skip'                  => 'Se répète toutes les {skip} semaines',
    'bill_repeats_monthly_skip'                 => 'Se répète tous les {skip} mois',
    'bill_repeats_quarterly_skip'               => 'Se répète tous les {skip} trimestres',
    'bill_repeats_half-year_skip'               => 'Se répète tous les {skip} semestres',
    'bill_repeats_yearly_skip'                  => 'Se répète tous les {skip} ans',
    'subscriptions'                             => 'Abonnements',
    'go_to_subscriptions'                       => 'Accédez à vos abonnements',
    'forever'                                   => 'Pour toujours',
    'extension_date_is'                         => 'La date de l\'extension est {date}',

    // accounts:
    'account_locked_currency'                   => 'La devise de ce compte doit rester :name tant que des tirelires y sont liées.',
    'i_am_owed_amount'                          => 'On me doit le montant',
    'i_owe_amount'                              => 'Je dois le montant',
    'inactive_account_link'                     => 'Vous avez :count compte inactif (archivé) que vous pouvez consulter sur cette page dédiée.| Vous avez :count comptes inactifs (archivés) que vous pouvez consulter sur cette page dédiée.',
    'all_accounts_inactive'                     => 'Voici vos comptes inactifs.',
    'active_account_link'                       => 'Ce lien renvoie à vos comptes actifs.',
    'account_missing_transaction'               => 'Le compte #:id (":name") ne peut pas être consulté directement et Firefly ne dispose d\'aucune information pour vous rediriger.',
    'cc_monthly_payment_date_help'              => 'Sélectionnez n\'importe quelle année et n\'importe quel mois, il sera ignoré de toute façon. Seul le jour du mois est pertinent.',
    'details_for_asset'                         => 'Détails pour le compte d’actif ":name"',
    'details_for_expense'                       => 'Détails du compte de dépenses ":name"',
    'details_for_revenue'                       => 'Détails du comptes de recettes ":name"',
    'details_for_cash'                          => 'Détails pour le compte de trésorerie ":name"',
    'store_new_asset_account'                   => 'Créer un nouveau compte d’actif',
    'store_new_expense_account'                 => 'Créer un nouveau compte de dépenses',
    'store_new_revenue_account'                 => 'Créer un compte de recettes',
    'edit_asset_account'                        => 'Modifier le compte d’actif ":name"',
    'edit_expense_account'                      => 'Modifier le compte de dépenses ";name"',
    'edit_revenue_account'                      => 'Modifier le compte de recettes ":name"',
    'delete_asset_account'                      => 'Supprimer le compte d’actif ":name"',
    'delete_expense_account'                    => 'Supprimer le compte de dépenses ":name"',
    'delete_revenue_account'                    => 'Supprimer le compte de recettes ":name"',
    'delete_liabilities_account'                => 'Supprimer le passif ":name"',
    'asset_deleted'                             => 'Compte d’actif ":name" correctement supprimé',
    'account_deleted'                           => 'Compte ":name" supprimé avec succès',
    'expense_deleted'                           => 'Compte de dépenses ":name" correctement supprimé',
    'revenue_deleted'                           => 'Compte de recettes ":name" correctement supprimé',
    'update_asset_account'                      => 'Mettre à jour le compte d’actif',
    'update_undefined_account'                  => 'Mettre à jour le compte',
    'update_liabilities_account'                => 'Mettre à jour le passif',
    'update_expense_account'                    => 'Mettre à jour le compte de dépenses',
    'update_revenue_account'                    => 'Mettre à jour le compte de recettes',
    'make_new_asset_account'                    => 'Créer un nouveau compte d’actif',
    'make_new_expense_account'                  => 'Créer un nouveau compte de dépenses',
    'make_new_revenue_account'                  => 'Créer un nouveau compte de recettes',
    'make_new_liabilities_account'              => 'Créer un nouveau passif',
    'asset_accounts'                            => 'Comptes d’actif',
    'undefined_accounts'                        => 'Comptes',
    'asset_accounts_inactive'                   => 'Comptes d\'actifs (inactif)',
    'expense_account'                           => 'Compte de dépenses',
    'expense_accounts'                          => 'Comptes de dépenses',
    'expense_accounts_inactive'                 => 'Comptes de dépenses (inactif)',
    'revenue_account'                           => 'Compte de recettes',
    'revenue_accounts'                          => 'Comptes de recettes',
    'revenue_accounts_inactive'                 => 'Comptes de recette (inactifs)',
    'cash_accounts'                             => 'Comptes de trésorerie',
    'Cash account'                              => 'Compte de trésorerie',
    'liabilities_accounts'                      => 'Passifs',
    'liabilities_accounts_inactive'             => 'Passifs (inactifs)',
    'reconcile_account'                         => 'Rapprocher le compte ":account"',
    'overview_of_reconcile_modal'               => 'Vue d’ensemble du rapprochement',
    'delete_reconciliation'                     => 'Supprimer le rapprochement',
    'update_reconciliation'                     => 'Mettre à jour le rapprochement',
    'amount_cannot_be_zero'                     => 'Le montant ne peut pas être zéro',
    'end_of_reconcile_period'                   => 'Fin de la période de rapptrochement : :period',
    'start_of_reconcile_period'                 => 'Début de la période de rapprochement : :period',
    'start_balance'                             => 'Solde initial',
    'end_balance'                               => 'Solde de clôture',
    'update_balance_dates_instruction'          => 'Faites correspondre les montants et les dates ci-dessus à votre relevé bancaire et appuyez sur "Commencer le rapprochement"',
    'select_transactions_instruction'           => 'Sélectionnez les opérations qui apparaissent sur votre relevé bancaire.',
    'select_range_and_balance'                  => 'Vérifiez d\'abord l\'intervalle de dates et les soldes. Puis appuyez sur "Commencer le rapprochement"',
    'date_change_instruction'                   => 'Si vous modifiez l\'intervalle de dates maintenant, toute progression sera perdue.',
    'update_selection'                          => 'Mettre à jour la sélection',
    'store_reconcile'                           => 'Stocker le rapprochement',
    'reconciliation_transaction'                => 'Opération de régularisation',
    'Reconciliation'                            => 'Rapprochement',
    'reconciliation'                            => 'Rapprochement',
    'reconcile_options'                         => 'Options de rapprochement',
    'reconcile_range'                           => 'Intervalle de rapprochement',
    'start_reconcile'                           => 'Commencer le rapprochement',
    'cash_account_type'                         => 'Espèces',
    'cash'                                      => 'espèces',
    'cant_find_redirect_account'                => 'Firefly III a essayé de vous rediriger mais n\'a pas pu. Désolé. Retour à l\'index.',
    'account_type'                              => 'Type de compte',
    'save_transactions_by_moving'               => 'Conserver cette opération en la déplaçant vers un autre compte :|Conserver ces opérations en les déplaçant vers un autre compte :',
    'save_transactions_by_moving_js'            => 'Aucune opération|Conserver cette opération en la déplaçant vers un autre compte. |Conserver ces opérations en les déplaçant vers un autre compte.',
    'stored_new_account'                        => 'Nouveau compte ":name" créé !',
    'stored_new_account_js'                     => 'Nouveau compte "<a href="accounts/show/{ID}">{name}</a>" enregistré !',
    'updated_account'                           => 'Compte ":name" mis à jour',
    'updated_account_js'                        => 'Compte "<a href="accounts/show/{ID}">{title}</a>" mis à jour.',
    'credit_card_options'                       => 'Cartes de crédit',
    'no_transactions_account'                   => 'Il n\'y a pas d\'opération (sur cette période) pour le compte d\'actif ":name".',
    'no_transactions_period'                    => 'Il n\'y a aucune opération (sur cette période).',
    'no_data_for_chart'                         => 'Il n\'y a pas assez d\'informations (pour le moment) pour générer ce graphique.',
    'select_at_least_one_account'               => 'Merci de sélectionner au moins un compte d\'actif',
    'select_at_least_one_category'              => 'Merci de sélectionner au moins une catégorie',
    'select_at_least_one_budget'                => 'Merci de sélectionner au moins un budget',
    'select_at_least_one_tag'                   => 'Merci de sélectionner au moins un tag',
    'select_at_least_one_expense'               => 'Merci de sélectionner au moins une combinaison de comptes de dépense/revenu. Si vous n\'en avez aucun (la liste est vide) ce rapport n\'est pas utilisable.',
    'account_default_currency'                  => 'Ce sera la devise par défaut associée à ce compte.',
    'piggy_default_currency'                    => 'Les tirelires ne peuvent être épargnées que dans une seule devise.',
    'piggy_account_currency_match'              => 'Seuls les comptes qui utilisent la devise sélectionnée précédemment seront acceptés.',
    'reconcile_has_more'                        => 'Votre registre Firefly III a plus d\'argent que ce que votre banque prétend que vous devriez avoir. Veuillez choisir comment gérer la situation parmi les différentes possibilités offertes. Ensuite, appuyez sur "Confirmer le rapprochement".',
    'reconcile_has_less'                        => 'Votre registre Firefly III a moins d\'argent que ce que votre banque prétend que vous devriez avoir. Veuillez choisir comment gérer la situation parmi les différentes possibilités offertes. Ensuite, appuyez sur "Confirmer le rapprochement".',
    'reconcile_is_equal'                        => 'Votre registre Firefly III et vos relevés bancaires correspondent. Il n\'y a rien à faire. Appuyez sur "Confirmer le rapprochement" pour confirmer votre entrée.',
    'create_pos_reconcile_transaction'          => 'Pointer les opérations sélectionnées et créer une correction en ajoutant :amount à ce compte d\'actif.',
    'create_neg_reconcile_transaction'          => 'Pointer les opérations sélectionnées et créer une correction en enlevant :amount à ce compte d\'actif.',
    'reconcile_do_nothing'                      => 'Pointer les opérations sélectionnées, sans effectuer de correction.',
    'reconcile_go_back'                         => 'Vous pouvez toujours modifier ou supprimer une correction ultérieurement.',
    'must_be_asset_account'                     => 'Vous pouvez uniquement rapprocher les comptes d\'actifs',
    'reconciliation_stored'                     => 'Rapprochement enregistré',
    'reconciliation_error'                      => 'En raison d\'une erreur, les opérations ont été marquées comme rapprochées, mais la correction n\'a pas été enregistrée : :error.',
    'reconciliation_transaction_title'          => 'Régularisation (du :from au :to)',
    'sum_of_reconciliation'                     => 'Total des rapprochements',
    'reconcile_this_account'                    => 'Rapprocher ce compte',
    'reconcile'                                 => 'Rapprocher',
    'show'                                      => 'Afficher',
    'confirm_reconciliation'                    => 'Confirmer le rapprochement',
    'submitted_start_balance'                   => 'Solde initial soumis',
    'selected_transactions'                     => 'Opérations sélectionnées ( :count)',
    'already_cleared_transactions'              => 'Opérations déjà pointées ( :count)',
    'submitted_end_balance'                     => 'Solde final soumis',
    'initial_balance_description'               => 'Balance initiale pour ":account"',
    'liability_credit_description'              => 'Passif de crédit pour ":account"',
    'interest_calc_'                            => 'inconnu',
    'interest_calc_daily'                       => 'Par jour',
    'interest_calc_monthly'                     => 'Par mois',
    'interest_calc_yearly'                      => 'Par an',
    'interest_calc_weekly'                      => 'Par semaine',
    'interest_calc_half-year'                   => 'Par semestre',
    'interest_calc_quarterly'                   => 'Par trimestre',
    'initial_balance_account'                   => 'Solde initial du compte :account',
    'list_options'                              => 'Lister les options',
    'account_column_opt_drag_and_drop'          => 'Glisser et déposer',
    'account_column_opt_active'                 => 'Actif',
    'account_column_opt_name'                   => 'Nom',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Type de passif',
    'account_column_opt_liability_direction'    => 'Sens du passif',
    'account_column_opt_liability_interest'     => 'Intérêt du passif',
    'account_column_opt_number'                 => 'Numéro de compte',
    'account_column_opt_current_balance'        => 'Solde actuel',
    'account_column_opt_amount_due'             => 'Montant dû',
    'account_column_opt_last_activity'          => 'Activité récente',
    'account_column_opt_balance_difference'     => 'Différence de solde',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nouvelle catégorie',
    'create_new_category'                       => 'Créer une nouvelle catégorie',
    'without_category'                          => 'Sans catégorie',
    'update_category'                           => 'Modifier la catégorie',
    'updated_category'                          => 'Catégorie ":name" mise à jour',
    'categories'                                => 'Catégories',
    'edit_category'                             => 'Modifier la catégorie ":name"',
    'no_category'                               => '(aucune catégorie)',
    'unknown_category_plain'                    => 'Sans catégorie',
    'category'                                  => 'Catégorie',
    'delete_category'                           => 'Supprimer la catégorie ":name"',
    'deleted_category'                          => 'Catégorie ":name" supprimée',
    'store_category'                            => 'Créer une nouvelle catégorie',
    'stored_category'                           => 'Nouvelle catégorie stockée ":name"',
    'without_category_between'                  => 'Sans catégorie entre :start et :end',


    // transactions:
    'wait_loading_transaction'                  => 'Veuillez patienter pendant le chargement du formulaire',
    'wait_loading_data'                         => 'Veuillez attendre que vos informations soient chargées...',
    'wait_attachments'                          => 'Veuillez patienter pendant le chargement des pièces jointes.',
    'errors_upload'                             => 'L\'envoi a échoué. Veuillez consulter l\'erreur dans votre console de navigateur.',
    'amount_foreign_if'                         => 'Montant en devise étrangère, le cas échéant',
    'amount_destination_account'                => 'Montant dans la devise du compte de destination',
    'edit_transaction_title'                    => 'Modifier l\'opération ":description"',
    'unreconcile'                               => 'Annuler le rapprochement',
    'update_withdrawal'                         => 'Mettre à jour une dépense',
    'update_deposit'                            => 'Mettre à jour un dépôt',
    'update_transaction'                        => 'Mettre à jour l\'opération',
    'update_transfer'                           => 'Mettre à jour un transfert',
    'updated_withdrawal'                        => 'Dépense ":description" mise à jour',
    'updated_deposit'                           => 'Dépôt ":description" mis à jour',
    'updated_transfer'                          => 'Transfert ":description" mis à jour',
    'no_changes_withdrawal'                     => 'Le retrait ":description" n\'a pas été modifié.',
    'no_changes_deposit'                        => 'Le dépôt ":description" n\'a pas été modifié.',
    'no_changes_transfer'                       => 'Le transfert ":description" n\'a pas été changé.',
    'delete_withdrawal'                         => 'Supprimer la dépense ":description"',
    'delete_deposit'                            => 'Supprimer le dépôt ":description"',
    'delete_transfer'                           => 'Supprimer le transfert ":description"',
    'deleted_withdrawal'                        => 'Dépense ":description" correctement supprimée',
    'deleted_deposit'                           => 'Dépôt ":description" correctement supprimé',
    'deleted_transfer'                          => 'Opération ":description" correctement supprimée',
    'deleted_reconciliation'                    => 'Opération ":description" supprimée avec succès',
    'stored_journal'                            => 'Opération ":description" créée avec succès',
    'stored_journal_js'                         => 'Opération "{{description}}" créée avec succès',
    'stored_journal_no_descr'                   => 'Nouvelle opération créée avec succès',
    'updated_journal_no_descr'                  => 'Votre opération a été mise à jour avec succès',
    'select_transactions'                       => 'Sélectionner des opérations',
    'rule_group_select_transactions'            => 'Appliquer le groupe de règles ":title" sur les opérations',
    'rule_select_transactions'                  => 'Appliquer la règle ":title" sur les opérations',
    'stop_selection'                            => 'Arrêter de sélectionner les opérations',
    'reconcile_selected'                        => 'Rapprocher',
    'mass_delete_journals'                      => 'Supprimer un certain nombre de opérations',
    'mass_edit_journals'                        => 'Modifier un certain nombre d’opérations',
    'mass_bulk_journals'                        => 'Modifier un certain nombre d’opérations en masse',
    'mass_bulk_journals_explain'                => 'Ce formulaire vous permet de modifier les propriétés des opérations listées ci-dessous d\'un coup. Toutes les opérations dans le tableau seront mises à jour lorsque vous changerez les paramètres que vous voyez ici.',
    'part_of_split'                             => 'Cette opération fait partie d\'une opération scindée. Si vous n\'avez pas sélectionné toutes les parties, vous risquez de n\'impacter que la moitié de l\'opération.',
    'bulk_set_new_values'                       => 'Utilisez les entrées ci-dessous pour définir de nouvelles valeurs. Si vous les laissez vides, ils seront vides pour tous. Notez également que seuls les dépenses recevront un budget.',
    'no_bulk_category'                          => 'Ne pas mettre à jour la catégorie',
    'no_bulk_budget'                            => 'Ne pas mettre à jour le budget',
    'no_bulk_tags'                              => 'Ne pas mettre à jour le·s tag·s',
    'replace_with_these_tags'                   => 'Remplacer par ces tags',
    'append_these_tags'                         => 'Ajouter ces tags',
    'mass_edit'                                 => 'Modifier la sélection individuellement',
    'bulk_edit'                                 => 'Modifier la sélection en masse',
    'mass_delete'                               => 'Supprimer la sélection',
    'cannot_edit_other_fields'                  => 'Vous ne pouvez pas modifier en masse d\'autres champs que ceux-ci, car il n’y a pas de place pour tous les afficher. S’il vous plaît suivez le lien et modifiez les un par un si vous devez modifier ces champs.',
    'cannot_change_amount_reconciled'           => 'Vous ne pouvez pas modifier le montant ou le(s) compte(s) des opérations rapprochées.',
    'no_budget'                                 => '(pas de budget)',
    'no_bill'                                   => '(aucun abonnement)',
    'account_per_budget'                        => 'Compte par budget',
    'account_per_category'                      => 'Compte par catégorie',
    'create_new_object'                         => 'Créer',
    'empty'                                     => '(vide)',
    'all_other_budgets'                         => '(tous les autres budgets)',
    'all_other_accounts'                        => '(tous les autres comptes)',
    'expense_per_source_account'                => 'Dépenses par compte source',
    'expense_per_destination_account'           => 'Dépenses par compte de destination',
    'income_per_destination_account'            => 'Revenu par compte de destination',
    'spent_in_specific_category'                => 'Dépense dans la catégorie ":category"',
    'earned_in_specific_category'               => 'Gagné dans la catégorie ":category"',
    'spent_in_specific_tag'                     => 'Dépenser dans le mot-clé ":tag"',
    'earned_in_specific_tag'                    => 'Gagné dans le mot-clé ":tag"',
    'income_per_source_account'                 => 'Revenu par compte source',
    'average_spending_per_destination'          => 'Dépense moyenne par compte de destination',
    'average_spending_per_source'               => 'Dépense moyenne par compte source',
    'average_earning_per_source'                => 'Revenu moyen par compte source',
    'average_earning_per_destination'           => 'Revenu moyen par compte de destination',
    'account_per_tag'                           => 'Compte par mot-clé',
    'tag_report_expenses_listed_once'           => 'Les dépenses et les revenus ne sont jamais listés deux fois. Si une opération a plusieurs mots-clés, elle ne peut apparaître que sous l\'un de ses mots-clés. Cette liste peut sembler manquer de données, mais les montants seront corrects.',
    'double_report_expenses_charted_once'       => 'Les dépenses et les revenus ne sont jamais affichés deux fois. Si une opération a plusieurs mots-clés, elle ne peut apparaître que sous l\'un de ses mots-clés. Ce graphique peut sembler manquer de données, mais les montants seront corrects.',
    'tag_report_chart_single_tag'               => 'Ce graphique s\'applique à un seul mot-clé. Si une opération a plusieurs mots-clés, ce que vous voyez ici peut également être reflété dans les graphiques d\'autres mots-clés.',
    'tag'                                       => 'Mot-clé',
    'no_budget_squared'                         => '(pas de budget)',
    'perm-delete-many'                          => 'Supprimer beaucoup d\'éléments d\'un coup peut être très perturbateur. Soyez prudent. Vous pouvez supprimer une partie d\'une opération scindée à partir de cette page, alors faites attention.',
    'mass_deleted_transactions_success'         => ':count opération supprimée.|:count opérations supprimées.',
    'mass_edited_transactions_success'          => ':count opération mise à jour.|:count opérations mises à jour.',
    'opt_group_'                                => '(aucun type de compte)',
    'opt_group_no_account_type'                 => '(aucun type de compte)',
    'opt_group_defaultAsset'                    => 'Comptes d\'actifs par défaut',
    'opt_group_savingAsset'                     => 'Comptes d\'épargne',
    'opt_group_sharedAsset'                     => 'Comptes d\'actifs partagés',
    'opt_group_ccAsset'                         => 'Cartes de crédit',
    'opt_group_cashWalletAsset'                 => 'Porte-monnaie',
    'opt_group_expense_account'                 => 'Comptes de dépenses',
    'opt_group_revenue_account'                 => 'Comptes de recettes',
    'opt_group_l_Loan'                          => 'Passif: Prêt',
    'opt_group_cash_account'                    => 'Compte de trésorerie',
    'opt_group_l_Debt'                          => 'Passif: Dette',
    'opt_group_l_Mortgage'                      => 'Passif: Prêt hypothécaire',
    'opt_group_l_Credit card'                   => 'Passif: Carte de crédit',
    'notes'                                     => 'Notes',
    'view_notes'                                => 'Voir les notes',
    'set_budget_limit_notes'                    => 'Voir les notes pour ce montant budgétisé',
    'edit_bl_notes'                             => 'Modifier des notes',
    'update_bl_notes'                           => 'Mettre à jour les notes',
    'unknown_journal_error'                     => 'Impossible de stocker l\'opération. Veuillez vérifier les fichiers journaux.',
    'attachment_not_found'                      => 'Cette pièce jointe est introuvable.',
    'journal_link_bill'                         => 'Cette opération est liée à l\'abonnement <a href=":route">:name</a>. Pour supprimer la connexion, décochez la case à cocher. Utilisez les règles pour la connecter à un autre abonnement.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">L\'opération n°{ID} ("{title}")</a> a été enregistrée.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">L\'opération n°{ID}</a> a été enregistrée.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">L\'opération n°{ID}</a> ("{title}") a été mise à jour.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">L\'opération n°{ID}</a> ("{title}") n\'a pas été modifiée.',
    'first_split_decides'                       => 'La première séparation détermine la valeur de ce champ',
    'first_split_overrules_source'              => 'La première séparation peut remplacer le compte source',
    'first_split_overrules_destination'         => 'La première séparation peut remplacer le compte de destination',
    'spent_x_of_y'                              => 'Dépensé {amount} sur {total}',

    // new user:
    'welcome'                                   => 'Bienvenue sur Firefly III !',
    'submit'                                    => 'Soumettre',
    'submission'                                => 'Soumission',
    'submit_yes_really'                         => 'Soumettre (je sais ce que je fais)',
    'getting_started'                           => 'Mise en route',
    'to_get_started'                            => 'Vous venez d\'installer Firefly III avec succès. Pour commencer avec cet outil, entrez le nom de votre banque et le solde de votre compte courant principal. Ne vous inquiétez pas si vous avez plusieurs comptes. Vous pourrez les ajouter plus tard. Firefly III a simplement besoin de quelque chose pour commencer.',
    'savings_balance_text'                      => 'Firefly III créera automatiquement un compte d\'épargne pour vous. Par défaut, il n\'y aura pas d\'argent sur ce compte d\'épargne, mais si vous indiquez un montant à Firefly III, il l\'enregistrera en tant que solde.',
    'finish_up_new_user'                        => 'C\'est tout ! Vous pouvez continuer en appuyant sur <strong>Envoyer</strong>. Vous passerez à l\'index de Firefly III.',
    'stored_new_accounts_new_user'              => 'Super ! Vos nouveaux comptes ont été créés.',
    'set_preferred_language'                    => 'Si vous préférez utiliser Firefly III dans une autre langue, veuillez l\'indiquer ici.',
    'language'                                  => 'Langue',
    'new_savings_account'                       => ':bank_name compte d\'épargne',
    'cash_wallet'                               => 'Porte-monnaie',
    'currency_not_present'                      => 'Si la devise que vous utilisez habituellement n\'est pas répertoriée, ne vous inquiétez pas. Vous pouvez créer vos propres devises dans Options > Devises.',

    // home page:
    'transaction_table_description'             => 'Une table contenant vos opérations',
    'opposing_account'                          => 'Compte opposé',
    'yourAccounts'                              => 'Vos comptes',
    'your_accounts'                             => 'Aperçu de votre compte',
    'category_overview'                         => 'Aperçu des catégories',
    'expense_overview'                          => 'Aperçu des comptes de dépense',
    'revenue_overview'                          => 'Aperçu des comptes de revenu',
    'budgetsAndSpending'                        => 'Budgets et dépenses',
    'budgets_and_spending'                      => 'Budgets et dépenses',
    'go_to_budget'                              => 'Aller au budget "{budget}"',
    'go_to_deposits'                            => 'Aller aux dépôts',
    'go_to_expenses'                            => 'Aller aux dépenses',
    'savings'                                   => 'Épargne',
    'newWithdrawal'                             => 'Nouvelle dépense',
    'newDeposit'                                => 'Nouveau dépôt',
    'newTransfer'                               => 'Nouveau transfert',
    'bills_to_pay'                              => 'Abonnements à payer',
    'per_day'                                   => 'Par jour',
    'left_to_spend_per_day'                     => 'Reste à dépenser par jour',
    'bills_paid'                                => 'Abonnements payés',
    'custom_period'                             => 'Période personnalisée',
    'reset_to_current'                          => 'Réinitialiser à la période en cours',
    'select_period'                             => 'Sélectionnez une période',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Devise',
    'preferences'                               => 'Préférences',
    'logout'                                    => 'Se déconnecter',
    'logout_other_sessions'                     => 'Déconnecter toutes les autres sessions',
    'toggleNavigation'                          => 'Activer navigation',
    'toggle_dropdown'                           => 'Afficher/masquer la liste déroulante',
    'searchPlaceholder'                         => 'Rechercher...',
    'version'                                   => 'Version',
    'dashboard'                                 => 'Tableau de bord',
    'income_and_expense'                        => 'Revenus et dépenses',
    'all_money'                                 => 'Tout votre argent',
    'unknown_source_plain'                      => 'Compte source inconnu',
    'unknown_dest_plain'                        => 'Compte de destination inconnu',
    'unknown_any_plain'                         => 'Compte inconnu',
    'unknown_budget_plain'                      => 'Pas de budget',
    'available_budget'                          => 'Budget disponible ({currency})',
    'currencies'                                => 'Devises',
    'activity'                                  => 'Activité',
    'usage'                                     => 'Utilisation',
    'accounts'                                  => 'Comptes',
    'Asset account'                             => 'Compte d’actif',
    'Default account'                           => 'Compte d’actif',
    'Expense account'                           => 'Compte de dépenses',
    'Revenue account'                           => 'Compte de recettes',
    'Initial balance account'                   => 'Balance initiale',
    'account_type_Asset account'                => 'Compte d’actif',
    'account_type_Expense account'              => 'Compte de dépenses',
    'account_type_Revenue account'              => 'Compte de recettes',
    'account_type_Debt'                         => 'Dette',
    'account_type_Loan'                         => 'Prêt',
    'account_type_Mortgage'                     => 'Prêt hypothécaire',
    'account_type_debt'                         => 'Dette',
    'account_type_loan'                         => 'Emprunt',
    'account_type_mortgage'                     => 'Prêt immobilier',
    'account_type_Credit card'                  => 'Carte de crédit',
    'credit_card_type_monthlyFull'              => 'Paiement complet tous les mois',
    'liability_direction_credit'                => 'On me doit cette dette',
    'liability_direction_debit'                 => 'Je dois cette dette à quelqu\'un d\'autre',
    'liability_direction_credit_short'          => 'Emprunteur',
    'liability_direction_debit_short'           => 'Prêteur',
    'liability_direction__short'                => 'Inconnu',
    'liability_direction_null_short'            => 'Inconnu',
    'Liability credit'                          => 'Passif de crédit',
    'budgets'                                   => 'Budgets',
    'tags'                                      => 'Tags',
    'reports'                                   => 'Rapports',
    'transactions'                              => 'Opérations',
    'expenses'                                  => 'Dépenses',
    'income'                                    => 'Recette / revenu',
    'transfers'                                 => 'Transferts',
    'moneyManagement'                           => 'Gestion financière',
    'money_management'                          => 'Gestion financière',
    'tools'                                     => 'Outils',
    'piggyBanks'                                => 'Tirelires',
    'piggy_banks'                               => 'Tirelires',
    'amount_x_of_y'                             => '{current} sur {total}',
    'bills'                                     => 'Abonnements',
    'withdrawal'                                => 'Dépense',
    'opening_balance'                           => 'Solde d\'ouverture',
    'deposit'                                   => 'Dépôt',
    'account'                                   => 'Compte',
    'transfer'                                  => 'Transfert',
    'Withdrawal'                                => 'Dépense',
    'Deposit'                                   => 'Dépôt',
    'Transfer'                                  => 'Transfert',
    'bill'                                      => 'Abonnement',
    'yes'                                       => 'Oui',
    'no'                                        => 'Non',
    'amount'                                    => 'Montant',
    'overview'                                  => 'Vue globale',
    'saveOnAccount'                             => 'Mis de côté sur le compte',
    'saveOnAccounts'                            => 'Mis de côté sur le(s) compte(s)',
    'unknown'                                   => 'Inconnu',
    'monthly'                                   => 'Mensuel',
    'profile'                                   => 'Profil',
    'errors'                                    => 'Erreurs',
    'debt_start_date'                           => 'Date de début de la dette',
    'debt_start_amount'                         => 'Montant initial de la dette',
    'debt_start_amount_help'                    => 'Il est toujours préférable de définir cette valeur à un montant négatif. Lisez les pages d\'aide (icône (?) en haut à droite) pour plus d\'informations.',
    'interest_period_help'                      => 'Ce champ est purement cosmétique et ne sera pas calculé pour vous. Il se trouve que les banques ont chacune leur façon de faire et Firefly III ne fournira pas de bonne solution.',
    'store_new_liabilities_account'             => 'Enregistrer un nouveau passif',
    'edit_liabilities_account'                  => 'Modifier le passif ":name"',
    'financial_control'                         => 'Gestion des finances',
    'accounting'                                => 'Comptabilité',
    'automation'                                => 'Automatisation',
    'others'                                    => 'Autres',
    'classification'                            => 'Classification',
    'store_transaction'                         => 'Enregistrer l\'opération',


    // reports:
    'quick_link_needs_accounts'                 => 'Pour générer des rapports, vous devez ajouter au moins un compte d\'actif à Firefly III.',
    'report_default'                            => 'Rapport financier par défaut entre le :start et le :end',
    'report_audit'                              => 'Aperçu de l\'historique des opérations entre le :start et le :end',
    'report_category'                           => 'Rapport de catégorie entre :start et :end',
    'report_double'                             => 'Rapport de compte de dépenses / recettes entre le :start et le :end',
    'report_budget'                             => 'Rapport du budget entre le :start et le :end',
    'report_tag'                                => 'Rapport de tag entre le :start et le :end',
    'quick_link_reports'                        => 'Liens rapides',
    'quick_link_examples'                       => 'Voici quelques exemples de liens pour vous aider à démarrer. Consultez les pages d\'aide en cliquant le bouton (?) pour plus d\'informations sur les rapports et les mots magiques que vous pouvez utiliser.',
    'quick_link_default_report'                 => 'Rapport financier par défaut',
    'quick_link_audit_report'                   => 'Historique des opérations',
    'report_this_month_quick'                   => 'Mois en cours, tous les comptes',
    'report_last_month_quick'                   => 'Mois dernier, tous les comptes',
    'report_this_year_quick'                    => 'Année en cours, tous les comptes',
    'report_this_fiscal_year_quick'             => 'Année fiscale en cours, tous les comptes',
    'report_all_time_quick'                     => 'Tous les temps, tous les comptes',
    'reports_can_bookmark'                      => 'N’oubliez pas que les rapports peuvent être mis en favori.',
    'incomeVsExpenses'                          => 'Revenus vs dépenses',
    'accountBalances'                           => 'Soldes du compte',
    'balanceStart'                              => 'Solde au début de la période',
    'balanceEnd'                                => 'Solde à la fin de la période',
    'splitByAccount'                            => 'Séparation par compte',
    'coveredWithTags'                           => 'Couvert par des tags',
    'leftInBudget'                              => 'Budget restant',
    'left_in_debt'                              => 'Montant dû',
    'sumOfSums'                                 => 'Somme des montants',
    'noCategory'                                => '(aucune catégorie)',
    'notCharged'                                => 'Pas (encore) facturé',
    'inactive'                                  => 'Inactif',
    'active'                                    => 'Actif',
    'difference'                                => 'Différence',
    'money_flowing_in'                          => 'Entrée',
    'money_flowing_out'                         => 'Sortie',
    'topX'                                      => ':number premiers',
    'show_full_list'                            => 'Afficher la liste complète',
    'show_only_top'                             => 'Afficher uniquement :number premiers',
    'report_type'                               => 'Type de rapport',
    'report_type_default'                       => 'Rapport financier par défaut',
    'report_type_audit'                         => 'Historique des opérations',
    'report_type_category'                      => 'Rapport par catégories',
    'report_type_budget'                        => 'Rapport du budget',
    'report_type_tag'                           => 'Rapport de tag',
    'report_type_double'                        => 'Rapport de compte de dépenses/recettes',
    'more_info_help'                            => 'Vous trouverez plus d’informations sur ces différents types de rapports dans les pages d’aide. Appuyez sur l’icône (?) dans le coin supérieur droit.',
    'report_included_accounts'                  => 'Comptes inclus',
    'report_date_range'                         => 'Intervalle de dates',
    'report_preset_ranges'                      => 'Intervalles pré-configurés',
    'shared'                                    => 'Partagé',
    'fiscal_year'                               => 'Année fiscale',
    'income_entry'                              => 'Revenus du compte ":name" entre le :start et le :end',
    'expense_entry'                             => 'Dépenses du compte ":name" entre le :start et le :end',
    'category_entry'                            => 'Dépenses et revenus dans la catégorie ":name" entre le :start et le :end',
    'budget_spent_amount'                       => 'Dépenses dans le budget ":budget" entre le :start et le :end',
    'balance_amount'                            => 'Dépenses dans le budget ":budget" payé depuis le compte ":account" entre le :start et le :end',
    'no_audit_activity'                         => 'Aucune activité n\'a été enregistrée sur le compte <a href=":url" title=":account_name">:account_name</a> entre le :start et le :end.',
    'audit_end_balance'                         => 'Le solde du compte <a href=":url" title=":account_name">:account_name</a> à la fin du :end était de : :balance',
    'reports_extra_options'                     => 'Options supplémentaires',
    'report_has_no_extra_options'               => 'Ce rapport n\'a pas d\'options supplémentaires',
    'reports_submit'                            => 'Afficher le rapport',
    'end_after_start_date'                      => 'La date de fin du rapport doit être postérieure à la date de début.',
    'select_category'                           => 'Sélectionner la(les) catégorie(s)',
    'select_budget'                             => 'Sélectionnez le(s) budget(s).',
    'select_tag'                                => 'Sélectionnez le·s tag·s.',
    'income_per_category'                       => 'Revenus par catégorie',
    'expense_per_category'                      => 'Dépenses par catégorie',
    'expense_per_budget'                        => 'Dépenses par budget',
    'income_per_account'                        => 'Revenus par compte',
    'expense_per_account'                       => 'Dépenses par compte',
    'expense_per_tag'                           => 'Dépenses par tag',
    'income_per_tag'                            => 'Revenus par tag',
    'include_expense_not_in_budget'             => 'Les dépenses incluses ne sont pas dans le(s) budget(s) sélectionné(s)',
    'include_expense_not_in_account'            => 'Les dépenses incluses ne sont pas dans le(s) compte(s) sélectionné(s)',
    'include_expense_not_in_category'           => 'Les dépenses incluses ne sont pas dans la(les) catégorie(s) sélectionnée(s)',
    'include_income_not_in_category'            => 'Les revenus inclus ne sont pas dans la(les) catégorie(s) sélectionnée(s)',
    'include_income_not_in_account'             => 'Revenus inclus non compris dans le(s) compte(s) sélectionné(s)',
    'include_income_not_in_tags'                => 'Les revenus inclus ne sont pas dans la (les) catégorie·s sélectionnée·s',
    'include_expense_not_in_tags'               => 'Les dépenses incluses ne sont pas dans le·s tag·s sélectionnée·s',
    'everything_else'                           => 'Tout le reste',
    'income_and_expenses'                       => 'Recettes et dépenses',
    'spent_average'                             => 'Dépenses (moyenne)',
    'income_average'                            => 'Revenus (moyenne)',
    'transaction_count'                         => 'Nombre d\'opérations',
    'average_spending_per_account'              => 'Dépenses moyennes par compte',
    'average_income_per_account'                => 'Revenus moyens par compte',
    'total'                                     => 'Total',
    'description'                               => 'Description',
    'sum_of_period'                             => 'Somme pour la période',
    'average_in_period'                         => 'Moyenne pour la période',
    'no_account_role'                           => '(aucun rôle)',
    'account_role_defaultAsset'                 => 'Compte d\'actif par défaut',
    'account_role_sharedAsset'                  => 'Compte d\'actif partagé',
    'account_role_savingAsset'                  => 'Compte d’épargne',
    'account_role_ccAsset'                      => 'Carte de crédit',
    'account_role_cashWalletAsset'              => 'Porte-monnaie',
    'budget_chart_click'                        => 'Cliquez sur le nom du budget dans le tableau ci-dessus pour voir un graphique.',
    'category_chart_click'                      => 'Cliquez sur un nom de catégorie dans le tableau ci-dessus pour voir un graphique.',
    'in_out_accounts'                           => 'Gagné et dépensé par compte',
    'in_out_accounts_per_asset'                 => 'Gagné et dépensé (par compte d\'actif)',
    'in_out_per_category'                       => 'Gagné et dépensé par catégorie',
    'out_per_budget'                            => 'Dépensé par budget',
    'select_expense_revenue'                    => 'Sélectionner le compte de dépenses / recettes',
    'multi_currency_report_sum'                 => 'Cette liste contenant des comptes dans des devises différentes, les sommes que vous voyez peuvent ne pas faire sens. Le rapport sera lui toujours généré dans votre devise par défaut.',
    'sum_in_default_currency'                   => 'La somme sera toujours dans votre devise par défaut.',
    'net_filtered_prefs'                        => 'Ce graphique n’inclura jamais les comptes dont l\'option « inclure dans l\'avoir net » n\'est pas cochée.',


    // charts:
    'chart'                                     => 'Graphique',
    'month'                                     => 'Mois',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Dépensé',
    'spent_capped'                              => 'Dépensé (plafonné)',
    'spent_in_budget'                           => 'Dépensé dans le budget',
    'left_to_spend'                             => 'Reste à dépenser',
    'earned'                                    => 'Gagné',
    'overspent'                                 => 'Trop dépensé',
    'left'                                      => 'Reste',
    'max-amount'                                => 'Montant maximum',
    'min-amount'                                => 'Montant minimum',
    'journal-amount'                            => 'Saisie d\'abonnement actuelle',
    'name'                                      => 'Nom',
    'expires_at'                                => 'Expire le',
    'date'                                      => 'Date',
    'date_and_time'                             => 'Date et heure',
    'time'                                      => 'Heure',
    'paid'                                      => 'Payé',
    'unpaid'                                    => 'Impayé',
    'day'                                       => 'Jour',
    'budgeted'                                  => 'Budgétisé',
    'period'                                    => 'Période',
    'balance'                                   => 'Solde',
    'in_out_period'                             => 'Entrée + sortie de la période',
    'sum'                                       => 'Somme',
    'summary'                                   => 'Résumé',
    'average'                                   => 'Moyenne',
    'balanceFor'                                => 'Solde pour :name',
    'no_tags'                                   => '(pas de mot-clé)',
    'nothing_found'                             => '(aucun résultat)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Paramètres de la page',
    'visible_columns'               => 'Colonnes visibles',
    'accounts_to_show'              => 'Comptes à afficher',
    'active_accounts_only'          => 'Comptes actifs uniquement',
    'in_active_accounts_only'       => 'Comptes inactifs uniquement',
    'show_all_accounts'             => 'Afficher tous les comptes',
    'group_accounts'                => 'Grouper les comptes',

    // piggy banks:
    'event_history'                 => 'Historique des événements',
    'add_money_to_piggy'            => 'Ajouter de l’argent à la tirelire ":name"',
    'piggy_bank'                    => 'Tirelire',
    'new_piggy_bank'                => 'Nouvelle tirelire',
    'store_piggy_bank'              => 'Créer une nouvelle tirelire',
    'stored_piggy_bank'             => 'Créer une nouvelle tirelire ":name"',
    'account_status'                => 'État du compte',
    'left_for_piggy_banks'          => 'Reste pour les tirelires',
    'sum_of_piggy_banks'            => 'Somme des tirelires',
    'saved_so_far'                  => 'Mis de côté jusqu\'à présent',
    'saved_so_far_total'            => 'Économisé jusqu\'à présent au total',
    'reset_history'                 => 'réinitialiser l\'historique',
    'reset_history_confirm'         => 'Êtes-vous sûr de vouloir réinitialiser l\'historique de cette tirelire ? Le tableau correspondra ainsi à nouveau au montant de la tirelire.',
    'piggy_history_reset'           => 'L\'historique de la tirelire a été réinitialisé',
    'left_to_save'                  => 'Reste à mettre de côté',
    'suggested_amount'              => 'Montant mensuel suggéré à économiser',
    'add_money_to_piggy_title'      => 'Ajouter de l’argent à la tirelire ":name"',
    'remove_money_from_piggy_title' => 'Retirer l’argent de la tirelire ":name"',
    'add'                           => 'Ajouter',
    'no_money_for_piggy'            => 'Vous n\'avez pas d\'argent à placer dans cette tirelire.',
    'suggested_savings_per_month'   => 'Suggéré par mois',

    'remove'                    => 'Enlever',
    'max_amount_add'            => 'Le montant maximum que vous pouvez ajouter est',
    'max_amount_remove'         => 'Le montant maximum que vous pouvez supprimer est',
    'update_piggy_button'       => 'Mise à jour de la tirelire',
    'update_piggy_title'        => 'Mise à jour de la tirelire ":name"',
    'updated_piggy_bank'        => 'Tirelire ":name" mise à jour',
    'details'                   => 'Détails',
    'events'                    => 'Evènements',
    'target_amount'             => 'Montant cible',
    'start_date'                => 'Date de début',
    'no_start_date'             => 'Pas de date de début',
    'target_date'               => 'Date cible',
    'no_target_date'            => 'Aucune date butoir',
    'table'                     => 'Tableau',
    'delete_piggy_bank'         => 'Supprimer la tirelire ":name"',
    'cannot_add_amount_piggy'   => 'Impossible d\'ajouter :amount à ":name".',
    'cannot_remove_from_piggy'  => 'Impossible de supprimer :amount à ":name".',
    'deleted_piggy_bank'        => 'Tirelire ":name" supprimée',
    'added_amount_to_piggy'     => 'Ajouté :amount à ":name"',
    'removed_amount_from_piggy' => ':amount retiré de ":name"',
    'piggy_events'              => 'Tirelires associées',

    // tags
    'delete_tag'                => 'Supprimer le tag ":tag"',
    'deleted_tag'               => 'Tag ":tag" supprimé',
    'new_tag'                   => 'Créer un nouveau tag',
    'edit_tag'                  => 'Modifier le tag ":tag"',
    'updated_tag'               => 'Mise à jour du tag ":tag"',
    'created_tag'               => 'Tag " : tag" a été créé !',

    'transaction_journal_information'               => 'Informations sur l\'opération',
    'transaction_journal_amount'                    => 'Informations sur les montants',
    'transaction_journal_meta'                      => 'Méta informations',
    'transaction_journal_more'                      => 'Plus d\'informations',
    'basic_journal_information'                     => 'Informations de base sur l\'opération',
    'transaction_journal_extra'                     => 'Informations supplémentaires',
    'att_part_of_journal'                           => 'Stocké dans ":journal"',
    'total_amount'                                  => 'Montant total',
    'number_of_decimals'                            => 'Nombre de décimales',


    // administration
    'invite_is_already_redeemed'                    => 'L\'invitation à ":address" a déjà été utilisée.',
    'invite_is_deleted'                             => 'L\'invitation à ":address" a été supprimée.',
    'invite_new_user_title'                         => 'Inviter un nouvel utilisateur',
    'invite_new_user_text'                          => 'En tant qu\'administrateur, vous pouvez inviter des utilisateurs à s\'inscrire sur votre instance Firefly III. En partageant avec eux le lien direct, ils seront en mesure de créer un compte. L\'utilisateur invité et son lien d\'invitation apparaîtront dans le tableau ci-dessous. Vous êtes libre de partager le lien d\'invitation avec eux.',
    'invited_user_mail'                             => 'Adresse e-mail',
    'invite_user'                                   => 'Inviter l’utilisateur',
    'user_is_invited'                               => 'L\'adresse e-mail ":address" a été invitée à rejoindre Firefly III',
    'administration'                                => 'Administration',
    'system_settings'                               => 'Paramètres du système',
    'code_already_used'                             => 'Le code d\'invitation a été utilisé',
    'user_administration'                           => 'Gestion des utilisateurs',
    'list_all_users'                                => 'Tous les utilisateurs',
    'all_users'                                     => 'Tous les utilisateurs',
    'instance_configuration'                        => 'Configuration',
    'firefly_instance_configuration'                => 'Configuration de Firefly III',
    'config_security' => 'Configuration de la sécurité',
    'config_features' => 'Fonctionnalités activées',
    'config_tech' => 'Fonctionnalités techniques',
    'config_external_connections' => 'Paramètres liés à la confidentialité (se connecte à Internet)',

    'setting_enable_exchange_rates' => 'Activer les taux de change',
    'setting_enable_exchange_rates_explain' => 'Firefly III a la capacité de calculer les taux de change pour vous.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III peut calculer le solde courant à votre place, et l\'afficher à différents endroits. C\'est encore légèrement expérimental, donc désactivé par défaut. Vous devrez peut-être redémarrer votre conteneur ou lancer la commande initiale manuellement (voir la doc).',
    'setting_enable_external_map' => 'Utiliser le service de carte externe',
    'setting_enable_external_map_explain' => 'Firefly III utilise un service externe pour afficher les emplacements. Ça vous va ?',
    'setting_enable_external_rates' => 'Télécharger les taux de change depuis le web',
    'setting_enable_external_rates_explain' => 'Firefly III peut télécharger les taux de change pour les devises intégrées. Cela nécessite l\'exécution d\'une tâche cron.',
    'setting_allow_webhooks' => 'Autoriser les webhooks',
    'setting_allow_webhooks_explain' => 'Autoriser Firefly III à envoyer des webhooks ?',
    'setting_valid_url_protocols' => 'Protocoles d\'URL autorisés',
    'setting_valid_url_protocols_explain' => 'Firefly III permet uniquement aux urls d\'avoir des protocoles standards tels que https et ftp, etc. Si vous êtes bricoleur, vous pouvez aussi en autoriser d\'autres.',


    'setting_single_user_mode'                      => 'Mode utilisateur unique',
    'setting_single_user_mode_explain'              => 'Par défaut, Firefly III accepte uniquement une (1) inscription : vous. Il s\'agit d\'une mesure de sécurité qui empêche les inconnus d\'utiliser votre instance, à moins que vous ne les y autorisiez. Les inscriptions futures sont bloquées. Lorsque vous désactivez cette case, d\'autres personnes peuvent utiliser votre instance, en supposant qu\'elles puissent l\'atteindre (quand elle est connectée à Internet).',
    'store_configuration'                           => 'Sauvegarder la configuration',
    'single_user_administration'                    => 'Gestion de l\'utilisateur pour :email',
    'edit_user'                                     => 'Modifier l\'utilisateur :email',
    'hidden_fields_preferences'                     => 'Vous pouvez activer plus d\'options d\'opérations dans vos <a href="preferences">paramètres</a>.',
    'user_data_information'                         => 'Données utilisateur',
    'user_information'                              => 'Informations utilisateur',
    'total_size'                                    => 'taille totale',
    'budget_or_budgets'                             => ':count budget|:count budgets',
    'budgets_with_limits'                           => ':count budget avec un montant configuré|:count budgets avec un montant configuré',
    'nr_of_rules_in_total_groups'                   => ':count_rules règle(s) dans :count_groups groupe(s) de règles',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'La configuration a été mise à jour',
    'setting_is_demo_site'                          => 'Site de démonstration',
    'setting_is_demo_site_explain'                  => 'Si vous cochez cette case, cette installation se comportera comme si c\'était le site de démonstration, ce qui comporte certaines limitations.',
    'block_code_bounced'                            => 'Rebond des emails',
    'block_code_expired'                            => 'Compte démo expiré',
    'no_block_code'                                 => 'Aucune raison pour le blocage ou utilisateur non bloqué',
    'demo_user_export'                              => 'L\'utilisateur du compte de démonstration ne peut pas exporter de données',
    'block_code_email_changed'                      => 'L\'utilisateur n\'a pas encore confirmé sa nouvelle adresse e-mail',
    'admin_update_email'                            => 'Contrairement à la page de profil, l\'utilisateur NE SERA PAS informé que son adresse email a changé !',
    'update_user'                                   => 'Utilisateur mis à jour',
    'updated_user'                                  => 'Les données utilisateur ont bien été modifiées.',
    'delete_user'                                   => 'Supprimer l\'utilisateur :email',
    'user_deleted'                                  => 'L\'utilisateur a été supprimé',
    'send_test_email'                               => 'Envoyer un message de test',
    'send_test_email_text'                          => 'Pour vérifier que votre installation est capable d\'envoyer des notifications, utilisez ce bouton. Vous ne verrez pas d\'erreur ici (s\'il y en a), <strong>elles seront enregistrées dans les logs</strong>. Vous pouvez utiliser ce bouton autant de fois que vous le voulez. Il n\'y a pas de système anti-spam. Le message sera envoyé à <code>:email</code> et devrait arriver sous peu.',
    'send_message'                                  => 'Envoyer le message',
    'send_test_triggered'                           => 'Le test a été initié. Vérifiez votre boîte de réception (et les logs si nécessaire).',
    'give_admin_careful'                            => 'Les utilisateurs disposant de droits d\'administration peuvent révoquer les vôtres. Soyez prudent.',
    'admin_maintanance_title'                       => 'Maintenance',
    'admin_maintanance_expl'                        => 'Quelques boutons intéressants pour la maintenance de Firefly III',
    'admin_maintenance_clear_cache'                 => 'Vider le cache',
    'owner_notifications'                           => 'Notifications administrateur',
    'owner_notifications_expl'                      => 'Les notifications suivantes peuvent être activées ou désactivées par l\'administrateur. Elles seront envoyées sur TOUS les canaux configurés. Certains canaux sont configurés dans vos variables d\'environnement, d\'autres peuvent être configurés ici.',
    'channel_settings'                              => 'Paramètres pour les canaux de notification',
    'notification_test_failed'                      => 'Le test de notification pour le canal «:channel» a échoué. Les logs auront plus de détails.',
    'notification_test_executed'                    => 'Test de notification pour le canal «:channel» exécuté. Vérifiez vos logs pour plus de détails.',
    'settings_notifications'                        => 'Paramètres pour les notifications',
    'title_owner_notifications'                     => 'Notifications du propriétaire',
    'owner_notification_check_user_new_reg'         => 'L\'utilisateur reçoit un message de bienvenue après inscription',
    'owner_notification_check_admin_new_reg'        => 'Les administrateurs reçoivent une notification à l\'inscription de nouveaux utilisateurs',
    'owner_notification_check_new_version'          => 'Une nouvelle version est disponible',
    'owner_notification_check_invite_created'       => 'Un utilisateur est invité à rejoindre Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Une invitation d\'utilisateur a été utilisée',
    'owner_notification_check_unknown_user_attempt' => 'Un utilisateur inconnu tente de se connecter',
    'all_invited_users'                             => 'Tous les utilisateurs invités',
    'save_notification_settings'                    => 'Enregistrer les paramètres',
    'notification_settings'                         => 'Paramètres pour les notifications',
    'notification_settings_saved'                   => 'Les paramètres de notification ont été enregistrés',
    'available_channels_title'                      => 'Canaux disponibles',
    'available_channels_expl'                       => 'Ces canaux sont disponibles pour envoyer des notifications. Pour tester votre configuration, utilisez les boutons ci-dessous. Veuillez noter que les boutons n\'ont pas de système anti-spam.',
    'notification_channel_name_email'               => 'E-mail',
    'slack_discord_double'                          => 'Le canal de notification Slack peut également envoyer des notifications à Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'non disponible',
    'configure_channel_in_env'                      => 'a besoin de variables d\'environnement',
    'test_notification_channel_name_email'          => 'Tester l\'email',
    'test_notification_channel_name_slack'          => 'Tester Slack',
    'test_notification_channel_name_ntfy'           => 'Tester Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Tester Gotify',
    'test_notification_channel_name_pushbullet'     => 'Tester Pushbullet',

    'split_transaction_title'               => 'Description de l\'opération séparée',
    'split_transaction_title_help'          => 'Si vous créez une opération séparée, il doit y avoir une description globale pour chaque fraction de l\'opération.',
    'split_title_help'                      => 'Si vous créez une opération séparée, il doit y avoir une description globale pour chaque fraction de l\'opération.',
    'you_create_transfer'                   => 'Vous saisissez un transfert.',
    'you_create_withdrawal'                 => 'Vous saisissez une dépense.',
    'you_create_deposit'                    => 'Vous saisissez un dépôt.',

    // links
    'journal_link_configuration'            => 'Configuration des liens d\'opération',
    'create_new_link_type'                  => 'Créer un nouveau type de lien',
    'store_new_link_type'                   => 'Enregistrer un nouveau type de lien',
    'update_link_type'                      => 'Mettre à jour le type de lien',
    'edit_link_type'                        => 'Modifier le type de lien ":name"',
    'updated_link_type'                     => 'Type de lien mis à jour ":name"',
    'delete_link_type'                      => 'Supprimer le type de lien ":name"',
    'deleted_link_type'                     => 'Type de lien supprimé ":name"',
    'stored_new_link_type'                  => 'Enregistrer le nouveau type de lien ":name"',
    'cannot_edit_link_type'                 => 'Impossible d\'éditer le type de lien ":name"',
    'link_type_help_name'                   => 'Par exemple "Duplique"',
    'link_type_help_inward'                 => 'Par exemple "duplique"',
    'link_type_help_outward'                => 'Par exemple "est dupliqué par"',
    'save_connections_by_moving'            => 'Enregistrer le lien entre ces opérations en les déplaçant vers un autre type de lien :',
    'do_not_save_connection'                => '(ne pas enregistrer la connexion)',
    'link_transaction'                      => 'Lier l\'opération',
    'link_to_other_transaction'             => 'Lier cette opération à une autre opération',
    'select_transaction_to_link'            => 'Sélectionnez une autre opération à laquelle lier cette opération. Les liens sont actuellement inutilisés dans Firefly III (ils sont juste montrés), mais je compte changer cela dans le futur. Utilisez le champ de recherche pour sélectionner une opération soit par titre ou par ID. Si vous voulez ajouter des types de liens personnalisés, consultez les paramètres.',
    'this_transaction'                      => 'Cette opération',
    'transaction'                           => 'Opération',
    'comments'                              => 'Commentaires',
    'link_notes'                            => 'Toutes les notes que vous souhaitez enregistrer avec le lien.',
    'invalid_link_selection'                => 'Impossible de lier ces opérations',
    'selected_transaction'                  => 'Opération sélectionnée',
    'journals_linked'                       => 'Ces opérations sont liées.',
    'journals_error_linked'                 => 'Ces opérations sont déjà liées.',
    'journals_link_to_self'                 => 'Vous ne pouvez pas lier une opération à elle-même',
    'journal_links'                         => 'Liens d\'opération',
    'this_withdrawal'                       => 'Cette dépense',
    'this_deposit'                          => 'Ce dépôt',
    'this_transfer'                         => 'Ce transfert',
    'overview_for_link'                     => 'Aperçu pour le type de lien ":name"',
    'source_transaction'                    => 'Source de l\'opération',
    'link_description'                      => 'Description du lien',
    'destination_transaction'               => 'Destination de l\'opération',
    'delete_journal_link'                   => 'Supprimez le lien entre <a href=":source_link">:source</a> et <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Lien supprimé',

    // link translations:
    'Paid_name'                             => 'Payé',
    'Refund_name'                           => 'Remboursement',
    'Reimbursement_name'                    => 'Remboursement',
    'Related_name'                          => 'Associé',
    'relates to_inward'                     => 'se rapporte à',
    'is (partially) refunded by_inward'     => 'est (partiellement) remboursé par',
    'is (partially) paid for by_inward'     => 'est (partiellement) payé par',
    'is (partially) reimbursed by_inward'   => 'est (partiellement) remboursé par',
    'inward_transaction'                    => 'Opération entrante',
    'outward_transaction'                   => 'Opération sortante',
    'relates to_outward'                    => 'se rapporte à',
    '(partially) refunds_outward'           => 'rembourse (partiellement)',
    '(partially) pays for_outward'          => 'paye (partiellement) pour',
    '(partially) reimburses_outward'        => 'rembourse (partiellement)',
    'is (partially) refunded by'            => 'est (partiellement) remboursé par',
    'is (partially) paid for by'            => 'est (partiellement) payé par',
    'is (partially) reimbursed by'          => 'est (partiellement) remboursé par',
    'relates to'                            => 'se rapporte à',
    '(partially) refunds'                   => 'rembourse (partiellement)',
    '(partially) pays for'                  => 'paye (partiellement) pour',
    '(partially) reimburses'                => 'rembourse (partiellement)',

    // split a transaction:
    'splits'                                => 'Séparations',
    'add_another_split'                     => 'Ajouter une autre fraction',
    'cannot_edit_opening_balance'           => 'Vous ne pouvez pas modifier le solde d\'ouverture d\'un compte.',
    'no_edit_multiple_left'                 => 'Vous n\'avez sélectionné aucune opération valide à éditer.',
    'breadcrumb_convert_group'              => 'Convertir l\'opération',
    'convert_invalid_source'                => 'La source est invalide pour l\'opération n°%d.',
    'convert_invalid_destination'           => 'Le compte de destination est invalide pour l\'opération n°%d.',
    'create_another'                        => 'Après enregistrement, revenir ici pour en créer un nouveau.',
    'after_update_create_another'           => 'Après la mise à jour, revenir ici pour continuer l\'édition.',
    'store_as_new'                          => 'Enregistrer comme une nouvelle opération au lieu de mettre à jour.',
    'reset_after'                           => 'Réinitialiser le formulaire après soumission',
    'errors_submission'                     => 'Certaines informations ne sont pas correctes dans votre formulaire. Veuillez vérifier les erreurs ci-dessous.',
    'errors_submission_v2'                  => 'Certaines informations ne sont pas correctes dans votre formulaire. Veuillez vérifier les erreurs ci-dessous : {{errorMessage}}',
    'transaction_expand_split'              => 'Développer la séparation',
    'transaction_remove_split'              => 'Supprimer le fractionnement',
    'transaction_collapse_split'            => 'Réduire la séparation',

    // object groups
    'default_group_title_name'              => '(Sans groupement)',
    'default_group_title_name_plain'        => 'non groupé',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Nous allons créer un compte d’actif !',
    'no_accounts_intro_asset'               => 'Vous n\'avez pas encore de compte d\'actif. Les comptes d\'actifs sont vos comptes principaux : votre compte courant, votre compte d\'épargne, votre compte partagé ou même votre carte de crédit.',
    'no_accounts_imperative_asset'          => 'Pour commencer à utiliser Firefly III, vous devez créer au moins un compte d\'actif. Faisons-le maintenant :',
    'no_accounts_create_asset'              => 'Créer un compte d\'actif',
    'no_accounts_title_expense'             => 'Nous allons créer un compte de dépenses !',
    'no_accounts_intro_expense'             => 'Vous n\'avez pas encore de compte de dépenses. Les comptes de dépenses sont les endroits où vous dépensez, comme les magasins et les supermarchés.',
    'no_accounts_imperative_expense'        => 'Les comptes de dépenses sont créés automatiquement lorsque vous créez des opérations, mais vous pouvez en créer manuellement, si vous le souhaitez. Nous allons en créer un maintenant :',
    'no_accounts_create_expense'            => 'Créer un compte de dépenses',
    'no_accounts_title_revenue'             => 'Nous allons créer un compte de revenus !',
    'no_accounts_intro_revenue'             => 'Vous n\'avez pas encore de compte de revenus. Les comptes de revenus sont les endroits où vous recevez de l\'argent, comme votre employeur.',
    'no_accounts_imperative_revenue'        => 'Les comptes de revenus sont créés automatiquement lorsque vous créez des opérations, mais vous pouvez en créer manuellement, si vous le souhaitez. Nous allons en créer un maintenant :',
    'no_accounts_create_revenue'            => 'Créer un compte de revenus',
    'no_accounts_title_liabilities'         => 'Nous allons créer un passif !',
    'no_accounts_intro_liabilities'         => 'Vous n’avez encore aucun passif. Les passifs sont des comptes qui inscrivent vos emprunts et autres dettes.',
    'no_accounts_imperative_liabilities'    => 'Vous n’êtes pas obligé d\'utiliser cette fonctionnalité, mais elle peut être utile si vous souhaitez garder une trace de ces éléments.',
    'no_accounts_create_liabilities'        => 'Créer un passif',
    'no_budgets_title_default'              => 'Nous allons créer un budget',
    'no_rules_title_default'                => 'Nous allons créer une règle',
    'no_budgets_intro_default'              => 'Vous n\'avez pas encore de budget. Les budgets sont utilisés pour organiser vos dépenses en groupes logiques, ce que vous permet d\'établir des seuils pour limiter ces dépenses.',
    'no_rules_intro_default'                => 'Vous n\'avez pas encore de règles. Les règles sont des automatisations puissantes qui peuvent gérer les opérations pour vous.',
    'no_rules_imperative_default'           => 'Les règles peuvent être très utiles lorsque vous gérez des opérations. Créons-en une maintenant :',
    'no_budgets_imperative_default'         => 'Les budgets sont les outils de base de la gestion financière. Nous allons en créer un maintenant :',
    'no_budgets_create_default'             => 'Créer un budget',
    'no_rules_create_default'               => 'Créer une règle',
    'no_categories_title_default'           => 'Nous allons créer une catégorie !',
    'no_categories_intro_default'           => 'Vous n\'avez pas encore de catégories. Les catégories sont utilisées pour affiner vos opérations et les étiqueter avec leur catégorie désignée.',
    'no_categories_imperative_default'      => 'Les catégories sont créées automatiquement lorsque vous créez des opérations, mais vous pouvez en créer manuellement. Nous allons en créer une maintenant :',
    'no_categories_create_default'          => 'Créer une catégorie',
    'no_tags_title_default'                 => 'Nous allons créer un tag !',
    'no_tags_intro_default'                 => 'Vous n\'avez pas encore de tags. Les tags sont utilisés pour affiner vos opérations en les associant avec des mots-clés spécifiques.',
    'no_tags_imperative_default'            => 'Les tags sont créés automatiquement lorsque vous créez des opérations, mais vous pouvez en créer manuellement. Nous allons en créer un maintenant :',
    'no_tags_create_default'                => 'Créer un tag',
    'no_transactions_title_withdrawal'      => 'Nous allons créer une dépense !',
    'no_transactions_intro_withdrawal'      => 'Vous n\'avez pas encore de dépenses. Vous devriez créer des dépenses pour commencer à gérer vos finances.',
    'no_transactions_imperative_withdrawal' => 'Avez-vous dépensé de l’argent ? Alors vous devriez l’écrire :',
    'no_transactions_create_withdrawal'     => 'Créer une dépense',
    'no_transactions_title_deposit'         => 'Nous allons créer un revenu !',
    'no_transactions_intro_deposit'         => 'Vous n\'avez pas encore enregistré de revenus. Vous devriez créer des entrées de revenus pour commencer à gérer vos finances.',
    'no_transactions_imperative_deposit'    => 'Est-ce que vous avez reçu de l’argent ? Alors vous devriez l’écrire :',
    'no_transactions_create_deposit'        => 'Créer un dépôt',
    'no_transactions_title_transfers'       => 'Nous allons créer un transfert !',
    'no_transactions_intro_transfers'       => 'Vous n\'avez pas encore de transferts. Lorsque vous transférez de l\'argent entre les comptes d\'actifs, c\'est enregistré comme un transfert.',
    'no_transactions_imperative_transfers'  => 'Avez vous déplacé de l’argent ? Alors vous devriez l’écrire :',
    'no_transactions_create_transfers'      => 'Créer un transfert',
    'no_piggies_title_default'              => 'Nous allons créer une tirelire !',
    'no_piggies_intro_default'              => 'Vous n\'avez encore pas de tirelire. Vous pouvez créer des tirelires pour diviser vos économies et garder une trace de ce que vous économisez.',
    'no_piggies_imperative_default'         => 'Avez-vous des choses pour lesquelles vous économisez de l\'argent ? Créer une tirelire et suivez-là :',
    'no_piggies_create_default'             => 'Créer une nouvelle tirelire',
    'no_bills_title_default'                => 'Créer un abonnement !',
    'no_bills_intro_default'                => 'Vous n\'avez pas encore d\'abonnement. Vous pouvez créer des abonnements pour suivre les dépenses régulières, comme votre loyer ou votre assurance.',
    'no_bills_imperative_default'           => 'Avez-vous des abonnements réguliers ? Créez un abonnement et gardez une trace de vos paiements :',
    'no_bills_create_default'               => 'Créer un abonnement',

    // recurring transactions
    'recurrence_max_count'                  => 'Cette opération périodique sera créée au plus :max fois, et a déjà été créée :count fois.',
    'create_right_now'                      => 'Créer maintenant',
    'no_new_transaction_in_recurrence'      => 'Aucune nouvelle opération n\'a été créée. Peut-être a-t-elle déjà été déclenchée pour cette date ?',
    'recurrences'                           => 'Opérations périodiques',
    'repeat_until_in_past'                  => 'Cette opération récurrente a cessé de se répéter le :date.',
    'recurring_calendar_view'               => 'Calendrier',
    'no_recurring_title_default'            => 'Créons une opération périodique !',
    'no_recurring_intro_default'            => 'Vous n’avez pas encore d\'opérations périodiques. Vous pouvez en utiliser pour que Firefly III crée automatiquement des opérations pour vous.',
    'no_recurring_imperative_default'       => 'Il s’agit d’une fonctionnalité plutôt poussée, mais elle peut être très utile. Assurez-vous de lire la documentation ( icône ? en haut à droite) avant de continuer.',
    'no_recurring_create_default'           => 'Créer une opération périodique',
    'make_new_recurring'                    => 'Créer une opération périodique',
    'recurring_daily'                       => 'Tous les jours',
    'recurring_weekly'                      => 'Chaque semaine le :weekday',
    'recurring_weekly_skip'                 => 'Toutes les :skip semaine(s), le :weekday',
    'recurring_monthly'                     => 'Le :dayOfMonth de chaque mois',
    'recurring_monthly_skip'                => 'Tous les :skip mois, le :dayOfMonth(ier,ième) jour',
    'recurring_ndom'                        => 'Le :dayOfMonth(er/ème) :weekday de chaque mois',
    'recurring_ndom_skip'                   => 'Tous les :skip(er/ème) mois le :dayOfMonth(er/ème) :weekday',
    'recurring_yearly'                      => 'Chaque année le :date',
    'overview_for_recurrence'               => 'Aperçu de l’opération périodique ":title"',
    'warning_duplicates_repetitions'        => 'Dans de rares cas, des dates apparaissent en double dans cette liste. Cela peut arriver lorsque plusieurs répétitions se superposent. Firefly III générera toujours une seule opération par jour.',
    'created_transactions'                  => 'Opérations associées',
    'expected_withdrawals'                  => 'Dépenses attendues',
    'expected_deposits'                     => 'Dépôts attendus',
    'expected_transfers'                    => 'Transferts attendus',
    'created_withdrawals'                   => 'Dépenses créées',
    'created_deposits'                      => 'Dépôts créés',
    'created_transfers'                     => 'Transferts créés',
    'recurring_info'                        => 'Opération périodique :count / :total',
    'created_from_recurrence'               => 'Créé à partir de l\'opération périodique ":title" (#:id)',
    'recurring_never_cron'                  => 'Il semble que la tâche cron qui supporte les opérations périodiques n\'a jamais été exécutée. Ceci est normal si vous venez juste d\'installer Firefly III, mais pensez à la configurer dès que possible. Veuillez consulter la page d\'aide associée en cliquant sur l\'icône (?) en haut à droite de la page.',
    'recurring_cron_long_ago'               => 'Il semble que la dernière exécution de la tâche cron supportant les opérations périodiques date de plus de 36 heures. Êtes-vous surs qu\'elle est configurée correctement ? Veuillez consulter la page d\'aide associée en cliquant sur l\'icône (?) en haut à droite de la page.',

    'create_new_recurrence'              => 'Créer une nouvelle opération périodique',
    'help_first_date'                    => 'Indiquer la première occurrence attendue. Doit être dans le futur.',
    'help_first_date_no_past'            => 'Indiquer la première occurrence attendue. Firefly III ne créera pas d\'opérations dans le passé.',
    'no_currency'                        => '(pas de devise)',
    'mandatory_for_recurring'            => 'Informations de répétition obligatoires',
    'mandatory_for_transaction'          => 'Informations d\'opération obligatoires',
    'optional_for_recurring'             => 'Informations de répétition optionnelles',
    'optional_for_transaction'           => 'Informations d\'opération optionnelles',
    'change_date_other_options'          => 'Modifiez la date de début pour voir plus d\'options.',
    'mandatory_fields_for_tranaction'    => 'Les valeurs ci-dessous seront enregistrées dans les opérations créées',
    'click_for_calendar'                 => 'Cliquez ici pour voir les répétitions des opérations sur un calendrier.',
    'repeat_forever'                     => 'Répéter pour toujours',
    'repeat_until_date'                  => 'Répéter jusqu\'à une date',
    'repeat_times'                       => 'Répéter un nombre de fois',
    'recurring_skips_one'                => 'Tous les',
    'recurring_skips_more'               => 'Omettre :count répétitions',
    'store_new_recurrence'               => 'Enregistrer l\'opération périodique',
    'stored_new_recurrence'              => 'Opération périodique ":title" enregistrée avec succès.',
    'edit_recurrence'                    => 'Modifier l\'opération périodique ":title"',
    'recurring_repeats_until'            => 'Se répète jusqu\'à :date',
    'recurring_repeats_forever'          => 'Se répète pour toujours',
    'recurring_repeats_x_times'          => 'Répéter :count fois',
    'update_recurrence'                  => 'Mettre à jour l\'opération périodique',
    'updated_recurrence'                 => 'Opération périodique ":title" mise à jour',
    'recurrence_is_inactive'             => 'Cette opération périodique n’est pas active et ne génère pas de nouvelles opérations.',
    'delete_recurring'                   => 'Supprimer l\'opération périodique ":title"',
    'new_recurring_transaction'          => 'Nouvelle opération périodique',
    'help_weekend'                       => 'Que doit faire Firefly III lorsque l’opération périodique tombe un samedi ou un dimanche ?',
    'do_nothing'                         => 'Créer l\'opération tout de même',
    'skip_transaction'                   => 'Ignorer l\'occurrence',
    'jump_to_friday'                     => 'Créer l\'opération le vendredi précédent',
    'jump_to_monday'                     => 'Créer l\'opération le lundi suivant',
    'will_jump_friday'                   => 'Sera créée le vendredi plutôt que les week-ends.',
    'will_jump_monday'                   => 'Sera créée le lundi plutôt que les week-ends.',
    'except_weekends'                    => 'Sauf les week-ends',
    'recurrence_deleted'                 => 'Opération périodique ":title" supprimée',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Solde (:currency)',
    'box_spent_in_currency'              => 'Dépensé (:currency)',
    'box_earned_in_currency'             => 'Gagné (:currency)',
    'box_budgeted_in_currency'           => 'Budgétisé (:currency)',
    'box_bill_paid_in_currency'          => 'Abonnements payés (:currency)',
    'box_bill_unpaid_in_currency'        => 'Abonnements non payés (:currency)',
    'box_left_to_spend_in_currency'      => 'Reste à dépenser (:currency)',
    'box_net_worth_in_currency'          => 'Avoir net (:currency)',
    'box_spend_per_day'                  => 'Reste à dépenser par jour: :amount',

    // debug page
    'debug_page'                         => 'Page de débogage',
    'debug_submit_instructions'          => 'Si vous rencontrez des problèmes, vous pouvez utiliser les informations contenues dans ce cadre comme informations de débogage. Veuillez copier-coller dans une nouvelle "issue" <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a> (en anglais). Cela générera une belle table qui peut être utilisée pour diagnostiquer rapidement votre problème.',
    'debug_pretty_table'                 => 'Si vous copiez/collez le cadre ci-dessous dans une "issue" GitHub, cela générera un tableau. Veuillez ne pas entourer ce texte avec des apostrophes ou des guillemets.',
    'debug_additional_data'              => 'Vous pouvez également partager le contenu du cadre ci-dessous. Vous pouvez également copier/coller cela dans une <a href="https://github.com/firefly-iii/firefly-iii/issues">"issue" GitHub</a> déjà existante ou nouvellement créée. Cependant, le contenu de ce cadre peut contenir des informations privées telles que les noms de compte, les détails de transaction ou les adresses électroniques.',

    // object groups
    'object_groups_menu_bar'             => 'Groupes',
    'object_groups_page_title'           => 'Groupes',
    'object_groups_breadcrumb'           => 'Groupes',
    'object_groups_index'                => 'Vue d\'ensemble',
    'object_groups'                      => 'Groupes',
    'object_groups_empty_explain'        => 'Certaines choses dans Firefly III peuvent être divisées en groupes. Les tirelires, par exemple, présentent un champ "Groupe" dans les écrans d\'édition et de création. Lorsque vous définissez ce champ, vous pouvez modifier les noms et l\'ordre des groupes sur cette page. Pour plus d\'informations, consultez les pages d\'aide dans le coin supérieur droit, sous l\'icône (?).',
    'object_group_title'                 => 'Titre',
    'edit_object_group'                  => 'Modifier le groupe ":title"',
    'delete_object_group'                => 'Supprimer le groupe ":title"',
    'update_object_group'                => 'Mettre à jour le groupe',
    'updated_object_group'               => 'Groupe ":title" mis à jour avec succès',
    'deleted_object_group'               => 'Groupe ":title" supprimé avec succès',
    'object_group'                       => 'Groupe',

    // other stuff
    'placeholder'                        => '[Réservé]',

    // audit log entries
    'incomplete_ale' => 'Tous les événements ne sont pas enregistrés comme des entrées de journal d\'audit.',
    'audit_log_entries'                  => 'Auditer les entrées du journal',
    'ale_action_log_add'                 => ':amount ajouté à la tirelire ":name"',
    'ale_action_log_remove'              => ':amount retiré de la tirelire ":name"',
    'ale_action_clear_budget'            => 'Supprimé du budget',
    'ale_action_update_group_title'      => 'Titre du groupe d\'opérations mis à jour',
    'ale_action_update_date'             => 'Date de l\'opération mise à jour',
    'ale_action_update_order'            => 'Ordre de l\'opération mis à jour',
    'ale_action_clear_category'          => 'Supprimé de la catégorie',
    'ale_action_clear_notes'             => 'Notes supprimées',
    'ale_action_clear_tag'               => 'Tag retiré',
    'ale_action_clear_all_tags'          => 'Tous les tags ont été retirés',
    'ale_action_set_bill'                => 'Lié à l\'abonnement',
    'ale_action_switch_accounts'         => 'Comptes source et destination inversés',
    'ale_action_set_budget'              => 'Budget défini',
    'ale_action_set_category'            => 'Catégorie définie',
    'ale_action_set_source'              => 'Compte source défini',
    'ale_action_set_destination'         => 'Compte de destination défini',
    'ale_action_update_transaction_type' => 'Type d\'opération modifié',
    'ale_action_update_notes'            => 'Notes modifiées',
    'ale_action_update_description'      => 'Decription modifiée',
    'ale_action_add_to_piggy'            => 'Tirelire',
    'ale_action_remove_from_piggy'       => 'Tirelire',
    'ale_action_add_tag'                 => 'Tag ajouté',
    'ale_action_update_amount'           => 'Montant actualisé',

    // dashboard
    'enable_auto_convert'                => 'Activer la conversion des devises',
    'disable_auto_convert'               => 'Désactiver la conversion des devises',
];
