<?php

/**
 * validation.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


declare(strict_types=1);

return [
    'invalid_account_list' => 'Invalid account type list entry ":value"',
    'invalid_transaction_type_list' => 'Invalid transaction type list',
    'limit_exists'                   => 'There is already a budget limit (amount) for this budget and currency in the given period.',
    'invalid_sort_instruction'       => 'The sort instruction is invalid for an object of type ":object".',
    'invalid_sort_instruction_index' => 'The sort instruction at index #:index is invalid for an object of type ":object".',
    'no_sort_instructions'           => 'There are no sort instructions defined for an object of type ":object".',
    'webhook_budget_info'            => 'Cannot deliver budget information for transaction related webhooks.',
    'webhook_account_info'           => 'Cannot deliver account information for budget related webhooks.',
    'webhook_transaction_info'       => 'Cannot deliver transaction information for budget related webhooks.',
    'invalid_account_type'           => 'Egy malacpersely csak eszközszámlákhoz és kötelezettségekhez kapcsolható',
    'unique_currency_code' => 'This currency code is already in use',
    'invalid_account_currency'       => 'Ez a számla nem használja a kiválasztott pénznemet',
    'current_amount_too_much'        => 'The combined amount in "current_amount" cannot exceed the "target_amount".',
    'filter_must_be_in'              => '":filter" szűrő ezek egyike kell legyen: :values',
    'filter_not_string'              => 'Filter ":filter" is expected to be a string of text',
    'bad_api_filter'                 => 'Ez az API végpont nem támogatja ":filter"-t szűrőként.',
    'nog_logged_in'                  => 'Nincs bejelentkezve.',
    'prohibited'                     => 'You must not submit anything in field.',
    'bad_webhook_combination'        => 'Webhook trigger ":trigger" cannot be combined with webhook response ":response".',
    'unknown_webhook_trigger'        => 'Unknown webhook trigger ":trigger".',
    'only_any_trigger'               => 'If you select the "Any event"-trigger, you may not select any other triggers.',
    'bad_type_source'                => 'A Firefly III nem tudja eldönteni a tranzakció típusát a forrásszámla alapján.',
    'bad_type_destination'           => 'A Firefly III nem tudja eldönteni a tranzakció típusát a célszámla alapján.',
    'missing_where'                  => 'Array is missing "where"-clause',
    'missing_update'                 => 'Array is missing "update"-clause',
    'invalid_where_key'              => 'JSON contains an invalid key for the "where"-clause',
    'invalid_update_key'             => 'JSON contains an invalid key for the "update"-clause',
    'invalid_query_data'             => 'Érvénytelen érték van a lekérdezés %s:%s mezőjében.',
    'invalid_query_account_type'     => 'A lekérdezés különböző típusú számlákat tartalmaz, ami nem megengedett.',
    'invalid_query_currency'         => 'A lekérdezés olyan számlákat tartalmaz, amelyek különböző pénznembeállításokkal rendelkeznek, ami nem megengedett.',
    'iban'                           => 'Ez nem egy érvényes IBAN számlaszám.',
    'zero_or_more'                   => 'Az érték nem lehet negatív.',
    'more_than_zero'                 => 'Az értéknek nagyobbnak kell lennie nullánál.',
    'more_than_zero_correct'         => 'Az érték nulla vagy nagyobb lehet.',
    'no_asset_account'               => 'Ez nem egy eszközszámla.',
    'date_or_time'                   => 'Az értéknek érvényes dátum vagy időformátumúnak kell lennie (ISO 8601).',
    'source_equals_destination'      => 'A forrásszámla egyenlő a célszámlával.',
    'unique_account_number_for_user' => 'Úgy tűnik, hogy ez a számlaszám már használatban van.',
    'unique_user_group_for_user'     => 'Úgy tűnik, hogy ez az adminisztratív cím már használatban van.',
    'unique_iban_for_user'           => 'Úgy tűnik, hogy ez a számlaszám már használatban van.',
    'reconciled_forbidden_field'     => 'Ez a tranzakció már egyeztetve lett, ":field" nem módosítható',
    'deleted_user'                   => 'Biztonsági megkötések miatt ezzel az email címmel nem lehet regisztrálni.',
    'rule_trigger_value'             => 'Ez az érték érvénytelen a kiválasztott eseményindítóhoz.',
    'rule_action_expression'         => 'Érvénytelen kifejezés. :error',
    'rule_action_value'              => 'Ez az érték érvénytelen a kiválasztott művelethez.',
    'file_already_attached'          => 'A feltöltött ":name" fájl már csatolva van ehhez az objektumhoz.',
    'file_attached'                  => '":name" fájl sikeresen feltöltve.',
    'file_zero'                      => 'A fájl mérete 0 bájt.',
    'must_exist'                     => 'Az ID mező :attribute nem létezik az adatbázisban.',
    'all_accounts_equal'             => 'Ebben a mezőben minden számlának meg kell egyeznie.',
    'group_title_mandatory'          => 'A csoportcím kötelező ha egynél több tranzakció van.',
    'transaction_types_equal'        => 'Minden felosztásnak ugyanolyan típusúnak kell lennie.',
    'invalid_transaction_type'       => 'Érvénytelen tranzakciótípus.',
    'invalid_selection'              => 'Érvénytelen kiválasztás.',
    'belongs_user'                   => 'Ez az érték egy olyan objektumhoz van kapcsolva ami úgy tűnik nem létezik.',
    'belongs_user_or_user_group'     => 'Ez az érték egy olyan objektumhoz kapcsolódik, amely úgy tűnik, hogy nem létezik a jelenlegi pénzügyi adminisztrációban.',
    'no_access_group'                => 'A felhasználónak nincs hozzáférése ehhez az adminisztrációhoz.',
    'no_accepted_roles_defined'      => 'Ehhez a végponthoz nem definiáltak hozzáférési szerepköröket, hozzáférés megtagadva.',
    'at_least_one_transaction'       => 'Legalább egy tranzakció szükséges.',
    'recurring_transaction_id'       => 'Legalább egy tranzakció szükséges.',
    'need_id_to_match'               => 'You need to submit this entry with an ID for the API to be able to match it.',
    'too_many_unmatched'             => 'Too many submitted transactions cannot be matched to their respective database entries. Make sure existing entries have a valid ID.',
    'id_does_not_match'              => 'Submitted ID #:id does not match expected ID. Make sure it matches or omit the field.',
    'at_least_one_repetition'        => 'Legalább egy ismétlés szükséges.',
    'require_repeat_until'           => 'Legalább egy ismétlésszám vagy egy végdátum (repeat_until) kötelező. Csak az egyik.',
    'require_currency_info'          => 'Ennek a mezőnek a tartalma érvénytelen pénznem információ nélkül.',
    'require_currency_id_code'       => 'Please set either "transaction_currency_id" or "transaction_currency_code".',
    'not_transfer_account'           => 'Ez a fiók nem használható fel tranzakciókhoz.',
    'require_currency_amount'        => 'Ennek a mezőnek a tartalma érvénytelen devizanem információ nélkül.',
    'require_foreign_currency'       => 'Ebben a mezőben egy számot kell megadnia',
    'require_foreign_dest'           => 'A mező értékének meg kell egyeznie a célszámla pénznemével.',
    'require_foreign_src'            => 'A mező értékének meg kell egyeznie a forrásszámla pénznemével.',
    'equal_description'              => 'A tranzakció leírása nem egyezhet meg a globális leírással.',
    'file_invalid_mime'              => '":name" fájl ":mime" típusú ami nem lehet új feltöltés.',
    'file_too_large'                 => '":name" fájl túl nagy.',
    'belongs_to_user'                => ':attribute értéke ismeretlen.',
    'accepted'                       => ':attribute attribútumot el kell fogadni.',
    'bic'                            => 'Ez nem egy érvényes BIC.',
    'at_least_one_trigger'           => 'A szabályban legalább egy eseményindítónak lennie kell.',
    'at_least_one_active_trigger'    => 'A szabályban legalább egy aktív eseményindítónak lennie kell.',
    'at_least_one_action'            => 'A szabályban legalább egy műveletnek lennie kell.',
    'at_least_one_active_action'     => 'A szabályban legalább egy aktív műveletnek lennie kell.',
    'base64'                         => 'Ez nem érvényes base64 kódolású adat.',
    'model_id_invalid'               => 'A megadott azonosító érvénytelennek tűnik ehhez a modellhez.',
    'less'                           => ':attribute kisebbnek kell lennie 10,000,000-nél',
    'active_url'                     => ':attribute nem egy érvényes URL.',
    'after'                          => ':attribute egy :date utáni dátum kell legyen.',
    'date_after'                     => 'A kezdő dátumnak a befejezési dátum előtt kell lennie.',
    'alpha'                          => ':attribute csak betűket tartalmazhat.',
    'alpha_dash'                     => ':attribute csak számokat, betűket és kötőjeleket tartalmazhat.',
    'alpha_num'                      => ':attribute csak betűket és számokat tartalmazhat.',
    'array'                          => ':attribute egy tömb kell legyen.',
    'unique_for_user'                => ':attribute attribútumhoz már van bejegyzés.',
    'before'                         => ':attribute csak :date előtti dátum lehet.',
    'unique_object_for_user'         => 'A név már használatban van.',
    'unique_account_for_user'        => 'Ez a fióknév már használatban van.',


    'between.numeric'            => ':attribute :min és :max között kell legyen.',
    'between.file'               => ':attribute :min és :max kilobájt között kell legyen.',
    'between.string'             => ':attribute :min és :max karakter között kell legyen.',
    'between.array'              => ':attribute :min és :max elem között kell legyen.',
    'between_date'               => 'The date must be between the given start and end date.',
    'boolean'                    => ':attribute mező csak igaz vagy hamis lehet.',
    'confirmed'                  => 'A :attribute ellenörzés nem egyezik.',
    'date'                       => ':attribute nem egy érvényes dátum.',
    'date_format'                => ':attribute nem egyezik :format formátummal.',
    'different'                  => ':attribute és :other különböző kell legyen.',
    'digits'                     => ':attribute :digits számjegy kell legyen.',
    'digits_between'             => ':attribute :min és :max számjegy között kell legyen.',
    'email'                      => ':attribute érvényes email cím kell legyen.',
    'filled'                     => ':attribute mező kötelező.',
    'exists'                     => 'A kiválasztott :attribute étvénytelen.',
    'image'                      => ':attribute kép kell legyen.',
    'in'                         => 'A kiválasztott :attribute étvénytelen.',
    'integer'                    => ':attribute csak egész szám lehet.',
    'ip'                         => ':attribute érvényes IP cím kell legyen.',
    'json'                       => ':attribute érvényes JSON karakterlánc kell legyen.',
    'max.numeric'                => ':attribute nem lehet nagyobb, mint :max.',
    'max.file'                   => ':attribute nem lehet nagyobb, mint :max kilobájt.',
    'max.string'                 => ':attribute nem lehet nagyobb, mint :max karakter.',
    'max.array'                  => ':attribute nem lehet több, mint :max elem.',
    'mimes'                      => 'A :attribute ilyen fájl típusnak kell lennie: :values.',
    'min.numeric'                => 'A :attribute legalább :min kell lenni.',
    'lte.numeric'                => ':attribute attribútumnak :value értéknél kevesebbnek vagy vele egyenlőnek kell lennie.',
    'min.file'                   => ':attribute legalább :min kilobájt kell legyen.',
    'min.string'                 => ':attribute legalább :min karakter kell legyen.',
    'min.array'                  => ':attribute legalább :min elem kell legyen.',
    'not_in'                     => 'A kiválasztott :attribute étvénytelen.',
    'numeric'                    => ':attribute szám kell legyen.',
    'convert_to_itself'          => 'Cannot store currency exchange rate for ":code", because from and to currency are the same.',
    'invalid_currency_code'      => 'Currency code ":code" is invalid',
    'scientific_notation'        => ':attribute nem használhatja a tudományos jelölést.',
    'numeric_primary'            => 'The primary currency amount must be a number.',
    'numeric_destination'        => 'A cél mennyiségnek számnak kell lennie.',
    'numeric_source'             => 'A forrás mennyiségnek számnak kell lennie.',
    'generic_invalid'            => 'Helytelen érték.',
    'transaction_type_changed'   => 'If you change the type of the transaction, make sure the correct source/destination accounts are set.',
    'regex'                      => ':attribute attribútum formátuma érvénytelen.',
    'required'                   => ':attribute mező kötelező.',
    'required_if'                => ':attribute mező kötelező, ha :other :value.',
    'required_unless'            => ':attribute mező kötelező, kivéve ha :other szerepel itt: :values.',
    'required_with'              => ':attribute attribútum mező kötelező ha jelen van :values.',
    'required_with_all'          => ':attribute attribútum mező kötelező ha jelen van :values.',
    'required_without'           => ':attribute mező kötelező, ha :values nincs jelen.',
    'required_without_all'       => ':attribute mező kötelező, ha :values közül egy sincs jelen.',
    'same'                       => ':attribute és :other meg kell egyezzenek.',
    'size.numeric'               => ':attribute attribútumnak :size méretűnek kell lennie.',
    'amount_min_over_max'        => 'A minimum mennyiség nem lehet nagyobb mint a maximális mennyiség.',
    'size.file'                  => ':attribute :size kilobájt kell legyen.',
    'size.string'                => ':attribute :size karakter kell legyen.',
    'size.array'                 => ':attribute :size elemet kell, hogy tartalmazzon.',
    'unique'                     => ':attribute már foglalt.',
    'string'                     => ':attribute egy karakterlánc kell legyen.',
    'url'                        => ':attribute attribútum formátuma érvénytelen.',
    'timezone'                   => ':attribute érvényes zóna kell legyen.',
    '2fa_code'                   => ':attribute mező érvénytelen.',
    'dimensions'                 => ':attribute attribútum képfelbontása érvénytelen.',
    'distinct'                   => ':attribute mezőben duplikált érték van.',
    'file'                       => ':attribute egy fájl kell legyen.',
    'in_array'                   => ':attribute nem létezik itt: :other.',
    'present'                    => ':attribute mezőnek jelen kell lennie.',
    'amount_zero'                => 'A teljes mennyiség nem lehet nulla.',
    'current_target_amount'      => 'A megadott értéknek kevesebbnek kell lennie, mint a célérték.',
    'unique_piggy_bank_for_user' => 'A malacpersely nevének egyedinek kell lennie.',
    'unique_object_group'        => 'Csoport neve már foglalt',
    'starts_with'                => 'Az értéknek ezzel kell kezdődnie: :values.',
    'unique_webhook'             => 'You already have a webhook with this combination of URL, trigger, response and delivery.',
    'unique_existing_webhook'    => 'You already have another webhook with this combination of URL, trigger, response and delivery.',
    'same_account_type'          => 'Mindkét számlának azonos számlatípusúnak kell lennie',
    'same_account_currency'      => 'Mindkét számlának azonos pénznem beállítással kell rendelkeznie',
    'piggy_no_change_currency'   => 'Nem tudod a számla pénznemét megváltoztatni, mivel perselyek tartoznak hozzá.',


    'secure_password'             => 'This is not a secure password. Please try again. For more information, visit https://bit.ly/FF3-password',
    'valid_recurrence_rep_type'   => 'Érvénytelen ismétléstípus az ismétlődő tranzakciókhoz.',
    'valid_recurrence_rep_moment' => 'Érvénytelen ismétlési időpont ehhez az ismétléstípushoz.',
    'invalid_account_info'        => 'Érvénytelen számlainformáció.',
    'attributes'                  => [
        'email'                   => 'email cím',
        'description'             => 'leírás',
        'amount'                  => 'összeg',
        'transactions.*.amount'   => 'tranzakció összege',
        'name'                    => 'név',
        'piggy_bank_id'           => 'malacpersely azonosító',
        'targetamount'            => 'cél összeg',
        'opening_balance_date'    => 'nyitó egyenleg dátuma',
        'opening_balance'         => 'nyitó egyenleg',
        'match'                   => 'egyezés',
        'amount_min'              => 'minimális összeg',
        'amount_max'              => 'maximális összeg',
        'title'                   => 'cím',
        'tag'                     => 'címke',
        'transaction_description' => 'tranzakció leírása',
        'rule-action-value.1'     => 'szabály művelet érték #1',
        'rule-action-value.2'     => 'szabály művelet érték #2',
        'rule-action-value.3'     => 'szabály művelet érték #3',
        'rule-action-value.4'     => 'szabály művelet érték #4',
        'rule-action-value.5'     => 'szabály művelet érték #5',
        'rule-action.1'           => 'szabály művelet #1',
        'rule-action.2'           => 'szabály művelet #2',
        'rule-action.3'           => 'szabály művelet #3',
        'rule-action.4'           => 'szabály művelet #4',
        'rule-action.5'           => 'szabály művelet #5',
        'rule-trigger-value.1'    => 'szabály eseményindító érték #1',
        'rule-trigger-value.2'    => 'szabály eseményindító érték #2',
        'rule-trigger-value.3'    => 'szabály eseményindító érték #3',
        'rule-trigger-value.4'    => 'szabály eseményindító érték #4',
        'rule-trigger-value.5'    => 'szabály eseményindító érték #5',
        'rule-trigger.1'          => 'szabály eseményindító #1',
        'rule-trigger.2'          => 'szabály eseményindító #2',
        'rule-trigger.3'          => 'szabály eseményindító #3',
        'rule-trigger.4'          => 'szabály eseményindító #4',
        'rule-trigger.5'          => 'szabály eseményindító #5',
    ],

    // validation of accounts:
    'withdrawal_source_need_data' => 'Egy érvényes forrásszámla azonosító és/vagy egy érvényes forrásszámla név kell a folytatáshoz.',
    'withdrawal_source_bad_data'  => '[a] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'withdrawal_dest_need_data'   => '[a] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'withdrawal_dest_bad_data'    => 'Nem található érvényes célszámla ":id" azonosító vagy ":name" név keresésekor.',

    'withdrawal_dest_iban_exists' => 'This destination account IBAN is already in use by an asset account or a liability and cannot be used as a withdrawal destination.',
    'deposit_src_iban_exists'     => 'This source account IBAN is already in use by an asset account or a liability and cannot be used as a deposit source.',

    'reconciliation_source_bad_data' => 'Could not find a valid reconciliation account when searching for ID ":id" or name ":name".',

    'generic_source_bad_data' => '[e] Could not find a valid source account when searching for ID ":id" or name ":name".',

    'deposit_source_need_data' => 'Egy érvényes forrásszámla azonosító és/vagy egy érvényes forrásszámla név kell a folytatáshoz.',
    'deposit_source_bad_data'  => '[b] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'deposit_dest_need_data'   => '[b] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'deposit_dest_bad_data'    => 'Nem található érvényes célszámla ":id" azonosító vagy ":name" név keresésekor.',
    'deposit_dest_wrong_type'  => 'A beküldött célfiók nem megfelelő típusú.',


    'transfer_source_need_data' => 'Egy érvényes forrásszámla azonosító és/vagy egy érvényes forrásszámla név kell a folytatáshoz.',
    'transfer_source_bad_data'  => '[c] Could not find a valid source account when searching for ID ":id" or name ":name".',
    'transfer_dest_need_data'   => '[c] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'transfer_dest_bad_data'    => 'Nem található érvényes célszámla ":id" azonosító vagy ":name" név keresésekor.',
    'need_id_in_edit'           => 'Minden felosztásnak rendelkeznie kell "transaction_journal_id"-val (lehet érvényes érték vagy 0).',

    'ob_source_need_data'           => 'Egy érvényes forrásszámla azonosító és/vagy egy érvényes forrásszámla név kell a folytatáshoz.',
    'lc_source_need_data'           => 'Need to get a valid source account ID to continue.',
    'ob_dest_need_data'             => '[d] Need to get a valid destination account ID and/or valid destination account name to continue.',
    'ob_dest_bad_data'              => 'Nem található érvényes célszámla ":id" azonosító vagy ":name" név keresésekor.',
    'reconciliation_either_account' => 'To submit a reconciliation, you must submit either a source or a destination account. Not both, not neither.',

    'generic_invalid_source'      => 'Nem használhatod ezt a fiókot forrásfiókként.',
    'generic_invalid_destination' => 'Nem használhatod ezt a fiókot célfiókként.',

    'generic_no_source'      => 'You must submit source account information or submit a transaction journal ID.',
    'generic_no_destination' => 'You must submit destination account information or submit a transaction journal ID.',

    'gte.numeric'  => ':attribute attribútumnak :value értéknél nagyobbnak vagy vele egyenlőnek kell lennie.',
    'gt.numeric'   => 'A(z) :attribute nagyobb kell, hogy legyen, mint :value.',
    'gte.file'     => ':attribute attribútumnak :value kilobájtnál nagyobb vagy egyenlőnek kell lennie.',
    'gte.string'   => ':attribute attribútumnak :value karakternél nagyobb vagy egyenlőnek kell lennie.',
    'gte.array'    => 'A(z) :attribute legalább :value elemet kell, hogy tartalmazzon.',
    'missing_with' => ':attribute nem kombinálható másik mezővel.',

    'amount_required_for_auto_budget' => 'Az összeg kötelező.',
    'auto_budget_amount_positive'     => 'Az értéknek nagyobbnak kell lennie nullánál.',

    'auto_budget_period_mandatory' => 'Az auto költségvetési periódus kötelező mező.',

    // no access to administration:
    'no_auth_user_group'           => 'Ennek az adminisztrációnak az eléréséhez be kell jelentkezni.',
    'no_access_user_group'         => 'Nincsenek meg a megfelelő hozzáférési jogok ehhez az adminisztrációhoz.',
    'administration_owner_rename'  => 'A sztenderd adminisztrációt nem lehet átnevezni.',
    'existing_mfa_code'            => 'Érvényes kódot kell megadni',
];
