<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => '閉じる',
    'actions'                                   => '操作',
    'edit'                                      => '編集',
    'loading'                                   => '読込中',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => '削除',
    'split'                                     => '分割',
    'single_split'                              => '分割',
    'clone'                                     => '複製',
    'clone_and_edit'                            => '複製と編集',
    'confirm_action'                            => '操作を確認',
    'last_seven_days'                           => '過去7日間',
    'last_thirty_days'                          => '過去30日間',
    'last_180_days'                             => '過去180日間',
    'month_to_date'                             => '過去1ヶ月',
    'year_to_date'                              => '過去1年間',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => '概要',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => '全て',
    'today'                                     => '今日',
    'customRange'                               => '期間を指定',
    'date_range'                                => '対象期間',
    'apply'                                     => '適用',
    'select_date'                               => '日付を選択...',
    'cancel'                                    => 'キャンセル',
    'from'                                      => '引き出し元',
    'to'                                        => 'へ',
    'structure'                                 => '構成',
    'help_translating'                          => 'このヘルプ文章はまだあなたの言語で利用可能ではありません。<a href="https://crowdin.com/project/firefly-iii-help">翻訳を手伝っていただけますか？</a>',
    'showEverything'                            => 'すべてを表示',
    'never'                                     => 'なし',
    'no_results_for_empty_search'               => '検索条件が空なので、何も見つかりませんでした。',
    'removed_amount'                            => ':amount 削除しました',
    'added_amount'                              => ':amount 追加しました',
    'asset_account_role_help'                   => '追加設定は後で設定することができます。',
    'Opening balance'                           => '開始残高',
    'create_new_stuff'                          => '新しく作成する',
    'new_withdrawal'                            => '新しい出金',
    'create_new_transaction'                    => '新しい取引を作成',
    'sidebar_frontpage_create'                  => '作成',
    'new_transaction'                           => '新しい取引',
    'no_rules_for_bill'                         => 'この購読に関連付けられたルールがありません。',
    'go_to_asset_accounts'                      => '資産勘定を見る',
    'go_to_budgets'                             => '予算へ移動',
    'go_to_withdrawals'                         => '出金に移動',
    'clones_journal_x'                          => 'この取引は「:description」 (#:id) の複製です。',
    'go_to_categories'                          => 'カテゴリへ移動',
    'go_to_bills'                               => 'Go to your subscriptions',
    'go_to_expense_accounts'                    => '支出口座を見る',
    'go_to_revenue_accounts'                    => '収入口座を見る',
    'go_to_piggies'                             => '貯金箱へ移動',
    'new_deposit'                               => '新しい入金',
    'new_transfer'                              => '新しい送金',
    'new_transfers'                             => '新しい送金',
    'new_asset_account'                         => '新しい資産勘定',
    'new_expense_account'                       => '新しい支出口座',
    'new_revenue_account'                       => '新しい収入口座',
    'new_liabilities_account'                   => '新しい債務',
    'new_budget'                                => '新しい予算',
    'new_bill'                                  => '新しい購読',
    'block_account_logout'                      => 'あなたはログアウトしました。ブロックされたアカウントはこのサイトを使うことが出来ません。有効なメールアドレスで登録しましたか？',
    'flash_success'                             => '成功しました！',
    'flash_info'                                => 'メッセージ',
    'flash_warning'                             => '警告！',
    'flash_error'                               => 'エラー！',
    'flash_danger'                              => '危険！',
    'flash_info_multiple'                       => '1件のメッセージがあります|:count 件のメッセージがあります',
    'flash_error_multiple'                      => '1件のエラーがあります|:count 件のエラーがあります',
    'net_worth'                                 => '純資産',
    'help_for_this_page'                        => 'このページのヘルプ',
    'help_for_this_page_body'                   => 'こちらのページの詳細は<a href="https://docs.firefly-iii.org/">ドキュメント</a>をご覧ください。',
    'two_factor_welcome'                        => 'こんにちは！',
    'two_factor_enter_code'                     => '続行するには、2要素認証コードを入力してください。あなたのアプリケーションが生成してくれます。',
    'two_factor_code_here'                      => 'コードを入力',
    'two_factor_title'                          => '2要素認証',
    'authenticate'                              => '認証',
    'two_factor_forgot_title'                   => '2要素認証を紛失',
    'two_factor_forgot'                         => '2要素認証端末を忘れてしまいました。',
    'two_factor_lost_header'                    => '2要素認証を紛失しましたか？',
    'two_factor_lost_intro'                     => 'バックアップコードも紛失してしまった場合、Webから修正する方法はありません。２つから選ぶことができます。',
    'two_factor_lost_fix_self'                  => 'If you run your own instance of Firefly III, read <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">this entry in the FAQ</a> for instructions.',
    'two_factor_lost_fix_owner'                 => 'または、サイト管理者 <a href="mailto::site_owner">:site_owner</a> に連絡して2要素認証をリセットしてもらうよう頼んでください。',
    'mfa_backup_code'                           => 'あなたはバックアップコードを利用してログインしました。もし再び使用することが出来ないなら、リストから削除してください。',
    'pref_two_factor_new_backup_codes'          => '新しいバックアップコードを取得',
    'pref_two_factor_backup_code_count'         => ':count 個の有効なバックアップコードがあります。|:count 個の有効なバックアップコードがあります。',
    '2fa_i_have_them'                           => '保存しました！',
    'warning_much_data'                         => ':days日間のデータは読み込みに時間を要す場合があります。',
    'registered'                                => '登録に成功しました！',
    'Default asset account'                     => '既定の資産勘定',
    'no_budget_pointer'                         => 'まだ予算を立てていないようです。<a href="/budgets">予算</a>ページで作成してください。予算は支出の把握に役立ちます。',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => '貯蓄口座',
    'Credit card'                               => 'クレジットカード',
    'source_accounts'                           => '引き出し元口座|引き出し元口座',
    'destination_accounts'                      => '預け入れ先口座|預け入れ先口座',
    'user_id_is'                                => 'あなたのユーザーIDは <strong>:user</strong> です',
    'field_supports_markdown'                   => 'この欄は<a href="https://en.support.wordpress.com/markdown-quick-reference/">マークダウン</a>をサポートしています。',
    'need_more_help'                            => 'もしFirefly IIIの使用に当たってヘルプが必要なら、<a href="https://github.com/firefly-iii/firefly-iii/issues">Githubでチケットを開いてください</a>。',
    'reenable_intro_text'                       => '<a href="#" id="reenableGuidance">導入ガイダンス</a>を再度有効にすることもできます。',
    'intro_boxes_after_refresh'                 => '説明は再読込後に再び表示されます。',
    'show_all_no_filter'                        => 'すべての取引を日付でまとめずに表示します。',
    'expenses_by_category'                      => 'カテゴリ別支出',
    'expenses_by_budget'                        => '予算別支出',
    'income_by_category'                        => 'カテゴリ別収入',
    'expenses_by_asset_account'                 => '資産勘定による支出',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly IIIはあなたを正しいページにリダイレクトすることができませんでした。申し訳ありません。',
    'sum_of_expenses'                           => '合計支出',
    'sum_of_income'                             => '合計収入',
    'liabilities'                               => '負債',
    'spent_in_specific_budget'                  => '予算":budget"の支出',
    'spent_in_specific_double'                  => '口座「:account」での支出',
    'earned_in_specific_double'                 => '口座「:account」での収入',
    'source_account'                            => '引き出し口座',
    'source_account_reconciliation'             => '引き出し口座の取引照合を編集することはできません。',
    'destination_account'                       => '預け入れ口座',
    'destination_account_reconciliation'        => '預け入れ口座の取引照合を編集することはできません。',
    'sum_of_expenses_in_budget'                 => '予算":budget"の合計支出',
    'left_in_budget_limit'                      => '予算による支出残高',
    'current_period'                            => '現在の期間',
    'show_the_current_period_and_overview'      => '現在の期間と概要を見る',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => '英語以外の言語で正しく動作させるには、あなたのOSが正しいロケール情報を持っている必要があります。利用できない場合は、通貨データ、日付、金額が正しく表示されない可能性があります。',
    'budget_in_period'                          => '予算「:name」の :start から :end までのすべての取引の通貨 :currency のチャート',
    'chart_budget_in_period'                    => '予算「:name」の :start から :end までのすべての取引の通貨 :currency のチャート',
    'chart_budget_in_period_only_currency'      => ':currency で予算計上されたため、このチャートは :currency での取引のみ表示されます。',
    'chart_account_in_period'                   => '口座「:name」(:balance) における :start から :end までのすべての取引のチャート',
    'chart_category_in_period'                  => '「:name」カテゴリの :start から :end までのすべての取引のチャート',
    'chart_category_all'                        => 'カテゴリ「:name」のすべての取引のチャート',
    'clone_withdrawal'                          => '出金を複製',
    'clone_deposit'                             => '入金を複製',
    'clone_transfer'                            => '送金を複製',
    'multi_select_no_selection'                 => '選択されていません',
    'multi_select_select_all'                   => 'すべてを選択',
    'multi_select_n_selected'                   => '選択済み',
    'multi_select_all_selected'                 => 'すべて選択済み',
    'multi_select_filter_placeholder'           => '検索…',
    'intro_next_label'                          => '次へ',
    'intro_prev_label'                          => '前へ',
    'intro_skip_label'                          => 'スキップ',
    'intro_done_label'                          => '完了',
    'between_dates_breadcrumb'                  => ':start から :end まで',
    'all_journals_without_budget'               => '予算外のすべての取引',
    'journals_without_budget'                   => '予算外のすべての取引',
    'all_journals_without_category'             => 'カテゴリを除いたすべての取引',
    'journals_without_category'                 => 'カテゴリを除いた取引',
    'all_journals_for_account'                  => '口座「:name」のすべての取引',
    'chart_all_journals_for_account'            => '口座「:name」のすべての取引のチャート',
    'journals_in_period_for_account'            => '口座「:name」の :start から :end までのすべての取引',
    'journals_in_period_for_account_js'         => '{start} から {end} までの口座 {title} のすべての取引',
    'transferred'                               => '送金済み',
    'all_withdrawal'                            => 'すべての支出',
    'all_transactions'                          => 'すべての取引',
    'title_withdrawal_between'                  => ':startから:endまでのすべての支出',
    'all_deposit'                               => 'すべての収入',
    'title_deposit_between'                     => ':start から :end までのすべての収入',
    'all_transfers'                             => 'すべての送金',
    'title_transfers_between'                   => ':start から :end までのすべての送金',
    'all_transfer'                              => 'すべての送金',
    'all_journals_for_tag'                      => '":tag"タグのついたすべての取引',
    'title_transfer_between'                    => ':start から :end までのすべての送金',
    'all_journals_for_category'                 => 'カテゴリ「:name」のすべての取引',
    'all_journals_for_budget'                   => '":name"予算のすべての取引',
    'chart_all_journals_for_budget'             => '":name"予算のすべての取引のチャート',
    'journals_in_period_for_category'           => 'カテゴリ「:name」の :start から :end までのすべての取引',
    'journals_in_period_for_tag'                => 'タグ「:tag」のある :start から :end までのすべての取引',
    'not_available_demo_user'                   => 'あなたがアクセスしようとした機能はデモユーザーではご利用になれません。',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => '引き出し資産口座「@source_name」は @source_currency の取引のみ受け付けます。 宛先資産口座「@dest_name」は @dest_currency でのみ取引を受け付けます。両方の通貨で正しく送金額を入力する必要があります。',
    'transaction_data'                          => '取引データ',
    'invalid_server_configuration'              => '無効なサーバー構成',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'クイックスイッチ',
    'sign_in_to_start'                          => 'サインインしてセッションを開始',
    'sign_in'                                   => 'サインイン',
    'register_new_account'                      => '新しいアカウントを登録',
    'forgot_my_password'                        => 'パスワードを忘れました',
    'problems_with_input'                       => '入力に問題が発生しました。',
    'reset_password'                            => 'パスワードをリセット',
    'button_reset_password'                     => 'パスワードをリセット',
    'reset_button'                              => 'リセット',
    'want_to_login'                             => 'ログインする',
    'login_page_title'                          => 'Firefly III にログイン',
    'register_page_title'                       => 'Firefly IIIに登録する',
    'forgot_pw_page_title'                      => 'Firefly III のパスワードを忘れました',
    'reset_pw_page_title'                       => 'Firefly III のパスワードをリセットする',
    'cannot_reset_demo_user'                    => 'デモユーザーのパスワードはリセットできません。',
    'no_att_demo_user'                          => 'デモユーザーは添付ファイルをアップロードできません。',
    'button_register'                           => '登録',
    'authorization'                             => '認証',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => '一日当たりの予想費用',
    'per_period_sum_1W'                         => '週当たりの予想費用',
    'per_period_sum_1M'                         => '月当たりの予想費用',
    'per_period_sum_3M'                         => '四半期当たりの予想費用',
    'per_period_sum_6M'                         => '半期当たりの予想費用',
    'per_period_sum_1Y'                         => '年あたりの予想費用',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => '予想合計',
    'reconciliation_account_name'               => ':name 照合 (:currency)',
    'saved'                                     => '保存しました。',
    'advanced_options'                          => '高度な設定',
    'advanced_options_explain'                  => 'Firefly III のいくつかのページにはこのボタンの後ろに高度なオプションがあります。このページには何もありませんが、他のページをチェックしてください！',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhook',
    'webhooks_breadcrumb'                       => 'Webhook',
    'webhooks_menu_disabled'                    => '無効',
    'no_webhook_messages'                       => 'Webhookメッセージはありません',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => '取引作成後',
    'webhook_trigger_UPDATE_TRANSACTION'        => '取引更新後',
    'webhook_trigger_DESTROY_TRANSACTION'       => '取引削除後',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => '取引詳細',
    'webhook_response_ACCOUNTS'                 => '口座詳細',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => '詳細確認',
    'create_new_webhook'                        => 'Webhookを作成',
    'webhooks_create_breadcrumb'                => 'Webhookを作成',
    'webhook_trigger_form_help'                 => 'Webhookがトリガーするイベントです',
    'webhook_response_form_help'                => 'WebhookがURLに送信するものです。',
    'webhook_delivery_form_help'                => 'Webhookがデータを配信するフォーマットです。',
    'webhook_active_form_help'                  => 'Webhookは有効である必要があります。でなければ呼び出されません。',
    'stored_new_webhook'                        => 'Webhook「:title」が保存されました',
    'delete_webhook'                            => 'Webhookを削除する',
    'deleted_webhook'                           => 'Webhook「:title」が削除されました',
    'edit_webhook'                              => 'Webhook「:title」を編集',
    'updated_webhook'                           => 'Webhook「:title」が更新されました',
    'edit_webhook_js'                           => 'Webhook「{title}」を編集',
    'show_webhook'                              => 'Webhook「:title」',
    'webhook_was_triggered'                     => '指定された取引でWebhookがトリガーされました。結果が表示されるまでお待ちください。',
    'webhook_messages'                          => 'Webhookメッセージ',
    'view_message'                              => 'メッセージを見る',
    'view_attempts'                             => '失敗した試行の表示',
    'message_content_title'                     => 'Webhookメッセージの内容',
    'message_content_help'                      => 'このWebhookを使用して送信（または送信試行）されたメッセージの内容です。',
    'attempt_content_title'                     => 'Webhookの試行',
    'attempt_content_help'                      => '設定されたURLに送信するWebhookメッセージの試みはすべて失敗しました。しばらくするとFirefly IIIは試行を停止します。',
    'no_attempts'                               => '失敗した試行はありません。これは良いことです！',
    'webhook_attempt_at'                        => '{moment} に試行',
    'logs'                                      => 'ログ',
    'response'                                  => 'レスポンス',
    'visit_webhook_url'                         => 'WebhookのURLを開く',
    'reset_webhook_secret'                      => 'Webhookのシークレットをリセット',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> が保存されました。',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> が更新されました。',

    // API access
    'authorization_request'                     => 'Firefly III v:version 認証要求',
    'authorization_request_intro'               => '<strong>:client</strong>はあなたの資産情報管理の権限を要求しています。<strong>:client</strong>に情報へのアクセスを許可しますか？',
    'authorization_request_site'                => '<code>:url</code> にリダイレクトされ、Firefly III データにアクセスできます。',
    'authorization_request_invalid'             => 'このアクセスリクエストは無効です。今後はこのリンクを利用しないでください。',
    'scopes_will_be_able'                       => 'このアプリケーションは次のことができます：',
    'button_authorize'                          => '許可する',
    'none_in_select_list'                       => '(なし)',
    'no_piggy_bank'                             => '(貯金箱がありません)',
    'name_in_currency'                          => '通貨 ":name" を編集する',
    'paid_in_currency'                          => ':currency で支払い済み',
    'unpaid_in_currency'                        => ':currency で未払い',
    'is_alpha_warning'                          => 'あなたはアルファバージョンを使用しています。バグや問題に注意してください。',
    'is_beta_warning'                           => 'あなたはベータバージョンを使用しています。バグや問題に注意してください。',
    'all_destination_accounts'                  => '預け入れ口座',
    'all_source_accounts'                       => '引き出し口座',
    'back_to_index'                             => 'インデックスに戻る',
    'cant_logout_guard'                         => 'Firefly III からログアウトできません。',
    'internal_reference'                        => '内部参照',

    // check for updates:
    'update_check_title'                        => 'アップデートを確認',
    'admin_update_check_title'                  => 'アップデートを自動的に確認',
    'admin_update_check_explain'                => 'Firefly III は自動的にアップデートを確認できます。 この設定を有効にすると、Firefly III アップデートサーバーに問い合わせ、新しいバージョンの Firefly III が利用可能かどうかを確認し、もしあれば通知が届きます。右のボタンでこの通知をテストできます。 Firefly III でアップデートを確認したい場合は、以下を指定してください。',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => '後で確認する',
    'updates_do_not_check'                      => 'アップデートを確認しない',
    'updates_enable_check'                      => 'アップデートの確認を有効にする',
    'admin_update_check_now_title'              => '今すぐアップデートを確認',
    'admin_update_check_now_explain'            => 'ボタンを押すと、Firefly III が最新バージョンかどうかを確認します。',
    'check_for_updates_button'                  => '今すぐ確認',
    'update_new_version_alert'                  => 'Firefly III の新しいバージョンが利用可能です。あなたは現在 :your_version を実行していますが、最新バージョンは :date にリリースされた :new_version です。',
    'update_version_beta'                       => 'このバージョンはベータ版です。問題が発生する可能性があります。',
    'update_version_alpha'                      => 'このバージョンはアルファ版です。問題が発生する可能性があります。',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => '最新のリリースである :version を利用しています。',
    'update_newer_version_alert'                => '最新の :new_version よりも新しい :your_version を利用しています。',
    'update_check_error'                        => 'アップデートの確認中にエラーが発生しました: :error',
    'unknown_error'                             => '不明なエラーです。申し訳ありません。',
    'disabled_but_check'                        => 'アップデートのチェックを無効にしました。時々自分で更新を確認することを忘れないでください。よろしくおねがいします。',
    'admin_update_channel_title'                => 'アップデートチャンネル',
    'admin_update_channel_explain'              => 'Firefly III には、機能追加、機能改善、不具合をどれくらい先取りするかを決める3つのアップデートチャンネルがあります。 あなたが冒険好きならば、「ベータ」チャンネルを使用してください。危うい生活をしたいときは、「アルファ」を使用してください。',
    'update_channel_stable'                     => '安定。すべてが期待通りに動作するはずです。',
    'update_channel_beta'                       => 'ベータ。新しい機能がありますが、不安定かもしれません。',
    'update_channel_alpha'                      => 'アルファ。私たちは何でも投入し、使います。',

    // search
    'search'                                    => '検索',
    'search_query'                              => 'クエリ',
    'search_found_transactions'                 => 'Firefly III は :count 件の取引を :time 秒で見つけました。|Firefly III は :count 件の取引を :time 秒で見つけました。',
    'search_found_more_transactions'            => 'Firefly III は :count 件以上の取引を :time 秒で見つけました。',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'これらの検索条件は無効であり、無視されています。',

    // old


    'search_modifier_date_on'                             => '取引日が「:value」',
    'search_modifier_not_date_on'                         => '取引日が「:value」ではない',
    'search_modifier_reconciled'                          => '照合済みの取引',
    'search_modifier_not_reconciled'                      => '照合されていない取引',
    'search_modifier_id'                                  => '取引IDが「:value」',
    'search_modifier_not_id'                              => '取引IDが「:value」ではない',
    'search_modifier_date_before'                         => '取引日が「:value」以前',
    'search_modifier_date_after'                          => '取引日が「:value」以降',
    'search_modifier_external_id_is'                      => '外部IDが「:value」',
    'search_modifier_not_external_id_is'                  => '外部IDが「:value」ではない',
    'search_modifier_no_external_url'                     => '外部URLがない取引',
    'search_modifier_no_external_id'                      => '外部IDがない取引',
    'search_modifier_not_any_external_url'                => '外部URLがない取引',
    'search_modifier_not_any_external_id'                 => '外部IDがない取引',
    'search_modifier_any_external_url'                    => '外部URLがある取引',
    'search_modifier_any_external_id'                     => '外部IDがない取引',
    'search_modifier_not_no_external_url'                 => '外部URLがある取引',
    'search_modifier_not_no_external_id'                  => '外部IDがある取引',
    'search_modifier_internal_reference_is'               => '内部参照が「:value」',
    'search_modifier_not_internal_reference_is'           => '内部参照が「:value」ではない',
    'search_modifier_description_starts'                  => '概要が「:value」で始まる',
    'search_modifier_not_description_starts'              => '概要が「:value」で始まらない',
    'search_modifier_description_ends'                    => '概要が「:value」で終わる',
    'search_modifier_not_description_ends'                => '概要が「:value」で終わらない',
    'search_modifier_description_contains'                => '概要に「:value」を含む',
    'search_modifier_not_description_contains'            => '概要が「:value」を含まない',
    'search_modifier_description_is'                      => '概要が「:value」と一致する',
    'search_modifier_not_description_is'                  => '概要が「:value」と一致しない',
    'search_modifier_currency_is'                         => '取引 (外国) 通貨が「:value」',
    'search_modifier_not_currency_is'                     => '取引 (外国) 通貨が「:value」ではない',
    'search_modifier_foreign_currency_is'                 => '取引外国通貨が「:value」',
    'search_modifier_not_foreign_currency_is'             => '取引 (外国) 通貨が「:value」ではない',
    'search_modifier_has_attachments'                     => '一つの添付ファイルがある取引',
    'search_modifier_has_no_category'                     => 'カテゴリに属していない取引',
    'search_modifier_not_has_no_category'                 => '一つ以上のカテゴリに属する取引',
    'search_modifier_not_has_any_category'                => 'カテゴリに属していない取引',
    'search_modifier_has_any_category'                    => '一つ以上のカテゴリに属する取引',
    'search_modifier_has_no_budget'                       => '予算外の取引',
    'search_modifier_not_has_any_budget'                  => '予算外の取引',
    'search_modifier_has_any_budget'                      => '予算がある取引',
    'search_modifier_not_has_no_budget'                   => '予算がある取引',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'タグがない取引',
    'search_modifier_not_has_any_tag'                     => 'タグがない取引',
    'search_modifier_not_has_no_tag'                      => 'タグがある取引',
    'search_modifier_has_any_tag'                         => 'タグがある取引',
    'search_modifier_notes_contains'                      => '備考に「:value」を含む取引',
    'search_modifier_not_notes_contains'                  => '備考に「:value」を含まない取引',
    'search_modifier_notes_starts'                        => '備考が「:value」で始まる取引',
    'search_modifier_not_notes_starts'                    => '備考が「:value」で始まらない取引',
    'search_modifier_notes_ends'                          => '備考が「:value」で終わる取引',
    'search_modifier_not_notes_ends'                      => '備考が「:value」で終わらない取引',
    'search_modifier_notes_is'                            => '備考が「:value」と一致する取引',
    'search_modifier_not_notes_is'                        => '備考が「:value」と一致しない取引',
    'search_modifier_no_notes'                            => '備考がない取引',
    'search_modifier_not_no_notes'                        => '備考がある取引',
    'search_modifier_any_notes'                           => '備考がある取引',
    'search_modifier_not_any_notes'                       => '備考がない取引',
    'search_modifier_amount_is'                           => '金額が「:value」と一致',
    'search_modifier_not_amount_is'                       => '金額が「:value」ではない',
    'search_modifier_amount_less'                         => '金額が「:value」以下',
    'search_modifier_not_amount_more'                     => '金額が「:value」以下',
    'search_modifier_amount_more'                         => '金額が「:value」以上',
    'search_modifier_not_amount_less'                     => '金額が「:value」以上',
    'search_modifier_source_account_is'                   => '引き出し口座名が「:value」と一致',
    'search_modifier_not_source_account_is'               => '引き出し口座名が「:value」ではない',
    'search_modifier_source_account_contains'             => '引き出し口座名に「:value」を含む',
    'search_modifier_not_source_account_contains'         => '引き出し口座名が「:value」を含まない',
    'search_modifier_source_account_starts'               => '引き出し口座名が「:value」で始まる',
    'search_modifier_not_source_account_starts'           => '引き出し口座名が「:value」で始まらない',
    'search_modifier_source_account_ends'                 => '引き出し口座名が「:value」で終わる',
    'search_modifier_not_source_account_ends'             => '引き出し口座名が「:value」で終わらない',
    'search_modifier_source_account_id'                   => '引き出し口座IDが「:value」',
    'search_modifier_not_source_account_id'               => '引き出し口座IDが「:value」ではない',
    'search_modifier_source_account_nr_is'                => '引き出し口座番号（IBAN）が「:value」',
    'search_modifier_not_source_account_nr_is'            => '引き出し口座番号（IBAN）が「:value」ではない',
    'search_modifier_source_account_nr_contains'          => '引き出し口座番号（IBAN）に「:value」を含む',
    'search_modifier_not_source_account_nr_contains'      => '引き出し口座番号（IBAN）が「:value」を含まない',
    'search_modifier_source_account_nr_starts'            => '引き出し口座番号（IBAN）が「:value」で始まる',
    'search_modifier_not_source_account_nr_starts'        => '引き出し口座番号（IBAN）が「:value」で始まらない',
    'search_modifier_source_account_nr_ends'              => '引き出し口座番号（IBAN）が「:value」で終わる',
    'search_modifier_not_source_account_nr_ends'          => '引き出し口座番号（IBAN）が「:value」で終わらない',
    'search_modifier_destination_account_is'              => '預け入れ口座名が「:value」と一致する',
    'search_modifier_not_destination_account_is'          => '預け入れ口座名が「:value」ではない',
    'search_modifier_destination_account_contains'        => '預け入れ口座名に「:value」を含む',
    'search_modifier_not_destination_account_contains'    => '預け入れ口座名が「:value」を含まない',
    'search_modifier_destination_account_starts'          => '預け入れ口座名が「:value」で始まる',
    'search_modifier_not_destination_account_starts'      => '預け入れ口座名が「:value」で始まらない',
    'search_modifier_destination_account_ends'            => '預け入れ口座名が「:value」で終わる',
    'search_modifier_not_destination_account_ends'        => '預け入れ口座名が「:value」で終わらない',
    'search_modifier_destination_account_id'              => '預け入れ口座IDが「:value」',
    'search_modifier_not_destination_account_id'          => '預け入れ口座IDが「:value」ではない',
    'search_modifier_destination_is_cash'                 => '預け入れ口座が現金口座',
    'search_modifier_not_destination_is_cash'             => '預け入れ口座が現金口座ではない',
    'search_modifier_source_is_cash'                      => '引き出し口座が現金口座',
    'search_modifier_not_source_is_cash'                  => '引き出し口座が現金口座ではない',
    'search_modifier_destination_account_nr_is'           => '預け入れ口座番号（IBAN）が「:value」',
    'search_modifier_not_destination_account_nr_is'       => '預け入れ口座番号（IBAN）が「:value」',
    'search_modifier_destination_account_nr_contains'     => '預け入れ口座番号（IBAN）が「:value」を含む',
    'search_modifier_not_destination_account_nr_contains' => '預け入れ口座番号（IBAN）が「:value」を含まない',
    'search_modifier_destination_account_nr_starts'       => '預け入れ口座番号（IBAN）が「:value」で始まる',
    'search_modifier_not_destination_account_nr_starts'   => '預け入れ口座番号（IBAN）が「:value」で始まらない',
    'search_modifier_destination_account_nr_ends'         => '預け入れ口座番号（IBAN）が「:value」で終わる',
    'search_modifier_not_destination_account_nr_ends'     => '預け入れ口座番号（IBAN）が「:value」で終わらない',
    'search_modifier_account_id'                          => '引き出し口座または預け入れ口座IDが「:value」',
    'search_modifier_not_account_id'                      => '引き出し口座または預け入れ口座IDが「:value」ではない',
    'search_modifier_category_is'                         => 'カテゴリが「:value」',
    'search_modifier_not_category_is'                     => 'カテゴリが「:value」ではない',
    'search_modifier_budget_is'                           => '予算名が「:value」',
    'search_modifier_not_budget_is'                       => '予算名が「:value」ではない',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => '取引種別が「:value」',
    'search_modifier_not_transaction_type'                => '取引種別が「:value」ではない',
    'search_modifier_tag_is'                              => 'タグが「:value」',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'タグ「:value」がない',
    'search_modifier_date_on_year'                        => '「:value」年の取引',
    'search_modifier_not_date_on_year'                    => '「:value」年の取引ではない',
    'search_modifier_date_on_month'                       => '「:value」月の取引',
    'search_modifier_not_date_on_month'                   => '「:value」月の取引ではない',
    'search_modifier_date_on_day'                         => '「:value」日の取引',
    'search_modifier_not_date_on_day'                     => '「:value」日の取引ではない',
    'search_modifier_date_before_year'                    => ':value年以前または年内の取引',
    'search_modifier_date_before_month'                   => ':value月以前または月内の取引',
    'search_modifier_date_before_day'                     => '「:value」日より前の取引',
    'search_modifier_date_after_year'                     => '「:value」中またはそれ以降の取引',
    'search_modifier_date_after_month'                    => '「:value」中またはそれ以降の取引',
    'search_modifier_date_after_day'                      => '「:value」日以降の取引',

    // new
    'search_modifier_tag_is_not'                          => 'タグ「:value」がない',
    'search_modifier_not_tag_is_not'                      => 'タグが「:value」',
    'search_modifier_account_is'                          => 'どちらかの口座が「:value」',
    'search_modifier_not_account_is'                      => 'どちらの口座も「:value」ではない',
    'search_modifier_account_contains'                    => 'どちらかの口座名に「:value」を含む',
    'search_modifier_not_account_contains'                => 'どちらの口座も「:value」を含まない',
    'search_modifier_account_ends'                        => 'どちらかの口座が「:value」で終わる',
    'search_modifier_not_account_ends'                    => 'どちらの口座も「:value」で終わらない',
    'search_modifier_account_starts'                      => 'どちらかの口座が「:value」で始まる',
    'search_modifier_not_account_starts'                  => 'どちらの口座も「:value」で始まらない',
    'search_modifier_account_nr_is'                       => 'どちらかの口座番号 / IBAN が「:value」',
    'search_modifier_not_account_nr_is'                   => 'どちらの口座番号 / IBAN も「:value」ではない',
    'search_modifier_account_nr_contains'                 => 'どちらかの口座番号 / IBAN が「:value」を含む',
    'search_modifier_not_account_nr_contains'             => 'どちらの口座番号 / IBAN も「:value」を含まない',
    'search_modifier_account_nr_ends'                     => 'どちらかの口座番号 / IBAN が「:value」で終わる',
    'search_modifier_not_account_nr_ends'                 => 'どちらの口座番号 / IBAN も「:value」で終わらない',
    'search_modifier_account_nr_starts'                   => 'どちらかの口座番号 / IBAN が「:value」で始まる',
    'search_modifier_not_account_nr_starts'               => 'どちらの口座番号 / IBAN も「:value」で始まらない',
    'search_modifier_category_contains'                   => 'カテゴリに「:value」を含む',
    'search_modifier_not_category_contains'               => 'カテゴリが「:value」を含まない',
    'search_modifier_category_ends'                       => 'カテゴリが「:value」で終わる',
    'search_modifier_not_category_ends'                   => 'カテゴリが「:value」で終わらない',
    'search_modifier_category_starts'                     => 'カテゴリが「:value」で始まる',
    'search_modifier_not_category_starts'                 => 'カテゴリが「:value」で始まらない',
    'search_modifier_budget_contains'                     => '予算名が「:value」を含む',
    'search_modifier_not_budget_contains'                 => '予算名が「:value」を含まない',
    'search_modifier_budget_ends'                         => '予算名が「:value」で終わる',
    'search_modifier_not_budget_ends'                     => '予算名が「:value」で終わらない',
    'search_modifier_budget_starts'                       => '予算名が「:value」で始まる',
    'search_modifier_not_budget_starts'                   => '予算名が「:value」で始まらない',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => '外部IDに「:value」を含む',
    'search_modifier_not_external_id_contains'            => '外部IDが「:value」を含まない',
    'search_modifier_external_id_ends'                    => '外部 ID が「:value」で終わる',
    'search_modifier_not_external_id_ends'                => '外部IDが「:value」で終わらない',
    'search_modifier_external_id_starts'                  => '外部 ID が「:value」で始まる',
    'search_modifier_not_external_id_starts'              => '外部IDが「:value」で始まらない',
    'search_modifier_internal_reference_contains'         => '内部参照に「:value」を含む',
    'search_modifier_not_internal_reference_contains'     => '内部参照が「:value」を含まない',
    'search_modifier_internal_reference_ends'             => '内部参照が「:value」で終わる',
    'search_modifier_internal_reference_starts'           => '内部参照が「:value」で始まる',
    'search_modifier_not_internal_reference_ends'         => '内部参照が「:value」で終わらない',
    'search_modifier_not_internal_reference_starts'       => '内部参照が「:value」で始まらない',
    'search_modifier_external_url_is'                     => '外部 URL が「:value」',
    'search_modifier_not_external_url_is'                 => '外部URLが「:value」ではない',
    'search_modifier_external_url_contains'               => '外部URLに「:value」を含む',
    'search_modifier_not_external_url_contains'           => '外部URLが「:value」を含まない',
    'search_modifier_external_url_ends'                   => '外部 URL が「:value」で終わる',
    'search_modifier_not_external_url_ends'               => '外部URLが「:value」で終わらない',
    'search_modifier_external_url_starts'                 => '外部 URL が「:value」で始まる',
    'search_modifier_not_external_url_starts'             => '外部URLが「:value」で始まらない',
    'search_modifier_has_no_attachments'                  => '添付ファイルがない取引',
    'search_modifier_not_has_no_attachments'              => '添付ファイルがある取引',
    'search_modifier_not_has_attachments'                 => '添付ファイルがない取引',
    'search_modifier_account_is_cash'                     => 'どちらかの口座が現金口座',
    'search_modifier_not_account_is_cash'                 => 'どちらの口座も現金口座ではない',
    'search_modifier_journal_id'                          => 'ジャーナル ID が「:value"」',
    'search_modifier_not_journal_id'                      => 'ジャーナルIDが「:value"」ではない',
    'search_modifier_recurrence_id'                       => '定期的な取引 ID が「:value」',
    'search_modifier_not_recurrence_id'                   => '定期的な取引IDが「:value」ではない',
    'search_modifier_foreign_amount_is'                   => '外貨金額が「:value」',
    'search_modifier_not_foreign_amount_is'               => '外貨金額が「:value」ではない',
    'search_modifier_foreign_amount_less'                 => '外貨金額が「:value」より少ない',
    'search_modifier_not_foreign_amount_more'             => '外貨金額が「:value」より少ない',
    'search_modifier_not_foreign_amount_less'             => '外貨金額が「:value」より大きい',
    'search_modifier_foreign_amount_more'                 => '外貨金額が「:value」より大きい',
    'search_modifier_exists'                              => '取引が存在する',
    'search_modifier_not_exists'                          => '取引が存在しない',

    // date fields
    'search_modifier_interest_date_on'                    => '利息日が「:value」',
    'search_modifier_not_interest_date_on'                => '利息日が「:value」ではない',
    'search_modifier_interest_date_on_year'               => '利息日が「:value」',
    'search_modifier_not_interest_date_on_year'           => '利息日が「:value」年ではない',
    'search_modifier_interest_date_on_month'              => '利息日が「:value」',
    'search_modifier_not_interest_date_on_month'          => '利息日が「:value」月ではない',
    'search_modifier_interest_date_on_day'                => '利息日が「:value」',
    'search_modifier_not_interest_date_on_day'            => '利息日が「:value」日ではない',
    'search_modifier_interest_date_before_year'           => '利息日が「:value」以前',
    'search_modifier_interest_date_before_month'          => '利息日が「:value」以前',
    'search_modifier_interest_date_before_day'            => '利息日が「:value」以前',
    'search_modifier_interest_date_after_year'            => '利息日が「:value」以降',
    'search_modifier_interest_date_after_month'           => '利息日が「:value」以降',
    'search_modifier_interest_date_after_day'             => '利息日が「:value」以降',
    'search_modifier_book_date_on_year'                   => '記帳日が「:value」',
    'search_modifier_book_date_on_month'                  => '記帳日が「:value」内',
    'search_modifier_book_date_on_day'                    => '記帳日が「:value」',
    'search_modifier_not_book_date_on_year'               => '記帳日が「:value」年ではない',
    'search_modifier_not_book_date_on_month'              => '記帳日が「:value」月ではない',
    'search_modifier_not_book_date_on_day'                => '記帳日が「:value」日ではない',
    'search_modifier_book_date_before_year'               => '記帳日が「:value」以前',
    'search_modifier_book_date_before_month'              => '記帳日が「:value」以前',
    'search_modifier_book_date_before_day'                => '記帳日が「:value」以前',
    'search_modifier_book_date_after_year'                => '記帳日が「:value」以降',
    'search_modifier_book_date_after_month'               => '記帳日が「:value」以降',
    'search_modifier_book_date_after_day'                 => '記帳日が「:value」以降',
    'search_modifier_process_date_on_year'                => '取引処理日が「:value」',
    'search_modifier_process_date_on_month'               => '取引処理日が「:value」',
    'search_modifier_process_date_on_day'                 => '取引処理日が「:value」',
    'search_modifier_not_process_date_on_year'            => '取引処理日が「:value」年ではない',
    'search_modifier_not_process_date_on_month'           => '取引処理日が「:value」月ではない',
    'search_modifier_not_process_date_on_day'             => '取引処理日が「:value」日ではない',
    'search_modifier_process_date_before_year'            => '取引処理日が「:value」以前',
    'search_modifier_process_date_before_month'           => '取引処理日が「:value」以前',
    'search_modifier_process_date_before_day'             => '取引処理日が「:value」以前',
    'search_modifier_process_date_after_year'             => '取引処理日が「:value」以降',
    'search_modifier_process_date_after_month'            => '取引処理日が「:value」以降',
    'search_modifier_process_date_after_day'              => '取引処理日が「:value」以降',
    'search_modifier_due_date_on_year'                    => '「:value」が期限の取引',
    'search_modifier_due_date_on_month'                   => '「:value」が期限の取引',
    'search_modifier_due_date_on_day'                     => '「:value」が期限の取引',
    'search_modifier_not_due_date_on_year'                => '支払期日が「:value」年ではない',
    'search_modifier_not_due_date_on_month'               => '支払期日が「:value」月ではない',
    'search_modifier_not_due_date_on_day'                 => '支払期日が「:value」日ではない',
    'search_modifier_due_date_before_year'                => '「:value」以前が期限の取引',
    'search_modifier_due_date_before_month'               => '「:value」以前が期限の取引',
    'search_modifier_due_date_before_day'                 => '「:value」以前が期限の取引',
    'search_modifier_due_date_after_year'                 => '「:value」以降が期限の取引',
    'search_modifier_due_date_after_month'                => '「:value」以降が期限の取引',
    'search_modifier_due_date_after_day'                  => '「:value」以降が期限の取引',
    'search_modifier_payment_date_on_year'                => '引き落とし日が「:value」',
    'search_modifier_payment_date_on_month'               => '引き落とし日が「:value」',
    'search_modifier_payment_date_on_day'                 => '引き落とし日が「:value」',
    'search_modifier_not_payment_date_on_year'            => '支払日が「:value」年ではない',
    'search_modifier_not_payment_date_on_month'           => '支払日が「:value」月ではない',
    'search_modifier_not_payment_date_on_day'             => '支払日が「:value」日ではない',
    'search_modifier_payment_date_before_year'            => '引き落とし日が「:value」以前',
    'search_modifier_payment_date_before_month'           => '引き落とし日が「:value」以前',
    'search_modifier_payment_date_before_day'             => '引き落とし日が「:value」以前',
    'search_modifier_payment_date_after_year'             => '引き落とし日が「:value」以降',
    'search_modifier_payment_date_after_month'            => '引き落とし日が「:value」以降',
    'search_modifier_payment_date_after_day'              => '引き落とし日が「:value」以降',
    'search_modifier_invoice_date_on_year'                => '請求日が「:value」内',
    'search_modifier_invoice_date_on_month'               => '請求日が「:value」内',
    'search_modifier_invoice_date_on_day'                 => '請求日が「:value」',
    'search_modifier_not_invoice_date_on_year'            => '請求日が「:value」年ではない',
    'search_modifier_not_invoice_date_on_month'           => '請求日が「:value」月ではない',
    'search_modifier_not_invoice_date_on_day'             => '請求日が「:value」日ではない',
    'search_modifier_invoice_date_before_year'            => '請求日が「:value」以前',
    'search_modifier_invoice_date_before_month'           => '請求日が「:value」以前',
    'search_modifier_invoice_date_before_day'             => '請求日が「:value」以前',
    'search_modifier_invoice_date_after_year'             => '請求日が「:value」以降',
    'search_modifier_invoice_date_after_month'            => '請求日が「:value」以降',
    'search_modifier_invoice_date_after_day'              => '請求日が「:value」以降',
    // other dates
    'search_modifier_updated_at_on_year'                  => '取引の最終更新が「:value」',
    'search_modifier_updated_at_on_month'                 => '取引の最終更新が「:value」',
    'search_modifier_updated_at_on_day'                   => '取引の最終更新が「:value」',
    'search_modifier_not_updated_at_on_year'              => '取引の最終更新が「:value」年ではない',
    'search_modifier_not_updated_at_on_month'             => '取引の最終更新が「:value」月ではない',
    'search_modifier_not_updated_at_on_day'               => '取引の最終更新が「:value」日ではない',
    'search_modifier_updated_at_before_year'              => '取引の最終更新が「:value」以前',
    'search_modifier_updated_at_before_month'             => '取引の最終更新が「:value」以前',
    'search_modifier_updated_at_before_day'               => '取引の最終更新が「:value」以前',
    'search_modifier_updated_at_after_year'               => '取引の最終更新が「:value」以降',
    'search_modifier_updated_at_after_month'              => '取引の最終更新が「:value」以降',
    'search_modifier_updated_at_after_day'                => '取引の最終更新が「:value」以降',
    'search_modifier_created_at_on_year'                  => '取引の作成が「:value」',
    'search_modifier_created_at_on_month'                 => '取引の作成が「:value」',
    'search_modifier_created_at_on_day'                   => '取引の作成が「:value」',
    'search_modifier_not_created_at_on_year'              => '取引の作成が「:value」年ではない',
    'search_modifier_not_created_at_on_month'             => '取引の作成が「:value」月ではない',
    'search_modifier_not_created_at_on_day'               => '取引の作成が「:value」日ではない',
    'search_modifier_created_at_before_year'              => '取引の作成が「:value」以前',
    'search_modifier_created_at_before_month'             => '取引の作成が「:value」以前',
    'search_modifier_created_at_before_day'               => '取引の最終更新が「:value」以前',
    'search_modifier_created_at_after_year'               => '取引の作成が「:value」以降',
    'search_modifier_created_at_after_month'              => '取引の作成が「:value」以降',
    'search_modifier_created_at_after_day'                => '取引の作成が「:value」以降',
    'search_modifier_interest_date_before'                => '利息日が「:value」以前',
    'search_modifier_interest_date_after'                 => '利息日が「:value」以降',
    'search_modifier_book_date_on'                        => '記帳日が「:value」',
    'search_modifier_not_book_date_on'                    => '記帳日が「:value」ではない',
    'search_modifier_book_date_before'                    => '記帳日が「:value」以前',
    'search_modifier_book_date_after'                     => '記帳日が「:value」以降',
    'search_modifier_process_date_on'                     => '取引処理日が「:value」',
    'search_modifier_not_process_date_on'                 => '取引処理日が「:value」 ではない',
    'search_modifier_process_date_before'                 => '取引処理日が「:value」以前',
    'search_modifier_process_date_after'                  => '取引処理日が「:value」以降',
    'search_modifier_due_date_on'                         => '取引期限が「:value」',
    'search_modifier_not_due_date_on'                     => '取引期限が「:value」ではない',
    'search_modifier_due_date_before'                     => '取引期限が「:value」以前',
    'search_modifier_due_date_after'                      => '取引期限が「:value」以降',
    'search_modifier_payment_date_on'                     => '支払日が「:value」',
    'search_modifier_not_payment_date_on'                 => '支払日が「:value」ではない',
    'search_modifier_payment_date_before'                 => '支払日が「:value」以前',
    'search_modifier_payment_date_after'                  => '支払日が「:value」以降',
    'search_modifier_invoice_date_on'                     => '請求日が「:value」',
    'search_modifier_not_invoice_date_on'                 => '請求日が「:value」ではない',
    'search_modifier_invoice_date_before'                 => '請求日が「:value」以前',
    'search_modifier_invoice_date_after'                  => '請求日が「:value」以降',
    'search_modifier_created_at_on'                       => '「:value」に作成された取引',
    'search_modifier_not_created_at_on'                   => '取引作成が「:value」ではない',
    'search_modifier_created_at_before'                   => '「:value」以前に作成された取引',
    'search_modifier_created_at_after'                    => '「:value」以降に作成された取引',
    'search_modifier_updated_at_on'                       => '取引が「:value」に更新',
    'search_modifier_not_updated_at_on'                   => '取引更新が「:value」ではない',
    'search_modifier_updated_at_before'                   => '取引が「:value」以前に更新',
    'search_modifier_updated_at_after'                    => '取引が「:value」以降に更新',

    'search_modifier_attachment_name_is'            => 'いずれかの添付ファイル名が「:value」',
    'search_modifier_attachment_name_contains'      => 'いずれかの添付ファイル名に「:value」を含む',
    'search_modifier_attachment_name_starts'        => 'いずれかの添付ファイル名が「:value」で始まる',
    'search_modifier_attachment_name_ends'          => 'いずれかの添付ファイル名が「:value」で終わる',
    'search_modifier_attachment_notes_are'          => 'いずれかの添付ファイルの備考が「:value」',
    'search_modifier_attachment_notes_contains'     => 'いずれかの添付ファイルの備考に「:value」を含む',
    'search_modifier_attachment_notes_starts'       => 'いずれかの添付ファイルの備考が「:value」で始まる',
    'search_modifier_attachment_notes_ends'         => 'いずれかの添付ファイルの備考が「:value」で終わる',
    'search_modifier_not_attachment_name_is'        => '添付ファイル名が「:value」ではない',
    'search_modifier_not_attachment_name_contains'  => '添付ファイル名が「:value」を含まない',
    'search_modifier_not_attachment_name_starts'    => '添付ファイル名が「:value」で始まらない',
    'search_modifier_not_attachment_name_ends'      => '添付ファイル名が「:value」で終わらない',
    'search_modifier_not_attachment_notes_are'      => '添付ファイルの備考が「:value」ではない',
    'search_modifier_not_attachment_notes_contains' => '添付ファイルの備考が「:value」を含まない',
    'search_modifier_not_attachment_notes_starts'   => '添付ファイルの備考が「:value」で始まらない',
    'search_modifier_not_attachment_notes_ends'     => '添付ファイルの備考が「:value」で終わらない',
    'search_modifier_sepa_ct_is'                    => 'SEPA CTが「:value」',
    'update_rule_from_query'                        => '検索クエリからルール「:rule」を更新',
    'create_rule_from_query'                        => '検索クエリから新しいルールを作成',
    'rule_from_search_words'                        => 'ルールエンジンは「:string」をうまく扱えません。 検索クエリに提案されたルールは、異なる結果をもたらす可能性があります。ルールのトリガーは慎重に検証してください。',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => '検索中にエラーが発生しました。詳細はログファイルを確認してください。',
    'search_box'                                          => '検索',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => '検索エラー',
    'search_searching'                                    => '検索中...',
    'search_results'                                      => '検索結果',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => '毎年',
    'repeat_freq_half-year'                               => '半年ごと',
    'repeat_freq_quarterly'                               => '四半期ごと',
    'repeat_freq_monthly'                                 => '毎月',
    'repeat_freq_weekly'                                  => '週毎',
    'repeat_freq_daily'                                   => '毎日',
    'daily'                                               => '毎日',
    'weekly'                                              => '週毎',
    'quarterly'                                           => '四半期ごと',
    'half-year'                                           => '半年ごと',
    'yearly'                                              => '毎年',

    // rules
    'is_not_rule_trigger'                                 => '否定',
    'cannot_fire_inactive_rules'                          => '無効なルールは実行できません。',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'ルール',
    'rule_name'                                           => 'ルールの名前',
    'rule_triggers'                                       => 'ルールがいつ発動するか',
    'rule_actions'                                        => 'ルールは何をするか',
    'new_rule'                                            => '新しいルール',
    'new_rule_group'                                      => '新しいルールグループ',
    'rule_priority_up'                                    => 'ルールの優先度を上げる',
    'rule_priority_down'                                  => 'ルールの優先度を下げる',
    'make_new_rule_group'                                 => '新しいルールグループを作成',
    'store_new_rule_group'                                => '新しいルールグループを保存',
    'created_new_rule_group'                              => '新しいルールグループ「:title」が保存されました！',
    'updated_rule_group'                                  => 'ルールグループ「:title」を更新しました。',
    'edit_rule_group'                                     => 'ルールグループ「:title」を編集',
    'duplicate_rule'                                      => 'ルール「:title」を複製',
    'rule_copy_of'                                        => '「:title」のコピー',
    'duplicated_rule'                                     => 'ルール「:title」を「:newTitle」として複製されました',
    'delete_rule_group'                                   => 'ルールグループ「:title」を削除',
    'deleted_rule_group'                                  => '削除されたルールグループ「:title」',
    'update_rule_group'                                   => 'ルールグループを更新',
    'no_rules_in_group'                                   => 'このグループにはルールがありません',
    'move_rule_group_up'                                  => 'ルールグループを上に移動',
    'move_rule_group_down'                                => 'ルールグループを下に移動',
    'save_rules_by_moving'                                => '別のルールグループに移動して、このルールを保存します。|これらのルールを別のルールグループに移動して保存します。',
    'make_new_rule'                                       => 'ルールグループ「:title」に新しいルールを作成',
    'make_new_rule_no_group'                              => '新しいルールを作成',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => '取引に基づいてルールを作成します。以下のフォームを入力し送信してください。',
    'rule_is_strict'                                      => '厳密なルール',
    'rule_is_not_strict'                                  => '非厳密ルール',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => '厳密モードでアクションが実行されるには、すべてのトリガーが適合しなければいけません。非厳密モードでは、いずれかのトリガーだけで済みます。',
    'rule_help_active'                                    => '無効なルールは決して実行されません。',
    'stored_new_rule'                                     => '新しいルール「:title」を保存しました',
    'deleted_rule'                                        => 'ルール「:title」を削除しました',
    'store_new_rule'                                      => '新しいルールを保存',
    'updated_rule'                                        => 'ルール「:title」を更新しました',
    'default_rule_group_name'                             => 'デフォルトルール',
    'default_rule_group_description'                      => 'グループに属しないルールです。',
    'trigger'                                             => 'トリガー',
    'trigger_value'                                       => '発動する値',
    'stop_processing_other_triggers'                      => '他のトリガーの処理を停止する',
    'add_rule_trigger'                                    => '新しいトリガーを追加',
    'action'                                              => '操作',
    'action_value'                                        => 'アクションの値',
    'stop_executing_other_actions'                        => '他のアクションの実行を停止する',
    'add_rule_action'                                     => '新しい操作を追加',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'ルール ":title" を削除',
    'update_rule'                                         => 'ルールを更新',
    'test_rule_triggers'                                  => '一致する取引を見る',
    'warning_no_matching_transactions'                    => '一致する取引は見つかりませんでした。',
    'warning_no_valid_triggers'                           => '有効なトリガーがありません。',
    'apply_rule_selection'                                => 'ルール「:title」を任意の取引に適用する',
    'apply_rule_selection_intro'                          => '「:title」のようなルールは通常、新規作成または更新された取引にのみ適用されます。しかし Firefly III に既存の取引に適用するように指示できます。これは、ルールを更新し、既存の取引に変更を適用する必要がある場合に便利です。',
    'include_transactions_from_accounts'                  => 'これらの口座からの取引を含める',
    'include'                                             => '含めるか',
    'applied_rule_selection'                              => '{0} 選択した取引の中でルール「:title」によって変更されたものはありません。|[1] 選択した取引の中の1件が、ルール「:title」によって変更されました。|[2,*] 選択した取引の中の:count件が、ルール「:title」によって変更されました。',
    'execute'                                             => '実行',
    'apply_rule_group_selection'                          => 'ルールグループ「:title」を選択した取引に適用する',
    'apply_rule_group_selection_intro'                    => '「:title」のようなルールは通常、新規作成または更新された取引にのみ適用されます。しかし Firefly III に既存の取引に適用するように指示できます。これはルールを更新し既存の取引に変更を適用する必要がある場合に便利です。',
    'applied_rule_group_selection'                        => 'ルールグループ「:title」が選択した取引に適用されました。',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => '取引が作成されたとき',
    'rule_trigger_update_journal'                         => '取引が更新されたとき',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'ユーザーアクションは ":trigger_value"です。',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => '引き出し口座名が...で始まる',
    'rule_trigger_source_account_starts'                  => '引き出し口座名が「:trigger_value」で始まる',
    'rule_trigger_source_account_ends_choice'             => '引き出し口座名が…で終わる',
    'rule_trigger_source_account_ends'                    => '引き出し口座名が「:trigger_value」で終わる',
    'rule_trigger_source_account_is_choice'               => '引き出し口座名が...',
    'rule_trigger_source_account_is'                      => '引き出し口座名が「:trigger_value」',
    'rule_trigger_source_account_contains_choice'         => '引き出し口座名が…を含む',
    'rule_trigger_source_account_contains'                => '引き出し口座名に「:trigger_value」を含む',
    'rule_trigger_account_id_choice'                      => 'どちらかの口座IDが…',
    'rule_trigger_account_id'                             => 'どちらかの口座IDが :trigger_value と一致',
    'rule_trigger_source_account_id_choice'               => '引き出し口座IDが…',
    'rule_trigger_source_account_id'                      => '引き出し口座IDが「:trigger_value」と一致する',
    'rule_trigger_destination_account_id_choice'          => '預け入れ口座IDが…',
    'rule_trigger_destination_account_id'                 => '預け入れ口座IDが「:trigger_value」',
    'rule_trigger_account_is_cash_choice'                 => 'どちらかの口座が現金',
    'rule_trigger_account_is_cash'                        => 'どちらかの口座が現金',
    'rule_trigger_source_is_cash_choice'                  => '預け入れ口座が現金口座',
    'rule_trigger_source_is_cash'                         => '引き出し口座が現金口座',
    'rule_trigger_destination_is_cash_choice'             => '預け入れ口座が現金口座',
    'rule_trigger_destination_is_cash'                    => '預け入れ口座が現金口座',
    'rule_trigger_source_account_nr_starts_choice'        => '引き出し口座番号/IBANが…で始まる',
    'rule_trigger_source_account_nr_starts'               => '出金元口座番号/IBANが「:trigger_value」で始まる',
    'rule_trigger_source_account_nr_ends_choice'          => '引き出し口座番号/IBANが…で終わる',
    'rule_trigger_source_account_nr_ends'                 => '引き出し口座番号/IBANが「:trigger_value」で終わる',
    'rule_trigger_source_account_nr_is_choice'            => '引き出し口座番号/IBANが…',
    'rule_trigger_source_account_nr_is'                   => '引き出し口座番号/IBANが「:trigger_value」',
    'rule_trigger_source_account_nr_contains_choice'      => '引き出し口座番号/IBANが…を含む',
    'rule_trigger_source_account_nr_contains'             => '引き出し口座番号/IBANに「:trigger_value」を含む',
    'rule_trigger_destination_account_starts_choice'      => '預け入れ口座名が...で始まる',
    'rule_trigger_destination_account_starts'             => '預け入れ口座名が「:trigger_value」で始まる',
    'rule_trigger_destination_account_ends_choice'        => '預け入れ口座名が...で終わる',
    'rule_trigger_destination_account_ends'               => '預け入れ口座名が「:trigger_value」で終わる',
    'rule_trigger_destination_account_is_choice'          => '預け入れ口座名が…',
    'rule_trigger_destination_account_is'                 => '預け入れ口座名が「:trigger_value」',
    'rule_trigger_destination_account_contains_choice'    => '預け入れ口座名が...を含む',
    'rule_trigger_destination_account_contains'           => '預け入れ口座名に「:trigger_value」を含む',
    'rule_trigger_destination_account_nr_starts_choice'   => '預け入れ口座番号/IBANが...で始まる',
    'rule_trigger_destination_account_nr_starts'          => '預け入れ口座番号/IBANが「:trigger_value」で始まる',
    'rule_trigger_destination_account_nr_ends_choice'     => '預け入れ口座番号/IBANが...で終わる',
    'rule_trigger_destination_account_nr_ends'            => '引き出し口座番号/IBANが「:trigger_value」で終わる',
    'rule_trigger_destination_account_nr_is_choice'       => '預け入れ口座番号/IBANが…',
    'rule_trigger_destination_account_nr_is'              => '引き出し口座番号/IBANが「:trigger_value」',
    'rule_trigger_destination_account_nr_contains_choice' => '預け入れ口座番号/IBANが...を含む',
    'rule_trigger_destination_account_nr_contains'        => '預け入れ口座番号/IBANに「:trigger_value」を含む',
    'rule_trigger_transaction_type_choice'                => '取引種別が…',
    'rule_trigger_transaction_type'                       => '取引種別が「:trigger_value」',
    'rule_trigger_category_is_choice'                     => 'カテゴリが…',
    'rule_trigger_category_is'                            => 'カテゴリが「:trigger_value」',
    'rule_trigger_amount_less_choice'                     => '金額が...以下',
    'rule_trigger_amount_less'                            => '金額が「:trigger_value」以下',
    'rule_trigger_amount_is_choice'                       => '金額が…',
    'rule_trigger_amount_is'                              => '金額が「:trigger_value」',
    'rule_trigger_amount_more_choice'                     => '金額が...以上',
    'rule_trigger_amount_more'                            => '金額が「:trigger_value」以上',
    'rule_trigger_description_starts_choice'              => '概要が…で始まる',
    'rule_trigger_description_starts'                     => '概要が「:trigger_value」で始まる',
    'rule_trigger_description_ends_choice'                => '概要が…で終わる',
    'rule_trigger_description_ends'                       => '概要が「:trigger_value」で終わる',
    'rule_trigger_description_contains_choice'            => '概要に…を含む',
    'rule_trigger_description_contains'                   => '概要が「:trigger_value」を含む',
    'rule_trigger_description_is_choice'                  => '概要が…',
    'rule_trigger_description_is'                         => '概要が「:trigger_value」',
    'rule_trigger_date_on_choice'                         => '取引日が…',
    'rule_trigger_date_on'                                => '取引日が「:trigger_value」',
    'rule_trigger_date_before_choice'                     => '取引日が…より前',
    'rule_trigger_date_before'                            => '取引日が「:trigger_value」より前',
    'rule_trigger_date_after_choice'                      => '取引日が…より後',
    'rule_trigger_date_after'                             => '取引日が「:trigger_value」より後',
    'rule_trigger_created_at_on_choice'                   => '取引作成日が...',
    'rule_trigger_created_at_on'                          => '取引が作成が「:trigger_value」',
    'rule_trigger_updated_at_on_choice'                   => '取引の最終編集日が',
    'rule_trigger_updated_at_on'                          => '取引の最終編集が「:trigger_value」',
    'rule_trigger_budget_is_choice'                       => '予算が…',
    'rule_trigger_budget_is'                              => '予算が「:trigger_value」',
    'rule_trigger_tag_is_choice'                          => 'タグが...',
    'rule_trigger_tag_is'                                 => 'タグが「:trigger_value」',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => '取引通貨が…',
    'rule_trigger_currency_is'                            => '取引通貨が「:trigger_value」',
    'rule_trigger_foreign_currency_is_choice'             => '取引外国通貨が…',
    'rule_trigger_foreign_currency_is'                    => '取引外国通貨が「:trigger_value」',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'カテゴリなし',
    'rule_trigger_has_no_category'                        => 'カテゴリのない取引',
    'rule_trigger_has_any_category_choice'                => '(任意の) カテゴリがある',
    'rule_trigger_has_any_category'                       => '一つ以上のカテゴリに属する取引',
    'rule_trigger_has_no_budget_choice'                   => '予算をもたない',
    'rule_trigger_has_no_budget'                          => '予算をもたない取引',
    'rule_trigger_has_any_budget_choice'                  => '予算がある取引',
    'rule_trigger_has_any_budget'                         => '一つ以上の予算をもつ取引',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'タグがない',
    'rule_trigger_has_no_tag'                             => 'タグがない取引',
    'rule_trigger_has_any_tag_choice'                     => '一つ以上のタグがある',
    'rule_trigger_has_any_tag'                            => '一つ以上のタグがある取引',
    'rule_trigger_any_notes_choice'                       => '備考がある',
    'rule_trigger_any_notes'                              => '備考がある取引',
    'rule_trigger_no_notes_choice'                        => '備考がない',
    'rule_trigger_no_notes'                               => '備考がない取引',
    'rule_trigger_notes_is_choice'                        => '備考が...',
    'rule_trigger_notes_is'                               => '備考が「:trigger_value」',
    'rule_trigger_notes_contains_choice'                  => '備考が次を含む',
    'rule_trigger_notes_contains'                         => '備考に「:trigger_value」を含む',
    'rule_trigger_notes_starts_choice'                    => '備考が...で始まる',
    'rule_trigger_notes_starts'                           => '備考が「:trigger_value」で始まる',
    'rule_trigger_notes_ends_choice'                      => '備考が...で終わる',
    'rule_trigger_notes_ends'                             => '備考が「:trigger_value」で終わる',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => '外部 ID が…',
    'rule_trigger_external_id_is'                         => '外部 ID が「:trigger_value」',
    'rule_trigger_internal_reference_is_choice'           => '内部参照が…',
    'rule_trigger_internal_reference_is'                  => '内部参照が「:trigger_value」',
    'rule_trigger_journal_id_choice'                      => '取引IDが…',
    'rule_trigger_journal_id'                             => '取引IDが「:trigger_value」',
    'rule_trigger_any_external_url'                       => '外部URLがある取引',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => '外部IDがある取引',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => '外部 URL がない取引',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => '外部IDがない取引',
    'rule_trigger_id_choice'                              => '取引IDが…',
    'rule_trigger_id'                                     => '取引IDが「:trigger_value」',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CTが...',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CTが「:trigger_value」',

    // new values:
    'rule_trigger_user_action_choice'                     => 'ユーザーアクションが「:trigger_value」',
    'rule_trigger_tag_is_not_choice'                      => 'タグ…がない',
    'rule_trigger_tag_is_not'                             => 'タグ「:trigger_value」がない',
    'rule_trigger_account_is_choice'                      => 'どちらかの口座が…と一致する',
    'rule_trigger_account_is'                             => 'どちらかの口座が「:trigger_value」と一致する',
    'rule_trigger_account_contains_choice'                => 'どちらかの口座が…を含む',
    'rule_trigger_account_contains'                       => 'どちらかの口座名に「:trigger_value」を含む',
    'rule_trigger_account_ends_choice'                    => 'どちらかの口座が…で終わる',
    'rule_trigger_account_ends'                           => 'どちらかの口座が「:trigger_value」で終わる',
    'rule_trigger_account_starts_choice'                  => 'どちらかの口座で…で始まる',
    'rule_trigger_account_starts'                         => 'どちらかの口座が「:trigger_value」で始まる',
    'rule_trigger_account_nr_is_choice'                   => 'どちらかの口座番号 / IBAN が…',
    'rule_trigger_account_nr_is'                          => 'どちらかの口座番号 / IBAN が「:trigger_value」',
    'rule_trigger_account_nr_contains_choice'             => 'どちらかの口座番号 / IBAN が…を含む',
    'rule_trigger_account_nr_contains'                    => 'どちらかの口座番号 / IBAN に「:trigger_value」を含む',
    'rule_trigger_account_nr_ends_choice'                 => 'どちらかの口座番号 / IBAN が…で終わる',
    'rule_trigger_account_nr_ends'                        => 'どちらかの口座番号 / IBAN が「:trigger_value」で終わる',
    'rule_trigger_account_nr_starts_choice'               => 'どちらかの口座番号 / IBAN が…で始まる',
    'rule_trigger_account_nr_starts'                      => 'どちらかの口座番号 / IBAN が「:trigger_value」で始まる',
    'rule_trigger_category_contains_choice'               => 'カテゴリに…を含む',
    'rule_trigger_category_contains'                      => 'カテゴリに「:trigger_value」を含む',
    'rule_trigger_category_ends_choice'                   => 'カテゴリが…で終わる',
    'rule_trigger_category_ends'                          => 'カテゴリが「:trigger_value」で終わる',
    'rule_trigger_category_starts_choice'                 => 'カテゴリが…で始まる',
    'rule_trigger_category_starts'                        => 'カテゴリが「:trigger_value」で始まる',
    'rule_trigger_budget_contains_choice'                 => '予算名に…を含む',
    'rule_trigger_budget_contains'                        => '予算名に「:trigger_value」を含む',
    'rule_trigger_budget_ends_choice'                     => '予算名が…で終わる',
    'rule_trigger_budget_ends'                            => '予算名が「:trigger_value」で終わる',
    'rule_trigger_budget_starts_choice'                   => '予算名が…で始まる',
    'rule_trigger_budget_starts'                          => '予算名が「:trigger_value」で始まる',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => '外部 ID が…を含む',
    'rule_trigger_external_id_contains'                   => '外部IDに「:trigger_value」を含む',
    'rule_trigger_external_id_ends_choice'                => '外部 ID が…で終わる',
    'rule_trigger_external_id_ends'                       => '外部 ID が「:trigger_value」で終わる',
    'rule_trigger_external_id_starts_choice'              => '外部 ID が…で始まる',
    'rule_trigger_external_id_starts'                     => '外部 ID が「:trigger_value」で始まる',
    'rule_trigger_internal_reference_contains_choice'     => '内部参照が…を含む',
    'rule_trigger_internal_reference_contains'            => '内部参照に「:trigger_value」を含む',
    'rule_trigger_internal_reference_ends_choice'         => '内部参照が…で終わる',
    'rule_trigger_internal_reference_ends'                => '内部参照が「:trigger_value」で終わる',
    'rule_trigger_internal_reference_starts_choice'       => '内部参照が…で始まる',
    'rule_trigger_internal_reference_starts'              => '内部参照が「:trigger_value」で始まる',
    'rule_trigger_external_url_is_choice'                 => '外部 URL が…',
    'rule_trigger_external_url_is'                        => '外部 URL が「:trigger_value」',
    'rule_trigger_external_url_contains_choice'           => '外部 URL に…を含む',
    'rule_trigger_external_url_contains'                  => '外部 URLに「:trigger_value」を含む',
    'rule_trigger_external_url_ends_choice'               => '外部 URL が…で終わる',
    'rule_trigger_external_url_ends'                      => '外部 URL が「:trigger_value」で終わる',
    'rule_trigger_external_url_starts_choice'             => '外部 URL が…で始まる',
    'rule_trigger_external_url_starts'                    => '外部 ID が「:trigger_value」で始まる',
    'rule_trigger_has_no_attachments_choice'              => '添付ファイルなし',
    'rule_trigger_has_no_attachments'                     => '添付ファイルがない取引',
    'rule_trigger_recurrence_id_choice'                   => '定期的な取引 ID が…',
    'rule_trigger_recurrence_id'                          => '定期的な取引IDが「:trigger_value」',
    'rule_trigger_interest_date_on_choice'                => '利息日が…',
    'rule_trigger_interest_date_on'                       => '利息日が「:trigger_value」',
    'rule_trigger_interest_date_before_choice'            => '利息日が…より前',
    'rule_trigger_interest_date_before'                   => '利息日が「:trigger_value」より前',
    'rule_trigger_interest_date_after_choice'             => '利息日が…より後',
    'rule_trigger_interest_date_after'                    => '利息日が「:trigger_value」より後',
    'rule_trigger_book_date_on_choice'                    => '記帳日が…',
    'rule_trigger_book_date_on'                           => '記帳日が「:trigger_value」',
    'rule_trigger_book_date_before_choice'                => '記帳日が…より前',
    'rule_trigger_book_date_before'                       => '記帳日が「:trigger_value」より前',
    'rule_trigger_book_date_after_choice'                 => '記帳日が…より後',
    'rule_trigger_book_date_after'                        => '記帳日が「:trigger_value」より後',
    'rule_trigger_process_date_on_choice'                 => '処理日が…',
    'rule_trigger_process_date_on'                        => '処理日が「:trigger_value」',
    'rule_trigger_process_date_before_choice'             => '処理日が…より前',
    'rule_trigger_process_date_before'                    => '処理日が「:trigger_value」より前',
    'rule_trigger_process_date_after_choice'              => '処理日が…より後',
    'rule_trigger_process_date_after'                     => '処理日が「:trigger_value」より後',
    'rule_trigger_due_date_on_choice'                     => '支払い期日が...',
    'rule_trigger_due_date_on'                            => '支払い期日が:trigger_value',
    'rule_trigger_due_date_before_choice'                 => '支払い期日が…より前',
    'rule_trigger_due_date_before'                        => '支払い期日が「:trigger_value」',
    'rule_trigger_due_date_after_choice'                  => '支払い期日が...より後',
    'rule_trigger_due_date_after'                         => '支払い期日が「:trigger_value」より後',
    'rule_trigger_payment_date_on_choice'                 => '支払日が…',
    'rule_trigger_payment_date_on'                        => '支払日が「:trigger_value」',
    'rule_trigger_payment_date_before_choice'             => '支払日が…より前',
    'rule_trigger_payment_date_before'                    => '支払日が「:trigger_value」より前',
    'rule_trigger_payment_date_after_choice'              => '支払日が…より後',
    'rule_trigger_payment_date_after'                     => '支払日が「:trigger_value」より後',
    'rule_trigger_invoice_date_on_choice'                 => '請求日が…',
    'rule_trigger_invoice_date_on'                        => '請求日が「:trigger_value」',
    'rule_trigger_invoice_date_before_choice'             => '請求日が…より前',
    'rule_trigger_invoice_date_before'                    => '請求日が「:trigger_value」より前',
    'rule_trigger_invoice_date_after_choice'              => '請求日が…より後',
    'rule_trigger_invoice_date_after'                     => '請求日が「:trigger_value」より後',
    'rule_trigger_created_at_before_choice'               => '取引が…より前に作成された',
    'rule_trigger_created_at_before'                      => '取引が「:trigger_value」より前に作成された',
    'rule_trigger_created_at_after_choice'                => '取引が…より後に作成された',
    'rule_trigger_created_at_after'                       => '取引が「:trigger_value」より後に作成された',
    'rule_trigger_updated_at_before_choice'               => '取引が…より前に更新された',
    'rule_trigger_updated_at_before'                      => '取引が「:trigger_value」より前に更新された',
    'rule_trigger_updated_at_after_choice'                => '取引が…より後に更新された',
    'rule_trigger_updated_at_after'                       => '取引が「:trigger_value」より後に更新された',
    'rule_trigger_foreign_amount_is_choice'               => '外貨金額が…',
    'rule_trigger_foreign_amount_is'                      => '外貨金額が「:trigger_value」と一致する',
    'rule_trigger_foreign_amount_less_choice'             => '外貨金額が…より小さい',
    'rule_trigger_foreign_amount_less'                    => '外貨金額が「:trigger_value」より小さい',
    'rule_trigger_foreign_amount_more_choice'             => '外貨金額が…より大きい',
    'rule_trigger_foreign_amount_more'                    => '外貨金額が「:trigger_value」より大きい',
    'rule_trigger_attachment_name_is_choice'              => '添付ファイル名が…',
    'rule_trigger_attachment_name_is'                     => '添付ファイル名が「:trigger_value」',
    'rule_trigger_attachment_name_contains_choice'        => '添付ファイル名に…を含む',
    'rule_trigger_attachment_name_contains'               => 'いずれかの添付ファイル名に「:trigger_value」を含む',
    'rule_trigger_attachment_name_starts_choice'          => 'いずれかの添付ファイル名が…で始まる',
    'rule_trigger_attachment_name_starts'                 => 'いずれかの添付ファイル名が「:trigger_value」で始まる',
    'rule_trigger_attachment_name_ends_choice'            => '添付ファイル名が…で終わる',
    'rule_trigger_attachment_name_ends'                   => '添付ファイル名が「:trigger_value」で終わる',
    'rule_trigger_attachment_notes_are_choice'            => 'いずれかの添付ファイル備考が…',
    'rule_trigger_attachment_notes_are'                   => 'いずれかの添付ファイル備考が「:trigger_value」',
    'rule_trigger_attachment_notes_contains_choice'       => 'いずれかの添付ファイル備考が…を含む',
    'rule_trigger_attachment_notes_contains'              => 'いずれかの添付ファイル備考に「:trigger_value」を含む',
    'rule_trigger_attachment_notes_starts_choice'         => 'いずれかの添付ファイル備考が…で始まる',
    'rule_trigger_attachment_notes_starts'                => 'いずれかの添付ファイル備考が「:trigger_value」で始まる',
    'rule_trigger_attachment_notes_ends_choice'           => 'いずれかの添付ファイル備考が…で終わる',
    'rule_trigger_attachment_notes_ends'                  => 'いずれかの添付ファイル備考が「:trigger_value」で終わる',
    'rule_trigger_reconciled_choice'                      => '照合済みの取引',
    'rule_trigger_reconciled'                             => '照合済みの取引',
    'rule_trigger_exists_choice'                          => 'すべてのトランザクションが一致(!)',
    'rule_trigger_exists'                                 => 'すべての取引が一致',

    // more values for new types:
    'rule_trigger_not_account_id'                         => '口座IDが「:trigger_value」ではない',
    'rule_trigger_not_source_account_id'                  => '引き出し口座IDが「:trigger_value」ではない',
    'rule_trigger_not_destination_account_id'             => '預け入れ口座IDが「:trigger_value」ではない',
    'rule_trigger_not_transaction_type'                   => '取引種別が「:trigger_value」ではない',
    'rule_trigger_not_tag_is'                             => 'タグが「:trigger_value」ではない',
    'rule_trigger_not_tag_is_not'                         => 'タグが「:trigger_value」',
    'rule_trigger_not_description_is'                     => '概要が「:trigger_value」ではない',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => '概要が「:trigger_value」で終わらない',
    'rule_trigger_not_description_starts'                 => '概要が「:trigger_value」で始まらない',
    'rule_trigger_not_notes_is'                           => '備考が「:trigger_value」ではない',
    'rule_trigger_not_notes_contains'                     => '備考に「:trigger_value」を含まない',
    'rule_trigger_not_notes_ends'                         => '備考が「:trigger_value」で終わらない',
    'rule_trigger_not_notes_starts'                       => '備考が「:trigger_value」で始まらない',
    'rule_trigger_not_source_account_is'                  => '引き出し口座名が「:trigger_value」ではない',
    'rule_trigger_not_source_account_contains'            => '引き出し口座名が「:trigger_value」を含まない',
    'rule_trigger_not_source_account_ends'                => '引き出し口座名が「:trigger_value」で終わらない',
    'rule_trigger_not_source_account_starts'              => '引き出し口座名が「:trigger_value」で始まらない',
    'rule_trigger_not_source_account_nr_is'               => '引き出し口座番号/IBANが「:trigger_value」ではない',
    'rule_trigger_not_source_account_nr_contains'         => '引き出し口座番号/IBANが「:trigger_value」を含まない',
    'rule_trigger_not_source_account_nr_ends'             => '引き出し口座番号/IBANが「:trigger_value」で終わらない',
    'rule_trigger_not_source_account_nr_starts'           => '引き出し口座番号/IBANが「:trigger_value」で始まらない',
    'rule_trigger_not_destination_account_is'             => '預け入れ口座名が「:trigger_value」ではない',
    'rule_trigger_not_destination_account_contains'       => '預け入れ口座名が「:trigger_value」を含まない',
    'rule_trigger_not_destination_account_ends'           => '預け入れ口座名が「:trigger_value」で終わらない',
    'rule_trigger_not_destination_account_starts'         => '預け入れ口座名が「:trigger_value」で始まらない',
    'rule_trigger_not_destination_account_nr_is'          => '預け入れ口座番号/IBANが「:trigger_value」ではない',
    'rule_trigger_not_destination_account_nr_contains'    => '預け入れ口座番号/IBANが「:trigger_value」を含まない',
    'rule_trigger_not_destination_account_nr_ends'        => '預け入れ口座番号/IBANが「:trigger_value」で終わらない',
    'rule_trigger_not_destination_account_nr_starts'      => '預け入れ口座番号/IBANが「:trigger_value」を始まらない',
    'rule_trigger_not_account_is'                         => 'どちらの口座も「:trigger_value」ではない',
    'rule_trigger_not_account_contains'                   => 'どちらの口座も「:trigger_value」を含まない',
    'rule_trigger_not_account_ends'                       => 'どちらの口座も「:trigger_value」で終わらない',
    'rule_trigger_not_account_starts'                     => 'どちらの口座も「:trigger_value」で始まらない',
    'rule_trigger_not_account_nr_is'                      => 'どちらの口座番号/IBANも「:trigger_value」ではない',
    'rule_trigger_not_account_nr_contains'                => 'どちらの口座番号/IBANも「:trigger_value」を含まない',
    'rule_trigger_not_account_nr_ends'                    => 'どちらの口座番号/IBANも「:trigger_value」で終わらない',
    'rule_trigger_not_account_nr_starts'                  => 'どちらの口座番号/IBANも「:trigger_value」で始まらない',
    'rule_trigger_not_category_is'                        => 'カテゴリが「:trigger_value」ではない',
    'rule_trigger_not_category_contains'                  => 'カテゴリが「:trigger_value」を含まない',
    'rule_trigger_not_category_ends'                      => 'カテゴリが「:trigger_value」で終わらない',
    'rule_trigger_not_category_starts'                    => 'カテゴリが「:trigger_value」で始まらない',
    'rule_trigger_not_budget_is'                          => '予算名が「:trigger_value」ではない',
    'rule_trigger_not_budget_contains'                    => '予算名に「:trigger_value」を含まない',
    'rule_trigger_not_budget_ends'                        => '予算名が「:trigger_value」で終わらない',
    'rule_trigger_not_budget_starts'                      => '予算名が「:trigger_value」で始まらない',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => '外部IDが「:trigger_value」ではない',
    'rule_trigger_not_external_id_contains'               => '外部IDに「:trigger_value」を含まない',
    'rule_trigger_not_external_id_ends'                   => '外部IDが「:trigger_value」で終わらない',
    'rule_trigger_not_external_id_starts'                 => '外部IDが「:trigger_value」で始まらない',
    'rule_trigger_not_internal_reference_is'              => '内部参照が「:trigger_value」ではない',
    'rule_trigger_not_internal_reference_contains'        => '内部参照に「:trigger_value」を含まない',
    'rule_trigger_not_internal_reference_ends'            => '内部参照が「:trigger_value」で終わらない',
    'rule_trigger_not_internal_reference_starts'          => '内部参照が「:trigger_value」で始まらない',
    'rule_trigger_not_external_url_is'                    => '外部URLが「:trigger_value」ではない',
    'rule_trigger_not_external_url_contains'              => '外部URLに「:trigger_value」を含まない',
    'rule_trigger_not_external_url_ends'                  => '外部URLが「:trigger_value」で終わらない',
    'rule_trigger_not_external_url_starts'                => '外部URLが「:trigger_value」で始まらない',
    'rule_trigger_not_currency_is'                        => '通貨が「:trigger_value」ではない',
    'rule_trigger_not_foreign_currency_is'                => '外国通貨が「:trigger_value」ではない',
    'rule_trigger_not_id'                                 => '取引IDが「:trigger_value」ではない',
    'rule_trigger_not_journal_id'                         => '取引ジャーナルIDが「:trigger_value」ではない',
    'rule_trigger_not_recurrence_id'                      => '繰り返しIDが「:trigger_value」ではない',
    'rule_trigger_not_date_on'                            => '日付が「:trigger_value」ではない',
    'rule_trigger_not_date_before'                        => '日付が「:trigger_value」より前ではない',
    'rule_trigger_not_date_after'                         => '日付が「:trigger_value」より後ではない',
    'rule_trigger_not_interest_date_on'                   => '利息日が「:trigger_value」ではない',
    'rule_trigger_not_interest_date_before'               => '利息日が「:trigger_value」より前ではない',
    'rule_trigger_not_interest_date_after'                => '利息日が「:trigger_value」より後ではない',
    'rule_trigger_not_book_date_on'                       => '記帳日が「:trigger_value」ではない',
    'rule_trigger_not_book_date_before'                   => '記帳日が「:trigger_value」より前ではない',
    'rule_trigger_not_book_date_after'                    => '記帳日が「:trigger_value」より後ではない',
    'rule_trigger_not_process_date_on'                    => '処理日が「:trigger_value」ではない',
    'rule_trigger_not_process_date_before'                => '処理日が「:trigger_value」より前ではない',
    'rule_trigger_not_process_date_after'                 => '処理日が「:trigger_value」より後ではない',
    'rule_trigger_not_due_date_on'                        => '支払い期日が「:trigger_value」ではない',
    'rule_trigger_not_due_date_before'                    => '支払い期日が「:trigger_value」より前ではない',
    'rule_trigger_not_due_date_after'                     => '支払い期日が「:trigger_value」より後ではない',
    'rule_trigger_not_payment_date_on'                    => '支払日が「:trigger_value」ではない',
    'rule_trigger_not_payment_date_before'                => '支払日が「:trigger_value」より前',
    'rule_trigger_not_payment_date_after'                 => '支払日が「:trigger_value」より後ではない',
    'rule_trigger_not_invoice_date_on'                    => '請求日が「:trigger_value」ではない',
    'rule_trigger_not_invoice_date_before'                => '支払日が「:trigger_value」より前ではない',
    'rule_trigger_not_invoice_date_after'                 => '請求日が「:trigger_value」より後ではない',
    'rule_trigger_not_created_at_on'                      => '取引作成が「:trigger_value」ではない',
    'rule_trigger_not_created_at_before'                  => '取引作成が「:trigger_value」の前ではない',
    'rule_trigger_not_created_at_after'                   => '取引作成が「:trigger_value」より後ではない',
    'rule_trigger_not_updated_at_on'                      => '取引更新が「:trigger_value」ではない',
    'rule_trigger_not_updated_at_before'                  => '取引更新が「:trigger_value」より前ではない',
    'rule_trigger_not_updated_at_after'                   => '取引更新が「:trigger_value」より後ではない',
    'rule_trigger_not_amount_is'                          => '取引金額が「:trigger_value」ではない',
    'rule_trigger_not_amount_less'                        => '取引金額が「:trigger_value」より大きい',
    'rule_trigger_not_amount_more'                        => '取引金額が「:trigger_value」より小さい',
    'rule_trigger_not_foreign_amount_is'                  => '取引外貨金額が「:trigger_value」ではない',
    'rule_trigger_not_foreign_amount_less'                => '取引外貨金額が「:trigger_value」より大きい',
    'rule_trigger_not_foreign_amount_more'                => '取引外貨金額が「:trigger_value」より小さい',
    'rule_trigger_not_attachment_name_is'                 => '添付ファイル名「:trigger_value」がない',
    'rule_trigger_not_attachment_name_contains'           => '添付ファイル名に「:trigger_value」を含むものがない',
    'rule_trigger_not_attachment_name_starts'             => '添付ファイル名が「:trigger_value」で始まるものがない',
    'rule_trigger_not_attachment_name_ends'               => '添付ファイル名が「:trigger_value」で終わるものがない',
    'rule_trigger_not_attachment_notes_are'               => '添付ファイルの備考が「:trigger_value」のものがない',
    'rule_trigger_not_attachment_notes_contains'          => '添付ファイルの備考に「:trigger_value」を含むものがない',
    'rule_trigger_not_attachment_notes_starts'            => '添付ファイルの備考が「:trigger_value」で始まるものがない',
    'rule_trigger_not_attachment_notes_ends'              => '添付ファイルの備考が「:trigger_value」で終わるものがない',
    'rule_trigger_not_reconciled'                         => '照合されていない取引',
    'rule_trigger_not_exists'                             => '存在しない取引',
    'rule_trigger_not_has_attachments'                    => '添付ファイルがない取引',
    'rule_trigger_not_has_any_category'                   => 'カテゴリのない取引',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'タグがない取引',
    'rule_trigger_not_any_notes'                          => '備考がない取引',
    'rule_trigger_not_any_external_url'                   => '外部URLがない取引',
    'rule_trigger_not_has_no_attachments'                 => '添付ファイルがある取引',
    'rule_trigger_not_has_no_category'                    => 'カテゴリがある取引',
    'rule_trigger_not_has_no_budget'                      => '予算がある取引',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'タグがある取引',
    'rule_trigger_not_no_notes'                           => '備考がある取引',
    'rule_trigger_not_no_external_url'                    => '外部URLがある取引',
    'rule_trigger_not_source_is_cash'                     => '引き出し口座が現金口座ではない',
    'rule_trigger_not_destination_is_cash'                => '預け入れ口座が現金口座ではない',
    'rule_trigger_not_account_is_cash'                    => 'どちらの口座も現金口座ではない',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => '取引を削除 (!)',
    'rule_action_delete_transaction'             => '取引を削除 (!)',
    'rule_action_set_category'                   => 'カテゴリを「:action_value」に設定',
    'rule_action_clear_category'                 => 'カテゴリをクリア',
    'rule_action_set_budget'                     => '予算を「:action_value」に設定',
    'rule_action_clear_budget'                   => '予算をクリア',
    'rule_action_add_tag'                        => 'タグ「:action_value」を追加',
    'rule_action_remove_tag'                     => 'タグ「:action_value」を削除',
    'rule_action_remove_all_tags'                => 'すべてのタグを削除',
    'rule_action_set_description'                => '備考を「:action_value」に設定',
    'rule_action_append_description'             => '備考の始めに「:action_value」を追加',
    'rule_action_prepend_description'            => '備考の終わりに「:action_value」を追加',
    'rule_action_set_category_choice'            => 'カテゴリを...に設定',
    'rule_action_clear_category_choice'          => 'カテゴリをクリア',
    'rule_action_set_budget_choice'              => '予算を...に設定',
    'rule_action_clear_budget_choice'            => '予算をクリア',
    'rule_action_add_tag_choice'                 => 'タグ…を追加',
    'rule_action_remove_tag_choice'              => 'タグ…を削除',
    'rule_action_remove_all_tags_choice'         => 'すべてのタグを削除',
    'rule_action_set_description_choice'         => '説明を...に設定',
    'rule_action_update_piggy_choice'            => '取引金額を貯金箱...に加算/減算する',
    'rule_action_update_piggy'                   => '取引金額を貯金箱「:action_value」に加算/減算する',
    'rule_action_append_description_choice'      => '概要の終わりに…を追加',
    'rule_action_prepend_description_choice'     => '概要の終わりに…を追加',
    'rule_action_set_source_account_choice'      => '引き出し口座を...に設定',
    'rule_action_set_source_account'             => '支払元口座を「:action_value」にする',
    'rule_action_set_destination_account_choice' => '預け入れ口座を...に設定',
    'rule_action_set_destination_account'        => '預け入れ口座を「:action_value」にする',
    'rule_action_append_notes_choice'            => '備考の終わりに...を追加',
    'rule_action_append_notes'                   => '備考の始めに「:action_value」を追加',
    'rule_action_prepend_notes_choice'           => '備考の終わりに…を追加',
    'rule_action_prepend_notes'                  => '備考の終わりに「:action_value」を追加',
    'rule_action_clear_notes_choice'             => '備考を削除',
    'rule_action_clear_notes'                    => '備考を削除',
    'rule_action_set_notes_choice'               => '備考に...を設定',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => '引き出し口座と預け入れ口座を切り替える（送金のみ）',
    'rule_action_switch_accounts'                => '引き出しと預け入れを切り替える',
    'rule_action_set_notes'                      => '備考に「:action_value」を設定',
    'rule_action_convert_deposit_choice'         => '取引を入金に変換',
    'rule_action_convert_deposit'                => '取引を「:action_value」からの入金に変換する',
    'rule_action_convert_withdrawal_choice'      => '取引を出金に変換',
    'rule_action_convert_withdrawal'             => '取引を「:action_value」への引き出しに変換する',
    'rule_action_convert_transfer_choice'        => '取引を送金に変換',
    'rule_action_convert_transfer'               => '取引を「:action_value」で送金に変換する',
    'rule_action_append_descr_to_notes_choice'   => '取引のメモの終わりに概要を追加',
    'rule_action_append_notes_to_descr_choice'   => '説明の終わりに取引の備考を追加',
    'rule_action_move_descr_to_notes_choice'     => '現在の取引メモを概要で置き換えます',
    'rule_action_move_notes_to_descr_choice'     => '現在の概要を取引メモで置き換えます',
    'rule_action_append_descr_to_notes'          => 'メモの終わりに概要を追加',
    'rule_action_append_notes_to_descr'          => '概要の終わりにメモを追加',
    'rule_action_move_descr_to_notes'            => 'メモを概要で置き換え',
    'rule_action_move_notes_to_descr'            => '概要をメモで置き換え',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => '取引「:description」をもとにしたルール',
    'new_rule_for_journal_description'          => 'このルールは取引「:description」に基づいています。全く同じ取引に適合します。',

    // tags
    'store_new_tag'                             => '新しいタグを保存',
    'update_tag'                                => 'タグを更新',
    'no_location_set'                           => '場所が設定されていません。',
    'meta_data'                                 => 'メタデータ',
    'location'                                  => '場所',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => '日付なし',
    'result'                                    => '結果',
    'sums_apply_to_range'                       => '選択した範囲にすべての合計が適用されます',
    'mapbox_api_key'                            => '地図を使うには <a href="https://www.mapbox.com/">Mapbox</a> のAPIキーを取得してください。<code>.env</code>ファイルを開き、<code>MAPBOX_API_KEY=</code>のうしろにAPIキーを入力してください。',
    'press_object_location'                     => '対象の位置を設定するには、右クリックまたは長押しします。',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => '場所をクリア',
    'delete_all_selected_tags'                  => '選択したすべてのタグを削除',
    'select_tags_to_delete'                     => '忘れずにタグを選択してください。',
    'deleted_x_tags'                            => ':count 個のタグを削除しました。|:count 個のタグを削除しました。',
    'create_rule_from_transaction'              => '取引に基づいてルールを作成',
    'create_recurring_from_transaction'         => '取引に基づいて定期的な取引を作成する',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'ブラウザに判断させる',
    'dark_mode_option_light'                    => '常にライト',
    'dark_mode_option_dark'                     => '常にダーク',
    'equal_to_language'                         => '（言語と同一）',
    'dark_mode_preference'                      => 'ダークモード',
    'dark_mode_preference_help'                 => 'Firefly III にいつダークモードを使用するか伝えましょう。',
    'pref_home_screen_accounts'                 => 'ホーム画面の口座',
    'pref_home_screen_accounts_help'            => 'ホームページにどの口座を表示しますか？',
    'pref_view_range'                           => '閲覧範囲',
    'pref_view_range_help'                      => 'いくつかのチャートは自動的に期間でグループ化されます。予算も期間にグループ化されます。どの期間を設定しますか？',
    'pref_1D'                                   => '1日',
    'pref_1W'                                   => '1週',
    'pref_1M'                                   => '1ヵ月',
    'pref_3M'                                   => '3ヶ月 (四半期)',
    'pref_6M'                                   => '6ヶ月',
    'pref_1Y'                                   => '1年',
    'pref_last365'                              => '昨年',
    'pref_last90'                               => '過去 90 日間',
    'pref_last30'                               => '過去 30 日間',
    'pref_last7'                                => '過去 7 日間',
    'pref_YTD'                                  => '年始から今日まで',
    'pref_QTD'                                  => '今四半期',
    'pref_MTD'                                  => '今月',
    'pref_languages'                            => '言語',
    'pref_locale'                               => 'ロケール設定',
    'pref_languages_help'                       => 'Firefly III は多言語に対応しています。どれがお好みですか？',
    'pref_locale_help'                          => 'Firefly III では、通貨、数字、日付のフォーマットなど、他のローカル設定に変更できます。 このリストにあるエントリは、あなたのシステムでサポートされていない可能性があります。 Firefly III にはすべてのロケールの正しい日付設定がありません。改善のために私に連絡してください。',
    'pref_locale_no_demo'                       => 'この機能はデモユーザーでは動作しません。',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => '会計年度設定',
    'pref_custom_fiscal_year_label'             => '有効',
    'pref_custom_fiscal_year_help'              => '1月1日から12月31日まで以外の会計年度を使用する国では、 これを有効にして、会計年度の開始日/終了日を指定します。',
    'pref_fiscal_year_start_label'              => '会計年度開始日',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => '認証アプリからアカウントを削除することを忘れないでください！',
    'pref_two_factor_auth_code'                 => 'コードを確認',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => '確認コードをリセット',
    'pref_two_factor_auth_disable_2fa'          => 'Disable MFA',
    '2fa_use_secret_instead'                    => 'QR コードをスキャンできない場合は、代わりにシークレットを使用してください: <code>:secret</code>',
    '2fa_backup_codes'                          => 'デバイスを失くした場合に備えて、これらのバックアップコードを保存してください。',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'この多要素認証コードは無効です。',
    'pref_save_settings'                        => '設定を保存',
    'saved_preferences'                         => '設定が保存されました！',
    'preferences_general'                       => '一般設定',
    'preferences_frontpage'                     => 'ホーム画面',
    'preferences_security'                      => 'セキュリティ',
    'preferences_layout'                        => 'レイアウト',
    'preferences_notifications'                 => '通知',
    'pref_home_show_deposits'                   => 'ホーム画面に入金を表示する',
    'pref_home_show_deposits_info'              => 'ホーム画面にはすでに支出口座が表示されています。収入口座も表示しますか？',
    'pref_home_do_show_deposits'                => 'はい、表示します',
    'successful_count'                          => ':count 通のエラーがあります',
    'list_page_size_title'                      => 'ページの表示件数',
    'list_page_size_help'                       => 'あらゆるリスト (アカウント、取引など) のページあたりの最大表示数です。',
    'list_page_size_label'                      => 'ページの表示件数',
    'between_dates'                             => '(:start と :end)',
    'pref_optional_fields_transaction'          => '取引のオプション項目',
    'pref_optional_fields_transaction_help'     => 'デフォルトでは、新しい取引を作成するとき、すべての項目が有効ではありません (乱雑になるため)。 以下からあなたが便利と思う項目を有効にできます。すでに入力されている項目は、無効としても設定に関係なく表示されます。',
    'optional_tj_date_fields'                   => '日付フィールド',
    'optional_tj_other_fields'                  => 'その他の項目',
    'optional_tj_attachment_fields'             => '添付ファイル項目',
    'pref_optional_tj_interest_date'            => '利息日',
    'pref_optional_tj_book_date'                => '記帳日',
    'pref_optional_tj_process_date'             => '処理日',
    'pref_optional_tj_due_date'                 => '期限',
    'pref_optional_tj_payment_date'             => '引き落とし日',
    'pref_optional_tj_invoice_date'             => '領収書発行日',
    'pref_optional_tj_internal_reference'       => '内部参照',
    'pref_optional_tj_notes'                    => '備考',
    'pref_optional_tj_attachments'              => '添付ファイル',
    'pref_optional_tj_external_url'             => '外部 URL',
    'pref_optional_tj_location'                 => '場所',
    'pref_optional_tj_links'                    => '取引リンク',
    'optional_field_meta_dates'                 => '日付',
    'optional_field_meta_business'              => 'ビジネス',
    'optional_field_attachments'                => '添付ファイル',
    'optional_field_meta_data'                  => '任意のメタデータ',
    'external_url'                              => '外部 URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => '新しい API アクセストークンが作成されたときに警告する',
    'pref_notification_transaction_creation'    => '取引が自動的に作成されたとき警告する',
    'pref_notification_user_login'              => '新しい場所からログインしたときに警告する',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Multi factor authentication is enabled',
    'pref_notification_disabled_mfa'            => 'Multi factor authentication is disabled',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => '通知',
    'pref_notifications_help'                   => 'これらは受け取る通知であるかどうかを示します。いくつかの通知には機密情報が含まれている場合があります。',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack Incoming Webhook URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => '財務管理',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Enable multi-factor authentication',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Firefly III からデータを消去',
    'purge_data_expl'                           => '「パージ」とは、「削除済みのものを削除する」ことを意味します。通常、Firefly IIIは何も永久には削除せず非表示にします。下のボタンはこれまでに削除されたレコードのすべてを削除します。',
    'delete_stuff_header'                       => '削除とパージ',
    'purge_all_data'                            => '削除済の全レコードをパージ',
    'purge_data'                                => 'データを消去',
    'purged_all_records'                        => '削除済の全レコードがパージされました。',
    'delete_data_title'                         => 'Firefly IIIからデータを削除',
    'permanent_delete_stuff'                    => 'あなたはFirefly IIIからデータを削除することができます。以下のボタンで、表示されているものと非表示のものが削除されます。 取り消しボタンはありませんが、必要な場合はサルベージできる項目がデータベースに残っている可能性があります。',
    'other_sessions_logged_out'                 => 'すべてのセッションでログアウトしました。',
    'delete_unused_accounts'                    => '未使用の口座を削除すると、オートコンプリートの一覧がきれいになります。',
    'delete_all_unused_accounts'                => '未使用の口座を削除',
    'deleted_all_unused_accounts'               => 'すべての未使用の口座は削除されました',
    'delete_all_budgets'                        => 'すべての予算を削除',
    'delete_all_categories'                     => 'すべてのカテゴリを削除',
    'delete_all_tags'                           => 'すべてのタグを削除',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'すべての貯金箱を削除',
    'delete_all_rules'                          => 'すべてのルールを削除',
    'delete_all_recurring'                      => 'すべての定期的な取引を削除',
    'delete_all_object_groups'                  => 'すべてのグループを削除',
    'delete_all_accounts'                       => 'すべての口座を削除',
    'delete_all_asset_accounts'                 => 'すべての資産口座を削除',
    'delete_all_expense_accounts'               => 'すべての支出口座を削除',
    'delete_all_revenue_accounts'               => 'すべての収入口座を削除',
    'delete_all_liabilities'                    => 'すべての負債を削除',
    'delete_all_transactions'                   => 'すべての取引を削除',
    'delete_all_withdrawals'                    => 'すべての引き出しを削除',
    'delete_all_deposits'                       => 'すべての入金を削除',
    'delete_all_transfers'                      => 'すべての送金を削除',
    'also_delete_transactions'                  => '口座を削除すると、関連するすべての出金、入金、送金も削除されます！',
    'deleted_all_budgets'                       => 'すべての予算が削除されました',
    'deleted_all_categories'                    => 'すべてのカテゴリが削除されました',
    'deleted_all_tags'                          => 'すべてのタグが削除されました',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'すべての貯金箱が削除されました',
    'deleted_all_rules'                         => 'すべてのルールとルールグループが削除されました',
    'deleted_all_object_groups'                 => 'すべてのグループが削除されました',
    'deleted_all_accounts'                      => 'すべてのアカウントが削除されました',
    'deleted_all_asset_accounts'                => 'すべての資産口座が削除されました',
    'deleted_all_expense_accounts'              => 'すべての支出口座が削除されました',
    'deleted_all_revenue_accounts'              => 'すべての収入口座が削除されました',
    'deleted_all_liabilities'                   => 'すべての負債が削除されました',
    'deleted_all_transactions'                  => 'すべての取引が削除されました',
    'deleted_all_withdrawals'                   => 'すべての引き出しが削除されました',
    'deleted_all_deposits'                      => 'すべての入金が削除されました',
    'deleted_all_transfers'                     => 'すべての送金が削除されました',
    'deleted_all_recurring'                     => 'すべての定期的な取引が削除されました',
    'change_your_password'                      => 'パスワードを変更する',
    'delete_account'                            => 'アカウントを削除',
    'current_password'                          => '現在のパスワード',
    'new_password'                              => '新しいパスワード',
    'new_password_again'                        => '新しいパスワード(確認)',
    'delete_your_account'                       => 'アカウントを削除',
    'delete_your_account_help'                  => '口座を削除すると、口座や取引など Firefly III に保存した<em>すべてのもの</em> が削除されます。',
    'delete_your_account_password'              => '続行するにはパスワードを入力してください',
    'password'                                  => 'パスワード',
    'are_you_sure'                              => '本当によろしいですか？これを元に戻すことはできません。',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'アカウントを削除',
    'invalid_current_password'                  => '現在のパスワードが正しくありません！',
    'password_changed'                          => 'パスワードが変更されました！',
    'should_change'                             => 'アイデアはパスワードを変更することです。',
    'invalid_password'                          => 'パスワードが正しくありません！',
    'what_is_pw_security'                       => '「パスワードの安全性確認」とは？',
    'secure_pw_title'                           => '安全なパスワードを選択する方法',
    'forgot_password_response'                  => 'ありがとうございます。このメールアドレスのアカウントが存在する場合は、受信トレイで手順を見つけられるでしょう。',
    'secure_pw_history'                         => '数日に一回は、どこかのサイトのユーザーパスワード漏洩のニュースを目にします。 ハッカーと泥棒は、あなたの個人情報を盗むために、これらのパスワードを使用するでしょう。この情報は大切です。',
    'secure_pw_ff'                              => 'インターネット上のあらゆるところで、同じパスワードを使用していますか？その場合、ひとつのサイトがパスワードを漏洩すると、ハッカーはあなたのすべてのデータにアクセスできてしまいます。 Firefly III があなたの財務記録を保護するためには、あなたが強力でユニークなパスワードを使用することが必要です。',
    'secure_pw_check_box'                       => 'Firefly III で使用するパスワードが過去に盗まれているかどうかを確認できます。 該当する場合、Firefly III はそのパスワードを使用しないことをお勧めします。',
    'secure_pw_working_title'                   => 'どのような仕組みですか？',
    'secure_pw_working'                         => 'チェックすると、Firefly III はあなたのパスワードの SHA1 ハッシュの最初の5文字を<a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Troy Hunt</a>のウェブサイトに送信し、リストにあるか確認します。これにより、最新の <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a> で推奨されている通り、あなたが安全ではないパスワードを使用するのを防ぎます。',
    'secure_pw_should'                          => 'チェックを入れるべき？',
    'secure_pw_long_password'                   => 'はい。常にパスワードが安全であることを確認してください。',
    'command_line_token'                        => 'コマンドライントークン',
    'explain_command_line_token'                => 'データのエクスポートなどのコマンドラインオプションを実行するには、このトークンが必要です。 それら慎重に扱うべきコマンドはトークンがなければ動作しません。私を含め、誰にもコマンドライントークンを共有しないでください。 もし紛失したり、疑心暗鬼に陥っている場合は、ボタンでトークンを再生成してください。',
    'regenerate_command_line_token'             => 'コマンドライントークンを再生成',
    'token_regenerated'                         => '新しいコマンドライントークンが生成されました',
    'change_your_email'                         => 'メールアドレスを変更する',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'メールアドレスを確認するまでログインできません。',
    'login_with_new_email'                      => '新しいメールアドレスでログインできるようになりました。',
    'login_with_old_email'                      => '古いメールアドレスで再度ログインできるようになりました。',
    'login_provider_local_only'                 => 'この操作は「:login_provider」による認証では使用できません。',
    'external_user_mgt_disabled'                => 'この操作は Firefly III がユーザ管理や認証処理を担わない場合には使用できません。',
    'external_auth_disabled'                    => 'この操作は Firefly III が認証処理を担わない場合には使用できません。',
    'delete_local_info_only'                    => "Firefly III がユーザー管理や認証処理に担わないため、この機能はローカルの Firefly III の情報のみを削除します。",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuthクライアント',
    'profile_oauth_no_clients'                  => 'OAuthクライアントを作成していません。',
    'profile_oauth_clients_external_auth'       => 'Autheliaのような外部認証プロバイダを使用している場合、OAuth クライアントは動作しません。パーソナルアクセストークンのみを使用できます。',
    'profile_oauth_clients_header'              => 'クライアント',
    'profile_oauth_client_id'                   => 'クライアント ID',
    'profile_oauth_client_name'                 => '名前',
    'profile_oauth_client_secret'               => 'シークレット',
    'profile_oauth_create_new_client'           => '新しいクライアントを作成',
    'profile_oauth_create_client'               => 'クライアントを作成',
    'profile_oauth_edit_client'                 => 'クライアントの編集',
    'profile_oauth_name_help'                   => 'ユーザーが認識、信頼するものです。',
    'profile_oauth_redirect_url'                => 'リダイレクト URL',
    'profile_oauth_redirect_url_help'           => 'アプリケーションの認証コールバック URL です。',
    'profile_authorized_apps'                   => '認証済みアプリケーション',
    'profile_authorized_clients'                => '認証済みクライアント',
    'profile_scopes'                            => 'スコープ',
    'profile_revoke'                            => '無効にする',
    'profile_oauth_client_secret_title'         => 'クライアントシークレット',
    'profile_oauth_client_secret_expl'          => '新しいクライアントシークレットです。 これは一度しか表示されないので、失くさないでください！このシークレットにより API リクエストを実行できます。',
    'profile_personal_access_tokens'            => 'パーソナルアクセストークン',
    'profile_personal_access_token'             => '個人アクセストークン',
    'profile_oauth_confidential'                => '機密',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => '新しいパーソナルアクセストークンです。 これは一度しか表示されないので、失くさないでください！このシークレットにより API リクエストを実行できます。',
    'profile_no_personal_access_token'          => 'パーソナルアクセストークンは作成されていません。',
    'profile_create_new_token'                  => '新しいトークンを作成',
    'profile_create_token'                      => 'トークンを作成',
    'profile_create'                            => '作成',
    'profile_save_changes'                      => '変更を保存',
    'profile_whoops'                            => 'おっと！',
    'profile_something_wrong'                   => '何か問題が発生しました！',
    'profile_try_again'                         => '問題が発生しました。もう一度やり直してください。',
    'amounts'                                   => '金額',
    'multi_account_warning_unknown'             => '作成する取引の種類に応じて、続く分割の引き出し口座や預け入れ口座は、取引の最初の分割で定義されているものによって覆される可能性があります。',
    'multi_account_warning_withdrawal'          => '続く分割の引き出し口座は、出金の最初の分割の定義によって覆されることに注意してください。',
    'multi_account_warning_deposit'             => '続く分割の預け入れ口座は、送金の最初の分割の定義によって覆されることに注意してください。',
    'multi_account_warning_transfer'            => '続く分割の預け入れ口座と引き出し口座は、送金の最初の分割の定義によって覆されることに注意してください。',


    // export data:
    'export_data_title'                         => 'Firefly III からデータをエクスポート',
    'export_data_menu'                          => 'データのエクスポート',
    'export_data_bc'                            => 'Firefly III からデータをエクスポート',
    'export_data_main_title'                    => 'Firefly III からデータをエクスポート',
    'export_data_expl'                          => 'このリンクで Firefly IIIからすべての取引とメタデータをエクスポートできます。処理の詳細についてはヘルプ (右上の(？)アイコン) を参照してください。',
    'export_data_all_transactions'              => 'すべての取引をエクスポート',
    'export_data_advanced_expl'                 => 'より高度、または特定のエクスポートが必要な場合、コンソールコマンド <code>php artisan help foreflily-ii:export-data</code> の使用方法のヘルプを参照してください。',

    // attachments
    'nr_of_attachments'                         => '1個の添付ファイル|:count 個の添付ファイル',
    'attachments'                               => '添付ファイル',
    'edit_attachment'                           => '添付ファイル「:name」の編集',
    'update_attachment'                         => '添付ファイルを更新',
    'delete_attachment'                         => '添付ファイル「:name」の削除',
    'attachment_deleted'                        => '添付ファイル「:name」を削除しました',
    'liabilities_deleted'                       => '債務「:name」を削除しました',
    'attachment_updated'                        => '添付ファイル「:name」を更新しました',
    'upload_max_file_size'                      => '最大ファイルサイズ: :size',
    'list_all_attachments'                      => 'すべての添付ファイルのリスト',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => '支出',
    'title_withdrawal'                          => '支出',
    'title_revenue'                             => '収益 / 収入',
    'title_deposit'                             => '収益 / 収入',
    'title_transfer'                            => '送金',
    'title_transfers'                           => '送金',
    'submission_options'                        => '送信オプション',
    'apply_rules_checkbox'                      => 'ルールを適用',
    'fire_webhooks_checkbox'                    => 'Webhookを実行',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'この取引はすでに出金です',
    'convert_is_already_type_Deposit'           => 'この取引はすでに入金です',
    'convert_is_already_type_Transfer'          => 'この取引はすでに送金です',
    'convert_to_Withdrawal'                     => '「:description」を出金に変換',
    'convert_to_Deposit'                        => '「:description」を入金に変換',
    'convert_to_Transfer'                       => '「:description」を送金に変換',
    'convert_options_WithdrawalDeposit'         => '出金を入金に変換',
    'convert_options_WithdrawalTransfer'        => '出金を送金に変換',
    'convert_options_DepositTransfer'           => '入金を送金に変換',
    'convert_options_DepositWithdrawal'         => '入金を出金に変換',
    'convert_options_TransferWithdrawal'        => '送金を出金に変換',
    'convert_options_TransferDeposit'           => '送金を入金に変換',
    'convert_Withdrawal_to_deposit'             => 'この出金を入金に変換',
    'convert_Withdrawal_to_transfer'            => 'この出金を送金に変換',
    'convert_Deposit_to_withdrawal'             => 'この入金を出金に変換',
    'convert_Deposit_to_transfer'               => 'この入金を送金に変換',
    'convert_Transfer_to_deposit'               => 'この送金を入金に変換',
    'convert_Transfer_to_withdrawal'            => 'この送金を出金に変換',
    'convert_please_set_revenue_source'         => 'お金が入ってくる収入口座を選んでください。',
    'convert_please_set_asset_destination'      => 'お金が入る資産口座を選んでください。',
    'convert_please_set_expense_destination'    => 'お金が出ていく支出口座を選んでください。',
    'convert_please_set_asset_source'           => 'お金が入ってくる資産口座を選んでください。',
    'convert_expl_w_d'                          => '出金を入金に変換すると、お金は出金ではなく表示された預け入れ口座への入金となります。 |出金を入金に変換すると、お金は出金ではなく表示された預け入れ口座への入金となります。',
    'convert_expl_w_t'                          => '出金を送金に変換すると、お金は元の支出口座での支出ではなく、引き出し口座から他の資産口座または債務口座への送金となります。|出金を送金に変換すると、お金は元の支出口座での支出ではなく、引き出し口座から他の資産口座または債務口座への送金となります。',
    'convert_expl_d_w'                          => '入金を出金に変換すると、お金は入金ではなく、表示された引き出し口座からの出金となります。 |入金を出金に変換すると、お金は入金ではなく、表示された引き出し口座からの出金となります。',
    'convert_expl_d_t'                          => '入金を送金に変換すると、お金は資産口座や債務口座から、一覧にある預け入れ口座への入金となります。|入金を送金に変換すると、お金は資産口座や債務口座から、一覧にある預け入れ口座への入金となります。',
    'convert_expl_t_w'                          => '送金を出金に変換すると、預け入れ口座への送金ではなく、ここで設定した預け入れ口座での支出となります。|送金を出金に変換すると、預け入れ口座への送金ではなく、ここで設定した相手先口座での支出となります。',
    'convert_expl_t_d'                          => '送金を入金に変換すると、預け入れ口座への送金ではなく、ここで設定した預け入れ口座への入金となります。|送金を入金に変換すると、預け入れ口座への送金ではなく、ここで設定した預け入れ口座への入金となります。',
    'convert_select_sources'                    => '変換を完了するには、以下で新しい引き出し口座を設定してください。 |変換を完了するには、以下で新しい引き出し口座を設定してください。',
    'convert_select_destinations'               => '変換を完了するには、以下で新しい預け入れ口座を設定してください。 |変換を完了するには、以下で新しい預け入れ口座を設定してください。',
    'converted_to_Withdrawal'                   => '取引は引き出しに変換されました',
    'converted_to_Deposit'                      => '取引は入金に変換されました',
    'converted_to_Transfer'                     => '取引は送金に変換されました',
    'invalid_convert_selection'                 => '選択した口座は既にこの取引で使用されているか、存在しません。',
    'source_or_dest_invalid'                    => '正しい取引詳細が見つかりません。変換はできません。',
    'convert_to_withdrawal'                     => '出金に変換',
    'convert_to_deposit'                        => '入金に変換',
    'convert_to_transfer'                       => '送金に変換',

    // create new stuff:
    'create_new_withdrawal'                     => '新規出金を作成',
    'create_new_deposit'                        => '新規入金を作成',
    'create_new_transfer'                       => '新規送金を作成',
    'create_new_asset'                          => '新しい資産口座を作成',
    'create_new_liabilities'                    => '新しい責任を作成',
    'create_new_expense'                        => '新しい支出口座を作成',
    'create_new_revenue'                        => '新しい収入口座を作成',
    'create_new_piggy_bank'                     => '新規貯金箱の作成',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => '新しいサブスクリプションを作成',
    'create_new_rule'                           => '新しいルールを作成',

    // currencies:
    'create_currency'                           => '新しい通貨を作成',
    'store_currency'                            => '新しい通貨を保存',
    'update_currency'                           => '通貨を更新',
    'new_default_currency'                      => '「:name」はデフォルト通貨です。',
    'default_currency_failed'                   => '「:name」をデフォルト通貨にすることができませんでした。ログを確認してください。',
    'cannot_delete_currency'                    => ':nameは使用されているため削除できません。',
    'cannot_delete_fallback_currency'           => ':name はシステムのフォールバック通貨であり、削除できません。',
    'cannot_disable_currency_journals'          => '取引がまだ使用しているため、:name を無効にできません。',
    'cannot_disable_currency_last_left'         => '唯一の有効な通貨であるため、:name を無効にできません。',
    'cannot_disable_currency_account_meta'      => '資産口座で使用されているため、:name を無効にできません。',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => '定期的な取引で使用されているため、:name を無効にできません。',
    'cannot_disable_currency_available_budgets' => '有効な予算で使用されているため、:name を無効にできません。',
    'cannot_disable_currency_budget_limits'     => '予算制限で使用されているため、:name を無効にできません。',
    'cannot_disable_currency_current_default'   => '現在のデフォルト通貨であるため、:name を無効にできません。',
    'cannot_disable_currency_system_fallback'   => 'システムのデフォルト通貨であるため、:name を無効にできません。',
    'disable_EUR_side_effects'                  => 'Euro はシステムの緊急フォールバック通貨です。無効にすると意図しない副作用が発生し、保証できません。',
    'deleted_currency'                          => '通貨「:name」を削除しました',
    'created_currency'                          => '通貨「:name」が作成されました',
    'could_not_store_currency'                  => '新しい通貨を保存できませんでした。',
    'updated_currency'                          => '通貨「:name」が更新されました',
    'ask_site_owner'                            => '通貨の追加、削除、編集を:ownerに依頼してください。',
    'currencies_intro'                          => 'Firefly III はさまざまな通貨をサポートしており、ここで設定および有効にできます。',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'デフォルトにする',
    'default_currency'                          => 'デフォルト',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => '無効',
    'enable_currency'                           => '有効',
    'disable_currency'                          => '無効',
    'currencies_default_disabled'               => 'これらの通貨のほとんどはデフォルトで無効になっています。使用するには、まず有効にする必要があります。',
    'currency_is_now_enabled'                   => '通貨「:name」が有効になりました',
    'could_not_enable_currency'                 => '通貨「:name」を有効にできませんでした。ログを確認してください。',
    'currency_is_now_disabled'                  => '通貨「:name」は無効になりました',
    'could_not_disable_currency'                => '通貨「:name」を無効にできませんでした。使用中ではありませんか？',

    // forms:
    'mandatoryFields'                           => '必須項目',
    'optionalFields'                            => '任意項目',
    'options'                                   => 'オプション',

    // budgets:
    'daily_budgets'                             => '毎日の予算',
    'weekly_budgets'                            => '毎週の予算',
    'monthly_budgets'                           => '毎月の予算',
    'quarterly_budgets'                         => '四半期の予算',
    'half_year_budgets'                         => '半年間の予算',
    'yearly_budgets'                            => '年間の予算',
    'other_budgets'                             => '任意の期間の予算',
    'budget_limit_not_in_range'                 => 'この金額は :start から :end: まで適用されます:',
    'total_available_budget'                    => '利用可能な予算の合計 (:start から :end まで)',
    'total_available_budget_in_currency'        => ':currencyで利用可能な予算の合計',
    'see_below'                                 => '下を参照',
    'create_new_budget'                         => '新しい予算を作成する',
    'store_new_budget'                          => '新しい予算を保存',
    'stored_new_budget'                         => '新しい予算「:name」を保存しました',
    'available_between'                         => ':start から :end までの利用可能額',
    'transactionsWithoutBudget'                 => '予算外の支出',
    'transactions_no_budget'                    => ':start から :end までの予算外の支出',
    'spent_between'                             => ':start から :end までの支出済み',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => '利用可能な金額を設定',
    'update_available_amount'                   => '利用可能な金額を更新',
    'ab_basic_modal_explain'                    => 'このフォームで、指定期間でいくらの予算(総額、:currency)になるかを示します。',
    'createBudget'                              => '新しい予算',
    'invalid_currency'                          => 'これは無効な通貨です',
    'invalid_amount'                            => '金額を入力してください',
    'set_ab'                                    => '利用可能な予算額が設定されました',
    'updated_ab'                                => '利用可能な予算額が更新されました',
    'deleted_ab'                                => '利用可能な予算額が削除されました',
    'deleted_bl'                                => '予算額が削除されました',
    'alt_currency_ab_create'                    => '別の通貨で利用可能な予算を設定する',
    'bl_create_btn'                             => '予算を別の通貨で設定',
    'inactiveBudgets'                           => 'アクティブでない予算',
    'without_budget_between'                    => ':start から :end までの予算外の取引',
    'delete_budget'                             => '予算「:name」を削除する',
    'deleted_budget'                            => '予算「:name」を削除しました',
    'edit_budget'                               => '予算「:name」を編集',
    'updated_budget'                            => '予算「:name」を編集しました',
    'update_amount'                             => '金額を更新',
    'update_budget'                             => '予算を更新',
    'update_budget_amount_range'                => ':start から :end までの利用可能な金額を更新する',
    'set_budget_limit_title'                    => ':start から :end の間の予算「:budget」の予算額を設定',
    'set_budget_limit'                          => '予算額を設定',
    'budget_period_navigator'                   => '期間ナビゲーター',
    'info_on_available_amount'                  => '利用可能額は？',
    'available_amount_indication'               => 'これらの金額から、予算総額がどうなるか見込んでください。',
    'suggested'                                 => '推奨',
    'average_between'                           => ':start から :end までの平均',
    'transferred_in'                            => '送金 (入)',
    'transferred_away'                          => '送金 (出)',
    'auto_budget_none'                          => '自動予算なし',
    'auto_budget_reset'                         => '期間ごとに定額を設定する',
    'auto_budget_rollover'                      => '期間ごとに金額を追加',
    'auto_budget_adjusted'                      => '期間ごとに金額を追加し過剰な支出のために補正します',
    'auto_budget_period_daily'                  => '毎日',
    'auto_budget_period_weekly'                 => '毎週',
    'auto_budget_period_monthly'                => '毎月',
    'auto_budget_period_quarterly'              => '四半期ごと',
    'auto_budget_period_half_year'              => '半年ごと',
    'auto_budget_period_yearly'                 => '年ごと',
    'auto_budget_help'                          => 'この機能の詳細については、ヘルプを参照してください。右上の (？) アイコンをクリックします。',
    'auto_budget_reset_icon'                    => 'この予算は定期的に設定されます',
    'auto_budget_rollover_icon'                 => '予算額は定期的に増加します',
    'auto_budget_adjusted_icon'                 => '予算額は定期的に増加し過剰な支出を補正します',
    'remove_budgeted_amount'                    => ':currency で予算を削除する',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'サブスクリプション',
    'not_expected_period'                       => 'この期間には予定なし',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '(まだ) なし',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => '繰り返し',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => '接続した取引',
    'auto_match_on'                             => 'Firefly III によって自動的に適合',
    'auto_match_off'                            => 'Firefly III によって自動的に適合しない',
    'next_expected_match'                       => '次のマッチ予測',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'もっと見る',
    'rescan_old'                                => 'すべての取引にルールを再度実行する',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => ':start から :end までの予測',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'スキップする',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => '非アクティブなルール',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => '予定日 :date',
    'bill_expected_date_js'                     => '予定日 {date}',
    'expected_amount'                           => '(予想される) 金額',
    'bill_paid_on'                              => '{date} に支払い済み',
    'bill_repeats_weekly'                       => '毎週の繰り返し',
    'bill_repeats_monthly'                      => '毎月の繰り返し',
    'bill_repeats_quarterly'                    => '四半期ごとの繰り返し',
    'bill_repeats_half-year'                    => '半年ごとの繰り返し',
    'bill_repeats_yearly'                       => '毎年の繰り返し',
    'bill_repeats_weekly_other'                 => '1週おきの繰り返し',
    'bill_repeats_monthly_other'                => '1ヶ月おきの繰り返し',
    'bill_repeats_quarterly_other'              => '四半期おきの繰り返し',
    'bill_repeats_half-year_other'              => '毎年の繰り返し',
    'bill_repeats_yearly_other'                 => '一年おきの繰り返し',
    'bill_repeats_weekly_skip'                  => '{skip} 週おきの繰り返し',
    'bill_repeats_monthly_skip'                 => '{skip} ヶ月おきの繰り返し',
    'bill_repeats_quarterly_skip'               => '{skip} 四半期おきの繰り返し',
    'bill_repeats_half-year_skip'               => '{skip} 半期おきの繰り返し',
    'bill_repeats_yearly_skip'                  => '{skip} 年おきの繰り返し',
    'subscriptions'                             => '講読',
    'go_to_subscriptions'                       => 'サブスクリプションに移動',
    'forever'                                   => '無期限',
    'extension_date_is'                         => '延長日は {date} です',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => '債務額',
    'i_owe_amount'                              => '債務額',
    'inactive_account_link'                     => ':count 件の非アクティブ (アーカイブ済み) 口座があり、この別々のページで表示できます。|:count 件の非アクティブ (アーカイブ済み) 口座があり、この別々のページで表示できます。',
    'all_accounts_inactive'                     => 'これらは、アクティブでないアカウントです。',
    'active_account_link'                       => 'このリンクはアクティブな口座に戻ります。',
    'account_missing_transaction'               => '口座 #:id「:name」は直接見ることはできません。Firefly にリダイレクト情報がありません。',
    'cc_monthly_payment_date_help'              => '無視されますが、年と月を選択してください。月内の日のみ、意味があります。',
    'details_for_asset'                         => '資産口座「:name」の詳細',
    'details_for_expense'                       => '支出口座「:name」の詳細',
    'details_for_revenue'                       => '収入口座「:name」の詳細',
    'details_for_cash'                          => '現金口座「:name」の詳細',
    'store_new_asset_account'                   => '新しい口座を保存',
    'store_new_expense_account'                 => '新しい支出口座を保存',
    'store_new_revenue_account'                 => '新しい収入口座を保存',
    'edit_asset_account'                        => '資産口座「:name」を編集',
    'edit_expense_account'                      => '支出口座「:name」を編集',
    'edit_revenue_account'                      => '収入口座「:name」を編集',
    'delete_asset_account'                      => '資産口座「:name」を削除',
    'delete_expense_account'                    => '支出口座「:name」を削除',
    'delete_revenue_account'                    => '収入口座「:name」を削除',
    'delete_liabilities_account'                => '債務「:name」を削除',
    'asset_deleted'                             => '資産口座「:name」を正常に削除しました',
    'account_deleted'                           => '口座「:name」を正常に削除しました',
    'expense_deleted'                           => '支出口座「:name」を正常に削除しました',
    'revenue_deleted'                           => '収入口座「:name」を正常に削除しました',
    'update_asset_account'                      => '資産口座を更新',
    'update_undefined_account'                  => '口座情報の更新',
    'update_liabilities_account'                => '債務を更新',
    'update_expense_account'                    => '支出口座を編集する',
    'update_revenue_account'                    => '収入口座を更新',
    'make_new_asset_account'                    => '新しい資産口座を作成',
    'make_new_expense_account'                  => '新しい支出口座を作成',
    'make_new_revenue_account'                  => '新しい収入口座を作成',
    'make_new_liabilities_account'              => '新しい債務を作成',
    'asset_accounts'                            => '資産口座',
    'undefined_accounts'                        => '口座',
    'asset_accounts_inactive'                   => '資産口座 (非アクティブ)',
    'expense_account'                           => '支出口座',
    'expense_accounts'                          => '支出口座',
    'expense_accounts_inactive'                 => '支出口座(非アクティブ)',
    'revenue_account'                           => '収入口座',
    'revenue_accounts'                          => '収入口座',
    'revenue_accounts_inactive'                 => '収入口座 (非アクティブ)',
    'cash_accounts'                             => '現金口座',
    'Cash account'                              => '現金口座',
    'liabilities_accounts'                      => '債務',
    'liabilities_accounts_inactive'             => '負債 (非アクティブ)',
    'reconcile_account'                         => '口座「:account」を照合',
    'overview_of_reconcile_modal'               => '照合の概要',
    'delete_reconciliation'                     => '照合を削除',
    'update_reconciliation'                     => '照合を更新',
    'amount_cannot_be_zero'                     => '金額はゼロにできません',
    'end_of_reconcile_period'                   => '照合期間の終了：:period',
    'start_of_reconcile_period'                 => '照合期間の開始：:period',
    'start_balance'                             => '開始残高',
    'end_balance'                               => '終了残高',
    'update_balance_dates_instruction'          => '上記の金額と日付を銀行明細と一致させ、「照合を開始」を押してください',
    'select_transactions_instruction'           => '銀行明細に表示される取引を選択します。',
    'select_range_and_balance'                  => 'まず、日付範囲と残高を確認します。次に「照合を開始」を押します',
    'date_change_instruction'                   => 'ここで日付の範囲を変更すると、すべての進行状況が失われます。',
    'update_selection'                          => '選択を更新',
    'store_reconcile'                           => '照合を保存',
    'reconciliation_transaction'                => '取引の照合',
    'Reconciliation'                            => '照合',
    'reconciliation'                            => '照合',
    'reconcile_options'                         => '照合オプション',
    'reconcile_range'                           => '照合範囲',
    'start_reconcile'                           => '照合を開始',
    'cash_account_type'                         => '現金',
    'cash'                                      => '現金',
    'cant_find_redirect_account'                => 'Firefly III はあなたをリダイレクトしようとしましたが、できませんでした。申し訳ありません。インデックスに戻ります。',
    'account_type'                              => '口座種別',
    'save_transactions_by_moving'               => '別の口座に移動してこの取引を保存します:|別の口座に移動してこれら取引を保存します:',
    'save_transactions_by_moving_js'            => '取引がありません|この取引を別の口座に移し保存します。|これらの取引を別の口座に移し保存します。',
    'stored_new_account'                        => '新しい口座「:name」が保存されました！',
    'stored_new_account_js'                     => '新しい口座「<a href="accounts/show/{ID}">{name}</a>」が保存されました！',
    'updated_account'                           => '口座「:name」を更新しました',
    'updated_account_js'                        => '口座「<a href="accounts/show/{ID}">{title}</a>」を更新しました。',
    'credit_card_options'                       => 'クレジットカードオプション',
    'no_transactions_account'                   => '資産口座「:name」の取引は(この期間中)ありません。',
    'no_transactions_period'                    => '(この期間は) 取引がありません。',
    'no_data_for_chart'                         => 'このチャートを生成するのに十分な情報がまだありません。',
    'select_at_least_one_account'               => '少なくとも1つ資産口座を選択してください',
    'select_at_least_one_category'              => '少なくとも1つのカテゴリを選択してください',
    'select_at_least_one_budget'                => '少なくとも1つの予算を選択してください',
    'select_at_least_one_tag'                   => '少なくとも 1 つのタグを選択してください',
    'select_at_least_one_expense'               => '少なくとも1つの支出 / 収入口座の組み合わせを選択してください。組み合わせがない (リストが空の) 場合はこのレポートは利用できません。',
    'account_default_currency'                  => 'これはこの口座の既定通貨になります。',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Firefly III の元帳には、銀行が示すよりも多くの残高があります。 どう対処すべきかを選択し、「照合の確認」を押します。',
    'reconcile_has_less'                        => 'Firefly III の元帳には、銀行が示すよりも残高がありません。 どう対処すべきかを選択し、「照合の確認」を押します。',
    'reconcile_is_equal'                        => 'Firefly III 台帳と銀行取引明細が一致しています。何もする必要はありません。入力内容を確認するには「照合を確認」を押してください。',
    'create_pos_reconcile_transaction'          => '選択した取引を消去し、この資産口座に:amount を加算訂正します。',
    'create_neg_reconcile_transaction'          => '選択した取引を消去し、この資産口座に:amount を減算訂正します。',
    'reconcile_do_nothing'                      => '選択した取引を消去しますが、訂正はしません。',
    'reconcile_go_back'                         => '調整は後でいつでも編集または削除できます。',
    'must_be_asset_account'                     => '資産口座のみ照合できます',
    'reconciliation_stored'                     => '照合を保存しました',
    'reconciliation_error'                      => '取引は照合済みとしてマークされましたが、エラーにより訂正は保存されていません: :error。',
    'reconciliation_transaction_title'          => '照合 (:from から :to)',
    'sum_of_reconciliation'                     => '照合の合計',
    'reconcile_this_account'                    => 'この口座を照合',
    'reconcile'                                 => '照合',
    'show'                                      => '表示',
    'confirm_reconciliation'                    => '照合を確認',
    'submitted_start_balance'                   => '送信された開始残高',
    'selected_transactions'                     => '選択した取引 (:count)',
    'already_cleared_transactions'              => '取引が消去されました (:count)',
    'submitted_end_balance'                     => '送信された終了残高',
    'initial_balance_description'               => '":account" の初期残高',
    'liability_credit_description'              => '「:account」の債務信用',
    'interest_calc_'                            => '不明',
    'interest_calc_daily'                       => '1日あたり',
    'interest_calc_monthly'                     => '1ヶ月あたり',
    'interest_calc_yearly'                      => '1年あたり',
    'interest_calc_weekly'                      => '1週あたり',
    'interest_calc_half-year'                   => '半年あたり',
    'interest_calc_quarterly'                   => '四半期あたり',
    'initial_balance_account'                   => ':account の初期残高',
    'list_options'                              => 'リストオプション',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => '新しいカテゴリ',
    'create_new_category'                       => '新しい出金を作成する',
    'without_category'                          => 'カテゴリなし',
    'update_category'                           => 'カテゴリを更新',
    'updated_category'                          => 'カテゴリ「:name」を更新しました',
    'categories'                                => 'カテゴリ',
    'edit_category'                             => 'カテゴリ「:name」を編集',
    'no_category'                               => '(カテゴリなし)',
    'unknown_category_plain'                    => 'カテゴリなし',
    'category'                                  => 'カテゴリ',
    'delete_category'                           => 'カテゴリ":name" を削除する',
    'deleted_category'                          => 'カテゴリ「:name」を削除しました',
    'store_category'                            => '新しいカテゴリを保存',
    'stored_category'                           => '新しいカテゴリ「:name」を保存しました',
    'without_category_between'                  => ':start から :end までのカテゴリなし',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => '照合を取り消す',
    'update_withdrawal'                         => '出金を更新',
    'update_deposit'                            => '入金を更新',
    'update_transaction'                        => '取引を更新',
    'update_transfer'                           => '送金を更新',
    'updated_withdrawal'                        => '出金「:description」を更新しました',
    'updated_deposit'                           => '入金「:description」を更新しました',
    'updated_transfer'                          => '送金「:description」を更新しました',
    'no_changes_withdrawal'                     => '出金「:description」は変更されませんでした。',
    'no_changes_deposit'                        => '入金「:description」は変更されませんでした。',
    'no_changes_transfer'                       => '送金「:description」は変更されませんでした。',
    'delete_withdrawal'                         => '出金「:description」を削除',
    'delete_deposit'                            => '入金「:description」を削除',
    'delete_transfer'                           => '送金「:description」を削除',
    'deleted_withdrawal'                        => '出金「:description」を削除しました',
    'deleted_deposit'                           => '入金「:description」を削除しました',
    'deleted_transfer'                          => '送金「:description」を削除しました',
    'deleted_reconciliation'                    => '取引照合":description"を削除しました',
    'stored_journal'                            => '取引「:description」を作成しました',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => '新しい取引を作成しました',
    'updated_journal_no_descr'                  => '取引を更新しました',
    'select_transactions'                       => '取引を選択',
    'rule_group_select_transactions'            => '「:title」を取引に適用',
    'rule_select_transactions'                  => '「:title」を取引に適用',
    'stop_selection'                            => '選択した取引を停止',
    'reconcile_selected'                        => '照合',
    'mass_delete_journals'                      => '取引の一括削除',
    'mass_edit_journals'                        => '取引の一括編集',
    'mass_bulk_journals'                        => '取引を一括編集',
    'mass_bulk_journals_explain'                => 'このフォームでは、以下の取引のプロパティを一括で変更できます。 表示されているパラメータを変更すると、表内のすべての取引が更新されます。',
    'part_of_split'                             => 'この取引は分割取引の一部です。 すべての分割を選択していない場合は、取引の半分だけの変更となってしまいます。',
    'bulk_set_new_values'                       => '新しい値を設定するには、以下に入力します。空のままにすると、すべての入力が空になります。 また、出金のみが予算を与えられることに注意してください。',
    'no_bulk_category'                          => 'カテゴリを更新しない',
    'no_bulk_budget'                            => '予算を更新しない',
    'no_bulk_tags'                              => 'タグを更新しない',
    'replace_with_these_tags'                   => 'これらのタグに置換',
    'append_these_tags'                         => 'これらのタグを追加',
    'mass_edit'                                 => '選択したものを個別に編集',
    'bulk_edit'                                 => '選択したものを一括編集',
    'mass_delete'                               => '選択したものを削除',
    'cannot_edit_other_fields'                  => '表示するスペースがないため、ここにある以外のフィールドを一括編集することはできません。 ここにない項目を編集するには、リンクから一つ一つ編集してください。',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(予算なし)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => '予算ごとの口座',
    'account_per_category'                      => 'カテゴリごとの口座',
    'create_new_object'                         => '作成',
    'empty'                                     => '(空)',
    'all_other_budgets'                         => '(その他の予算すべて)',
    'all_other_accounts'                        => '(その他の口座すべて)',
    'expense_per_source_account'                => '引き出し口座ごとの支出',
    'expense_per_destination_account'           => '預け入れ口座ごとの支出',
    'income_per_destination_account'            => '預け入れ口座ごとの収入',
    'spent_in_specific_category'                => 'カテゴリ「:category」の支出',
    'earned_in_specific_category'               => 'カテゴリ「:category」の収入',
    'spent_in_specific_tag'                     => 'タグ「:tag」の支出',
    'earned_in_specific_tag'                    => 'タグ「:tag」の収入',
    'income_per_source_account'                 => '引き出し口座ごとの収入',
    'average_spending_per_destination'          => '預け入れ口座ごとの平均支出',
    'average_spending_per_source'               => '引き出し口座あたりの平均支出',
    'average_earning_per_source'                => '引き出し口座あたりの平均収益',
    'average_earning_per_destination'           => '預け入れ口座あたりの平均収入',
    'account_per_tag'                           => 'タグごとの口座',
    'tag_report_expenses_listed_once'           => '支出と収入は2重表示されません。取引に複数のタグがある場合は、そのタグの1つにのみ表示される可能性があります。 このリストはデータが欠けているように見えるかもしれませんが、金額は正しいです。',
    'double_report_expenses_charted_once'       => '支出と収入は2重表示されません。取引に複数のタグがある場合は、そのタグの1つにのみ表示される可能性があります。 このリストはデータが欠けているように見えるかもしれませんが、金額は正しいです。',
    'tag_report_chart_single_tag'               => 'このチャートは単一のタグを表します。 取引に複数のタグがある場合、ここに表示されるものは他のタグのチャートにも反映される可能性があります。',
    'tag'                                       => 'タグ',
    'no_budget_squared'                         => '(予算なし)',
    'perm-delete-many'                          => '一度に多くのアイテムを削除すると非常に混乱する可能性があります。注意してください。 このページから分割取引の一部を削除することができますので、ご注意ください。',
    'mass_deleted_transactions_success'         => ':count 件の取引を削除しました。|:count 件の取引を削除しました。',
    'mass_edited_transactions_success'          => ':count 件の取引を更新しました。|:count 件の取引を更新しました。',
    'opt_group_'                                => '(口座種別なし)',
    'opt_group_no_account_type'                 => '(取引種別なし)',
    'opt_group_defaultAsset'                    => 'デフォルトの資産口座',
    'opt_group_savingAsset'                     => '貯蓄口座',
    'opt_group_sharedAsset'                     => '共有資産口座',
    'opt_group_ccAsset'                         => 'クレジットカード',
    'opt_group_cashWalletAsset'                 => '現金',
    'opt_group_expense_account'                 => '支出口座',
    'opt_group_revenue_account'                 => '収入口座',
    'opt_group_l_Loan'                          => '債務：ローン',
    'opt_group_cash_account'                    => '現金口座',
    'opt_group_l_Debt'                          => '債務：借金',
    'opt_group_l_Mortgage'                      => '債務：住宅ローン',
    'opt_group_l_Credit card'                   => '債務：クレジットカード',
    'notes'                                     => '備考',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => '取引を保存できませんでした。ログファイルを確認してください。',
    'attachment_not_found'                      => '添付ファイルが見つかりませんでした。',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">取引 #{ID}「{title}」</a> が保存されました。',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">取引 #{ID}</a> が保存されました。',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">取引 #{ID}「{title}」</a> が更新されました。',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">取引 #{ID}</a>「{title}」は変更されませんでした。',
    'first_split_decides'                       => '最初の分割がこの項目の値を決定します。',
    'first_split_overrules_source'              => '最初の分割が引き出し口座を覆す可能性があります',
    'first_split_overrules_destination'         => '最初の分割が預け入れ口座を覆す可能性があります',
    'spent_x_of_y'                              => '{amount} / {total} を支出しました',

    // new user:
    'welcome'                                   => 'Firefly IIIへようこそ！',
    'submit'                                    => '送信',
    'submission'                                => '送信',
    'submit_yes_really'                         => '送信 (私は自分が何をしているかわかっています)',
    'getting_started'                           => 'さあ、はじめよう',
    'to_get_started'                            => 'Firefly III が正常にインストールされました。 始めるには、銀行名とメイン口座の残高を入力してください。 複数の口座を持っている場合も心配いりません。後で追加することができます。Firefly III は始めるため、ひとつ必要としているだけです。',
    'savings_balance_text'                      => 'Firefly III は自動的に貯蓄口座を作成します。 初期状態では貯蓄口座にお金はありませんが、Firefly III に残高を入力すれば、それが保存されます。',
    'finish_up_new_user'                        => '以上です！ <strong>送信</strong>を押してください。Firefly IIIのホームに移動します。',
    'stored_new_accounts_new_user'              => 'やった！新しい口座が保存されました。',
    'set_preferred_language'                    => 'Firefly III を別の言語で使用する場合は、こちらで設定してください。',
    'language'                                  => '言語',
    'new_savings_account'                       => ':bank_name 貯蓄口座',
    'cash_wallet'                               => '現金',
    'currency_not_present'                      => '普段使用している通貨が表示されていなくても、心配いりません。オプション > 通貨 であなたの通貨を作成できます。',

    // home page:
    'transaction_table_description'             => '取引表',
    'opposing_account'                          => '対する口座',
    'yourAccounts'                              => 'あなたの口座',
    'your_accounts'                             => '口座の概要',
    'category_overview'                         => 'カテゴリ概要',
    'expense_overview'                          => '支出口座の概要',
    'revenue_overview'                          => '収入口座の概要',
    'budgetsAndSpending'                        => '予算と出費',
    'budgets_and_spending'                      => '予算と出費',
    'go_to_budget'                              => '予算「{budget}」へ移動',
    'go_to_deposits'                            => '入金へ移動',
    'go_to_expenses'                            => '支出へ移動',
    'savings'                                   => '貯蓄',
    'newWithdrawal'                             => '新しい支出',
    'newDeposit'                                => '新しい入金',
    'newTransfer'                               => '新しい送金',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => '1日あたり',
    'left_to_spend_per_day'                     => '1日あたりの残り支出額',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'カスタム期間',
    'reset_to_current'                          => '現在の期間にリセット',
    'select_period'                             => '期間を選択',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => '通貨',
    'preferences'                               => '設定',
    'logout'                                    => 'ログアウト',
    'logout_other_sessions'                     => 'すべてのセッションからログアウト',
    'toggleNavigation'                          => 'ナビゲーションを切り替え',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => '検索...',
    'version'                                   => 'バージョン',
    'dashboard'                                 => 'ダッシュボード',
    'income_and_expense'                        => '収入と支出',
    'all_money'                                 => 'すべてのお金',
    'unknown_source_plain'                      => '不明な引き出し口座',
    'unknown_dest_plain'                        => '不明な預け入れ口座',
    'unknown_any_plain'                         => '不明な口座',
    'unknown_budget_plain'                      => '予算なし',
    'available_budget'                          => '有効な予算 ({currency})',
    'currencies'                                => '通貨',
    'activity'                                  => '活動',
    'usage'                                     => '使用状況',
    'accounts'                                  => '口座',
    'Asset account'                             => '資産口座',
    'Default account'                           => '資産口座',
    'Expense account'                           => '支出口座',
    'Revenue account'                           => '収入口座',
    'Initial balance account'                   => '初期口座残高',
    'account_type_Asset account'                => '資産口座',
    'account_type_Expense account'              => '支出口座',
    'account_type_Revenue account'              => '収入口座',
    'account_type_Debt'                         => '借金',
    'account_type_Loan'                         => 'ローン',
    'account_type_Mortgage'                     => '住宅ローン',
    'account_type_debt'                         => '借金',
    'account_type_loan'                         => 'ローン',
    'account_type_mortgage'                     => '住宅ローン',
    'account_type_Credit card'                  => 'クレジットカード',
    'credit_card_type_monthlyFull'              => '全額毎月支払い',
    'liability_direction_credit'                => 'この借金を負っている',
    'liability_direction_debit'                 => 'この借金を他の誰かに借りている',
    'liability_direction_credit_short'          => 'この負債を負っている',
    'liability_direction_debit_short'           => 'この負債を負う',
    'liability_direction__short'                => '不明',
    'liability_direction_null_short'            => '不明',
    'Liability credit'                          => '債務信用',
    'budgets'                                   => '予算',
    'tags'                                      => 'タグ',
    'reports'                                   => 'レポート',
    'transactions'                              => '取引',
    'expenses'                                  => '支出',
    'income'                                    => '収益 / 収入',
    'transfers'                                 => '送金',
    'moneyManagement'                           => '資金管理',
    'money_management'                          => '財テク',
    'tools'                                     => 'ツール',
    'piggyBanks'                                => '貯金箱',
    'piggy_banks'                               => '貯金箱',
    'amount_x_of_y'                             => '{current} / {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => '出金',
    'opening_balance'                           => '開始残高',
    'deposit'                                   => '入金',
    'account'                                   => '口座',
    'transfer'                                  => '送金',
    'Withdrawal'                                => '出金',
    'Deposit'                                   => '預金',
    'Transfer'                                  => '送金',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'はい',
    'no'                                        => 'いいえ',
    'amount'                                    => '金額',
    'overview'                                  => '概要',
    'saveOnAccount'                             => '貯蓄口座',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => '不明',
    'monthly'                                   => '毎月',
    'profile'                                   => 'プロフィール',
    'errors'                                    => 'エラー',
    'debt_start_date'                           => '借金の開始日',
    'debt_start_amount'                         => '借金の開始金額',
    'debt_start_amount_help'                    => 'この値は負の値に設定すべきです。詳細については、ヘルプページ (右上？アイコン) をご覧ください。',
    'interest_period_help'                      => 'この項目は表面的であり計算はされません。 銀行はとてもずるいので、Firefly III は正しく理解できません。',
    'store_new_liabilities_account'             => '債務を保存',
    'edit_liabilities_account'                  => '貯金箱「:name」を編集',
    'financial_control'                         => '財務管理',
    'accounting'                                => '会計',
    'automation'                                => '自動化',
    'others'                                    => 'その他',
    'classification'                            => '分類',
    'store_transaction'                         => '取引を保存',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => ':start から :end までのデフォルトの財務レポート',
    'report_audit'                              => ':start から :end までの取引履歴概要',
    'report_category'                           => ':start から :end までのカテゴリレポート',
    'report_double'                             => ':start から :end までの支出/収入口座のレポート',
    'report_budget'                             => ':start から :end までの予算報告',
    'report_tag'                                => ':start から :end までのタグレポート',
    'quick_link_reports'                        => 'クイックリンク',
    'quick_link_examples'                       => 'これらは手始めにちょうどよい例へのリンクです。 (？) ボタンからのヘルプページで、すべてのレポートと使用できるマジックワードについて確認してください。',
    'quick_link_default_report'                 => 'デフォルトの財務レポート',
    'quick_link_audit_report'                   => '取引履歴の概要',
    'report_this_month_quick'                   => '今月のすべての口座',
    'report_last_month_quick'                   => '先月のすべての口座',
    'report_this_year_quick'                    => '今年のすべての口座',
    'report_this_fiscal_year_quick'             => '現在の会計年度のすべての口座',
    'report_all_time_quick'                     => '全期間のすべての口座',
    'reports_can_bookmark'                      => 'レポートはブックマークできることを忘れないでください。',
    'incomeVsExpenses'                          => '収入 vs 支出',
    'accountBalances'                           => '口座残高',
    'balanceStart'                              => '期間開始時の残高',
    'balanceEnd'                                => '期間終了時の残高',
    'splitByAccount'                            => '口座で分割',
    'coveredWithTags'                           => 'タグ',
    'leftInBudget'                              => '残り予算',
    'left_in_debt'                              => '負債額',
    'sumOfSums'                                 => '合計',
    'noCategory'                                => '(カテゴリなし)',
    'notCharged'                                => 'まだ',
    'inactive'                                  => '非アクティブ',
    'active'                                    => '有効',
    'difference'                                => '差異',
    'money_flowing_in'                          => '入',
    'money_flowing_out'                         => '出',
    'topX'                                      => '上位 :number 件',
    'show_full_list'                            => 'リスト全体を表示',
    'show_only_top'                             => '上位 :number 件のみ',
    'report_type'                               => 'レポート種別',
    'report_type_default'                       => 'デフォルトの財務レポート',
    'report_type_audit'                         => '取引履歴の概要 (監査)',
    'report_type_category'                      => 'カテゴリレポート',
    'report_type_budget'                        => '予算レポート',
    'report_type_tag'                           => 'タグレポート',
    'report_type_double'                        => '支出 / 収入口座レポート',
    'more_info_help'                            => 'レポート種別の詳細については、ヘルプページを参照してください。右上隅の (？) アイコンを押します。',
    'report_included_accounts'                  => '含める口座',
    'report_date_range'                         => '日付範囲',
    'report_preset_ranges'                      => '既定の範囲',
    'shared'                                    => '共有中',
    'fiscal_year'                               => '会計年度',
    'income_entry'                              => ':start から :end までの口座「:name」からの収入',
    'expense_entry'                             => '口座「:name」への :start から :end までの支出',
    'category_entry'                            => 'カテゴリ「:name」の :start から :end までの支出と収入',
    'budget_spent_amount'                       => '予算「:budget」の :start から :end までの支出',
    'balance_amount'                            => ':start から :end までの口座「:account」から支払われる予算「:budget」の支出',
    'no_audit_activity'                         => ':start から :end までに、口座「<a href=":url" title=":account_name">:account_name</a>」のアクティビティの記録はありません。',
    'audit_end_balance'                         => ':end 末での <a href=":url" title=":account_name">:account_name</a> の口座残高: :balance',
    'reports_extra_options'                     => '追加オプション',
    'report_has_no_extra_options'               => 'このレポートには追加オプションはありません',
    'reports_submit'                            => 'レポートを表示',
    'end_after_start_date'                      => 'レポートの終了日は開始日より後でなければいけません。',
    'select_category'                           => 'カテゴリを選択',
    'select_budget'                             => '予算を選択',
    'select_tag'                                => 'タグを選択',
    'income_per_category'                       => 'カテゴリ別収入',
    'expense_per_category'                      => 'カテゴリ別支出',
    'expense_per_budget'                        => '予算ごとの支出',
    'income_per_account'                        => '口座ごとの収入',
    'expense_per_account'                       => '口座ごとの支出',
    'expense_per_tag'                           => 'タグごとの支出',
    'income_per_tag'                            => 'タグごとの収入',
    'include_expense_not_in_budget'             => '選択された予算に含まれない支出',
    'include_expense_not_in_account'            => '選択された口座に含まれない支出',
    'include_expense_not_in_category'           => '選択されたカテゴリに含まれない支出',
    'include_income_not_in_category'            => '選択されたカテゴリに含まれない収入',
    'include_income_not_in_account'             => '選択された口座に含まれない収入',
    'include_income_not_in_tags'                => '選択されたタグに含まれない収入',
    'include_expense_not_in_tags'               => '選択されたタグに含まれない支出',
    'everything_else'                           => 'その他すべて',
    'income_and_expenses'                       => '収入と支出',
    'spent_average'                             => '支出 (平均)',
    'income_average'                            => '収入 (平均)',
    'transaction_count'                         => '取引件数',
    'average_spending_per_account'              => '口座ごとの平均支出',
    'average_income_per_account'                => '口座ごとの平均収入',
    'total'                                     => '合計',
    'description'                               => '概要',
    'sum_of_period'                             => '期間の合計',
    'average_in_period'                         => '期間の平均',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'デフォルトの資産口座',
    'account_role_sharedAsset'                  => '共有資産口座',
    'account_role_savingAsset'                  => '貯蓄口座',
    'account_role_ccAsset'                      => 'クレジットカード',
    'account_role_cashWalletAsset'              => '現金',
    'budget_chart_click'                        => 'チャートを見たい予算名をクリックしてください。',
    'category_chart_click'                      => 'チャートを見たいカテゴリ名をクリックしてください。',
    'in_out_accounts'                           => '組み合わせごとの収入と支出',
    'in_out_accounts_per_asset'                 => '(資産口座ごとの) 収入と支出',
    'in_out_per_category'                       => 'カテゴリごとの収入と支出',
    'out_per_budget'                            => '予算ごとの支出',
    'select_expense_revenue'                    => '支出 / 収益口座を選択',
    'multi_currency_report_sum'                 => 'このリストには複数の通貨をもつ口座が含まれているため、表示される合計は意味をなさないかもしれません。 レポートは常にデフォルトの通貨になります。',
    'sum_in_default_currency'                   => '合計は常にデフォルト通貨になります。',
    'net_filtered_prefs'                        => 'このチャートには「純資産に含める」オプションがチェックされていない口座が含まれることはありません。',


    // charts:
    'chart'                                     => 'チャート',
    'month'                                     => '月',
    'budget'                                    => '予算',
    'spent'                                     => '支出',
    'spent_capped'                              => '支出 (上限あり)',
    'spent_in_budget'                           => '予算',
    'left_to_spend'                             => '支出できる残り',
    'earned'                                    => '収益',
    'overspent'                                 => '使いすぎ',
    'left'                                      => '残り',
    'max-amount'                                => '上限額',
    'min-amount'                                => '最低額',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => '名称',
    'expires_at'                                => 'Expires at',
    'date'                                      => '日付',
    'date_and_time'                             => '日付と時刻',
    'time'                                      => '時刻',
    'paid'                                      => '支払い済み',
    'unpaid'                                    => '未払い',
    'day'                                       => '日',
    'budgeted'                                  => '予算設定',
    'period'                                    => '期間',
    'balance'                                   => '収支',
    'in_out_period'                             => 'この期間の収支',
    'sum'                                       => '合計',
    'summary'                                   => '要約',
    'average'                                   => '平均',
    'balanceFor'                                => ':name の残高',
    'no_tags'                                   => '(タグなし)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'イベント履歴',
    'add_money_to_piggy'            => '貯金箱「:name」にお金を追加',
    'piggy_bank'                    => '貯金箱',
    'new_piggy_bank'                => '新しい貯金箱',
    'store_piggy_bank'              => '新しい貯金箱を保存',
    'stored_piggy_bank'             => '新しい貯金箱「:name」を保存',
    'account_status'                => '口座状態',
    'left_for_piggy_banks'          => '貯金箱の残額',
    'sum_of_piggy_banks'            => '貯金箱の合計',
    'saved_so_far'                  => 'これまでの貯金額',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => '残り貯金額',
    'suggested_amount'              => '月ごとの推奨貯蓄額',
    'add_money_to_piggy_title'      => '貯金箱「:name」を追加',
    'remove_money_from_piggy_title' => '貯金箱「:name」からお金を取り去る',
    'add'                           => '追加',
    'no_money_for_piggy'            => 'この貯金箱に入れるお金がありません。',
    'suggested_savings_per_month'   => '1ヶ月あたりの推奨',

    'remove'                    => '削除',
    'max_amount_add'            => '追加できる最大金額は',
    'max_amount_remove'         => '削除できる最大金額は',
    'update_piggy_button'       => '貯金箱を更新する',
    'update_piggy_title'        => '貯金箱「:name」を更新',
    'updated_piggy_bank'        => '貯金箱「:name」を更新しました',
    'details'                   => '詳細',
    'events'                    => 'イベント',
    'target_amount'             => '目標金額',
    'start_date'                => '開始日',
    'no_start_date'             => '開始日なし',
    'target_date'               => '目標日付',
    'no_target_date'            => '目標日付なし',
    'table'                     => '表',
    'delete_piggy_bank'         => '貯金箱「:name」を削除',
    'cannot_add_amount_piggy'   => ':amount を「:name」に追加できませんでした。',
    'cannot_remove_from_piggy'  => ':amount を「:name」から削除できませんでした。',
    'deleted_piggy_bank'        => '貯金箱「:name」を削除しました',
    'added_amount_to_piggy'     => ':amount を「:name」に追加しました',
    'removed_amount_from_piggy' => '「:name」から :amount を削除しました',
    'piggy_events'              => '関連する貯金箱',

    // tags
    'delete_tag'                => 'タグ「:tag」を削除する',
    'deleted_tag'               => 'タグ「:tag」を削除しました',
    'new_tag'                   => '新しいタグを作成する',
    'edit_tag'                  => 'タグ「:tag」を編集する',
    'updated_tag'               => 'タグ「:tag」を更新しました',
    'created_tag'               => 'タグ「:tag」が作成されました！',

    'transaction_journal_information'               => '取引情報',
    'transaction_journal_amount'                    => '金額情報',
    'transaction_journal_meta'                      => 'メタ情報',
    'transaction_journal_more'                      => '詳細情報',
    'basic_journal_information'                     => '取引基本情報',
    'transaction_journal_extra'                     => '追加情報',
    'att_part_of_journal'                           => '「:journal」に保存しました',
    'total_amount'                                  => '合計金額',
    'number_of_decimals'                            => '小数点以下の桁数',


    // administration
    'invite_is_already_redeemed'                    => '「:address」 への招待はすでに利用されました。',
    'invite_is_deleted'                             => '「:address」 への招待が削除されました。',
    'invite_new_user_title'                         => 'ユーザーを招待する',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'メールアドレス',
    'invite_user'                                   => 'ユーザーを招待',
    'user_is_invited'                               => 'メールアドレス「:address」がFirefly IIIに招待されました。',
    'administration'                                => '管理',
    'system_settings'                               => 'システム設定',
    'code_already_used'                             => '招待コードが使用されました',
    'user_administration'                           => 'ユーザー管理',
    'list_all_users'                                => '全ユーザー',
    'all_users'                                     => '全ユーザー',
    'instance_configuration'                        => '設定',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => 'シングルユーザーモード',
    'setting_single_user_mode_explain'              => 'デフォルトでは Firefly III はあなた一人の登録しか受け付けません。これはセキュリティ対策であり、許可しない限り他の人がインスタンスを使用することを防ぎます。 今後の登録はブロックされています。このチェックを外すと、(インターネットに接続されている場合) アクセスできる他の人も利用できるようになります。',
    'store_configuration'                           => '設定を保存',
    'single_user_administration'                    => ':email のユーザー管理',
    'edit_user'                                     => 'ユーザー :email を編集',
    'hidden_fields_preferences'                     => '<a href="preferences">設定</a> で追加の取引オプションを有効にできます。',
    'user_data_information'                         => 'ユーザーデータ',
    'user_information'                              => 'ユーザー情報',
    'total_size'                                    => '合計サイズ',
    'budget_or_budgets'                             => ':count件の予算|:count件の予算',
    'budgets_with_limits'                           => ':count 件の金額設定済み予算|:count 件の金額設定済み予算',
    'nr_of_rules_in_total_groups'                   => ':count_groups 個のルールグループに :count_rules 個のルール',
    'tag_or_tags'                                   => ':count 個のタグ|:count 個のタグ',
    'configuration_updated'                         => '設定が更新されました',
    'setting_is_demo_site'                          => 'デモサイト',
    'setting_is_demo_site_explain'                  => 'チェックすると、この Firefly III はデモサイトとして動作します。これには奇妙な副作用がありえます。',
    'block_code_bounced'                            => 'メールを配信できませんでした',
    'block_code_expired'                            => 'デモアカウントの期限切れ',
    'no_block_code'                                 => 'ブロック理由がないかブロックされてません',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'ユーザーはまだ新しいメールアドレスを確認していません',
    'admin_update_email'                            => 'プロフィールページとは違い、ユーザーにメールアドレスが変更されたことは通知されません。',
    'update_user'                                   => 'ユーザーを更新',
    'updated_user'                                  => 'ユーザーデータが変更されました。',
    'delete_user'                                   => 'ユーザー :email を削除',
    'user_deleted'                                  => 'ユーザーが削除されました。',
    'send_test_email'                               => 'テストメールメッセージを送信',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'メッセージを送信',
    'send_test_triggered'                           => 'テストが実行されました。受信トレイとログファイルを確認してください。',
    'give_admin_careful'                            => '管理者権限を与えられたユーザーは、あなたの特権を奪うことができます。注意してください。',
    'admin_maintanance_title'                       => 'メンテナンス',
    'admin_maintanance_expl'                        => 'Firefly III メンテナンス用の素敵なボタン',
    'admin_maintenance_clear_cache'                 => 'キャッシュをクリア',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => '招待されたすべてのユーザー',
    'save_notification_settings'                    => '設定を保存',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => '通知設定が保存されました。',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => '分割取引の概要',
    'split_transaction_title_help'          => '分割取引を作成する場合、取引のすべての分割の包括的な概要が必要です。',
    'split_title_help'                      => '分割取引を作成する場合、取引のすべての分割の包括的な概要が必要です。',
    'you_create_transfer'                   => '送金を作成しています。',
    'you_create_withdrawal'                 => '出金を作成しています。',
    'you_create_deposit'                    => '入金を作成しています。',

    // links
    'journal_link_configuration'            => '取引リンクの設定',
    'create_new_link_type'                  => '新しいリンクタイプを作成',
    'store_new_link_type'                   => '新しいリンクタイプを保存',
    'update_link_type'                      => 'リンクタイプを更新',
    'edit_link_type'                        => 'リンクタイプ「:name」を更新',
    'updated_link_type'                     => 'リンクタイプ「:name」を更新しました',
    'delete_link_type'                      => 'リンクタイプ「:name」を削除',
    'deleted_link_type'                     => 'リンクタイプ「:name」を削除しました',
    'stored_new_link_type'                  => '新しいリンクタイプ「:name」を保存しました',
    'cannot_edit_link_type'                 => 'リンクタイプ「:name」を編集できません',
    'link_type_help_name'                   => '例「重複」',
    'link_type_help_inward'                 => '例「重複」',
    'link_type_help_outward'                => '例「次と重複」',
    'save_connections_by_moving'            => 'これらの取引間のリンクを、別のリンクタイプに変更して保存します:',
    'do_not_save_connection'                => '(接続を保存しない)',
    'link_transaction'                      => '取引をリンク',
    'link_to_other_transaction'             => 'この取引を別の取引にリンク',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'この取引',
    'transaction'                           => '取引',
    'comments'                              => 'コメント',
    'link_notes'                            => 'リンクに保存したい備考。',
    'invalid_link_selection'                => 'これらの取引はリンクできません',
    'selected_transaction'                  => '選択した取引',
    'journals_linked'                       => '取引がリンクされました。',
    'journals_error_linked'                 => 'これらの取引はすでにリンクされています。',
    'journals_link_to_self'                 => '取引を同じ取引にリンクすることはできません',
    'journal_links'                         => '取引リンク',
    'this_withdrawal'                       => 'この出金',
    'this_deposit'                          => 'この入金',
    'this_transfer'                         => 'この送金',
    'overview_for_link'                     => 'リンクタイプ「:name」の概要',
    'source_transaction'                    => '元の取引',
    'link_description'                      => 'リンクの概要',
    'destination_transaction'               => '取引先',
    'delete_journal_link'                   => '<a href=":source_link">:source</a> と <a href=":destination_link">:destination</a> の間のリンクを削除する',
    'deleted_link'                          => 'リンクを削除しました',

    // link translations:
    'Paid_name'                             => '支払い済み',
    'Refund_name'                           => '返済',
    'Reimbursement_name'                    => '払い戻し',
    'Related_name'                          => '関連',
    'relates to_inward'                     => '関連する',
    'is (partially) refunded by_inward'     => '次のユーザーによって (部分的に) 返済されます',
    'is (partially) paid for by_inward'     => '次のユーザーによって (部分的に) 支払われます',
    'is (partially) reimbursed by_inward'   => '次のユーザーによって (部分的に) 払い戻されます',
    'inward_transaction'                    => '内部取引',
    'outward_transaction'                   => '外部取引',
    'relates to_outward'                    => '関連する',
    '(partially) refunds_outward'           => '(部分的な) 返済',
    '(partially) pays for_outward'          => '(部分的な) 支払い',
    '(partially) reimburses_outward'        => '(部分的な) 払い戻し',
    'is (partially) refunded by'            => '次のユーザーによって (部分的に) 返済されます',
    'is (partially) paid for by'            => '次のユーザーによって (部分的に) 支払われます',
    'is (partially) reimbursed by'          => '次のユーザーによって (部分的に) 払い戻されます',
    'relates to'                            => '関連する',
    '(partially) refunds'                   => '(部分的な) 返済',
    '(partially) pays for'                  => '(部分的な) 支払い',
    '(partially) reimburses'                => '(部分的な) 払い戻し',

    // split a transaction:
    'splits'                                => '分割',
    'add_another_split'                     => '別の分割を追加',
    'cannot_edit_opening_balance'           => '口座の開始残高は編集できません。',
    'no_edit_multiple_left'                 => '編集する有効な取引が選択されていません。',
    'breadcrumb_convert_group'              => '取引を変換',
    'convert_invalid_source'                => '取引 #%d の引き出し元情報が無効です。',
    'convert_invalid_destination'           => '取引 #%d の宛先情報が無効です。',
    'create_another'                        => '保存後に戻り作成を続ける。',
    'after_update_create_another'           => '保存後に戻って編集を続ける。',
    'store_as_new'                          => '更新せず新しい取引として保存する。',
    'reset_after'                           => '送信後にフォームをリセット',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => '分割を展開',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => '分割をたたむ',

    // object groups
    'default_group_title_name'              => '(グループなし)',
    'default_group_title_name_plain'        => 'グループ解除',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => '資産口座を作成しましょう！',
    'no_accounts_intro_asset'               => '資産口座がまだありません。資産口座は当座預金口座、貯蓄口座、共有口座、さらにはクレジットカードといった、あなたの主要口座です。',
    'no_accounts_imperative_asset'          => 'Firefly III を始めるには、少なくとも1つの資産口座が必要です。今すぐ作成しましょう:',
    'no_accounts_create_asset'              => '資産口座の作成',
    'no_accounts_title_expense'             => '支出口座を作成しましょう！',
    'no_accounts_intro_expense'             => '支出口座がまだありません。支出口座は、お店やスーパーマーケットなどのお金を支出する先です。',
    'no_accounts_imperative_expense'        => '支出口座は取引を作成するときに自動的に作成されますが、必要に応じて手動で作成することもできます。今すぐ作成しましょう:',
    'no_accounts_create_expense'            => '支出口座を作成する',
    'no_accounts_title_revenue'             => '収入口座を作成しましょう！',
    'no_accounts_intro_revenue'             => '収入口座がまだありません。収入口座は雇用主などからお金を受け取るところです。',
    'no_accounts_imperative_revenue'        => '収入口座は取引を作成するときに自動的に作成されますが、必要に応じて手動で作成することもできます。今すぐ作成しましょう:',
    'no_accounts_create_revenue'            => '収入口座を作成',
    'no_accounts_title_liabilities'         => '債務を作成しましょう！',
    'no_accounts_intro_liabilities'         => 'まだ債務がありません。債務は (学生) ローンやその他の借金を登録する口座です。',
    'no_accounts_imperative_liabilities'    => 'この機能を使用する必要はありませんが、これらを把握したい場合に便利です。',
    'no_accounts_create_liabilities'        => '債務を作成',
    'no_budgets_title_default'              => '予算を作成しましょう',
    'no_rules_title_default'                => 'ルールを作ってみましょう！',
    'no_budgets_intro_default'              => '予算はまだありません。予算は支出をグループに分類し、制限するための目安になります。',
    'no_rules_intro_default'                => 'ルールはまだありません。ルールは取引を処理できる強力な自動化機能です。',
    'no_rules_imperative_default'           => 'ルールは取引を管理するときに非常に便利です。今すぐ作成してみましょう:',
    'no_budgets_imperative_default'         => '予算は資産管理の基本的なツールです。今すぐ作成しましょう:',
    'no_budgets_create_default'             => '予算を作成',
    'no_rules_create_default'               => 'ルールを作成',
    'no_categories_title_default'           => 'カテゴリを作成しましょう！',
    'no_categories_intro_default'           => 'カテゴリはまだありません。カテゴリは取引を微調整し、指定されたカテゴリでラベル付けするために使用されます。',
    'no_categories_imperative_default'      => 'カテゴリは取引を作成するときに自動的に作成されますが、手動で作成することもできます。今すぐ作成しましょう:',
    'no_categories_create_default'          => 'カテゴリを作成',
    'no_tags_title_default'                 => 'タグを作成しましょう！',
    'no_tags_intro_default'                 => 'タグはまだありません。タグは取引を微調整し、特定のキーワードでラベル付けするために使用されます。',
    'no_tags_imperative_default'            => 'タグは取引を作成すると自動的に作成されますが、手動で作成することもできます。今すぐ作成しましょう:',
    'no_tags_create_default'                => 'タグを作成',
    'no_transactions_title_withdrawal'      => '支出を作成しましょう！',
    'no_transactions_intro_withdrawal'      => '支出はまだありません。資産の管理をはじめるため、経費を作成しましょう。',
    'no_transactions_imperative_withdrawal' => 'お金を使ったことがありますか？それらを記録しましょう:',
    'no_transactions_create_withdrawal'     => '支出を作成する',
    'no_transactions_title_deposit'         => '収入を作ってみよう！',
    'no_transactions_intro_deposit'         => '収入記録はまだありません。資産の管理を開始するための収入エントリを作成する必要があります。',
    'no_transactions_imperative_deposit'    => 'お金を受け取ったことがありますか？それらを記録しましょう:',
    'no_transactions_create_deposit'        => '新しい入金を作成する',
    'no_transactions_title_transfers'       => '送金を作成しましょう！',
    'no_transactions_intro_transfers'       => '送金はまだありません。資産口座間でお金を移動すると、送金として記録されます。',
    'no_transactions_imperative_transfers'  => 'お金を移動しましたか？それらは記録すべきです：',
    'no_transactions_create_transfers'      => '送金を作成',
    'no_piggies_title_default'              => '貯金箱を作成しましょう！',
    'no_piggies_intro_default'              => 'まだ貯金箱がありません。貯金を分割し、把握するために貯金箱を作ることができます。',
    'no_piggies_imperative_default'         => '何かのためにお金を貯めていますか？貯金箱を作って把握しましょう:',
    'no_piggies_create_default'             => '新規貯金箱の作成',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => '今すぐ作成',
    'no_new_transaction_in_recurrence'      => '新しい取引は作成されませんでした。この日付で既に発行されている可能性があります。',
    'recurrences'                           => '定期的な取引',
    'repeat_until_in_past'                  => 'この繰り返し取引は :date で繰り返し処理を停止しました。',
    'recurring_calendar_view'               => 'カレンダー',
    'no_recurring_title_default'            => '定期的な取引を作成しましょう！',
    'no_recurring_intro_default'            => '定期的な取引はまだありません。定期的な取引で Firefly III に自動的に取引を作成させることができます。',
    'no_recurring_imperative_default'       => 'これはかなり高度な機能ですが、非常に便利です。 続行する前に、ドキュメント(？)アイコンを必ず読んでください。',
    'no_recurring_create_default'           => '定期的な取引を作成',
    'make_new_recurring'                    => '定期的な取引を作成',
    'recurring_daily'                       => '毎日',
    'recurring_weekly'                      => '毎週 :weekday',
    'recurring_weekly_skip'                 => '毎月第 :skip :weekday',
    'recurring_monthly'                     => '毎月 :dayOfMonth 日',
    'recurring_monthly_skip'                => ':skipヶ月ごとの :dayOfMonth 日',
    'recurring_ndom'                        => '毎月第 :dayOfMonth :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => '毎年 :date',
    'overview_for_recurrence'               => '定期的な取引「:title」の概要',
    'warning_duplicates_repetitions'        => 'まれに日付が2回、このリストに表示されます。これは複数の繰り返しが衝突したときに発生する可能性があります。Firefly III は常に1日につき1つの取引を生成します。',
    'created_transactions'                  => '関連する取引',
    'expected_withdrawals'                  => '出金予測',
    'expected_deposits'                     => '入金予測',
    'expected_transfers'                    => '送金予測',
    'created_withdrawals'                   => '出金を作成しました',
    'created_deposits'                      => '入金を作成しました',
    'created_transfers'                     => '送金を作成しました',
    'recurring_info'                        => '定期的な取引 :count / :total',
    'created_from_recurrence'               => '定期的な取引「:title」(#:id) から作成されました',
    'recurring_never_cron'                  => '定期的な取引をサポートするために必要なcronジョブは、一度も実行されていないようです。Firefly III をインストールしたばかりの場合は、これは普通のことですが、できるだけ早く設定する必要があります。 ページの右上隅にある (？) アイコンを使用してヘルプページを確認してください。',
    'recurring_cron_long_ago'               => '定期的な取引をサポートするための cron ジョブが前回実行されてから36時間以上が経過しているようです。 正しく設定されていますか？ページの右上隅にある(？)アイコンから、ヘルプページを確認してください。',

    'create_new_recurrence'              => '定期的な取引を作成',
    'help_first_date'                    => '初回の繰り返し予定を示します。これは未来の日付でなければなりません。',
    'help_first_date_no_past'            => '繰り返し取引の初回を示します。Firefly III は過去に取引を作成しません。',
    'no_currency'                        => '(通貨なし)',
    'mandatory_for_recurring'            => '繰り返しの必須情報',
    'mandatory_for_transaction'          => '必須の取引情報',
    'optional_for_recurring'             => '繰り返しのオプション情報',
    'optional_for_transaction'           => 'オプションの取引情報',
    'change_date_other_options'          => '「最初の日付」を変更して、他のオプションを表示します。',
    'mandatory_fields_for_tranaction'    => 'この値で取引が作成されます。',
    'click_for_calendar'                 => '取引が繰り返されるときに表示されるカレンダーはここをクリックしてください。',
    'repeat_forever'                     => '無期限に繰り返す',
    'repeat_until_date'                  => '終了日まで繰り返す',
    'repeat_times'                       => '指定回数繰り返す',
    'recurring_skips_one'                => '他すべて',
    'recurring_skips_more'               => ':count 回の発生をスキップ',
    'store_new_recurrence'               => '定期的な取引を保存',
    'stored_new_recurrence'              => '定期的な取引「:title」が正常に保存されました。',
    'edit_recurrence'                    => '定期的な取引 ":title"を編集',
    'recurring_repeats_until'            => ':date まで繰り返し',
    'recurring_repeats_forever'          => '無期限に繰り返し',
    'recurring_repeats_x_times'          => '繰り返し :count 回|繰り返し :count 回',
    'update_recurrence'                  => '定期的な取引を更新',
    'updated_recurrence'                 => '定期的な取引「:title」を更新しました',
    'recurrence_is_inactive'             => 'この定期的な取引は有効ではないため、新しい取引は生成されません。',
    'delete_recurring'                   => '定期的な取引「:title」を削除',
    'new_recurring_transaction'          => '新しい定期的な取引',
    'help_weekend'                       => '定期的な取引が土曜日または日曜日になる場合、Firefly III は何をすべきですか？',
    'do_nothing'                         => '新規取引を作成',
    'skip_transaction'                   => '発生をスキップ',
    'jump_to_friday'                     => '代わりに前の金曜日に取引を作成します',
    'jump_to_monday'                     => '代わりに次の月曜日に取引を作成します',
    'will_jump_friday'                   => '週末の代わりに金曜日に作成されます。',
    'will_jump_monday'                   => '週末の代わりに月曜日に作成されます。',
    'except_weekends'                    => '週末を除外する',
    'recurrence_deleted'                 => '定期的な取引「:title」を削除しました',


    // new lines for summary controller.
    'box_balance_in_currency'            => '残高 (:currency)',
    'box_spent_in_currency'              => '支出 (:currency)',
    'box_earned_in_currency'             => '収益 (:currency)',
    'box_budgeted_in_currency'           => '予算確保 (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => '残り支出 (:currency)',
    'box_net_worth_in_currency'          => '純資産 (:currency)',
    'box_spend_per_day'                  => '1日あたりの支出残り: :amount',

    // debug page
    'debug_page'                         => 'デバッグページ',
    'debug_submit_instructions'          => '問題が発生している場合は、この情報をデバッグ情報として使用できます。 新規または既存の <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>にコピー＆ペーストしてください。 それは問題を迅速に診断するための、すばらしいテーブルを生成します。',
    'debug_pretty_table'                 => '以下の内容を GitHub issue にコピー＆ペーストするとテーブルが生成されます。バックティック (`) や引用符で囲まないでください。',
    'debug_additional_data'              => '以下の内容を共有することもできます。 新規または既存の <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>にこれをコピー＆ペーストすることもできます。 ただし、この以下の内容には、口座名、取引の詳細、または電子メールアドレスなどの個人情報が含まれている場合があります。',

    // object groups
    'object_groups_menu_bar'             => 'グループ',
    'object_groups_page_title'           => 'グループ',
    'object_groups_breadcrumb'           => 'グループ',
    'object_groups_index'                => '概要',
    'object_groups'                      => 'グループ',
    'object_groups_empty_explain'        => 'Firefly III のいくつかのものはグループに分けることができます。貯金箱を例に挙げると、編集/作成画面に「グループ」項目があります。 この項目を設定すると、グループの名前とページ内でのグループ表示順を編集できます。 詳細については、右上の(?) アイコンの下にあるヘルプページをご覧ください。',
    'object_group_title'                 => 'タイトル',
    'edit_object_group'                  => 'グループ「:title」を編集',
    'delete_object_group'                => 'グループ「:title」を削除',
    'update_object_group'                => 'グループの更新',
    'updated_object_group'               => 'グループ「:title」を更新しました',
    'deleted_object_group'               => 'グループ「:title」を削除しました',
    'object_group'                       => 'グループ',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => '監査ログのエントリ',
    'ale_action_log_add'                 => '貯金箱「:name」に「:amount」を追加',
    'ale_action_log_remove'              => '貯金箱「:name」から:amountを減算',
    'ale_action_clear_budget'            => '予算から削除されました',
    'ale_action_update_group_title'      => '更新された取引グループタイトル',
    'ale_action_update_date'             => '更新された取引日',
    'ale_action_update_order'            => '更新された取引並び順',
    'ale_action_clear_category'          => 'カテゴリから削除されました',
    'ale_action_clear_notes'             => '削除された備考',
    'ale_action_clear_tag'               => '削除されたタグ',
    'ale_action_clear_all_tags'          => '削除されたすべてのタグ',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => '引き出し口座と預け入れ口座を切り替えました',
    'ale_action_set_budget'              => '予算を設定する',
    'ale_action_set_category'            => 'カテゴリを設定する',
    'ale_action_set_source'              => '引き出し口座を設定',
    'ale_action_set_destination'         => '預け入れ口座を設定',
    'ale_action_update_transaction_type' => '変更された取引種別',
    'ale_action_update_notes'            => '変更された備考',
    'ale_action_update_description'      => '変更された概要',
    'ale_action_add_to_piggy'            => '貯金箱',
    'ale_action_remove_from_piggy'       => '貯金箱',
    'ale_action_add_tag'                 => '追加したタグ',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => '通貨の変換を有効にする',
    'disable_auto_convert'               => '通貨の変換を無効にする',
];
