<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primarna valuta',
    'bank_name'                    => 'Naziv banke',
    'bank_balance'                 => 'Stanje',
    'current_balance'              => 'Trenutno stanje',
    'savings_balance'              => 'Stanje prihrankov',
    'credit_card_limit'            => 'Limit kreditne kartice',
    'automatch'                    => 'Samodejno poveži',
    'skip'                         => 'Preskoči',
    'enabled'                      => 'Omogočeno',
    'name'                         => 'Ime',
    'active'                       => 'Aktivno',
    'amount_min'                   => 'Najnižji znesek',
    'amount_max'                   => 'Najvišji znesek',
    'match'                        => 'Se ujema z',
    'strict'                       => 'Strogi način',
    'repeat_freq'                  => 'Ponovitve',
    'object_group'                 => 'Skupina',
    'location'                     => 'Lokacija',
    'update_channel'               => 'Kanal posodobitev',
    'currency_id'                  => 'Valuta',
    'transaction_currency_id'      => 'Valuta',
    'auto_budget_currency_id'      => 'Valuta',
    'external_ip'                  => 'Javni IP naslov vašega strežnika',
    'attachments'                  => 'Priloge',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Preverite varnost gesla',
    'source_account'               => 'Izvorni račun',
    'destination_account'          => 'Ciljni račun',
    'asset_destination_account'    => 'Ciljni račun',
    'include_net_worth'            => 'Vključite v neto vrednost',
    'asset_source_account'         => 'Izvorni račun',
    'journal_description'          => 'Opis',
    'note'                         => 'Opombe',
    'currency'                     => 'Valuta',
    'account_id'                   => 'Račun sredstev',
    'budget_id'                    => 'Proračun',
    'bill_id'                      => 'Naročnina',
    'opening_balance'              => 'Začetno stanje',
    'tag_mode'                      => 'Način oznak',
    'virtual_balance'              => 'Navidezno stanje',
    'run_after_form' => 'Zaženi to pravilo',
    'valid_url_protocols' => 'Valid URL protocols',
    'allow_webhooks' => 'Allow webhooks',
    'enable_external_rates' => 'Enable external exchange rates',
    'enable_external_map' => 'Enable external map',
    'use_running_balance' => 'Calculate running balances',
    'enable_exchange_rates' => 'Enable exchange rates',
    'targetamount'                 => 'Ciljni znesek',
    'target_amount'                => 'Ciljni znesek',
    'account_role'                 => 'Vloga računa',
    'opening_balance_date'         => 'Datum začetnega stanja',
    'cc_type'                      => 'Načrt plačila s kreditno kartico',
    'cc_monthly_payment_date'      => 'Datum mesečnega plačila s kreditno kartico',
    'piggy_bank_id'                => 'Hranilnik',
    'returnHere'                   => 'Vrni se sem',
    'returnHereExplanation'        => 'Po shranjevanju se vrni sem in ustvari še enega.',
    'returnHereUpdateExplanation'  => 'Po shranjevanju se vrni sem.',
    'description'                  => 'Opis',
    'expense_account'              => 'Račun stroškov',
    'revenue_account'              => 'Račun prihodkov',
    'decimal_places'               => 'Decimalke',
    'destination_amount'           => 'Znesek (cilj)',
    'new_email_address'            => 'Nov elektronski naslov',
    'verification'                 => 'Potrditev',
    'api_key'                      => 'API ključ',
    'remember_me'                  => 'Zapomni se me',
    'liability_type_id'            => 'Vrsta obveznosti',
    'liability_type'               => 'Vrsta obveznosti',
    'interest'                     => 'Obresti',
    'interest_period'              => 'Obdobje obresti',
    'extension_date'               => 'Datum razširitve',
    'type'                         => 'Vrsta',
    'convert_Withdrawal'           => 'Pretvori odliv',
    'convert_Deposit'              => 'Pretvori priliv',
    'convert_Transfer'             => 'Pretvori prenos',
    'amount'                       => 'Znesek',
    'foreign_amount'               => 'Tuj znesek',
    'date'                         => 'Datum',
    'interest_date'                => 'Datum obresti',
    'book_date'                    => 'Datum knjiženja',
    'process_date'                 => 'Datum obdelave',
    'category'                     => 'Kategorija',
    'tags'                         => 'Oznake',
    'deletePermanently'            => 'Trajno izbriši',
    'cancel'                       => 'Prekliči',
    'targetdate'                   => 'Ciljni datum',
    'target_date'                  => 'Ciljni datum',
    'startdate'                    => 'Začetni datum',
    'start_date'                   => 'Začetni datum',
    'tag'                          => 'Oznaka',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Tečaj',

    'under'                        => 'Pod',
    'symbol'                       => 'Simbol',
    'code'                         => 'Koda',
    'iban'                         => 'IBAN',
    'account_number'               => 'Številka računa',
    'creditCardNumber'             => 'Številka kreditne kartice',
    'has_headers'                  => 'Glave',
    'date_format'                  => 'Format datuma',
    'attachments[]'                => 'Priloge',
    'title'                        => 'Naslov',
    'notes'                        => 'Opombe',
    'filename'                     => 'Ime datoteke',
    'mime'                         => 'Vrsta MIME',
    'size'                         => 'Velikost',
    'trigger'                      => 'Sprožilec',
    'stop_processing'              => 'Ustavi izvajanje',
    'end_date'                     => 'Končni datum',
    'enddate'                      => 'Končni datum',
    'move_rules_before_delete'     => 'Skupina pravil',
    'start'                        => 'Začetek obsega',
    'end'                          => 'Konec obsega',
    'delete_account'               => 'Izbriši račun ":name"',
    'delete_webhook'               => 'Izbriši webhook ":title"',
    'delete_bill'                  => 'Izbriši naročnino ":name"',
    'delete_budget'                => 'Izbriši proračun ":name"',
    'delete_category'              => 'Izbriši kategorijo ":name"',
    'delete_currency'              => 'Izbriši valuto ":name"',
    'delete_journal'               => 'Izbriši transakcijo z opisom ":description"',
    'delete_attachment'            => 'Izbruši prilogo ":name"',
    'delete_rule'                  => 'Izbriši pravilo ":title"',
    'delete_rule_group'            => 'Izbriši skupino pravil ":title"',
    'delete_link_type'             => 'Izbriši vrsto povezave ":name"',
    'delete_user'                  => 'Izbriši uporabnika ":email"',
    'delete_recurring'             => 'Izbriši ponavljajočo se transakcijo ":title"',
    'user_areYouSure'              => 'Z brisanjem uporabnika ":email", boste izbrisali vse. Dejanja se ne da razveljaviti ali povrniti iz koša. Če izbrišete samega sebe, boste izgubil dostop do te namestitve Firefly III.',
    'attachment_areYouSure'        => 'Ste prepričani, da želite izbrisati pripeto datoteko ":name"?',
    'account_areYouSure'           => 'Ste prepričani, da želite izbrisati račun ":name"?',
    'account_areYouSure_js'        => 'Ste prepričani, da želite izbrisati račun z imenom "{name}"?',
    'bill_areYouSure'              => 'Ste prepričani, da želite izbrisati naročnino ":name"?',
    'rule_areYouSure'              => 'Ste prepričani, da želite izbrisati pravilo ":title"?',
    'object_group_areYouSure'      => 'Ste prepričani, da želite izbrisati skupino z naslovom ":title"?',
    'ruleGroup_areYouSure'         => 'Ste prepričani, da želite izbrisati skupino pravil ":title"?',
    'budget_areYouSure'            => 'Ste prepričani, da želite izbrisati proračun ":name"?',
    'webhook_areYouSure'           => 'Ste prepričani, da želite izbrisati webhook z imenom ":title"?',
    'category_areYouSure'          => 'Ste prepričani, da želite izbrisati kategorijo z imenom ":name"?',
    'recurring_areYouSure'         => 'Ste prepričani, da želite izbrisati ponavljajoče pravilo ":title"?',
    'currency_areYouSure'          => 'Ste prepričani, da želite izbrisati valuto ":name"?',
    'piggyBank_areYouSure'         => 'Ste prepričani, da želite izbrisati hranilnik ":name"?',
    'journal_areYouSure'           => 'Ste prepričani, da želite izbrisati transakcijo z opisom ":description"?',
    'mass_journal_are_you_sure'    => 'Ste prepričani, da želite izbrisati te transakcije?',



    'tag_areYouSure'               => 'Ste prepričani, da želite izbrisati oznako ":tag"?',
    'journal_link_areYouSure'      => 'Ste prepričani, da želite izbrisati povezavo med <a href=":source_link">:source</a> in <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Ste prepričani, da želite izbrisati vrsto povezave ":name" (":inward"/":outward")?',
    'permDeleteWarning'            => 'Brisanje stvari iz Firefly III je trajno in ga ni mogoče razveljaviti.',
    'mass_make_selection'          => 'Še vedno lahko preprečite brisanje elementov, tako da počistite potrditveno polje.',
    'delete_all_permanently'       => 'Označeno trajno izbriši',
    'update_all_journals'          => 'Posodobi te transakcije',
    'also_delete_transactions'     => 'Edina transakcija, ki je povezana s tem računom, bo prav tako izbrisana.|Vseh :count transakcij, povezanih s tem računom, bo izbrisanih.',
    'also_delete_transactions_js'  => 'Brez transakcij|Izbrisana bo tudi edina transakcija, povezana s tem računom.|Izbrisanih bo tudi vseh {count} transakcij, povezanih s tem računom.',
    'also_delete_connections'      => 'Edina transakcija, povezana s to vrsto povezave, bo izgubila povezavo.|Vseh :count transakcij, povezanih s to vrsto povezave bo izgubilo povezavo.',
    'also_delete_rules'            => 'Edino pravilo, ki je povezano s tem računom, bo prav tako izbrisano.|Vseh :count pravil, povezanih s skupino pravil bo izbrisanih.',
    'also_delete_piggyBanks'       => 'Edini hranilnik, ki je povezan s tem računom, bo prav tako izbrisan.|Vseh :count hranilnikov, povezanih s tem računom, bo izbrisanih.',
    'also_delete_piggyBanks_js'    => 'Brez hranilnikov|Edini hranilnik, povezan s tem računom, bo prav tako izbrisan.|Izbrisani bodo tudi vseh {count} hranilnikov, povezani s tem računom.',
    'not_delete_piggy_banks'       => 'Hranilnik, povezan s to skupino, ne bo izbrisan.| :count hranilnikov, povezanih s to skupino, ne bo izbrisanih.',
    'bill_keep_transactions'       => 'Edina transakcija, povezana s to naročnino, ne bo izbrisana.|Vseh :count transakcij, povezanih s to naročnino, ne bodo izbrisanih.',
    'budget_keep_transactions'     => 'Edina transakcija, povezana s tem proračunom, ne izbrisana.|Vseh :count transakcij, povezanih s tem proračunom, bo ohranjenih.',
    'category_keep_transactions'   => 'Edina transakcija, povezana s to kategorijo, ne bo izbrisana.|Vseh :count transakcij, povezanih s to kategorijo bo ohranjenih.',
    'recurring_keep_transactions'  => 'Edina transakcija, ustvarjena s to ponavljajočo transakcijo, ne izbrisana.|Vseh :count transakcij, ustvarjenih s to ponavljajočo transakcijo bo ohranjenih.',
    'tag_keep_transactions'        => 'Edina transakcija, povezana s to oznako, ne bo izbrisana.|Vseh :count transakcij, povezanih s to oznako bo ohranjenih.',
    'check_for_updates'            => 'Preveri za posodobitve',
    'liability_direction'          => 'Odgovornost not/ven',
    'delete_object_group'          => 'Izbriši skupino ":title"',
    'email'                        => 'E-poštni naslov',
    'password'                     => 'Geslo',
    'password_confirmation'        => 'Geslo (ponovno)',
    'blocked'                      => 'Je blokiran?',
    'blocked_code'                 => 'Razlog blokade',
    'login_name'                   => 'Prijava',
    'is_owner'                     => 'Je administrator?',
    'url'                          => 'URL',
    'bill_end_date'                => 'Končni datum',

    // import
    'apply_rules'                  => 'Uporabi pravila',
    'artist'                       => 'Izvajalec',
    'album'                        => 'Album',
    'song'                         => 'Pesem',

    // admin
    'domain'                       => 'Domena',
    'single_user_mode'             => 'Onemogoči prijavo uporabnikov',
    'is_demo_site'                 => 'Je demo postavitev',

    // import
    'configuration_file'           => 'Nastavitvena datoteka',
    'csv_comma'                    => 'Vejica (,)',
    'csv_semicolon'                => 'Podpičje (;)',
    'csv_tab'                      => 'Tabulator (nevidno)',
    'csv_delimiter'                => 'CSV ločilo polj',
    'client_id'                    => 'Client ID',
    'app_id'                       => 'App ID',
    'secret'                       => 'Skrivna koda',
    'public_key'                   => 'Javni ključ',
    'country_code'                 => 'Šifra države',
    'provider_code'                => 'Banka ponudnika podatkov',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => 'Vrata',
    'fints_bank_code'              => 'Koda banke',
    'fints_username'               => 'Uporabniško ime',
    'fints_password'               => 'PIN / geslo',
    'fints_account'                => 'FinTS račun',
    'local_account'                => 'Račun v Firely III',



    'from_date'                    => 'Datum od',
    'to_date'                      => 'Datum do',
    'due_date'                     => 'Datum zapadlosti',
    'payment_date'                 => 'Datum plačila',
    'invoice_date'                 => 'Datum računa',
    'internal_reference'           => 'Notranji sklic',
    'inward'                       => 'Interni opis',
    'outward'                      => 'Eksterni opis',
    'rule_group_id'                => 'Skupina pravil',
    'transaction_description'      => 'Opis transakcije',
    'first_date'                   => 'Prvi datum',
    'transaction_type'             => 'Vrsta transakcije',
    'repeat_until'                 => 'Ponavljaj do',
    'recurring_description'        => 'Opis ponavljajoče transakcije',
    'repetition_type'              => 'Vrsta ponovitve',
    'foreign_currency_id'          => 'Tuja valuta',
    'repetition_end'               => 'Konec ponovitve',
    'repetitions'                  => 'Ponovitve',
    'calendar'                     => 'Koledar',
    'weekend'                      => 'Vikend',
    'client_secret'                => 'Skrivna koda odjemalca',
    'withdrawal_destination_id'    => 'Ciljni račun',
    'deposit_source_id'            => 'Izvorni račun',
    'expected_on'                  => 'Pričakovano dne',
    'paid'                         => 'Plačano',
    'auto_budget_type'             => 'Samodejni proračun',
    'auto_budget_amount'           => 'Znesek samodejnega proračuna',
    'auto_budget_period'           => 'Obdobje samodejnega proračuna',
    'collected'                    => 'Zbirka',
    'submitted'                    => 'Oddano',
    'key'                          => 'Ključ',
    'value'                        => 'Vsebina zapisa',
    'webhook_delivery'             => 'Dostava',
    'webhook_response'             => 'Odziv',
    'webhook_trigger'              => 'Sprožilec',
    'pushover_app_token'           => 'Pushover žeton aplikacije',
    'pushover_user_token'          => 'Pushover uporabniški žeton',
    'ntfy_server'                  => 'Ntfy strežnik',
    'ntfy_topic'                   => 'Ntfy tema',
    'ntfy_auth'                    => 'Ntfy omogočeno preverjanje pristnosti',
    'ntfy_user'                    => 'Ntfy uporabniško ime',
    'ntfy_pass'                    => 'Ntfy geslo',
];
