<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Bankens namn',
    'bank_balance'                 => 'Saldo',
    'current_balance'              => 'Current balance',
    'savings_balance'              => 'Sparsaldo',
    'credit_card_limit'            => 'Kreditkortgräns',
    'automatch'                    => 'Hitta automatiskt',
    'skip'                         => 'Hoppa över',
    'enabled'                      => 'Aktiverad',
    'name'                         => 'Namn',
    'active'                       => 'Aktiv',
    'amount_min'                   => 'Minsta belopp',
    'amount_max'                   => 'Högsta belopp',
    'match'                        => 'Träffar på',
    'strict'                       => 'Strikt läge',
    'repeat_freq'                  => 'Upprepningar',
    'object_group'                 => 'Grupp',
    'location'                     => 'Plats',
    'update_channel'               => 'Uppdateringskanal',
    'currency_id'                  => 'Valuta',
    'transaction_currency_id'      => 'Valuta',
    'auto_budget_currency_id'      => 'Valuta',
    'external_ip'                  => 'Din servers externa IP',
    'attachments'                  => 'Bilagor',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Verifiera lösenordssäkerhet',
    'source_account'               => 'Från konto',
    'destination_account'          => 'Till konto',
    'asset_destination_account'    => 'Till konto',
    'include_net_worth'            => 'Inkludera i nettovärde',
    'asset_source_account'         => 'Källkonto',
    'journal_description'          => 'Beskrivning',
    'note'                         => 'Anteckningar',
    'currency'                     => 'Valuta',
    'account_id'                   => 'Tillgångskonto',
    'budget_id'                    => 'Budget',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => 'Ingående balans',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Virtuell balans',
    'run_after_form' => 'Run this rule',
    'valid_url_protocols' => 'Valid URL protocols',
    'allow_webhooks' => 'Allow webhooks',
    'enable_external_rates' => 'Enable external exchange rates',
    'enable_external_map' => 'Enable external map',
    'use_running_balance' => 'Calculate running balances',
    'enable_exchange_rates' => 'Enable exchange rates',
    'targetamount'                 => 'Mål belopp',
    'target_amount'                => 'Target amount',
    'account_role'                 => 'Konto roll',
    'opening_balance_date'         => 'Ingående balans datum',
    'cc_type'                      => 'Kreditkort betalning plan',
    'cc_monthly_payment_date'      => 'Kreditkort månadsbetalnings datum',
    'piggy_bank_id'                => 'Spargris',
    'returnHere'                   => 'Återgå hit',
    'returnHereExplanation'        => 'Återkom hit efter att sparat för att lägga till ytterligare.',
    'returnHereUpdateExplanation'  => 'Återkom hit efter uppdaterat.',
    'description'                  => 'Beskrivning',
    'expense_account'              => 'Kostnadskonto',
    'revenue_account'              => 'Intäktskonton',
    'decimal_places'               => 'Decimaler',
    'destination_amount'           => 'Summa (mål)',
    'new_email_address'            => 'Ny e-postadress',
    'verification'                 => 'Verifikation',
    'api_key'                      => 'API-nyckel',
    'remember_me'                  => 'Kom ihåg mig',
    'liability_type_id'            => 'Skuldstyp',
    'liability_type'               => 'Typ av ansvar',
    'interest'                     => 'Ränta',
    'interest_period'              => 'Ränteperiod',
    'extension_date'               => 'Datum för tillägg',
    'type'                         => 'Typ',
    'convert_Withdrawal'           => 'Konvertera uttag',
    'convert_Deposit'              => 'Konvertera insättning',
    'convert_Transfer'             => 'Konvertera överföring',
    'amount'                       => 'Belopp',
    'foreign_amount'               => 'Utländskt belopp',
    'date'                         => 'Datum',
    'interest_date'                => 'Räntedatum',
    'book_date'                    => 'Bokföringsdatum',
    'process_date'                 => 'Behandlingsdatum',
    'category'                     => 'Kategori',
    'tags'                         => 'Etiketter',
    'deletePermanently'            => 'Ta bort permanent',
    'cancel'                       => 'Avbryt',
    'targetdate'                   => 'Måldatum',
    'target_date'                  => 'Target date',
    'startdate'                    => 'Startdatum',
    'start_date'                   => 'Start date',
    'tag'                          => 'Etikett',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Under',
    'symbol'                       => 'Symbol',
    'code'                         => 'Kod',
    'iban'                         => 'IBAN',
    'account_number'               => 'Kontonummer',
    'creditCardNumber'             => 'Kreditkortsnummer',
    'has_headers'                  => 'Rubriker',
    'date_format'                  => 'Datumformat',
    'attachments[]'                => 'Bilagor',
    'title'                        => 'Titel',
    'notes'                        => 'Anteckningar',
    'filename'                     => 'Filnamn',
    'mime'                         => 'MIME-typ',
    'size'                         => 'Storlek',
    'trigger'                      => 'Utlösare',
    'stop_processing'              => 'Sluta bearbeta',
    'end_date'                     => 'End date',
    'enddate'                      => 'Slutdatum',
    'move_rules_before_delete'     => 'Regelgrupp',
    'start'                        => 'Start område',
    'end'                          => 'Slut område',
    'delete_account'               => 'Ta bort konto ":name"',
    'delete_webhook'               => 'Delete webhook ":title"',
    'delete_bill'                  => 'Delete subscription ":name"',
    'delete_budget'                => 'Ta bort budget ":name"',
    'delete_category'              => 'Ta bort kategori ":name"',
    'delete_currency'              => 'Ta bort valuta ":name"',
    'delete_journal'               => 'Ta bort transaktion med beskrivning ":description"',
    'delete_attachment'            => 'Ta bort bilaga ":name"',
    'delete_rule'                  => 'Ta bort regel ":title"',
    'delete_rule_group'            => 'Ta bort regelgrupp ":title"',
    'delete_link_type'             => 'Ta bort länktyp ":name"',
    'delete_user'                  => 'Ta bort användare ":email"',
    'delete_recurring'             => 'Ta bort återkommande transaktion ":title"',
    'user_areYouSure'              => 'Om du tar bort användare ":email", tas allting bort. Det går inte att ångra, återta eller något. Om du tar bort dig själv, tappar du åtkomst till denna installation av Firefly III.',
    'attachment_areYouSure'        => 'Är du säker du vill ta bort bilagan ":name"?',
    'account_areYouSure'           => 'Är du säker du vill ta bort kontot ":name"?',
    'account_areYouSure_js'        => 'Är du säker du vill ta bort kontot "{name}"?',
    'bill_areYouSure'              => 'Are you sure you want to delete the subscription named ":name"?',
    'rule_areYouSure'              => 'Är du säker du vill ta bort regeln ":title"?',
    'object_group_areYouSure'      => 'Är du säker på att du vill ta bort gruppen ":title"?',
    'ruleGroup_areYouSure'         => 'Är du säker du vill ta bort regelgruppen ":title"?',
    'budget_areYouSure'            => 'Är du säker du vill ta bort budgeten ":name"?',
    'webhook_areYouSure'           => 'Are you sure you want to delete the webhook named ":title"?',
    'category_areYouSure'          => 'Är du säker du vill ta bort kategorin ":name"?',
    'recurring_areYouSure'         => 'Är du säker du vill ta bort återkommande transaktioner ":title"?',
    'currency_areYouSure'          => 'Är du säker du vill ta bort valutan ":name"?',
    'piggyBank_areYouSure'         => 'Är du säker du vill ta bort spargrisen ":name"?',
    'journal_areYouSure'           => 'Är du säker du vill ta bort transaktionen ":description"?',
    'mass_journal_are_you_sure'    => 'Är du säker du vill ta bort dessa transaktioner?',



    'tag_areYouSure'               => 'Är du säker du vill ta bort etiketten ":tag"?',
    'journal_link_areYouSure'      => 'Är du säker du vill ta bort länken mellan <a href=":source_link">:source</a> och <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Är du säker du vill ta bort länktypen ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Att ta bort saker från Firefly III är permanent och kan inte ångras.',
    'mass_make_selection'          => 'Du kan fortfarande förhindra saker från att raderas genom att ta bort kryssrutan.',
    'delete_all_permanently'       => 'Ta bort valt permanent',
    'update_all_journals'          => 'Uppdatera dessa transaktioner',
    'also_delete_transactions'     => 'Transaktionen kopplad till detta konto kommer också att tas bort.|Alla :count transaktioner kopplade till detta konto kommer också att tas bort.',
    'also_delete_transactions_js'  => 'Inga transaktioner|Den enda transaktionen som är ansluten till detta konto kommer också att tas bort.|Alla {count} transaktioner som är kopplade till detta konto kommer också att tas bort.',
    'also_delete_connections'      => 'Den transaktion som är länkad med denna länktyp kommer att mista sin koppling.|Alla :count transaktioner länkade med denna länktyp kommer att mista sin koppling.',
    'also_delete_rules'            => 'Regeln kopplad till denna regelgrupp tas också bort. Alla :count regler kopplade till denna regelgrupp tas också bort.',
    'also_delete_piggyBanks'       => 'Spargrisen kopplad till detta konto tas också bort.|Alla :count spargrisar kopplade till detta konto kommer också att tas bort.',
    'also_delete_piggyBanks_js'    => 'Inga spargrisar|Den enda spargrisen som är ansluten till detta konto kommer också att tas bort.|Alla {count} spargrisar anslutna till detta konto kommer också att tas bort.',
    'not_delete_piggy_banks'       => 'Den sparbank som är ansluten till denna grupp tas ej bort.|De :count sparbanker anslutna till denna grupp kommer inte att tas bort.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => 'Transaktionen kopplad till budgeten kommer att sparas.|Alla :count transaktioner kopplade till budgeten kommer att sparas.',
    'category_keep_transactions'   => 'Transaktionen kopplad till kategorin kommer att sparas.|Alla :count transaktioner kopplade till kategorin kommer att sparas.',
    'recurring_keep_transactions'  => 'Transaktionen skapad av denna återkommande transaktion kommer inte tas bort.|Alla :count transaktioner skapade av denna återkommande transaktion undantas borttagning.',
    'tag_keep_transactions'        => 'Transaktionen kopplad till etiketten kommer inte att tas bort.|Alla :count transaktioner kopplade till etiketten kommer att sparas.',
    'check_for_updates'            => 'Sök efter uppdateringar',
    'liability_direction'          => 'Ansvar in/ut',
    'delete_object_group'          => 'Ta bort groupp ":title"',
    'email'                        => 'E-postadress',
    'password'                     => 'Lösenord',
    'password_confirmation'        => 'Lösenord (igen)',
    'blocked'                      => 'Blockerad?',
    'blocked_code'                 => 'Anledning för blockering',
    'login_name'                   => 'Logga in',
    'is_owner'                     => 'Admin?',
    'url'                          => 'Länk',
    'bill_end_date'                => 'Slutdatum',

    // import
    'apply_rules'                  => 'Tillämpa regler',
    'artist'                       => 'Artist',
    'album'                        => 'Album',
    'song'                         => 'Låt',

    // admin
    'domain'                       => 'Domän',
    'single_user_mode'             => 'Inaktivera användarregistrering',
    'is_demo_site'                 => 'En demo sida',

    // import
    'configuration_file'           => 'Konfigurationsfil',
    'csv_comma'                    => 'Ett komma (,)',
    'csv_semicolon'                => 'Ett semikolon (;)',
    'csv_tab'                      => 'Ett tabb (osynligt)',
    'csv_delimiter'                => 'CSV fältavgränsare',
    'client_id'                    => 'Client ID',
    'app_id'                       => 'App-ID',
    'secret'                       => 'Hemlig nyckel',
    'public_key'                   => 'Publik nyckel',
    'country_code'                 => 'Landskod',
    'provider_code'                => 'Bank eller dataleverantör',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => 'Port',
    'fints_bank_code'              => 'Bankkod',
    'fints_username'               => 'Användarnamn',
    'fints_password'               => 'PIN / Lösenord',
    'fints_account'                => 'FinTS konto',
    'local_account'                => 'Firefly III konto',



    'from_date'                    => 'Datum från',
    'to_date'                      => 'Datum till',
    'due_date'                     => 'Förfallodatum',
    'payment_date'                 => 'Betalningsdatum',
    'invoice_date'                 => 'Fakturadatum',
    'internal_reference'           => 'Intern referens',
    'inward'                       => 'Inkommande beskrivning',
    'outward'                      => 'Utgående beskrivning',
    'rule_group_id'                => 'Regelgrupp',
    'transaction_description'      => 'Transaktionsbeskrivning',
    'first_date'                   => 'Första datum',
    'transaction_type'             => 'Transaktionstyp',
    'repeat_until'                 => 'Upprepa tills',
    'recurring_description'        => 'Återkommande transaktionsbeskrivning',
    'repetition_type'              => 'Typ av upprepning',
    'foreign_currency_id'          => 'Utländsk valuta',
    'repetition_end'               => 'Upprepning avslutas',
    'repetitions'                  => 'Upprepningar',
    'calendar'                     => 'Kalender',
    'weekend'                      => 'Helg',
    'client_secret'                => 'Klient-hemlighet',
    'withdrawal_destination_id'    => 'Destinationskonto',
    'deposit_source_id'            => 'Källkonto',
    'expected_on'                  => 'Förväntad',
    'paid'                         => 'Betald',
    'auto_budget_type'             => 'Auto-budget',
    'auto_budget_amount'           => 'Auto-budget belopp',
    'auto_budget_period'           => 'Auto-budget period',
    'collected'                    => 'Insamlat',
    'submitted'                    => 'Inskickad',
    'key'                          => 'Nyckel',
    'value'                        => 'Innehållet i registret',
    'webhook_delivery'             => 'Delivery',
    'webhook_response'             => 'Response',
    'webhook_trigger'              => 'Utlösare',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy username',
    'ntfy_pass'                    => 'Ntfy password',
];
