<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => '以:timezone儲存',
    'displayed_in_tz'                           => '以:timezone顯示',
    'close'                                     => '關閉',
    'actions'                                   => '操作',
    'edit'                                      => '編輯',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => '刪除',
    'split'                                     => '分割',
    'single_split'                              => '拆分',
    'clone'                                     => '複製',
    'clone_and_edit'                            => '複制並編輯',
    'confirm_action'                            => '確認',
    'last_seven_days'                           => '最近7天',
    'last_thirty_days'                          => '最近30天',
    'last_180_days'                             => '最近 180 天',
    'month_to_date'                             => '本月至今',
    'year_to_date'                              => '今年迄今為止',
    'previous_year' => 'Previous year (:year)',
    'YTD'                                       => '本年至今',
    'welcome_back'                              => '歡迎回來繼續理財！',
    'main_dashboard_page_title'                 => '首頁',
    'everything'                                => '所有',
    'today'                                     => '今天',
    'customRange'                               => '自訂範圍',
    'date_range'                                => '日期範圍',
    'apply'                                     => '套用',
    'select_date'                               => '選擇日期..',
    'cancel'                                    => '取消',
    'from'                                      => '自',
    'to'                                        => '至',
    'structure'                                 => '結構',
    'help_translating'                          => '此說明尚欠奉中文版，<a href="https://crowdin.com/project/firefly-iii-help">要協助翻譯嗎？</a>',
    'showEverything'                            => '全部顯示',
    'never'                                     => '未有資料',
    'no_results_for_empty_search'               => '您的搜尋空白，結果也是空白。',
    'removed_amount'                            => '已移除 :amount',
    'added_amount'                              => '已新增 :amount',
    'asset_account_role_help'                   => '選擇後如有額外選項，可稍後設定。',
    'Opening balance'                           => '初始餘額',
    'create_new_stuff'                          => '建立新內容',
    'new_withdrawal'                            => '新提款',
    'create_new_transaction'                    => '建立新交易',
    'sidebar_frontpage_create'                  => '建立',
    'new_transaction'                           => '新交易',
    'no_rules_for_bill'                         => '此週期性付款未設定其相關的規則。',
    'go_to_asset_accounts'                      => '檢視您的資產帳戶',
    'go_to_budgets'                             => '前往您的預算',
    'go_to_withdrawals'                         => '前往支出',
    'clones_journal_x'                          => '這項交易是從":description" (#:id) 複制出來',
    'go_to_categories'                          => '前往您的分類',
    'go_to_bills'                               => '前往週期性付款',
    'go_to_expense_accounts'                    => '查看您的支出帳戶',
    'go_to_revenue_accounts'                    => '查看您的收入帳戶',
    'go_to_piggies'                             => '前往您的小豬撲滿',
    'new_deposit'                               => '新存款',
    'new_transfer'                              => '新轉帳',
    'new_transfers'                             => '新轉帳',
    'new_asset_account'                         => '新資產帳戶',
    'new_expense_account'                       => '新支出帳戶',
    'new_revenue_account'                       => '新收入帳戶',
    'new_liabilities_account'                   => '新債務',
    'new_budget'                                => '新預算',
    'new_bill'                                  => '新的週期性付款',
    'block_account_logout'                      => '您已被登出。被封鎖的帳號無法使用本網站，您是以有效的電子郵件地址註冊嗎？',
    'flash_success'                             => '成功！',
    'flash_info'                                => '訊息',
    'flash_warning'                             => '警告！',
    'flash_error'                               => '錯誤！',
    'flash_danger'                              => '危險!',
    'flash_info_multiple'                       => '有 1 個訊息|有 :count 個訊息',
    'flash_error_multiple'                      => '有 1 個錯誤|有 :count 個錯誤',
    'net_worth'                                 => '淨值',
    'help_for_this_page'                        => '本頁說明',
    'help_for_this_page_body'                   => '。',
    'two_factor_welcome'                        => '您好！',
    'two_factor_enter_code'                     => '如要繼續，請輸入您的兩步驟驗證 (two factor authentication) 代碼，您的應用程式可為您產生。',
    'two_factor_code_here'                      => '在此輸入代碼',
    'two_factor_title'                          => '兩步驟驗證',
    'authenticate'                              => '驗證',
    'two_factor_forgot_title'                   => '遺失兩步驟驗證',
    'two_factor_forgot'                         => '啥兩步驟我忘了。',
    'two_factor_lost_header'                    => '遺失您的兩步驟驗證嗎？',
    'two_factor_lost_intro'                     => '如果您也遺失了備份代碼，那就很不幸了。這不是您能從網頁介面解決的問題。您有兩個選擇。',
    'two_factor_lost_fix_self'                  => '如果您自行架設 Firefly III，請參閱 <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">此 FAQ 條目</a> 以取得指示。',
    'two_factor_lost_fix_owner'                 => '否則，請寄送電子郵件至網站擁有者 <a href="mailto::site_owner">:site_owner</a> 要求重設您的兩步驟驗證。',
    'mfa_backup_code'                           => '您已使用備份代碼登入 Firefly III。該代碼無法再次使用，請從您的清單中劃掉。',
    'pref_two_factor_new_backup_codes'          => '取得新的備份代碼',
    'pref_two_factor_backup_code_count'         => '您有 :count 個有效的備份代碼。|您有 :count 個有效的備份代碼。',
    '2fa_i_have_them'                           => '我已儲存！',
    'warning_much_data'                         => '載入 :days 天的資料或會相當耗時。',
    'registered'                                => '您已成功註冊！',
    'Default asset account'                     => '預設資產帳戶',
    'no_budget_pointer'                         => '看起來您尚未建立任何預算。您應該在 <a href="budgets">預算</a> 頁面建立一些。預算能協助您追蹤支出。',
    'no_bill_pointer'                           => '看起來您尚未建立任何週期性付款。您應該在 <a href="subscriptions">週期性付款</a> 頁面建立一些。週期性付款能協助您追蹤支出。',
    'Savings account'                           => '儲蓄帳戶',
    'Credit card'                               => '信用卡',
    'source_accounts'                           => 'Source account|Source accounts',
    'destination_accounts'                      => 'Destination account|Destination accounts',
    'user_id_is'                                => '您的使用者 ID 是 <strong>:user</strong>',
    'field_supports_markdown'                   => '此欄位支援 <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a> 語法。',
    'need_more_help'                            => '如果您需要更多 Firefly III 的協助，請 <a href="https://github.com/firefly-iii/firefly-iii/issues">於 GitHub 建立提問</a>。',
    'reenable_intro_text'                       => '您也可以重新啟用 <a href="#" id="reenableGuidance">介紹指引</a>。',
    'intro_boxes_after_refresh'                 => '重新整理頁面後，介紹框將會再次出現。',
    'show_all_no_filter'                        => '不以日期分組，顯示所有交易紀錄',
    'expenses_by_category'                      => '按分類的支出',
    'expenses_by_budget'                        => '按預算的支出',
    'income_by_category'                        => '按分類的收入',
    'expenses_by_asset_account'                 => '按資產帳戶的支出',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III 無法重新導向正確頁面，抱歉。',
    'sum_of_expenses'                           => '支出總和',
    'sum_of_income'                             => '收入總和',
    'liabilities'                               => '債務',
    'spent_in_specific_budget'                  => '預算「:budget」中的花費',
    'spent_in_specific_double'                  => '於帳戶 ":account" 花費了',
    'earned_in_specific_double'                 => '於帳戶 ":account" 賺取了',
    'source_account'                            => '來源帳戶',
    'source_account_reconciliation'             => '您無法編輯對帳交易的來源帳戶。',
    'destination_account'                       => '目標帳戶',
    'destination_account_reconciliation'        => '您無法編輯對帳交易的目標帳戶。',
    'sum_of_expenses_in_budget'                 => '預算「:budget」中的總花費',
    'left_in_budget_limit'                      => '依照預算的支出尚餘',
    'current_period'                            => '目前區間',
    'show_the_current_period_and_overview'      => '顯示目前區間與概覽',
    'pref_anonymous' => 'Hidden amounts',
    'pref_anonymous_help' => 'For privacy and anonymity, you can make Firefly III hide all amounts. This will not hide amounts in edit boxes, but the rest are hidden. You can also toggle this with the little "eye"-icon in the top bar.',
    'pref_anonymous_label' => 'Hide amounts',
    'pref_languages_locale'                     => '英文以外的語言，須搭配作業系統內對應的地區資訊 (locale-information) 才能正常運作，否則貨幣資料、日期與金額或會格式有誤。',
    'budget_in_period'                          => 'All transactions for budget ":name" between :start and :end in :currency',
    'chart_budget_in_period'                    => 'Chart for all transactions for budget ":name" between :start and :end in :currency',
    'chart_budget_in_period_only_currency'      => '您設定的預算金額貨幣為 :currency，因此此圖表只會顯示以 :currency 的交易。',
    'chart_account_in_period'                   => 'Chart for all transactions for account ":name" (:balance) between :start and :end',
    'chart_category_in_period'                  => '分類「:name」自 :start 至 :end 的所有交易圖表',
    'chart_category_all'                        => '分類「:name」的所有交易圖表',
    'clone_withdrawal'                          => '複製此提款',
    'clone_deposit'                             => '複製此存款',
    'clone_transfer'                            => '複製此轉帳',
    'multi_select_no_selection'                 => '未選取',
    'multi_select_select_all'                   => '選取全部',
    'multi_select_n_selected'                   => '選取',
    'multi_select_all_selected'                 => '全部選取',
    'multi_select_filter_placeholder'           => '搜尋…',
    'intro_next_label'                          => '下一步',
    'intro_prev_label'                          => '上一步',
    'intro_skip_label'                          => '略過',
    'intro_done_label'                          => '完成',
    'between_dates_breadcrumb'                  => '自 :start 至 :end',
    'all_journals_without_budget'               => '沒有預算的所有交易',
    'journals_without_budget'                   => '沒有預算的交易',
    'all_journals_without_category'             => '沒有分類的所有交易',
    'journals_without_category'                 => '沒有分類的交易',
    'all_journals_for_account'                  => ':name 帳戶的所有交易',
    'chart_all_journals_for_account'            => ':name 帳戶的所有交易圖表',
    'journals_in_period_for_account'            => ':name 帳戶自 :start 至 :end 的所有交易',
    'journals_in_period_for_account_js'         => 'All transactions for account {title} between {start} and {end}',
    'transferred'                               => '已轉帳',
    'all_withdrawal'                            => '所有支出',
    'all_transactions'                          => '所有交易',
    'title_withdrawal_between'                  => '自 :start 至 :end 的所有支出',
    'all_deposit'                               => '所有收入',
    'title_deposit_between'                     => '自 :start 至 :end 的所有收入',
    'all_transfers'                             => '所有轉帳',
    'title_transfers_between'                   => '自 :start 至 :end 的所有轉帳',
    'all_transfer'                              => '所有轉帳',
    'all_journals_for_tag'                      => '標籤「:tag」的所有交易',
    'title_transfer_between'                    => '自 :start 至 :end 的所有轉帳',
    'all_journals_for_category'                 => '分類 :name 的所有交易',
    'all_journals_for_budget'                   => '預算 :name 的所有交易',
    'chart_all_journals_for_budget'             => '預算 :name 的所有交易圖表',
    'journals_in_period_for_category'           => '分類 :name 自 :start 至 :end 的所有交易',
    'journals_in_period_for_tag'                => '標籤 :tag 自 :start 至 :end 的所有交易',
    'not_available_demo_user'                   => '此功能未開放予展示使用者。',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => '來源資產帳戶「@source_name」僅接受以 @source_currency 交易，目標資產帳戶「@dest_name」僅接受以 @dest_currency 交易，您必須提供對應兩種貨幣的轉帳總額。',
    'transaction_data'                          => '交易資料',
    'invalid_server_configuration'              => '伺服器組態無效',
    'invalid_locale_settings'                   => 'Firefly III 無法正確格式化金錢數值，因您的伺服器缺少相關套件。請參考 <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">此處說明</a>。',
    'quickswitch'                               => '快速切換',
    'sign_in_to_start'                          => '登入以開始您的連線階段',
    'sign_in'                                   => '登入',
    'register_new_account'                      => '註冊新帳號',
    'forgot_my_password'                        => '我忘記了密碼',
    'problems_with_input'                       => '輸入有誤。',
    'reset_password'                            => '重設密碼',
    'button_reset_password'                     => '重設密碼',
    'reset_button'                              => '重設',
    'want_to_login'                             => '我想登入',
    'login_page_title'                          => '登入 Firefly III',
    'register_page_title'                       => '在 Firefly III 註冊',
    'forgot_pw_page_title'                      => '忘記您 Firefly III 的密碼',
    'reset_pw_page_title'                       => '重設您 Firefly III 的密碼',
    'cannot_reset_demo_user'                    => '您不能重設 展示使用者 的密碼。',
    'no_att_demo_user'                          => '展示用戶無法上傳附件。',
    'button_register'                           => '註冊帳號',
    'authorization'                             => '身份認證',
    'active_bills_only'                         => '僅啟用的週期性付款',
    'active_bills_only_total'                   => '所有啟用的週期性付款',
    'active_exp_bills_only'                     => '僅啟用和預期的週期性付款',
    'active_exp_bills_only_total'               => '所有啟用且預期的週期性付款',
    'per_period_sum_1D'                         => '預期每日開支',
    'per_period_sum_1W'                         => '預期每週開支',
    'per_period_sum_1M'                         => '預期每月開支',
    'per_period_sum_3M'                         => '預期每季度開支',
    'per_period_sum_6M'                         => '預期每半年開支',
    'per_period_sum_1Y'                         => '預期每年開支',
    'average_per_bill'                          => '每個週期性付款的平均值',
    'expected_total'                            => '預期總數',
    'reconciliation_account_name'               => ':name 對帳 (:currency)',
    'saved'                                     => '已儲存',
    'advanced_options'                          => '進階選項',
    'advanced_options_explain'                  => 'Firefly III 的部分頁面在此按鈕後方有進階選項。本頁並無特別進階功能，但仍請查看其他頁面！',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => '停用',
    'no_webhook_messages'                       => '尚無 webhook 訊息',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => '在交易建立後',
    'webhook_trigger_UPDATE_TRANSACTION'        => '在交易更新後',
    'webhook_trigger_DESTROY_TRANSACTION'       => '在交易刪除後',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => '交易詳情',
    'webhook_response_ACCOUNTS'                 => '帳號詳情',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => '檢查',
    'create_new_webhook'                        => '建立新的 webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => '指示此 webhook 在何種事件時觸發',
    'webhook_response_form_help'                => '指出此 webhook 必須向該 URL 提交什麼資料。',
    'webhook_delivery_form_help'                => '指示此 webhook 以何種格式傳送資料。',
    'webhook_active_form_help'                  => '此 webhook 必須處於啟用狀態，否則不會被呼叫。',
    'stored_new_webhook'                        => '已儲存新的 webhook 「:title」',
    'delete_webhook'                            => '刪除 Webhook',
    'deleted_webhook'                           => '已刪除 webhook「:title」',
    'edit_webhook'                              => '編輯 webhook「:title」',
    'updated_webhook'                           => '已更新 webhook「:title」',
    'edit_webhook_js'                           => '編輯 webhook「{title}」',
    'show_webhook'                              => 'Webhook「:title」',
    'webhook_was_triggered'                     => '此 webhook 已於指定的交易中被觸發。請稍候顯示結果。',
    'webhook_messages'                          => 'Webhook 訊息',
    'view_message'                              => '查看訊息',
    'view_attempts'                             => '檢視失敗的嘗試',
    'message_content_title'                     => 'Webhook 訊息內容',
    'message_content_help'                      => '這是透過此 webhook 已送出（或嘗試送出）的訊息內容。',
    'attempt_content_title'                     => 'Webhook 嘗試',
    'attempt_content_help'                      => '以下為此 webhook 訊息提交至設定之 URL 時所有未成功的嘗試。過一段時間後，Firefly III 將停止嘗試。',
    'no_attempts'                               => '沒有未成功的嘗試。這是好事！',
    'webhook_attempt_at'                        => '於 {moment} 的嘗試',
    'logs'                                      => '紀錄日誌',
    'response'                                  => '回覆',
    'visit_webhook_url'                         => '造訪 webhook URL',
    'reset_webhook_secret'                      => '重設 webhook 密鑰',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID}（「{title}」）</a> 已儲存。',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a>（「{title}」）已更新。',

    // API access
    'authorization_request'                     => 'Firefly III :version 版授權請求',
    'authorization_request_intro'               => '應用程式「<strong>:client</strong>」正在請求存取您的財務管理權限。您要授權「<strong>:client</strong>」存取這些紀錄嗎？',
    'authorization_request_site'                => '您將被重新導向至 <code>:url</code>，之後該站點可以存取您的 Firefly III 資料。',
    'authorization_request_invalid'             => '此存取請求無效。請勿再次點擊此連結。',
    'scopes_will_be_able'                       => '此應用程式可以：',
    'button_authorize'                          => '授權',
    'none_in_select_list'                       => '(空)',
    'no_piggy_bank'                             => '(無小豬撲滿)',
    'name_in_currency'                          => ':name 於 :currency',
    'paid_in_currency'                          => '以 :currency 支付',
    'unpaid_in_currency'                        => '未以 :currency 支付',
    'is_alpha_warning'                          => '您使用的是 ALPHA 版本。可能會遇到問題。',
    'is_beta_warning'                           => '您使用的是 BETA 版本。可能會遇到問題。',
    'all_destination_accounts'                  => '目標帳戶',
    'all_source_accounts'                       => '來源帳戶',
    'back_to_index'                             => 'Back to the index',
    'cant_logout_guard'                         => 'Firefly III 無法將您登出。',
    'internal_reference'                        => 'Internal reference',

    // check for updates:
    'update_check_title'                        => '檢查更新',
    'admin_update_check_title'                  => '自動檢查更新',
    'admin_update_check_explain'                => 'Firefly III 可自動檢查更新。當您啟用此設定時，它會連線至 Firefly III 更新伺服器以檢查是否有新版本可用。一旦有新版本，系統會通知您。您可以使用右側的按鈕測試這項通知。請於下方指定是否要讓 Firefly III 檢查更新。',
    'check_for_updates_permission'              => 'Firefly III 可以檢查更新，但需要您的許可才行。請前往 <a href=":link">設定</a> 指定您是否想啟用此功能。',
    'updates_ask_me_later'                      => '稍後再詢問',
    'updates_do_not_check'                      => '不檢查更新',
    'updates_enable_check'                      => '啟用更新檢查',
    'admin_update_check_now_title'              => '立刻檢查更新',
    'admin_update_check_now_explain'            => '如果您按下此按鈕，Firefly III 將檢查您目前的版本是否為最新版。',
    'check_for_updates_button'                  => '馬上檢查！',
    'update_new_version_alert'                  => '有新版本的 Firefly III 可用。目前版本：:your_version，最新版本：:new_version（發行於 :date）。',
    'update_version_beta'                       => '您使用的是測試 (BETA) 版本，可能會遇到問題。',
    'update_version_alpha'                      => '您使用的是測試 (ALPHA) 版本，可能會遇到問題。',
    'update_current_dev_older'                  => '您正在使用開發版本「:version」，比最新發行版本「:new_version」更舊。請立即更新！',
    'update_current_dev_newer'                  => '您正在使用開發版本「:version」，比最新發行版本「:new_version」更新。',
    'update_current_version_alert'              => '您正在使用 :version，此為目前最新可用的版本。',
    'update_newer_version_alert'                => '您目前的版本（:your_version）比最新發行版本（:new_version）還新。',
    'update_check_error'                        => '檢查更新時發生錯誤：:error',
    'unknown_error'                             => '發生未知錯誤，很抱歉。',
    'disabled_but_check'                        => '您已停用自動檢查更新。請記得自行不時檢查是否有更新。謝謝！',
    'admin_update_channel_title'                => '更新頻道',
    'admin_update_channel_explain'              => 'Firefly III 具有三個更新「頻道」，決定了您在功能、增強和錯誤修正方面的進度。若您冒險精神旺盛，可以選擇「beta」，若愛冒險則用「alpha」。',
    'update_channel_stable'                     => '穩定版。所有功能應該都能正常運作。',
    'update_channel_beta'                       => 'Beta。包含新功能，但可能會有問題。',
    'update_channel_alpha'                      => 'Alpha。先丟進來，能動就用。',

    // search
    'search'                                    => '搜尋',
    'search_query'                              => '查詢',
    'search_found_transactions'                 => 'Firefly III 在 :time 秒內找到 :count 筆交易。|Firefly III 在 :time 秒內找到 :count 筆交易。',
    'search_found_more_transactions'            => 'Firefly III 在 :time 秒內找到超過 :count 筆交易。',
    'search_for_overview'                       => 'Firefly III 正在搜尋符合 <b>所有</b> 下列條件的交易：',
    'search_for_query'                          => '必須包含以下所有關鍵字：<span class="text-info">:query</span>',
    'search_for_excluded_words'                 => '必須排除以下所有關鍵字：<span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => '這些搜尋參數無效，已被忽略。',

    // old


    'search_modifier_date_on'                             => '交易日期為「:value」',
    'search_modifier_not_date_on'                         => '交易日期不等於「:value」',
    'search_modifier_reconciled'                          => '交易已對帳',
    'search_modifier_not_reconciled'                      => '交易未對帳',
    'search_modifier_id'                                  => '交易ID為「:value」',
    'search_modifier_not_id'                              => '交易ID不為「:value」',
    'search_modifier_date_before'                         => '交易日期在「:value」之前或當天',
    'search_modifier_date_after'                          => '交易日期在「:value」之後或當天',
    'search_modifier_external_id_is'                      => '外部 ID 為「:value」',
    'search_modifier_not_external_id_is'                  => '外部 ID 不為「:value」',
    'search_modifier_no_external_url'                     => '交易沒有外部 URL',
    'search_modifier_no_external_id'                      => '交易沒有外部 ID',
    'search_modifier_not_any_external_url'                => '交易沒有外部 URL',
    'search_modifier_not_any_external_id'                 => '交易沒有外部 ID',
    'search_modifier_any_external_url'                    => '交易必須有（任何）外部 URL',
    'search_modifier_any_external_id'                     => '交易必須有（任何）外部 ID',
    'search_modifier_not_no_external_url'                 => '交易必須有（任何）外部 URL',
    'search_modifier_not_no_external_id'                  => '交易必須有（任何）外部 ID',
    'search_modifier_internal_reference_is'               => '內部參考為「:value」',
    'search_modifier_not_internal_reference_is'           => '內部參考不為「:value」',
    'search_modifier_description_starts'                  => '描述以「:value」開頭',
    'search_modifier_not_description_starts'              => '描述不以「:value」開頭',
    'search_modifier_description_ends'                    => '描述以「:value」結尾',
    'search_modifier_not_description_ends'                => '描述不以「:value」結尾',
    'search_modifier_description_contains'                => '描述包含「:value」',
    'search_modifier_not_description_contains'            => '描述不包含「:value」',
    'search_modifier_description_is'                      => '描述正好是「:value」',
    'search_modifier_not_description_is'                  => '描述並非「:value」',
    'search_modifier_currency_is'                         => '交易（外幣）貨幣為「:value」',
    'search_modifier_not_currency_is'                     => '交易（外幣）貨幣不為「:value」',
    'search_modifier_foreign_currency_is'                 => '交易外幣為「:value」',
    'search_modifier_not_foreign_currency_is'             => '交易外幣不為「:value」',
    'search_modifier_has_attachments'                     => '交易必須包含附件',
    'search_modifier_has_no_category'                     => '交易必須沒有分類',
    'search_modifier_not_has_no_category'                 => '交易必須有（任何）分類',
    'search_modifier_not_has_any_category'                => '交易必須沒有分類',
    'search_modifier_has_any_category'                    => '交易必須有（任何）分類',
    'search_modifier_has_no_budget'                       => '交易必須沒有預算',
    'search_modifier_not_has_any_budget'                  => '交易必須沒有預算',
    'search_modifier_has_any_budget'                      => '交易必須有（任何）預算',
    'search_modifier_not_has_no_budget'                   => '交易必須有（任何）預算',
    'search_modifier_has_no_bill'                         => '交易必須沒有週期性付款',
    'search_modifier_not_has_no_bill'                     => '交易必須有（任何）週期性付款',
    'search_modifier_has_any_bill'                        => '交易必須有（任何）週期性付款',
    'search_modifier_not_has_any_bill'                    => '交易必須沒有週期性付款',
    'search_modifier_has_no_tag'                          => '交易必須沒有標籤',
    'search_modifier_not_has_any_tag'                     => '交易必須沒有標籤',
    'search_modifier_not_has_no_tag'                      => '交易必須有（任何）標籤',
    'search_modifier_has_any_tag'                         => '交易必須有（任何）標籤',
    'search_modifier_notes_contains'                      => '交易備註包含「:value」',
    'search_modifier_not_notes_contains'                  => '交易備註不包含「:value」',
    'search_modifier_notes_starts'                        => '交易備註以「:value」開頭',
    'search_modifier_not_notes_starts'                    => '交易備註不以「:value」開頭',
    'search_modifier_notes_ends'                          => '交易備註以「:value」結尾',
    'search_modifier_not_notes_ends'                      => '交易備註不以「:value」結尾',
    'search_modifier_notes_is'                            => '交易備註正好是「:value」',
    'search_modifier_not_notes_is'                        => '交易備註並非「:value」',
    'search_modifier_no_notes'                            => '交易沒有備註',
    'search_modifier_not_no_notes'                        => '交易必須有備註',
    'search_modifier_any_notes'                           => '交易必須有備註',
    'search_modifier_not_any_notes'                       => '交易沒有備註',
    'search_modifier_amount_is'                           => '金額正好是 :value',
    'search_modifier_not_amount_is'                       => '金額不為 :value',
    'search_modifier_amount_less'                         => '金額少於或等於 :value',
    'search_modifier_not_amount_more'                     => '金額少於或等於 :value',
    'search_modifier_amount_more'                         => '金額大於或等於 :value',
    'search_modifier_not_amount_less'                     => '金額大於或等於 :value',
    'search_modifier_source_account_is'                   => '來源帳戶名稱正好是「:value」',
    'search_modifier_not_source_account_is'               => '來源帳戶名稱不為「:value」',
    'search_modifier_source_account_contains'             => '來源帳戶名稱包含「:value」',
    'search_modifier_not_source_account_contains'         => '來源帳戶名稱不包含「:value」',
    'search_modifier_source_account_starts'               => '來源帳戶名稱以「:value」開頭',
    'search_modifier_not_source_account_starts'           => '來源帳戶名稱不以「:value」開頭',
    'search_modifier_source_account_ends'                 => '來源帳戶名稱以「:value」結尾',
    'search_modifier_not_source_account_ends'             => '來源帳戶名稱不以「:value」結尾',
    'search_modifier_source_account_id'                   => '來源帳戶 ID 為 :value',
    'search_modifier_not_source_account_id'               => '來源帳戶 ID 不為 :value',
    'search_modifier_source_account_nr_is'                => '來源帳戶號碼（IBAN）為「:value」',
    'search_modifier_not_source_account_nr_is'            => '來源帳戶號碼（IBAN）不為「:value」',
    'search_modifier_source_account_nr_contains'          => '來源帳戶號碼（IBAN）包含「:value」',
    'search_modifier_not_source_account_nr_contains'      => '來源帳戶號碼（IBAN）不包含「:value」',
    'search_modifier_source_account_nr_starts'            => '來源帳戶號碼（IBAN）以「:value」開頭',
    'search_modifier_not_source_account_nr_starts'        => '來源帳戶號碼（IBAN）不以「:value」開頭',
    'search_modifier_source_account_nr_ends'              => '來源帳戶號碼（IBAN）以「:value」結尾',
    'search_modifier_not_source_account_nr_ends'          => '來源帳戶號碼（IBAN）不以「:value」結尾',
    'search_modifier_destination_account_is'              => '目標帳戶名稱正好是「:value」',
    'search_modifier_not_destination_account_is'          => '目標帳戶名稱不為「:value」',
    'search_modifier_destination_account_contains'        => '目標帳戶名稱包含「:value」',
    'search_modifier_not_destination_account_contains'    => '目標帳戶名稱不包含「:value」',
    'search_modifier_destination_account_starts'          => '目標帳戶名稱以「:value」開頭',
    'search_modifier_not_destination_account_starts'      => '目標帳戶名稱不以「:value」開頭',
    'search_modifier_destination_account_ends'            => '目標帳戶名稱以「:value」結尾',
    'search_modifier_not_destination_account_ends'        => '目標帳戶名稱不以「:value」結尾',
    'search_modifier_destination_account_id'              => '目標帳戶 ID 為 :value',
    'search_modifier_not_destination_account_id'          => '目標帳戶 ID 不為 :value',
    'search_modifier_destination_is_cash'                 => '目標帳戶是「(cash)」帳戶',
    'search_modifier_not_destination_is_cash'             => '目標帳戶不是「(cash)」帳戶',
    'search_modifier_source_is_cash'                      => '來源帳戶是「(cash)」帳戶',
    'search_modifier_not_source_is_cash'                  => '來源帳戶不是「(cash)」帳戶',
    'search_modifier_destination_account_nr_is'           => '目標帳戶號碼（IBAN）為「:value」',
    'search_modifier_not_destination_account_nr_is'       => '目標帳戶號碼（IBAN）不為「:value」',
    'search_modifier_destination_account_nr_contains'     => '目標帳戶號碼（IBAN）包含「:value」',
    'search_modifier_not_destination_account_nr_contains' => '目標帳戶號碼（IBAN）不包含「:value」',
    'search_modifier_destination_account_nr_starts'       => '目標帳戶號碼（IBAN）以「:value」開頭',
    'search_modifier_not_destination_account_nr_starts'   => '目標帳戶號碼（IBAN）不以「:value」開頭',
    'search_modifier_destination_account_nr_ends'         => '目標帳戶號碼（IBAN）以「:value」結尾',
    'search_modifier_not_destination_account_nr_ends'     => '目標帳戶號碼（IBAN）不以「:value」結尾',
    'search_modifier_account_id'                          => '來源或目標帳戶 ID 為：:value',
    'search_modifier_not_account_id'                      => '來源或目標帳戶 ID 不為：:value',
    'search_modifier_category_is'                         => '分類為「:value」',
    'search_modifier_not_category_is'                     => '分類不為「:value」',
    'search_modifier_budget_is'                           => '預算為「:value」',
    'search_modifier_not_budget_is'                       => '預算不為「:value」',
    'search_modifier_bill_is'                             => '週期性付款為「:value」',
    'search_modifier_not_bill_is'                         => '週期性付款不為「:value」',
    'search_modifier_transaction_type'                    => '交易類型為「:value」',
    'search_modifier_not_transaction_type'                => '交易類型不為「:value」',
    'search_modifier_tag_is'                              => '標籤為「:value」',
    'search_modifier_tag_contains'                        => '標籤包含「:value」',
    'search_modifier_not_tag_contains'                    => '標籤不包含「:value」',
    'search_modifier_tag_ends'                            => '標籤以「:value」結尾',
    'search_modifier_tag_starts'                          => '標籤以「:value」開頭',
    'search_modifier_not_tag_is'                          => '沒有標籤「:value」',
    'search_modifier_date_on_year'                        => '交易在「:value」年',
    'search_modifier_not_date_on_year'                    => '交易不在「:value」年',
    'search_modifier_date_on_month'                       => '交易在「:value」月',
    'search_modifier_not_date_on_month'                   => '交易不在「:value」月',
    'search_modifier_date_on_day'                         => '交易在每月的「:value」日',
    'search_modifier_not_date_on_day'                     => '交易不在每月的「:value」日',
    'search_modifier_date_before_year'                    => '交易在「:value」年或之前',
    'search_modifier_date_before_month'                   => '交易在「:value」月或之前',
    'search_modifier_date_before_day'                     => '交易在每月「:value」日或之前',
    'search_modifier_date_after_year'                     => '交易在「:value」年或之後',
    'search_modifier_date_after_month'                    => '交易在「:value」月或之後',
    'search_modifier_date_after_day'                      => '交易在每月「:value」日或之後',

    // new
    'search_modifier_tag_is_not'                          => '沒有標籤「:value」',
    'search_modifier_not_tag_is_not'                      => '標籤為「:value」',
    'search_modifier_account_is'                          => '來源或目標帳戶為「:value」',
    'search_modifier_not_account_is'                      => '來源或目標帳戶並非「:value」',
    'search_modifier_account_contains'                    => '來源或目標帳戶包含「:value」',
    'search_modifier_not_account_contains'                => '來源或目標帳戶不包含「:value」',
    'search_modifier_account_ends'                        => '來源或目標帳戶以「:value」結尾',
    'search_modifier_not_account_ends'                    => '來源或目標帳戶不以「:value」結尾',
    'search_modifier_account_starts'                      => '來源或目標帳戶以「:value」開頭',
    'search_modifier_not_account_starts'                  => '來源或目標帳戶不以「:value」開頭',
    'search_modifier_account_nr_is'                       => '來源或目標帳戶號碼/IBAN 為「:value」',
    'search_modifier_not_account_nr_is'                   => '來源或目標帳戶號碼/IBAN 並非「:value」',
    'search_modifier_account_nr_contains'                 => '來源或目標帳戶號碼/IBAN 包含「:value」',
    'search_modifier_not_account_nr_contains'             => '來源或目標帳戶號碼/IBAN 不包含「:value」',
    'search_modifier_account_nr_ends'                     => '來源或目標帳戶號碼/IBAN 以「:value」結尾',
    'search_modifier_not_account_nr_ends'                 => '來源或目標帳戶號碼/IBAN 不以「:value」結尾',
    'search_modifier_account_nr_starts'                   => '來源或目標帳戶號碼/IBAN 以「:value」開頭',
    'search_modifier_not_account_nr_starts'               => '來源或目標帳戶號碼/IBAN 不以「:value」開頭',
    'search_modifier_category_contains'                   => '分類包含「:value」',
    'search_modifier_not_category_contains'               => '分類不包含「:value」',
    'search_modifier_category_ends'                       => '分類以「:value」結尾',
    'search_modifier_not_category_ends'                   => '分類不以「:value」結尾',
    'search_modifier_category_starts'                     => '分類以「:value」開頭',
    'search_modifier_not_category_starts'                 => '分類不以「:value」開頭',
    'search_modifier_budget_contains'                     => '預算包含「:value」',
    'search_modifier_not_budget_contains'                 => '預算不包含「:value」',
    'search_modifier_budget_ends'                         => '預算以「:value」結尾',
    'search_modifier_not_budget_ends'                     => '預算不以「:value」結尾',
    'search_modifier_budget_starts'                       => '預算以「:value」開頭',
    'search_modifier_not_budget_starts'                   => '預算不以「:value」開頭',
    'search_modifier_bill_contains'                       => '週期性付款包含「:value」',
    'search_modifier_not_bill_contains'                   => '週期性付款不包含「:value」',
    'search_modifier_bill_ends'                           => '週期性付款以「:value」結尾',
    'search_modifier_not_bill_ends'                       => '週期性付款不以「:value」結尾',
    'search_modifier_bill_starts'                         => '週期性付款以「:value」開頭',
    'search_modifier_not_bill_starts'                     => '週期性付款不以「:value」開頭',
    'search_modifier_external_id_contains'                => '外部 ID 包含「:value」',
    'search_modifier_not_external_id_contains'            => '外部 ID 不包含「:value」',
    'search_modifier_external_id_ends'                    => '外部 ID 以「:value」結尾',
    'search_modifier_not_external_id_ends'                => '外部 ID 不以「:value」結尾',
    'search_modifier_external_id_starts'                  => '外部 ID 以「:value」開頭',
    'search_modifier_not_external_id_starts'              => '外部 ID 不以「:value」開頭',
    'search_modifier_internal_reference_contains'         => '內部參考包含「:value」',
    'search_modifier_not_internal_reference_contains'     => '內部參考不包含「:value」',
    'search_modifier_internal_reference_ends'             => '內部參考以「:value」結尾',
    'search_modifier_internal_reference_starts'           => '內部參考以「:value」開頭',
    'search_modifier_not_internal_reference_ends'         => '內部參考不以「:value」結尾',
    'search_modifier_not_internal_reference_starts'       => '內部參考不以「:value」開頭',
    'search_modifier_external_url_is'                     => '外部 URL 為「:value」',
    'search_modifier_not_external_url_is'                 => '外部 URL 不為「:value」',
    'search_modifier_external_url_contains'               => '外部 URL 包含「:value」',
    'search_modifier_not_external_url_contains'           => '外部 URL 不包含「:value」',
    'search_modifier_external_url_ends'                   => '外部 URL 以「:value」結尾',
    'search_modifier_not_external_url_ends'               => '外部 URL 不以「:value」結尾',
    'search_modifier_external_url_starts'                 => '外部 URL 以「:value」開頭',
    'search_modifier_not_external_url_starts'             => '外部 URL 不以「:value」開頭',
    'search_modifier_has_no_attachments'                  => '交易沒有附件',
    'search_modifier_not_has_no_attachments'              => '交易有附件',
    'search_modifier_not_has_attachments'                 => '交易沒有附件',
    'search_modifier_account_is_cash'                     => '來源或目標帳戶為「(cash)」帳戶。',
    'search_modifier_not_account_is_cash'                 => '來源或目標帳戶都不是「(cash)」帳戶。',
    'search_modifier_journal_id'                          => '交易日誌 ID 為「:value」',
    'search_modifier_not_journal_id'                      => '交易日誌 ID 不為「:value」',
    'search_modifier_recurrence_id'                       => '重複交易 ID 為「:value」',
    'search_modifier_not_recurrence_id'                   => '重複交易 ID 不為「:value」',
    'search_modifier_foreign_amount_is'                   => '外幣金額為「:value」',
    'search_modifier_not_foreign_amount_is'               => '外幣金額不為「:value」',
    'search_modifier_foreign_amount_less'                 => '外幣金額小於「:value」',
    'search_modifier_not_foreign_amount_more'             => '外幣金額小於「:value」',
    'search_modifier_not_foreign_amount_less'             => '外幣金額大於「:value」',
    'search_modifier_foreign_amount_more'                 => '外幣金額大於「:value」',
    'search_modifier_exists'                              => '交易存在（任何交易）',
    'search_modifier_not_exists'                          => '交易不存在（沒有交易）',

    // date fields
    'search_modifier_interest_date_on'                    => '交易計息日為「:value」',
    'search_modifier_not_interest_date_on'                => '交易計息日不為「:value」',
    'search_modifier_interest_date_on_year'               => '交易計息日位於「:value」年',
    'search_modifier_not_interest_date_on_year'           => '交易計息日不在「:value」年',
    'search_modifier_interest_date_on_month'              => '交易計息日在「:value」月',
    'search_modifier_not_interest_date_on_month'          => '交易計息日不在「:value」月',
    'search_modifier_interest_date_on_day'                => '交易計息日為當月的「:value」日',
    'search_modifier_not_interest_date_on_day'            => '交易計息日不為當月的「:value」日',
    'search_modifier_interest_date_before_year'           => '交易計息日早於或在「:value」年',
    'search_modifier_interest_date_before_month'          => '交易計息日早於或在「:value」月',
    'search_modifier_interest_date_before_day'            => '交易計息日早於或在每月「:value」日',
    'search_modifier_interest_date_after_year'            => '交易計息日晚於或在「:value」年',
    'search_modifier_interest_date_after_month'           => '交易計息日晚於或在「:value」月',
    'search_modifier_interest_date_after_day'             => '交易計息日晚於或在每月「:value」日',
    'search_modifier_book_date_on_year'                   => '交易入帳日期位於「:value」年',
    'search_modifier_book_date_on_month'                  => '交易入帳日期位於「:value」月',
    'search_modifier_book_date_on_day'                    => '交易入帳日期位於每月「:value」日',
    'search_modifier_not_book_date_on_year'               => '交易入帳日期不在「:value」年',
    'search_modifier_not_book_date_on_month'              => '交易入帳日期不在「:value」月',
    'search_modifier_not_book_date_on_day'                => '交易入帳日期不在當月的「:value」日',
    'search_modifier_book_date_before_year'               => '交易入帳日期早於或在「:value」年',
    'search_modifier_book_date_before_month'              => '交易入帳日期早於或在「:value」月',
    'search_modifier_book_date_before_day'                => '交易入帳日期早於或在每月「:value」日',
    'search_modifier_book_date_after_year'                => '交易入帳日期晚於或在「:value」年',
    'search_modifier_book_date_after_month'               => '交易入帳日期晚於或在「:value」月',
    'search_modifier_book_date_after_day'                 => '交易入帳日期晚於或在每月「:value」日',
    'search_modifier_process_date_on_year'                => '交易處理日期位於「:value」年',
    'search_modifier_process_date_on_month'               => '交易處理日期位於「:value」月',
    'search_modifier_process_date_on_day'                 => '交易處理日期位於每月「:value」日',
    'search_modifier_not_process_date_on_year'            => '交易處理日期不在「:value」年',
    'search_modifier_not_process_date_on_month'           => '交易處理日期不在「:value」月',
    'search_modifier_not_process_date_on_day'             => '交易處理日期不在每月「:value」日',
    'search_modifier_process_date_before_year'            => '交易處理日期早於或在「:value」年',
    'search_modifier_process_date_before_month'           => '交易處理日期早於或在「:value」月',
    'search_modifier_process_date_before_day'             => '交易處理日期早於或在每月「:value」日',
    'search_modifier_process_date_after_year'             => '交易處理日期晚於或在「:value」年',
    'search_modifier_process_date_after_month'            => '交易處理日期晚於或在「:value」月',
    'search_modifier_process_date_after_day'              => '交易處理日期晚於或在每月「:value」日',
    'search_modifier_due_date_on_year'                    => '交易到期日位於「:value」年',
    'search_modifier_due_date_on_month'                   => '交易到期日位於「:value」月',
    'search_modifier_due_date_on_day'                     => '交易到期日在每月「:value」日',
    'search_modifier_not_due_date_on_year'                => '交易到期日不在「:value」年',
    'search_modifier_not_due_date_on_month'               => '交易到期日不在「:value」月',
    'search_modifier_not_due_date_on_day'                 => '交易到期日不在每月「:value」日',
    'search_modifier_due_date_before_year'                => '交易到期日早於或在「:value」年',
    'search_modifier_due_date_before_month'               => '交易到期日早於或在「:value」月',
    'search_modifier_due_date_before_day'                 => '交易到期日早於或在每月「:value」日',
    'search_modifier_due_date_after_year'                 => '交易到期日晚於或在「:value」年',
    'search_modifier_due_date_after_month'                => '交易到期日晚於或在「:value」月',
    'search_modifier_due_date_after_day'                  => '交易到期日晚於或在每月「:value」日',
    'search_modifier_payment_date_on_year'                => '交易支付日期位於「:value」年',
    'search_modifier_payment_date_on_month'               => '交易支付日期位於「:value」月',
    'search_modifier_payment_date_on_day'                 => '交易支付日期位於每月「:value」日',
    'search_modifier_not_payment_date_on_year'            => '交易支付日期不在「:value」年',
    'search_modifier_not_payment_date_on_month'           => '交易支付日期不在「:value」月',
    'search_modifier_not_payment_date_on_day'             => '交易支付日期不在每月「:value」日',
    'search_modifier_payment_date_before_year'            => '交易支付日期早於或在「:value」年',
    'search_modifier_payment_date_before_month'           => '交易支付日期早於或在「:value」月',
    'search_modifier_payment_date_before_day'             => '交易支付日期早於或在每月「:value」日',
    'search_modifier_payment_date_after_year'             => '交易支付日期晚於或在「:value」年',
    'search_modifier_payment_date_after_month'            => '交易支付日期晚於或在「:value」月',
    'search_modifier_payment_date_after_day'              => '交易支付日期晚於或在每月「:value」日',
    'search_modifier_invoice_date_on_year'                => '交易發票日期位於「:value」年',
    'search_modifier_invoice_date_on_month'               => '交易發票日期位於「:value」月',
    'search_modifier_invoice_date_on_day'                 => '交易發票日期位於每月「:value」日',
    'search_modifier_not_invoice_date_on_year'            => '交易發票日期不在「:value」年',
    'search_modifier_not_invoice_date_on_month'           => '交易發票日期不在「:value」月',
    'search_modifier_not_invoice_date_on_day'             => '交易發票日期不在每月「:value」日',
    'search_modifier_invoice_date_before_year'            => '交易發票日期早於或在「:value」年',
    'search_modifier_invoice_date_before_month'           => '交易發票日期早於或在「:value」月',
    'search_modifier_invoice_date_before_day'             => '交易發票日期早於或在每月「:value」日',
    'search_modifier_invoice_date_after_year'             => '交易發票日期晚於或在「:value」年',
    'search_modifier_invoice_date_after_month'            => '交易發票日期晚於或在「:value」月',
    'search_modifier_invoice_date_after_day'              => '交易發票日期晚於或在每月「:value」日',
    // other dates
    'search_modifier_updated_at_on_year'                  => '交易上次更新於「:value」年',
    'search_modifier_updated_at_on_month'                 => '交易上次更新於「:value」月',
    'search_modifier_updated_at_on_day'                   => '交易上次更新於每月「:value」日',
    'search_modifier_not_updated_at_on_year'              => '交易上次更新並非在「:value」年',
    'search_modifier_not_updated_at_on_month'             => '交易上次更新並非在「:value」月',
    'search_modifier_not_updated_at_on_day'               => '交易上次更新並非在每月「:value」日',
    'search_modifier_updated_at_before_year'              => '交易上次更新時間早於或在「:value」年',
    'search_modifier_updated_at_before_month'             => '交易上次更新時間早於或在「:value」月',
    'search_modifier_updated_at_before_day'               => '交易上次更新時間在或早於每月「:value」日',
    'search_modifier_updated_at_after_year'               => '交易上次更新時間在或晚於「:value」年',
    'search_modifier_updated_at_after_month'              => '交易上次更新時間在或晚於「:value」月',
    'search_modifier_updated_at_after_day'                => '交易上次更新時間在或晚於每月「:value」日',
    'search_modifier_created_at_on_year'                  => '交易建立於「:value」年',
    'search_modifier_created_at_on_month'                 => '交易建立於「:value」月',
    'search_modifier_created_at_on_day'                   => '交易建立於每月「:value」日',
    'search_modifier_not_created_at_on_year'              => '交易並非建立於「:value」年',
    'search_modifier_not_created_at_on_month'             => '交易並非建立於「:value」月',
    'search_modifier_not_created_at_on_day'               => '交易並非建立於每月「:value」日',
    'search_modifier_created_at_before_year'              => '交易建立時間在或早於「:value」年',
    'search_modifier_created_at_before_month'             => '交易建立時間在或早於「:value」月',
    'search_modifier_created_at_before_day'               => '交易建立時間在或早於每月「:value」日',
    'search_modifier_created_at_after_year'               => '交易建立時間在或晚於「:value」年',
    'search_modifier_created_at_after_month'              => '交易建立時間在或晚於「:value」月',
    'search_modifier_created_at_after_day'                => '交易建立時間在或晚於每月「:value」日',
    'search_modifier_interest_date_before'                => '交易計息日位於「:value」或之前',
    'search_modifier_interest_date_after'                 => '交易計息日位於「:value」或之後',
    'search_modifier_book_date_on'                        => '交易入帳日期為「:value」',
    'search_modifier_not_book_date_on'                    => '交易入帳日期不為「:value」',
    'search_modifier_book_date_before'                    => '交易入帳日期位於「:value」或之前',
    'search_modifier_book_date_after'                     => '交易入帳日期位於「:value」或之後',
    'search_modifier_process_date_on'                     => '交易處理日期為「:value」',
    'search_modifier_not_process_date_on'                 => '交易處理日期不為「:value」',
    'search_modifier_process_date_before'                 => '交易處理日期位於「:value」或之前',
    'search_modifier_process_date_after'                  => '交易處理日期位於「:value」或之後',
    'search_modifier_due_date_on'                         => '交易到期日為「:value」',
    'search_modifier_not_due_date_on'                     => '交易到期日不為「:value」',
    'search_modifier_due_date_before'                     => '交易到期日位於「:value」或之前',
    'search_modifier_due_date_after'                      => '交易到期日位於「:value」或之後',
    'search_modifier_payment_date_on'                     => '交易支付日期為「:value」',
    'search_modifier_not_payment_date_on'                 => '交易支付日期不為「:value」',
    'search_modifier_payment_date_before'                 => '交易支付日期位於「:value」或之前',
    'search_modifier_payment_date_after'                  => '交易支付日期位於「:value」或之後',
    'search_modifier_invoice_date_on'                     => '交易發票日期為「:value」',
    'search_modifier_not_invoice_date_on'                 => '交易發票日期不為「:value」',
    'search_modifier_invoice_date_before'                 => '交易發票日期位於「:value」或之前',
    'search_modifier_invoice_date_after'                  => '交易發票日期位於「:value」或之後',
    'search_modifier_created_at_on'                       => '交易建立於「:value」',
    'search_modifier_not_created_at_on'                   => '交易並非建立於「:value」',
    'search_modifier_created_at_before'                   => '交易建立時間在「:value」或之前',
    'search_modifier_created_at_after'                    => '交易建立時間在「:value」或之後',
    'search_modifier_updated_at_on'                       => '交易於「:value」時更新',
    'search_modifier_not_updated_at_on'                   => '交易並非在「:value」時更新',
    'search_modifier_updated_at_before'                   => '交易於「:value」或之前更新',
    'search_modifier_updated_at_after'                    => '交易於「:value」或之後更新',

    'search_modifier_attachment_name_is'            => '任何附件名稱為「:value」',
    'search_modifier_attachment_name_contains'      => '任何附件名稱包含「:value」',
    'search_modifier_attachment_name_starts'        => '任何附件名稱以「:value」開頭',
    'search_modifier_attachment_name_ends'          => '任何附件名稱以「:value」結尾',
    'search_modifier_attachment_notes_are'          => '任何附件的備註為「:value」',
    'search_modifier_attachment_notes_contains'     => '任何附件的備註包含「:value」',
    'search_modifier_attachment_notes_starts'       => '任何附件的備註以「:value」開頭',
    'search_modifier_attachment_notes_ends'         => '任何附件的備註以「:value」結尾',
    'search_modifier_not_attachment_name_is'        => '任何附件名稱不為「:value」',
    'search_modifier_not_attachment_name_contains'  => '任何附件名稱不包含「:value」',
    'search_modifier_not_attachment_name_starts'    => '任何附件名稱不以「:value」開頭',
    'search_modifier_not_attachment_name_ends'      => '任何附件名稱不以「:value」結尾',
    'search_modifier_not_attachment_notes_are'      => '任何附件的備註不為「:value」',
    'search_modifier_not_attachment_notes_contains' => '任何附件的備註不包含「:value」',
    'search_modifier_not_attachment_notes_starts'   => '任何附件的備註不以「:value」開頭',
    'search_modifier_not_attachment_notes_ends'     => '任何附件的備註不以「:value」結尾',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT 為「:value」',
    'update_rule_from_query'                        => '從搜尋查詢更新規則「:rule」',
    'create_rule_from_query'                        => '從搜尋查詢建立新規則',
    'rule_from_search_words'                        => '規則引擎無法處理「:string」。依照您的搜尋查詢所建議的規則可能有不同結果。請仔細檢查規則條件。',

    // more new stuff
    'search_modifier_destination_balance_is'        => '目標帳戶餘額正好是「:value」',
    'search_modifier_not_destination_balance_is'    => '目標帳戶餘額不為「:value」',
    'search_modifier_source_balance_is'             => '來源帳戶餘額正好是「:value」',
    'search_modifier_not_source_balance_is'         => '來源帳戶餘額不為「:value」',

    'search_modifier_destination_balance_lte'     => '目標帳戶餘額小於或等於「:value」',
    'search_modifier_not_destination_balance_lte' => '目標帳戶餘額大於「:value」',
    'search_modifier_source_balance_lte'          => '來源帳戶餘額小於或等於「:value」',
    'search_modifier_not_source_balance_lte'      => '來源帳戶餘額大於「:value」',

    'search_modifier_destination_balance_lt'     => '目標帳戶餘額小於「:value」',
    'search_modifier_not_destination_balance_lt' => '目標帳戶餘額不小於「:value」',
    'search_modifier_source_balance_lt'          => '來源帳戶餘額小於「:value」',
    'search_modifier_not_source_balance_lt'      => '來源帳戶餘額不小於「:value」',

    'search_modifier_destination_balance_gte'     => '目標帳戶餘額大於或等於「:value」',
    'search_modifier_not_destination_balance_gte' => '目標帳戶餘額小於「:value」',
    'search_modifier_source_balance_gte'          => '來源帳戶餘額大於或等於「:value」',
    'search_modifier_not_source_balance_gte'      => '來源帳戶餘額小於「:value」',

    'search_modifier_destination_balance_gt'              => '目標帳戶餘額大於「:value」',
    'search_modifier_not_destination_balance_gt'          => '目標帳戶餘額不大於「:value」',
    'search_modifier_source_balance_gt'                   => '來源帳戶餘額大於「:value」',
    'search_modifier_not_source_balance_gt'               => '來源帳戶餘額不大於「:value」',


    // END
    'general_search_error'                                => '搜尋時發生錯誤。詳細資訊請查閱日誌檔。',
    'search_box'                                          => '搜尋',
    'search_box_intro'                                    => '歡迎使用 Firefly III 的搜尋功能。請在下方輸入您的搜尋內容。<a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">請務必參考說明文件</a>，因為搜尋功能相當進階。',
    'search_error'                                        => '搜尋時發生錯誤',
    'search_searching'                                    => '正在搜尋...',
    'search_results'                                      => '搜尋結果',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => '每年',
    'repeat_freq_half-year'                               => '每半年',
    'repeat_freq_quarterly'                               => '每季',
    'repeat_freq_monthly'                                 => '每月',
    'repeat_freq_weekly'                                  => '每週',
    'repeat_freq_daily'                                   => 'daily',
    'daily'                                               => 'daily',
    'weekly'                                              => '每週',
    'quarterly'                                           => '每季',
    'half-year'                                           => '每半年',
    'yearly'                                              => '每年',

    // rules
    'is_not_rule_trigger'                                 => '不符合',
    'cannot_fire_inactive_rules'                          => '您無法執行未啟用的規則。',
    'show_triggers'                                       => '顯示觸發器',
    'show_actions'                                        => '顯示動作',
    'rules'                                               => '規則',
    'rule_name'                                           => '規則名稱',
    'rule_triggers'                                       => '規則觸發於',
    'rule_actions'                                        => '規則將',
    'new_rule'                                            => '新規則',
    'new_rule_group'                                      => '新規則群組',
    'rule_priority_up'                                    => '提高規則優先順序',
    'rule_priority_down'                                  => '降低規則優先順序',
    'make_new_rule_group'                                 => '建立新規則群組',
    'store_new_rule_group'                                => '儲存新規則群組',
    'created_new_rule_group'                              => '新規則群組 ":title" 已儲存！',
    'updated_rule_group'                                  => '已成功更新 ":title" 規則群組。',
    'edit_rule_group'                                     => '編輯 ":title" 規則群組',
    'duplicate_rule'                                      => '複製規則 ":title"',
    'rule_copy_of'                                        => '複製 ":title"',
    'duplicated_rule'                                     => '已將規則 ":title" 複製為 ":newTitle"',
    'delete_rule_group'                                   => '刪除 ":title" 規則群組',
    'deleted_rule_group'                                  => '規則群組 ":title" 已刪除',
    'update_rule_group'                                   => '更新規則群組',
    'no_rules_in_group'                                   => '此群組內沒有規則',
    'move_rule_group_up'                                  => '上移規則群組',
    'move_rule_group_down'                                => '下移規則群組',
    'save_rules_by_moving'                                => '將此規則移至其他規則群組即可儲存：|將這些規則移至其他規則群組即可儲存：',
    'make_new_rule'                                       => '在規則群組 ":title" 中建立新規則',
    'make_new_rule_no_group'                              => '建立新規則',
    'instructions_rule_from_bill'                         => '若要將交易與新週期性付款 ":name" 對應，Firefly III 能建立一則自動匹配交易的規則。請檢查下列設定並儲存規則，之後 Firefly III 即可自動將交易匹配至新的週期性付款。',
    'instructions_rule_from_journal'                      => '依照某一筆交易建立規則。請補足或提交下列表單。',
    'rule_is_strict'                                      => '嚴謹規則',
    'rule_is_not_strict'                                  => '非嚴謹規則',
    'rule_help_stop_processing'                           => '勾選後，若此規則被觸發，則同群組中後續規則將停止執行。',
    'rule_help_strict'                                    => '於嚴謹規則中，所有觸發器均須觸發才能執行動作。於非嚴謹規則中，任一觸發器被觸發即可執行動作。',
    'rule_help_active'                                    => '未啟用的規則不會被執行。',
    'stored_new_rule'                                     => '已以 ":title" 為標題儲存新規則',
    'deleted_rule'                                        => '已刪除標題為 ":title" 的規則',
    'store_new_rule'                                      => '儲存新規則',
    'updated_rule'                                        => '已更新標題為 ":title" 的規則',
    'default_rule_group_name'                             => '預設規則',
    'default_rule_group_description'                      => '所有不屬於特定群組的規則。',
    'trigger'                                             => '觸發器',
    'trigger_value'                                       => '觸發值',
    'stop_processing_other_triggers'                      => '停止處理其他觸發器',
    'add_rule_trigger'                                    => '新增觸發器',
    'action'                                              => '動作',
    'action_value'                                        => '動作值',
    'stop_executing_other_actions'                        => '停止處理其他動作',
    'add_rule_action'                                     => '新增動作',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => '刪除規則 ":title"',
    'update_rule'                                         => '更新規則',
    'test_rule_triggers'                                  => '檢視相符交易',
    'warning_no_matching_transactions'                    => '找不到相符的交易。',
    'warning_no_valid_triggers'                           => '尚未提供有效的觸發器。',
    'apply_rule_selection'                                => '將規則 ":title" 套用至您所選的交易',
    'apply_rule_selection_intro'                          => '規則（如 ":title"）只會在新的或更新後的交易上執行。但您可以要求 Firefly III 將此規則套用至既有的交易。如果您更新了一項規則，並想將其套用至其他交易，請使用此功能。',
    'include_transactions_from_accounts'                  => '包含這些帳戶的交易',
    'include'                                             => '包含？',
    'applied_rule_selection'                              => '{0} 您選擇的交易中，沒有任何被規則 ":title" 變更。|[1] 您選擇的交易中，有 1 筆被規則 ":title" 變更。|[2,*] 您選擇的交易中，有 :count 筆被規則 ":title" 變更。',
    'execute'                                             => '執行',
    'apply_rule_group_selection'                          => '將規則群組 ":title" 套用至您所選的交易',
    'apply_rule_group_selection_intro'                    => '規則群組（如 ":title"）只會在新的或更新後的交易上執行。但您可以要求 Firefly III 套用該群組至已存在的交易。如果您更新了該群組並想套用至其他交易，請使用此功能。',
    'applied_rule_group_selection'                        => '規則群組 ":title" 已套用至您選擇的交易。',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => '當建立一筆交易',
    'rule_trigger_update_journal'                         => '當更新一筆交易',
    'rule_trigger_manual'                                 => '僅在使用者手動執行時',
    'rule_trigger_user_action'                            => '使用者動作為 ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => '來源帳戶名稱以…開頭',
    'rule_trigger_source_account_starts'                  => '來源帳戶名稱以「:trigger_value」開頭',
    'rule_trigger_source_account_ends_choice'             => '來源帳戶名稱以…結尾',
    'rule_trigger_source_account_ends'                    => '來源帳戶名稱以「:trigger_value」結尾',
    'rule_trigger_source_account_is_choice'               => '來源帳戶名稱為…',
    'rule_trigger_source_account_is'                      => '來源帳戶名稱為「:trigger_value」',
    'rule_trigger_source_account_contains_choice'         => '來源帳戶名稱包含…',
    'rule_trigger_source_account_contains'                => '來源帳戶名稱包含「:trigger_value」',
    'rule_trigger_account_id_choice'                      => '來源或目標帳戶 ID 恰好是…',
    'rule_trigger_account_id'                             => '來源或目標帳戶 ID 恰好是 :trigger_value',
    'rule_trigger_source_account_id_choice'               => '來源帳戶 ID 恰好是…',
    'rule_trigger_source_account_id'                      => '來源帳戶 ID 恰好是 :trigger_value',
    'rule_trigger_destination_account_id_choice'          => '目標帳戶 ID 恰好是…',
    'rule_trigger_destination_account_id'                 => '目標帳戶 ID 恰好是 :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => '來源或目標帳戶為 (cash)',
    'rule_trigger_account_is_cash'                        => '來源或目標帳戶為 (cash)',
    'rule_trigger_source_is_cash_choice'                  => '來源帳戶為 (cash)',
    'rule_trigger_source_is_cash'                         => '來源帳戶為 (cash)',
    'rule_trigger_destination_is_cash_choice'             => '目標帳戶為 (cash)',
    'rule_trigger_destination_is_cash'                    => '目標帳戶為 (cash)',
    'rule_trigger_source_account_nr_starts_choice'        => '來源帳戶號碼 / IBAN 以…開頭',
    'rule_trigger_source_account_nr_starts'               => '來源帳戶號碼 / IBAN 以「:trigger_value」開頭',
    'rule_trigger_source_account_nr_ends_choice'          => '來源帳戶號碼 / IBAN 以…結尾',
    'rule_trigger_source_account_nr_ends'                 => '來源帳戶號碼 / IBAN 以「:trigger_value」結尾',
    'rule_trigger_source_account_nr_is_choice'            => '來源帳戶號碼 / IBAN 為…',
    'rule_trigger_source_account_nr_is'                   => '來源帳戶號碼 / IBAN 為「:trigger_value」',
    'rule_trigger_source_account_nr_contains_choice'      => '來源帳戶號碼 / IBAN 包含…',
    'rule_trigger_source_account_nr_contains'             => '來源帳戶號碼 / IBAN 包含「:trigger_value」',
    'rule_trigger_destination_account_starts_choice'      => '目標帳戶名稱以…開頭',
    'rule_trigger_destination_account_starts'             => '目標帳戶名稱以「:trigger_value」開頭',
    'rule_trigger_destination_account_ends_choice'        => '目標帳戶名稱以…結尾',
    'rule_trigger_destination_account_ends'               => '目標帳戶名稱以「:trigger_value」結尾',
    'rule_trigger_destination_account_is_choice'          => '目標帳戶名稱為…',
    'rule_trigger_destination_account_is'                 => '目標帳戶名稱為「:trigger_value」',
    'rule_trigger_destination_account_contains_choice'    => '目標帳戶名稱包含…',
    'rule_trigger_destination_account_contains'           => '目標帳戶名稱包含「:trigger_value」',
    'rule_trigger_destination_account_nr_starts_choice'   => '目標帳戶號碼 / IBAN 以…開頭',
    'rule_trigger_destination_account_nr_starts'          => '目標帳戶號碼 / IBAN 以「:trigger_value」開頭',
    'rule_trigger_destination_account_nr_ends_choice'     => '目標帳戶號碼 / IBAN 以…結尾',
    'rule_trigger_destination_account_nr_ends'            => '目標帳戶號碼 / IBAN 以「:trigger_value」結尾',
    'rule_trigger_destination_account_nr_is_choice'       => '目標帳戶號碼 / IBAN 為…',
    'rule_trigger_destination_account_nr_is'              => '目標帳戶號碼 / IBAN 為「:trigger_value」',
    'rule_trigger_destination_account_nr_contains_choice' => '目標帳戶號碼 / IBAN 包含…',
    'rule_trigger_destination_account_nr_contains'        => '目標帳戶號碼 / IBAN 包含「:trigger_value」',
    'rule_trigger_transaction_type_choice'                => '轉帳類型為…',
    'rule_trigger_transaction_type'                       => '轉帳類型為「:trigger_value」',
    'rule_trigger_category_is_choice'                     => '分類為…',
    'rule_trigger_category_is'                            => '分類為「:trigger_value」',
    'rule_trigger_amount_less_choice'                     => '金額小於或等於…',
    'rule_trigger_amount_less'                            => '金額小於或等於 :trigger_value',
    'rule_trigger_amount_is_choice'                       => '金額為…',
    'rule_trigger_amount_is'                              => '金額為 :trigger_value',
    'rule_trigger_amount_more_choice'                     => '金額大於或等於…',
    'rule_trigger_amount_more'                            => '金額大於或等於 :trigger_value',
    'rule_trigger_description_starts_choice'              => '描述以…開頭',
    'rule_trigger_description_starts'                     => '描述以「:trigger_value」開頭',
    'rule_trigger_description_ends_choice'                => '描述以…結尾',
    'rule_trigger_description_ends'                       => '描述以「:trigger_value」結尾',
    'rule_trigger_description_contains_choice'            => '描述包含…',
    'rule_trigger_description_contains'                   => '描述包含「:trigger_value」',
    'rule_trigger_description_is_choice'                  => '描述為…',
    'rule_trigger_description_is'                         => '描述為「:trigger_value」',
    'rule_trigger_date_on_choice'                         => '交易日期為…',
    'rule_trigger_date_on'                                => '交易日期為「:trigger_value」',
    'rule_trigger_date_before_choice'                     => '交易日期早於…',
    'rule_trigger_date_before'                            => '交易日期早於「:trigger_value」',
    'rule_trigger_date_after_choice'                      => '交易日期晚於…',
    'rule_trigger_date_after'                             => '交易日期晚於「:trigger_value」',
    'rule_trigger_created_at_on_choice'                   => '交易建立於…',
    'rule_trigger_created_at_on'                          => '交易建立於「:trigger_value」',
    'rule_trigger_updated_at_on_choice'                   => '交易上次編輯於…',
    'rule_trigger_updated_at_on'                          => '交易上次編輯於「:trigger_value」',
    'rule_trigger_budget_is_choice'                       => '預算為…',
    'rule_trigger_budget_is'                              => '預算為「:trigger_value」',
    'rule_trigger_tag_is_choice'                          => '任何標籤為…',
    'rule_trigger_tag_is'                                 => '任何標籤為「:trigger_value」',
    'rule_trigger_tag_contains_choice'                    => '任何標籤包含…',
    'rule_trigger_tag_contains'                           => '任何標籤包含「:trigger_value」',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => '任何標籤以…結尾',
    'rule_trigger_tag_ends'                               => '任何標籤以「:trigger_value」結尾',
    'rule_trigger_tag_starts_choice'                      => '任何標籤以…開頭',
    'rule_trigger_tag_starts'                             => '任何標籤以「:trigger_value」開頭',
    'rule_trigger_currency_is_choice'                     => '轉帳貨幣為…',
    'rule_trigger_currency_is'                            => '轉帳貨幣為「:trigger_value」',
    'rule_trigger_foreign_currency_is_choice'             => '交易外幣為…',
    'rule_trigger_foreign_currency_is'                    => '交易外幣為「:trigger_value」',
    'rule_trigger_has_attachments_choice'                 => '有任何附件',
    'rule_trigger_has_attachments'                        => '有任何附件',
    'rule_trigger_has_no_category_choice'                 => '無分類',
    'rule_trigger_has_no_category'                        => '交易沒有分類',
    'rule_trigger_has_any_category_choice'                => '交易有 (任何) 分類',
    'rule_trigger_has_any_category'                       => '交易有 (任何) 分類',
    'rule_trigger_has_no_budget_choice'                   => '沒有預算',
    'rule_trigger_has_no_budget'                          => '交易沒有預算',
    'rule_trigger_has_any_budget_choice'                  => '有 (任何) 預算',
    'rule_trigger_has_any_budget'                         => '交易有 (任何) 預算',
    'rule_trigger_has_no_bill_choice'                     => '沒有週期性付款',
    'rule_trigger_has_no_bill'                            => '交易沒有週期性付款',
    'rule_trigger_has_any_bill_choice'                    => '有 (任何) 週期性付款',
    'rule_trigger_has_any_bill'                           => '交易有 (任何) 週期性付款',
    'rule_trigger_has_no_tag_choice'                      => '沒有標籤',
    'rule_trigger_has_no_tag'                             => '交易沒有標籤',
    'rule_trigger_has_any_tag_choice'                     => '有 (任何) 標籤',
    'rule_trigger_has_any_tag'                            => '交易有 (任何) 標籤',
    'rule_trigger_any_notes_choice'                       => '有 (任何) 備註',
    'rule_trigger_any_notes'                              => '交易有 (任何) 備註',
    'rule_trigger_no_notes_choice'                        => '沒有備註',
    'rule_trigger_no_notes'                               => '交易沒有備註',
    'rule_trigger_notes_is_choice'                        => '備註為…',
    'rule_trigger_notes_is'                               => '備註為「:trigger_value」',
    'rule_trigger_notes_contains_choice'                  => '備註包含…',
    'rule_trigger_notes_contains'                         => '備註包含「:trigger_value」',
    'rule_trigger_notes_starts_choice'                    => '備註以…開頭',
    'rule_trigger_notes_starts'                           => '備註以「:trigger_value」開頭',
    'rule_trigger_notes_ends_choice'                      => '備註以…結尾',
    'rule_trigger_notes_ends'                             => '備註以「:trigger_value」結尾',
    'rule_trigger_bill_is_choice'                         => '週期性付款為…',
    'rule_trigger_bill_is'                                => '週期性付款為「:trigger_value」',
    'rule_trigger_external_id_is_choice'                  => '外部 ID 為…',
    'rule_trigger_external_id_is'                         => '外部 ID 為「:trigger_value」',
    'rule_trigger_internal_reference_is_choice'           => '內部參考為…',
    'rule_trigger_internal_reference_is'                  => '內部參考為「:trigger_value」',
    'rule_trigger_journal_id_choice'                      => '交易日誌 ID 為…',
    'rule_trigger_journal_id'                             => '交易日誌 ID 為「:trigger_value」',
    'rule_trigger_any_external_url'                       => '交易有 (任何) 外部 URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => '交易有 (任何) 外部 ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => '交易沒有外部 URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => '交易沒有外部 ID',
    'rule_trigger_id_choice'                              => '交易 ID 為…',
    'rule_trigger_id'                                     => '交易 ID 為「:trigger_value」',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT 為…',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT 為「:trigger_value」',

    // new values:
    'rule_trigger_user_action_choice'                     => '使用者動作為「:trigger_value」',
    'rule_trigger_tag_is_not_choice'                      => '沒有標籤…',
    'rule_trigger_tag_is_not'                             => '沒有標籤「:trigger_value」',
    'rule_trigger_account_is_choice'                      => '來源或目標帳戶恰好為…',
    'rule_trigger_account_is'                             => '來源或目標帳戶恰好為「:trigger_value」',
    'rule_trigger_account_contains_choice'                => '來源或目標帳戶包含…',
    'rule_trigger_account_contains'                       => '來源或目標帳戶包含「:trigger_value」',
    'rule_trigger_account_ends_choice'                    => '來源或目標帳戶以…結尾',
    'rule_trigger_account_ends'                           => '來源或目標帳戶以「:trigger_value」結尾',
    'rule_trigger_account_starts_choice'                  => '來源或目標帳戶以…開頭',
    'rule_trigger_account_starts'                         => '來源或目標帳戶以「:trigger_value」開頭',
    'rule_trigger_account_nr_is_choice'                   => '來源或目標帳戶號碼 / IBAN 為…',
    'rule_trigger_account_nr_is'                          => '來源或目標帳戶號碼 / IBAN 為「:trigger_value」',
    'rule_trigger_account_nr_contains_choice'             => '來源或目標帳戶號碼 / IBAN 包含…',
    'rule_trigger_account_nr_contains'                    => '來源或目標帳戶號碼 / IBAN 包含「:trigger_value」',
    'rule_trigger_account_nr_ends_choice'                 => '來源或目標帳戶號碼 / IBAN 以…結尾',
    'rule_trigger_account_nr_ends'                        => '來源或目標帳戶號碼 / IBAN 以「:trigger_value」結尾',
    'rule_trigger_account_nr_starts_choice'               => '來源或目標帳戶號碼 / IBAN 以…開頭',
    'rule_trigger_account_nr_starts'                      => '來源或目標帳戶號碼 / IBAN 以「:trigger_value」開頭',
    'rule_trigger_category_contains_choice'               => '分類包含…',
    'rule_trigger_category_contains'                      => '分類包含「:trigger_value」',
    'rule_trigger_category_ends_choice'                   => '分類以…結尾',
    'rule_trigger_category_ends'                          => '分類以「:trigger_value」結尾',
    'rule_trigger_category_starts_choice'                 => '分類以…開頭',
    'rule_trigger_category_starts'                        => '分類以「:trigger_value」開頭',
    'rule_trigger_budget_contains_choice'                 => '預算包含…',
    'rule_trigger_budget_contains'                        => '預算包含「:trigger_value」',
    'rule_trigger_budget_ends_choice'                     => '預算以…結尾',
    'rule_trigger_budget_ends'                            => '預算以「:trigger_value」結尾',
    'rule_trigger_budget_starts_choice'                   => '預算以…開頭',
    'rule_trigger_budget_starts'                          => '預算以「:trigger_value」開頭',
    'rule_trigger_bill_contains_choice'                   => '週期性付款包含…',
    'rule_trigger_bill_contains'                          => '週期性付款包含「:trigger_value」',
    'rule_trigger_bill_ends_choice'                       => '週期性付款以…結尾',
    'rule_trigger_bill_ends'                              => '週期性付款以「:trigger_value」結尾',
    'rule_trigger_bill_starts_choice'                     => '週期性付款以…開頭',
    'rule_trigger_bill_starts'                            => '週期性付款以「:trigger_value」開頭',
    'rule_trigger_external_id_contains_choice'            => '外部 ID 包含…',
    'rule_trigger_external_id_contains'                   => '外部 ID 包含「:trigger_value」',
    'rule_trigger_external_id_ends_choice'                => '外部 ID 以…結尾',
    'rule_trigger_external_id_ends'                       => '外部 ID 以「:trigger_value」結尾',
    'rule_trigger_external_id_starts_choice'              => '外部 ID 以…開頭',
    'rule_trigger_external_id_starts'                     => '外部 ID 以「:trigger_value」開頭',
    'rule_trigger_internal_reference_contains_choice'     => '內部參考包含…',
    'rule_trigger_internal_reference_contains'            => '內部參考包含「:trigger_value」',
    'rule_trigger_internal_reference_ends_choice'         => '內部參考以…結尾',
    'rule_trigger_internal_reference_ends'                => '內部參考以「:trigger_value」結尾',
    'rule_trigger_internal_reference_starts_choice'       => '內部參考以…開頭',
    'rule_trigger_internal_reference_starts'              => '內部參考以「:trigger_value」開頭',
    'rule_trigger_external_url_is_choice'                 => '外部 URL 為…',
    'rule_trigger_external_url_is'                        => '外部 URL 為「:trigger_value」',
    'rule_trigger_external_url_contains_choice'           => '外部 URL 包含…',
    'rule_trigger_external_url_contains'                  => '外部 URL 包含「:trigger_value」',
    'rule_trigger_external_url_ends_choice'               => '外部 URL 以…結尾',
    'rule_trigger_external_url_ends'                      => '外部 URL 以「:trigger_value」結尾',
    'rule_trigger_external_url_starts_choice'             => '外部 URL 以…開頭',
    'rule_trigger_external_url_starts'                    => '外部 URL 以「:trigger_value」開頭',
    'rule_trigger_has_no_attachments_choice'              => '沒有附件',
    'rule_trigger_has_no_attachments'                     => '交易沒有附件',
    'rule_trigger_recurrence_id_choice'                   => '重複交易 ID 為…',
    'rule_trigger_recurrence_id'                          => '重複交易 ID 為「:trigger_value」',
    'rule_trigger_interest_date_on_choice'                => '計息日為…',
    'rule_trigger_interest_date_on'                       => '計息日為「:trigger_value」',
    'rule_trigger_interest_date_before_choice'            => '計息日早於…',
    'rule_trigger_interest_date_before'                   => '計息日早於「:trigger_value」',
    'rule_trigger_interest_date_after_choice'             => '計息日晚於…',
    'rule_trigger_interest_date_after'                    => '計息日晚於「:trigger_value」',
    'rule_trigger_book_date_on_choice'                    => '入帳日期為…',
    'rule_trigger_book_date_on'                           => '入帳日期為「:trigger_value」',
    'rule_trigger_book_date_before_choice'                => '入帳日期早於…',
    'rule_trigger_book_date_before'                       => '入帳日期早於「:trigger_value」',
    'rule_trigger_book_date_after_choice'                 => '入帳日期晚於…',
    'rule_trigger_book_date_after'                        => '入帳日期晚於「:trigger_value」',
    'rule_trigger_process_date_on_choice'                 => '處理日期為…',
    'rule_trigger_process_date_on'                        => '處理日期為「:trigger_value」',
    'rule_trigger_process_date_before_choice'             => '處理日期早於…',
    'rule_trigger_process_date_before'                    => '處理日期早於「:trigger_value」',
    'rule_trigger_process_date_after_choice'              => '處理日期晚於…',
    'rule_trigger_process_date_after'                     => '處理日期晚於「:trigger_value」',
    'rule_trigger_due_date_on_choice'                     => '到期日為…',
    'rule_trigger_due_date_on'                            => '到期日為「:trigger_value」',
    'rule_trigger_due_date_before_choice'                 => '到期日早於…',
    'rule_trigger_due_date_before'                        => '到期日早於「:trigger_value」',
    'rule_trigger_due_date_after_choice'                  => '到期日晚於…',
    'rule_trigger_due_date_after'                         => '到期日晚於「:trigger_value」',
    'rule_trigger_payment_date_on_choice'                 => '支付日期為…',
    'rule_trigger_payment_date_on'                        => '支付日期為「:trigger_value」',
    'rule_trigger_payment_date_before_choice'             => '支付日期早於…',
    'rule_trigger_payment_date_before'                    => '支付日期早於「:trigger_value」',
    'rule_trigger_payment_date_after_choice'              => '支付日期晚於…',
    'rule_trigger_payment_date_after'                     => '支付日期晚於「:trigger_value」',
    'rule_trigger_invoice_date_on_choice'                 => '發票日期為…',
    'rule_trigger_invoice_date_on'                        => '發票日期為「:trigger_value」',
    'rule_trigger_invoice_date_before_choice'             => '發票日期早於…',
    'rule_trigger_invoice_date_before'                    => '發票日期早於「:trigger_value」',
    'rule_trigger_invoice_date_after_choice'              => '發票日期晚於…',
    'rule_trigger_invoice_date_after'                     => '發票日期晚於「:trigger_value」',
    'rule_trigger_created_at_before_choice'               => '交易建立時間早於…',
    'rule_trigger_created_at_before'                      => '交易建立時間早於「:trigger_value」',
    'rule_trigger_created_at_after_choice'                => '交易建立時間晚於…',
    'rule_trigger_created_at_after'                       => '交易建立時間晚於「:trigger_value」',
    'rule_trigger_updated_at_before_choice'               => '交易上次更新時間早於…',
    'rule_trigger_updated_at_before'                      => '交易上次更新時間早於「:trigger_value」',
    'rule_trigger_updated_at_after_choice'                => '交易上次更新時間晚於…',
    'rule_trigger_updated_at_after'                       => '交易上次更新時間晚於「:trigger_value」',
    'rule_trigger_foreign_amount_is_choice'               => '外幣金額恰好為…',
    'rule_trigger_foreign_amount_is'                      => '外幣金額恰好為「:trigger_value」',
    'rule_trigger_foreign_amount_less_choice'             => '外幣金額小於…',
    'rule_trigger_foreign_amount_less'                    => '外幣金額小於「:trigger_value」',
    'rule_trigger_foreign_amount_more_choice'             => '外幣金額大於…',
    'rule_trigger_foreign_amount_more'                    => '外幣金額大於「:trigger_value」',
    'rule_trigger_attachment_name_is_choice'              => '任何附件名稱為…',
    'rule_trigger_attachment_name_is'                     => '任何附件名稱為「:trigger_value」',
    'rule_trigger_attachment_name_contains_choice'        => '任何附件名稱包含…',
    'rule_trigger_attachment_name_contains'               => '任何附件名稱包含「:trigger_value」',
    'rule_trigger_attachment_name_starts_choice'          => '任何附件名稱以…開頭',
    'rule_trigger_attachment_name_starts'                 => '任何附件名稱以「:trigger_value」開頭',
    'rule_trigger_attachment_name_ends_choice'            => '任何附件名稱以…結尾',
    'rule_trigger_attachment_name_ends'                   => '任何附件名稱以「:trigger_value」結尾',
    'rule_trigger_attachment_notes_are_choice'            => '任何附件備註為…',
    'rule_trigger_attachment_notes_are'                   => '任何附件備註為「:trigger_value」',
    'rule_trigger_attachment_notes_contains_choice'       => '任何附件備註包含…',
    'rule_trigger_attachment_notes_contains'              => '任何附件備註包含「:trigger_value」',
    'rule_trigger_attachment_notes_starts_choice'         => '任何附件備註以…開頭',
    'rule_trigger_attachment_notes_starts'                => '任何附件備註以「:trigger_value」開頭',
    'rule_trigger_attachment_notes_ends_choice'           => '任何附件備註以…結尾',
    'rule_trigger_attachment_notes_ends'                  => '任何附件備註以「:trigger_value」結尾',
    'rule_trigger_reconciled_choice'                      => '交易已對帳',
    'rule_trigger_reconciled'                             => '交易已對帳',
    'rule_trigger_exists_choice'                          => '符合 (任何) 交易',
    'rule_trigger_exists'                                 => '符合 (任何) 交易',

    // more values for new types:
    'rule_trigger_not_account_id'                         => '帳戶 ID 不為「:trigger_value」',
    'rule_trigger_not_source_account_id'                  => '來源帳戶 ID 不為「:trigger_value」',
    'rule_trigger_not_destination_account_id'             => '目標帳戶 ID 不為「:trigger_value」',
    'rule_trigger_not_transaction_type'                   => '交易類型不為「:trigger_value」',
    'rule_trigger_not_tag_is'                             => '標籤不為「:trigger_value」',
    'rule_trigger_not_tag_is_not'                         => '標籤為「:trigger_value」',
    'rule_trigger_not_description_is'                     => '描述不為「:trigger_value」',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => '描述不以「:trigger_value」結尾',
    'rule_trigger_not_description_starts'                 => '描述不以「:trigger_value」開頭',
    'rule_trigger_not_notes_is'                           => '備註不為「:trigger_value」',
    'rule_trigger_not_notes_contains'                     => '備註不包含「:trigger_value」',
    'rule_trigger_not_notes_ends'                         => '備註不以「:trigger_value」結尾',
    'rule_trigger_not_notes_starts'                       => '備註不以「:trigger_value」開頭',
    'rule_trigger_not_source_account_is'                  => '來源帳戶不為「:trigger_value」',
    'rule_trigger_not_source_account_contains'            => '來源帳戶不包含「:trigger_value」',
    'rule_trigger_not_source_account_ends'                => '來源帳戶不以「:trigger_value」結尾',
    'rule_trigger_not_source_account_starts'              => '來源帳戶不以「:trigger_value」開頭',
    'rule_trigger_not_source_account_nr_is'               => '來源帳戶號碼 / IBAN 不為「:trigger_value」',
    'rule_trigger_not_source_account_nr_contains'         => '來源帳戶號碼 / IBAN 不包含「:trigger_value」',
    'rule_trigger_not_source_account_nr_ends'             => '來源帳戶號碼 / IBAN 不以「:trigger_value」結尾',
    'rule_trigger_not_source_account_nr_starts'           => '來源帳戶號碼 / IBAN 不以「:trigger_value」開頭',
    'rule_trigger_not_destination_account_is'             => '目標帳戶不為「:trigger_value」',
    'rule_trigger_not_destination_account_contains'       => '目標帳戶不包含「:trigger_value」',
    'rule_trigger_not_destination_account_ends'           => '目標帳戶不以「:trigger_value」結尾',
    'rule_trigger_not_destination_account_starts'         => '目標帳戶不以「:trigger_value」開頭',
    'rule_trigger_not_destination_account_nr_is'          => '目標帳戶號碼 / IBAN 不為「:trigger_value」',
    'rule_trigger_not_destination_account_nr_contains'    => '目標帳戶號碼 / IBAN 不包含「:trigger_value」',
    'rule_trigger_not_destination_account_nr_ends'        => '目標帳戶號碼 / IBAN 不以「:trigger_value」結尾',
    'rule_trigger_not_destination_account_nr_starts'      => '目標帳戶號碼 / IBAN 不以「:trigger_value」開頭',
    'rule_trigger_not_account_is'                         => '來源或目標帳戶皆非「:trigger_value」',
    'rule_trigger_not_account_contains'                   => '來源或目標帳戶不包含「:trigger_value」',
    'rule_trigger_not_account_ends'                       => '來源或目標帳戶不以「:trigger_value」結尾',
    'rule_trigger_not_account_starts'                     => '來源或目標帳戶不以「:trigger_value」開頭',
    'rule_trigger_not_account_nr_is'                      => '來源或目標帳戶號碼 / IBAN 不為「:trigger_value」',
    'rule_trigger_not_account_nr_contains'                => '來源或目標帳戶號碼 / IBAN 不包含「:trigger_value」',
    'rule_trigger_not_account_nr_ends'                    => '來源或目標帳戶號碼 / IBAN 不以「:trigger_value」結尾',
    'rule_trigger_not_account_nr_starts'                  => '來源或目標帳戶號碼 / IBAN 不以「:trigger_value」開頭',
    'rule_trigger_not_category_is'                        => '分類不為「:trigger_value」',
    'rule_trigger_not_category_contains'                  => '分類不包含「:trigger_value」',
    'rule_trigger_not_category_ends'                      => '分類不以「:trigger_value」結尾',
    'rule_trigger_not_category_starts'                    => '分類不以「:trigger_value」開頭',
    'rule_trigger_not_budget_is'                          => '預算不為「:trigger_value」',
    'rule_trigger_not_budget_contains'                    => '預算不包含「:trigger_value」',
    'rule_trigger_not_budget_ends'                        => '預算不以「:trigger_value」結尾',
    'rule_trigger_not_budget_starts'                      => '預算不以「:trigger_value」開頭',
    'rule_trigger_not_bill_is'                            => '週期性付款不為「:trigger_value」',
    'rule_trigger_not_bill_contains'                      => '週期性付款不包含「:trigger_value」',
    'rule_trigger_not_bill_ends'                          => '週期性付款不以「:trigger_value」結尾',
    'rule_trigger_not_bill_starts'                        => '週期性付款不以「:trigger_value」開頭',
    'rule_trigger_not_external_id_is'                     => '外部 ID 不為「:trigger_value」',
    'rule_trigger_not_external_id_contains'               => '外部 ID 不包含「:trigger_value」',
    'rule_trigger_not_external_id_ends'                   => '外部 ID 不以「:trigger_value」結尾',
    'rule_trigger_not_external_id_starts'                 => '外部 ID 不以「:trigger_value」開頭',
    'rule_trigger_not_internal_reference_is'              => '內部參考不為「:trigger_value」',
    'rule_trigger_not_internal_reference_contains'        => '內部參考不包含「:trigger_value」',
    'rule_trigger_not_internal_reference_ends'            => '內部參考不以「:trigger_value」結尾',
    'rule_trigger_not_internal_reference_starts'          => '內部參考不以「:trigger_value」開頭',
    'rule_trigger_not_external_url_is'                    => '外部 URL 不為「:trigger_value」',
    'rule_trigger_not_external_url_contains'              => '外部 URL 不包含「:trigger_value」',
    'rule_trigger_not_external_url_ends'                  => '外部 URL 不以「:trigger_value」結尾',
    'rule_trigger_not_external_url_starts'                => '外部 URL 不以「:trigger_value」開頭',
    'rule_trigger_not_currency_is'                        => '貨幣不為「:trigger_value」',
    'rule_trigger_not_foreign_currency_is'                => '外幣不為「:trigger_value」',
    'rule_trigger_not_id'                                 => '交易 ID 不為「:trigger_value」',
    'rule_trigger_not_journal_id'                         => '交易日誌 ID 不為「:trigger_value」',
    'rule_trigger_not_recurrence_id'                      => '重複交易 ID 不為「:trigger_value」',
    'rule_trigger_not_date_on'                            => '日期不為「:trigger_value」',
    'rule_trigger_not_date_before'                        => '日期不早於「:trigger_value」',
    'rule_trigger_not_date_after'                         => '日期不晚於「:trigger_value」',
    'rule_trigger_not_interest_date_on'                   => '計息日不為「:trigger_value」',
    'rule_trigger_not_interest_date_before'               => '計息日不早於「:trigger_value」',
    'rule_trigger_not_interest_date_after'                => '計息日不晚於「:trigger_value」',
    'rule_trigger_not_book_date_on'                       => '入帳日期不為「:trigger_value」',
    'rule_trigger_not_book_date_before'                   => '入帳日期不早於「:trigger_value」',
    'rule_trigger_not_book_date_after'                    => '入帳日期不晚於「:trigger_value」',
    'rule_trigger_not_process_date_on'                    => '處理日期不為「:trigger_value」',
    'rule_trigger_not_process_date_before'                => '處理日期不早於「:trigger_value」',
    'rule_trigger_not_process_date_after'                 => '處理日期不晚於「:trigger_value」',
    'rule_trigger_not_due_date_on'                        => '到期日不為「:trigger_value」',
    'rule_trigger_not_due_date_before'                    => '到期日不早於「:trigger_value」',
    'rule_trigger_not_due_date_after'                     => '到期日不晚於「:trigger_value」',
    'rule_trigger_not_payment_date_on'                    => '支付日期不為「:trigger_value」',
    'rule_trigger_not_payment_date_before'                => '支付日期不早於「:trigger_value」',
    'rule_trigger_not_payment_date_after'                 => '支付日期不晚於「:trigger_value」',
    'rule_trigger_not_invoice_date_on'                    => '發票日期不為「:trigger_value」',
    'rule_trigger_not_invoice_date_before'                => '發票日期不早於「:trigger_value」',
    'rule_trigger_not_invoice_date_after'                 => '發票日期不晚於「:trigger_value」',
    'rule_trigger_not_created_at_on'                      => '交易並非建立於「:trigger_value」',
    'rule_trigger_not_created_at_before'                  => '交易並非建立於「:trigger_value」之前',
    'rule_trigger_not_created_at_after'                   => '交易並非建立於「:trigger_value」之後',
    'rule_trigger_not_updated_at_on'                      => '交易並非更新於「:trigger_value」',
    'rule_trigger_not_updated_at_before'                  => '交易並非更新於「:trigger_value」之前',
    'rule_trigger_not_updated_at_after'                   => '交易並非更新於「:trigger_value」之後',
    'rule_trigger_not_amount_is'                          => '交易金額不為「:trigger_value」',
    'rule_trigger_not_amount_less'                        => '交易金額大於「:trigger_value」',
    'rule_trigger_not_amount_more'                        => '交易金額小於「:trigger_value」',
    'rule_trigger_not_foreign_amount_is'                  => '外幣金額不為「:trigger_value」',
    'rule_trigger_not_foreign_amount_less'                => '外幣金額大於「:trigger_value」',
    'rule_trigger_not_foreign_amount_more'                => '外幣金額小於「:trigger_value」',
    'rule_trigger_not_attachment_name_is'                 => '沒有附件名稱為「:trigger_value」',
    'rule_trigger_not_attachment_name_contains'           => '沒有附件名稱包含「:trigger_value」',
    'rule_trigger_not_attachment_name_starts'             => '沒有附件名稱以「:trigger_value」開頭',
    'rule_trigger_not_attachment_name_ends'               => '沒有附件名稱以「:trigger_value」結尾',
    'rule_trigger_not_attachment_notes_are'               => '沒有附件備註為「:trigger_value」',
    'rule_trigger_not_attachment_notes_contains'          => '沒有附件備註包含「:trigger_value」',
    'rule_trigger_not_attachment_notes_starts'            => '沒有附件備註以「:trigger_value」開頭',
    'rule_trigger_not_attachment_notes_ends'              => '沒有附件備註以「:trigger_value」結尾',
    'rule_trigger_not_reconciled'                         => '交易未對帳',
    'rule_trigger_not_exists'                             => '交易不存在',
    'rule_trigger_not_has_attachments'                    => '交易沒有附件',
    'rule_trigger_not_has_any_category'                   => '交易沒有分類',
    'rule_trigger_not_has_any_budget'                     => '交易沒有預算',
    'rule_trigger_not_has_any_bill'                       => '交易沒有週期性付款',
    'rule_trigger_not_has_any_tag'                        => '交易沒有標籤',
    'rule_trigger_not_any_notes'                          => '交易沒有備註',
    'rule_trigger_not_any_external_url'                   => '交易沒有外部 URL',
    'rule_trigger_not_has_no_attachments'                 => '交易有（任何）附件',
    'rule_trigger_not_has_no_category'                    => '交易有（任何）分類',
    'rule_trigger_not_has_no_budget'                      => '交易有（任何）預算',
    'rule_trigger_not_has_no_bill'                        => '交易有（任何）週期性付款',
    'rule_trigger_not_has_no_tag'                         => '交易有（任何）標籤',
    'rule_trigger_not_no_notes'                           => '交易有任何備註',
    'rule_trigger_not_no_external_url'                    => '交易有外部 URL',
    'rule_trigger_not_source_is_cash'                     => '來源帳戶不是現金帳戶',
    'rule_trigger_not_destination_is_cash'                => '目標帳戶不是現金帳戶',
    'rule_trigger_not_account_is_cash'                    => '來源或目標帳戶都不是現金帳戶',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => '目標帳戶餘額大於…',
    'rule_trigger_destination_balance_gte_choice'         => '目標帳戶餘額大於或等於…',
    'rule_trigger_destination_balance_is_choice'          => '目標帳戶餘額恰好為…',
    'rule_trigger_destination_balance_lt_choice'          => '目標帳戶餘額小於…',
    'rule_trigger_destination_balance_lte_choice'         => '目標帳戶餘額小於或等於…',

    'rule_trigger_source_balance_gt_choice'  => '來源帳戶餘額大於…',
    'rule_trigger_source_balance_gte_choice' => '來源帳戶餘額大於或等於…',
    'rule_trigger_source_balance_is_choice'  => '來源帳戶餘額恰好為…',
    'rule_trigger_source_balance_lt_choice'  => '來源帳戶餘額小於…',
    'rule_trigger_source_balance_lte_choice' => '來源帳戶餘額小於或等於…',

    'rule_trigger_destination_balance_gt'  => '目標帳戶餘額大於 :trigger_value',
    'rule_trigger_destination_balance_gte' => '目標帳戶餘額大於或等於 :trigger_value',
    'rule_trigger_destination_balance_is'  => '目標帳戶餘額恰好為 :trigger_value',
    'rule_trigger_destination_balance_lt'  => '目標帳戶餘額小於 :trigger_value',
    'rule_trigger_destination_balance_lte' => '目標帳戶餘額小於或等於 :trigger_value',

    'rule_trigger_source_balance_gt'           => '來源帳戶餘額大於 :trigger_value',
    'rule_trigger_source_balance_gte'          => '來源帳戶餘額大於或等於 :trigger_value',
    'rule_trigger_source_balance_is'           => '來源帳戶餘額恰好為 :trigger_value',
    'rule_trigger_source_balance_lt'           => '來源帳戶餘額小於 :trigger_value',
    'rule_trigger_source_balance_lte'          => '來源帳戶餘額小於或等於 :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => '目標帳戶餘額不大於 :trigger_value',
    'rule_trigger_not_destination_balance_gte' => '目標帳戶餘額小於 :trigger_value',
    'rule_trigger_not_destination_balance_is'  => '目標帳戶餘額不為 :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => '目標帳戶餘額不小於 :trigger_value',
    'rule_trigger_not_destination_balance_lte' => '目標帳戶餘額大於 :trigger_value',

    'rule_trigger_not_source_balance_gt'         => '來源帳戶餘額不大於 :trigger_value',
    'rule_trigger_not_source_balance_gte'        => '來源帳戶餘額小於 :trigger_value',
    'rule_trigger_not_source_balance_is'         => '來源帳戶餘額不為 :trigger_value',
    'rule_trigger_not_source_balance_lt'         => '來源帳戶餘額不小於 :trigger_value',
    'rule_trigger_not_source_balance_lte'        => '來源帳戶餘額大於 :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => '刪除交易（！）',
    'rule_action_delete_transaction'             => '刪除交易（！）',
    'rule_action_set_category'                   => '將分類設為「:action_value」',
    'rule_action_clear_category'                 => '清除分類',
    'rule_action_set_budget'                     => '將預算設為「:action_value」',
    'rule_action_clear_budget'                   => '清除預算',
    'rule_action_add_tag'                        => '新增標籤「:action_value」',
    'rule_action_remove_tag'                     => '移除標籤「:action_value」',
    'rule_action_remove_all_tags'                => '移除所有標籤',
    'rule_action_set_description'                => '將描述設為「:action_value」',
    'rule_action_append_description'             => '於描述後加上「:action_value」',
    'rule_action_prepend_description'            => '於描述前加上「:action_value」',
    'rule_action_set_category_choice'            => '將分類設為…',
    'rule_action_clear_category_choice'          => '清除任何分類',
    'rule_action_set_budget_choice'              => '將預算設為…',
    'rule_action_clear_budget_choice'            => '清除任何預算',
    'rule_action_add_tag_choice'                 => '新增標籤…',
    'rule_action_remove_tag_choice'              => '移除標籤…',
    'rule_action_remove_all_tags_choice'         => '移除所有標籤',
    'rule_action_set_description_choice'         => '將描述設為…',
    'rule_action_update_piggy_choice'            => '在小豬撲滿中新增 / 移除交易金額…',
    'rule_action_update_piggy'                   => '在小豬撲滿「:action_value」中新增 / 移除交易金額',
    'rule_action_append_description_choice'      => '在描述後方加上…',
    'rule_action_prepend_description_choice'     => '在描述前方加上…',
    'rule_action_set_source_account_choice'      => '將來源帳戶設為…',
    'rule_action_set_source_account'             => '將來源帳戶設為 :action_value',
    'rule_action_set_destination_account_choice' => '將目標帳戶設為…',
    'rule_action_set_destination_account'        => '將目標帳戶設為 :action_value',
    'rule_action_append_notes_choice'            => '在備註後方加上…',
    'rule_action_append_notes'                   => '在備註後方加上「:action_value」',
    'rule_action_prepend_notes_choice'           => '在備註前方加上…',
    'rule_action_prepend_notes'                  => '在備註前方加上「:action_value」',
    'rule_action_clear_notes_choice'             => '移除任何備註',
    'rule_action_clear_notes'                    => '移除任何備註',
    'rule_action_set_notes_choice'               => '將備註設為…',
    'rule_action_link_to_bill_choice'            => '連結至週期性付款…',
    'rule_action_link_to_bill'                   => '連結至週期性付款「:action_value」',
    'rule_action_switch_accounts_choice'         => '切換來源與目標帳戶（僅轉帳適用）',
    'rule_action_switch_accounts'                => '切換來源與目標帳戶',
    'rule_action_set_notes'                      => '將備註設為「:action_value」',
    'rule_action_convert_deposit_choice'         => '將交易轉為存款',
    'rule_action_convert_deposit'                => '將交易轉為來自「:action_value」的存款',
    'rule_action_convert_withdrawal_choice'      => '將交易轉為提款',
    'rule_action_convert_withdrawal'             => '將交易轉為給「:action_value」的提款',
    'rule_action_convert_transfer_choice'        => '將交易轉為轉帳',
    'rule_action_convert_transfer'               => '將交易轉為與「:action_value」的轉帳',
    'rule_action_append_descr_to_notes_choice'   => '將描述附加到交易備註後方',
    'rule_action_append_notes_to_descr_choice'   => '將交易備註附加到描述後方',
    'rule_action_move_descr_to_notes_choice'     => '將目前交易備註替換成描述',
    'rule_action_move_notes_to_descr_choice'     => '將目前描述替換成交易備註',
    'rule_action_append_descr_to_notes'          => '將描述附加到備註後方',
    'rule_action_append_notes_to_descr'          => '將備註附加到描述後方',
    'rule_action_move_descr_to_notes'            => '以描述取代備註',
    'rule_action_move_notes_to_descr'            => '以備註取代描述',
    'rule_action_set_amount_choice'              => '將金額設為…',
    'rule_action_set_amount'                     => '將金額設為「:action_value」',
    'rule_action_set_destination_to_cash_choice' => '將目標帳戶設為 (cash)',
    'rule_action_set_source_to_cash_choice'      => '將來源帳戶設為 (cash)',
    'rulegroup_for_bills_title'                  => '週期性付款專用規則群組',
    'rulegroup_for_bills_description'            => '一個專門用於包含週期性付款規則的規則群組。',
    'rule_for_bill_title'                        => '週期性付款「:name」所自動產生的規則',
    'rule_for_bill_description'                  => '此規則用於嘗試匹配週期性付款「:name」。',
    'create_rule_for_bill'                       => '為週期性付款「:name」建立新規則',
    'create_rule_for_bill_txt'                   => '您剛剛建立了一個名為「:name」的新週期性付款，恭喜！Firefly III 可自動將新的提款與該週期性付款匹配。例如，每次支付房租時，該週期性付款「租金」都會自動與這筆支出建立關聯。如此一來，Firefly III 就能精準顯示哪些週期性付款即將到期、哪些尚未到期。要達成此效果，必須建立一則新規則。Firefly III 已替您填入了合理的預設值。請確定這些值是否正確。如果正確，Firefly III 將會自動將正確的提款匹配至正確的週期性付款。請檢查這些觸發條件是否正確，若不正確請加以修正。',
    'new_rule_for_bill_title'                    => '週期性付款「:name」的規則',
    'new_rule_for_bill_description'              => '此規則將交易標記為週期性付款「:name」。',

    'new_rule_for_journal_title'                => '基於交易「:description」的規則',
    'new_rule_for_journal_description'          => '此規則依據交易「:description」建立。它會匹配完全相同的交易。',

    // tags
    'store_new_tag'                             => '儲存新標籤',
    'update_tag'                                => '更新標籤',
    'no_location_set'                           => '沒有設定位置。',
    'meta_data'                                 => '中繼資料',
    'location'                                  => '位置',
    'location_first_split'                      => '此交易的位置可於此交易的第一筆拆分中設定。',
    'without_date'                              => '不含日期',
    'result'                                    => '結果',
    'sums_apply_to_range'                       => '所有總和均套用至所選範圍',
    'mapbox_api_key'                            => '若要使用地圖，請自 <a href="https://www.mapbox.com/">Mapbox</a> 取得一組 API 金鑰。開啟您的 <code>.env</code> 檔案並於 <code>MAPBOX_API_KEY=</code> 行後輸入該金鑰。',
    'press_object_location'                     => '右鍵點擊或長按以設定物件位置。',
    'click_tap_location'                        => '點擊或輕觸地圖以新增位置',
    'clear_location'                            => '清除位置',
    'delete_all_selected_tags'                  => '刪除所有選取的標籤',
    'select_tags_to_delete'                     => '別忘了先選取一些標籤。',
    'deleted_x_tags'                            => '已刪除 :count 個標籤。|已刪除 :count 個標籤。',
    'create_rule_from_transaction'              => '根據此交易建立規則',
    'create_recurring_from_transaction'         => '根據此交易建立重複交易',

    // preferences
    'test_notifications_buttons'                => '若要測試您的設定，請使用下方按鈕。請注意，這些按鈕無法阻擋大量通知。',
    'dark_mode_option_browser'                  => '讓瀏覽器決定',
    'dark_mode_option_light'                    => '始終使用淺色模式',
    'dark_mode_option_dark'                     => '始終使用深色模式',
    'equal_to_language'                         => '（與語言相同）',
    'dark_mode_preference'                      => '深色模式',
    'dark_mode_preference_help'                 => '告訴 Firefly III 何時使用深色模式。',
    'pref_home_screen_accounts'                 => '主畫面帳戶',
    'pref_home_screen_accounts_help'            => '哪些帳戶應顯示在主畫面上？',
    'pref_view_range'                           => '檢視範圍',
    'pref_view_range_help'                      => '部分圖表會自動在此區間進行分組，您的預算也會按此區間顯示。您偏好的區間是什麼？',
    'pref_1D'                                   => '1 天',
    'pref_1W'                                   => '1 週',
    'pref_1M'                                   => '1 個月',
    'pref_3M'                                   => '3 個月 (季)',
    'pref_6M'                                   => '6 個月',
    'pref_1Y'                                   => '1 年',
    'pref_last365'                              => '過去一年',
    'pref_last90'                               => '過去 90 天',
    'pref_last30'                               => '過去 30 天',
    'pref_last7'                                => '過去 7 天',
    'pref_YTD'                                  => '今年迄今',
    'pref_QTD'                                  => '本季迄今',
    'pref_MTD'                                  => '本月迄今',
    'pref_languages'                            => '語言',
    'pref_locale'                               => '地區設定',
    'pref_languages_help'                       => 'Firefly III 支援多種語言，請選擇您想顯示的語言。',
    'pref_locale_help'                          => 'Firefly III 允許您設定其他在地化 (locale) 設定，例如貨幣、數字與日期的格式。此列表中的部分項目可能不受您系統支援。Firefly III 不一定擁有每個在地設定的正確日期格式；如需改進，請聯絡開發者。',
    'pref_locale_no_demo'                       => '此功能無法於展示使用者生效。',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => '自訂財政年度',
    'pref_custom_fiscal_year_label'             => '啟用',
    'pref_custom_fiscal_year_help'              => '部分國家/地區的會計年度不以 1 月 1 日開始。若您啟用此設定，可自訂財政年度的起始、結束日期。',
    'pref_fiscal_year_start_label'              => '財政年度起始日',
    'pref_two_factor_auth'                      => '多重驗證 (Multi-factor authentication)',
    'pref_two_factor_auth_help'                 => '啟用多重驗證 (亦稱雙重驗證) 後，您的帳號將多一層安全防護。除了密碼外，您還需輸入由手機應用程式 (如 Authy 或 Google Authenticator) 產生的驗證碼。',
    'pref_enable_two_factor_auth'               => '啟用多重驗證',
    'pref_two_factor_auth_disabled'             => '已移除並停用多重驗證驗證碼',
    'pref_two_factor_auth_remove_it'            => '請勿忘記在您的驗證應用程式中刪除此帳號！',
    'pref_two_factor_auth_code'                 => '驗證碼',
    'pref_two_factor_auth_code_help'            => '請使用 Authy 或 Google Authenticator 等手機應用程式掃描此 QR 碼，並輸入所產生的驗證碼。每次造訪本頁時，QR 碼都會變化。請確保使用最新的 QR 碼。',
    'pref_two_factor_auth_reset_code'           => '重設認證碼',
    'pref_two_factor_auth_disable_2fa'          => '停用多重驗證',
    '2fa_use_secret_instead'                    => '若您無法掃描 QR 碼，也可直接使用此祕密金鑰：<code>:secret</code>。',
    '2fa_backup_codes'                          => '請將這些備用代碼妥善保存，以防遺失裝置時仍能登入。',
    '2fa_already_enabled'                       => '多重驗證 (MFA) 已啟用。',
    'wrong_mfa_code'                            => '此 MFA 代碼無效。',
    'pref_save_settings'                        => '儲存設定',
    'saved_preferences'                         => '偏好設定已儲存！',
    'preferences_general'                       => '一般',
    'preferences_frontpage'                     => '主畫面',
    'preferences_security'                      => '安全性',
    'preferences_layout'                        => '版面配置',
    'preferences_notifications'                 => '通知',
    'pref_home_show_deposits'                   => '在主畫面顯示存款',
    'pref_home_show_deposits_info'              => '主畫面已顯示您的支出帳戶，是否也要顯示收入帳戶？',
    'pref_home_do_show_deposits'                => '是，顯示',
    'successful_count'                          => ':count 項成功',
    'list_page_size_title'                      => '頁面大小',
    'list_page_size_help'                       => '在各個清單 (如帳戶、交易) 中，每頁要顯示多少筆資料？',
    'list_page_size_label'                      => '頁面大小',
    'between_dates'                             => '（:start 與 :end）',
    'pref_optional_fields_transaction'          => '交易的選填欄位',
    'pref_optional_fields_transaction_help'     => '預設情況下，Firefly III 不會在「建立新交易」表單中顯示所有欄位 (以保持介面整潔)。若您常使用某些欄位，您可在此將它們啟用。若欄位原本已填有資料，則無論此處如何設定都會顯示。',
    'optional_tj_date_fields'                   => '日期欄位',
    'optional_tj_other_fields'                  => '其他欄位',
    'optional_tj_attachment_fields'             => '附件欄位',
    'pref_optional_tj_interest_date'            => '利率日期',
    'pref_optional_tj_book_date'                => '登記日期',
    'pref_optional_tj_process_date'             => '處理日期',
    'pref_optional_tj_due_date'                 => '截止日期',
    'pref_optional_tj_payment_date'             => '付款日期',
    'pref_optional_tj_invoice_date'             => '發票日期',
    'pref_optional_tj_internal_reference'       => '內部參照',
    'pref_optional_tj_notes'                    => '備註',
    'pref_optional_tj_attachments'              => '附件',
    'pref_optional_tj_external_url'             => '外部 URL',
    'pref_optional_tj_location'                 => '位置',
    'pref_optional_tj_links'                    => '交易連結',
    'optional_field_meta_dates'                 => '日期欄位',
    'optional_field_meta_business'              => '商務欄位',
    'optional_field_attachments'                => '附件欄位',
    'optional_field_meta_data'                  => '可選中繼資料欄位',
    'external_url'                              => '外部 URL',
    'pref_notification_login_failure'           => '登入失敗',
    'pref_notification_bill_reminder'           => '週期性付款到期提醒',
    'pref_notification_new_access_token'        => '當建立新的 API Access Token 時發出警示',
    'pref_notification_transaction_creation'    => '當系統自動建立交易時發出警示',
    'pref_notification_user_login'              => '當您從新位置登入時發出警示',
    'pref_notification_rule_action_failures'    => '規則動作執行失敗時發出警示（不經由電子郵件）',
    'pref_notification_new_password'            => '您的密碼已變更',
    'pref_notification_enabled_mfa'             => '已啟用多重驗證 (MFA)',
    'pref_notification_disabled_mfa'            => '已停用多重驗證 (MFA)',
    'pref_notification_few_left_mfa'            => '您的備用代碼所剩無幾',
    'pref_notification_no_left_mfa'             => '您已沒有任何備用代碼',
    'pref_notification_many_failed_mfa'         => '多重驗證檢查持續失敗',
    'pref_notification_new_backup_codes'        => '已產生新的備用代碼',
    'pref_notifications'                        => '通知',
    'pref_notifications_help'                   => '選擇您想收到哪些通知。部分通知可能包含敏感的財務資訊。',
    'pref_notifications_settings'               => '通知設定',
    'pref_notifications_settings_help'          => '使用這些設定來配置通知管道。請注意，通知將同時傳送至所有管道。請先儲存設定，才能開始使用。',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord Webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => '匯率',
    'header_exchange_rates'                     => '匯率',
    'exchange_rates_intro'                      => 'Firefly III 支援下載並使用匯率。如需更多資訊，請參考<a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">文件</a>。',
    'exchange_rates_from_to'                    => '在 {from} 與 {to} 之間（以及反方向）',
    'header_exchange_rates_rates'               => '匯率清單',
    'exchange_rates_intro_rates'                => 'Firefly III 會使用下列匯率。若未提供反向匯率，系統會自動計算其反向值。若該交易日期無對應匯率，Firefly III 會回溯較舊的匯率；若皆無可用，則會使用「1」。',
    'header_exchange_rates_table'               => '匯率表',
    'help_rate_form'                            => '在這一天，一個 {from} 可兌換多少 {to}？',
    'save_new_rate'                             => '儲存新匯率',
    'add_new_rate'                              => '新增匯率',
    'not_enough_currencies'                     => '貨幣數量不足',
    'not_enough_currencies_enabled'             => '若您僅啟用了單一貨幣，則無需使用匯率。',

    // Financial administrations
    'administration_index'                      => '財務管理',
    'administrations_breadcrumb'                => '多個財務管理',
    'administrations_page_title'                => '多個財務管理',
    'administrations_index_menu'                => '多個財務管理',
    'administrations_page_sub_title'            => '總覽',
    'create_administration'                     => '建立新的財務管理',
    'administration_owner'                      => '財務管理所有者：{{email}}',
    'administration_you'                        => '您的角色：{{role}}',
    'other_users_in_admin'                      => '此財務管理下的其他使用者',
    'administrations_create_breadcrumb'         => '建立新的財務管理',
    'administrations_page_create_sub_title'     => '建立新的財務管理',
    'basic_administration_information'          => '基本財務管理資訊',
    'new_administration_created'                => '新財務管理「{{title}}」已建立',
    'edit_administration_breadcrumb'            => '編輯財務管理「:title」',
    'administrations_page_edit_sub_title'       => '編輯財務管理「:title」',
    'administrations_page_edit_sub_title_js'    => '編輯財務管理「{title}」',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => '已更新財務管理「:title」',
    'flash_administration_created'              => '已建立財務管理「:title」',
    'flash_administration_deleted'              => '已刪除財務管理「:title」',

    // roles
    'administration_role_owner'                 => '擁有者',
    'administration_role_ro'                    => '唯讀',
    'administration_role_mng_trx'               => '管理交易',
    'administration_role_mng_meta'              => '管理分類與中繼資料',
    'administration_role_mng_budgets'           => '管理預算',
    'administration_role_mng_piggies'           => '管理小豬撲滿',
    'administration_role_mng_subscriptions'     => '管理週期性付款',
    'administration_role_mng_rules'             => '管理規則',
    'administration_role_mng_recurring'         => '管理重複交易',
    'administration_role_mng_webhooks'          => '管理 Webhooks',
    'administration_role_mng_currencies'        => '管理貨幣',
    'administration_role_view_reports'          => '檢視報表',
    'administration_role_full'                  => '完全存取',

    // mfa
    'enable_mfa'                                => '啟用多重驗證 (MFA)',
    'mfa_index_title'                           => '多重驗證 (MFA)',
    'mfa_index_intro'                           => 'Firefly III 支援多重驗證 (MFA)。您可以為帳號啟用 MFA，增添一層安全保護。您可使用 Authy、Google Authenticator 或 FreeOTP 產生登入所需的驗證碼。Firefly III 不支援安全金鑰，但您可將其用作 MFA 祕密金鑰的儲存裝置。',
    'mfa_index_enabled'                         => '您的帳號已啟用多重驗證。',
    'mfa_index_disabled'                        => '您的帳號尚未啟用多重驗證。',
    'mfa_index_owner'                           => '此網站的擁有者始終可關閉您帳號的多重驗證。',
    'current_password_confirm_mfa'              => '請輸入您目前的密碼',
    'mfa_warning_code_changes'                  => '當您輸入完密碼及 MFA 代碼後，系統可能會再次要求您輸入新的 MFA 代碼。請等待應用程式生成新代碼，並避免重複使用剛才的代碼。',
    'mfa_already_disabled'                      => '您的帳號尚未啟用多重驗證，因此無法停用。',
    'disable_mfa_page'                          => '停用多重驗證',
    'disable_mfa_intro'                         => '您可於此停用多重驗證。請輸入您的密碼與一組多重驗證碼以完成。若您喪失 MFA 生成器的使用權限，<a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">請參照說明文件</a>。',
    'pref_disable_mfa'                          => '停用多重驗證',
    'mfa_not_enabled'                           => '尚未啟用多重驗證。',
    'mfa_backup_codes_intro'                    => 'Firefly III 可為您產生備用代碼，當您無法使用代碼生成器登入時可使用這些代碼。您可隨時重新生成備用代碼，一旦生成新的，舊代碼即失效。',
    'mfa_backup_codes_quick'                    => '若您剛從多重驗證的設定頁面進入，可能尚未產生新代碼。請注意，MFA 代碼只能使用一次，確保使用與之前不同的代碼。',
    'mfa_backup_codes_title'                    => '多重驗證備用代碼',
    'mfa_backup_codes_post_title'               => '多重驗證備用代碼',

    // profile:
    'manage_mfa_settings'                       => '管理多重驗證設定',
    'purge_data_title'                          => '自 Firefly III 清除資料',
    'purge_data_expl'                           => '「清除」意指「永久刪除先前已標註為刪除的項目」。在正常情況下，Firefly III 不會真正地刪除任何資料，只是將它們隱藏。按下下方按鈕將會「徹底」刪除這些先前「已刪除」的紀錄。',
    'delete_stuff_header'                       => '刪除並清除資料',
    'purge_all_data'                            => '清除所有已刪除的紀錄',
    'purge_data'                                => '清除資料',
    'purged_all_records'                        => '已清除所有已刪除的紀錄。',
    'delete_data_title'                         => '從 Firefly III 刪除資料',
    'permanent_delete_stuff'                    => '您可在此刪除 Firefly III 中的資料。使用下列按鈕後，這些項目將自介面上移除並隱藏，無法立即復原。不過它們仍可能保留在資料庫中，若有必要可嘗試救援。',
    'other_sessions_logged_out'                 => '您於其他所有工作階段已被登出。',
    'delete_unused_accounts'                    => '刪除未使用的帳戶能清除自動完成列表中的冗餘項目。',
    'delete_all_unused_accounts'                => '刪除未使用的帳戶',
    'deleted_all_unused_accounts'               => '已刪除所有未使用的帳戶',
    'delete_all_budgets'                        => '刪除您所有的預算',
    'delete_all_categories'                     => '刪除您所有的分類',
    'delete_all_tags'                           => '刪除您所有的標籤',
    'delete_all_bills'                          => '刪除您所有的週期性付款',
    'delete_all_piggy_banks'                    => '刪除您所有的小豬撲滿',
    'delete_all_rules'                          => '刪除您所有的規則',
    'delete_all_recurring'                      => '刪除您所有的重複交易',
    'delete_all_object_groups'                  => '刪除您所有的群組',
    'delete_all_accounts'                       => '刪除您所有的帳戶',
    'delete_all_asset_accounts'                 => '刪除您所有的資產帳戶',
    'delete_all_expense_accounts'               => '刪除您所有的支出帳戶',
    'delete_all_revenue_accounts'               => '刪除您所有的收入帳戶',
    'delete_all_liabilities'                    => '刪除您所有的債務',
    'delete_all_transactions'                   => '刪除您所有的交易',
    'delete_all_withdrawals'                    => '刪除您所有的支出 (提款)',
    'delete_all_deposits'                       => '刪除您所有的收入 (存款)',
    'delete_all_transfers'                      => '刪除您所有的轉帳',
    'also_delete_transactions'                  => '刪除帳戶時也會同時刪除所有相關的提款、存款與轉帳！',
    'deleted_all_budgets'                       => '所有預算已刪除',
    'deleted_all_categories'                    => '所有分類已刪除',
    'deleted_all_tags'                          => '所有標籤已刪除',
    'deleted_all_bills'                         => '所有週期性付款已刪除',
    'deleted_all_piggy_banks'                   => '所有小豬撲滿已刪除',
    'deleted_all_rules'                         => '所有規則與規則群組已刪除',
    'deleted_all_object_groups'                 => '所有群組已刪除',
    'deleted_all_accounts'                      => '所有帳戶已刪除',
    'deleted_all_asset_accounts'                => '所有資產帳戶已刪除',
    'deleted_all_expense_accounts'              => '所有支出帳戶已刪除',
    'deleted_all_revenue_accounts'              => '所有收入帳戶已刪除',
    'deleted_all_liabilities'                   => '所有債務已刪除',
    'deleted_all_transactions'                  => '所有交易已刪除',
    'deleted_all_withdrawals'                   => '所有支出 (提款) 已刪除',
    'deleted_all_deposits'                      => '所有收入 (存款) 已刪除',
    'deleted_all_transfers'                     => '所有轉帳已刪除',
    'deleted_all_recurring'                     => '所有重複交易已刪除',
    'change_your_password'                      => '更改您的密碼',
    'delete_account'                            => '移除帳號',
    'current_password'                          => '目前密碼',
    'new_password'                              => '新密碼',
    'new_password_again'                        => '新密碼 (再輸入一次)',
    'delete_your_account'                       => '刪除您的帳號',
    'delete_your_account_help'                  => '刪除您的帳號將同時刪除所有帳戶、交易，<em>一切</em> 您在 Firefly III 中的資料都將<strong>不可復原</strong>。',
    'delete_your_account_password'              => '請輸入您的密碼以繼續。',
    'password'                                  => '密碼',
    'are_you_sure'                              => '您確定要這麼做嗎？無法復原此操作。',
    'are_you_sure_confirm'                      => '您確定嗎？',
    'delete_account_button'                     => '*刪除* 您的帳號',
    'invalid_current_password'                  => '目前的密碼無效！',
    'password_changed'                          => '您的密碼已變更！',
    'should_change'                             => '建議您變更密碼。',
    'invalid_password'                          => '無效密碼！',
    'what_is_pw_security'                       => '何謂「驗證密碼安全」？',
    'secure_pw_title'                           => '如何選擇安全的密碼',
    'forgot_password_response'                  => '謝謝。若此電子郵件地址有對應的帳戶，您將會收到進一步的指示。',
    'secure_pw_history'                         => '常見新聞提及網站外洩使用者密碼，竊賊或駭客可利用這些密碼竊取個人資料，這些資料都有其價值。',
    'secure_pw_ff'                              => '是否在多個網站使用相同密碼？若其中一處發生密碼外洩，骯髒的駭客就能存取您所有的資料。Firefly III 仰賴您設定一個強而獨特的密碼以保障您的財務資料安全。',
    'secure_pw_check_box'                       => '因此，Firefly III 可協助檢查您選用的密碼是否曾在外洩紀錄中。若是，Firefly III 建議您<strong>避免</strong>使用該密碼。',
    'secure_pw_working_title'                   => '這是如何運作？',
    'secure_pw_working'                         => '勾選該選項後，Firefly III 會將您的密碼做 SHA1 雜湊，取前 5 個字元傳送給 <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Troy Hunt</a> 的網站，並與洩漏密碼清單進行比對，依據 <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST 指南</a> 建議來避免您使用一些已知風險的密碼。',
    'secure_pw_should'                          => '是否需要勾選此選項？',
    'secure_pw_long_password'                   => '是的，以便檢查您的密碼安全性。',
    'command_line_token'                        => '指令列權杖',
    'explain_command_line_token'                => '執行某些指令列操作（例如匯出資料）需要此權杖；沒有它就無法執行敏感操作。請勿與他人分享此權杖。沒有人會向您索取此權杖，連我都不會。如果您擔心此權杖外洩，或感到疑慮，請點擊按鈕重新產生。',
    'regenerate_command_line_token'             => '重新產生指令列權杖',
    'token_regenerated'                         => '已產生新的指令列權杖',
    'change_your_email'                         => '更改您的電子郵件地址',
    'email_verification'                        => '系統將寄送電子郵件至您的舊郵件及新郵件地址。為了安全起見，您在驗證新的郵件地址前將無法登入。若您不確定此 Firefly III 安裝是否可寄信，請勿使用此功能。若您是管理員，可至<a href="settings">設定</a>頁面測試郵件功能。',
    'email_changed_logout'                      => '您必須先驗證新的郵件地址，在此之前將無法登入。',
    'login_with_new_email'                      => '您現在可以使用新的電子郵件地址登入。',
    'login_with_old_email'                      => '您現在可以使用舊的電子郵件地址再次登入。',
    'login_provider_local_only'                 => '當透過「:login_provider」進行驗證時，此操作無法使用。',
    'external_user_mgt_disabled'                => '當 Firefly III 不管理使用者或執行驗證時，此動作無法使用。',
    'external_auth_disabled'                    => '當 Firefly III 不負責驗證時，此操作無法使用。',
    'delete_local_info_only'                    => "因 Firefly III 不負責使用者管理或驗證，此功能只會刪除 Firefly III 本地端的資料。",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth 用戶端',
    'profile_oauth_no_clients'                  => '您尚未建立任何 OAuth 用戶端。',
    'profile_oauth_clients_external_auth'       => '如果您使用像 Authelia 之類的外部驗證服務，OAuth 用戶端將無法運作。您只能使用個人存取權杖 (Personal Access Tokens)。',
    'profile_oauth_clients_header'              => '用戶端',
    'profile_oauth_client_id'                   => '用戶端 ID',
    'profile_oauth_client_name'                 => '名稱',
    'profile_oauth_client_secret'               => '祕密 (Secret)',
    'profile_oauth_create_new_client'           => '建立新用戶端',
    'profile_oauth_create_client'               => '建立用戶端',
    'profile_oauth_edit_client'                 => '編輯用戶端',
    'profile_oauth_name_help'                   => '一個能讓使用者認得且值得信賴的名稱。',
    'profile_oauth_redirect_url'                => '重新導向 URL',
    'profile_oauth_redirect_url_help'           => '您應用程式的授權回呼 (Callback) URL。',
    'profile_authorized_apps'                   => '已授權的應用程式',
    'profile_authorized_clients'                => '已授權的用戶端',
    'profile_scopes'                            => 'Scopes',
    'profile_revoke'                            => '撤銷',
    'profile_oauth_client_secret_title'         => '用戶端祕密',
    'profile_oauth_client_secret_expl'          => '以下為您新的用戶端祕密。此祕密只會顯示一次，請謹慎保存！您現在可使用此祕密來發送 API 請求。',
    'profile_personal_access_tokens'            => '個人存取權杖 (Personal Access Tokens)',
    'profile_personal_access_token'             => '個人存取權杖',
    'profile_oauth_confidential'                => '機密 (Confidential)',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => '以下為您新的個人存取權杖。此權杖只顯示一次，請務必保存好！您現在可使用它來發送 API 請求。',
    'profile_no_personal_access_token'          => '您尚未建立任何個人存取權杖。',
    'profile_create_new_token'                  => '建立新權杖',
    'profile_create_token'                      => '建立權杖',
    'profile_create'                            => '建立',
    'profile_save_changes'                      => '儲存變更',
    'profile_whoops'                            => '糟糕！',
    'profile_something_wrong'                   => '出了一些問題！',
    'profile_try_again'                         => '出了一些問題，請再試一次。',
    'amounts'                                   => '金額',
    'multi_account_warning_unknown'             => '依您建立交易的類型不同，後續拆分的來源帳戶或目標帳戶可能會被第一筆拆分中設定的帳戶覆寫。',
    'multi_account_warning_withdrawal'          => '請注意，若您建立的是提款交易，後續拆分的來源帳戶將會被第一筆拆分中設定的帳戶覆寫。',
    'multi_account_warning_deposit'             => '請注意，若您建立的是存款交易，後續拆分的目標帳戶將會被第一筆拆分中設定的帳戶覆寫。',
    'multi_account_warning_transfer'            => '請注意，若您建立的是轉帳交易，後續拆分的來源與目標帳戶將會被第一筆拆分中設定的帳戶覆寫。',


    // export data:
    'export_data_title'                         => '自 Firefly III 匯出資料',
    'export_data_menu'                          => '匯出資料',
    'export_data_bc'                            => '自 Firefly III 匯出資料',
    'export_data_main_title'                    => '自 Firefly III 匯出資料',
    'export_data_expl'                          => '使用此連結可匯出所有交易與中繼資料。更多說明請參考右上角的 (?) 說明圖示。',
    'export_data_all_transactions'              => '匯出所有交易',
    'export_data_advanced_expl'                 => '若您需要更進階或更特定的匯出類型，請參考如何使用 <code>php artisan help firefly-iii:export-data</code> 的說明。',

    // attachments
    'nr_of_attachments'                         => '̇1 個附加檔案|:count 個附加檔案',
    'attachments'                               => '附加檔案',
    'edit_attachment'                           => '編輯附加檔案 ":name"',
    'update_attachment'                         => '更新附加檔案',
    'delete_attachment'                         => '刪除附加檔案 ":name"',
    'attachment_deleted'                        => '已刪除附加檔案 ":name"',
    'liabilities_deleted'                       => '已刪除債務 ":name"',
    'attachment_updated'                        => '已更新附加檔案 ":name',
    'upload_max_file_size'                      => '最大檔案大小: :size',
    'list_all_attachments'                      => '全部附加檔案清單',

    // transaction index
    'is_reconciled_fields_dropped'              => '由於此交易已對帳，除非您先取消對帳狀態，否則無法更新其帳戶或金額。',
    'is_reconciled'                             => '已對帳',
    'title_expenses'                            => '支出',
    'title_withdrawal'                          => '支出',
    'title_revenue'                             => '收入',
    'title_deposit'                             => '收入',
    'title_transfer'                            => '轉帳',
    'title_transfers'                           => '轉帳',
    'submission_options'                        => '送出選項',
    'apply_rules_checkbox'                      => '套用規則',
    'fire_webhooks_checkbox'                    => '觸發 Webhooks',
    'select_source_account'                     => '請選擇或輸入有效的來源帳戶名稱',
    'select_dest_account'                       => '請選擇或輸入有效的目標帳戶名稱',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => '此交易已是一筆提款',
    'convert_is_already_type_Deposit'           => '此交易已是一筆存款',
    'convert_is_already_type_Transfer'          => '此交易已是一筆轉帳',
    'convert_to_Withdrawal'                     => '將「:description」轉換為提款',
    'convert_to_Deposit'                        => '將「:description」轉換為存款',
    'convert_to_Transfer'                       => '將「:description」轉換為轉帳',
    'convert_options_WithdrawalDeposit'         => '將提款轉為存款',
    'convert_options_WithdrawalTransfer'        => '將提款轉為轉帳',
    'convert_options_DepositTransfer'           => '將存款轉為轉帳',
    'convert_options_DepositWithdrawal'         => '將存款轉為提款',
    'convert_options_TransferWithdrawal'        => '將轉帳轉為提款',
    'convert_options_TransferDeposit'           => '將轉帳轉為存款',
    'convert_Withdrawal_to_deposit'             => '將此提款轉為存款',
    'convert_Withdrawal_to_transfer'            => '將此提款轉為轉帳',
    'convert_Deposit_to_withdrawal'             => '將此存款轉為提款',
    'convert_Deposit_to_transfer'               => '將此存款轉為轉帳',
    'convert_Transfer_to_deposit'               => '將此轉帳轉為存款',
    'convert_Transfer_to_withdrawal'            => '將此轉帳轉為提款',
    'convert_please_set_revenue_source'         => '請選擇金錢來源的收入帳戶',
    'convert_please_set_asset_destination'      => '請選擇要將金錢轉入的資產帳戶',
    'convert_please_set_expense_destination'    => '請選擇金錢要轉入的支出帳戶',
    'convert_please_set_asset_source'           => '請選擇金錢來源的資產帳戶',
    'convert_expl_w_d'                          => '將提款轉為存款時，會將金額存入所顯示的目標帳戶，而非從該帳戶提款。|將提款轉為存款時，會將金額存入所顯示的目標帳戶，而非從該帳戶提款。',
    'convert_expl_w_t'                          => '將提款轉為轉帳時，金額會自來源帳戶轉移至其他資產或債務帳戶，而非花在原支出帳戶上。|將提款轉為轉帳時，金額會自來源帳戶轉移至其他資產或債務帳戶，而非花在原支出帳戶上。',
    'convert_expl_d_w'                          => '將存款轉為提款時，金額會自顯示的來源帳戶提款，而非存入該帳戶。|將存款轉為提款時，金額會自顯示的來源帳戶提款，而非存入該帳戶。',
    'convert_expl_d_t'                          => '將存款轉為轉帳時，金額會自您的其中一個資產或債務帳戶存入列出的目標帳戶。|將存款轉為轉帳時，金額會自您的其中一個資產或債務帳戶存入列出的目標帳戶。',
    'convert_expl_t_w'                          => '將轉帳轉為提款時，金額會花費在您於此設定的目標帳戶，而非轉移到其他帳戶。|將轉帳轉為提款時，金額會花費在您於此設定的目標帳戶，而非轉移到其他帳戶。',
    'convert_expl_t_d'                          => '將轉帳轉為存款時，金額會存入此處顯示的目標帳戶，而非轉移到該帳戶。|將轉帳轉為存款時，金額會存入此處顯示的目標帳戶，而非轉移到該帳戶。',
    'convert_select_sources'                    => '為完成轉換，請在下方設定新的來源帳戶。|為完成轉換，請在下方設定新的來源帳戶。',
    'convert_select_destinations'               => '為完成轉換，請選擇新的目標帳戶。|為完成轉換，請選擇新的目標帳戶。',
    'converted_to_Withdrawal'                   => '此交易已轉換為提款',
    'converted_to_Deposit'                      => '此交易已轉換為存款',
    'converted_to_Transfer'                     => '此交易已轉換為轉帳',
    'invalid_convert_selection'                 => '您選擇的帳戶已用於此交易或不存在',
    'source_or_dest_invalid'                    => '找不到正確的交易細節，無法轉換。',
    'convert_to_withdrawal'                     => '轉換成提款',
    'convert_to_deposit'                        => '轉換成存款',
    'convert_to_transfer'                       => '轉換成轉帳',

    // create new stuff:
    'create_new_withdrawal'                     => '建立新提款',
    'create_new_deposit'                        => '建立新存款',
    'create_new_transfer'                       => '建立新轉帳',
    'create_new_asset'                          => '建立新資產帳戶',
    'create_new_liabilities'                    => '建立新債務',
    'create_new_expense'                        => '建立新支出帳戶',
    'create_new_revenue'                        => '建立新收入帳戶',
    'create_new_piggy_bank'                     => '建立新小豬撲滿',
    'create_new_bill'                           => '建立新的週期性付款',
    'create_new_subscription'                   => '建立新的週期性付款',
    'create_new_rule'                           => '建立新規則',

    // currencies:
    'create_currency'                           => '建立新貨幣',
    'store_currency'                            => '儲存新貨幣',
    'update_currency'                           => '更新貨幣',
    'new_default_currency'                      => '「:name」已成為新的預設貨幣。',
    'default_currency_failed'                   => '無法將「:name」設為預設貨幣，請查看日誌。',
    'cannot_delete_currency'                    => '因仍在使用中，無法刪除 :name。',
    'cannot_delete_fallback_currency'           => ':name 為系統用的回退貨幣，無法刪除。',
    'cannot_disable_currency_journals'          => '因有交易使用此貨幣，無法停用 :name。',
    'cannot_disable_currency_last_left'         => '因其為最後一個啟用的貨幣，無法停用 :name。',
    'cannot_disable_currency_account_meta'      => '因其在資產帳戶中被使用，無法停用 :name。',
    'cannot_disable_currency_bills'             => '因其在週期性付款中被使用，無法停用 :name。',
    'cannot_disable_currency_recurring'         => '因其在重複交易中被使用，無法停用 :name。',
    'cannot_disable_currency_available_budgets' => '因其在可用預算中被使用，無法停用 :name。',
    'cannot_disable_currency_budget_limits'     => '因其在預算限制中被使用，無法停用 :name。',
    'cannot_disable_currency_current_default'   => '因其為目前的預設貨幣，無法停用 :name。',
    'cannot_disable_currency_system_fallback'   => '因其為系統回退預設貨幣，無法停用 :name。',
    'disable_EUR_side_effects'                  => '歐元為系統的緊急回退貨幣。停用可能會造成預期外的後果，並使系統失去保固。',
    'deleted_currency'                          => '已刪除貨幣 :name',
    'created_currency'                          => '已建立貨幣 :name',
    'could_not_store_currency'                  => '無法儲存新貨幣',
    'updated_currency'                          => '已更新貨幣 :name',
    'ask_site_owner'                            => '請聯絡 :owner 新增、刪除或編輯貨幣。',
    'currencies_intro'                          => 'Firefly III 支援多種貨幣，您可在此設定並啟用。',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => '設為預設貨幣',
    'default_currency'                          => '預設',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => '已停用',
    'enable_currency'                           => '啟用',
    'disable_currency'                          => '停用',
    'currencies_default_disabled'               => '大部分貨幣預設為停用，若需使用請先啟用。',
    'currency_is_now_enabled'                   => '貨幣「:name」已被啟用',
    'could_not_enable_currency'                 => '無法啟用「:name」。請檢查日誌。',
    'currency_is_now_disabled'                  => '貨幣「:name」已被停用',
    'could_not_disable_currency'                => '無法停用「:name」。或許仍在使用中？',

    // forms:
    'mandatoryFields'                           => '必要欄位',
    'optionalFields'                            => '選填欄位',
    'options'                                   => '選項',

    // budgets:
    'daily_budgets'                             => '每日預算',
    'weekly_budgets'                            => '每週預算',
    'monthly_budgets'                           => '每月預算',
    'quarterly_budgets'                         => '每季預算',
    'half_year_budgets'                         => '每半年預算',
    'yearly_budgets'                            => '每年預算',
    'other_budgets'                             => '自訂期間的預算',
    'budget_limit_not_in_range'                 => '此金額套用於 :start 至 :end：',
    'total_available_budget'                    => '總可用預算 (自 :start 至 :end)',
    'total_available_budget_in_currency'        => '以 :currency 表示的總可用預算',
    'see_below'                                 => '見下方',
    'create_new_budget'                         => '建立新預算',
    'store_new_budget'                          => '儲存新預算',
    'stored_new_budget'                         => '已儲存新預算「:name」',
    'available_between'                         => '自 :start 至 :end 間可用',
    'transactionsWithoutBudget'                 => '無預算支出',
    'transactions_no_budget'                    => '自 :start 至 :end 的無預算支出',
    'spent_between'                             => '已於 :start 至 :end 期間花費',
    'spent_between_left'                        => ':start 至 :end 間已花費 :spent，尚餘 :left。',
    'set_available_amount'                      => '設定可用金額',
    'update_available_amount'                   => '更新可用金額',
    'ab_basic_modal_explain'                    => '使用此表單說明您在所示期間內可預算多少金額 (總計，單位 :currency)。',
    'createBudget'                              => '新預算',
    'invalid_currency'                          => '無效的貨幣',
    'invalid_amount'                            => '請輸入金額',
    'set_ab'                                    => '可用預算金額已設定',
    'updated_ab'                                => '可用預算金額已更新',
    'deleted_ab'                                => '可用預算金額已刪除',
    'deleted_bl'                                => '預算金額已移除',
    'alt_currency_ab_create'                    => '以其他貨幣設定可用預算',
    'bl_create_btn'                             => '以其他貨幣設定預算',
    'inactiveBudgets'                           => '未使用預算',
    'without_budget_between'                    => '自 :start 至 :end 無預算的交易',
    'delete_budget'                             => '刪除預算「:name」',
    'deleted_budget'                            => '已刪除預算「:name」',
    'edit_budget'                               => '編輯預算「:name」',
    'updated_budget'                            => '已更新預算「:name」',
    'update_amount'                             => '更新金額',
    'update_budget'                             => '更新預算',
    'update_budget_amount_range'                => '更新 (預期) :start 至 :end 的可用金額',
    'set_budget_limit_title'                    => '為預算 :budget 在 :start 至 :end 間設定金額',
    'set_budget_limit'                          => '設定預算金額',
    'budget_period_navigator'                   => '期間導覽',
    'info_on_available_amount'                  => '我有多少可用的預算？',
    'available_amount_indication'               => '請參考以下金額以估計您的總可用預算',
    'suggested'                                 => '建議值',
    'average_between'                           => ':start 至 :end 期間的平均值',
    'transferred_in'                            => '轉入 (轉帳)',
    'transferred_away'                          => '轉出 (轉帳)',
    'auto_budget_none'                          => '無自動預算',
    'auto_budget_reset'                         => '每期設定固定金額',
    'auto_budget_rollover'                      => '每期增加一定金額',
    'auto_budget_adjusted'                      => '每期增加一定金額，並根據超支情況進行調整',
    'auto_budget_period_daily'                  => '每日',
    'auto_budget_period_weekly'                 => '每週',
    'auto_budget_period_monthly'                => '每月',
    'auto_budget_period_quarterly'              => '每季',
    'auto_budget_period_half_year'              => '每半年',
    'auto_budget_period_yearly'                 => '每年',
    'auto_budget_help'                          => '您可在說明中閱讀此功能的更多資訊。按一下右上角的 (?) 圖示查看。',
    'auto_budget_reset_icon'                    => '此預算將會在固定周期更新',
    'auto_budget_rollover_icon'                 => '預算金額將定期增加',
    'auto_budget_adjusted_icon'                 => '預算金額將定期增加，並在超支時進行修正',
    'remove_budgeted_amount'                    => '移除以 :currency 設定的預算金額',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => '使用「略過」欄位可建立雙月週期 (略過 = 1) 或其他自訂間隔。',
    'subscription'                              => '週期性付款',
    'not_expected_period'                       => '本期間不預期',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => '尚未 / 不預期',
    'visit_bill'                                => '前往 Firefly III 中的週期性付款「:name」',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => '週期性付款會匹配金額介於 :low 到 :high 的交易。',
    'running_again_loss'                        => '先前已連結至此週期性付款的交易，若不再符合規則，可能會失去連結。',
    'bill_related_rules'                        => '與此週期性付款相關的規則',
    'repeats'                                   => '重複',
    'bill_end_date_help'                        => '選填欄位。此週期性付款預計在該日期結束。',
    'bill_extension_date_help'                  => '選填欄位。此週期性付款必須在該日期或之前延長 (或取消)。',
    'bill_end_index_line'                       => '此週期性付款將於 :date 結束',
    'bill_extension_index_line'                 => '此週期性付款必須在 :date 前延長或取消',
    'connected_journals'                        => '已連接交易',
    'auto_match_on'                             => '由 Firefly III 自動配對',
    'auto_match_off'                            => '不由 Firefly III 自動配對',
    'next_expected_match'                       => '下一個預期配對',
    'delete_bill'                               => '刪除週期性付款「:name」',
    'deleted_bill'                              => '已刪除週期性付款「:name」',
    'edit_bill'                                 => '編輯週期性付款「:name」',
    'more'                                      => '更多',
    'rescan_old'                                => '再次於所有交易執行規則',
    'update_bill'                               => '更新週期性付款',
    'updated_bill'                              => '已更新週期性付款「:name」',
    'store_new_bill'                            => '儲存新的週期性付款',
    'stored_new_bill'                           => '已儲存新的週期性付款「:name」',
    'cannot_scan_inactive_bill'                 => '無法掃描停用的週期性付款。',
    'rescanned_bill'                            => '重新掃描所有內容，並將 :count 筆交易連結至此週期性付款。|重新掃描所有內容，並將 :count 筆交易連結至此週期性付款。',
    'average_bill_amount_year'                  => '本年週期性付款平均金額 (:year)',
    'average_bill_amount_overall'               => '週期性付款平均金額 (整體)',
    'bill_is_active'                            => '此週期性付款已啟用',
    'bill_expected_between'                     => '期待自 :start 至 :end',
    'bill_will_automatch'                       => '週期性付款將自動連結符合的交易',
    'skips_over'                                => '略過',
    'bill_store_error'                          => '儲存新的週期性付款時發生意外錯誤，請檢查日誌檔案。',
    'list_inactive_rule'                        => '未啟用的規則',
    'bill_edit_rules'                           => 'Firefly III 也會嘗試編輯與此週期性付款相關的規則。然而，若您曾自行編輯該規則，Firefly III 將不會改動任何內容。|Firefly III 也會嘗試編輯與此週期性付款相關的 :count 筆規則。然而，若您曾自行編輯這些規則，Firefly III 將不會改動任何內容。',
    'bill_expected_date'                        => '預期於 :date',
    'bill_expected_date_js'                     => '預期於 {date}',
    'expected_amount'                           => '（預期）金額',
    'bill_paid_on'                              => '已於 {date} 付款',
    'bill_repeats_weekly'                       => '每週重複',
    'bill_repeats_monthly'                      => '每月重複',
    'bill_repeats_quarterly'                    => '每季重複',
    'bill_repeats_half-year'                    => '每半年重複',
    'bill_repeats_yearly'                       => '每年重複',
    'bill_repeats_weekly_other'                 => '每兩週重複',
    'bill_repeats_monthly_other'                => '每兩個月重複',
    'bill_repeats_quarterly_other'              => '每兩季重複',
    'bill_repeats_half-year_other'              => '每年重複',
    'bill_repeats_yearly_other'                 => '每兩年重複',
    'bill_repeats_weekly_skip'                  => '每 {skip} 週重複',
    'bill_repeats_monthly_skip'                 => '每 {skip} 個月重複',
    'bill_repeats_quarterly_skip'               => '每 {skip} 季重複',
    'bill_repeats_half-year_skip'               => '每 {skip} 半年重複',
    'bill_repeats_yearly_skip'                  => '每 {skip} 年重複',
    'subscriptions'                             => '週期性付款',
    'go_to_subscriptions'                       => '前往您的週期性付款',
    'forever'                                   => '無限期',
    'extension_date_is'                         => '需延長日期為 {date}',

    // accounts:
    'account_locked_currency'                   => '只要此帳戶仍有小豬撲滿連結，則其貨幣就必須維持為 :name。',
    'i_am_owed_amount'                          => '有人欠我錢',
    'i_owe_amount'                              => '我欠別人錢',
    'inactive_account_link'                     => '您有 :count 個停用（封存）帳戶，可在此獨立頁面檢視。|您有 :count 個停用（封存）帳戶，可在此獨立頁面檢視。',
    'all_accounts_inactive'                     => '以下為您所有的停用帳戶。',
    'active_account_link'                       => '此連結可返回您仍在使用的帳戶清單。',
    'account_missing_transaction'               => '帳戶 #:id（「:name」）無法直接檢視，Firefly III 無法找到重新導向的資訊。',
    'cc_monthly_payment_date_help'              => '可選任意年份與月份，系統只會取日 (Day) 資訊。',
    'details_for_asset'                         => '資產帳戶「:name」的詳細資訊',
    'details_for_expense'                       => '支出帳戶「:name」的詳細資訊',
    'details_for_revenue'                       => '收入帳戶「:name」的詳細資訊',
    'details_for_cash'                          => '現金帳戶「:name」的詳細資訊',
    'store_new_asset_account'                   => '儲存新資產帳戶',
    'store_new_expense_account'                 => '儲存新支出帳戶',
    'store_new_revenue_account'                 => '儲存新收入帳戶',
    'edit_asset_account'                        => '編輯資產帳戶「:name」',
    'edit_expense_account'                      => '編輯支出帳戶「:name」',
    'edit_revenue_account'                      => '編輯收入帳戶「:name」',
    'delete_asset_account'                      => '刪除資產帳戶「:name」',
    'delete_expense_account'                    => '刪除支出帳戶「:name」',
    'delete_revenue_account'                    => '刪除收入帳戶「:name」',
    'delete_liabilities_account'                => '刪除債務「:name」',
    'asset_deleted'                             => '已成功刪除資產帳戶「:name」',
    'account_deleted'                           => '已成功刪除帳戶「:name」',
    'expense_deleted'                           => '已成功刪除支出帳戶「:name」',
    'revenue_deleted'                           => '已成功刪除收入帳戶「:name」',
    'update_asset_account'                      => '更新資產帳戶',
    'update_undefined_account'                  => '更新帳戶',
    'update_liabilities_account'                => '更新債務',
    'update_expense_account'                    => '更新支出帳戶',
    'update_revenue_account'                    => '更新收入帳戶',
    'make_new_asset_account'                    => '建立新資產帳戶',
    'make_new_expense_account'                  => '建立新支出帳戶',
    'make_new_revenue_account'                  => '建立新收入帳戶',
    'make_new_liabilities_account'              => '建立新債務',
    'asset_accounts'                            => '資產帳戶',
    'undefined_accounts'                        => '帳戶',
    'asset_accounts_inactive'                   => '資產帳戶（停用）',
    'expense_account'                           => '支出帳戶',
    'expense_accounts'                          => '支出帳戶',
    'expense_accounts_inactive'                 => '支出帳戶（停用）',
    'revenue_account'                           => '收入帳戶',
    'revenue_accounts'                          => '收入帳戶',
    'revenue_accounts_inactive'                 => '收入帳戶（停用）',
    'cash_accounts'                             => '現金帳戶',
    'Cash account'                              => '現金帳戶',
    'liabilities_accounts'                      => '債務',
    'liabilities_accounts_inactive'             => '債務（停用）',
    'reconcile_account'                         => '核對帳戶「:account」',
    'overview_of_reconcile_modal'               => '對帳概覽',
    'delete_reconciliation'                     => '刪除對帳',
    'update_reconciliation'                     => '更新對帳',
    'amount_cannot_be_zero'                     => '金額不可為零',
    'end_of_reconcile_period'                   => '對帳區間結束：:period',
    'start_of_reconcile_period'                 => '對帳區間開始：:period',
    'start_balance'                             => '初始餘額',
    'end_balance'                               => '結束餘額',
    'update_balance_dates_instruction'          => '請將上述金額及日期與您的銀行帳單對照後，按一下「開始對帳」',
    'select_transactions_instruction'           => '請選擇您的銀行帳單上顯示的所有交易',
    'select_range_and_balance'                  => '請確認日期範圍與餘額後，再按「開始對帳」',
    'date_change_instruction'                   => '若您此時變更日期範圍，任何進度都將遺失。',
    'update_selection'                          => '更新選擇',
    'store_reconcile'                           => '儲存對帳',
    'reconciliation_transaction'                => '對帳交易',
    'Reconciliation'                            => '對帳',
    'reconciliation'                            => '對帳',
    'reconcile_options'                         => '對帳選項',
    'reconcile_range'                           => '對帳範圍',
    'start_reconcile'                           => '開始對帳',
    'cash_account_type'                         => '現金',
    'cash'                                      => '現金',
    'cant_find_redirect_account'                => 'Firefly III 試圖重新導向，但失敗了。很抱歉。返回主頁。',
    'account_type'                              => '帳戶類型',
    'save_transactions_by_moving'               => '將此交易移動至其他帳戶即可儲存：|將這些交易移動至其他帳戶即可儲存：',
    'save_transactions_by_moving_js'            => '無交易|將此交易移動至其他帳戶即可儲存。|將這些交易移動至其他帳戶即可儲存。',
    'stored_new_account'                        => '新帳戶「:name」已儲存！',
    'stored_new_account_js'                     => '已儲存新帳戶「<a href="accounts/show/{ID}">{name}</a>」！',
    'updated_account'                           => '已更新帳戶「:name」',
    'updated_account_js'                        => '已更新帳戶「<a href="accounts/show/{ID}">{title}</a>」。',
    'credit_card_options'                       => '信用卡選項',
    'no_transactions_account'                   => '資產帳戶「:name」在此期間沒有交易。',
    'no_transactions_period'                    => '此期間沒有任何交易記錄。',
    'no_data_for_chart'                         => '目前尚無足夠資訊生成圖表。',
    'select_at_least_one_account'               => '請選擇至少一個資產帳戶',
    'select_at_least_one_category'              => '請選擇至少一個分類',
    'select_at_least_one_budget'                => '請選擇至少一個預算',
    'select_at_least_one_tag'                   => '請選擇至少一個標籤',
    'select_at_least_one_expense'               => '請選擇至少一組支出或收入帳戶。若清單為空，則本報表不可用。',
    'account_default_currency'                  => '此貨幣將作為與此帳戶關聯的預設貨幣。',
    'piggy_default_currency'                    => '小豬撲滿只能儲存單一貨幣的金額。',
    'piggy_account_currency_match'              => '僅支援符合先前選擇的貨幣之帳戶。',
    'reconcile_has_more'                        => 'Firefly III 之餘額較銀行多，您有多個處理方式。請選擇並按「確認對帳」。',
    'reconcile_has_less'                        => 'Firefly III 之餘額較銀行少，您有多個處理方式。請選擇並按「確認對帳」。',
    'reconcile_is_equal'                        => 'Firefly III 與銀行餘額相符。無需任何動作。請按「確認對帳」匯入。',
    'create_pos_reconcile_transaction'          => '忽略所選交易，並建立一筆校正交易，在此資產帳戶中新增 :amount。',
    'create_neg_reconcile_transaction'          => '忽略所選交易，並建立一筆校正交易，自此資產帳戶移除 :amount。',
    'reconcile_do_nothing'                      => '刪除所選交易，但無校正。',
    'reconcile_go_back'                         => '您可稍後編輯或刪除此校正交易。',
    'must_be_asset_account'                     => '僅能對帳資產帳戶。',
    'reconciliation_stored'                     => '對帳資訊已儲存',
    'reconciliation_error'                      => '發生錯誤。此交易已標註為對帳，但修正無法儲存：:error。',
    'reconciliation_transaction_title'          => '對帳 (自 :from 至 :to)',
    'sum_of_reconciliation'                     => '對帳總和',
    'reconcile_this_account'                    => '對帳此帳戶',
    'reconcile'                                 => '對帳',
    'show'                                      => '顯示',
    'confirm_reconciliation'                    => '確認對帳',
    'submitted_start_balance'                   => '已提交初始餘額',
    'selected_transactions'                     => '已選擇交易 (:count)',
    'already_cleared_transactions'              => '已清除交易 (:count)',
    'submitted_end_balance'                     => '已提交結束餘額',
    'initial_balance_description'               => '「:account」的初始餘額',
    'liability_credit_description'              => '「:account」的債務貸方',
    'interest_calc_'                            => '未知',
    'interest_calc_daily'                       => '每日',
    'interest_calc_monthly'                     => '每月',
    'interest_calc_yearly'                      => '每年',
    'interest_calc_weekly'                      => '每週',
    'interest_calc_half-year'                   => '每半年',
    'interest_calc_quarterly'                   => '每季',
    'initial_balance_account'                   => '「:account」初始餘額帳戶',
    'list_options'                              => '列表選項',
    'account_column_opt_drag_and_drop'          => '拖曳排序',
    'account_column_opt_active'                 => '啟用狀態',
    'account_column_opt_name'                   => '名稱',
    'account_column_opt_type'                   => '類型',
    'account_column_opt_liability_type'         => '債務類型',
    'account_column_opt_liability_direction'    => '債務方向',
    'account_column_opt_liability_interest'     => '債務利息',
    'account_column_opt_number'                 => '帳戶號碼',
    'account_column_opt_current_balance'        => '當前餘額',
    'account_column_opt_amount_due'             => '到期金額',
    'account_column_opt_last_activity'          => '最後操作',
    'account_column_opt_balance_difference'     => '餘額差額',
    'account_column_opt_menu'                   => '操作選單',

    // categories:
    'new_category'                              => '新分類',
    'create_new_category'                       => '建立新分類',
    'without_category'                          => '沒有分類',
    'update_category'                           => '更新分類',
    'updated_category'                          => '已更新分類「:name」',
    'categories'                                => '分類',
    'edit_category'                             => '編輯分類「:name」',
    'no_category'                               => '(沒有分類)',
    'unknown_category_plain'                    => '沒有分類',
    'category'                                  => '分類',
    'delete_category'                           => '刪除分類「:name」',
    'deleted_category'                          => '已刪除分類「:name」',
    'store_category'                            => '儲存新分類',
    'stored_category'                           => '已儲存新分類「:name」',
    'without_category_between'                  => '自 :start 至 :end 間未分類的交易',


    // transactions:
    'wait_loading_transaction'                  => '請稍候，正在載入表單',
    'wait_loading_data'                         => '請稍候，正在載入資料…',
    'wait_attachments'                          => '請稍候，正在上傳附件。',
    'errors_upload'                             => '上傳失敗。請於瀏覽器主控台檢視錯誤訊息。',
    'amount_foreign_if'                         => '外幣金額（若有）',
    'amount_destination_account'                => '目標帳戶的貨幣金額',
    'edit_transaction_title'                    => '編輯交易「:description」',
    'unreconcile'                               => '取消對帳',
    'update_withdrawal'                         => '更新提款',
    'update_deposit'                            => '更新存款',
    'update_transaction'                        => '更新交易',
    'update_transfer'                           => '更新轉帳',
    'updated_withdrawal'                        => '已更新提款「:description」',
    'updated_deposit'                           => '已更新存款「:description」',
    'updated_transfer'                          => '已更新轉帳「:description」',
    'no_changes_withdrawal'                     => '提款「:description」並未修改。',
    'no_changes_deposit'                        => '存款「:description」並未修改。',
    'no_changes_transfer'                       => '轉帳「:description」並未修改。',
    'delete_withdrawal'                         => '刪除提款「:description」',
    'delete_deposit'                            => '刪除存款「:description」',
    'delete_transfer'                           => '刪除轉帳「:description」',
    'deleted_withdrawal'                        => '已成功刪除提款「:description」',
    'deleted_deposit'                           => '已成功刪除存款「:description」',
    'deleted_transfer'                          => '已成功刪除轉帳「:description」',
    'deleted_reconciliation'                    => '已成功刪除對帳交易「:description」',
    'stored_journal'                            => '已成功建立新交易「:description」',
    'stored_journal_js'                         => '已成功建立新交易「{{description}}」',
    'stored_journal_no_descr'                   => '已成功建立新交易',
    'updated_journal_no_descr'                  => '已成功更新此交易',
    'select_transactions'                       => '選擇交易',
    'rule_group_select_transactions'            => '將「:title」套用至交易',
    'rule_select_transactions'                  => '將「:title」套用至交易',
    'stop_selection'                            => '停止選取交易',
    'reconcile_selected'                        => '對帳',
    'mass_delete_journals'                      => '刪除多筆交易',
    'mass_edit_journals'                        => '編輯多筆交易',
    'mass_bulk_journals'                        => '批次編輯多筆交易',
    'mass_bulk_journals_explain'                => '此功能能一次更新下方所列之交易。更改此處的參數後，所有表格中的交易將一併更新。',
    'part_of_split'                             => '此交易為拆分交易之一。若您未全選所有拆分交易，則可能只修改了部分交易。',
    'bulk_set_new_values'                       => '在下方輸入欄設定新的值。若留空則表示此欄無更動。此外僅提款類型可設定預算。',
    'no_bulk_category'                          => '不修改分類',
    'no_bulk_budget'                            => '不修改預算',
    'no_bulk_tags'                              => '不修改標籤',
    'replace_with_these_tags'                   => '以這些標籤取代',
    'append_these_tags'                         => '加入這些標籤',
    'mass_edit'                                 => '逐筆編輯選取的交易',
    'bulk_edit'                                 => '批次編輯選取的交易',
    'mass_delete'                               => '刪除選取交易',
    'cannot_edit_other_fields'                  => '因版面限制，您僅能批次編輯此處顯示的欄位。如需編輯其他欄位，請點擊連結並逐筆編輯交易。',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(無預算)',
    'no_bill'                                   => '(無週期性付款)',
    'account_per_budget'                        => '每預算的帳戶',
    'account_per_category'                      => '每分類的帳戶',
    'create_new_object'                         => '建立',
    'empty'                                     => '(空)',
    'all_other_budgets'                         => '(所有其他預算)',
    'all_other_accounts'                        => '(所有其他帳戶)',
    'expense_per_source_account'                => '依來源帳戶的支出',
    'expense_per_destination_account'           => '依目標帳戶的支出',
    'income_per_destination_account'            => '依目標帳戶的收入',
    'spent_in_specific_category'                => '分類「:category」中的支出',
    'earned_in_specific_category'               => '分類「:category」中的收入',
    'spent_in_specific_tag'                     => '標籤「:tag」中的支出',
    'earned_in_specific_tag'                    => '標籤「:tag」中的收入',
    'income_per_source_account'                 => '依來源帳戶的收入',
    'average_spending_per_destination'          => '按目標帳戶的平均支出',
    'average_spending_per_source'               => '按來源帳戶的平均支出',
    'average_earning_per_source'                => '按來源帳戶的平均收入',
    'average_earning_per_destination'           => '按目標帳戶的平均收入',
    'account_per_tag'                           => '按標籤的帳戶',
    'tag_report_expenses_listed_once'           => '支出與收入不會重複顯示。若交易擁有多個標籤，則只會顯示在其中一個標籤下。列表似乎有所遺漏，但金額計算正確。',
    'double_report_expenses_charted_once'       => '支出與收入不會重複在圖表中顯示。若交易擁有多個標籤，則僅顯示於其一。圖表似有缺項，但金額計算正確。',
    'tag_report_chart_single_tag'               => '此圖表僅適用於單一標籤。若交易擁有多個標籤，其結果或同樣出現在其他標籤的圖表中。',
    'tag'                                       => '標籤',
    'no_budget_squared'                         => '(無預算)',
    'perm-delete-many'                          => '一次刪除多項內容恐造成嚴重影響，請謹慎操作。您可在此頁刪除部分拆分交易，請多留意。',
    'mass_deleted_transactions_success'         => '已刪除 :count 筆交易。|已刪除 :count 筆交易。',
    'mass_edited_transactions_success'          => '已更新 :count 筆交易。|已更新 :count 筆交易。',
    'opt_group_'                                => '(無帳戶類型)',
    'opt_group_no_account_type'                 => '(無帳戶類型)',
    'opt_group_defaultAsset'                    => '預設資產帳戶',
    'opt_group_savingAsset'                     => '儲蓄帳戶',
    'opt_group_sharedAsset'                     => '共用資產帳戶',
    'opt_group_ccAsset'                         => '信用卡',
    'opt_group_cashWalletAsset'                 => '現金皮夾',
    'opt_group_expense_account'                 => '支出帳戶',
    'opt_group_revenue_account'                 => '收入帳戶',
    'opt_group_l_Loan'                          => '債務：貸款',
    'opt_group_cash_account'                    => '現金帳戶',
    'opt_group_l_Debt'                          => '債務：欠款',
    'opt_group_l_Mortgage'                      => '債務：抵押',
    'opt_group_l_Credit card'                   => '債務：信用卡',
    'notes'                                     => '備註',
    'view_notes'                                => '檢視備註',
    'set_budget_limit_notes'                    => '檢視此預算金額的備註',
    'edit_bl_notes'                             => '編輯備註',
    'update_bl_notes'                           => '更新備註',
    'unknown_journal_error'                     => '無法儲存交易，請檢查日誌檔案。',
    'attachment_not_found'                      => '找不到此附件。',
    'journal_link_bill'                         => '此交易已連結至週期性付款 <a href=":route">:name</a>。若需移除連結，請取消勾選此方塊；如需連結到其他週期性付款，可透過規則自動設定。',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">交易 #{ID}（「{title}」）</a> 已儲存。',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">交易 #{ID}</a> 已儲存。',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">交易 #{ID}</a>（「{title}」）已更新。',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">交易 #{ID}</a>（「{title}」）無任何變更。',
    'first_split_decides'                       => '第一筆拆分決定此欄位的值',
    'first_split_overrules_source'              => '第一筆拆分可能會覆寫來源帳戶',
    'first_split_overrules_destination'         => '第一筆拆分可能會覆寫目標帳戶',
    'spent_x_of_y'                              => '已花費 {amount} / {total}',

    // new user:
    'welcome'                                   => '歡迎使用 Firefly III！',
    'submit'                                    => '送出',
    'submission'                                => '提交',
    'submit_yes_really'                         => '送出（我確定要這麼做）',
    'getting_started'                           => '開始使用',
    'to_get_started'                            => '很高興看到您成功安裝 Firefly III。要開始使用此工具，請輸入您主要使用的銀行名稱與餘額。若您有多個帳戶，可稍後再行新增。這只是 Firefly III 初始化流程所需。',
    'savings_balance_text'                      => 'Firefly III 會自動為您建立儲蓄帳戶。預設下此帳戶沒有餘額，若您想指定餘額，也可在此輸入。',
    'finish_up_new_user'                        => '好了！請按下 <strong>送出</strong> 繼續，您將被帶至 Firefly III 的首頁。',
    'stored_new_accounts_new_user'              => '太好了！您的帳戶已成功儲存。',
    'set_preferred_language'                    => '若您想在 Firefly III 中使用其他語言，請在此選擇。',
    'language'                                  => '語言',
    'new_savings_account'                       => ':bank_name 儲蓄帳戶',
    'cash_wallet'                               => '現金皮夾',
    'currency_not_present'                      => '若您慣用的貨幣不在清單中，請無須擔心，可於「選項 > 貨幣」頁面中自行建立。',

    // home page:
    'transaction_table_description'             => '包含交易紀錄的列表',
    'opposing_account'                          => '對應帳戶',
    'yourAccounts'                              => '您的帳戶',
    'your_accounts'                             => '您的帳戶概覽',
    'category_overview'                         => '分類概覽',
    'expense_overview'                          => '支出帳戶概覽',
    'revenue_overview'                          => '收入帳戶概覽',
    'budgetsAndSpending'                        => '預算與花費',
    'budgets_and_spending'                      => '預算與花費',
    'go_to_budget'                              => '前往預算「{budget}」',
    'go_to_deposits'                            => '前往存款',
    'go_to_expenses'                            => '前往支出',
    'savings'                                   => '儲蓄',
    'newWithdrawal'                             => '新支出',
    'newDeposit'                                => '新存款',
    'newTransfer'                               => '新轉帳',
    'bills_to_pay'                              => '待付款的週期性付款',
    'per_day'                                   => '每日',
    'left_to_spend_per_day'                     => '每日剩餘可花費',
    'bills_paid'                                => '已支付的週期性付款',
    'custom_period'                             => '自訂期間',
    'reset_to_current'                          => '重設至目前期間',
    'select_period'                             => '選擇期間',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => '貨幣',
    'preferences'                               => '偏好設定',
    'logout'                                    => '登出',
    'logout_other_sessions'                     => '登出所有其他工作階段',
    'toggleNavigation'                          => '切換導覽',
    'toggle_dropdown'                           => '切換下拉選單',
    'searchPlaceholder'                         => '搜尋…',
    'version'                                   => '版本',
    'dashboard'                                 => '監控面板',
    'income_and_expense'                        => '收入與支出',
    'all_money'                                 => '您的所有資金',
    'unknown_source_plain'                      => '未知的來源帳戶',
    'unknown_dest_plain'                        => '未知的目標帳戶',
    'unknown_any_plain'                         => '未知的帳戶',
    'unknown_budget_plain'                      => '無預算',
    'available_budget'                          => '可用預算（{currency}）',
    'currencies'                                => '貨幣',
    'activity'                                  => '活動',
    'usage'                                     => '使用狀況',
    'accounts'                                  => '帳戶',
    'Asset account'                             => '資產帳戶',
    'Default account'                           => '資產帳戶',
    'Expense account'                           => '支出帳戶',
    'Revenue account'                           => '收入帳戶',
    'Initial balance account'                   => '初始餘額帳戶',
    'account_type_Asset account'                => '資產帳戶',
    'account_type_Expense account'              => '支出帳戶',
    'account_type_Revenue account'              => '收入帳戶',
    'account_type_Debt'                         => '負債',
    'account_type_Loan'                         => '貸款',
    'account_type_Mortgage'                     => '抵押',
    'account_type_debt'                         => '負債',
    'account_type_loan'                         => '貸款',
    'account_type_mortgage'                     => '抵押',
    'account_type_Credit card'                  => '信用卡',
    'credit_card_type_monthlyFull'              => '每月全額支付',
    'liability_direction_credit'                => '他人欠我此筆債務',
    'liability_direction_debit'                 => '我欠他人此筆債務',
    'liability_direction_credit_short'          => '他人欠我此債',
    'liability_direction_debit_short'           => '我欠此債',
    'liability_direction__short'                => '未知',
    'liability_direction_null_short'            => '未知',
    'Liability credit'                          => '債權',
    'budgets'                                   => '預算',
    'tags'                                      => '標籤',
    'reports'                                   => '報表',
    'transactions'                              => '交易',
    'expenses'                                  => '支出',
    'income'                                    => '收入 / 所得',
    'transfers'                                 => '轉帳',
    'moneyManagement'                           => '金錢管理',
    'money_management'                          => '金錢管理',
    'tools'                                     => '工具',
    'piggyBanks'                                => '小豬撲滿',
    'piggy_banks'                               => '小豬撲滿',
    'amount_x_of_y'                             => '{current} / {total}',
    'bills'                                     => '週期性付款',
    'withdrawal'                                => '提款',
    'opening_balance'                           => '開戶餘額',
    'deposit'                                   => '存款',
    'account'                                   => '帳戶',
    'transfer'                                  => '轉帳',
    'Withdrawal'                                => '提款',
    'Deposit'                                   => '存款',
    'Transfer'                                  => '轉帳',
    'bill'                                      => '週期性付款',
    'yes'                                       => '是',
    'no'                                        => '否',
    'amount'                                    => '金額',
    'overview'                                  => '概覽',
    'saveOnAccount'                             => '儲存於帳戶',
    'saveOnAccounts'                            => '儲存至帳戶',
    'unknown'                                   => '未知',
    'monthly'                                   => '每月',
    'profile'                                   => '個人檔案',
    'errors'                                    => '錯誤',
    'debt_start_date'                           => '負債開始日期',
    'debt_start_amount'                         => '負債起始金額',
    'debt_start_amount_help'                    => '最好將此金額設為負數。詳情請參閱協助頁面（右上角 (?) 圖示）。',
    'interest_period_help'                      => '此欄位純為顯示用途，Firefly III 不會為您計算。由於銀行算法常常藏玄機，Firefly III 無法精準處理此事。',
    'store_new_liabilities_account'             => '儲存新債務',
    'edit_liabilities_account'                  => '編輯債務「:name」',
    'financial_control'                         => '財務控管',
    'accounting'                                => '會計',
    'automation'                                => '自動化',
    'others'                                    => '其他',
    'classification'                            => '分類',
    'store_transaction'                         => '儲存交易',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => '自 :start 至 :end 的預設財務報表',
    'report_audit'                              => '自 :start 至 :end 的交易歷史總覽',
    'report_category'                           => '自 :start 至 :end 的分類報表',
    'report_double'                             => '支出 / 收入帳戶報表（自 :start 至 :end）',
    'report_budget'                             => '自 :start 至 :end 的預算報表',
    'report_tag'                                => '自 :start 至 :end 的標籤報表',
    'quick_link_reports'                        => '快速連結',
    'quick_link_examples'                       => '以下為範例連結，協助您快速上手。更多可用的報表與魔術詞彙資訊可於右上角 (?) 按鈕處查看協助頁面。',
    'quick_link_default_report'                 => '預設財務報表',
    'quick_link_audit_report'                   => '交易歷史總覽',
    'report_this_month_quick'                   => '目前月份（所有帳戶）',
    'report_last_month_quick'                   => '上個月（所有帳戶）',
    'report_this_year_quick'                    => '目前年份（所有帳戶）',
    'report_this_fiscal_year_quick'             => '目前財政年度（所有帳戶）',
    'report_all_time_quick'                     => '所有時間（所有帳戶）',
    'reports_can_bookmark'                      => '您可將特定報表加入書籤，方便日後快速存取。',
    'incomeVsExpenses'                          => '所得 vs. 支出',
    'accountBalances'                           => '帳戶餘額',
    'balanceStart'                              => '此區間起始餘額',
    'balanceEnd'                                => '此區間結束餘額',
    'splitByAccount'                            => '以帳戶分割',
    'coveredWithTags'                           => '以標籤涵蓋',
    'leftInBudget'                              => '預算剩餘',
    'left_in_debt'                              => '到期金額',
    'sumOfSums'                                 => '合計總和',
    'noCategory'                                => '(沒有分類)',
    'notCharged'                                => '(尚未開始)',
    'inactive'                                  => '停用',
    'active'                                    => '啟用',
    'difference'                                => '差額',
    'money_flowing_in'                          => '收入',
    'money_flowing_out'                         => '支出',
    'topX'                                      => '前 :number',
    'show_full_list'                            => '顯示完整清單',
    'show_only_top'                             => '只顯示前 :number',
    'report_type'                               => '報表類型',
    'report_type_default'                       => '預設財務報表',
    'report_type_audit'                         => '交易歷史稽核',
    'report_type_category'                      => '分類報表',
    'report_type_budget'                        => '預算報表',
    'report_type_tag'                           => '標籤報表',
    'report_type_double'                        => '支出 / 收入帳戶報表',
    'more_info_help'                            => '您可在協助頁面（右上角 (?) 按鈕）找到更多關於報表類型的資訊。',
    'report_included_accounts'                  => '已包含的帳戶',
    'report_date_range'                         => '日期範圍',
    'report_preset_ranges'                      => '預設範圍',
    'shared'                                    => '共用',
    'fiscal_year'                               => '財政年度',
    'income_entry'                              => '帳戶「:name」自 :start 至 :end 的收入',
    'expense_entry'                             => '帳戶「:name」自 :start 至 :end 的支出',
    'category_entry'                            => '分類「:name」在 :start 至 :end 間的支出與收入',
    'budget_spent_amount'                       => '預算「:budget」自 :start 至 :end 的支出',
    'balance_amount'                            => '帳戶「:account」自 :start 至 :end 在預算「:budget」的支出',
    'no_audit_activity'                         => '<a href=":url" title=":account_name">:account_name</a> 自 :start 至 :end 沒有任何交易活動。',
    'audit_end_balance'                         => '<a href=":url" title=":account_name">:account_name</a> 帳戶於 :end 的餘額：:balance',
    'reports_extra_options'                     => '額外選項',
    'report_has_no_extra_options'               => '此報表無額外選項',
    'reports_submit'                            => '產生報表',
    'end_after_start_date'                      => '報表結束日期必須晚於開始日期。',
    'select_category'                           => '選擇分類',
    'select_budget'                             => '選擇預算',
    'select_tag'                                => '選擇標籤',
    'income_per_category'                       => '每個分類的收入',
    'expense_per_category'                      => '每個分類的支出',
    'expense_per_budget'                        => '每個預算的支出',
    'income_per_account'                        => '每個帳戶的收入',
    'expense_per_account'                       => '每個帳戶的支出',
    'expense_per_tag'                           => '每個標籤的支出',
    'income_per_tag'                            => '每個標籤的收入',
    'include_expense_not_in_budget'             => '包含不在所選預算內的支出',
    'include_expense_not_in_account'            => '包含不在所選帳戶內的支出',
    'include_expense_not_in_category'           => '包含不在所選分類內的支出',
    'include_income_not_in_category'            => '包含不在所選分類內的收入',
    'include_income_not_in_account'             => '包含不在所選帳戶內的收入',
    'include_income_not_in_tags'                => '包含未在所選標籤內的收入',
    'include_expense_not_in_tags'               => '包含未在所選標籤內的支出',
    'everything_else'                           => '其他項目',
    'income_and_expenses'                       => '收入與支出',
    'spent_average'                             => '支出（平均）',
    'income_average'                            => '收入（平均）',
    'transaction_count'                         => '交易筆數',
    'average_spending_per_account'              => '每個帳戶的平均支出',
    'average_income_per_account'                => '每個帳戶的平均收入',
    'total'                                     => '總計',
    'description'                               => '描述',
    'sum_of_period'                             => '區間內總和',
    'average_in_period'                         => '區間平均',
    'no_account_role'                           => '(沒有角色)',
    'account_role_defaultAsset'                 => '預設資產帳戶',
    'account_role_sharedAsset'                  => '共用資產帳戶',
    'account_role_savingAsset'                  => '儲蓄帳戶',
    'account_role_ccAsset'                      => '信用卡',
    'account_role_cashWalletAsset'              => '現金錢包',
    'budget_chart_click'                        => '點擊上表中的預算名稱以查看圖表。',
    'category_chart_click'                      => '點擊上表中的分類名稱以查看圖表。',
    'in_out_accounts'                           => '賺取與花費（每個組合）',
    'in_out_accounts_per_asset'                 => '每個資產帳戶的收入與支出',
    'in_out_per_category'                       => '每個分類的收入與支出',
    'out_per_budget'                            => '每個預算的支出',
    'select_expense_revenue'                    => '選擇支出 / 收入帳戶',
    'multi_currency_report_sum'                 => '清單中有多種貨幣，因此您所看到的總額僅為參考，報表永遠以您預設的貨幣呈現。',
    'sum_in_default_currency'                   => '所有總額皆以您的預設貨幣顯示',
    'net_filtered_prefs'                        => '此圖表不包含在 “淨值計算” 中已取消勾選的帳戶',


    // charts:
    'chart'                                     => '圖表',
    'month'                                     => '月',
    'budget'                                    => '預算',
    'spent'                                     => '支出',
    'spent_capped'                              => '支出（封頂）',
    'spent_in_budget'                           => '預算內的支出',
    'left_to_spend'                             => '尚可花費',
    'earned'                                    => '收入',
    'overspent'                                 => '超支',
    'left'                                      => '剩餘',
    'max-amount'                                => '最大金額',
    'min-amount'                                => '最小金額',
    'journal-amount'                            => '目前週期性付款記錄',
    'name'                                      => '名稱',
    'expires_at'                                => 'Expires at',
    'date'                                      => '日期',
    'date_and_time'                             => '日期與時間',
    'time'                                      => '時間',
    'paid'                                      => '已付款',
    'unpaid'                                    => '未付款',
    'day'                                       => '日',
    'budgeted'                                  => '已編列預算',
    'period'                                    => '區間',
    'balance'                                   => '餘額',
    'in_out_period'                             => '本期間收入與支出',
    'sum'                                       => '總計',
    'summary'                                   => '概要',
    'average'                                   => '平均',
    'balanceFor'                                => ':name 的餘額',
    'no_tags'                                   => '(無標籤)',
    'nothing_found'                             => '(無相關資料)',

    // page settings and wizard dialogs

    'page_settings_header'          => '頁面設定',
    'visible_columns'               => '可見欄位',
    'accounts_to_show'              => '顯示哪些帳戶',
    'active_accounts_only'          => '僅顯示啟用的帳戶',
    'in_active_accounts_only'       => '僅顯示停用的帳戶',
    'show_all_accounts'             => '顯示所有帳戶',
    'group_accounts'                => '群組帳戶',

    // piggy banks:
    'event_history'                 => '事件歷史',
    'add_money_to_piggy'            => '將金額新增至小豬撲滿「:name」',
    'piggy_bank'                    => '小豬撲滿',
    'new_piggy_bank'                => '新小豬撲滿',
    'store_piggy_bank'              => '儲存新小豬撲滿',
    'stored_piggy_bank'             => '已儲存新的小豬撲滿「:name」',
    'account_status'                => '帳戶狀態',
    'left_for_piggy_banks'          => '已預留給小豬撲滿',
    'sum_of_piggy_banks'            => '小豬撲滿總額',
    'saved_so_far'                  => '已儲存至今',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => '尚可儲蓄',
    'suggested_amount'              => '建議每月儲蓄金額',
    'add_money_to_piggy_title'      => '新增金額至小豬撲滿「:name」',
    'remove_money_from_piggy_title' => '自小豬撲滿「:name」移除金額',
    'add'                           => '新增',
    'no_money_for_piggy'            => '您沒有可放入小豬撲滿的餘額',
    'suggested_savings_per_month'   => '每月建議儲蓄',

    'remove'                    => '移除',
    'max_amount_add'            => '可增加的最大金額',
    'max_amount_remove'         => '可移除的最大金額',
    'update_piggy_button'       => '更新小豬撲滿',
    'update_piggy_title'        => '更新小豬撲滿「:name」',
    'updated_piggy_bank'        => '已更新小豬撲滿「:name」',
    'details'                   => '明細',
    'events'                    => '事件',
    'target_amount'             => '目標金額',
    'start_date'                => '開始日期',
    'no_start_date'             => '無開始日期',
    'target_date'               => '目標日期',
    'no_target_date'            => '無目標日期',
    'table'                     => '表格',
    'delete_piggy_bank'         => '删除小豬撲滿 ":name"',
    'cannot_add_amount_piggy'   => '無法增加 :amount 至 “:name”。',
    'cannot_remove_from_piggy'  => '無法自 “:name” 移除 :amount。',
    'deleted_piggy_bank'        => '删除小豬撲滿 ":name"',
    'added_amount_to_piggy'     => '已新增 :amount 至 “:name”',
    'removed_amount_from_piggy' => '已自 “:name” 移除 :amount',
    'piggy_events'              => '相關的小豬撲滿',

    // tags
    'delete_tag'                => '刪除標籤 ":tag"',
    'deleted_tag'               => '已刪除標籤 ":tag"',
    'new_tag'                   => '建立新標籤',
    'edit_tag'                  => '編輯標籤 ":tag"',
    'updated_tag'               => '已更新標籤 “:tag”',
    'created_tag'               => '標籤 “:tag” 已被建立！',

    'transaction_journal_information'               => '交易資訊',
    'transaction_journal_amount'                    => '金額資訊',
    'transaction_journal_meta'                      => '後設資訊',
    'transaction_journal_more'                      => '更多資訊',
    'basic_journal_information'                     => '基本交易資訊',
    'transaction_journal_extra'                     => '額外資訊',
    'att_part_of_journal'                           => '儲存在 ":journal"',
    'total_amount'                                  => '總金額',
    'number_of_decimals'                            => '小數位數：',


    // administration
    'invite_is_already_redeemed'                    => '給「:address」的邀請已被兌領。',
    'invite_is_deleted'                             => '給「:address」的邀請已被刪除。',
    'invite_new_user_title'                         => '邀請新使用者',
    'invite_new_user_text'                          => '做為管理者，您可邀請使用者於此 Firefly III 安裝註冊。只需將直達連結提供給他們，即可讓他們註冊帳號。所有已邀請的使用者及其邀請連結都會顯示在下表。您可自由分享該邀請連結。',
    'invited_user_mail'                             => '電子郵件地址',
    'invite_user'                                   => '邀請使用者',
    'user_is_invited'                               => '電子郵件地址「:address」已被邀請加入 Firefly III',
    'administration'                                => '管理',
    'system_settings'                               => '系統設定',
    'code_already_used'                             => '該邀請代碼已被使用',
    'user_administration'                           => '使用者管理',
    'list_all_users'                                => '所有使用者',
    'all_users'                                     => '所有使用者',
    'instance_configuration'                        => '組態設定',
    'firefly_instance_configuration'                => 'Firefly III 組態',
    'config_security' => 'Security configuration',
    'config_features' => 'Enabled features',
    'config_tech' => 'Tech related features',
    'config_external_connections' => 'Privacy-sensitive settings (connects to the internet)',

    'setting_enable_exchange_rates' => 'Enable exchange rates',
    'setting_enable_exchange_rates_explain' => 'Firefly III has the capability of calculating exchange rates for you.',
    'setting_use_running_balance' => 'Use "running balance"-column and data',
    'setting_use_running_balance_explain' => 'Firefly III can calculate the current running balance for you, and display this in various places. It is still slightly experimental, so disabled by default. You may need to restart your container or fire the initial command manually (see the docs).',
    'setting_enable_external_map' => 'Use external map service',
    'setting_enable_external_map_explain' => 'Firefly III uses an external service to display locations. Is this OK?',
    'setting_enable_external_rates' => 'Download exchange rates from the web',
    'setting_enable_external_rates_explain' => 'Firefly III can download exchange rates for the built-in currencies. This needs the cron job to work.',
    'setting_allow_webhooks' => 'Allow webhooks',
    'setting_allow_webhooks_explain' => 'Allow Firefly III to fire webhooks?',
    'setting_valid_url_protocols' => 'Allowed URL protocols',
    'setting_valid_url_protocols_explain' => 'Firefly III only allows urls to have standard protocols like https and ftp etc. If you\'re a techie you may want to allow others as well.',


    'setting_single_user_mode'                      => '單使用者模式',
    'setting_single_user_mode_explain'              => '預設下，Firefly III 只接受一個（1）註冊，即您本人。這是一種安全措施，以防止在未經您同意的情況下他人使用此安裝。目前註冊功能已停用。當您取消此方塊後，若他人能存取此安裝（在可連網的情形下），他們就能夠註冊並使用。',
    'store_configuration'                           => '儲存設定',
    'single_user_administration'                    => ':email 的使用者管理後臺',
    'edit_user'                                     => '編輯使用者 :email',
    'hidden_fields_preferences'                     => '您可在 <a href="preferences">偏好設定</a> 中啟用更多交易選項。',
    'user_data_information'                         => '使用者資料',
    'user_information'                              => '使用者資訊',
    'total_size'                                    => '總大小',
    'budget_or_budgets'                             => ':count 個預算|:count 個預算',
    'budgets_with_limits'                           => ':count 個預算有設定金額|:count 個預算有設定金額',
    'nr_of_rules_in_total_groups'                   => '在 :count_groups 個規則群組中，共含 :count_rules 條規則',
    'tag_or_tags'                                   => ':count 個標籤|:count 個標籤',
    'configuration_updated'                         => '已更新組態設定',
    'setting_is_demo_site'                          => '展示網站',
    'setting_is_demo_site_explain'                  => '若您勾選此選項，此安裝將以展示網站模式運作，可能會有一些特殊行為。',
    'block_code_bounced'                            => '電子郵件被退回',
    'block_code_expired'                            => '演示帳戶已過期',
    'no_block_code'                                 => '無封鎖原因或使用者未被封鎖',
    'demo_user_export'                              => '展示用戶無法匯出資料',
    'block_code_email_changed'                      => '使用者尚未確認新的電子郵件地址',
    'admin_update_email'                            => '與個人檔案頁面不同，此操作不會通知使用者其電子郵件地址已改變！',
    'update_user'                                   => '更新使用者',
    'updated_user'                                  => '使用者資料已更改。',
    'delete_user'                                   => '刪除使用者 :email',
    'user_deleted'                                  => '使用者已被刪除',
    'send_test_email'                               => '寄送測試電子郵件訊息',
    'send_test_email_text'                          => '若要測試您的安裝是否能寄送通知，請按下此按鈕。若有錯誤，此處不會顯示（若有問題），<strong>您可於日誌檔查看錯誤</strong>。您可無限制地多次按下此按鈕。沒有垃圾郵件防制。此訊息將寄送到 <code>:email</code>，應能在稍後送達。',
    'send_message'                                  => '傳送訊息',
    'send_test_triggered'                           => '測試已觸發，請檢查收件匣與日誌檔。',
    'give_admin_careful'                            => '若授予使用者管理者權限，他們可移除您的權限。請小心！',
    'admin_maintanance_title'                       => '維護',
    'admin_maintanance_expl'                        => 'Firefly III 維護操作的便捷按鈕',
    'admin_maintenance_clear_cache'                 => '清除快取',
    'owner_notifications'                           => '管理者通知',
    'owner_notifications_expl'                      => '管理者可啟用或停用以下通知。這些通知會透過所有已設定的管道送出。有些管道設定於您的環境變數，另一些可於此配置。',
    'channel_settings'                              => '通知管道設定',
    'notification_test_failed'                      => '通知管道「:channel」的測試失敗。請查看日誌以了解更多資訊。',
    'notification_test_executed'                    => '通知管道「:channel」的測試已執行。請查看日誌以了解詳細資訊。',
    'settings_notifications'                        => '通知設定',
    'title_owner_notifications'                     => '管理者通知',
    'owner_notification_check_user_new_reg'         => '當使用者註冊後接收歡迎訊息',
    'owner_notification_check_admin_new_reg'        => '當有新使用者註冊時，管理者接收通知',
    'owner_notification_check_new_version'          => '有可用的新版本',
    'owner_notification_check_invite_created'       => '使用者已被邀請加入 Firefly III',
    'owner_notification_check_invite_redeemed'      => '使用者已使用邀請連結',
    'owner_notification_check_unknown_user_attempt' => '未知使用者嘗試登入',
    'all_invited_users'                             => '所有被邀請的使用者',
    'save_notification_settings'                    => '儲存設定',
    'notification_settings'                         => '通知設定',
    'notification_settings_saved'                   => '通知設定已儲存',
    'available_channels_title'                      => '可用的通知管道',
    'available_channels_expl'                       => '以下管道可用於傳送通知。若要測試設定，可使用下方按鈕。請注意此按鈕並無垃圾郵件防制。',
    'notification_channel_name_email'               => '電子郵件',
    'slack_discord_double'                          => 'Slack 通知管道亦可傳送通知至 Discord。',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => '不可用',
    'configure_channel_in_env'                      => '需要環境變數配置',
    'test_notification_channel_name_email'          => '測試電子郵件',
    'test_notification_channel_name_slack'          => '測試 Slack',
    'test_notification_channel_name_ntfy'           => '測試 Ntfy.sh',
    'test_notification_channel_name_pushover'       => '測試 Pushover',
    'test_notification_channel_name_gotify'         => '測試 Gotify',
    'test_notification_channel_name_pushbullet'     => '測試 Pushbullet',

    'split_transaction_title'               => '拆分交易的描述',
    'split_transaction_title_help'          => '若您建立一筆拆分交易，需要整體描述以表示這些拆分都屬於同一筆交易。',
    'split_title_help'                      => '若您建立一筆拆分交易，須有一個有關交易所有拆分的整體描述。',
    'you_create_transfer'                   => '您正在建立一筆轉帳。',
    'you_create_withdrawal'                 => '您正在建立一筆提款。',
    'you_create_deposit'                    => '您正在建立一筆存款。',

    // links
    'journal_link_configuration'            => '交易連結設定',
    'create_new_link_type'                  => '建立新連結類型',
    'store_new_link_type'                   => '儲存新連結類型',
    'update_link_type'                      => '更新連結類型',
    'edit_link_type'                        => '編輯連結類型 ":name"',
    'updated_link_type'                     => '更新連結類型 ":name"',
    'delete_link_type'                      => '刪除連結類型 ":name"',
    'deleted_link_type'                     => '刪除連結類型 ":name"',
    'stored_new_link_type'                  => '新建連結類型 ":name"',
    'cannot_edit_link_type'                 => '無法編輯連結類型 ":name"',
    'link_type_help_name'                   => '例如「重複」',
    'link_type_help_inward'                 => '例如「因為重複」',
    'link_type_help_outward'                => '例如「為重複，故…」',
    'save_connections_by_moving'            => '透過將這些交易移至其他連結類型來儲存它們的連結：',
    'do_not_save_connection'                => '（不儲存此連結）',
    'link_transaction'                      => '連結交易',
    'link_to_other_transaction'             => '連結至其他交易',
    'select_transaction_to_link'            => '選擇一筆交易以與此交易鏈結。此連結目前僅作為顯示用途，未來可能有更多功能。請使用搜索欄以交易標題或 ID 進行篩選。若需要自訂連結類型，可於設定中新增。',
    'this_transaction'                      => '此交易',
    'transaction'                           => '交易',
    'comments'                              => '評論',
    'link_notes'                            => '您想與此連結一同儲存的任何備註。',
    'invalid_link_selection'                => '無法連結這些交易。',
    'selected_transaction'                  => '已選擇交易',
    'journals_linked'                       => '交易已連結。',
    'journals_error_linked'                 => '這些交易彼此已連結',
    'journals_link_to_self'                 => '您不能將交易連結至自身',
    'journal_links'                         => '交易連結',
    'this_withdrawal'                       => '此提款',
    'this_deposit'                          => '此存款',
    'this_transfer'                         => '此轉帳',
    'overview_for_link'                     => '連結類型「:name」的總覽',
    'source_transaction'                    => '來源交易',
    'link_description'                      => '連結描述',
    'destination_transaction'               => '目標交易',
    'delete_journal_link'                   => '刪除 <a href=":source_link">:source</a> 與 <a href=":destination_link">:destination</a> 間的連結',
    'deleted_link'                          => '連結已刪除',

    // link translations:
    'Paid_name'                             => '已付款',
    'Refund_name'                           => '退款',
    'Reimbursement_name'                    => '報銷',
    'Related_name'                          => '相關',
    'relates to_inward'                     => '關聯於',
    'is (partially) refunded by_inward'     => '被（部分）退還，由',
    'is (partially) paid for by_inward'     => '被（部分）支付，由',
    'is (partially) reimbursed by_inward'   => '被（部分）報銷，由',
    'inward_transaction'                    => '內向交易',
    'outward_transaction'                   => '外向交易',
    'relates to_outward'                    => '關聯於',
    '(partially) refunds_outward'           => '(部分) 退還',
    '(partially) pays for_outward'          => '(部分) 支付',
    '(partially) reimburses_outward'        => '（部分）報銷',
    'is (partially) refunded by'            => '被（部分）退款',
    'is (partially) paid for by'            => '被（部分）支付',
    'is (partially) reimbursed by'          => '被（部分）報銷',
    'relates to'                            => '關聯於',
    '(partially) refunds'                   => '（部分）退款',
    '(partially) pays for'                  => '（部分）支付',
    '(partially) reimburses'                => '（部分）報銷',

    // split a transaction:
    'splits'                                => '拆分',
    'add_another_split'                     => '新增拆分',
    'cannot_edit_opening_balance'           => '您無法編輯帳戶的開戶餘額交易。',
    'no_edit_multiple_left'                 => '沒有可批次編輯的有效交易。',
    'breadcrumb_convert_group'              => '轉換交易',
    'convert_invalid_source'                => '對交易 #%d 的來源資訊無效。',
    'convert_invalid_destination'           => '對交易 #%d 的目標資訊無效。',
    'create_another'                        => '儲存後返回此頁以建立新交易',
    'after_update_create_another'           => '更新後繼續此頁以持續編輯',
    'store_as_new'                          => '儲存為新交易，而非更新',
    'reset_after'                           => '送出後重設表單',
    'errors_submission'                     => '送出資料時發生錯誤，請檢查下列訊息。',
    'errors_submission_v2'                  => '送出資料時發生錯誤，請檢查下列訊息：{{errorMessage}}',
    'transaction_expand_split'              => '展開拆分',
    'transaction_remove_split'              => '移除拆分',
    'transaction_collapse_split'            => '收起拆分',

    // object groups
    'default_group_title_name'              => '(未分組)',
    'default_group_title_name_plain'        => '未分組',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => '建立新資產帳戶',
    'no_accounts_intro_asset'               => '您尚無資產帳戶。資產帳戶可包含您的支票帳戶、儲蓄帳戶、共用帳戶，甚至是信用卡。',
    'no_accounts_imperative_asset'          => '要開始使用 Firefly III，您至少需要一個資產帳戶。立即新增：',
    'no_accounts_create_asset'              => '建立新資產帳戶',
    'no_accounts_title_expense'             => '建立新支出帳戶',
    'no_accounts_intro_expense'             => '您目前沒有支出帳戶。支出帳戶為您花錢的地方，例如超市或商店。',
    'no_accounts_imperative_expense'        => '在建立交易時可自動產生支出帳戶，但您也能手動新增。現在就建立：',
    'no_accounts_create_expense'            => '建立新支出帳戶',
    'no_accounts_title_revenue'             => '建立新收入帳戶',
    'no_accounts_intro_revenue'             => '您還沒有收入帳戶，收入帳戶為您收款的地方，如雇主。',
    'no_accounts_imperative_revenue'        => '建立交易時可自動產生收入帳戶，但您也能手動新增。現在就建立：',
    'no_accounts_create_revenue'            => '建立新收入帳戶',
    'no_accounts_title_liabilities'         => '建立一筆債務吧！',
    'no_accounts_intro_liabilities'         => '您目前沒有債務帳戶，這些帳戶可用以記錄（學生）貸款或其他借貸項目。',
    'no_accounts_imperative_liabilities'    => '雖然您不一定需要此功能，但若要追蹤貸款或負債，此功能將非常實用。',
    'no_accounts_create_liabilities'        => '建立新債務',
    'no_budgets_title_default'              => '建立預算',
    'no_rules_title_default'                => '建立規則',
    'no_budgets_intro_default'              => '您目前沒有預算。預算能協助您將支出歸類並做出花費上限設定（軟性限制）。',
    'no_rules_intro_default'                => '您目前沒有規則。規則能自動化管理交易，是非常強大的功能。',
    'no_rules_imperative_default'           => '當管理交易時，規則相當方便。讓我們立即建立一個：',
    'no_budgets_imperative_default'         => '預算是管理財務的基本工具，現在就建立一個預算：',
    'no_budgets_create_default'             => '建立新預算',
    'no_rules_create_default'               => '建立規則',
    'no_categories_title_default'           => '建立新分類吧！',
    'no_categories_intro_default'           => '您還沒有任何分類。分類能協助您細分交易並進行標示。',
    'no_categories_imperative_default'      => '在建立交易時可自動產生分類，也可以手動新增。現在就建立：',
    'no_categories_create_default'          => '建立分類',
    'no_tags_title_default'                 => '建立新標籤吧！',
    'no_tags_intro_default'                 => '您還沒有任何標籤。標籤能協助您細分交易並進行特殊標示。',
    'no_tags_imperative_default'            => '在建立交易時可自動產生標籤，也可以手動新增。現在就建立：',
    'no_tags_create_default'                => '建立標籤',
    'no_transactions_title_withdrawal'      => '新增支出',
    'no_transactions_intro_withdrawal'      => '您目前沒有任何支出。建立支出能開始追蹤您的金錢流向。',
    'no_transactions_imperative_withdrawal' => '您有花費嗎？將其記錄下來：',
    'no_transactions_create_withdrawal'     => '新增支出',
    'no_transactions_title_deposit'         => '建立新收入',
    'no_transactions_intro_deposit'         => '目前沒有任何收入記錄。建立收入能開始追蹤您的金錢流向。',
    'no_transactions_imperative_deposit'    => '您有收到一些錢嗎？將其記錄下來：',
    'no_transactions_create_deposit'        => '新增存款',
    'no_transactions_title_transfers'       => '建立轉帳',
    'no_transactions_intro_transfers'       => '您目前沒有任何轉帳記錄。從一個資產帳戶移動金錢到另一個帳戶即是一筆轉帳。',
    'no_transactions_imperative_transfers'  => '若您移動了一筆金錢，也可將其記錄下來：',
    'no_transactions_create_transfers'      => '新增轉帳',
    'no_piggies_title_default'              => '建立小豬撲滿',
    'no_piggies_intro_default'              => '您尚未建立任何小豬撲滿。小豬撲滿讓您追蹤並儲存特定目標的金錢。',
    'no_piggies_imperative_default'         => '想要儲蓄嗎？建立小豬撲滿並開始追蹤：',
    'no_piggies_create_default'             => '建立新小豬撲滿',
    'no_bills_title_default'                => '建立週期性付款',
    'no_bills_intro_default'                => '您目前沒有任何週期性付款（subscriptions）。此功能可以幫助您管理房租、保險等定期支出。',
    'no_bills_imperative_default'           => '您是否有定期付款？立即建立一筆週期性付款並追蹤每次支付：',
    'no_bills_create_default'               => '建立週期性付款',

    // recurring transactions
    'recurrence_max_count'                  => '此週期性交易最多會建立 :max 次，已經建立過 :count 次。',
    'create_right_now'                      => '立即建立',
    'no_new_transaction_in_recurrence'      => '未建立新交易。也許該日期的交易已自動執行？',
    'recurrences'                           => '週期性交易',
    'repeat_until_in_past'                  => '此週期性交易已於 :date 停止重複。',
    'recurring_calendar_view'               => '月曆',
    'no_recurring_title_default'            => '建立一筆週期性交易吧！',
    'no_recurring_intro_default'            => '您目前沒有週期性交易。這樣的功能可以讓 Firefly III 自動建立交易，並簡化重複性工作。',
    'no_recurring_imperative_default'       => '這是一個進階且非常實用的功能。請在使用前先參閱右上方 (?) 的說明文件！',
    'no_recurring_create_default'           => '建立週期性交易',
    'make_new_recurring'                    => '建立新週期性交易',
    'recurring_daily'                       => '每天',
    'recurring_weekly'                      => '每星期:weekday',
    'recurring_weekly_skip'                 => '每 :skip 週於:weekday',
    'recurring_monthly'                     => '於每月第 :dayOfMonth 天',
    'recurring_monthly_skip'                => '每 :skip 個月，於第 :dayOfMonth 天',
    'recurring_ndom'                        => '於每月第 :dayOfMonth 個 :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => '每年:date',
    'overview_for_recurrence'               => '週期性交易「:title」概覽',
    'warning_duplicates_repetitions'        => '在少數情況下，相同日期可能在清單上出現兩次，這是當多條重複週期衝突時才會發生。Firefly III 每天僅建立一次紀錄。',
    'created_transactions'                  => '關聯交易',
    'expected_withdrawals'                  => '預期提款',
    'expected_deposits'                     => '預期存款',
    'expected_transfers'                    => '預期轉帳',
    'created_withdrawals'                   => '已建立的提款',
    'created_deposits'                      => '已建立的存款',
    'created_transfers'                     => '已建立的轉帳',
    'recurring_info'                        => '週期性交易 :count / :total',
    'created_from_recurrence'               => '由週期性交易「:title」(#:id) 建立',
    'recurring_never_cron'                  => '負責週期性交易的 cron job 尚未運行。這對於剛安裝 Firefly III 的情況是正常的，但建議盡早設定。請參閱右上方 (?) 按鈕下的說明文件。',
    'recurring_cron_long_ago'               => '負責週期性交易的 cron job 超過 36 小時未運行。請確認您已正確設定。詳見右上方 (?) 的說明文件。',

    'create_new_recurrence'              => '建立新週期性交易',
    'help_first_date'                    => '顯示第一筆預期執行的週期性交易之日期，應該是未來的時間點。',
    'help_first_date_no_past'            => '此日期為週期性交易的初始日期，Firefly III 不會為過去的日期建立交易。',
    'no_currency'                        => '(沒有貨幣)',
    'mandatory_for_recurring'            => '必填的週期性資訊',
    'mandatory_for_transaction'          => '必填的交易資訊',
    'optional_for_recurring'             => '選填的週期性資訊',
    'optional_for_transaction'           => '選填的交易資訊',
    'change_date_other_options'          => '若更改了「第一個日期」，或許會有更多可用選項。',
    'mandatory_fields_for_tranaction'    => '此處的設定在建完交易後才會停止。',
    'click_for_calendar'                 => '點此以顯示週期性交易的月曆',
    'repeat_forever'                     => '永遠重複',
    'repeat_until_date'                  => '重複至指定日期',
    'repeat_times'                       => '重複固定次數',
    'recurring_skips_one'                => '每隔一個',
    'recurring_skips_more'               => '每隔 :count 個',
    'store_new_recurrence'               => '儲存週期性交易',
    'stored_new_recurrence'              => '已成功儲存週期性交易「:title」',
    'edit_recurrence'                    => '編輯週期性交易「:title」',
    'recurring_repeats_until'            => '重複至 :date',
    'recurring_repeats_forever'          => '永遠重複',
    'recurring_repeats_x_times'          => '重複 :count 次|重複 :count 次',
    'update_recurrence'                  => '更新週期性交易',
    'updated_recurrence'                 => '已更新週期性交易 :title',
    'recurrence_is_inactive'             => '此週期性交易為停用狀態，不會自動產生新交易。',
    'delete_recurring'                   => '刪除週期性交易「:title」',
    'new_recurring_transaction'          => '新週期性交易',
    'help_weekend'                       => '若週期性交易的日期落在週末，Firefly III 該如何處理？',
    'do_nothing'                         => '仍於週末建立交易',
    'skip_transaction'                   => '跳過該筆交易',
    'jump_to_friday'                     => '將交易移至前一個星期五',
    'jump_to_monday'                     => '將交易移至後一個星期一',
    'will_jump_friday'                   => '將於週五建立交易，而非週末。',
    'will_jump_monday'                   => '將於週一建立交易，而非週末。',
    'except_weekends'                    => '週末例外',
    'recurrence_deleted'                 => '週期性交易「:title」已刪除',


    // new lines for summary controller.
    'box_balance_in_currency'            => '餘額（:currency）',
    'box_spent_in_currency'              => '支出（:currency）',
    'box_earned_in_currency'             => '收入（:currency）',
    'box_budgeted_in_currency'           => '預算總額（:currency）',
    'box_bill_paid_in_currency'          => '已支付的週期性付款（:currency）',
    'box_bill_unpaid_in_currency'        => '未支付的週期性付款（:currency）',
    'box_left_to_spend_in_currency'      => '剩餘可花費（:currency）',
    'box_net_worth_in_currency'          => '淨值（:currency）',
    'box_spend_per_day'                  => '每日可花費：:amount',

    // debug page
    'debug_page'                         => '除錯頁面',
    'debug_submit_instructions'          => '若您遇到問題，可使用此欄位內容做為除錯資訊。請將其複製貼上至 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a> 中（新開或既有的都行）。將會產生一個表格，方便更快診斷問題。',
    'debug_pretty_table'                 => '若您直接將下方文字複製貼上至 GitHub issue，會產生一個表格。請勿再加上任何額外的 backticks 或引號。',
    'debug_additional_data'              => '您也可以提供下方欄位的內容，並同樣貼於 <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>。但該內容可能包含私人資訊（例如帳戶名稱、交易細節或電子郵件地址）。請自行斟酌。',

    // object groups
    'object_groups_menu_bar'             => '群組',
    'object_groups_page_title'           => '群組',
    'object_groups_breadcrumb'           => '群組',
    'object_groups_index'                => '群組總覽',
    'object_groups'                      => '群組',
    'object_groups_empty_explain'        => '在 Firefly III 中，一些項目可以被分組。舉例來說，小豬撲滿的編輯與建立頁面中有「群組」欄位。若您設置了該欄位，可以在此頁編輯群組名稱與順序。詳情請見右上角 (?) 按鈕下的說明文件。',
    'object_group_title'                 => '標題',
    'edit_object_group'                  => '編輯群組「:title」',
    'delete_object_group'                => '刪除群組「:title」',
    'update_object_group'                => '更新群組',
    'updated_object_group'               => '已成功更新群組「:title」',
    'deleted_object_group'               => '已成功刪除群組「:title」',
    'object_group'                       => '群組',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'incomplete_ale' => 'Not all events are recorded as audit log entries.',
    'audit_log_entries'                  => '稽核日誌項目',
    'ale_action_log_add'                 => '已新增 :amount 至小豬撲滿「:name」',
    'ale_action_log_remove'              => '已自小豬撲滿「:name」移除 :amount',
    'ale_action_clear_budget'            => '已從預算中移除',
    'ale_action_update_group_title'      => '已更新交易群組標題',
    'ale_action_update_date'             => '已更新交易日期',
    'ale_action_update_order'            => '已更新交易順序',
    'ale_action_clear_category'          => '已自分類中移除',
    'ale_action_clear_notes'             => '已移除備註',
    'ale_action_clear_tag'               => '已清除標籤',
    'ale_action_clear_all_tags'          => '已清除全部標籤',
    'ale_action_set_bill'                => '已連結至週期性付款',
    'ale_action_switch_accounts'         => '已交換來源帳戶與目標帳戶',
    'ale_action_set_budget'              => '已設定預算',
    'ale_action_set_category'            => '已設定分類',
    'ale_action_set_source'              => '已設定來源帳戶',
    'ale_action_set_destination'         => '已設定目標帳戶',
    'ale_action_update_transaction_type' => '已更改交易類型',
    'ale_action_update_notes'            => '已更新備註',
    'ale_action_update_description'      => '已更新描述',
    'ale_action_add_to_piggy'            => '小豬撲滿',
    'ale_action_remove_from_piggy'       => '小豬撲滿',
    'ale_action_add_tag'                 => '已新增標籤',
    'ale_action_update_amount'           => '已更新金額',

    // dashboard
    'enable_auto_convert'                => '啟用貨幣自動換算',
    'disable_auto_convert'               => '停用貨幣自動換算',
];
