<?php
    session_start();
    include_once('admin/db/saucerer.php');
?>

<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <link rel="icon" href="image/favicon/1.png" type="image/png">
        <title>FitBora &copy;</title>

    <link rel="canonical" href="https://fitbora.net">

    <meta name="description" content="The fitness & wellness network">

    <meta name="keywords" content="Gyms, Health Clubs, Spas, Massage Parlors, Physiotherapists, Sports Clubs, Dance Clubs, Trainers, Dieticians, Technicians, Consultants, Swimming Pools, Suppliers, Kampala, Uganda">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://fitbora.net/image/card/1.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="FitBora &copy;">

    <meta property="og:url" content="https://fitbora.net">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="The fitness & wellness network">

    <meta property="og:site_name" content="FitBora &copy;">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://fitbora.net">

    <meta name="twitter:title" content="FitBora &copy;">

    <meta name="twitter:description" content="The fitness & wellness network">

    <meta name="twitter:image" content="https://fitbora.net/image/card/1.png">

    <meta name="twitter:site" content="@fitbora">

    <meta name="twitter:creator" content="@iann_thecreator">


        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="css/bootstrap.css">
        <link rel="stylesheet" href="vendors/linericon/style.css">
        <link rel="stylesheet" href="css/font-awesome.min.css">
        <link rel="stylesheet" href="vendors/owl-carousel/owl.carousel.min.css">
        <link rel="stylesheet" href="vendors/bootstrap-datepicker/bootstrap-datetimepicker.min.css">
        <link rel="stylesheet" href="vendors/nice-select/css/nice-select.css">
        <link rel="stylesheet" href="vendors/owl-carousel/owl.carousel.min.css">
        <!-- main css -->
        <link rel="stylesheet" href="css/style.css">
        <link rel="stylesheet" href="css/responsive.css">

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="css/fontawesome/css/all.css" rel="stylesheet">  


    </head>
    <body>
        <!--================Header Area =================-->
        <header class="header_area">
            <div class="container">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <!-- Brand and toggle get grouped for better mobile display -->
                    <a class="navbar-brand logo_h" href="./"><img src="image/logo.png" alt=""></a>

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse offset" id="navbarSupportedContent">
                        <ul class="nav navbar-nav menu_nav ml-auto">
                            <li class="nav-item active"><a class="nav-link" href="./">Home</a></li> 
                            <li class="nav-item submenu dropdown">
                                <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Directories</a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item"><a class="nav-link" href="listings">All Listings</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Gyms">Gyms</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Health Clubs">Health Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Spas">Spas</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Massage Parlors">Massage Parlors</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Physiotherapists">Physiotherapists</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Dance Clubs">Dance Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Sports Clubs">Sports Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Trainers">Trainers</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Dieticians">Dieticians</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Technicians">Technicians</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Consultants">Consultants</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Swimming Pools">Swimming Pools</a></li>
                                    <li class="nav-item"><a class="nav-link" href="listings/Equipment Suppliers">Equipment Suppliers</a></li>
                                </ul>
                            </li> 
                            <li class="nav-item submenu dropdown">
                                <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Categories</a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item"><a class="nav-link" href="categories">All Categories</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Fitness">Fitness</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Wellness">Wellness</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Massage">Massage</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Steam Bath">Steam Bath</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Sauna">Sauna</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Dance">Dance</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Sports">Sports</a></li>
                                    <li class="nav-item"><a class="nav-link" href="categories/Experts">Experts</a></li>
                                </ul>
                            </li> 
                            <li class="nav-item"><a class="nav-link" href="blog">Blog</a></li>
                            <li class="nav-item"><a class="nav-link" href="events">Events</a></li>
                            <li class="nav-item"><a class="nav-link" href="about">About Us</a></li>
                            <li class="nav-item"><a class="nav-link" href="contact">Contact Us</a></li>
                        </ul>
                    </div> 
                </nav>
            </div>
        </header>
        <!--================Header Area =================--> 

        <!--================Banner Area =================-->
        <section class="banner_area">
            <div class="booking_table d_flex align-items-center">
            	<div class="overlay bg-parallax" data-stellar-ratio="0.9" data-stellar-vertical-offset="0" data-background=""></div>
				<div class="container">
					<div class="banner_content text-center">

                    <div class="row">
                        <div class="col-lg-8 col-sm-12 col-md-6">
                         <div class="slider-icons">
                            <p class="text-uppercase">Find <b>&</b> explore</p>
                            <h4>Top <span>gyms, spas</span> & so much more</h4>
                            <img src="image/icons/main-arrow.png">
                           <div class="icon_slider owl-carousel">
                               <a href="listings/Gyms" class="one"><i class="fa fa-dumbbell"></i> Gyms</a>
                               <a href="listings/Health Clubs" class="two"><i class="fa fa-heartbeat"></i> Health</a>
                               <a href="listings/Spas" class="three"><i class="fa fa-spa"></i> Spas</a>
                               <a href="listings/Massage Parlors" class="four"><i class="fa fa-ranking-star"></i> Parlors</a>
                               <a href="listings/Physiotherapists" class="five"><i class="fa fa-hiking"></i> Physio</a>
                               <a href="listings/Dance Clubs" class="six"><i class="fa fa-icons"></i> Dance</a>
                               <a href="listings/Sports Clubs" class="seven"><i class="fa fa-futbol"></i> Sports</a>
                               <a href="listings/Trainers" class="eight"><i class="fa fa-running"></i> Trainers</a>
                               <a href="listings/Dieticians" class="nine"><i class="fa fa-stopwatch-20"></i> Dieticians</a>
                               <a href="listings/Technicians" class="ten"><i class="fa fa-toolbox"></i> Technicians</a>
                               <a href="listings/Consultants" class="eleven"><i class="fa fa-medal"></i> Consultants</a>
                               <a href="listings/Swimming Pools" class="twelve"><i class="fa fa-swimmer"></i> Swimming</a>
                               <a href="listings/Equipment Suppliers" class="thirteen"><i class="fa fa-biking"></i> Suppliers</a>
                           </div>
                         </div>
                        </div>

                        <div class="col-lg-4 col-sm-12 col-md-6">
                            
                    <div class="hotel_booking_table one row">
                        <div class="col-md-12">
                            <div class="boking_table">
                                <div class="row">
                            <h2>Find the right listing.<span class="flash">.</span></h2>

                                    <div class="col-md-12">
                                        <div class="book_tabel_item">
                                            <form action="listings/search/index.php" method="post" enctype="multipart/form-data">
                                            <div class="form-group">
                                                <p>Title</p>
                                                <div class='input-group'>
                                                    <input type='text' name="valueToSearch" class="form-control" placeholder="What are you looking for?" required />
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="book_tabel_item">
                                                <p>Select Category</p>
                                            <div class="input-group">
                                                <select class="wide" name="category">
                                                    <option value="" data-display="Business Category">Business Category</option>
                                                    <option>Fitness</option>
                                                    <option>Wellness</option>
                                                    <option>Massage</option>
                                                    <option>Steam Bath</option>
                                                    <option>Sauna</option>
                                                    <option>Dance</option>
                                                    <option>Sports</option>
                                                    <option>Experts</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="book_tabel_item">
                                            <div class="form-group">
                                                <p>By Location</p>
                                                <div class='input-group'>
                                                    <input type='text' name="location" class="form-control" placeholder="Location.." />
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="book_tabel_item">
                                            <input type="submit" name="search" class="book_now_btn button_hover" value="Search">
                                        </div>
                                    </div>
                                </form>
                                </div>
                            </div>
                        </div>
                    </div>
                        </div>

                    </div>

					</div>
				</div>

            </div>

        </section>
        <!--================Banner Area =================-->

                
        <!--================ Explore Area Start  =================-->
        <section class="latest_blog_area one two">
            <div class="container">
                <div class="section_title one text-center">
                    <p class="text-uppercase" style="font-size: 18px;">Featured Cities</p>
                    <h2 class="title_color" style="font-size: 18px;">Explore Swimming Pools, Trainers & Consultants</h2>
                    <hr>

<?php

    $sql = "SELECT * FROM listings WHERE deleted=''";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    if($query->fetch_assoc()==0){
        echo '<p style="font-size: 18px;">Something exciting is coming soon, kindly scrolling for more <i class="fa fa-caret-down ml-2 float-bounce"></i></p>';
        echo '<video autoplay loop muted width="300px">
              <source src="image/motion/4.mp4">
              <video>';
    }
?>
                </div>
                <div class="row mb_30">

                    
<?php

    $sql = "SELECT COUNT(*), district, image FROM listings WHERE deleted='' GROUP BY district ORDER BY id DESC LIMIT 3";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="col-lg-4 col-md-4 col-sm-4">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                              echo '<a href="districts/ug/?district='.$row["district"].'">';
                                echo '<img class="img-fluid" src="admin/listings/images/'.$row["image"].'" alt="'.$row["district"].'">';
                                echo '<div class="thumb-title"><h4 class="sec_h4">'.$row["district"].'</h4> <hr></div>';
                                echo '<p><i class="fa fa-map-marker"></i>';
                                if ($row["COUNT(*)"]==1) {
                                    echo ''.$row["COUNT(*)"].' Listing';
                                } else {
                                    echo ''.$row["COUNT(*)"].' Listings';
                                }
                                 echo '</p>';
                              echo '</a>';
                            echo '</div> '; 
                        echo '</div>';
                    echo '</div>';
    }

?>


                </div>

            <div align="center" class="mt-5"><a href="districts" class="button_hover theme_btn">Discover More <i class="fa fa-caret-right ml-2 float-bounce-right"></i></a></div>

            </div>
        </section>
        <!--================ Explore Area End  =================-->



            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->



        <!--================ Featured Listings Start =================-->
        <section class="latest_blog_area section_gap one listings">
            <div class="container">
                <div class="section_title text-center">
                    <h2 class="title_color">FEATURED LISTINGS</h2>
                    <hr>

<?php

    $sql = "SELECT * FROM listings WHERE deleted=''";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    if($query->fetch_assoc()==0){
        echo '<p style="font-size: 18px;">Something exciting is coming soon, kindly scrolling for more <i class="fa fa-caret-down ml-2 float-bounce"></i></p>';
        echo '<video autoplay loop muted width="300px">
              <source src="image/motion/6.mp4">
              <video>';
    }
?>
                </div>
                <div class="row mb_30 saucerer_slider owl-carousel">

                                        
<?php

    $sql = "SELECT * FROM listings WHERE deleted='' ORDER BY id DESC";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        if ($row["g_maps"]) {
            $g_maps = $row["g_maps"];
        } else {
            $g_maps = '#!';
        }

        if ($row["hr_open"]!='00:00:00') {
            $hr_open = date("h:ia", strtotime($row["hr_open"]));

            if ($row["hr_close"]!='00:00:00') {
                $hr_close = '- '.date("h:ia", strtotime($row["hr_close"])).'';
            } else {
                $hr_close = '';
            }
        } else {
            $hr_open = '09:00am';
            $hr_close = '';
        }

        echo '<div class="col-lg-12 col-md-12 col-sm-12">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                                echo '<img class="img-fluid" src="admin/listings/images/'.$row["image"].'" alt="fitbora fitness">';
                                echo '<a href="tel:'.$row["phone"].'"><i class="fa fa-phone"></i></a>';
                                echo '<a href="listings/1/?listing='.$row["url"].'"><i class="fa fa-caret-right"></i></a>';
                            echo '</div>';
                            echo '<div class="details">';
                                echo '<a href="listings/1/?listing='.$row["url"].'"><h4 class="sec_h4">'.$row["title"].'</h4></a>';
                                echo '<p><a href="listings/'.$row["sub"].'s">'.$row["sub"].'</a>&nbsp; | &nbsp;<a href="categories/'.$row["cat"].'">'.$row["cat"].'</a></p>';
                                echo '<p>'.$row["services"].'</p>';
                                echo '<p><a href="'.$g_maps.'"><i class="fa fa-map-marker mr-1"></i> '.$row["address"].', '.$row["district"].'</a></p>';
                            echo '</div>';  

                            echo '<div class="one-footer">';
                                echo '<div class="row">';
                                    echo '<div class="col-md-12 col-sm-12 col-12">';
                                        echo '<p class="ml-4 mt-3"><i class="fa fa-clock-o mr-1"></i> '.$hr_open.' '.$hr_close.'</p>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';

                        echo '</div>';
                    echo '</div>';
    }

?>


                </div>

            <div align="center" class="mt-5"><a href="listings" class="button_hover theme_btn">SEE ALL LISTINGS <i class="fa fa-caret-right ml-2 float-bounce-right"></i></a></div>
            </div>
        </section>
        <!--================ Featured Listings  End =================-->


            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


        
        <!--================ Blog Area Start =================-->
         <section class="latest_blog_area one two">
            <div class="container">
                <div class="section_title one text-center">
                    <p class="text-uppercase" style="font-size: 18px;">Available Categories</p>
                    <hr>

<?php

    $sql = "SELECT * FROM listings WHERE deleted=''";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    if($query->fetch_assoc()==0){
        echo '<p style="font-size: 18px;">Something exciting is coming soon, kindly scrolling for more <i class="fa fa-caret-down ml-2 float-bounce"></i></p>';
        echo '<video autoplay loop muted width="300px">
              <source src="image/motion/2.mp4">
              <video>';
    }
?>
                </div>
                <div class="row mb_30 category_slider owl-carousel">

<?php

    $sql = "SELECT COUNT(*), cat, image FROM listings WHERE deleted='' GROUP BY cat ORDER BY COUNT(*) DESC";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="col-lg-12 col-md-12 col-sm-12">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                              echo '<a href="categories/'.$row["cat"].'">';
                                echo '<img class="img-fluid" src="admin/listings/images/'.$row["image"].'" alt="'.$row["cat"].'">';
                                echo '<div class="thumb-title"><h4 class="sec_h4 text-uppercase">'.$row["cat"].'</h4> <hr></div>';
                                echo '<p><i class="fa fa-map-marker"></i>';
        if ($row['COUNT(*)']==0) {
            echo "No listings";
        } elseif ($row['COUNT(*)']==1) {
            echo "".number_format($row['COUNT(*)'])." Listing";
        } else {
            echo "".number_format($row['COUNT(*)'])." Listings";
        }
                                 echo '</p>';
                              echo '</a>';
                            echo '</div>'; 
                        echo '</div>';
                    echo '</div>';
        }

?>

                </div>
            </div>
        </section>
        <!--================ Blog Area  End =================-->


            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


        
        <!--================ Events Box Start  =================-->
        <div class="event-box"></div>
        <!--================ Events Box End  =================-->



            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


        
        <!--================ About History Area  =================-->
        <section class="about_history_area one section_gap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-12 d_flex align-items-center">
                        <div class="about_content ">
                            <i>Let's uncover the best places</i>
                            <h2 class="title title_color">Discover Interesting Fitness Centers Around You</h2>
                            <p>Whether you're seeking a soothing massage, a revitalizing facial, or a complete wellness makeover, FitBora helps you make informed choices and discover exceptional experiences tailored to your needs. <br> <br>
                            Indulge in the pampering and self-care you deserve with ease and confidence, thanks to FitBora.</p>

                  <div class="col-md-12 lower">
                <div class="row">

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-layer-group"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Choose A Category</h4>
                        <p>Select through a variety of our curated selections</p>
                    </div>

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-map-location"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Find What You Want</h4>
                        <p>Explore various fitness and wellness options & compare features</p>
                    </div>

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-handshake"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Trusted Locals</h4>
                        <p>Choose the right fitness center or professional for you</p>
                    </div>

                  </div>
                </div>
                
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 col-12 about-grid">
                        <div class="about-float"><a href="listings"><div>Explore Listings</div></a></div>
                        <img class="img-fluid" src="image/stock/2.jpg" alt="Fitbora">
                        <img class="img-fluid" src="image/stock/3.jpg" alt="Fitbora">
                        <img class="img-fluid" src="image/stock/4.jpg" alt="Fitbora">
                        <img class="img-fluid" src="image/stock/8.jpg" alt="Fitbora">
                    </div>
                </div>
            </div>
        </section>
        <!--================ About History Area  =================-->



        <!--================ Categories Area Start =================-->
        <section class="blog_categorie_area one">
            <div class="container">
                <div class="section_title text-center">
                    <h2 class="title_color">Directories</h2>
                    <hr>
                </div>
                <div class="row">

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                           <img src="image/directories/1.png" alt="Gyms">
                            <div class="categories_details">
                                <a href="listings/Gyms">
                                <div class="categories_text">
                                    <h5><i class="fa fa-dumbbell"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Gyms</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/2.png" alt="Health Clubs">
                            <div class="categories_details">
                                <a href="listings/Health Clubs">
                                <div class="categories_text">
                                    <h5><i class="fa fa-heartbeat"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Health Clubs</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/3.png" alt="Spas">
                            <div class="categories_details">
                                <a href="listings/Spas">
                                <div class="categories_text"><h5><i class="fa fa-spa"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Spas</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/4.png" alt="Massage Parlors">
                            <div class="categories_details">
                                <a href="listings/Massage Parlors">
                                <div class="categories_text"><h5><i class="fa fa-ranking-star"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Massage Parlors</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/5.png" alt="Physiotherapists">
                            <div class="categories_details">
                                <a href="listings/Physiotherapists">
                                <div class="categories_text"><h5><i class="fa fa-hiking"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Physiotherapists</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/6.png" alt="Sports Clubs">
                            <div class="categories_details">
                                <a href="listings/Sports Clubs">
                                <div class="categories_text"><h5><i class="fa fa-futbol"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Sports Clubs</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/7.png" alt="Dance Clubs">
                            <div class="categories_details">
                                <a href="listings/Dance Clubs">
                                <div class="categories_text"><h5><i class="fa fa-icons"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Dance Clubs</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/8.png" alt="Trainers">
                            <div class="categories_details">
                                <a href="listings/Trainers">
                                <div class="categories_text"><h5><i class="fa fa-running"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Trainers</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/9.png" alt="Dieticians">
                            <div class="categories_details">
                                <a href="listings/Dieticians">
                                <div class="categories_text"><h5><i class="fa fa-stopwatch-20"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Dieticians</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/10.png" alt="Technicians">
                            <div class="categories_details">
                                <a href="listings/Technicians">
                                <div class="categories_text"><h5><i class="fa fa-toolbox"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Technicians</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/11.png" alt="Consultants">
                            <div class="categories_details">
                                <a href="listings/Consultants">
                                <div class="categories_text"><h5><i class="fa fa-medal"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Consultants</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <video autoplay muted loop class="img-fluid">
                                    <source src="image/directories/14.mp4" type="video/mp4">
                                </video>
                            <div class="categories_details">
                                <a href="listings/Swimming Pools">
                                <div class="categories_text"><h5><i class="fa fa-swimmer"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Swimming Pools</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-md-4 col-sm-6 col-6">
                        <div class="categories_post">
                            <img src="image/directories/13.png" alt="Suppliers">
                            <div class="categories_details">
                                <a href="listings/Suppliers">
                                <div class="categories_text"><h5><i class="fa fa-biking"></i></h5>
                                    <div class="border_line"></div>
                                    <p>Suppliers</p>
                                </div>
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!--================ Categories Area End =================-->

        
        <!--================ Blog Area Start =================-->
        <section class="latest_blog_area section_gap one listings">
            <div class="container">
                <div class="section_title text-center">
                    <p class="text-uppercase" style="font-size: 18px;">Most Visited</p>
                    <h2 class="title_color">Top Rated Gyms</h2>
                    <hr>

<?php

    $sql = "SELECT * FROM listings WHERE sub='Gym' AND deleted=''";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    if($query->fetch_assoc()==0){
        echo '<p style="font-size: 18px;">Something exciting is coming soon, kindly scrolling for more <i class="fa fa-caret-down ml-2 float-bounce"></i></p>';
        echo '<video autoplay loop muted width="300px">
              <source src="image/motion/6.mp4">
              <video>';
    }
?>
                </div>
                <div class="row mb_30 saucerer_slider owl-carousel">

                                        
<?php

    $sql = "SELECT * FROM listings WHERE sub='Gym' AND deleted='' ORDER BY id DESC";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        if ($row["g_maps"]) {
            $g_maps = $row["g_maps"];
        } else {
            $g_maps = '#!';
        }

        if ($row["hr_open"]!='00:00:00') {
            $hr_open = date("h:ia", strtotime($row["hr_open"]));

            if ($row["hr_close"]!='00:00:00') {
                $hr_close = '- '.date("h:ia", strtotime($row["hr_close"])).'';
            } else {
                $hr_close = '';
            }
        } else {
            $hr_open = '09:00am';
            $hr_close = '';
        }

        echo '<div class="col-lg-12 col-md-12 col-sm-12">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                                echo '<img class="img-fluid" src="admin/listings/images/'.$row["image"].'" alt="fitbora fitness">';
                                echo '<a href="tel:'.$row["phone"].'"><i class="fa fa-phone"></i></a>';
                                echo '<a href="listings/1/?listing='.$row["url"].'"><i class="fa fa-caret-right"></i></a>';
                            echo '</div>';
                            echo '<div class="details">';
                                echo '<a href="listings/1/?listing='.$row["url"].'"><h4 class="sec_h4">'.$row["title"].'</h4></a>';
                                echo '<p><a href="listings/'.$row["sub"].'s">'.$row["sub"].'</a>&nbsp; | &nbsp;<a href="categories/'.$row["cat"].'">'.$row["cat"].'</a></p>';
                                echo '<p>'.$row["services"].'</p>';
                                echo '<p><a href="'.$g_maps.'"><i class="fa fa-map-marker mr-1"></i> '.$row["address"].', '.$row["district"].'</a></p>';
                            echo '</div>';  

                            echo '<div class="one-footer">';
                                echo '<div class="row">';
                                    echo '<div class="col-md-12 col-sm-12 col-12">';
                                        echo '<p class="ml-4 mt-3"><i class="fa fa-clock-o mr-1"></i> '.$hr_open.' '.$hr_close.'</p>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';

                        echo '</div>';
                    echo '</div>';
    }

?>


                </div>

            <div align="center" class="mt-5"><a href="categories/fitness" class="button_hover theme_btn">SEE FITNESS CENTERS <i class="fa fa-caret-right ml-2 float-bounce-right"></i></a></div>
            </div>
        </section>
        <!--================ Blog Area  End =================-->


            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


            <!--================ Blog Area Start =================--
        <section class="latest_blog_area section_gap one">
            <div class="container">
                <div class="section_title text-center">
                    <p class="text-uppercase" style="font-size: 18px;">Most Visited</p>
                    <h2 class="title_color">Top Rated Gyms</h2>
                    <hr>
                </div>
                <div class="row mb_30">

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="single-recent-blog-post">
                            <div class="thumb">
                                <img class="img-fluid" src="image/blog/1.jpeg" alt="fitbora fitness">
                                <img src="image/icons/play-button.png" alt="Play" class="play-btn">
                                <i class="fa fa-heart-o"></i>
                            </div>
                            <div class="details">
                                <a href="#"><h4 class="sec_h4">J’s Big Gym</h4></a>
                                <p><a href="#">Health</a>&nbsp; | &nbsp;<a href="#">Closed</a></p>
                                <p>Welcome to J's Big Gym. J's Big Gym is proud to be the FIRST in Hom...</p>
                                <p><a href="#"><i class="fa fa-map-marker mr-1"></i> Kampala, Uganda</a></p>
                            </div>  

                            <div class="one-footer">
                                <div class="row">
                                    <div class="col-md-3 col-sm-3 col-3">
                                        <img src="image/icons/3.png" alt="icon">
                                    </div>
                                    <div class="col-md-9 col-sm-9 col-9">
                                        <h4 class="sec_h4">J’s Big Gym</h4>
                                        <p><i class="fa fa-clock-o mr-1"></i> March 10, 2018</p>
                                    </div>
                                </div>
                            </div> 

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="single-recent-blog-post">
                            <div class="thumb">
                                <img class="img-fluid" src="image/blog/2.jpeg" alt="fitbora fitness">
                                <img src="image/icons/play-button.png" alt="Play" class="play-btn">
                                <i class="fa fa-heart-o"></i>
                            </div>
                            <div class="details">
                                <a href="#"><h4 class="sec_h4">Opera House Hotels</h4></a>
                                <p><a href="#">Hotels</a>&nbsp; | &nbsp;<a href="#">Closed</a></p>
                                <p>Opera House Hotels is The Bronx’s premier hotel with 30 spacious and c...</p>
                                <p><a href="#"><i class="fa fa-map-marker mr-1"></i> Kampala, Uganda</a></p>
                         </div>  

                            <div class="one-footer">
                                <div class="row">
                                    <div class="col-md-3 col-sm-3 col-3">
                                        <img src="image/icons/4.png" alt="icon">
                                    </div>
                                    <div class="col-md-9 col-sm-9 col-9">
                                        <h4 class="sec_h4">Opera</h4>
                                        <p><i class="fa fa-clock-o mr-1"></i> March 10, 2018</p>
                                    </div>
                                </div>
                            </div> 

                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="single-recent-blog-post">
                            <div class="thumb">
                                <img class="img-fluid" src="image/blog/3.jpeg" alt="fitbora fitness">
                                <img src="image/icons/play-button.png" alt="Play" class="play-btn">
                                <i class="fa fa-heart-o"></i>
                            </div>
                            <div class="details">
                                <a href="#"><h4 class="sec_h4">Family Basket Superm...</h4></a>
                                <p><a href="#">Shopping</a>&nbsp; | &nbsp;<a href="#">Always Open</a></p>
                                <p>Welcome to Sleep Hollow Supermarket store, stocks amazing products for...</p>
                                <p><a href="#"><i class="fa fa-map-marker mr-1"></i> Kampala, Uganda</a></p>
                            </div>  

                            <div class="one-footer">
                                <div class="row">
                                    <div class="col-md-3 col-sm-3 col-3">
                                        <img src="image/icons/5.jpg" alt="icon">
                                    </div>
                                    <div class="col-md-9 col-sm-9 col-9">
                                        <h4 class="sec_h4">Family Basket</h4>
                                        <p><i class="fa fa-clock-o mr-1"></i> March 10, 2018</p>
                                    </div>
                                </div>
                            </div> 

                        </div>
                    </div>

                </div>
            </div>
        </section>
        --================ Blog Area  End =================-->

        
        <!--================ About History Area  =================-->
        <section class="about_history_area section_gap">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 d_flex align-items-center">
                        <div class="about_content ">
                            <h2 class="title title_color">About Us</h2>
                            <h6>Everything you need to find the right listing</h6>
                            <p>FitBora is a premier online listing designed to connect fitness and wellness enthusiasts with the best gyms and fitness facilities in their area. Our comprehensive listing platform offers an extensive range of options, from high-end luxury fitness clubs to budget-friendly community gyms, spas and health clubs - ensuring there’s something for everyone.</p>

                          <div class="row history_bottom">
                            <div class="col-md-6 col-6">
                             <img class="img-fluid" src="image/icons/1.png" alt="fitbora fitness">
                             <h4 class="sec_h4">Curated Selections</h4>
                             <p>Dedicated to supporting healthier and more active lifestyles by connecting people with the appropriate fitness and wellness resources in their community.</p>
                            </div>

                            <div class="col-md-6 col-6">
                             <img class="img-fluid" src="image/icons/2.png" alt="fitbora fitness">
                             <h4 class="sec_h4">Our Mission</h4>
                             <p>To empower individuals to achieve their fitness goals by simplifying the process of finding the perfect gym.</p>
                            </div>
                          </div>

                        </div>
                    </div>
                    <div class="col-md-4">
                        <video class="img-fluid" autoplay loop muted width="100%" style="transform: scaleX(-1);">
                            <source src="image/motion/7.mp4">
                        <video>
                        <div align="center"><br>
                          <a href="about" class="button_hover theme_btn_two">Check Out More About Us & Offers</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--================ About History Area  =================-->



        
        <!--================ Testimonial Area  =================-->
        <section class="featured_area section_gap">
            <div class="container">
                <div class="section_title text-center">
                    <p style="font-size: 18px;">OTHER</p>
                    <h2 class="title_color">Featured Listings</h2>
                    <hr>
                </div>
                <div class="featured_slider owl-carousel">

                    <?php

    $sql = "SELECT * FROM listings WHERE deleted='' GROUP BY sub ORDER BY id DESC";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="media featured_item">
                        <div class="media-body" align="center">
                        <img src="admin/listings/images/'.$row["image"].'" alt="'.$row["sub"].'">
                            <a href="listings/'.$row["sub"].'s"><h4 class="sec_h4">'.$row["sub"].'s</h4></a>
                            <a href="listings/'.$row["sub"].'s" class="button_hover theme_btn">EXPLORE</a>
                        </div>
                    </div>';
    }
?>

                </div>
            </div>
        </section>
        <!--================ Testimonial Area  =================-->



        
        <!--================ Facilities Area Start =================-->
        <section class="facilities_area section_gap one">
            <div class="overlay bg-parallax" data-stellar-ratio="0.8" data-stellar-vertical-offset="0" data-background="">  
            </div>
            <div class="container">
                <div class="section_title text-center">
                    <p class="text-primary">How It Works</p>
                    <h2 class="title_w">Get Started</h2>
                    <hr>
                </div>
                <div class="row mb_30" align="center">

                    <div class="col-lg-4 col-md-6">
                        <div class="facilities_item">
                            <img class="img-fluid" src="image/stock/5.jpg" alt="fitbora fitness">
                            <h4 class="sec_h4"><i class="lnr lnr-dinner"></i>Find Interesting Places</h4>
                            <span class="fa fa-circle"></span>
                            <p>You can search for areas of interest, local events, trendy restaurants or just things to do.</p>
                        </div>
                    </div>
                    
                    <div class="col-lg-4 col-md-6">
                        <div class="facilities_item">
                                <video autoplay muted loop class="img-fluid">
                                    <source src="video/ocean-sea-wave-video.mp4" type="video/mp4">
                                </video>  
                            <h4 class="sec_h4"><i class="lnr lnr-shirt"></i>Check Reviews</h4>
                            <span class="fa fa-circle"></span>
                            <p>You can search for areas of interest, local events, trendy restaurants or just things to do.</p>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="facilities_item">
                            <img class="img-fluid" src="image/stock/9.jpg" alt="fitbora fitness">
                            <h4 class="sec_h4"><i class="lnr lnr-bicycle"></i>Enjoy Your Serving</h4>
                            <span class="fa fa-circle"></span>
                            <p>You can search for areas of interest, local events, trendy restaurants or just things to do.</p>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!--================ Facilities Area End =================-->

        
        <!--================ Blog Area Start =================-->
        <section class="latest_blog_area one section_gap">
            <div class="container">
                <div class="section_title text-center">
                    <p class="text-uppercase" style="font-size: 18px;">Latest</p>
                    <h2 class="title_color">From The Blog</h2>
                    <hr> 

<?php

    $sql = "SELECT * FROM blogs WHERE deleted=''";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    if($query->fetch_assoc()==0){
        echo '<p style="font-size: 18px;">No blogs yet, kindly check back later.<span class="flash">.</span></p>';
        echo '<video autoplay loop muted width="300px">
              <source src="image/motion/4.mp4">
              <video>';
    }
?>
                </div>
                <div class="row mb_30">

                    <?php

    $sql = "SELECT * FROM blogs WHERE blog_type='Video' AND deleted='' ORDER BY id DESC LIMIT 1";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="col-lg-4 col-md-6">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                                echo '<video class="img-fluid one" controls><source src="admin/blogs/video-blogs/videos/'.$row["vid1"].'"></video>';
                            echo '</div>';
                            echo '<div class="details" align="center">';
                                echo '<p>'.date("jS M, Y", strtotime($row["timestamp"])).'</p>';
                                echo '<a href="blogs/single/?blog='.$row["code"].'"><h4 class="sec_h4">'.substr($row['title'], 0, 20).'.<span class="flash">.</span></h4></a>';
                                echo '<p>'.substr($row['title'], 0, 46).'.<span class="flash">.</p>';
                                echo '<a href="blog/single/?blog='.$row["code"].'" class="button_hover theme_btn_two">Read More</a>';
                                echo '<hr>';
                            echo '</div> '; 
                        echo '</div>';
                    echo '</div>';
    }
?>


<?php

    $sql = "SELECT * FROM blogs WHERE blog_type='Image' AND deleted='' ORDER BY id DESC LIMIT 2";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="col-lg-4 col-md-6">';
                        echo '<div class="single-recent-blog-post">';
                            echo '<div class="thumb">';
                                echo '<img class="img-fluid one" src="admin/blogs/images/'.$row["image1"].'" alt="'.$row["title"].' img">';
                            echo '</div>';
                            echo '<div class="details" align="center">';
                                echo '<p>'.date("jS M, Y", strtotime($row["timestamp"])).'</p>';
                                echo '<a href="blogs/single/?blog='.$row["code"].'"><h4 class="sec_h4">'.substr($row['title'], 0, 20).'.<span class="flash">.</span></h4></a>';
                                echo '<p>'.substr($row['title'], 0, 46).'.<span class="flash">.</p>';
                                echo '<a href="blog/single/?blog='.$row["code"].'" class="button_hover theme_btn_two">Read More</a>';
                                echo '<hr>';
                            echo '</div> '; 
                        echo '</div>';
                    echo '</div>';
    }
?>

                </div>

            <div align="center" class="mt-5"><a href="blog" class="button_hover theme_btn">SEE ALL BLOGS <i class="fa fa-caret-right ml-2 float-bounce-right"></i></a></div>
            </div>

            </div>
        </section>
        <!--================ Blog Area  End =================-->


        
        <!--================ Facilities Area Start =================-->
        <section class="facilities_area section_gap one">
            <div class="overlay bg-parallax" data-stellar-ratio="0.8" data-stellar-vertical-offset="0" data-background="">  
            </div>
            <div class="container">
                <div class="section_title text-center">
                    <h2 class="title_w">Our Core</h2>
                    <hr>
                </div>
                <div class="mb_30" align="center"> 

                    <p class="text-white">At FitBora, we believe that incorporating fitness and wellness - physical, mental, and emotional - into your routine is about more than just lookig good.</p>

                    <p class="text-white">It's a crucial and integral part of living a healthy, balanced, and more fulfilling life.</p>

                </div>
            </div>
        </section>
        <!--================ Facilities Area End =================-->
        
        <!--================ Testimonial Area  =================
        <section class="testimonial_area section_gap">
            <div class="container">
                <div class="section_title text-center">
                    <h2 class="title_color">Testimonials</h2>
                    <p>A word from our happy clients..</p>
                    <hr>
                </div>
                <div class="testimonial_slider owl-carousel">
                    <div class="media testimonial_item">
                        <img class="rounded-circle" src="image/elements/user2.png" alt="">
                        <div class="media-body">
                            <p>Having been at several hotels in over 10 different countries in 3 different continents over the years, I can honestly say that it is one of the best hotels in Africa. The prices are so friendly and yet come with top notch services. Don't even get me started on the rooms & room service, it's worth a try.</p>
                            <a href="#"><h4 class="sec_h4">Fanny Spencer</h4></a>
                            <div class="star">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                    </div>    
                    <div class="media testimonial_item">
                        <img class="rounded-circle" src="image/blog/author.png" alt="">
                        <div class="media-body">
                            <p>The hotel has a strong understanding of current modern foods. The chefs are particularly skilled with food preparation that has valuable addition to nutrition & think outside the box. I would gladly recommend you to try it! The hotel has food they call Luwombo (local food prepared in banana leaves) & the Katogo (Plantain prepared with several additives & meats), OMG! This exceeded my expectation.</p>
                            <a href="#"><h4 class="sec_h4">Ian M</h4></a>
                            <div class="star">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                    </div>
                    <div class="media testimonial_item">
                        <img class="rounded-circle" src="image/testtimonial-1.jpg" alt="">
                        <div class="media-body">
                            <p>If you have the opportunity to check out this hotel, I say go for it! You are guaranteed an enjoyable and productive experience. It has given me the best experience that any Ugandan hotel or should I say African hotel has ever offered. I look forward to booking a room very soon again and can't wait. In fact, I'm thinking of visiting the country again just to have that pleasurable experience once more. </p>
                            <a href="#"><h4 class="sec_h4">Prince O</h4></a>
                            <div class="star">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                    </div>    
                    <div class="media testimonial_item">
                        <img class="rounded-circle" src="image/testtimonial-1.jpg" alt="">
                        <div class="media-body">
                            <p>It has this thing they do when you're new in the country and want to explore Uganda, they offer a wide variety of beautiful scenery itineraries and packages to help you travel those locations you choose to explore. The hotel provides everything you need to travel with a guide inclusive. And the prices are unbelievable, I don't usually fall in love this fast but mehn this hotel got me there.</p>
                            <a href="#"><h4 class="sec_h4">George Miller</h4></a>
                            <div class="star">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                    </div>
                    <div class="media testimonial_item">
                        <img class="rounded-circle" src="image/testtimonial-1.jpg" alt="">
                        <div class="media-body">
                            <p>I personally am an environmentalist and I couldn't help but notice how much the hotel strives to preserve the environment within & around the hotel. One thing I noticed about the community around the hotel dump plastics in their community and the hotel has this thing they do where they organize teams of their employees every Saturday and clean the community, dispose of plastics & burn them. I highly encourage you to support this hotel because the planet needs more people like these.</p>
                            <a href="#"><h4 class="sec_h4">Mark R</h4></a>
                            <div class="star">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        ================ Testimonial Area  =================-->
        
        <!--================ start footer Area  =================-->	
        <footer class="footer-area section_gap">
            <div class="container">
                <div class="row">

                    <div class="col-lg-4 col-md-12 col-sm-12 col-12">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Overview</h6>
                            <p>FitBora is a premier online listing designed to connect fitness and wellness enthusiasts with the best gyms and fitness facilities in their area.
                            Our comprehensive listing platform offers an extensive range of options, from high-end luxury fitness clubs to budget-friendly community gyms, spas and health clubs - ensuring there’s something for everyone.</p>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Locations</h6>
                                    <ul class="list_style">
<?php

    $sql = "SELECT COUNT(*), district, image FROM listings WHERE deleted='' GROUP BY district ORDER BY id DESC LIMIT 5";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<li><a href="districts/ug/?district='.$row["district"].'"><i class="fa fa-angle-right"></i> '.$row["district"].'</a></li>';
    }

?>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <a href="categories"><h6 class="footer_title">Categories</h6></a>
                                    <ul class="list_style">
                                        <li><a href="categories/Fitness"><i class="fa fa-angle-right"></i> Fitness</a></li>
                                        <li><a href="categories/Wellness"><i class="fa fa-angle-right"></i> Wellness</a></li>
                                        <li><a href="categories/Massage"><i class="fa fa-angle-right"></i> Massage</a></li>
                                        <li><a href="categories/Steam Bath"><i class="fa fa-angle-right"></i> Steam Bath</a></li>
                                        <li><a href="categories/Experts"><i class="fa fa-angle-right"></i> Experts</a></li>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Interact With</h6>
                                    <ul class="list_style">
                                        <li><a href="listings/Trainers"><i class="fa fa-angle-right"></i> Trainers</a></li>
                                        <li><a href="listings/Dieticians"><i class="fa fa-angle-right"></i> Dieticians</a></li>
                                        <li><a href="listings/Technicians"><i class="fa fa-angle-right"></i> Technicians</a></li>
                                        <li><a href="listings/Consultants"><i class="fa fa-angle-right"></i> Consultants</a></li>
                                        <li><a href="listings/Physiotherapists"><i class="fa fa-angle-right"></i> Physiotherapists</a></li>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Quick Links</h6>
                                    <ul class="list_style">
                                        <li><a href="blog"><i class="fa fa-angle-right"></i> Blogs</a></li>
                                        <li><a href="events"><i class="fa fa-angle-right"></i> Events</a></li>
                                        <li><a href="about"><i class="fa fa-angle-right"></i> About Us</a></li>
                                        <li><a href="contact"><i class="fa fa-angle-right"></i> Contact Us</a></li>
                                        <li><a href="listings"><i class="fa fa-angle-right"></i> Directories</a></li>
                                    </ul>
                        </div>
                    </div>

                </div>
                <div class="border_line"></div>
                <div class="row footer-bottom d-flex justify-content-between align-items-center">
                    <div class="col-lg-3 col-sm-12 footer-social">
                        <a href="https://facebook.com/fitbora"><i class="fab fa-facebook"></i></a>
                        <a href="https://x.com/fitbora"><i class="fab fa-x-twitter"></i></a>
                        <a href="https://instagram.com/fitbora"><i class="fab fa-instagram"></i></a>
                        <a href="https://wa.me/256746006066"><i class="fab fa-whatsapp"></i></a>
                    </div>

                    <p class="col-lg-6 col-sm-12 footer-text m-0 text-center">
                      <a href="#">Fitbora</a> &copy; <script>document.write(new Date().getFullYear());</script>, All Rights Reserved<span class="flash">.</span></p>

                    <p class="col-lg-3 col-sm-12 footer-text m-0 text-center" style="font-size: 12px;">Powered by <a href="https://camonitor.online" target="_blank" style="color: #82848f;">Custom Assist Inc<span class="flash">.</span></a></p>

                </div>


            </div>

            
        </footer>
		<!--================ End footer Area  =================-->
        
        
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="js/jquery-3.2.1.min.js"></script>
        <script src="js/popper.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="vendors/owl-carousel/owl.carousel.min.js"></script>
        <script src="js/jquery.ajaxchimp.min.js"></script>
        <script src="js/mail-script.js"></script>
        <script src="vendors/bootstrap-datepicker/bootstrap-datetimepicker.min.js"></script>
        <script src="vendors/nice-select/js/jquery.nice-select.js"></script>
        <script src="js/mail-script.js"></script>
        <script src="js/stellar.js"></script>
        <script src="vendors/lightbox/simpleLightbox.min.js"></script>
        <script src="js/custom.js"></script>
        <script src="js/video-on-scroll.js"></script>
        <script src="admin/counter/js/chat.js"></script>

    </body>
</html>