<?php
    session_start();
    include_once('../admin/db/saucerer.php');
?>

<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <link rel="icon" href="../image/favicon/1.png" type="image/png">
        <title>About | FitBora &copy;</title>

    <meta name="description" content="The fitness & wellness network">

    <meta name="keywords" content="Gyms, Health Clubs, Spas, Massage Parlors, Physiotherapists, Sports Clubs, Dance Clubs, Trainers, Dieticians, Technicians, Consultants, Swimming Pools, Suppliers, Kampala, Uganda">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://fitbora.net/image/card/1.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="FitBora &copy;">

    <meta property="og:url" content="https://fitbora.net/about">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="The fitness & wellness network">

    <meta property="og:site_name" content="FitBora &copy;">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://fitbora.net/about">

    <meta name="twitter:title" content="FitBora &copy;">

    <meta name="twitter:description" content="The fitness & wellness network">

    <meta name="twitter:image" content="https://fitbora.net/image/card/1.png">

    <meta name="twitter:site" content="@fitbora">

    <meta name="twitter:creator" content="@iann_thecreator">


        <!-- Bootstrap CSS -->
        <link rel="stylesheet" href="../css/bootstrap.css">
        <link rel="stylesheet" href="../vendors/linericon/style.css">
        <link rel="stylesheet" href="../css/font-awesome.min.css">
        <link rel="stylesheet" href="../vendors/owl-carousel/owl.carousel.min.css">
        <link rel="stylesheet" href="../vendors/bootstrap-datepicker/bootstrap-datetimepicker.min.css">
        <link rel="stylesheet" href="../vendors/nice-select/css/nice-select.css">
        <link rel="stylesheet" href="../vendors/owl-carousel/owl.carousel.min.css">
        <!-- main css -->
        <link rel="stylesheet" href="../css/style.css">
        <link rel="stylesheet" href="../css/responsive.css">

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="../css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="../css/fontawesome/css/all.css" rel="stylesheet">  


    </head>
    <body>
        <!--================Header Area =================-->
        <header class="header_area">
            <div class="container">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <!-- Brand and toggle get grouped for better mobile display -->
                    <a class="navbar-brand logo_h" href="../"><img src="../image/logo.png" alt=""></a>

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse offset" id="navbarSupportedContent">
                        <ul class="nav navbar-nav menu_nav ml-auto">
                            <li class="nav-item"><a class="nav-link" href="../">Home</a></li> 
                            <li class="nav-item submenu dropdown">
                                <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Directories</a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item"><a class="nav-link" href="../listings">All Listings</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Gyms">Gyms</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Health Clubs">Health Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Spas">Spas</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Massage Parlors">Massage Parlors</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Physiotherapists">Physiotherapists</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Dance Clubs">Dance Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Sports Clubs">Sports Clubs</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Trainers">Trainers</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Dieticians">Dieticians</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Technicians">Technicians</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Consultants">Consultants</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Swimming Pools">Swimming Pools</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../listings/Equipment Suppliers">Equipment Suppliers</a></li>
                                </ul>
                            </li> 
                            <li class="nav-item submenu dropdown">
                                <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Categories</a>
                                <ul class="dropdown-menu">
                                    <li class="nav-item"><a class="nav-link" href="../categories">All Categories</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Fitness">Fitness</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Wellness">Wellness</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Massage">Massage</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Steam Bath">Steam Bath</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Sauna">Sauna</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Dance">Dance</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Sports">Sports</a></li>
                                    <li class="nav-item"><a class="nav-link" href="../categories/Experts">Experts</a></li>
                                </ul>
                            </li> 
                            <li class="nav-item"><a class="nav-link" href="../blog">Blog</a></li>
                            <li class="nav-item"><a class="nav-link" href="../events">Events</a></li>
                            <li class="nav-item active"><a class="nav-link" href="../about">About Us</a></li>
                            <li class="nav-item"><a class="nav-link" href="../contact">Contact Us</a></li>
                        </ul>
                    </div> 
                </nav>
            </div>
        </header>
        <!--================Header Area =================--> 


        
        <!--================Breadcrumb Area =================-->
        <section class="breadcrumb_area">
            <div class="overlay bg-parallax" data-stellar-ratio="0.8" data-stellar-vertical-offset="0" data-background=""></div>
            <div class="container">
                <div class="page-cover text-center">
                    <h2 class="page-cover-tittle">About Us</h2>
                    <ol class="breadcrumb">
                        <li><a href="../">Home</a></li>
                        <li class="active">About Us</li>
                    </ol>
                </div>
            </div>
        </section>
        <!--================Breadcrumb Area =================-->


        
        <!--================ About History Area  =================-->
        <section class="about_history_area section_gap">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 d_flex align-items-center">
                        <div class="about_content ">
                            <h2 class="title title_color">About Us</h2>
                            <h6>Everything you need to find the right listing</h6>
                            <p>FitBora is a premier online listing designed to connect fitness and wellness enthusiasts with the best gyms and fitness facilities in their area. Our comprehensive listing platform offers an extensive range of options, from high-end luxury fitness clubs to budget-friendly community gyms, spas and health clubs - ensuring there’s something for everyone.</p>

                          <div class="row history_bottom">
                            <div class="col-md-6 col-6">
                             <img class="img-fluid" src="../image/icons/1.png" alt="fitbora fitness">
                             <h4 class="sec_h4">Curated Selections</h4>
                             <p>Dedicated to supporting healthier and more active lifestyles by connecting people with the appropriate fitness and wellness resources in their community.</p>
                            </div>

                            <div class="col-md-6 col-6">
                             <img class="img-fluid" src="../image/icons/2.png" alt="fitbora fitness">
                             <h4 class="sec_h4">Our Mission</h4>
                             <p>To empower individuals to achieve their fitness goals by simplifying the process of finding the perfect gym.</p>
                            </div>
                          </div>

                        </div>
                    </div>
                    <div class="col-md-4">
                        <video class="img-fluid" autoplay loop muted width="100%" style="transform: scaleX(-1);">
                            <source src="../image/motion/7.mp4">
                        <video>
                    </div>
                </div>
            </div>
        </section>
        <!--================ About History Area  =================-->


            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


        
        <!--================ About History Area  =================-->
        <section class="about_history_area section_gap">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 d_flex align-items-center">
                        <div class="about_content ">
                            <h2 class="title title_color">Overview</h2>
                            <p>At FitBora, we prioritize user-experience by providing usable profiles for each facility, including amenities, membership options, training schedules, and user reviews. Our intuitive search filters and interactive map make it easy for users to find a gym or wellness centre that fits their specific needs, whether they’re looking for a state-of-the-art facility, specialized workout programs, or convenient locations. <br> <br>
                            With FitBora, users can explore various fitness and wellness options, compare features, and make informed decisions with confidence. <br> <br>
                            FitBora offers a curated selection of spas, from luxurious day spas to tranquil wellness resorts, ensuring that you can find the perfect escape for relaxation and recreation.</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <img class="img-fluid" src="../image/about_bg.jpg" alt="img">
                    </div>
                </div>
            </div>
        </section>
        <!--================ About History Area  =================-->


            <!--======= Line Start ========-->
            <div class="container"><hr></div>
            <!--======= Line End ========-->


        
        <!--================ About History Area  =================-->
        <section class="about_history_area one section_gap">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-12 d_flex align-items-center">
                        <div class="about_content ">
                            <i>Let's uncover the best places</i>
                            <h2 class="title title_color">Discover Interesting Fitness Centers Around You</h2>
                            <p>Whether you're seeking a soothing massage, a revitalizing facial, or a complete wellness makeover, FitBora helps you make informed choices and discover exceptional experiences tailored to your needs. <br> <br>
                            Indulge in the pampering and self-care you deserve with ease and confidence, thanks to FitBora.</p>

                  <div class="col-md-12 lower">
                <div class="row">

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-layer-group"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Choose A Category</h4>
                        <p>Select through a variety of our curated selections</p>
                    </div>

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-map-location"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Find What You Want</h4>
                        <p>Explore various fitness and wellness options & compare features</p>
                    </div>

                    <div class="col-md-2 col-sm-2 col-2">
                        <i class="fa fa-handshake"></i>
                    </div>
                    <div class="col-md-10 col-sm-10 col-10">
                        <h4>Trusted Locals</h4>
                        <p>Choose the right fitness center or professional for you</p>
                    </div>

                  </div>
                </div>
                
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12 col-12 about-grid">
                        <div class="about-float"><a href="../listings"><div>Explore Listings</div></a></div>
                        <img class="img-fluid" src="../image/stock/2.jpg" alt="Fitbora">
                        <img class="img-fluid" src="../image/stock/3.jpg" alt="Fitbora">
                        <img class="img-fluid" src="../image/stock/4.jpg" alt="Fitbora">
                        <img class="img-fluid" src="../image/stock/8.jpg" alt="Fitbora">
                    </div>
                </div>
            </div>
        </section>
        <!--================ About History Area  =================-->
        
        <!--================ Testimonial Area  =================-->
        <section class="featured_area section_gap">
            <div class="container">
                <div class="section_title text-center">
                    <p style="font-size: 18px;">OTHER</p>
                    <h2 class="title_color">Featured Listings</h2>
                    <hr>
                </div>
                <div class="featured_slider owl-carousel">

                    <?php

    $sql = "SELECT * FROM listings WHERE deleted='' GROUP BY sub ORDER BY id DESC";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<div class="media featured_item">
                        <div class="media-body" align="center">
                        <img src="../admin/listings/images/'.$row["image"].'" alt="'.$row["sub"].'">
                            <a href="../listings/'.$row["sub"].'s"><h4 class="sec_h4">'.$row["sub"].'s</h4></a>
                            <a href="../listings/'.$row["sub"].'s" class="button_hover theme_btn">EXPLORE</a>
                        </div>
                    </div>';
    }
?>

                </div>
            </div>
        </section>
        <!--================ Testimonial Area  =================-->

        
        <!--================ start footer Area  =================-->    
        <footer class="footer-area section_gap">
            <div class="container">
                <div class="row">

                    <div class="col-lg-4 col-md-12 col-sm-12 col-12">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Overview</h6>
                            <p>FitBora is a premier online listing designed to connect fitness and wellness enthusiasts with the best gyms and fitness facilities in their area.
                            Our comprehensive listing platform offers an extensive range of options, from high-end luxury fitness clubs to budget-friendly community gyms, spas and health clubs - ensuring there’s something for everyone.</p>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Locations</h6>
                                    <ul class="list_style">
<?php

    $sql = "SELECT COUNT(*), district, image FROM listings WHERE deleted='' GROUP BY district ORDER BY id DESC LIMIT 5";

    //use for MySQLi-OOP
    $query = $conn->query($sql);
    while($row = $query->fetch_assoc()){

        echo '<li><a href="../districts/ug/?district='.$row["district"].'"><i class="fa fa-angle-right"></i> '.$row["district"].'</a></li>';
    }

?>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <a href="../categories"><h6 class="footer_title">Categories</h6></a>
                                    <ul class="list_style">
                                        <li><a href="../categories/Fitness"><i class="fa fa-angle-right"></i> Fitness</a></li>
                                        <li><a href="../categories/Wellness"><i class="fa fa-angle-right"></i> Wellness</a></li>
                                        <li><a href="../categories/Massage"><i class="fa fa-angle-right"></i> Massage</a></li>
                                        <li><a href="../categories/Steam Bath"><i class="fa fa-angle-right"></i> Steam Bath</a></li>
                                        <li><a href="../categories/Experts"><i class="fa fa-angle-right"></i> Experts</a></li>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Interact With</h6>
                                    <ul class="list_style">
                                        <li><a href="../listings/Trainers"><i class="fa fa-angle-right"></i> Trainers</a></li>
                                        <li><a href="../listings/Dieticians"><i class="fa fa-angle-right"></i> Dieticians</a></li>
                                        <li><a href="../listings/Technicians"><i class="fa fa-angle-right"></i> Technicians</a></li>
                                        <li><a href="../listings/Consultants"><i class="fa fa-angle-right"></i> Consultants</a></li>
                                        <li><a href="../listings/Physiotherapists"><i class="fa fa-angle-right"></i> Physiotherapists</a></li>
                                    </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-3 col-sm-3 col-6">
                        <div class="single-footer-widget">
                            <h6 class="footer_title">Quick Links</h6>
                                    <ul class="list_style">
                                        <li><a href="../blog"><i class="fa fa-angle-right"></i> Blogs</a></li>
                                        <li><a href="../events"><i class="fa fa-angle-right"></i> Events</a></li>
                                        <li><a href="../about"><i class="fa fa-angle-right"></i> About Us</a></li>
                                        <li><a href="../contact"><i class="fa fa-angle-right"></i> Contact Us</a></li>
                                        <li><a href="../listings"><i class="fa fa-angle-right"></i> Directories</a></li>
                                    </ul>
                        </div>
                    </div>

                </div>
                <div class="border_line"></div>
                <div class="row footer-bottom d-flex justify-content-between align-items-center">
                    <div class="col-lg-3 col-sm-12 footer-social">
                        <a href="https://facebook.com/fitbora"><i class="fab fa-facebook"></i></a>
                        <a href="https://x.com/fitbora"><i class="fab fa-x-twitter"></i></a>
                        <a href="https://instagram.com/fitbora"><i class="fab fa-instagram"></i></a>
                        <a href="https://wa.me/256746006066"><i class="fab fa-whatsapp"></i></a>
                    </div>

                    <p class="col-lg-6 col-sm-12 footer-text m-0 text-center">
                      <a href="#">Fitbora</a> &copy; <script>document.write(new Date().getFullYear());</script>, All Rights Reserved<span class="flash">.</span></p>

                    <p class="col-lg-3 col-sm-12 footer-text m-0 text-center" style="font-size: 12px;">Powered by <a href="https://camonitor.online" target="_blank" style="color: #82848f;">Custom Assist Inc<span class="flash">.</span></a></p>

                </div>


            </div>

            
        </footer>
        <!--================ End footer Area  =================-->
        
        
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="../js/jquery-3.2.1.min.js"></script>
        <script src="../js/popper.js"></script>
        <script src="../js/bootstrap.min.js"></script>
        <script src="../vendors/owl-carousel/owl.carousel.min.js"></script>
        <script src="../js/jquery.ajaxchimp.min.js"></script>
        <script src="../js/mail-script.js"></script>
        <script src="../vendors/bootstrap-datepicker/bootstrap-datetimepicker.min.js"></script>
        <script src="../vendors/nice-select/js/jquery.nice-select.js"></script>
        <script src="../js/mail-script.js"></script>
        <script src="../js/stellar.js"></script>
        <script src="../vendors/lightbox/simpleLightbox.min.js"></script>
        <script src="../js/custom.js"></script>
        <script src="../js/video-on-scroll.js"></script>
    </body>
</html>