
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `flarum187`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_tokens`
--

CREATE TABLE `[[dbprefix]]access_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]access_tokens_token_unique` (`token`),
  KEY `[[dbprefix]]access_tokens_user_id_foreign` (`user_id`),
  KEY `[[dbprefix]]access_tokens_type_index` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]access_tokens`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_keys`
--

CREATE TABLE `[[dbprefix]]api_keys` (
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `allowed_ips` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `last_activity_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]api_keys_key_unique` (`key`),
  KEY `[[dbprefix]]api_keys_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussions`
--

CREATE TABLE `[[dbprefix]]discussions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_count` int(11) NOT NULL DEFAULT '1',
  `participant_count` int(10) unsigned NOT NULL DEFAULT '0',
  `post_number_index` int(10) unsigned NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `first_post_id` int(10) unsigned DEFAULT NULL,
  `last_posted_at` datetime DEFAULT NULL,
  `last_posted_user_id` int(10) unsigned DEFAULT NULL,
  `last_post_id` int(10) unsigned DEFAULT NULL,
  `last_post_number` int(10) unsigned DEFAULT NULL,
  `hidden_at` datetime DEFAULT NULL,
  `hidden_user_id` int(10) unsigned DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `is_sticky` tinyint(1) NOT NULL DEFAULT '0',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]discussions_hidden_user_id_foreign` (`hidden_user_id`),
  KEY `[[dbprefix]]discussions_first_post_id_foreign` (`first_post_id`),
  KEY `[[dbprefix]]discussions_last_post_id_foreign` (`last_post_id`),
  KEY `[[dbprefix]]discussions_last_posted_at_index` (`last_posted_at`),
  KEY `[[dbprefix]]discussions_last_posted_user_id_index` (`last_posted_user_id`),
  KEY `[[dbprefix]]discussions_created_at_index` (`created_at`),
  KEY `[[dbprefix]]discussions_user_id_index` (`user_id`),
  KEY `[[dbprefix]]discussions_comment_count_index` (`comment_count`),
  KEY `[[dbprefix]]discussions_participant_count_index` (`participant_count`),
  KEY `[[dbprefix]]discussions_hidden_at_index` (`hidden_at`),
  KEY `[[dbprefix]]discussions_is_sticky_created_at_index` (`is_sticky`,`created_at`),
  KEY `[[dbprefix]]discussions_is_sticky_last_posted_at_index` (`is_sticky`,`last_posted_at`),
  KEY `[[dbprefix]]discussions_is_locked_index` (`is_locked`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion_tag`
--

CREATE TABLE `[[dbprefix]]discussion_tag` (
  `discussion_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`discussion_id`,`tag_id`),
  KEY `[[dbprefix]]discussion_tag_tag_id_foreign` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]discussion_user`
--

CREATE TABLE `[[dbprefix]]discussion_user` (
  `user_id` int(10) unsigned NOT NULL,
  `discussion_id` int(10) unsigned NOT NULL,
  `last_read_at` datetime DEFAULT NULL,
  `last_read_post_number` int(10) unsigned DEFAULT NULL,
  `subscription` enum('follow','ignore') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`user_id`,`discussion_id`),
  KEY `[[dbprefix]]discussion_user_discussion_id_foreign` (`discussion_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_tokens`
--

CREATE TABLE `[[dbprefix]]email_tokens` (
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`token`),
  KEY `[[dbprefix]]email_tokens_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]flags`
--

CREATE TABLE `[[dbprefix]]flags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason_detail` text COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]flags_post_id_foreign` (`post_id`),
  KEY `[[dbprefix]]flags_user_id_foreign` (`user_id`),
  KEY `[[dbprefix]]flags_created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name_singular` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_plural` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'Admin', 'Admins', '#B72A2A', 'fas fa-wrench', 0, NULL, NULL),
(2, 'Guest', 'Guests', NULL, NULL, 0, NULL, NULL),
(3, 'Member', 'Members', NULL, NULL, 0, NULL, NULL),
(4, 'Mod', 'Mods', '#80349E', 'fas fa-bolt', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]group_permission`
--

CREATE TABLE `[[dbprefix]]group_permission` (
  `group_id` int(10) unsigned NOT NULL,
  `permission` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`group_id`,`permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]group_permission`
--

INSERT INTO `[[dbprefix]]group_permission` VALUES
(2, 'viewForum', NULL),
(3, 'discussion.flagPosts', '[[regtime]]'),
(3, 'discussion.likePosts', '[[regtime]]'),
(3, 'discussion.reply', NULL),
(3, 'discussion.replyWithoutApproval', '[[regtime]]'),
(3, 'discussion.startWithoutApproval', '[[regtime]]'),
(3, 'searchUsers', NULL),
(3, 'startDiscussion', NULL),
(4, 'discussion.approvePosts', '[[regtime]]'),
(4, 'discussion.editPosts', NULL),
(4, 'discussion.hide', NULL),
(4, 'discussion.hidePosts', NULL),
(4, 'discussion.lock', '[[regtime]]'),
(4, 'discussion.rename', NULL),
(4, 'discussion.sticky', '[[regtime]]'),
(4, 'discussion.tag', '[[regtime]]'),
(4, 'discussion.viewFlags', '[[regtime]]'),
(4, 'discussion.viewIpsPosts', NULL),
(4, 'user.suspend', '[[regtime]]'),
(4, 'user.viewLastSeenAt', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]group_user`
--

CREATE TABLE `[[dbprefix]]group_user` (
  `user_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`,`group_id`),
  KEY `[[dbprefix]]group_user_group_id_foreign` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]group_user`
--

INSERT INTO `[[dbprefix]]group_user` VALUES
(1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_providers`
--

CREATE TABLE `[[dbprefix]]login_providers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `provider` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `last_login_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]login_providers_provider_identifier_unique` (`provider`,`identifier`),
  KEY `[[dbprefix]]login_providers_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=139 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, '2015_02_24_000000_create_access_tokens_table', NULL),
(2, '2015_02_24_000000_create_api_keys_table', NULL),
(3, '2015_02_24_000000_create_config_table', NULL),
(4, '2015_02_24_000000_create_discussions_table', NULL),
(5, '2015_02_24_000000_create_email_tokens_table', NULL),
(6, '2015_02_24_000000_create_groups_table', NULL),
(7, '2015_02_24_000000_create_notifications_table', NULL),
(8, '2015_02_24_000000_create_password_tokens_table', NULL),
(9, '2015_02_24_000000_create_permissions_table', NULL),
(10, '2015_02_24_000000_create_posts_table', NULL),
(11, '2015_02_24_000000_create_users_discussions_table', NULL),
(12, '2015_02_24_000000_create_users_groups_table', NULL),
(13, '2015_02_24_000000_create_users_table', NULL),
(14, '2015_09_15_000000_create_auth_tokens_table', NULL),
(15, '2015_09_20_224327_add_hide_to_discussions', NULL),
(16, '2015_09_22_030432_rename_notification_read_time', NULL),
(17, '2015_10_07_130531_rename_config_to_settings', NULL),
(18, '2015_10_24_194000_add_ip_address_to_posts', NULL),
(19, '2015_12_05_042721_change_access_tokens_columns', NULL),
(20, '2015_12_17_194247_change_settings_value_column_to_text', NULL),
(21, '2016_02_04_095452_add_slug_to_discussions', NULL),
(22, '2017_04_07_114138_add_is_private_to_discussions', NULL),
(23, '2017_04_07_114138_add_is_private_to_posts', NULL),
(24, '2018_01_11_093900_change_access_tokens_columns', NULL),
(25, '2018_01_11_094000_change_access_tokens_add_foreign_keys', NULL),
(26, '2018_01_11_095000_change_api_keys_columns', NULL),
(27, '2018_01_11_101800_rename_auth_tokens_to_registration_tokens', NULL),
(28, '2018_01_11_102000_change_registration_tokens_rename_id_to_token', NULL),
(29, '2018_01_11_102100_change_registration_tokens_created_at_to_datetime', NULL),
(30, '2018_01_11_120604_change_posts_table_to_innodb', NULL),
(31, '2018_01_11_155200_change_discussions_rename_columns', NULL),
(32, '2018_01_11_155300_change_discussions_add_foreign_keys', NULL),
(33, '2018_01_15_071700_rename_users_discussions_to_discussion_user', NULL),
(34, '2018_01_15_071800_change_discussion_user_rename_columns', NULL),
(35, '2018_01_15_071900_change_discussion_user_add_foreign_keys', NULL),
(36, '2018_01_15_072600_change_email_tokens_rename_id_to_token', NULL),
(37, '2018_01_15_072700_change_email_tokens_add_foreign_keys', NULL),
(38, '2018_01_15_072800_change_email_tokens_created_at_to_datetime', NULL),
(39, '2018_01_18_130400_rename_permissions_to_group_permission', NULL),
(40, '2018_01_18_130500_change_group_permission_add_foreign_keys', NULL),
(41, '2018_01_18_130600_rename_users_groups_to_group_user', NULL),
(42, '2018_01_18_130700_change_group_user_add_foreign_keys', NULL),
(43, '2018_01_18_133000_change_notifications_columns', NULL),
(44, '2018_01_18_133100_change_notifications_add_foreign_keys', NULL),
(45, '2018_01_18_134400_change_password_tokens_rename_id_to_token', NULL),
(46, '2018_01_18_134500_change_password_tokens_add_foreign_keys', NULL),
(47, '2018_01_18_134600_change_password_tokens_created_at_to_datetime', NULL),
(48, '2018_01_18_135000_change_posts_rename_columns', NULL),
(49, '2018_01_18_135100_change_posts_add_foreign_keys', NULL),
(50, '2018_01_30_112238_add_fulltext_index_to_discussions_title', NULL),
(51, '2018_01_30_220100_create_post_user_table', NULL),
(52, '2018_01_30_222900_change_users_rename_columns', NULL),
(55, '2018_09_15_041340_add_users_indicies', NULL),
(56, '2018_09_15_041828_add_discussions_indicies', NULL),
(57, '2018_09_15_043337_add_notifications_indices', NULL),
(58, '2018_09_15_043621_add_posts_indices', NULL),
(59, '2018_09_22_004100_change_registration_tokens_columns', NULL),
(60, '2018_09_22_004200_create_login_providers_table', NULL),
(61, '2018_10_08_144700_add_shim_prefix_to_group_icons', NULL),
(62, '2019_10_12_195349_change_posts_add_discussion_foreign_key', NULL),
(63, '2020_03_19_134512_change_discussions_default_comment_count', NULL),
(64, '2020_04_21_130500_change_permission_groups_add_is_hidden', NULL),
(65, '2021_03_02_040000_change_access_tokens_add_type', NULL),
(66, '2021_03_02_040500_change_access_tokens_add_id', NULL),
(67, '2021_03_02_041000_change_access_tokens_add_title_ip_agent', NULL),
(68, '2021_04_18_040500_change_migrations_add_id_primary_key', NULL),
(69, '2021_04_18_145100_change_posts_content_column_to_mediumtext', NULL),
(70, '2018_07_21_000000_seed_default_groups', NULL),
(71, '2018_07_21_000100_seed_default_group_permissions', NULL),
(72, '2021_05_10_000000_rename_permissions', NULL),
(73, '2022_05_20_000000_add_timestamps_to_groups_table', NULL),
(74, '2022_05_20_000001_add_created_at_to_group_user_table', NULL),
(75, '2022_05_20_000002_add_created_at_to_group_permission_table', NULL),
(76, '2022_07_14_000000_add_type_index_to_posts', NULL),
(77, '2022_07_14_000001_add_type_created_at_composite_index_to_posts', NULL),
(78, '2022_08_06_000000_change_access_tokens_last_activity_at_to_nullable', NULL),
(79, '2015_09_02_000000_add_flags_read_time_to_users_table', 'flarum-flags'),
(80, '2015_09_02_000000_create_flags_table', 'flarum-flags'),
(81, '2017_07_22_000000_add_default_permissions', 'flarum-flags'),
(82, '2018_06_27_101500_change_flags_rename_time_to_created_at', 'flarum-flags'),
(83, '2018_06_27_101600_change_flags_add_foreign_keys', 'flarum-flags'),
(84, '2018_06_27_105100_change_users_rename_flags_read_time_to_read_flags_at', 'flarum-flags'),
(85, '2018_09_15_043621_add_flags_indices', 'flarum-flags'),
(86, '2019_10_22_000000_change_reason_text_col_type', 'flarum-flags'),
(87, '2015_09_21_011527_add_is_approved_to_discussions', 'flarum-approval'),
(88, '2015_09_21_011706_add_is_approved_to_posts', 'flarum-approval'),
(89, '2017_07_22_000000_add_default_permissions', 'flarum-approval'),
(90, '2015_02_24_000000_create_discussions_tags_table', 'flarum-tags'),
(91, '2015_02_24_000000_create_tags_table', 'flarum-tags'),
(92, '2015_02_24_000000_create_users_tags_table', 'flarum-tags'),
(93, '2015_02_24_000000_set_default_settings', 'flarum-tags'),
(94, '2015_10_19_061223_make_slug_unique', 'flarum-tags'),
(95, '2017_07_22_000000_add_default_permissions', 'flarum-tags'),
(96, '2018_06_27_085200_change_tags_columns', 'flarum-tags'),
(97, '2018_06_27_085300_change_tags_add_foreign_keys', 'flarum-tags'),
(98, '2018_06_27_090400_rename_users_tags_to_tag_user', 'flarum-tags'),
(99, '2018_06_27_100100_change_tag_user_rename_read_time_to_marked_as_read_at', 'flarum-tags'),
(100, '2018_06_27_100200_change_tag_user_add_foreign_keys', 'flarum-tags'),
(101, '2018_06_27_103000_rename_discussions_tags_to_discussion_tag', 'flarum-tags'),
(102, '2018_06_27_103100_add_discussion_tag_foreign_keys', 'flarum-tags'),
(103, '2019_04_21_000000_add_icon_to_tags_table', 'flarum-tags'),
(104, '2022_05_20_000003_add_timestamps_to_tags_table', 'flarum-tags'),
(105, '2022_05_20_000004_add_created_at_to_discussion_tag_table', 'flarum-tags'),
(106, '2023_03_01_000000_create_post_mentions_tag_table', 'flarum-tags'),
(107, '2015_05_11_000000_add_suspended_until_to_users_table', 'flarum-suspend'),
(108, '2015_09_14_000000_rename_suspended_until_column', 'flarum-suspend'),
(109, '2017_07_22_000000_add_default_permissions', 'flarum-suspend'),
(110, '2018_06_27_111400_change_users_rename_suspend_until_to_suspended_until', 'flarum-suspend'),
(111, '2021_10_27_000000_add_suspend_reason_and_message', 'flarum-suspend'),
(112, '2015_05_11_000000_add_subscription_to_users_discussions_table', 'flarum-subscriptions'),
(113, '2015_02_24_000000_add_sticky_to_discussions', 'flarum-sticky'),
(114, '2017_07_22_000000_add_default_permissions', 'flarum-sticky'),
(115, '2018_09_15_043621_add_discussions_indices', 'flarum-sticky'),
(116, '2021_01_13_000000_add_discussion_last_posted_at_indices', 'flarum-sticky'),
(117, '2015_05_11_000000_create_mentions_posts_table', 'flarum-mentions'),
(118, '2015_05_11_000000_create_mentions_users_table', 'flarum-mentions'),
(119, '2018_06_27_102000_rename_mentions_posts_to_post_mentions_post', 'flarum-mentions'),
(120, '2018_06_27_102100_rename_mentions_users_to_post_mentions_user', 'flarum-mentions'),
(121, '2018_06_27_102200_change_post_mentions_post_rename_mentions_id_to_mentions_post_id', 'flarum-mentions'),
(122, '2018_06_27_102300_change_post_mentions_post_add_foreign_keys', 'flarum-mentions'),
(123, '2018_06_27_102400_change_post_mentions_user_rename_mentions_id_to_mentions_user_id', 'flarum-mentions'),
(124, '2018_06_27_102500_change_post_mentions_user_add_foreign_keys', 'flarum-mentions'),
(125, '2021_04_19_000000_set_default_settings', 'flarum-mentions'),
(126, '2022_05_20_000005_add_created_at_to_post_mentions_post_table', 'flarum-mentions'),
(127, '2022_05_20_000006_add_created_at_to_post_mentions_user_table', 'flarum-mentions'),
(128, '2022_10_21_000000_create_post_mentions_group_table', 'flarum-mentions'),
(129, '2021_03_25_000000_default_settings', 'flarum-markdown'),
(130, '2015_02_24_000000_add_locked_to_discussions', 'flarum-lock'),
(131, '2017_07_22_000000_add_default_permissions', 'flarum-lock'),
(132, '2018_09_15_043621_add_discussions_indices', 'flarum-lock'),
(133, '2015_05_11_000000_create_posts_likes_table', 'flarum-likes'),
(134, '2015_09_04_000000_add_default_like_permissions', 'flarum-likes'),
(135, '2018_06_27_100600_rename_posts_likes_to_post_likes', 'flarum-likes'),
(136, '2018_06_27_100700_change_post_likes_add_foreign_keys', 'flarum-likes'),
(137, '2021_05_10_094200_add_created_at_to_post_likes_table', 'flarum-likes'),
(138, '2018_09_29_060444_replace_emoji_shorcuts_with_unicode', 'flarum-emoji');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notifications`
--

CREATE TABLE `[[dbprefix]]notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `from_user_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(10) unsigned DEFAULT NULL,
  `data` blob,
  `created_at` datetime NOT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `read_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]notifications_from_user_id_foreign` (`from_user_id`),
  KEY `[[dbprefix]]notifications_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]password_tokens`
--

CREATE TABLE `[[dbprefix]]password_tokens` (
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`token`),
  KEY `[[dbprefix]]password_tokens_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]posts`
--

CREATE TABLE `[[dbprefix]]posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion_id` int(10) unsigned NOT NULL,
  `number` int(10) unsigned DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` mediumtext COLLATE utf8mb4_unicode_ci COMMENT ' ',
  `edited_at` datetime DEFAULT NULL,
  `edited_user_id` int(10) unsigned DEFAULT NULL,
  `hidden_at` datetime DEFAULT NULL,
  `hidden_user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]posts_discussion_id_number_unique` (`discussion_id`,`number`),
  KEY `[[dbprefix]]posts_edited_user_id_foreign` (`edited_user_id`),
  KEY `[[dbprefix]]posts_hidden_user_id_foreign` (`hidden_user_id`),
  KEY `[[dbprefix]]posts_discussion_id_number_index` (`discussion_id`,`number`),
  KEY `[[dbprefix]]posts_discussion_id_created_at_index` (`discussion_id`,`created_at`),
  KEY `[[dbprefix]]posts_user_id_created_at_index` (`user_id`,`created_at`),
  KEY `[[dbprefix]]posts_type_index` (`type`),
  KEY `[[dbprefix]]posts_type_created_at_index` (`type`,`created_at`),
  FULLTEXT KEY `content` (`content`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_likes`
--

CREATE TABLE `[[dbprefix]]post_likes` (
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`,`user_id`),
  KEY `[[dbprefix]]post_likes_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_mentions_group`
--

CREATE TABLE `[[dbprefix]]post_mentions_group` (
  `post_id` int(10) unsigned NOT NULL,
  `mentions_group_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`,`mentions_group_id`),
  KEY `[[dbprefix]]post_mentions_group_mentions_group_id_foreign` (`mentions_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_mentions_post`
--

CREATE TABLE `[[dbprefix]]post_mentions_post` (
  `post_id` int(10) unsigned NOT NULL,
  `mentions_post_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`,`mentions_post_id`),
  KEY `[[dbprefix]]post_mentions_post_mentions_post_id_foreign` (`mentions_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_mentions_tag`
--

CREATE TABLE `[[dbprefix]]post_mentions_tag` (
  `post_id` int(10) unsigned NOT NULL,
  `mentions_tag_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`,`mentions_tag_id`),
  KEY `[[dbprefix]]post_mentions_tag_mentions_tag_id_foreign` (`mentions_tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_mentions_user`
--

CREATE TABLE `[[dbprefix]]post_mentions_user` (
  `post_id` int(10) unsigned NOT NULL,
  `mentions_user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`post_id`,`mentions_user_id`),
  KEY `[[dbprefix]]post_mentions_user_mentions_user_id_foreign` (`mentions_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]post_user`
--

CREATE TABLE `[[dbprefix]]post_user` (
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`post_id`,`user_id`),
  KEY `[[dbprefix]]post_user_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]registration_tokens`
--

CREATE TABLE `[[dbprefix]]registration_tokens` (
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT NULL,
  `provider` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('allow_hide_own_posts', 'reply'),
('allow_post_editing', 'reply'),
('allow_renaming', '10'),
('allow_sign_up', '1'),
('custom_less', ''),
('default_locale', 'en'),
('default_route', '/all'),
('display_name_driver', 'username'),
('extensions_enabled', '["flarum-flags","flarum-approval","flarum-tags","flarum-suspend","flarum-subscriptions","flarum-sticky","flarum-statistics","flarum-mentions","flarum-markdown","flarum-lock","flarum-likes","flarum-lang-english","flarum-emoji","flarum-bbcode"]'),
('flarum-markdown.mdarea', '1'),
('flarum-mentions.allow_username_format', '1'),
('flarum-tags.max_primary_tags', '1'),
('flarum-tags.max_secondary_tags', '3'),
('flarum-tags.min_primary_tags', '1'),
('flarum-tags.min_secondary_tags', '0'),
('forum_description', '[[site_desc]]'),
('forum_title', '[[site_name]]'),
('mail_driver', 'mail'),
('mail_from', 'noreply@[[domhost]]'),
('slug_driver_Flarum\\User\\User', 'default'),
('theme_colored_header', '0'),
('theme_dark_mode', '0'),
('theme_primary_color', '#4D698E'),
('theme_secondary_color', '#4D698E'),
('version', '1.8.7'),
('welcome_message', 'Enjoy your new forum! Hop over to discuss.flarum.org if you have any questions, or to join our community!'),
('welcome_title', 'Welcome to [[site_name]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_path` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `background_mode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `default_sort` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_restricted` tinyint(1) NOT NULL DEFAULT '0',
  `is_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `discussion_count` int(10) unsigned NOT NULL DEFAULT '0',
  `last_posted_at` datetime DEFAULT NULL,
  `last_posted_discussion_id` int(10) unsigned DEFAULT NULL,
  `last_posted_user_id` int(10) unsigned DEFAULT NULL,
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]tags_slug_unique` (`slug`),
  KEY `[[dbprefix]]tags_parent_id_foreign` (`parent_id`),
  KEY `[[dbprefix]]tags_last_posted_user_id_foreign` (`last_posted_user_id`),
  KEY `[[dbprefix]]tags_last_posted_discussion_id_foreign` (`last_posted_discussion_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]tags`
--

INSERT INTO `[[dbprefix]]tags` VALUES
(1, 'General', 'general', NULL, '#888', NULL, NULL, 0, NULL, NULL, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag_user`
--

CREATE TABLE `[[dbprefix]]tag_user` (
  `user_id` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `marked_as_read_at` datetime DEFAULT NULL,
  `is_hidden` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`tag_id`),
  KEY `[[dbprefix]]tag_user_tag_id_foreign` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_email_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar_url` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferences` blob,
  `joined_at` datetime DEFAULT NULL,
  `last_seen_at` datetime DEFAULT NULL,
  `marked_all_as_read_at` datetime DEFAULT NULL,
  `read_notifications_at` datetime DEFAULT NULL,
  `discussion_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0',
  `read_flags_at` datetime DEFAULT NULL,
  `suspended_until` datetime DEFAULT NULL,
  `suspend_reason` text COLLATE utf8mb4_unicode_ci,
  `suspend_message` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]users_username_unique` (`username`),
  UNIQUE KEY `[[dbprefix]]users_email_unique` (`email`),
  KEY `[[dbprefix]]users_joined_at_index` (`joined_at`),
  KEY `[[dbprefix]]users_last_seen_at_index` (`last_seen_at`),
  KEY `[[dbprefix]]users_discussion_count_index` (`discussion_count`),
  KEY `[[dbprefix]]users_comment_count_index` (`comment_count`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_email]]', 1, '[[admin_pass]]', NULL, NULL, '[[regtime]]', '[[regtime]]', NULL, NULL, 0, 0, NULL, NULL, NULL, NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]access_tokens`
--
ALTER TABLE `[[dbprefix]]access_tokens`
  ADD CONSTRAINT `[[dbprefix]]access_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]api_keys`
--
ALTER TABLE `[[dbprefix]]api_keys`
  ADD CONSTRAINT `[[dbprefix]]api_keys_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]discussions`
--
ALTER TABLE `[[dbprefix]]discussions`
  ADD CONSTRAINT `[[dbprefix]]discussions_first_post_id_foreign` FOREIGN KEY (`first_post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]discussions_hidden_user_id_foreign` FOREIGN KEY (`hidden_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]discussions_last_post_id_foreign` FOREIGN KEY (`last_post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]discussions_last_posted_user_id_foreign` FOREIGN KEY (`last_posted_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]discussion_tag`
--
ALTER TABLE `[[dbprefix]]discussion_tag`
  ADD CONSTRAINT `[[dbprefix]]discussion_tag_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `[[dbprefix]]discussions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]discussion_tag_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `[[dbprefix]]tags` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]discussion_user`
--
ALTER TABLE `[[dbprefix]]discussion_user`
  ADD CONSTRAINT `[[dbprefix]]discussion_user_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `[[dbprefix]]discussions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]discussion_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]email_tokens`
--
ALTER TABLE `[[dbprefix]]email_tokens`
  ADD CONSTRAINT `[[dbprefix]]email_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]flags`
--
ALTER TABLE `[[dbprefix]]flags`
  ADD CONSTRAINT `[[dbprefix]]flags_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]flags_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]group_permission`
--
ALTER TABLE `[[dbprefix]]group_permission`
  ADD CONSTRAINT `[[dbprefix]]group_permission_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]groups` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]group_user`
--
ALTER TABLE `[[dbprefix]]group_user`
  ADD CONSTRAINT `[[dbprefix]]group_user_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `[[dbprefix]]groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]group_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]login_providers`
--
ALTER TABLE `[[dbprefix]]login_providers`
  ADD CONSTRAINT `[[dbprefix]]login_providers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]notifications`
--
ALTER TABLE `[[dbprefix]]notifications`
  ADD CONSTRAINT `[[dbprefix]]notifications_from_user_id_foreign` FOREIGN KEY (`from_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]password_tokens`
--
ALTER TABLE `[[dbprefix]]password_tokens`
  ADD CONSTRAINT `[[dbprefix]]password_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]posts`
--
ALTER TABLE `[[dbprefix]]posts`
  ADD CONSTRAINT `[[dbprefix]]posts_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `[[dbprefix]]discussions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]posts_edited_user_id_foreign` FOREIGN KEY (`edited_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]posts_hidden_user_id_foreign` FOREIGN KEY (`hidden_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]posts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]post_likes`
--
ALTER TABLE `[[dbprefix]]post_likes`
  ADD CONSTRAINT `[[dbprefix]]post_likes_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_likes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]post_mentions_group`
--
ALTER TABLE `[[dbprefix]]post_mentions_group`
  ADD CONSTRAINT `[[dbprefix]]post_mentions_group_mentions_group_id_foreign` FOREIGN KEY (`mentions_group_id`) REFERENCES `[[dbprefix]]groups` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_mentions_group_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]post_mentions_post`
--
ALTER TABLE `[[dbprefix]]post_mentions_post`
  ADD CONSTRAINT `[[dbprefix]]post_mentions_post_mentions_post_id_foreign` FOREIGN KEY (`mentions_post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_mentions_post_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]post_mentions_tag`
--
ALTER TABLE `[[dbprefix]]post_mentions_tag`
  ADD CONSTRAINT `[[dbprefix]]post_mentions_tag_mentions_tag_id_foreign` FOREIGN KEY (`mentions_tag_id`) REFERENCES `[[dbprefix]]tags` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_mentions_tag_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]post_mentions_user`
--
ALTER TABLE `[[dbprefix]]post_mentions_user`
  ADD CONSTRAINT `[[dbprefix]]post_mentions_user_mentions_user_id_foreign` FOREIGN KEY (`mentions_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_mentions_user_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]post_user`
--
ALTER TABLE `[[dbprefix]]post_user`
  ADD CONSTRAINT `[[dbprefix]]post_user_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]post_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]tags`
--
ALTER TABLE `[[dbprefix]]tags`
  ADD CONSTRAINT `[[dbprefix]]tags_last_posted_discussion_id_foreign` FOREIGN KEY (`last_posted_discussion_id`) REFERENCES `[[dbprefix]]discussions` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]tags_last_posted_user_id_foreign` FOREIGN KEY (`last_posted_user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]tags_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]tags` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]tag_user`
--
ALTER TABLE `[[dbprefix]]tag_user`
  ADD CONSTRAINT `[[dbprefix]]tag_user_tag_id_foreign` FOREIGN KEY (`tag_id`) REFERENCES `[[dbprefix]]tags` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]tag_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
