<?php
    session_start();
?>

    <!DOCTYPE html>
<html lang="en">

<head>
    <!-- ========== Meta Tags ========== -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- ========== Page Title ========== -->
    <title>FMAU Quiz Night - Hosted By Cornerstone Asset Managers</title>

    <meta name="description" content="FMAU Quiz Night - Hosted By Cornerstone Asset Managers">

    <!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="../../assets/img/favicon.png" type="image/x-icon">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://cornerstoneassetmanagers.com/assets/img/stock/fmau/card/1.jpeg">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="FUND MANAGERS ASSOCIATION OF UGANDA">

    <meta property="og:url" content="https://cornerstone.co.ug/forms/fmau-quiz">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="FMAU Quiz Night - Hosted By Cornerstone Asset Managers">

    <meta property="og:site_name" content="FMAU Quiz Night - Hosted By Cornerstone Asset Managers">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://cornerstone.co.ug/forms/fmau-quiz">

    <meta name="twitter:title" content="FUND MANAGERS ASSOCIATION OF UGANDA">

    <meta name="twitter:description" content="FMAU Quiz Night - Hosted By Cornerstone Asset Managers">

    <meta name="twitter:image" content="https://cornerstoneassetmanagers.com/assets/img/stock/fmau/card/1.jpeg">

    <meta name="twitter:site" content="@cornerstone_asset_managers">

    <meta name="twitter:creator" content="@iann_thecreator">

    <!-- ========== Start Stylesheet ========== -->
    <link href="../../assets/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../../assets/css/font-awesome.min.css" rel="stylesheet" />
    <link href="../../assets/css/themify-icons.css" rel="stylesheet" />
    <link href="../../assets/css/flaticon-set.css" rel="stylesheet" />
    <link href="../../assets/css/magnific-popup.css" rel="stylesheet" />
    <link href="../../assets/css/owl.carousel.min.css" rel="stylesheet" />
    <link href="../../assets/css/owl.theme.default.min.css" rel="stylesheet" />
    <link href="../../assets/css/animate.css" rel="stylesheet" />
    <link href="../../assets/css/bootsnav.css" rel="stylesheet" />
    <link href="../../assets/css/style.css" rel="stylesheet">
    <link href="../../assets/css/responsive.css" rel="stylesheet" />  

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="../../assets/css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="../../assets/css/fontawesome/css/all.css" rel="stylesheet">

    <link href="../../assets/css/datatable/dataTable.bootstrap.min.css" rel="stylesheet">  

    <!-- ========== End Stylesheet ========== -->

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="../../assets/js/html5/html5shiv.min.js"></script>
      <script src="../../assets/js/html5/respond.min.js"></script>
    <![endif]-->

    <!-- ========== Google Fonts ========== -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@200;300;400;600;700;800&display=swap" rel="stylesheet">


<style type="text/css">

.bg-dark {
    background: #000 !important;
}

.navbar-header {
    display: none;
}

.contact-items {
    background-color: rgba(255, 255, 255, 0.6) !important;
    backdrop-filter: blur(3px);
  -moz-backdrop-filter: blur(3px);
  -o-backdrop-filter: blur(3px);
  -webkit-backdrop-filter: blur(3px);
}

.address-details.two {
    display: none;
}

.address-details i {
    color: #e51e23 !important;
}

.left-item form input,
.left-item form textarea {
    border-bottom: 1px solid #e51e23 !important;
    background: none;
}


/* If the screen size is  btn 767.98px less and 576px wide */
@media screen and (max-width: 991.98px) and (min-width: 0) {

.address-details.one {
    display: none !important;
}

.address-details.two {
    display: block !important;
}

.navbar-header {
    display: block !important;
}

}

</style>

</head>

<body>

    <!-- Preloader Start --
    <div class="se-pre-con"></div>
    -- Preloader Ends --><!-- Header 
    ============================================= -->
    <header id="home">

        <!-- Start Navigation -->
        <nav class="navbar navbar-sticky bootsnav">

            

    <!-- Start Header Top 
    ============================================= -->
    <div class="top-bar-area overflow-hidden navbar-sticky bg-dark text-light">
        <div class="container">
            <div class="row align-center">
                
                <div class="col-lg-9 info">
                    <div class="info box item-flex">
                    <a class="navbar-brand1" href="../../">
                        <img src="../../assets/img/stock/fmau/logo/3.png" class="logo" width="150px" alt="Logo">
                    </a>
                        <ul class="list">
                            <li><b>QUIZ NIGHT FORM</b></li>
                        </ul>
                        <ul class="social">
                            <li class="facebook">
                                <i class="fab fa-facebook"></i>
                            </li>
                            <li class="twitter">
                                <i class="fab fa-x-twitter"></i>
                            </li>
                            <li class="pinterest">
                                <i class="fab fa-instagram"></i>
                            </li>
                            <li class="linkedin">
                                <i class="fab fa-linkedin"></i>
                            </li>
                            <li class="youtube">
                                <i class="fab fa-youtube"></i>
                            </li>
                            <li class="whatsapp">
                                <i class="fab fa-whatsapp"></i>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-3 text-right button-box">
                    <div class="button login-signup">
                        <a href="https://my.cornerstone.co.ug/?agid=39" class="text-uppercase" target="_blank">Invest In Unit Trusts <i class="fa fa-arrow-circle-right ml-2 float-bounce-right"></i></a>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Header Top -->

                <!-- Start Header Navigation -->
                <div class="navbar-header">

                    <div class="text-right navbar-login mr-2 mt-4">
                        <a href="https://my.cornerstone.co.ug/?agid=39" class="btn btn-dark border-dark bg-white btn-sm text-dark" target="_blank">Unit Trusts <i class="fa fa-arrow-circle-right ml-2 float-bounce-right"></i></a>
                    </div>

                    <a class="navbar-brand1" href="#!">
                        <img src="../../assets/img/stock/fmau/logo/2.png" class="logo" alt="Logo" width="150px" align="left">
                    </a>

                </div>
                <!-- End Header Navigation -->

        </nav>
        <!-- End Navigation -->

    </header>
    <!-- End Header -->
    

    <!-- Start Breadcrumb 
    ============================================= -->
    <div class="breadcrumb-area gradient-bg bg-cover shadow dark text-light text-center" style="background-image: url(../../assets/img/stock/fmau/header/3.png);background-attachment: fixed;">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <h1>FMAU Quiz Night</h1>
                    <h6>FUND MANAGERS ASSOCIATION OF UGANDA</h6>
                    <p style="font-size: 12px;">Join us for the Ultimate Quiz Night-an engaging team-building event filled with fun trivia, collaboration, and friendly competition. Come connect, participate, and enjoy an unforgettable evening. Hosted by Cornerstone Asset Managers.</p>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb -->
    <?php

        if(isset($_SESSION['error'])){
          echo
          "
          <div class='alert' style='margin-top:15px; color: #fff;font-weight: bold;border-radius: 10px !important;padding: 5px 60px;'>
                <ol class='breadcrumb'>
                  <li>
            <button class='close' style='position: absolute;right: 35px;color: #fff;opacity: 1;'>&times;</button>
            ".$_SESSION['error']."
          </li>
                </ol>
              </div>
          ";
          unset($_SESSION['error']);
        }
        if(isset($_SESSION['success'])){
          echo
          "
          <div class='alert' style='margin-top:15px; color: #fff;font-weight: bold;border-radius: 10px !important;padding: 5px 40px;'>
                <ol class='breadcrumb'>
                  <li>
            <button class='close' style='color: #fff;opacity: 1;margin-left: 30px;'>&times;</button>
            ".$_SESSION['success']."
          </li>
                </ol>
              </div>
          ";
          unset($_SESSION['success']);
        }
  ?>

    <!-- Start Contact Area
    ============================================= -->
    <div class="contact-area default-padding">
        <!-- Fixed BG -->
        <div class="fixed-bg">
            <img src="../../assets/img/illustration/3.png" alt="Thumb">
        </div>
        <!-- End Fixed BG -->
        <div class="container">
            <div class="contact-items">
                <div class="row align-center">

                    <div class="col-lg-4 right-item address-details one">
                        <div class="info-items text-light">
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-map-marked-alt"></i>
                                </div>
                                <div class="info">
                                    <h5>Location</h5>
                                    <p>
                                         P.O Box 160498 <br> 
                                         Plot 16A, Ntinda II Road <br>
                                         Naguru, Kampala (Uganda) 
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="info">
                                    <h5>Call Us</h5>
                                    <p>
                                        <a href="tel:+256742325242">+256 742 325242</a>
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-envelope-open"></i>
                                </div>
                                <div class="info">
                                    <h5>Send Mail</h5>
                                    <p>
                                        <a href="mailto:clientsupport@cornerstone.co.ug" style="font-weight: normal;font-size: 12px;">admin@fundmanagersuganda.com</a>
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                        </div>
                    </div>
                    
                    <div class="col-lg-8 left-item">
                        <div class="content">
                            <h2>Join the Quiz Night.<span class="flash">.</span></h2>
                            <p>A night of brains, banter, and bragging rights!</p>

                            <form action="quiz/index.php" method="POST">
                                <div class="row">


                                    <input type="hidden" name="quiz_event" value="FMAU Quiz Night">
                                    <input type="hidden" name="quiz_event_id" value="<?php echo date("HisdmY",time()); ?>">

                                    <div class="col-lg-12 username">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="quiz_username" placeholder="Username">
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="quiz_name" placeholder="Your names" required>
                                            <span class="alert-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <input type="email" class="form-control" name="quiz_email" placeholder="Email Address" required>
                                            <span class="alert-error"></span>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="quiz_phone" placeholder="Phone Number" required>
                                            <span class="alert-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group comments">
                                            <textarea class="form-control" name="quiz_suggestion" placeholder="Suggest an idea for the quiz night (Optional)"></textarea>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <button type="submit" name="quiz_submit" style="background: #e51e23">
                                            Proceed to join <i class="fa fa-arrow-right ml-2 float-bounce-right"></i>
                                        </button>
                                    </div>
                                </div>
                                <!-- Alert Message -->
                                <div class="col-lg-12 alert-notification">
                                    <div id="message" class="alert-msg"></div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="col-lg-4 right-item address-details two">
                        <div class="info-items text-light">
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-map-marked-alt"></i>
                                </div>
                                <div class="info">
                                    <h5>Location</h5>
                                    <p>
                                         P.O Box 160498 <br> 
                                         Plot 16A, Ntinda II Road <br>
                                         Naguru, Kampala (Uganda) 
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="info">
                                    <h5>Call Us</h5>
                                    <p>
                                        <a href="tel:+256742325242">+256 742 325242</a>
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                            <!-- Single Item -->
                            <div class="item">
                                <div class="icon">
                                    <i class="fas fa-envelope-open"></i>
                                </div>
                                <div class="info">
                                    <h5>Send Mail</h5>
                                    <p>
                                        <a href="mailto:clientsupport@cornerstone.co.ug" style="font-weight: normal;font-size: 12px;">admin@fundmanagersuganda.com</a>
                                    </p>
                                </div>
                            </div>
                            <!-- End Single Item -->
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- End Contact -->

    <p style='color:#555;padding: 0 60px;font-size: 12px;'>The FMAU Quiz Night is an event organized by the Fund Managers Association of Uganda and hosted by Cornerstone Asset Managers. For more information, kindly call us on <span class='link3-u' style='color:#555; text-decoration:underline;'><a href='tel:+256742325242' style='color:#555;'>+256 742 325242</a></span></p>

    <!-- Start Google Maps 
    ============================================= 
    <div class="maps-area">
        <div class="google-maps">
            <iframe src="https://www.google.com/maps/embed?pb=!1m26!1m12!1m3!1d63836.21016989284!2d32.56389284458511!3d0.30134987209251224!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!4m11!3e6!4m3!3m2!1d0.262395!2d32.6321656!4m5!1s0x177dbbaf4cea8a9d%3A0x6872ba4a55aad286!2s22%20Bukoto%20St%2C%20Kampala!3m2!1d0.3403082!2d32.5882674!5e0!3m2!1sen!2sug!4v1702482084751!5m2!1sen!2sug" width="100%" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </div>
     End Google Maps -->

    <!-- Start Footer 
    ============================================= -->
    <footer class="bg-dark text-light">
        <!-- Fixed Shape -->

        <div class="footer-bottom">
            <div class="container">
                <div class="row pt-4">
                    <div class="col-lg-4">
                        <ul class="footer-social">
                            <li class="facebook mr-2">
                                <a href="https://www.facebook.com/profile.php?id=61569347717892"><i class="fab fa-facebook"></i></a>
                            </li>
                            <li class="twitter mr-2">
                                <a href="https://x.com/csassetmanagers?s=21"><i class="fab fa-x-twitter"></i></a>
                            </li>
                            <li class="pinterest mr-2">
                                <a href="https://www.instagram.com/cornerstone_assetmanagers/profilecard/?igsh=MW40eXh1cDZ0NnFwZQ=="><i class="fab fa-instagram"></i></a>
                            </li>
                            <li class="linkedin mr-2">
                                <a href="https://www.linkedin.com/company/cornerstone-asset-managers/"><i class="fab fa-linkedin"></i></a>
                            </li>
                            <li class="youtube mr-2">
                                <a href="https://www.youtube.com/channel/UC4ODu7TJiwK2FfToYPRgTYg"><i class="fab fa-youtube"></i></a>
                            </li>
                            <li class="whatsapp">
                                <a href="https://wa.me/256767936167?text=https://cornerstone.co.ug *Cornerstone Support* %0D%0A  %0D%0A Hello, we are always happy to hear from you %0D%0A  %0D%0A"><i class="fab fa-whatsapp"></i></a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-4 text-center">
                        <p style="color: #e51e23;">Fund Managers Association of Uganda</a> &copy; <script>document.write(new Date().getFullYear());</script></p>
                    </div>
                    <div class="col-lg-4 text-right">
                        <p class="text-gradient" style="font-size: 12px;">Powered by Cornerstone Asset Managers</p>
                    </div>
                </div>
            </div>
        </div>
        <!-- Start Footer Bottom -->

        <div class="fixed-shape">
            <img src="../../assets/img/shape/3.svg" alt="Shape">
        </div>
        <!-- End Fixed Shape -->
    </footer>
    <!-- End Footer -->

    <!----Modals Start---->
    <?php include('../../modals/quote.php'); ?>
    <!----Modals End---->

    <!-- jQuery Frameworks
    ============================================= -->
    <script src="../../assets/js/jquery-1.12.4.min.js"></script>
    <script src="../../assets/js/popper.min.js"></script>
    <script src="../../assets/js/bootstrap.min.js"></script>
    <script src="../../assets/js/equal-height.min.js"></script>
    <script src="../../assets/js/jquery.appear.js"></script>
    <script src="../../assets/js/jquery.easing.min.js"></script>
    <script src="../../assets/js/jquery.magnific-popup.min.js"></script>
    <script src="../../assets/js/modernizr.custom.13711.js"></script>
    <script src="../../assets/js/owl.carousel.min.js"></script>
    <script src="../../assets/js/wow.min.js"></script>
    <script src="../../assets/js/progress-bar.min.js"></script>
    <script src="../../assets/js/isotope.pkgd.min.js"></script>
    <script src="../../assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="../../assets/js/count-to.js"></script>
    <script src="../../assets/js/bootsnav.js"></script>
    <script src="../../assets/js/main.js"></script>

    <script src="../../assets/js/datatable/jquery.dataTables.min.js"></script>
    <script src="../../assets/js/datatable/dataTable.bootstrap.min.js"></script>

<script>
$(document).ready(function(){
  //inialize datatable
    $('#myTable').DataTable();

    //hide alert
    $(document).on('click', '.close', function(){
      $('.alert').hide();
    })
});
</script>



<script>
$(document).ready(function() {
  var delay = 500;
  $('#newsletter').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();

    var newsletter = $('#newsletter').val();

    var email = $('#email').val();
        if(email == ''){
      $('.message_box').html(
      '<span style="color:white;font-size: 14px;">Please Enter An Email Address!</span>'
      );
      $('#email').focus();
            return false;
      }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('.message_box').html(
      '<span style="color:white;font-size: 14px;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
      }
    
          
      $.ajax
      ({
             type: "POST",
       url: "../../contact-us/newsletters/index.php",
             data: "email="+email+"&username="+username+"&newsletter="+newsletter,
       beforeSend: function() {
       $('.message_box_one').html(
       '<button type="submit" id="newsletter" name="newsletter" class="message_box_one"><img src="../../assets/img/success.gif" width="25" height="25"/></button>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('.message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};
</script>

</body>
</html>