<?php

/******************************************************************************
 * Each entry of that file can be associated with a comment to indicate its   *
 * state. When there is no comment, it means the entry is fully translated.   *
 * The recognized comments are (comment matching is case-insensitive):        *
 *   + TODO: the entry has never been translated.                             *
 *   + DIRTY: the entry has been translated but needs to be updated.          *
 *   + IGNORE: the entry does not need to be translated.                      *
 * When a comment is not recognized, it is discarded.                         *
 ******************************************************************************/

return array(
	'auth' => array(
		'allow_anonymous' => 'Allow anonymous reading of the default user’s articles (%s)',
		'allow_anonymous_refresh' => 'Allow anonymous refresh of the articles',
		'api_enabled' => 'Allow <abbr>API</abbr> access <small>(required for mobile apps and sharing user queries)</small>',
		'form' => 'Web form (traditional, requires JavaScript)',
		'http' => 'HTTP (advanced: managed by Web server, OIDC, SSO…)',
		'none' => 'None (dangerous)',
		'title' => 'Authentication',
		'token' => 'Master authentication token',
		'token_help' => 'Allows access to all RSS outputs of the user as well as refreshing feeds without authentication:',
		'type' => 'Authentication method',
	),
	'extensions' => array(
		'author' => 'Author',
		'community' => 'Available community extensions',
		'description' => 'Description',
		'disabled' => 'Disabled',
		'empty_list' => 'There are no installed extensions',
		'empty_list_help' => 'Check the logs to determine the reason behind the empty extension list.',
		'enabled' => 'Enabled',
		'is_compatible' => 'Is compatible',	// TODO
		'latest' => 'Installed',
		'name' => 'Name',
		'no_configure_view' => 'This extension cannot be configured.',
		'system' => array(
			'_' => 'System extensions',
			'no_rights' => 'System extension (you do not have the required permissions)',
		),
		'title' => 'Extensions',
		'update' => 'Update available',
		'user' => 'User extensions',
		'version' => 'Version',
	),
	'stats' => array(
		'_' => 'Statistics',
		'all_feeds' => 'All feeds',
		'category' => 'Category',
		'date_published' => 'Publication date',
		'date_received' => 'Received date',
		'entry_count' => 'Entry count',
		'entry_per_category' => 'Entries per category',
		'entry_per_day' => 'Entries per day (last 30 days)',
		'entry_per_day_of_week' => 'Per day of week (average: %.2f messages)',
		'entry_per_hour' => 'Per hour (average: %.2f messages)',
		'entry_per_month' => 'Per month (average: %.2f messages)',
		'entry_repartition' => 'Entries repartition',
		'feed' => 'Feed',
		'feed_per_category' => 'Feeds per category',
		'idle' => 'Idle feeds',
		'main' => 'Main statistics',
		'main_stream' => 'Main stream',
		'nb_unreads' => 'Number of unread articles',
		'no_idle' => 'There are no idle feeds!',
		'number_entries' => '%d articles',
		'overview' => 'Overview',
		'percent_of_total' => '% of total',
		'repartition' => 'Articles repartition: %s',
		'status_favorites' => 'Favourites',
		'status_read' => 'Read',
		'status_total' => 'Total',
		'status_unread' => 'Unread',
		'title' => 'Statistics',
		'top_feed' => 'Top ten feeds',
		'unread_dates' => 'Dates with most unread articles',
	),
	'system' => array(
		'_' => 'System configuration',
		'auto-update-url' => 'Auto-update server URL',
		'base-url' => array(
			'_' => 'Base URL',
			'recommendation' => 'Automatic recommendation: <kbd>%s</kbd>',
		),
		'cookie-duration' => array(
			'help' => 'in seconds',
			'number' => 'Duration to keep logged in',
		),
		'force_email_validation' => 'Force email address validation',
		'instance-name' => 'Instance name',
		'max-categories' => 'Max number of categories per user',
		'max-feeds' => 'Max number of feeds per user',
		'registration' => array(
			'number' => 'Max number of accounts',
			'select' => array(
				'label' => 'Registration form',
				'option' => array(
					'noform' => 'Disabled: No registration form',
					'nolimit' => 'Enabled: No limit of accounts',
					'setaccountsnumber' => 'Set max. number of accounts',
				),
			),
			'status' => array(
				'disabled' => 'Form disabled',
				'enabled' => 'Form enabled',
			),
			'title' => 'User registration form',
		),
		'sensitive-parameter' => 'Sensitive parameter. Edit manually in <kbd>./data/config.php</kbd>',
		'tos' => array(
			'disabled' => 'is not given',
			'enabled' => '<a href="./?a=tos">is enabled</a>',
			'help' => 'How to <a href="https://freshrss.github.io/FreshRSS/en/admins/12_User_management.html#enable-terms-of-service-tos" target="_blank">enable the Terms of Service</a>',
		),
		'websub' => array(
			'help' => 'About <a href="https://freshrss.github.io/FreshRSS/en/users/WebSub.html" target="_blank">WebSub</a>',
		),
	),
	'update' => array(
		'_' => 'Update FreshRSS',
		'apply' => 'Start update',
		'changelog' => 'Changelog',
		'check' => 'Check for new updates',
		'copiedFromURL' => 'update.php copied from %s to ./data',
		'current_version' => 'Current installed version',
		'last' => 'Last check',
		'loading' => 'Updating…',
		'none' => 'No update available',
		'releaseChannel' => array(
			'_' => 'Release channel',
			'edge' => 'Rolling release (“edge”)',
			'latest' => 'Stable release (“latest”)',
		),
		'title' => 'Update FreshRSS',
		'viaGit' => 'Update via git and GitHub.com started',
	),
	'user' => array(
		'admin' => 'Administrator',
		'article_count' => 'Articles',
		'back_to_manage' => '← Return to user list',
		'create' => 'Create new user',
		'database_size' => 'Database size',
		'email' => 'Email address',
		'enabled' => 'Enabled',
		'feed_count' => 'Feeds',
		'is_admin' => 'Is admin',
		'language' => 'Language',
		'last_user_activity' => 'Last user activity',
		'list' => 'User list',
		'number' => 'There is %d account created',
		'numbers' => 'There are %d accounts created',
		'password_form' => 'Password<br /><small>(for the Web-form login method)</small>',
		'password_format' => 'At least 7 characters',
		'title' => 'Manage users',
		'username' => 'Username',
	),
);
