<?php
/*
Gibbon: the flexible, open school platform
Founded by Ross Parker at ICHK Secondary. Built by Ross Parker, Sandra Kuipers and the Gibbon community (https://gibbonedu.org/about/)
Copyright © 2010, Gibbon Foundation
Gibbon™, Gibbon Education Ltd. (Hong Kong)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

//Takes a number, and returns an Excel-style column reference for it
function num2alpha($n)
{
    for ($r = ''; $n >= 0; $n = intval($n / 26) - 1) {
        $r = chr($n % 26 + 0x41).$r;
    }

    return $r;
}

function getColourArray()
{
    $return = array();

    $return[0] = '54, 175, 56';
    $return[1] = '192, 89, 203';
    $return[2] = '30, 30, 200';
    $return[3] = '65, 83, 84';
    $return[4] = '206, 169, 83';
    $return[5] = '30, 255, 30';
    $return[6] = '255, 40, 40';
    $return[7] = '146, 156, 163';
    $return[8] = '121, 126, 203';
    $return[9] = '86, 117, 57';
    $return[10] = '114, 66, 47';
    $return[11] = '93, 55, 98';

    return $return;
}
