<?php
/*
Gibbon: the flexible, open school platform
Founded by Ross Parker at ICHK Secondary. Built by Ross Parker, Sandra Kuipers and the Gibbon community (https://gibbonedu.org/about/)
Copyright © 2010, Gibbon Foundation
Gibbon™, Gibbon Education Ltd. (Hong Kong)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

namespace Gibbon\Domain\User;

use Gibbon\Domain\QueryCriteria;
use Gibbon\Domain\QueryableGateway;
use Gibbon\Domain\Traits\TableAware;

/**
 * User Photo Gateway
 *
 * @version v30
 * @since   v30
 */
class PersonPhotoGateway extends QueryableGateway
{
    use TableAware;

    private static $tableName = 'gibbonPersonPhoto';
    private static $primaryKey = 'gibbonPersonPhotoID';

    private static $searchableColumns = [''];


    public function queryPersonPhoto(QueryCriteria $criteria, $gibbonPersonID) {
        $query = $this
            ->newQuery()
            ->cols(['gibbonPersonPhoto.gibbonPersonPhotoID', 'gibbonPersonPhoto.gibbonSchoolYearID', 'gibbonPersonPhoto.gibbonPersonID', 'gibbonPersonPhoto.personImage', 'gibbonPersonPhoto.gibbonPersonIDCreated', 'gibbonPersonPhoto.timestamp'])
            ->from('gibbonPersonPhoto')
            ->leftJoin('gibbonPerson', 'gibbonPerson.gibbonPersonID=gibbonPersonPhoto.gibbonPersonID')
            ->where('gibbonPersonPhoto.gibbonPersonID = :gibbonPersonID')
            ->bindValue('gibbonPersonID', $gibbonPersonID);
            
        return $this->runQuery($query, $criteria);
    }

      public function queryPersonPhotoByPerson(QueryCriteria $criteria, $gibbonPersonID) {
        $query = $this
            ->newQuery()
            ->cols(['gibbonPersonPhoto.gibbonPersonPhotoID', 'gibbonPersonPhoto.gibbonSchoolYearID', 'gibbonPersonPhoto.gibbonPersonID', 'gibbonPersonPhoto.personImage', 'gibbonPersonPhoto.gibbonPersonIDCreated', 'gibbonPersonPhoto.timestamp', 'gibbonSchoolYear.name as schoolYear', 'modified.surname', 'modified.preferredName'])
            ->from('gibbonPersonPhoto')
            ->leftJoin('gibbonPerson as modified', 'modified.gibbonPersonID=gibbonPersonPhoto.gibbonPersonIDCreated')
            ->leftJoin('gibbonSchoolYear', 'gibbonSchoolYear.gibbonSchoolYearID=gibbonPersonPhoto.gibbonSchoolYearID')
            ->where('gibbonPersonPhoto.gibbonPersonID = :gibbonPersonID')
            ->bindValue('gibbonPersonID', $gibbonPersonID);
            
        return $this->runQuery($query, $criteria);
    }
}
