Ext.define('go.modules.business.business.AgreementGrid', {
	extend: go.grid.GridPanel,

	userId: null, // set when create
	tbar: [{
		xtype: 'tbtitle',
		text: t('Employment agreements')
	},'->',{
		iconCls: 'ic-add',
		handler: function () {
			const grid = this.ownerCt.ownerCt;
			let values = {employeeId: grid.userId}, budgets = {},
				dlg = new go.modules.business.business.AgreementDialog();
			if (grid.getStore().data.length > 0) {

				Ext.MessageBox.confirm(t('Copy working hours and budgets', 'business', 'business')
					, t('Do you want to copy the values of the current agreement?', 'business', 'business'),
					function (btn) {
						if (btn === 'yes') {
							const lastRecord = grid.getStore().getAt(grid.getStore().data.length - 1);
							if (lastRecord) {
								values = lastRecord.data;
								// By default, we start an agreement the first of next year
								let currYear = new Date(lastRecord.data.start).getFullYear(), startDate = new Date(values.start);
								startDate.setFullYear((currYear +1), 0, 1);
								values.start = startDate;
								budgets = values.budgets || {};
								delete values.budgets;
								delete values.id;
								delete values.finish;
							}
							dlg.setValues(values).show();

							// Apply current budgets to new period
							if (!Ext.isEmpty(budgets)) {
								go.Db.store('Activity').all(function (success, activities) {
									if (success) {
										dlg.updateYearBudgetComponent(activities, budgets);
									}
								});
							}
						} else {
							dlg.setValues(values).show();
						}
					}, this);

			} else {
				dlg.setValues(values).show();
			}
			dlg.on('close', function() {
				grid.getStore().reload();
			})
		}
	}],
	autoHeight:true,
	viewConfig: {
		forceFit: true,
		actionConfig: {
			scope: this,
			menu: new Ext.menu.Menu({
				items: [
					{
						itemId: "view",
						iconCls: 'ic-edit',
						text: t("Edit"),
						handler: function(item) {
							const record = item.parentMenu.grid.store.getAt(item.parentMenu.rowIndex);
							item.parentMenu.grid.edit(record);
						},
						scope: this
					}
					,{
						itemId:"delete",
						iconCls: 'ic-delete',
						text: t("Delete"),
						handler: function(item) {
							const record = item.parentMenu.grid.store.getAt(item.parentMenu.rowIndex);

							item.parentMenu.grid.getSelectionModel().selectRecords([record]);
							item.parentMenu.grid.deleteSelected();
						},
						scope: this
					}
				]
			})

		}
	},
	columns: [
		{header:t('Start at'), dataIndex: 'start', xtype: 'datecolumn'},
		{header:t('Finish at'), dataIndex: 'finish', xtype: 'datecolumn'},
		{header: t("short_days")[1], dataIndex: 'mo', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[2], dataIndex: 'tu', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[3], dataIndex: 'we', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[4], dataIndex: 'th', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[5], dataIndex: 'fr', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[6], dataIndex: 'sa', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t("short_days")[0], dataIndex: 'su', width:50, renderer: go.grid.ColumnRenderers.duration},
		{header: t('Total'), width:60, renderer: function(value,meta,r) {
				const d = r.data;
				return go.util.Format.duration(((d.mo+d.tu+d.we+d.th+d.fr+d.sa+d.su) * 60));
			}}
	],
	listeners: {
		rowdblclick: function (grid, rowIndex, e) {
			const record = grid.getStore().getAt(rowIndex);
			grid.edit(record);
		},
		scope:this
	},

	edit: function(record) {
		let dlg = new go.modules.business.business.AgreementDialog();
		dlg.load(record.id).show();
	},



	initComponent: function() {
		this.store = new go.data.Store({
			entityStore: 'EmployeeAgreement',
			fields: [
				'employeeId',
				{name:'start',type:'date'},
				{name:'finish',type:'date'},
				'mo','tu','we','th','fr','sa','su',
				'budgets'
			],
			sortInfo:{
				field: 'start',
				direction: 'ASC'
			}
		});
		this.callParent();
	}
});
