Ext.onReady(function() {

	Ext.override(go.users.SystemSettingsUserGrid, {

		initColumns: go.users.SystemSettingsUserGrid.prototype.initColumns.createSequence(function (fields,columns) {
			fields.push('employee.hourlyRevenue','employee.hourlyCosts', 'employee.businessId', 'employee.timeClosedUntil', 'employee.quitAt');
			columns.push({
				header: t('Hourly revenue', 'business', 'business'),
				width: dp(100),
				sortable: true,
				dataIndex: 'employee.hourlyRevenue',
				renderer: go.grid.ColumnRenderers.currency // passed_rate,send_tr_reminder
			},{
				header: t('Hourly costs', 'business', 'business'),
				width: dp(100),
				sortable: true,
				dataIndex: 'employee.hourlyCosts',
				renderer: go.grid.ColumnRenderers.currency
			},{
				// 	header: t('Business'),
				// 	width: dp(100),
				// 	sortable: true,
				// 	dataIndex: 'employee.businessId'
				// },{
				xtype:'datecolumn',
				header: t('Timesheet closed until', 'business', 'business'),
				width: dp(100),
				sortable: true,
				dataIndex: 'employee.timeClosedUntil'
			},{
				xtype:'datecolumn',
				header: t('Quit', 'business', 'business'),
				width: dp(100),
				sortable: true,
				dataIndex: 'employee.quitAt'
			});
			return {columns:columns, fields:fields};
		}),

		initComponent: go.users.SystemSettingsUserGrid.prototype.initComponent.createSequence(function () {

			// state is broken with colunns override
			// todo: fix state and remove these 2 lines
			// this.stateId = null;
			// this.id = null;
			//
			// this.store = store;
			// this.reconfigure(store, new Ext.grid.ColumnModel({columns:columns}));
			//
			// var searchBars = this.getTopToolbar().findByType('tbsearch');
			// if(searchBars.length == 1) {
			// 	searchBars[0].store = store;
			// }

			// add filter button
			this.getTopToolbar().insert(1, {
				text:t('Employees only'),
				iconCls: 'ic-account-box',
				enableToggle:true,
				toggleHandler: function(btn, state) {
					this.store.setFilter('isEmployee', state ? {isEmployee: true} : null);
					this.store.load();
				},
				scope:this
			});
		})
	})
});