go.modules.business.catalog.ArticleGrid = Ext.extend(go.grid.GridPanel, {
	initComponent: function () {
		this.frontendConfig = go.modules.business.catalog.ModuleConfig.frontendOptions;

		this.store = new go.data.Store({
			fields: [
				'id',
				'number',
				'name',
				'description',
				'unit',
				{name: 'cost', type: 'float'},
				{name: 'price', type: 'float'},
				'vatRateId',
				{name: 'supplier', type: "relation"},
				'supplierNumber',
				{name: 'createdAt', type: 'date'},
				{name: 'modifiedAt', type: 'date'},
				{name: 'creator', type: "relation"},
				{name: 'modifier', type: "relation"},
				'permissionLevel',
				'categoryId'
			],
			entityStore: "Article"
		});

		Ext.apply(this, {
			columns: [{
				id: 'id',
				header: "ID",
				width: dp(80),
				sortable: true,
				hidden: true,
				dataIndex: 'id'
			},{
				id: 'number',
				header: t('Number'),
				width: dp(80),
				sortable: true,
				dataIndex: 'number'
			},{
				id: 'name',
				header: t('Name'),
				width: dp(160),
				sortable: true,
				dataIndex: 'name'
			},{
				id: 'cost',
				header: t('Cost'),
				width: dp(160),
				sortable: true,
				dataIndex: 'cost',
				xtype: "valutacolumn"

			},{
				id: 'price',
				header: t('Price'),
				width: dp(160),
				sortable: true,
				dataIndex: 'price',
				xtype: "valutacolumn"
			},{
				id: 'supplier',
				header: t('Supplier'),
				width: dp(160),
				sortable: true,
				dataIndex: 'supplier',
				renderer: function(v) {
					return v ? v.name : "";
				}
			},{
				id: 'supplierNumber',
				header: t('Supplier number'),
				width: dp(160),
				sortable: true,
				dataIndex: 'supplierNumber'
			},{
				hidden: !this.frontendConfig.showCreator,
				id: 'showCreator',
				header: t('Created by'),
				width: dp(160),
				sortable: true,
				dataIndex: 'creator',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				id: 'showCreationDate',
				header: t('Created at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'createdAt',
				hidden: !this.frontendConfig.showCreationDate
			},{
				hidden: !this.frontendConfig.showModifier,
				header: t('Modified by'),
				width: dp(160),
				sortable: true,
				id: 'showModifier',
				dataIndex: 'modifier',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				hidden: !this.frontendConfig.showModificationDate,
				id: 'showModificationDate',
				header: t('Modified at'),
				width: dp(160),
				sortable: false,
				dataIndex: 'modifiedAt'
			}],
			viewConfig: {
				totalDisplay: this.frontendConfig.showTotals,
				emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
			},
			stateful: true,
			stateId: 'Article-grid'
		});

		go.modules.business.catalog.ArticleGrid.superclass.initComponent.call(this);
	},


	//when filtering on a group then offer to delete contacts from a group when delting.
	deleteSelected: function () {

		var filter = this.store.getFilter('categories');
		if (!filter || go.util.empty(filter.categories)) {
			return go.grid.GridTrait.deleteSelected.call(this);
		}


		var selectedRecords = this.getSelectionModel().getSelections(), ids = selectedRecords.column('id'), strConfirm;

		switch (ids.length) {
			case 0:
				return;
			case 1:
				strConfirm = t("Are you sure you want to delete the selected item?");
				break;

			default:
				strConfirm = t("Are you sure you want to delete the {count} items?").replace('{count}', ids.length);
				break;
		}

		Ext.Msg.show({
			title: t("Confirm delete"),
			msg: t(strConfirm),
			buttons: {ok: t("Remove from category"), yes: t("Delete"), "cancel": t("Cancel")},
			fn: function (btn) {

				if (btn === "yes") {
					this.getStore().entityStore.set({
						destroy: ids
					});
				}

				if (btn === "ok") {
					const updates = {}, me = this;

					go.Db.store("Article").get(ids).then(function (result) {
						result.entities.forEach(function (article) {

							updates[article.id] = {
								categories: go.util.clone(article.categories)
							};

							filter.categories.forEach(categoryId => {
								const i = article.categories.indexOf(categoryId);
								if(i > -1) {
									updates[article.id].categories.splice(i, 1);
								}
							})
						});

						me.getStore().remove(selectedRecords);

						me.getStore().entityStore.set({
							update: updates
						});
					});

				}
			},
			scope: this,
			icon: Ext.MessageBox.QUESTION
		});
	}
});

