create table business_contracts_book
(
    id             int unsigned auto_increment
        primary key,
    businessId     int unsigned                      not null,
    targetBookId   int unsigned                      not null,
    aclId          int                               null,
    numberFormat   varchar(50)  default '%T%Y-00000' null,
    currency       varchar(20)  default '€'          null,
    nextNumber     int unsigned default 1            null,
    emailAccountId int                               null,
    name           varchar(100)                      null,
    constraint business_contracts_book_business_business_null_fk
        foreign key (businessId) references business_business (id),
    constraint business_contracts_book_business_finance_book_null_fk
        foreign key (targetBookId) references business_finance_book (id),
    constraint business_contracts_book_core_acl_null_fk
        foreign key (aclId) references core_acl (id)
);

create table business_contracts_contract
(
    modifiedBy     int                     not null,
    customerId int                     not null,
    businessModel enum ('b2b', 'b2c') default 'b2b' not null,
    customer   varchar(190)            not null,
    contactId int null,
    startsAt       date                    not null,
    endsAt         date                    null,
    intervalMonths tinyint      default 1  not null,
    nextAt         date                    null,
    billInArrears boolean default false not null,
    description    varchar(190)            not null,
    number         varchar(50)             null,
    modifiedAt     datetime                null,
    createdAt      datetime                not null,
    id             int auto_increment
        primary key,
    filesFolderId  int                     null,
    createdBy      int                     not null,
    autoSend       tinyint(1)   default 0  null,
    reference      varchar(190) default '' not null,
    bookId         int unsigned            null,
    constraint business_contracts_contract_business_contracts_book_null_fk
        foreign key (bookId) references business_contracts_book (id)
            on delete cascade,
    constraint business_contracts_contract_ibfk_2
        foreign key (customerId) references addressbook_contact (id)
);

alter table business_contracts_contract
    add constraint business_contracts_contract_addressbook_contact_id_fk
        foreign key (contactId) references addressbook_contact (id)
            on delete set null;

create index customerId
    on business_contracts_contract (customerId);

create table business_contracts_contract_custom_fields
(
    id           int auto_increment
        primary key,
    hostname     varchar(190) default '' not null,
    expiresAt    date                    null,
    oldLicenseId varchar(190) default '' not null,
    constraint business_contracts_contract_custom_fields_ibfk_1
        foreign key (id) references business_contracts_contract (id)
            on delete cascade
);

create table business_contracts_contract_item
(
    id          int auto_increment
        primary key,
    contractId  int                           not null,
    quantity    decimal(19, 4) default 1.0000 not null,
    description text                          not null,
    unit varchar(100) null,
    unitPrice   decimal(19, 4) default 0.0000 not null,
    unitCost decimal(19, 4) default 0.0000 not null,
    vatRateId   int unsigned                  not null,
    `order`     int unsigned                  not null,
    articleId   int                           null,
    categoryId int unsigned null,
    constraint business_contracts_contract_item_ibfk_1
        foreign key (contractId) references business_contracts_contract (id)
            on delete cascade
);

create index contractId
    on business_contracts_contract_item (contractId);


alter table business_contracts_contract_item
    add constraint business_contracts_contract_item_business_category_id_fk
        foreign key (categoryId) references business_business_category (id);

alter table business_contracts_contract_item
    add constraint business_contracts_contract_item_business_catalog_article_id_fk
        foreign key (articleId) references business_catalog_article (id);
