drop table if exists business_finance_business;

drop table if exists business_finance_business_debtor_profile;

drop table if exists business_finance_business_debtor_profile_action;

drop table if exists business_finance_contact_business;

drop table if exists business_finance_document_custom_fields;

drop table if exists business_finance_document_item;

drop table if exists business_finance_document_item_group;

drop table if exists business_finance_payment;

drop table if exists business_finance_document;

drop table if exists business_finance_book;

drop table if exists business_finance_status;

create table business_finance_book
(
    id             int unsigned auto_increment
        primary key,
    businessId     int unsigned                                                                                          not null,
    aclId          int                                                                                                   null,
    type           enum ('quote', 'salesorder', 'salesinvoice', 'purchaseorder', 'purchaseinvoice') default 'quote'      null,
    numberFormat   varchar(50)                                                                      default '%T%Y-00000' null,
    currency       varchar(20)                                                                      default '€'          null,
    nextNumber     int unsigned                                                                     default 1            null,
    emailAccountId int                                                                                                   null,
    name           varchar(100)                                                                                          null,
    businessModel enum ('b2b', 'b2c', 'both') default 'b2b' not null,
    defaultGreeting text null,
    defaultClosing text null,
    enableZUGFeRD bool default false not null,
    enableUbl boolean default false not null,
    constraint business_finance_book_business_business_null_fk
        foreign key (businessId) references business_business (id),
    constraint business_finance_book_core_acl_null_fk
        foreign key (aclId) references core_acl (id)
);

create table business_finance_business
(
    businessId                 int unsigned                      not null,
    salesInvoiceEmailAccountId int                               null,
    primary key (businessId),
    constraint business_finance_business_ibfk_1
        foreign key (businessId) references business_business (id)
            on delete cascade
);

create table business_finance_business_debtor_profile
(
    id         int unsigned auto_increment
        primary key,
    businessId int unsigned       not null,
    name       varchar(100)       not null,
    expireDays smallint default 14 not null,
    graceDays  smallint     default 7  not null,
    taskListId int unsigned null
);

    alter table business_finance_business_debtor_profile
    add constraint business_finance_business_debtor_profile_tasks_task_id_fk
        foreign key (taskListId) references tasks_task (id)
            on delete set null;

create table business_finance_business_debtor_profile_action
(
    id              int unsigned auto_increment
        primary key,
    profileId       int unsigned                           not null,
    triggerInDays   smallint                                not null,
    type            enum ('email', 'task') default 'email' not null,
    name            varchar(100)                           not null,
    emailTemplateId int                                    null,
    pdfTemplateId   int                                    null
);

create table business_finance_contact_business
(
    businessId   int unsigned not null,
    contactId    int          not null,
    profileId    int unsigned null,
    lastActionAt datetime     null,
    graceUntil date default (current_date) not null,
    primary key (businessId, contactId),
    constraint business_finance_contact_business_ibfk_1
        foreign key (businessId) references business_business (id)
            on delete cascade,
    constraint business_finance_contact_business_ibfk_2
        foreign key (contactId) references addressbook_contact (id)
            on delete cascade
);


create index business_finance_contact_business_graceUntil_index
    on business_finance_contact_business (graceUntil);

create index contactId
    on business_finance_contact_business (contactId);

create table business_finance_document
(
    id                      bigint unsigned auto_increment
        primary key,
    bookId                  int unsigned              null,
    statusId int unsigned null,
    number                  varchar(190)              null,
    createdBy               int                       not null,
    createdAt               datetime                  not null,
    modifiedBy              int                       not null,
    modifiedAt              datetime                  null,
    customerId          int                       not null,
    businessModel enum ('b2b', 'b2c') default 'b2b' not null,
    contactId               int                       null,
    customerTo          text                      null,
    customerStreet      text                      null,
    customerZipCode     varchar(50)               null,
    customerCity        varchar(100)              null,
    customerState       varchar(100)              null,
    customerCountryCode char(2) collate ascii_bin null,
    date                    date                      null,
    sentAt                  datetime                  null,
    expiresAt               date                      null,
    acceptedAt datetime null,
    deliveredAt datetime null,
    completedAt             date                      null,
    vatReverseCharge        tinyint(1)   default 0    not null,
    greeting text null,
    closing text null,
    filesFolderId           int                       null,
    showTotals              tinyint(1)   default 1    not null,
    customer            varchar(190)              null,
    contact                 varchar(190)              null,
    token                   binary(40)                null,
    reference               varchar(190) default ''   not null,
    paymentStatus varchar(190) null comment 'Field that can be used by payment providers to store status',
    paymentId varchar(100) null,
    recurringPayment bool default false not null,
    cancelled bool default false not null,
    showPricePerLine bool default true not null,
     constraint business_finance_document_addressbook_contact_id_fk
        foreign key (customerId) references addressbook_contact (id),
    constraint business_finance_document_business_finance_book_null_fk
        foreign key (bookId) references business_finance_book (id)
            on delete cascade
);

alter table business_finance_document
    add constraint business_finance_document_business_finance_status_id_fk
        foreign key (statusId) references business_finance_status (id)
            on delete set null;






create index business_finance_document_completedAt_index
    on business_finance_document (completedAt);

create index business_finance_document_deliveredAt_index
    on business_finance_document (deliveredAt);

create index business_finance_document_expiresAt_index
    on business_finance_document (expiresAt);
create index business_finance_document_cancelled_index
    on business_finance_document (cancelled);

create index number
    on business_finance_document (number, bookId);

create table business_finance_document_custom_fields
(
    id bigint unsigned auto_increment
        primary key,
    constraint business_finance_document_custom_fields_ibfk_1
        foreign key (id) references business_finance_document (id)
            on delete cascade
);

create table business_finance_document_item_group
(
    id         bigint unsigned auto_increment
        primary key,
    documentId bigint unsigned        not null,
    title      varchar(100)           null,
    showAs enum ('group', 'groupwithtotal', 'single', 'hidden') default 'group' not null,
    `order`    int unsigned default 0 not null,
    constraint business_finance_document_item_group_ibfk_1
        foreign key (documentId) references business_finance_document (id)
            on delete cascade
);

create table business_finance_document_item
(
    id          bigint unsigned auto_increment
        primary key,
    groupId     bigint unsigned               not null,
    quantity    decimal(19, 4) default 1.0000 not null,
    description text                          not null,
    unit varchar(100) null,
    unitPrice   decimal(19, 6) default 0.0000 not null,
    unitCost    decimal(19, 4) default 0.0000 not null,
    vatRateId   int unsigned                  null,
    vatRate     decimal(19, 4)                not null,
    `order`     int unsigned                  null,
    articleId   int unsigned                  null,
    categoryId int unsigned null,
    constraint business_finance_document_item_ibfk_1
        foreign key (groupId) references business_finance_document_item_group (id)
            on delete cascade,
    constraint business_finance_document_item_ibfk_2
        foreign key (vatRateId) references business_business_vat_rate (id)
            on delete set null
);


alter table business_finance_document_item
    add constraint business_finance_document_item_business_business_category_id_fk
        foreign key (categoryId) references business_business_category (id);

create index documentId
    on business_finance_document_item (groupId);

create index vatRateId
    on business_finance_document_item (vatRateId);

create index documentId
    on business_finance_document_item_group (documentId);

create table business_finance_payment
(
    id                  int unsigned auto_increment
        primary key,
    customerId      int                     null,
    documentId          bigint unsigned         null,
    amount              decimal(19, 4)          not null,
    date                date      default (current_date)               not null,
    description         varchar(190)            null,
    reference           varchar(190)            null comment 'Unique payment reference to make sure a payment is only processed once',
    businessId          int unsigned            not null,
    checked             tinyint(1)   default 1  null,
    contraAccountName   varchar(190) default '' null,
    contraAccountNumber varchar(190) default '' null,
    createdAt           datetime                null,
    modifiedAt          datetime                null,
    constraint reference
        unique (reference),
    constraint business_finance_payment_business_business_id_fk
        foreign key (businessId) references business_business (id)
            on update cascade,
    constraint business_finance_payment_ibfk_1
        foreign key (documentId) references business_finance_document (id)
            on delete cascade
);

create index documentId
    on business_finance_payment (documentId);


create table business_finance_status
(
    id      int unsigned auto_increment
        primary key,
    bookId  int unsigned null,
    name    varchar(190) null,
    color   char(6)      null,
    `order` int          null,
    constraint business_finance_status_business_finance_book_id_fk
        foreign key (bookId) references business_finance_book (id)
            on delete cascade
);

create index business_finance_status_order_index
    on business_finance_status (`order`);

create index business_finance_payment_date_index
    on business_finance_payment (date);

create index business_finance_payment_customerId_date_index
    on business_finance_payment (customerId, date);

create index business_finance_book_id_businessId_type_index
    on business_finance_book (id, businessId, type);