Ext.onReady(function() {
	Ext.override(go.modules.business.business.BusinessDialog, {
		closeOnSave: false,
		width: dp(1000),
		initComponent: go.modules.business.business.BusinessDialog.prototype.initComponent.createSequence(function() {

			if(go.Modules.isInstalled("legacy", "email")) {
				this.emailAccount = new GO.email.SelectAccount({
					hiddenName: 'finance.salesInvoiceEmailAccountId',
					hint: t("Used for finance. Sending invoices, statements etc.", "finance", "business"),
					anchor: "100%"
				})
				//Only writable accounts can be used for sync
				this.emailAccount.store.baseParams.permissionLevel = go.permissionLevels.write;


				this.mainPanel.items.itemAt(0).insert(3, this.emailAccount);
			}
		}),
		initFormItems: go.modules.business.business.BusinessDialog.prototype.initFormItems.createSequence(function() {



			this.addPanel({

				title: t("Debtor management", "finance", "business"),
				items:[{
					xtype: "fieldset",
					title: t("Statement PDF Templates", "finance", "business"),
					items: [
						this.statementTemplatesGrid = new go.pdftemplate.GridPanel({
							border: 1,
							disabled: true,
							module: {
								name: "finance",
								package: "business"
							},
							hideLabel: true
						})
					]
				}, {
					xtype: "fieldset",
					title: t("Profiles", "finance", "business"),
					items: [
						this.debtorProfileGrid = new go.modules.business.finance.DebtorProfileGrid({
							border: 1,
							disabled: true
						})
					]
				}]
			});
		}),

		setKey : function() {


			this.statementTemplatesGrid.setDisabled(false);
			this.statementTemplatesGrid.setKey( "statement-" + this.currentId);
			this.statementTemplatesGrid.store.load();

			this.debtorProfileGrid.setDisabled(false);
			this.debtorProfileGrid.store.setFilter('businessId', {businessId: this.currentId});
			this.debtorProfileGrid.store.load();
		},

		onLoad: go.modules.business.business.BusinessDialog.prototype.onLoad.createSequence(function() {
			this.setKey();
			this.closeOnSave = true;
		}),

		onSubmit: go.modules.business.business.BusinessDialog.prototype.onSubmit.createSequence(function() {
			this.setKey();
		})

	});
});