go.modules.business.finance.FinanceDocumentGrid = Ext.extend(go.grid.GridPanel, {
    enableDragDrop: true,
    ddGroup: "finance",

    summary: true,

    initComponent: function () {
        this.frontendConfig = go.modules.business.finance.ModuleConfig.frontendOptions;

        const me = this;

        if(this.summary) {
            const sum = new Ext.grid.GridSummary();
            this.plugins = [sum];
        }

        this.store = new go.data.Store({
            fields: [
                'id',
                'number',
              'type',
                {name: 'createdAt', type: 'date'},
                {name: 'date', type: 'date'},
                {name: 'modifiedAt', type: 'date'},
                {name: 'completedAt', type: 'date'},
                {name: 'acceptedAt', type: 'date'},
                {name: 'sentAt', type: 'date'},
                {name: 'expiresAt', type: 'date'},
                {name: 'deliveredAt', type: 'date'},
                {name: 'creator', type: "relation"},
                {name: 'modifier', type: "relation"},
                {name: 'cancelled', type: "bool"},
                {name: 'status'},
	            'reference',
              'customer',
              'contact',
                {name: 'book', type: "relation"},
                // {name: 'customer', type: "relation", mapping: "customer.name"},
                // {name: 'contact', type: "relation", mapping: "contact.name"},
                'permissionLevel',
                {name: 'subtotalPrice', type: "float"},
                {name: 'totalPrice', type: "float"},
                {name: 'totalCost', type: "float"},
                {name: 'profit', type: "float"},
                //{name: 'status', type: "relation"},
            ],
            entityStore: "FinanceDocument",
            sortInfo: {
                field: "number",
                direction: "DESC"
            }
        });

        function valutaRenderer(v, meta, record) {
            if(record.data.book) {
                 //store for summaryRenderer
                me.currency = record.data.book.currency;
            }
            return me.currency + " " + go.util.Format.number(v, 2);
        };

        Ext.apply(this, {
            columns: [{
                id: 'showID',
                hidden: !this.frontendConfig.showID,
                header: 'ID',
                width: dp(60),
                sortable: true,
                dataIndex: 'id'
            },{
                id: 'number',
                hidden: false,
                header: t("Number"),
                dataIndex: 'number',
                sortable: true,
                width: dp(160),
                renderer : function(v) {
                    return v || "-";
                }
            },{
	            id: 'reference',
	            hidden: false,
	            header: t("Reference"),
	            dataIndex: 'reference',
	            sortable: true,
	            width: dp(160)
            },{
                xtype:"datecolumn",
                dateOnly: true,
                id: 'date',
                header: t('Date'),
                sortable: true,
                dataIndex: 'date'
            },{
	            xtype:"datecolumn",
	            dateOnly: true,
	            id: 'deliveredAt',
	            header: t('Delivery date'),
	            sortable: true,
	            dataIndex: 'deliveredAt',
	            hidden: true
            },{
                id: "status",
                dataIndex: "id",
                header: t("Status"),
                width: dp(160),
                renderer: function(v, meta, record) {
                    return go.modules.business.finance.util.getStatusBadge(record.data, "", record.data.book);
                }
            },{
                id: "contact",
                hidden: true,
                dataIndex: "contact",
                header: t("Contact","addressbook", "community"),
                width: dp(200),
	              sortable: true
            },{
                id: "customer",
                dataIndex: "customer",
                header: t("Customer", "addressbook", "community"),
                width: dp(200),
	              sortable: true
            },{
                align: "right",
                renderer: valutaRenderer,
                summaryRenderer: valutaRenderer,
                summaryType: 'SUM',
                dataIndex: "profit",
                hidden: true,
                header: t("Profit")
            },{
                align: "right",
                renderer: valutaRenderer,
                summaryRenderer: valutaRenderer,
                summaryType: 'SUM',
                dataIndex: "totalCost",
                hidden: true,
                header: t("Costs")
            },{
                align: "right",
                renderer: valutaRenderer,
                dataIndex: "subtotalPrice",
                summaryRenderer: valutaRenderer,
                summaryType: 'SUM',
                hidden: false,
                header: t("Subtotal")
            },{
                align: "right",
                renderer: valutaRenderer,
                summaryRenderer: valutaRenderer,
                summaryType: 'SUM',
                dataIndex: "totalPrice",
                hidden: true,
                header: t("Total")
            },{
                hidden: true,
                id: 'showCreator',
                header: t('Created by'),
                width: dp(160),
                sortable: true,
                dataIndex: 'creator',
                renderer: function(v) {
                    return v ? v.displayName : "-";
                }
            },{
                xtype:"datecolumn",
                id: 'showCreationDate',
                header: t('Created at'),
                width: dp(160),
                sortable: true,
                dataIndex: 'createdAt',
                hidden: true
            },{
                hidden: !this.frontendConfig.showModifier,
                header: t('Modified by'),
                width: dp(160),
                sortable: true,
                id: 'showModifier',
                dataIndex: 'modifier',
                renderer: function(v) {
                    return v ? v.displayName : "-";
                }
            },{
                xtype:"datecolumn",
                hidden: true,
                id: 'showModificationDate',
                header: t('Modified at'),
                width: dp(160),
                sortable: false,
                dataIndex: 'modifiedAt'
            }],
            viewConfig: {
                totalDisplay: true,
                emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
            },
            stateful: true,
            stateId: 'FinanceDocument-grid'
        });

        go.modules.business.finance.FinanceDocumentGrid.superclass.initComponent.call(this);
    }
});


Ext.reg("financedocumentgrid", go.modules.business.finance.FinanceDocumentGrid);
