go.modules.business.finance.MigrateWindow = Ext.extend(go.Window, {

	title: t("Migrate"),
	width: dp(500),
	autoHeight: true,
	initComponent: function () {
		this.supr().initComponent.call(this);

		this.formPanel = new Ext.form.FormPanel({
			items: [{
				xtype: "fieldset",
				items: [
					{
						xtype: "xcheckbox",
						boxLabel: t("Migrate all books automatically"),
						name: "auto",
						checked: true,
						listeners: {
							check: (cb, checked) => {
								this.perBookOptions.setVisible(!checked);
								this.selectOldBook.allowBlank = checked;
								this.selectNewBook.allowBlank = checked;
							}
						}
					},
					{
						fieldLabel: t("Contract book"),
						anchor: "100%",
						xtype: "contractbookcombo",
						allowBlank: false,
						hiddenName: 'contractBookId',
					},
					this.perBookOptions = new Ext.Container({
						xtype: "container",
						hidden: true,
						layout: "form",
						items: [
							{
								xtype: "xcheckbox",
								boxLabel: t("Migrate catalog"),
								name: "migrateCatalog",
								checked: true
							},
							this.selectOldBook = new GO.billing.SelectBook({
								anchor: "100%",
								hiddenName: "sourceBookId",
								fieldLabel: t("Source book"),
								allowBlank: true
							}),
							this.selectNewBook = new go.modules.business.finance.FinanceBookCombo({
								anchor: "100%",
								xtype: "financebookcombo",
								hiddenName: 'financeBookId',
								allowBlank: true,
								fieldLabel: t("Target book"),
							})
							]
					})
				]
			}

			],
			buttons: [{
				text: t("GO!"),
				cls: "primary",
				scope: this,
				handler: function() {
					if(!this.formPanel.form.isValid()) {
						GO.errorDialog.show(t("The form is invalid"));
						return;
					}

					this.getEl().mask(t("Loading..."));
					go.Jmap.request({
						method: "FinanceDocument/migrateBilling",
						params: this.formPanel.form.getValues()
					})
						.then(() => {
							Ext.MessageBox.alert(t("Success"), t("The process has started in the background. You will receive a notification when it's done."));
							this.close();
						})
						.finally(() => {
						this.getEl().unmask();
					})
				}
			}]
		});


		this.add(this.formPanel);

	}
});