go.modules.business.finance.MonthlyReportPanel = Ext.extend(Ext.Panel, {

	// title: t("Monthly report"),

	// width: dp(1200),
	// height: dp(960),
	//
	// autoScroll: true,
	// maximizable: true,
	initComponent: function () {

		this.tbar = [
			this.previousYearBtn = new Ext.Button({
				iconCls: 'ic-chevron-left',
				text: t("Years"),
				handler: function () {
					this.ownerCt.getLayout().setActiveItem(0);
				},
				scope: this
			}),
			"->",
			this.previousYearBtn = new Ext.Button({
			iconCls: 'ic-chevron-left', handler: function () {
				this.yearField.setValue(parseInt(this.yearField.getValue()) - 1);
			}, scope: this
		}), this.yearField = new Ext.form.TextField({
			readonly: true, width: dp(80), style: "text-align: center", listeners: {
				setvalue: this.onChange, scope: this
			}
		}), this.nextYearBtn = new Ext.Button({
			iconCls: 'ic-chevron-right', handler: function () {
				this.yearField.setValue(parseInt(this.yearField.getValue()) + 1);
			}, scope: this
		})

		];


		this.bbar = [this.totalField = new Ext.form.Label()]

		this.items = [{

			xtype: "container",
			height: dp(400), // layout: "fit",
			style: "padding: 20px",
			items: [
				this.montlySalesChart = new go.chart.BarChart({
					height: "100%",
					width: "100%",

					chartConfig: {
						plugins:[{
							afterDraw: chart => {


								let ctx = chart.ctx;
								ctx.save();

								let y = chart.scales.x.bottom + 14, x = chart.scales.x.left;

								let width = chart.scales.x.width / 4;


								x += width / 2; // move to center

								// ctx.textAlign = 'center';
								// ctx.font = '12px Arial';
								ctx.fillStyle = "#666";
								ctx.strokeStyle  = 'lightgray';

								const borderY = chart.scales.x.bottom + 2, cellHeight = 22;

								ctx.beginPath();
								ctx.moveTo(chart.scales.x.left, borderY);
								ctx.lineTo(chart.scales.x.left + chart.scales.x.width, borderY);
								ctx.stroke();


								let month = 0;
								for(let i = 1;i <= 4; i++) {

									let total = 0;
									for(let n = 0; n < 3; n ++) {
										total += chart.data.datasets[1].data[month];
										month++;
									}

									ctx.fillText(`Q${i}: ${this.book.currency} ${go.util.Format.number(total, 0)}`, x, y, width);

									ctx.beginPath();
									ctx.moveTo(x - (width / 2), borderY - 22);
									ctx.lineTo(x - (width / 2), borderY + cellHeight);
									ctx.stroke();

									ctx.beginPath();
									ctx.moveTo(x + (width / 2), borderY - 22);
									ctx.lineTo(x + (width / 2), borderY + cellHeight);
									ctx.stroke();

									x += width;
								}

								ctx.beginPath();
								ctx.moveTo(chart.scales.x.left, borderY + cellHeight);
								ctx.lineTo(chart.scales.x.left + chart.scales.x.width, borderY + cellHeight);
								ctx.stroke();

								ctx.restore();
							}
						}]
					},
					options: {
						maintainAspectRatio: false, // for height to work
						scales: {
							y: {
								beginAtZero: true
							}
						},
						plugins: {
							title: {
								display: true, text: t("Total per month compared to last year"),
							},

							legend: {
								position: 'bottom',
								labels: {
									padding: 40,
									align: 'end',
									usePointStyle: true
								}
							},
						},


				}
			})]
		}, {

			xtype: "container", cls: 'go-hbox', style: "justify-content: center; column-gap: 20%;", height: dp(400), items: [{
				width: "30%",
				height: "100%",
				xtype: "container",
				style: "padding: 20px",
				items: [this.categoryPieChart = new go.chart.PieChart({
					height: "100%", width: "100%", responsive: true, options: {
						plugins: {
							title: {
								display: true, text: t("Totals per category")
							}
						}
					}
				})]
			}, {
				width: "30%",
				height: "100%",
				xtype: "container",
				style: "padding: 20px",
				items: [this.statusPieChart = new go.chart.PieChart({
					height: "100%", width: "100%", responsive: true, options: {
						plugins: {
							title: {
								display: true, text: t("Totals per status")
							}
						}
					}
				})]
			}]
		}];


		go.modules.business.finance.MonthlyReportPanel.superclass.initComponent.call(this);
	},

	load: async function (bookId, year) {
		this.bookId = bookId;
		this.book = await go.Db.store("FinanceBook").single(bookId);
		this.yearField.setValue(year);
		this.setTitle(t("Monthly report") + " - " + this.book.name);
	},

	onChange: function (field, year) {
		Promise.all([
			go.Jmap.request({
			method: "FinanceDocument/monthlyTotals", params: {
				bookId: this.bookId, year: year - 1
			}
		}),
			go.Jmap.request({
			method: "FinanceDocument/monthlyTotals", params: {
				bookId: this.bookId, year: year
			}
		})]).then((totals) => {

			const series = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], lastYearSeries = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
				m = Object.values(t('short_months')),
				labels = [m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]];

			let total = 0, count = 0;

			totals[0].forEach((rec) => {
				lastYearSeries[rec.month - 1] = rec.subtotal;
			});

			totals[1].forEach((rec) => {
				series[rec.month - 1] = rec.subtotal;

				total += rec.subtotal;

				count += rec.count;

				// labels[rec.month - 1] += " - " + this.book.currency + " " + go.util.Format.number(rec.subtotal, 0);
			});

			this.montlySalesChart.update([
				{
					barPercentage: .5,
					label: year - 1,
					data: lastYearSeries,
					backgroundColor: [
						'rgba(255, 205, 86, 0.2)'
					],
					borderColor: [
						'rgb(255, 205, 86)'
					],
					borderWidth: 1
				},
				{
					label: year,
					data: series,
					backgroundColor: [
						'rgba(54, 162, 235, 0.2)'
					],
					borderColor: [
						'rgb(54, 162, 235)'
					],
					borderWidth: 1
				}
				], labels);

			this.totalField.setText(t("Total") + ": " + go.util.Format.valuta(total) + ", " + t("Invoice count") + ": " + count, false);

		});


		go.Jmap.request({
			method: "FinanceDocument/totalsPerCategory", params: {
				bookId: this.bookId, year: year
			}
		}).then(totals => {
			if (!go.util.empty(totals)) {
				// const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
				// 	return currentValue.subtotal + accumulator;
				// }, 0);

				const data = {
					series: [], labels: []
				};

				const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
					return currentValue.subtotal + accumulator;
				}, 0);

				for (const category of totals) {
					const perc = parseInt((category.subtotal / sum) * 100);

					if (perc > 0) {
						data.labels.push((category.name ?? t("Uncategorized")) + " " + perc + "%");
						data.series.push({
							value: category.subtotal
						});
					}
				}

				this.categoryPieChart.update([{data: data.series}], data.labels);
			} else {
				this.categoryPieChart.update([], []);
			}
		});


		go.Jmap.request({
			method: "FinanceDocument/totalsPerStatus", params: {
				bookId: this.bookId, year: year
			}
		}).then((totals) => {

			const labels = [], data = [];

			const sum = Object.values(totals).reduce(function (accumulator, currentValue) {
				return currentValue.subtotal + accumulator;
			}, 0);

			if (!go.util.empty(totals)) {

				for (const status in totals) {

					const perc = parseInt((totals[status].subtotal / sum) * 100);

					if (perc > 0) {
						labels.push(go.modules.business.finance.util.humanStatus(status, this.book) + " " + perc + "%");
						data.push({
							value: totals[status].subtotal
						});
					}
				}

				this.statusPieChart.update([{data: data}], labels);
			} else {
				this.statusPieChart.update([], []);
			}

		});


	}
});
